{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":91},{"name":"new","containerName":"main::","children":[{"line":106,"localvar":"my","containerName":"new","kind":13,"name":"$class","definition":"my"},{"line":106,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","line":108,"localvar":"my","kind":13,"containerName":"new","name":"$self"},{"line":108,"containerName":"new","kind":13,"name":"$class"},{"name":"@args","containerName":"new","kind":13,"line":108},{"line":109,"kind":13,"containerName":"new","name":"$self"},{"name":"$self","containerName":"new","kind":13,"line":110},{"line":111,"kind":13,"localvar":"my","containerName":"new","name":"$symbols","definition":"my"},{"containerName":"new","kind":13,"name":"$subalphas","line":111},{"name":"$self","containerName":"new","kind":13,"line":111},{"line":111,"kind":12,"containerName":"new","name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":112},{"name":"$symbols","kind":13,"containerName":"new","line":114},{"name":"$symbols","kind":13,"containerName":"new","line":114},{"kind":13,"containerName":"new","name":"$self","line":114},{"line":114,"name":"symbols","kind":12,"containerName":"new"},{"line":114,"containerName":"new","kind":13,"name":"$symbols"},{"name":"$subalphas","kind":13,"containerName":"new","line":115},{"line":115,"name":"$subalphas","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":115},{"line":115,"containerName":"new","kind":12,"name":"alphabets"},{"containerName":"new","kind":13,"name":"$subalphas","line":115},{"name":"$self","containerName":"new","kind":13,"line":116}],"detail":"($class,@args)","definition":"sub","range":{"start":{"line":105,"character":0},"end":{"character":9999,"line":117}},"kind":12,"line":105,"signature":{"documentation":"1;\n# $Id: Alphabet.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Alphabet\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Alphabet - BSANE/BioCORBA compliant symbol list alphabet\n\n=head1 SYNOPSIS\n\n  {\n      my $alphabet = Bio::Symbols::Alphabet->new(-symbols => [ @s ],\n  \t\t\t\t\t\t-subalphabets => [ @alphas ] );\n\n      my @symbols = $alphabet->symbols;\n      my @subalphas = $alphabet->alphabets;\n      if( $alphabet->contains($symbol) ) {\n  \t  # do something\n      }\n  }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to\nform symbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Alphabet;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Symbol::AlphabetI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Alphabet->new();\n Function: Builds a new Bio::Symbol::Alphabet object \n Returns : Bio::Symbol::Alphabet\n Args    : -symbols  => Array ref of Bio::Symbol::SymbolI objects\n           -subalphas=> Array ref of Bio::Symbol::AlphabetI objects \n                        representing sub alphabets","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"kind":12,"containerName":"new","name":"SUPER","line":108},{"signature":{"label":"symbols($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Alphabet.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Alphabet\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Alphabet - BSANE/BioCORBA compliant symbol list alphabet\n\n=head1 SYNOPSIS\n\n  {\n      my $alphabet = Bio::Symbols::Alphabet->new(-symbols => [ @s ],\n  \t\t\t\t\t\t-subalphabets => [ @alphas ] );\n\n      my @symbols = $alphabet->symbols;\n      my @subalphas = $alphabet->alphabets;\n      if( $alphabet->contains($symbol) ) {\n  \t  # do something\n      }\n  }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to\nform symbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Alphabet;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Symbol::AlphabetI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Alphabet->new();\n Function: Builds a new Bio::Symbol::Alphabet object \n Returns : Bio::Symbol::Alphabet\n Args    : -symbols  => Array ref of Bio::Symbol::SymbolI objects\n           -subalphas=> Array ref of Bio::Symbol::AlphabetI objects \n                        representing sub alphabets\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->{'_symbols'} = [];\n    $self->{'_alphabets'} = [];\n    my ($symbols, $subalphas) = $self->_rearrange([qw(SYMBOLS SUBALPHAS)],\n\t\t\t\t\t\t  @args);\n\n    defined $symbols && ref($symbols) =~ /array/i && $self->symbols(@$symbols);\n    defined $subalphas && ref($subalphas) =~ /array/i && $self->alphabets(@$subalphas);\n    return $self;\n}\n\n=head2 AlphabetI Interface methods\n\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $alphabet->symbols();\n Function: Get/Set Symbol list for an alphabet\n           List of symbols, which make up this alphabet.\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optionalalphabets) Array of Bio::Symbol::SymbolI objects"},"line":134,"range":{"end":{"line":146,"character":9999},"start":{"line":134,"character":0}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"symbols","line":135},{"line":135,"containerName":"symbols","kind":13,"name":"@args"},{"kind":13,"containerName":"symbols","name":"@args","line":136},{"line":137,"kind":13,"containerName":"symbols","name":"$self"},{"definition":"my","name":"$symbol","kind":13,"localvar":"my","containerName":"symbols","line":138},{"line":138,"name":"@args","kind":13,"containerName":"symbols"},{"line":139,"containerName":"symbols","kind":13,"name":"$symbol"},{"name":"$symbol","containerName":"symbols","kind":13,"line":139},{"line":140,"name":"$symbol","kind":13,"containerName":"symbols"},{"name":"isa","containerName":"symbols","kind":12,"line":140},{"line":141,"kind":13,"containerName":"symbols","name":"$self"},{"name":"warn","containerName":"symbols","kind":12,"line":141},{"containerName":"symbols","kind":13,"name":"$self","line":143},{"containerName":"symbols","kind":13,"name":"$symbol","line":143}],"name":"symbols","containerName":"main::"},{"line":147,"containerName":null,"kind":13,"name":"%self"},{"definition":"sub","detail":"($self,@args)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"alphabets","line":162,"definition":"my"},{"line":162,"name":"@args","containerName":"alphabets","kind":13},{"line":163,"kind":13,"containerName":"alphabets","name":"@args"},{"kind":13,"containerName":"alphabets","name":"$self","line":164},{"localvar":"my","kind":13,"containerName":"alphabets","name":"$alpha","line":165,"definition":"my"},{"line":165,"name":"@args","kind":13,"containerName":"alphabets"},{"line":166,"containerName":"alphabets","kind":13,"name":"$alpha"},{"line":166,"name":"isa","containerName":"alphabets","kind":12},{"name":"$self","containerName":"alphabets","kind":13,"line":167},{"line":167,"kind":12,"containerName":"alphabets","name":"warn"},{"line":169,"kind":13,"containerName":"alphabets","name":"$self"},{"name":"$alpha","containerName":"alphabets","kind":13,"line":169}],"containerName":"main::","name":"alphabets","signature":{"documentation":"1;\n# $Id: Alphabet.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Alphabet\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Alphabet - BSANE/BioCORBA compliant symbol list alphabet\n\n=head1 SYNOPSIS\n\n  {\n      my $alphabet = Bio::Symbols::Alphabet->new(-symbols => [ @s ],\n  \t\t\t\t\t\t-subalphabets => [ @alphas ] );\n\n      my @symbols = $alphabet->symbols;\n      my @subalphas = $alphabet->alphabets;\n      if( $alphabet->contains($symbol) ) {\n  \t  # do something\n      }\n  }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to\nform symbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Alphabet;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Symbol::AlphabetI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Alphabet->new();\n Function: Builds a new Bio::Symbol::Alphabet object \n Returns : Bio::Symbol::Alphabet\n Args    : -symbols  => Array ref of Bio::Symbol::SymbolI objects\n           -subalphas=> Array ref of Bio::Symbol::AlphabetI objects \n                        representing sub alphabets\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->{'_symbols'} = [];\n    $self->{'_alphabets'} = [];\n    my ($symbols, $subalphas) = $self->_rearrange([qw(SYMBOLS SUBALPHAS)],\n\t\t\t\t\t\t  @args);\n\n    defined $symbols && ref($symbols) =~ /array/i && $self->symbols(@$symbols);\n    defined $subalphas && ref($subalphas) =~ /array/i && $self->alphabets(@$subalphas);\n    return $self;\n}\n\n=head2 AlphabetI Interface methods\n\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $alphabet->symbols();\n Function: Get/Set Symbol list for an alphabet\n           List of symbols, which make up this alphabet.\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optionalalphabets) Array of Bio::Symbol::SymbolI objects\n\n\nsub symbols {\n    my ($self,@args) = @_;\n    if( @args ) { \n\t$self->{'_symbols'} = [];\n\tforeach my $symbol ( @args ) {\n\t    if( ! defined $symbol || ! ref($symbol) || \n\t\t! $symbol->isa('Bio::Symbol::SymbolI') ) {\n\t\t$self->warn(\"Did not provide a proper Bio::Symbol::SymbolI to method 'symbols' (got $symbol)\");\n\t    } else { \n\t\tpush @{$self->{'_symbols'}}, $symbol;\n\t    }\n\t}\n    }\n    return @{$self->{'_symbols'}};\n}\n\n=head2 alphabets\n\n Title   : alphabets\n Usage   : my @alphabets = $alphabet->alphabets();\n Function: Get/Set Sub Alphabet list for an alphabet \n           Sub-alphabets. E.g. codons made from DNAxDNAxDNA alphabets\n Returns : Array of Bio::Symbol::AlphabetI objects\n Args    : (optional) Array of Bio::Symbol::AlphabetI objects","parameters":[{"label":"$self"},{"label":"@args"}],"label":"alphabets($self,@args)"},"line":161,"kind":12,"range":{"end":{"line":172,"character":9999},"start":{"line":161,"character":0}}},{"line":173,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"range":{"end":{"line":192,"character":9999},"start":{"line":186,"character":0}},"line":186,"signature":{"parameters":[{"label":"$self"},{"label":"$testsymbol"}],"documentation":"1;\n# $Id: Alphabet.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Alphabet\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Alphabet - BSANE/BioCORBA compliant symbol list alphabet\n\n=head1 SYNOPSIS\n\n  {\n      my $alphabet = Bio::Symbols::Alphabet->new(-symbols => [ @s ],\n  \t\t\t\t\t\t-subalphabets => [ @alphas ] );\n\n      my @symbols = $alphabet->symbols;\n      my @subalphas = $alphabet->alphabets;\n      if( $alphabet->contains($symbol) ) {\n  \t  # do something\n      }\n  }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to\nform symbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Alphabet;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Symbol::AlphabetI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Alphabet->new();\n Function: Builds a new Bio::Symbol::Alphabet object \n Returns : Bio::Symbol::Alphabet\n Args    : -symbols  => Array ref of Bio::Symbol::SymbolI objects\n           -subalphas=> Array ref of Bio::Symbol::AlphabetI objects \n                        representing sub alphabets\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->{'_symbols'} = [];\n    $self->{'_alphabets'} = [];\n    my ($symbols, $subalphas) = $self->_rearrange([qw(SYMBOLS SUBALPHAS)],\n\t\t\t\t\t\t  @args);\n\n    defined $symbols && ref($symbols) =~ /array/i && $self->symbols(@$symbols);\n    defined $subalphas && ref($subalphas) =~ /array/i && $self->alphabets(@$subalphas);\n    return $self;\n}\n\n=head2 AlphabetI Interface methods\n\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $alphabet->symbols();\n Function: Get/Set Symbol list for an alphabet\n           List of symbols, which make up this alphabet.\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optionalalphabets) Array of Bio::Symbol::SymbolI objects\n\n\nsub symbols {\n    my ($self,@args) = @_;\n    if( @args ) { \n\t$self->{'_symbols'} = [];\n\tforeach my $symbol ( @args ) {\n\t    if( ! defined $symbol || ! ref($symbol) || \n\t\t! $symbol->isa('Bio::Symbol::SymbolI') ) {\n\t\t$self->warn(\"Did not provide a proper Bio::Symbol::SymbolI to method 'symbols' (got $symbol)\");\n\t    } else { \n\t\tpush @{$self->{'_symbols'}}, $symbol;\n\t    }\n\t}\n    }\n    return @{$self->{'_symbols'}};\n}\n\n=head2 alphabets\n\n Title   : alphabets\n Usage   : my @alphabets = $alphabet->alphabets();\n Function: Get/Set Sub Alphabet list for an alphabet \n           Sub-alphabets. E.g. codons made from DNAxDNAxDNA alphabets\n Returns : Array of Bio::Symbol::AlphabetI objects\n Args    : (optional) Array of Bio::Symbol::AlphabetI objects\n\n\nsub alphabets {\n    my ($self,@args) = @_;\n   if( @args ) { \n       $self->{'_alphabets'} = [];\n       foreach my $alpha ( @args ) {\n\t   if( ! $alpha->isa('Bio::Symbol::AlphabetI') ) {\n\t       $self->warn(\"Did not provide a proper Bio::Symbol::AlphabetI to method 'alphabets' (got $alpha)\");\n\t   } else { \n\t       push @{$self->{'_alphabets'}}, $alpha;\n\t   }\n       }\n   }\n    return @{$self->{'_alphabets'}};\n}\n\n=head2 contains\n\n Title   : contains\n Usage   : if($alphabet->contains($symbol)) { }\n Function: Tests of Symbol is contained in this alphabet\n Returns : Boolean\n Args    : Bio::Symbol::SymbolI","label":"contains($self,$testsymbol)"},"containerName":"main::","name":"contains","children":[{"definition":"my","line":187,"name":"$self","localvar":"my","containerName":"contains","kind":13},{"line":187,"containerName":"contains","kind":13,"name":"$testsymbol"},{"definition":"my","name":"$symbol","kind":13,"localvar":"my","containerName":"contains","line":188},{"name":"$self","kind":13,"containerName":"contains","line":188},{"line":188,"containerName":"contains","kind":12,"name":"symbols"},{"line":189,"name":"$symbol","containerName":"contains","kind":13},{"line":189,"containerName":"contains","kind":12,"name":"equals"},{"name":"$testsymbol","kind":13,"containerName":"contains","line":189}],"detail":"($self,$testsymbol)","definition":"sub"}]}