{"version":5,"vars":[{"line":141,"name":"base","kind":2,"containerName":""},{"name":"%ASGTable","containerName":"main::","kind":13,"line":143,"definition":"our"},{"line":151,"name":"%AATable","containerName":"main::","kind":13,"definition":"our"},{"range":{"start":{"character":0,"line":172},"end":{"line":179,"character":9999}},"kind":12,"line":172,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $id $\n#\n# bioperl module for Bio::Structure::SecStr::STRIDE::Res.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ed Green <ed@compbio.berkeley.edu>\n#\n# Copyright Univ. of California\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Structure::SecStr::STRIDE::Res - Module for parsing/accessing stride output\n\n=head1 SYNOPSIS\n\n my $stride_obj = Bio::Structure::SecStr::STRIDE::Res->new( '-file' => 'filename.stride' );\n\n # or\n\n my $stride_obj = Bio::Structure::SecStr::STRIDE::Res->new( '-fh' => \\*STDOUT );\n\n # Get secondary structure assignment for PDB residue 20 of chain A\n $sec_str = $stride_obj->resSecStr( '20:A' );\n\n # same\n $sec_str = $stride_obj->resSecStr( 20, 'A' )\n\n=head1 DESCRIPTION\n\nSTRIDE::Res is a module for objectifying STRIDE output.  STRIDE is a\nprogram (similar to DSSP) for assigning secondary structure to\nindividual residues of a pdb structure file.\n\n    ( Knowledge-Based Protein Secondary Structure Assignment,\n    PROTEINS: Structure, Function, and Genetics 23:566-579 (1995) )\n\nSTRIDE is available here:\nhttp://webclu.bio.wzw.tum.de/stride/\n\nMethods are then available for extracting all of the infomation\npresent within the output or convenient subsets of it.\n\nAlthough they are very similar in function, DSSP and STRIDE differ\nsomewhat in output format.  Thes differences are reflected in the\nreturn value of some methods of these modules.  For example, both\nthe STRIDE and DSSP parsers have resSecStr() methods for returning\nthe secondary structure of a given residue.  However, the range of\nreturn values for DSSP is ( H, B, E, G, I, T, and S ) whereas the\nrange of values for STRIDE is ( H, G, I, E, B, b, T, and C ).  See\nindividual methods for details.\n\nThe methods are roughly divided into 3 sections:\n\n  1.  Global features of this structure (PDB ID, total surface area,\n      etc.).  These methods do not require an argument. \n  2.  Residue specific features ( amino acid, secondary structure,\n      solvent exposed surface area, etc. ).  These methods do require an\n      arguement.  The argument is supposed to uniquely identify a\n      residue described within the structure.  It can be of any of the\n      following forms:\n      ('#A:B') or ( #, 'A', 'B' )\n  \t|| |\n  \t|| - Chain ID (blank for single chain)\n  \t|--- Insertion code for this residue.  Blank for most residues.\n  \t|--- Numeric portion of residue ID.\n\n      (#)\n       |\n       --- Numeric portion of residue ID.  If there is only one chain and\n  \t   it has no ID AND there is no residue with an insertion code at this\n  \t   number, then this can uniquely specify a residue.\n\n      ('#:C') or ( #, 'C' )\n  \t| |\n  \t| -Chain ID\n  \t---Numeric portion of residue ID.\n\n     If a residue is incompletely specified then the first residue that\n     fits the arguments is returned.  For example, if 19 is the argument\n     and there are three chains, A, B, and C with a residue whose number\n     is 19, then 19:A will be returned (assuming its listed first).\n\n     Since neither DSSP nor STRIDE correctly handle alt-loc codes, they\n     are not supported by these modules.\n\n 3.  Value-added methods.  Return values are not verbatem strings\n     parsed from DSSP or STRIDE output.  \n\n=head1 FEEDBACK\n\n=head2 MailingLists\n\nUsUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ed Green\n\nEmail ed@compbio.berkeley.edu\n\n\n=head1 APPENDIX\n\nThe Rest of the documentation details each method.\nInternal methods are preceded with a _.\n\n\n\npackage Bio::Structure::SecStr::STRIDE::Res;\nuse strict;\nuse Bio::Root::IO;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\nour %ASGTable = ( 'aa'         =>  0,\n\t\t  'resNum'     =>  1,\n\t\t  'ssAbbr'     =>  2,\n\t\t  'ssName'     =>  3,\n\t\t  'phi'        =>  4,\n\t\t  'psi'        =>  5,\n\t\t  'surfArea'   =>  6 );\n\nour %AATable = ( 'ALA' => 'A', 'ARG' => 'R', 'ASN' => 'N',\n\t\t 'ASP' => 'D', 'CYS' => 'C', 'GLN' => 'Q',\n\t\t 'GLU' => 'E', 'GLY' => 'G', 'HIS' => 'H',\n\t\t 'ILE' => 'I', 'LEU' => 'L', 'LYS' => 'K',\n\t\t 'MET' => 'M', 'PHE' => 'F', 'PRO' => 'P',\n\t\t 'SER' => 'S', 'THR' => 'T', 'TRP' => 'W',\n\t\t 'TYR' => 'Y', 'VAL' => 'V' );\n\n=head2 new\n\n Title         : new\n Usage         : makes new object of this class\n Function      : Constructor\n Example       : $stride_obj = Bio::Structure::SecStr::STRIDE:Res->new( '-file' =>  filename \n\t\t\t\t\t\t     # or \n\t\t\t\t\t\t     '-fh'   => FILEHANDLE )\n Returns       : object (ref)\n Args          : filename or filehandle( must be proper STRIDE output )"},"containerName":"main::","name":"new","children":[{"definition":"my","name":"$class","localvar":"my","containerName":"new","kind":13,"line":173},{"name":"@args","kind":13,"containerName":"new","line":173},{"definition":"my","line":174,"kind":13,"localvar":"my","containerName":"new","name":"$self"},{"line":174,"name":"$class","containerName":"new","kind":13},{"line":174,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":175,"containerName":"new","localvar":"my","kind":13,"name":"$io"},{"line":175,"name":"new","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"@args","line":175},{"line":176,"name":"$self","containerName":"new","kind":13},{"name":"_parse","kind":12,"containerName":"new","line":176},{"line":176,"name":"$io","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$io","line":177},{"containerName":"new","kind":12,"name":"close","line":177},{"line":178,"name":"$self","containerName":"new","kind":13}],"detail":"($class,@args)","definition":"sub"},{"line":174,"name":"SUPER","containerName":"new","kind":12},{"name":"Bio","kind":12,"containerName":"Root::IO","line":175},{"definition":"sub","name":"totSurfArea","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"totSurfArea","name":"$self","line":197,"definition":"my"},{"definition":"my","name":"$total","containerName":"totSurfArea","localvar":"my","kind":13,"line":198},{"definition":"my","kind":13,"localvar":"my","containerName":"totSurfArea","name":"$chain","line":199},{"containerName":"totSurfArea","kind":13,"name":"$res","line":199},{"name":"$self","kind":13,"containerName":"totSurfArea","line":201},{"name":"$self","kind":13,"containerName":"totSurfArea","line":202},{"name":"$chain","kind":13,"containerName":"totSurfArea","line":205},{"name":"$self","containerName":"totSurfArea","kind":13,"line":205},{"definition":"my","line":206,"kind":13,"localvar":"my","containerName":"totSurfArea","name":"$i"},{"containerName":"totSurfArea","kind":13,"name":"$i","line":206},{"name":"$self","kind":13,"containerName":"totSurfArea","line":206},{"containerName":"totSurfArea","kind":13,"name":"$chain","line":206},{"name":"$i","containerName":"totSurfArea","kind":13,"line":206},{"line":207,"containerName":"totSurfArea","kind":13,"name":"$total"},{"line":208,"name":"$self","containerName":"totSurfArea","kind":13},{"line":208,"kind":13,"containerName":"totSurfArea","name":"$chain"},{"line":208,"name":"$i","containerName":"totSurfArea","kind":13},{"line":208,"name":"$ASGTable","kind":13,"containerName":"totSurfArea"}],"range":{"start":{"line":196,"character":0},"end":{"character":9999,"line":210}},"kind":12,"line":196},{"containerName":null,"kind":13,"name":"%self","line":213},{"line":213,"kind":13,"containerName":null,"name":"$total"},{"containerName":null,"kind":13,"name":"%self","line":214},{"range":{"end":{"line":236,"character":9999},"start":{"line":231,"character":0}},"kind":12,"line":231,"containerName":"main::","name":"numResidues","children":[{"line":232,"name":"$self","kind":13,"localvar":"my","containerName":"numResidues","definition":"my"},{"definition":"my","line":233,"kind":13,"localvar":"my","containerName":"numResidues","name":"$chain"},{"localvar":"my","kind":13,"containerName":"numResidues","name":"$total","line":234,"definition":"my"},{"kind":13,"localvar":"my","containerName":"numResidues","name":"$key","line":235,"definition":"my"},{"line":236,"name":"$key","kind":13,"containerName":"numResidues"},{"line":236,"kind":13,"containerName":"numResidues","name":"$self"}],"definition":"sub"},{"name":"%chain","containerName":null,"kind":13,"line":237},{"line":238,"name":"$key","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%chain","line":238},{"kind":13,"containerName":null,"name":"$total","line":239},{"name":"%self","kind":13,"containerName":null,"line":239},{"line":239,"name":"%key","containerName":null,"kind":13},{"line":243,"containerName":null,"kind":13,"name":"$total"},{"name":"%self","kind":13,"containerName":null,"line":243},{"name":"$key","containerName":null,"kind":13,"line":243},{"name":"$total","kind":13,"containerName":null,"line":246},{"range":{"end":{"line":266,"character":9999},"start":{"line":263,"character":0}},"kind":12,"line":263,"definition":"sub","name":"pdbID","containerName":"main::","children":[{"definition":"my","line":264,"containerName":"pdbID","localvar":"my","kind":13,"name":"$self"},{"line":265,"name":"$self","kind":13,"containerName":"pdbID"}]},{"range":{"start":{"character":0,"line":279},"end":{"line":281,"character":9999}},"kind":12,"line":279,"name":"pdbAuthor","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"pdbAuthor","line":280},{"line":281,"containerName":"pdbAuthor","kind":13,"name":"$self"}],"definition":"sub"},{"definition":"sub","name":"pdbCompound","containerName":"main::","children":[{"line":298,"localvar":"my","containerName":"pdbCompound","kind":13,"name":"$self","definition":"my"},{"line":299,"name":"$self","containerName":"pdbCompound","kind":13}],"range":{"start":{"line":297,"character":0},"end":{"line":299,"character":9999}},"kind":12,"line":297},{"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"pdbDate","line":315},{"kind":13,"containerName":"pdbDate","name":"$self","line":316}],"name":"pdbDate","containerName":"main::","definition":"sub","line":314,"range":{"start":{"line":314,"character":0},"end":{"character":9999,"line":317}},"kind":12},{"definition":"sub","containerName":"main::","name":"pdbHeader","children":[{"definition":"my","line":332,"name":"$self","localvar":"my","containerName":"pdbHeader","kind":13},{"name":"$self","kind":13,"containerName":"pdbHeader","line":333}],"range":{"end":{"line":334,"character":9999},"start":{"character":0,"line":331}},"kind":12,"line":331},{"line":348,"kind":12,"range":{"end":{"line":350,"character":9999},"start":{"line":348,"character":0}},"children":[{"definition":"my","line":349,"localvar":"my","kind":13,"containerName":"pdbSource","name":"$self"},{"containerName":"pdbSource","kind":13,"name":"$self","line":350}],"name":"pdbSource","containerName":"main::","definition":"sub"},{"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"resAA","line":369,"definition":"my"},{"name":"@args","localvar":"my","containerName":"resAA","kind":13,"line":370,"definition":"my"},{"localvar":"my","containerName":"resAA","kind":13,"name":"$ord","line":371,"definition":"my"},{"line":371,"name":"$chain","containerName":"resAA","kind":13},{"line":371,"containerName":"resAA","kind":13,"name":"$self"},{"line":371,"containerName":"resAA","kind":12,"name":"_toOrdChain"},{"line":371,"kind":13,"containerName":"resAA","name":"@args"},{"line":372,"name":"$AATable","kind":13,"containerName":"resAA"},{"line":372,"kind":13,"containerName":"resAA","name":"$self"},{"name":"$chain","kind":13,"containerName":"resAA","line":372},{"line":372,"containerName":"resAA","kind":13,"name":"$ord"},{"line":372,"name":"$ASGTable","containerName":"resAA","kind":13}],"containerName":"main::","name":"resAA","line":368,"kind":12,"range":{"end":{"line":373,"character":9999},"start":{"character":0,"line":368}}},{"line":387,"range":{"end":{"character":9999,"line":392},"start":{"character":0,"line":387}},"kind":12,"definition":"sub","children":[{"definition":"my","line":388,"kind":13,"localvar":"my","containerName":"resPhi","name":"$self"},{"line":389,"name":"@args","localvar":"my","containerName":"resPhi","kind":13,"definition":"my"},{"name":"$ord","kind":13,"localvar":"my","containerName":"resPhi","line":390,"definition":"my"},{"line":390,"containerName":"resPhi","kind":13,"name":"$chain"},{"kind":13,"containerName":"resPhi","name":"$self","line":390},{"line":390,"name":"_toOrdChain","kind":12,"containerName":"resPhi"},{"line":390,"name":"@args","containerName":"resPhi","kind":13},{"line":391,"name":"$self","kind":13,"containerName":"resPhi"},{"name":"$chain","kind":13,"containerName":"resPhi","line":391},{"kind":13,"containerName":"resPhi","name":"$ord","line":391},{"line":391,"kind":13,"containerName":"resPhi","name":"$ASGTable"}],"containerName":"main::","name":"resPhi"},{"line":406,"kind":12,"range":{"start":{"line":406,"character":0},"end":{"character":9999,"line":411}},"definition":"sub","children":[{"containerName":"resPsi","localvar":"my","kind":13,"name":"$self","line":407,"definition":"my"},{"line":408,"name":"@args","localvar":"my","kind":13,"containerName":"resPsi","definition":"my"},{"localvar":"my","kind":13,"containerName":"resPsi","name":"$ord","line":409,"definition":"my"},{"line":409,"name":"$chain","containerName":"resPsi","kind":13},{"line":409,"containerName":"resPsi","kind":13,"name":"$self"},{"containerName":"resPsi","kind":12,"name":"_toOrdChain","line":409},{"line":409,"containerName":"resPsi","kind":13,"name":"@args"},{"name":"$self","containerName":"resPsi","kind":13,"line":410},{"line":410,"kind":13,"containerName":"resPsi","name":"$chain"},{"line":410,"name":"$ord","kind":13,"containerName":"resPsi"},{"name":"$ASGTable","containerName":"resPsi","kind":13,"line":410}],"name":"resPsi","containerName":"main::"},{"line":425,"kind":12,"range":{"end":{"line":430,"character":9999},"start":{"line":425,"character":0}},"definition":"sub","children":[{"definition":"my","line":426,"localvar":"my","containerName":"resSolvAcc","kind":13,"name":"$self"},{"containerName":"resSolvAcc","localvar":"my","kind":13,"name":"@args","line":427,"definition":"my"},{"localvar":"my","kind":13,"containerName":"resSolvAcc","name":"$ord","line":428,"definition":"my"},{"line":428,"containerName":"resSolvAcc","kind":13,"name":"$chain"},{"kind":13,"containerName":"resSolvAcc","name":"$self","line":428},{"line":428,"name":"_toOrdChain","kind":12,"containerName":"resSolvAcc"},{"containerName":"resSolvAcc","kind":13,"name":"@args","line":428},{"name":"$self","containerName":"resSolvAcc","kind":13,"line":429},{"containerName":"resSolvAcc","kind":13,"name":"$chain","line":429},{"line":429,"name":"$ord","containerName":"resSolvAcc","kind":13},{"line":429,"name":"$ASGTable","kind":13,"containerName":"resSolvAcc"}],"containerName":"main::","name":"resSolvAcc"},{"definition":"sub","name":"resSurfArea","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"resSurfArea","name":"$self","line":445,"definition":"my"},{"line":446,"name":"@args","localvar":"my","containerName":"resSurfArea","kind":13,"definition":"my"},{"name":"$ord","localvar":"my","kind":13,"containerName":"resSurfArea","line":447,"definition":"my"},{"line":447,"name":"$chain","kind":13,"containerName":"resSurfArea"},{"line":447,"name":"$self","containerName":"resSurfArea","kind":13},{"line":447,"name":"_toOrdChain","containerName":"resSurfArea","kind":12},{"containerName":"resSurfArea","kind":13,"name":"@args","line":447},{"line":448,"containerName":"resSurfArea","kind":13,"name":"$self"},{"line":448,"kind":13,"containerName":"resSurfArea","name":"$chain"},{"line":448,"name":"$ord","containerName":"resSurfArea","kind":13},{"line":448,"containerName":"resSurfArea","kind":13,"name":"$ASGTable"}],"kind":12,"range":{"start":{"line":444,"character":0},"end":{"character":9999,"line":449}},"line":444},{"containerName":"main::","name":"resSecStr","children":[{"name":"$self","containerName":"resSecStr","localvar":"my","kind":13,"line":474,"definition":"my"},{"line":475,"kind":13,"localvar":"my","containerName":"resSecStr","name":"@args","definition":"my"},{"definition":"my","line":476,"name":"$ord","containerName":"resSecStr","localvar":"my","kind":13},{"line":476,"kind":13,"containerName":"resSecStr","name":"$chain"},{"line":476,"name":"$self","containerName":"resSecStr","kind":13},{"line":476,"containerName":"resSecStr","kind":12,"name":"_toOrdChain"},{"line":476,"name":"@args","containerName":"resSecStr","kind":13},{"line":477,"containerName":"resSecStr","kind":13,"name":"$self"},{"containerName":"resSecStr","kind":13,"name":"$chain","line":477},{"line":477,"name":"$ord","kind":13,"containerName":"resSecStr"},{"line":477,"kind":13,"containerName":"resSecStr","name":"$ASGTable"}],"definition":"sub","range":{"end":{"line":478,"character":9999},"start":{"character":0,"line":473}},"kind":12,"line":473},{"kind":12,"range":{"start":{"line":493,"character":0},"end":{"line":510,"character":9999}},"line":493,"containerName":"main::","name":"resSecStrSum","children":[{"definition":"my","line":494,"kind":13,"localvar":"my","containerName":"resSecStrSum","name":"$self"},{"line":495,"localvar":"my","containerName":"resSecStrSum","kind":13,"name":"@args","definition":"my"},{"name":"$ss_char","localvar":"my","containerName":"resSecStrSum","kind":13,"line":496,"definition":"my"},{"line":496,"name":"$self","containerName":"resSecStrSum","kind":13},{"kind":12,"containerName":"resSecStrSum","name":"resSecStr","line":496},{"line":496,"kind":13,"containerName":"resSecStrSum","name":"@args"},{"kind":13,"containerName":"resSecStrSum","name":"$ss_char","line":498},{"line":498,"name":"$ss_char","containerName":"resSecStrSum","kind":13},{"name":"$ss_char","containerName":"resSecStrSum","kind":13,"line":498},{"name":"$ss_char","kind":13,"containerName":"resSecStrSum","line":501},{"line":501,"name":"$ss_char","containerName":"resSecStrSum","kind":13},{"line":501,"name":"$ss_char","kind":13,"containerName":"resSecStrSum"},{"name":"$ss_char","containerName":"resSecStrSum","kind":13,"line":504}],"definition":"sub"},{"definition":"sub","containerName":"main::","name":"resSecStrName","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"resSecStrName","line":528},{"definition":"my","line":529,"localvar":"my","containerName":"resSecStrName","kind":13,"name":"@args"},{"name":"$ord","localvar":"my","kind":13,"containerName":"resSecStrName","line":530,"definition":"my"},{"name":"$chain","containerName":"resSecStrName","kind":13,"line":530},{"name":"$self","containerName":"resSecStrName","kind":13,"line":530},{"line":530,"name":"_toOrdChain","containerName":"resSecStrName","kind":12},{"name":"@args","kind":13,"containerName":"resSecStrName","line":530},{"name":"$self","containerName":"resSecStrName","kind":13,"line":531},{"line":531,"name":"$chain","kind":13,"containerName":"resSecStrName"},{"kind":13,"containerName":"resSecStrName","name":"$ord","line":531},{"containerName":"resSecStrName","kind":13,"name":"$ASGTable","line":531}],"range":{"end":{"character":9999,"line":532},"start":{"line":527,"character":0}},"kind":12,"line":527},{"children":[{"line":554,"kind":13,"localvar":"my","containerName":"strideLocs","name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"strideLocs","line":555}],"containerName":"main::","name":"strideLocs","definition":"sub","line":553,"kind":12,"range":{"end":{"character":9999,"line":556},"start":{"line":553,"character":0}}},{"range":{"start":{"character":0,"line":577},"end":{"line":600,"character":9999}},"kind":12,"line":577,"name":"secBounds","containerName":"main::","children":[{"localvar":"my","containerName":"secBounds","kind":13,"name":"$self","line":579,"definition":"my"},{"line":580,"localvar":"my","kind":13,"containerName":"secBounds","name":"$chain","definition":"my"},{"containerName":"secBounds","localvar":"my","kind":13,"name":"@SecBounds","line":581,"definition":"my"},{"name":"$chain","kind":13,"containerName":"secBounds","line":583},{"name":"$chain","kind":13,"containerName":"secBounds","line":583},{"line":583,"name":"$chain","kind":13,"containerName":"secBounds"},{"containerName":"secBounds","kind":13,"name":"$chain","line":583},{"containerName":"secBounds","kind":13,"name":"$self","line":586},{"kind":13,"containerName":"secBounds","name":"$chain","line":586},{"line":587,"name":"$self","kind":13,"containerName":"secBounds"},{"containerName":"secBounds","kind":13,"name":"$chain","line":587},{"name":"$self","kind":13,"containerName":"secBounds","line":591},{"line":591,"name":"$chain","containerName":"secBounds","kind":13},{"name":"$self","containerName":"secBounds","kind":13,"line":592},{"line":592,"name":"throw","kind":12,"containerName":"secBounds"},{"definition":"my","line":595,"localvar":"my","containerName":"secBounds","kind":13,"name":"$cur_element"},{"name":"$self","kind":13,"containerName":"secBounds","line":595},{"name":"$chain","kind":13,"containerName":"secBounds","line":595},{"line":596,"containerName":"secBounds","kind":13,"name":"$ASGTable"},{"definition":"my","line":597,"kind":13,"localvar":"my","containerName":"secBounds","name":"$beg"},{"definition":"my","kind":13,"localvar":"my","containerName":"secBounds","name":"$i","line":598},{"line":600,"kind":13,"containerName":"secBounds","name":"$i"},{"line":600,"containerName":"secBounds","kind":13,"name":"$i"},{"kind":13,"containerName":"secBounds","name":"$self","line":600},{"name":"$chain","containerName":"secBounds","kind":13,"line":600}],"definition":"sub"},{"kind":13,"containerName":null,"name":"%i","line":600},{"line":601,"containerName":null,"kind":13,"name":"%self"},{"line":601,"name":"@chain","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@i","line":601},{"containerName":null,"kind":13,"name":"%ASGTable","line":601},{"line":602,"kind":13,"containerName":null,"name":"%cur_element"},{"line":603,"name":"@SecBounds","kind":13,"containerName":null},{"line":603,"kind":13,"containerName":null,"name":"$beg"},{"name":"$i","kind":13,"containerName":null,"line":603},{"line":603,"containerName":null,"kind":13,"name":"$cur_element"},{"containerName":null,"kind":13,"name":"$beg","line":604},{"line":604,"name":"$i","kind":13,"containerName":null},{"name":"$cur_element","kind":13,"containerName":null,"line":605},{"line":605,"name":"%self","containerName":null,"kind":13},{"line":605,"kind":13,"containerName":null,"name":"@chain"},{"line":605,"kind":13,"containerName":null,"name":"@i"},{"line":606,"name":"%ASGTable","kind":13,"containerName":null},{"line":610,"name":"%self","containerName":null,"kind":13},{"line":610,"containerName":null,"kind":13,"name":"@chain"},{"name":"@i","containerName":null,"kind":13,"line":610},{"line":610,"name":"%ASGTable","kind":13,"containerName":null},{"name":"%cur_element","containerName":null,"kind":13,"line":611},{"line":612,"containerName":null,"kind":13,"name":"@SecBounds"},{"line":612,"kind":13,"containerName":null,"name":"$beg"},{"name":"$i","containerName":null,"kind":13,"line":612},{"line":612,"name":"%cur_element","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@SecBounds","line":615},{"line":615,"kind":13,"containerName":null,"name":"$beg"},{"line":615,"containerName":null,"kind":13,"name":"$i"},{"name":"@cur_element","kind":13,"containerName":null,"line":615},{"line":616,"name":"$i","kind":13,"containerName":null},{"line":616,"name":"$i","containerName":null,"kind":13},{"line":616,"kind":13,"containerName":null,"name":"%self"},{"line":616,"name":"@chain","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@i","line":616},{"kind":13,"containerName":null,"name":"%ASGTable","line":617},{"line":620,"kind":13,"containerName":null,"name":"%self"},{"name":"$chain","containerName":null,"kind":13,"line":620},{"line":620,"name":"@SecBounds","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%self","line":621},{"name":"$chain","kind":13,"containerName":null,"line":621},{"line":636,"kind":12,"range":{"start":{"character":0,"line":636},"end":{"character":9999,"line":638}},"definition":"sub","children":[{"localvar":"my","kind":13,"containerName":"chains","name":"$self","line":637,"definition":"my"},{"definition":"my","containerName":"chains","localvar":"my","kind":13,"name":"@chains","line":638},{"containerName":"chains","kind":13,"name":"$self","line":638}],"containerName":"main::","name":"chains"},{"line":639,"containerName":null,"kind":13,"name":"@chains"},{"line":668,"kind":12,"range":{"end":{"line":714,"character":9999},"start":{"character":0,"line":668}},"children":[{"definition":"my","containerName":"getSeq","localvar":"my","kind":13,"name":"$self","line":669},{"definition":"my","name":"$chain","containerName":"getSeq","localvar":"my","kind":13,"line":670},{"line":671,"containerName":"getSeq","localvar":"my","kind":13,"name":"$fill_in","definition":"my"},{"line":673,"containerName":"getSeq","kind":13,"name":"$chain"},{"name":"$chain","kind":13,"containerName":"getSeq","line":674},{"line":677,"name":"$self","containerName":"getSeq","kind":13},{"line":677,"name":"$chain","kind":13,"containerName":"getSeq"},{"line":678,"name":"$self","kind":13,"containerName":"getSeq"},{"line":678,"containerName":"getSeq","kind":13,"name":"$chain"},{"line":681,"containerName":"getSeq","localvar":"my","kind":13,"name":"$seq","definition":"my"},{"name":"$num_res","containerName":"getSeq","kind":13,"line":682},{"kind":13,"containerName":"getSeq","name":"$last_res_num","line":683},{"kind":13,"containerName":"getSeq","name":"$cur_res_num","line":684},{"line":685,"name":"$i","kind":13,"containerName":"getSeq"},{"kind":13,"containerName":"getSeq","name":"$step","line":686},{"containerName":"getSeq","kind":13,"name":"$id","line":688},{"containerName":"getSeq","kind":13,"name":"$seq","line":690},{"kind":13,"containerName":"getSeq","name":"$num_res","line":691},{"kind":13,"containerName":"getSeq","name":"$self","line":691},{"line":691,"containerName":"getSeq","kind":12,"name":"numResidues"},{"line":691,"kind":13,"containerName":"getSeq","name":"$chain"},{"kind":13,"containerName":"getSeq","name":"$last_res_num","line":692},{"line":692,"kind":13,"containerName":"getSeq","name":"$self"},{"line":692,"name":"_pdbNum","containerName":"getSeq","kind":12},{"kind":13,"containerName":"getSeq","name":"$chain","line":692},{"kind":13,"containerName":"getSeq","name":"$i","line":693},{"kind":13,"containerName":"getSeq","name":"$i","line":693},{"name":"$num_res","kind":13,"containerName":"getSeq","line":693},{"line":693,"name":"$i","kind":13,"containerName":"getSeq"},{"line":694,"kind":13,"containerName":"getSeq","name":"$fill_in"},{"kind":13,"containerName":"getSeq","name":"$cur_res_num","line":695},{"line":695,"name":"$self","kind":13,"containerName":"getSeq"},{"kind":12,"containerName":"getSeq","name":"_pdbNum","line":695},{"line":695,"containerName":"getSeq","kind":13,"name":"$i"},{"line":695,"name":"$chain","kind":13,"containerName":"getSeq"},{"name":"$step","containerName":"getSeq","kind":13,"line":696},{"kind":13,"containerName":"getSeq","name":"$cur_res_num","line":696},{"containerName":"getSeq","kind":13,"name":"$last_res_num","line":696},{"name":"$step","containerName":"getSeq","kind":13,"line":697},{"line":698,"name":"$seq","containerName":"getSeq","kind":13},{"line":698,"containerName":"getSeq","kind":13,"name":"$step"},{"containerName":"getSeq","kind":13,"name":"$seq","line":701},{"line":701,"name":"$self","kind":13,"containerName":"getSeq"},{"line":701,"kind":12,"containerName":"getSeq","name":"_resAA"},{"name":"$i","containerName":"getSeq","kind":13,"line":701},{"name":"$chain","containerName":"getSeq","kind":13,"line":701},{"name":"$last_res_num","containerName":"getSeq","kind":13,"line":702},{"name":"$cur_res_num","kind":13,"containerName":"getSeq","line":702},{"containerName":"getSeq","kind":13,"name":"$id","line":705},{"name":"$self","kind":13,"containerName":"getSeq","line":705},{"name":"pdbID","kind":12,"containerName":"getSeq","line":705},{"name":"$id","kind":13,"containerName":"getSeq","line":706},{"line":708,"name":"$self","containerName":"getSeq","kind":13},{"name":"$chain","kind":13,"containerName":"getSeq","line":708},{"name":"new","containerName":"getSeq","kind":12,"line":708},{"line":708,"name":"$seq","kind":13,"containerName":"getSeq"},{"name":"$id","containerName":"getSeq","kind":13,"line":709},{"line":713,"containerName":"getSeq","kind":13,"name":"$self"},{"line":713,"name":"$chain","kind":13,"containerName":"getSeq"}],"containerName":"main::","name":"getSeq","definition":"sub"},{"line":708,"kind":12,"containerName":"PrimarySeq","name":"Bio"},{"definition":"sub","name":"_pdbNum","containerName":"main::","children":[{"definition":"my","line":734,"name":"$self","localvar":"my","kind":13,"containerName":"_pdbNum"},{"line":735,"localvar":"my","kind":13,"containerName":"_pdbNum","name":"$ord","definition":"my"},{"definition":"my","line":736,"kind":13,"localvar":"my","containerName":"_pdbNum","name":"$chain"},{"line":737,"name":"$self","containerName":"_pdbNum","kind":13},{"line":737,"containerName":"_pdbNum","kind":13,"name":"$chain"},{"kind":13,"containerName":"_pdbNum","name":"$ord","line":737},{"name":"$self","containerName":"_pdbNum","kind":13,"line":738},{"line":738,"kind":12,"containerName":"_pdbNum","name":"throw"},{"kind":13,"localvar":"my","containerName":"_pdbNum","name":"$pdb_junk","line":740,"definition":"my"},{"line":740,"name":"$self","kind":13,"containerName":"_pdbNum"},{"name":"$chain","containerName":"_pdbNum","kind":13,"line":740},{"containerName":"_pdbNum","kind":13,"name":"$ord","line":740},{"line":740,"name":"$ASGTable","kind":13,"containerName":"_pdbNum"},{"definition":"my","line":741,"name":"$num_part","localvar":"my","kind":13,"containerName":"_pdbNum"},{"line":742,"name":"$num_part","kind":13,"containerName":"_pdbNum"},{"name":"$pdb_junk","kind":13,"containerName":"_pdbNum","line":742},{"line":743,"name":"$num_part","kind":13,"containerName":"_pdbNum"}],"range":{"start":{"character":0,"line":733},"end":{"character":9999,"line":744}},"kind":12,"line":733},{"children":[{"line":760,"localvar":"my","containerName":"_resAA","kind":13,"name":"$self","definition":"my"},{"definition":"my","line":761,"containerName":"_resAA","localvar":"my","kind":13,"name":"$ord"},{"line":762,"name":"$chain","localvar":"my","containerName":"_resAA","kind":13,"definition":"my"},{"containerName":"_resAA","kind":13,"name":"$self","line":763},{"containerName":"_resAA","kind":13,"name":"$chain","line":763},{"line":763,"kind":13,"containerName":"_resAA","name":"$ord"},{"kind":13,"containerName":"_resAA","name":"$self","line":764},{"containerName":"_resAA","kind":12,"name":"throw","line":764},{"name":"$AATable","containerName":"_resAA","kind":13,"line":766},{"line":766,"kind":13,"containerName":"_resAA","name":"$self"},{"line":766,"name":"$chain","containerName":"_resAA","kind":13},{"line":766,"name":"$ord","kind":13,"containerName":"_resAA"},{"containerName":"_resAA","kind":13,"name":"$ASGTable","line":766}],"name":"_resAA","containerName":"main::","definition":"sub","line":759,"range":{"start":{"line":759,"character":0},"end":{"character":9999,"line":767}},"kind":12},{"name":"_pdbInsCo","containerName":"main::","children":[{"line":782,"containerName":"_pdbInsCo","localvar":"my","kind":13,"name":"$self","definition":"my"},{"localvar":"my","kind":13,"containerName":"_pdbInsCo","name":"$ord","line":783,"definition":"my"},{"name":"$chain","localvar":"my","kind":13,"containerName":"_pdbInsCo","line":784,"definition":"my"},{"containerName":"_pdbInsCo","kind":13,"name":"$self","line":785},{"kind":13,"containerName":"_pdbInsCo","name":"$chain","line":785},{"line":785,"name":"$ord","kind":13,"containerName":"_pdbInsCo"},{"name":"$self","kind":13,"containerName":"_pdbInsCo","line":786},{"line":786,"containerName":"_pdbInsCo","kind":12,"name":"throw"},{"line":788,"localvar":"my","kind":13,"containerName":"_pdbInsCo","name":"$pdb_junk","definition":"my"},{"line":788,"name":"$self","containerName":"_pdbInsCo","kind":13},{"containerName":"_pdbInsCo","kind":13,"name":"$chain","line":788},{"name":"$ord","containerName":"_pdbInsCo","kind":13,"line":788},{"line":788,"name":"$ASGTable","kind":13,"containerName":"_pdbInsCo"},{"definition":"my","name":"$letter_part","kind":13,"localvar":"my","containerName":"_pdbInsCo","line":789},{"line":790,"kind":13,"containerName":"_pdbInsCo","name":"$letter_part"},{"line":790,"containerName":"_pdbInsCo","kind":13,"name":"$pdb_junk"},{"kind":13,"containerName":"_pdbInsCo","name":"$letter_part","line":792}],"definition":"sub","kind":12,"range":{"end":{"line":793,"character":9999},"start":{"line":781,"character":0}},"line":781},{"range":{"start":{"character":0,"line":832},"end":{"character":9999,"line":874}},"kind":12,"line":832,"definition":"sub","containerName":"main::","name":"_toOrdChain","children":[{"definition":"my","line":833,"name":"$self","localvar":"my","kind":13,"containerName":"_toOrdChain"},{"name":"$arg_str","localvar":"my","containerName":"_toOrdChain","kind":13,"line":834,"definition":"my"},{"line":836,"name":"$key_num","localvar":"my","containerName":"_toOrdChain","kind":13,"definition":"my"},{"line":836,"name":"$chain_id","kind":13,"containerName":"_toOrdChain"},{"line":836,"kind":13,"containerName":"_toOrdChain","name":"$ins_code"},{"containerName":"_toOrdChain","kind":13,"name":"$key","line":836},{"line":836,"kind":13,"containerName":"_toOrdChain","name":"$i"},{"kind":13,"containerName":"_toOrdChain","name":"$key_num","line":840},{"containerName":"_toOrdChain","kind":13,"name":"$ins_code","line":842},{"name":"$chain_id","kind":13,"containerName":"_toOrdChain","line":843},{"line":846,"kind":13,"containerName":"_toOrdChain","name":"$chain_id"},{"line":850,"name":"$arg_str","kind":13,"containerName":"_toOrdChain"},{"containerName":"_toOrdChain","kind":13,"name":"$arg_str","line":851},{"line":853,"containerName":"_toOrdChain","kind":13,"name":"$chain_id"},{"name":"$arg_str","kind":13,"containerName":"_toOrdChain","line":853},{"line":854,"name":"$arg_str","containerName":"_toOrdChain","kind":13},{"containerName":"_toOrdChain","kind":13,"name":"$arg_str","line":856},{"line":858,"containerName":"_toOrdChain","kind":13,"name":"$ins_code"},{"name":"$arg_str","kind":13,"containerName":"_toOrdChain","line":858},{"line":859,"kind":13,"containerName":"_toOrdChain","name":"$arg_str"},{"containerName":"_toOrdChain","kind":13,"name":"$key_num","line":862},{"name":"$arg_str","containerName":"_toOrdChain","kind":13,"line":862},{"line":865,"containerName":"_toOrdChain","kind":13,"name":"$key"},{"name":"$chain_id","kind":13,"containerName":"_toOrdChain","line":866},{"name":"$chain_id","kind":13,"containerName":"_toOrdChain","line":866},{"name":"$chain_id","kind":13,"containerName":"_toOrdChain","line":867},{"line":870,"kind":13,"containerName":"_toOrdChain","name":"$self"},{"line":870,"name":"$chain_id","containerName":"_toOrdChain","kind":13},{"name":"$self","containerName":"_toOrdChain","kind":13,"line":871},{"name":"throw","containerName":"_toOrdChain","kind":12,"line":871},{"line":874,"name":"$i","containerName":"_toOrdChain","kind":13},{"line":874,"name":"$i","kind":13,"containerName":"_toOrdChain"},{"name":"$self","containerName":"_toOrdChain","kind":13,"line":874},{"line":874,"name":"$chain_id","kind":13,"containerName":"_toOrdChain"}]},{"line":874,"name":"%i","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%self","line":875},{"name":"@chain_id","containerName":null,"kind":13,"line":875},{"line":875,"containerName":null,"kind":13,"name":"@i"},{"kind":13,"containerName":null,"name":"%ASGTable","line":875},{"containerName":null,"kind":13,"name":"%key","line":876},{"line":877,"name":"$i","kind":13,"containerName":null},{"line":877,"name":"$chain_id","kind":13,"containerName":null},{"line":881,"name":"$self","kind":13,"containerName":null},{"name":"throw","containerName":"main::","kind":12,"line":881},{"kind":12,"range":{"end":{"character":9999,"line":915},"start":{"line":897,"character":0}},"line":897,"definition":"sub","name":"_parse","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_parse","kind":13,"line":898},{"definition":"my","name":"$io","localvar":"my","containerName":"_parse","kind":13,"line":899},{"localvar":"my","kind":13,"containerName":"_parse","name":"$file","line":900,"definition":"my"},{"kind":13,"containerName":"_parse","name":"$io","line":900},{"name":"_fh","kind":12,"containerName":"_parse","line":900},{"line":903,"name":"$self","kind":13,"containerName":"_parse"},{"kind":12,"containerName":"_parse","name":"_parseTop","line":903},{"kind":13,"containerName":"_parse","name":"$io","line":903},{"line":904,"kind":13,"containerName":"_parse","name":"$self"},{"name":"throw","kind":12,"containerName":"_parse","line":904},{"line":908,"containerName":"_parse","kind":13,"name":"$self"},{"line":908,"containerName":"_parse","kind":12,"name":"_parseHead"},{"name":"$io","containerName":"_parse","kind":13,"line":908},{"name":"$self","containerName":"_parse","kind":13,"line":911},{"line":911,"kind":12,"containerName":"_parse","name":"_parseSummary"},{"kind":13,"containerName":"_parse","name":"$io","line":911},{"name":"$self","kind":13,"containerName":"_parse","line":914},{"line":914,"name":"_parseASG","containerName":"_parse","kind":12},{"line":914,"name":"$io","containerName":"_parse","kind":13}]},{"definition":"sub","name":"_parseTop","containerName":"main::","children":[{"definition":"my","line":930,"name":"$self","containerName":"_parseTop","localvar":"my","kind":13},{"line":931,"name":"$io","localvar":"my","containerName":"_parseTop","kind":13,"definition":"my"},{"definition":"my","name":"$file","localvar":"my","containerName":"_parseTop","kind":13,"line":932},{"line":932,"kind":13,"containerName":"_parseTop","name":"$io"},{"name":"_fh","kind":12,"containerName":"_parseTop","line":932},{"line":933,"kind":13,"localvar":"my","containerName":"_parseTop","name":"$cur","definition":"my"},{"containerName":"_parseTop","kind":13,"name":"$file","line":933},{"name":"$cur","containerName":"_parseTop","kind":13,"line":934}],"kind":12,"range":{"start":{"character":0,"line":929},"end":{"line":938,"character":9999}},"line":929},{"line":952,"kind":12,"range":{"start":{"character":0,"line":952},"end":{"line":1002,"character":9999}},"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_parseHead","line":953,"definition":"my"},{"definition":"my","line":954,"name":"$io","localvar":"my","kind":13,"containerName":"_parseHead"},{"definition":"my","line":955,"name":"$file","containerName":"_parseHead","localvar":"my","kind":13},{"line":955,"containerName":"_parseHead","kind":13,"name":"$io"},{"line":955,"containerName":"_parseHead","kind":12,"name":"_fh"},{"definition":"my","line":956,"localvar":"my","containerName":"_parseHead","kind":13,"name":"$cur"},{"line":957,"name":"$element","localvar":"my","kind":13,"containerName":"_parseHead","definition":"my"},{"definition":"my","containerName":"_parseHead","localvar":"my","kind":13,"name":"@elements","line":958},{"containerName":"_parseHead","kind":13,"name":"@cmp","line":958},{"line":958,"name":"@src","kind":13,"containerName":"_parseHead"},{"containerName":"_parseHead","kind":13,"name":"@aut","line":958},{"line":959,"localvar":"my","containerName":"_parseHead","kind":13,"name":"%head","definition":"my"},{"definition":"my","line":960,"localvar":"my","kind":13,"containerName":"_parseHead","name":"$still_head"},{"name":"$cur","kind":13,"containerName":"_parseHead","line":962},{"containerName":"_parseHead","kind":13,"name":"$file","line":962},{"line":963,"name":"$cur","containerName":"_parseHead","kind":13},{"kind":13,"containerName":"_parseHead","name":"$cur","line":964},{"line":964,"containerName":"_parseHead","kind":13,"name":"$file"},{"line":967,"name":"$cur","kind":13,"containerName":"_parseHead"},{"name":"@elements","kind":13,"containerName":"_parseHead","line":968},{"containerName":"_parseHead","kind":13,"name":"$cur","line":968},{"containerName":"_parseHead","kind":13,"name":"@elements","line":969},{"name":"@elements","kind":13,"containerName":"_parseHead","line":970},{"line":971,"name":"$self","kind":13,"containerName":"_parseHead"},{"containerName":"_parseHead","kind":13,"name":"@elements","line":971},{"containerName":"_parseHead","kind":13,"name":"$self","line":972},{"name":"@elements","containerName":"_parseHead","kind":13,"line":972},{"line":975,"kind":13,"containerName":"_parseHead","name":"$element"},{"containerName":"_parseHead","kind":13,"name":"@elements","line":975},{"line":976,"name":"$head","kind":13,"containerName":"_parseHead"},{"line":976,"name":"$element","containerName":"_parseHead","kind":13},{"name":"$cur","kind":13,"containerName":"_parseHead","line":979},{"name":"$file","containerName":"_parseHead","kind":13,"line":979},{"containerName":"_parseHead","kind":13,"name":"$cur","line":980},{"kind":13,"containerName":"_parseHead","name":"$cur","line":981},{"name":"$cur","containerName":"_parseHead","kind":13,"line":981},{"name":"@cmp","kind":13,"containerName":"_parseHead","line":982},{"kind":13,"containerName":"_parseHead","name":"$cur","line":982},{"name":"$cur","kind":13,"containerName":"_parseHead","line":983},{"kind":13,"containerName":"_parseHead","name":"$file","line":983},{"containerName":"_parseHead","kind":13,"name":"$cur","line":986},{"name":"$cur","kind":13,"containerName":"_parseHead","line":987},{"name":"$cur","kind":13,"containerName":"_parseHead","line":987},{"containerName":"_parseHead","kind":13,"name":"@src","line":988},{"name":"$cur","kind":13,"containerName":"_parseHead","line":988},{"kind":13,"containerName":"_parseHead","name":"$cur","line":989},{"kind":13,"containerName":"_parseHead","name":"$file","line":989},{"line":992,"name":"$cur","kind":13,"containerName":"_parseHead"},{"containerName":"_parseHead","kind":13,"name":"$cur","line":993},{"containerName":"_parseHead","kind":13,"name":"$cur","line":993},{"name":"@aut","kind":13,"containerName":"_parseHead","line":994},{"line":994,"containerName":"_parseHead","kind":13,"name":"$cur"},{"name":"$cur","containerName":"_parseHead","kind":13,"line":995},{"kind":13,"containerName":"_parseHead","name":"$file","line":995},{"line":998,"containerName":"_parseHead","kind":13,"name":"$head"},{"line":998,"name":"@cmp","containerName":"_parseHead","kind":13},{"name":"$head","kind":13,"containerName":"_parseHead","line":999},{"line":999,"kind":13,"containerName":"_parseHead","name":"@src"},{"kind":13,"containerName":"_parseHead","name":"$head","line":1000},{"line":1000,"name":"@aut","containerName":"_parseHead","kind":13},{"line":1001,"name":"$self","containerName":"_parseHead","kind":13},{"kind":13,"containerName":"_parseHead","name":"%head","line":1001}],"name":"_parseHead","containerName":"main::"},{"definition":"sub","children":[{"localvar":"my","containerName":"_parseSummary","kind":13,"name":"$self","line":1017,"definition":"my"},{"name":"$io","localvar":"my","kind":13,"containerName":"_parseSummary","line":1018,"definition":"my"},{"definition":"my","name":"$file","localvar":"my","kind":13,"containerName":"_parseSummary","line":1019},{"name":"$io","containerName":"_parseSummary","kind":13,"line":1019},{"line":1019,"containerName":"_parseSummary","kind":12,"name":"_fh"},{"localvar":"my","kind":13,"containerName":"_parseSummary","name":"$cur","line":1020,"definition":"my"},{"name":"$file","kind":13,"containerName":"_parseSummary","line":1020},{"name":"$bound_set","localvar":"my","containerName":"_parseSummary","kind":13,"line":1021,"definition":"my"},{"line":1022,"name":"$element","localvar":"my","kind":13,"containerName":"_parseSummary","definition":"my"},{"name":"@elements","kind":13,"localvar":"my","containerName":"_parseSummary","line":1023,"definition":"my"},{"name":"@cur","containerName":"_parseSummary","kind":13,"line":1023},{"definition":"my","name":"@LOC_lookup","containerName":"_parseSummary","localvar":"my","kind":13,"line":1024},{"kind":13,"containerName":"_parseSummary","name":"$cur","line":1033},{"containerName":"_parseSummary","kind":13,"name":"$cur","line":1034},{"name":"$file","containerName":"_parseSummary","kind":13,"line":1034},{"line":1037,"name":"$cur","containerName":"_parseSummary","kind":13},{"kind":13,"containerName":"_parseSummary","name":"$bound_set","line":1038},{"name":"@LOC_lookup","containerName":"_parseSummary","kind":13,"line":1038},{"line":1039,"kind":13,"containerName":"_parseSummary","name":"$element"},{"name":"$cur","kind":13,"containerName":"_parseSummary","line":1039},{"containerName":"_parseSummary","kind":13,"name":"$bound_set","line":1039},{"containerName":"_parseSummary","kind":13,"name":"$bound_set","line":1039},{"kind":13,"containerName":"_parseSummary","name":"$element","line":1040},{"name":"@cur","containerName":"_parseSummary","kind":13,"line":1041},{"containerName":"_parseSummary","kind":13,"name":"$element","line":1041},{"kind":13,"containerName":"_parseSummary","name":"@elements","line":1043},{"kind":13,"containerName":"_parseSummary","name":"@cur","line":1043},{"line":1044,"name":"$cur","containerName":"_parseSummary","kind":13},{"line":1044,"containerName":"_parseSummary","kind":13,"name":"$file"},{"line":1045,"kind":13,"containerName":"_parseSummary","name":"@cur"},{"containerName":"_parseSummary","kind":13,"name":"$self","line":1047},{"name":"@elements","kind":13,"containerName":"_parseSummary","line":1047}],"containerName":"main::","name":"_parseSummary","line":1016,"kind":12,"range":{"end":{"character":9999,"line":1049},"start":{"line":1016,"character":0}}},{"line":1063,"range":{"end":{"character":9999,"line":1117},"start":{"character":0,"line":1063}},"kind":12,"definition":"sub","children":[{"name":"$self","containerName":"_parseASG","localvar":"my","kind":13,"line":1064,"definition":"my"},{"definition":"my","name":"$io","localvar":"my","kind":13,"containerName":"_parseASG","line":1065},{"localvar":"my","kind":13,"containerName":"_parseASG","name":"$file","line":1066,"definition":"my"},{"line":1066,"name":"$io","containerName":"_parseASG","kind":13},{"line":1066,"name":"_fh","containerName":"_parseASG","kind":12},{"definition":"my","containerName":"_parseASG","localvar":"my","kind":13,"name":"$cur","line":1067},{"line":1067,"containerName":"_parseASG","kind":13,"name":"$file"},{"name":"$bound_set","localvar":"my","kind":13,"containerName":"_parseASG","line":1068,"definition":"my"},{"name":"$ord_num","localvar":"my","containerName":"_parseASG","kind":13,"line":1069,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"_parseASG","name":"$chain","line":1070},{"line":1070,"name":"$last_chain","containerName":"_parseASG","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"_parseASG","name":"$element","line":1071},{"line":1072,"name":"%ASG","containerName":"_parseASG","localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"@cur","containerName":"_parseASG","localvar":"my","kind":13,"line":1073},{"line":1073,"containerName":"_parseASG","kind":13,"name":"@elements"},{"name":"@ASG_lookup","localvar":"my","containerName":"_parseASG","kind":13,"line":1074,"definition":"my"},{"line":1084,"name":"$cur","kind":13,"containerName":"_parseASG"},{"kind":13,"containerName":"_parseASG","name":"$cur","line":1085},{"name":"$file","containerName":"_parseASG","kind":13,"line":1085},{"line":1088,"name":"$cur","containerName":"_parseASG","kind":13},{"line":1090,"containerName":"_parseASG","kind":13,"name":"$ord_num"},{"containerName":"_parseASG","kind":13,"name":"$cur","line":1090},{"containerName":"_parseASG","kind":13,"name":"$ord_num","line":1091},{"kind":13,"containerName":"_parseASG","name":"$chain","line":1094},{"line":1094,"name":"$cur","kind":13,"containerName":"_parseASG"},{"name":"$last_chain","containerName":"_parseASG","kind":13,"line":1096},{"line":1096,"name":"$chain","containerName":"_parseASG","kind":13},{"name":"$last_chain","containerName":"_parseASG","kind":13,"line":1096},{"line":1097,"containerName":"_parseASG","kind":13,"name":"$ASG"},{"containerName":"_parseASG","kind":13,"name":"$last_chain","line":1097},{"line":1097,"kind":13,"containerName":"_parseASG","name":"@elements"},{"line":1098,"name":"@elements","kind":13,"containerName":"_parseASG"},{"line":1102,"name":"$bound_set","kind":13,"containerName":"_parseASG"},{"containerName":"_parseASG","kind":13,"name":"@ASG_lookup","line":1102},{"line":1103,"kind":13,"containerName":"_parseASG","name":"$element"},{"name":"$cur","kind":13,"containerName":"_parseASG","line":1103},{"name":"$bound_set","containerName":"_parseASG","kind":13,"line":1103},{"kind":13,"containerName":"_parseASG","name":"$bound_set","line":1104},{"name":"$element","containerName":"_parseASG","kind":13,"line":1105},{"name":"@cur","kind":13,"containerName":"_parseASG","line":1106},{"line":1106,"kind":13,"containerName":"_parseASG","name":"$element"},{"containerName":"_parseASG","kind":13,"name":"$elements","line":1108},{"line":1108,"name":"$ord_num","containerName":"_parseASG","kind":13},{"kind":13,"containerName":"_parseASG","name":"@cur","line":1108},{"line":1109,"containerName":"_parseASG","kind":13,"name":"$cur"},{"line":1109,"containerName":"_parseASG","kind":13,"name":"$file"},{"containerName":"_parseASG","kind":13,"name":"@cur","line":1110},{"name":"$last_chain","kind":13,"containerName":"_parseASG","line":1111},{"name":"$chain","kind":13,"containerName":"_parseASG","line":1111},{"name":"$ASG","containerName":"_parseASG","kind":13,"line":1114},{"name":"$chain","containerName":"_parseASG","kind":13,"line":1114},{"line":1114,"kind":13,"containerName":"_parseASG","name":"@elements"},{"line":1116,"name":"$self","containerName":"_parseASG","kind":13},{"name":"%ASG","containerName":"_parseASG","kind":13,"line":1116}],"name":"_parseASG","containerName":"main::"}]}