{"vars":[{"name":"base","containerName":"","kind":2,"line":82},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Entry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Structure::Entry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Kris Boulez <kris.boulez@algonomics.com>\n#\n# Copyright Kris Boulez\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Structure::Entry - Bioperl structure Object, describes the whole entry\n\n=head1 SYNOPSIS\n\n  #add synopsis here\n\n=head1 DESCRIPTION\n\nThis object stores a whole Bio::Structure entry. It can consist of one\nor more models (L<Bio::Structure::Model>), which in turn consist of one \nor more chains (L<Bio::Structure::Chain>). A chain is composed of residues \n(L<Bio::Structure::Residue>) and a residue consists of atoms \n(L<Bio::Structure::Atom>). If no specific model or chain is chosen, the \nfirst one is chosen.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Kris Boulez\n\nEmail kris.boulez@algonomics.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal \nmethods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Structure::Entry;\nuse strict;\n\nuse Bio::Structure::Model;\nuse Bio::Structure::Chain;\nuse Bio::Annotation::Collection;\nuse Tie::RefHash;\n\nuse base qw(Bio::Root::Root Bio::Structure::StructureI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $struc = Bio::Structure::Entry->new( \n                                           -id  => 'structure_id',\n                                           );\n\n Function: Returns a new Bio::Structure::Entry object from basic \n\t        constructors. Probably most called from Bio::Structure::IO.\n Returns : a new Bio::Structure::Model object"},"line":97,"range":{"end":{"character":9999,"line":113},"start":{"line":97,"character":0}},"kind":12,"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","name":"$class","localvar":"my","containerName":"new","kind":13,"line":98},{"line":98,"name":"@args","containerName":"new","kind":13},{"line":99,"name":"$self","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":99},{"line":99,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","name":"$id","kind":13,"localvar":"my","containerName":"new","line":101},{"line":101,"containerName":"new","kind":13,"name":"$model"},{"line":101,"kind":13,"containerName":"new","name":"$chain"},{"kind":13,"containerName":"new","name":"$residue","line":101},{"line":102,"name":"$self","containerName":"new","kind":13},{"name":"_rearrange","kind":12,"containerName":"new","line":102},{"kind":13,"containerName":"new","name":"@args","line":107},{"kind":13,"containerName":"new","name":"$self","line":112},{"containerName":"new","kind":13,"name":"$self","line":113}],"containerName":"main::","name":"new"},{"line":99,"name":"SUPER","containerName":"new","kind":12},{"line":116,"containerName":null,"kind":13,"name":"%self"},{"containerName":null,"kind":13,"name":"%self","line":117},{"line":119,"name":"$id","kind":13,"containerName":null},{"line":119,"name":"$self","containerName":null,"kind":13},{"name":"id","kind":12,"containerName":"main::","line":119},{"name":"$id","kind":13,"containerName":null,"line":119},{"containerName":null,"kind":13,"name":"%self","line":121},{"kind":13,"containerName":null,"name":"$model","line":122},{"line":122,"kind":13,"containerName":null,"name":"$self"},{"line":122,"name":"model","kind":12,"containerName":"main::"},{"line":122,"name":"$model","containerName":null,"kind":13},{"line":124,"name":"%chain","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$self","line":125},{"line":125,"containerName":"main::","kind":12,"name":"model"},{"line":126,"kind":13,"containerName":null,"name":"$self"},{"line":126,"containerName":"main::","kind":12,"name":"_create_default_model"},{"name":"$m","containerName":null,"localvar":"my","kind":13,"line":128,"definition":"my"},{"containerName":null,"kind":13,"name":"$self","line":128},{"line":128,"kind":12,"containerName":"main::","name":"model"},{"line":129,"name":"$m","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"chain","line":129},{"name":"$chain","containerName":null,"kind":13,"line":129},{"name":"$residue","kind":13,"containerName":null,"line":133},{"line":133,"name":"$self","kind":13,"containerName":null},{"line":133,"name":"residue","kind":12,"containerName":"main::"},{"name":"$residue","kind":13,"containerName":null,"line":133},{"line":136,"localvar":"my","kind":13,"containerName":null,"name":"$ann","definition":"my"},{"kind":12,"containerName":"Annotation::Collection","name":"Bio","line":136},{"line":136,"containerName":"main::","kind":12,"name":"new"},{"name":"$self","containerName":null,"kind":13,"line":137},{"name":"annotation","containerName":"main::","kind":12,"line":137},{"kind":13,"containerName":null,"name":"$ann","line":137},{"line":139,"name":"$self","containerName":null,"kind":13},{"line":154,"kind":12,"range":{"end":{"line":177,"character":9999},"start":{"line":154,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"$model"}],"documentation":"","label":"model($self,$model)"},"children":[{"definition":"my","line":155,"kind":13,"localvar":"my","containerName":"model","name":"$self"},{"line":155,"name":"$model","containerName":"model","kind":13},{"name":"$model","containerName":"model","kind":13,"line":157},{"line":158,"name":"$model","kind":13,"containerName":"model"},{"line":159,"name":"$model","containerName":"model","kind":13},{"line":159,"kind":12,"containerName":"model","name":"isa"},{"definition":"my","name":"@obj","containerName":"model","localvar":"my","kind":13,"line":161},{"name":"$self","containerName":"model","kind":13,"line":161},{"line":161,"kind":12,"containerName":"model","name":"model"},{"containerName":"model","kind":13,"name":"@obj","line":162},{"definition":"my","name":"$m","kind":13,"localvar":"my","containerName":"model","line":163},{"line":163,"name":"@obj","kind":13,"containerName":"model"},{"line":164,"containerName":"model","kind":13,"name":"$self"},{"line":164,"name":"_remove_from_graph","kind":12,"containerName":"model"},{"kind":13,"containerName":"model","name":"$m","line":164},{"containerName":"model","kind":13,"name":"$self","line":165},{"line":169,"name":"$self","kind":13,"containerName":"model"},{"line":169,"name":"add_model","kind":12,"containerName":"model"},{"kind":13,"containerName":"model","name":"$self","line":169},{"containerName":"model","kind":13,"name":"$model","line":169},{"name":"$self","containerName":"model","kind":13,"line":172},{"line":172,"name":"throw","containerName":"model","kind":12},{"line":176,"kind":13,"containerName":"model","name":"$self"},{"line":176,"containerName":"model","kind":12,"name":"get_models"},{"line":176,"kind":13,"containerName":"model","name":"$self"}],"containerName":"main::","name":"model","definition":"sub","detail":"($self,$model)"},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$entry"},{"label":"$model"}],"label":"add_model($self,$entry,$model)"},"kind":12,"range":{"end":{"line":220,"character":9999},"start":{"line":191,"character":0}},"line":191,"detail":"($self,$entry,$model)","definition":"sub","name":"add_model","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"add_model","name":"$self","line":192,"definition":"my"},{"line":192,"name":"$entry","kind":13,"containerName":"add_model"},{"containerName":"add_model","kind":13,"name":"$model","line":192},{"kind":13,"containerName":"add_model","name":"$model","line":196},{"line":196,"kind":13,"containerName":"add_model","name":"$entry"},{"line":197,"kind":13,"containerName":"add_model","name":"$model"},{"kind":13,"containerName":"add_model","name":"$entry","line":197},{"name":"$entry","containerName":"add_model","kind":13,"line":198},{"line":198,"kind":13,"containerName":"add_model","name":"$self"},{"kind":13,"containerName":"add_model","name":"$entry","line":201},{"line":201,"name":"$entry","kind":13,"containerName":"add_model"},{"containerName":"add_model","kind":13,"name":"$self","line":202},{"name":"throw","kind":12,"containerName":"add_model","line":202},{"name":"$model","kind":13,"containerName":"add_model","line":204},{"name":"$model","containerName":"add_model","kind":13,"line":205},{"line":207,"localvar":"my","containerName":"add_model","kind":13,"name":"$m","definition":"my"},{"kind":13,"containerName":"add_model","name":"$model","line":207},{"line":208,"containerName":"add_model","kind":13,"name":"$m"},{"line":208,"containerName":"add_model","kind":12,"name":"isa"},{"line":209,"containerName":"add_model","kind":13,"name":"$self"},{"line":209,"containerName":"add_model","kind":12,"name":"throw"},{"name":"$self","kind":13,"containerName":"add_model","line":211},{"line":211,"kind":12,"containerName":"add_model","name":"_parent"},{"line":211,"kind":13,"containerName":"add_model","name":"$m"},{"line":212,"containerName":"add_model","kind":13,"name":"$self"},{"containerName":"add_model","kind":12,"name":"throw","line":212},{"name":"$self","kind":13,"containerName":"add_model","line":214},{"line":214,"name":"$m","kind":13,"containerName":"add_model"}]},{"line":221,"name":"$model","kind":13,"containerName":null},{"name":"isa","containerName":"main::","kind":12,"line":221},{"name":"$self","kind":13,"containerName":null,"line":222},{"name":"_parent","containerName":"main::","kind":12,"line":222},{"line":222,"kind":13,"containerName":null,"name":"%model"},{"line":223,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"throw","line":223},{"line":225,"kind":13,"containerName":null,"name":"%self"},{"line":225,"kind":13,"containerName":null,"name":"%model"},{"kind":13,"containerName":null,"name":"$self","line":231},{"name":"throw","containerName":"main::","kind":12,"line":231},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$array_ref","line":235},{"line":235,"containerName":null,"kind":13,"name":"%self"},{"line":236,"containerName":null,"kind":13,"name":"$array_ref"},{"name":"$array_ref","containerName":null,"kind":13,"line":236},{"detail":"($self,$entry)","definition":"sub","containerName":"main::","name":"get_models","children":[{"line":251,"localvar":"my","kind":13,"containerName":"get_models","name":"$self","definition":"my"},{"line":251,"name":"$entry","kind":13,"containerName":"get_models"},{"line":254,"kind":13,"containerName":"get_models","name":"$entry"},{"line":255,"name":"$entry","kind":13,"containerName":"get_models"},{"line":255,"kind":13,"containerName":"get_models","name":"$self"},{"line":258,"kind":13,"containerName":"get_models","name":"$self"},{"kind":12,"containerName":"get_models","name":"add_model","line":258},{"name":"$entry","containerName":"get_models","kind":13,"line":258}],"signature":{"label":"get_models($self,$entry)","documentation":"","parameters":[{"label":"$self"},{"label":"$entry"}]},"range":{"end":{"line":259,"character":9999},"start":{"line":250,"character":0}},"kind":12,"line":250},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"id","children":[{"definition":"my","line":273,"localvar":"my","containerName":"id","kind":13,"name":"$self"},{"name":"$value","containerName":"id","kind":13,"line":273},{"name":"$value","kind":13,"containerName":"id","line":274},{"name":"$self","kind":13,"containerName":"id","line":275},{"line":275,"containerName":"id","kind":13,"name":"$value"},{"line":277,"name":"$self","kind":13,"containerName":"id"}],"signature":{"label":"id($self,$value)","documentation":"","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"start":{"character":0,"line":272},"end":{"character":9999,"line":278}},"kind":12,"line":272},{"children":[{"containerName":"chain","localvar":"my","kind":13,"name":"$self","line":292,"definition":"my"},{"line":292,"name":"$chain","kind":13,"containerName":"chain"},{"line":294,"name":"$self","containerName":"chain","kind":13},{"line":294,"kind":12,"containerName":"chain","name":"model"},{"line":295,"containerName":"chain","kind":13,"name":"$self"},{"line":295,"name":"_create_default_model","kind":12,"containerName":"chain"},{"definition":"my","line":297,"name":"@models","localvar":"my","containerName":"chain","kind":13},{"line":297,"name":"$self","containerName":"chain","kind":13},{"line":297,"kind":12,"containerName":"chain","name":"model"},{"definition":"my","localvar":"my","containerName":"chain","kind":13,"name":"$first_model","line":298},{"line":298,"kind":13,"containerName":"chain","name":"$models"},{"line":300,"kind":13,"containerName":"chain","name":"$chain"},{"line":302,"name":"$chain","containerName":"chain","kind":13},{"name":"$chain","kind":13,"containerName":"chain","line":302},{"line":302,"name":"isa","kind":12,"containerName":"chain"},{"line":304,"containerName":"chain","localvar":"my","kind":13,"name":"@obj","definition":"my"},{"line":304,"containerName":"chain","kind":13,"name":"$self"},{"line":304,"name":"get_chains","containerName":"chain","kind":12},{"containerName":"chain","kind":13,"name":"$first_model","line":304},{"line":305,"containerName":"chain","kind":13,"name":"@obj"},{"localvar":"my","containerName":"chain","kind":13,"name":"$c","line":306,"definition":"my"},{"containerName":"chain","kind":13,"name":"@obj","line":306},{"kind":13,"containerName":"chain","name":"$self","line":307},{"name":"_remove_from_graph","kind":12,"containerName":"chain","line":307},{"kind":13,"containerName":"chain","name":"$c","line":307},{"containerName":"chain","kind":13,"name":"$self","line":311},{"containerName":"chain","kind":12,"name":"add_chain","line":311},{"line":311,"containerName":"chain","kind":13,"name":"$first_model"},{"name":"$chain","containerName":"chain","kind":13,"line":311},{"line":314,"containerName":"chain","kind":13,"name":"$self"},{"line":314,"name":"throw","containerName":"chain","kind":12},{"name":"$self","kind":13,"containerName":"chain","line":317},{"kind":12,"containerName":"chain","name":"get_chains","line":317},{"containerName":"chain","kind":13,"name":"$first_model","line":317}],"containerName":"main::","name":"chain","definition":"sub","detail":"($self,$chain)","line":291,"kind":12,"range":{"end":{"line":318,"character":9999},"start":{"character":0,"line":291}},"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$chain"}],"label":"chain($self,$chain)"}},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$model"},{"label":"$chain"}],"label":"add_chain($self,$model,$chain)"},"range":{"end":{"line":368,"character":9999},"start":{"line":332,"character":0}},"kind":12,"line":332,"detail":"($self,$model,$chain)","definition":"sub","name":"add_chain","containerName":"main::","children":[{"line":333,"containerName":"add_chain","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$model","containerName":"add_chain","kind":13,"line":333},{"containerName":"add_chain","kind":13,"name":"$chain","line":333},{"containerName":"add_chain","kind":13,"name":"$model","line":335},{"line":336,"containerName":"add_chain","kind":13,"name":"$self"},{"line":336,"name":"throw","containerName":"add_chain","kind":12},{"line":338,"name":"$chain","kind":13,"containerName":"add_chain"},{"line":339,"kind":13,"containerName":"add_chain","name":"$chain"},{"name":"$c","localvar":"my","kind":13,"containerName":"add_chain","line":341,"definition":"my"},{"name":"$chain","containerName":"add_chain","kind":13,"line":341},{"line":342,"name":"$c","kind":13,"containerName":"add_chain"},{"line":342,"name":"isa","containerName":"add_chain","kind":12},{"line":343,"name":"$self","containerName":"add_chain","kind":13},{"line":343,"containerName":"add_chain","kind":12,"name":"throw"},{"name":"$self","containerName":"add_chain","kind":13,"line":345},{"name":"_parent","containerName":"add_chain","kind":12,"line":345},{"kind":13,"containerName":"add_chain","name":"$c","line":345},{"line":346,"kind":13,"containerName":"add_chain","name":"$self"},{"containerName":"add_chain","kind":12,"name":"throw","line":346},{"line":348,"name":"$self","kind":13,"containerName":"add_chain"},{"containerName":"add_chain","kind":12,"name":"_parent","line":348},{"name":"$c","kind":13,"containerName":"add_chain","line":348},{"line":348,"name":"$model","containerName":"add_chain","kind":13},{"line":349,"name":"$self","kind":13,"containerName":"add_chain"},{"name":"_child","containerName":"add_chain","kind":12,"line":349},{"containerName":"add_chain","kind":13,"name":"$model","line":349},{"line":349,"containerName":"add_chain","kind":13,"name":"$c"},{"kind":13,"containerName":"add_chain","name":"$chain","line":355},{"name":"isa","containerName":"add_chain","kind":12,"line":355},{"name":"$self","kind":13,"containerName":"add_chain","line":356},{"containerName":"add_chain","kind":12,"name":"_parent","line":356},{"kind":13,"containerName":"add_chain","name":"$chain","line":356},{"line":357,"kind":13,"containerName":"add_chain","name":"$self"},{"name":"throw","containerName":"add_chain","kind":12,"line":357},{"line":359,"kind":13,"containerName":"add_chain","name":"$self"},{"line":359,"name":"_parent","containerName":"add_chain","kind":12},{"kind":13,"containerName":"add_chain","name":"$chain","line":359},{"line":359,"kind":13,"containerName":"add_chain","name":"$model"},{"name":"$self","kind":13,"containerName":"add_chain","line":360},{"line":360,"name":"_child","containerName":"add_chain","kind":12},{"name":"$model","kind":13,"containerName":"add_chain","line":360},{"name":"$chain","containerName":"add_chain","kind":13,"line":360},{"line":366,"containerName":"add_chain","kind":13,"name":"$self"},{"line":366,"name":"throw","kind":12,"containerName":"add_chain"}]},{"definition":"my","line":369,"name":"$array_ref","localvar":"my","kind":13,"containerName":null},{"line":369,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"_child","line":369},{"name":"$model","kind":13,"containerName":null,"line":369},{"line":370,"name":"$array_ref","kind":13,"containerName":null},{"line":370,"containerName":null,"kind":13,"name":"$array_ref"},{"definition":"sub","detail":"($self,$model)","children":[{"definition":"my","line":385,"localvar":"my","containerName":"get_chains","kind":13,"name":"$self"},{"name":"$model","containerName":"get_chains","kind":13,"line":385},{"name":"$model","kind":13,"containerName":"get_chains","line":387},{"line":388,"name":"$model","containerName":"get_chains","kind":13},{"name":"$self","containerName":"get_chains","kind":13,"line":388},{"line":388,"name":"get_models","containerName":"get_chains","kind":12},{"kind":13,"containerName":"get_chains","name":"$self","line":391},{"line":391,"kind":12,"containerName":"get_chains","name":"add_chain"},{"containerName":"get_chains","kind":13,"name":"$model","line":391}],"name":"get_chains","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$model"}],"documentation":"","label":"get_chains($self,$model)"},"line":384,"kind":12,"range":{"end":{"line":392,"character":9999},"start":{"character":0,"line":384}}},{"detail":"($self,$residue)","definition":"sub","containerName":"main::","name":"residue","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"residue","name":"$self","line":406},{"name":"$residue","kind":13,"containerName":"residue","line":406},{"line":408,"name":"$self","containerName":"residue","kind":13},{"containerName":"residue","kind":12,"name":"model","line":408},{"name":"$m","localvar":"my","containerName":"residue","kind":13,"line":409,"definition":"my"},{"line":409,"kind":13,"containerName":"residue","name":"$self"},{"kind":12,"containerName":"residue","name":"_create_default_model","line":409},{"name":"$self","containerName":"residue","kind":13,"line":410},{"line":410,"name":"add_model","kind":12,"containerName":"residue"},{"line":410,"name":"$self","containerName":"residue","kind":13},{"line":410,"kind":13,"containerName":"residue","name":"$m"},{"definition":"my","name":"@models","containerName":"residue","localvar":"my","kind":13,"line":412},{"containerName":"residue","kind":13,"name":"$self","line":412},{"line":412,"kind":12,"containerName":"residue","name":"model"},{"line":413,"localvar":"my","containerName":"residue","kind":13,"name":"$first_model","definition":"my"},{"kind":13,"containerName":"residue","name":"$models","line":413},{"name":"$self","kind":13,"containerName":"residue","line":415},{"line":415,"containerName":"residue","kind":12,"name":"get_chains"},{"containerName":"residue","kind":13,"name":"$first_model","line":415},{"definition":"my","containerName":"residue","localvar":"my","kind":13,"name":"$c","line":416},{"kind":13,"containerName":"residue","name":"$self","line":416},{"line":416,"containerName":"residue","kind":12,"name":"_create_default_chain"},{"name":"$self","kind":13,"containerName":"residue","line":417},{"containerName":"residue","kind":12,"name":"add_chain","line":417},{"line":417,"name":"$first_model","containerName":"residue","kind":13},{"line":417,"containerName":"residue","kind":13,"name":"$c"},{"containerName":"residue","localvar":"my","kind":13,"name":"@chains","line":419,"definition":"my"},{"line":419,"name":"$self","kind":13,"containerName":"residue"},{"name":"get_chains","containerName":"residue","kind":12,"line":419},{"line":419,"name":"$first_model","kind":13,"containerName":"residue"},{"name":"$first_chain","kind":13,"localvar":"my","containerName":"residue","line":420,"definition":"my"},{"line":420,"kind":13,"containerName":"residue","name":"$chains"},{"name":"$residue","containerName":"residue","kind":13,"line":422},{"name":"$residue","kind":13,"containerName":"residue","line":423},{"name":"$residue","kind":13,"containerName":"residue","line":424},{"name":"isa","containerName":"residue","kind":12,"line":424},{"definition":"my","localvar":"my","kind":13,"containerName":"residue","name":"@obj","line":426},{"line":426,"name":"$self","kind":13,"containerName":"residue"},{"kind":12,"containerName":"residue","name":"get_residues","line":426},{"name":"$first_chain","containerName":"residue","kind":13,"line":426},{"kind":13,"containerName":"residue","name":"@obj","line":427},{"definition":"my","line":428,"name":"$r","containerName":"residue","localvar":"my","kind":13},{"kind":13,"containerName":"residue","name":"@obj","line":428},{"line":429,"kind":13,"containerName":"residue","name":"$self"},{"name":"_remove_from_graph","containerName":"residue","kind":12,"line":429},{"line":429,"containerName":"residue","kind":13,"name":"$r"},{"name":"$self","containerName":"residue","kind":13,"line":433},{"line":433,"containerName":"residue","kind":12,"name":"add_residue"},{"name":"$first_chain","containerName":"residue","kind":13,"line":433},{"line":433,"name":"$residue","containerName":"residue","kind":13},{"name":"$self","containerName":"residue","kind":13,"line":436},{"line":436,"name":"throw","kind":12,"containerName":"residue"},{"containerName":"residue","kind":13,"name":"$self","line":439},{"name":"get_residues","containerName":"residue","kind":12,"line":439},{"kind":13,"containerName":"residue","name":"$first_chain","line":439}],"signature":{"label":"residue($self,$residue)","parameters":[{"label":"$self"},{"label":"$residue"}],"documentation":""},"range":{"start":{"character":0,"line":405},"end":{"line":440,"character":9999}},"kind":12,"line":405},{"signature":{"parameters":[{"label":"$self"},{"label":"$chain"},{"label":"$residue"}],"documentation":"","label":"add_residue($self,$chain,$residue)"},"range":{"end":{"line":490,"character":9999},"start":{"character":0,"line":454}},"kind":12,"line":454,"detail":"($self,$chain,$residue)","definition":"sub","containerName":"main::","name":"add_residue","children":[{"line":455,"localvar":"my","containerName":"add_residue","kind":13,"name":"$self","definition":"my"},{"name":"$chain","containerName":"add_residue","kind":13,"line":455},{"containerName":"add_residue","kind":13,"name":"$residue","line":455},{"line":457,"name":"$chain","kind":13,"containerName":"add_residue"},{"line":458,"containerName":"add_residue","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"add_residue","line":458},{"containerName":"add_residue","kind":13,"name":"$residue","line":460},{"name":"$residue","kind":13,"containerName":"add_residue","line":461},{"definition":"my","containerName":"add_residue","localvar":"my","kind":13,"name":"$r","line":463},{"line":463,"containerName":"add_residue","kind":13,"name":"$residue"},{"containerName":"add_residue","kind":13,"name":"$r","line":464},{"line":464,"name":"isa","kind":12,"containerName":"add_residue"},{"line":465,"kind":13,"containerName":"add_residue","name":"$self"},{"name":"throw","containerName":"add_residue","kind":12,"line":465},{"name":"$self","containerName":"add_residue","kind":13,"line":467},{"line":467,"name":"_parent","containerName":"add_residue","kind":12},{"line":467,"kind":13,"containerName":"add_residue","name":"$r"},{"line":468,"name":"$self","kind":13,"containerName":"add_residue"},{"line":468,"containerName":"add_residue","kind":12,"name":"throw"},{"line":470,"kind":13,"containerName":"add_residue","name":"$self"},{"name":"_parent","containerName":"add_residue","kind":12,"line":470},{"containerName":"add_residue","kind":13,"name":"$r","line":470},{"containerName":"add_residue","kind":13,"name":"$chain","line":470},{"line":471,"name":"$self","containerName":"add_residue","kind":13},{"kind":12,"containerName":"add_residue","name":"_child","line":471},{"kind":13,"containerName":"add_residue","name":"$chain","line":471},{"containerName":"add_residue","kind":13,"name":"$r","line":471},{"name":"$str_ref","kind":13,"localvar":"my","containerName":"add_residue","line":473,"definition":"my"},{"kind":13,"containerName":"add_residue","name":"$r","line":474},{"line":474,"name":"_grandparent","kind":12,"containerName":"add_residue"},{"line":474,"name":"$str_ref","kind":13,"containerName":"add_residue"},{"line":477,"containerName":"add_residue","kind":13,"name":"$residue"},{"line":477,"name":"isa","kind":12,"containerName":"add_residue"},{"name":"$self","kind":13,"containerName":"add_residue","line":478},{"name":"_parent","kind":12,"containerName":"add_residue","line":478},{"name":"$residue","containerName":"add_residue","kind":13,"line":478},{"containerName":"add_residue","kind":13,"name":"$self","line":479},{"name":"throw","containerName":"add_residue","kind":12,"line":479},{"line":481,"name":"$self","kind":13,"containerName":"add_residue"},{"line":481,"kind":12,"containerName":"add_residue","name":"_parent"},{"line":481,"name":"$residue","kind":13,"containerName":"add_residue"},{"line":481,"containerName":"add_residue","kind":13,"name":"$chain"},{"line":482,"containerName":"add_residue","kind":13,"name":"$self"},{"kind":12,"containerName":"add_residue","name":"_child","line":482},{"name":"$chain","containerName":"add_residue","kind":13,"line":482},{"line":482,"kind":13,"containerName":"add_residue","name":"$residue"},{"definition":"my","line":484,"localvar":"my","containerName":"add_residue","kind":13,"name":"$str_ref"},{"line":485,"kind":13,"containerName":"add_residue","name":"$residue"},{"name":"_grandparent","containerName":"add_residue","kind":12,"line":485},{"line":485,"kind":13,"containerName":"add_residue","name":"$str_ref"},{"containerName":"add_residue","kind":13,"name":"$self","line":488},{"line":488,"kind":12,"containerName":"add_residue","name":"throw"}]},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$array_ref","line":491},{"containerName":null,"kind":13,"name":"$self","line":491},{"line":491,"name":"_child","kind":12,"containerName":"main::"},{"name":"$chain","kind":13,"containerName":null,"line":491},{"containerName":null,"kind":13,"name":"$array_ref","line":492},{"name":"$array_ref","containerName":null,"kind":13,"line":492},{"signature":{"label":"get_residues($self,$chain)","parameters":[{"label":"$self"},{"label":"$chain"}],"documentation":""},"kind":12,"range":{"start":{"character":0,"line":506},"end":{"character":9999,"line":514}},"line":506,"detail":"($self,$chain)","definition":"sub","containerName":"main::","name":"get_residues","children":[{"name":"$self","containerName":"get_residues","localvar":"my","kind":13,"line":507,"definition":"my"},{"line":507,"name":"$chain","containerName":"get_residues","kind":13},{"line":509,"name":"$chain","kind":13,"containerName":"get_residues"},{"containerName":"get_residues","kind":13,"name":"$self","line":510},{"line":510,"kind":12,"containerName":"get_residues","name":"throw"},{"line":513,"containerName":"get_residues","kind":13,"name":"$self"},{"line":513,"containerName":"get_residues","kind":12,"name":"add_residue"},{"line":513,"kind":13,"containerName":"get_residues","name":"$chain"}]},{"signature":{"parameters":[{"label":"$self"},{"label":"$residue"},{"label":"$atom"}],"documentation":"","label":"add_atom($self,$residue,$atom)"},"kind":12,"range":{"start":{"line":527,"character":0},"end":{"character":9999,"line":561}},"line":527,"detail":"($self,$residue,$atom)","definition":"sub","containerName":"main::","name":"add_atom","children":[{"definition":"my","localvar":"my","containerName":"add_atom","kind":13,"name":"$self","line":528},{"name":"$residue","kind":13,"containerName":"add_atom","line":528},{"line":528,"kind":13,"containerName":"add_atom","name":"$atom"},{"line":530,"containerName":"add_atom","kind":13,"name":"$residue"},{"containerName":"add_atom","kind":13,"name":"$self","line":531},{"line":531,"name":"throw","kind":12,"containerName":"add_atom"},{"name":"$atom","kind":13,"containerName":"add_atom","line":533},{"line":534,"name":"$atom","containerName":"add_atom","kind":13},{"name":"$a","kind":13,"localvar":"my","containerName":"add_atom","line":536,"definition":"my"},{"line":536,"name":"$atom","kind":13,"containerName":"add_atom"},{"line":537,"kind":13,"containerName":"add_atom","name":"$a"},{"kind":12,"containerName":"add_atom","name":"isa","line":537},{"kind":13,"containerName":"add_atom","name":"$self","line":538},{"containerName":"add_atom","kind":12,"name":"throw","line":538},{"line":540,"name":"$self","containerName":"add_atom","kind":13},{"name":"_parent","containerName":"add_atom","kind":12,"line":540},{"containerName":"add_atom","kind":13,"name":"$a","line":540},{"containerName":"add_atom","kind":13,"name":"$self","line":541},{"line":541,"name":"throw","kind":12,"containerName":"add_atom"},{"containerName":"add_atom","kind":13,"name":"$self","line":543},{"line":543,"kind":12,"containerName":"add_atom","name":"_parent"},{"kind":13,"containerName":"add_atom","name":"$a","line":543},{"line":543,"name":"$residue","containerName":"add_atom","kind":13},{"containerName":"add_atom","kind":13,"name":"$self","line":544},{"name":"_child","kind":12,"containerName":"add_atom","line":544},{"kind":13,"containerName":"add_atom","name":"$residue","line":544},{"line":544,"name":"$a","containerName":"add_atom","kind":13},{"kind":13,"containerName":"add_atom","name":"$atom","line":551},{"containerName":"add_atom","kind":13,"name":"$self","line":552},{"containerName":"add_atom","kind":12,"name":"_parent","line":552},{"line":552,"name":"$atom","kind":13,"containerName":"add_atom"},{"kind":13,"containerName":"add_atom","name":"$self","line":553},{"name":"throw","kind":12,"containerName":"add_atom","line":553},{"line":555,"name":"$self","containerName":"add_atom","kind":13},{"line":555,"kind":12,"containerName":"add_atom","name":"_parent"},{"name":"$atom","kind":13,"containerName":"add_atom","line":555},{"line":555,"containerName":"add_atom","kind":13,"name":"$residue"},{"line":556,"kind":13,"containerName":"add_atom","name":"$self"},{"name":"_child","kind":12,"containerName":"add_atom","line":556},{"name":"$residue","kind":13,"containerName":"add_atom","line":556},{"name":"$atom","kind":13,"containerName":"add_atom","line":556}]},{"name":"$array_ref","localvar":"my","kind":13,"containerName":null,"line":562,"definition":"my"},{"kind":13,"containerName":null,"name":"$self","line":562},{"name":"_child","kind":12,"containerName":"main::","line":562},{"line":562,"name":"$residue","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$array_ref","line":563},{"containerName":null,"kind":13,"name":"$array_ref","line":563},{"name":"get_atoms","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"get_atoms","localvar":"my","kind":13,"line":578},{"name":"$residue","kind":13,"containerName":"get_atoms","line":578},{"kind":13,"containerName":"get_atoms","name":"$residue","line":580},{"kind":13,"containerName":"get_atoms","name":"$self","line":581},{"name":"throw","kind":12,"containerName":"get_atoms","line":581},{"kind":13,"containerName":"get_atoms","name":"$self","line":584},{"kind":12,"containerName":"get_atoms","name":"add_atom","line":584},{"line":584,"name":"$residue","containerName":"get_atoms","kind":13}],"detail":"($self,$residue)","definition":"sub","kind":12,"range":{"start":{"line":577,"character":0},"end":{"character":9999,"line":585}},"line":577,"signature":{"label":"get_atoms($self,$residue)","parameters":[{"label":"$self"},{"label":"$residue"}],"documentation":""}},{"range":{"start":{"character":0,"line":608},"end":{"line":611,"character":9999}},"kind":12,"line":608,"definition":"sub","name":"connect","containerName":"main::","children":[{"definition":"my","line":609,"localvar":"my","containerName":"connect","kind":13,"name":"$self"},{"name":"$self","containerName":"connect","kind":13,"line":610},{"line":610,"kind":12,"containerName":"connect","name":"conect"}]},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$source"},{"label":"$serial"},{"label":"$type"}],"label":"conect($self,$source,$serial,$type)"},"line":625,"kind":12,"range":{"start":{"line":625,"character":0},"end":{"character":9999,"line":633}},"definition":"sub","detail":"($self,$source,$serial,$type)","children":[{"kind":13,"localvar":"my","containerName":"conect","name":"$self","line":626,"definition":"my"},{"name":"$source","kind":13,"containerName":"conect","line":626},{"containerName":"conect","kind":13,"name":"$serial","line":626},{"line":626,"containerName":"conect","kind":13,"name":"$type"},{"line":628,"containerName":"conect","kind":13,"name":"$source"},{"line":629,"name":"$self","kind":13,"containerName":"conect"},{"line":629,"kind":12,"containerName":"conect","name":"throw"},{"kind":13,"containerName":"conect","name":"$serial","line":631},{"line":631,"name":"$type","kind":13,"containerName":"conect"},{"line":632,"name":"$self","kind":13,"containerName":"conect"},{"line":632,"name":"$source","containerName":"conect","kind":13},{"line":633,"name":"$self","containerName":"conect","kind":13}],"name":"conect","containerName":"main::"},{"name":"%source","containerName":null,"kind":13,"line":633},{"name":"%self","containerName":null,"kind":13,"line":634},{"line":634,"kind":13,"containerName":null,"name":"@source"},{"kind":13,"localvar":"my","containerName":null,"name":"$c","line":637,"definition":"my"},{"line":637,"kind":13,"containerName":null,"name":"$serial"},{"containerName":null,"kind":13,"name":"$type","line":637},{"name":"%self","containerName":null,"kind":13,"line":638},{"name":"$source","kind":13,"containerName":null,"line":638},{"name":"$c","containerName":null,"kind":13,"line":638},{"line":641,"containerName":null,"kind":13,"name":"%self"},{"line":641,"name":"$source","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":642},{"name":"$source","containerName":null,"kind":13,"line":642},{"line":643,"containerName":null,"kind":13,"name":"%self"},{"name":"$source","containerName":null,"kind":13,"line":643},{"name":"get_all_connect_source","containerName":"main::","children":[{"line":657,"localvar":"my","kind":13,"containerName":"get_all_connect_source","name":"$self","definition":"my"}],"definition":"sub","kind":12,"range":{"end":{"line":659,"character":9999},"start":{"line":656,"character":0}},"line":656},{"name":"get_all_conect_source","kind":12,"line":658},{"children":[{"definition":"my","line":676,"name":"$self","localvar":"my","kind":13,"containerName":"get_all_conect_source"},{"line":677,"name":"@sources","localvar":"my","kind":13,"containerName":"get_all_conect_source","definition":"my"},{"name":"$source","localvar":"my","kind":13,"containerName":"get_all_conect_source","line":679,"definition":"my"},{"kind":13,"containerName":"get_all_conect_source","name":"$a","line":679},{"line":679,"name":"$b","kind":13,"containerName":"get_all_conect_source"},{"containerName":"get_all_conect_source","kind":13,"name":"$self","line":679}],"name":"get_all_conect_source","containerName":"main::","definition":"sub","line":675,"range":{"end":{"character":9999,"line":679},"start":{"line":675,"character":0}},"kind":12},{"name":"@sources","containerName":null,"kind":13,"line":680},{"line":680,"kind":13,"containerName":null,"name":"$source"},{"line":682,"kind":13,"containerName":null,"name":"@sources"},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"","label":"master($self,$value)"},"line":696,"kind":12,"range":{"start":{"line":696,"character":0},"end":{"character":9999,"line":702}},"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"master","line":697},{"containerName":"master","kind":13,"name":"$value","line":697},{"kind":13,"containerName":"master","name":"$value","line":698},{"line":699,"name":"$self","kind":13,"containerName":"master"},{"containerName":"master","kind":13,"name":"$value","line":699},{"line":701,"containerName":"master","kind":13,"name":"$self"}],"containerName":"main::","name":"master"},{"definition":"sub","detail":"($self,$chainid)","children":[{"definition":"my","line":718,"localvar":"my","containerName":"seqres","kind":13,"name":"$self"},{"line":718,"kind":13,"containerName":"seqres","name":"$chainid"},{"name":"$s_u","containerName":"seqres","localvar":"my","kind":13,"line":719,"definition":"my"},{"definition":"my","line":720,"kind":13,"localvar":"my","containerName":"seqres","name":"%seq_ch"},{"kind":13,"containerName":"seqres","name":"$chainid","line":721},{"definition":"my","line":722,"localvar":"my","containerName":"seqres","kind":13,"name":"$m"},{"line":722,"containerName":"seqres","kind":13,"name":"$self"},{"line":722,"containerName":"seqres","kind":12,"name":"get_models"},{"line":722,"name":"$self","containerName":"seqres","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"seqres","name":"$c","line":723},{"containerName":"seqres","kind":13,"name":"$self","line":723},{"kind":12,"containerName":"seqres","name":"get_chains","line":723},{"line":723,"name":"$m","kind":13,"containerName":"seqres"},{"containerName":"seqres","kind":13,"name":"$chainid","line":724},{"name":"$c","containerName":"seqres","kind":13,"line":724},{"line":724,"kind":12,"containerName":"seqres","name":"id"},{"definition":"my","line":726,"kind":13,"localvar":"my","containerName":"seqres","name":"$seqres"},{"line":726,"name":"$self","kind":13,"containerName":"seqres"},{"name":"annotation","containerName":"seqres","kind":12,"line":726},{"line":726,"containerName":"seqres","kind":12,"name":"get_Annotations"},{"line":727,"name":"$seqres_string","localvar":"my","containerName":"seqres","kind":13,"definition":"my"},{"line":727,"name":"$seqres","containerName":"seqres","kind":13},{"line":727,"kind":12,"containerName":"seqres","name":"as_text"},{"line":728,"containerName":"seqres","kind":13,"name":"$self"},{"line":728,"name":"debug","containerName":"seqres","kind":12},{"line":729,"name":"$seqres_string","containerName":"seqres","kind":13},{"definition":"my","line":731,"name":"@l","localvar":"my","containerName":"seqres","kind":13},{"line":731,"name":"$seqres_string","containerName":"seqres","kind":13},{"containerName":"seqres","kind":13,"name":"$seqres_string","line":731},{"containerName":"seqres","localvar":"my","kind":13,"name":"$line","line":732,"definition":"my"},{"line":732,"containerName":"seqres","kind":13,"name":"@l"},{"definition":"my","name":"$chid","localvar":"my","containerName":"seqres","kind":13,"line":735},{"line":735,"containerName":"seqres","kind":13,"name":"$seq"},{"name":"$line","kind":13,"containerName":"seqres","line":735},{"name":"$chid","kind":13,"containerName":"seqres","line":736},{"line":737,"name":"$chid","kind":13,"containerName":"seqres"},{"containerName":"seqres","kind":13,"name":"$seq","line":739},{"line":740,"name":"$seq","kind":13,"containerName":"seqres"},{"kind":13,"containerName":"seqres","name":"$seq_ch","line":741},{"containerName":"seqres","kind":13,"name":"$chid","line":741},{"kind":13,"containerName":"seqres","name":"$seq","line":741},{"name":"$self","containerName":"seqres","kind":13,"line":742},{"line":742,"kind":12,"containerName":"seqres","name":"debug"},{"name":"$seq_ch","containerName":"seqres","kind":13,"line":745},{"line":745,"name":"$chainid","containerName":"seqres","kind":13},{"line":746,"containerName":"seqres","kind":13,"name":"$self"},{"name":"warn","containerName":"seqres","kind":12,"line":746},{"definition":"my","line":751,"name":"$pseq","kind":13,"localvar":"my","containerName":"seqres"},{"containerName":"seqres","kind":12,"name":"new","line":751},{"line":752,"name":"$pseq","containerName":"seqres","kind":13},{"name":"seq3in","kind":12,"containerName":"seqres","line":752},{"name":"$pseq","kind":13,"containerName":"seqres","line":752},{"containerName":"seqres","kind":13,"name":"$seq_ch","line":752},{"line":752,"name":"$chainid","kind":13,"containerName":"seqres"},{"definition":"my","name":"$id","containerName":"seqres","localvar":"my","kind":13,"line":753},{"name":"$self","kind":13,"containerName":"seqres","line":753},{"line":753,"kind":12,"containerName":"seqres","name":"id"},{"line":753,"name":"$chainid","kind":13,"containerName":"seqres"},{"line":754,"containerName":"seqres","kind":13,"name":"$pseq"},{"line":754,"name":"id","containerName":"seqres","kind":12},{"line":754,"name":"$id","containerName":"seqres","kind":13},{"containerName":"seqres","kind":13,"name":"$pseq","line":755}],"containerName":"main::","name":"seqres","signature":{"label":"seqres($self,$chainid)","documentation":"","parameters":[{"label":"$self"},{"label":"$chainid"}]},"line":717,"kind":12,"range":{"start":{"line":717,"character":0},"end":{"character":9999,"line":756}}},{"containerName":"PrimarySeq","kind":12,"name":"Bio","line":751},{"line":752,"name":"Bio","kind":12,"containerName":"SeqUtils"},{"signature":{"label":"get_atom_by_serial($self,$model,$serial)","documentation":"","parameters":[{"label":"$self"},{"label":"$model"},{"label":"$serial"}]},"range":{"start":{"line":770,"character":0},"end":{"line":793,"character":9999}},"kind":12,"line":770,"detail":"($self,$model,$serial)","definition":"sub","containerName":"main::","name":"get_atom_by_serial","children":[{"definition":"my","line":771,"localvar":"my","kind":13,"containerName":"get_atom_by_serial","name":"$self"},{"name":"$model","kind":13,"containerName":"get_atom_by_serial","line":771},{"name":"$serial","kind":13,"containerName":"get_atom_by_serial","line":771},{"line":773,"name":"$model","kind":13,"containerName":"get_atom_by_serial"},{"kind":13,"containerName":"get_atom_by_serial","name":"$serial","line":773},{"name":"$serial","containerName":"get_atom_by_serial","kind":13,"line":774},{"containerName":"get_atom_by_serial","kind":13,"name":"$model","line":774},{"definition":"my","name":"@m","localvar":"my","containerName":"get_atom_by_serial","kind":13,"line":775},{"line":775,"containerName":"get_atom_by_serial","kind":13,"name":"$self"},{"line":775,"name":"get_models","kind":12,"containerName":"get_atom_by_serial"},{"line":775,"containerName":"get_atom_by_serial","kind":13,"name":"$self"},{"name":"$model","containerName":"get_atom_by_serial","kind":13,"line":776},{"line":776,"name":"$m","containerName":"get_atom_by_serial","kind":13},{"containerName":"get_atom_by_serial","kind":13,"name":"$model","line":778},{"containerName":"get_atom_by_serial","kind":13,"name":"$model","line":778},{"name":"$self","containerName":"get_atom_by_serial","kind":13,"line":779},{"line":779,"name":"throw","containerName":"get_atom_by_serial","kind":12},{"containerName":"get_atom_by_serial","kind":13,"name":"$serial","line":781},{"line":781,"name":"$serial","kind":13,"containerName":"get_atom_by_serial"},{"name":"$self","containerName":"get_atom_by_serial","kind":13,"line":782},{"line":782,"name":"throw","containerName":"get_atom_by_serial","kind":12},{"definition":"my","localvar":"my","containerName":"get_atom_by_serial","kind":13,"name":"$chain","line":784},{"name":"$self","kind":13,"containerName":"get_atom_by_serial","line":784},{"name":"get_chains","kind":12,"containerName":"get_atom_by_serial","line":784},{"line":784,"kind":13,"containerName":"get_atom_by_serial","name":"$model"},{"line":785,"name":"$residue","containerName":"get_atom_by_serial","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"get_atom_by_serial","name":"$self","line":785},{"name":"get_residues","containerName":"get_atom_by_serial","kind":12,"line":785},{"line":785,"kind":13,"containerName":"get_atom_by_serial","name":"$chain"},{"definition":"my","localvar":"my","kind":13,"containerName":"get_atom_by_serial","name":"$atom","line":786},{"name":"$self","kind":13,"containerName":"get_atom_by_serial","line":786},{"line":786,"containerName":"get_atom_by_serial","kind":12,"name":"get_atoms"},{"name":"$residue","kind":13,"containerName":"get_atom_by_serial","line":786},{"name":"$atom","kind":13,"containerName":"get_atom_by_serial","line":788},{"kind":12,"containerName":"get_atom_by_serial","name":"serial","line":788},{"line":788,"name":"$serial","kind":13,"containerName":"get_atom_by_serial"},{"name":"$atom","kind":13,"containerName":"get_atom_by_serial","line":789}]},{"range":{"end":{"character":9999,"line":804},"start":{"line":795,"character":0}},"kind":12,"line":795,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$obj"}],"label":"parent($self,$obj)"},"containerName":"main::","name":"parent","children":[{"definition":"my","line":796,"localvar":"my","containerName":"parent","kind":13,"name":"$self"},{"line":796,"name":"$obj","kind":13,"containerName":"parent"},{"name":"$obj","kind":13,"containerName":"parent","line":798},{"line":799,"kind":13,"containerName":"parent","name":"$self"},{"name":"throw","kind":12,"containerName":"parent","line":799},{"line":803,"kind":13,"containerName":"parent","name":"$self"},{"containerName":"parent","kind":12,"name":"_parent","line":803},{"kind":13,"containerName":"parent","name":"$obj","line":803}],"detail":"($self,$obj)","definition":"sub"},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"DESTROY","line":807,"definition":"my"},{"line":809,"name":"$self","containerName":"DESTROY","kind":13}],"name":"DESTROY","containerName":"main::","definition":"sub","line":806,"kind":12,"range":{"end":{"character":9999,"line":809},"start":{"character":0,"line":806}}},{"line":810,"kind":13,"containerName":null,"name":"%self"},{"signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"","label":"annotation($obj,$value)"},"line":824,"kind":12,"range":{"end":{"character":9999,"line":830},"start":{"line":824,"character":0}},"definition":"sub","detail":"($obj,$value)","children":[{"definition":"my","line":825,"name":"$obj","kind":13,"localvar":"my","containerName":"annotation"},{"line":825,"name":"$value","containerName":"annotation","kind":13},{"kind":13,"containerName":"annotation","name":"$value","line":826},{"containerName":"annotation","kind":13,"name":"$obj","line":827},{"line":827,"containerName":"annotation","kind":13,"name":"$value"},{"line":829,"containerName":"annotation","kind":13,"name":"$obj"}],"containerName":"main::","name":"annotation"},{"containerName":"main::","name":"_remove_models","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_remove_models","name":"$self","line":851}],"definition":"sub","kind":12,"range":{"end":{"line":854,"character":9999},"start":{"character":0,"line":850}},"line":850},{"kind":12,"range":{"end":{"character":9999,"line":873},"start":{"character":0,"line":868}},"line":868,"containerName":"main::","name":"_create_default_model","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_create_default_model","kind":13,"line":869},{"containerName":"_create_default_model","localvar":"my","kind":13,"name":"$model","line":871,"definition":"my"},{"kind":12,"containerName":"_create_default_model","name":"new","line":871},{"line":872,"kind":13,"containerName":"_create_default_model","name":"$model"}],"definition":"sub"},{"name":"Bio","containerName":"Structure::Model","kind":12,"line":871},{"line":887,"range":{"start":{"character":0,"line":887},"end":{"line":892,"character":9999}},"kind":12,"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_create_default_chain","line":888,"definition":"my"},{"line":890,"containerName":"_create_default_chain","localvar":"my","kind":13,"name":"$chain","definition":"my"},{"line":890,"containerName":"_create_default_chain","kind":12,"name":"new"},{"kind":13,"containerName":"_create_default_chain","name":"$chain","line":891}],"name":"_create_default_chain","containerName":"main::","definition":"sub"},{"line":890,"name":"Bio","containerName":"Structure::Chain","kind":12},{"definition":"sub","detail":"($self,$key,$value)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_parent","line":917},{"name":"$key","containerName":"_parent","kind":13,"line":917},{"line":917,"containerName":"_parent","kind":13,"name":"$value"},{"name":"$key","kind":13,"containerName":"_parent","line":919},{"line":919,"name":"$key","containerName":"_parent","kind":13},{"name":"$self","kind":13,"containerName":"_parent","line":920},{"line":920,"kind":12,"containerName":"_parent","name":"throw"},{"line":922,"name":"$value","kind":13,"containerName":"_parent"},{"line":922,"name":"$value","containerName":"_parent","kind":13},{"containerName":"_parent","kind":13,"name":"$self","line":923},{"line":923,"name":"throw","kind":12,"containerName":"_parent"},{"line":927,"name":"$value","containerName":"_parent","kind":13},{"name":"$self","kind":13,"containerName":"_parent","line":929},{"name":"$key","containerName":"_parent","kind":13,"line":929},{"kind":13,"containerName":"_parent","name":"$self","line":930},{"kind":13,"containerName":"_parent","name":"$key","line":930},{"line":932,"containerName":"_parent","kind":13,"name":"$self"},{"line":932,"kind":12,"containerName":"_parent","name":"throw"},{"kind":13,"containerName":"_parent","name":"$self","line":934},{"line":934,"name":"$key","containerName":"_parent","kind":13},{"name":"$value","containerName":"_parent","kind":13,"line":934}],"containerName":"main::","name":"_parent","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}],"label":"_parent($self,$key,$value)"},"line":915,"kind":12,"range":{"end":{"line":935,"character":9999},"start":{"line":915,"character":0}}},{"line":916,"kind":12,"name":"strict"},{"line":936,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"kind":13,"name":"$key","line":936},{"detail":"($self,$key,$value)","definition":"sub","name":"_child","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_child","line":959},{"line":959,"name":"$key","kind":13,"containerName":"_child"},{"name":"$value","kind":13,"containerName":"_child","line":959},{"line":961,"name":"$key","kind":13,"containerName":"_child"},{"kind":13,"containerName":"_child","name":"$key","line":961},{"kind":13,"containerName":"_child","name":"$self","line":962},{"kind":12,"containerName":"_child","name":"throw","line":962},{"line":964,"kind":13,"containerName":"_child","name":"$value"},{"line":964,"name":"$value","kind":13,"containerName":"_child"},{"containerName":"_child","kind":13,"name":"$self","line":965},{"name":"throw","kind":12,"containerName":"_child","line":965},{"line":969,"kind":13,"containerName":"_child","name":"$value"},{"line":970,"kind":13,"containerName":"_child","name":"$self"},{"kind":13,"containerName":"_child","name":"$key","line":970},{"line":970,"name":"$self","containerName":"_child","kind":13}],"signature":{"parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}],"documentation":"","label":"_child($self,$key,$value)"},"range":{"end":{"character":9999,"line":970},"start":{"line":958,"character":0}},"kind":12,"line":958},{"line":970,"name":"%key","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%self","line":971},{"containerName":null,"kind":13,"name":"@key","line":971},{"line":973,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"kind":13,"name":"$key","line":973},{"name":"$value","containerName":null,"kind":13,"line":973},{"line":975,"containerName":null,"kind":13,"name":"%self"},{"kind":13,"containerName":null,"name":"$key","line":975},{"signature":{"label":"_remove_from_graph($self,$object)","parameters":[{"label":"$self"},{"label":"$object"}],"documentation":""},"line":990,"range":{"start":{"character":0,"line":990},"end":{"line":1002,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$object)","children":[{"containerName":"_remove_from_graph","localvar":"my","kind":13,"name":"$self","line":991,"definition":"my"},{"line":991,"kind":13,"containerName":"_remove_from_graph","name":"$object"},{"name":"$object","containerName":"_remove_from_graph","kind":13,"line":993},{"line":993,"kind":13,"containerName":"_remove_from_graph","name":"$object"},{"line":994,"name":"$self","containerName":"_remove_from_graph","kind":13},{"name":"throw","kind":12,"containerName":"_remove_from_graph","line":994},{"line":996,"name":"$self","kind":13,"containerName":"_remove_from_graph"},{"name":"_parent","kind":12,"containerName":"_remove_from_graph","line":996},{"line":996,"containerName":"_remove_from_graph","kind":13,"name":"$object"},{"line":997,"localvar":"my","kind":13,"containerName":"_remove_from_graph","name":"$dad","definition":"my"},{"name":"$self","kind":13,"containerName":"_remove_from_graph","line":997},{"line":997,"name":"_parent","containerName":"_remove_from_graph","kind":12},{"name":"$object","kind":13,"containerName":"_remove_from_graph","line":997},{"definition":"my","localvar":"my","kind":13,"containerName":"_remove_from_graph","name":"$k","line":999},{"line":999,"containerName":"_remove_from_graph","kind":13,"name":"$self"},{"name":"_child","containerName":"_remove_from_graph","kind":12,"line":999},{"name":"$dad","containerName":"_remove_from_graph","kind":13,"line":999},{"line":1000,"kind":13,"containerName":"_remove_from_graph","name":"$object"},{"containerName":"_remove_from_graph","kind":13,"name":"$self","line":1000},{"containerName":"_remove_from_graph","kind":13,"name":"$dad","line":1000},{"line":1000,"kind":13,"containerName":"_remove_from_graph","name":"$k"},{"name":"$self","containerName":"_remove_from_graph","kind":13,"line":1001},{"line":1001,"kind":13,"containerName":"_remove_from_graph","name":"$dad"},{"line":1001,"containerName":"_remove_from_graph","kind":13,"name":"$k"}],"containerName":"main::","name":"_remove_from_graph"},{"name":"%self","kind":13,"containerName":null,"line":1004},{"name":"$object","kind":13,"containerName":null,"line":1004},{"line":1009,"kind":12,"range":{"end":{"line":1012,"character":9999},"start":{"character":0,"line":1009}},"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_print_stats_pc($self)"},"children":[{"line":1011,"name":"$self","localvar":"my","kind":13,"containerName":"_print_stats_pc","definition":"my"},{"definition":"my","localvar":"my","containerName":"_print_stats_pc","kind":13,"name":"$pc","line":1012},{"kind":13,"containerName":"_print_stats_pc","name":"$self","line":1012}],"name":"_print_stats_pc","containerName":"main::","definition":"sub","detail":"($self)"},{"line":1013,"name":"$cp","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":1013,"name":"%self","containerName":null,"kind":13},{"containerName":null,"localvar":"my","kind":13,"name":"$now_time","line":1014,"definition":"my"},{"line":1014,"containerName":"HiRes::time","kind":12,"name":"Time"},{"line":1015,"kind":13,"containerName":null,"name":"$self"},{"name":"debug","kind":12,"containerName":"main::","line":1015}],"version":5}