{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":110},{"kind":12,"range":{"start":{"character":0,"line":123},"end":{"line":138,"character":9999}},"line":123,"signature":{"documentation":"1;\n#-----------------------------------------------------------------------------\n# PACKAGE : Bio::SeqIO::tab\n# AUTHOR  : Philip Lijnzaad <p.lijnzaad@med.uu.nl>\n# CREATED : Feb 6 2003\n# REVISION: $Id: tab.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) This module is free software; you can redistribute it\n# and/or modify it under the same terms as Perl itself.\n#\n# _History_\n#\n# Ewan Birney <birney@ebi.ac.uk> developed the SeqIO\n# schema and the first prototype modules.\n#\n# This code is based on his Bio::SeqIO::raw\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tab - nearly raw sequence file input/output\nstream. Reads/writes id\"\\t\"sequence\"\\n\"\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::SeqIO> class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from tabbed flat\nfile databases.\n\nIt is very useful when doing large scale stuff using the Unix command\nline utilities (grep, sort, awk, sed, split, you name it). Imagine\nthat you have a format converter 'seqconvert' along the following\nlines:\n\n  my $in  = Bio::SeqIO->newFh(-fh => \\*STDIN , '-format' => $from);\n  my $out = Bio::SeqIO->newFh(-fh=> \\*STDOUT, '-format' => $to);\n  print $out $_ while <$in>;\n\nthen you can very easily filter sequence files for duplicates as:\n\n  $ seqconvert < foo.fa -from fasta -to tab | sort -u |\\\n       seqconvert -from tab -to fasta > foo-unique.fa\n\nOr grep [-v] for certain sequences with:\n\n  $ seqconvert < foo.fa -from fasta -to tab | grep -v '^S[a-z]*control' |\\\n       seqconvert -from tab -to fasta > foo-without-controls.fa\n\nOr chop up a huge file with sequences into smaller chunks with:\n\n  $ seqconvert < all.fa -from fasta -to tab | split -l 10 - chunk-\n  $ for i in chunk-*; do seqconvert -from tab -to fasta < $i > $i.fa; done\n  # (this creates files chunk-aa.fa, chunk-ab.fa, ..., each containing 10\n  # sequences)\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHORS\n\nPhilip Lijnzaad, p.lijnzaad@med.uu.nl\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::tab;\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::SeqIO);\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_seq($self,@args)"},"name":"next_seq","containerName":"main::","children":[{"line":124,"name":"$self","localvar":"my","kind":13,"containerName":"next_seq","definition":"my"},{"kind":13,"containerName":"next_seq","name":"@args","line":124},{"definition":"my","localvar":"my","kind":13,"containerName":"next_seq","name":"$nextline","line":128},{"containerName":"next_seq","kind":13,"name":"$self","line":128},{"name":"_readline","containerName":"next_seq","kind":12,"line":128},{"line":129,"kind":13,"containerName":"next_seq","name":"$nextline"},{"line":129,"name":"$nextline","kind":13,"containerName":"next_seq"},{"kind":13,"containerName":"next_seq","name":"$nextline","line":130},{"line":131,"containerName":"next_seq","kind":13,"name":"$nextline"},{"line":132,"name":"$id","localvar":"my","kind":13,"containerName":"next_seq","definition":"my"},{"name":"$seq","kind":13,"containerName":"next_seq","line":132},{"line":133,"name":"$seq","kind":13,"containerName":"next_seq"},{"line":134,"name":"new","containerName":"next_seq","kind":12},{"line":134,"name":"$id","kind":13,"containerName":"next_seq"},{"line":134,"name":"$seq","kind":13,"containerName":"next_seq"},{"line":136,"name":"$self","kind":13,"containerName":"next_seq"},{"name":"throw","containerName":"next_seq","kind":12,"line":136}],"detail":"($self,@args)","definition":"sub"},{"containerName":"Seq","kind":12,"name":"Bio","line":134},{"definition":"sub","detail":"($self,@seq)","children":[{"line":152,"name":"$self","containerName":"write_seq","localvar":"my","kind":13,"definition":"my"},{"name":"@seq","kind":13,"containerName":"write_seq","line":152},{"kind":13,"containerName":"write_seq","name":"@seq","line":153},{"kind":12,"containerName":"write_seq","name":"display_id","line":154},{"line":155,"name":"$self","containerName":"write_seq","kind":13},{"line":155,"name":"throw","containerName":"write_seq","kind":12},{"name":"display_id","containerName":"write_seq","kind":12,"line":155},{"line":157,"name":"$self","containerName":"write_seq","kind":13},{"line":157,"name":"_print","kind":12,"containerName":"write_seq"},{"kind":12,"containerName":"write_seq","name":"display_id","line":157},{"line":157,"name":"seq","containerName":"write_seq","kind":12},{"name":"$self","kind":13,"containerName":"write_seq","line":160},{"line":160,"name":"flush","kind":12,"containerName":"write_seq"},{"line":160,"name":"$self","kind":13,"containerName":"write_seq"},{"line":160,"name":"_flush_on_write","kind":12,"containerName":"write_seq"},{"line":160,"containerName":"write_seq","kind":13,"name":"$self"},{"line":160,"kind":12,"containerName":"write_seq","name":"_fh"}],"name":"write_seq","containerName":"main::","signature":{"label":"write_seq($self,@seq)","documentation":"1;\n#-----------------------------------------------------------------------------\n# PACKAGE : Bio::SeqIO::tab\n# AUTHOR  : Philip Lijnzaad <p.lijnzaad@med.uu.nl>\n# CREATED : Feb 6 2003\n# REVISION: $Id: tab.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) This module is free software; you can redistribute it\n# and/or modify it under the same terms as Perl itself.\n#\n# _History_\n#\n# Ewan Birney <birney@ebi.ac.uk> developed the SeqIO\n# schema and the first prototype modules.\n#\n# This code is based on his Bio::SeqIO::raw\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tab - nearly raw sequence file input/output\nstream. Reads/writes id\"\\t\"sequence\"\\n\"\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::SeqIO> class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from tabbed flat\nfile databases.\n\nIt is very useful when doing large scale stuff using the Unix command\nline utilities (grep, sort, awk, sed, split, you name it). Imagine\nthat you have a format converter 'seqconvert' along the following\nlines:\n\n  my $in  = Bio::SeqIO->newFh(-fh => \\*STDIN , '-format' => $from);\n  my $out = Bio::SeqIO->newFh(-fh=> \\*STDOUT, '-format' => $to);\n  print $out $_ while <$in>;\n\nthen you can very easily filter sequence files for duplicates as:\n\n  $ seqconvert < foo.fa -from fasta -to tab | sort -u |\\\n       seqconvert -from tab -to fasta > foo-unique.fa\n\nOr grep [-v] for certain sequences with:\n\n  $ seqconvert < foo.fa -from fasta -to tab | grep -v '^S[a-z]*control' |\\\n       seqconvert -from tab -to fasta > foo-without-controls.fa\n\nOr chop up a huge file with sequences into smaller chunks with:\n\n  $ seqconvert < all.fa -from fasta -to tab | split -l 10 - chunk-\n  $ for i in chunk-*; do seqconvert -from tab -to fasta < $i > $i.fa; done\n  # (this creates files chunk-aa.fa, chunk-ab.fa, ..., each containing 10\n  # sequences)\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHORS\n\nPhilip Lijnzaad, p.lijnzaad@med.uu.nl\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::tab;\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::SeqIO);\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\n\nsub next_seq{\n   my ($self,@args) = @_;\n   ## When its 1 sequence per line with no formatting at all,\n   ## grabbing it should be easy :)\n\n   my $nextline = $self->_readline();\n   chomp($nextline) if defined $nextline;\n   return unless defined $nextline;\n   if ($nextline =~ /^([^\\t]*)\\t(.*)/) {\n       my ($id, $seq)=($1, uc($2));\n       $seq =~ s/\\W//g;\n       return  Bio::Seq->new(-display_id=> $id, -seq => $seq);\n   }  else {\n       $self->throw(\"Can't parse tabbed sequence entry:'$nextline' around line $.\");\n   }\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Seq object","parameters":[{"label":"$self"},{"label":"@seq"}]},"line":151,"kind":12,"range":{"end":{"line":162,"character":9999},"start":{"line":151,"character":0}}}]}