{"version":5,"vars":[{"line":85,"containerName":"","kind":2,"name":"base"},{"name":"next_seq","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"next_seq","kind":13,"line":102,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"next_seq","name":"$state","line":104},{"definition":"my","containerName":"next_seq","localvar":"my","kind":13,"name":"@comment","line":105},{"line":106,"containerName":"next_seq","localvar":"my","kind":13,"name":"@sequence","definition":"my"},{"definition":"my","name":"$line","localvar":"my","containerName":"next_seq","kind":13,"line":108},{"name":"$self","kind":13,"containerName":"next_seq","line":108},{"name":"_readline","kind":12,"containerName":"next_seq","line":108},{"name":"$state","kind":13,"containerName":"next_seq","line":109},{"line":109,"name":"$state","containerName":"next_seq","kind":13},{"containerName":"next_seq","kind":13,"name":"$line","line":110},{"line":111,"containerName":"next_seq","kind":13,"name":"$line"},{"line":113,"name":"$line","containerName":"next_seq","kind":13},{"line":114,"containerName":"next_seq","kind":13,"name":"$state"},{"kind":13,"containerName":"next_seq","name":"$state","line":115},{"kind":13,"containerName":"next_seq","name":"$state","line":117},{"line":118,"containerName":"next_seq","kind":13,"name":"@comment"},{"line":118,"kind":13,"containerName":"next_seq","name":"$line"},{"kind":13,"containerName":"next_seq","name":"$state","line":120},{"kind":13,"containerName":"next_seq","name":"@sequence","line":121},{"line":122,"name":"$line","kind":13,"containerName":"next_seq"},{"line":124,"kind":13,"containerName":"next_seq","name":"$self"},{"line":124,"name":"throw","kind":12,"containerName":"next_seq"},{"line":129,"kind":13,"containerName":"next_seq","name":"$state"},{"line":132,"name":"$state","containerName":"next_seq","kind":13},{"kind":13,"containerName":"next_seq","name":"$self","line":133},{"name":"throw","containerName":"next_seq","kind":12,"line":133},{"line":136,"name":"$sequence","containerName":"next_seq","localvar":"my","kind":13,"definition":"my"},{"name":"@sequence","containerName":"next_seq","kind":13,"line":136},{"line":138,"containerName":"next_seq","kind":13,"name":"$sequence"},{"line":138,"kind":13,"containerName":"next_seq","name":"$self"},{"kind":12,"containerName":"next_seq","name":"throw","line":138},{"definition":"my","line":139,"localvar":"my","kind":13,"containerName":"next_seq","name":"$seq"},{"kind":12,"containerName":"next_seq","name":"new","line":139},{"kind":13,"containerName":"next_seq","name":"$sequence","line":139},{"definition":"my","kind":13,"localvar":"my","containerName":"next_seq","name":"$comment","line":141},{"kind":13,"containerName":"next_seq","name":"@comment","line":141},{"localvar":"my","containerName":"next_seq","kind":13,"name":"$anno","line":143,"definition":"my"},{"line":143,"kind":12,"containerName":"next_seq","name":"new"},{"kind":13,"containerName":"next_seq","name":"$anno","line":144},{"line":144,"kind":12,"containerName":"next_seq","name":"add_Annotation"},{"line":144,"name":"new","containerName":"next_seq","kind":12},{"containerName":"next_seq","kind":13,"name":"$comment","line":144},{"line":145,"name":"$seq","kind":13,"containerName":"next_seq"},{"line":145,"name":"annotation","kind":12,"containerName":"next_seq"},{"line":145,"name":"$anno","containerName":"next_seq","kind":13},{"name":"$seq","containerName":"next_seq","kind":13,"line":147}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":101},"end":{"line":148,"character":9999}},"line":101,"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"next_seq($self)"}},{"name":"Comment","kind":2,"containerName":"Bio::Seq::Bio::Annotation::Collection::Bio::Annotation","line":102},{"name":"Bio","containerName":"Seq","kind":12,"line":139},{"line":143,"name":"Bio","containerName":"Annotation::Collection","kind":12},{"line":144,"name":"Bio","kind":12,"containerName":"Annotation::Comment"},{"detail":"($self,@seq)","definition":"sub","containerName":"main::","name":"write_seq","children":[{"line":161,"kind":13,"localvar":"my","containerName":"write_seq","name":"$self","definition":"my"},{"line":161,"kind":13,"containerName":"write_seq","name":"@seq"},{"name":"$self","containerName":"write_seq","kind":13,"line":162},{"line":162,"name":"throw","containerName":"write_seq","kind":12}],"signature":{"label":"write_seq($self,@seq)","documentation":"1;\n#-----------------------------------------5~------------------------------------\n# PACKAGE : Bio::SeqIO::lasergene\n# AUTHOR  : Malcolm Cook <mec@stowers-institute.org>\n# CREATED : Feb 16 1999\n# REVISION: $Id: lasergene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# _History_\n#\n# This code is based on the Bio::SeqIO::raw module with\n# the necessary minor tweaks necessary to get it to read (only)\n# Lasergene formatted sequences\n#\n# Cleaned up by Torsten Seemann June 2006\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::lasergene - Lasergene sequence file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::SeqIO> class.\n\n=head1 DESCRIPTION\n\nThis object can product Bio::Seq::RichSeq objects from Lasergene sequence files.\n\nIT DOES NOT PARSE ANY ATTIBUTE VALUE PAIRS IN THE HEADER OF THE LASERGENE FORMATTED FILE.\n\nIT DOES NOT WRITE THESE FILES EITHER.\n\n=head1 REFERENCES\n\n  https://www.dnastar.com/products/lasergene.php\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHORS\n\n  Torsten Seemann - torsten.seemann AT infotech.monash.edu.au\n  Malcolm Cook  - mec AT stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::lasergene;\n\nuse strict;\n\nuse base qw(Bio::SeqIO);\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    : none\n\n\nuse Bio::Seq;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\n\nsub next_seq {\n   my ($self) = @_;\n\n   my $state = 0;\n   my @comment;\n   my @sequence;\n\n   while (my $line = $self->_readline) {\n     $state = 1 if $state == 0;\n     chomp $line;\n     next if $line =~ m/^\\s*$/; # skip blank lines\n\n     if ($line eq '^^') {  # end of a comment or sequence\n       $state++;\n       last if $state > 2; # we have comment and sequence so exit\n     }\n     elsif ($state == 1) { # another piece of comment\n       push @comment, $line;\n     }\n     elsif ($state == 2) { # another piece of sequence\n       push @sequence, $line\n     }\n     else {\n       $self->throw(\"unreachable state reached, probable bug!\");\n     }\n   }\n\n   # return quietly if there was nothing in the file\n   return if $state == 0;\n\n   # ensure we read some comment and some sequence\n   if ($state < 2) {\n     $self->throw(\"unexpected end of file\");\n   }\n\n   my $sequence = join('', @sequence);\n#   print STDERR \"SEQ=[[$sequence]]\\n\";\n   $sequence or $self->throw(\"empty sequence in lasergene file\");\n   my $seq = Bio::Seq->new(-seq => $sequence);\n\n   my $comment = join('; ', @comment);\n#   print STDERR \"COM=[[$comment]]\\n\";\n   my $anno = Bio::Annotation::Collection->new;\n   $anno->add_Annotation('comment', Bio::Annotation::Comment->new(-text => $comment) );\n   $seq->annotation($anno);\n\n   return $seq;\n}\n\n=head2 write_seq (NOT IMPLEMENTED)\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Array of Bio::PrimarySeqI objects","parameters":[{"label":"$self"},{"label":"@seq"}]},"range":{"start":{"line":160,"character":0},"end":{"character":9999,"line":163}},"kind":12,"line":160}]}