{"version":5,"vars":[{"line":85,"name":"vars","containerName":"","kind":2},{"kind":13,"containerName":null,"name":"$FASTALINELEN","line":90},{"line":90,"name":"SeqFactory","kind":2,"containerName":"strict::Bio::Seq"},{"line":91,"kind":2,"containerName":"","name":"base"},{"definition":"sub","detail":"($self,@args)","children":[{"localvar":"my","kind":13,"containerName":"_initialize","name":"$self","line":94,"definition":"my"},{"containerName":"_initialize","kind":13,"name":"@args","line":94},{"name":"$self","kind":13,"containerName":"_initialize","line":95},{"kind":13,"containerName":"_initialize","name":"@args","line":95},{"name":"$self","containerName":"_initialize","kind":13,"line":96},{"line":96,"name":"sequence_factory","kind":12,"containerName":"_initialize"},{"line":97,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"sequence_factory","kind":12,"containerName":"_initialize","line":97},{"line":98,"name":"new","containerName":"_initialize","kind":12},{"kind":13,"containerName":"_initialize","name":"$self","line":98},{"name":"verbose","containerName":"_initialize","kind":12,"line":98}],"name":"_initialize","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize($self,@args)"},"line":93,"range":{"end":{"line":101,"character":9999},"start":{"character":0,"line":93}},"kind":12},{"name":"SUPER","containerName":"_initialize","kind":12,"line":95},{"line":97,"kind":12,"containerName":"Seq::SeqFactory","name":"Bio"},{"range":{"end":{"character":9999,"line":142},"start":{"character":0,"line":113}},"kind":12,"line":113,"signature":{"label":"next_seq($self)","documentation":"1;\n# $Id: largefasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::largefasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# \n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::largefasta - method i/o on very large fasta sequence files\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from fasta flat\nfile databases.\n\nThis module handles very large sequence files by using the\nBio::Seq::LargePrimarySeq module to store all the sequence data in\na file.  This can be a problem if you have limited disk space on your\ncomputer because this will effectively cause 2 copies of the sequence\nfile to reside on disk for the life of the\nBio::Seq::LargePrimarySeq object.  The default location for this is\nspecified by the L<File::Spec>-E<gt>tmpdir routine which is usually /tmp\non UNIX.  If a sequence file is larger than the swap space (capacity\nof the /tmp dir) this could cause problems for the machine.  It is\npossible to set the directory where the temporary file is located by\nadding the following line to your code BEFORE calling next_seq. See\nL<Bio::Seq::LargePrimarySeq> for more information.\n\n    $Bio::Seq::LargePrimarySeq::DEFAULT_TEMP_DIR = 'newdir';\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Jason Stajich\n\nEmail: jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::largefasta;\nuse vars qw($FASTALINELEN);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\n$FASTALINELEN = 60;\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);    \n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(), \n\t\t\t       -type => 'Bio::Seq::LargePrimarySeq'));      \n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : A Bio::Seq::LargePrimarySeq object\n Args    : NONE","parameters":[{"label":"$self"}]},"containerName":"main::","name":"next_seq","children":[{"line":114,"containerName":"next_seq","localvar":"my","kind":13,"name":"$self","definition":"my"},{"definition":"my","name":"$largeseq","localvar":"my","kind":13,"containerName":"next_seq","line":116},{"name":"$self","kind":13,"containerName":"next_seq","line":116},{"name":"sequence_factory","kind":12,"containerName":"next_seq","line":116},{"line":116,"name":"create","kind":12,"containerName":"next_seq"},{"localvar":"my","kind":13,"containerName":"next_seq","name":"$id","line":117,"definition":"my"},{"line":117,"name":"$fulldesc","kind":13,"containerName":"next_seq"},{"line":117,"name":"$entry","containerName":"next_seq","kind":13},{"definition":"my","name":"$count","kind":13,"localvar":"my","containerName":"next_seq","line":118},{"containerName":"next_seq","localvar":"my","kind":13,"name":"$seen","line":119,"definition":"my"},{"name":"$entry","kind":13,"containerName":"next_seq","line":120},{"containerName":"next_seq","kind":13,"name":"$self","line":120},{"containerName":"next_seq","kind":12,"name":"_readline","line":120},{"containerName":"next_seq","kind":13,"name":"$seen","line":121},{"name":"$entry","kind":13,"containerName":"next_seq","line":121},{"kind":13,"containerName":"next_seq","name":"$self","line":122},{"line":122,"name":"_pushback","containerName":"next_seq","kind":12},{"name":"$entry","containerName":"next_seq","kind":13,"line":122},{"line":123,"name":"$largeseq","kind":13,"containerName":"next_seq"},{"line":126,"kind":13,"containerName":"next_seq","name":"$entry"},{"line":126,"name":"$seen","kind":13,"containerName":"next_seq"},{"name":"$entry","kind":13,"containerName":"next_seq","line":127},{"kind":13,"containerName":"next_seq","name":"$seen","line":128},{"line":129,"name":"$id","kind":13,"containerName":"next_seq"},{"line":129,"name":"$fulldesc","containerName":"next_seq","kind":13},{"name":"$self","containerName":"next_seq","kind":13,"line":130},{"line":130,"kind":12,"containerName":"next_seq","name":"warn"},{"line":131,"containerName":"next_seq","kind":13,"name":"$largeseq"},{"line":131,"name":"display_id","containerName":"next_seq","kind":12},{"kind":13,"containerName":"next_seq","name":"$id","line":131},{"line":132,"name":"$largeseq","containerName":"next_seq","kind":13},{"line":132,"containerName":"next_seq","kind":12,"name":"primary_id"},{"name":"$id","containerName":"next_seq","kind":13,"line":132},{"containerName":"next_seq","kind":13,"name":"$largeseq","line":133},{"name":"desc","kind":12,"containerName":"next_seq","line":133},{"line":133,"name":"$fulldesc","kind":13,"containerName":"next_seq"},{"line":135,"name":"$entry","containerName":"next_seq","kind":13},{"line":136,"name":"$largeseq","kind":13,"containerName":"next_seq"},{"line":136,"name":"add_sequence_as_string","kind":12,"containerName":"next_seq"},{"kind":13,"containerName":"next_seq","name":"$entry","line":136},{"line":138,"containerName":"next_seq","kind":13,"name":"$count"},{"line":138,"name":"$self","kind":13,"containerName":"next_seq"},{"name":"verbose","containerName":"next_seq","kind":12,"line":138},{"line":140,"containerName":"next_seq","kind":13,"name":"$seen"},{"containerName":"next_seq","kind":13,"name":"$largeseq","line":141}],"detail":"($self)","definition":"sub"},{"children":[{"line":156,"containerName":"write_seq","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":156,"kind":13,"containerName":"write_seq","name":"@seq"},{"definition":"my","localvar":"my","kind":13,"containerName":"write_seq","name":"$seq","line":157},{"line":157,"name":"@seq","containerName":"write_seq","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"write_seq","name":"$top","line":158},{"line":158,"kind":13,"containerName":"write_seq","name":"$seq"},{"kind":12,"containerName":"write_seq","name":"id","line":158},{"line":159,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":159,"name":"can","containerName":"write_seq","kind":12},{"definition":"my","line":159,"kind":13,"localvar":"my","containerName":"write_seq","name":"$desc"},{"line":159,"kind":13,"containerName":"write_seq","name":"$seq"},{"name":"desc","kind":12,"containerName":"write_seq","line":159},{"containerName":"write_seq","kind":13,"name":"$desc","line":160},{"kind":13,"containerName":"write_seq","name":"$top","line":161},{"line":163,"containerName":"write_seq","kind":13,"name":"$self"},{"line":163,"kind":12,"containerName":"write_seq","name":"_print"},{"line":163,"name":"$top","kind":13,"containerName":"write_seq"},{"definition":"my","line":164,"containerName":"write_seq","localvar":"my","kind":13,"name":"$end"},{"kind":13,"containerName":"write_seq","name":"$seq","line":164},{"name":"length","containerName":"write_seq","kind":12,"line":164},{"name":"$start","localvar":"my","containerName":"write_seq","kind":13,"line":165,"definition":"my"},{"kind":13,"containerName":"write_seq","name":"$start","line":166},{"line":166,"name":"$end","kind":13,"containerName":"write_seq"},{"name":"$stop","containerName":"write_seq","localvar":"my","kind":13,"line":167,"definition":"my"},{"name":"$start","containerName":"write_seq","kind":13,"line":167},{"line":167,"name":"$FASTALINELEN","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":13,"name":"$stop","line":168},{"containerName":"write_seq","kind":13,"name":"$end","line":168},{"line":168,"name":"$stop","kind":13,"containerName":"write_seq"},{"line":168,"name":"$end","kind":13,"containerName":"write_seq"},{"kind":13,"containerName":"write_seq","name":"$self","line":169},{"name":"_print","containerName":"write_seq","kind":12,"line":169},{"line":169,"containerName":"write_seq","kind":13,"name":"$seq"},{"line":169,"kind":12,"containerName":"write_seq","name":"subseq"},{"name":"$start","containerName":"write_seq","kind":13,"line":169},{"line":169,"containerName":"write_seq","kind":13,"name":"$stop"},{"name":"$start","containerName":"write_seq","kind":13,"line":170},{"line":170,"containerName":"write_seq","kind":13,"name":"$FASTALINELEN"},{"line":174,"name":"$self","kind":13,"containerName":"write_seq"},{"line":174,"kind":12,"containerName":"write_seq","name":"flush"},{"name":"$self","containerName":"write_seq","kind":13,"line":174},{"name":"_flush_on_write","kind":12,"containerName":"write_seq","line":174},{"line":174,"name":"$self","containerName":"write_seq","kind":13},{"name":"_fh","kind":12,"containerName":"write_seq","line":174}],"name":"write_seq","containerName":"main::","definition":"sub","detail":"($self,@seq)","line":155,"kind":12,"range":{"start":{"character":0,"line":155},"end":{"character":9999,"line":176}},"signature":{"label":"write_seq($self,@seq)","parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"1;\n# $Id: largefasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::largefasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# \n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::largefasta - method i/o on very large fasta sequence files\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from fasta flat\nfile databases.\n\nThis module handles very large sequence files by using the\nBio::Seq::LargePrimarySeq module to store all the sequence data in\na file.  This can be a problem if you have limited disk space on your\ncomputer because this will effectively cause 2 copies of the sequence\nfile to reside on disk for the life of the\nBio::Seq::LargePrimarySeq object.  The default location for this is\nspecified by the L<File::Spec>-E<gt>tmpdir routine which is usually /tmp\non UNIX.  If a sequence file is larger than the swap space (capacity\nof the /tmp dir) this could cause problems for the machine.  It is\npossible to set the directory where the temporary file is located by\nadding the following line to your code BEFORE calling next_seq. See\nL<Bio::Seq::LargePrimarySeq> for more information.\n\n    $Bio::Seq::LargePrimarySeq::DEFAULT_TEMP_DIR = 'newdir';\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Jason Stajich\n\nEmail: jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::largefasta;\nuse vars qw($FASTALINELEN);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\n$FASTALINELEN = 60;\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);    \n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(), \n\t\t\t       -type => 'Bio::Seq::LargePrimarySeq'));      \n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : A Bio::Seq::LargePrimarySeq object\n Args    : NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n#  local $/ = \"\\n\";\n    my $largeseq = $self->sequence_factory->create();\n    my ($id,$fulldesc,$entry);\n    my $count = 0;\n    my $seen = 0;\n    while( defined ($entry = $self->_readline) ) {\n\tif( $seen == 1 && $entry =~ /^\\s*>/ ) {\n\t    $self->_pushback($entry);\n\t    return $largeseq;\n\t}\n#\tif ( ($entry eq '>') || eof($self->_fh) ) { $seen = 1; next; }      \n\tif ( ($entry eq '>')  ) { $seen = 1; next; }      \n\telsif( $entry =~ /\\s*>(.+?)$/ ) {\n\t    $seen = 1;\n\t    ($id,$fulldesc) = ($1 =~ /^\\s*(\\S+)\\s*(.*)$/)\n\t\tor $self->warn(\"Can't parse fasta header\");\n\t    $largeseq->display_id($id);\n\t    $largeseq->primary_id($id);\t  \n\t    $largeseq->desc($fulldesc);\n\t} else {\n\t    $entry =~ s/\\s+//g;\n\t    $largeseq->add_sequence_as_string($entry);\n\t}\n\t(++$count % 1000 == 0 && $self->verbose() > 0) && print \"line $count\\n\";\n    }\n    return unless $seen;\n    return $largeseq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Seq object"}}]}