{"vars":[{"line":78,"containerName":"","kind":2,"name":"vars"},{"name":"base","containerName":"","kind":2,"line":80},{"containerName":"main::","name":"new","children":[{"definition":"my","name":"$caller","kind":13,"localvar":"my","containerName":"new","line":96},{"name":"$seq","kind":13,"containerName":"new","line":96},{"line":96,"containerName":"new","kind":13,"name":"$seq_h"},{"name":"$ann_l","kind":13,"containerName":"new","line":96},{"line":97,"localvar":"my","kind":13,"containerName":"new","name":"$class","definition":"my"},{"line":97,"containerName":"new","kind":13,"name":"$caller"},{"line":97,"kind":13,"containerName":"new","name":"$caller"},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":99},{"kind":13,"containerName":"new","name":"$seq","line":100},{"line":103,"containerName":"new","kind":13,"name":"$seq_h"},{"line":104,"name":"$ann_l","containerName":"new","kind":13},{"name":"$class","kind":13,"containerName":"new","line":105},{"kind":13,"containerName":"new","name":"$self","line":107}],"detail":"($caller,$seq,$seq_h,$ann_l)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":108},"start":{"line":95,"character":0}},"line":95,"signature":{"label":"new($caller,$seq,$seq_h,$ann_l)","parameters":[{"label":"$caller"},{"label":"$seq"},{"label":"$seq_h"},{"label":"$ann_l"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations"}},{"kind":12,"name":"seq","line":100},{"name":"curr_feats","kind":12,"line":101},{"name":"curr_coords","kind":12,"line":102},{"line":103,"name":"seq_h","kind":12},{"line":104,"kind":12,"name":"ann_l"},{"signature":{"parameters":[{"label":"$self"},{"label":"$length"},{"label":"$tags"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes","label":"add_source($self,$length,$tags)"},"line":120,"kind":12,"range":{"end":{"line":126,"character":9999},"start":{"line":120,"character":0}},"definition":"sub","detail":"($self,$length,$tags)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"add_source","line":121},{"name":"$length","kind":13,"containerName":"add_source","line":121},{"line":121,"name":"$tags","kind":13,"containerName":"add_source"},{"definition":"my","name":"$feat","localvar":"my","containerName":"add_source","kind":13,"line":122},{"line":122,"name":"new","containerName":"add_source","kind":12},{"kind":13,"containerName":"add_source","name":"$length","line":124},{"line":126,"kind":13,"containerName":"add_source","name":"$tags"}],"containerName":"main::","name":"add_source"},{"line":122,"name":"Bio","containerName":"SeqFeature::Generic","kind":12},{"definition":"my","name":"$val","localvar":"my","kind":13,"containerName":null,"line":127},{"line":127,"name":"%tags","kind":13,"containerName":null},{"line":128,"name":"$feat","kind":13,"containerName":null},{"line":128,"kind":12,"containerName":"main::","name":"add_tag_value"},{"line":128,"name":"$val","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$feat","line":132},{"line":148,"range":{"start":{"line":148,"character":0},"end":{"character":9999,"line":185}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$gene"},{"label":"$gname"},{"label":"$id"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)","label":"has_gene($self,$gene,$gname,$id)"},"children":[{"line":149,"containerName":"has_gene","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":149,"containerName":"has_gene","kind":13,"name":"$gene"},{"name":"$gname","containerName":"has_gene","kind":13,"line":149},{"name":"$id","containerName":"has_gene","kind":13,"line":149},{"line":156,"containerName":"has_gene","kind":13,"name":"$gene"},{"line":157,"kind":13,"containerName":"has_gene","name":"$self"},{"containerName":"has_gene","kind":13,"name":"$self","line":158},{"containerName":"has_gene","kind":13,"name":"$id","line":165},{"line":165,"kind":13,"containerName":"has_gene","name":"$self"},{"line":166,"name":"$self","kind":13,"containerName":"has_gene"},{"line":166,"name":"$id","kind":13,"containerName":"has_gene"},{"kind":13,"containerName":"has_gene","name":"$gname","line":168},{"line":168,"name":"$self","containerName":"has_gene","kind":13},{"line":169,"kind":13,"containerName":"has_gene","name":"$self"},{"name":"$gname","containerName":"has_gene","kind":13,"line":169},{"definition":"my","name":"$tags","kind":13,"localvar":"my","containerName":"has_gene","line":172},{"line":174,"localvar":"my","containerName":"has_gene","kind":13,"name":"$child","definition":"my"},{"name":"$gene","containerName":"has_gene","kind":13,"line":174},{"name":"$name","containerName":"has_gene","localvar":"my","kind":13,"line":175,"definition":"my"},{"kind":13,"containerName":"has_gene","name":"$child","line":175},{"containerName":"has_gene","kind":13,"name":"$name","line":177},{"name":"$tags","kind":13,"containerName":"has_gene","line":178},{"line":179,"containerName":"has_gene","kind":13,"name":"$tags"},{"line":179,"name":"$self","kind":13,"containerName":"has_gene"},{"name":"dbxref","kind":12,"containerName":"has_gene","line":179},{"line":179,"name":"$child","kind":13,"containerName":"has_gene"},{"line":181,"containerName":"has_gene","kind":13,"name":"$name"},{"containerName":"has_gene","kind":13,"name":"$self","line":182},{"name":"complain","containerName":"has_gene","kind":12,"line":182}],"containerName":"main::","name":"has_gene","definition":"sub","detail":"($self,$gene,$gname,$id)"},{"name":"curr_gene","kind":12,"line":157},{"kind":12,"name":"curr_gene","line":158},{"line":165,"name":"curr_ltag","kind":12},{"name":"curr_ltag","kind":12,"line":166},{"line":168,"name":"curr_gname","kind":12},{"line":169,"name":"curr_gname","kind":12},{"line":174,"kind":12,"name":"Children"},{"line":175,"kind":12,"name":"Name"},{"kind":12,"name":"dbxref","line":178},{"kind":12,"name":"dbxref","line":179},{"line":187,"kind":13,"localvar":"my","containerName":null,"name":"$feat","definition":"my"},{"name":"Bio","kind":12,"containerName":"SeqFeature::Generic","line":187},{"line":187,"containerName":"main::","kind":12,"name":"new"},{"line":190,"name":"%seen","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"kind":13,"containerName":null,"name":"%tags","line":191},{"line":192,"containerName":null,"localvar":"my","kind":13,"name":"$val","definition":"my"},{"containerName":null,"kind":13,"name":"%tags","line":192},{"name":"$feat","kind":13,"containerName":null,"line":193},{"containerName":"main::","kind":12,"name":"add_tag_value","line":193},{"line":193,"name":"$val","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%seen","line":193},{"name":"$val","containerName":null,"kind":13,"line":193},{"line":197,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"name":"curr_gene","line":197},{"containerName":null,"kind":13,"name":"$feat","line":197},{"kind":13,"containerName":null,"name":"$feat","line":198},{"definition":"sub","detail":"($self,$transcript)","children":[{"line":213,"name":"$self","localvar":"my","containerName":"_has_CDS","kind":13,"definition":"my"},{"line":213,"name":"$transcript","kind":13,"containerName":"_has_CDS"},{"line":215,"containerName":"_has_CDS","kind":13,"name":"$transcript"},{"name":"$self","containerName":"_has_CDS","kind":13,"line":216},{"name":"$self","containerName":"_has_CDS","kind":13,"line":217},{"line":224,"name":"$tags","containerName":"_has_CDS","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_has_CDS","name":"$self","line":224},{"name":"$self","containerName":"_has_CDS","kind":13,"line":225},{"line":225,"name":"$self","kind":13,"containerName":"_has_CDS"},{"containerName":"_has_CDS","kind":12,"name":"_add_CDS","line":225},{"containerName":"_has_CDS","kind":13,"name":"$transcript","line":225},{"line":225,"kind":13,"containerName":"_has_CDS","name":"$tags"}],"containerName":"main::","name":"_has_CDS","signature":{"label":"_has_CDS($self,$transcript)","parameters":[{"label":"$self"},{"label":"$transcript"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature"},"line":212,"range":{"start":{"character":0,"line":212},"end":{"line":227,"character":9999}},"kind":12},{"name":"curr_cds","kind":12,"line":216},{"line":217,"kind":12,"name":"curr_cds"},{"line":224,"name":"curr_tags","kind":12},{"kind":12,"name":"curr_cds","line":225},{"signature":{"parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$type"},{"label":"$id"},{"label":"$tags"},{"label":"$feats"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature\n\n\nsub _has_CDS {\n    my ($self, $transcript) = @_;\n\n    if ( !$transcript ) {\n\tif ( defined $self->{curr_cds} ) {\n\t    return $self->{curr_cds};\n        }\n\telse {\n\t    return 0;\n\t}\n    }\n    else {\n\tmy $tags = $self->{curr_tags};\n\t$self->{curr_cds} = $self->_add_CDS( $transcript, $tags );\n    }\n}\n\n=head2 add_annotation\n\n Title   : add_annotation\n Usage   : $featHandler->add_annotation($seq, $type, $id, $tags, $feats)\n Function: converts a containment hierarchy into an ordered list of flat features\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects","label":"add_annotation($self,$seq,$type,$id,$tags,$feats)"},"kind":12,"range":{"start":{"line":243,"character":0},"end":{"line":269,"character":9999}},"line":243,"detail":"($self,$seq,$type,$id,$tags,$feats)","definition":"sub","containerName":"main::","name":"add_annotation","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"add_annotation","name":"$self","line":244},{"name":"$seq","kind":13,"containerName":"add_annotation","line":244},{"name":"$type","kind":13,"containerName":"add_annotation","line":244},{"line":244,"name":"$id","containerName":"add_annotation","kind":13},{"name":"$tags","kind":13,"containerName":"add_annotation","line":244},{"line":244,"name":"$feats","containerName":"add_annotation","kind":13},{"containerName":"add_annotation","kind":13,"name":"$self","line":247},{"containerName":"add_annotation","kind":12,"name":"has_gene","line":247},{"line":249,"kind":13,"containerName":"add_annotation","name":"$self"},{"name":"_add_generic_annotation","kind":12,"containerName":"add_annotation","line":249},{"definition":"my","name":"$feat","kind":13,"localvar":"my","containerName":"add_annotation","line":253},{"name":"$type","kind":13,"containerName":"add_annotation","line":255},{"line":256,"containerName":"add_annotation","kind":13,"name":"$feat"},{"name":"$self","containerName":"add_annotation","kind":13,"line":256},{"line":256,"containerName":"add_annotation","kind":12,"name":"has_gene"},{"line":257,"name":"$feat","containerName":"add_annotation","kind":13},{"name":"add_tag_value","kind":12,"containerName":"add_annotation","line":257},{"line":257,"containerName":"add_annotation","kind":13,"name":"$self"},{"line":257,"containerName":"add_annotation","kind":13,"name":"$id"},{"line":258,"name":"$feat","kind":13,"containerName":"add_annotation"},{"line":258,"kind":12,"containerName":"add_annotation","name":"has_tag"},{"line":261,"containerName":"add_annotation","kind":13,"name":"$feat"},{"name":"new","kind":12,"containerName":"add_annotation","line":261},{"line":262,"name":"$feat","kind":13,"containerName":"add_annotation"},{"name":"primary_tag","containerName":"add_annotation","kind":12,"line":262},{"name":"$type","containerName":"add_annotation","kind":13,"line":262},{"containerName":"add_annotation","localvar":"my","kind":13,"name":"$gene","line":263,"definition":"my"},{"name":"$self","containerName":"add_annotation","kind":13,"line":263},{"kind":12,"containerName":"add_annotation","name":"has_gene","line":263},{"line":264,"name":"$gene","containerName":"add_annotation","kind":13},{"line":264,"containerName":"add_annotation","kind":12,"name":"add_tag_value"},{"name":"$self","containerName":"add_annotation","kind":13,"line":264},{"containerName":"add_annotation","kind":13,"name":"$id","line":264},{"name":"$gene","containerName":"add_annotation","kind":13,"line":265},{"name":"has_tag","containerName":"add_annotation","kind":12,"line":265},{"name":"$feat","containerName":"add_annotation","kind":13,"line":266},{"name":"add_tag_value","containerName":"add_annotation","kind":12,"line":266},{"name":"$self","kind":13,"containerName":"add_annotation","line":266},{"line":266,"kind":13,"containerName":"add_annotation","name":"$id"},{"containerName":"add_annotation","kind":13,"name":"$feat","line":267},{"line":267,"name":"has_tag","containerName":"add_annotation","kind":12},{"kind":13,"containerName":"add_annotation","name":"$tags","line":269}]},{"kind":12,"name":"gene","line":257},{"name":"curr_gname","kind":12,"line":257},{"line":261,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"line":264,"name":"gene","kind":12},{"kind":12,"name":"curr_gname","line":264},{"line":266,"kind":12,"name":"gene"},{"kind":12,"name":"curr_gname","line":266},{"kind":13,"containerName":null,"name":"%tags","line":271},{"line":271,"name":"type","kind":12},{"containerName":null,"kind":13,"name":"$feat","line":272},{"name":"add_tag_value","containerName":"main::","kind":12,"line":272},{"kind":12,"name":"gene","line":272},{"name":"%tags","containerName":null,"kind":13,"line":272},{"line":272,"name":"name","kind":12},{"kind":13,"containerName":null,"name":"$feat","line":273},{"kind":12,"containerName":"main::","name":"has_tag","line":273},{"name":"%tags","containerName":null,"kind":13,"line":274},{"name":"name","kind":12,"line":274},{"line":277,"name":"%tags","kind":13,"containerName":null},{"name":"$feat","containerName":null,"kind":13,"line":278},{"containerName":"main::","kind":12,"name":"has_tag","line":278},{"name":"$val","kind":13,"localvar":"my","containerName":null,"line":279,"definition":"my"},{"containerName":null,"kind":13,"name":"%tags","line":279},{"line":280,"kind":13,"containerName":null,"name":"$feat"},{"line":280,"kind":12,"containerName":"main::","name":"add_tag_value"},{"line":280,"kind":13,"containerName":null,"name":"$val"},{"line":286,"containerName":null,"kind":13,"name":"$feat"},{"line":286,"kind":12,"containerName":"main::","name":"strand"},{"line":286,"kind":13,"containerName":null,"name":"%self"},{"line":286,"name":"curr_strand","kind":12},{"containerName":null,"kind":13,"name":"$feat","line":287},{"name":"start","kind":12,"containerName":"main::","line":287},{"line":287,"kind":13,"containerName":null,"name":"%self"},{"name":"curr_coords","kind":12,"line":287},{"containerName":null,"kind":13,"name":"$feat","line":288},{"line":288,"containerName":"main::","kind":12,"name":"end"},{"name":"%self","containerName":null,"kind":13,"line":288},{"line":288,"name":"curr_coords","kind":12},{"line":291,"localvar":"my","containerName":null,"kind":13,"name":"@annotations","definition":"my"},{"line":291,"kind":13,"containerName":null,"name":"$feat"},{"line":294,"name":"$self","kind":13,"containerName":null},{"line":294,"name":"has_gene","kind":12,"containerName":"main::"},{"line":294,"name":"%type","kind":13,"containerName":null},{"name":"$gene","localvar":"my","kind":13,"containerName":null,"line":295,"definition":"my"},{"containerName":null,"kind":13,"name":"$self","line":295},{"line":295,"name":"has_gene","containerName":"main::","kind":12},{"line":296,"containerName":null,"kind":13,"name":"$gene"},{"name":"strand","kind":12,"containerName":"main::","line":296},{"containerName":null,"kind":13,"name":"%self","line":296},{"kind":12,"name":"curr_strand","line":296},{"name":"$gene","containerName":null,"kind":13,"line":297},{"name":"start","kind":12,"containerName":"main::","line":297},{"line":297,"kind":13,"containerName":null,"name":"%self"},{"line":297,"name":"curr_coords","kind":12},{"line":298,"name":"$gene","containerName":null,"kind":13},{"line":298,"kind":12,"containerName":"main::","name":"end"},{"name":"%self","kind":13,"containerName":null,"line":298},{"line":298,"kind":12,"name":"curr_coords"},{"line":299,"name":"@annotations","kind":13,"containerName":null},{"line":299,"containerName":null,"kind":13,"name":"$gene"},{"containerName":null,"kind":13,"name":"%self","line":300},{"name":"curr_gene","kind":12,"line":300},{"name":"%feats","containerName":null,"kind":13,"line":304},{"name":"$self","kind":13,"containerName":null,"line":305},{"line":305,"containerName":"main::","kind":12,"name":"complain"},{"line":306,"kind":13,"containerName":null,"name":"@annotations"},{"line":310,"localvar":"my","containerName":null,"kind":13,"name":"$seqid","definition":"my"},{"containerName":null,"kind":13,"name":"$seq","line":310},{"name":"id","containerName":"main::","kind":12,"line":310},{"definition":"my","name":"$list","localvar":"my","containerName":null,"kind":13,"line":311},{"name":"%self","containerName":null,"kind":13,"line":311},{"line":311,"name":"ann_l","kind":12},{"line":314,"containerName":null,"kind":13,"name":"@list"},{"name":"@annotations","kind":13,"containerName":null,"line":314},{"line":314,"name":"start","kind":12,"containerName":"main::"},{"name":"@list","containerName":null,"kind":13,"line":314},{"line":314,"name":"start","containerName":"main::","kind":12},{"line":315,"name":"$list","kind":13,"containerName":null},{"line":315,"kind":13,"containerName":null,"name":"@annotations"},{"line":318,"name":"$list","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@annotations","line":318},{"line":322,"name":"%self","containerName":null,"kind":13},{"kind":12,"name":"curr_gene","line":322},{"line":323,"kind":13,"containerName":null,"name":"%self"},{"name":"curr_ltag","kind":12,"line":323},{"line":324,"kind":13,"containerName":null,"name":"%self"},{"name":"curr_gname","kind":12,"line":324},{"name":"%self","containerName":null,"kind":13,"line":325},{"line":325,"kind":12,"name":"curr_coords"},{"kind":13,"containerName":null,"name":"%self","line":326},{"kind":12,"name":"curr_feats","line":326},{"name":"%self","containerName":null,"kind":13,"line":327},{"kind":12,"name":"curr_strand","line":327},{"containerName":null,"kind":13,"name":"%self","line":328},{"name":"ann_seq","kind":12,"line":328},{"name":"$seq","kind":13,"containerName":null,"line":328},{"kind":13,"containerName":null,"name":"$self","line":329},{"containerName":"main::","kind":12,"name":"flush","line":329},{"detail":"($self,$seq,$type,$id,$tags,$feats)","definition":"sub","name":"_add_generic_annotation","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"_add_generic_annotation","name":"$self","line":348,"definition":"my"},{"line":348,"name":"$seq","kind":13,"containerName":"_add_generic_annotation"},{"line":348,"kind":13,"containerName":"_add_generic_annotation","name":"$type"},{"line":348,"name":"$id","containerName":"_add_generic_annotation","kind":13},{"line":348,"kind":13,"containerName":"_add_generic_annotation","name":"$tags"},{"name":"$feats","kind":13,"containerName":"_add_generic_annotation","line":348},{"containerName":"_add_generic_annotation","kind":13,"name":"$feats","line":350},{"name":"primary_tag","kind":12,"containerName":"_add_generic_annotation","line":351},{"name":"$type","kind":13,"containerName":"_add_generic_annotation","line":351},{"line":354,"name":"$self","kind":13,"containerName":"_add_generic_annotation"}],"signature":{"label":"_add_generic_annotation($self,$seq,$type,$id,$tags,$feats)","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$type"},{"label":"$id"},{"label":"$tags"},{"label":"$feats"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature\n\n\nsub _has_CDS {\n    my ($self, $transcript) = @_;\n\n    if ( !$transcript ) {\n\tif ( defined $self->{curr_cds} ) {\n\t    return $self->{curr_cds};\n        }\n\telse {\n\t    return 0;\n\t}\n    }\n    else {\n\tmy $tags = $self->{curr_tags};\n\t$self->{curr_cds} = $self->_add_CDS( $transcript, $tags );\n    }\n}\n\n=head2 add_annotation\n\n Title   : add_annotation\n Usage   : $featHandler->add_annotation($seq, $type, $id, $tags, $feats)\n Function: converts a containment hierarchy into an ordered list of flat features\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub add_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n\n    # is this a generic feature?\n    unless ( $self->has_gene ) {\n\tshift;\n\t$self->_add_generic_annotation(@_);\n\treturn 0;\n    }\n\n    my $feat;\n\n    if ( $type eq 'gene' ) {\n\t$feat = $self->has_gene;\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');\n    }\n    else {\n\t$feat = Bio::SeqFeature::Generic->new;\n\t$feat->primary_tag($type);\n\tmy $gene = $self->has_gene;\n\t$gene->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $gene->has_tag('gene');\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');;\n    }\n    for ( keys %{$tags} ) {\n\t# or else add simple tag/value pairs\n\tif ( $_ eq 'name' && $tags->{type}->[0] eq 'gene' ) {\n\t    $feat->add_tag_value( gene => $tags->{name}->[0] )\n\t\tunless $feat->has_tag( 'gene' );\n\t    delete $tags->{name};\n\t}\n\telse {\n\t    next if $_ eq 'type' && $tags->{$_}->[0] eq 'gene';\n\t    next if $_ eq 'gene' && $feat->has_tag( 'gene' );\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val );\n\t    }\n\t}\n    }\n\n\n    $feat->strand( $self->{curr_strand} );\n    $feat->start( $self->{curr_coords}->[0] );\n    $feat->end( $self->{curr_coords}->[1] );\n\n    # create an array of features for the annotation (order matters)\n    my @annotations = ( $feat );\n\n    # add the gene feature if the annotation is not a gene\n    if ( $self->has_gene && $type ne 'gene') {\n\tmy $gene = $self->has_gene;\n\t$gene->strand( $self->{curr_strand} );\n\t$gene->start( $self->{curr_coords}->[0] );\n        $gene->end( $self->{curr_coords}->[-1] );\n\tpush @annotations, $gene;\n\t$self->{curr_gene} = '';\n    }\n\n    # add the subfeatures\n    for ( @{$feats} ) {\n\t$self->complain(\"bad feature $_\") unless ref($_) =~ /Bio/;\n\tpush @annotations, $_;\n    }\n    \n    # add the annotation array to the list for this sequence\n    my $seqid = $seq->id;\n    my $list = $self->{ann_l};\n    \n    # make sure the feature_sets appear in ascending order\n    if ( $list->[0] && $annotations[0]->start < $list->[0]->start ) {\n\t    unshift @{$list}, @annotations;\n       }\n    else {\n        push @{$list}, @annotations;\n    }\n\n    # garbage collection\n    $self->{curr_gene}   = '';\n    $self->{curr_ltag}   = '';\n    $self->{curr_gname}  = '';\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;    \n    $self->flush;\n}\n\n\n=head2 _add_generic_annotation\n\n Title   : _add_generic_annotation\n Usage   : $self->_add_generic_annotation($seq, $type, $id, $tags, $feats)\n Function: an internal method to handle non-gene annotations\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects"},"kind":12,"range":{"end":{"line":354,"character":9999},"start":{"line":347,"character":0}},"line":347},{"line":354,"name":"ann_l","kind":12},{"name":"$feats","kind":13,"containerName":null,"line":354},{"kind":13,"containerName":null,"name":"%self","line":356},{"kind":12,"name":"curr_coords","line":356},{"line":357,"name":"%self","containerName":null,"kind":13},{"name":"curr_feats","kind":12,"line":357},{"name":"%self","containerName":null,"kind":13,"line":358},{"kind":12,"name":"curr_strand","line":358},{"name":"%self","containerName":null,"kind":13,"line":359},{"kind":12,"name":"ann_seq","line":359},{"line":359,"name":"$seq","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$self","line":360},{"line":360,"containerName":"main::","kind":12,"name":"flush"},{"line":379,"range":{"end":{"character":9999,"line":395},"start":{"line":379,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$id"},{"label":"$gname"},{"label":"$set"},{"label":"$anntype"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature\n\n\nsub _has_CDS {\n    my ($self, $transcript) = @_;\n\n    if ( !$transcript ) {\n\tif ( defined $self->{curr_cds} ) {\n\t    return $self->{curr_cds};\n        }\n\telse {\n\t    return 0;\n\t}\n    }\n    else {\n\tmy $tags = $self->{curr_tags};\n\t$self->{curr_cds} = $self->_add_CDS( $transcript, $tags );\n    }\n}\n\n=head2 add_annotation\n\n Title   : add_annotation\n Usage   : $featHandler->add_annotation($seq, $type, $id, $tags, $feats)\n Function: converts a containment hierarchy into an ordered list of flat features\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub add_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n\n    # is this a generic feature?\n    unless ( $self->has_gene ) {\n\tshift;\n\t$self->_add_generic_annotation(@_);\n\treturn 0;\n    }\n\n    my $feat;\n\n    if ( $type eq 'gene' ) {\n\t$feat = $self->has_gene;\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');\n    }\n    else {\n\t$feat = Bio::SeqFeature::Generic->new;\n\t$feat->primary_tag($type);\n\tmy $gene = $self->has_gene;\n\t$gene->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $gene->has_tag('gene');\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');;\n    }\n    for ( keys %{$tags} ) {\n\t# or else add simple tag/value pairs\n\tif ( $_ eq 'name' && $tags->{type}->[0] eq 'gene' ) {\n\t    $feat->add_tag_value( gene => $tags->{name}->[0] )\n\t\tunless $feat->has_tag( 'gene' );\n\t    delete $tags->{name};\n\t}\n\telse {\n\t    next if $_ eq 'type' && $tags->{$_}->[0] eq 'gene';\n\t    next if $_ eq 'gene' && $feat->has_tag( 'gene' );\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val );\n\t    }\n\t}\n    }\n\n\n    $feat->strand( $self->{curr_strand} );\n    $feat->start( $self->{curr_coords}->[0] );\n    $feat->end( $self->{curr_coords}->[1] );\n\n    # create an array of features for the annotation (order matters)\n    my @annotations = ( $feat );\n\n    # add the gene feature if the annotation is not a gene\n    if ( $self->has_gene && $type ne 'gene') {\n\tmy $gene = $self->has_gene;\n\t$gene->strand( $self->{curr_strand} );\n\t$gene->start( $self->{curr_coords}->[0] );\n        $gene->end( $self->{curr_coords}->[-1] );\n\tpush @annotations, $gene;\n\t$self->{curr_gene} = '';\n    }\n\n    # add the subfeatures\n    for ( @{$feats} ) {\n\t$self->complain(\"bad feature $_\") unless ref($_) =~ /Bio/;\n\tpush @annotations, $_;\n    }\n    \n    # add the annotation array to the list for this sequence\n    my $seqid = $seq->id;\n    my $list = $self->{ann_l};\n    \n    # make sure the feature_sets appear in ascending order\n    if ( $list->[0] && $annotations[0]->start < $list->[0]->start ) {\n\t    unshift @{$list}, @annotations;\n       }\n    else {\n        push @{$list}, @annotations;\n    }\n\n    # garbage collection\n    $self->{curr_gene}   = '';\n    $self->{curr_ltag}   = '';\n    $self->{curr_gname}  = '';\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;    \n    $self->flush;\n}\n\n\n=head2 _add_generic_annotation\n\n Title   : _add_generic_annotation\n Usage   : $self->_add_generic_annotation($seq, $type, $id, $tags, $feats)\n Function: an internal method to handle non-gene annotations\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub _add_generic_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n    \n    for ( @$feats ) {\n\t$_->primary_tag($type);\n    }\n\n    push @{$self->{ann_l}}, @$feats;\n\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;\n    $self->flush;\n}\n\n\n=head2 feature_set\n\n Title   : feature_set\n Usage   : push @feats, $featHandler->feature_set($id, $gname, $set, $anntype);\n Function: handles <feature_span> hierarchies (usually a transcript)\n Returns : a list of Bio::SeqFeature::Generic objects\n Args    : $id      -- ID of the feature set\n           $gname   -- name of the gene\n           $set     -- the <feature_set> object\n           $anntype -- type of the parent annotation","label":"feature_set($self,$id,$gname,$set,$anntype)"},"children":[{"localvar":"my","kind":13,"containerName":"feature_set","name":"$self","line":380,"definition":"my"},{"line":380,"name":"$id","kind":13,"containerName":"feature_set"},{"line":380,"kind":13,"containerName":"feature_set","name":"$gname"},{"line":380,"name":"$set","kind":13,"containerName":"feature_set"},{"line":380,"name":"$anntype","containerName":"feature_set","kind":13},{"name":"$stype","localvar":"my","kind":13,"containerName":"feature_set","line":381,"definition":"my"},{"name":"$set","containerName":"feature_set","kind":13,"line":381},{"containerName":"feature_set","kind":13,"name":"$self","line":382},{"line":383,"name":"$self","containerName":"feature_set","kind":13},{"line":384,"name":"$self","kind":13,"containerName":"feature_set"},{"kind":13,"containerName":"feature_set","name":"$self","line":385},{"definition":"my","name":"@feats","localvar":"my","kind":13,"containerName":"feature_set","line":386},{"name":"$tags","localvar":"my","containerName":"feature_set","kind":13,"line":387,"definition":"my"},{"line":387,"kind":13,"containerName":"feature_set","name":"$self"},{"definition":"my","line":388,"name":"$sname","containerName":"feature_set","localvar":"my","kind":13},{"name":"$set","containerName":"feature_set","kind":13,"line":388},{"line":389,"name":"$set","containerName":"feature_set","kind":13},{"line":391,"containerName":"feature_set","kind":13,"name":"$set"},{"containerName":"feature_set","kind":13,"name":"$tags","line":392},{"containerName":"feature_set","kind":13,"name":"$set","line":392},{"definition":"my","line":395,"name":"@fcount","localvar":"my","kind":13,"containerName":"feature_set"},{"line":395,"containerName":"feature_set","kind":13,"name":"$set"}],"containerName":"main::","name":"feature_set","definition":"sub","detail":"($self,$id,$gname,$set,$anntype)"},{"line":381,"name":"_type","kind":12},{"kind":12,"name":"Characters","line":381},{"name":"curr_loc","kind":12,"line":382},{"kind":12,"name":"curr_tags","line":383},{"kind":12,"name":"curr_subfeats","line":384},{"kind":12,"name":"curr_strand","line":385},{"line":387,"name":"curr_tags","kind":12},{"line":388,"name":"_name","kind":12},{"name":"Characters","kind":12,"line":388},{"line":389,"kind":12,"name":"Attributes"},{"kind":12,"name":"id","line":389},{"line":391,"name":"Attributes","kind":12},{"line":391,"kind":12,"name":"problem"},{"line":392,"name":"problem","kind":12},{"name":"Attributes","kind":12,"line":392},{"line":392,"name":"problem","kind":12},{"line":395,"kind":12,"name":"Name"},{"line":395,"name":"Children","kind":12},{"kind":13,"containerName":null,"name":"@fcount","line":397},{"line":398,"name":"$self","kind":13,"containerName":null},{"line":398,"name":"_build_feature_set","kind":12,"containerName":"main::"},{"line":398,"kind":13,"containerName":null,"name":"$set"},{"definition":"my","line":399,"name":"$feat","containerName":null,"localvar":"my","kind":13},{"containerName":null,"kind":13,"name":"%self","line":399},{"line":399,"name":"curr_subfeats","kind":12},{"line":400,"name":"$feat","containerName":null,"kind":13},{"line":400,"name":"primary_tag","kind":12,"containerName":"main::"},{"name":"$feat","containerName":null,"kind":13,"line":400},{"name":"primary_tag","kind":12,"containerName":"main::","line":400},{"kind":13,"containerName":null,"name":"$feat","line":401},{"name":"primary_tag","kind":12,"containerName":"main::","line":401},{"kind":13,"containerName":null,"name":"$feat","line":402},{"line":402,"name":"add_tag_value","kind":12,"containerName":"main::"},{"line":402,"name":"gene","kind":12},{"line":402,"kind":13,"containerName":null,"name":"$gname"},{"name":"$id","kind":13,"containerName":null,"line":402},{"name":"$feat","containerName":null,"kind":13,"line":403},{"kind":12,"containerName":"main::","name":"has_tag","line":403},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"%seen_tag","line":406},{"name":"$tag","kind":13,"localvar":"my","containerName":null,"line":407,"definition":"my"},{"line":407,"name":"%tags","containerName":null,"kind":13},{"definition":"my","line":408,"localvar":"my","kind":13,"containerName":null,"name":"$val"},{"line":408,"name":"%tags","kind":13,"containerName":null},{"line":408,"name":"%tag","containerName":null,"kind":13},{"line":409,"kind":13,"containerName":null,"name":"$feat"},{"line":409,"name":"add_tag_value","kind":12,"containerName":"main::"},{"line":409,"containerName":null,"kind":13,"name":"$tag"},{"name":"$val","containerName":null,"kind":13,"line":409},{"name":"$val","kind":13,"containerName":null,"line":410},{"line":410,"kind":13,"containerName":null,"name":"%seen_tag"},{"containerName":null,"kind":13,"name":"$tag","line":410},{"line":410,"containerName":null,"kind":13,"name":"$val"},{"line":413,"name":"@feats","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%feat","line":413},{"name":"%self","containerName":null,"kind":13,"line":416},{"line":416,"name":"curr_ltag","kind":12},{"kind":13,"containerName":null,"name":"$id","line":416},{"line":417,"kind":13,"containerName":null,"name":"%self"},{"line":417,"name":"curr_cds","kind":12},{"containerName":null,"kind":13,"name":"$gname","line":418},{"line":418,"kind":13,"containerName":null,"name":"$id"},{"line":418,"name":"$gname","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%self","line":419},{"name":"curr_gname","kind":12,"line":419},{"line":419,"name":"$gname","containerName":null,"kind":13},{"line":421,"name":"$self","containerName":null,"kind":13},{"line":421,"name":"has_gene","kind":12,"containerName":"main::"},{"line":422,"kind":13,"containerName":null,"name":"%anntype"},{"kind":13,"containerName":null,"name":"$stype","line":423},{"name":"%self","containerName":null,"kind":13,"line":427},{"kind":12,"name":"curr_feat","line":427},{"containerName":"SeqFeature::Generic","kind":12,"name":"Bio","line":427},{"line":427,"containerName":"main::","kind":12,"name":"new"},{"line":428,"name":"$stype","kind":13,"containerName":null},{"line":429,"name":"$id","containerName":null,"kind":13},{"localvar":"my","kind":13,"containerName":null,"name":"$feat","line":431,"definition":"my"},{"containerName":null,"kind":13,"name":"%self","line":431},{"kind":12,"name":"curr_feat","line":431},{"line":432,"containerName":null,"kind":13,"name":"$self"},{"line":432,"name":"_build_feature_set","containerName":"main::","kind":12},{"line":432,"name":"$set","containerName":null,"kind":13},{"definition":"my","line":434,"name":"$gene","localvar":"my","kind":13,"containerName":null},{"line":434,"containerName":null,"kind":13,"name":"$gname"},{"kind":13,"containerName":null,"name":"%self","line":434},{"kind":12,"name":"curr_ltag","line":434},{"kind":13,"containerName":null,"name":"$feat","line":436},{"kind":12,"containerName":"main::","name":"add_tag_value","line":436},{"kind":12,"name":"gene","line":436},{"name":"$gene","kind":13,"containerName":null,"line":436},{"line":437,"containerName":null,"kind":13,"name":"$feat"},{"line":437,"name":"has_tag","kind":12,"containerName":"main::"},{"name":"$cds","localvar":"my","containerName":null,"kind":13,"line":440,"definition":"my"},{"line":440,"kind":13,"containerName":null,"name":"$self"},{"name":"_has_CDS","containerName":"main::","kind":12,"line":440},{"line":440,"kind":13,"containerName":null,"name":"$feat"},{"line":442,"kind":13,"containerName":null,"name":"%cds"},{"name":"$feat","kind":13,"containerName":null,"line":443},{"line":443,"name":"primary_tag","kind":12,"containerName":"main::"},{"name":"$cds","kind":13,"containerName":null,"line":446},{"name":"remove_tag","kind":12,"containerName":"main::","line":446},{"line":446,"name":"$cds","kind":13,"containerName":null},{"name":"has_tag","containerName":"main::","kind":12,"line":446},{"line":447,"name":"$cds","kind":13,"containerName":null},{"line":447,"name":"add_tag_value","kind":12,"containerName":"main::"},{"kind":12,"name":"standard_name","line":447},{"name":"$sname","kind":13,"containerName":null,"line":447},{"line":448,"kind":13,"containerName":null,"name":"$cds"},{"kind":12,"containerName":"main::","name":"remove_tag","line":448},{"containerName":null,"kind":13,"name":"$cds","line":448},{"kind":12,"containerName":"main::","name":"has_tag","line":448},{"line":449,"name":"$cds","containerName":null,"kind":13},{"line":449,"kind":12,"containerName":"main::","name":"add_tag_value"},{"kind":12,"name":"gene","line":449},{"line":449,"containerName":null,"kind":13,"name":"$gene"},{"line":452,"kind":13,"containerName":null,"name":"$cds"},{"kind":12,"containerName":"main::","name":"has_tag","line":452},{"line":452,"containerName":null,"kind":13,"name":"$cds"},{"containerName":"main::","kind":12,"name":"get_tag_values","line":452},{"line":453,"kind":13,"localvar":"my","containerName":null,"name":"$pid","definition":"my"},{"name":"$self","containerName":null,"kind":13,"line":453},{"line":453,"name":"protein_id","containerName":"main::","kind":12},{"name":"$cds","containerName":null,"kind":13,"line":453},{"kind":13,"containerName":null,"name":"$sname","line":453},{"line":454,"name":"$cds","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"remove_tag","line":454},{"name":"$cds","kind":13,"containerName":null,"line":455},{"line":455,"containerName":"main::","kind":12,"name":"add_tag_value"},{"line":455,"kind":12,"name":"protein_id"},{"name":"$pid","kind":13,"containerName":null,"line":455},{"name":"@subfeats","localvar":"my","containerName":null,"kind":13,"line":460,"definition":"my"},{"line":460,"containerName":null,"kind":13,"name":"%self"},{"line":460,"name":"curr_subfeats","kind":12},{"definition":"my","line":461,"containerName":null,"localvar":"my","kind":13,"name":"$sf"},{"kind":13,"containerName":null,"name":"@","line":461},{"name":"subfeats","kind":12,"line":461},{"kind":13,"containerName":null,"name":"$sf","line":462},{"line":462,"containerName":"main::","kind":12,"name":"add_tag_value"},{"kind":12,"name":"standard_name","line":462},{"name":"$sname","containerName":null,"kind":13,"line":462},{"line":463,"name":"$sf","containerName":null,"kind":13},{"name":"has_tag","kind":12,"containerName":"main::","line":463},{"line":464,"name":"$sf","containerName":null,"kind":13},{"line":464,"kind":12,"containerName":"main::","name":"add_tag_value"},{"line":464,"kind":12,"name":"gene"},{"line":464,"containerName":null,"kind":13,"name":"$gene"},{"line":465,"containerName":null,"kind":13,"name":"$sf"},{"line":465,"containerName":"main::","kind":12,"name":"has_tag"},{"name":"$feat","containerName":null,"kind":13,"line":468},{"name":"add_tag_value","containerName":"main::","kind":12,"line":468},{"line":468,"kind":12,"name":"standard_name"},{"line":468,"kind":13,"containerName":null,"name":"$sname"},{"line":469,"name":"$feat","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"has_tag","line":469},{"line":470,"name":"$feat","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"add_tag_value","line":470},{"name":"gene","kind":12,"line":470},{"kind":13,"containerName":null,"name":"$gene","line":470},{"line":471,"name":"$feat","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"has_tag","line":471},{"localvar":"my","kind":13,"containerName":null,"name":"%seen","line":475,"definition":"my"},{"line":476,"name":"$feat","containerName":null,"kind":13},{"line":476,"kind":12,"containerName":"main::","name":"length"},{"line":476,"name":"$cds","containerName":null,"kind":13},{"name":"length","kind":12,"containerName":"main::","line":476},{"name":"$t","kind":13,"localvar":"my","containerName":null,"line":477,"definition":"my"},{"kind":13,"containerName":null,"name":"$feat","line":477},{"line":477,"name":"all_tags","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$t","line":478},{"line":479,"kind":13,"containerName":null,"name":"$cds"},{"line":479,"containerName":"main::","kind":12,"name":"add_tag_value"},{"name":"$t","kind":13,"containerName":null,"line":479},{"line":479,"name":"$feat","kind":13,"containerName":null},{"name":"get_tag_values","kind":12,"containerName":"main::","line":479},{"kind":13,"containerName":null,"name":"$t","line":479},{"kind":13,"containerName":null,"name":"$feat","line":481},{"name":"@feats","containerName":null,"kind":13,"line":484},{"kind":13,"containerName":null,"name":"$a","line":484},{"name":"start","containerName":"main::","kind":12,"line":484},{"line":484,"name":"$b","kind":13,"containerName":null},{"line":484,"name":"start","containerName":"main::","kind":12},{"name":"$cds","kind":13,"containerName":null,"line":484},{"line":484,"kind":13,"containerName":null,"name":"@subfeats"},{"containerName":null,"kind":13,"name":"@feats","line":485},{"line":485,"name":"$feat","containerName":null,"kind":13},{"line":485,"kind":13,"containerName":null,"name":"%feat"},{"line":488,"name":"%self","kind":13,"containerName":null},{"name":"curr_loc","kind":12,"line":488},{"definition":"my","name":"$loc","localvar":"my","containerName":null,"kind":13,"line":489},{"name":"Bio","containerName":"Location::Split","kind":12,"line":489},{"name":"new","kind":12,"containerName":"main::","line":489},{"line":492,"containerName":null,"localvar":"my","kind":13,"name":"@loc","definition":"my"},{"line":492,"kind":13,"containerName":null,"name":"$a"},{"line":492,"name":"start","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$b","line":492},{"containerName":"main::","kind":12,"name":"start","line":492},{"containerName":null,"kind":13,"name":"%self","line":492},{"kind":12,"name":"curr_loc","line":492},{"containerName":null,"kind":13,"name":"@loc","line":495},{"name":"$loc","containerName":null,"kind":13,"line":496},{"line":496,"kind":12,"containerName":"main::","name":"add_sub_Location"},{"line":498,"kind":13,"containerName":null,"name":"$feat"},{"kind":12,"containerName":"main::","name":"location","line":498},{"name":"%loc","containerName":null,"kind":13,"line":498},{"line":501,"name":"$feat","containerName":null,"kind":13},{"line":501,"name":"location","containerName":"main::","kind":12},{"line":501,"name":"%self","kind":13,"containerName":null},{"kind":12,"name":"curr_loc","line":501},{"line":504,"name":"%tags","containerName":null,"kind":13},{"line":506,"name":"$feat","kind":13,"containerName":null},{"line":506,"name":"has_tag","containerName":"main::","kind":12},{"definition":"my","line":507,"localvar":"my","containerName":null,"kind":13,"name":"$v"},{"line":507,"name":"%tags","containerName":null,"kind":13},{"line":508,"containerName":null,"kind":13,"name":"$feat"},{"name":"add_tag_value","kind":12,"containerName":"main::","line":508},{"line":508,"name":"$v","containerName":null,"kind":13},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"@subfeats","line":513},{"name":"%self","kind":13,"containerName":null,"line":513},{"kind":12,"name":"curr_subfeats","line":513},{"line":514,"kind":13,"localvar":"my","containerName":null,"name":"$sf","definition":"my"},{"line":514,"name":"@","containerName":null,"kind":13},{"line":514,"name":"subfeats","kind":12},{"kind":13,"containerName":null,"name":"$sf","line":515},{"line":515,"name":"add_tag_value","containerName":"main::","kind":12},{"kind":12,"name":"standard_name","line":515},{"line":515,"containerName":null,"kind":13,"name":"$sname"},{"line":516,"kind":13,"containerName":null,"name":"$sf"},{"line":516,"containerName":"main::","kind":12,"name":"has_tag"},{"kind":13,"containerName":null,"name":"$sf","line":517},{"line":517,"kind":12,"containerName":"main::","name":"add_tag_value"},{"line":517,"kind":12,"name":"gene"},{"kind":13,"containerName":null,"name":"$gene","line":517},{"line":518,"name":"$sf","kind":13,"containerName":null},{"line":518,"name":"has_tag","kind":12,"containerName":"main::"},{"name":"@feats","kind":13,"containerName":null,"line":521},{"kind":13,"containerName":null,"name":"$feat","line":521},{"line":521,"containerName":null,"kind":13,"name":"@subfeats"},{"name":"%self","kind":13,"containerName":null,"line":527},{"name":"curr_coords","kind":12,"line":527},{"kind":13,"containerName":null,"name":"%self","line":528},{"name":"curr_coords","kind":12,"line":528},{"line":529,"kind":13,"containerName":null,"name":"@feats"},{"line":530,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"name":"curr_coords","line":530},{"line":530,"name":"start","kind":12,"containerName":"main::"},{"line":531,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"name":"curr_coords","line":531},{"kind":12,"containerName":"main::","name":"start","line":531},{"containerName":null,"kind":13,"name":"%self","line":533},{"line":533,"kind":12,"name":"curr_coords"},{"kind":12,"containerName":"main::","name":"end","line":533},{"containerName":null,"kind":13,"name":"%self","line":534},{"line":534,"name":"curr_coords","kind":12},{"kind":12,"containerName":"main::","name":"end","line":534},{"line":538,"name":"$self","kind":13,"containerName":null},{"line":538,"containerName":"main::","kind":12,"name":"flush"},{"name":"$set","containerName":null,"kind":13,"line":538},{"kind":13,"containerName":null,"name":"@feats","line":540},{"children":[{"line":558,"localvar":"my","containerName":"_build_feature_set","kind":13,"name":"$self","definition":"my"},{"name":"$set","kind":13,"containerName":"_build_feature_set","line":558},{"name":"$keep_subfeat","containerName":"_build_feature_set","kind":13,"line":558},{"name":"$child","localvar":"my","containerName":"_build_feature_set","kind":13,"line":560,"definition":"my"},{"line":560,"name":"$set","containerName":"_build_feature_set","kind":13}],"name":"_build_feature_set","containerName":"main::","definition":"sub","detail":"($self,$set,$keep_subfeat)","line":557,"range":{"start":{"line":557,"character":0},"end":{"line":560,"character":9999}},"kind":12,"signature":{"label":"_build_feature_set($self,$set,$keep_subfeat)","documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature\n\n\nsub _has_CDS {\n    my ($self, $transcript) = @_;\n\n    if ( !$transcript ) {\n\tif ( defined $self->{curr_cds} ) {\n\t    return $self->{curr_cds};\n        }\n\telse {\n\t    return 0;\n\t}\n    }\n    else {\n\tmy $tags = $self->{curr_tags};\n\t$self->{curr_cds} = $self->_add_CDS( $transcript, $tags );\n    }\n}\n\n=head2 add_annotation\n\n Title   : add_annotation\n Usage   : $featHandler->add_annotation($seq, $type, $id, $tags, $feats)\n Function: converts a containment hierarchy into an ordered list of flat features\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub add_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n\n    # is this a generic feature?\n    unless ( $self->has_gene ) {\n\tshift;\n\t$self->_add_generic_annotation(@_);\n\treturn 0;\n    }\n\n    my $feat;\n\n    if ( $type eq 'gene' ) {\n\t$feat = $self->has_gene;\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');\n    }\n    else {\n\t$feat = Bio::SeqFeature::Generic->new;\n\t$feat->primary_tag($type);\n\tmy $gene = $self->has_gene;\n\t$gene->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $gene->has_tag('gene');\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');;\n    }\n    for ( keys %{$tags} ) {\n\t# or else add simple tag/value pairs\n\tif ( $_ eq 'name' && $tags->{type}->[0] eq 'gene' ) {\n\t    $feat->add_tag_value( gene => $tags->{name}->[0] )\n\t\tunless $feat->has_tag( 'gene' );\n\t    delete $tags->{name};\n\t}\n\telse {\n\t    next if $_ eq 'type' && $tags->{$_}->[0] eq 'gene';\n\t    next if $_ eq 'gene' && $feat->has_tag( 'gene' );\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val );\n\t    }\n\t}\n    }\n\n\n    $feat->strand( $self->{curr_strand} );\n    $feat->start( $self->{curr_coords}->[0] );\n    $feat->end( $self->{curr_coords}->[1] );\n\n    # create an array of features for the annotation (order matters)\n    my @annotations = ( $feat );\n\n    # add the gene feature if the annotation is not a gene\n    if ( $self->has_gene && $type ne 'gene') {\n\tmy $gene = $self->has_gene;\n\t$gene->strand( $self->{curr_strand} );\n\t$gene->start( $self->{curr_coords}->[0] );\n        $gene->end( $self->{curr_coords}->[-1] );\n\tpush @annotations, $gene;\n\t$self->{curr_gene} = '';\n    }\n\n    # add the subfeatures\n    for ( @{$feats} ) {\n\t$self->complain(\"bad feature $_\") unless ref($_) =~ /Bio/;\n\tpush @annotations, $_;\n    }\n    \n    # add the annotation array to the list for this sequence\n    my $seqid = $seq->id;\n    my $list = $self->{ann_l};\n    \n    # make sure the feature_sets appear in ascending order\n    if ( $list->[0] && $annotations[0]->start < $list->[0]->start ) {\n\t    unshift @{$list}, @annotations;\n       }\n    else {\n        push @{$list}, @annotations;\n    }\n\n    # garbage collection\n    $self->{curr_gene}   = '';\n    $self->{curr_ltag}   = '';\n    $self->{curr_gname}  = '';\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;    \n    $self->flush;\n}\n\n\n=head2 _add_generic_annotation\n\n Title   : _add_generic_annotation\n Usage   : $self->_add_generic_annotation($seq, $type, $id, $tags, $feats)\n Function: an internal method to handle non-gene annotations\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub _add_generic_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n    \n    for ( @$feats ) {\n\t$_->primary_tag($type);\n    }\n\n    push @{$self->{ann_l}}, @$feats;\n\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;\n    $self->flush;\n}\n\n\n=head2 feature_set\n\n Title   : feature_set\n Usage   : push @feats, $featHandler->feature_set($id, $gname, $set, $anntype);\n Function: handles <feature_span> hierarchies (usually a transcript)\n Returns : a list of Bio::SeqFeature::Generic objects\n Args    : $id      -- ID of the feature set\n           $gname   -- name of the gene\n           $set     -- the <feature_set> object\n           $anntype -- type of the parent annotation\n\n\n\n\nsub feature_set {\n    my ($self, $id, $gname, $set, $anntype) = @_;\n    my $stype = $set->{_type}->{Characters};\n    $self->{curr_loc}      = [];\n    $self->{curr_tags}     = {};\n    $self->{curr_subfeats} = [];\n    $self->{curr_strand}   = 0;\n    my @feats = ();\n    my $tags = $self->{curr_tags};\n    my $sname = $set->{_name}->{Characters} ||\n        $set->{Attributes}->{id};\n\n    if ( $set->{Attributes}->{problem} ) {\n        $tags->{problem} = [$set->{Attributes}->{problem}];\n    }\n\n    my @fcount = grep { $_->{Name} eq 'feature_span' } @{$set->{Children}};\n    \n    if ( @fcount == 1 ) {\n\t$self->_build_feature_set($set, 1);\n\tmy ($feat) = @{$self->{curr_subfeats}};\n\t$feat->primary_tag('transcript') if $feat->primary_tag eq 'exon';\n\tif ( $feat->primary_tag eq 'transcript' ) {\n\t    $feat->add_tag_value( gene => ($gname || $id) )\n\t\tunless $feat->has_tag('gene');\n\t}\n        \n        my %seen_tag;\n\tfor my $tag ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$tag}} ) {\n\t\t$feat->add_tag_value( $tag => $val ) \n\t\t    if $val && ++$seen_tag{$tag.$val} < 2;\n\t    }\n\t}\n\t@feats = ($feat);\n    }\n    else {\n\t$self->{curr_ltag}     = $id;\n\t$self->{curr_cds}      = '';\n\t$gname = $id if $gname eq 'gene';\n\t$self->{curr_gname} = $gname;\n\n\tif ( $self->has_gene ) {\n\t    unless ( $anntype =~/RNA/i ) {\n\t\t$stype =~ s/transcript/mRNA/;\n\t    }\n\t}\n\t\n\t$self->{curr_feat}  = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t\t    -primary => $stype,\n\t\t\t\t\t\t\t    -id      => $id,\n\t\t\t\t\t\t\t    );\n\tmy $feat = $self->{curr_feat};\n\t$self->_build_feature_set($set);\n\t\n\tmy $gene = $gname || $self->{curr_ltag};\n\t\n\t$feat->add_tag_value( gene => $gene )\n\t    unless $feat->has_tag('gene');\n\n\t# if there is an annotated protein product\n\tmy $cds = $self->_has_CDS( $feat );\n\n\tif ( $cds ) {\n            $feat->primary_tag('mRNA');\n\n\t    # we really just want one value here\n\t    $cds->remove_tag('standard_name') if $cds->has_tag('standard_name');\n\t    $cds->add_tag_value( standard_name => $sname );\n\t    $cds->remove_tag('gene') if $cds->has_tag('gene');\n\t    $cds->add_tag_value( gene => $gene );\n\t    \n            # catch empty protein ids\n            if ( $cds->has_tag('protein_id' ) && !$cds->get_tag_values('protein_id') ) {\n\t\tmy $pid = $self->protein_id($cds, $sname);\n\t\t$cds->remove_tag('protein_id');\n\t\t$cds->add_tag_value( protein_id => $pid );\n\t    }\n\n\t    # make sure other subfeats are tied to the transcript\n            # via a 'standard_name' qualifier and the gene via a 'gene' qualifier\n\t    my @subfeats = @{$self->{curr_subfeats}};\n            for my $sf ( @ subfeats ) {\n                $sf->add_tag_value( standard_name => $sname )\n\t\t    unless $sf->has_tag('standard_name');\n                $sf->add_tag_value( gene => $gene )\n\t\t    unless $sf->has_tag('gene');\n            }\n\t    \n\t    $feat->add_tag_value( standard_name => $sname )\n\t\tunless $feat->has_tag('standard_name');\n\t    $feat->add_tag_value( gene => $gene )\n\t\tunless $feat->has_tag('gene');\n\n            # if the mRNA and CDS are the same length, the mRNA is redundant\n            # lose the mRNA, steal its tags and give them to the CDS\n            my %seen;\n\t    if ( $feat->length == $cds->length ) {\n\t\tfor my $t ( $feat->all_tags ) {\n\t\t    next if $t =~ /gene|standard_name/;\n\t\t    $cds->add_tag_value( $t => $feat->get_tag_values($t) );\n\t\t}\n\t\tundef $feat;\n\t    }\n\n\t    @feats = sort { $a->start <=> $b->start } ($cds, @subfeats);\n\t    unshift @feats, $feat if $feat;\n\t}\n\telse {\n\t    if ( @{$self->{curr_loc}} > 1 ) {\n\t\tmy $loc = Bio::Location::Split->new( -splittype => 'JOIN' );\n\t\t\n\t\t# sort the exons in ascending start order\n\t\tmy @loc = sort { $a->start <=> $b->start } @{$self->{curr_loc}};\n\t\t\n\t\t# then add them to the transcript location\n\t\tfor ( @loc ) {\n\t\t    $loc->add_sub_Location( $_ ) \n\t\t}\n\t\t$feat->location( $loc );\n\t    }\n\t    else {\n\t\t$feat->location( $self->{curr_loc}->[0] );\n\t    }\t\n \t    \n\t    for ( keys %$tags ) {\n\t\t# expunge duplicate gene attributes\n\t\tnext if /gene/ && $feat->has_tag('gene');\n\t\tfor my $v ( @{$tags->{$_}} ) {\n\t\t    $feat->add_tag_value( $_ => $v );\n\t\t}\n\t    }\n\n\t    # make sure other subfeats are tied to the transcript\n\t    my @subfeats = @{$self->{curr_subfeats}};\n\t    for my $sf ( @ subfeats ) {\n\t\t$sf->add_tag_value( standard_name => $sname )\n\t\t    unless $sf->has_tag('standard_name');\n\t\t$sf->add_tag_value( gene => $gene )\n\t\t    unless $sf->has_tag('gene');\n\t    }\n\n\t    @feats = ( $feat, @subfeats );\n\t}\n    }\n    \n    # adjust the maximum extent of the annotated feature \n    # if req'd (ie the <annotation> element)\n    $self->{curr_coords}->[0] ||= 1000000000000;\n    $self->{curr_coords}->[1] ||= -1000000000000;\n    for ( @feats ) {\n        if ( $self->{curr_coords}->[0] > $_->start ) {\n\t    $self->{curr_coords}->[0] = $_->start;\n\t}\n\tif ( $self->{curr_coords}->[1] < $_->end ) {\n\t    $self->{curr_coords}->[1] = $_->end;\n\t}\n    }\n    \n    $self->flush( $set );\n\n    return @feats;\n}\n\n\n=head2 _build_feature_set\n\n Title   : _build_feature_set\n Usage   : $self->_build_feature_set($set, 1) # 1 flag means retain the exon as a subfeat\n Function: an internal method to process attributes and subfeats of a feature set\n Returns : nothing\n Args    : $set -- a <feature_set> element\n           1    -- optional flag to retain exons as subfeats.  Otherwise, they will\n                   be converted to sublocations of a parent CDS feature","parameters":[{"label":"$self"},{"label":"$set"},{"label":"$keep_subfeat"}]}},{"line":560,"kind":12,"name":"Children"},{"definition":"my","line":561,"containerName":null,"localvar":"my","kind":13,"name":"$name"},{"name":"%child","kind":13,"containerName":null,"line":561},{"line":561,"kind":12,"name":"Name"},{"name":"%name","kind":13,"containerName":null,"line":564},{"name":"$self","containerName":null,"kind":13,"line":565},{"name":"date","containerName":"main::","kind":12,"line":565},{"containerName":null,"kind":13,"name":"$child","line":565},{"name":"%name","kind":13,"containerName":null,"line":567},{"line":568,"containerName":null,"kind":13,"name":"$self"},{"line":568,"kind":12,"containerName":"main::","name":"comment"},{"line":568,"containerName":null,"kind":13,"name":"$child"},{"line":570,"name":"%name","containerName":null,"kind":13},{"line":571,"containerName":null,"kind":13,"name":"$self"},{"name":"evidence","containerName":"main::","kind":12,"line":571},{"line":571,"name":"$child","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%name","line":573},{"name":"$self","containerName":null,"kind":13,"line":574},{"name":"_add_feature_span","containerName":"main::","kind":12,"line":574},{"kind":13,"containerName":null,"name":"$child","line":574},{"name":"$keep_subfeat","kind":13,"containerName":null,"line":574},{"kind":13,"containerName":null,"name":"%name","line":576},{"line":577,"kind":13,"containerName":null,"name":"$self"},{"name":"property","containerName":"main::","kind":12,"line":577},{"name":"$child","kind":13,"containerName":null,"line":577},{"line":582,"containerName":null,"kind":13,"name":"%name"},{"name":"%self","kind":13,"containerName":null,"line":583},{"name":"curr_tags","kind":12,"line":583},{"line":583,"name":"@name","kind":13,"containerName":null},{"line":583,"containerName":null,"kind":13,"name":"%child"},{"name":"Characters","kind":12,"line":583},{"line":585,"kind":13,"containerName":null,"name":"%name"},{"name":"$self","kind":13,"containerName":null,"line":586},{"line":586,"name":"complain","kind":12,"containerName":"main::"},{"signature":{"label":"_add_feature_span($self,$el,$keep_subfeat)","parameters":[{"label":"$self"},{"label":"$el"},{"label":"$keep_subfeat"}],"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature\n\n\nsub _has_CDS {\n    my ($self, $transcript) = @_;\n\n    if ( !$transcript ) {\n\tif ( defined $self->{curr_cds} ) {\n\t    return $self->{curr_cds};\n        }\n\telse {\n\t    return 0;\n\t}\n    }\n    else {\n\tmy $tags = $self->{curr_tags};\n\t$self->{curr_cds} = $self->_add_CDS( $transcript, $tags );\n    }\n}\n\n=head2 add_annotation\n\n Title   : add_annotation\n Usage   : $featHandler->add_annotation($seq, $type, $id, $tags, $feats)\n Function: converts a containment hierarchy into an ordered list of flat features\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub add_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n\n    # is this a generic feature?\n    unless ( $self->has_gene ) {\n\tshift;\n\t$self->_add_generic_annotation(@_);\n\treturn 0;\n    }\n\n    my $feat;\n\n    if ( $type eq 'gene' ) {\n\t$feat = $self->has_gene;\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');\n    }\n    else {\n\t$feat = Bio::SeqFeature::Generic->new;\n\t$feat->primary_tag($type);\n\tmy $gene = $self->has_gene;\n\t$gene->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $gene->has_tag('gene');\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');;\n    }\n    for ( keys %{$tags} ) {\n\t# or else add simple tag/value pairs\n\tif ( $_ eq 'name' && $tags->{type}->[0] eq 'gene' ) {\n\t    $feat->add_tag_value( gene => $tags->{name}->[0] )\n\t\tunless $feat->has_tag( 'gene' );\n\t    delete $tags->{name};\n\t}\n\telse {\n\t    next if $_ eq 'type' && $tags->{$_}->[0] eq 'gene';\n\t    next if $_ eq 'gene' && $feat->has_tag( 'gene' );\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val );\n\t    }\n\t}\n    }\n\n\n    $feat->strand( $self->{curr_strand} );\n    $feat->start( $self->{curr_coords}->[0] );\n    $feat->end( $self->{curr_coords}->[1] );\n\n    # create an array of features for the annotation (order matters)\n    my @annotations = ( $feat );\n\n    # add the gene feature if the annotation is not a gene\n    if ( $self->has_gene && $type ne 'gene') {\n\tmy $gene = $self->has_gene;\n\t$gene->strand( $self->{curr_strand} );\n\t$gene->start( $self->{curr_coords}->[0] );\n        $gene->end( $self->{curr_coords}->[-1] );\n\tpush @annotations, $gene;\n\t$self->{curr_gene} = '';\n    }\n\n    # add the subfeatures\n    for ( @{$feats} ) {\n\t$self->complain(\"bad feature $_\") unless ref($_) =~ /Bio/;\n\tpush @annotations, $_;\n    }\n    \n    # add the annotation array to the list for this sequence\n    my $seqid = $seq->id;\n    my $list = $self->{ann_l};\n    \n    # make sure the feature_sets appear in ascending order\n    if ( $list->[0] && $annotations[0]->start < $list->[0]->start ) {\n\t    unshift @{$list}, @annotations;\n       }\n    else {\n        push @{$list}, @annotations;\n    }\n\n    # garbage collection\n    $self->{curr_gene}   = '';\n    $self->{curr_ltag}   = '';\n    $self->{curr_gname}  = '';\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;    \n    $self->flush;\n}\n\n\n=head2 _add_generic_annotation\n\n Title   : _add_generic_annotation\n Usage   : $self->_add_generic_annotation($seq, $type, $id, $tags, $feats)\n Function: an internal method to handle non-gene annotations\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub _add_generic_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n    \n    for ( @$feats ) {\n\t$_->primary_tag($type);\n    }\n\n    push @{$self->{ann_l}}, @$feats;\n\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;\n    $self->flush;\n}\n\n\n=head2 feature_set\n\n Title   : feature_set\n Usage   : push @feats, $featHandler->feature_set($id, $gname, $set, $anntype);\n Function: handles <feature_span> hierarchies (usually a transcript)\n Returns : a list of Bio::SeqFeature::Generic objects\n Args    : $id      -- ID of the feature set\n           $gname   -- name of the gene\n           $set     -- the <feature_set> object\n           $anntype -- type of the parent annotation\n\n\n\n\nsub feature_set {\n    my ($self, $id, $gname, $set, $anntype) = @_;\n    my $stype = $set->{_type}->{Characters};\n    $self->{curr_loc}      = [];\n    $self->{curr_tags}     = {};\n    $self->{curr_subfeats} = [];\n    $self->{curr_strand}   = 0;\n    my @feats = ();\n    my $tags = $self->{curr_tags};\n    my $sname = $set->{_name}->{Characters} ||\n        $set->{Attributes}->{id};\n\n    if ( $set->{Attributes}->{problem} ) {\n        $tags->{problem} = [$set->{Attributes}->{problem}];\n    }\n\n    my @fcount = grep { $_->{Name} eq 'feature_span' } @{$set->{Children}};\n    \n    if ( @fcount == 1 ) {\n\t$self->_build_feature_set($set, 1);\n\tmy ($feat) = @{$self->{curr_subfeats}};\n\t$feat->primary_tag('transcript') if $feat->primary_tag eq 'exon';\n\tif ( $feat->primary_tag eq 'transcript' ) {\n\t    $feat->add_tag_value( gene => ($gname || $id) )\n\t\tunless $feat->has_tag('gene');\n\t}\n        \n        my %seen_tag;\n\tfor my $tag ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$tag}} ) {\n\t\t$feat->add_tag_value( $tag => $val ) \n\t\t    if $val && ++$seen_tag{$tag.$val} < 2;\n\t    }\n\t}\n\t@feats = ($feat);\n    }\n    else {\n\t$self->{curr_ltag}     = $id;\n\t$self->{curr_cds}      = '';\n\t$gname = $id if $gname eq 'gene';\n\t$self->{curr_gname} = $gname;\n\n\tif ( $self->has_gene ) {\n\t    unless ( $anntype =~/RNA/i ) {\n\t\t$stype =~ s/transcript/mRNA/;\n\t    }\n\t}\n\t\n\t$self->{curr_feat}  = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t\t    -primary => $stype,\n\t\t\t\t\t\t\t    -id      => $id,\n\t\t\t\t\t\t\t    );\n\tmy $feat = $self->{curr_feat};\n\t$self->_build_feature_set($set);\n\t\n\tmy $gene = $gname || $self->{curr_ltag};\n\t\n\t$feat->add_tag_value( gene => $gene )\n\t    unless $feat->has_tag('gene');\n\n\t# if there is an annotated protein product\n\tmy $cds = $self->_has_CDS( $feat );\n\n\tif ( $cds ) {\n            $feat->primary_tag('mRNA');\n\n\t    # we really just want one value here\n\t    $cds->remove_tag('standard_name') if $cds->has_tag('standard_name');\n\t    $cds->add_tag_value( standard_name => $sname );\n\t    $cds->remove_tag('gene') if $cds->has_tag('gene');\n\t    $cds->add_tag_value( gene => $gene );\n\t    \n            # catch empty protein ids\n            if ( $cds->has_tag('protein_id' ) && !$cds->get_tag_values('protein_id') ) {\n\t\tmy $pid = $self->protein_id($cds, $sname);\n\t\t$cds->remove_tag('protein_id');\n\t\t$cds->add_tag_value( protein_id => $pid );\n\t    }\n\n\t    # make sure other subfeats are tied to the transcript\n            # via a 'standard_name' qualifier and the gene via a 'gene' qualifier\n\t    my @subfeats = @{$self->{curr_subfeats}};\n            for my $sf ( @ subfeats ) {\n                $sf->add_tag_value( standard_name => $sname )\n\t\t    unless $sf->has_tag('standard_name');\n                $sf->add_tag_value( gene => $gene )\n\t\t    unless $sf->has_tag('gene');\n            }\n\t    \n\t    $feat->add_tag_value( standard_name => $sname )\n\t\tunless $feat->has_tag('standard_name');\n\t    $feat->add_tag_value( gene => $gene )\n\t\tunless $feat->has_tag('gene');\n\n            # if the mRNA and CDS are the same length, the mRNA is redundant\n            # lose the mRNA, steal its tags and give them to the CDS\n            my %seen;\n\t    if ( $feat->length == $cds->length ) {\n\t\tfor my $t ( $feat->all_tags ) {\n\t\t    next if $t =~ /gene|standard_name/;\n\t\t    $cds->add_tag_value( $t => $feat->get_tag_values($t) );\n\t\t}\n\t\tundef $feat;\n\t    }\n\n\t    @feats = sort { $a->start <=> $b->start } ($cds, @subfeats);\n\t    unshift @feats, $feat if $feat;\n\t}\n\telse {\n\t    if ( @{$self->{curr_loc}} > 1 ) {\n\t\tmy $loc = Bio::Location::Split->new( -splittype => 'JOIN' );\n\t\t\n\t\t# sort the exons in ascending start order\n\t\tmy @loc = sort { $a->start <=> $b->start } @{$self->{curr_loc}};\n\t\t\n\t\t# then add them to the transcript location\n\t\tfor ( @loc ) {\n\t\t    $loc->add_sub_Location( $_ ) \n\t\t}\n\t\t$feat->location( $loc );\n\t    }\n\t    else {\n\t\t$feat->location( $self->{curr_loc}->[0] );\n\t    }\t\n \t    \n\t    for ( keys %$tags ) {\n\t\t# expunge duplicate gene attributes\n\t\tnext if /gene/ && $feat->has_tag('gene');\n\t\tfor my $v ( @{$tags->{$_}} ) {\n\t\t    $feat->add_tag_value( $_ => $v );\n\t\t}\n\t    }\n\n\t    # make sure other subfeats are tied to the transcript\n\t    my @subfeats = @{$self->{curr_subfeats}};\n\t    for my $sf ( @ subfeats ) {\n\t\t$sf->add_tag_value( standard_name => $sname )\n\t\t    unless $sf->has_tag('standard_name');\n\t\t$sf->add_tag_value( gene => $gene )\n\t\t    unless $sf->has_tag('gene');\n\t    }\n\n\t    @feats = ( $feat, @subfeats );\n\t}\n    }\n    \n    # adjust the maximum extent of the annotated feature \n    # if req'd (ie the <annotation> element)\n    $self->{curr_coords}->[0] ||= 1000000000000;\n    $self->{curr_coords}->[1] ||= -1000000000000;\n    for ( @feats ) {\n        if ( $self->{curr_coords}->[0] > $_->start ) {\n\t    $self->{curr_coords}->[0] = $_->start;\n\t}\n\tif ( $self->{curr_coords}->[1] < $_->end ) {\n\t    $self->{curr_coords}->[1] = $_->end;\n\t}\n    }\n    \n    $self->flush( $set );\n\n    return @feats;\n}\n\n\n=head2 _build_feature_set\n\n Title   : _build_feature_set\n Usage   : $self->_build_feature_set($set, 1) # 1 flag means retain the exon as a subfeat\n Function: an internal method to process attributes and subfeats of a feature set\n Returns : nothing\n Args    : $set -- a <feature_set> element\n           1    -- optional flag to retain exons as subfeats.  Otherwise, they will\n                   be converted to sublocations of a parent CDS feature\n\n\n\nsub _build_feature_set {\n    my ($self, $set, $keep_subfeat) = @_;\n\n    for my $child ( @{$set->{Children}} ) {\n        my $name = $child->{Name};\n\n        # these elements require special handling\n        if ( $name eq 'date' ) {\n            $self->date( $child );\n        }\n        elsif ( $name eq 'comment' ) {\n            $self->comment( $child );\n        }\n        elsif ( $name eq 'evidence' ) {\n            $self->evidence( $child );\n        }\n        elsif ( $name eq 'feature_span' ) {\n            $self->_add_feature_span( $child, $keep_subfeat );\n\t}\n        elsif ( $name eq 'property' ) {\n            $self->property( $child );\n        }\n\n        # need to add the db_xref tags to the gene?\n        # otherwise, simple tag/value pairs\n        elsif ( $name =~ /synonym|author|description/) {\n            $self->{curr_tags}->{$name} = [$child->{Characters}];\n        }\n        elsif ( $name !~ /name|type|seq/ ){\n            $self->complain(\"Unrecognized element '$name'. I don't \" .\n                            \"know what to do with $name elements\");\n\n        }\n    }\n}\n\n=head2 _add_feature_span\n\n Title   : _add_feature_span\n Usage   : $self->_add_feature_span($el, 1)\n Function: an internal method to process <feature_span> elements\n Returns : nothing\n Args    : $el -- a <feature_span> element\n           1   -- an optional flag to retain exons as subfeatures"},"line":606,"range":{"end":{"line":619,"character":9999},"start":{"character":0,"line":606}},"kind":12,"definition":"sub","detail":"($self,$el,$keep_subfeat)","children":[{"definition":"my","line":607,"name":"$self","localvar":"my","kind":13,"containerName":"_add_feature_span"},{"line":607,"name":"$el","containerName":"_add_feature_span","kind":13},{"kind":13,"containerName":"_add_feature_span","name":"$keep_subfeat","line":607},{"definition":"my","name":"$tags","containerName":"_add_feature_span","localvar":"my","kind":13,"line":609},{"line":609,"name":"$self","containerName":"_add_feature_span","kind":13},{"localvar":"my","kind":13,"containerName":"_add_feature_span","name":"$feat","line":610,"definition":"my"},{"line":610,"kind":13,"containerName":"_add_feature_span","name":"$self"},{"name":"$type","localvar":"my","containerName":"_add_feature_span","kind":13,"line":611,"definition":"my"},{"containerName":"_add_feature_span","kind":13,"name":"$el","line":611},{"containerName":"_add_feature_span","kind":13,"name":"$el","line":611},{"definition":"my","localvar":"my","containerName":"_add_feature_span","kind":13,"name":"$id","line":612},{"line":612,"containerName":"_add_feature_span","kind":13,"name":"$el"},{"line":612,"name":"$el","kind":13,"containerName":"_add_feature_span"},{"name":"$seqr","kind":13,"localvar":"my","containerName":"_add_feature_span","line":613,"definition":"my"},{"line":613,"containerName":"_add_feature_span","kind":13,"name":"$el"},{"line":614,"name":"$start","localvar":"my","containerName":"_add_feature_span","kind":13,"definition":"my"},{"line":614,"name":"$seqr","kind":13,"containerName":"_add_feature_span"},{"line":615,"localvar":"my","containerName":"_add_feature_span","kind":13,"name":"$end","definition":"my"},{"line":615,"name":"$seqr","containerName":"_add_feature_span","kind":13},{"definition":"my","name":"$stype","containerName":"_add_feature_span","localvar":"my","kind":13,"line":616},{"line":616,"kind":13,"containerName":"_add_feature_span","name":"$seqr"},{"definition":"my","line":617,"localvar":"my","kind":13,"containerName":"_add_feature_span","name":"$seqid"},{"name":"$seqr","containerName":"_add_feature_span","kind":13,"line":617},{"line":619,"name":"$self","kind":13,"containerName":"_add_feature_span"}],"containerName":"main::","name":"_add_feature_span"},{"name":"curr_tags","kind":12,"line":609},{"kind":12,"name":"curr_feat","line":610},{"line":611,"name":"_type","kind":12},{"line":611,"name":"Characters","kind":12},{"line":611,"kind":12,"name":"Name"},{"line":612,"name":"Attributes","kind":12},{"line":612,"name":"id","kind":12},{"name":"_name","kind":12,"line":612},{"kind":12,"name":"Characters","line":612},{"name":"_seq_relationship","kind":12,"line":613},{"name":"_span","kind":12,"line":614},{"name":"_start","kind":12,"line":614},{"kind":12,"name":"Characters","line":614},{"line":615,"kind":12,"name":"_span"},{"kind":12,"name":"_end","line":615},{"kind":12,"name":"Characters","line":615},{"line":616,"name":"Attributes","kind":12},{"line":616,"kind":12,"name":"type"},{"line":617,"kind":12,"name":"Attributes"},{"kind":12,"name":"seq","line":617},{"line":619,"name":"seq_l","kind":12},{"line":619,"name":"%self","containerName":null,"kind":13},{"kind":12,"name":"seq_h","line":619},{"containerName":null,"kind":13,"name":"$seqid","line":619},{"line":621,"kind":13,"containerName":null,"name":"$start"},{"containerName":null,"kind":13,"name":"%end","line":621},{"line":622,"containerName":null,"kind":13,"name":"%self"},{"line":622,"kind":12,"name":"curr_strand"},{"line":623,"containerName":null,"kind":13,"name":"$start"},{"line":623,"name":"$end","kind":13,"containerName":null},{"line":623,"containerName":null,"kind":13,"name":"$end"},{"name":"%start","kind":13,"containerName":null,"line":623},{"containerName":null,"kind":13,"name":"%self","line":626},{"kind":12,"name":"curr_strand","line":626},{"line":630,"kind":13,"containerName":null,"name":"%type"},{"definition":"my","line":631,"name":"$sl","containerName":null,"localvar":"my","kind":13},{"line":631,"kind":12,"containerName":"Location::Simple","name":"Bio"},{"name":"new","kind":12,"containerName":"main::","line":631},{"line":631,"name":"$start","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$end","line":632},{"line":633,"name":"%self","containerName":null,"kind":13},{"line":633,"kind":12,"name":"curr_strand"},{"line":634,"kind":13,"containerName":null,"name":"%self"},{"line":634,"name":"curr_loc","kind":12},{"kind":13,"containerName":null,"name":"$sl","line":634},{"line":638,"kind":13,"containerName":null,"name":"%type"},{"name":"%self","containerName":null,"kind":13,"line":639},{"line":639,"kind":12,"name":"curr_tags"},{"name":"codon_start","kind":12,"line":639},{"line":639,"name":"%start","containerName":null,"kind":13},{"line":642,"containerName":null,"kind":13,"name":"%type"},{"line":643,"name":"$keep_subfeat","kind":13,"containerName":null},{"line":645,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"name":"curr_subfeats","line":645},{"line":646,"name":"Bio","kind":12,"containerName":"SeqFeature::Generic"},{"kind":12,"containerName":"main::","name":"new","line":646},{"kind":13,"containerName":null,"name":"$start","line":646},{"name":"$end","containerName":null,"kind":13,"line":647},{"name":"%self","kind":13,"containerName":null,"line":648},{"line":648,"kind":12,"name":"curr_strand"},{"kind":13,"containerName":null,"name":"$type","line":649},{"definition":"my","line":653,"localvar":"my","kind":13,"containerName":null,"name":"$tscript"},{"name":"%el","containerName":null,"kind":13,"line":653},{"kind":12,"name":"Attributes","line":653},{"kind":12,"name":"produces_seq","line":653},{"line":654,"name":"$tscript","kind":13,"containerName":null},{"line":654,"name":"%tscript","containerName":null,"kind":13},{"definition":"my","line":655,"localvar":"my","kind":13,"containerName":null,"name":"$subseq"},{"line":655,"kind":13,"containerName":null,"name":"%self"},{"name":"seq_h","kind":12,"line":655},{"containerName":null,"kind":13,"name":"%el","line":655},{"name":"Attributes","kind":12,"line":655},{"kind":12,"name":"produces_seq","line":655},{"containerName":null,"kind":13,"name":"%self","line":656},{"line":656,"name":"curr_tags","kind":12},{"name":"product","kind":12,"line":656},{"line":656,"containerName":null,"kind":13,"name":"%el"},{"kind":12,"name":"Attributes","line":656},{"line":656,"kind":12,"name":"produces_seq"},{"containerName":null,"kind":13,"name":"%self","line":657},{"kind":12,"name":"curr_tags","line":657},{"line":657,"kind":12,"name":"translation"},{"name":"$subseq","containerName":null,"kind":13,"line":657},{"line":657,"name":"seq","containerName":"main::","kind":12},{"name":"$subseq","containerName":null,"kind":13,"line":657},{"line":660,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"flush","line":660},{"kind":13,"containerName":null,"name":"$el","line":660},{"definition":"sub","detail":"($self,$feat,$tags)","children":[{"definition":"my","line":675,"name":"$self","containerName":"_add_CDS","localvar":"my","kind":13},{"line":675,"name":"$feat","containerName":"_add_CDS","kind":13},{"name":"$tags","containerName":"_add_CDS","kind":13,"line":675},{"line":676,"localvar":"my","kind":13,"containerName":"_add_CDS","name":"$loc","definition":"my"},{"name":"$single","containerName":"_add_CDS","localvar":"my","kind":13,"line":677,"definition":"my"},{"containerName":"_add_CDS","kind":13,"name":"$self","line":679}],"name":"_add_CDS","containerName":"main::","signature":{"documentation":"1;\n# $Id: featHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n#\n# Helper module for Bio::SeqIO::game::featHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::featHandler -- a class for handling feature elements\n\n=head1 SYNOPSIS\n\nThis module is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::featHandler converts game XML E<lt>annotationE<gt>\nelements into flattened Bio::SeqFeature::Generic objects to be added\nto the sequence\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::featHandler;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Location::Split;\nuse Data::Dumper;\nuse strict;\n\nuse vars qw {};                                                                                \n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $featHandler = Bio::SeqIO::game::featHandler->new($seq, $seq_h, $ann_l)\n Function: creates an object to deal with sequence features \n Returns : a handler object\n Args    : $seq   -- a Bio::SeqI compliant object\n           $seq_h -- ref. to a hash of other sequences associated \n                     with the main sequence (proteins, etc)\n           $ann_l -- ref. to a list of annotations\n\n\nsub new {\n    my ($caller, $seq, $seq_h, $ann_l  ) = @_;\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ({                                                                             \n        seq           => $seq,                                                                           \n        curr_feats    => [],\n\tcurr_coords   => [],\n\tseq_h         => $seq_h,\n\tann_l         => $ann_l,\n    }, $class);\n\n    return $self;\n}\n\n=head2 add_source\n\n Title   : add_source\n Usage   : $featHandler->add_source($seq->length, \\%tags);\n Function: creates a source feature\n Returns : a Bio::SeqFeature::Generic object \n Args    : sequence length and a ref. to a hash of tag/value attributes\n\n\nsub add_source {\n    my ($self, $length, $tags) = @_;\n    my $feat = Bio::SeqFeature::Generic->new( -primary => 'source',\n\t\t\t\t\t      -start   => 1,\n\t\t\t\t\t      -end     => $length,\n\t\t\t\t\t    );\n    for ( keys %{$tags} ) {\n\tfor my $val ( @{$tags->{$_}} ) {\n\t    $feat->add_tag_value( $_ => $val );\n\t}\n    }\n\n    return $feat;\n}\n\n=head2 has_gene\n\n Title   : has_gene\n Usage   : my $gene = $self->_has_gene($gene, $gname, $id)\n Function: method to get/set the current gene feature\n Returns : a Bio::SeqFeature::Generic object (if there is a gene)\n Args    : (optional)\n           $gene  -- an XML element for the annotation\n           $gname -- gene name\n           $id    -- gene ID (not always the same as the name)\n\n\nsub has_gene {\n    my ($self, $gene, $gname, $id) = @_;\n    \n    # use name preferentially over id. We can't edit IDs in Apollo\n    # AFAIK, and this will create an orphan CDS for newly created \n    # transcipts -- I think this needs more work\n    #$id = $gname if $id && $gname;\n\n    unless ( $gene ) {\n\tif ( defined $self->{curr_gene} ) {\n\t    return $self->{curr_gene};\n\t}\n        else {\n\t    return 0;\n        }\n    }\n    else {\n        if ( $id && !$self->{curr_ltag} ) {\n\t    $self->{curr_ltag} = $id;\n\t}\n\tif ( $gname && !$self->{curr_gname} ) {\n\t    $self->{curr_gname} = $gname;\n\t}\n\t    \n\tmy $tags  = {};\n\t\n\tfor my $child ( @{$gene->{Children}} ) {\n\t    my $name = $child->{Name};\n\n\t    if ( $name eq 'dbxref' ) {\n\t        $tags->{dbxref} ||= [];\n\t\tpush @{$tags->{dbxref}}, $self->dbxref( $child );\n\t    }\n            elsif ( $name !~ /name/ ){\n                $self->complain(\"Unrecognized element '$name'. I don't \" .\n\t\t\t        \"know what to do with $name elements\");\n\t    }\n\t}\n\t\n\tmy $feat = Bio::SeqFeature::Generic->new( \n\t    -primary => 'gene',\n\t);\n        my %seen;\n\tfor ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val ) unless ++$seen{$_.$val} > 1;\n\t    }\n\t}\n\t    \n\t$self->{curr_gene} = $feat;\n\treturn $feat;\n    }\t\n}\n\n=head2 _has_CDS\n\n Title   : _has_CDS\n Usage   : my $cds = $self->_has_CDS\n Function: internal getter/setter for CDS features\n Returns : a Bio::SeqFeature::Generic transcript object (or nothing)\n Args    : a Bio::SeqFeature::Generic transcript feature\n\n\nsub _has_CDS {\n    my ($self, $transcript) = @_;\n\n    if ( !$transcript ) {\n\tif ( defined $self->{curr_cds} ) {\n\t    return $self->{curr_cds};\n        }\n\telse {\n\t    return 0;\n\t}\n    }\n    else {\n\tmy $tags = $self->{curr_tags};\n\t$self->{curr_cds} = $self->_add_CDS( $transcript, $tags );\n    }\n}\n\n=head2 add_annotation\n\n Title   : add_annotation\n Usage   : $featHandler->add_annotation($seq, $type, $id, $tags, $feats)\n Function: converts a containment hierarchy into an ordered list of flat features\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub add_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n\n    # is this a generic feature?\n    unless ( $self->has_gene ) {\n\tshift;\n\t$self->_add_generic_annotation(@_);\n\treturn 0;\n    }\n\n    my $feat;\n\n    if ( $type eq 'gene' ) {\n\t$feat = $self->has_gene;\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');\n    }\n    else {\n\t$feat = Bio::SeqFeature::Generic->new;\n\t$feat->primary_tag($type);\n\tmy $gene = $self->has_gene;\n\t$gene->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $gene->has_tag('gene');\n\t$feat->add_tag_value( gene => ($self->{curr_gname} || $id) )\n\t    unless $feat->has_tag('gene');;\n    }\n    for ( keys %{$tags} ) {\n\t# or else add simple tag/value pairs\n\tif ( $_ eq 'name' && $tags->{type}->[0] eq 'gene' ) {\n\t    $feat->add_tag_value( gene => $tags->{name}->[0] )\n\t\tunless $feat->has_tag( 'gene' );\n\t    delete $tags->{name};\n\t}\n\telse {\n\t    next if $_ eq 'type' && $tags->{$_}->[0] eq 'gene';\n\t    next if $_ eq 'gene' && $feat->has_tag( 'gene' );\n\t    for my $val ( @{$tags->{$_}} ) {\n\t\t$feat->add_tag_value( $_ => $val );\n\t    }\n\t}\n    }\n\n\n    $feat->strand( $self->{curr_strand} );\n    $feat->start( $self->{curr_coords}->[0] );\n    $feat->end( $self->{curr_coords}->[1] );\n\n    # create an array of features for the annotation (order matters)\n    my @annotations = ( $feat );\n\n    # add the gene feature if the annotation is not a gene\n    if ( $self->has_gene && $type ne 'gene') {\n\tmy $gene = $self->has_gene;\n\t$gene->strand( $self->{curr_strand} );\n\t$gene->start( $self->{curr_coords}->[0] );\n        $gene->end( $self->{curr_coords}->[-1] );\n\tpush @annotations, $gene;\n\t$self->{curr_gene} = '';\n    }\n\n    # add the subfeatures\n    for ( @{$feats} ) {\n\t$self->complain(\"bad feature $_\") unless ref($_) =~ /Bio/;\n\tpush @annotations, $_;\n    }\n    \n    # add the annotation array to the list for this sequence\n    my $seqid = $seq->id;\n    my $list = $self->{ann_l};\n    \n    # make sure the feature_sets appear in ascending order\n    if ( $list->[0] && $annotations[0]->start < $list->[0]->start ) {\n\t    unshift @{$list}, @annotations;\n       }\n    else {\n        push @{$list}, @annotations;\n    }\n\n    # garbage collection\n    $self->{curr_gene}   = '';\n    $self->{curr_ltag}   = '';\n    $self->{curr_gname}  = '';\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;    \n    $self->flush;\n}\n\n\n=head2 _add_generic_annotation\n\n Title   : _add_generic_annotation\n Usage   : $self->_add_generic_annotation($seq, $type, $id, $tags, $feats)\n Function: an internal method to handle non-gene annotations\n Returns : nothing\n Args    : $seq   -- a Bio::SeqI compliant object\n           $type  -- the annotation type\n           $id    -- the anotation ID\n           $tags  -- ref. to a hash of tag/value attributes\n           $feats -- ref to an array of Bio::SeqFeature::Generic objects\n\n\nsub _add_generic_annotation {\n    my ($self, $seq, $type, $id, $tags, $feats) = @_;\n    \n    for ( @$feats ) {\n\t$_->primary_tag($type);\n    }\n\n    push @{$self->{ann_l}}, @$feats;\n\n    $self->{curr_coords} = [];\n    $self->{curr_feats}  = [];\n    $self->{curr_strand} = 0;\n    $self->{ann_seq}     = $seq;\n    $self->flush;\n}\n\n\n=head2 feature_set\n\n Title   : feature_set\n Usage   : push @feats, $featHandler->feature_set($id, $gname, $set, $anntype);\n Function: handles <feature_span> hierarchies (usually a transcript)\n Returns : a list of Bio::SeqFeature::Generic objects\n Args    : $id      -- ID of the feature set\n           $gname   -- name of the gene\n           $set     -- the <feature_set> object\n           $anntype -- type of the parent annotation\n\n\n\n\nsub feature_set {\n    my ($self, $id, $gname, $set, $anntype) = @_;\n    my $stype = $set->{_type}->{Characters};\n    $self->{curr_loc}      = [];\n    $self->{curr_tags}     = {};\n    $self->{curr_subfeats} = [];\n    $self->{curr_strand}   = 0;\n    my @feats = ();\n    my $tags = $self->{curr_tags};\n    my $sname = $set->{_name}->{Characters} ||\n        $set->{Attributes}->{id};\n\n    if ( $set->{Attributes}->{problem} ) {\n        $tags->{problem} = [$set->{Attributes}->{problem}];\n    }\n\n    my @fcount = grep { $_->{Name} eq 'feature_span' } @{$set->{Children}};\n    \n    if ( @fcount == 1 ) {\n\t$self->_build_feature_set($set, 1);\n\tmy ($feat) = @{$self->{curr_subfeats}};\n\t$feat->primary_tag('transcript') if $feat->primary_tag eq 'exon';\n\tif ( $feat->primary_tag eq 'transcript' ) {\n\t    $feat->add_tag_value( gene => ($gname || $id) )\n\t\tunless $feat->has_tag('gene');\n\t}\n        \n        my %seen_tag;\n\tfor my $tag ( keys %{$tags} ) {\n\t    for my $val ( @{$tags->{$tag}} ) {\n\t\t$feat->add_tag_value( $tag => $val ) \n\t\t    if $val && ++$seen_tag{$tag.$val} < 2;\n\t    }\n\t}\n\t@feats = ($feat);\n    }\n    else {\n\t$self->{curr_ltag}     = $id;\n\t$self->{curr_cds}      = '';\n\t$gname = $id if $gname eq 'gene';\n\t$self->{curr_gname} = $gname;\n\n\tif ( $self->has_gene ) {\n\t    unless ( $anntype =~/RNA/i ) {\n\t\t$stype =~ s/transcript/mRNA/;\n\t    }\n\t}\n\t\n\t$self->{curr_feat}  = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t\t    -primary => $stype,\n\t\t\t\t\t\t\t    -id      => $id,\n\t\t\t\t\t\t\t    );\n\tmy $feat = $self->{curr_feat};\n\t$self->_build_feature_set($set);\n\t\n\tmy $gene = $gname || $self->{curr_ltag};\n\t\n\t$feat->add_tag_value( gene => $gene )\n\t    unless $feat->has_tag('gene');\n\n\t# if there is an annotated protein product\n\tmy $cds = $self->_has_CDS( $feat );\n\n\tif ( $cds ) {\n            $feat->primary_tag('mRNA');\n\n\t    # we really just want one value here\n\t    $cds->remove_tag('standard_name') if $cds->has_tag('standard_name');\n\t    $cds->add_tag_value( standard_name => $sname );\n\t    $cds->remove_tag('gene') if $cds->has_tag('gene');\n\t    $cds->add_tag_value( gene => $gene );\n\t    \n            # catch empty protein ids\n            if ( $cds->has_tag('protein_id' ) && !$cds->get_tag_values('protein_id') ) {\n\t\tmy $pid = $self->protein_id($cds, $sname);\n\t\t$cds->remove_tag('protein_id');\n\t\t$cds->add_tag_value( protein_id => $pid );\n\t    }\n\n\t    # make sure other subfeats are tied to the transcript\n            # via a 'standard_name' qualifier and the gene via a 'gene' qualifier\n\t    my @subfeats = @{$self->{curr_subfeats}};\n            for my $sf ( @ subfeats ) {\n                $sf->add_tag_value( standard_name => $sname )\n\t\t    unless $sf->has_tag('standard_name');\n                $sf->add_tag_value( gene => $gene )\n\t\t    unless $sf->has_tag('gene');\n            }\n\t    \n\t    $feat->add_tag_value( standard_name => $sname )\n\t\tunless $feat->has_tag('standard_name');\n\t    $feat->add_tag_value( gene => $gene )\n\t\tunless $feat->has_tag('gene');\n\n            # if the mRNA and CDS are the same length, the mRNA is redundant\n            # lose the mRNA, steal its tags and give them to the CDS\n            my %seen;\n\t    if ( $feat->length == $cds->length ) {\n\t\tfor my $t ( $feat->all_tags ) {\n\t\t    next if $t =~ /gene|standard_name/;\n\t\t    $cds->add_tag_value( $t => $feat->get_tag_values($t) );\n\t\t}\n\t\tundef $feat;\n\t    }\n\n\t    @feats = sort { $a->start <=> $b->start } ($cds, @subfeats);\n\t    unshift @feats, $feat if $feat;\n\t}\n\telse {\n\t    if ( @{$self->{curr_loc}} > 1 ) {\n\t\tmy $loc = Bio::Location::Split->new( -splittype => 'JOIN' );\n\t\t\n\t\t# sort the exons in ascending start order\n\t\tmy @loc = sort { $a->start <=> $b->start } @{$self->{curr_loc}};\n\t\t\n\t\t# then add them to the transcript location\n\t\tfor ( @loc ) {\n\t\t    $loc->add_sub_Location( $_ ) \n\t\t}\n\t\t$feat->location( $loc );\n\t    }\n\t    else {\n\t\t$feat->location( $self->{curr_loc}->[0] );\n\t    }\t\n \t    \n\t    for ( keys %$tags ) {\n\t\t# expunge duplicate gene attributes\n\t\tnext if /gene/ && $feat->has_tag('gene');\n\t\tfor my $v ( @{$tags->{$_}} ) {\n\t\t    $feat->add_tag_value( $_ => $v );\n\t\t}\n\t    }\n\n\t    # make sure other subfeats are tied to the transcript\n\t    my @subfeats = @{$self->{curr_subfeats}};\n\t    for my $sf ( @ subfeats ) {\n\t\t$sf->add_tag_value( standard_name => $sname )\n\t\t    unless $sf->has_tag('standard_name');\n\t\t$sf->add_tag_value( gene => $gene )\n\t\t    unless $sf->has_tag('gene');\n\t    }\n\n\t    @feats = ( $feat, @subfeats );\n\t}\n    }\n    \n    # adjust the maximum extent of the annotated feature \n    # if req'd (ie the <annotation> element)\n    $self->{curr_coords}->[0] ||= 1000000000000;\n    $self->{curr_coords}->[1] ||= -1000000000000;\n    for ( @feats ) {\n        if ( $self->{curr_coords}->[0] > $_->start ) {\n\t    $self->{curr_coords}->[0] = $_->start;\n\t}\n\tif ( $self->{curr_coords}->[1] < $_->end ) {\n\t    $self->{curr_coords}->[1] = $_->end;\n\t}\n    }\n    \n    $self->flush( $set );\n\n    return @feats;\n}\n\n\n=head2 _build_feature_set\n\n Title   : _build_feature_set\n Usage   : $self->_build_feature_set($set, 1) # 1 flag means retain the exon as a subfeat\n Function: an internal method to process attributes and subfeats of a feature set\n Returns : nothing\n Args    : $set -- a <feature_set> element\n           1    -- optional flag to retain exons as subfeats.  Otherwise, they will\n                   be converted to sublocations of a parent CDS feature\n\n\n\nsub _build_feature_set {\n    my ($self, $set, $keep_subfeat) = @_;\n\n    for my $child ( @{$set->{Children}} ) {\n        my $name = $child->{Name};\n\n        # these elements require special handling\n        if ( $name eq 'date' ) {\n            $self->date( $child );\n        }\n        elsif ( $name eq 'comment' ) {\n            $self->comment( $child );\n        }\n        elsif ( $name eq 'evidence' ) {\n            $self->evidence( $child );\n        }\n        elsif ( $name eq 'feature_span' ) {\n            $self->_add_feature_span( $child, $keep_subfeat );\n\t}\n        elsif ( $name eq 'property' ) {\n            $self->property( $child );\n        }\n\n        # need to add the db_xref tags to the gene?\n        # otherwise, simple tag/value pairs\n        elsif ( $name =~ /synonym|author|description/) {\n            $self->{curr_tags}->{$name} = [$child->{Characters}];\n        }\n        elsif ( $name !~ /name|type|seq/ ){\n            $self->complain(\"Unrecognized element '$name'. I don't \" .\n                            \"know what to do with $name elements\");\n\n        }\n    }\n}\n\n=head2 _add_feature_span\n\n Title   : _add_feature_span\n Usage   : $self->_add_feature_span($el, 1)\n Function: an internal method to process <feature_span> elements\n Returns : nothing\n Args    : $el -- a <feature_span> element\n           1   -- an optional flag to retain exons as subfeatures\n\n\n\n\nsub _add_feature_span {\n    my ($self, $el, $keep_subfeat) = @_;\n\n    my $tags  = $self->{curr_tags};\n    my $feat  = $self->{curr_feat};\n    my $type  = $el->{_type}->{Characters} || $el->{Name};\n    my $id    = $el->{Attributes}->{id} || $el->{_name}->{Characters};\n    my $seqr  = $el->{_seq_relationship};\n    my $start = int $seqr->{_span}->{_start}->{Characters};\n    my $end   = int $seqr->{_span}->{_end}->{Characters};\n    my $stype = $seqr->{Attributes}->{type}; \n    my $seqid = $seqr->{Attributes}->{seq};\n\n    push @{$self->{seq_l}}, $self->{seq_h}->{$seqid};\n\n    if ( $start > $end ) {\n\t$self->{curr_strand} = -1;\n\t($start, $end) = ($end, $start);\n    }\n    else {\n\t$self->{curr_strand} = 1;\n    }\n\n    # add exons to the transcript\n    if ( $type eq 'exon' ) {\n\tmy $sl = Bio::Location::Simple->new( -start  => $start,\n                                             -end    => $end,\n                                             -strand => $self->{curr_strand} );\n        push @{$self->{curr_loc}}, $sl;\n    }\n    \n    # apollo and gadfly use different tags for the same thing \n    if ( $type =~ /start_codon|translate offset/ ) {\n        $self->{curr_tags}->{codon_start} = [$start];\n    }\n    else { \n\tif ( $type eq 'exon' ) {\n\t    return unless $keep_subfeat;\n\t}\n\tpush @{$self->{curr_subfeats}}, \n\tBio::SeqFeature::Generic->new( -start   => $start,\n\t\t\t\t       -end     => $end,\n\t\t\t\t       -strand  => $self->{curr_strand},\n\t\t\t\t       -primary => $type );\n    }\n\n    # identify the translation product     \n    my $tscript = $el->{Attributes}->{produces_seq};\n    if ( $tscript && $tscript ne 'null') {\n\tmy $subseq = $self->{seq_h}->{$el->{Attributes}->{produces_seq}};\n        $self->{curr_tags}->{product} = [$el->{Attributes}->{produces_seq}];\n\t$self->{curr_tags}->{translation} = [$subseq->seq] if $subseq;\n    }      \n\n    $self->flush( $el );\n}\n\n=head2 _add_CDS\n\n Title   : _add_CDS\n Usage   : my $cds = $self->_add_CDS($transcript, $tags)\n Function: an internal method to create a CDS feature from a transcript feature\n Returns : a Bio::SeqFeature::Generic object\n Args    : $transcript -- a Bio::SeqFeature::Generic object for a transcript\n           $tags       -- ref. to a hash of tag/value attributes","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$tags"}],"label":"_add_CDS($self,$feat,$tags)"},"line":674,"range":{"end":{"character":9999,"line":679},"start":{"line":674,"character":0}},"kind":12},{"line":679,"kind":12,"name":"curr_loc"},{"line":680,"containerName":null,"kind":13,"name":"$loc"},{"kind":12,"containerName":"Location::Split","name":"Bio","line":680},{"name":"new","containerName":"main::","kind":12,"line":680},{"definition":"my","line":683,"localvar":"my","containerName":null,"kind":13,"name":"@loc"},{"line":683,"name":"$a","kind":13,"containerName":null},{"line":683,"containerName":"main::","kind":12,"name":"start"},{"name":"$b","kind":13,"containerName":null,"line":683},{"line":683,"containerName":"main::","kind":12,"name":"start"},{"line":683,"kind":13,"containerName":null,"name":"%self"},{"line":683,"kind":12,"name":"curr_loc"},{"name":"@loc","containerName":null,"kind":13,"line":686},{"line":687,"kind":13,"containerName":null,"name":"$loc"},{"kind":12,"containerName":"main::","name":"add_sub_Location","line":687},{"name":"$loc","kind":13,"containerName":null,"line":691},{"line":691,"containerName":null,"kind":13,"name":"%self"},{"line":691,"name":"curr_loc","kind":12},{"kind":13,"containerName":null,"name":"$single","line":692},{"line":696,"name":"@exons","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"$single","kind":13,"containerName":null,"line":696},{"name":"$loc","kind":13,"containerName":null,"line":696},{"name":"$loc","containerName":null,"kind":13,"line":696},{"line":696,"containerName":"main::","kind":12,"name":"sub_Location"},{"kind":13,"containerName":null,"name":"$feat","line":698},{"line":698,"name":"location","containerName":"main::","kind":12},{"line":698,"kind":13,"containerName":null,"name":"$loc"},{"localvar":"my","kind":13,"containerName":null,"name":"$seq","line":700,"definition":"my"},{"line":700,"containerName":null,"kind":13,"name":"%self"},{"line":700,"name":"seq_h","kind":12},{"line":700,"name":"%tags","containerName":null,"kind":13},{"kind":12,"name":"protein_id","line":700},{"containerName":null,"kind":13,"name":"$seq","line":701},{"line":701,"name":"%self","kind":13,"containerName":null},{"kind":12,"name":"seq_h","line":701},{"name":"%tags","kind":13,"containerName":null,"line":701},{"line":701,"kind":12,"name":"product"},{"line":702,"name":"%self","containerName":null,"kind":13},{"line":702,"kind":12,"name":"seq_h"},{"name":"%tags","containerName":null,"kind":13,"line":702},{"line":702,"name":"gene","kind":12},{"line":703,"name":"%self","containerName":null,"kind":13},{"name":"seq_h","kind":12,"line":703},{"name":"%tags","containerName":null,"kind":13,"line":703},{"line":703,"kind":12,"name":"standard_name"},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$start","line":710},{"line":710,"name":"$stop","containerName":null,"kind":13},{"line":710,"containerName":null,"kind":13,"name":"$peptide"},{"containerName":null,"kind":13,"name":"%seq","line":711},{"name":"$peptide","kind":13,"containerName":null,"line":712},{"name":"$seq","containerName":null,"kind":13,"line":712},{"line":712,"name":"display_id","kind":12,"containerName":"main::"},{"definition":"my","line":713,"localvar":"my","containerName":null,"kind":13,"name":"$desc"},{"name":"$seq","kind":13,"containerName":null,"line":713},{"line":713,"name":"description","containerName":"main::","kind":12},{"line":714,"kind":13,"containerName":null,"name":"$desc"},{"kind":13,"containerName":null,"name":"$desc","line":715},{"kind":13,"containerName":null,"name":"%desc","line":717},{"line":718,"name":"$start","containerName":null,"kind":13},{"line":718,"name":"$stop","kind":13,"containerName":null},{"line":718,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"name":"offset","line":718},{"containerName":null,"kind":13,"name":"%self","line":718},{"kind":12,"name":"offset","line":718},{"line":722,"containerName":null,"kind":13,"name":"$start"},{"line":722,"name":"$loc","kind":13,"containerName":null},{"line":722,"kind":12,"containerName":"main::","name":"start"},{"line":723,"name":"$stop","kind":13,"containerName":null},{"name":"$loc","kind":13,"containerName":null,"line":723},{"line":723,"name":"end","containerName":"main::","kind":12},{"line":727,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"warn","line":727},{"line":727,"name":"$feat","containerName":null,"kind":13},{"line":727,"containerName":"main::","kind":12,"name":"display_name"},{"line":730,"kind":13,"containerName":null,"name":"%tags"},{"line":730,"name":"transcript","kind":12},{"definition":"my","line":733,"name":"@exons_to_add","localvar":"my","containerName":null,"kind":13},{"line":735,"containerName":null,"kind":13,"name":"@exons"},{"definition":"my","line":736,"name":"$exon","localvar":"my","kind":13,"containerName":null},{"name":"Bio","kind":12,"containerName":"Location::Simple","line":736},{"name":"new","containerName":"main::","kind":12,"line":736},{"line":738,"name":"end","kind":12,"containerName":"main::"},{"line":738,"name":"$start","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"start","line":738},{"line":738,"kind":13,"containerName":null,"name":"%stop"},{"line":742,"name":"start","kind":12,"containerName":"main::"},{"line":742,"containerName":null,"kind":13,"name":"$start"},{"line":742,"kind":12,"containerName":"main::","name":"end"},{"containerName":null,"kind":13,"name":"%start","line":742},{"kind":13,"containerName":null,"name":"$exon","line":744},{"line":744,"name":"start","kind":12,"containerName":"main::"},{"line":744,"kind":13,"containerName":null,"name":"$start"},{"line":746,"containerName":"main::","kind":12,"name":"end"},{"containerName":null,"kind":13,"name":"$stop","line":746},{"line":746,"kind":12,"containerName":"main::","name":"start"},{"containerName":null,"kind":13,"name":"%stop","line":746},{"line":748,"kind":13,"containerName":null,"name":"$exon"},{"name":"end","kind":12,"containerName":"main::","line":748},{"name":"$stop","containerName":null,"kind":13,"line":748},{"name":"$exon","containerName":null,"kind":13,"line":751},{"name":"valid_Location","containerName":"main::","kind":12,"line":751},{"containerName":null,"kind":13,"name":"$exon","line":752},{"line":752,"kind":12,"containerName":"main::","name":"start"},{"line":752,"kind":12,"containerName":"main::","name":"start"},{"containerName":null,"kind":13,"name":"$exon","line":753},{"line":753,"containerName":"main::","kind":12,"name":"end"},{"containerName":"main::","kind":12,"name":"end","line":753},{"name":"$exon","containerName":null,"kind":13,"line":755},{"line":755,"containerName":"main::","kind":12,"name":"strand"},{"line":755,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"name":"curr_strand","line":755},{"containerName":null,"kind":13,"name":"@exons_to_add","line":756},{"containerName":null,"kind":13,"name":"$exon","line":756},{"line":759,"name":"$cds_loc","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"@exons_to_add","containerName":null,"kind":13,"line":760},{"line":761,"kind":13,"containerName":null,"name":"$cds_loc"},{"line":761,"containerName":"Location::Split","kind":12,"name":"Bio"},{"line":761,"name":"new","containerName":"main::","kind":12},{"line":762,"name":"@exons_to_add","kind":13,"containerName":null},{"line":763,"containerName":null,"kind":13,"name":"$cds_loc"},{"line":763,"name":"add_sub_Location","kind":12,"containerName":"main::"},{"line":767,"name":"$cds_loc","kind":13,"containerName":null},{"name":"@exons_to_add","kind":13,"containerName":null,"line":767},{"name":"$parent","containerName":null,"localvar":"my","kind":13,"line":770,"definition":"my"},{"kind":13,"containerName":null,"name":"%self","line":770},{"kind":12,"name":"curr_gname","line":770},{"name":"%self","containerName":null,"kind":13,"line":770},{"line":770,"name":"curr_ltag","kind":12},{"line":773,"containerName":null,"localvar":"my","kind":13,"name":"%cds_tags","definition":"my"},{"definition":"my","name":"$k","kind":13,"localvar":"my","containerName":null,"line":774},{"name":"%tags","kind":13,"containerName":null,"line":774},{"containerName":null,"kind":13,"name":"%k","line":775},{"name":"%cds_tags","containerName":null,"kind":13,"line":776},{"line":776,"kind":13,"containerName":null,"name":"$k"},{"name":"%tags","containerName":null,"kind":13,"line":776},{"name":"$k","containerName":null,"kind":13,"line":776},{"name":"%tags","kind":13,"containerName":null,"line":777},{"name":"$k","containerName":null,"kind":13,"line":777},{"line":781,"name":"%tags","containerName":null,"kind":13},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$v","line":782},{"line":782,"containerName":null,"kind":13,"name":"%tags"},{"name":"$feat","kind":13,"containerName":null,"line":783},{"name":"add_tag_value","containerName":"main::","kind":12,"line":783},{"name":"$v","kind":13,"containerName":null,"line":783},{"line":784,"name":"$feat","containerName":null,"kind":13},{"line":784,"kind":12,"containerName":"main::","name":"has_tag"},{"kind":13,"containerName":null,"name":"%self","line":788},{"kind":12,"name":"curr_gname","line":788},{"kind":13,"containerName":null,"name":"%cds_tags","line":789},{"kind":12,"name":"gene","line":789},{"name":"%self","containerName":null,"kind":13,"line":789},{"kind":12,"name":"curr_gname","line":789},{"definition":"my","line":792,"name":"$gene","localvar":"my","kind":13,"containerName":null},{"line":792,"name":"$self","kind":13,"containerName":null},{"name":"has_gene","kind":12,"containerName":"main::","line":792},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$cds","line":794},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":794},{"line":794,"kind":12,"containerName":"main::","name":"new"},{"line":796,"name":"$cds_loc","containerName":null,"kind":13},{"line":799,"kind":13,"containerName":null,"name":"%cds_tags"},{"kind":12,"name":"translation","line":799},{"line":799,"name":"$seq","kind":13,"containerName":null},{"line":799,"name":"seq","containerName":"main::","kind":12},{"name":"%cds_tags","containerName":null,"kind":13,"line":801},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"%seen","line":802},{"kind":13,"localvar":"my","containerName":null,"name":"$val","line":803,"definition":"my"},{"line":803,"name":"%cds_tags","containerName":null,"kind":13},{"name":"%seen","containerName":null,"kind":13,"line":804},{"line":804,"name":"$val","containerName":null,"kind":13},{"line":805,"containerName":null,"kind":13,"name":"$cds"},{"name":"add_tag_value","containerName":"main::","kind":12,"line":805},{"line":805,"kind":13,"containerName":null,"name":"$val"},{"containerName":null,"kind":13,"name":"$cds","line":809}],"version":5}