{"version":5,"vars":[{"containerName":"Carp::Data::Dumper::XML::Writer::IO::File::IO::Handle::Bio::Seq::Bio::Seq::RichSeq::Bio::SeqIO::FTHelper::Bio::Species::Bio::Seq::SeqFactory::Bio::Factory::SequenceStreamI::Bio::SeqFeature::Generic::Bio::Annotation::Collection::Bio::Annotation::Comment::Bio::Annotation::Reference::Bio::Annotation::DBLink::Bio::SeqFeature::Tools","kind":2,"name":"Unflattener","line":243},{"definition":"my","line":243,"containerName":null,"localvar":"my","kind":13,"name":"%finaldatahash"},{"line":244,"localvar":"my","kind":13,"containerName":null,"name":"%datahash","definition":"my"},{"definition":"my","name":"$chadotables","containerName":null,"localvar":"my","kind":13,"line":246},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"%fkey","line":248},{"kind":13,"localvar":"my","containerName":null,"name":"%cv_name","line":278,"definition":"my"},{"definition":"my","line":284,"containerName":null,"localvar":"my","kind":13,"name":"%feattype_args2so"},{"line":303,"kind":13,"localvar":"my","containerName":null,"name":"%organism","definition":"my"},{"name":"base","kind":2,"containerName":"","line":305},{"signature":{"label":"_initialize($self,%args)","parameters":[{"label":"$self"},{"label":"%args"}],"documentation":""},"line":307,"range":{"start":{"character":0,"line":307},"end":{"line":324,"character":9999}},"kind":12,"definition":"sub","detail":"($self,%args)","children":[{"name":"$self","localvar":"my","containerName":"_initialize","kind":13,"line":309,"definition":"my"},{"line":309,"name":"%args","containerName":"_initialize","kind":13},{"name":"$self","kind":13,"containerName":"_initialize","line":311},{"name":"%args","kind":13,"containerName":"_initialize","line":311},{"line":312,"name":"$self","kind":13,"containerName":"_initialize"},{"line":312,"kind":12,"containerName":"_initialize","name":"sequence_factory"},{"line":313,"name":"$self","kind":13,"containerName":"_initialize"},{"line":313,"name":"sequence_factory","kind":12,"containerName":"_initialize"},{"containerName":"_initialize","kind":12,"name":"new","line":314},{"line":314,"kind":13,"containerName":"_initialize","name":"$self"},{"line":314,"name":"verbose","kind":12,"containerName":"_initialize"},{"kind":13,"containerName":"_initialize","name":"$self","line":318},{"containerName":"_initialize","kind":12,"name":"suppress_residues","line":318},{"line":318,"kind":13,"containerName":"_initialize","name":"$args"},{"name":"$args","kind":13,"containerName":"_initialize","line":319},{"kind":13,"containerName":"_initialize","name":"$self","line":321},{"name":"allow_residues","containerName":"_initialize","kind":12,"line":321},{"line":321,"containerName":"_initialize","kind":13,"name":"$args"},{"line":322,"name":"$args","kind":13,"containerName":"_initialize"}],"containerName":"main::","name":"_initialize"},{"name":"SUPER","kind":12,"containerName":"_initialize","line":311},{"name":"Bio","containerName":"Seq::SeqFactory","kind":12,"line":313},{"signature":{"label":"write_seq($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: chadoxml.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::chadoxml\n#\n# Peili Zhang   <peili@morgan.harvard.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::chadoxml - chadoxml sequence output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    $writer = Bio::SeqIO->new(-file => \">chado.xml\",\n                              -format => 'chadoxml');\n\n    # assume you already have Sequence or SeqFeature objects\n    $writer->write_seq($seq_obj);\n\n    #after writing all seqs\n    $writer->close_chadoxml();\n\n\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to chadoxml flat\nfile databases (for chadoxml DTD, see\nhttp://gmod.cvs.sourceforge.net/gmod/schema/chado/dat/chado.dtd).\n\nThis is currently a write-only module.\n\n    $seqio = Bio::SeqIO->new(-file => '>outfile.xml',\n                             -format => 'chadoxml'\n                             -suppress_residues => 1,\n                             -allow_residues => 'chromosome',\n                             );\n\n    # we have a Bio::Seq object $seq which is a gene located on\n    # chromosome arm 'X', to be written out to chadoxml\n    # before converting to chadoxml, $seq object B<must> be transformed\n    # so that all the coordinates in $seq are against the source\n    # feature to be passed into Bio::SeqIO::chadoxml->write_seq()\n    # -- chromosome arm X in the example below.\n\n    $seqio->write_seq(-seq=>$seq,\n                      -genus   => 'Homo',\n                      -species => 'sapiens',\n                      -seq_so_type=>'gene',\n                      -src_feature=>'X',\n                      -src_feat_type=>'chromosome_arm',\n                        -nounflatten=>1,\n                      -is_analysis=>'true',\n                      -data_source=>'GenBank');\n\nThe chadoxml output of Bio::SeqIO::chadoxml-E<gt>write_seq() method can be\npassed to the loader utility in XORT package\n(http://gmod.cvs.sourceforge.net/gmod/schema/XMLTools/XORT/)\nto be loaded into chado.\n\nThis object is currently implemented to work with sequence and\nannotation data from whole genome projects deposited in GenBank. It\nmay not be able to handle all different types of data from all\ndifferent sources.\n\nIn converting a Bio::Seq object into chadoxml, a top-level feature is\ncreated to represent the object and all sequence features inside the\nBio::Seq object are treated as subfeatures of the top-level\nfeature. The Bio::SeqIO::chadoxml object calls\nBio::SeqFeature::Tools::Unflattener to unflatten the flat feature list\ncontained in the subject Bio::Seq object, to build gene model\ncontainment hierarchy conforming to chado central dogma model: gene\n--E<gt> mRNA --E<gt> exons and protein.\n\nDestination of data in the subject Bio::Seq object $seq is as following:\n\n    *$seq->display_id:  name of the top-level feature;\n\n    *$seq->accession_number: if defined, uniquename and\n                 feature_dbxref of the top-level\n                 feature if not defined,\n                 $seq->display_id is used as the\n                 uniquename of the top-level feature;\n\n    *$seq->molecule: transformed to SO type, used as the feature\n            type of the top-level feature if -seq_so_type\n            argument is supplied, use the supplied SO type\n            as the feature type of the top-level feature;\n\n    *$seq->species: organism of the top-level feature;\n\n    *$seq->seq: residues of the top-level feature;\n\n    *$seq->is_circular, $seq->division: feature_cvterm;\n\n    *$seq->keywords, $seq->desc, comments: featureprop;\n\n    *references: pub and feature_pub;\n        medline/pubmed ids: pub_dbxref;\n        comments: pubprop;\n\n    *feature \"source\" span: featureloc for top-level feature;\n\n    *feature \"source\" db_xref: feature_dbxref for top-level feature;\n\n    *feature \"source\" other tags: featureprop for top-level feature;\n\n    *subfeature 'symbol' or 'label' tag: feature uniquename, if\n                     none of these is present, the chadoxml object\n                     generates feature uniquenames as:\n                     <gene>-<feature_type>-<span>\n                     (e.g. foo-mRNA--1000..3000);\n\n    *gene model: feature_relationship built based on the\n                     containment hierarchy;\n\n    *feature span: featureloc;\n\n    *feature accession numbers: feature_dbxref;\n\n    *feature tags (except db_xref, symbol and gene): featureprop;\n\nThings to watch out for:\n\n    *chado schema change: this version works with the chado\n                               version tagged chado_1_01 in GMOD CVS.\n\n    *feature uniquenames: especially important if using XORT\n                              loader to do incremental load into\n                              chado. may need pre-processing of the\n                              source data to put the correct\n                              uniquenames in place.\n\n    *pub uniquenames: chadoxml->write_seq() has the FlyBase policy\n                          on pub uniquenames hard-coded, it assigns\n                          pub uniquenames in the following way: for\n                          journals and books, use ISBN number; for\n                          published papers, use MEDLINE ID; for\n                          everything else, use FlyBase unique\n                          identifier FBrf#. need to modify the code to\n                          implement your policy. look for the comments\n                          in the code.\n\n    *for pubs possibly existing in chado but with no knowledge of\n         its uniquename:put \"op\" as \"match\", then need to run the\n                        output chadoxml through a special filter that\n                        talks to chado database and tries to find the\n                        pub by matching with the provided information\n                        instead of looking up by the unique key. after\n                        matching, the filter also resets the \"match\"\n                        operation to either \"force\" (default), or\n                        \"lookup\", or \"insert\", or \"update\". the\n                        \"match\" operation is for a special FlyBase use\n                        case. please modify to work according to your\n                        rules.\n\n    *chado initialization for loading:\n\n        cv & cvterm: in the output chadoxml, all cv's and\n                             cvterm's are lookup only. Therefore,\n                             before using XORT loader to load the\n                             output into chado, chado must be\n                             pre-loaded with all necessary CVs and\n                             CVterms, including \"SO\" , \"property\n                             type\", \"relationship type\", \"pub type\",\n                             \"pubprop type\", \"pub relationship type\",\n                             \"sequence topology\", \"GenBank feature\n                             qualifier\", \"GenBank division\". A pub by\n                             the uniquename 'nullpub' of type 'null\n                             pub' needs to be inserted.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR - Peili Zhang\n\nEmail peili@morgan.harvard.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::chadoxml;\nuse strict;\nuse English;\n\nuse Carp;\nuse Data::Dumper;\nuse XML::Writer;\nuse IO::File;\nuse IO::Handle;\nuse Bio::Seq;\nuse Bio::Seq::RichSeq;\nuse Bio::SeqIO::FTHelper;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\nuse Bio::Factory::SequenceStreamI;\nuse Bio::SeqFeature::Generic;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::SeqFeature::Tools::Unflattener;\n\n#global variables\nundef(my %finaldatahash); #data from Bio::Seq object stored in a hash\nundef(my %datahash); #data from Bio::Seq object stored in a hash\n\nmy $chadotables = 'feature featureprop feature_relationship featureloc feature_cvterm cvterm cv feature_pub pub pub_dbxref pub_author author pub_relationship pubprop feature_dbxref dbxref db synonym feature_synonym';\n\nmy %fkey = (\n    \"cvterm.cv_id\"          => \"cv\",\n        \"cvterm.dbxref_id\"              => \"dbxref\",\n    \"dbxref.db_id\"          => \"db\",\n    \"feature.type_id\"       => \"cvterm\",\n    \"feature.organism_id\"       => \"organism\",\n    \"feature.dbxref_id\"         => \"dbxref\",\n    \"featureprop.type_id\"       => \"cvterm\",\n    \"feature_pub.pub_id\"        => \"pub\",\n    \"feature_cvterm.cvterm_id\"  => \"cvterm\",\n    \"feature_cvterm.pub_id\"     => \"pub\",\n        \"feature_cvterm.feature_id\"     => \"feature\",\n    \"feature_dbxref.dbxref_id\"  => \"dbxref\",\n    \"feature_relationship.object_id\"    => \"feature\",\n    \"feature_relationship.subject_id\"   => \"feature\",\n    \"feature_relationship.type_id\"  => \"cvterm\",\n    \"featureloc.srcfeature_id\"  => \"feature\",\n    \"pub.type_id\"           => \"cvterm\",\n    \"pub_dbxref.dbxref_id\"      => \"dbxref\",\n    \"pub_author.author_id\"      => \"author\",\n    \"pub_relationship.obj_pub_id\"   => \"pub\",\n    \"pub_relationship.subj_pub_id\"  => \"pub\",\n    \"pub_relationship.type_id\"  => \"cvterm\",\n    \"pubprop.type_id\"       => \"cvterm\",\n        \"feature_synonym.feature_id\"    => \"feature\",\n        \"feature_synonym.synonym_id\"    => \"synonym\",\n        \"feature_synonym.pub_id\"        => \"pub\",\n        \"synonym.type_id\"               => \"cvterm\",\n);\n\nmy %cv_name = (\n        'relationship'                  => 'relationship',\n        'sequence'                      => 'sequence',\n        'feature_property'              => 'feature_property',\n);\n\nmy %feattype_args2so = (\n    \"aberr\"             => \"aberration_junction\",\n#   \"conflict\"          => \"sequence_difference\",\n#   \"polyA_signal\"          => \"polyA_signal_sequence\",\n    \"variation\"         => \"sequence_variant\",\n    \"mutation1\"         => \"point_mutation\",        #for single-base mutation\n    \"mutation2\"         => \"sequence_variant\",      #for multi-base mutation\n    \"rescue\"            => \"rescue_fragment\",\n#   \"rfrag\"             => \"restriction_fragment\",\n    \"protein_bind\"          => \"protein_binding_site\",\n    \"misc_feature\"          => \"region\",\n#   \"prim_transcript\"       => \"primary_transcript\",\n    \"CDS\"               => \"polypeptide\",\n    \"reg_element\"           => \"regulatory_region\",\n    \"seq_variant\"           => \"sequence_variant\",\n    \"mat_peptide\"           => \"mature_peptide\",\n    \"sig_peptide\"           => \"signal_peptide\",\n);\n\nundef(my %organism);\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n\n    my($self,%args) = @_;\n\n    $self->SUPER::_initialize(%args);\n    unless( defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n    #optional arguments that can be passed in\n    $self->suppress_residues($args{'-suppress_residues'})\n        if defined $args{'-suppress_residues'};\n\n    $self->allow_residues($args{'-allow_residues'})\n        if defined $args{'-allow_residues'};\n    return;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(-seq=>$seq, -seq_so_type=>$seqSOtype,\n                  -src_feature=>$srcfeature,\n                  -src_feat_type=>$srcfeattype,\n                  -nounflatten=>0 or 1,\n                  -is_analysis=>'true' or 'false',\n                  -data_source=>$datasource)\n Function: writes the $seq object (must be seq) into chadoxml.\n Returns : 1 for success and 0 for error\n Args     : A Bio::Seq object $seq, optional $seqSOtype, $srcfeature,\n            $srcfeattype, $nounflatten, $is_analysis and $data_source.\n\nWhen $srcfeature (a string, the uniquename of the source feature) is given, the\nlocation and strand information of the top-level feature against the source\nfeature will be derived from the sequence feature called 'source' of the $seq\nobject, a featureloc record is generated for the top -level feature on\n$srcfeature. when $srcfeature is given, $srcfeattype must also be present. All\nfeature coordinates in $seq should be against $srcfeature. $seqSOtype is the\noptional SO term to use as the type of the top-level feature. For example, a\nGenBank data file for a Drosophila melanogaster genome scaffold has the molecule\ntype of \"DNA\", when converting to chadoxml, a $seqSOtype argument of\n\"golden_path_region\" can be supplied to save the scaffold as a feature of type\n\"golden_path_region\" in chadoxml, instead of \"DNA\". a feature with primary tag\nof 'source' must be present in the sequence feature list of $seq, to decribe the\nwhole sequence record.\n\nIn the current implementation:\n\n=over 3\n\n* *\n\nnon-mRNA records\n\nA top-level feature of type $seq-E<gt>alphabet is generated for the whole GenBank\nrecord, features listed are unflattened for DNA records to build gene model\nfeature graph, and for the other types of records all features in $seq are\ntreated as subfeatures of the top-level feature.\n\n* *\n\nmRNA records\n\nIf a 'gene' feature is present, it B<must> have a /symbol or /label tag to\ncontain the uniquename of the gene. a top-level feature of type 'gene' is\ngenerated. the mRNA is written as a subfeature of the top-level gene feature,\nand the other sequence features listed in $seq are treated as subfeatures of the\nmRNA feature."},"line":381,"kind":12,"range":{"start":{"character":0,"line":381},"end":{"line":1184,"character":9999}},"definition":"sub","detail":"($self,@args)","children":[{"line":382,"kind":13,"localvar":"my","containerName":"write_seq","name":"$usage","definition":"my"},{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"write_seq","line":404},{"line":404,"name":"@args","containerName":"write_seq","kind":13},{"line":406,"name":"$seq","kind":13,"localvar":"my","containerName":"write_seq","definition":"my"},{"line":406,"name":"$seq_so_type","containerName":"write_seq","kind":13},{"name":"$srcfeature","containerName":"write_seq","kind":13,"line":406},{"kind":13,"containerName":"write_seq","name":"$srcfeattype","line":406},{"kind":13,"containerName":"write_seq","name":"$nounflatten","line":406},{"line":406,"kind":13,"containerName":"write_seq","name":"$isanalysis"},{"line":406,"name":"$datasource","containerName":"write_seq","kind":13},{"line":406,"name":"$genus","containerName":"write_seq","kind":13},{"name":"$species","kind":13,"containerName":"write_seq","line":406},{"containerName":"write_seq","kind":13,"name":"$self","line":407},{"line":407,"kind":12,"containerName":"write_seq","name":"_rearrange"},{"name":"@args","kind":13,"containerName":"write_seq","line":417},{"line":420,"containerName":"write_seq","kind":13,"name":"$seq"},{"kind":13,"containerName":"write_seq","name":"$self","line":421},{"line":421,"name":"throw","kind":12,"containerName":"write_seq"},{"line":424,"containerName":"write_seq","kind":13,"name":"$seq"},{"line":424,"name":"$seq","kind":13,"containerName":"write_seq"},{"kind":12,"containerName":"write_seq","name":"isa","line":424},{"line":430,"name":"$srcfeature","containerName":"write_seq","kind":13},{"kind":13,"containerName":"write_seq","name":"$seq","line":431},{"line":431,"name":"can","containerName":"write_seq","kind":12},{"line":432,"containerName":"write_seq","kind":13,"name":"$srcfeature"},{"name":"$seq","kind":13,"containerName":"write_seq","line":432},{"line":432,"kind":12,"containerName":"write_seq","name":"seq_id"},{"line":432,"containerName":"write_seq","kind":13,"name":"$seq"},{"line":432,"name":"seq_id","kind":12,"containerName":"write_seq"},{"name":"$seq","containerName":"write_seq","kind":13,"line":432},{"line":432,"kind":12,"containerName":"write_seq","name":"display_name"},{"line":437,"kind":13,"containerName":"write_seq","name":"$srcfeature"},{"line":439,"name":"$srcfeature","kind":13,"containerName":"write_seq"},{"name":"$srcfeature","containerName":"write_seq","kind":13,"line":441},{"containerName":"write_seq","kind":13,"name":"$self","line":443},{"line":443,"name":"throw","containerName":"write_seq","kind":12},{"line":443,"name":"$usage","containerName":"write_seq","kind":13},{"line":447,"kind":13,"containerName":"write_seq","name":"$srcfeattype"},{"kind":13,"containerName":"write_seq","name":"$self","line":449},{"line":449,"containerName":"write_seq","kind":12,"name":"throw"},{"line":449,"containerName":"write_seq","kind":13,"name":"$usage"},{"line":452,"kind":13,"containerName":"write_seq","name":"$srcfeattype"},{"line":453,"name":"$srcfeattype","kind":13,"containerName":"write_seq"},{"name":"$self","kind":13,"containerName":"write_seq","line":455},{"line":455,"containerName":"write_seq","kind":12,"name":"throw"},{"line":455,"name":"$usage","kind":13,"containerName":"write_seq"},{"definition":"my","kind":13,"localvar":"my","containerName":"write_seq","name":"$div","line":461},{"line":462,"name":"$hkey","localvar":"my","containerName":"write_seq","kind":13,"definition":"my"},{"definition":"my","line":463,"name":"@top_featureprops","localvar":"my","containerName":"write_seq","kind":13},{"line":464,"containerName":"write_seq","localvar":"my","kind":13,"name":"@featuresyns","definition":"my"},{"definition":"my","line":465,"localvar":"my","kind":13,"containerName":"write_seq","name":"@top_featurecvterms"},{"definition":"my","containerName":"write_seq","localvar":"my","kind":13,"name":"$name","line":466},{"line":466,"containerName":"write_seq","kind":13,"name":"$seq"},{"name":"display_id","kind":12,"containerName":"write_seq","line":466},{"name":"$seq","kind":13,"containerName":"write_seq","line":466},{"kind":12,"containerName":"write_seq","name":"can","line":466},{"line":467,"name":"$name","kind":13,"containerName":"write_seq"},{"line":467,"containerName":"write_seq","kind":13,"name":"$seq"},{"line":467,"containerName":"write_seq","kind":12,"name":"display_name"},{"line":467,"name":"$seq","containerName":"write_seq","kind":13},{"kind":12,"containerName":"write_seq","name":"can","line":467},{"line":468,"localvar":"my","kind":13,"containerName":"write_seq","name":"@feature_cvterms","definition":"my"},{"definition":"my","line":469,"containerName":"write_seq","localvar":"my","kind":13,"name":"%sthash"},{"name":"%dvhash","kind":13,"localvar":"my","containerName":"write_seq","line":470,"definition":"my"},{"line":471,"name":"%h1","localvar":"my","containerName":"write_seq","kind":13,"definition":"my"},{"line":472,"localvar":"my","kind":13,"containerName":"write_seq","name":"%h2","definition":"my"},{"name":"$temp","kind":13,"localvar":"my","containerName":"write_seq","line":473,"definition":"my"},{"definition":"my","name":"$ann","containerName":"write_seq","localvar":"my","kind":13,"line":474},{"definition":"my","line":475,"localvar":"my","kind":13,"containerName":"write_seq","name":"@references"},{"definition":"my","name":"@feature_pubs","kind":13,"localvar":"my","containerName":"write_seq","line":476},{"definition":"my","line":477,"name":"$ref","containerName":"write_seq","localvar":"my","kind":13},{"line":478,"name":"$location","localvar":"my","containerName":"write_seq","kind":13,"definition":"my"},{"definition":"my","line":479,"name":"$fbrf","kind":13,"localvar":"my","containerName":"write_seq"},{"line":480,"name":"$journal","containerName":"write_seq","localvar":"my","kind":13,"definition":"my"},{"definition":"my","containerName":"write_seq","localvar":"my","kind":13,"name":"$issue","line":481},{"name":"$volume","kind":13,"localvar":"my","containerName":"write_seq","line":482,"definition":"my"},{"line":483,"localvar":"my","containerName":"write_seq","kind":13,"name":"$volumeissue","definition":"my"},{"definition":"my","line":484,"localvar":"my","containerName":"write_seq","kind":13,"name":"$pages"},{"definition":"my","kind":13,"localvar":"my","containerName":"write_seq","name":"$year","line":485},{"localvar":"my","containerName":"write_seq","kind":13,"name":"$pubtype","line":486,"definition":"my"},{"name":"$uniquename","kind":13,"localvar":"my","containerName":"write_seq","line":488,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"write_seq","name":"$refhash","line":489},{"definition":"my","line":490,"name":"$feat","kind":13,"localvar":"my","containerName":"write_seq"},{"definition":"my","line":491,"localvar":"my","kind":13,"containerName":"write_seq","name":"$tag"},{"line":492,"name":"$tag_cv","localvar":"my","containerName":"write_seq","kind":13,"definition":"my"},{"definition":"my","name":"$ftype","localvar":"my","containerName":"write_seq","kind":13,"line":493},{"kind":13,"localvar":"my","containerName":"write_seq","name":"$subfeatcnt","line":494,"definition":"my"},{"line":495,"localvar":"my","containerName":"write_seq","kind":13,"name":"@top_featrels","definition":"my"},{"line":496,"localvar":"my","kind":13,"containerName":"write_seq","name":"%srcfhash","definition":"my"},{"name":"$name","kind":13,"containerName":"write_seq","line":500},{"kind":13,"containerName":"write_seq","name":"$seq","line":500},{"line":500,"name":"can","kind":12,"containerName":"write_seq"},{"line":501,"kind":13,"containerName":"write_seq","name":"$name"},{"name":"$seq","containerName":"write_seq","kind":13,"line":501},{"line":501,"containerName":"write_seq","kind":12,"name":"attributes"},{"name":"$seq","containerName":"write_seq","kind":13,"line":504},{"line":504,"kind":12,"containerName":"write_seq","name":"can"},{"line":504,"name":"$seq","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":12,"name":"accession_number","line":504},{"name":"$seq","containerName":"write_seq","kind":13,"line":504},{"kind":12,"containerName":"write_seq","name":"accession_number","line":504},{"name":"$uniquename","kind":13,"containerName":"write_seq","line":505},{"name":"$seq","kind":13,"containerName":"write_seq","line":505},{"line":505,"containerName":"write_seq","kind":12,"name":"accession_number"},{"name":"$seq","containerName":"write_seq","kind":13,"line":506},{"name":"can","kind":12,"containerName":"write_seq","line":506},{"name":"$seq","containerName":"write_seq","kind":13,"line":506},{"line":506,"name":"accession","kind":12,"containerName":"write_seq"},{"line":506,"name":"$seq","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":12,"name":"accession","line":506},{"name":"$uniquename","kind":13,"containerName":"write_seq","line":507},{"kind":13,"containerName":"write_seq","name":"$seq","line":507},{"name":"accession","containerName":"write_seq","kind":12,"line":507},{"name":"$seq","kind":13,"containerName":"write_seq","line":508},{"kind":12,"containerName":"write_seq","name":"can","line":508},{"containerName":"write_seq","kind":13,"name":"$uniquename","line":509},{"line":509,"name":"$seq","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":12,"name":"attributes","line":509},{"line":511,"containerName":"write_seq","kind":13,"name":"$uniquename"},{"kind":13,"containerName":"write_seq","name":"$name","line":511},{"definition":"my","name":"$len","localvar":"my","kind":13,"containerName":"write_seq","line":513},{"line":513,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":513,"name":"length","containerName":"write_seq","kind":12},{"line":514,"name":"$len","kind":13,"containerName":"write_seq"},{"line":515,"kind":13,"containerName":"write_seq","name":"$len"},{"localvar":"my","kind":13,"containerName":"write_seq","name":"$gb_type","line":518,"definition":"my"},{"containerName":"write_seq","kind":13,"name":"$seq","line":519},{"line":519,"name":"can","containerName":"write_seq","kind":12},{"line":519,"containerName":"write_seq","kind":13,"name":"$gb_type"},{"line":519,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":519,"name":"molecule","kind":12,"containerName":"write_seq"},{"name":"$gb_type","containerName":"write_seq","kind":13,"line":520},{"line":520,"name":"$seq","containerName":"write_seq","kind":13},{"name":"can","kind":12,"containerName":"write_seq","line":520},{"name":"$seq","kind":13,"containerName":"write_seq","line":520},{"kind":12,"containerName":"write_seq","name":"alphabet","line":520},{"line":522,"containerName":"write_seq","kind":13,"name":"$gb_type"},{"kind":13,"containerName":"write_seq","name":"$ftype","line":522},{"kind":13,"containerName":"write_seq","name":"$gb_type","line":523},{"kind":13,"containerName":"write_seq","name":"$ftype","line":523},{"line":525,"name":"$seq_so_type","containerName":"write_seq","kind":13},{"line":526,"name":"$seq_so_type","containerName":"write_seq","kind":13},{"line":527,"name":"$ftype","containerName":"write_seq","kind":13},{"line":527,"name":"$seq_so_type","containerName":"write_seq","kind":13},{"line":529,"containerName":"write_seq","kind":13,"name":"$seq"},{"name":"type","kind":12,"containerName":"write_seq","line":529},{"kind":13,"containerName":"write_seq","name":"$ftype","line":530},{"name":"$seq","containerName":"write_seq","kind":13,"line":530},{"name":"type","containerName":"write_seq","kind":12,"line":530},{"kind":13,"containerName":"write_seq","name":"$seq","line":532},{"containerName":"write_seq","kind":12,"name":"type","line":532},{"name":"$ftype","kind":13,"containerName":"write_seq","line":535},{"line":535,"kind":13,"containerName":"write_seq","name":"$gb_type"},{"line":539,"name":"$ftype","kind":13,"containerName":"write_seq"},{"name":"$gb_type","kind":13,"containerName":"write_seq","line":539},{"definition":"my","line":542,"localvar":"my","containerName":"write_seq","kind":13,"name":"%ftype_hash"},{"containerName":"write_seq","kind":13,"name":"$self","line":542},{"line":542,"kind":12,"containerName":"write_seq","name":"return_ftype_hash"},{"kind":13,"containerName":"write_seq","name":"$ftype","line":542},{"line":544,"name":"$species","containerName":"write_seq","kind":13},{"name":"%organism","containerName":"write_seq","kind":13,"line":545},{"kind":13,"containerName":"write_seq","name":"$genus","line":545},{"kind":13,"containerName":"write_seq","name":"$species","line":545},{"name":"$spec","localvar":"my","kind":13,"containerName":"write_seq","line":548,"definition":"my"},{"line":548,"containerName":"write_seq","kind":13,"name":"$seq"},{"line":548,"name":"species","kind":12,"containerName":"write_seq"},{"name":"$spec","containerName":"write_seq","kind":13,"line":549},{"kind":13,"containerName":"write_seq","name":"$self","line":550},{"line":550,"name":"throw","kind":12,"containerName":"write_seq"},{"name":"%organism","containerName":"write_seq","kind":13,"line":552},{"kind":13,"containerName":"write_seq","name":"$spec","line":552},{"line":552,"name":"genus","kind":12,"containerName":"write_seq"},{"line":552,"name":"$spec","containerName":"write_seq","kind":13},{"kind":12,"containerName":"write_seq","name":"species","line":552},{"name":"$residues","localvar":"my","kind":13,"containerName":"write_seq","line":556,"definition":"my"},{"kind":13,"containerName":"write_seq","name":"$self","line":557},{"name":"suppress_residues","containerName":"write_seq","kind":12,"line":557},{"name":"$self","containerName":"write_seq","kind":13,"line":558},{"line":558,"kind":12,"containerName":"write_seq","name":"suppress_residues"},{"line":558,"kind":13,"containerName":"write_seq","name":"$self"},{"line":558,"name":"allow_residues","containerName":"write_seq","kind":12},{"line":558,"name":"$ftype","kind":13,"containerName":"write_seq"},{"line":559,"name":"$residues","containerName":"write_seq","kind":13},{"line":559,"kind":13,"containerName":"write_seq","name":"$seq"},{"line":559,"name":"seq","kind":12,"containerName":"write_seq"},{"line":559,"name":"isa","kind":12,"containerName":"write_seq"},{"containerName":"write_seq","kind":13,"name":"$seq","line":560},{"line":560,"name":"seq","containerName":"write_seq","kind":12},{"line":560,"containerName":"write_seq","kind":12,"name":"seq"},{"name":"$seq","containerName":"write_seq","kind":13,"line":561},{"line":561,"name":"seq","kind":12,"containerName":"write_seq"},{"line":564,"name":"$residues","kind":13,"containerName":"write_seq"},{"localvar":"my","containerName":"write_seq","kind":13,"name":"$isanal","line":568,"definition":"my"},{"line":569,"name":"$ftype","kind":13,"containerName":"write_seq"},{"name":"$ftype","kind":13,"containerName":"write_seq","line":569},{"kind":13,"containerName":"write_seq","name":"$ftype","line":569},{"line":569,"containerName":"write_seq","kind":13,"name":"$ftype"},{"kind":13,"containerName":"write_seq","name":"$ftype","line":569},{"kind":13,"containerName":"write_seq","name":"$isanal","line":570},{"line":570,"name":"$isanalysis","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":13,"name":"$isanal","line":571},{"line":571,"name":"$isanal","containerName":"write_seq","kind":13},{"name":"%datahash","containerName":"write_seq","kind":13,"line":574},{"line":575,"containerName":"write_seq","kind":13,"name":"$name"},{"line":576,"containerName":"write_seq","kind":13,"name":"$uniquename"},{"line":577,"name":"$len","kind":13,"containerName":"write_seq"},{"line":578,"kind":13,"containerName":"write_seq","name":"$residues"},{"line":579,"name":"%ftype_hash","containerName":"write_seq","kind":13},{"containerName":"write_seq","kind":13,"name":"%organism","line":580},{"line":581,"name":"$isanal","kind":13,"containerName":"write_seq"},{"line":584,"containerName":"write_seq","kind":13,"name":"$srcfeature"},{"kind":13,"containerName":"write_seq","name":"%srcfhash","line":585},{"name":"$self","kind":13,"containerName":"write_seq","line":585},{"kind":12,"containerName":"write_seq","name":"_srcf_hash","line":585},{"kind":13,"containerName":"write_seq","name":"$srcfeature","line":585},{"line":586,"containerName":"write_seq","kind":13,"name":"$srcfeattype"},{"containerName":"write_seq","kind":13,"name":"%organism","line":587},{"name":"$phase","containerName":"write_seq","localvar":"my","kind":13,"line":589,"definition":"my"},{"name":"$strand","kind":13,"containerName":"write_seq","line":589},{"line":590,"containerName":"write_seq","kind":13,"name":"$seq"},{"containerName":"write_seq","kind":12,"name":"can","line":590},{"name":"$phase","kind":13,"containerName":"write_seq","line":591},{"kind":13,"containerName":"write_seq","name":"$seq","line":591},{"line":591,"kind":12,"containerName":"write_seq","name":"phase"},{"name":"$seq","containerName":"write_seq","kind":13,"line":594},{"line":594,"name":"can","containerName":"write_seq","kind":12},{"name":"$strand","kind":13,"containerName":"write_seq","line":595},{"line":595,"name":"$seq","containerName":"write_seq","kind":13},{"name":"strand","kind":12,"containerName":"write_seq","line":595},{"definition":"my","line":597,"name":"%fl","localvar":"my","kind":13,"containerName":"write_seq"},{"name":"%srcfhash","kind":13,"containerName":"write_seq","line":598},{"name":"$seq","kind":13,"containerName":"write_seq","line":599},{"line":599,"containerName":"write_seq","kind":12,"name":"start"},{"name":"$seq","kind":13,"containerName":"write_seq","line":600},{"kind":12,"containerName":"write_seq","name":"end","line":600},{"line":601,"name":"$strand","containerName":"write_seq","kind":13},{"name":"$phase","kind":13,"containerName":"write_seq","line":602},{"line":605,"containerName":"write_seq","kind":13,"name":"$datahash"},{"line":605,"containerName":"write_seq","kind":13,"name":"%fl"},{"line":611,"name":"$srcfeature","kind":13,"containerName":"write_seq"},{"name":"$srcfeature","kind":13,"containerName":"write_seq","line":612},{"containerName":"write_seq","kind":13,"name":"$uniquename","line":612},{"kind":13,"containerName":"write_seq","name":"$srcfeattype","line":613},{"containerName":"write_seq","kind":13,"name":"$ftype","line":613},{"kind":13,"containerName":"write_seq","name":"$datasource","line":617},{"kind":13,"containerName":"write_seq","name":"$datasource","line":618},{"name":"$datasource","kind":13,"containerName":"write_seq","line":621},{"line":623,"name":"$seq","containerName":"write_seq","kind":13},{"name":"can","containerName":"write_seq","kind":12,"line":623},{"name":"$seq","containerName":"write_seq","kind":13,"line":623},{"line":623,"name":"is_circular","containerName":"write_seq","kind":12},{"line":624,"kind":13,"containerName":"write_seq","name":"%sthash"},{"kind":13,"containerName":"write_seq","name":"%sthash","line":640},{"name":"@feature_cvterms","containerName":"write_seq","kind":13,"line":656},{"line":656,"name":"%sthash","containerName":"write_seq","kind":13},{"line":659,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":659,"kind":12,"containerName":"write_seq","name":"can"},{"kind":13,"containerName":"write_seq","name":"$seq","line":659},{"line":659,"name":"division","containerName":"write_seq","kind":12},{"line":660,"kind":13,"containerName":"write_seq","name":"$div"},{"kind":13,"containerName":"write_seq","name":"$seq","line":660},{"line":660,"name":"division","kind":12,"containerName":"write_seq"},{"line":661,"name":"%dvhash","containerName":"write_seq","kind":13},{"containerName":"write_seq","kind":13,"name":"$div","line":662},{"line":672,"containerName":"write_seq","kind":13,"name":"@feature_cvterms"},{"containerName":"write_seq","kind":13,"name":"%dvhash","line":672},{"name":"$datahash","containerName":"write_seq","kind":13,"line":675},{"kind":13,"containerName":"write_seq","name":"@feature_cvterms","line":675},{"name":"$seq","kind":13,"containerName":"write_seq","line":680},{"line":680,"containerName":"write_seq","kind":12,"name":"can"},{"line":680,"containerName":"write_seq","kind":13,"name":"$seq"},{"name":"desc","kind":12,"containerName":"write_seq","line":680},{"name":"$temp","containerName":"write_seq","kind":13,"line":681},{"line":681,"kind":13,"containerName":"write_seq","name":"$seq"},{"line":681,"kind":12,"containerName":"write_seq","name":"desc"},{"kind":13,"localvar":"my","containerName":"write_seq","name":"%prophash","line":683,"definition":"my"},{"line":687,"name":"$cv_name","containerName":"write_seq","kind":13},{"name":"$temp","containerName":"write_seq","kind":13,"line":690},{"line":693,"containerName":"write_seq","kind":13,"name":"@top_featureprops"},{"name":"%prophash","kind":13,"containerName":"write_seq","line":693},{"line":697,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":697,"name":"can","containerName":"write_seq","kind":12},{"line":698,"name":"$temp","containerName":"write_seq","kind":13},{"line":698,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":698,"kind":12,"containerName":"write_seq","name":"keywords"},{"line":700,"name":"$temp","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":13,"name":"$temp","line":700},{"containerName":"write_seq","kind":13,"name":"$temp","line":700},{"name":"%prophash","localvar":"my","kind":13,"containerName":"write_seq","line":701,"definition":"my"},{"line":705,"name":"$cv_name","kind":13,"containerName":"write_seq"},{"line":708,"name":"$temp","kind":13,"containerName":"write_seq"},{"name":"@top_featureprops","containerName":"write_seq","kind":13,"line":711},{"kind":13,"containerName":"write_seq","name":"%prophash","line":711},{"line":716,"kind":13,"containerName":"write_seq","name":"$seq"},{"line":716,"name":"can","containerName":"write_seq","kind":12},{"line":717,"kind":13,"containerName":"write_seq","name":"$ann"},{"name":"$seq","kind":13,"containerName":"write_seq","line":717},{"line":717,"name":"annotation","containerName":"write_seq","kind":12},{"definition":"my","name":"$comment","localvar":"my","kind":13,"containerName":"write_seq","line":718},{"containerName":"write_seq","kind":13,"name":"$ann","line":718},{"kind":12,"containerName":"write_seq","name":"get_Annotations","line":718},{"line":719,"name":"$temp","kind":13,"containerName":"write_seq"},{"line":719,"containerName":"write_seq","kind":13,"name":"$comment"},{"line":719,"name":"as_text","kind":12,"containerName":"write_seq"},{"containerName":"write_seq","localvar":"my","kind":13,"name":"%prophash","line":721,"definition":"my"},{"line":725,"kind":13,"containerName":"write_seq","name":"$cv_name"},{"name":"$temp","kind":13,"containerName":"write_seq","line":728},{"name":"@top_featureprops","containerName":"write_seq","kind":13,"line":731},{"name":"%prophash","containerName":"write_seq","kind":13,"line":731},{"line":735,"name":"@top_dbxrefs","localvar":"my","containerName":"write_seq","kind":13,"definition":"my"},{"kind":13,"containerName":"write_seq","name":"$seq","line":737},{"line":737,"name":"can","kind":12,"containerName":"write_seq"},{"definition":"my","line":738,"name":"%attributes","localvar":"my","containerName":"write_seq","kind":13},{"line":738,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":738,"kind":12,"containerName":"write_seq","name":"attributes"},{"localvar":"my","kind":13,"containerName":"write_seq","name":"$key","line":739,"definition":"my"},{"line":739,"name":"%attributes","kind":13,"containerName":"write_seq"},{"name":"$key","kind":13,"containerName":"write_seq","line":740},{"name":"$key","kind":13,"containerName":"write_seq","line":741},{"line":743,"name":"$key","containerName":"write_seq","kind":13},{"line":744,"name":"@featuresyns","containerName":"write_seq","kind":13},{"line":744,"containerName":"write_seq","kind":13,"name":"$self"},{"line":744,"containerName":"write_seq","kind":12,"name":"handle_Alias_tag"},{"containerName":"write_seq","kind":13,"name":"$seq","line":744},{"line":744,"kind":13,"containerName":"write_seq","name":"@featuresyns"},{"line":748,"kind":13,"containerName":"write_seq","name":"$key"},{"line":749,"containerName":"write_seq","kind":13,"name":"@top_featurecvterms"},{"line":749,"name":"$self","containerName":"write_seq","kind":13},{"line":749,"kind":12,"containerName":"write_seq","name":"handle_Ontology_tag"},{"containerName":"write_seq","kind":13,"name":"$seq","line":749},{"line":749,"kind":13,"containerName":"write_seq","name":"@top_featurecvterms"},{"name":"$key","kind":13,"containerName":"write_seq","line":752},{"line":752,"kind":13,"containerName":"write_seq","name":"$key"},{"name":"@top_dbxrefs","kind":13,"containerName":"write_seq","line":753},{"line":753,"containerName":"write_seq","kind":13,"name":"$self"},{"line":753,"name":"handle_dbxref","containerName":"write_seq","kind":12},{"containerName":"write_seq","kind":13,"name":"$seq","line":753},{"line":753,"name":"$key","kind":13,"containerName":"write_seq"},{"kind":13,"containerName":"write_seq","name":"@top_dbxrefs","line":753},{"line":756,"containerName":"write_seq","kind":13,"name":"$key"},{"containerName":"write_seq","kind":13,"name":"@top_featureprops","line":757},{"name":"$self","kind":13,"containerName":"write_seq","line":758},{"kind":12,"containerName":"write_seq","name":"handle_unreserved_tags","line":758},{"line":758,"kind":13,"containerName":"write_seq","name":"$seq"},{"line":758,"containerName":"write_seq","kind":13,"name":"$key"},{"name":"@top_featureprops","containerName":"write_seq","kind":13,"line":758},{"line":762,"kind":13,"containerName":"write_seq","name":"$datahash"},{"containerName":"write_seq","kind":13,"name":"@featuresyns","line":762},{"kind":13,"containerName":"write_seq","name":"$seq","line":764},{"line":764,"name":"can","kind":12,"containerName":"write_seq"},{"name":"@top_dbxrefs","containerName":"write_seq","kind":13,"line":765},{"line":765,"kind":13,"containerName":"write_seq","name":"$self"},{"line":765,"kind":12,"containerName":"write_seq","name":"handle_source"},{"containerName":"write_seq","kind":13,"name":"$seq","line":765},{"kind":13,"containerName":"write_seq","name":"@top_dbxrefs","line":765},{"name":"$seq","kind":13,"containerName":"write_seq","line":769},{"line":769,"name":"can","containerName":"write_seq","kind":12},{"kind":13,"containerName":"write_seq","name":"$seq","line":769},{"name":"accession_number","containerName":"write_seq","kind":12,"line":769},{"line":769,"containerName":"write_seq","kind":13,"name":"$seq"},{"line":769,"name":"accession_number","kind":12,"containerName":"write_seq"},{"name":"$db","localvar":"my","kind":13,"containerName":"write_seq","line":770,"definition":"my"},{"line":770,"kind":13,"containerName":"write_seq","name":"$self"},{"line":770,"name":"_guess_acc_db","containerName":"write_seq","kind":12},{"line":770,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":770,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":770,"name":"accession_number","kind":12,"containerName":"write_seq"},{"definition":"my","line":771,"name":"%acchash","localvar":"my","containerName":"write_seq","kind":13},{"containerName":"write_seq","kind":13,"name":"$db","line":772},{"containerName":"write_seq","kind":13,"name":"$seq","line":773},{"kind":12,"containerName":"write_seq","name":"accession_number","line":773},{"kind":13,"containerName":"write_seq","name":"$seq","line":774},{"name":"seq_version","containerName":"write_seq","kind":12,"line":774},{"name":"%fdbx","containerName":"write_seq","localvar":"my","kind":13,"line":776,"definition":"my"},{"kind":13,"containerName":"write_seq","name":"%acchash","line":776},{"line":777,"kind":13,"containerName":"write_seq","name":"@top_dbxrefs"},{"line":777,"containerName":"write_seq","kind":13,"name":"%fdbx"},{"kind":13,"containerName":"write_seq","name":"$seq","line":780},{"line":780,"kind":12,"containerName":"write_seq","name":"isa"},{"line":780,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":780,"name":"get_secondary_accessions","containerName":"write_seq","kind":12},{"definition":"my","line":781,"localvar":"my","containerName":"write_seq","kind":13,"name":"@secacc"},{"line":781,"containerName":"write_seq","kind":13,"name":"$seq"},{"name":"get_secondary_accessions","containerName":"write_seq","kind":12,"line":781},{"definition":"my","name":"$acc","kind":13,"localvar":"my","containerName":"write_seq","line":782},{"line":783,"containerName":"write_seq","kind":13,"name":"$acc"},{"name":"@secacc","containerName":"write_seq","kind":13,"line":783},{"definition":"my","localvar":"my","kind":13,"containerName":"write_seq","name":"%acchash","line":784},{"line":786,"name":"$acc","kind":13,"containerName":"write_seq"},{"definition":"my","kind":13,"localvar":"my","containerName":"write_seq","name":"%fdbx","line":788},{"line":788,"kind":13,"containerName":"write_seq","name":"%acchash"},{"line":789,"name":"@top_dbxrefs","containerName":"write_seq","kind":13},{"name":"%fdbx","containerName":"write_seq","kind":13,"line":789},{"line":794,"containerName":"write_seq","kind":13,"name":"$seq"},{"line":794,"kind":12,"containerName":"write_seq","name":"isa"},{"line":794,"kind":13,"containerName":"write_seq","name":"$seq"},{"containerName":"write_seq","kind":12,"name":"pid","line":794},{"definition":"my","line":795,"name":"$id","containerName":"write_seq","localvar":"my","kind":13},{"name":"$seq","kind":13,"containerName":"write_seq","line":795},{"name":"pid","kind":12,"containerName":"write_seq","line":795},{"definition":"my","line":799,"name":"%acchash","localvar":"my","containerName":"write_seq","kind":13},{"name":"$id","kind":13,"containerName":"write_seq","line":801},{"definition":"my","name":"%fdbx","containerName":"write_seq","localvar":"my","kind":13,"line":803},{"line":803,"kind":13,"containerName":"write_seq","name":"%acchash"},{"line":804,"name":"@top_dbxrefs","containerName":"write_seq","kind":13},{"kind":13,"containerName":"write_seq","name":"%fdbx","line":804},{"line":808,"kind":13,"containerName":"write_seq","name":"$ann"},{"containerName":"write_seq","kind":13,"name":"@references","line":810},{"name":"$ann","kind":13,"containerName":"write_seq","line":810},{"kind":12,"containerName":"write_seq","name":"get_Annotations","line":810},{"line":811,"containerName":"write_seq","kind":13,"name":"$ref"},{"line":811,"name":"@references","kind":13,"containerName":"write_seq"},{"line":812,"localvar":"my","containerName":"write_seq","kind":13,"name":"%pubhash","definition":"my"},{"name":"$refhash","kind":13,"containerName":"write_seq","line":813},{"name":"$ref","kind":13,"containerName":"write_seq","line":813},{"containerName":"write_seq","kind":12,"name":"hash_tree","line":813},{"kind":13,"containerName":"write_seq","name":"$location","line":814},{"containerName":"write_seq","kind":13,"name":"$ref","line":814},{"line":814,"name":"location","kind":12,"containerName":"write_seq"},{"name":"$refhash","kind":13,"containerName":"write_seq","line":814},{"line":818,"name":"$location","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":13,"name":"$location","line":819},{"line":823,"containerName":"write_seq","kind":13,"name":"$fbrf"},{"line":823,"containerName":"write_seq","kind":13,"name":"$PREMATCH"},{"name":"$location","containerName":"write_seq","kind":13,"line":824},{"line":824,"kind":13,"containerName":"write_seq","name":"$POSTMATCH"},{"name":"$location","kind":13,"containerName":"write_seq","line":825},{"line":830,"name":"$location","containerName":"write_seq","kind":13},{"line":831,"containerName":"write_seq","kind":13,"name":"$pubtype"},{"line":832,"kind":13,"containerName":"write_seq","name":"%pubhash"},{"kind":13,"containerName":"write_seq","name":"$ref","line":833},{"line":833,"name":"title","kind":12,"containerName":"write_seq"},{"line":833,"name":"$refhash","containerName":"write_seq","kind":13},{"line":836,"name":"$pubtype","kind":13,"containerName":"write_seq"},{"line":840,"kind":13,"containerName":"write_seq","name":"$location"},{"line":841,"kind":13,"containerName":"write_seq","name":"$pubtype"},{"line":843,"containerName":"write_seq","kind":13,"name":"%pubhash"},{"line":844,"name":"$ref","containerName":"write_seq","kind":13},{"containerName":"write_seq","kind":12,"name":"title","line":844},{"line":844,"containerName":"write_seq","kind":13,"name":"$refhash"},{"name":"$pubtype","containerName":"write_seq","kind":13,"line":847},{"name":"$pyear","kind":13,"localvar":"my","containerName":"write_seq","line":850,"definition":"my"},{"line":851,"name":"$pyear","containerName":"write_seq","kind":13},{"line":851,"name":"$self","containerName":"write_seq","kind":13},{"kind":12,"containerName":"write_seq","name":"_getSubmitYear","line":851},{"line":851,"containerName":"write_seq","kind":13,"name":"$location"},{"name":"$pyear","kind":13,"containerName":"write_seq","line":852},{"name":"$pubhash","kind":13,"containerName":"write_seq","line":853},{"line":853,"kind":13,"containerName":"write_seq","name":"$pyear"},{"line":858,"name":"$location","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":13,"name":"$pubtype","line":859},{"line":862,"containerName":"write_seq","kind":13,"name":"$location"},{"name":"$year","containerName":"write_seq","kind":13,"line":864},{"line":864,"kind":13,"containerName":"write_seq","name":"$MATCH"},{"definition":"my","line":865,"name":"$stuff","localvar":"my","kind":13,"containerName":"write_seq"},{"name":"$PREMATCH","containerName":"write_seq","kind":13,"line":865},{"line":866,"name":"$year","kind":13,"containerName":"write_seq"},{"line":867,"name":"$year","kind":13,"containerName":"write_seq"},{"line":869,"kind":13,"containerName":"write_seq","name":"$stuff"},{"name":"$pages","containerName":"write_seq","kind":13,"line":871},{"containerName":"write_seq","kind":13,"name":"$MATCH","line":871},{"name":"$stuff","kind":13,"containerName":"write_seq","line":872},{"line":872,"containerName":"write_seq","kind":13,"name":"$PREMATCH"},{"line":873,"kind":13,"containerName":"write_seq","name":"$pages"},{"line":874,"name":"$pages","kind":13,"containerName":"write_seq"},{"name":"$stuff","containerName":"write_seq","kind":13,"line":876},{"name":"$volumeissue","kind":13,"containerName":"write_seq","line":878},{"kind":13,"containerName":"write_seq","name":"$MATCH","line":878},{"line":879,"name":"$journal","containerName":"write_seq","kind":13},{"line":879,"kind":13,"containerName":"write_seq","name":"$PREMATCH"},{"name":"$volumeissue","kind":13,"containerName":"write_seq","line":880},{"line":881,"name":"$volumeissue","containerName":"write_seq","kind":13},{"line":882,"kind":13,"containerName":"write_seq","name":"$issue"},{"containerName":"write_seq","kind":13,"name":"$MATCH","line":882},{"line":883,"containerName":"write_seq","kind":13,"name":"$volume"},{"line":883,"name":"$PREMATCH","kind":13,"containerName":"write_seq"},{"name":"$issue","kind":13,"containerName":"write_seq","line":884},{"containerName":"write_seq","kind":13,"name":"$issue","line":885},{"kind":13,"containerName":"write_seq","name":"$volume","line":886},{"line":887,"containerName":"write_seq","kind":13,"name":"$volume"},{"name":"%pubhash","kind":13,"containerName":"write_seq","line":889},{"name":"$ref","kind":13,"containerName":"write_seq","line":890},{"line":890,"name":"title","kind":12,"containerName":"write_seq"},{"line":890,"containerName":"write_seq","kind":13,"name":"$refhash"},{"line":891,"name":"$volume","containerName":"write_seq","kind":13},{"containerName":"write_seq","kind":13,"name":"$issue","line":892},{"line":893,"containerName":"write_seq","kind":13,"name":"$year"},{"line":894,"kind":13,"containerName":"write_seq","name":"$pages"},{"line":898,"kind":13,"containerName":"write_seq","name":"$pubtype"},{"line":901,"containerName":"write_seq","kind":13,"name":"$journal"},{"line":902,"containerName":"write_seq","kind":13,"name":"$journal"},{"line":924,"name":"$pubtype","kind":13,"containerName":"write_seq"},{"line":925,"name":"%pubhash","kind":13,"containerName":"write_seq"},{"line":926,"name":"$ref","kind":13,"containerName":"write_seq"},{"line":926,"name":"title","containerName":"write_seq","kind":12},{"line":926,"name":"$refhash","kind":13,"containerName":"write_seq"},{"line":929,"kind":13,"containerName":"write_seq","name":"$pubtype"},{"definition":"my","name":"$autref","localvar":"my","kind":13,"containerName":"write_seq","line":936},{"line":936,"name":"$self","containerName":"write_seq","kind":13},{"line":936,"name":"_getRefAuthors","containerName":"write_seq","kind":12},{"name":"$ref","containerName":"write_seq","kind":13,"line":936},{"name":"$autref","containerName":"write_seq","kind":13,"line":937},{"name":"$pubhash","kind":13,"containerName":"write_seq","line":938},{"kind":13,"containerName":"write_seq","name":"$autref","line":938},{"line":942,"name":"$pubtype","containerName":"write_seq","kind":13},{"definition":"my","line":943,"containerName":"write_seq","localvar":"my","kind":13,"name":"$autref"},{"containerName":"write_seq","kind":13,"name":"$self","line":943},{"line":943,"name":"_getSubmitAddr","kind":12,"containerName":"write_seq"},{"name":"$ref","kind":13,"containerName":"write_seq","line":943},{"name":"$autref","kind":13,"containerName":"write_seq","line":944},{"line":945,"name":"$pubhash","kind":13,"containerName":"write_seq"},{"line":945,"containerName":"write_seq","kind":13,"name":"$autref"},{"name":"$ref","containerName":"write_seq","kind":13,"line":953},{"line":953,"containerName":"write_seq","kind":12,"name":"comment"},{"kind":13,"containerName":"write_seq","name":"$refhash","line":953},{"name":"$comnt","localvar":"my","kind":13,"containerName":"write_seq","line":954,"definition":"my"},{"containerName":"write_seq","kind":13,"name":"$ref","line":954},{"name":"comment","kind":12,"containerName":"write_seq","line":954},{"kind":13,"containerName":"write_seq","name":"$refhash","line":954},{"line":956,"name":"$pubhash","kind":13,"containerName":"write_seq"},{"name":"$comnt","containerName":"write_seq","kind":13,"line":958},{"line":963,"name":"@pub_dbxrefs","containerName":"write_seq","localvar":"my","kind":13,"definition":"my"},{"containerName":"write_seq","kind":13,"name":"$fbrf","line":964},{"line":965,"name":"@pub_dbxrefs","kind":13,"containerName":"write_seq"},{"kind":13,"containerName":"write_seq","name":"$fbrf","line":965},{"line":967,"name":"$temp","containerName":"write_seq","kind":13},{"kind":13,"containerName":"write_seq","name":"$ref","line":967},{"kind":12,"containerName":"write_seq","name":"medline","line":967},{"name":"@pub_dbxrefs","containerName":"write_seq","kind":13,"line":968},{"line":968,"kind":13,"containerName":"write_seq","name":"$temp"},{"line":970,"name":"$pubhash","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":13,"name":"$temp","line":970},{"kind":13,"containerName":"write_seq","name":"$temp","line":972},{"line":972,"name":"$ref","containerName":"write_seq","kind":13},{"line":972,"name":"pubmed","containerName":"write_seq","kind":12},{"line":973,"name":"@pub_dbxrefs","kind":13,"containerName":"write_seq"},{"line":973,"kind":13,"containerName":"write_seq","name":"$temp"},{"name":"$pubhash","containerName":"write_seq","kind":13,"line":975},{"kind":13,"containerName":"write_seq","name":"@pub_dbxrefs","line":975},{"containerName":"write_seq","kind":13,"name":"$pubhash","line":981},{"line":981,"name":"$pubhash","kind":13,"containerName":"write_seq"},{"name":"$fbrf","kind":13,"containerName":"write_seq","line":982},{"line":983,"name":"$pubhash","kind":13,"containerName":"write_seq"},{"name":"$fbrf","containerName":"write_seq","kind":13,"line":983},{"line":992,"containerName":"write_seq","kind":13,"name":"$ref"},{"name":"start","containerName":"write_seq","kind":12,"line":992},{"line":992,"containerName":"write_seq","kind":13,"name":"$ref"},{"kind":12,"containerName":"write_seq","name":"end","line":992},{"line":992,"name":"$len","kind":13,"containerName":"write_seq"},{"name":"$ref","containerName":"write_seq","kind":13,"line":992},{"name":"start","containerName":"write_seq","kind":12,"line":992},{"kind":13,"containerName":"write_seq","name":"$ref","line":992},{"line":992,"kind":12,"containerName":"write_seq","name":"end"},{"line":993,"name":"@feature_pubs","kind":13,"containerName":"write_seq"},{"line":993,"name":"%pubhash","containerName":"write_seq","kind":13},{"line":999,"name":"%parf","kind":13,"localvar":"my","containerName":"write_seq","definition":"my"},{"line":1000,"kind":13,"containerName":"write_seq","name":"$uniquename"},{"containerName":"write_seq","kind":13,"name":"$ref","line":1000},{"containerName":"write_seq","kind":12,"name":"start","line":1000},{"line":1000,"name":"$ref","containerName":"write_seq","kind":13},{"line":1000,"containerName":"write_seq","kind":12,"name":"end"},{"line":1001,"name":"%organism","containerName":"write_seq","kind":13},{"line":1002,"kind":13,"containerName":"write_seq","name":"$cv_name"},{"line":1004,"name":"%parfsrcf","localvar":"my","kind":13,"containerName":"write_seq","definition":"my"},{"name":"$uniquename","containerName":"write_seq","kind":13,"line":1005},{"name":"%organism","kind":13,"containerName":"write_seq","line":1006},{"name":"%parfloc","containerName":"write_seq","localvar":"my","kind":13,"line":1008,"definition":"my"},{"kind":13,"containerName":"write_seq","name":"%parfsrcf","line":1009},{"kind":13,"containerName":"write_seq","name":"$ref","line":1010},{"name":"start","kind":12,"containerName":"write_seq","line":1010},{"name":"$ref","containerName":"write_seq","kind":13,"line":1011},{"line":1011,"containerName":"write_seq","kind":12,"name":"end"},{"line":1013,"name":"$parf","containerName":"write_seq","kind":13},{"line":1013,"kind":13,"containerName":"write_seq","name":"%parfloc"},{"line":1014,"name":"$parf","kind":13,"containerName":"write_seq"},{"line":1014,"name":"%pubhash","containerName":"write_seq","kind":13},{"definition":"my","containerName":"write_seq","localvar":"my","kind":13,"name":"%ffr","line":1015},{"name":"%parf","kind":13,"containerName":"write_seq","line":1016},{"line":1017,"kind":13,"containerName":"write_seq","name":"$cv_name"},{"containerName":"write_seq","kind":13,"name":"@top_featrels","line":1019},{"containerName":"write_seq","kind":13,"name":"%ffr","line":1019},{"kind":13,"containerName":"write_seq","name":"$datahash","line":1022},{"line":1022,"containerName":"write_seq","kind":13,"name":"@feature_pubs"},{"name":"$srcfeature","kind":13,"containerName":"write_seq","line":1026},{"kind":13,"containerName":"write_seq","name":"%srcfhash","line":1027},{"containerName":"write_seq","kind":13,"name":"$self","line":1027},{"line":1027,"name":"_srcf_hash","kind":12,"containerName":"write_seq"},{"line":1027,"kind":13,"containerName":"write_seq","name":"$srcfeature"},{"line":1028,"name":"$srcfeattype","containerName":"write_seq","kind":13},{"name":"%organism","kind":13,"containerName":"write_seq","line":1029},{"name":"$gb_type","kind":13,"containerName":"write_seq","line":1039},{"line":1039,"name":"$gb_type","containerName":"write_seq","kind":13},{"name":"$nounflatten","kind":13,"containerName":"write_seq","line":1040},{"definition":"my","localvar":"my","containerName":"write_seq","kind":13,"name":"$u","line":1041},{"kind":12,"containerName":"write_seq","name":"new","line":1041},{"name":"$u","containerName":"write_seq","kind":13,"line":1042},{"name":"unflatten_seq","kind":12,"containerName":"write_seq","line":1042},{"line":1042,"name":"$seq","containerName":"write_seq","kind":13},{"name":"@top_sfs","kind":13,"localvar":"my","containerName":"write_seq","line":1045,"definition":"my"},{"kind":13,"containerName":"write_seq","name":"$seq","line":1045},{"line":1045,"containerName":"write_seq","kind":12,"name":"get_SeqFeatures"},{"line":1050,"name":"$datasource","containerName":"write_seq","kind":13},{"line":1051,"containerName":"write_seq","kind":13,"name":"$tag_cv"},{"line":1052,"name":"$datasource","containerName":"write_seq","kind":13},{"line":1053,"kind":13,"containerName":"write_seq","name":"$tag_cv"},{"line":1055,"kind":13,"containerName":"write_seq","name":"$tag_cv"},{"line":1055,"name":"$cv_name","containerName":"write_seq","kind":13},{"definition":"my","line":1058,"containerName":"write_seq","localvar":"my","kind":13,"name":"$si"},{"line":1059,"kind":13,"containerName":"write_seq","name":"$feat"},{"line":1059,"kind":13,"containerName":"write_seq","name":"@top_sfs"},{"line":1062,"containerName":"write_seq","localvar":"my","kind":13,"name":"$prim_tag","definition":"my"},{"line":1062,"name":"$feat","kind":13,"containerName":"write_seq"},{"line":1062,"kind":12,"containerName":"write_seq","name":"primary_tag"},{"line":1066,"containerName":"write_seq","kind":13,"name":"$prim_tag"},{"line":1067,"containerName":"write_seq","kind":13,"name":"$tag"},{"containerName":"write_seq","kind":13,"name":"$feat","line":1067},{"line":1067,"name":"all_tags","containerName":"write_seq","kind":12},{"line":1069,"name":"$tag","containerName":"write_seq","kind":13},{"kind":13,"containerName":"write_seq","name":"$tag","line":1070},{"line":1071,"name":"$tag","kind":13,"containerName":"write_seq"},{"name":"@t1","localvar":"my","containerName":"write_seq","kind":13,"line":1072,"definition":"my"},{"kind":13,"containerName":"write_seq","name":"$feat","line":1072},{"containerName":"write_seq","kind":12,"name":"each_tag_value","line":1072},{"line":1072,"name":"$tag","kind":13,"containerName":"write_seq"},{"line":1073,"kind":13,"containerName":"write_seq","name":"$temp"},{"kind":13,"containerName":"write_seq","name":"@t1","line":1073},{"name":"$temp","kind":13,"containerName":"write_seq","line":1074},{"definition":"my","localvar":"my","containerName":"write_seq","kind":13,"name":"$db","line":1075},{"definition":"my","line":1076,"containerName":"write_seq","localvar":"my","kind":13,"name":"$xref"},{"line":1080,"localvar":"my","kind":13,"containerName":"write_seq","name":"%acchash","definition":"my"},{"line":1081,"name":"$db","containerName":"write_seq","kind":13},{"name":"$xref","kind":13,"containerName":"write_seq","line":1082},{"definition":"my","kind":13,"localvar":"my","containerName":"write_seq","name":"%fdbx","line":1084},{"line":1084,"name":"%acchash","containerName":"write_seq","kind":13},{"name":"@top_dbxrefs","containerName":"write_seq","kind":13,"line":1085},{"kind":13,"containerName":"write_seq","name":"%fdbx","line":1085},{"line":1088,"name":"$tag","containerName":"write_seq","kind":13},{"line":1089,"kind":13,"localvar":"my","containerName":"write_seq","name":"@t1","definition":"my"},{"line":1089,"containerName":"write_seq","kind":13,"name":"$feat"},{"line":1089,"name":"each_tag_value","kind":12,"containerName":"write_seq"},{"name":"$tag","kind":13,"containerName":"write_seq","line":1089},{"line":1090,"name":"$temp","containerName":"write_seq","kind":13},{"kind":13,"containerName":"write_seq","name":"@t1","line":1090},{"line":1094,"kind":13,"containerName":"write_seq","name":"$tag"},{"definition":"my","containerName":"write_seq","localvar":"my","kind":13,"name":"%prophash","line":1095},{"line":1096,"containerName":"write_seq","kind":13,"name":"%prophash"},{"line":1097,"containerName":"write_seq","kind":13,"name":"$tag"},{"kind":13,"containerName":"write_seq","name":"$tag_cv","line":1097},{"name":"$feat","kind":13,"containerName":"write_seq","line":1098},{"containerName":"write_seq","kind":12,"name":"each_tag_value","line":1098},{"kind":13,"containerName":"write_seq","name":"$tag","line":1098},{"line":1100,"containerName":"write_seq","kind":13,"name":"@top_featureprops"},{"line":1100,"name":"%prophash","kind":13,"containerName":"write_seq"},{"name":"$feat","kind":13,"containerName":"write_seq","line":1104},{"line":1104,"kind":12,"containerName":"write_seq","name":"can"},{"definition":"my","line":1105,"name":"$source","localvar":"my","containerName":"write_seq","kind":13},{"containerName":"write_seq","kind":13,"name":"$feat","line":1105},{"containerName":"write_seq","kind":12,"name":"source","line":1105},{"line":1106,"name":"@top_dbxrefs","kind":13,"containerName":"write_seq"},{"line":1106,"kind":13,"containerName":"write_seq","name":"$self"},{"name":"handle_source","containerName":"write_seq","kind":12,"line":1106},{"line":1106,"containerName":"write_seq","kind":13,"name":"$feat"},{"line":1106,"kind":13,"containerName":"write_seq","name":"@top_dbxrefs"},{"line":1110,"kind":13,"localvar":"my","containerName":"write_seq","name":"$fmin","definition":"my"},{"definition":"my","line":1111,"containerName":"write_seq","localvar":"my","kind":13,"name":"$fmax"},{"definition":"my","name":"$strand","kind":13,"localvar":"my","containerName":"write_seq","line":1112},{"definition":"my","localvar":"my","containerName":"write_seq","kind":13,"name":"$phase","line":1113},{"definition":"my","line":1114,"localvar":"my","containerName":"write_seq","kind":13,"name":"%fl"},{"line":1116,"name":"$fmin","containerName":"write_seq","kind":13},{"name":"$feat","kind":13,"containerName":"write_seq","line":1116},{"kind":12,"containerName":"write_seq","name":"start","line":1116},{"line":1117,"containerName":"write_seq","kind":13,"name":"$fmax"},{"line":1117,"name":"$feat","containerName":"write_seq","kind":13},{"name":"end","kind":12,"containerName":"write_seq","line":1117},{"name":"$strand","containerName":"write_seq","kind":13,"line":1118},{"name":"$feat","kind":13,"containerName":"write_seq","line":1118},{"name":"strand","kind":12,"containerName":"write_seq","line":1118},{"line":1120,"name":"$feat","kind":13,"containerName":"write_seq"},{"kind":12,"containerName":"write_seq","name":"can","line":1120},{"name":"$phase","containerName":"write_seq","kind":13,"line":1121},{"line":1121,"containerName":"write_seq","kind":13,"name":"$feat"},{"containerName":"write_seq","kind":12,"name":"phase","line":1121},{"kind":13,"containerName":"write_seq","name":"%fl","line":1124},{"kind":13,"containerName":"write_seq","name":"%srcfhash","line":1125},{"line":1126,"containerName":"write_seq","kind":13,"name":"$fmin"},{"containerName":"write_seq","kind":13,"name":"$fmax","line":1127},{"line":1128,"name":"$strand","kind":13,"containerName":"write_seq"},{"kind":13,"containerName":"write_seq","name":"$phase","line":1129},{"line":1132,"name":"$datahash","kind":13,"containerName":"write_seq"},{"name":"%fl","containerName":"write_seq","kind":13,"line":1132},{"line":1135,"containerName":"write_seq","kind":13,"name":"@top_sfs"},{"kind":13,"containerName":"write_seq","name":"$si","line":1135},{"line":1137,"containerName":"write_seq","kind":13,"name":"$si"},{"kind":13,"containerName":"write_seq","name":"$feat","line":1142},{"line":1142,"name":"@top_sfs","kind":13,"containerName":"write_seq"},{"definition":"my","containerName":"write_seq","localvar":"my","kind":13,"name":"$r","line":1145},{"line":1145,"kind":13,"containerName":"write_seq","name":"$self"},{"line":1145,"containerName":"write_seq","kind":12,"name":"_subfeat2featrelhash"},{"kind":13,"containerName":"write_seq","name":"$name","line":1145},{"line":1145,"kind":13,"containerName":"write_seq","name":"$ftype"},{"name":"$feat","containerName":"write_seq","kind":13,"line":1145},{"line":1145,"kind":13,"containerName":"write_seq","name":"%srcfhash"},{"containerName":"write_seq","kind":13,"name":"$tag_cv","line":1145},{"containerName":"write_seq","kind":13,"name":"$isanalysis","line":1145},{"line":1147,"kind":13,"containerName":"write_seq","name":"$ftype"},{"line":1147,"kind":13,"containerName":"write_seq","name":"$feat"},{"line":1147,"containerName":"write_seq","kind":12,"name":"primary_tag"},{"name":"%fr","localvar":"my","kind":13,"containerName":"write_seq","line":1148,"definition":"my"},{"kind":13,"containerName":"write_seq","name":"$r","line":1148},{"name":"@top_featrels","kind":13,"containerName":"write_seq","line":1149},{"line":1149,"kind":13,"containerName":"write_seq","name":"%fr"},{"name":"%finaldatahash","containerName":"write_seq","kind":13,"line":1151},{"line":1151,"containerName":"write_seq","kind":13,"name":"$r"},{"name":"@top_dbxrefs","containerName":"write_seq","kind":13,"line":1155},{"line":1156,"name":"$datahash","containerName":"write_seq","kind":13},{"line":1156,"name":"@top_dbxrefs","kind":13,"containerName":"write_seq"},{"line":1159,"kind":13,"containerName":"write_seq","name":"@top_featureprops"},{"line":1160,"name":"$datahash","containerName":"write_seq","kind":13},{"line":1160,"containerName":"write_seq","kind":13,"name":"@top_featureprops"},{"line":1163,"kind":13,"containerName":"write_seq","name":"@top_featrels"},{"kind":13,"containerName":"write_seq","name":"$datahash","line":1164},{"line":1164,"name":"@top_featrels","kind":13,"containerName":"write_seq"},{"name":"@top_featurecvterms","containerName":"write_seq","kind":13,"line":1167},{"line":1168,"kind":13,"containerName":"write_seq","name":"$datahash"},{"line":1168,"kind":13,"containerName":"write_seq","name":"@top_featurecvterms"},{"line":1171,"name":"$ftype","kind":13,"containerName":"write_seq"},{"name":"%finaldatahash","containerName":"write_seq","kind":13,"line":1171},{"line":1172,"containerName":"write_seq","kind":13,"name":"$finaldatahash"},{"line":1173,"containerName":"write_seq","kind":13,"name":"%datahash"},{"line":1174,"containerName":"write_seq","kind":13,"name":"$cv_name"},{"name":"%finaldatahash","containerName":"write_seq","kind":13,"line":1177},{"kind":13,"containerName":"write_seq","name":"%datahash","line":1177},{"definition":"my","line":1180,"name":"$mainTag","localvar":"my","kind":13,"containerName":"write_seq"},{"name":"$self","containerName":"write_seq","kind":13,"line":1181},{"line":1181,"name":"_hash2xml","kind":12,"containerName":"write_seq"},{"line":1181,"containerName":"write_seq","kind":13,"name":"$mainTag"},{"kind":13,"containerName":"write_seq","name":"%finaldatahash","line":1181}],"containerName":"main::","name":"write_seq"},{"line":965,"name":"dbxref_id","kind":12},{"line":965,"kind":12,"name":"accession"},{"line":965,"name":"db_id","kind":12},{"line":968,"name":"dbxref_id","kind":12},{"kind":12,"name":"accession","line":968},{"line":968,"kind":12,"name":"db_id"},{"line":973,"name":"dbxref_id","kind":12},{"line":973,"kind":12,"name":"accession"},{"line":973,"kind":12,"name":"db_id"},{"line":1041,"name":"Bio","kind":12,"containerName":"SeqFeature::Tools::Unflattener"},{"range":{"end":{"character":9999,"line":1300},"start":{"character":0,"line":1186}},"kind":12,"line":1186,"definition":"sub","name":"_hash2xml","containerName":"main::","children":[{"line":1187,"name":"$self","localvar":"my","kind":13,"containerName":"_hash2xml","definition":"my"},{"definition":"my","localvar":"my","containerName":"_hash2xml","kind":13,"name":"$isMatch","line":1188},{"kind":13,"containerName":"_hash2xml","name":"$isMatch","line":1189},{"definition":"my","line":1190,"localvar":"my","kind":13,"containerName":"_hash2xml","name":"$ult"},{"line":1191,"name":"$ref","containerName":"_hash2xml","localvar":"my","kind":13,"definition":"my"},{"kind":13,"localvar":"my","containerName":"_hash2xml","name":"%mh","line":1192,"definition":"my"},{"definition":"my","localvar":"my","containerName":"_hash2xml","kind":13,"name":"$key","line":1193},{"definition":"my","line":1194,"localvar":"my","kind":13,"containerName":"_hash2xml","name":"$v"},{"kind":13,"localvar":"my","containerName":"_hash2xml","name":"$sh","line":1195,"definition":"my"},{"definition":"my","name":"$xx","containerName":"_hash2xml","localvar":"my","kind":13,"line":1196},{"localvar":"my","kind":13,"containerName":"_hash2xml","name":"$yy","line":1197,"definition":"my"},{"definition":"my","name":"$nt","kind":13,"localvar":"my","containerName":"_hash2xml","line":1198},{"line":1199,"name":"$ntref","containerName":"_hash2xml","localvar":"my","kind":13,"definition":"my"},{"line":1200,"localvar":"my","containerName":"_hash2xml","kind":13,"name":"$output","definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"_hash2xml","name":"$root","line":1201},{"line":1203,"containerName":"_hash2xml","kind":13,"name":"$self"},{"line":1204,"kind":13,"containerName":"_hash2xml","name":"$root"},{"line":1205,"containerName":"_hash2xml","kind":13,"name":"$self"},{"kind":12,"containerName":"_hash2xml","name":"_create_writer","line":1205},{"kind":13,"localvar":"my","containerName":"_hash2xml","name":"$temp","line":1207,"definition":"my"},{"definition":"my","name":"%subh","localvar":"my","containerName":"_hash2xml","kind":13,"line":1208},{"line":1214,"name":"$ult","containerName":"_hash2xml","kind":13},{"containerName":"_hash2xml","kind":13,"name":"$mh","line":1214},{"line":1215,"kind":13,"containerName":"_hash2xml","name":"$self"},{"line":1215,"kind":12,"containerName":"_hash2xml","name":"startTag"},{"line":1215,"name":"$ult","containerName":"_hash2xml","kind":13},{"line":1215,"name":"$mh","containerName":"_hash2xml","kind":13},{"line":1219,"name":"$ult","kind":13,"containerName":"_hash2xml"},{"kind":13,"containerName":"_hash2xml","name":"$mh","line":1219},{"kind":13,"containerName":"_hash2xml","name":"$self","line":1220},{"name":"startTag","containerName":"_hash2xml","kind":12,"line":1220},{"line":1220,"kind":13,"containerName":"_hash2xml","name":"$ult"},{"name":"$isMatch","kind":13,"containerName":"_hash2xml","line":1222},{"line":1226,"kind":13,"containerName":"_hash2xml","name":"$ult"},{"containerName":"_hash2xml","kind":13,"name":"$ult","line":1226},{"containerName":"_hash2xml","kind":13,"name":"$self","line":1227},{"line":1227,"containerName":"_hash2xml","kind":12,"name":"startTag"},{"containerName":"_hash2xml","kind":13,"name":"$ult","line":1227},{"line":1231,"containerName":"_hash2xml","kind":13,"name":"$isMatch"},{"name":"$self","kind":13,"containerName":"_hash2xml","line":1232},{"line":1232,"kind":12,"containerName":"_hash2xml","name":"startTag"},{"name":"$ult","containerName":"_hash2xml","kind":13,"line":1232},{"containerName":"_hash2xml","kind":13,"name":"$self","line":1236},{"line":1236,"kind":12,"containerName":"_hash2xml","name":"startTag"},{"line":1236,"name":"$ult","containerName":"_hash2xml","kind":13},{"line":1240,"name":"$key","kind":13,"containerName":"_hash2xml"},{"line":1240,"kind":13,"containerName":"_hash2xml","name":"%mh"},{"line":1243,"kind":13,"containerName":"_hash2xml","name":"$xx"},{"kind":13,"containerName":"_hash2xml","name":"$key","line":1243},{"containerName":"_hash2xml","kind":13,"name":"$yy","line":1244},{"name":"$key","containerName":"_hash2xml","kind":13,"line":1244},{"name":"$chadotables","containerName":"_hash2xml","kind":13,"line":1245},{"kind":13,"containerName":"_hash2xml","name":"$xx","line":1245},{"kind":13,"containerName":"_hash2xml","name":"$chadotables","line":1245},{"name":"$yy","containerName":"_hash2xml","kind":13,"line":1245},{"containerName":"_hash2xml","kind":13,"name":"$isMatch","line":1247},{"line":1248,"name":"$self","kind":13,"containerName":"_hash2xml"},{"kind":12,"containerName":"_hash2xml","name":"startTag","line":1248},{"line":1248,"kind":13,"containerName":"_hash2xml","name":"$key"},{"containerName":"_hash2xml","kind":13,"name":"$self","line":1250},{"line":1250,"name":"startTag","containerName":"_hash2xml","kind":12},{"kind":13,"containerName":"_hash2xml","name":"$key","line":1250},{"definition":"my","containerName":"_hash2xml","localvar":"my","kind":13,"name":"$x","line":1253},{"kind":13,"containerName":"_hash2xml","name":"$ult","line":1253},{"line":1253,"containerName":"_hash2xml","kind":13,"name":"$key"},{"line":1255,"name":"$fkey","kind":13,"containerName":"_hash2xml"},{"line":1255,"name":"$x","kind":13,"containerName":"_hash2xml"},{"line":1257,"containerName":"_hash2xml","kind":13,"name":"$nt"},{"line":1257,"kind":13,"containerName":"_hash2xml","name":"$fkey"},{"line":1257,"name":"$x","kind":13,"containerName":"_hash2xml"},{"line":1258,"containerName":"_hash2xml","kind":13,"name":"$sh"},{"kind":13,"containerName":"_hash2xml","name":"$mh","line":1258},{"name":"$key","containerName":"_hash2xml","kind":13,"line":1258},{"name":"$self","containerName":"_hash2xml","kind":13,"line":1259},{"kind":12,"containerName":"_hash2xml","name":"_hash2xml","line":1259},{"kind":13,"containerName":"_hash2xml","name":"$isMatch","line":1259},{"line":1259,"name":"$nt","containerName":"_hash2xml","kind":13},{"name":"$sh","kind":13,"containerName":"_hash2xml","line":1259},{"line":1263,"containerName":"_hash2xml","kind":13,"name":"$self"},{"line":1263,"name":"characters","kind":12,"containerName":"_hash2xml"},{"name":"$mh","kind":13,"containerName":"_hash2xml","line":1263},{"line":1263,"name":"$key","kind":13,"containerName":"_hash2xml"},{"line":1265,"name":"$self","containerName":"_hash2xml","kind":13},{"line":1265,"containerName":"_hash2xml","kind":12,"name":"endTag"},{"name":"$key","containerName":"_hash2xml","kind":13,"line":1265},{"name":"$key","containerName":"_hash2xml","kind":13,"line":1270},{"name":"%mh","kind":13,"containerName":"_hash2xml","line":1270},{"kind":13,"containerName":"_hash2xml","name":"$xx","line":1273},{"containerName":"_hash2xml","kind":13,"name":"$key","line":1273},{"containerName":"_hash2xml","kind":13,"name":"$yy","line":1274},{"line":1274,"name":"$key","kind":13,"containerName":"_hash2xml"},{"line":1276,"kind":13,"containerName":"_hash2xml","name":"$chadotables"},{"kind":13,"containerName":"_hash2xml","name":"$xx","line":1276},{"containerName":"_hash2xml","kind":13,"name":"$chadotables","line":1276},{"line":1276,"kind":13,"containerName":"_hash2xml","name":"$yy"},{"line":1279,"kind":13,"containerName":"_hash2xml","name":"$ntref"},{"line":1279,"kind":13,"containerName":"_hash2xml","name":"$mh"},{"containerName":"_hash2xml","kind":13,"name":"$key","line":1279},{"line":1281,"name":"$ntref","containerName":"_hash2xml","kind":13},{"name":"$self","containerName":"_hash2xml","kind":13,"line":1282},{"containerName":"_hash2xml","kind":12,"name":"_hash2xml","line":1282},{"containerName":"_hash2xml","kind":13,"name":"$isMatch","line":1282},{"line":1282,"name":"$key","kind":13,"containerName":"_hash2xml"},{"line":1282,"name":"$ntref","kind":13,"containerName":"_hash2xml"},{"line":1283,"name":"$ntref","containerName":"_hash2xml","kind":13},{"containerName":"_hash2xml","kind":13,"name":"$ref","line":1285},{"line":1285,"kind":13,"containerName":"_hash2xml","name":"$ntref"},{"line":1287,"name":"$self","containerName":"_hash2xml","kind":13},{"name":"_hash2xml","kind":12,"containerName":"_hash2xml","line":1287},{"line":1287,"kind":13,"containerName":"_hash2xml","name":"$isMatch"},{"name":"$key","kind":13,"containerName":"_hash2xml","line":1287},{"line":1287,"name":"$ref","kind":13,"containerName":"_hash2xml"},{"containerName":"_hash2xml","kind":13,"name":"$self","line":1295},{"name":"endTag","containerName":"_hash2xml","kind":12,"line":1295},{"line":1295,"containerName":"_hash2xml","kind":13,"name":"$ult"}]},{"kind":12,"range":{"start":{"line":1302,"character":0},"end":{"character":9999,"line":1325}},"line":1302,"name":"_guess_acc_db","containerName":"main::","children":[{"definition":"my","line":1303,"name":"$self","kind":13,"localvar":"my","containerName":"_guess_acc_db"},{"localvar":"my","containerName":"_guess_acc_db","kind":13,"name":"$seq","line":1304,"definition":"my"},{"definition":"my","line":1305,"name":"$acc","localvar":"my","kind":13,"containerName":"_guess_acc_db"},{"name":"$acc","kind":13,"containerName":"_guess_acc_db","line":1308},{"name":"$acc","kind":13,"containerName":"_guess_acc_db","line":1308},{"line":1308,"containerName":"_guess_acc_db","kind":13,"name":"$acc"},{"line":1308,"name":"$acc","kind":13,"containerName":"_guess_acc_db"},{"line":1310,"name":"$acc","kind":13,"containerName":"_guess_acc_db"},{"name":"$acc","containerName":"_guess_acc_db","kind":13,"line":1310},{"line":1310,"kind":13,"containerName":"_guess_acc_db","name":"$acc"},{"kind":13,"containerName":"_guess_acc_db","name":"$acc","line":1312},{"name":"$seq","containerName":"_guess_acc_db","kind":13,"line":1314},{"line":1314,"kind":12,"containerName":"_guess_acc_db","name":"molecule"},{"line":1314,"name":"$acc","containerName":"_guess_acc_db","kind":13},{"name":"$seq","containerName":"_guess_acc_db","kind":13,"line":1316},{"kind":12,"containerName":"_guess_acc_db","name":"molecule","line":1316},{"line":1316,"kind":13,"containerName":"_guess_acc_db","name":"$acc"},{"line":1318,"containerName":"_guess_acc_db","kind":13,"name":"$acc"},{"line":1318,"name":"$acc","kind":13,"containerName":"_guess_acc_db"},{"line":1320,"containerName":"_guess_acc_db","kind":13,"name":"$acc"},{"kind":13,"containerName":"_guess_acc_db","name":"$acc","line":1320}],"definition":"sub"},{"children":[{"definition":"my","line":1328,"containerName":"_subfeat2featrelhash","localvar":"my","kind":13,"name":"$self"},{"definition":"my","line":1329,"localvar":"my","containerName":"_subfeat2featrelhash","kind":13,"name":"$genename"},{"kind":13,"localvar":"my","containerName":"_subfeat2featrelhash","name":"$seqtype","line":1330,"definition":"my"},{"line":1331,"containerName":"_subfeat2featrelhash","localvar":"my","kind":13,"name":"$feat","definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"_subfeat2featrelhash","name":"$r","line":1332},{"definition":"my","line":1333,"name":"%srcf","containerName":"_subfeat2featrelhash","localvar":"my","kind":13},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$r","line":1333},{"definition":"my","line":1334,"name":"$tag_cv","localvar":"my","containerName":"_subfeat2featrelhash","kind":13},{"line":1335,"name":"$isanalysis","containerName":"_subfeat2featrelhash","localvar":"my","kind":13,"definition":"my"},{"name":"$prim_tag","localvar":"my","containerName":"_subfeat2featrelhash","kind":13,"line":1337,"definition":"my"},{"line":1337,"name":"$feat","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1337,"name":"primary_tag","containerName":"_subfeat2featrelhash","kind":12},{"line":1339,"name":"$sfunique","localvar":"my","kind":13,"containerName":"_subfeat2featrelhash","definition":"my"},{"containerName":"_subfeat2featrelhash","localvar":"my","kind":13,"name":"$sfname","line":1340,"definition":"my"},{"definition":"my","name":"$sftype","localvar":"my","containerName":"_subfeat2featrelhash","kind":13,"line":1341},{"line":1343,"name":"$feat","containerName":"_subfeat2featrelhash","kind":13},{"line":1343,"name":"has_tag","kind":12,"containerName":"_subfeat2featrelhash"},{"line":1344,"containerName":"_subfeat2featrelhash","kind":13,"name":"$sfunique"},{"line":1344,"name":"$feat","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1344,"name":"each_tag_value","kind":12,"containerName":"_subfeat2featrelhash"},{"name":"$feat","kind":13,"containerName":"_subfeat2featrelhash","line":1345},{"line":1345,"name":"has_tag","kind":12,"containerName":"_subfeat2featrelhash"},{"name":"$sfunique","kind":13,"containerName":"_subfeat2featrelhash","line":1346},{"line":1346,"name":"$feat","containerName":"_subfeat2featrelhash","kind":13},{"line":1346,"containerName":"_subfeat2featrelhash","kind":12,"name":"each_tag_value"},{"name":"$sfunique","containerName":"_subfeat2featrelhash","kind":13,"line":1350},{"line":1350,"name":"$self","containerName":"_subfeat2featrelhash","kind":13},{"containerName":"_subfeat2featrelhash","kind":12,"name":"_genFeatUniqueName","line":1350},{"name":"$genename","kind":13,"containerName":"_subfeat2featrelhash","line":1350},{"line":1350,"name":"$feat","containerName":"_subfeat2featrelhash","kind":13},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$feat","line":1353},{"name":"has_tag","containerName":"_subfeat2featrelhash","kind":12,"line":1353},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$sfname","line":1354},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$feat","line":1354},{"line":1354,"name":"each_tag_value","containerName":"_subfeat2featrelhash","kind":12},{"name":"$feattype_args2so","kind":13,"containerName":"_subfeat2featrelhash","line":1358},{"line":1358,"name":"$prim_tag","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1359,"kind":13,"containerName":"_subfeat2featrelhash","name":"$sftype"},{"line":1359,"name":"$feattype_args2so","containerName":"_subfeat2featrelhash","kind":13},{"line":1359,"containerName":"_subfeat2featrelhash","kind":13,"name":"$prim_tag"},{"name":"$sftype","kind":13,"containerName":"_subfeat2featrelhash","line":1361},{"line":1361,"name":"$prim_tag","kind":13,"containerName":"_subfeat2featrelhash"},{"name":"$prim_tag","containerName":"_subfeat2featrelhash","kind":13,"line":1364},{"line":1365,"containerName":"_subfeat2featrelhash","kind":13,"name":"$feat"},{"containerName":"_subfeat2featrelhash","kind":12,"name":"start","line":1365},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$feat","line":1365},{"containerName":"_subfeat2featrelhash","kind":12,"name":"end","line":1365},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$sftype","line":1366},{"line":1366,"containerName":"_subfeat2featrelhash","kind":13,"name":"$feattype_args2so"},{"name":"$sftype","containerName":"_subfeat2featrelhash","kind":13,"line":1368},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$feattype_args2so","line":1368},{"definition":"my","localvar":"my","kind":13,"containerName":"_subfeat2featrelhash","name":"$isanal","line":1373},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$sftype","line":1374},{"name":"$sftype","containerName":"_subfeat2featrelhash","kind":13,"line":1374},{"line":1374,"name":"$sftype","containerName":"_subfeat2featrelhash","kind":13},{"line":1374,"name":"$sftype","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1374,"kind":13,"containerName":"_subfeat2featrelhash","name":"$sftype"},{"line":1375,"name":"$isanal","containerName":"_subfeat2featrelhash","kind":13},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$isanalysis","line":1375},{"name":"%sfhash","localvar":"my","kind":13,"containerName":"_subfeat2featrelhash","line":1378,"definition":"my"},{"name":"$sfname","containerName":"_subfeat2featrelhash","kind":13,"line":1379},{"line":1380,"name":"$sfunique","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1381,"containerName":"_subfeat2featrelhash","kind":13,"name":"%organism"},{"line":1382,"containerName":"_subfeat2featrelhash","kind":13,"name":"$sftype"},{"name":"$cv_name","containerName":"_subfeat2featrelhash","kind":13,"line":1382},{"name":"$isanal","containerName":"_subfeat2featrelhash","kind":13,"line":1383},{"definition":"my","name":"$sfmin","localvar":"my","kind":13,"containerName":"_subfeat2featrelhash","line":1395},{"definition":"my","line":1396,"name":"$sfmax","containerName":"_subfeat2featrelhash","localvar":"my","kind":13},{"line":1397,"name":"$is_sfmin_partial","containerName":"_subfeat2featrelhash","localvar":"my","kind":13,"definition":"my"},{"line":1398,"localvar":"my","containerName":"_subfeat2featrelhash","kind":13,"name":"$is_sfmax_partial","definition":"my"},{"line":1399,"localvar":"my","kind":13,"containerName":"_subfeat2featrelhash","name":"$sfstrand","definition":"my"},{"name":"$sfphase","localvar":"my","containerName":"_subfeat2featrelhash","kind":13,"line":1400,"definition":"my"},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$sfmin","line":1401},{"name":"$feat","containerName":"_subfeat2featrelhash","kind":13,"line":1401},{"line":1401,"name":"start","kind":12,"containerName":"_subfeat2featrelhash"},{"line":1402,"kind":13,"containerName":"_subfeat2featrelhash","name":"$sfmax"},{"line":1402,"name":"$feat","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1402,"kind":12,"containerName":"_subfeat2featrelhash","name":"end"},{"name":"$sfstrand","kind":13,"containerName":"_subfeat2featrelhash","line":1403},{"line":1403,"name":"$feat","containerName":"_subfeat2featrelhash","kind":13},{"line":1403,"containerName":"_subfeat2featrelhash","kind":12,"name":"strand"},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$feat","line":1405},{"line":1405,"name":"can","containerName":"_subfeat2featrelhash","kind":12},{"name":"$sfphase","containerName":"_subfeat2featrelhash","kind":13,"line":1406},{"line":1406,"name":"$feat","kind":13,"containerName":"_subfeat2featrelhash"},{"containerName":"_subfeat2featrelhash","kind":12,"name":"phase","line":1406},{"line":1410,"name":"$seqtype","kind":13,"containerName":"_subfeat2featrelhash"},{"name":"$sftype","containerName":"_subfeat2featrelhash","kind":13,"line":1410},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$feat","line":1412},{"line":1412,"kind":12,"containerName":"_subfeat2featrelhash","name":"location"},{"containerName":"_subfeat2featrelhash","kind":12,"name":"isa","line":1412},{"line":1413,"name":"$feat","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1413,"name":"location","kind":12,"containerName":"_subfeat2featrelhash"},{"line":1413,"kind":12,"containerName":"_subfeat2featrelhash","name":"start_pos_type"},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$is_sfmin_partial","line":1414},{"name":"$feat","containerName":"_subfeat2featrelhash","kind":13,"line":1416},{"kind":12,"containerName":"_subfeat2featrelhash","name":"location","line":1416},{"name":"end_pos_type","kind":12,"containerName":"_subfeat2featrelhash","line":1416},{"line":1417,"containerName":"_subfeat2featrelhash","kind":13,"name":"$is_sfmax_partial"},{"line":1421,"name":"%sfl","localvar":"my","containerName":"_subfeat2featrelhash","kind":13,"definition":"my"},{"line":1422,"name":"%srcf","containerName":"_subfeat2featrelhash","kind":13},{"name":"$sfmin","containerName":"_subfeat2featrelhash","kind":13,"line":1423},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$is_sfmin_partial","line":1424},{"name":"$sfmax","containerName":"_subfeat2featrelhash","kind":13,"line":1425},{"name":"$is_sfmax_partial","containerName":"_subfeat2featrelhash","kind":13,"line":1426},{"line":1427,"name":"$sfstrand","containerName":"_subfeat2featrelhash","kind":13},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$sfphase","line":1428},{"name":"$sfhash","containerName":"_subfeat2featrelhash","kind":13,"line":1431},{"line":1431,"kind":13,"containerName":"_subfeat2featrelhash","name":"%sfl"},{"definition":"my","line":1436,"name":"@sfdbxrefs","localvar":"my","containerName":"_subfeat2featrelhash","kind":13},{"kind":13,"localvar":"my","containerName":"_subfeat2featrelhash","name":"@sub_featureprops","line":1437,"definition":"my"},{"definition":"my","line":1438,"name":"@sub_featuresyns","containerName":"_subfeat2featrelhash","localvar":"my","kind":13},{"line":1439,"name":"@sub_featurecvterms","localvar":"my","kind":13,"containerName":"_subfeat2featrelhash","definition":"my"},{"definition":"my","name":"$tag","containerName":"_subfeat2featrelhash","localvar":"my","kind":13,"line":1440},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$feat","line":1440},{"name":"all_tags","containerName":"_subfeat2featrelhash","kind":12,"line":1440},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$tag","line":1442},{"line":1442,"containerName":"_subfeat2featrelhash","kind":13,"name":"$tag"},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$tag","line":1442},{"definition":"my","name":"@t1","localvar":"my","containerName":"_subfeat2featrelhash","kind":13,"line":1443},{"name":"$feat","kind":13,"containerName":"_subfeat2featrelhash","line":1443},{"line":1443,"name":"each_tag_value","containerName":"_subfeat2featrelhash","kind":12},{"line":1443,"kind":13,"containerName":"_subfeat2featrelhash","name":"$tag"},{"definition":"my","line":1445,"name":"$temp","localvar":"my","containerName":"_subfeat2featrelhash","kind":13},{"name":"@t1","kind":13,"containerName":"_subfeat2featrelhash","line":1445},{"line":1446,"name":"$temp","containerName":"_subfeat2featrelhash","kind":13},{"line":1447,"localvar":"my","containerName":"_subfeat2featrelhash","kind":13,"name":"$db","definition":"my"},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$PREMATCH","line":1447},{"definition":"my","line":1448,"name":"$xref","containerName":"_subfeat2featrelhash","localvar":"my","kind":13},{"line":1448,"name":"$POSTMATCH","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1450,"name":"%acchash","kind":13,"localvar":"my","containerName":"_subfeat2featrelhash","definition":"my"},{"line":1451,"name":"$db","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1452,"name":"$xref","containerName":"_subfeat2featrelhash","kind":13},{"definition":"my","line":1454,"localvar":"my","containerName":"_subfeat2featrelhash","kind":13,"name":"%sfdbx"},{"containerName":"_subfeat2featrelhash","kind":13,"name":"%acchash","line":1454},{"line":1455,"containerName":"_subfeat2featrelhash","kind":13,"name":"@sfdbxrefs"},{"line":1455,"name":"%sfdbx","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1458,"containerName":"_subfeat2featrelhash","kind":13,"name":"$tag"},{"name":"@sub_featuresyns","kind":13,"containerName":"_subfeat2featrelhash","line":1459},{"line":1459,"containerName":"_subfeat2featrelhash","kind":13,"name":"$self"},{"containerName":"_subfeat2featrelhash","kind":12,"name":"handle_Alias_tag","line":1459},{"line":1459,"kind":13,"containerName":"_subfeat2featrelhash","name":"$feat"},{"line":1459,"containerName":"_subfeat2featrelhash","kind":13,"name":"@sub_featuresyns"},{"line":1460,"name":"$tag","kind":13,"containerName":"_subfeat2featrelhash"},{"name":"@sub_featurecvterms","kind":13,"containerName":"_subfeat2featrelhash","line":1461},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$self","line":1461},{"containerName":"_subfeat2featrelhash","kind":12,"name":"handle_Ontology_tag","line":1461},{"line":1461,"containerName":"_subfeat2featrelhash","kind":13,"name":"$feat"},{"kind":13,"containerName":"_subfeat2featrelhash","name":"@sub_featurecvterms","line":1461},{"line":1463,"kind":13,"containerName":"_subfeat2featrelhash","name":"$tag"},{"line":1463,"containerName":"_subfeat2featrelhash","kind":13,"name":"$tag"},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$tag","line":1463},{"line":1463,"name":"$tag","containerName":"_subfeat2featrelhash","kind":13},{"name":"$tag","containerName":"_subfeat2featrelhash","kind":13,"line":1464},{"line":1465,"name":"$tag","containerName":"_subfeat2featrelhash","kind":13},{"name":"$val","localvar":"my","kind":13,"containerName":"_subfeat2featrelhash","line":1466,"definition":"my"},{"line":1466,"name":"$feat","containerName":"_subfeat2featrelhash","kind":13},{"containerName":"_subfeat2featrelhash","kind":12,"name":"each_tag_value","line":1466},{"line":1466,"name":"$tag","kind":13,"containerName":"_subfeat2featrelhash"},{"definition":"my","line":1467,"name":"%prophash","containerName":"_subfeat2featrelhash","localvar":"my","kind":13},{"line":1468,"name":"%prophash","containerName":"_subfeat2featrelhash","kind":13},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$tag","line":1469},{"line":1469,"name":"$tag_cv","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1470,"kind":13,"containerName":"_subfeat2featrelhash","name":"$val"},{"line":1472,"name":"@sub_featureprops","containerName":"_subfeat2featrelhash","kind":13},{"line":1472,"kind":13,"containerName":"_subfeat2featrelhash","name":"%prophash"},{"name":"$feat","kind":13,"containerName":"_subfeat2featrelhash","line":1477},{"line":1477,"name":"can","containerName":"_subfeat2featrelhash","kind":12},{"line":1478,"containerName":"_subfeat2featrelhash","kind":13,"name":"@sfdbxrefs"},{"line":1478,"kind":13,"containerName":"_subfeat2featrelhash","name":"$self"},{"line":1478,"name":"handle_source","containerName":"_subfeat2featrelhash","kind":12},{"name":"$feat","containerName":"_subfeat2featrelhash","kind":13,"line":1478},{"containerName":"_subfeat2featrelhash","kind":13,"name":"@sfdbxrefs","line":1478},{"containerName":"_subfeat2featrelhash","kind":13,"name":"@sub_featureprops","line":1481},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$sfhash","line":1482},{"containerName":"_subfeat2featrelhash","kind":13,"name":"@sub_featureprops","line":1482},{"name":"@sfdbxrefs","containerName":"_subfeat2featrelhash","kind":13,"line":1484},{"name":"$sfhash","kind":13,"containerName":"_subfeat2featrelhash","line":1485},{"line":1485,"name":"@sfdbxrefs","containerName":"_subfeat2featrelhash","kind":13},{"name":"@sub_featuresyns","kind":13,"containerName":"_subfeat2featrelhash","line":1487},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$sfhash","line":1488},{"name":"@sub_featuresyns","containerName":"_subfeat2featrelhash","kind":13,"line":1488},{"name":"@sub_featurecvterms","kind":13,"containerName":"_subfeat2featrelhash","line":1490},{"name":"$sfhash","containerName":"_subfeat2featrelhash","kind":13,"line":1491},{"containerName":"_subfeat2featrelhash","kind":13,"name":"@sub_featurecvterms","line":1491},{"name":"@ssfeatrel","containerName":"_subfeat2featrelhash","localvar":"my","kind":13,"line":1494,"definition":"my"},{"line":1495,"name":"$feat","containerName":"_subfeat2featrelhash","kind":13},{"kind":12,"containerName":"_subfeat2featrelhash","name":"has_tag","line":1495},{"name":"$genename","kind":13,"containerName":"_subfeat2featrelhash","line":1496},{"line":1496,"name":"$feat","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1496,"kind":12,"containerName":"_subfeat2featrelhash","name":"each_tag_value"},{"line":1497,"kind":13,"containerName":"_subfeat2featrelhash","name":"$feat"},{"line":1497,"containerName":"_subfeat2featrelhash","kind":12,"name":"has_tag"},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$genename","line":1498},{"line":1498,"containerName":"_subfeat2featrelhash","kind":13,"name":"$feat"},{"line":1498,"containerName":"_subfeat2featrelhash","kind":12,"name":"each_tag_value"},{"definition":"my","containerName":"_subfeat2featrelhash","localvar":"my","kind":13,"name":"$sf","line":1501},{"line":1501,"containerName":"_subfeat2featrelhash","kind":13,"name":"$feat"},{"line":1501,"kind":12,"containerName":"_subfeat2featrelhash","name":"get_SeqFeatures"},{"line":1503,"localvar":"my","containerName":"_subfeat2featrelhash","kind":13,"name":"$rref","definition":"my"},{"line":1503,"name":"$self","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1503,"name":"_subfeat2featrelhash","containerName":"_subfeat2featrelhash","kind":12},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$genename","line":1503},{"line":1503,"kind":13,"containerName":"_subfeat2featrelhash","name":"$sftype"},{"name":"$sf","kind":13,"containerName":"_subfeat2featrelhash","line":1503},{"containerName":"_subfeat2featrelhash","kind":13,"name":"%srcf","line":1503},{"name":"$tag_cv","containerName":"_subfeat2featrelhash","kind":13,"line":1503},{"name":"$isanalysis","kind":13,"containerName":"_subfeat2featrelhash","line":1503},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$rref","line":1504},{"name":"@ssfeatrel","containerName":"_subfeat2featrelhash","kind":13,"line":1505},{"line":1505,"containerName":"_subfeat2featrelhash","kind":13,"name":"$rref"},{"containerName":"_subfeat2featrelhash","kind":13,"name":"@ssfeatrel","line":1509},{"name":"$sfhash","containerName":"_subfeat2featrelhash","kind":13,"line":1510},{"name":"@ssfeatrel","containerName":"_subfeat2featrelhash","kind":13,"line":1510},{"definition":"my","name":"$reltypename","localvar":"my","kind":13,"containerName":"_subfeat2featrelhash","line":1514},{"containerName":"_subfeat2featrelhash","kind":13,"name":"$reltypename","line":1515},{"line":1515,"containerName":"_subfeat2featrelhash","kind":13,"name":"$sftype"},{"localvar":"my","kind":13,"containerName":"_subfeat2featrelhash","name":"%fr","line":1517,"definition":"my"},{"line":1518,"kind":13,"containerName":"_subfeat2featrelhash","name":"%sfhash"},{"line":1519,"name":"$reltypename","containerName":"_subfeat2featrelhash","kind":13},{"line":1520,"name":"$cv_name","containerName":"_subfeat2featrelhash","kind":13},{"kind":13,"containerName":"_subfeat2featrelhash","name":"$seqtype","line":1523},{"line":1523,"name":"$sftype","kind":13,"containerName":"_subfeat2featrelhash"},{"line":1524,"name":"%sfhash","containerName":"_subfeat2featrelhash","kind":13},{"line":1526,"kind":13,"containerName":"_subfeat2featrelhash","name":"%fr"}],"containerName":"main::","name":"_subfeat2featrelhash","definition":"sub","line":1327,"kind":12,"range":{"start":{"character":0,"line":1327},"end":{"character":9999,"line":1529}}},{"line":1515,"name":"return_reltypename","kind":12},{"range":{"end":{"line":1550,"character":9999},"start":{"line":1532,"character":0}},"kind":12,"line":1532,"definition":"sub","containerName":"main::","name":"_genFeatUniqueName","children":[{"name":"$self","localvar":"my","containerName":"_genFeatUniqueName","kind":13,"line":1533,"definition":"my"},{"definition":"my","containerName":"_genFeatUniqueName","localvar":"my","kind":13,"name":"$genename","line":1534},{"definition":"my","localvar":"my","containerName":"_genFeatUniqueName","kind":13,"name":"$feat","line":1535},{"line":1536,"localvar":"my","kind":13,"containerName":"_genFeatUniqueName","name":"$uniquename","definition":"my"},{"name":"$ftype","localvar":"my","kind":13,"containerName":"_genFeatUniqueName","line":1537,"definition":"my"},{"line":1537,"containerName":"_genFeatUniqueName","kind":13,"name":"$feat"},{"kind":12,"containerName":"_genFeatUniqueName","name":"primary_tag","line":1537},{"definition":"my","name":"$start","localvar":"my","containerName":"_genFeatUniqueName","kind":13,"line":1538},{"name":"$feat","containerName":"_genFeatUniqueName","kind":13,"line":1538},{"name":"start","kind":12,"containerName":"_genFeatUniqueName","line":1538},{"name":"$end","containerName":"_genFeatUniqueName","localvar":"my","kind":13,"line":1539,"definition":"my"},{"name":"$feat","kind":13,"containerName":"_genFeatUniqueName","line":1539},{"line":1539,"kind":12,"containerName":"_genFeatUniqueName","name":"end"},{"line":1541,"name":"$feat","kind":13,"containerName":"_genFeatUniqueName"},{"name":"has_tag","kind":12,"containerName":"_genFeatUniqueName","line":1541},{"line":1542,"containerName":"_genFeatUniqueName","kind":13,"name":"$genename"},{"line":1542,"name":"$feat","containerName":"_genFeatUniqueName","kind":13},{"line":1542,"name":"each_tag_value","containerName":"_genFeatUniqueName","kind":12},{"containerName":"_genFeatUniqueName","kind":13,"name":"$feat","line":1543},{"containerName":"_genFeatUniqueName","kind":12,"name":"has_tag","line":1543},{"line":1544,"kind":13,"containerName":"_genFeatUniqueName","name":"$genename"},{"line":1544,"kind":13,"containerName":"_genFeatUniqueName","name":"$feat"},{"name":"each_tag_value","containerName":"_genFeatUniqueName","kind":12,"line":1544},{"line":1547,"name":"$uniquename","kind":13,"containerName":"_genFeatUniqueName"},{"name":"$genename","kind":13,"containerName":"_genFeatUniqueName","line":1547},{"name":"$ftype","containerName":"_genFeatUniqueName","kind":13,"line":1547},{"name":"$start","containerName":"_genFeatUniqueName","kind":13,"line":1547},{"name":"$end","containerName":"_genFeatUniqueName","kind":13,"line":1547},{"line":1549,"kind":13,"containerName":"_genFeatUniqueName","name":"$uniquename"}]},{"kind":12,"range":{"end":{"line":1613,"character":9999},"start":{"line":1567,"character":0}},"line":1567,"definition":"sub","name":"_getRefAuthors","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_getRefAuthors","line":1568,"definition":"my"},{"definition":"my","line":1569,"name":"$ref","localvar":"my","containerName":"_getRefAuthors","kind":13},{"name":"$temp","localvar":"my","containerName":"_getRefAuthors","kind":13,"line":1571,"definition":"my"},{"name":"$ref","kind":13,"containerName":"_getRefAuthors","line":1571},{"line":1571,"kind":12,"containerName":"_getRefAuthors","name":"authors"},{"definition":"my","line":1572,"localvar":"my","containerName":"_getRefAuthors","kind":13,"name":"@authors"},{"definition":"my","name":"@aut","localvar":"my","kind":13,"containerName":"_getRefAuthors","line":1573},{"kind":13,"containerName":"_getRefAuthors","name":"$temp","line":1576},{"name":"$temp","kind":13,"containerName":"_getRefAuthors","line":1577},{"line":1578,"containerName":"_getRefAuthors","kind":13,"name":"$temp"},{"line":1579,"name":"$lastauthor","kind":13,"localvar":"my","containerName":"_getRefAuthors","definition":"my"},{"line":1579,"containerName":"_getRefAuthors","kind":13,"name":"$POSTMATCH"},{"line":1580,"kind":13,"containerName":"_getRefAuthors","name":"@authors"},{"line":1580,"name":"$PREMATCH","kind":13,"containerName":"_getRefAuthors"},{"containerName":"_getRefAuthors","kind":13,"name":"@authors","line":1581},{"line":1581,"name":"$lastauthor","kind":13,"containerName":"_getRefAuthors"},{"line":1583,"name":"@authors","containerName":"_getRefAuthors","kind":13},{"line":1583,"name":"$temp","containerName":"_getRefAuthors","kind":13},{"definition":"my","line":1586,"localvar":"my","containerName":"_getRefAuthors","kind":13,"name":"$a"},{"line":1587,"name":"$i","localvar":"my","kind":13,"containerName":"_getRefAuthors","definition":"my"},{"kind":13,"containerName":"_getRefAuthors","name":"$a","line":1588},{"line":1588,"name":"@authors","containerName":"_getRefAuthors","kind":13},{"kind":13,"containerName":"_getRefAuthors","name":"$i","line":1589},{"name":"$last","kind":13,"localvar":"my","containerName":"_getRefAuthors","line":1591,"definition":"my"},{"line":1592,"kind":13,"localvar":"my","containerName":"_getRefAuthors","name":"$given","definition":"my"},{"line":1593,"name":"$a","kind":13,"containerName":"_getRefAuthors"},{"kind":13,"containerName":"_getRefAuthors","name":"$last","line":1594},{"name":"$given","kind":13,"containerName":"_getRefAuthors","line":1594},{"kind":13,"containerName":"_getRefAuthors","name":"$a","line":1594},{"line":1595,"containerName":"_getRefAuthors","kind":13,"name":"$a"},{"name":"$last","containerName":"_getRefAuthors","kind":13,"line":1596},{"line":1596,"kind":13,"containerName":"_getRefAuthors","name":"$given"},{"line":1596,"containerName":"_getRefAuthors","kind":13,"name":"$a"},{"line":1598,"name":"%au","localvar":"my","containerName":"_getRefAuthors","kind":13,"definition":"my"},{"line":1599,"name":"$last","containerName":"_getRefAuthors","kind":13},{"line":1600,"name":"$given","containerName":"_getRefAuthors","kind":13},{"name":"@aut","containerName":"_getRefAuthors","kind":13,"line":1602},{"line":1602,"kind":13,"containerName":"_getRefAuthors","name":"%au"},{"kind":13,"containerName":"_getRefAuthors","name":"$i","line":1602},{"line":1605,"name":"@aut","kind":13,"containerName":"_getRefAuthors"}]},{"name":"author_id","kind":12,"line":1602},{"kind":12,"name":"arank","line":1602},{"range":{"end":{"character":9999,"line":1632},"start":{"line":1617,"character":0}},"kind":12,"line":1617,"name":"_getSubmitYear","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_getSubmitYear","line":1618},{"localvar":"my","kind":13,"containerName":"_getSubmitYear","name":"$citation","line":1619,"definition":"my"},{"line":1621,"containerName":"_getSubmitYear","kind":13,"name":"$citation"},{"containerName":"_getSubmitYear","kind":13,"name":"$self","line":1622},{"line":1622,"kind":12,"containerName":"_getSubmitYear","name":"warn"},{"line":1625,"name":"$citation","containerName":"_getSubmitYear","kind":13},{"name":"$a","localvar":"my","kind":13,"containerName":"_getSubmitYear","line":1626,"definition":"my"},{"name":"$MATCH","containerName":"_getSubmitYear","kind":13,"line":1626},{"containerName":"_getSubmitYear","kind":13,"name":"$a","line":1627},{"name":"$year","localvar":"my","containerName":"_getSubmitYear","kind":13,"line":1628,"definition":"my"},{"name":"$MATCH","kind":13,"containerName":"_getSubmitYear","line":1628},{"line":1630,"name":"$year","kind":13,"containerName":"_getSubmitYear"}],"definition":"sub"},{"line":1634,"range":{"end":{"character":9999,"line":1656},"start":{"character":0,"line":1634}},"kind":12,"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_getSubmitAddr","line":1635},{"kind":13,"localvar":"my","containerName":"_getSubmitAddr","name":"$ref","line":1636,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"_getSubmitAddr","name":"%author","line":1637},{"definition":"my","line":1639,"localvar":"my","containerName":"_getSubmitAddr","kind":13,"name":"$citation"},{"line":1639,"name":"$ref","containerName":"_getSubmitAddr","kind":13},{"line":1639,"containerName":"_getSubmitAddr","kind":12,"name":"location"},{"name":"$citation","containerName":"_getSubmitAddr","kind":13,"line":1640},{"name":"$self","containerName":"_getSubmitAddr","kind":13,"line":1641},{"line":1641,"name":"warn","containerName":"_getSubmitAddr","kind":12},{"line":1644,"name":"$citation","kind":13,"containerName":"_getSubmitAddr"},{"line":1645,"kind":13,"localvar":"my","containerName":"_getSubmitAddr","name":"$a","definition":"my"},{"containerName":"_getSubmitAddr","kind":13,"name":"$POSTMATCH","line":1645},{"line":1646,"name":"$a","kind":13,"containerName":"_getSubmitAddr"},{"line":1647,"containerName":"_getSubmitAddr","kind":13,"name":"$a"},{"containerName":"_getSubmitAddr","kind":13,"name":"%author","line":1648},{"name":"$a","kind":13,"containerName":"_getSubmitAddr","line":1649},{"name":"%author","kind":13,"containerName":"_getSubmitAddr","line":1651}],"containerName":"main::","name":"_getSubmitAddr","definition":"sub"},{"definition":"sub","name":"suppress_residues","containerName":"main::","children":[{"line":1672,"name":"$self","localvar":"my","containerName":"suppress_residues","kind":13,"definition":"my"},{"name":"$suppress_residues","localvar":"my","kind":13,"containerName":"suppress_residues","line":1673,"definition":"my"},{"containerName":"suppress_residues","kind":13,"name":"$self","line":1674},{"line":1674,"name":"$suppress_residues","containerName":"suppress_residues","kind":13},{"line":1674,"kind":13,"containerName":"suppress_residues","name":"$suppress_residues"},{"line":1675,"name":"$self","kind":13,"containerName":"suppress_residues"}],"range":{"end":{"character":9999,"line":1676},"start":{"character":0,"line":1671}},"kind":12,"line":1671},{"kind":12,"range":{"start":{"line":1696,"character":0},"end":{"line":1701,"character":9999}},"line":1696,"definition":"sub","containerName":"main::","name":"allow_residues","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"allow_residues","line":1697},{"line":1698,"localvar":"my","kind":13,"containerName":"allow_residues","name":"$allow_residues","definition":"my"},{"kind":13,"containerName":"allow_residues","name":"$self","line":1699},{"line":1699,"name":"$allow_residues","kind":13,"containerName":"allow_residues"},{"kind":13,"containerName":"allow_residues","name":"$allow_residues","line":1699},{"containerName":"allow_residues","kind":13,"name":"$self","line":1700}]},{"line":1716,"range":{"end":{"line":1722,"character":9999},"start":{"character":0,"line":1716}},"kind":12,"definition":"sub","children":[{"localvar":"my","containerName":"return_ftype_hash","kind":13,"name":"$self","line":1717,"definition":"my"},{"name":"$ftype","localvar":"my","containerName":"return_ftype_hash","kind":13,"line":1718,"definition":"my"},{"name":"%ftype_hash","localvar":"my","containerName":"return_ftype_hash","kind":13,"line":1719,"definition":"my"},{"kind":13,"containerName":"return_ftype_hash","name":"$ftype","line":1719},{"kind":13,"containerName":"return_ftype_hash","name":"$cv_name","line":1720},{"name":"%ftype_hash","containerName":"return_ftype_hash","kind":13,"line":1721}],"containerName":"main::","name":"return_ftype_hash"},{"line":1736,"range":{"start":{"line":1736,"character":0},"end":{"line":1748,"character":9999}},"kind":12,"children":[{"line":1737,"name":"$self","containerName":"return_reltypename","localvar":"my","kind":13,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"return_reltypename","name":"$sftype","line":1738},{"definition":"my","localvar":"my","containerName":"return_reltypename","kind":13,"name":"$reltypename","line":1740},{"line":1741,"name":"$sftype","containerName":"return_reltypename","kind":13},{"name":"$sftype","kind":13,"containerName":"return_reltypename","line":1741},{"line":1742,"name":"$reltypename","kind":13,"containerName":"return_reltypename"},{"line":1744,"name":"$reltypename","kind":13,"containerName":"return_reltypename"},{"line":1747,"name":"$reltypename","kind":13,"containerName":"return_reltypename"}],"containerName":"main::","name":"return_reltypename","definition":"sub"},{"definition":"sub","detail":"($self,%argv)","children":[{"name":"$self","localvar":"my","containerName":"next_seq","kind":13,"line":1762,"definition":"my"},{"name":"%argv","containerName":"next_seq","kind":13,"line":1762},{"line":1764,"containerName":"next_seq","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"next_seq","line":1764}],"name":"next_seq","containerName":"main::","signature":{"documentation":"1;\n# $Id: chadoxml.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::chadoxml\n#\n# Peili Zhang   <peili@morgan.harvard.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::chadoxml - chadoxml sequence output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    $writer = Bio::SeqIO->new(-file => \">chado.xml\",\n                              -format => 'chadoxml');\n\n    # assume you already have Sequence or SeqFeature objects\n    $writer->write_seq($seq_obj);\n\n    #after writing all seqs\n    $writer->close_chadoxml();\n\n\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to chadoxml flat\nfile databases (for chadoxml DTD, see\nhttp://gmod.cvs.sourceforge.net/gmod/schema/chado/dat/chado.dtd).\n\nThis is currently a write-only module.\n\n    $seqio = Bio::SeqIO->new(-file => '>outfile.xml',\n                             -format => 'chadoxml'\n                             -suppress_residues => 1,\n                             -allow_residues => 'chromosome',\n                             );\n\n    # we have a Bio::Seq object $seq which is a gene located on\n    # chromosome arm 'X', to be written out to chadoxml\n    # before converting to chadoxml, $seq object B<must> be transformed\n    # so that all the coordinates in $seq are against the source\n    # feature to be passed into Bio::SeqIO::chadoxml->write_seq()\n    # -- chromosome arm X in the example below.\n\n    $seqio->write_seq(-seq=>$seq,\n                      -genus   => 'Homo',\n                      -species => 'sapiens',\n                      -seq_so_type=>'gene',\n                      -src_feature=>'X',\n                      -src_feat_type=>'chromosome_arm',\n                        -nounflatten=>1,\n                      -is_analysis=>'true',\n                      -data_source=>'GenBank');\n\nThe chadoxml output of Bio::SeqIO::chadoxml-E<gt>write_seq() method can be\npassed to the loader utility in XORT package\n(http://gmod.cvs.sourceforge.net/gmod/schema/XMLTools/XORT/)\nto be loaded into chado.\n\nThis object is currently implemented to work with sequence and\nannotation data from whole genome projects deposited in GenBank. It\nmay not be able to handle all different types of data from all\ndifferent sources.\n\nIn converting a Bio::Seq object into chadoxml, a top-level feature is\ncreated to represent the object and all sequence features inside the\nBio::Seq object are treated as subfeatures of the top-level\nfeature. The Bio::SeqIO::chadoxml object calls\nBio::SeqFeature::Tools::Unflattener to unflatten the flat feature list\ncontained in the subject Bio::Seq object, to build gene model\ncontainment hierarchy conforming to chado central dogma model: gene\n--E<gt> mRNA --E<gt> exons and protein.\n\nDestination of data in the subject Bio::Seq object $seq is as following:\n\n    *$seq->display_id:  name of the top-level feature;\n\n    *$seq->accession_number: if defined, uniquename and\n                 feature_dbxref of the top-level\n                 feature if not defined,\n                 $seq->display_id is used as the\n                 uniquename of the top-level feature;\n\n    *$seq->molecule: transformed to SO type, used as the feature\n            type of the top-level feature if -seq_so_type\n            argument is supplied, use the supplied SO type\n            as the feature type of the top-level feature;\n\n    *$seq->species: organism of the top-level feature;\n\n    *$seq->seq: residues of the top-level feature;\n\n    *$seq->is_circular, $seq->division: feature_cvterm;\n\n    *$seq->keywords, $seq->desc, comments: featureprop;\n\n    *references: pub and feature_pub;\n        medline/pubmed ids: pub_dbxref;\n        comments: pubprop;\n\n    *feature \"source\" span: featureloc for top-level feature;\n\n    *feature \"source\" db_xref: feature_dbxref for top-level feature;\n\n    *feature \"source\" other tags: featureprop for top-level feature;\n\n    *subfeature 'symbol' or 'label' tag: feature uniquename, if\n                     none of these is present, the chadoxml object\n                     generates feature uniquenames as:\n                     <gene>-<feature_type>-<span>\n                     (e.g. foo-mRNA--1000..3000);\n\n    *gene model: feature_relationship built based on the\n                     containment hierarchy;\n\n    *feature span: featureloc;\n\n    *feature accession numbers: feature_dbxref;\n\n    *feature tags (except db_xref, symbol and gene): featureprop;\n\nThings to watch out for:\n\n    *chado schema change: this version works with the chado\n                               version tagged chado_1_01 in GMOD CVS.\n\n    *feature uniquenames: especially important if using XORT\n                              loader to do incremental load into\n                              chado. may need pre-processing of the\n                              source data to put the correct\n                              uniquenames in place.\n\n    *pub uniquenames: chadoxml->write_seq() has the FlyBase policy\n                          on pub uniquenames hard-coded, it assigns\n                          pub uniquenames in the following way: for\n                          journals and books, use ISBN number; for\n                          published papers, use MEDLINE ID; for\n                          everything else, use FlyBase unique\n                          identifier FBrf#. need to modify the code to\n                          implement your policy. look for the comments\n                          in the code.\n\n    *for pubs possibly existing in chado but with no knowledge of\n         its uniquename:put \"op\" as \"match\", then need to run the\n                        output chadoxml through a special filter that\n                        talks to chado database and tries to find the\n                        pub by matching with the provided information\n                        instead of looking up by the unique key. after\n                        matching, the filter also resets the \"match\"\n                        operation to either \"force\" (default), or\n                        \"lookup\", or \"insert\", or \"update\". the\n                        \"match\" operation is for a special FlyBase use\n                        case. please modify to work according to your\n                        rules.\n\n    *chado initialization for loading:\n\n        cv & cvterm: in the output chadoxml, all cv's and\n                             cvterm's are lookup only. Therefore,\n                             before using XORT loader to load the\n                             output into chado, chado must be\n                             pre-loaded with all necessary CVs and\n                             CVterms, including \"SO\" , \"property\n                             type\", \"relationship type\", \"pub type\",\n                             \"pubprop type\", \"pub relationship type\",\n                             \"sequence topology\", \"GenBank feature\n                             qualifier\", \"GenBank division\". A pub by\n                             the uniquename 'nullpub' of type 'null\n                             pub' needs to be inserted.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR - Peili Zhang\n\nEmail peili@morgan.harvard.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::chadoxml;\nuse strict;\nuse English;\n\nuse Carp;\nuse Data::Dumper;\nuse XML::Writer;\nuse IO::File;\nuse IO::Handle;\nuse Bio::Seq;\nuse Bio::Seq::RichSeq;\nuse Bio::SeqIO::FTHelper;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\nuse Bio::Factory::SequenceStreamI;\nuse Bio::SeqFeature::Generic;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::SeqFeature::Tools::Unflattener;\n\n#global variables\nundef(my %finaldatahash); #data from Bio::Seq object stored in a hash\nundef(my %datahash); #data from Bio::Seq object stored in a hash\n\nmy $chadotables = 'feature featureprop feature_relationship featureloc feature_cvterm cvterm cv feature_pub pub pub_dbxref pub_author author pub_relationship pubprop feature_dbxref dbxref db synonym feature_synonym';\n\nmy %fkey = (\n    \"cvterm.cv_id\"          => \"cv\",\n        \"cvterm.dbxref_id\"              => \"dbxref\",\n    \"dbxref.db_id\"          => \"db\",\n    \"feature.type_id\"       => \"cvterm\",\n    \"feature.organism_id\"       => \"organism\",\n    \"feature.dbxref_id\"         => \"dbxref\",\n    \"featureprop.type_id\"       => \"cvterm\",\n    \"feature_pub.pub_id\"        => \"pub\",\n    \"feature_cvterm.cvterm_id\"  => \"cvterm\",\n    \"feature_cvterm.pub_id\"     => \"pub\",\n        \"feature_cvterm.feature_id\"     => \"feature\",\n    \"feature_dbxref.dbxref_id\"  => \"dbxref\",\n    \"feature_relationship.object_id\"    => \"feature\",\n    \"feature_relationship.subject_id\"   => \"feature\",\n    \"feature_relationship.type_id\"  => \"cvterm\",\n    \"featureloc.srcfeature_id\"  => \"feature\",\n    \"pub.type_id\"           => \"cvterm\",\n    \"pub_dbxref.dbxref_id\"      => \"dbxref\",\n    \"pub_author.author_id\"      => \"author\",\n    \"pub_relationship.obj_pub_id\"   => \"pub\",\n    \"pub_relationship.subj_pub_id\"  => \"pub\",\n    \"pub_relationship.type_id\"  => \"cvterm\",\n    \"pubprop.type_id\"       => \"cvterm\",\n        \"feature_synonym.feature_id\"    => \"feature\",\n        \"feature_synonym.synonym_id\"    => \"synonym\",\n        \"feature_synonym.pub_id\"        => \"pub\",\n        \"synonym.type_id\"               => \"cvterm\",\n);\n\nmy %cv_name = (\n        'relationship'                  => 'relationship',\n        'sequence'                      => 'sequence',\n        'feature_property'              => 'feature_property',\n);\n\nmy %feattype_args2so = (\n    \"aberr\"             => \"aberration_junction\",\n#   \"conflict\"          => \"sequence_difference\",\n#   \"polyA_signal\"          => \"polyA_signal_sequence\",\n    \"variation\"         => \"sequence_variant\",\n    \"mutation1\"         => \"point_mutation\",        #for single-base mutation\n    \"mutation2\"         => \"sequence_variant\",      #for multi-base mutation\n    \"rescue\"            => \"rescue_fragment\",\n#   \"rfrag\"             => \"restriction_fragment\",\n    \"protein_bind\"          => \"protein_binding_site\",\n    \"misc_feature\"          => \"region\",\n#   \"prim_transcript\"       => \"primary_transcript\",\n    \"CDS\"               => \"polypeptide\",\n    \"reg_element\"           => \"regulatory_region\",\n    \"seq_variant\"           => \"sequence_variant\",\n    \"mat_peptide\"           => \"mature_peptide\",\n    \"sig_peptide\"           => \"signal_peptide\",\n);\n\nundef(my %organism);\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n\n    my($self,%args) = @_;\n\n    $self->SUPER::_initialize(%args);\n    unless( defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n    #optional arguments that can be passed in\n    $self->suppress_residues($args{'-suppress_residues'})\n        if defined $args{'-suppress_residues'};\n\n    $self->allow_residues($args{'-allow_residues'})\n        if defined $args{'-allow_residues'};\n    return;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(-seq=>$seq, -seq_so_type=>$seqSOtype,\n                  -src_feature=>$srcfeature,\n                  -src_feat_type=>$srcfeattype,\n                  -nounflatten=>0 or 1,\n                  -is_analysis=>'true' or 'false',\n                  -data_source=>$datasource)\n Function: writes the $seq object (must be seq) into chadoxml.\n Returns : 1 for success and 0 for error\n Args     : A Bio::Seq object $seq, optional $seqSOtype, $srcfeature,\n            $srcfeattype, $nounflatten, $is_analysis and $data_source.\n\nWhen $srcfeature (a string, the uniquename of the source feature) is given, the\nlocation and strand information of the top-level feature against the source\nfeature will be derived from the sequence feature called 'source' of the $seq\nobject, a featureloc record is generated for the top -level feature on\n$srcfeature. when $srcfeature is given, $srcfeattype must also be present. All\nfeature coordinates in $seq should be against $srcfeature. $seqSOtype is the\noptional SO term to use as the type of the top-level feature. For example, a\nGenBank data file for a Drosophila melanogaster genome scaffold has the molecule\ntype of \"DNA\", when converting to chadoxml, a $seqSOtype argument of\n\"golden_path_region\" can be supplied to save the scaffold as a feature of type\n\"golden_path_region\" in chadoxml, instead of \"DNA\". a feature with primary tag\nof 'source' must be present in the sequence feature list of $seq, to decribe the\nwhole sequence record.\n\nIn the current implementation:\n\n=over 3\n\n* *\n\nnon-mRNA records\n\nA top-level feature of type $seq-E<gt>alphabet is generated for the whole GenBank\nrecord, features listed are unflattened for DNA records to build gene model\nfeature graph, and for the other types of records all features in $seq are\ntreated as subfeatures of the top-level feature.\n\n* *\n\nmRNA records\n\nIf a 'gene' feature is present, it B<must> have a /symbol or /label tag to\ncontain the uniquename of the gene. a top-level feature of type 'gene' is\ngenerated. the mRNA is written as a subfeature of the top-level gene feature,\nand the other sequence features listed in $seq are treated as subfeatures of the\nmRNA feature.\n\n\n\nsub write_seq {\n    my $usage = <<EOUSAGE;\nBio::SeqIO::chadoxml->write_seq()\nUsage   : \\$stream->write_seq(-seq=>\\$seq,\n                  -seq_so_type=>\\$SOtype,\n                  -src_feature=>\\$srcfeature,\n                  -src_feat_type=>\\$srcfeattype,\n                  -nounflatten=>0 or 1,\n                              -is_analysis=>'true' or 'false',\n                              -data_source=>\\$datasource)\nArgs    : \\$seq     : a Bio::Seq object\n      \\$SOtype  : the SO term to use as the feature type of\n                      the \\$seq record, optional\n      \\$srcfeature  : unique name of the source feature, a string\n              containing at least one alphabetical letter\n              (a-z, A-Z), optional\n      \\$srcfeattype : feature type of \\$srcfeature. one of SO terms.\n              optional\n      when \\$srcfeature is given, \\$srcfeattype becomes mandatory,\n      \\$datasource  : source of the sequence annotation data,\n              e.g. 'GenBank' or 'GFF'.\nEOUSAGE\n\n    my ($self,@args) = @_;\n\n    my ($seq, $seq_so_type, $srcfeature, $srcfeattype, $nounflatten, $isanalysis, $datasource, $genus, $species) =\n       $self->_rearrange([qw(SEQ\n                 SEQ_SO_TYPE\n                 SRC_FEATURE\n                 SRC_FEAT_TYPE\n                 NOUNFLATTEN\n                 IS_ANALYSIS\n                 DATA_SOURCE\n                                 GENUS\n                                 SPECIES\n                 )],\n                  @args);\n    #print \"$seq_so_type, $srcfeature, $srcfeattype\\n\";\n\n    if( !defined $seq ) {\n        $self->throw(\"Attempting to write with no seq!\");\n    }\n\n    if( ! ref $seq || ! $seq->isa('Bio::Seq::RichSeqI') ) {\n       ## FIXME $self->warn(\" $seq is not a RichSeqI compliant module. Attempting to dump, but may fail!\");\n    }\n\n        # try to get the srcfeature from the seqFeature object\n        # for this to work, the user has to pass in the srcfeature type\n        if (!$srcfeature) {\n            if ($seq->can('seq_id')) {\n                $srcfeature=$seq->seq_id if ($seq->seq_id ne $seq->display_name);\n            }    \n        }\n\n    #$srcfeature, when provided, should contain at least one alphabetical letter\n    if (defined $srcfeature)\n    {\n        if ($srcfeature =~ /[a-zA-Z]/)\n        {\n        chomp($srcfeature);\n        } else {\n        $self->throw( $usage );\n        }\n\n        #check for mandatory $srcfeattype\n        if (! defined $srcfeattype)\n        {\n        $self->throw( $usage );\n        #$srcfeattype must be a string of non-whitespace characters\n        } else {\n        if ($srcfeattype =~ /\\S+/) {\n            chomp($srcfeattype);\n        } else {\n            $self->throw( $usage );\n        }\n        }\n    }\n\n    # variables local to write_seq()\n        my $div = undef;\n    my $hkey = undef;\n    undef(my @top_featureprops);\n        undef(my @featuresyns);\n        undef(my @top_featurecvterms);\n    my $name = $seq->display_id if $seq->can('display_id');\n        $name = $seq->display_name  if $seq->can('display_name');\n    undef(my @feature_cvterms);\n    undef(my %sthash);\n    undef(my %dvhash);\n    undef(my %h1);\n    undef(my %h2);\n    my $temp = undef;\n    my $ann = undef;\n    undef(my @references);\n    undef(my @feature_pubs);\n    my $ref = undef;\n    my $location = undef;\n    my $fbrf = undef;\n    my $journal = undef;\n    my $issue = undef;\n    my $volume = undef;\n    my $volumeissue = undef;\n    my $pages = undef;\n    my $year = undef;\n    my $pubtype = undef;\n#   my $miniref= undef;\n    my $uniquename = undef;\n    my $refhash = undef;\n    my $feat = undef;\n    my $tag = undef;\n    my $tag_cv = undef;\n    my $ftype = undef;\n    my $subfeatcnt = undef;\n    undef(my @top_featrels);\n    undef (my %srcfhash);\n\n    local($^W) = 0; # supressing warnings about uninitialized fields.\n\n        if (!$name && $seq->can('attributes') ) {\n            ($name) = $seq->attributes('Alias'); \n        }\n\n    if ($seq->can('accession_number') && defined $seq->accession_number && $seq->accession_number ne 'unknown') {\n        $uniquename = $seq->accession_number;\n    } elsif ($seq->can('accession') && defined $seq->accession && $seq->accession ne 'unknown') {\n        $uniquename = $seq->accession;\n    } elsif ($seq->can('attributes')) {\n                ($uniquename) = $seq->attributes('load_id');\n        } else {\n        $uniquename = $name;\n    }\n        my $len = $seq->length();\n    if ($len == 0) {\n        $len = undef;\n    }\n\n    undef(my $gb_type);\n    if (!$seq->can('molecule') || ! defined ($gb_type = $seq->molecule()) ) {\n        $gb_type = $seq->can('alphabet') ? $seq->alphabet : 'DNA';\n    }\n    $gb_type = 'DNA' if $ftype eq 'dna';\n    $gb_type = 'RNA' if $ftype eq 'rna';\n\n    if(length $seq_so_type > 0) {\n        if (defined $seq_so_type) {\n            $ftype = $seq_so_type;\n        }\n            elsif ($seq->type) {\n                    $ftype = ($seq->type =~ /(.*):/)\n                             ? $1\n                             : $seq->type;\n            }\n        else {\n            $ftype = $gb_type;\n        }\n    }\n    else {\n        $ftype = $gb_type;\n    }\n\n    my %ftype_hash = $self->return_ftype_hash($ftype);\n\n        if ($species) {\n            %organism = (\"genus\"=>$genus, \"species\" => $species);\n        }\n        else {\n        my $spec = $seq->species();\n        if (!defined $spec) {\n        $self->throw(\"$seq does not know what organism it is from, which is required by chado. cannot proceed!\\n\");\n        } else {\n        %organism = (\"genus\"=>$spec->genus(), \"species\" => $spec->species());\n        }\n        }\n\n        my $residues;\n        if (!$self->suppress_residues ||\n            ($self->suppress_residues && $self->allow_residues eq $ftype)) {\n            $residues = $seq->seq->isa('Bio::PrimarySeq') \n                        ? $seq->seq->seq \n                        : $seq->seq;\n        }\n        else {\n            $residues = '';\n        }\n\n    #set is_analysis flag for gene model features\n    undef(my $isanal);\n    if ($ftype eq 'gene' || $ftype eq 'mRNA' || $ftype eq 'exon' || $ftype eq 'protein' || $ftype eq 'polypeptide') {\n        $isanal = $isanalysis;\n        $isanal = 'false' if !defined $isanal;\n    }\n\n    %datahash = (\n        \"name\"      => $name,\n        \"uniquename\"    => $uniquename,\n        \"seqlen\"    => $len,\n        \"residues\"  => $residues,\n        \"type_id\"   => \\%ftype_hash,\n        \"organism_id\"   => \\%organism,\n        \"is_analysis\"   => $isanal || 'false',\n        );\n\n        if (defined $srcfeature) {\n                %srcfhash = $self->_srcf_hash($srcfeature,\n                                              $srcfeattype,\n                                              \\%organism);\n              \n                my ($phase,$strand);\n                if ($seq->can('phase')) {\n                    $phase = $seq->phase;\n                } \n\n                if ($seq->can('strand')) {\n                    $strand = $seq->strand;\n                }\n                my %fl = (\n                                \"srcfeature_id\" => \\%srcfhash,\n                                \"fmin\"          => $seq->start - 1,\n                                \"fmax\"          => $seq->end,\n                                \"strand\"        => $strand,\n                                \"phase\"         => $phase,\n                                );\n\n                $datahash{'featureloc'} = \\%fl;\n \n        }\n\n\n    #if $srcfeature is not given, use the Bio::Seq object itself as the srcfeature for featureloc's\n    if (!defined $srcfeature) {\n        $srcfeature = $uniquename;\n        $srcfeattype = $ftype;\n    }\n\n    #default data source is 'GenBank'\n    if (!defined $datasource) {\n        $datasource = 'GenBank';\n    }\n\n    if ($datasource =~ /GenBank/i) {\n        #sequence topology as feature_cvterm\n        if ($seq->can('is_circular') && $seq->is_circular) {\n            %sthash = (\n                \"cvterm_id\" => {'name' => 'circular',\n                            'cv_id' => {\n                            'name' => 'sequence topology',\n                            },\n                        },\n                   \"pub_id\" => {'uniquename' => 'nullpub',\n                            'type_id' => {\n                            'name' => 'null pub',\n                            'cv_id' => {\n                                'name'=> 'pub type',\n                            },\n                            },\n                        },\n                );\n        } else {\n            %sthash = (\n                \"cvterm_id\" => { 'name' => 'linear',\n                             'cv_id' => {\n                             'name' => 'sequence topology',\n                             }\n                         },\n                \"pub_id\"    => {'uniquename' => 'nullpub',\n                            'type_id' => {\n                            'name' => 'null pub',\n                            'cv_id' => {\n                                'name'=> 'pub type',\n                            },\n                            },\n                        },\n                   );\n        }\n        push(@feature_cvterms, \\%sthash);\n\n        #division as feature_cvterm\n            if ($seq->can('division') && defined $seq->division()) {\n                $div = $seq->division();\n            %dvhash = (\n                \"cvterm_id\" => {'name' => $div,\n                            'cv_id' => {\n                            'name' => 'GenBank division'}},\n                \"pub_id\"    => {'uniquename' => 'nullpub',\n                            'type_id' => {\n                            'name' => 'null pub',\n                            'cv_id' => {\n                                'name'=> 'pub type'},\n                                }},\n                );\n            push(@feature_cvterms, \\%dvhash);\n        }\n\n        $datahash{'feature_cvterm'} = \\@feature_cvterms;\n    } # closes if GenBank\n\n    #featureprop's\n    #DEFINITION\n    if ($seq->can('desc') && defined $seq->desc()) {\n        $temp = $seq->desc();\n\n        my %prophash = (\n            \"type_id\"   => {'name' => 'description',\n                        'cv_id' => {\n                        'name' => \n                                                 $cv_name{'feature_property'} \n                                                       },\n                                           },\n            \"value\"     => $temp,\n            );\n\n        push(@top_featureprops, \\%prophash);\n        }\n\n    #KEYWORDS\n    if ($seq->can('keywords')) {\n        $temp = $seq->keywords();\n\n        if (defined $temp && $temp ne '.' && $temp ne '') {\n        my %prophash = (\n                \"type_id\"   => {'name' => 'keywords',\n                            'cv_id' => {\n                                                  'name' => \n                                                   $cv_name{'feature_property'}\n                                                           }\n                        },\n                \"value\"     => $temp,\n                            );\n\n        push(@top_featureprops, \\%prophash);\n        }\n        }\n\n    #COMMENT\n    if ($seq->can('annotation')) { \n        $ann = $seq->annotation();\n        foreach my $comment ($ann->get_Annotations('comment')) {\n            $temp = $comment->as_text();\n            #print \"fcomment: $temp\\n\";\n            my %prophash = (\n                \"type_id\"   => {'name' => 'comment',\n                            'cv_id' => {\n                                                  'name' => \n                                                   $cv_name{'feature_property'}\n                                                           }\n                                               },\n                \"value\"     => $temp,\n                );\n\n            push(@top_featureprops, \\%prophash);\n        }\n    }\n\n        my @top_dbxrefs = ();\n        #feature object from Bio::DB::SeqFeature::Store\n        if ($seq->can('attributes')) {\n                my %attributes = $seq->attributes;\n                for my $key (keys %attributes) {\n                    next if ($key eq 'parent_id');\n                    next if ($key eq 'load_id');\n\n                    if ($key eq 'Alias') {\n                        @featuresyns = $self->handle_Alias_tag($seq,@featuresyns);\n                    }\n\n                    ###FIXME deal with Dbxref, Ontology_term,source, \n                    elsif ($key eq 'Ontology_term') {\n                        @top_featurecvterms = $self->handle_Ontology_tag($seq,@top_featurecvterms);\n                    }\n\n                    elsif ($key eq 'dbxref' or $key eq 'Dbxref') {\n                        @top_dbxrefs = $self->handle_dbxref($seq, $key, @top_dbxrefs);\n                    }\n\n                    elsif ($key =~ /^[a-z]/) {\n                        @top_featureprops \n                             = $self->handle_unreserved_tags($seq,$key,@top_featureprops);\n                    }\n                }\n        }\n        $datahash{'feature_synonym'} = \\@featuresyns;\n\n        if ($seq->can('source')) {\n                @top_dbxrefs = $self->handle_source($seq,@top_dbxrefs);\n        }\n\n    #accession and version as feature_dbxref\n    if ($seq->can('accession_number') && defined $seq->accession_number && $seq->accession_number ne 'unknown') {\n        my $db = $self->_guess_acc_db($seq, $seq->accession_number);\n        my %acchash = (\n               \"db_id\"  => {'name' => $db},\n               \"accession\"  => $seq->accession_number,\n               \"version\"    => $seq->seq_version,\n               );\n        my %fdbx = ('dbxref_id' => \\%acchash);\n        push(@top_dbxrefs, \\%fdbx);\n    }\n\n    if( $seq->isa('Bio::Seq::RichSeqI') && defined $seq->get_secondary_accessions() ) {\n        my @secacc = $seq->get_secondary_accessions();\n        my $acc;\n        foreach $acc (@secacc) {\n            my %acchash = (\n                \"db_id\"         => {'name' => 'GB'},\n                \"accession\" => $acc,\n                );\n            my %fdbx = ('dbxref_id' => \\%acchash);\n            push(@top_dbxrefs, \\%fdbx);\n        }\n    }\n\n    #GI number\n    if( $seq->isa('Bio::Seq::RichSeqI') && defined ($seq->pid)) {\n        my $id = $seq->pid;\n        #print \"reftype: \", ref($id), \"\\n\";\n\n        #if (ref($id) eq 'HASH') {\n        my %acchash = (\n            \"db_id\"     => {'name' => 'GI'},\n            \"accession\" => $id,\n            );\n        my %fdbx = ('dbxref_id' => \\%acchash);\n        push (@top_dbxrefs, \\%fdbx);\n    }\n\n    #REFERENCES as feature_pub\n    if (defined $ann) {\n        #get the references\n        @references = $ann->get_Annotations('reference');\n        foreach $ref (@references) {\n        undef(my %pubhash);\n        $refhash = $ref->hash_tree();\n        $location = $ref->location || $refhash->{'location'};\n        #print \"location: $location\\n\";\n\n        #get FBrf#, special for FlyBase SEAN loading\n        if (index($location, ' ==') >= 0) {\n            $location =~ /\\s==/;\n                #print \"match: $MATCH\\n\";\n                #print \"prematch: $PREMATCH\\n\";\n                #print \"postmatch: $POSTMATCH\\n\";\n            $fbrf = $PREMATCH;\n            $location = $POSTMATCH;\n            $location =~ s/^\\s//;\n        }\n\n        #print \"location: $location\\n\";\n        #unpublished reference\n        if ($location =~ /Unpublished/) {\n            $pubtype = 'unpublished';\n            %pubhash = (\n                \"title\"     => $ref->title || $refhash->{'title'},\n                #\"miniref\"  => substr($location, 0, 255),\n                #\"uniquename\"   => $fbrf,\n                \"type_id\"   => {'name' => $pubtype, 'cv_id' => {'name' =>'pub type'}}\n                );\n        }\n        #submitted\n        elsif ($location =~ /Submitted/) {\n            $pubtype = 'submitted';\n\n            %pubhash = (\n                \"title\"     => $ref->title || $refhash->{'title'},\n                #\"miniref\"  => substr($location, 0, 255),\n                #\"uniquename\"   => $fbrf,\n                \"type_id\"   => {'name' => $pubtype, 'cv_id' => {'name' =>'pub type'}}\n                );\n\n            undef(my $pyear);\n            $pyear = $self->_getSubmitYear($location);\n            if (defined $pyear) {\n            $pubhash{'pyear'} = $pyear;\n            }\n        }\n\n        #published journal paper\n        elsif ($location =~ /\\D+\\s\\d+\\s\\((\\d+|\\d+-\\d+)\\),\\s(\\d+-\\d+|\\d+--\\d+)\\s\\(\\d\\d\\d\\d\\)$/) {\n            $pubtype = 'paper';\n\n                #parse location to get journal, volume, issue, pages & year\n            $location =~ /\\(\\d\\d\\d\\d\\)$/;\n\n            $year = $MATCH;\n            my $stuff = $PREMATCH;\n            $year =~ s/\\(//; #remove the leading parenthesis\n            $year =~ s/\\)//; #remove the trailing parenthesis\n\n            $stuff =~ /,\\s(\\d+-\\d+|\\d+--\\d+)\\s$/;\n\n            $pages = $MATCH;\n            $stuff = $PREMATCH;\n            $pages =~ s/^, //; #remove the leading comma and space\n            $pages =~ s/ $//; #remove the last space\n\n            $stuff =~ /\\s\\d+\\s\\((\\d+|\\d+-\\d+)\\)$/;\n\n            $volumeissue = $MATCH;\n            $journal = $PREMATCH;\n            $volumeissue =~ s/^ //; #remove the leading space\n            $volumeissue =~ /\\((\\d+|\\d+-\\d+)\\)$/;\n            $issue = $MATCH;\n            $volume = $PREMATCH;\n            $issue =~ s/^\\(//; #remove the leading parentheses\n            $issue =~ s/\\)$//; #remove the last parentheses\n            $volume =~ s/^\\s//; #remove the leading space\n            $volume =~ s/\\s$//; #remove the last space\n\n            %pubhash = (\n                \"title\"     => $ref->title || $refhash->{'title'},\n                \"volume\"    => $volume,\n                \"issue\"     => $issue,\n                \"pyear\"     => $year,\n                \"pages\"     => $pages,\n                #\"miniref\"  => substr($location, 0, 255),\n                #\"miniref\"  => ' ',\n                #\"uniquename\"   => $fbrf,\n                \"type_id\"   => {'name' => $pubtype, 'cv_id' => {'name' =>'pub type'}},\n                \"pub_relationship\" => {\n                    'obj_pub_id' => {\n                    'uniquename' => $journal,\n                    'title' => $journal,\n                    #'miniref' => substr($journal, 0, 255),\n                    'type_id' =>{'name' => 'journal',\n                             'cv_id' =>\n                             {'name' => 'pub type'\n                              },\n                         },\n                             #'pubprop' =>{'value'=> $journal,\n                             #       'type_id'=>{'name' => 'abbreviation', 'cv_id' => {'name' => 'pubprop type'}},\n                             #      },\n                         },\n                       'type_id' => {\n                           'name' => 'published_in',\n                           'cv_id' => {\n                           'name' => 'pub relationship type'},\n                       },\n                },\n                );\n        }\n\n        #other references\n        else {\n            $pubtype = 'other';\n            %pubhash = (\n                \"title\"     => $ref->title || $refhash->{'title'},\n                #\"miniref\"  => $fbrf,\n                \"type_id\"   => {\n                    'name' => $pubtype,\n                    'cv_id' => {'name' =>'pub type'}\n                }\n                );\n        }\n\n        #pub_author\n        my $autref = $self->_getRefAuthors($ref);\n        if (defined $autref) {\n            $pubhash{'pub_author'} = $autref;\n        }\n        # if no author and is type 'submitted' and has submitter address, use the first 100 characters of submitter address as the author lastname.\n        else {\n            if ($pubtype eq 'submitted') {\n            my $autref = $self->_getSubmitAddr($ref);\n            if (defined $autref) {\n                $pubhash{'pub_author'} = $autref;\n            }\n            }\n        }\n\n        #$ref->comment as pubprop\n        #print \"ref comment: \", $ref->comment, \"\\n\";\n        #print \"ref comment: \", $refhash->{'comment'}, \"\\n\";\n        if (defined $ref->comment || defined $refhash->{'comment'}) {\n            my $comnt = $ref->comment || $refhash->{'comment'};\n                #print \"remark: \", $comnt, \"\\n\";\n            $pubhash{'pubprop'} = {\n            \"type_id\"       => {'name' => 'comment', 'cv_id' => {'name' => 'pubprop type'}},\n            \"value\"     => $comnt,\n            };\n        }\n\n        #pub_dbxref\n        undef(my @pub_dbxrefs);\n        if (defined $fbrf) {\n            push(@pub_dbxrefs, {dbxref_id => {accession => $fbrf, db_id => {'name' => 'FlyBase'}}});\n        }\n        if (defined ($temp = $ref->medline)) {\n            push(@pub_dbxrefs, {dbxref_id => {accession => $temp, db_id => {'name' => 'MEDLINE'}}});\n                #use medline # as the pub's uniquename\n            $pubhash{'uniquename'} = $temp;\n        }\n        if (defined ($temp = $ref->pubmed)) {\n            push(@pub_dbxrefs, {dbxref_id => {accession => $temp, db_id => {'name' => 'PUBMED'}}});\n        }\n        $pubhash{'pub_dbxref'} = \\@pub_dbxrefs;\n\n        #if the pub uniquename is not defined or blank, put its FBrf# as its uniquename\n        #this is unique to FlyBase\n        #USERS OF THIS MODULE: PLEASE MODIFY HERE TO IMPLEMENT YOUR POLICY\n        # ON PUB UNIQUENAME!!!\n        if (!defined $pubhash{'uniquename'} || $pubhash{'uniquename'} eq '') {\n            if (defined $fbrf) {\n            $pubhash{'uniquename'} = $fbrf;\n            }\n                #else {\n                #   $pubhash{'uniquename'} = $self->_CreatePubUname($ref);\n                #}\n        }\n\n        #add to collection of references\n        #if the pub covers the entire sequence of the top-level feature, add it to feature_pubs\n        if (($ref->start == 1 && $ref->end == $len) || (!defined $ref->start && !defined $ref->end)) {\n            push(@feature_pubs, {\"pub_id\" => \\%pubhash});\n        }\n        #the pub is about a sub-sequence of the top-level feature\n        #create a feature for the sub-sequence and add pub as its feature_pub\n        #featureloc of this sub-sequence is against the top-level feature, in interbase coordinates.\n        else {\n            my %parf = (\n                'uniquename'    => $uniquename . ':' . $ref->start . \"\\.\\.\" . $ref->end,\n                'organism_id'   =>\\%organism,\n                'type_id'   =>{'name' =>'region', 'cv_id' => {'name' => $cv_name{'sequence'} }},\n                );\n            my %parfsrcf = (\n                    'uniquename'    => $uniquename,\n                    'organism_id'   =>\\%organism,\n                    );\n            my %parfloc = (\n                   'srcfeature_id'  => \\%parfsrcf,\n                   'fmin'       => $ref->start - 1,\n                   'fmax'       => $ref->end,\n                   );\n            $parf{'featureloc'} = \\%parfloc;\n            $parf{'feature_pub'} = {'pub_id' => \\%pubhash};\n            my %ffr = (\n                   'subject_id' => \\%parf,\n                   'type_id'        => { 'name' => 'partof', 'cv_id' => { 'name' => $cv_name{'relationship'}}},\n                   );\n            push(@top_featrels, \\%ffr);\n        }\n        }\n        $datahash{'feature_pub'} = \\@feature_pubs;\n    }\n\n    ##construct srcfeature hash for use in featureloc\n    if (defined $srcfeature) {\n                %srcfhash = $self->_srcf_hash($srcfeature, \n                                              $srcfeattype, \n                                              \\%organism);\n    #   my %fr = (\n    #       \"object_id\" => \\%srcfhash,\n    #       \"type_id\"   => { 'name' => 'partof', 'cv_id' => { 'name' => 'relationship type'}},\n    #       );\n\n    #   push (@top_featrels, \\%fr);\n    }\n\n    #unflatten the seq features in $seq if $seq is a gene or a DNA sequence\n    if (($gb_type eq 'gene' || $gb_type eq 'DNA') &&\n        !$nounflatten) {\n        my $u = Bio::SeqFeature::Tools::Unflattener->new;\n        $u->unflatten_seq(-seq=>$seq, -use_magic=>1);\n    }\n\n    my @top_sfs = $seq->get_SeqFeatures;\n    #print $#top_sfs, \"\\n\";\n\n    #SUBFEATURES\n\n    if ($datasource =~ /GenBank/i) {\n        $tag_cv = 'GenBank feature qualifier';\n    } elsif ($datasource =~ /GFF/i) {\n        $tag_cv = 'feature_property';\n    } else {\n        $tag_cv = $cv_name{'feature_property'};\n    }\n\n    my $si = 0;\n    foreach $feat (@top_sfs) {\n        #$feat = $top_sfs[$si];\n        #print \"si: $si\\n\";\n        my $prim_tag = $feat->primary_tag;\n        #print $prim_tag, \"\\n\";\n\n        # get all qualifiers of the 'source' feature, load these as top_featureprops of the top level feature\n        if ($prim_tag eq 'source') {\n            foreach $tag ($feat->all_tags()) {\n                #db_xref\n                if ($tag eq 'db_xref' \n                                 or $tag eq 'Dbxref'\n                                 or $tag eq 'dbxref')   {\n                    my @t1 = $feat->each_tag_value($tag);\n                    foreach $temp (@t1) {\n                       $temp =~ /([^:]*?):(.*)/;\n                                           my $db = $1; \n                                           my $xref = $2;\n                                           #PRE/POST very inefficent\n                       #my $db = $PREMATCH;\n                       #my $xref = $POSTMATCH;\n                       my %acchash = (\n                        \"db_id\"     => {'name' => $db},\n                        \"accession\" => $xref,\n                        );\n                       my %fdbx = ('dbxref_id' => \\%acchash);\n                       push (@top_dbxrefs, \\%fdbx);\n                    }\n                                #Ontology_term\n                                } elsif ($tag eq 'Ontology_term') {\n                                        my @t1 = $feat->each_tag_value($tag);\n                                        foreach $temp (@t1) {\n                                            ###FIXME\n                                        }\n                #other tags as featureprop\n                } elsif ($tag ne 'gene') {\n                    my %prophash = undef;\n                    %prophash = (\n                                    \"type_id\"       => {'name' => $tag, 'cv_id' => {'name' => $tag_cv}},\n                        \"value\"     => join(' ',$feat->each_tag_value($tag)),\n                        );\n                    push(@top_featureprops, \\%prophash);\n                }\n            }\n\n                        if ($feat->can('source')) {\n                            my $source = $feat->source();\n                            @top_dbxrefs = $self->handle_source($feat, @top_dbxrefs);\n                        }\n\n            #featureloc for the top-level feature\n            my $fmin = undef;\n            my $fmax = undef;\n            my $strand = undef;\n                        my $phase = undef;\n            my %fl = undef;\n\n            $fmin = $feat->start - 1;\n            $fmax = $feat->end;\n            $strand = $feat->strand;\n\n                        if ($feat->can('phase')) {\n                            $phase = $feat->phase;\n                        }\n\n            %fl = (\n                \"srcfeature_id\" => \\%srcfhash,\n                \"fmin\"      => $fmin,\n                \"fmax\"      => $fmax,\n                \"strand\"    => $strand,\n                                \"phase\"         => $phase,\n                );\n\n            $datahash{'featureloc'} = \\%fl;\n\n            #delete 'source' feature from @top_sfs\n            splice(@top_sfs, $si, 1);\n        }\n        $si ++;\n    #close loop over top_sfs\n    }\n\n    #the top-level features other than 'source'\n    foreach $feat (@top_sfs) {\n        #print $feat->primary_tag, \"\\n\";\n\n        my $r = $self->_subfeat2featrelhash($name, $ftype, $feat, \\%srcfhash, $tag_cv, $isanalysis);\n\n        if (!($ftype eq 'mRNA' && $feat->primary_tag eq 'gene')) {\n            my %fr = %$r;\n            push(@top_featrels, \\%fr);\n        } else {\n            %finaldatahash = %$r;\n        }\n    }\n\n    if (@top_dbxrefs) {\n        $datahash{'feature_dbxref'} = \\@top_dbxrefs;\n    }\n\n    if (@top_featureprops) {\n        $datahash{'featureprop'} = \\@top_featureprops;\n    }\n\n    if (@top_featrels) {\n        $datahash{'feature_relationship'} = \\@top_featrels;\n    }\n\n        if (@top_featurecvterms) {\n                $datahash{'feature_cvterm'} = \\@top_featurecvterms;\n        }\n\n    if ($ftype eq 'mRNA' && %finaldatahash) {\n        $finaldatahash{'feature_relationship'} = {\n                        'subject_id'    => \\%datahash,\n                        'type_id'   => { 'name' => 'partof', 'cv_id' => { 'name' => $cv_name{'relationship'} }},\n                             };\n    } else {\n        %finaldatahash = %datahash;\n    }\n\n    my $mainTag = 'feature';\n    $self->_hash2xml(undef, $mainTag, \\%finaldatahash);\n\n    return 1;\n}\n\nsub _hash2xml {\n    my $self = shift;\n    my $isMatch = undef;\n    $isMatch = shift;\n    my $ult = shift;\n    my $ref = shift;\n    my %mh = %$ref;\n    my $key;\n    my $v;\n    my $sh;\n    my $xx;\n    my $yy;\n    my $nt;\n    my $ntref;\n    my $output;\n    my $root = shift if (@_);\n    #print \"ult: $ult\\n\";\n    if (!defined $self->{'writer'}) {\n    $root = 1;\n        $self->_create_writer();\n    }\n    my $temp;\n    my %subh = undef;\n\n    #start opeing tag\n    #if pub record of type 'journal', form the 'ref' attribute for special pub lookup\n    #requires that the journal name itself is also stored as a pubprop record for the journal with value equal\n    #to the journal name and type of 'abbreviation'.\n    if ($ult eq 'pub' && $mh{'type_id'}->{'name'} eq 'journal') {\n    $self->{'writer'}->startTag($ult, 'ref' => $mh{'title'} . ':journal:abbreviation');\n    }\n\n    #special pub match if pub uniquename not known\n    elsif ($ult eq 'pub' && !defined $mh{'uniquename'}) {\n    $self->{'writer'}->startTag($ult, 'op' => 'match');\n    #set the match flag, all the sub tags should also have \"op\"=\"match\"\n    $isMatch = 1;\n    }\n\n    #if cvterm or cv, lookup only\n    elsif (($ult eq 'cvterm') || ($ult eq 'cv')) {\n    $self->{'writer'}->startTag($ult, 'op' => 'lookup');\n    }\n\n    #if nested tables of match table, match too\n    elsif ($isMatch) {\n    $self->{'writer'}->startTag($ult, 'op' => 'match');\n    }\n\n    else {\n    $self->{'writer'}->startTag($ult);\n    }\n\n    #first loop to produce xml for all the table columns\n    foreach $key (keys %mh)\n    {\n    #print \"key: $key\\n\";\n    $xx = ' ' . $key;\n    $yy = $key . ' ';\n    if (index($chadotables, $xx) < 0 && index($chadotables, $yy) < 0)\n    {\n        if ($isMatch) {\n        $self->{'writer'}->startTag($key, 'op' => 'match');\n        } else {\n        $self->{'writer'}->startTag($key);\n        }\n\n        my $x = $ult . '.' . $key;\n        #the column is a foreign key\n        if (defined $fkey{$x})\n        {\n        $nt = $fkey{$x};\n        $sh = $mh{$key};\n        $self->_hash2xml($isMatch, $nt, $sh, 0);\n        } else\n        {\n        #print \"$key: $mh{$key}\\n\";\n        $self->{'writer'}->characters($mh{$key});\n        }\n        $self->{'writer'}->endTag($key);\n    }\n    }\n\n    #second loop to produce xml for all the nested tables\n    foreach $key (keys %mh)\n    {\n    #print \"key: $key\\n\";\n    $xx = ' ' . $key;\n    $yy = $key . ' ';\n    #a nested table\n    if (index($chadotables, $xx) > 0 || index($chadotables, $yy) > 0)\n    {\n        #$writer->startTag($key);\n        $ntref = $mh{$key};\n        #print \"$key: \", ref($ntref), \"\\n\";\n        if (ref($ntref) =~ 'HASH') {\n        $self->_hash2xml($isMatch, $key, $ntref, 0);\n        } elsif (ref($ntref) =~ 'ARRAY') {\n        #print \"array dim: \", $#$ntref, \"\\n\";\n        foreach $ref (@$ntref) {\n                #print \"\\n\";\n            $self->_hash2xml($isMatch, $key, $ref, 0);\n        }\n        }\n        #$writer->endTag($key);\n    }\n    }\n\n    #end tag\n    $self->{'writer'}->endTag($ult);\n\n    #if ($root == 1) {\n#   $self->{'writer'}->endTag('chado');\n#    }\n}\n\nsub _guess_acc_db {\n    my $self = shift;\n    my $seq = shift;\n    my $acc = shift;\n    #print \"acc: $acc\\n\";\n\n    if ($acc =~ /^NM_\\d{6}/ || $acc =~ /^NP_\\d{6}/ || $acc =~ /^NT_\\d{6}/ || $acc =~ /^NC_\\d{6}/) {\n        return \"RefSeq\";\n    } elsif ($acc =~ /^XM_\\d{6}/ || $acc =~ /^XP_\\d{6}/ || $acc =~ /^XR_\\d{6}/) {\n        return \"RefSeq\";\n    } elsif ($acc =~ /^[a-zA-Z]{1,2}\\d{5,6}/) {\n        return \"GB\";\n    } elsif ($seq->molecule() eq 'protein' && $acc =~ /^[a-zA-z]\\d{5}/) {\n        return \"PIR\";\n    } elsif ($seq->molecule() eq 'protein' && $acc =~ /^\\d{6,7}[a-zA-Z]/) {\n        return \"PRF\";\n    } elsif ($acc =~ /\\d+/ && $acc !~ /[a-zA-Z]/) {\n        return \"LocusID\";\n    } elsif ($acc =~ /^CG\\d+/ || $acc =~ /^FB[a-z][a-z]\\d+/) {\n        return \"FlyBase\";\n    } else {\n        return \"unknown\";\n    }\n}\n\nsub _subfeat2featrelhash {\n    my $self = shift;\n    my $genename = shift;\n    my $seqtype = shift;\n    my $feat = shift;\n    my $r = shift;\n    my %srcf = %$r;     #srcfeature hash for featureloc.srcfeature_id\n    my $tag_cv = shift;\n    my $isanalysis = shift;\n\n    my $prim_tag = $feat->primary_tag;\n\n    my $sfunique = undef;       #subfeature uniquename\n    my $sfname = undef;     #subfeature name\n    my $sftype = undef;     #subfeature type\n\n    if ($feat->has_tag('symbol')) {\n        ($sfunique) = $feat->each_tag_value(\"symbol\");\n    } elsif ($feat->has_tag('label')) {\n        ($sfunique) = $feat->each_tag_value(\"label\");\n    } else {\n        #$self->throw(\"$prim_tag at \" . $feat->start . \"\\.\\.\" . $feat->end . \" does not have symbol or label! To convert into chadoxml, a seq feature must have a /symbol or /label tag holding its unique name.\");\n        #generate feature unique name as <genename>-<feature-type>-<span>\n        $sfunique = $self->_genFeatUniqueName($genename, $feat);\n    }\n\n    if ($feat->has_tag('Name')) {\n        ($sfname) = $feat->each_tag_value(\"Name\");\n    }\n\n    #feature type translation\n    if (defined $feattype_args2so{$prim_tag}) {\n        $sftype = $feattype_args2so{$prim_tag};\n    } else {\n        $sftype = $prim_tag;\n    }\n\n    if ($prim_tag eq 'mutation') {\n        if ($feat->start == $feat->end) {\n            $sftype = $feattype_args2so{'mutation1'};\n        } else {\n            $sftype = $feattype_args2so{'mutation2'};\n        }\n    }\n\n    #set is_analysis flag for gene model features\n    undef(my $isanal);\n    if ($sftype eq 'gene' || $sftype eq 'mRNA' || $sftype eq 'exon' || $sftype eq 'protein' || $sftype eq 'polypeptide') {\n        $isanal = $isanalysis;\n    }\n\n    my %sfhash = (\n        \"name\"          => $sfname,\n        \"uniquename\"        => $sfunique,\n        \"organism_id\"       => \\%organism,\n        \"type_id\"       => { 'name' => $sftype, 'cv_id' => { 'name' => $cv_name{'sequence'} }},\n        \"is_analysis\"           => $isanal || 'false',\n        );\n\n    #make a copy of %sfhash for passing to this method when recursively called\n    #my %srcfeat = (\n        #        \"name\"                  => $sfname,\n        #        \"uniquename\"            => $sfunique,\n        #        \"organism_id\"           => \\%organism,\n        #        \"type_id\"               => { 'name' => $sftype, 'cv_id' => { 'name' => 'SO'}},\n        #        );\n\n    #featureloc for subfeatures\n    undef(my $sfmin);\n    undef(my $sfmax);\n    undef(my $is_sfmin_partial);\n    undef(my $is_sfmax_partial);\n    undef(my $sfstrand);\n        undef(my $sfphase);\n    $sfmin = $feat->start - 1;\n    $sfmax = $feat->end;\n    $sfstrand = $feat->strand();\n\n        if ($feat->can('phase')) {\n            $sfphase = $feat->phase;\n        }\n\n    #if the gene feature in an mRNA record, cannot use its coordinates, omit featureloc\n    if ($seqtype eq 'mRNA' && $sftype eq 'gene') {\n    } else {\n        if ($feat->location->isa('Bio::Location::FuzzyLocationI')) {\n            if ($feat->location->start_pos_type() ne 'EXACT') {\n                $is_sfmin_partial = 'true';\n            }\n            if ($feat->location->end_pos_type() ne 'EXACT') {\n                $is_sfmax_partial = 'true';\n            }\n        }\n\n        my %sfl = (\n            \"srcfeature_id\" => \\%srcf,\n            \"fmin\"      => $sfmin,\n            \"is_fmin_partial\" => $is_sfmin_partial || 'false',\n            \"fmax\"      => $sfmax,\n            \"is_fmax_partial\" => $is_sfmax_partial || 'false',\n            \"strand\"    => $sfstrand,\n                        \"phase\"         => $sfphase,\n            );\n\n        $sfhash{'featureloc'} = \\%sfl;\n    }\n\n\n    #subfeature tags\n    undef(my @sfdbxrefs);       #subfeature dbxrefs\n    undef(my @sub_featureprops);    #subfeature props\n        undef(my @sub_featuresyns);     #subfeature synonyms\n        undef(my @sub_featurecvterms);  #subfeature cvterms\n    foreach my $tag ($feat->all_tags()) {\n        #feature_dbxref for features\n        if ($tag eq 'db_xref' or $tag eq 'dbxref' or $tag eq 'Dbxref')   {\n            my @t1 = $feat->each_tag_value($tag);\n            #print \"# of dbxref: @t1\\n\";\n            for my $temp (@t1) {\n               $temp =~ /:/;\n               my $db = $PREMATCH;\n               my $xref = $POSTMATCH;\n               #print \"db: $db; xref: $xref\\n\";\n               my %acchash = (\n                \"db_id\"     => {'name' => $db},\n                \"accession\" => $xref,\n                );\n               my %sfdbx = ('dbxref_id' => \\%acchash);\n               push (@sfdbxrefs, \\%sfdbx);\n            }\n                #Alias tags\n                } elsif ($tag eq 'Alias') {\n                        @sub_featuresyns = $self->handle_Alias_tag($feat, @sub_featuresyns);\n                } elsif ($tag eq 'Ontology_term') {\n                        @sub_featurecvterms = $self->handle_Ontology_tag($feat, @sub_featurecvterms);\n        #featureprop for features, excluding GFF Name & Parent tags\n        } elsif ($tag ne 'gene' && $tag ne 'symbol' && $tag ne 'Name' && $tag ne 'Parent') {\n                        next if ($tag eq 'parent_id');\n                        next if ($tag eq 'load_id');\n            foreach my $val ($feat->each_tag_value($tag)) {\n                my %prophash = undef;\n                %prophash = (\n                                \"type_id\"       => {'name' => $tag, 'cv_id' => {'name' => $tag_cv}},\n                    \"value\"     => $val,\n                );\n                push(@sub_featureprops, \\%prophash);\n            }\n        }\n    }\n\n        if ($feat->can('source')) {\n                @sfdbxrefs = $self->handle_source($feat,@sfdbxrefs);\n        }\n\n    if (@sub_featureprops) {\n        $sfhash{'featureprop'} = \\@sub_featureprops;\n    }\n    if (@sfdbxrefs) {\n        $sfhash{'feature_dbxref'} = \\@sfdbxrefs;\n    }\n        if (@sub_featuresyns) {\n                $sfhash{'feature_synonym'} = \\@sub_featuresyns;\n        }\n        if (@sub_featurecvterms) {\n                $sfhash{'feature_cvterm'} = \\@sub_featurecvterms;\n        }\n\n    undef(my @ssfeatrel);\n    if ($feat->has_tag('locus_tag')) {\n        ($genename)= $feat->each_tag_value('locus_tag');\n    } elsif ($feat->has_tag('gene')) {\n        ($genename)= $feat->each_tag_value('gene');\n    }\n\n    foreach my $sf ($feat->get_SeqFeatures()) {\n        #print $sf->primary_tag, \"\\n\";\n        my $rref = $self->_subfeat2featrelhash($genename, $sftype, $sf, \\%srcf, $tag_cv, $isanalysis);\n        if (defined $rref) {\n            push(@ssfeatrel, $rref);\n        }\n    }\n\n    if (@ssfeatrel) {\n        $sfhash{'feature_relationship'} = \\@ssfeatrel;\n    }\n\n    #subj-obj relationship type\n    undef(my $reltypename);\n        $reltypename = return_reltypename($sftype);\n\n    my %fr = (\n        \"subject_id\"    => \\%sfhash,\n        \"type_id\"       => { 'name' => $reltypename, \n                                             'cv_id' => { 'name' => $cv_name{'relationship'} }},\n        );\n\n    if ($seqtype eq 'mRNA' && $sftype eq 'gene') {\n        return \\%sfhash;\n    } else {\n        return \\%fr;\n    }\n\n}\n\n#generate uniquename for feature as: <genename>-<feature-type>-<span> (foo-mRNA-10..1000)\nsub _genFeatUniqueName {\n    my $self = shift;\n    my $genename = shift;\n    my $feat = shift;\n    undef(my $uniquename);\n    my $ftype = $feat->primary_tag;\n    my $start = $feat->start;\n    my $end = $feat->end;\n\n    if ($feat->has_tag('locus_tag')) {\n        ($genename) = $feat->each_tag_value(\"locus_tag\");\n    } elsif ($feat->has_tag('gene')) {\n        ($genename) = $feat->each_tag_value(\"gene\");\n    }\n\n    $uniquename = $genename . '-' . $ftype . '-' . $start . \"\\.\\.\" . $end;\n\n    return $uniquename;\n}\n\n#create uniquename for pubs with no medline id and no FBrf#\n#use \"<authors>, <year>, <type>\" as the uniquename (same as miniref)\n#<authors> is <sole-author-surname>    if one author,\n#  or <first-author-surname> and <second-author-surname>   if two,\n#  or <first-author-surname> et al.   if more\n#sub _CreatePubUname {\n#   my $self = shift;\n#   my $pub = shift;\n#   undef(my $pubuname);\n#\n#   return $pubuname;\n#}\n\n#get authors of a reference\n#returns ref to the array of author hashes\nsub _getRefAuthors {\n    my $self = shift;\n    my $ref = shift;\n\n    my $temp = $ref->authors;\n    undef(my @authors);\n    undef(my @aut);\n\n    #there are authors\n    if ($temp ne '.') {\n        if (index($temp, ' and ') > 0) {\n            $temp =~ / and /;\n            my $lastauthor = $POSTMATCH;\n            @authors = split(/\\, /, $PREMATCH);\n            push (@authors, $lastauthor);\n        } else {\n            @authors = split(/\\, /, $temp);\n        }\n\n        my $a;\n        my $i = 0;\n        foreach $a (@authors) {\n            $i ++;\n            #parse the author lastname and givennames\n            undef(my $last);\n            undef(my $given);\n            if (index($a, ',') > 0) {   #genbank format, last,f.m.\n                ($last, $given) = split(/\\,/, $a);\n            } elsif (index($a, ' ') > 0) {  #embl format, last f.m.\n                ($last, $given) = split(/ /, $a);\n            }\n            my %au = (\n                'surname'   => $last,\n                'givennames'    => $given,\n                );\n            push(@aut, {author_id => \\%au, arank => $i});\n        }\n\n        return \\@aut;\n    }\n\n    #no authors, Bio::SeqIO::genbank doesn't pick up 'CONSRTM' line.\n    else {\n        return;\n    }\n\n}\n\n#extract submission year from the citation of the submitted reference\n#genbank format for the submitted citation: JOURNAL   Submitted (DD-MON-YYYY) submitter address\nsub _getSubmitYear {\n    my $self = shift;\n    my $citation = shift;\n\n    if ($citation !~ /Submitted/) {\n    $self->warn(\"not citation for a submitted reference. cannot extract submission year.\");\n    return;\n    } else {\n    $citation =~ /Submitted \\(\\d\\d-[a-zA-Z]{3}-\\d{4}\\)/;\n    my $a = $MATCH;\n    $a =~ /\\d{4}/;\n    my $year = $MATCH;\n\n    return $year;\n    }\n}\n\nsub _getSubmitAddr {\n    my $self = shift;\n    my $ref = shift;\n    undef(my %author);\n\n    my $citation = $ref->location;\n    if ($citation !~ /Submitted/) {\n    $self->warn(\"not citation for a submitted reference. cannot extract submission year.\");\n    return;\n    } else {\n    $citation =~ /Submitted \\(\\d\\d-[a-zA-Z]{3}-\\d{4}\\)/;\n    my $a = $POSTMATCH;\n    if (defined $a) {\n        $a =~ s/^\\s//;\n        %author = (\n               'author_id'  => {'surname'   => substr($a, 0, 100)},\n               );\n        return \\%author;\n    } else {\n        return;\n    }\n    }\n}\n\n=head2 suppress_residues\n\n Title    : suppress_residues\n Usage    : $obj->suppress_residues()        #get existing value\n            $obj->suppress_residues($newval) #set new value\n Function : Keep track of the flag to suppress printing of residues in the\n            chadoxml file. The default it to allow all residues to go into the\n            file.\n Returns  : value of suppress_residues (a scalar)\n Args     : new value of suppress_residues (to set)\n\n\nsub suppress_residues {\n    my $self = shift;\n    my $suppress_residues = shift if defined(@_);\n    return $self->{'suppress_residues'} = $suppress_residues if defined($suppress_residues);\n    return $self->{'suppress_residues'};\n}\n\n=head2 allow_residues\n\n Title    : allow_residues\n Usage    : $obj->allow_residues()        #get existing value\n            $obj->allow_residues($feature_type) #set new value\n Function : Track the allow_residues type.  This can be used in conjunction\n            with the suppress_residues flag to only allow residues from a\n            specific feature type to be printed in the xml file, for example,\n            only printing chromosome residues. When suppress_residues is set to\n            true, then only chromosome features would would go into the xml\n            file. If suppress_residues is not set, this function has no effect\n            (since the default is to put all residues in the xml file).\n Returns  : value of allow_residues (string that corresponds to a feature type)\n Args     : new value of allow_residues (to set)\n Status   :\n\n\nsub allow_residues {\n    my $self = shift;\n    my $allow_residues = shift if defined(@_);\n    return $self->{'allow_residues'} = $allow_residues if defined($allow_residues);\n    return $self->{'allow_residues'};\n}\n\n=head2 return_ftype_hash\n\n Title    : return_ftype_hash\n Usage    : $obj->return_ftype_hash()\n Function : A simple hash where returning it has be factored out of the main\n            code to allow subclasses to override it.\n Returns  : A hash that indicates what the name of the SO term is and what\n            the name of the Sequence Ontology is in the cv table.\n Args     : The string that represents the SO term.\n Status   :\n\n\nsub return_ftype_hash {\n    my $self  = shift;\n    my $ftype = shift;\n    my %ftype_hash = ( \"name\" => $ftype,\n                       \"cv_id\" => {\"name\" => $cv_name{'sequence'} });\n    return %ftype_hash;\n}\n\n=head2 return_reltypename\n\n Title    : return_reltypename\n Usage    : $obj->return_reltypename\n Function : Return the appropriate relationship type name depending on the\n            feature type (typically part_of, but derives_from for polypeptide).\n Returns  : A relationship type name.\n Args     : A SO type name.\n Status   :\n\n\nsub return_reltypename {\n    my $self   = shift;\n    my $sftype = shift;\n\n    my $reltypename;\n    if ($sftype eq 'protein' || $sftype eq 'polypeptide') {\n        $reltypename = 'derives_from';\n    } else {\n        $reltypename = 'part_of';\n    }\n\n    return $reltypename;\n}\n\n=head2 next_seq\n\n Title    : next_seq\n Usage    : $obj->next_seq\n Function : \n Returns  : \n Args     : \n Status   : Not implemented (write only adaptor)","parameters":[{"label":"$self"},{"label":"%argv"}],"label":"next_seq($self,%argv)"},"line":1761,"kind":12,"range":{"end":{"character":9999,"line":1766},"start":{"character":0,"line":1761}}},{"line":1779,"range":{"end":{"line":1795,"character":9999},"start":{"line":1779,"character":0}},"kind":12,"definition":"sub","children":[{"definition":"my","line":1780,"name":"$self","localvar":"my","kind":13,"containerName":"_create_writer"},{"name":"$self","containerName":"_create_writer","kind":13,"line":1782},{"line":1782,"containerName":"_create_writer","kind":13,"name":"$self"},{"kind":12,"containerName":"_create_writer","name":"_fh","line":1782},{"containerName":"_create_writer","kind":13,"name":"$self","line":1787},{"line":1787,"containerName":"_create_writer","kind":12,"name":"xmlDecl"},{"line":1788,"kind":13,"containerName":"_create_writer","name":"$self"},{"name":"comment","kind":12,"containerName":"_create_writer","line":1788},{"containerName":"_create_writer","kind":13,"name":"$self","line":1792},{"line":1792,"name":"startTag","containerName":"_create_writer","kind":12}],"name":"_create_writer","containerName":"main::"},{"line":1782,"kind":12,"name":"new"},{"name":"XML","containerName":"Writer","kind":12,"line":1782},{"name":"OUTPUT","kind":12,"line":1782},{"line":1783,"name":"DATA_MODE","kind":12},{"line":1784,"kind":12,"name":"DATA_INDENT"},{"kind":12,"range":{"end":{"line":1813,"character":9999},"start":{"character":0,"line":1808}},"line":1808,"definition":"sub","containerName":"main::","name":"close_chadoxml","children":[{"definition":"my","line":1809,"name":"$self","localvar":"my","containerName":"close_chadoxml","kind":13},{"line":1811,"name":"$self","kind":13,"containerName":"close_chadoxml"},{"containerName":"close_chadoxml","kind":12,"name":"endTag","line":1811}]},{"definition":"sub","children":[{"definition":"my","line":1827,"kind":13,"localvar":"my","containerName":"handle_unreserved_tags","name":"$self"},{"definition":"my","kind":13,"localvar":"my","containerName":"handle_unreserved_tags","name":"$seq","line":1828},{"definition":"my","line":1829,"name":"$key","localvar":"my","containerName":"handle_unreserved_tags","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"handle_unreserved_tags","name":"@arr","line":1830},{"localvar":"my","kind":13,"containerName":"handle_unreserved_tags","name":"@values","line":1832,"definition":"my"},{"line":1832,"name":"$seq","containerName":"handle_unreserved_tags","kind":13},{"name":"attributes","kind":12,"containerName":"handle_unreserved_tags","line":1832},{"name":"$key","containerName":"handle_unreserved_tags","kind":13,"line":1832},{"name":"$value","containerName":"handle_unreserved_tags","localvar":"my","kind":13,"line":1833,"definition":"my"},{"name":"@values","containerName":"handle_unreserved_tags","kind":13,"line":1833},{"line":1834,"containerName":"handle_unreserved_tags","localvar":"my","kind":13,"name":"%prophash","definition":"my"},{"containerName":"handle_unreserved_tags","kind":13,"name":"$key","line":1835},{"line":1836,"name":"$cv_name","containerName":"handle_unreserved_tags","kind":13},{"line":1838,"name":"$value","containerName":"handle_unreserved_tags","kind":13},{"line":1840,"name":"@arr","containerName":"handle_unreserved_tags","kind":13},{"line":1840,"kind":13,"containerName":"handle_unreserved_tags","name":"%prophash"},{"line":1843,"kind":13,"containerName":"handle_unreserved_tags","name":"@arr"}],"name":"handle_unreserved_tags","containerName":"main::","line":1826,"range":{"start":{"line":1826,"character":0},"end":{"line":1844,"character":9999}},"kind":12},{"line":1857,"range":{"end":{"line":1882,"character":9999},"start":{"line":1857,"character":0}},"kind":12,"children":[{"definition":"my","line":1858,"name":"$self","localvar":"my","kind":13,"containerName":"handle_Alias_tag"},{"localvar":"my","containerName":"handle_Alias_tag","kind":13,"name":"$seq","line":1859,"definition":"my"},{"name":"@arr","localvar":"my","kind":13,"containerName":"handle_Alias_tag","line":1860,"definition":"my"},{"name":"@Aliases","localvar":"my","kind":13,"containerName":"handle_Alias_tag","line":1862,"definition":"my"},{"line":1862,"name":"$seq","containerName":"handle_Alias_tag","kind":13},{"line":1862,"name":"attributes","containerName":"handle_Alias_tag","kind":12},{"line":1863,"localvar":"my","kind":13,"containerName":"handle_Alias_tag","name":"$Alias","definition":"my"},{"line":1863,"name":"@Aliases","containerName":"handle_Alias_tag","kind":13},{"localvar":"my","containerName":"handle_Alias_tag","kind":13,"name":"%synhash","line":1864,"definition":"my"},{"containerName":"handle_Alias_tag","kind":13,"name":"$Alias","line":1867},{"line":1868,"name":"$Alias","kind":13,"containerName":"handle_Alias_tag"},{"name":"@arr","containerName":"handle_Alias_tag","kind":13,"line":1870},{"line":1870,"name":"%synhash","containerName":"handle_Alias_tag","kind":13},{"line":1881,"containerName":"handle_Alias_tag","kind":13,"name":"@arr"}],"name":"handle_Alias_tag","containerName":"main::","definition":"sub"},{"definition":"sub","children":[{"definition":"my","line":1896,"name":"$self","kind":13,"localvar":"my","containerName":"handle_Ontology_tag"},{"name":"$seq","localvar":"my","kind":13,"containerName":"handle_Ontology_tag","line":1897,"definition":"my"},{"name":"@arr","kind":13,"localvar":"my","containerName":"handle_Ontology_tag","line":1898,"definition":"my"},{"line":1900,"containerName":"handle_Ontology_tag","localvar":"my","kind":13,"name":"@terms","definition":"my"},{"line":1900,"kind":13,"containerName":"handle_Ontology_tag","name":"$seq"},{"line":1900,"containerName":"handle_Ontology_tag","kind":12,"name":"attributes"},{"name":"$term","localvar":"my","containerName":"handle_Ontology_tag","kind":13,"line":1901,"definition":"my"},{"line":1901,"containerName":"handle_Ontology_tag","kind":13,"name":"@terms"},{"definition":"my","containerName":"handle_Ontology_tag","localvar":"my","kind":13,"name":"$hashref","line":1902},{"name":"$term","kind":13,"containerName":"handle_Ontology_tag","line":1903},{"name":"$db","localvar":"my","containerName":"handle_Ontology_tag","kind":13,"line":1904,"definition":"my"},{"line":1905,"name":"$acc","localvar":"my","containerName":"handle_Ontology_tag","kind":13,"definition":"my"},{"line":1906,"name":"$hashref","containerName":"handle_Ontology_tag","kind":13},{"line":1909,"kind":13,"containerName":"handle_Ontology_tag","name":"$db"},{"line":1911,"name":"$acc","containerName":"handle_Ontology_tag","kind":13},{"name":"@arr","containerName":"handle_Ontology_tag","kind":13,"line":1915},{"line":1915,"kind":13,"containerName":"handle_Ontology_tag","name":"$hashref"},{"kind":13,"containerName":"handle_Ontology_tag","name":"@arr","line":1918}],"containerName":"main::","name":"handle_Ontology_tag","line":1895,"kind":12,"range":{"start":{"character":0,"line":1895},"end":{"character":9999,"line":1919}}},{"line":1915,"name":"cvterm_id","kind":12},{"line":1932,"kind":12,"range":{"end":{"line":1963,"character":9999},"start":{"character":0,"line":1932}},"definition":"sub","children":[{"definition":"my","line":1933,"localvar":"my","kind":13,"containerName":"handle_dbxref","name":"$self"},{"definition":"my","name":"$seq","localvar":"my","containerName":"handle_dbxref","kind":13,"line":1934},{"localvar":"my","kind":13,"containerName":"handle_dbxref","name":"$tag","line":1935,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"handle_dbxref","name":"@arr","line":1936},{"name":"@terms","localvar":"my","kind":13,"containerName":"handle_dbxref","line":1938,"definition":"my"},{"kind":13,"containerName":"handle_dbxref","name":"$seq","line":1938},{"name":"attributes","containerName":"handle_dbxref","kind":12,"line":1938},{"line":1938,"containerName":"handle_dbxref","kind":13,"name":"$tag"},{"localvar":"my","containerName":"handle_dbxref","kind":13,"name":"$term","line":1939,"definition":"my"},{"containerName":"handle_dbxref","kind":13,"name":"@terms","line":1939},{"definition":"my","localvar":"my","containerName":"handle_dbxref","kind":13,"name":"$hashref","line":1940},{"line":1941,"kind":13,"containerName":"handle_dbxref","name":"$term"},{"definition":"my","line":1942,"localvar":"my","kind":13,"containerName":"handle_dbxref","name":"$db"},{"line":1943,"name":"$acc","localvar":"my","containerName":"handle_dbxref","kind":13,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"handle_dbxref","name":"$version","line":1944},{"kind":13,"containerName":"handle_dbxref","name":"$acc","line":1945},{"name":"$acc","kind":13,"containerName":"handle_dbxref","line":1946},{"kind":13,"containerName":"handle_dbxref","name":"$version","line":1947},{"name":"$hashref","kind":13,"containerName":"handle_dbxref","line":1949},{"name":"$db","kind":13,"containerName":"handle_dbxref","line":1951},{"line":1952,"name":"$acc","containerName":"handle_dbxref","kind":13},{"containerName":"handle_dbxref","kind":13,"name":"$version","line":1953},{"line":1958,"name":"$self","containerName":"handle_dbxref","kind":13},{"name":"throw","kind":12,"containerName":"handle_dbxref","line":1958},{"line":1960,"kind":13,"containerName":"handle_dbxref","name":"@arr"},{"name":"$hashref","kind":13,"containerName":"handle_dbxref","line":1960},{"name":"@arr","containerName":"handle_dbxref","kind":13,"line":1962}],"containerName":"main::","name":"handle_dbxref"},{"containerName":"main::","name":"handle_source","children":[{"definition":"my","containerName":"handle_source","localvar":"my","kind":13,"name":"$self","line":1977},{"localvar":"my","containerName":"handle_source","kind":13,"name":"$seq","line":1978,"definition":"my"},{"line":1979,"name":"@arr","localvar":"my","containerName":"handle_source","kind":13,"definition":"my"},{"line":1981,"containerName":"handle_source","localvar":"my","kind":13,"name":"$source","definition":"my"},{"name":"$seq","containerName":"handle_source","kind":13,"line":1981},{"containerName":"handle_source","kind":12,"name":"source","line":1981},{"name":"@arr","kind":13,"containerName":"handle_source","line":1982},{"line":1982,"name":"$source","kind":13,"containerName":"handle_source"},{"definition":"my","line":1984,"containerName":"handle_source","localvar":"my","kind":13,"name":"$hashref"},{"line":1987,"kind":13,"containerName":"handle_source","name":"$source"},{"kind":13,"containerName":"handle_source","name":"@arr","line":1991},{"kind":13,"containerName":"handle_source","name":"$hashref","line":1991},{"line":1992,"kind":13,"containerName":"handle_source","name":"@arr"}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":1993},"start":{"line":1976,"character":0}},"line":1976},{"definition":"sub","name":"_srcf_hash","containerName":"main::","children":[{"localvar":"my","containerName":"_srcf_hash","kind":13,"name":"$self","line":2008,"definition":"my"},{"line":2009,"name":"$srcf","containerName":"_srcf_hash","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":2010,"name":"$stype","containerName":"_srcf_hash","localvar":"my","kind":13},{"kind":13,"localvar":"my","containerName":"_srcf_hash","name":"$orgref","line":2011,"definition":"my"},{"line":2013,"name":"%hash","localvar":"my","containerName":"_srcf_hash","kind":13,"definition":"my"},{"line":2013,"containerName":"_srcf_hash","kind":13,"name":"$srcf"},{"line":2014,"name":"$orgref","kind":13,"containerName":"_srcf_hash"},{"containerName":"_srcf_hash","kind":13,"name":"$stype","line":2015},{"line":2017,"name":"$cv_name","kind":13,"containerName":"_srcf_hash"},{"line":2020,"name":"%hash","containerName":"_srcf_hash","kind":13}],"kind":12,"range":{"end":{"line":2021,"character":9999},"start":{"line":2007,"character":0}},"line":2007}]}