{"version":5,"vars":[{"line":73,"kind":2,"containerName":"","name":"vars"},{"name":"@ISA","kind":13,"containerName":null,"line":79},{"line":79,"kind":2,"containerName":"strict::Bio::SeqIO::Bio::Seq","name":"SeqFactory"},{"children":[{"name":"$READ_AVAIL","containerName":"BEGIN","kind":13,"line":84},{"name":"@ISA","kind":13,"containerName":"BEGIN","line":86},{"line":87,"containerName":"BEGIN","kind":13,"name":"$READ_AVAIL"}],"containerName":"main::","name":"BEGIN","definition":"sub","line":81,"kind":12,"range":{"end":{"line":89,"character":9999},"start":{"line":81,"character":0}}},{"containerName":"SeqIO::staden::read","kind":12,"name":"Bio","line":83},{"definition":"sub","detail":"($self,@args)","children":[{"line":92,"name":"$self","localvar":"my","containerName":"_initialize","kind":13,"definition":"my"},{"containerName":"_initialize","kind":13,"name":"@args","line":92},{"line":93,"kind":13,"containerName":"_initialize","name":"$self"},{"line":93,"containerName":"_initialize","kind":13,"name":"@args"},{"line":94,"name":"$get_trace","containerName":"_initialize","localvar":"my","kind":13,"definition":"my"},{"name":"$self","containerName":"_initialize","kind":13,"line":94},{"name":"_rearrange","kind":12,"containerName":"_initialize","line":94},{"name":"@args","containerName":"_initialize","kind":13,"line":94},{"kind":13,"containerName":"_initialize","name":"$get_trace","line":95},{"line":95,"name":"$self","containerName":"_initialize","kind":13},{"line":95,"containerName":"_initialize","kind":12,"name":"get_trace_data"},{"line":96,"containerName":"_initialize","kind":13,"name":"$self"},{"line":96,"name":"sequence_factory","kind":12,"containerName":"_initialize"},{"kind":13,"containerName":"_initialize","name":"$self","line":97},{"kind":12,"containerName":"_initialize","name":"sequence_factory","line":97},{"line":97,"kind":12,"containerName":"_initialize","name":"new"},{"name":"$self","kind":13,"containerName":"_initialize","line":97},{"containerName":"_initialize","kind":12,"name":"verbose","line":97},{"line":99,"containerName":"_initialize","kind":13,"name":"$READ_AVAIL"},{"line":100,"containerName":"_initialize","kind":12,"name":"throw"}],"name":"_initialize","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"line":91,"range":{"end":{"character":9999,"line":104},"start":{"character":0,"line":91}},"kind":12},{"name":"SUPER","kind":12,"containerName":"_initialize","line":93},{"line":97,"containerName":"Seq::SeqFactory","kind":12,"name":"Bio"},{"line":100,"containerName":"Root::Root","kind":12,"name":"Bio"},{"line":116,"range":{"end":{"line":137,"character":9999},"start":{"line":116,"character":0}},"kind":12,"signature":{"label":"next_seq($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: abi.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::abi\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::abi - abi trace sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from abi trace\nfiles.  To optionally read the trace graph data (which can be used\nto draw chromatographs, for instance), set the optional\n'-read_graph_data' flag or the read_graph_data method to a value\nevaluating to TRUE.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Aaron Mackey\n\nEmail: amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::abi;\nuse vars qw(@ISA $READ_AVAIL);\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::Seq::SeqFactory;\n\npush @ISA, qw( Bio::SeqIO );\n\nsub BEGIN {\n    eval { require Bio::SeqIO::staden::read; };\n    if ($@) {\n\t$READ_AVAIL = 0;\n    } else {\n\tpush @ISA, \"Bio::SeqIO::staden::read\";\n\t$READ_AVAIL = 1;\n    }\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  my ($get_trace) = $self->_rearrange([qw(get_trace_data)],@args);\n  $get_trace && $self->get_trace_data(1);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), -type => 'Bio::Seq::Quality'));\n  }\n  unless ($READ_AVAIL) {\n      Bio::Root::Root->throw( -class => 'Bio::Root::SystemException',\n\t\t\t      -text  => \"Bio::SeqIO::staden::read is not available; make sure the bioperl-ext package has been installed successfully!\"\n\t\t\t    );\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq::Quality object\n Args    : NONE"},"children":[{"definition":"my","line":118,"localvar":"my","kind":13,"containerName":"next_seq","name":"$self"},{"line":120,"name":"$seq","localvar":"my","containerName":"next_seq","kind":13,"definition":"my"},{"line":120,"containerName":"next_seq","kind":13,"name":"$id"},{"line":120,"name":"$desc","containerName":"next_seq","kind":13},{"name":"$qual","kind":13,"containerName":"next_seq","line":120},{"line":120,"containerName":"next_seq","kind":13,"name":"$self"},{"containerName":"next_seq","kind":12,"name":"read_trace","line":120},{"line":120,"containerName":"next_seq","kind":13,"name":"$self"},{"name":"_fh","kind":12,"containerName":"next_seq","line":120},{"line":123,"containerName":"next_seq","localvar":"my","kind":13,"name":"$base_locs","definition":"my"},{"line":123,"name":"$a_trace","kind":13,"containerName":"next_seq"},{"line":123,"kind":13,"containerName":"next_seq","name":"$c_trace"},{"kind":13,"containerName":"next_seq","name":"$g_trace","line":123},{"kind":13,"containerName":"next_seq","name":"$t_trace","line":123},{"name":"$points","kind":13,"containerName":"next_seq","line":123},{"containerName":"next_seq","kind":13,"name":"$max_height","line":123},{"line":124,"kind":13,"containerName":"next_seq","name":"$self"},{"name":"get_trace_data","containerName":"next_seq","kind":12,"line":124},{"line":125,"name":"$base_locs","containerName":"next_seq","kind":13},{"line":125,"containerName":"next_seq","kind":13,"name":"$a_trace"},{"line":125,"name":"$c_trace","kind":13,"containerName":"next_seq"},{"containerName":"next_seq","kind":13,"name":"$g_trace","line":125},{"line":125,"containerName":"next_seq","kind":13,"name":"$t_trace"},{"line":125,"containerName":"next_seq","kind":13,"name":"$points"},{"line":125,"kind":13,"containerName":"next_seq","name":"$max_height"},{"line":125,"name":"$self","kind":13,"containerName":"next_seq"},{"name":"read_trace_with_graph","containerName":"next_seq","kind":12,"line":125},{"kind":13,"containerName":"next_seq","name":"$self","line":125},{"containerName":"next_seq","kind":12,"name":"_fh","line":125},{"line":127,"containerName":"next_seq","kind":13,"name":"$base_locs"},{"line":131,"name":"$seq","containerName":"next_seq","kind":13},{"line":131,"name":"$self","containerName":"next_seq","kind":13},{"line":131,"name":"sequence_factory","containerName":"next_seq","kind":12},{"name":"create","containerName":"next_seq","kind":12,"line":131},{"kind":13,"containerName":"next_seq","name":"$seq","line":131},{"line":132,"name":"$id","containerName":"next_seq","kind":13},{"line":133,"kind":13,"containerName":"next_seq","name":"$id"},{"line":134,"containerName":"next_seq","kind":13,"name":"$desc"},{"line":136,"name":"$qual","kind":13,"containerName":"next_seq"},{"name":"$base_locs","containerName":"next_seq","kind":13,"line":137}],"name":"next_seq","containerName":"main::","definition":"sub","detail":"($self)"},{"name":"a_trace","kind":12,"line":138},{"name":"$a_trace","kind":13,"containerName":null,"line":138},{"line":139,"name":"c_trace","kind":12},{"name":"$c_trace","containerName":null,"kind":13,"line":139},{"kind":12,"name":"g_trace","line":140},{"line":140,"kind":13,"containerName":null,"name":"$g_trace"},{"line":141,"name":"t_trace","kind":12},{"line":141,"containerName":null,"kind":13,"name":"$t_trace"},{"kind":12,"name":"max_height","line":142},{"containerName":null,"kind":13,"name":"$max_height","line":142},{"line":143,"kind":12,"name":"num_points"},{"kind":13,"containerName":null,"name":"$points","line":143},{"line":145,"containerName":null,"kind":13,"name":"$seq"},{"detail":"($self,@seq)","definition":"sub","containerName":"main::","name":"write_seq","children":[{"definition":"my","line":160,"name":"$self","localvar":"my","containerName":"write_seq","kind":13},{"line":160,"containerName":"write_seq","kind":13,"name":"@seq"},{"definition":"my","localvar":"my","containerName":"write_seq","kind":13,"name":"$fh","line":162},{"line":162,"name":"$self","containerName":"write_seq","kind":13},{"line":162,"name":"_fh","containerName":"write_seq","kind":12},{"definition":"my","localvar":"my","kind":13,"containerName":"write_seq","name":"$seq","line":163},{"name":"@seq","containerName":"write_seq","kind":13,"line":163},{"line":164,"containerName":"write_seq","kind":13,"name":"$self"},{"line":164,"name":"write_trace","containerName":"write_seq","kind":12},{"line":164,"containerName":"write_seq","kind":13,"name":"$fh"},{"name":"$seq","containerName":"write_seq","kind":13,"line":164},{"kind":13,"containerName":"write_seq","name":"$self","line":167},{"containerName":"write_seq","kind":12,"name":"flush","line":167},{"containerName":"write_seq","kind":13,"name":"$self","line":167},{"line":167,"name":"_flush_on_write","containerName":"write_seq","kind":12},{"name":"$self","kind":13,"containerName":"write_seq","line":167},{"containerName":"write_seq","kind":12,"name":"_fh","line":167}],"signature":{"label":"write_seq($self,@seq)","documentation":"1;\n# $Id: abi.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::abi\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::abi - abi trace sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from abi trace\nfiles.  To optionally read the trace graph data (which can be used\nto draw chromatographs, for instance), set the optional\n'-read_graph_data' flag or the read_graph_data method to a value\nevaluating to TRUE.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Aaron Mackey\n\nEmail: amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::abi;\nuse vars qw(@ISA $READ_AVAIL);\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::Seq::SeqFactory;\n\npush @ISA, qw( Bio::SeqIO );\n\nsub BEGIN {\n    eval { require Bio::SeqIO::staden::read; };\n    if ($@) {\n\t$READ_AVAIL = 0;\n    } else {\n\tpush @ISA, \"Bio::SeqIO::staden::read\";\n\t$READ_AVAIL = 1;\n    }\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  my ($get_trace) = $self->_rearrange([qw(get_trace_data)],@args);\n  $get_trace && $self->get_trace_data(1);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), -type => 'Bio::Seq::Quality'));\n  }\n  unless ($READ_AVAIL) {\n      Bio::Root::Root->throw( -class => 'Bio::Root::SystemException',\n\t\t\t      -text  => \"Bio::SeqIO::staden::read is not available; make sure the bioperl-ext package has been installed successfully!\"\n\t\t\t    );\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq::Quality object\n Args    : NONE\n\n\nsub next_seq {\n\n    my ($self) = @_;\n\n    my ($seq, $id, $desc, $qual) = $self->read_trace($self->_fh, 'abi');\n\n    # create the seq object\n\tmy ($base_locs, $a_trace, $c_trace, $g_trace, $t_trace, $points, $max_height);\n\tif ($self->get_trace_data) {\n\t\t($base_locs, $a_trace, $c_trace, $g_trace, $t_trace, $points, $max_height) = $self->read_trace_with_graph($self->_fh, 'abi');\n\t} else {\n\t\t$base_locs = [];\n\t}\n\n    # create the seq object\n    $seq = $self->sequence_factory->create(-seq        => $seq,\n\t\t\t\t\t   -id         => $id,\n\t\t\t\t\t   -primary_id => $id,\n\t\t\t\t\t   -desc       => $desc,\n\t\t\t\t\t   -alphabet   => 'DNA',\n\t\t\t\t\t   -qual       => $qual,\n\t\t\t\t\t   -trace      => join (\" \", @{$base_locs}),\n\t\t\t\t\t   -trace_data => { a_trace => $a_trace,\n\t\t\t\t\t\t\t\t\t   c_trace => $c_trace,\n\t\t\t\t\t\t\t\t\t   g_trace => $g_trace,\n\t\t\t\t\t\t\t\t\t   t_trace => $t_trace, \n\t\t\t\t\t   \t\t    max_height => $max_height,\n\t\t\t\t\t\t\t\tnum_points => $points }\n\t\t\t\t\t   );\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Seq object","parameters":[{"label":"$self"},{"label":"@seq"}]},"kind":12,"range":{"start":{"line":159,"character":0},"end":{"line":169,"character":9999}},"line":159},{"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: abi.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::abi\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::abi - abi trace sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from abi trace\nfiles.  To optionally read the trace graph data (which can be used\nto draw chromatographs, for instance), set the optional\n'-read_graph_data' flag or the read_graph_data method to a value\nevaluating to TRUE.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Aaron Mackey\n\nEmail: amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::abi;\nuse vars qw(@ISA $READ_AVAIL);\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::Seq::SeqFactory;\n\npush @ISA, qw( Bio::SeqIO );\n\nsub BEGIN {\n    eval { require Bio::SeqIO::staden::read; };\n    if ($@) {\n\t$READ_AVAIL = 0;\n    } else {\n\tpush @ISA, \"Bio::SeqIO::staden::read\";\n\t$READ_AVAIL = 1;\n    }\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  my ($get_trace) = $self->_rearrange([qw(get_trace_data)],@args);\n  $get_trace && $self->get_trace_data(1);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), -type => 'Bio::Seq::Quality'));\n  }\n  unless ($READ_AVAIL) {\n      Bio::Root::Root->throw( -class => 'Bio::Root::SystemException',\n\t\t\t      -text  => \"Bio::SeqIO::staden::read is not available; make sure the bioperl-ext package has been installed successfully!\"\n\t\t\t    );\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq::Quality object\n Args    : NONE\n\n\nsub next_seq {\n\n    my ($self) = @_;\n\n    my ($seq, $id, $desc, $qual) = $self->read_trace($self->_fh, 'abi');\n\n    # create the seq object\n\tmy ($base_locs, $a_trace, $c_trace, $g_trace, $t_trace, $points, $max_height);\n\tif ($self->get_trace_data) {\n\t\t($base_locs, $a_trace, $c_trace, $g_trace, $t_trace, $points, $max_height) = $self->read_trace_with_graph($self->_fh, 'abi');\n\t} else {\n\t\t$base_locs = [];\n\t}\n\n    # create the seq object\n    $seq = $self->sequence_factory->create(-seq        => $seq,\n\t\t\t\t\t   -id         => $id,\n\t\t\t\t\t   -primary_id => $id,\n\t\t\t\t\t   -desc       => $desc,\n\t\t\t\t\t   -alphabet   => 'DNA',\n\t\t\t\t\t   -qual       => $qual,\n\t\t\t\t\t   -trace      => join (\" \", @{$base_locs}),\n\t\t\t\t\t   -trace_data => { a_trace => $a_trace,\n\t\t\t\t\t\t\t\t\t   c_trace => $c_trace,\n\t\t\t\t\t\t\t\t\t   g_trace => $g_trace,\n\t\t\t\t\t\t\t\t\t   t_trace => $t_trace, \n\t\t\t\t\t   \t\t    max_height => $max_height,\n\t\t\t\t\t\t\t\tnum_points => $points }\n\t\t\t\t\t   );\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Seq object\n\n\n\nsub write_seq {\n    my ($self,@seq) = @_;\n\n    my $fh = $self->_fh;\n    foreach my $seq (@seq) {\n\t$self->write_trace($fh, $seq, 'abi');\n    }\n\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 get_trace_data\n\n Title   : get_trace_data\n Usage   : $stream->get_trace_data(1)\n Function: set boolean flag to retrieve the trace data (possibly for\n           output)\n Returns : bool value, TRUE = retrieve trace data (default FALSE)\n Args    : bool value","label":"get_trace_data($self,$val)"},"kind":12,"range":{"start":{"character":0,"line":182},"end":{"line":186,"character":9999}},"line":182,"detail":"($self,$val)","definition":"sub","containerName":"main::","name":"get_trace_data","children":[{"line":183,"name":"$self","kind":13,"localvar":"my","containerName":"get_trace_data","definition":"my"},{"line":183,"kind":13,"containerName":"get_trace_data","name":"$val"},{"line":184,"containerName":"get_trace_data","kind":13,"name":"$self"},{"containerName":"get_trace_data","kind":13,"name":"$val","line":184},{"kind":13,"containerName":"get_trace_data","name":"$self","line":185}]},{"line":184,"name":"_get_trace_data","kind":12},{"line":185,"kind":12,"name":"_get_trace_data"}]}