{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":93},{"name":"new","containerName":"main::","children":[{"line":111,"name":"$class","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"line":111,"name":"@args","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"@args","line":113},{"definition":"my","name":"$fact","kind":13,"localvar":"my","containerName":"new","line":115},{"name":"new","kind":12,"containerName":"new","line":115},{"name":"@args","kind":13,"containerName":"new","line":118},{"kind":13,"containerName":"new","name":"$fact","line":118},{"definition":"my","line":120,"localvar":"my","kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":13,"name":"$class","line":120},{"line":120,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","name":"$primary","localvar":"my","kind":13,"containerName":"new","line":122},{"line":122,"kind":13,"containerName":"new","name":"$hit"},{"line":122,"containerName":"new","kind":13,"name":"$query"},{"line":122,"containerName":"new","kind":13,"name":"$fea1"},{"name":"$source","containerName":"new","kind":13,"line":122},{"name":"$sbjct","kind":13,"containerName":"new","line":122},{"line":123,"name":"$self","containerName":"new","kind":13},{"line":123,"name":"_rearrange","containerName":"new","kind":12},{"line":129,"containerName":"new","kind":13,"name":"@args"},{"line":131,"kind":13,"containerName":"new","name":"$sbjct"},{"line":134,"kind":13,"containerName":"new","name":"$hit"},{"kind":13,"containerName":"new","name":"$hit","line":134},{"name":"$sbjct","kind":13,"containerName":"new","line":134},{"line":136,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"warn","line":136},{"line":141,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"query","line":141},{"line":141,"name":"$query","kind":13,"containerName":"new"},{"name":"$query","kind":13,"containerName":"new","line":141},{"containerName":"new","kind":13,"name":"$fea1","line":141},{"line":142,"containerName":"new","kind":13,"name":"$hit"},{"name":"$self","containerName":"new","kind":13,"line":142},{"line":142,"kind":12,"containerName":"new","name":"hit"},{"name":"$hit","kind":13,"containerName":"new","line":142},{"line":145,"name":"$primary","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":145},{"kind":12,"containerName":"new","name":"primary_tag","line":145},{"name":"$primary","containerName":"new","kind":13,"line":146},{"containerName":"new","kind":13,"name":"$primary","line":146},{"line":147,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"primary_tag","line":147},{"containerName":"new","kind":13,"name":"$primary","line":147},{"name":"$source","kind":13,"containerName":"new","line":150},{"line":150,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"source_tag","line":150},{"line":150,"name":"$source","containerName":"new","kind":13},{"line":152,"containerName":"new","kind":13,"name":"$self"}],"detail":"($class,@args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":153},"start":{"character":0,"line":110}},"line":110,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: SimilarityPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SimilarityPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SimilarityPair - Sequence feature based on the similarity\n                  of two sequences.\n\n=head1 SYNOPSIS\n\n  $sim_pair = Bio::SeqFeature::SimilarityPair->from_searchResult($blastHit);\n\n  $sim = $sim_pair->query(); # a Bio::SeqFeature::Similarity object - the query\n  $sim = $sim_pair->hit();   # dto - the hit.\n\n  # some properties for the similarity pair\n  $expect = $sim_pair->significance();\n  $score = $sim_pair->score();\n  $bitscore = $sim_pair->bits();\n\n  # this will not write the description for the sequence (only its name)\n  print $sim_pair->query()->gff_string(), \"\\n\";\n\n=head1 DESCRIPTION\n\nLightweight similarity search result as a pair of Similarity\nfeatures. This class inherits off Bio::SeqFeature::FeaturePair and\ntherefore implements Bio::SeqFeatureI, whereas the two features of the\npair are descendants of Bio::SeqFeature::Generic, with better support\nfor representing similarity search results in a cleaner way.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net or hilmar.lapp@pharma.novartis.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::SimilarityPair;\nuse strict;\n\nuse Bio::SeqFeature::Similarity;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::FeaturePair);\n\n=head2 new\n\n Title   : new\n Usage   : my $similarityPair = Bio::SeqFeature::SimilarityPair->new\n                                 (-hit   => $hit,\n                                  -query => $query,\n                                  -source => 'blastp');\n Function: Initializes a new SimilarityPair object\n Returns : Bio::SeqFeature::SimilarityPair\n Args    : -query => The query in a Feature pair \n           -hit   => (formerly '-subject') the subject/hit in a Feature pair","parameters":[{"label":"$class"},{"label":"@args"}]}},{"line":115,"containerName":"Factory::ObjectFactory","kind":12,"name":"Bio"},{"line":120,"name":"SUPER","kind":12,"containerName":"new"},{"range":{"start":{"line":172,"character":0},"end":{"character":9999,"line":174}},"kind":12,"line":172,"containerName":"main::","name":"query","children":[{"line":173,"name":"feature1","containerName":"query","kind":12}],"definition":"sub"},{"line":191,"range":{"start":{"line":191,"character":0},"end":{"line":195,"character":9999}},"kind":12,"children":[{"definition":"my","line":192,"name":"$self","kind":13,"localvar":"my","containerName":"subject"},{"line":194,"kind":13,"containerName":"subject","name":"$self"},{"line":194,"containerName":"subject","kind":12,"name":"hit"}],"name":"subject","containerName":"main::","definition":"sub"},{"line":209,"kind":12,"range":{"end":{"character":9999,"line":211},"start":{"character":0,"line":209}},"children":[{"line":210,"containerName":"hit","kind":12,"name":"feature2"}],"name":"hit","containerName":"main::","definition":"sub"},{"containerName":"main::","name":"source_tag","children":[{"containerName":"source_tag","localvar":"my","kind":13,"name":"$self","line":226,"definition":"my"},{"kind":13,"containerName":"source_tag","name":"@args","line":226},{"line":228,"containerName":"source_tag","kind":13,"name":"@args"},{"containerName":"source_tag","kind":13,"name":"$self","line":229},{"line":229,"kind":12,"containerName":"source_tag","name":"hit"},{"line":229,"name":"source_tag","containerName":"source_tag","kind":12},{"line":229,"kind":13,"containerName":"source_tag","name":"@args"},{"name":"$self","containerName":"source_tag","kind":13,"line":231},{"containerName":"source_tag","kind":12,"name":"query","line":231},{"line":231,"containerName":"source_tag","kind":12,"name":"source_tag"},{"name":"@args","containerName":"source_tag","kind":13,"line":231}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":232},"start":{"line":225,"character":0}},"line":225,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SimilarityPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SimilarityPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SimilarityPair - Sequence feature based on the similarity\n                  of two sequences.\n\n=head1 SYNOPSIS\n\n  $sim_pair = Bio::SeqFeature::SimilarityPair->from_searchResult($blastHit);\n\n  $sim = $sim_pair->query(); # a Bio::SeqFeature::Similarity object - the query\n  $sim = $sim_pair->hit();   # dto - the hit.\n\n  # some properties for the similarity pair\n  $expect = $sim_pair->significance();\n  $score = $sim_pair->score();\n  $bitscore = $sim_pair->bits();\n\n  # this will not write the description for the sequence (only its name)\n  print $sim_pair->query()->gff_string(), \"\\n\";\n\n=head1 DESCRIPTION\n\nLightweight similarity search result as a pair of Similarity\nfeatures. This class inherits off Bio::SeqFeature::FeaturePair and\ntherefore implements Bio::SeqFeatureI, whereas the two features of the\npair are descendants of Bio::SeqFeature::Generic, with better support\nfor representing similarity search results in a cleaner way.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net or hilmar.lapp@pharma.novartis.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::SimilarityPair;\nuse strict;\n\nuse Bio::SeqFeature::Similarity;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::FeaturePair);\n\n=head2 new\n\n Title   : new\n Usage   : my $similarityPair = Bio::SeqFeature::SimilarityPair->new\n                                 (-hit   => $hit,\n                                  -query => $query,\n                                  -source => 'blastp');\n Function: Initializes a new SimilarityPair object\n Returns : Bio::SeqFeature::SimilarityPair\n Args    : -query => The query in a Feature pair \n           -hit   => (formerly '-subject') the subject/hit in a Feature pair\n\n\n\nsub new {\n    my($class,@args) = @_;\n\n    if(! grep { lc($_) eq \"-feature_factory\"; } @args) {\n\t# if no overriding factory is provided, provide our preferred one\n\tmy $fact = Bio::Factory::ObjectFactory->new(\n                                    -type => \"Bio::SeqFeature::Similarity\",\n\t\t\t\t    -interface => \"Bio::SeqFeatureI\");\n\tpush(@args, '-feature_factory', $fact);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $hit, $query, $fea1, $source,$sbjct) =\n        $self->_rearrange([qw(PRIMARY\n                              HIT\n                              QUERY\n                              FEATURE1\n                              SOURCE\n                              SUBJECT\n                              )],@args);\n    \n    if( $sbjct ) { \n        # undeprecated by Jason before 1.1 release \n        # $self->deprecated(\"use of -subject deprecated: SimilarityPair now uses 'hit'\");\n        if(! $hit) { $hit = $sbjct } \n        else { \n            $self->warn(\"-hit and -subject were specified, using -hit and ignoring -subject\");\n        }\n    }\n\n    # set the query and subject feature if provided\n    $self->query( $query) if $query && ! $fea1;\n    $hit && $self->hit($hit);\n\n    # the following refer to feature1, which is guaranteed to exist\n    if( defined $primary || ! defined $self->primary_tag) { \n        $primary = 'similarity' unless defined $primary;\n        $self->primary_tag($primary);\n    } \n\n    $source && $self->source_tag($source);\n\n    return $self;\n}\n\n#\n# Everything else is just inherited from SeqFeature::FeaturePair.\n#\n\n=head2 query\n\n Title   : query\n Usage   : $query_feature = $obj->query();\n           $obj->query($query_feature);\n Function: The query object for this similarity pair\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\nSee L<Bio::SeqFeature::Similarity>, L<Bio::SeqFeature::FeaturePair>\n\n\nsub query {\n    return shift->feature1(@_);\n}\n\n\n\n\n=head2 subject\n\n Title   : subject\n Usage   : $sbjct_feature = $obj->subject();\n           $obj->subject($sbjct_feature);\n Function: Get/Set Subject for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n Notes   : Deprecated.  Use the method 'hit' instead\n\n\nsub subject { \n    my $self = shift;\n#    $self->deprecated(\"Method subject deprecated: use hit() instead\");\n    $self->hit(@_); \n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $sbjct_feature = $obj->hit();\n           $obj->hit($sbjct_feature);\n Function: Get/Set Hit for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\n\n\nsub hit {\n    return shift->feature2(@_);\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $source = $obj->source_tag(); # i.e., program\n           $obj->source_tag($evalue);\n Function: Gets the source tag (program name typically) for a feature \n Returns : string\n Args    : [optional] string","label":"source_tag($self,@args)"}},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","containerName":"significance","localvar":"my","kind":13,"name":"$self","line":247},{"name":"@args","kind":13,"containerName":"significance","line":247},{"line":249,"kind":13,"containerName":"significance","name":"@args"},{"line":250,"name":"$self","containerName":"significance","kind":13},{"line":250,"name":"hit","kind":12,"containerName":"significance"},{"kind":12,"containerName":"significance","name":"significance","line":250},{"containerName":"significance","kind":13,"name":"@args","line":250},{"kind":13,"containerName":"significance","name":"$self","line":252},{"kind":12,"containerName":"significance","name":"query","line":252},{"line":252,"kind":12,"containerName":"significance","name":"significance"},{"kind":13,"containerName":"significance","name":"@args","line":252}],"containerName":"main::","name":"significance","signature":{"documentation":"1;\n# $Id: SimilarityPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SimilarityPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SimilarityPair - Sequence feature based on the similarity\n                  of two sequences.\n\n=head1 SYNOPSIS\n\n  $sim_pair = Bio::SeqFeature::SimilarityPair->from_searchResult($blastHit);\n\n  $sim = $sim_pair->query(); # a Bio::SeqFeature::Similarity object - the query\n  $sim = $sim_pair->hit();   # dto - the hit.\n\n  # some properties for the similarity pair\n  $expect = $sim_pair->significance();\n  $score = $sim_pair->score();\n  $bitscore = $sim_pair->bits();\n\n  # this will not write the description for the sequence (only its name)\n  print $sim_pair->query()->gff_string(), \"\\n\";\n\n=head1 DESCRIPTION\n\nLightweight similarity search result as a pair of Similarity\nfeatures. This class inherits off Bio::SeqFeature::FeaturePair and\ntherefore implements Bio::SeqFeatureI, whereas the two features of the\npair are descendants of Bio::SeqFeature::Generic, with better support\nfor representing similarity search results in a cleaner way.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net or hilmar.lapp@pharma.novartis.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::SimilarityPair;\nuse strict;\n\nuse Bio::SeqFeature::Similarity;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::FeaturePair);\n\n=head2 new\n\n Title   : new\n Usage   : my $similarityPair = Bio::SeqFeature::SimilarityPair->new\n                                 (-hit   => $hit,\n                                  -query => $query,\n                                  -source => 'blastp');\n Function: Initializes a new SimilarityPair object\n Returns : Bio::SeqFeature::SimilarityPair\n Args    : -query => The query in a Feature pair \n           -hit   => (formerly '-subject') the subject/hit in a Feature pair\n\n\n\nsub new {\n    my($class,@args) = @_;\n\n    if(! grep { lc($_) eq \"-feature_factory\"; } @args) {\n\t# if no overriding factory is provided, provide our preferred one\n\tmy $fact = Bio::Factory::ObjectFactory->new(\n                                    -type => \"Bio::SeqFeature::Similarity\",\n\t\t\t\t    -interface => \"Bio::SeqFeatureI\");\n\tpush(@args, '-feature_factory', $fact);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $hit, $query, $fea1, $source,$sbjct) =\n        $self->_rearrange([qw(PRIMARY\n                              HIT\n                              QUERY\n                              FEATURE1\n                              SOURCE\n                              SUBJECT\n                              )],@args);\n    \n    if( $sbjct ) { \n        # undeprecated by Jason before 1.1 release \n        # $self->deprecated(\"use of -subject deprecated: SimilarityPair now uses 'hit'\");\n        if(! $hit) { $hit = $sbjct } \n        else { \n            $self->warn(\"-hit and -subject were specified, using -hit and ignoring -subject\");\n        }\n    }\n\n    # set the query and subject feature if provided\n    $self->query( $query) if $query && ! $fea1;\n    $hit && $self->hit($hit);\n\n    # the following refer to feature1, which is guaranteed to exist\n    if( defined $primary || ! defined $self->primary_tag) { \n        $primary = 'similarity' unless defined $primary;\n        $self->primary_tag($primary);\n    } \n\n    $source && $self->source_tag($source);\n\n    return $self;\n}\n\n#\n# Everything else is just inherited from SeqFeature::FeaturePair.\n#\n\n=head2 query\n\n Title   : query\n Usage   : $query_feature = $obj->query();\n           $obj->query($query_feature);\n Function: The query object for this similarity pair\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\nSee L<Bio::SeqFeature::Similarity>, L<Bio::SeqFeature::FeaturePair>\n\n\nsub query {\n    return shift->feature1(@_);\n}\n\n\n\n\n=head2 subject\n\n Title   : subject\n Usage   : $sbjct_feature = $obj->subject();\n           $obj->subject($sbjct_feature);\n Function: Get/Set Subject for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n Notes   : Deprecated.  Use the method 'hit' instead\n\n\nsub subject { \n    my $self = shift;\n#    $self->deprecated(\"Method subject deprecated: use hit() instead\");\n    $self->hit(@_); \n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $sbjct_feature = $obj->hit();\n           $obj->hit($sbjct_feature);\n Function: Get/Set Hit for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\n\n\nsub hit {\n    return shift->feature2(@_);\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $source = $obj->source_tag(); # i.e., program\n           $obj->source_tag($evalue);\n Function: Gets the source tag (program name typically) for a feature \n Returns : string\n Args    : [optional] string\n\n\n\nsub source_tag {\n    my ($self, @args) = @_;\n\n    if(@args) {\n        $self->hit()->source_tag(@args);\n    }\n    return $self->query()->source_tag(@args);\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: \n Returns : \n Args    : ","parameters":[{"label":"$self"},{"label":"@args"}],"label":"significance($self,@args)"},"line":246,"kind":12,"range":{"end":{"character":9999,"line":253},"start":{"character":0,"line":246}}},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SimilarityPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SimilarityPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SimilarityPair - Sequence feature based on the similarity\n                  of two sequences.\n\n=head1 SYNOPSIS\n\n  $sim_pair = Bio::SeqFeature::SimilarityPair->from_searchResult($blastHit);\n\n  $sim = $sim_pair->query(); # a Bio::SeqFeature::Similarity object - the query\n  $sim = $sim_pair->hit();   # dto - the hit.\n\n  # some properties for the similarity pair\n  $expect = $sim_pair->significance();\n  $score = $sim_pair->score();\n  $bitscore = $sim_pair->bits();\n\n  # this will not write the description for the sequence (only its name)\n  print $sim_pair->query()->gff_string(), \"\\n\";\n\n=head1 DESCRIPTION\n\nLightweight similarity search result as a pair of Similarity\nfeatures. This class inherits off Bio::SeqFeature::FeaturePair and\ntherefore implements Bio::SeqFeatureI, whereas the two features of the\npair are descendants of Bio::SeqFeature::Generic, with better support\nfor representing similarity search results in a cleaner way.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net or hilmar.lapp@pharma.novartis.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::SimilarityPair;\nuse strict;\n\nuse Bio::SeqFeature::Similarity;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::FeaturePair);\n\n=head2 new\n\n Title   : new\n Usage   : my $similarityPair = Bio::SeqFeature::SimilarityPair->new\n                                 (-hit   => $hit,\n                                  -query => $query,\n                                  -source => 'blastp');\n Function: Initializes a new SimilarityPair object\n Returns : Bio::SeqFeature::SimilarityPair\n Args    : -query => The query in a Feature pair \n           -hit   => (formerly '-subject') the subject/hit in a Feature pair\n\n\n\nsub new {\n    my($class,@args) = @_;\n\n    if(! grep { lc($_) eq \"-feature_factory\"; } @args) {\n\t# if no overriding factory is provided, provide our preferred one\n\tmy $fact = Bio::Factory::ObjectFactory->new(\n                                    -type => \"Bio::SeqFeature::Similarity\",\n\t\t\t\t    -interface => \"Bio::SeqFeatureI\");\n\tpush(@args, '-feature_factory', $fact);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $hit, $query, $fea1, $source,$sbjct) =\n        $self->_rearrange([qw(PRIMARY\n                              HIT\n                              QUERY\n                              FEATURE1\n                              SOURCE\n                              SUBJECT\n                              )],@args);\n    \n    if( $sbjct ) { \n        # undeprecated by Jason before 1.1 release \n        # $self->deprecated(\"use of -subject deprecated: SimilarityPair now uses 'hit'\");\n        if(! $hit) { $hit = $sbjct } \n        else { \n            $self->warn(\"-hit and -subject were specified, using -hit and ignoring -subject\");\n        }\n    }\n\n    # set the query and subject feature if provided\n    $self->query( $query) if $query && ! $fea1;\n    $hit && $self->hit($hit);\n\n    # the following refer to feature1, which is guaranteed to exist\n    if( defined $primary || ! defined $self->primary_tag) { \n        $primary = 'similarity' unless defined $primary;\n        $self->primary_tag($primary);\n    } \n\n    $source && $self->source_tag($source);\n\n    return $self;\n}\n\n#\n# Everything else is just inherited from SeqFeature::FeaturePair.\n#\n\n=head2 query\n\n Title   : query\n Usage   : $query_feature = $obj->query();\n           $obj->query($query_feature);\n Function: The query object for this similarity pair\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\nSee L<Bio::SeqFeature::Similarity>, L<Bio::SeqFeature::FeaturePair>\n\n\nsub query {\n    return shift->feature1(@_);\n}\n\n\n\n\n=head2 subject\n\n Title   : subject\n Usage   : $sbjct_feature = $obj->subject();\n           $obj->subject($sbjct_feature);\n Function: Get/Set Subject for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n Notes   : Deprecated.  Use the method 'hit' instead\n\n\nsub subject { \n    my $self = shift;\n#    $self->deprecated(\"Method subject deprecated: use hit() instead\");\n    $self->hit(@_); \n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $sbjct_feature = $obj->hit();\n           $obj->hit($sbjct_feature);\n Function: Get/Set Hit for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\n\n\nsub hit {\n    return shift->feature2(@_);\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $source = $obj->source_tag(); # i.e., program\n           $obj->source_tag($evalue);\n Function: Gets the source tag (program name typically) for a feature \n Returns : string\n Args    : [optional] string\n\n\n\nsub source_tag {\n    my ($self, @args) = @_;\n\n    if(@args) {\n        $self->hit()->source_tag(@args);\n    }\n    return $self->query()->source_tag(@args);\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: \n Returns : \n Args    : \n\n\n\nsub significance {\n    my ($self, @args) = @_;\n\n    if(@args) {\n        $self->hit()->significance(@args);\n    }\n    return $self->query()->significance(@args);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $obj->score();\n           $obj->score($value);\n Function: \n Returns : \n Args    : ","label":"score($self,@args)"},"kind":12,"range":{"end":{"character":9999,"line":277},"start":{"line":267,"character":0}},"line":267,"detail":"($self,@args)","definition":"sub","name":"score","containerName":"main::","children":[{"line":268,"containerName":"score","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":268,"containerName":"score","kind":13,"name":"@args"},{"name":"@args","kind":13,"containerName":"score","line":270},{"line":271,"kind":13,"containerName":"score","name":"$self"},{"name":"hit","kind":12,"containerName":"score","line":271},{"line":271,"name":"score","kind":12,"containerName":"score"},{"name":"@args","containerName":"score","kind":13,"line":271},{"line":276,"name":"$self","containerName":"score","kind":13},{"line":276,"containerName":"score","kind":12,"name":"query"},{"name":"score","containerName":"score","kind":12,"line":276},{"containerName":"score","kind":13,"name":"@args","line":276}]},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"bits","children":[{"containerName":"bits","localvar":"my","kind":13,"name":"$self","line":292,"definition":"my"},{"line":292,"name":"@args","kind":13,"containerName":"bits"},{"kind":13,"containerName":"bits","name":"@args","line":294},{"containerName":"bits","kind":13,"name":"$self","line":295},{"name":"hit","kind":12,"containerName":"bits","line":295},{"containerName":"bits","kind":12,"name":"bits","line":295},{"line":295,"name":"@args","kind":13,"containerName":"bits"},{"containerName":"bits","kind":13,"name":"$self","line":297},{"line":297,"name":"query","containerName":"bits","kind":12},{"name":"bits","containerName":"bits","kind":12,"line":297},{"line":297,"kind":13,"containerName":"bits","name":"@args"}],"signature":{"documentation":"1;\n# $Id: SimilarityPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SimilarityPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SimilarityPair - Sequence feature based on the similarity\n                  of two sequences.\n\n=head1 SYNOPSIS\n\n  $sim_pair = Bio::SeqFeature::SimilarityPair->from_searchResult($blastHit);\n\n  $sim = $sim_pair->query(); # a Bio::SeqFeature::Similarity object - the query\n  $sim = $sim_pair->hit();   # dto - the hit.\n\n  # some properties for the similarity pair\n  $expect = $sim_pair->significance();\n  $score = $sim_pair->score();\n  $bitscore = $sim_pair->bits();\n\n  # this will not write the description for the sequence (only its name)\n  print $sim_pair->query()->gff_string(), \"\\n\";\n\n=head1 DESCRIPTION\n\nLightweight similarity search result as a pair of Similarity\nfeatures. This class inherits off Bio::SeqFeature::FeaturePair and\ntherefore implements Bio::SeqFeatureI, whereas the two features of the\npair are descendants of Bio::SeqFeature::Generic, with better support\nfor representing similarity search results in a cleaner way.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net or hilmar.lapp@pharma.novartis.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::SimilarityPair;\nuse strict;\n\nuse Bio::SeqFeature::Similarity;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::FeaturePair);\n\n=head2 new\n\n Title   : new\n Usage   : my $similarityPair = Bio::SeqFeature::SimilarityPair->new\n                                 (-hit   => $hit,\n                                  -query => $query,\n                                  -source => 'blastp');\n Function: Initializes a new SimilarityPair object\n Returns : Bio::SeqFeature::SimilarityPair\n Args    : -query => The query in a Feature pair \n           -hit   => (formerly '-subject') the subject/hit in a Feature pair\n\n\n\nsub new {\n    my($class,@args) = @_;\n\n    if(! grep { lc($_) eq \"-feature_factory\"; } @args) {\n\t# if no overriding factory is provided, provide our preferred one\n\tmy $fact = Bio::Factory::ObjectFactory->new(\n                                    -type => \"Bio::SeqFeature::Similarity\",\n\t\t\t\t    -interface => \"Bio::SeqFeatureI\");\n\tpush(@args, '-feature_factory', $fact);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $hit, $query, $fea1, $source,$sbjct) =\n        $self->_rearrange([qw(PRIMARY\n                              HIT\n                              QUERY\n                              FEATURE1\n                              SOURCE\n                              SUBJECT\n                              )],@args);\n    \n    if( $sbjct ) { \n        # undeprecated by Jason before 1.1 release \n        # $self->deprecated(\"use of -subject deprecated: SimilarityPair now uses 'hit'\");\n        if(! $hit) { $hit = $sbjct } \n        else { \n            $self->warn(\"-hit and -subject were specified, using -hit and ignoring -subject\");\n        }\n    }\n\n    # set the query and subject feature if provided\n    $self->query( $query) if $query && ! $fea1;\n    $hit && $self->hit($hit);\n\n    # the following refer to feature1, which is guaranteed to exist\n    if( defined $primary || ! defined $self->primary_tag) { \n        $primary = 'similarity' unless defined $primary;\n        $self->primary_tag($primary);\n    } \n\n    $source && $self->source_tag($source);\n\n    return $self;\n}\n\n#\n# Everything else is just inherited from SeqFeature::FeaturePair.\n#\n\n=head2 query\n\n Title   : query\n Usage   : $query_feature = $obj->query();\n           $obj->query($query_feature);\n Function: The query object for this similarity pair\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\nSee L<Bio::SeqFeature::Similarity>, L<Bio::SeqFeature::FeaturePair>\n\n\nsub query {\n    return shift->feature1(@_);\n}\n\n\n\n\n=head2 subject\n\n Title   : subject\n Usage   : $sbjct_feature = $obj->subject();\n           $obj->subject($sbjct_feature);\n Function: Get/Set Subject for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n Notes   : Deprecated.  Use the method 'hit' instead\n\n\nsub subject { \n    my $self = shift;\n#    $self->deprecated(\"Method subject deprecated: use hit() instead\");\n    $self->hit(@_); \n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $sbjct_feature = $obj->hit();\n           $obj->hit($sbjct_feature);\n Function: Get/Set Hit for a SimilarityPair \n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] Bio::SeqFeature::Similarity\n\n\n\nsub hit {\n    return shift->feature2(@_);\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $source = $obj->source_tag(); # i.e., program\n           $obj->source_tag($evalue);\n Function: Gets the source tag (program name typically) for a feature \n Returns : string\n Args    : [optional] string\n\n\n\nsub source_tag {\n    my ($self, @args) = @_;\n\n    if(@args) {\n        $self->hit()->source_tag(@args);\n    }\n    return $self->query()->source_tag(@args);\n}\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: \n Returns : \n Args    : \n\n\n\nsub significance {\n    my ($self, @args) = @_;\n\n    if(@args) {\n        $self->hit()->significance(@args);\n    }\n    return $self->query()->significance(@args);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $obj->score();\n           $obj->score($value);\n Function: \n Returns : \n Args    : \n\n\n\nsub score {\n    my ($self, @args) = @_;\n\n    if(@args) {\n        $self->hit()->score(@args);\n    }\n    # Note: You might think it's only getting set on the hit object.\n    # Actually, it's getting set on both hit and query.\n\n    return $self->query()->score(@args);\n}\n\n=head2 bits\n\n Title   : bits\n Usage   : $bits = $obj->bits();\n           $obj->bits($value);\n Function: \n Returns : \n Args    : ","parameters":[{"label":"$self"},{"label":"@args"}],"label":"bits($self,@args)"},"range":{"start":{"character":0,"line":291},"end":{"character":9999,"line":298}},"kind":12,"line":291}]}