{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":96},{"definition":"sub","detail":"($caller,@args)","children":[{"line":99,"name":"$caller","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"new","name":"@args","line":99},{"line":100,"name":"$self","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"kind":13,"containerName":"new","name":"$caller","line":100},{"line":100,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","kind":13,"containerName":"new","name":"$feature","line":102,"definition":"my"},{"line":102,"name":"$location","kind":13,"containerName":"new"},{"line":102,"kind":13,"containerName":"new","name":"$self"},{"line":102,"name":"_rearrange","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"@args","line":102},{"line":104,"name":"$feature","kind":13,"containerName":"new"},{"line":104,"containerName":"new","kind":13,"name":"$feature"},{"name":"$feature","containerName":"new","kind":13,"line":104},{"name":"isa","containerName":"new","kind":12,"line":104},{"line":105,"kind":13,"containerName":"new","name":"$self"},{"name":"throw","containerName":"new","kind":12,"line":105},{"line":108,"kind":13,"containerName":"new","name":"$feature"},{"containerName":"new","kind":12,"name":"isa","line":108},{"name":"$feature","containerName":"new","kind":13,"line":109},{"name":"$feature","containerName":"new","kind":13,"line":109},{"line":109,"kind":12,"containerName":"new","name":"parent"},{"line":112,"containerName":"new","kind":13,"name":"$location"},{"kind":13,"containerName":"new","name":"$location","line":112},{"name":"$location","kind":13,"containerName":"new","line":112},{"name":"isa","containerName":"new","kind":12,"line":112},{"name":"$self","containerName":"new","kind":13,"line":113},{"kind":12,"containerName":"new","name":"throw","line":113},{"line":117,"name":"$self","containerName":"new","kind":13}],"name":"new","containerName":"main::","signature":{"label":"new($caller,@args)","parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":""},"line":98,"range":{"end":{"character":9999,"line":118},"start":{"character":0,"line":98}},"kind":12},{"kind":12,"containerName":"new","name":"SUPER","line":100},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none","label":"location($self,$value)"},"line":133,"range":{"start":{"character":0,"line":133},"end":{"line":148,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"line":134,"localvar":"my","kind":13,"containerName":"location","name":"$self","definition":"my"},{"line":134,"name":"$value","containerName":"location","kind":13},{"line":136,"name":"$value","containerName":"location","kind":13},{"containerName":"location","kind":13,"name":"$value","line":137},{"line":137,"name":"$value","kind":13,"containerName":"location"},{"name":"isa","kind":12,"containerName":"location","line":137},{"line":138,"name":"$self","containerName":"location","kind":13},{"name":"throw","containerName":"location","kind":12,"line":138},{"name":"$self","kind":13,"containerName":"location","line":141},{"name":"$value","kind":13,"containerName":"location","line":141},{"kind":13,"containerName":"location","name":"$self","line":143},{"line":145,"containerName":"location","kind":13,"name":"$self"},{"line":145,"name":"new","kind":12,"containerName":"location"},{"kind":13,"containerName":"location","name":"$self","line":147}],"name":"location","containerName":"main::"},{"name":"Bio","kind":12,"containerName":"Location::Simple","line":145},{"children":[{"containerName":"parent","localvar":"my","kind":13,"name":"$self","line":163,"definition":"my"},{"line":163,"name":"$value","kind":13,"containerName":"parent"},{"line":165,"name":"$value","containerName":"parent","kind":13},{"containerName":"parent","kind":13,"name":"$value","line":166},{"line":166,"kind":13,"containerName":"parent","name":"$value"},{"line":166,"name":"isa","kind":12,"containerName":"parent"},{"line":167,"containerName":"parent","kind":13,"name":"$self"},{"name":"throw","containerName":"parent","kind":12,"line":167},{"containerName":"parent","kind":13,"name":"$self","line":170},{"line":170,"name":"$value","containerName":"parent","kind":13},{"kind":13,"containerName":"parent","name":"$self","line":173}],"name":"parent","containerName":"main::","definition":"sub","detail":"($self,$value)","line":162,"range":{"start":{"character":0,"line":162},"end":{"character":9999,"line":174}},"kind":12,"signature":{"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"parent($self,$value)"}},{"signature":{"label":"start($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none"},"line":190,"kind":12,"range":{"start":{"line":190,"character":0},"end":{"character":9999,"line":193}},"definition":"sub","detail":"($self,$value)","children":[{"line":191,"name":"$self","localvar":"my","kind":13,"containerName":"start","definition":"my"},{"name":"$value","containerName":"start","kind":13,"line":191},{"containerName":"start","kind":13,"name":"$self","line":192},{"line":192,"name":"location","kind":12,"containerName":"start"},{"name":"start","kind":12,"containerName":"start","line":192},{"kind":13,"containerName":"start","name":"$value","line":192}],"containerName":"main::","name":"start"},{"children":[{"localvar":"my","kind":13,"containerName":"end","name":"$self","line":208,"definition":"my"},{"line":208,"name":"$value","containerName":"end","kind":13},{"line":209,"name":"$self","containerName":"end","kind":13},{"line":209,"containerName":"end","kind":12,"name":"location"},{"line":209,"kind":12,"containerName":"end","name":"end"},{"line":209,"kind":13,"containerName":"end","name":"$value"}],"containerName":"main::","name":"end","definition":"sub","detail":"($self,$value)","line":207,"range":{"start":{"line":207,"character":0},"end":{"line":210,"character":9999}},"kind":12,"signature":{"label":"end($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none"}},{"line":224,"kind":12,"range":{"end":{"line":227,"character":9999},"start":{"character":0,"line":224}},"signature":{"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"}],"label":"length($self)"},"children":[{"line":225,"localvar":"my","kind":13,"containerName":"length","name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"length","line":226},{"name":"end","containerName":"length","kind":12,"line":226},{"line":226,"kind":13,"containerName":"length","name":"$self"},{"containerName":"length","kind":12,"name":"start","line":226}],"name":"length","containerName":"main::","definition":"sub","detail":"($self)"},{"kind":12,"range":{"start":{"line":241,"character":0},"end":{"line":244,"character":9999}},"line":241,"signature":{"label":"strand($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none"},"containerName":"main::","name":"strand","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"strand","line":242},{"line":242,"name":"$value","kind":13,"containerName":"strand"},{"containerName":"strand","kind":13,"name":"$self","line":243},{"containerName":"strand","kind":12,"name":"location","line":243},{"name":"strand","containerName":"strand","kind":12,"line":243},{"line":243,"containerName":"strand","kind":13,"name":"$value"}],"detail":"($self,$value)","definition":"sub"},{"signature":{"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :","parameters":[{"label":"$self"},{"label":"$seq"}],"label":"attach_seq($self,$seq)"},"kind":12,"range":{"start":{"character":0,"line":261},"end":{"line":278,"character":9999}},"line":261,"detail":"($self,$seq)","definition":"sub","containerName":"main::","name":"attach_seq","children":[{"line":262,"kind":13,"localvar":"my","containerName":"attach_seq","name":"$self","definition":"my"},{"name":"$seq","kind":13,"containerName":"attach_seq","line":262},{"name":"$seq","containerName":"attach_seq","kind":13,"line":264},{"name":"$seq","containerName":"attach_seq","kind":13,"line":264},{"containerName":"attach_seq","kind":13,"name":"$seq","line":264},{"line":264,"name":"isa","kind":12,"containerName":"attach_seq"},{"line":265,"kind":13,"containerName":"attach_seq","name":"$self"},{"line":265,"name":"throw","containerName":"attach_seq","kind":12},{"name":"$self","kind":13,"containerName":"attach_seq","line":268},{"name":"$seq","kind":13,"containerName":"attach_seq","line":268},{"definition":"my","line":272,"name":"$sf","kind":13,"localvar":"my","containerName":"attach_seq"},{"line":272,"name":"$self","kind":13,"containerName":"attach_seq"},{"name":"sub_SeqFeature","containerName":"attach_seq","kind":12,"line":272},{"line":273,"name":"$sf","kind":13,"containerName":"attach_seq"},{"line":273,"containerName":"attach_seq","kind":12,"name":"can"},{"containerName":"attach_seq","kind":13,"name":"$sf","line":274},{"line":274,"name":"attach_seq","containerName":"attach_seq","kind":12},{"kind":13,"containerName":"attach_seq","name":"$seq","line":274}]},{"definition":"sub","detail":"($self,$arg)","children":[{"definition":"my","name":"$self","containerName":"seq","localvar":"my","kind":13,"line":293},{"name":"$arg","kind":13,"containerName":"seq","line":293},{"line":295,"containerName":"seq","kind":13,"name":"$arg"},{"line":296,"name":"$self","kind":13,"containerName":"seq"},{"line":296,"kind":12,"containerName":"seq","name":"throw"},{"line":299,"kind":13,"containerName":"seq","name":"$self"},{"definition":"my","line":306,"name":"$seq","localvar":"my","containerName":"seq","kind":13},{"line":306,"containerName":"seq","kind":13,"name":"$self"},{"name":"trunc","containerName":"seq","kind":12,"line":306},{"line":306,"kind":13,"containerName":"seq","name":"$self"},{"name":"start","kind":12,"containerName":"seq","line":306},{"kind":13,"containerName":"seq","name":"$self","line":306},{"containerName":"seq","kind":12,"name":"end","line":306},{"kind":13,"containerName":"seq","name":"$self","line":309},{"name":"strand","kind":12,"containerName":"seq","line":309},{"line":310,"containerName":"seq","kind":13,"name":"$seq"},{"line":310,"containerName":"seq","kind":13,"name":"$seq"},{"containerName":"seq","kind":12,"name":"revcom","line":310},{"name":"$seq","kind":13,"containerName":"seq","line":313}],"containerName":"main::","name":"seq","signature":{"label":"seq($self,$arg)","documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none","parameters":[{"label":"$self"},{"label":"$arg"}]},"line":292,"kind":12,"range":{"end":{"character":9999,"line":314},"start":{"line":292,"character":0}}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :","label":"entire_seq($self)"},"range":{"end":{"character":9999,"line":333},"start":{"line":328,"character":0}},"kind":12,"line":328,"detail":"($self)","definition":"sub","name":"entire_seq","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"entire_seq","kind":13,"line":329,"definition":"my"},{"line":331,"name":"$self","containerName":"entire_seq","kind":13},{"containerName":"entire_seq","kind":13,"name":"$self","line":332}]},{"detail":"($obj,$value)","definition":"sub","name":"seqname","containerName":"main::","children":[{"line":355,"localvar":"my","kind":13,"containerName":"seqname","name":"$obj","definition":"my"},{"line":355,"name":"$value","containerName":"seqname","kind":13},{"line":356,"kind":13,"containerName":"seqname","name":"$value"},{"name":"$obj","containerName":"seqname","kind":13,"line":357},{"containerName":"seqname","kind":13,"name":"$value","line":357},{"line":359,"name":"$obj","containerName":"seqname","kind":13}],"signature":{"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :\n\n\n\nsub entire_seq {\n   my ($self) = @_;\n\n   return unless exists($self->{'_gsf_seq'});\n   return $self->{'_gsf_seq'};\n}\n\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)","parameters":[{"label":"$obj"},{"label":"$value"}],"label":"seqname($obj,$value)"},"kind":12,"range":{"start":{"character":0,"line":354},"end":{"line":360,"character":9999}},"line":354},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":384,"kind":13,"localvar":"my","containerName":"primary_tag","name":"$self"},{"line":384,"name":"@args","containerName":"primary_tag","kind":13},{"line":386,"name":"$self","kind":13,"containerName":"primary_tag"},{"kind":12,"containerName":"primary_tag","name":"parent","line":386},{"kind":12,"containerName":"primary_tag","name":"primary_tag","line":386}],"containerName":"main::","name":"primary_tag","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :\n\n\n\nsub entire_seq {\n   my ($self) = @_;\n\n   return unless exists($self->{'_gsf_seq'});\n   return $self->{'_gsf_seq'};\n}\n\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)\n\n\n\nsub seqname {\n    my ($obj,$value) = @_;\n    if ( defined $value ) {\n\t$obj->{'_gsf_seqname'} = $value;\n    }\n    return $obj->{'_gsf_seqname'};\n}\n\n\n\n=head2 Proxies\n\nThese functions chain back to the parent for all non sequence related stuff.\n\n\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string \n Args    : none","label":"primary_tag($self,@args)"},"line":383,"kind":12,"range":{"start":{"line":383,"character":0},"end":{"character":9999,"line":387}}},{"signature":{"label":"source_tag($self)","documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :\n\n\n\nsub entire_seq {\n   my ($self) = @_;\n\n   return unless exists($self->{'_gsf_seq'});\n   return $self->{'_gsf_seq'};\n}\n\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)\n\n\n\nsub seqname {\n    my ($obj,$value) = @_;\n    if ( defined $value ) {\n\t$obj->{'_gsf_seqname'} = $value;\n    }\n    return $obj->{'_gsf_seqname'};\n}\n\n\n\n=head2 Proxies\n\nThese functions chain back to the parent for all non sequence related stuff.\n\n\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string \n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   return $self->parent->primary_tag();\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan' \n Returns : a string \n Args    : none","parameters":[{"label":"$self"}]},"line":401,"kind":12,"range":{"end":{"character":9999,"line":405},"start":{"character":0,"line":401}},"definition":"sub","detail":"($self)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"source_tag","line":402,"definition":"my"},{"line":404,"name":"$self","kind":13,"containerName":"source_tag"},{"line":404,"kind":12,"containerName":"source_tag","name":"parent"},{"line":404,"kind":12,"containerName":"source_tag","name":"source_tag"}],"containerName":"main::","name":"source_tag"},{"containerName":"main::","name":"has_tag","children":[{"line":420,"name":"$self","containerName":"has_tag","localvar":"my","kind":13,"definition":"my"},{"name":"$tag","kind":13,"containerName":"has_tag","line":420},{"line":422,"name":"$self","containerName":"has_tag","kind":13},{"line":422,"containerName":"has_tag","kind":12,"name":"parent"},{"name":"has_tag","kind":12,"containerName":"has_tag","line":422},{"name":"$tag","containerName":"has_tag","kind":13,"line":422}],"detail":"($self,$tag)","definition":"sub","kind":12,"range":{"start":{"line":419,"character":0},"end":{"line":423,"character":9999}},"line":419,"signature":{"parameters":[{"label":"$self"},{"label":"$tag"}],"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :\n\n\n\nsub entire_seq {\n   my ($self) = @_;\n\n   return unless exists($self->{'_gsf_seq'});\n   return $self->{'_gsf_seq'};\n}\n\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)\n\n\n\nsub seqname {\n    my ($obj,$value) = @_;\n    if ( defined $value ) {\n\t$obj->{'_gsf_seqname'} = $value;\n    }\n    return $obj->{'_gsf_seqname'};\n}\n\n\n\n=head2 Proxies\n\nThese functions chain back to the parent for all non sequence related stuff.\n\n\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string \n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   return $self->parent->primary_tag();\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan' \n Returns : a string \n Args    : none\n\n\n\nsub source_tag{\n   my ($self) = @_;\n\n   return $self->parent->source_tag();\n}\n\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :","label":"has_tag($self,$tag)"}},{"detail":"($self,$tag)","definition":"sub","containerName":"main::","name":"each_tag_value","children":[{"definition":"my","line":437,"kind":13,"localvar":"my","containerName":"each_tag_value","name":"$self"},{"kind":13,"containerName":"each_tag_value","name":"$tag","line":437},{"line":439,"name":"$self","containerName":"each_tag_value","kind":13},{"name":"parent","containerName":"each_tag_value","kind":12,"line":439},{"name":"each_tag_value","containerName":"each_tag_value","kind":12,"line":439},{"name":"$tag","kind":13,"containerName":"each_tag_value","line":439}],"signature":{"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :\n\n\n\nsub entire_seq {\n   my ($self) = @_;\n\n   return unless exists($self->{'_gsf_seq'});\n   return $self->{'_gsf_seq'};\n}\n\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)\n\n\n\nsub seqname {\n    my ($obj,$value) = @_;\n    if ( defined $value ) {\n\t$obj->{'_gsf_seqname'} = $value;\n    }\n    return $obj->{'_gsf_seqname'};\n}\n\n\n\n=head2 Proxies\n\nThese functions chain back to the parent for all non sequence related stuff.\n\n\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string \n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   return $self->parent->primary_tag();\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan' \n Returns : a string \n Args    : none\n\n\n\nsub source_tag{\n   my ($self) = @_;\n\n   return $self->parent->source_tag();\n}\n\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :\n\n\n\nsub has_tag{\n   my ($self,$tag) = @_;\n\n   return $self->parent->has_tag($tag);\n}\n\n=head2 each_tag_value\n\n Title   : each_tag_value\n Usage   : @values = $self->each_tag_value('some_tag')\n Function: \n Returns : An array comprising the values of the specified tag.\n Args    :","parameters":[{"label":"$self"},{"label":"$tag"}],"label":"each_tag_value($self,$tag)"},"range":{"start":{"line":436,"character":0},"end":{"character":9999,"line":440}},"kind":12,"line":436},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":454,"containerName":"all_tags","localvar":"my","kind":13,"name":"$self"},{"line":456,"kind":13,"containerName":"all_tags","name":"$self"},{"name":"parent","kind":12,"containerName":"all_tags","line":456},{"containerName":"all_tags","kind":12,"name":"all_tags","line":456}],"name":"all_tags","containerName":"main::","signature":{"label":"all_tags($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PositionProxy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::PositionProxy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::PositionProxy - handle features when truncation/revcom sequences span a feature\n\n=head1 SYNOPSIS\n\n   $proxy = Bio::SeqFeature::PositionProxy->new( -loc => $loc,\n                                                 -parent => $basefeature);\n\n   $seq->add_SeqFeature($feat);\n\n\n\n=head1 DESCRIPTION\n\nPositionProxy is a Proxy Sequence Feature to handle truncation\nand revcomp without duplicating all the data within the sequence features.\nIt holds a new location for a sequence feature and the original feature\nit came from to provide the additional annotation information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out of inheritence. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for sub arrays\n   _gsf_start     = scalar of the start point\n   _gsf_end       = scalar of the end point\n   _gsf_strand    = scalar of the strand\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::PositionProxy;\nuse strict;\n\nuse Bio::Tools::GFF;\n\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($feature,$location) = $self->_rearrange([qw(PARENT LOC)],@args);\n\n    if( !defined $feature || !ref $feature || !$feature->isa('Bio::SeqFeatureI') ) {\n      $self->throw(\"Must have a parent feature, not a [$feature]\");\n    }\n\n    if( $feature->isa(\"Bio::SeqFeature::PositionProxy\") ) {\n      $feature = $feature->parent();\n    }\n\n    if( !defined $location || !ref $location || !$location->isa('Bio::LocationI') ) {\n      $self->throw(\"Must have a location, not a [$location]\");\n    }\n\n\n    return $self;\n}\n\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n\t   of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 parent\n\n Title   : parent\n Usage   : my $sf = $proxy->parent()\n Function: returns the seqfeature parent of this proxy\n Returns : Bio::SeqFeatureI object\n Args    : none\n\n\n\nsub parent {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::SeqFeatureI')) {\n\t    $self->throw(\"object $value pretends to be a location but \".\n\t\t\t \"does not implement Bio::SeqFeatureI\");\n        }\n        $self->{'_parent'} = $value;\n    }\n\n    return $self->{'_parent'};\n}\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($self) = @_;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my ($self,$value) = @_;\n   return $self->location->strand($value);\n}\n\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    :\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( !defined $seq || !ref $seq || ! $seq->isa(\"Bio::PrimarySeqI\") ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n\n   foreach my $sf ( $self->sub_SeqFeature() ) {\n       if ( $sf->can(\"attach_seq\") ) {\n\t   $sf->attach_seq($seq);\n       }\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq on attached sequence bounded by start & end\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::PositionProxy->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( $self->strand == -1 ) {\n       $seq = $seq->revcom;\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns :\n Args    :\n\n\n\nsub entire_seq {\n   my ($self) = @_;\n\n   return unless exists($self->{'_gsf_seq'});\n   return $self->{'_gsf_seq'};\n}\n\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)\n\n\n\nsub seqname {\n    my ($obj,$value) = @_;\n    if ( defined $value ) {\n\t$obj->{'_gsf_seqname'} = $value;\n    }\n    return $obj->{'_gsf_seqname'};\n}\n\n\n\n=head2 Proxies\n\nThese functions chain back to the parent for all non sequence related stuff.\n\n\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string \n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   return $self->parent->primary_tag();\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan' \n Returns : a string \n Args    : none\n\n\n\nsub source_tag{\n   my ($self) = @_;\n\n   return $self->parent->source_tag();\n}\n\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :\n\n\n\nsub has_tag{\n   my ($self,$tag) = @_;\n\n   return $self->parent->has_tag($tag);\n}\n\n=head2 each_tag_value\n\n Title   : each_tag_value\n Usage   : @values = $self->each_tag_value('some_tag')\n Function: \n Returns : An array comprising the values of the specified tag.\n Args    :\n\n\n\nsub each_tag_value {\n   my ($self,$tag) = @_;\n\n   return $self->parent->each_tag_value($tag);\n}\n\n=head2 all_tags\n\n Title   : all_tags\n Usage   : @tags = $feat->all_tags()\n Function: gives all tags for this feature\n Returns : an array of strings\n Args    : none"},"line":453,"range":{"start":{"character":0,"line":453},"end":{"character":9999,"line":457}},"kind":12}]}