{"vars":[{"line":78,"containerName":"","kind":2,"name":"base"},{"range":{"end":{"character":9999,"line":99},"start":{"character":0,"line":96}},"kind":12,"line":96,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : ","label":"promoters($self)"},"containerName":"main::","name":"promoters","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"promoters","line":97,"definition":"my"},{"containerName":"promoters","kind":13,"name":"$self","line":98},{"name":"throw_not_implemented","containerName":"promoters","kind":12,"line":98}],"detail":"($self)","definition":"sub"},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"exons","line":121,"definition":"my"},{"containerName":"exons","kind":13,"name":"$type","line":121},{"containerName":"exons","kind":13,"name":"$self","line":122},{"containerName":"exons","kind":12,"name":"throw_not_implemented","line":122}],"name":"exons","containerName":"main::","definition":"sub","detail":"($self,$type)","line":120,"kind":12,"range":{"start":{"character":0,"line":120},"end":{"character":9999,"line":123}},"signature":{"label":"exons($self,$type)","documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.","parameters":[{"label":"$self"},{"label":"$type"}]}},{"children":[{"line":138,"name":"$self","containerName":"introns","localvar":"my","kind":13,"definition":"my"},{"line":139,"containerName":"introns","kind":13,"name":"$self"},{"line":139,"containerName":"introns","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"introns","definition":"sub","detail":"($self)","line":137,"kind":12,"range":{"end":{"line":140,"character":9999},"start":{"character":0,"line":137}},"signature":{"documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $transcript->introns();\n Function: Get all introns this transcript comprises of.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : ","parameters":[{"label":"$self"}],"label":"introns($self)"}},{"signature":{"label":"poly_A_site($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $transcript->introns();\n Function: Get all introns this transcript comprises of.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get the poly-adenylation site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object.\n Args    : "},"line":153,"kind":12,"range":{"end":{"line":156,"character":9999},"start":{"character":0,"line":153}},"definition":"sub","detail":"($self)","children":[{"line":154,"localvar":"my","containerName":"poly_A_site","kind":13,"name":"$self","definition":"my"},{"line":155,"containerName":"poly_A_site","kind":13,"name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"poly_A_site","line":155}],"containerName":"main::","name":"poly_A_site"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":174,"kind":13,"localvar":"my","containerName":"utrs","name":"$self"},{"line":175,"name":"$self","kind":13,"containerName":"utrs"},{"containerName":"utrs","kind":12,"name":"throw_not_implemented","line":175}],"name":"utrs","containerName":"main::","signature":{"documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $transcript->introns();\n Function: Get all introns this transcript comprises of.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get the poly-adenylation site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object.\n Args    : \n\n\n\nsub poly_A_site {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs();\n Function: Get the UTR regions this transcript comprises of.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : ","parameters":[{"label":"$self"}],"label":"utrs($self)"},"line":173,"range":{"end":{"line":176,"character":9999},"start":{"character":0,"line":173}},"kind":12},{"kind":12,"range":{"end":{"character":9999,"line":193},"start":{"character":0,"line":190}},"line":190,"signature":{"documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $transcript->introns();\n Function: Get all introns this transcript comprises of.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get the poly-adenylation site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object.\n Args    : \n\n\n\nsub poly_A_site {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs();\n Function: Get the UTR regions this transcript comprises of.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : \n\n\n\nsub utrs {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 mrna\n\n Title   : mrna()\n Usage   : $mrna = $transcript->mrna();\n Function: Get the mRNA of the transcript as a sequence object.\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : ","parameters":[{"label":"$self"}],"label":"mrna($self)"},"containerName":"main::","name":"mrna","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"mrna","line":191},{"line":192,"containerName":"mrna","kind":13,"name":"$self"},{"kind":12,"containerName":"mrna","name":"throw_not_implemented","line":192}],"detail":"($self)","definition":"sub"},{"detail":"($self)","definition":"sub","containerName":"main::","name":"cds","children":[{"line":209,"localvar":"my","containerName":"cds","kind":13,"name":"$self","definition":"my"},{"line":210,"containerName":"cds","kind":13,"name":"$self"},{"containerName":"cds","kind":12,"name":"throw_not_implemented","line":210}],"signature":{"documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $transcript->introns();\n Function: Get all introns this transcript comprises of.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get the poly-adenylation site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object.\n Args    : \n\n\n\nsub poly_A_site {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs();\n Function: Get the UTR regions this transcript comprises of.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : \n\n\n\nsub utrs {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 mrna\n\n Title   : mrna()\n Usage   : $mrna = $transcript->mrna();\n Function: Get the mRNA of the transcript as a sequence object.\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : \n\n\n\nsub mrna {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 cds\n\n Title   : cds()\n Usage   : $cds = $transcript->cds();\n Function: Get the CDS (coding sequence) of the transcript as a sequence\n           object.\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : ","parameters":[{"label":"$self"}],"label":"cds($self)"},"kind":12,"range":{"end":{"line":211,"character":9999},"start":{"character":0,"line":208}},"line":208},{"children":[{"definition":"my","line":226,"name":"$self","kind":13,"localvar":"my","containerName":"protein"},{"kind":13,"containerName":"protein","name":"$self","line":227},{"line":227,"name":"throw_not_implemented","containerName":"protein","kind":12}],"name":"protein","containerName":"main::","definition":"sub","detail":"($self)","line":225,"range":{"start":{"line":225,"character":0},"end":{"line":228,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $transcript->introns();\n Function: Get all introns this transcript comprises of.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get the poly-adenylation site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object.\n Args    : \n\n\n\nsub poly_A_site {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs();\n Function: Get the UTR regions this transcript comprises of.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : \n\n\n\nsub utrs {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 mrna\n\n Title   : mrna()\n Usage   : $mrna = $transcript->mrna();\n Function: Get the mRNA of the transcript as a sequence object.\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : \n\n\n\nsub mrna {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 cds\n\n Title   : cds()\n Usage   : $cds = $transcript->cds();\n Function: Get the CDS (coding sequence) of the transcript as a sequence\n           object.\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : \n\n\n\nsub cds {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 protein\n\n Title   : protein()\n Usage   : $protein = $transcript->protein();\n Function: Get the protein encoded by the transcript as a sequence object.\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : ","label":"protein($self)"}},{"children":[{"definition":"my","line":242,"localvar":"my","kind":13,"containerName":"parent","name":"$self"},{"name":"$value","kind":13,"localvar":"my","containerName":"parent","line":244,"definition":"my"},{"containerName":"parent","kind":13,"name":"$value","line":247},{"kind":13,"containerName":"parent","name":"$value","line":248},{"name":"isa","containerName":"parent","kind":12,"line":248},{"line":249,"name":"$self","containerName":"parent","kind":13},{"line":249,"name":"$value","containerName":"parent","kind":13},{"line":251,"name":"$self","containerName":"parent","kind":13},{"line":251,"name":"throw","containerName":"parent","kind":12},{"kind":13,"containerName":"parent","name":"$self","line":254}],"name":"parent","containerName":"main::","definition":"sub","line":241,"range":{"start":{"character":0,"line":241},"end":{"line":255,"character":9999}},"kind":12}],"version":5}