{"version":5,"vars":[{"line":76,"containerName":"","kind":2,"name":"base"},{"definition":"sub","detail":"($class,@args)","children":[{"line":79,"localvar":"my","kind":13,"containerName":"new","name":"$class","definition":"my"},{"kind":13,"containerName":"new","name":"@args","line":79},{"containerName":"new","kind":13,"name":"@args","line":82},{"containerName":"new","kind":13,"name":"@args","line":83},{"line":85,"name":"$self","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"line":85,"name":"$class","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"@args","line":85},{"containerName":"new","localvar":"my","kind":13,"name":"$primary","line":87,"definition":"my"},{"name":"$prim","kind":13,"containerName":"new","line":87},{"line":88,"kind":13,"containerName":"new","name":"$self"},{"line":88,"name":"_rearrange","containerName":"new","kind":12},{"name":"@args","kind":13,"containerName":"new","line":88},{"line":89,"name":"$self","containerName":"new","kind":13},{"line":89,"containerName":"new","kind":12,"name":"primary_tag"},{"containerName":"new","kind":13,"name":"$primary","line":89},{"line":89,"name":"$prim","kind":13,"containerName":"new"},{"line":91,"name":"$self","containerName":"new","kind":13}],"name":"new","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"line":78,"range":{"end":{"line":92,"character":9999},"start":{"character":0,"line":78}},"kind":12},{"kind":12,"containerName":"new","name":"SUPER","line":85},{"detail":"($self,$exon)","definition":"sub","name":"upstream_Exon","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"upstream_Exon","line":105},{"name":"$exon","containerName":"upstream_Exon","kind":13,"line":105},{"line":107,"kind":13,"containerName":"upstream_Exon","name":"$exon"},{"containerName":"upstream_Exon","kind":13,"name":"$self","line":108},{"kind":13,"containerName":"upstream_Exon","name":"$self","line":109},{"kind":12,"containerName":"upstream_Exon","name":"throw","line":109},{"line":110,"containerName":"upstream_Exon","kind":13,"name":"$exon"},{"line":110,"containerName":"upstream_Exon","kind":12,"name":"isa"},{"line":111,"kind":13,"containerName":"upstream_Exon","name":"$self"},{"line":111,"kind":13,"containerName":"upstream_Exon","name":"$exon"},{"line":113,"name":"$self","kind":13,"containerName":"upstream_Exon"}],"signature":{"label":"upstream_Exon($self,$exon)","parameters":[{"label":"$self"},{"label":"$exon"}],"documentation":"1;\n# $Id: Intron.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Intron\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by David Block <dblock@gene.pbi.nrc.ca>\n#\n# Copyright David Block\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Intron - An intron feature\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - David Block\n\nEmail dblock@gene.pbi.nrc.ca\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::Intron;\nuse strict;\n\nuse Bio::SeqFeature::Gene::Exon;\n\nuse base qw(Bio::SeqFeature::Gene::NC_Feature);\n\nsub new {\n    my($class,@args) = @_;\n\n    # introns are non-coding by default\n    if(! grep { lc($_) eq '-is_coding'; } @args) {\n\tpush(@args, '-is_coding', 0);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $prim) = \n\t$self->_rearrange([qw(PRIMARY PRIMARY_TAG)],@args);\n    $self->primary_tag('intron') unless $primary || $prim;\n\n    return $self;\n}\n\n=head2 upstream_Exon \n\n  Title   : upstream_Exon \n  Usage   : $intron->upstream_Exon()\n  Function: exon upstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : "},"kind":12,"range":{"start":{"character":0,"line":104},"end":{"character":9999,"line":114}},"line":104},{"signature":{"parameters":[{"label":"$self"},{"label":"$exon"}],"documentation":"1;\n# $Id: Intron.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Intron\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by David Block <dblock@gene.pbi.nrc.ca>\n#\n# Copyright David Block\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Intron - An intron feature\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - David Block\n\nEmail dblock@gene.pbi.nrc.ca\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::Intron;\nuse strict;\n\nuse Bio::SeqFeature::Gene::Exon;\n\nuse base qw(Bio::SeqFeature::Gene::NC_Feature);\n\nsub new {\n    my($class,@args) = @_;\n\n    # introns are non-coding by default\n    if(! grep { lc($_) eq '-is_coding'; } @args) {\n\tpush(@args, '-is_coding', 0);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $prim) = \n\t$self->_rearrange([qw(PRIMARY PRIMARY_TAG)],@args);\n    $self->primary_tag('intron') unless $primary || $prim;\n\n    return $self;\n}\n\n=head2 upstream_Exon \n\n  Title   : upstream_Exon \n  Usage   : $intron->upstream_Exon()\n  Function: exon upstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub upstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\") \n\t    unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_upstream_exon'} = $exon;\n    }\n    return $self->{'_upstream_exon'};\n}\n\n\n=head2 downstream_Exon \n\n  Title   : downstream_Exon \n  Usage   : $intron->downstream_Exon()\n  Function: exon downstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : ","label":"downstream_Exon($self,$exon)"},"line":127,"kind":12,"range":{"start":{"line":127,"character":0},"end":{"character":9999,"line":137}},"definition":"sub","detail":"($self,$exon)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"downstream_Exon","name":"$self","line":128},{"kind":13,"containerName":"downstream_Exon","name":"$exon","line":128},{"line":130,"name":"$exon","containerName":"downstream_Exon","kind":13},{"name":"$self","kind":13,"containerName":"downstream_Exon","line":131},{"line":132,"containerName":"downstream_Exon","kind":13,"name":"$self"},{"line":132,"containerName":"downstream_Exon","kind":12,"name":"throw"},{"line":133,"name":"$exon","kind":13,"containerName":"downstream_Exon"},{"line":133,"name":"isa","containerName":"downstream_Exon","kind":12},{"name":"$self","kind":13,"containerName":"downstream_Exon","line":134},{"line":134,"name":"$exon","containerName":"downstream_Exon","kind":13},{"containerName":"downstream_Exon","kind":13,"name":"$self","line":136}],"containerName":"main::","name":"downstream_Exon"},{"kind":12,"range":{"start":{"line":149,"character":0},"end":{"line":152,"character":9999}},"line":149,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Intron.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Intron\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by David Block <dblock@gene.pbi.nrc.ca>\n#\n# Copyright David Block\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Intron - An intron feature\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - David Block\n\nEmail dblock@gene.pbi.nrc.ca\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::Intron;\nuse strict;\n\nuse Bio::SeqFeature::Gene::Exon;\n\nuse base qw(Bio::SeqFeature::Gene::NC_Feature);\n\nsub new {\n    my($class,@args) = @_;\n\n    # introns are non-coding by default\n    if(! grep { lc($_) eq '-is_coding'; } @args) {\n\tpush(@args, '-is_coding', 0);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $prim) = \n\t$self->_rearrange([qw(PRIMARY PRIMARY_TAG)],@args);\n    $self->primary_tag('intron') unless $primary || $prim;\n\n    return $self;\n}\n\n=head2 upstream_Exon \n\n  Title   : upstream_Exon \n  Usage   : $intron->upstream_Exon()\n  Function: exon upstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub upstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\") \n\t    unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_upstream_exon'} = $exon;\n    }\n    return $self->{'_upstream_exon'};\n}\n\n\n=head2 downstream_Exon \n\n  Title   : downstream_Exon \n  Usage   : $intron->downstream_Exon()\n  Function: exon downstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub downstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\")\n            unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_downstream_exon'} = $exon;\n    }\n    return $self->{'_downstream_exon'};\n}\n\n=head2 phase \n\n  Title   : phase \n  Usage   : $intron->phase()\n  Function: returns the phase of the intron(where it interrupts the codon)  \n  Returns : int(0,1,2)\n  Args    : ","label":"phase($self)"},"containerName":"main::","name":"phase","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"phase","line":150},{"line":151,"name":"$self","kind":13,"containerName":"phase"},{"name":"downstream_Exon","kind":12,"containerName":"phase","line":151},{"line":151,"name":"phase","kind":12,"containerName":"phase"}],"detail":"($self)","definition":"sub"},{"detail":"($self,$ss_start,$ss_end)","definition":"sub","name":"acceptor_splice_site","containerName":"main::","children":[{"name":"$self","containerName":"acceptor_splice_site","localvar":"my","kind":13,"line":173,"definition":"my"},{"line":173,"name":"$ss_start","kind":13,"containerName":"acceptor_splice_site"},{"line":173,"containerName":"acceptor_splice_site","kind":13,"name":"$ss_end"},{"kind":13,"containerName":"acceptor_splice_site","name":"$ss_start","line":174},{"line":174,"name":"$ss_start","kind":13,"containerName":"acceptor_splice_site"},{"line":175,"kind":13,"containerName":"acceptor_splice_site","name":"$ss_end"},{"name":"$ss_end","kind":13,"containerName":"acceptor_splice_site","line":175},{"line":176,"name":"$self","kind":13,"containerName":"acceptor_splice_site"},{"name":"strand","kind":12,"containerName":"acceptor_splice_site","line":176},{"line":177,"name":"$tmp","localvar":"my","containerName":"acceptor_splice_site","kind":13,"definition":"my"},{"line":177,"name":"$ss_start","containerName":"acceptor_splice_site","kind":13},{"line":178,"kind":13,"containerName":"acceptor_splice_site","name":"$ss_start"},{"name":"$ss_end","containerName":"acceptor_splice_site","kind":13,"line":178},{"line":179,"name":"$ss_end","kind":13,"containerName":"acceptor_splice_site"},{"name":"$tmp","containerName":"acceptor_splice_site","kind":13,"line":179},{"definition":"my","name":"$intron_end","containerName":"acceptor_splice_site","localvar":"my","kind":13,"line":181},{"line":181,"name":"$self","kind":13,"containerName":"acceptor_splice_site"},{"kind":12,"containerName":"acceptor_splice_site","name":"location","line":181},{"line":181,"name":"end","kind":12,"containerName":"acceptor_splice_site"},{"definition":"my","line":182,"kind":13,"localvar":"my","containerName":"acceptor_splice_site","name":"$down_exon"},{"line":182,"kind":13,"containerName":"acceptor_splice_site","name":"$self"},{"kind":12,"containerName":"acceptor_splice_site","name":"downstream_Exon","line":182},{"line":183,"kind":13,"localvar":"my","containerName":"acceptor_splice_site","name":"$acceptor","definition":"my"},{"line":184,"name":"$self","kind":13,"containerName":"acceptor_splice_site"},{"line":184,"name":"strand","containerName":"acceptor_splice_site","kind":12},{"line":185,"containerName":"acceptor_splice_site","kind":13,"name":"$ss_start"},{"line":185,"name":"$ss_start","containerName":"acceptor_splice_site","kind":13},{"containerName":"acceptor_splice_site","kind":13,"name":"$down_exon","line":185},{"name":"length","kind":12,"containerName":"acceptor_splice_site","line":185},{"line":185,"containerName":"acceptor_splice_site","kind":13,"name":"$down_exon"},{"name":"length","containerName":"acceptor_splice_site","kind":12,"line":185},{"containerName":"acceptor_splice_site","kind":13,"name":"$ss_start","line":185},{"line":186,"name":"$ss_end","containerName":"acceptor_splice_site","kind":13},{"containerName":"acceptor_splice_site","kind":13,"name":"$ss_end","line":186},{"line":186,"name":"$self","containerName":"acceptor_splice_site","kind":13},{"kind":12,"containerName":"acceptor_splice_site","name":"length","line":186},{"name":"$self","containerName":"acceptor_splice_site","kind":13,"line":186},{"kind":12,"containerName":"acceptor_splice_site","name":"length","line":186},{"name":"$ss_end","containerName":"acceptor_splice_site","kind":13,"line":186},{"line":187,"containerName":"acceptor_splice_site","kind":13,"name":"$acceptor"},{"kind":12,"containerName":"acceptor_splice_site","name":"new","line":187},{"containerName":"acceptor_splice_site","kind":13,"name":"$self","line":187},{"line":187,"name":"start","containerName":"acceptor_splice_site","kind":12},{"line":187,"name":"$ss_start","containerName":"acceptor_splice_site","kind":13},{"containerName":"acceptor_splice_site","kind":13,"name":"$self","line":188},{"kind":12,"containerName":"acceptor_splice_site","name":"start","line":188},{"line":188,"kind":13,"containerName":"acceptor_splice_site","name":"$ss_end"},{"line":189,"containerName":"acceptor_splice_site","kind":13,"name":"$self"},{"containerName":"acceptor_splice_site","kind":12,"name":"strand","line":189},{"name":"$ss_start","containerName":"acceptor_splice_site","kind":13,"line":193},{"line":193,"name":"$ss_start","kind":13,"containerName":"acceptor_splice_site"},{"containerName":"acceptor_splice_site","kind":13,"name":"$self","line":193},{"line":193,"kind":12,"containerName":"acceptor_splice_site","name":"length"},{"containerName":"acceptor_splice_site","kind":13,"name":"$self","line":193},{"line":193,"name":"length","containerName":"acceptor_splice_site","kind":12},{"name":"$ss_start","kind":13,"containerName":"acceptor_splice_site","line":193},{"kind":13,"containerName":"acceptor_splice_site","name":"$ss_end","line":194},{"name":"$ss_end","kind":13,"containerName":"acceptor_splice_site","line":194},{"line":194,"name":"$down_exon","containerName":"acceptor_splice_site","kind":13},{"name":"length","containerName":"acceptor_splice_site","kind":12,"line":194},{"kind":13,"containerName":"acceptor_splice_site","name":"$down_exon","line":194},{"containerName":"acceptor_splice_site","kind":12,"name":"length","line":194},{"line":194,"name":"$ss_end","kind":13,"containerName":"acceptor_splice_site"},{"name":"$acceptor","kind":13,"containerName":"acceptor_splice_site","line":197},{"kind":12,"containerName":"acceptor_splice_site","name":"new","line":197},{"kind":13,"containerName":"acceptor_splice_site","name":"$self","line":197},{"name":"end","kind":12,"containerName":"acceptor_splice_site","line":197},{"name":"$ss_start","containerName":"acceptor_splice_site","kind":13,"line":197},{"containerName":"acceptor_splice_site","kind":13,"name":"$self","line":198},{"line":198,"containerName":"acceptor_splice_site","kind":12,"name":"end"},{"name":"$ss_end","kind":13,"containerName":"acceptor_splice_site","line":198},{"containerName":"acceptor_splice_site","kind":13,"name":"$self","line":199},{"line":199,"name":"strand","kind":12,"containerName":"acceptor_splice_site"},{"containerName":"acceptor_splice_site","kind":13,"name":"$acceptor","line":202},{"line":202,"name":"attach_seq","containerName":"acceptor_splice_site","kind":12},{"kind":13,"containerName":"acceptor_splice_site","name":"$self","line":202},{"line":202,"name":"entire_seq","kind":12,"containerName":"acceptor_splice_site"},{"kind":13,"containerName":"acceptor_splice_site","name":"$acceptor","line":204}],"signature":{"parameters":[{"label":"$self"},{"label":"$ss_start"},{"label":"$ss_end"}],"documentation":"1;\n# $Id: Intron.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Intron\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by David Block <dblock@gene.pbi.nrc.ca>\n#\n# Copyright David Block\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Intron - An intron feature\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - David Block\n\nEmail dblock@gene.pbi.nrc.ca\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::Intron;\nuse strict;\n\nuse Bio::SeqFeature::Gene::Exon;\n\nuse base qw(Bio::SeqFeature::Gene::NC_Feature);\n\nsub new {\n    my($class,@args) = @_;\n\n    # introns are non-coding by default\n    if(! grep { lc($_) eq '-is_coding'; } @args) {\n\tpush(@args, '-is_coding', 0);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $prim) = \n\t$self->_rearrange([qw(PRIMARY PRIMARY_TAG)],@args);\n    $self->primary_tag('intron') unless $primary || $prim;\n\n    return $self;\n}\n\n=head2 upstream_Exon \n\n  Title   : upstream_Exon \n  Usage   : $intron->upstream_Exon()\n  Function: exon upstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub upstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\") \n\t    unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_upstream_exon'} = $exon;\n    }\n    return $self->{'_upstream_exon'};\n}\n\n\n=head2 downstream_Exon \n\n  Title   : downstream_Exon \n  Usage   : $intron->downstream_Exon()\n  Function: exon downstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub downstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\")\n            unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_downstream_exon'} = $exon;\n    }\n    return $self->{'_downstream_exon'};\n}\n\n=head2 phase \n\n  Title   : phase \n  Usage   : $intron->phase()\n  Function: returns the phase of the intron(where it interrupts the codon)  \n  Returns : int(0,1,2)\n  Args    : \n\n\nsub phase {\n  my ($self) = @_;\n  return $self->downstream_Exon->phase;\n}\n\n\n=head2 acceptor_splice_site \n\n  Title   : acceptor_splice_site \n  Usage   : $intron->acceptor_splice_site(21,3)\n  Function: returns the sequence corresponding to the \n            consensus acceptor splice site. If start and\n            end are provided, it will number of base pairs\n            left and right of the canonical AG. Here 21 means\n            21 bp into intron and 3 means 3 bp into the exon.\n            --Intron--21----|AG|-3-----Exon\n            Defaults to 21,3\n\n  Returns : Bio::Seq\n  Args    : start and end","label":"acceptor_splice_site($self,$ss_start,$ss_end)"},"range":{"start":{"line":172,"character":0},"end":{"line":206,"character":9999}},"kind":12,"line":172},{"kind":12,"containerName":"SeqFeature::Generic","name":"Bio","line":187},{"line":197,"name":"Bio","kind":12,"containerName":"SeqFeature::Generic"},{"signature":{"label":"donor_splice_site($self,$ss_start,$ss_end)","parameters":[{"label":"$self"},{"label":"$ss_start"},{"label":"$ss_end"}],"documentation":"1;\n# $Id: Intron.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Intron\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by David Block <dblock@gene.pbi.nrc.ca>\n#\n# Copyright David Block\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Intron - An intron feature\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - David Block\n\nEmail dblock@gene.pbi.nrc.ca\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::Intron;\nuse strict;\n\nuse Bio::SeqFeature::Gene::Exon;\n\nuse base qw(Bio::SeqFeature::Gene::NC_Feature);\n\nsub new {\n    my($class,@args) = @_;\n\n    # introns are non-coding by default\n    if(! grep { lc($_) eq '-is_coding'; } @args) {\n\tpush(@args, '-is_coding', 0);\n    }\n    my $self = $class->SUPER::new(@args);\n\n    my ($primary, $prim) = \n\t$self->_rearrange([qw(PRIMARY PRIMARY_TAG)],@args);\n    $self->primary_tag('intron') unless $primary || $prim;\n\n    return $self;\n}\n\n=head2 upstream_Exon \n\n  Title   : upstream_Exon \n  Usage   : $intron->upstream_Exon()\n  Function: exon upstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub upstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\") \n\t    unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_upstream_exon'} = $exon;\n    }\n    return $self->{'_upstream_exon'};\n}\n\n\n=head2 downstream_Exon \n\n  Title   : downstream_Exon \n  Usage   : $intron->downstream_Exon()\n  Function: exon downstream of the intron \n  Returns : Bio::EnsEMBL::Exon\n  Args    : \n\n\nsub downstream_Exon {\n    my( $self, $exon ) = @_;\n    \n    if ($exon) {\n        $self->{'_intron_location'} = undef;\n        $self->throw(\"'$exon' is not a Bio::SeqFeature::Gene::ExonI\")\n            unless $exon->isa('Bio::SeqFeature::Gene::ExonI');\n        $self->{'_downstream_exon'} = $exon;\n    }\n    return $self->{'_downstream_exon'};\n}\n\n=head2 phase \n\n  Title   : phase \n  Usage   : $intron->phase()\n  Function: returns the phase of the intron(where it interrupts the codon)  \n  Returns : int(0,1,2)\n  Args    : \n\n\nsub phase {\n  my ($self) = @_;\n  return $self->downstream_Exon->phase;\n}\n\n\n=head2 acceptor_splice_site \n\n  Title   : acceptor_splice_site \n  Usage   : $intron->acceptor_splice_site(21,3)\n  Function: returns the sequence corresponding to the \n            consensus acceptor splice site. If start and\n            end are provided, it will number of base pairs\n            left and right of the canonical AG. Here 21 means\n            21 bp into intron and 3 means 3 bp into the exon.\n            --Intron--21----|AG|-3-----Exon\n            Defaults to 21,3\n\n  Returns : Bio::Seq\n  Args    : start and end\n\n\nsub acceptor_splice_site {\n  my ($self,$ss_start,$ss_end) = @_;\n  $ss_start = 21 unless defined $ss_start;\n  $ss_end   = 3 unless defined $ss_end;\n  if($self->strand < 0){\n    my $tmp= $ss_start;\n    $ss_start = $ss_end;\n    $ss_end = $tmp;\n  }\n  my $intron_end= $self->location->end;\n  my $down_exon = $self->downstream_Exon;\n  my $acceptor;  \n  if($self->strand < 0){\n      $ss_start= $ss_start >  $down_exon->length ? $down_exon->length: $ss_start;\n      $ss_end= $ss_end > $self->length-2 ? $self->length-2 : $ss_end;\n      $acceptor = Bio::SeqFeature::Generic->new(-start=>$self->start - ($ss_start) ,  \n                                               -end=>$self->start + ($ss_end+1),\n                                               -strand=>$self->strand,    \n                                               -primary_tag=>\"donor splice site\");\n  } \n  else {\n    $ss_start = $ss_start > $self->length-2 ? $self->length-2 : $ss_start;\n    $ss_end = $ss_end > $down_exon->length ? $down_exon->length : $ss_end;\n \n\n    $acceptor = Bio::SeqFeature::Generic->new(-start=>$self->end - ($ss_start + 1),  \n                                               -end=>$self->end + $ss_end,\n                                               -strand=>$self->strand,    \n                                               -primary_tag=>\"donor splice site\");\n  }\n  $acceptor->attach_seq($self->entire_seq);\n\n  return $acceptor;\n\n}\n\n=head2 donor_splice_site \n\n  Title   : donor_splice_site \n  Usage   : $intron->donor_splice_site(3,6)\n  Function: returns the sequence corresponding to the \n            consensus donor splice site. If start and\n            end are provided, it will number of base pairs\n            left and right of the canonical GT. Here 3 means\n            3 bp into exon and 6 means 6 bp into the intron.\n            --Exon-3--|GT|-6----Intron-\n            Defaults to 3,6\n\n  Returns : Bio::Seq\n  Args    : start and end"},"line":225,"range":{"start":{"line":225,"character":0},"end":{"line":254,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$ss_start,$ss_end)","children":[{"line":226,"name":"$self","kind":13,"localvar":"my","containerName":"donor_splice_site","definition":"my"},{"name":"$ss_start","kind":13,"containerName":"donor_splice_site","line":226},{"line":226,"name":"$ss_end","kind":13,"containerName":"donor_splice_site"},{"name":"$ss_start","containerName":"donor_splice_site","kind":13,"line":227},{"line":227,"name":"$ss_start","containerName":"donor_splice_site","kind":13},{"kind":13,"containerName":"donor_splice_site","name":"$ss_end","line":228},{"line":228,"name":"$ss_end","containerName":"donor_splice_site","kind":13},{"line":229,"containerName":"donor_splice_site","kind":13,"name":"$self"},{"line":229,"containerName":"donor_splice_site","kind":12,"name":"strand"},{"definition":"my","line":230,"name":"$tmp","localvar":"my","containerName":"donor_splice_site","kind":13},{"containerName":"donor_splice_site","kind":13,"name":"$ss_start","line":230},{"line":231,"name":"$ss_start","kind":13,"containerName":"donor_splice_site"},{"name":"$ss_end","containerName":"donor_splice_site","kind":13,"line":231},{"kind":13,"containerName":"donor_splice_site","name":"$ss_end","line":232},{"line":232,"containerName":"donor_splice_site","kind":13,"name":"$tmp"},{"line":234,"name":"$up_exon","containerName":"donor_splice_site","localvar":"my","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"donor_splice_site","line":234},{"name":"upstream_Exon","containerName":"donor_splice_site","kind":12,"line":234},{"definition":"my","line":235,"localvar":"my","containerName":"donor_splice_site","kind":13,"name":"$donor"},{"line":236,"name":"$self","containerName":"donor_splice_site","kind":13},{"line":236,"name":"strand","kind":12,"containerName":"donor_splice_site"},{"name":"$ss_end","kind":13,"containerName":"donor_splice_site","line":237},{"line":237,"containerName":"donor_splice_site","kind":13,"name":"$ss_end"},{"line":237,"name":"$up_exon","containerName":"donor_splice_site","kind":13},{"line":237,"name":"length","containerName":"donor_splice_site","kind":12},{"name":"$up_exon","kind":13,"containerName":"donor_splice_site","line":237},{"name":"length","containerName":"donor_splice_site","kind":12,"line":237},{"kind":13,"containerName":"donor_splice_site","name":"$ss_end","line":237},{"line":238,"containerName":"donor_splice_site","kind":13,"name":"$ss_start"},{"line":238,"kind":13,"containerName":"donor_splice_site","name":"$ss_start"},{"kind":13,"containerName":"donor_splice_site","name":"$self","line":238},{"line":238,"name":"length","kind":12,"containerName":"donor_splice_site"},{"kind":13,"containerName":"donor_splice_site","name":"$self","line":238},{"line":238,"name":"length","containerName":"donor_splice_site","kind":12},{"line":238,"containerName":"donor_splice_site","kind":13,"name":"$ss_start"},{"line":239,"kind":13,"containerName":"donor_splice_site","name":"$donor"},{"line":239,"containerName":"donor_splice_site","kind":12,"name":"new"},{"name":"$self","kind":13,"containerName":"donor_splice_site","line":239},{"line":239,"name":"end","containerName":"donor_splice_site","kind":12},{"line":239,"name":"$ss_start","containerName":"donor_splice_site","kind":13},{"line":240,"name":"$self","containerName":"donor_splice_site","kind":13},{"line":240,"name":"end","kind":12,"containerName":"donor_splice_site"},{"kind":13,"containerName":"donor_splice_site","name":"$ss_end","line":240},{"name":"$self","containerName":"donor_splice_site","kind":13,"line":241},{"name":"strand","containerName":"donor_splice_site","kind":12,"line":241},{"line":245,"containerName":"donor_splice_site","kind":13,"name":"$ss_start"},{"line":245,"kind":13,"containerName":"donor_splice_site","name":"$ss_start"},{"line":245,"name":"$up_exon","containerName":"donor_splice_site","kind":13},{"line":245,"containerName":"donor_splice_site","kind":12,"name":"length"},{"line":245,"containerName":"donor_splice_site","kind":13,"name":"$up_exon"},{"line":245,"name":"length","kind":12,"containerName":"donor_splice_site"},{"line":245,"containerName":"donor_splice_site","kind":13,"name":"$ss_start"},{"kind":13,"containerName":"donor_splice_site","name":"$ss_end","line":246},{"name":"$ss_end","containerName":"donor_splice_site","kind":13,"line":246},{"kind":13,"containerName":"donor_splice_site","name":"$self","line":246},{"line":246,"containerName":"donor_splice_site","kind":12,"name":"length"},{"name":"$self","containerName":"donor_splice_site","kind":13,"line":246},{"name":"length","containerName":"donor_splice_site","kind":12,"line":246},{"line":246,"name":"$ss_end","kind":13,"containerName":"donor_splice_site"},{"line":247,"name":"$donor","containerName":"donor_splice_site","kind":13},{"name":"new","containerName":"donor_splice_site","kind":12,"line":247},{"name":"$self","containerName":"donor_splice_site","kind":13,"line":247},{"name":"start","containerName":"donor_splice_site","kind":12,"line":247},{"line":247,"name":"$ss_start","containerName":"donor_splice_site","kind":13},{"name":"$self","kind":13,"containerName":"donor_splice_site","line":248},{"name":"start","containerName":"donor_splice_site","kind":12,"line":248},{"name":"$ss_end","containerName":"donor_splice_site","kind":13,"line":248},{"name":"$self","containerName":"donor_splice_site","kind":13,"line":249},{"name":"strand","containerName":"donor_splice_site","kind":12,"line":249},{"containerName":"donor_splice_site","kind":13,"name":"$donor","line":252},{"line":252,"name":"attach_seq","containerName":"donor_splice_site","kind":12},{"line":252,"name":"$self","kind":13,"containerName":"donor_splice_site"},{"line":252,"name":"entire_seq","containerName":"donor_splice_site","kind":12},{"kind":13,"containerName":"donor_splice_site","name":"$donor","line":253}],"containerName":"main::","name":"donor_splice_site"},{"kind":12,"containerName":"SeqFeature::Generic","name":"Bio","line":239},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":247},{"detail":"($self)","definition":"sub","name":"location","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"location","name":"$self","line":257},{"line":259,"kind":13,"containerName":"location","name":"$self"},{"line":260,"name":"$loc","localvar":"my","kind":13,"containerName":"location","definition":"my"},{"name":"new","containerName":"location","kind":12,"line":260},{"definition":"my","line":262,"name":"$up_exon","localvar":"my","kind":13,"containerName":"location"},{"line":262,"name":"$self","kind":13,"containerName":"location"},{"containerName":"location","kind":12,"name":"upstream_Exon","line":262},{"line":263,"name":"$down_exon","kind":13,"localvar":"my","containerName":"location","definition":"my"},{"kind":13,"containerName":"location","name":"$self","line":263},{"kind":12,"containerName":"location","name":"downstream_Exon","line":263},{"name":"$up_seq","localvar":"my","containerName":"location","kind":13,"line":266,"definition":"my"},{"name":"$up_exon","kind":13,"containerName":"location","line":266},{"line":266,"kind":12,"containerName":"location","name":"entire_seq"},{"definition":"my","containerName":"location","localvar":"my","kind":13,"name":"$down_seq","line":267},{"name":"$down_exon","containerName":"location","kind":13,"line":267},{"line":267,"containerName":"location","kind":12,"name":"entire_seq"},{"line":268,"containerName":"location","kind":13,"name":"$up_seq"},{"name":"$down_seq","kind":13,"containerName":"location","line":268},{"line":269,"name":"$self","kind":13,"containerName":"location"},{"line":269,"containerName":"location","kind":12,"name":"throw"},{"line":273,"localvar":"my","containerName":"location","kind":13,"name":"$up_strand","definition":"my"},{"name":"$up_exon","kind":13,"containerName":"location","line":273},{"line":273,"containerName":"location","kind":12,"name":"strand"},{"kind":13,"localvar":"my","containerName":"location","name":"$down_strand","line":274,"definition":"my"},{"line":274,"kind":13,"containerName":"location","name":"$down_exon"},{"line":274,"kind":12,"containerName":"location","name":"strand"},{"line":275,"containerName":"location","kind":13,"name":"$up_strand"},{"line":275,"containerName":"location","kind":13,"name":"$down_strand"},{"line":276,"name":"$self","containerName":"location","kind":13},{"name":"throw","kind":12,"containerName":"location","line":276},{"name":"$loc","kind":13,"containerName":"location","line":279},{"containerName":"location","kind":12,"name":"strand","line":279},{"containerName":"location","kind":13,"name":"$up_strand","line":279},{"definition":"my","line":283,"localvar":"my","containerName":"location","kind":13,"name":"$exon_end"},{"kind":13,"containerName":"location","name":"$exon_start","line":283},{"containerName":"location","kind":13,"name":"$up_strand","line":284},{"line":285,"name":"$exon_end","kind":13,"containerName":"location"},{"line":285,"name":"$up_exon","kind":13,"containerName":"location"},{"line":285,"name":"end","kind":12,"containerName":"location"},{"containerName":"location","kind":13,"name":"$exon_start","line":286},{"containerName":"location","kind":13,"name":"$down_exon","line":286},{"line":286,"name":"start","containerName":"location","kind":12},{"kind":13,"containerName":"location","name":"$exon_end","line":288},{"line":288,"name":"$down_exon","kind":13,"containerName":"location"},{"line":288,"name":"end","containerName":"location","kind":12},{"name":"$exon_start","containerName":"location","kind":13,"line":289},{"line":289,"name":"$up_exon","kind":13,"containerName":"location"},{"line":289,"containerName":"location","kind":12,"name":"start"},{"containerName":"location","kind":13,"name":"$exon_end","line":291},{"line":291,"kind":13,"containerName":"location","name":"$exon_start"},{"line":292,"name":"$self","kind":13,"containerName":"location"},{"line":292,"name":"throw","containerName":"location","kind":12},{"line":294,"containerName":"location","kind":13,"name":"$loc"},{"line":294,"kind":12,"containerName":"location","name":"start"},{"name":"$exon_end","containerName":"location","kind":13,"line":294},{"containerName":"location","kind":13,"name":"$loc","line":295},{"kind":12,"containerName":"location","name":"end","line":295},{"name":"$exon_start","kind":13,"containerName":"location","line":295},{"line":298,"name":"$self","containerName":"location","kind":13},{"containerName":"location","kind":13,"name":"$loc","line":298},{"line":301,"name":"$self","containerName":"location","kind":13}],"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"location($self)"},"kind":12,"range":{"start":{"line":256,"character":0},"end":{"line":302,"character":9999}},"line":256},{"line":260,"name":"Bio","containerName":"Location::Simple","kind":12}]}