{"vars":[{"line":86,"name":"base","containerName":"","kind":2},{"name":"@valid_exon_types","kind":13,"localvar":"my","containerName":null,"line":91,"definition":"my"},{"children":[{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$caller","line":94},{"line":94,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"new","line":95},{"kind":13,"containerName":"new","name":"$caller","line":95},{"line":95,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","line":97,"localvar":"my","kind":13,"containerName":"new","name":"$is_coding"},{"kind":13,"containerName":"new","name":"$self","line":98},{"name":"_rearrange","containerName":"new","kind":12,"line":98},{"line":98,"name":"@args","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":99},{"name":"primary_tag","containerName":"new","kind":12,"line":99},{"name":"$self","kind":13,"containerName":"new","line":99},{"line":99,"name":"primary_tag","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":100},{"name":"is_coding","containerName":"new","kind":12,"line":100},{"name":"$is_coding","kind":13,"containerName":"new","line":100},{"kind":13,"containerName":"new","name":"$is_coding","line":100},{"containerName":"new","kind":13,"name":"$self","line":101},{"kind":12,"containerName":"new","name":"strand","line":101},{"name":"$self","containerName":"new","kind":13,"line":101},{"containerName":"new","kind":12,"name":"strand","line":101},{"containerName":"new","kind":13,"name":"$self","line":102}],"name":"new","containerName":"main::","definition":"sub","detail":"($caller,@args)","line":93,"kind":12,"range":{"start":{"line":93,"character":0},"end":{"character":9999,"line":103}},"signature":{"label":"new($caller,@args)","parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":""}},{"line":95,"kind":12,"containerName":"new","name":"SUPER"},{"detail":"($self,$val)","definition":"sub","containerName":"main::","name":"is_coding","children":[{"line":124,"localvar":"my","containerName":"is_coding","kind":13,"name":"$self","definition":"my"},{"line":124,"name":"$val","kind":13,"containerName":"is_coding"},{"containerName":"is_coding","kind":13,"name":"$val","line":126},{"containerName":"is_coding","kind":13,"name":"$self","line":127},{"line":127,"kind":13,"containerName":"is_coding","name":"$val"},{"name":"$self","containerName":"is_coding","kind":13,"line":129}],"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Exon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Exon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Exon - a feature representing an exon\n\n=head1 SYNOPSIS\n\n    # obtain an exon instance $exon somehow\n    print \"exon from \", $exon->start(), \" to \", $exon->end(),\n          \" on seq \", $exon->seq_id(), \", strand \", $exon->strand(),\n          \", encodes the peptide sequence \", \n          $exon->cds()->translate()->seq(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module implements a feature representing an exon by implementing\nthe Bio::SeqFeature::Gene::ExonI interface. By default an Exon is\ncoding. Supply -is_coding =E<gt> 0 to the constructor or call\n$exon-E<gt>is_coding(0) otherwise.\n\nApart from that, this class also implements Bio::SeqFeatureI by\ninheriting off Bio::SeqFeature::Generic.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::Exon;\nuse strict;\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::ExonI);\n\n#\n# A list of allowed exon types. See primary_tag().\n#\nmy @valid_exon_types = ('initial', 'internal', 'terminal');\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($is_coding) =\n\t$self->_rearrange([qw(IS_CODING)],@args);\n    $self->primary_tag('exon') unless $self->primary_tag();\n    $self->is_coding(defined($is_coding) ? $is_coding : 1);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 is_coding\n\n Title   : is_coding\n Usage   : if($exon->is_coding()) {\n                   # do something\n           }\n           if($is_utr) {\n               $exon->is_coding(0);\n           }\n Function: Get/set whether or not the exon codes for amino acid.\n Returns : TRUE if the object represents a feature translated into protein,\n           and FALSE otherwise.\n Args    : A boolean value on set.","label":"is_coding($self,$val)"},"kind":12,"range":{"end":{"line":130,"character":9999},"start":{"character":0,"line":123}},"line":123},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"location","name":"$self","line":190},{"name":"$value","containerName":"location","kind":13,"line":190},{"name":"$value","kind":13,"containerName":"location","line":192},{"name":"$value","containerName":"location","kind":13,"line":192},{"kind":12,"containerName":"location","name":"isa","line":192},{"kind":13,"containerName":"location","name":"$self","line":193},{"kind":12,"containerName":"location","name":"throw","line":193},{"line":194,"containerName":"location","kind":13,"name":"$self"},{"kind":13,"containerName":"location","name":"$self","line":196},{"line":196,"name":"$value","containerName":"location","kind":13}],"containerName":"main::","name":"location","definition":"sub","detail":"($self,$value)","line":189,"kind":12,"range":{"start":{"line":189,"character":0},"end":{"character":9999,"line":197}},"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Exon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Exon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Exon - a feature representing an exon\n\n=head1 SYNOPSIS\n\n    # obtain an exon instance $exon somehow\n    print \"exon from \", $exon->start(), \" to \", $exon->end(),\n          \" on seq \", $exon->seq_id(), \", strand \", $exon->strand(),\n          \", encodes the peptide sequence \", \n          $exon->cds()->translate()->seq(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module implements a feature representing an exon by implementing\nthe Bio::SeqFeature::Gene::ExonI interface. By default an Exon is\ncoding. Supply -is_coding =E<gt> 0 to the constructor or call\n$exon-E<gt>is_coding(0) otherwise.\n\nApart from that, this class also implements Bio::SeqFeatureI by\ninheriting off Bio::SeqFeature::Generic.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::Exon;\nuse strict;\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::ExonI);\n\n#\n# A list of allowed exon types. See primary_tag().\n#\nmy @valid_exon_types = ('initial', 'internal', 'terminal');\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($is_coding) =\n\t$self->_rearrange([qw(IS_CODING)],@args);\n    $self->primary_tag('exon') unless $self->primary_tag();\n    $self->is_coding(defined($is_coding) ? $is_coding : 1);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 is_coding\n\n Title   : is_coding\n Usage   : if($exon->is_coding()) {\n                   # do something\n           }\n           if($is_utr) {\n               $exon->is_coding(0);\n           }\n Function: Get/set whether or not the exon codes for amino acid.\n Returns : TRUE if the object represents a feature translated into protein,\n           and FALSE otherwise.\n Args    : A boolean value on set.\n\n\n\nsub is_coding {\n    my ($self,$val) = @_;\n\n    if(defined($val)) {\n\t$self->{'_iscoding'} = $val;\n    }\n    return $self->{'_iscoding'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: Get/set the primary tag for the exon feature.\n\n           This method is overridden here in order to allow only for\n           tag values following a certain convention. For consistency reasons,\n           the tag value must either contain the string 'exon' or the string\n           'utr' (both case-insensitive). In the case of 'exon', a string\n           describing the type of exon may be appended or prefixed. Presently,\n           the following types are allowed: initial, internal, and terminal\n           (all case-insensitive). \n\n           If the supplied tag value matches 'utr' (case-insensitive),\n           is_coding() will automatically be set to FALSE, and to TRUE\n           otherwise.\n\n Returns : A string.\n Args    : A string on set.\n\n\n\n# sub primary_tag {\n#    my ($self,$value) = @_;\n\n#    if(defined($value)) {\n#        if((lc($value) =~ /utr/i) || (lc($value) eq \"exon\") ||\n# \t  ((lc($value) =~ /exon/i) &&\n# \t   (grep { $value =~ /$_/i; } @valid_exon_types))) {\n# \t   $self->is_coding($value =~ /utr/i ? 0 : 1);\n#        } else {\n# \t   $self->throw(\"primary tag $value is invalid for object of class \".\n# \t\t\tref($self));\n#        }\n#    }\n#    return $self->SUPER::primary_tag($value);\n# }\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $exon->location()\n Function: Returns a location object suitable for identifying the location \n\t   of the exon on the sequence or parent feature.\n\n           This method is overridden here to restrict allowed location types\n           to non-compound locations.\n\n Returns : Bio::LocationI object\n Args    : none","label":"location($self,$value)"}},{"line":196,"kind":12,"containerName":"location","name":"SUPER"},{"containerName":"main::","name":"cds","children":[{"name":"$self","localvar":"my","containerName":"cds","kind":13,"line":221,"definition":"my"},{"name":"$self","containerName":"cds","kind":13,"line":224},{"kind":12,"containerName":"cds","name":"is_coding","line":224},{"line":226,"kind":13,"localvar":"my","containerName":"cds","name":"$seq","definition":"my"},{"containerName":"cds","kind":13,"name":"$self","line":226},{"line":226,"name":"seq","containerName":"cds","kind":12},{"line":227,"containerName":"cds","kind":13,"name":"$seq"},{"line":227,"kind":13,"containerName":"cds","name":"$self"},{"name":"frame","kind":12,"containerName":"cds","line":227},{"name":"$self","containerName":"cds","kind":13,"line":227},{"name":"frame","containerName":"cds","kind":12,"line":227},{"localvar":"my","kind":13,"containerName":"cds","name":"$prefix","line":228,"definition":"my"},{"name":"$self","kind":13,"containerName":"cds","line":228},{"name":"frame","kind":12,"containerName":"cds","line":228},{"containerName":"cds","kind":13,"name":"$seq","line":229},{"kind":12,"containerName":"cds","name":"seq","line":229},{"containerName":"cds","kind":13,"name":"$prefix","line":229},{"name":"$seq","kind":13,"containerName":"cds","line":229},{"line":229,"kind":12,"containerName":"cds","name":"seq"},{"containerName":"cds","kind":13,"name":"$seq","line":231}],"detail":"($self)","definition":"sub","range":{"start":{"line":220,"character":0},"end":{"line":232,"character":9999}},"kind":12,"line":220,"signature":{"label":"cds($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Exon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Exon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Exon - a feature representing an exon\n\n=head1 SYNOPSIS\n\n    # obtain an exon instance $exon somehow\n    print \"exon from \", $exon->start(), \" to \", $exon->end(),\n          \" on seq \", $exon->seq_id(), \", strand \", $exon->strand(),\n          \", encodes the peptide sequence \", \n          $exon->cds()->translate()->seq(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis module implements a feature representing an exon by implementing\nthe Bio::SeqFeature::Gene::ExonI interface. By default an Exon is\ncoding. Supply -is_coding =E<gt> 0 to the constructor or call\n$exon-E<gt>is_coding(0) otherwise.\n\nApart from that, this class also implements Bio::SeqFeatureI by\ninheriting off Bio::SeqFeature::Generic.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::Exon;\nuse strict;\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::ExonI);\n\n#\n# A list of allowed exon types. See primary_tag().\n#\nmy @valid_exon_types = ('initial', 'internal', 'terminal');\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($is_coding) =\n\t$self->_rearrange([qw(IS_CODING)],@args);\n    $self->primary_tag('exon') unless $self->primary_tag();\n    $self->is_coding(defined($is_coding) ? $is_coding : 1);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 is_coding\n\n Title   : is_coding\n Usage   : if($exon->is_coding()) {\n                   # do something\n           }\n           if($is_utr) {\n               $exon->is_coding(0);\n           }\n Function: Get/set whether or not the exon codes for amino acid.\n Returns : TRUE if the object represents a feature translated into protein,\n           and FALSE otherwise.\n Args    : A boolean value on set.\n\n\n\nsub is_coding {\n    my ($self,$val) = @_;\n\n    if(defined($val)) {\n\t$self->{'_iscoding'} = $val;\n    }\n    return $self->{'_iscoding'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: Get/set the primary tag for the exon feature.\n\n           This method is overridden here in order to allow only for\n           tag values following a certain convention. For consistency reasons,\n           the tag value must either contain the string 'exon' or the string\n           'utr' (both case-insensitive). In the case of 'exon', a string\n           describing the type of exon may be appended or prefixed. Presently,\n           the following types are allowed: initial, internal, and terminal\n           (all case-insensitive). \n\n           If the supplied tag value matches 'utr' (case-insensitive),\n           is_coding() will automatically be set to FALSE, and to TRUE\n           otherwise.\n\n Returns : A string.\n Args    : A string on set.\n\n\n\n# sub primary_tag {\n#    my ($self,$value) = @_;\n\n#    if(defined($value)) {\n#        if((lc($value) =~ /utr/i) || (lc($value) eq \"exon\") ||\n# \t  ((lc($value) =~ /exon/i) &&\n# \t   (grep { $value =~ /$_/i; } @valid_exon_types))) {\n# \t   $self->is_coding($value =~ /utr/i ? 0 : 1);\n#        } else {\n# \t   $self->throw(\"primary tag $value is invalid for object of class \".\n# \t\t\tref($self));\n#        }\n#    }\n#    return $self->SUPER::primary_tag($value);\n# }\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $exon->location()\n Function: Returns a location object suitable for identifying the location \n\t   of the exon on the sequence or parent feature.\n\n           This method is overridden here to restrict allowed location types\n           to non-compound locations.\n\n Returns : Bio::LocationI object\n Args    : none\n\n\n\nsub location {\n   my ($self,$value) = @_;  \n\n   if(defined($value) && $value->isa('Bio::Location::SplitLocationI')) {\n       $self->throw(\"split or compound location is not allowed \".\n\t\t    \"for an object of type \" . ref($self));\n   }\n   return $self->SUPER::location($value);\n}\n\n=head2 cds\n\n Title   : cds()\n Usage   : $cds = $exon->cds();\n Function: Get the coding sequence of the exon as a sequence object.\n\n           The sequence of the returned object is prefixed by Ns (lower case)\n           if the frame of the exon is defined and different from zero. The\n           result is that the first base starts a codon (frame 0).\n\n           This implementation returns undef if the particular exon is\n           not translated to protein, i.e., is_coding() returns FALSE. Undef\n           will also be returned if no sequence is attached to this exon\n           feature.\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : "}}],"version":5}