{"version":5,"vars":[{"kind":2,"containerName":"","name":"Storable","line":149},{"kind":2,"containerName":"","name":"base","line":151},{"definition":1,"containerName":"main::","kind":14,"name":"MAX_BIN","line":159},{"line":162,"name":"MIN_BIN","kind":14,"containerName":"main::","definition":1},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially","label":"new($class,@args)"},"line":185,"range":{"start":{"line":185,"character":0},"end":{"character":9999,"line":205}},"kind":12,"definition":"sub","detail":"($class,@args)","children":[{"line":186,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"name":"@args","kind":13,"containerName":"new","line":186},{"line":188,"name":"$self","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":188,"containerName":"new","kind":13,"name":"$class"},{"containerName":"new","kind":13,"name":"@args","line":188},{"definition":"my","line":189,"name":"$maxbin","localvar":"my","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$minbin","line":189},{"line":189,"name":"$file","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$keep","line":189},{"line":190,"name":"$features","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":190},{"line":190,"name":"_rearrange","containerName":"new","kind":12},{"line":191,"name":"@args","kind":13,"containerName":"new"},{"line":193,"containerName":"new","kind":13,"name":"$maxbin"},{"kind":13,"containerName":"new","name":"$self","line":193},{"name":"max_bin","kind":12,"containerName":"new","line":193},{"name":"$maxbin","containerName":"new","kind":13,"line":193},{"containerName":"new","kind":13,"name":"$minbin","line":194},{"name":"$self","containerName":"new","kind":13,"line":194},{"name":"min_bin","containerName":"new","kind":12,"line":194},{"line":194,"name":"$minbin","containerName":"new","kind":13},{"line":196,"containerName":"new","kind":13,"name":"$features"},{"name":"$self","containerName":"new","kind":13,"line":196},{"line":196,"name":"add_features","containerName":"new","kind":12},{"line":196,"kind":13,"containerName":"new","name":"$features"},{"line":197,"name":"$DB_BTREE","containerName":"new","kind":13},{"line":198,"name":"$DB_BTREE","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":199},{"name":"$file","containerName":"new","kind":13,"line":200},{"name":"$self","containerName":"new","kind":13,"line":201},{"name":"debug","containerName":"new","kind":12,"line":201},{"line":202,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"indexfile","line":202},{"kind":13,"containerName":"new","name":"$file","line":202},{"kind":13,"containerName":"new","name":"$self","line":204},{"line":204,"name":"keep","containerName":"new","kind":12},{"line":204,"name":"$keep","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":205},{"line":205,"name":"$self","containerName":"new","kind":13}],"containerName":"main::","name":"new"},{"line":188,"containerName":"new","kind":12,"name":"SUPER"},{"line":197,"kind":12,"name":"R_DUP"},{"kind":12,"name":"_compare","line":198},{"containerName":null,"kind":13,"name":"$self","line":206},{"name":"indexfile","containerName":"main::","kind":12,"line":206},{"name":"O_RDWR","kind":12,"line":206},{"name":"O_CREAT","kind":12,"line":206},{"line":206,"name":"$DB_BTREE","containerName":null,"kind":13},{"name":"%self","kind":13,"containerName":null,"line":207},{"line":207,"name":"$self","kind":13,"containerName":null},{"line":207,"containerName":"main::","kind":12,"name":"throw"},{"line":208,"name":"$self","kind":13,"containerName":null},{"detail":"($self,$feats)","definition":"sub","containerName":"main::","name":"add_features","children":[{"kind":13,"localvar":"my","containerName":"add_features","name":"$self","line":224,"definition":"my"},{"line":224,"name":"$feats","kind":13,"containerName":"add_features"},{"line":225,"containerName":"add_features","kind":13,"name":"$feats"},{"line":226,"kind":13,"containerName":"add_features","name":"$self"},{"name":"warn","kind":12,"containerName":"add_features","line":226},{"line":229,"name":"$count","kind":13,"localvar":"my","containerName":"add_features","definition":"my"},{"line":230,"containerName":"add_features","localvar":"my","kind":13,"name":"$f","definition":"my"},{"name":"$feats","containerName":"add_features","kind":13,"line":230},{"line":231,"name":"$f","containerName":"add_features","kind":13},{"line":231,"name":"$f","containerName":"add_features","kind":13},{"name":"$f","containerName":"add_features","kind":13,"line":231},{"line":231,"name":"isa","containerName":"add_features","kind":12},{"containerName":"add_features","kind":13,"name":"$self","line":232},{"line":232,"name":"warn","containerName":"add_features","kind":12},{"definition":"my","line":235,"name":"$bin","localvar":"my","containerName":"add_features","kind":13},{"line":235,"kind":13,"containerName":"add_features","name":"$f"},{"containerName":"add_features","kind":12,"name":"start","line":235},{"line":235,"containerName":"add_features","kind":13,"name":"$f"},{"kind":12,"containerName":"add_features","name":"end","line":235},{"line":235,"name":"$self","containerName":"add_features","kind":13},{"name":"min_bin","kind":12,"containerName":"add_features","line":235},{"definition":"my","name":"$serialized","containerName":"add_features","localvar":"my","kind":13,"line":236},{"line":236,"name":"$f","kind":13,"containerName":"add_features"},{"line":237,"name":"$self","containerName":"add_features","kind":13},{"containerName":"add_features","kind":12,"name":"put","line":237},{"line":237,"containerName":"add_features","kind":13,"name":"$bin"},{"line":237,"containerName":"add_features","kind":13,"name":"$serialized"},{"line":238,"kind":13,"containerName":"add_features","name":"$f"},{"line":238,"containerName":"add_features","kind":12,"name":"isa"},{"line":239,"name":"$self","kind":13,"containerName":"add_features"},{"line":239,"name":"debug","kind":12,"containerName":"add_features"},{"name":"$f","kind":13,"containerName":"add_features","line":239},{"name":"location","containerName":"add_features","kind":12,"line":239},{"name":"to_FTstring","kind":12,"containerName":"add_features","line":239},{"name":"$self","containerName":"add_features","kind":13,"line":239},{"line":241,"kind":13,"containerName":"add_features","name":"$count"}],"signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($maxbin,$minbin, $file, $keep,\n      $features) = $self->_rearrange([qw(MAXBIN MINBIN FILE KEEP\n\t\t\t\t\t FEATURES)],@args);\n\n  defined $maxbin && $self->max_bin($maxbin);\n  defined $minbin && $self->min_bin($minbin);\n\n  defined $features &&  $self->add_features($features);\n  $DB_BTREE->{'flags'} = R_DUP ;\n  $DB_BTREE->{'compare'} = \\&_compare;\n  $self->{'_btreehash'} = {};\n  if( $file ) {\n      $self->debug(\"using file $file\");\n      $self->indexfile($file);\n  }\n  $self->keep($keep);\n  $self->{'_btree'} = tie %{$self->{'_btreehash'}},\n  'DB_File', $self->indexfile, O_RDWR|O_CREAT, 0640, $DB_BTREE;\n  $self->{'_btree'} || $self->throw(\"Unable to tie DB_File handle\");\n  return $self;\n}\n\n\n=head2 add_features\n\n Title   : add_features\n Usage   : $collection->add_features(\\@features);\n Function:\n Returns : number of features added\n Args    : arrayref of Bio::SeqFeatureI objects to index","parameters":[{"label":"$self"},{"label":"$feats"}],"label":"add_features($self,$feats)"},"kind":12,"range":{"end":{"line":242,"character":9999},"start":{"character":0,"line":223}},"line":223},{"name":"bin","kind":12,"line":235},{"line":236,"kind":12,"name":"feature_freeze"},{"containerName":null,"kind":13,"name":"$count","line":243},{"signature":{"label":"features_in_range(@args)","parameters":[{"label":"@args"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($maxbin,$minbin, $file, $keep,\n      $features) = $self->_rearrange([qw(MAXBIN MINBIN FILE KEEP\n\t\t\t\t\t FEATURES)],@args);\n\n  defined $maxbin && $self->max_bin($maxbin);\n  defined $minbin && $self->min_bin($minbin);\n\n  defined $features &&  $self->add_features($features);\n  $DB_BTREE->{'flags'} = R_DUP ;\n  $DB_BTREE->{'compare'} = \\&_compare;\n  $self->{'_btreehash'} = {};\n  if( $file ) {\n      $self->debug(\"using file $file\");\n      $self->indexfile($file);\n  }\n  $self->keep($keep);\n  $self->{'_btree'} = tie %{$self->{'_btreehash'}},\n  'DB_File', $self->indexfile, O_RDWR|O_CREAT, 0640, $DB_BTREE;\n  $self->{'_btree'} || $self->throw(\"Unable to tie DB_File handle\");\n  return $self;\n}\n\n\n=head2 add_features\n\n Title   : add_features\n Usage   : $collection->add_features(\\@features);\n Function:\n Returns : number of features added\n Args    : arrayref of Bio::SeqFeatureI objects to index\n\n\n\nsub add_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to add_features\");\n       return 0;\n   }\n   my $count = 0;\n   foreach my $f ( @$feats ) {\n       if( ! $f || ! ref($f) || ! $f->isa('Bio::RangeI') ) {\n\t   $self->warn(\"Must provide valid Bio::RangeI objects to add_features, skipping object '$f'\\n\");\n\t   next;\n       }\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my $serialized = &feature_freeze($f);\n       $self->{'_btree'}->put($bin,$serialized);\n       if( $f->isa('Bio::SeqFeature::Generic') ) {\n\t   $self->debug( \"$bin for \". $f->location->to_FTstring(). \" matches \".$#{$self->{'_features'}}. \"\\n\");\n       }\n       $count++;\n   }\n   return $count;\n}\n\n\n=head2 features_in_range\n\n Title   : features_in_range\n Usage   : my @features = $collection->features_in_range($range)\n Function: Retrieves a list of features which were contained or overlap the\n           the requested range (see Args for way to specify overlap or\n\t\t\t\tonly those containe)d\n Returns : List of Bio::SeqFeatureI objects\n Args    : -range => Bio::RangeI object defining range to search,\n           OR\n           -start  => start,\n           -end    => end,\n           -strand  => strand\n\n           -contain => boolean - true if feature must be completely\n                       contained with range\n                       OR false if should include features that simply overlap\n                       the range. Default: true.\n           -strandmatch =>  'strong',  ranges must have the same strand\n                            'weak',    ranges must have the same\n                                           strand or no strand\n                            'ignore', ignore strand information\n                           Default. 'ignore'."},"line":273,"kind":12,"range":{"start":{"character":0,"line":273},"end":{"line":346,"character":9999}},"definition":"sub","detail":"(@args)","children":[{"definition":"my","line":274,"name":"$self","localvar":"my","containerName":"features_in_range","kind":13},{"definition":"my","line":275,"localvar":"my","kind":13,"containerName":"features_in_range","name":"@args"},{"name":"$range","localvar":"my","kind":13,"containerName":"features_in_range","line":276,"definition":"my"},{"containerName":"features_in_range","kind":13,"name":"$contain","line":276},{"line":276,"name":"$strandmatch","containerName":"features_in_range","kind":13},{"line":276,"name":"$start","kind":13,"containerName":"features_in_range"},{"line":276,"containerName":"features_in_range","kind":13,"name":"$end"},{"line":276,"name":"$strand","kind":13,"containerName":"features_in_range"},{"kind":13,"containerName":"features_in_range","name":"@args","line":277},{"containerName":"features_in_range","kind":13,"name":"$range","line":278},{"line":278,"name":"@args","kind":13,"containerName":"features_in_range"},{"line":280,"name":"$start","containerName":"features_in_range","kind":13},{"line":280,"containerName":"features_in_range","kind":13,"name":"$end"},{"line":280,"kind":13,"containerName":"features_in_range","name":"$strand"},{"line":280,"containerName":"features_in_range","kind":13,"name":"$range"},{"name":"$contain","kind":13,"containerName":"features_in_range","line":281},{"name":"$strandmatch","containerName":"features_in_range","kind":13,"line":281},{"line":281,"kind":13,"containerName":"features_in_range","name":"$self"},{"kind":12,"containerName":"features_in_range","name":"_rearrange","line":281},{"line":285,"name":"@args","kind":13,"containerName":"features_in_range"},{"line":286,"kind":13,"containerName":"features_in_range","name":"$contain"},{"containerName":"features_in_range","kind":13,"name":"$contain","line":286},{"name":"$strand","kind":13,"containerName":"features_in_range","line":288},{"containerName":"features_in_range","kind":13,"name":"$strand","line":288},{"name":"$strand","containerName":"features_in_range","kind":13,"line":289},{"line":290,"name":"$strand","containerName":"features_in_range","kind":13},{"line":291,"name":"$self","containerName":"features_in_range","kind":13},{"line":291,"name":"warn","containerName":"features_in_range","kind":12},{"line":294,"containerName":"features_in_range","kind":13,"name":"$strand"},{"line":296,"name":"$start","kind":13,"containerName":"features_in_range"},{"line":296,"name":"$end","containerName":"features_in_range","kind":13},{"line":297,"containerName":"features_in_range","kind":13,"name":"$range"},{"kind":13,"containerName":"features_in_range","name":"$range","line":297},{"name":"$range","kind":13,"containerName":"features_in_range","line":297},{"line":297,"name":"isa","kind":12,"containerName":"features_in_range"},{"name":"$self","kind":13,"containerName":"features_in_range","line":299},{"line":299,"name":"warn","kind":12,"containerName":"features_in_range"},{"line":302,"containerName":"features_in_range","kind":13,"name":"$start"},{"line":302,"kind":13,"containerName":"features_in_range","name":"$end"},{"line":302,"name":"$strand","kind":13,"containerName":"features_in_range"},{"line":302,"containerName":"features_in_range","kind":13,"name":"$range"},{"kind":12,"containerName":"features_in_range","name":"start","line":302},{"line":302,"name":"$range","kind":13,"containerName":"features_in_range"},{"line":302,"name":"end","kind":12,"containerName":"features_in_range"},{"line":302,"containerName":"features_in_range","kind":13,"name":"$range"},{"name":"strand","kind":12,"containerName":"features_in_range","line":302},{"definition":"my","line":304,"localvar":"my","containerName":"features_in_range","kind":13,"name":"$r"},{"name":"new","containerName":"features_in_range","kind":12,"line":304},{"line":304,"name":"$start","kind":13,"containerName":"features_in_range"},{"name":"$end","kind":13,"containerName":"features_in_range","line":305},{"containerName":"features_in_range","kind":13,"name":"$strand","line":306},{"definition":"my","line":308,"localvar":"my","kind":13,"containerName":"features_in_range","name":"@features"},{"localvar":"my","kind":13,"containerName":"features_in_range","name":"$maxbin","line":309,"definition":"my"},{"line":309,"containerName":"features_in_range","kind":13,"name":"$self"},{"line":309,"kind":12,"containerName":"features_in_range","name":"max_bin"},{"definition":"my","line":310,"localvar":"my","kind":13,"containerName":"features_in_range","name":"$minbin"},{"name":"$self","kind":13,"containerName":"features_in_range","line":310},{"name":"min_bin","containerName":"features_in_range","kind":12,"line":310},{"name":"$tier","localvar":"my","containerName":"features_in_range","kind":13,"line":311,"definition":"my"},{"kind":13,"containerName":"features_in_range","name":"$maxbin","line":311},{"line":312,"localvar":"my","containerName":"features_in_range","kind":13,"name":"$k","definition":"my"},{"name":"$v","containerName":"features_in_range","kind":13,"line":312},{"line":312,"kind":13,"containerName":"features_in_range","name":"@bins"},{"line":313,"containerName":"features_in_range","kind":13,"name":"$tier"},{"line":313,"kind":13,"containerName":"features_in_range","name":"$minbin"},{"line":314,"localvar":"my","kind":13,"containerName":"features_in_range","name":"$tier_start","definition":"my"},{"line":314,"kind":13,"containerName":"features_in_range","name":"$tier_stop"},{"line":314,"name":"$tier","containerName":"features_in_range","kind":13},{"line":314,"name":"$start","containerName":"features_in_range","kind":13},{"line":315,"kind":13,"containerName":"features_in_range","name":"$tier"},{"containerName":"features_in_range","kind":13,"name":"$end","line":315},{"line":316,"kind":13,"containerName":"features_in_range","name":"$tier_start"},{"containerName":"features_in_range","kind":13,"name":"$tier_stop","line":316},{"name":"@vals","kind":13,"localvar":"my","containerName":"features_in_range","line":317,"definition":"my"},{"name":"$self","kind":13,"containerName":"features_in_range","line":317},{"line":317,"kind":12,"containerName":"features_in_range","name":"get_dup"},{"name":"$tier_start","containerName":"features_in_range","kind":13,"line":317},{"line":318,"kind":13,"containerName":"features_in_range","name":"@vals"},{"containerName":"features_in_range","kind":13,"name":"@bins","line":319},{"name":"@vals","containerName":"features_in_range","kind":13,"line":319},{"line":322,"name":"$k","containerName":"features_in_range","kind":13},{"containerName":"features_in_range","kind":13,"name":"$tier_start","line":322},{"definition":"my","line":323,"localvar":"my","containerName":"features_in_range","kind":13,"name":"@vals"},{"definition":"my","name":"$rc","localvar":"my","kind":13,"containerName":"features_in_range","line":324},{"name":"$self","containerName":"features_in_range","kind":13,"line":324},{"name":"seq","kind":12,"containerName":"features_in_range","line":324},{"name":"$k","kind":13,"containerName":"features_in_range","line":324},{"kind":13,"containerName":"features_in_range","name":"$v","line":324},{"name":"$rc","kind":13,"containerName":"features_in_range","line":325},{"line":326,"kind":13,"containerName":"features_in_range","name":"$rc"},{"line":326,"name":"$self","containerName":"features_in_range","kind":13},{"line":326,"name":"seq","kind":12,"containerName":"features_in_range"},{"line":326,"name":"$k","kind":13,"containerName":"features_in_range"},{"line":326,"containerName":"features_in_range","kind":13,"name":"$v"},{"name":"$k","kind":13,"containerName":"features_in_range","line":327},{"line":327,"kind":13,"containerName":"features_in_range","name":"$tier_stop"},{"kind":13,"containerName":"features_in_range","name":"$k","line":327},{"line":327,"containerName":"features_in_range","kind":13,"name":"$tier_start"},{"line":328,"name":"@bins","kind":13,"containerName":"features_in_range"},{"containerName":"features_in_range","kind":13,"name":"$v","line":328},{"containerName":"features_in_range","kind":13,"name":"$tier","line":331},{"line":333,"name":"%seen","localvar":"my","containerName":"features_in_range","kind":13,"definition":"my"},{"name":"$t","kind":13,"localvar":"my","containerName":"features_in_range","line":334,"definition":"my"},{"name":"@bins","containerName":"features_in_range","kind":13,"line":334},{"line":335,"name":"$seen","kind":13,"containerName":"features_in_range"},{"containerName":"features_in_range","kind":13,"name":"$t","line":335},{"kind":13,"containerName":"features_in_range","name":"$self","line":339},{"line":339,"containerName":"features_in_range","kind":12,"name":"warn"},{"line":343,"name":"$strandmatch","containerName":"features_in_range","kind":13},{"name":"$strandmatch","kind":13,"containerName":"features_in_range","line":343},{"kind":13,"containerName":"features_in_range","name":"$contain","line":344},{"containerName":"features_in_range","kind":13,"name":"$r","line":344},{"name":"contains","kind":12,"containerName":"features_in_range","line":344},{"line":344,"containerName":"features_in_range","kind":13,"name":"$strandmatch"},{"containerName":"features_in_range","kind":13,"name":"@bins","line":344},{"line":345,"name":"$r","containerName":"features_in_range","kind":13},{"line":345,"kind":12,"containerName":"features_in_range","name":"overlaps"},{"line":345,"name":"$strandmatch","containerName":"features_in_range","kind":13},{"containerName":"features_in_range","kind":13,"name":"@bins","line":345}],"containerName":"main::","name":"features_in_range"},{"line":304,"name":"Bio","containerName":"Location::Simple","kind":12},{"line":314,"name":"bin_bot","kind":12},{"line":315,"kind":12,"name":"bin_top"},{"name":"thaw","kind":12,"line":319},{"line":324,"name":"R_CURSOR","kind":12},{"line":326,"name":"R_NEXT","kind":12},{"line":328,"name":"thaw","kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"$feats"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($maxbin,$minbin, $file, $keep,\n      $features) = $self->_rearrange([qw(MAXBIN MINBIN FILE KEEP\n\t\t\t\t\t FEATURES)],@args);\n\n  defined $maxbin && $self->max_bin($maxbin);\n  defined $minbin && $self->min_bin($minbin);\n\n  defined $features &&  $self->add_features($features);\n  $DB_BTREE->{'flags'} = R_DUP ;\n  $DB_BTREE->{'compare'} = \\&_compare;\n  $self->{'_btreehash'} = {};\n  if( $file ) {\n      $self->debug(\"using file $file\");\n      $self->indexfile($file);\n  }\n  $self->keep($keep);\n  $self->{'_btree'} = tie %{$self->{'_btreehash'}},\n  'DB_File', $self->indexfile, O_RDWR|O_CREAT, 0640, $DB_BTREE;\n  $self->{'_btree'} || $self->throw(\"Unable to tie DB_File handle\");\n  return $self;\n}\n\n\n=head2 add_features\n\n Title   : add_features\n Usage   : $collection->add_features(\\@features);\n Function:\n Returns : number of features added\n Args    : arrayref of Bio::SeqFeatureI objects to index\n\n\n\nsub add_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to add_features\");\n       return 0;\n   }\n   my $count = 0;\n   foreach my $f ( @$feats ) {\n       if( ! $f || ! ref($f) || ! $f->isa('Bio::RangeI') ) {\n\t   $self->warn(\"Must provide valid Bio::RangeI objects to add_features, skipping object '$f'\\n\");\n\t   next;\n       }\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my $serialized = &feature_freeze($f);\n       $self->{'_btree'}->put($bin,$serialized);\n       if( $f->isa('Bio::SeqFeature::Generic') ) {\n\t   $self->debug( \"$bin for \". $f->location->to_FTstring(). \" matches \".$#{$self->{'_features'}}. \"\\n\");\n       }\n       $count++;\n   }\n   return $count;\n}\n\n\n=head2 features_in_range\n\n Title   : features_in_range\n Usage   : my @features = $collection->features_in_range($range)\n Function: Retrieves a list of features which were contained or overlap the\n           the requested range (see Args for way to specify overlap or\n\t\t\t\tonly those containe)d\n Returns : List of Bio::SeqFeatureI objects\n Args    : -range => Bio::RangeI object defining range to search,\n           OR\n           -start  => start,\n           -end    => end,\n           -strand  => strand\n\n           -contain => boolean - true if feature must be completely\n                       contained with range\n                       OR false if should include features that simply overlap\n                       the range. Default: true.\n           -strandmatch =>  'strong',  ranges must have the same strand\n                            'weak',    ranges must have the same\n                                           strand or no strand\n                            'ignore', ignore strand information\n                           Default. 'ignore'.\n\n\nsub features_in_range{\n   my $self = shift;\n   my (@args) = @_;\n   my ($range, $contain, $strandmatch,$start,$end,$strand);\n   if( @args == 1 ) {\n       $range = shift @args;\n   } else {\n       ($start,$end,$strand,$range,\n\t$contain,$strandmatch) = $self->_rearrange([qw(START END\n\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t       RANGE CONTAIN\n\t\t\t\t\t\t       STRANDMATCH)],\n\t\t\t\t\t\t   @args);\n       $contain = 1 unless defined $contain;\n   }\n   $strand = 1 unless defined $strand;\n   if( $strand !~ /^([\\-\\+])$/ &&\n       $strand !~ /^[\\-\\+]?1$/ ) {\n       $self->warn(\"must provide a valid numeric or +/- for strand\");\n       return ();\n   }\n   if( defined $1 ) { $strand .= 1; }\n\n   if( !defined $start && !defined $end ) {\n       if( ! defined $range || !ref($range) || ! $range->isa(\"Bio::RangeI\") )\n       {\n\t   $self->warn(\"Must defined a valid Range for the method feature_in_range\");\n\t   return ();\n       }\n       ($start,$end,$strand) = ($range->start,$range->end,$range->strand);\n   }\n   my $r = Bio::Location::Simple->new(-start => $start,\n\t\t\t\t     -end   => $end,\n\t\t\t\t     -strand => $strand);\n\n   my @features;\n   my $maxbin = $self->max_bin;\n   my $minbin = $self->min_bin;\n   my $tier = $maxbin;\n   my ($k,$v,@bins) = (\"\",undef);\n   while ($tier >= $minbin) {\n\tmy ($tier_start,$tier_stop) = (bin_bot($tier,$start),\n\t\t\t\t       bin_top($tier,$end));\n       if( $tier_start == $tier_stop ) {\n\t   my @vals = $self->{'_btree'}->get_dup($tier_start);\n\t   if( scalar @vals > 0 ) {\n\t       push @bins, map { thaw($_) } @vals;\n\t   }\n       } else {\t\n\t   $k = $tier_start;\n\t   my @vals;\n\t   for( my $rc = $self->{'_btree'}->seq($k,$v,R_CURSOR);\n\t        $rc == 0;\n\t        $rc = $self->{'_btree'}->seq($k,$v, R_NEXT) ) {\n\t       last if( $k > $tier_stop || $k < $tier_start);\n\t       push @bins, thaw($v);\n\t   }\n       }\n       $tier /= 10;\n   }\n   my %seen = ();\n   foreach my $t ( map { ref($_) } @bins) {\n       next if $seen{$t}++;\n       eval \"require $t\";\n\n       if( $@ ) {\n\t   $self->warn(\"Trying to thaw a stored feature $t which does not appear in your Perl library. $@\");\n\t   next;\n       }\n   }\n   $strandmatch = 'ignore' unless defined $strandmatch;\n   return ( $contain ) ? grep { $r->contains($_,$strandmatch) } @bins :\n       grep { $r->overlaps($_,$strandmatch)} @bins;\n}\n\n=head2 remove_features\n\n Title   : remove_features\n Usage   : $collection->remove_features(\\@array)\n Function: Removes the requested sequence features (based on features\n\t   which have the same location)\n Returns : Number of features removed\n Args    : Arrayref of Bio::RangeI objects","label":"remove_features($self,$feats)"},"kind":12,"range":{"end":{"line":389,"character":9999},"start":{"line":360,"character":0}},"line":360,"detail":"($self,$feats)","definition":"sub","containerName":"main::","name":"remove_features","children":[{"name":"$self","containerName":"remove_features","localvar":"my","kind":13,"line":361,"definition":"my"},{"name":"$feats","kind":13,"containerName":"remove_features","line":361},{"line":362,"name":"$feats","kind":13,"containerName":"remove_features"},{"line":363,"containerName":"remove_features","kind":13,"name":"$self"},{"name":"warn","kind":12,"containerName":"remove_features","line":363},{"line":366,"containerName":"remove_features","localvar":"my","kind":13,"name":"$countprocessed","definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"remove_features","name":"$f","line":368},{"name":"$feats","kind":13,"containerName":"remove_features","line":368},{"name":"$f","containerName":"remove_features","kind":13,"line":369},{"name":"$f","kind":13,"containerName":"remove_features","line":369},{"line":369,"containerName":"remove_features","kind":12,"name":"isa"},{"definition":"my","line":370,"name":"$bin","localvar":"my","containerName":"remove_features","kind":13},{"name":"$f","containerName":"remove_features","kind":13,"line":370},{"containerName":"remove_features","kind":12,"name":"start","line":370},{"line":370,"containerName":"remove_features","kind":13,"name":"$f"},{"line":370,"name":"end","kind":12,"containerName":"remove_features"},{"containerName":"remove_features","kind":13,"name":"$self","line":370},{"name":"min_bin","containerName":"remove_features","kind":12,"line":370},{"definition":"my","name":"@vals","kind":13,"localvar":"my","containerName":"remove_features","line":371},{"name":"$self","kind":13,"containerName":"remove_features","line":371},{"kind":12,"containerName":"remove_features","name":"get_dup","line":371},{"line":371,"kind":13,"containerName":"remove_features","name":"$bin"},{"containerName":"remove_features","localvar":"my","kind":13,"name":"$vcount","line":372,"definition":"my"},{"kind":13,"containerName":"remove_features","name":"@vals","line":372},{"definition":"my","line":374,"name":"$v","localvar":"my","kind":13,"containerName":"remove_features"},{"line":374,"name":"@vals","kind":13,"containerName":"remove_features"},{"name":"$v","containerName":"remove_features","kind":13,"line":377},{"line":377,"kind":13,"containerName":"remove_features","name":"$f"},{"containerName":"remove_features","kind":13,"name":"$self","line":378},{"line":378,"name":"del_dup","containerName":"remove_features","kind":12},{"line":378,"containerName":"remove_features","kind":13,"name":"$bin"},{"line":378,"containerName":"remove_features","kind":13,"name":"$v"},{"containerName":"remove_features","kind":13,"name":"$vcount","line":379},{"name":"$countprocessed","containerName":"remove_features","kind":13,"line":380},{"line":383,"kind":13,"containerName":"remove_features","name":"$vcount"},{"name":"$self","containerName":"remove_features","kind":13,"line":384},{"kind":12,"containerName":"remove_features","name":"del","line":384},{"line":384,"containerName":"remove_features","kind":13,"name":"$bin"},{"line":387,"containerName":"remove_features","kind":13,"name":"$countprocessed"}]},{"name":"bin","kind":12,"line":370},{"name":"feature_freeze","kind":12,"line":377},{"children":[{"definition":"my","line":403,"name":"$self","kind":13,"localvar":"my","containerName":"get_all_features"},{"definition":"my","line":404,"kind":13,"localvar":"my","containerName":"get_all_features","name":"@features"},{"definition":"my","line":405,"localvar":"my","kind":13,"containerName":"get_all_features","name":"$key"},{"line":405,"kind":13,"containerName":"get_all_features","name":"$value"},{"definition":"my","name":"$status","localvar":"my","kind":13,"containerName":"get_all_features","line":406},{"name":"$self","containerName":"get_all_features","kind":13,"line":406},{"line":406,"containerName":"get_all_features","kind":12,"name":"seq"},{"line":406,"name":"$key","kind":13,"containerName":"get_all_features"},{"line":406,"containerName":"get_all_features","kind":13,"name":"$value"},{"line":407,"containerName":"get_all_features","kind":13,"name":"$status"},{"name":"$status","containerName":"get_all_features","kind":13,"line":408},{"name":"$self","kind":13,"containerName":"get_all_features","line":408},{"name":"seq","containerName":"get_all_features","kind":12,"line":408},{"name":"$key","kind":13,"containerName":"get_all_features","line":408},{"line":408,"name":"$value","containerName":"get_all_features","kind":13},{"line":409,"name":"$value","kind":13,"containerName":"get_all_features"},{"line":410,"kind":13,"containerName":"get_all_features","name":"@features"},{"name":"$value","kind":13,"containerName":"get_all_features","line":410},{"line":412,"kind":13,"containerName":"get_all_features","name":"@features"},{"containerName":"get_all_features","kind":13,"name":"$self","line":412},{"line":412,"name":"feature_count","kind":12,"containerName":"get_all_features"},{"line":413,"name":"$self","containerName":"get_all_features","kind":13},{"name":"warn","containerName":"get_all_features","kind":12,"line":413},{"containerName":"get_all_features","kind":13,"name":"@features","line":415}],"containerName":"main::","name":"get_all_features","definition":"sub","detail":"($self)","line":402,"range":{"start":{"character":0,"line":402},"end":{"line":416,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($maxbin,$minbin, $file, $keep,\n      $features) = $self->_rearrange([qw(MAXBIN MINBIN FILE KEEP\n\t\t\t\t\t FEATURES)],@args);\n\n  defined $maxbin && $self->max_bin($maxbin);\n  defined $minbin && $self->min_bin($minbin);\n\n  defined $features &&  $self->add_features($features);\n  $DB_BTREE->{'flags'} = R_DUP ;\n  $DB_BTREE->{'compare'} = \\&_compare;\n  $self->{'_btreehash'} = {};\n  if( $file ) {\n      $self->debug(\"using file $file\");\n      $self->indexfile($file);\n  }\n  $self->keep($keep);\n  $self->{'_btree'} = tie %{$self->{'_btreehash'}},\n  'DB_File', $self->indexfile, O_RDWR|O_CREAT, 0640, $DB_BTREE;\n  $self->{'_btree'} || $self->throw(\"Unable to tie DB_File handle\");\n  return $self;\n}\n\n\n=head2 add_features\n\n Title   : add_features\n Usage   : $collection->add_features(\\@features);\n Function:\n Returns : number of features added\n Args    : arrayref of Bio::SeqFeatureI objects to index\n\n\n\nsub add_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to add_features\");\n       return 0;\n   }\n   my $count = 0;\n   foreach my $f ( @$feats ) {\n       if( ! $f || ! ref($f) || ! $f->isa('Bio::RangeI') ) {\n\t   $self->warn(\"Must provide valid Bio::RangeI objects to add_features, skipping object '$f'\\n\");\n\t   next;\n       }\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my $serialized = &feature_freeze($f);\n       $self->{'_btree'}->put($bin,$serialized);\n       if( $f->isa('Bio::SeqFeature::Generic') ) {\n\t   $self->debug( \"$bin for \". $f->location->to_FTstring(). \" matches \".$#{$self->{'_features'}}. \"\\n\");\n       }\n       $count++;\n   }\n   return $count;\n}\n\n\n=head2 features_in_range\n\n Title   : features_in_range\n Usage   : my @features = $collection->features_in_range($range)\n Function: Retrieves a list of features which were contained or overlap the\n           the requested range (see Args for way to specify overlap or\n\t\t\t\tonly those containe)d\n Returns : List of Bio::SeqFeatureI objects\n Args    : -range => Bio::RangeI object defining range to search,\n           OR\n           -start  => start,\n           -end    => end,\n           -strand  => strand\n\n           -contain => boolean - true if feature must be completely\n                       contained with range\n                       OR false if should include features that simply overlap\n                       the range. Default: true.\n           -strandmatch =>  'strong',  ranges must have the same strand\n                            'weak',    ranges must have the same\n                                           strand or no strand\n                            'ignore', ignore strand information\n                           Default. 'ignore'.\n\n\nsub features_in_range{\n   my $self = shift;\n   my (@args) = @_;\n   my ($range, $contain, $strandmatch,$start,$end,$strand);\n   if( @args == 1 ) {\n       $range = shift @args;\n   } else {\n       ($start,$end,$strand,$range,\n\t$contain,$strandmatch) = $self->_rearrange([qw(START END\n\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t       RANGE CONTAIN\n\t\t\t\t\t\t       STRANDMATCH)],\n\t\t\t\t\t\t   @args);\n       $contain = 1 unless defined $contain;\n   }\n   $strand = 1 unless defined $strand;\n   if( $strand !~ /^([\\-\\+])$/ &&\n       $strand !~ /^[\\-\\+]?1$/ ) {\n       $self->warn(\"must provide a valid numeric or +/- for strand\");\n       return ();\n   }\n   if( defined $1 ) { $strand .= 1; }\n\n   if( !defined $start && !defined $end ) {\n       if( ! defined $range || !ref($range) || ! $range->isa(\"Bio::RangeI\") )\n       {\n\t   $self->warn(\"Must defined a valid Range for the method feature_in_range\");\n\t   return ();\n       }\n       ($start,$end,$strand) = ($range->start,$range->end,$range->strand);\n   }\n   my $r = Bio::Location::Simple->new(-start => $start,\n\t\t\t\t     -end   => $end,\n\t\t\t\t     -strand => $strand);\n\n   my @features;\n   my $maxbin = $self->max_bin;\n   my $minbin = $self->min_bin;\n   my $tier = $maxbin;\n   my ($k,$v,@bins) = (\"\",undef);\n   while ($tier >= $minbin) {\n\tmy ($tier_start,$tier_stop) = (bin_bot($tier,$start),\n\t\t\t\t       bin_top($tier,$end));\n       if( $tier_start == $tier_stop ) {\n\t   my @vals = $self->{'_btree'}->get_dup($tier_start);\n\t   if( scalar @vals > 0 ) {\n\t       push @bins, map { thaw($_) } @vals;\n\t   }\n       } else {\t\n\t   $k = $tier_start;\n\t   my @vals;\n\t   for( my $rc = $self->{'_btree'}->seq($k,$v,R_CURSOR);\n\t        $rc == 0;\n\t        $rc = $self->{'_btree'}->seq($k,$v, R_NEXT) ) {\n\t       last if( $k > $tier_stop || $k < $tier_start);\n\t       push @bins, thaw($v);\n\t   }\n       }\n       $tier /= 10;\n   }\n   my %seen = ();\n   foreach my $t ( map { ref($_) } @bins) {\n       next if $seen{$t}++;\n       eval \"require $t\";\n\n       if( $@ ) {\n\t   $self->warn(\"Trying to thaw a stored feature $t which does not appear in your Perl library. $@\");\n\t   next;\n       }\n   }\n   $strandmatch = 'ignore' unless defined $strandmatch;\n   return ( $contain ) ? grep { $r->contains($_,$strandmatch) } @bins :\n       grep { $r->overlaps($_,$strandmatch)} @bins;\n}\n\n=head2 remove_features\n\n Title   : remove_features\n Usage   : $collection->remove_features(\\@array)\n Function: Removes the requested sequence features (based on features\n\t   which have the same location)\n Returns : Number of features removed\n Args    : Arrayref of Bio::RangeI objects\n\n\n\nsub remove_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to remove_features\");\n       return 0;\n   }\n   my $countprocessed = 0;\n\n   foreach my $f ( @$feats ) {\n       next if ! ref($f) || ! $f->isa('Bio::RangeI');\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my @vals = $self->{'_btree'}->get_dup($bin);\n       my $vcount = scalar @vals;\n\n       foreach my $v ( @vals )  {\n\t   # Once we have uniquely identifiable field\n\t   # I think it will work better.\n\t   if( $v eq &feature_freeze($f) ) {\n\t       $self->{'_btree'}->del_dup($bin,$v);\n\t       $vcount--;\n\t       $countprocessed++;\n\t   }\n       }\n       if( $vcount == 0 ) {\n\t   $self->{'_btree'}->del($bin);\n       }\n   }\n   $countprocessed;\n\n}\n\n=head2 get_all_features\n\n Title   : get_all_features\n Usage   : my @f = $col->get_all_features()\n Function: Return all the features stored in this collection (Could be large)\n Returns : Array of Bio::RangeI objects\n Args    : None","parameters":[{"label":"$self"}],"label":"get_all_features($self)"}},{"name":"R_FIRST","kind":12,"line":406},{"kind":12,"name":"R_NEXT","line":408},{"line":410,"name":"thaw","kind":12},{"signature":{"label":"min_bin($self,$min)","parameters":[{"label":"$self"},{"label":"$min"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($maxbin,$minbin, $file, $keep,\n      $features) = $self->_rearrange([qw(MAXBIN MINBIN FILE KEEP\n\t\t\t\t\t FEATURES)],@args);\n\n  defined $maxbin && $self->max_bin($maxbin);\n  defined $minbin && $self->min_bin($minbin);\n\n  defined $features &&  $self->add_features($features);\n  $DB_BTREE->{'flags'} = R_DUP ;\n  $DB_BTREE->{'compare'} = \\&_compare;\n  $self->{'_btreehash'} = {};\n  if( $file ) {\n      $self->debug(\"using file $file\");\n      $self->indexfile($file);\n  }\n  $self->keep($keep);\n  $self->{'_btree'} = tie %{$self->{'_btreehash'}},\n  'DB_File', $self->indexfile, O_RDWR|O_CREAT, 0640, $DB_BTREE;\n  $self->{'_btree'} || $self->throw(\"Unable to tie DB_File handle\");\n  return $self;\n}\n\n\n=head2 add_features\n\n Title   : add_features\n Usage   : $collection->add_features(\\@features);\n Function:\n Returns : number of features added\n Args    : arrayref of Bio::SeqFeatureI objects to index\n\n\n\nsub add_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to add_features\");\n       return 0;\n   }\n   my $count = 0;\n   foreach my $f ( @$feats ) {\n       if( ! $f || ! ref($f) || ! $f->isa('Bio::RangeI') ) {\n\t   $self->warn(\"Must provide valid Bio::RangeI objects to add_features, skipping object '$f'\\n\");\n\t   next;\n       }\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my $serialized = &feature_freeze($f);\n       $self->{'_btree'}->put($bin,$serialized);\n       if( $f->isa('Bio::SeqFeature::Generic') ) {\n\t   $self->debug( \"$bin for \". $f->location->to_FTstring(). \" matches \".$#{$self->{'_features'}}. \"\\n\");\n       }\n       $count++;\n   }\n   return $count;\n}\n\n\n=head2 features_in_range\n\n Title   : features_in_range\n Usage   : my @features = $collection->features_in_range($range)\n Function: Retrieves a list of features which were contained or overlap the\n           the requested range (see Args for way to specify overlap or\n\t\t\t\tonly those containe)d\n Returns : List of Bio::SeqFeatureI objects\n Args    : -range => Bio::RangeI object defining range to search,\n           OR\n           -start  => start,\n           -end    => end,\n           -strand  => strand\n\n           -contain => boolean - true if feature must be completely\n                       contained with range\n                       OR false if should include features that simply overlap\n                       the range. Default: true.\n           -strandmatch =>  'strong',  ranges must have the same strand\n                            'weak',    ranges must have the same\n                                           strand or no strand\n                            'ignore', ignore strand information\n                           Default. 'ignore'.\n\n\nsub features_in_range{\n   my $self = shift;\n   my (@args) = @_;\n   my ($range, $contain, $strandmatch,$start,$end,$strand);\n   if( @args == 1 ) {\n       $range = shift @args;\n   } else {\n       ($start,$end,$strand,$range,\n\t$contain,$strandmatch) = $self->_rearrange([qw(START END\n\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t       RANGE CONTAIN\n\t\t\t\t\t\t       STRANDMATCH)],\n\t\t\t\t\t\t   @args);\n       $contain = 1 unless defined $contain;\n   }\n   $strand = 1 unless defined $strand;\n   if( $strand !~ /^([\\-\\+])$/ &&\n       $strand !~ /^[\\-\\+]?1$/ ) {\n       $self->warn(\"must provide a valid numeric or +/- for strand\");\n       return ();\n   }\n   if( defined $1 ) { $strand .= 1; }\n\n   if( !defined $start && !defined $end ) {\n       if( ! defined $range || !ref($range) || ! $range->isa(\"Bio::RangeI\") )\n       {\n\t   $self->warn(\"Must defined a valid Range for the method feature_in_range\");\n\t   return ();\n       }\n       ($start,$end,$strand) = ($range->start,$range->end,$range->strand);\n   }\n   my $r = Bio::Location::Simple->new(-start => $start,\n\t\t\t\t     -end   => $end,\n\t\t\t\t     -strand => $strand);\n\n   my @features;\n   my $maxbin = $self->max_bin;\n   my $minbin = $self->min_bin;\n   my $tier = $maxbin;\n   my ($k,$v,@bins) = (\"\",undef);\n   while ($tier >= $minbin) {\n\tmy ($tier_start,$tier_stop) = (bin_bot($tier,$start),\n\t\t\t\t       bin_top($tier,$end));\n       if( $tier_start == $tier_stop ) {\n\t   my @vals = $self->{'_btree'}->get_dup($tier_start);\n\t   if( scalar @vals > 0 ) {\n\t       push @bins, map { thaw($_) } @vals;\n\t   }\n       } else {\t\n\t   $k = $tier_start;\n\t   my @vals;\n\t   for( my $rc = $self->{'_btree'}->seq($k,$v,R_CURSOR);\n\t        $rc == 0;\n\t        $rc = $self->{'_btree'}->seq($k,$v, R_NEXT) ) {\n\t       last if( $k > $tier_stop || $k < $tier_start);\n\t       push @bins, thaw($v);\n\t   }\n       }\n       $tier /= 10;\n   }\n   my %seen = ();\n   foreach my $t ( map { ref($_) } @bins) {\n       next if $seen{$t}++;\n       eval \"require $t\";\n\n       if( $@ ) {\n\t   $self->warn(\"Trying to thaw a stored feature $t which does not appear in your Perl library. $@\");\n\t   next;\n       }\n   }\n   $strandmatch = 'ignore' unless defined $strandmatch;\n   return ( $contain ) ? grep { $r->contains($_,$strandmatch) } @bins :\n       grep { $r->overlaps($_,$strandmatch)} @bins;\n}\n\n=head2 remove_features\n\n Title   : remove_features\n Usage   : $collection->remove_features(\\@array)\n Function: Removes the requested sequence features (based on features\n\t   which have the same location)\n Returns : Number of features removed\n Args    : Arrayref of Bio::RangeI objects\n\n\n\nsub remove_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to remove_features\");\n       return 0;\n   }\n   my $countprocessed = 0;\n\n   foreach my $f ( @$feats ) {\n       next if ! ref($f) || ! $f->isa('Bio::RangeI');\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my @vals = $self->{'_btree'}->get_dup($bin);\n       my $vcount = scalar @vals;\n\n       foreach my $v ( @vals )  {\n\t   # Once we have uniquely identifiable field\n\t   # I think it will work better.\n\t   if( $v eq &feature_freeze($f) ) {\n\t       $self->{'_btree'}->del_dup($bin,$v);\n\t       $vcount--;\n\t       $countprocessed++;\n\t   }\n       }\n       if( $vcount == 0 ) {\n\t   $self->{'_btree'}->del($bin);\n       }\n   }\n   $countprocessed;\n\n}\n\n=head2 get_all_features\n\n Title   : get_all_features\n Usage   : my @f = $col->get_all_features()\n Function: Return all the features stored in this collection (Could be large)\n Returns : Array of Bio::RangeI objects\n Args    : None\n\n\n\nsub get_all_features{\n   my ($self) = @_;\n   my @features;\n   my ($key,$value);\n   for (my $status = $self->{'_btree'}->seq($key, $value, R_FIRST) ;\n\t$status == 0 ;\n\t$status = $self->{'_btree'}->seq($key, $value, R_NEXT) )\n   {   next unless defined $value;\n       push @features, &thaw($value);\n   }\n   if( scalar @features !=  $self->feature_count() ) {\n       $self->warn(\"feature count does not match actual count\\n\");\n   }\n   return @features;\n}\n\n\n=head2 min_bin\n\n Title   : min_bin\n Usage   : my $minbin= $self->min_bin;\n Function: Get/Set the minimum value to use for binning\n Returns : integer\n Args    : [optional] minimum bin value"},"line":430,"kind":12,"range":{"end":{"character":9999,"line":436},"start":{"line":430,"character":0}},"definition":"sub","detail":"($self,$min)","children":[{"definition":"my","line":431,"name":"$self","kind":13,"localvar":"my","containerName":"min_bin"},{"name":"$min","containerName":"min_bin","kind":13,"line":431},{"line":432,"name":"$min","kind":13,"containerName":"min_bin"},{"line":433,"kind":13,"containerName":"min_bin","name":"$self"},{"line":433,"kind":13,"containerName":"min_bin","name":"$min"},{"containerName":"min_bin","kind":13,"name":"$self","line":435}],"name":"min_bin","containerName":"main::"},{"kind":12,"name":"MIN_BIN","line":435},{"name":"max_bin","containerName":"main::","children":[{"definition":"my","line":450,"localvar":"my","kind":13,"containerName":"max_bin","name":"$self"},{"name":"$max","containerName":"max_bin","kind":13,"line":450},{"kind":13,"containerName":"max_bin","name":"$max","line":451},{"kind":13,"containerName":"max_bin","name":"$self","line":452},{"name":"$max","containerName":"max_bin","kind":13,"line":452},{"line":454,"name":"$self","containerName":"max_bin","kind":13}],"detail":"($self,$max)","definition":"sub","range":{"end":{"line":455,"character":9999},"start":{"line":449,"character":0}},"kind":12,"line":449,"signature":{"parameters":[{"label":"$self"},{"label":"$max"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Collection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Collection - A container class for SeqFeatures\nsuitable for performing operations such as finding features within a\nrange, that match a certain feature type, etc.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::Collection;\n  use Bio::Location::Simple;\n  use Bio::Tools::GFF;\n  use Bio::Root::IO;\n  use File::Spec;\n  # let's first input some features\n  my $gffio = Bio::Tools::GFF->new(-file => File::Spec->catfile\n  \t\t\t\t (\"t\",\"data\",\"myco_sites.gff\"),\n  \t\t\t\t -gff_version => 2);\n  my @features = ();\n  # loop over the input stream\n  while(my $feature = $gffio->next_feature()) {\n      # do something with feature\n      push @features, $feature;\n  }\n  $gffio->close();\n  # build the Collection object\n  my $col = Bio::SeqFeature::Collection->new();\n  # add these features to the object\n  my $totaladded = $col->add_features(\\@features);\n\n  my @subset = $col->features_in_range(-start => 1,\n  \t\t\t\t     -end => 25000,\n  \t\t\t\t     -strand => 1,\n  \t\t\t\t     -contain => 0);\n  # subset should have 18 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  @subset = $col->features_in_range(-range => Bio::Location::Simple->new\n  \t\t\t\t  (-start => 70000,\n  \t\t\t\t   -end => 150000,\n  \t\t\t\t   -strand => -1),\n  \t\t\t\t  -contain => 1,\n  \t\t\t\t  -strandmatch => 'strong');\n\n  # subset should have 22 entries for this dataset\n  print \"size is \", scalar @subset, \"\\n\";\n  print \"total number of features in collection is \",\n         $col->feature_count(),\"\\n\";\n\n=head1 DESCRIPTION\n\nThis object will efficiently allow one for query subsets of ranges\nwithin a large collection of sequence features (in fact the objects\njust have to be Bio::RangeI compliant).  This is done by the creation\nof bins which are stored in order in a B-Tree data structure as\nprovided by the DB_File interface to the Berkeley DB.\n\nThis is based on work done by Lincoln for storage in a mysql instance\n- this is intended to be an embedded in-memory implementation for\neasily quering for subsets of a large range set.\n\nCollections can be made persistant by keeping the indexfile and\npassing in the -keep flag like this:\n\n  my $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                   -file => 'col.idx');\n  $collaction->add_features(\\@features);\n  undef $collection;\n\n  # To reuse this collection, next time you initialize a Collection object\n  # specify the filename and the index will be reused.\n  $collection = Bio::SeqFeature::Collection->new(-keep => 1,\n                                                -file => 'col.idx');\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nUsing code and strategy developed by Lincoln Stein (lstein@cshl.org)\nin Bio::DB::GFF implementation.  Credit also to Lincoln for suggesting\nusing Storable to serialize features rather than my previous implementation\nwhich kept the features in memory.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Collection;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::DB::GFF::Util::Binning;\nuse DB_File;\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Storable qw(freeze thaw);\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::CollectionI);\n\n\n# This may need to get re-optimized for BDB usage as these\n# numbers were derived empirically by Lincoln on a mysql srv\n# running on his laptop\n\n# this is the largest that any reference sequence can be (100 megabases)\nuse constant MAX_BIN    => 100_000_000;\n\n# this is the smallest bin (1 K)\nuse constant MIN_BIN    => 1_000;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::Collection->new();\n Function: Builds a new Bio::SeqFeature::Collection object\n Returns : Bio::SeqFeature::Collection\n Args    :\n\n           -minbin        minimum value to use for binning\n                          (default is 100,000,000)\n           -maxbin        maximum value to use for binning\n                          (default is 1,000)\n           -file          filename to store/read the\n                          BTREE from rather than an in-memory structure\n                          (default is false and in-memory).\n           -keep          boolean, will not remove index file on\n                          object destruction.\n           -features      Array ref of features to add initially\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($maxbin,$minbin, $file, $keep,\n      $features) = $self->_rearrange([qw(MAXBIN MINBIN FILE KEEP\n\t\t\t\t\t FEATURES)],@args);\n\n  defined $maxbin && $self->max_bin($maxbin);\n  defined $minbin && $self->min_bin($minbin);\n\n  defined $features &&  $self->add_features($features);\n  $DB_BTREE->{'flags'} = R_DUP ;\n  $DB_BTREE->{'compare'} = \\&_compare;\n  $self->{'_btreehash'} = {};\n  if( $file ) {\n      $self->debug(\"using file $file\");\n      $self->indexfile($file);\n  }\n  $self->keep($keep);\n  $self->{'_btree'} = tie %{$self->{'_btreehash'}},\n  'DB_File', $self->indexfile, O_RDWR|O_CREAT, 0640, $DB_BTREE;\n  $self->{'_btree'} || $self->throw(\"Unable to tie DB_File handle\");\n  return $self;\n}\n\n\n=head2 add_features\n\n Title   : add_features\n Usage   : $collection->add_features(\\@features);\n Function:\n Returns : number of features added\n Args    : arrayref of Bio::SeqFeatureI objects to index\n\n\n\nsub add_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to add_features\");\n       return 0;\n   }\n   my $count = 0;\n   foreach my $f ( @$feats ) {\n       if( ! $f || ! ref($f) || ! $f->isa('Bio::RangeI') ) {\n\t   $self->warn(\"Must provide valid Bio::RangeI objects to add_features, skipping object '$f'\\n\");\n\t   next;\n       }\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my $serialized = &feature_freeze($f);\n       $self->{'_btree'}->put($bin,$serialized);\n       if( $f->isa('Bio::SeqFeature::Generic') ) {\n\t   $self->debug( \"$bin for \". $f->location->to_FTstring(). \" matches \".$#{$self->{'_features'}}. \"\\n\");\n       }\n       $count++;\n   }\n   return $count;\n}\n\n\n=head2 features_in_range\n\n Title   : features_in_range\n Usage   : my @features = $collection->features_in_range($range)\n Function: Retrieves a list of features which were contained or overlap the\n           the requested range (see Args for way to specify overlap or\n\t\t\t\tonly those containe)d\n Returns : List of Bio::SeqFeatureI objects\n Args    : -range => Bio::RangeI object defining range to search,\n           OR\n           -start  => start,\n           -end    => end,\n           -strand  => strand\n\n           -contain => boolean - true if feature must be completely\n                       contained with range\n                       OR false if should include features that simply overlap\n                       the range. Default: true.\n           -strandmatch =>  'strong',  ranges must have the same strand\n                            'weak',    ranges must have the same\n                                           strand or no strand\n                            'ignore', ignore strand information\n                           Default. 'ignore'.\n\n\nsub features_in_range{\n   my $self = shift;\n   my (@args) = @_;\n   my ($range, $contain, $strandmatch,$start,$end,$strand);\n   if( @args == 1 ) {\n       $range = shift @args;\n   } else {\n       ($start,$end,$strand,$range,\n\t$contain,$strandmatch) = $self->_rearrange([qw(START END\n\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t       RANGE CONTAIN\n\t\t\t\t\t\t       STRANDMATCH)],\n\t\t\t\t\t\t   @args);\n       $contain = 1 unless defined $contain;\n   }\n   $strand = 1 unless defined $strand;\n   if( $strand !~ /^([\\-\\+])$/ &&\n       $strand !~ /^[\\-\\+]?1$/ ) {\n       $self->warn(\"must provide a valid numeric or +/- for strand\");\n       return ();\n   }\n   if( defined $1 ) { $strand .= 1; }\n\n   if( !defined $start && !defined $end ) {\n       if( ! defined $range || !ref($range) || ! $range->isa(\"Bio::RangeI\") )\n       {\n\t   $self->warn(\"Must defined a valid Range for the method feature_in_range\");\n\t   return ();\n       }\n       ($start,$end,$strand) = ($range->start,$range->end,$range->strand);\n   }\n   my $r = Bio::Location::Simple->new(-start => $start,\n\t\t\t\t     -end   => $end,\n\t\t\t\t     -strand => $strand);\n\n   my @features;\n   my $maxbin = $self->max_bin;\n   my $minbin = $self->min_bin;\n   my $tier = $maxbin;\n   my ($k,$v,@bins) = (\"\",undef);\n   while ($tier >= $minbin) {\n\tmy ($tier_start,$tier_stop) = (bin_bot($tier,$start),\n\t\t\t\t       bin_top($tier,$end));\n       if( $tier_start == $tier_stop ) {\n\t   my @vals = $self->{'_btree'}->get_dup($tier_start);\n\t   if( scalar @vals > 0 ) {\n\t       push @bins, map { thaw($_) } @vals;\n\t   }\n       } else {\t\n\t   $k = $tier_start;\n\t   my @vals;\n\t   for( my $rc = $self->{'_btree'}->seq($k,$v,R_CURSOR);\n\t        $rc == 0;\n\t        $rc = $self->{'_btree'}->seq($k,$v, R_NEXT) ) {\n\t       last if( $k > $tier_stop || $k < $tier_start);\n\t       push @bins, thaw($v);\n\t   }\n       }\n       $tier /= 10;\n   }\n   my %seen = ();\n   foreach my $t ( map { ref($_) } @bins) {\n       next if $seen{$t}++;\n       eval \"require $t\";\n\n       if( $@ ) {\n\t   $self->warn(\"Trying to thaw a stored feature $t which does not appear in your Perl library. $@\");\n\t   next;\n       }\n   }\n   $strandmatch = 'ignore' unless defined $strandmatch;\n   return ( $contain ) ? grep { $r->contains($_,$strandmatch) } @bins :\n       grep { $r->overlaps($_,$strandmatch)} @bins;\n}\n\n=head2 remove_features\n\n Title   : remove_features\n Usage   : $collection->remove_features(\\@array)\n Function: Removes the requested sequence features (based on features\n\t   which have the same location)\n Returns : Number of features removed\n Args    : Arrayref of Bio::RangeI objects\n\n\n\nsub remove_features{\n   my ($self,$feats) = @_;\n   if( ref($feats) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid Array reference to remove_features\");\n       return 0;\n   }\n   my $countprocessed = 0;\n\n   foreach my $f ( @$feats ) {\n       next if ! ref($f) || ! $f->isa('Bio::RangeI');\n       my $bin = bin($f->start,$f->end,$self->min_bin);\n       my @vals = $self->{'_btree'}->get_dup($bin);\n       my $vcount = scalar @vals;\n\n       foreach my $v ( @vals )  {\n\t   # Once we have uniquely identifiable field\n\t   # I think it will work better.\n\t   if( $v eq &feature_freeze($f) ) {\n\t       $self->{'_btree'}->del_dup($bin,$v);\n\t       $vcount--;\n\t       $countprocessed++;\n\t   }\n       }\n       if( $vcount == 0 ) {\n\t   $self->{'_btree'}->del($bin);\n       }\n   }\n   $countprocessed;\n\n}\n\n=head2 get_all_features\n\n Title   : get_all_features\n Usage   : my @f = $col->get_all_features()\n Function: Return all the features stored in this collection (Could be large)\n Returns : Array of Bio::RangeI objects\n Args    : None\n\n\n\nsub get_all_features{\n   my ($self) = @_;\n   my @features;\n   my ($key,$value);\n   for (my $status = $self->{'_btree'}->seq($key, $value, R_FIRST) ;\n\t$status == 0 ;\n\t$status = $self->{'_btree'}->seq($key, $value, R_NEXT) )\n   {   next unless defined $value;\n       push @features, &thaw($value);\n   }\n   if( scalar @features !=  $self->feature_count() ) {\n       $self->warn(\"feature count does not match actual count\\n\");\n   }\n   return @features;\n}\n\n\n=head2 min_bin\n\n Title   : min_bin\n Usage   : my $minbin= $self->min_bin;\n Function: Get/Set the minimum value to use for binning\n Returns : integer\n Args    : [optional] minimum bin value\n\n\n\nsub min_bin {\n  my ($self,$min) = @_;\n  if( defined $min ) {\n      $self->{'_min_bin'} = $min;\n  }\n  return $self->{'_min_bin'}  || MIN_BIN;\n}\n\n=head2 max_bin\n\n Title   : max_bin\n Usage   : my $maxbin= $self->max_bin;\n Function: Get/Set the maximum value to use for binning\n Returns : integer\n Args    : [optional] maximum bin value","label":"max_bin($self,$max)"}},{"line":454,"kind":12,"name":"MAX_BIN"},{"range":{"end":{"character":9999,"line":471},"start":{"character":0,"line":468}},"kind":12,"line":468,"name":"feature_count","containerName":"main::","children":[{"definition":"my","line":469,"name":"$self","containerName":"feature_count","localvar":"my","kind":13},{"definition":"my","localvar":"my","containerName":"feature_count","kind":13,"name":"$count","line":470},{"containerName":"feature_count","kind":13,"name":"$self","line":471}],"definition":"sub"},{"line":472,"localvar":"my","containerName":null,"kind":13,"name":"$v","definition":"my"},{"line":472,"name":"%self","kind":13,"containerName":null},{"line":473,"kind":13,"containerName":null,"name":"$v"},{"line":474,"containerName":null,"kind":13,"name":"$count"},{"name":"$count","kind":13,"containerName":null,"line":476},{"range":{"end":{"character":9999,"line":495},"start":{"line":490,"character":0}},"kind":12,"line":490,"definition":"sub","name":"indexfile","containerName":"main::","children":[{"definition":"my","line":491,"name":"$self","containerName":"indexfile","localvar":"my","kind":13},{"line":493,"name":"$self","kind":13,"containerName":"indexfile"},{"name":"$self","kind":13,"containerName":"indexfile","line":494}]},{"kind":12,"range":{"end":{"character":9999,"line":515},"start":{"line":510,"character":0}},"line":510,"containerName":"main::","name":"keep","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"keep","name":"$self","line":511},{"name":"$self","kind":13,"containerName":"keep","line":513},{"line":514,"name":"$self","kind":13,"containerName":"keep"}],"definition":"sub"},{"line":517,"kind":12,"range":{"end":{"character":9999,"line":524},"start":{"line":517,"character":0}},"children":[],"name":"_compare","containerName":"main::","definition":"sub"},{"containerName":"main::","name":"feature_freeze","children":[{"name":"$obj","localvar":"my","containerName":"feature_freeze","kind":13,"line":527,"definition":"my"},{"line":528,"name":"$funcref","localvar":"my","containerName":"feature_freeze","kind":13,"definition":"my"},{"line":528,"name":"$obj","kind":13,"containerName":"feature_freeze"},{"containerName":"feature_freeze","kind":12,"name":"_cleanup_methods","line":528},{"line":529,"kind":13,"containerName":"feature_freeze","name":"$obj"},{"name":"_unregister_for_cleanup","containerName":"feature_freeze","kind":12,"line":529},{"name":"$funcref","kind":13,"containerName":"feature_freeze","line":529},{"line":531,"name":"$obj","kind":13,"containerName":"feature_freeze"}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":526},"end":{"line":532,"character":9999}},"line":526},{"line":531,"name":"freeze","kind":12},{"kind":12,"range":{"start":{"character":0,"line":534},"end":{"character":9999,"line":536}},"line":534,"definition":"sub","name":"feature_thaw","containerName":"main::","children":[]},{"line":535,"name":"thaw","kind":12},{"name":"DESTROY","containerName":"main::","children":[{"line":539,"name":"$self","containerName":"DESTROY","localvar":"my","kind":13,"definition":"my"},{"line":540,"name":"$self","kind":13,"containerName":"DESTROY"},{"line":541,"name":"$self","kind":13,"containerName":"DESTROY"}],"definition":"sub","kind":12,"range":{"end":{"line":541,"character":9999},"start":{"line":538,"character":0}},"line":538},{"line":542,"kind":13,"containerName":null,"name":"$self"},{"line":542,"name":"keep","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$self","line":542},{"line":542,"name":"indexfile","containerName":"main::","kind":12},{"name":"$f","kind":13,"localvar":"my","containerName":null,"line":543,"definition":"my"},{"name":"$self","kind":13,"containerName":null,"line":543},{"containerName":"main::","kind":12,"name":"indexfile","line":543},{"name":"$self","kind":13,"containerName":null,"line":544},{"line":544,"name":"debug","containerName":"main::","kind":12},{"name":"$f","containerName":null,"kind":13,"line":544},{"name":"$f","containerName":null,"kind":13,"line":545},{"name":"$f","containerName":null,"kind":13,"line":546},{"name":"$self","kind":13,"containerName":null,"line":548},{"name":"SUPER","kind":12,"containerName":"DESTROY","line":548}]}