{"vars":[{"line":115,"name":"base","kind":2,"containerName":""},{"definition":"sub","detail":"($self)","children":[{"line":135,"name":"$self","containerName":"qual","localvar":"my","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"qual","line":136},{"containerName":"qual","kind":12,"name":"can","line":136},{"line":137,"kind":13,"containerName":"qual","name":"$self"},{"line":137,"name":"throw","kind":12,"containerName":"qual"}],"name":"qual","containerName":"main::","signature":{"documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : ","parameters":[{"label":"$self"}],"label":"qual($self)"},"line":134,"kind":12,"range":{"end":{"line":141,"character":9999},"start":{"character":0,"line":134}}},{"kind":12,"name":"confess","line":139},{"line":157,"range":{"start":{"character":0,"line":157},"end":{"line":166,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : \n\n\nsub qual {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subseq(10,40)};\n Function: returns the quality values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo bases of the sequence. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : a start position and an end position","parameters":[{"label":"$self"}],"label":"subqual($self)"},"children":[{"line":158,"name":"$self","localvar":"my","kind":13,"containerName":"subqual","definition":"my"},{"line":160,"name":"$self","kind":13,"containerName":"subqual"},{"line":160,"containerName":"subqual","kind":12,"name":"can"},{"line":161,"name":"$self","kind":13,"containerName":"subqual"},{"kind":12,"containerName":"subqual","name":"throw","line":161}],"name":"subqual","containerName":"main::","definition":"sub","detail":"($self)"},{"line":163,"name":"confess","kind":12},{"signature":{"label":"display_id($self)","documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : \n\n\nsub qual {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subseq(10,40)};\n Function: returns the quality values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo bases of the sequence. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id() _or_\n\t   $id_string = $obj->display_id($new_display_id);\n Function: Returns the display id, aka the common name of the Quality \n\tobject.\n\tThe semantics of this is that it is the most likely string to be\n\tused as an identifier of the quality sequence, and likely to have\n\t\"human\" readability.  The id is equivalent to the ID field of the\n\tGenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n\tdatabase. In fasta format, the >(\\S+) is presumed to be the id,\n\tthough some people overload the id to embed other information.\n\tBioperl does not use any embedded information in the ID field,\n\tand people are encouraged to use other mechanisms (accession field\n\tfor example, or extending the sequence object) to solve this.\n\tNotice that $seq->id() maps to this function, mainly for \n\tlegacy/convience issues\n Returns : A string\n Args    : If an arg is provided, it will replace the existing display_id\n\tin the object.","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"line":202,"character":9999},"start":{"line":193,"character":0}},"line":193,"detail":"($self)","definition":"sub","containerName":"main::","name":"display_id","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"display_id","name":"$self","line":194},{"containerName":"display_id","kind":13,"name":"$self","line":196},{"containerName":"display_id","kind":12,"name":"can","line":196},{"line":197,"name":"$self","kind":13,"containerName":"display_id"},{"kind":12,"containerName":"display_id","name":"throw","line":197}]},{"line":199,"kind":12,"name":"confess"},{"range":{"start":{"line":223,"character":0},"end":{"character":9999,"line":232}},"kind":12,"line":223,"signature":{"label":"accession_number($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : \n\n\nsub qual {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subseq(10,40)};\n Function: returns the quality values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo bases of the sequence. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id() _or_\n\t   $id_string = $obj->display_id($new_display_id);\n Function: Returns the display id, aka the common name of the Quality \n\tobject.\n\tThe semantics of this is that it is the most likely string to be\n\tused as an identifier of the quality sequence, and likely to have\n\t\"human\" readability.  The id is equivalent to the ID field of the\n\tGenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n\tdatabase. In fasta format, the >(\\S+) is presumed to be the id,\n\tthough some people overload the id to embed other information.\n\tBioperl does not use any embedded information in the ID field,\n\tand people are encouraged to use other mechanisms (accession field\n\tfor example, or extending the sequence object) to solve this.\n\tNotice that $seq->id() maps to this function, mainly for \n\tlegacy/convience issues\n Returns : A string\n Args    : If an arg is provided, it will replace the existing display_id\n\tin the object.\n\n\n\nsub display_id {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number(); _or_\n\t   $unique_biological_key = $obj->accession_number($new_acc_num);\n Function: Returns the unique biological id for a sequence, commonly \n\tcalled the accession_number. For sequences from established \n\tdatabases, the implementors should try to use the correct \n\taccession number. Notice that primary_id() provides the unique id \n\tfor the implemetation, allowing multiple objects to have the same\n\taccession number in a particular implementation. For sequences\n\twith no accession number, this method should return \"unknown\".\n Returns : A string.\n Args    : If an arg is provided, it will replace the existing\n\taccession_number in the object."},"name":"accession_number","containerName":"main::","children":[{"containerName":"accession_number","localvar":"my","kind":13,"name":"$self","line":224,"definition":"my"},{"containerName":"accession_number","kind":13,"name":"@args","line":224},{"line":226,"name":"$self","kind":13,"containerName":"accession_number"},{"line":226,"name":"can","kind":12,"containerName":"accession_number"},{"kind":13,"containerName":"accession_number","name":"$self","line":227},{"line":227,"containerName":"accession_number","kind":12,"name":"throw"}],"detail":"($self,@args)","definition":"sub"},{"line":229,"name":"confess","kind":12},{"range":{"start":{"character":0,"line":252},"end":{"character":9999,"line":261}},"kind":12,"line":252,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : \n\n\nsub qual {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subseq(10,40)};\n Function: returns the quality values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo bases of the sequence. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id() _or_\n\t   $id_string = $obj->display_id($new_display_id);\n Function: Returns the display id, aka the common name of the Quality \n\tobject.\n\tThe semantics of this is that it is the most likely string to be\n\tused as an identifier of the quality sequence, and likely to have\n\t\"human\" readability.  The id is equivalent to the ID field of the\n\tGenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n\tdatabase. In fasta format, the >(\\S+) is presumed to be the id,\n\tthough some people overload the id to embed other information.\n\tBioperl does not use any embedded information in the ID field,\n\tand people are encouraged to use other mechanisms (accession field\n\tfor example, or extending the sequence object) to solve this.\n\tNotice that $seq->id() maps to this function, mainly for \n\tlegacy/convience issues\n Returns : A string\n Args    : If an arg is provided, it will replace the existing display_id\n\tin the object.\n\n\n\nsub display_id {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number(); _or_\n\t   $unique_biological_key = $obj->accession_number($new_acc_num);\n Function: Returns the unique biological id for a sequence, commonly \n\tcalled the accession_number. For sequences from established \n\tdatabases, the implementors should try to use the correct \n\taccession number. Notice that primary_id() provides the unique id \n\tfor the implemetation, allowing multiple objects to have the same\n\taccession number in a particular implementation. For sequences\n\twith no accession number, this method should return \"unknown\".\n Returns : A string.\n Args    : If an arg is provided, it will replace the existing\n\taccession_number in the object.\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   }\n\n}\n\n\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id(); _or_\n\t   $unique_implementation_key = $obj->primary_id($new_prim_id);\n Function: Returns the unique id for this object in this implementation.\n\tThis allows implementations to manage their own object ids in a\n\tway the implementaiton can control clients can expect one id to\n\tmap to one object. For sequences with no accession number, this\n\tmethod should return a stringified memory location.\n Returns : A string\n Args    : If an arg is provided, it will replace the existing\n\tprimary_id in the object.","label":"primary_id($self,@args)"},"name":"primary_id","containerName":"main::","children":[{"definition":"my","line":253,"name":"$self","localvar":"my","kind":13,"containerName":"primary_id"},{"line":253,"name":"@args","containerName":"primary_id","kind":13},{"line":255,"containerName":"primary_id","kind":13,"name":"$self"},{"kind":12,"containerName":"primary_id","name":"can","line":255},{"line":256,"containerName":"primary_id","kind":13,"name":"$self"},{"line":256,"containerName":"primary_id","kind":12,"name":"throw"}],"detail":"($self,@args)","definition":"sub"},{"line":258,"name":"confess","kind":12},{"line":285,"range":{"start":{"character":0,"line":285},"end":{"character":9999,"line":289}},"kind":12,"signature":{"label":"can_call_new($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : \n\n\nsub qual {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subseq(10,40)};\n Function: returns the quality values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo bases of the sequence. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id() _or_\n\t   $id_string = $obj->display_id($new_display_id);\n Function: Returns the display id, aka the common name of the Quality \n\tobject.\n\tThe semantics of this is that it is the most likely string to be\n\tused as an identifier of the quality sequence, and likely to have\n\t\"human\" readability.  The id is equivalent to the ID field of the\n\tGenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n\tdatabase. In fasta format, the >(\\S+) is presumed to be the id,\n\tthough some people overload the id to embed other information.\n\tBioperl does not use any embedded information in the ID field,\n\tand people are encouraged to use other mechanisms (accession field\n\tfor example, or extending the sequence object) to solve this.\n\tNotice that $seq->id() maps to this function, mainly for \n\tlegacy/convience issues\n Returns : A string\n Args    : If an arg is provided, it will replace the existing display_id\n\tin the object.\n\n\n\nsub display_id {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number(); _or_\n\t   $unique_biological_key = $obj->accession_number($new_acc_num);\n Function: Returns the unique biological id for a sequence, commonly \n\tcalled the accession_number. For sequences from established \n\tdatabases, the implementors should try to use the correct \n\taccession number. Notice that primary_id() provides the unique id \n\tfor the implemetation, allowing multiple objects to have the same\n\taccession number in a particular implementation. For sequences\n\twith no accession number, this method should return \"unknown\".\n Returns : A string.\n Args    : If an arg is provided, it will replace the existing\n\taccession_number in the object.\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   }\n\n}\n\n\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id(); _or_\n\t   $unique_implementation_key = $obj->primary_id($new_prim_id);\n Function: Returns the unique id for this object in this implementation.\n\tThis allows implementations to manage their own object ids in a\n\tway the implementaiton can control clients can expect one id to\n\tmap to one object. For sequences with no accession number, this\n\tmethod should return a stringified memory location.\n Returns : A string\n Args    : If an arg is provided, it will replace the existing\n\tprimary_id in the object.\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 can_call_new()\n\n Title   : can_call_new()\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending on whether an\n\timplementation allows new constructor to be called. If a new\n\tconstructor is allowed, then it should take the followed hashed\n\tconstructor list.\n           $myobject->new( -qual => $quality_as_string,\n\t\t\t   -display_id  => $id,\n\t\t\t   -accession_number => $accession,\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :"},"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"can_call_new","line":286,"definition":"my"},{"line":286,"containerName":"can_call_new","kind":13,"name":"@args"}],"containerName":"main::","name":"can_call_new","definition":"sub","detail":"($self,@args)"},{"signature":{"documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : \n\n\nsub qual {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subseq(10,40)};\n Function: returns the quality values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo bases of the sequence. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id() _or_\n\t   $id_string = $obj->display_id($new_display_id);\n Function: Returns the display id, aka the common name of the Quality \n\tobject.\n\tThe semantics of this is that it is the most likely string to be\n\tused as an identifier of the quality sequence, and likely to have\n\t\"human\" readability.  The id is equivalent to the ID field of the\n\tGenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n\tdatabase. In fasta format, the >(\\S+) is presumed to be the id,\n\tthough some people overload the id to embed other information.\n\tBioperl does not use any embedded information in the ID field,\n\tand people are encouraged to use other mechanisms (accession field\n\tfor example, or extending the sequence object) to solve this.\n\tNotice that $seq->id() maps to this function, mainly for \n\tlegacy/convience issues\n Returns : A string\n Args    : If an arg is provided, it will replace the existing display_id\n\tin the object.\n\n\n\nsub display_id {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number(); _or_\n\t   $unique_biological_key = $obj->accession_number($new_acc_num);\n Function: Returns the unique biological id for a sequence, commonly \n\tcalled the accession_number. For sequences from established \n\tdatabases, the implementors should try to use the correct \n\taccession number. Notice that primary_id() provides the unique id \n\tfor the implemetation, allowing multiple objects to have the same\n\taccession number in a particular implementation. For sequences\n\twith no accession number, this method should return \"unknown\".\n Returns : A string.\n Args    : If an arg is provided, it will replace the existing\n\taccession_number in the object.\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   }\n\n}\n\n\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id(); _or_\n\t   $unique_implementation_key = $obj->primary_id($new_prim_id);\n Function: Returns the unique id for this object in this implementation.\n\tThis allows implementations to manage their own object ids in a\n\tway the implementaiton can control clients can expect one id to\n\tmap to one object. For sequences with no accession number, this\n\tmethod should return a stringified memory location.\n Returns : A string\n Args    : If an arg is provided, it will replace the existing\n\tprimary_id in the object.\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 can_call_new()\n\n Title   : can_call_new()\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending on whether an\n\timplementation allows new constructor to be called. If a new\n\tconstructor is allowed, then it should take the followed hashed\n\tconstructor list.\n           $myobject->new( -qual => $quality_as_string,\n\t\t\t   -display_id  => $id,\n\t\t\t   -accession_number => $accession,\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n   # we default to 0 here\n   return 0;\n}\n\n=head2 qualat($position)\n\n Title   : qualat($position)\n Usage   : $quality = $obj->qualat(10);\n Function: Return the quality value at the given location, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the first\n        two bases of the sequence. Start cannot be larger than end but can\n        be equal.\n Returns : A scalar.\n Args    : A position.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"qualat($self,$value)"},"range":{"end":{"line":312,"character":9999},"start":{"character":0,"line":304}},"kind":12,"line":304,"detail":"($self,$value)","definition":"sub","name":"qualat","containerName":"main::","children":[{"definition":"my","line":305,"name":"$self","localvar":"my","containerName":"qualat","kind":13},{"line":305,"name":"$value","kind":13,"containerName":"qualat"},{"kind":13,"containerName":"qualat","name":"$self","line":306},{"line":306,"kind":12,"containerName":"qualat","name":"can"},{"line":307,"name":"$self","containerName":"qualat","kind":13},{"name":"warn","containerName":"qualat","kind":12,"line":307}]},{"range":{"end":{"line":352,"character":9999},"start":{"character":0,"line":349}},"kind":12,"line":349,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : \n\n\nsub qual {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subseq(10,40)};\n Function: returns the quality values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo bases of the sequence. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id() _or_\n\t   $id_string = $obj->display_id($new_display_id);\n Function: Returns the display id, aka the common name of the Quality \n\tobject.\n\tThe semantics of this is that it is the most likely string to be\n\tused as an identifier of the quality sequence, and likely to have\n\t\"human\" readability.  The id is equivalent to the ID field of the\n\tGenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n\tdatabase. In fasta format, the >(\\S+) is presumed to be the id,\n\tthough some people overload the id to embed other information.\n\tBioperl does not use any embedded information in the ID field,\n\tand people are encouraged to use other mechanisms (accession field\n\tfor example, or extending the sequence object) to solve this.\n\tNotice that $seq->id() maps to this function, mainly for \n\tlegacy/convience issues\n Returns : A string\n Args    : If an arg is provided, it will replace the existing display_id\n\tin the object.\n\n\n\nsub display_id {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number(); _or_\n\t   $unique_biological_key = $obj->accession_number($new_acc_num);\n Function: Returns the unique biological id for a sequence, commonly \n\tcalled the accession_number. For sequences from established \n\tdatabases, the implementors should try to use the correct \n\taccession number. Notice that primary_id() provides the unique id \n\tfor the implemetation, allowing multiple objects to have the same\n\taccession number in a particular implementation. For sequences\n\twith no accession number, this method should return \"unknown\".\n Returns : A string.\n Args    : If an arg is provided, it will replace the existing\n\taccession_number in the object.\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   }\n\n}\n\n\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id(); _or_\n\t   $unique_implementation_key = $obj->primary_id($new_prim_id);\n Function: Returns the unique id for this object in this implementation.\n\tThis allows implementations to manage their own object ids in a\n\tway the implementaiton can control clients can expect one id to\n\tmap to one object. For sequences with no accession number, this\n\tmethod should return a stringified memory location.\n Returns : A string\n Args    : If an arg is provided, it will replace the existing\n\tprimary_id in the object.\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 can_call_new()\n\n Title   : can_call_new()\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending on whether an\n\timplementation allows new constructor to be called. If a new\n\tconstructor is allowed, then it should take the followed hashed\n\tconstructor list.\n           $myobject->new( -qual => $quality_as_string,\n\t\t\t   -display_id  => $id,\n\t\t\t   -accession_number => $accession,\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n   # we default to 0 here\n   return 0;\n}\n\n=head2 qualat($position)\n\n Title   : qualat($position)\n Usage   : $quality = $obj->qualat(10);\n Function: Return the quality value at the given location, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the first\n        two bases of the sequence. Start cannot be larger than end but can\n        be equal.\n Returns : A scalar.\n Args    : A position.\n\n\nsub qualat {\n   my ($self,$value) = @_;\n   if( $self->can('warn') ) {\n       $self->warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   } else {\n       warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   }\n   return '';\n} \n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. A implementing\nclass does not need to provide these functions, as they will be\nprovided by this class, but is free to override these functions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : @rev = @{$qual->revcom()};\n Function: Produces a new Bio::Seq::QualI implementing object which\n\tis reversed from the original quality array.\n\tThe id is the same id as the orginal sequence, and the accession number\n\tis also indentical. If someone wants to track that this sequence has\n\tbeen reversed, it needs to define its own extensions\n\n\tTo do an inplace edit of an object you can go:\n\n\t$qual = $qual->revcom();\n\n\tThis of course, causes Perl to handle the garbage collection of the old\n\tobject, but it is roughly speaking as efficient as an inplace edit.\n Returns : A new (fresh) Bio::Seq::PrimaryQualI object\n Args    : none","label":"revcom($self)"},"name":"revcom","containerName":"main::","children":[{"definition":"my","line":350,"name":"$self","containerName":"revcom","localvar":"my","kind":13},{"definition":"my","containerName":"revcom","localvar":"my","kind":13,"name":"@qualities","line":352},{"line":352,"kind":13,"containerName":"revcom","name":"$self"},{"containerName":"revcom","kind":12,"name":"qual","line":352}],"detail":"($self)","definition":"sub"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"@reversed_qualities","line":353},{"line":353,"containerName":null,"kind":13,"name":"@qualities"},{"line":354,"localvar":"my","kind":13,"containerName":null,"name":"$seqclass","definition":"my"},{"name":"$self","containerName":null,"kind":13,"line":355},{"name":"can_call_new","kind":12,"containerName":"main::","line":355},{"line":356,"name":"$seqclass","containerName":null,"kind":13},{"line":356,"name":"%self","containerName":null,"kind":13},{"name":"$seqclass","containerName":null,"kind":13,"line":358},{"definition":"my","line":363,"name":"$out","localvar":"my","containerName":null,"kind":13},{"name":"$seqclass","kind":13,"containerName":null,"line":363},{"containerName":"main::","kind":12,"name":"new","line":363},{"kind":13,"containerName":null,"name":"@reversed_qualities","line":363},{"name":"$self","containerName":null,"kind":13,"line":364},{"line":364,"kind":12,"containerName":"main::","name":"display_id"},{"line":365,"containerName":null,"kind":13,"name":"$self"},{"line":365,"name":"accession_number","kind":12,"containerName":"main::"},{"line":366,"containerName":null,"kind":13,"name":"$self"},{"line":366,"name":"desc","containerName":"main::","kind":12},{"name":"$out","kind":13,"containerName":null,"line":368},{"detail":"($self,$start,$end)","definition":"sub","name":"trunc","containerName":"main::","children":[{"line":383,"name":"$self","localvar":"my","kind":13,"containerName":"trunc","definition":"my"},{"kind":13,"containerName":"trunc","name":"$start","line":383},{"containerName":"trunc","kind":13,"name":"$end","line":383},{"containerName":"trunc","kind":13,"name":"$end","line":385},{"line":386,"name":"$self","kind":13,"containerName":"trunc"},{"containerName":"trunc","kind":12,"name":"can","line":386},{"line":387,"containerName":"trunc","kind":13,"name":"$self"},{"line":387,"name":"throw","containerName":"trunc","kind":12},{"line":393,"name":"$end","containerName":"trunc","kind":13},{"kind":13,"containerName":"trunc","name":"$start","line":393},{"kind":13,"containerName":"trunc","name":"$self","line":394},{"kind":12,"containerName":"trunc","name":"can","line":394},{"line":395,"containerName":"trunc","kind":13,"name":"$self"},{"line":395,"name":"throw","containerName":"trunc","kind":12},{"line":401,"name":"$r_qual","kind":13,"localvar":"my","containerName":"trunc","definition":"my"},{"kind":13,"containerName":"trunc","name":"$self","line":401},{"line":401,"kind":12,"containerName":"trunc","name":"subqual"},{"line":401,"name":"$start","containerName":"trunc","kind":13},{"line":401,"name":"$end","kind":13,"containerName":"trunc"},{"definition":"my","line":403,"localvar":"my","kind":13,"containerName":"trunc","name":"$seqclass"},{"name":"$self","containerName":"trunc","kind":13,"line":404},{"kind":12,"containerName":"trunc","name":"can_call_new","line":404},{"containerName":"trunc","kind":13,"name":"$seqclass","line":405},{"kind":13,"containerName":"trunc","name":"$self","line":405},{"line":407,"name":"$seqclass","kind":13,"containerName":"trunc"},{"name":"$out","localvar":"my","containerName":"trunc","kind":13,"line":411,"definition":"my"},{"line":411,"kind":13,"containerName":"trunc","name":"$seqclass"},{"line":411,"containerName":"trunc","kind":12,"name":"new"},{"line":411,"name":"$r_qual","kind":13,"containerName":"trunc"},{"name":"$self","containerName":"trunc","kind":13,"line":412},{"name":"display_id","kind":12,"containerName":"trunc","line":412},{"line":413,"containerName":"trunc","kind":13,"name":"$self"},{"line":413,"containerName":"trunc","kind":12,"name":"accession_number"},{"containerName":"trunc","kind":13,"name":"$self","line":414},{"line":414,"containerName":"trunc","kind":12,"name":"desc"},{"containerName":"trunc","kind":13,"name":"$out","line":416}],"signature":{"documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : \n\n\nsub qual {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subseq(10,40)};\n Function: returns the quality values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo bases of the sequence. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id() _or_\n\t   $id_string = $obj->display_id($new_display_id);\n Function: Returns the display id, aka the common name of the Quality \n\tobject.\n\tThe semantics of this is that it is the most likely string to be\n\tused as an identifier of the quality sequence, and likely to have\n\t\"human\" readability.  The id is equivalent to the ID field of the\n\tGenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n\tdatabase. In fasta format, the >(\\S+) is presumed to be the id,\n\tthough some people overload the id to embed other information.\n\tBioperl does not use any embedded information in the ID field,\n\tand people are encouraged to use other mechanisms (accession field\n\tfor example, or extending the sequence object) to solve this.\n\tNotice that $seq->id() maps to this function, mainly for \n\tlegacy/convience issues\n Returns : A string\n Args    : If an arg is provided, it will replace the existing display_id\n\tin the object.\n\n\n\nsub display_id {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number(); _or_\n\t   $unique_biological_key = $obj->accession_number($new_acc_num);\n Function: Returns the unique biological id for a sequence, commonly \n\tcalled the accession_number. For sequences from established \n\tdatabases, the implementors should try to use the correct \n\taccession number. Notice that primary_id() provides the unique id \n\tfor the implemetation, allowing multiple objects to have the same\n\taccession number in a particular implementation. For sequences\n\twith no accession number, this method should return \"unknown\".\n Returns : A string.\n Args    : If an arg is provided, it will replace the existing\n\taccession_number in the object.\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   }\n\n}\n\n\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id(); _or_\n\t   $unique_implementation_key = $obj->primary_id($new_prim_id);\n Function: Returns the unique id for this object in this implementation.\n\tThis allows implementations to manage their own object ids in a\n\tway the implementaiton can control clients can expect one id to\n\tmap to one object. For sequences with no accession number, this\n\tmethod should return a stringified memory location.\n Returns : A string\n Args    : If an arg is provided, it will replace the existing\n\tprimary_id in the object.\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 can_call_new()\n\n Title   : can_call_new()\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending on whether an\n\timplementation allows new constructor to be called. If a new\n\tconstructor is allowed, then it should take the followed hashed\n\tconstructor list.\n           $myobject->new( -qual => $quality_as_string,\n\t\t\t   -display_id  => $id,\n\t\t\t   -accession_number => $accession,\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n   # we default to 0 here\n   return 0;\n}\n\n=head2 qualat($position)\n\n Title   : qualat($position)\n Usage   : $quality = $obj->qualat(10);\n Function: Return the quality value at the given location, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the first\n        two bases of the sequence. Start cannot be larger than end but can\n        be equal.\n Returns : A scalar.\n Args    : A position.\n\n\nsub qualat {\n   my ($self,$value) = @_;\n   if( $self->can('warn') ) {\n       $self->warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   } else {\n       warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   }\n   return '';\n} \n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. A implementing\nclass does not need to provide these functions, as they will be\nprovided by this class, but is free to override these functions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : @rev = @{$qual->revcom()};\n Function: Produces a new Bio::Seq::QualI implementing object which\n\tis reversed from the original quality array.\n\tThe id is the same id as the orginal sequence, and the accession number\n\tis also indentical. If someone wants to track that this sequence has\n\tbeen reversed, it needs to define its own extensions\n\n\tTo do an inplace edit of an object you can go:\n\n\t$qual = $qual->revcom();\n\n\tThis of course, causes Perl to handle the garbage collection of the old\n\tobject, but it is roughly speaking as efficient as an inplace edit.\n Returns : A new (fresh) Bio::Seq::PrimaryQualI object\n Args    : none\n\n\nsub revcom{\n   my ($self) = @_;\n\t\t# this is the cleanest way\n\tmy @qualities = @{$self->qual()};\n\tmy @reversed_qualities = reverse(@qualities);\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::Seq::PrimaryQual';\n\t\t# Wassat?\n\t\t# $self->_attempt_to_load_Seq();\n   }\n\t# the \\@reverse_qualities thing works simply because I will it to work.\n   my $out = $seqclass->new( '-qual' => \\@reversed_qualities,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n=head2 trunc()\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n Returns : a fresh Bio::Seq::QualI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"label":"trunc($self,$start,$end)"},"kind":12,"range":{"start":{"character":0,"line":382},"end":{"character":9999,"line":417}},"line":382},{"kind":12,"name":"confess","line":389},{"name":"confess","kind":12,"line":397},{"children":[],"containerName":"main::","name":"translate","definition":"sub","line":433,"kind":12,"range":{"end":{"character":9999,"line":435},"start":{"character":0,"line":433}}},{"definition":"sub","detail":"($self)","children":[{"localvar":"my","kind":13,"containerName":"id","name":"$self","line":452,"definition":"my"},{"kind":13,"containerName":"id","name":"$self","line":453},{"name":"display_id","kind":12,"containerName":"id","line":453}],"name":"id","containerName":"main::","signature":{"label":"id($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : \n\n\nsub qual {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subseq(10,40)};\n Function: returns the quality values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo bases of the sequence. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id() _or_\n\t   $id_string = $obj->display_id($new_display_id);\n Function: Returns the display id, aka the common name of the Quality \n\tobject.\n\tThe semantics of this is that it is the most likely string to be\n\tused as an identifier of the quality sequence, and likely to have\n\t\"human\" readability.  The id is equivalent to the ID field of the\n\tGenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n\tdatabase. In fasta format, the >(\\S+) is presumed to be the id,\n\tthough some people overload the id to embed other information.\n\tBioperl does not use any embedded information in the ID field,\n\tand people are encouraged to use other mechanisms (accession field\n\tfor example, or extending the sequence object) to solve this.\n\tNotice that $seq->id() maps to this function, mainly for \n\tlegacy/convience issues\n Returns : A string\n Args    : If an arg is provided, it will replace the existing display_id\n\tin the object.\n\n\n\nsub display_id {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number(); _or_\n\t   $unique_biological_key = $obj->accession_number($new_acc_num);\n Function: Returns the unique biological id for a sequence, commonly \n\tcalled the accession_number. For sequences from established \n\tdatabases, the implementors should try to use the correct \n\taccession number. Notice that primary_id() provides the unique id \n\tfor the implemetation, allowing multiple objects to have the same\n\taccession number in a particular implementation. For sequences\n\twith no accession number, this method should return \"unknown\".\n Returns : A string.\n Args    : If an arg is provided, it will replace the existing\n\taccession_number in the object.\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   }\n\n}\n\n\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id(); _or_\n\t   $unique_implementation_key = $obj->primary_id($new_prim_id);\n Function: Returns the unique id for this object in this implementation.\n\tThis allows implementations to manage their own object ids in a\n\tway the implementaiton can control clients can expect one id to\n\tmap to one object. For sequences with no accession number, this\n\tmethod should return a stringified memory location.\n Returns : A string\n Args    : If an arg is provided, it will replace the existing\n\tprimary_id in the object.\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 can_call_new()\n\n Title   : can_call_new()\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending on whether an\n\timplementation allows new constructor to be called. If a new\n\tconstructor is allowed, then it should take the followed hashed\n\tconstructor list.\n           $myobject->new( -qual => $quality_as_string,\n\t\t\t   -display_id  => $id,\n\t\t\t   -accession_number => $accession,\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n   # we default to 0 here\n   return 0;\n}\n\n=head2 qualat($position)\n\n Title   : qualat($position)\n Usage   : $quality = $obj->qualat(10);\n Function: Return the quality value at the given location, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the first\n        two bases of the sequence. Start cannot be larger than end but can\n        be equal.\n Returns : A scalar.\n Args    : A position.\n\n\nsub qualat {\n   my ($self,$value) = @_;\n   if( $self->can('warn') ) {\n       $self->warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   } else {\n       warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   }\n   return '';\n} \n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. A implementing\nclass does not need to provide these functions, as they will be\nprovided by this class, but is free to override these functions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : @rev = @{$qual->revcom()};\n Function: Produces a new Bio::Seq::QualI implementing object which\n\tis reversed from the original quality array.\n\tThe id is the same id as the orginal sequence, and the accession number\n\tis also indentical. If someone wants to track that this sequence has\n\tbeen reversed, it needs to define its own extensions\n\n\tTo do an inplace edit of an object you can go:\n\n\t$qual = $qual->revcom();\n\n\tThis of course, causes Perl to handle the garbage collection of the old\n\tobject, but it is roughly speaking as efficient as an inplace edit.\n Returns : A new (fresh) Bio::Seq::PrimaryQualI object\n Args    : none\n\n\nsub revcom{\n   my ($self) = @_;\n\t\t# this is the cleanest way\n\tmy @qualities = @{$self->qual()};\n\tmy @reversed_qualities = reverse(@qualities);\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::Seq::PrimaryQual';\n\t\t# Wassat?\n\t\t# $self->_attempt_to_load_Seq();\n   }\n\t# the \\@reverse_qualities thing works simply because I will it to work.\n   my $out = $seqclass->new( '-qual' => \\@reversed_qualities,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n=head2 trunc()\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n Returns : a fresh Bio::Seq::QualI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc {\n   my ($self,$start,$end) = @_;\n\n   if( !$end ) {\n       if( $self->can('throw')  ) {\n\t   $self->throw(\"trunc start,end\");\n       } else {\n\t   confess(\"[$self] trunc start,end\");\n       }\n   }\n\n   if( $end < $start ) {\n       if( $self->can('throw')  ) {\n\t   $self->throw(\"$end is smaller than $start. if you want to truncated and reverse complement, you must call trunc followed by revcom. Sorry.\");\n       } else {\n\t   confess(\"[$self] $end is smaller than $start. If you want to truncated and reverse complement, you must call trunc followed by revcom. Sorry.\");\n       }\n   }\n\n   my $r_qual = $self->subqual($start,$end);\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::Seq::PrimaryQual';\n\t\t# wassat?\n\t\t# $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-qual' => $r_qual,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate()\n\n Title   : translate()\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n           #if full CDS expected:\n           $protein_seq_obj = $cds_seq_obj->translate(undef,undef,undef,undef,1);\n Function: Completely useless in this interface.\n Returns : Nothing.\n Args    : Nothing.\n\n\n\nsub translate {\n\treturn 0;\n}\n\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id()\n Function: ID of the quality. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :"},"line":451,"range":{"end":{"character":9999,"line":454},"start":{"line":451,"character":0}},"kind":12},{"name":"length","containerName":"main::","children":[{"definition":"my","line":471,"name":"$self","kind":13,"localvar":"my","containerName":"length"},{"name":"$self","kind":13,"containerName":"length","line":472},{"line":472,"containerName":"length","kind":12,"name":"can"},{"line":473,"name":"$self","kind":13,"containerName":"length"},{"line":473,"name":"throw","kind":12,"containerName":"length"}],"detail":"($self)","definition":"sub","range":{"start":{"line":470,"character":0},"end":{"line":477,"character":9999}},"kind":12,"line":470,"signature":{"label":"length($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : \n\n\nsub qual {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subseq(10,40)};\n Function: returns the quality values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo bases of the sequence. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id() _or_\n\t   $id_string = $obj->display_id($new_display_id);\n Function: Returns the display id, aka the common name of the Quality \n\tobject.\n\tThe semantics of this is that it is the most likely string to be\n\tused as an identifier of the quality sequence, and likely to have\n\t\"human\" readability.  The id is equivalent to the ID field of the\n\tGenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n\tdatabase. In fasta format, the >(\\S+) is presumed to be the id,\n\tthough some people overload the id to embed other information.\n\tBioperl does not use any embedded information in the ID field,\n\tand people are encouraged to use other mechanisms (accession field\n\tfor example, or extending the sequence object) to solve this.\n\tNotice that $seq->id() maps to this function, mainly for \n\tlegacy/convience issues\n Returns : A string\n Args    : If an arg is provided, it will replace the existing display_id\n\tin the object.\n\n\n\nsub display_id {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number(); _or_\n\t   $unique_biological_key = $obj->accession_number($new_acc_num);\n Function: Returns the unique biological id for a sequence, commonly \n\tcalled the accession_number. For sequences from established \n\tdatabases, the implementors should try to use the correct \n\taccession number. Notice that primary_id() provides the unique id \n\tfor the implemetation, allowing multiple objects to have the same\n\taccession number in a particular implementation. For sequences\n\twith no accession number, this method should return \"unknown\".\n Returns : A string.\n Args    : If an arg is provided, it will replace the existing\n\taccession_number in the object.\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   }\n\n}\n\n\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id(); _or_\n\t   $unique_implementation_key = $obj->primary_id($new_prim_id);\n Function: Returns the unique id for this object in this implementation.\n\tThis allows implementations to manage their own object ids in a\n\tway the implementaiton can control clients can expect one id to\n\tmap to one object. For sequences with no accession number, this\n\tmethod should return a stringified memory location.\n Returns : A string\n Args    : If an arg is provided, it will replace the existing\n\tprimary_id in the object.\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 can_call_new()\n\n Title   : can_call_new()\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending on whether an\n\timplementation allows new constructor to be called. If a new\n\tconstructor is allowed, then it should take the followed hashed\n\tconstructor list.\n           $myobject->new( -qual => $quality_as_string,\n\t\t\t   -display_id  => $id,\n\t\t\t   -accession_number => $accession,\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n   # we default to 0 here\n   return 0;\n}\n\n=head2 qualat($position)\n\n Title   : qualat($position)\n Usage   : $quality = $obj->qualat(10);\n Function: Return the quality value at the given location, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the first\n        two bases of the sequence. Start cannot be larger than end but can\n        be equal.\n Returns : A scalar.\n Args    : A position.\n\n\nsub qualat {\n   my ($self,$value) = @_;\n   if( $self->can('warn') ) {\n       $self->warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   } else {\n       warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   }\n   return '';\n} \n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. A implementing\nclass does not need to provide these functions, as they will be\nprovided by this class, but is free to override these functions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : @rev = @{$qual->revcom()};\n Function: Produces a new Bio::Seq::QualI implementing object which\n\tis reversed from the original quality array.\n\tThe id is the same id as the orginal sequence, and the accession number\n\tis also indentical. If someone wants to track that this sequence has\n\tbeen reversed, it needs to define its own extensions\n\n\tTo do an inplace edit of an object you can go:\n\n\t$qual = $qual->revcom();\n\n\tThis of course, causes Perl to handle the garbage collection of the old\n\tobject, but it is roughly speaking as efficient as an inplace edit.\n Returns : A new (fresh) Bio::Seq::PrimaryQualI object\n Args    : none\n\n\nsub revcom{\n   my ($self) = @_;\n\t\t# this is the cleanest way\n\tmy @qualities = @{$self->qual()};\n\tmy @reversed_qualities = reverse(@qualities);\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::Seq::PrimaryQual';\n\t\t# Wassat?\n\t\t# $self->_attempt_to_load_Seq();\n   }\n\t# the \\@reverse_qualities thing works simply because I will it to work.\n   my $out = $seqclass->new( '-qual' => \\@reversed_qualities,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n=head2 trunc()\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n Returns : a fresh Bio::Seq::QualI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc {\n   my ($self,$start,$end) = @_;\n\n   if( !$end ) {\n       if( $self->can('throw')  ) {\n\t   $self->throw(\"trunc start,end\");\n       } else {\n\t   confess(\"[$self] trunc start,end\");\n       }\n   }\n\n   if( $end < $start ) {\n       if( $self->can('throw')  ) {\n\t   $self->throw(\"$end is smaller than $start. if you want to truncated and reverse complement, you must call trunc followed by revcom. Sorry.\");\n       } else {\n\t   confess(\"[$self] $end is smaller than $start. If you want to truncated and reverse complement, you must call trunc followed by revcom. Sorry.\");\n       }\n   }\n\n   my $r_qual = $self->subqual($start,$end);\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::Seq::PrimaryQual';\n\t\t# wassat?\n\t\t# $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-qual' => $r_qual,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate()\n\n Title   : translate()\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n           #if full CDS expected:\n           $protein_seq_obj = $cds_seq_obj->translate(undef,undef,undef,undef,1);\n Function: Completely useless in this interface.\n Returns : Nothing.\n Args    : Nothing.\n\n\n\nsub translate {\n\treturn 0;\n}\n\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id()\n Function: ID of the quality. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :\n\n\n\nsub  id {\n   my ($self)= @_;\n   return $self->display_id();\n}\n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $qual->length();\n Function: Return the length of the array holding the quality values.\n        Under most circumstances, this should match the number of quality\n        values but no validation is done when the PrimaryQual object is\n        constructed and non-digits could be put into this array. Is this a\n        bug? Just enough rope...\n Returns : A scalar (the number of elements in the quality array).\n Args    : None."}},{"kind":12,"name":"confess","line":475},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"desc","children":[{"line":493,"localvar":"my","kind":13,"containerName":"desc","name":"$self","definition":"my"},{"name":"$value","containerName":"desc","kind":13,"line":493},{"kind":13,"containerName":"desc","name":"$self","line":494},{"line":494,"name":"can","kind":12,"containerName":"desc"},{"name":"$self","kind":13,"containerName":"desc","line":495},{"containerName":"desc","kind":12,"name":"warn","line":495}],"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : \n\n\nsub qual {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subseq(10,40)};\n Function: returns the quality values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo bases of the sequence. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id() _or_\n\t   $id_string = $obj->display_id($new_display_id);\n Function: Returns the display id, aka the common name of the Quality \n\tobject.\n\tThe semantics of this is that it is the most likely string to be\n\tused as an identifier of the quality sequence, and likely to have\n\t\"human\" readability.  The id is equivalent to the ID field of the\n\tGenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n\tdatabase. In fasta format, the >(\\S+) is presumed to be the id,\n\tthough some people overload the id to embed other information.\n\tBioperl does not use any embedded information in the ID field,\n\tand people are encouraged to use other mechanisms (accession field\n\tfor example, or extending the sequence object) to solve this.\n\tNotice that $seq->id() maps to this function, mainly for \n\tlegacy/convience issues\n Returns : A string\n Args    : If an arg is provided, it will replace the existing display_id\n\tin the object.\n\n\n\nsub display_id {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number(); _or_\n\t   $unique_biological_key = $obj->accession_number($new_acc_num);\n Function: Returns the unique biological id for a sequence, commonly \n\tcalled the accession_number. For sequences from established \n\tdatabases, the implementors should try to use the correct \n\taccession number. Notice that primary_id() provides the unique id \n\tfor the implemetation, allowing multiple objects to have the same\n\taccession number in a particular implementation. For sequences\n\twith no accession number, this method should return \"unknown\".\n Returns : A string.\n Args    : If an arg is provided, it will replace the existing\n\taccession_number in the object.\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   }\n\n}\n\n\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id(); _or_\n\t   $unique_implementation_key = $obj->primary_id($new_prim_id);\n Function: Returns the unique id for this object in this implementation.\n\tThis allows implementations to manage their own object ids in a\n\tway the implementaiton can control clients can expect one id to\n\tmap to one object. For sequences with no accession number, this\n\tmethod should return a stringified memory location.\n Returns : A string\n Args    : If an arg is provided, it will replace the existing\n\tprimary_id in the object.\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 can_call_new()\n\n Title   : can_call_new()\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending on whether an\n\timplementation allows new constructor to be called. If a new\n\tconstructor is allowed, then it should take the followed hashed\n\tconstructor list.\n           $myobject->new( -qual => $quality_as_string,\n\t\t\t   -display_id  => $id,\n\t\t\t   -accession_number => $accession,\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n   # we default to 0 here\n   return 0;\n}\n\n=head2 qualat($position)\n\n Title   : qualat($position)\n Usage   : $quality = $obj->qualat(10);\n Function: Return the quality value at the given location, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the first\n        two bases of the sequence. Start cannot be larger than end but can\n        be equal.\n Returns : A scalar.\n Args    : A position.\n\n\nsub qualat {\n   my ($self,$value) = @_;\n   if( $self->can('warn') ) {\n       $self->warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   } else {\n       warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   }\n   return '';\n} \n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. A implementing\nclass does not need to provide these functions, as they will be\nprovided by this class, but is free to override these functions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : @rev = @{$qual->revcom()};\n Function: Produces a new Bio::Seq::QualI implementing object which\n\tis reversed from the original quality array.\n\tThe id is the same id as the orginal sequence, and the accession number\n\tis also indentical. If someone wants to track that this sequence has\n\tbeen reversed, it needs to define its own extensions\n\n\tTo do an inplace edit of an object you can go:\n\n\t$qual = $qual->revcom();\n\n\tThis of course, causes Perl to handle the garbage collection of the old\n\tobject, but it is roughly speaking as efficient as an inplace edit.\n Returns : A new (fresh) Bio::Seq::PrimaryQualI object\n Args    : none\n\n\nsub revcom{\n   my ($self) = @_;\n\t\t# this is the cleanest way\n\tmy @qualities = @{$self->qual()};\n\tmy @reversed_qualities = reverse(@qualities);\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::Seq::PrimaryQual';\n\t\t# Wassat?\n\t\t# $self->_attempt_to_load_Seq();\n   }\n\t# the \\@reverse_qualities thing works simply because I will it to work.\n   my $out = $seqclass->new( '-qual' => \\@reversed_qualities,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n=head2 trunc()\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n Returns : a fresh Bio::Seq::QualI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc {\n   my ($self,$start,$end) = @_;\n\n   if( !$end ) {\n       if( $self->can('throw')  ) {\n\t   $self->throw(\"trunc start,end\");\n       } else {\n\t   confess(\"[$self] trunc start,end\");\n       }\n   }\n\n   if( $end < $start ) {\n       if( $self->can('throw')  ) {\n\t   $self->throw(\"$end is smaller than $start. if you want to truncated and reverse complement, you must call trunc followed by revcom. Sorry.\");\n       } else {\n\t   confess(\"[$self] $end is smaller than $start. If you want to truncated and reverse complement, you must call trunc followed by revcom. Sorry.\");\n       }\n   }\n\n   my $r_qual = $self->subqual($start,$end);\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::Seq::PrimaryQual';\n\t\t# wassat?\n\t\t# $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-qual' => $r_qual,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate()\n\n Title   : translate()\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n           #if full CDS expected:\n           $protein_seq_obj = $cds_seq_obj->translate(undef,undef,undef,undef,1);\n Function: Completely useless in this interface.\n Returns : Nothing.\n Args    : Nothing.\n\n\n\nsub translate {\n\treturn 0;\n}\n\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id()\n Function: ID of the quality. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :\n\n\n\nsub  id {\n   my ($self)= @_;\n   return $self->display_id();\n}\n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $qual->length();\n Function: Return the length of the array holding the quality values.\n        Under most circumstances, this should match the number of quality\n        values but no validation is done when the PrimaryQual object is\n        constructed and non-digits could be put into this array. Is this a\n        bug? Just enough rope...\n Returns : A scalar (the number of elements in the quality array).\n Args    : None.\n\n\nsub length {\n   my ($self)= @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of length - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of length - implementing class did not provide this method\");\n   }\n}\n\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval);\n           $description = $seq->desc();\n Function: Get/set description text for a qual object\n Example :\n Returns : value of desc\n Args    : newvalue (optional)","label":"desc($self,$value)"},"kind":12,"range":{"end":{"line":500,"character":9999},"start":{"character":0,"line":492}},"line":492},{"name":"_attempt_to_load_Seq","containerName":"main::","children":[{"localvar":"my","containerName":"_attempt_to_load_Seq","kind":13,"name":"$self","line":526,"definition":"my"},{"name":"$main","containerName":"_attempt_to_load_Seq","kind":13,"line":528},{"line":535,"kind":13,"containerName":"_attempt_to_load_Seq","name":"$self"},{"kind":12,"containerName":"_attempt_to_load_Seq","name":"can","line":535},{"line":536,"containerName":"_attempt_to_load_Seq","kind":13,"name":"$self"},{"line":536,"name":"throw","containerName":"_attempt_to_load_Seq","kind":12}],"detail":"($self)","definition":"sub","range":{"end":{"line":545,"character":9999},"start":{"line":525,"character":0}},"kind":12,"line":525,"signature":{"label":"_attempt_to_load_Seq($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : \n\n\nsub qual {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subseq(10,40)};\n Function: returns the quality values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo bases of the sequence. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id() _or_\n\t   $id_string = $obj->display_id($new_display_id);\n Function: Returns the display id, aka the common name of the Quality \n\tobject.\n\tThe semantics of this is that it is the most likely string to be\n\tused as an identifier of the quality sequence, and likely to have\n\t\"human\" readability.  The id is equivalent to the ID field of the\n\tGenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n\tdatabase. In fasta format, the >(\\S+) is presumed to be the id,\n\tthough some people overload the id to embed other information.\n\tBioperl does not use any embedded information in the ID field,\n\tand people are encouraged to use other mechanisms (accession field\n\tfor example, or extending the sequence object) to solve this.\n\tNotice that $seq->id() maps to this function, mainly for \n\tlegacy/convience issues\n Returns : A string\n Args    : If an arg is provided, it will replace the existing display_id\n\tin the object.\n\n\n\nsub display_id {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number(); _or_\n\t   $unique_biological_key = $obj->accession_number($new_acc_num);\n Function: Returns the unique biological id for a sequence, commonly \n\tcalled the accession_number. For sequences from established \n\tdatabases, the implementors should try to use the correct \n\taccession number. Notice that primary_id() provides the unique id \n\tfor the implemetation, allowing multiple objects to have the same\n\taccession number in a particular implementation. For sequences\n\twith no accession number, this method should return \"unknown\".\n Returns : A string.\n Args    : If an arg is provided, it will replace the existing\n\taccession_number in the object.\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   }\n\n}\n\n\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id(); _or_\n\t   $unique_implementation_key = $obj->primary_id($new_prim_id);\n Function: Returns the unique id for this object in this implementation.\n\tThis allows implementations to manage their own object ids in a\n\tway the implementaiton can control clients can expect one id to\n\tmap to one object. For sequences with no accession number, this\n\tmethod should return a stringified memory location.\n Returns : A string\n Args    : If an arg is provided, it will replace the existing\n\tprimary_id in the object.\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 can_call_new()\n\n Title   : can_call_new()\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending on whether an\n\timplementation allows new constructor to be called. If a new\n\tconstructor is allowed, then it should take the followed hashed\n\tconstructor list.\n           $myobject->new( -qual => $quality_as_string,\n\t\t\t   -display_id  => $id,\n\t\t\t   -accession_number => $accession,\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n   # we default to 0 here\n   return 0;\n}\n\n=head2 qualat($position)\n\n Title   : qualat($position)\n Usage   : $quality = $obj->qualat(10);\n Function: Return the quality value at the given location, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the first\n        two bases of the sequence. Start cannot be larger than end but can\n        be equal.\n Returns : A scalar.\n Args    : A position.\n\n\nsub qualat {\n   my ($self,$value) = @_;\n   if( $self->can('warn') ) {\n       $self->warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   } else {\n       warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   }\n   return '';\n} \n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. A implementing\nclass does not need to provide these functions, as they will be\nprovided by this class, but is free to override these functions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : @rev = @{$qual->revcom()};\n Function: Produces a new Bio::Seq::QualI implementing object which\n\tis reversed from the original quality array.\n\tThe id is the same id as the orginal sequence, and the accession number\n\tis also indentical. If someone wants to track that this sequence has\n\tbeen reversed, it needs to define its own extensions\n\n\tTo do an inplace edit of an object you can go:\n\n\t$qual = $qual->revcom();\n\n\tThis of course, causes Perl to handle the garbage collection of the old\n\tobject, but it is roughly speaking as efficient as an inplace edit.\n Returns : A new (fresh) Bio::Seq::PrimaryQualI object\n Args    : none\n\n\nsub revcom{\n   my ($self) = @_;\n\t\t# this is the cleanest way\n\tmy @qualities = @{$self->qual()};\n\tmy @reversed_qualities = reverse(@qualities);\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::Seq::PrimaryQual';\n\t\t# Wassat?\n\t\t# $self->_attempt_to_load_Seq();\n   }\n\t# the \\@reverse_qualities thing works simply because I will it to work.\n   my $out = $seqclass->new( '-qual' => \\@reversed_qualities,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n=head2 trunc()\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n Returns : a fresh Bio::Seq::QualI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc {\n   my ($self,$start,$end) = @_;\n\n   if( !$end ) {\n       if( $self->can('throw')  ) {\n\t   $self->throw(\"trunc start,end\");\n       } else {\n\t   confess(\"[$self] trunc start,end\");\n       }\n   }\n\n   if( $end < $start ) {\n       if( $self->can('throw')  ) {\n\t   $self->throw(\"$end is smaller than $start. if you want to truncated and reverse complement, you must call trunc followed by revcom. Sorry.\");\n       } else {\n\t   confess(\"[$self] $end is smaller than $start. If you want to truncated and reverse complement, you must call trunc followed by revcom. Sorry.\");\n       }\n   }\n\n   my $r_qual = $self->subqual($start,$end);\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::Seq::PrimaryQual';\n\t\t# wassat?\n\t\t# $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-qual' => $r_qual,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate()\n\n Title   : translate()\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n           #if full CDS expected:\n           $protein_seq_obj = $cds_seq_obj->translate(undef,undef,undef,undef,1);\n Function: Completely useless in this interface.\n Returns : Nothing.\n Args    : Nothing.\n\n\n\nsub translate {\n\treturn 0;\n}\n\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id()\n Function: ID of the quality. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :\n\n\n\nsub  id {\n   my ($self)= @_;\n   return $self->display_id();\n}\n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $qual->length();\n Function: Return the length of the array holding the quality values.\n        Under most circumstances, this should match the number of quality\n        values but no validation is done when the PrimaryQual object is\n        constructed and non-digits could be put into this array. Is this a\n        bug? Just enough rope...\n Returns : A scalar (the number of elements in the quality array).\n Args    : None.\n\n\nsub length {\n   my ($self)= @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of length - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of length - implementing class did not provide this method\");\n   }\n}\n\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval);\n           $description = $seq->desc();\n Function: Get/set description text for a qual object\n Example :\n Returns : value of desc\n Args    : newvalue (optional)\n\n\nsub desc {\n   my ($self,$value) = @_;\n   if( $self->can('warn') ) {\n       $self->warn(\"Bio::Seq::QualI definition of desc - implementing class did not provide this method\");\n   } else {\n       warn(\"Bio::Seq::QualI definition of desc - implementing class did not provide this method\");\n   }\n   return '';\n}\n\n#  These methods are here for backward compatibility with the old, 0.5\n#  Seq objects. They all throw warnings that someone is using a\n#  deprecated method, and may eventually be removed completely from\n#  this object. However, they are important to ease the transition from\n#  the old system.\n\n=head1 Private functions\n\nThese are some private functions for the PrimarySeqI interface. You do not\nneed to implement these functions\n\n=head2 _attempt_to_load_Seq\n\n Title   : _attempt_to_load_Seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :"}},{"kind":12,"containerName":"Seq::PrimaryQual","name":"Bio","line":534},{"line":538,"name":"confess","kind":12},{"definition":"sub","detail":"($self,@args)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"qualtype","line":564,"definition":"my"},{"name":"@args","containerName":"qualtype","kind":13,"line":564},{"line":565,"containerName":"qualtype","kind":13,"name":"$self"},{"line":565,"name":"can","kind":12,"containerName":"qualtype"},{"kind":13,"containerName":"qualtype","name":"$self","line":567},{"line":567,"containerName":"qualtype","kind":12,"name":"throw"}],"name":"qualtype","containerName":"main::","signature":{"label":"qualtype($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: QualI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::QualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::QualI - Interface definition for a Bio::Seq::Qual\n\n=head1 SYNOPSIS\n\n    # get a Bio::Seq::Qual compliant object somehow\n\n    # to test this is a seq object\n\n    $obj->isa(\"Bio::Seq::QualI\") \n       || $obj->throw(\"$obj does not implement the Bio::Seq::QualI interface\");\n\n    # accessors\n\n    $string    = $obj->qual();\n    $substring = $obj->subqual(12,50);\n    $display   = $obj->display_id(); # for human display\n    $id        = $obj->primary_id(); # unique id for this object,\n                                     # implementation defined\n    $unique_key= $obj->accession_number();\n                       # unique biological id\n\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic quality\ninformation. PrimaryQual is an object just for the quality and its\nname(s), nothing more. There is a pure perl implementation of this in\nBio::Seq::PrimaryQual. If you just want to use Bio::Seq::PrimaryQual\nobjects, then please read that module first. This module defines the\ninterface, and is of more interest to people who want to wrap their\nown Perl Objects/RDBs/FileSystems etc in way that they \"are\" bioperl\nquality objects, even though it is not using Perl to store the\nsequence etc.\n\nThis interface defines what bioperl consideres necessary to \"be\" a\nsequence of qualities, without providing an implementation of\nthis. (An implementation is provided in Bio::Seq::PrimaryQual). If you\nwant to provide a Bio::Seq::PrimaryQual 'compliant' object which in\nfact wraps another object/database/out-of-perl experience, then this\nis the correct thing to wrap, generally by providing a wrapper class\nwhich would inherit from your object and this Bio::Seq::QualI\ninterface. The wrapper class then would have methods lists in the\n\"Implementation Specific Functions\" which would provide these methods\nfor your object.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nThis module is heavily based on Bio::Seq::PrimarySeq and is modeled after\nor outright copies sections of it. Thanks Ewan!\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::QualI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n\tquality values. The individual elements of the quality array are\n\tnot validated and can be any numeric value.\n Returns : A reference to an array.\n Status  : \n\n\nsub qual {\n   my ($self) = @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subseq(10,40)};\n Function: returns the quality values from $start to $end, where the\n\tfirst value is 1 and the number is inclusive, ie 1-2 are the first\n\ttwo bases of the sequence. Start cannot be larger than end but can\n\tbe equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of subqual - implementing class did not provide this method\");\n   }\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id() _or_\n\t   $id_string = $obj->display_id($new_display_id);\n Function: Returns the display id, aka the common name of the Quality \n\tobject.\n\tThe semantics of this is that it is the most likely string to be\n\tused as an identifier of the quality sequence, and likely to have\n\t\"human\" readability.  The id is equivalent to the ID field of the\n\tGenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n\tdatabase. In fasta format, the >(\\S+) is presumed to be the id,\n\tthough some people overload the id to embed other information.\n\tBioperl does not use any embedded information in the ID field,\n\tand people are encouraged to use other mechanisms (accession field\n\tfor example, or extending the sequence object) to solve this.\n\tNotice that $seq->id() maps to this function, mainly for \n\tlegacy/convience issues\n Returns : A string\n Args    : If an arg is provided, it will replace the existing display_id\n\tin the object.\n\n\n\nsub display_id {\n   my ($self) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of id - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number(); _or_\n\t   $unique_biological_key = $obj->accession_number($new_acc_num);\n Function: Returns the unique biological id for a sequence, commonly \n\tcalled the accession_number. For sequences from established \n\tdatabases, the implementors should try to use the correct \n\taccession number. Notice that primary_id() provides the unique id \n\tfor the implemetation, allowing multiple objects to have the same\n\taccession number in a particular implementation. For sequences\n\twith no accession number, this method should return \"unknown\".\n Returns : A string.\n Args    : If an arg is provided, it will replace the existing\n\taccession_number in the object.\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of seq - implementing class did not provide this method\");\n   }\n\n}\n\n\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id(); _or_\n\t   $unique_implementation_key = $obj->primary_id($new_prim_id);\n Function: Returns the unique id for this object in this implementation.\n\tThis allows implementations to manage their own object ids in a\n\tway the implementaiton can control clients can expect one id to\n\tmap to one object. For sequences with no accession number, this\n\tmethod should return a stringified memory location.\n Returns : A string\n Args    : If an arg is provided, it will replace the existing\n\tprimary_id in the object.\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of qual - implementing class did not provide this method\");\n   }\n\n}\n\n\n=head2 can_call_new()\n\n Title   : can_call_new()\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: can_call_new returns 1 or 0 depending on whether an\n\timplementation allows new constructor to be called. If a new\n\tconstructor is allowed, then it should take the followed hashed\n\tconstructor list.\n           $myobject->new( -qual => $quality_as_string,\n\t\t\t   -display_id  => $id,\n\t\t\t   -accession_number => $accession,\n\t\t\t   );\n Example :\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n   # we default to 0 here\n   return 0;\n}\n\n=head2 qualat($position)\n\n Title   : qualat($position)\n Usage   : $quality = $obj->qualat(10);\n Function: Return the quality value at the given location, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the first\n        two bases of the sequence. Start cannot be larger than end but can\n        be equal.\n Returns : A scalar.\n Args    : A position.\n\n\nsub qualat {\n   my ($self,$value) = @_;\n   if( $self->can('warn') ) {\n       $self->warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   } else {\n       warn(\"Bio::Seq::QualI definition of qualat - implementing class did not provide this method\");\n   }\n   return '';\n} \n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. A implementing\nclass does not need to provide these functions, as they will be\nprovided by this class, but is free to override these functions.\n\nAll of revcom(), trunc(), and translate() create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : @rev = @{$qual->revcom()};\n Function: Produces a new Bio::Seq::QualI implementing object which\n\tis reversed from the original quality array.\n\tThe id is the same id as the orginal sequence, and the accession number\n\tis also indentical. If someone wants to track that this sequence has\n\tbeen reversed, it needs to define its own extensions\n\n\tTo do an inplace edit of an object you can go:\n\n\t$qual = $qual->revcom();\n\n\tThis of course, causes Perl to handle the garbage collection of the old\n\tobject, but it is roughly speaking as efficient as an inplace edit.\n Returns : A new (fresh) Bio::Seq::PrimaryQualI object\n Args    : none\n\n\nsub revcom{\n   my ($self) = @_;\n\t\t# this is the cleanest way\n\tmy @qualities = @{$self->qual()};\n\tmy @reversed_qualities = reverse(@qualities);\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::Seq::PrimaryQual';\n\t\t# Wassat?\n\t\t# $self->_attempt_to_load_Seq();\n   }\n\t# the \\@reverse_qualities thing works simply because I will it to work.\n   my $out = $seqclass->new( '-qual' => \\@reversed_qualities,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n=head2 trunc()\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n Returns : a fresh Bio::Seq::QualI implementing object\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc {\n   my ($self,$start,$end) = @_;\n\n   if( !$end ) {\n       if( $self->can('throw')  ) {\n\t   $self->throw(\"trunc start,end\");\n       } else {\n\t   confess(\"[$self] trunc start,end\");\n       }\n   }\n\n   if( $end < $start ) {\n       if( $self->can('throw')  ) {\n\t   $self->throw(\"$end is smaller than $start. if you want to truncated and reverse complement, you must call trunc followed by revcom. Sorry.\");\n       } else {\n\t   confess(\"[$self] $end is smaller than $start. If you want to truncated and reverse complement, you must call trunc followed by revcom. Sorry.\");\n       }\n   }\n\n   my $r_qual = $self->subqual($start,$end);\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::Seq::PrimaryQual';\n\t\t# wassat?\n\t\t# $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-qual' => $r_qual,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-desc' => $self->desc()\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate()\n\n Title   : translate()\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n           #if full CDS expected:\n           $protein_seq_obj = $cds_seq_obj->translate(undef,undef,undef,undef,1);\n Function: Completely useless in this interface.\n Returns : Nothing.\n Args    : Nothing.\n\n\n\nsub translate {\n\treturn 0;\n}\n\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id()\n Function: ID of the quality. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Example :\n Returns : A string.\n Args    :\n\n\n\nsub  id {\n   my ($self)= @_;\n   return $self->display_id();\n}\n\n=head2 length()\n\n Title   : length()\n Usage   : $length = $qual->length();\n Function: Return the length of the array holding the quality values.\n        Under most circumstances, this should match the number of quality\n        values but no validation is done when the PrimaryQual object is\n        constructed and non-digits could be put into this array. Is this a\n        bug? Just enough rope...\n Returns : A scalar (the number of elements in the quality array).\n Args    : None.\n\n\nsub length {\n   my ($self)= @_;\n   if( $self->can('throw') ) {\n       $self->throw(\"Bio::Seq::QualI definition of length - implementing class did not provide this method\");\n   } else {\n       confess(\"Bio::Seq::QualI definition of length - implementing class did not provide this method\");\n   }\n}\n\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval);\n           $description = $seq->desc();\n Function: Get/set description text for a qual object\n Example :\n Returns : value of desc\n Args    : newvalue (optional)\n\n\nsub desc {\n   my ($self,$value) = @_;\n   if( $self->can('warn') ) {\n       $self->warn(\"Bio::Seq::QualI definition of desc - implementing class did not provide this method\");\n   } else {\n       warn(\"Bio::Seq::QualI definition of desc - implementing class did not provide this method\");\n   }\n   return '';\n}\n\n#  These methods are here for backward compatibility with the old, 0.5\n#  Seq objects. They all throw warnings that someone is using a\n#  deprecated method, and may eventually be removed completely from\n#  this object. However, they are important to ease the transition from\n#  the old system.\n\n=head1 Private functions\n\nThese are some private functions for the PrimarySeqI interface. You do not\nneed to implement these functions\n\n=head2 _attempt_to_load_Seq\n\n Title   : _attempt_to_load_Seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _attempt_to_load_Seq{\n   my ($self) = @_;\n\n   if( $main::{'Bio::Seq::PrimaryQual'} ) {\n       return 1;\n   } else {\n       eval {\n\t   require Bio::Seq::PrimaryQual;\n       };\n       if( $@ ) {\n\t   if( $self->can('throw') ) {\n\t       $self->throw(\"Bio::Seq::PrimaryQual could not be loaded for $self\\nThis indicates that you are using Bio::Seq::PrimaryQualI without Bio::Seq::PrimaryQual loaded and without providing a complete solution\\nThe most likely problem is that there has been a misconfiguration of the bioperl environment\\nActual exception\\n\\n$@\\n\");\n\t   } else {\n\t       confess(\"Bio::Seq::PrimarySeq could not be loaded for $self\\nThis indicates that you are usnig Bio::Seq::PrimaryQualI without Bio::Seq::PrimaryQual loaded and without providing a complete solution\\nThe most likely problem is that there has been a misconfiguration of the bioperl environment\\nActual exception\\n\\n$@\\n\");\n\t   }\n\t   return 0;\n       }\n       return 1;\n   }\n\n}\n\n\n=head2 qualtype()\n\n Title   : qualtype()\n Usage   : if( $obj->qualtype eq 'phd' ) { /Do Something/ }\n Function: At this time, this function is not used for \n\tBio::Seq::PrimaryQual objects. In fact, now it is a month later and\n\tI just completed the Bio::Seq::SeqWithQuality object and this is\n\tdefinitely deprecated.\n Returns : Nothing. (not implemented)\n Args    : none\n Status  : Virtual"},"line":563,"range":{"start":{"character":0,"line":563},"end":{"line":574,"character":9999}},"kind":12},{"kind":12,"name":"confess","line":570}],"version":5}