{"version":5,"vars":[{"kind":2,"containerName":"","name":"vars","line":102},{"line":106,"containerName":"","kind":2,"name":"base"},{"kind":12,"range":{"end":{"character":9999,"line":160},"start":{"line":129,"character":0}},"line":129,"signature":{"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"name":"$class","kind":13,"localvar":"my","containerName":"new","line":130,"definition":"my"},{"line":130,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$self","line":131},{"name":"$class","kind":13,"containerName":"new","line":131},{"line":131,"kind":13,"containerName":"new","name":"@args"},{"line":134,"kind":13,"localvar":"my","containerName":"new","name":"$qual","definition":"my"},{"name":"$id","containerName":"new","kind":13,"line":134},{"name":"$acc","kind":13,"containerName":"new","line":134},{"line":134,"name":"$pid","containerName":"new","kind":13},{"line":134,"name":"$desc","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$given_id","line":134},{"name":"$header","containerName":"new","kind":13,"line":134},{"name":"$self","kind":13,"containerName":"new","line":135},{"line":135,"containerName":"new","kind":12,"name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":143},{"line":144,"kind":13,"containerName":"new","name":"$id"},{"containerName":"new","kind":13,"name":"$given_id","line":144},{"containerName":"new","kind":13,"name":"$id","line":145},{"name":"$given_id","kind":13,"containerName":"new","line":145},{"line":146,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"throw","line":146},{"line":149,"name":"$given_id","kind":13,"containerName":"new"},{"name":"$id","kind":13,"containerName":"new","line":149},{"line":149,"kind":13,"containerName":"new","name":"$given_id"},{"name":"$self","containerName":"new","kind":13,"line":152},{"name":"qual","kind":12,"containerName":"new","line":152},{"line":152,"containerName":"new","kind":13,"name":"$qual"},{"kind":13,"containerName":"new","name":"$qual","line":152},{"line":153,"name":"$header","kind":13,"containerName":"new"},{"line":153,"kind":13,"containerName":"new","name":"$self"},{"line":153,"name":"header","kind":12,"containerName":"new"},{"line":153,"name":"$header","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$id","line":154},{"line":154,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"display_id","line":154},{"line":154,"kind":13,"containerName":"new","name":"$id"},{"line":155,"kind":13,"containerName":"new","name":"$acc"},{"containerName":"new","kind":13,"name":"$self","line":155},{"line":155,"name":"accession_number","containerName":"new","kind":12},{"line":155,"kind":13,"containerName":"new","name":"$acc"},{"name":"$pid","containerName":"new","kind":13,"line":156},{"name":"$self","kind":13,"containerName":"new","line":156},{"line":156,"containerName":"new","kind":12,"name":"primary_id"},{"line":156,"name":"$pid","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$desc","line":157},{"line":157,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"desc","line":157},{"line":157,"kind":13,"containerName":"new","name":"$desc"},{"line":159,"containerName":"new","kind":13,"name":"$self"}],"detail":"($class,@args)","definition":"sub"},{"line":131,"kind":12,"containerName":"new","name":"SUPER"},{"containerName":"main::","name":"qual","children":[{"line":174,"localvar":"my","kind":13,"containerName":"qual","name":"$self","definition":"my"},{"containerName":"qual","kind":13,"name":"$value","line":174},{"containerName":"qual","kind":13,"name":"$value","line":176},{"line":176,"containerName":"qual","kind":13,"name":"$value"},{"name":"$self","kind":13,"containerName":"qual","line":177},{"line":178,"kind":13,"containerName":"qual","name":"$value"},{"kind":13,"containerName":"qual","name":"$self","line":180},{"line":180,"kind":13,"containerName":"qual","name":"$value"},{"containerName":"qual","kind":13,"name":"$self","line":181},{"name":"validate_qual","kind":12,"containerName":"qual","line":181},{"line":181,"name":"$value","kind":13,"containerName":"qual"},{"line":182,"kind":13,"containerName":"qual","name":"$self"},{"line":182,"kind":12,"containerName":"qual","name":"throw"},{"name":"$value","kind":13,"containerName":"qual","line":184},{"line":185,"containerName":"qual","kind":13,"name":"$self"},{"line":185,"kind":13,"containerName":"qual","name":"$value"},{"line":188,"containerName":"qual","kind":13,"name":"$self"}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"end":{"line":189,"character":9999},"start":{"line":173,"character":0}},"line":173,"signature":{"label":"qual($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array."}},{"detail":"($self,$qualstr)","definition":"sub","name":"validate_qual","containerName":"main::","children":[{"line":208,"name":"$self","containerName":"validate_qual","localvar":"my","kind":13,"definition":"my"},{"containerName":"validate_qual","kind":13,"name":"$qualstr","line":208},{"kind":13,"containerName":"validate_qual","name":"$qualstr","line":212},{"line":212,"name":"$qualstr","kind":13,"containerName":"validate_qual"},{"name":"$qualstr","containerName":"validate_qual","kind":13,"line":213}],"signature":{"parameters":[{"label":"$self"},{"label":"$qualstr"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.","label":"validate_qual($self,$qualstr)"},"kind":12,"range":{"end":{"line":216,"character":9999},"start":{"character":0,"line":205}},"line":205},{"line":212,"kind":12,"containerName":"length","name":"CORE"},{"signature":{"parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position","label":"subqual($self,$start,$end)"},"range":{"end":{"line":247,"character":9999},"start":{"character":0,"line":232}},"kind":12,"line":232,"detail":"($self,$start,$end)","definition":"sub","containerName":"main::","name":"subqual","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"subqual","name":"$self","line":233},{"line":233,"kind":13,"containerName":"subqual","name":"$start"},{"line":233,"name":"$end","kind":13,"containerName":"subqual"},{"line":235,"name":"$start","kind":13,"containerName":"subqual"},{"kind":13,"containerName":"subqual","name":"$end","line":235},{"name":"$self","kind":13,"containerName":"subqual","line":236},{"line":236,"name":"throw","containerName":"subqual","kind":12},{"name":"$start","containerName":"subqual","kind":13,"line":239},{"kind":13,"containerName":"subqual","name":"$end","line":239},{"line":239,"containerName":"subqual","kind":13,"name":"$self"},{"name":"length","kind":12,"containerName":"subqual","line":239},{"containerName":"subqual","kind":13,"name":"$self","line":240},{"line":240,"name":"throw","containerName":"subqual","kind":12},{"name":"$self","kind":13,"containerName":"subqual","line":240},{"line":240,"name":"length","containerName":"subqual","kind":12},{"name":"$start","kind":13,"containerName":"subqual","line":245},{"line":246,"containerName":"subqual","kind":13,"name":"$end"},{"definition":"my","containerName":"subqual","localvar":"my","kind":13,"name":"@sub_qual_array","line":247},{"name":"$self","containerName":"subqual","kind":13,"line":247}]},{"kind":12,"name":"qual","line":247},{"name":"$start","kind":13,"containerName":null,"line":247},{"kind":13,"containerName":null,"name":"$end","line":247},{"name":"@sub_qual_array","kind":13,"containerName":null,"line":250},{"signature":{"label":"display_id($obj,$value)","documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None","parameters":[{"label":"$obj"},{"label":"$value"}]},"line":276,"kind":12,"range":{"start":{"character":0,"line":276},"end":{"line":283,"character":9999}},"definition":"sub","detail":"($obj,$value)","children":[{"line":277,"name":"$obj","localvar":"my","kind":13,"containerName":"display_id","definition":"my"},{"line":277,"name":"$value","containerName":"display_id","kind":13},{"line":278,"name":"$value","kind":13,"containerName":"display_id"},{"line":279,"name":"$obj","kind":13,"containerName":"display_id"},{"containerName":"display_id","kind":13,"name":"$value","line":279},{"line":281,"name":"$obj","kind":13,"containerName":"display_id"}],"containerName":"main::","name":"display_id"},{"signature":{"label":"header($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 header()\n\n Title   : header()\n Usage   : $header = $obj->header();\n Function: Get/set the header that the user wants printed for this\n     quality object.\n Returns : A string\n Args    : None"},"range":{"end":{"line":303,"character":9999},"start":{"character":0,"line":296}},"kind":12,"line":296,"detail":"($obj,$value)","definition":"sub","name":"header","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"header","name":"$obj","line":297,"definition":"my"},{"name":"$value","kind":13,"containerName":"header","line":297},{"name":"$value","kind":13,"containerName":"header","line":298},{"name":"$obj","kind":13,"containerName":"header","line":299},{"line":299,"kind":13,"containerName":"header","name":"$value"},{"line":301,"name":"$obj","containerName":"header","kind":13}]},{"containerName":"main::","name":"accession_number","children":[{"line":322,"kind":13,"localvar":"my","containerName":"accession_number","name":"$obj","definition":"my"},{"name":"$acc","containerName":"accession_number","kind":13,"line":322},{"line":324,"name":"$acc","kind":13,"containerName":"accession_number"},{"containerName":"accession_number","kind":13,"name":"$obj","line":325},{"line":325,"name":"$acc","kind":13,"containerName":"accession_number"},{"line":327,"name":"$acc","kind":13,"containerName":"accession_number"},{"name":"$obj","kind":13,"containerName":"accession_number","line":327},{"name":"$acc","containerName":"accession_number","kind":13,"line":328},{"containerName":"accession_number","kind":13,"name":"$acc","line":328},{"name":"$acc","containerName":"accession_number","kind":13,"line":330}],"detail":"($obj,$acc)","definition":"sub","kind":12,"range":{"start":{"line":321,"character":0},"end":{"character":9999,"line":331}},"line":321,"signature":{"parameters":[{"label":"$obj"},{"label":"$acc"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 header()\n\n Title   : header()\n Usage   : $header = $obj->header();\n Function: Get/set the header that the user wants printed for this\n     quality object.\n Returns : A string\n Args    : None\n\n\nsub header {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'header'} = $value;\n    }\n    return $obj->{'header'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n        called the accession_number. For sequences from established\n        databases, the implementors should try to use the correct\n        accession number. Notice that primary_id() provides the unique id\n        for the implemetation, allowing multiple objects to have the same\n        accession number in a particular implementation. For sequences\n        with no accession number, this method should return \"unknown\".\n Returns : A string\n Args    : None","label":"accession_number($obj,$acc)"}},{"children":[{"name":"$obj","containerName":"primary_id","localvar":"my","kind":13,"line":348,"definition":"my"},{"line":348,"containerName":"primary_id","kind":13,"name":"$value"},{"line":349,"containerName":"primary_id","kind":13,"name":"$value"},{"line":350,"name":"$obj","containerName":"primary_id","kind":13},{"line":350,"containerName":"primary_id","kind":13,"name":"$value"},{"line":352,"name":"$obj","kind":13,"containerName":"primary_id"}],"name":"primary_id","containerName":"main::","definition":"sub","detail":"($obj,$value)","line":347,"kind":12,"range":{"start":{"character":0,"line":347},"end":{"line":354,"character":9999}},"signature":{"label":"primary_id($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 header()\n\n Title   : header()\n Usage   : $header = $obj->header();\n Function: Get/set the header that the user wants printed for this\n     quality object.\n Returns : A string\n Args    : None\n\n\nsub header {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'header'} = $value;\n    }\n    return $obj->{'header'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n        called the accession_number. For sequences from established\n        databases, the implementors should try to use the correct\n        accession number. Notice that primary_id() provides the unique id\n        for the implemetation, allowing multiple objects to have the same\n        accession number in a particular implementation. For sequences\n        with no accession number, this method should return \"unknown\".\n Returns : A string\n Args    : None\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n        This allows implementations to manage their own object ids in a\n        way the implementaiton can control clients can expect one id to\n        map to one object. For sequences with no accession number, this\n        method should return a stringified memory location.\n Returns : A string\n Args    : None"}},{"line":368,"kind":12,"range":{"start":{"line":368,"character":0},"end":{"line":375,"character":9999}},"signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 header()\n\n Title   : header()\n Usage   : $header = $obj->header();\n Function: Get/set the header that the user wants printed for this\n     quality object.\n Returns : A string\n Args    : None\n\n\nsub header {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'header'} = $value;\n    }\n    return $obj->{'header'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n        called the accession_number. For sequences from established\n        databases, the implementors should try to use the correct\n        accession number. Notice that primary_id() provides the unique id\n        for the implemetation, allowing multiple objects to have the same\n        accession number in a particular implementation. For sequences\n        with no accession number, this method should return \"unknown\".\n Returns : A string\n Args    : None\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n        This allows implementations to manage their own object ids in a\n        way the implementaiton can control clients can expect one id to\n        map to one object. For sequences with no accession number, this\n        method should return a stringified memory location.\n Returns : A string\n Args    : None\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval);\n           $description = $qual->desc();\n Function: Get/set description text for a qual object\n Example :\n Returns : Value of desc\n Args    : newvalue (optional)","label":"desc($obj,$value)"},"children":[{"definition":"my","containerName":"desc","localvar":"my","kind":13,"name":"$obj","line":369},{"line":369,"containerName":"desc","kind":13,"name":"$value"},{"kind":13,"containerName":"desc","name":"$value","line":370},{"kind":13,"containerName":"desc","name":"$obj","line":371},{"name":"$value","containerName":"desc","kind":13,"line":371},{"line":373,"containerName":"desc","kind":13,"name":"$obj"}],"containerName":"main::","name":"desc","definition":"sub","detail":"($obj,$value)"},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"id","line":390},{"name":"$value","containerName":"id","kind":13,"line":390},{"kind":13,"containerName":"id","name":"$value","line":391},{"line":392,"kind":13,"containerName":"id","name":"$self"},{"line":392,"kind":12,"containerName":"id","name":"display_id"},{"line":392,"containerName":"id","kind":13,"name":"$value"},{"line":394,"name":"$self","kind":13,"containerName":"id"},{"line":394,"containerName":"id","kind":12,"name":"display_id"}],"containerName":"main::","name":"id","signature":{"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 header()\n\n Title   : header()\n Usage   : $header = $obj->header();\n Function: Get/set the header that the user wants printed for this\n     quality object.\n Returns : A string\n Args    : None\n\n\nsub header {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'header'} = $value;\n    }\n    return $obj->{'header'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n        called the accession_number. For sequences from established\n        databases, the implementors should try to use the correct\n        accession number. Notice that primary_id() provides the unique id\n        for the implemetation, allowing multiple objects to have the same\n        accession number in a particular implementation. For sequences\n        with no accession number, this method should return \"unknown\".\n Returns : A string\n Args    : None\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n        This allows implementations to manage their own object ids in a\n        way the implementaiton can control clients can expect one id to\n        map to one object. For sequences with no accession number, this\n        method should return a stringified memory location.\n Returns : A string\n Args    : None\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval);\n           $description = $qual->desc();\n Function: Get/set description text for a qual object\n Example :\n Returns : Value of desc\n Args    : newvalue (optional)\n\n\nsub desc {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n    }\n    return $obj->{'desc'};\n\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n\tactually is in the implementation provided here) just a synonym\n\tfor display_id().\n Returns : A string.\n Args    : None.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"id($self,$value)"},"line":389,"range":{"end":{"line":395,"character":9999},"start":{"character":0,"line":389}},"kind":12},{"line":411,"range":{"start":{"line":411,"character":0},"end":{"character":9999,"line":416}},"kind":12,"definition":"sub","children":[{"definition":"my","containerName":"length","localvar":"my","kind":13,"name":"$self","line":412},{"containerName":"length","kind":13,"name":"$self","line":413},{"kind":13,"containerName":"length","name":"$self","line":414},{"kind":12,"containerName":"length","name":"warn","line":414},{"containerName":"length","kind":13,"name":"$self","line":414},{"kind":13,"containerName":"length","name":"$self","line":414},{"line":416,"kind":13,"containerName":"length","name":"$self"}],"name":"length","containerName":"main::"},{"name":"qual","kind":12,"line":413},{"line":414,"name":"qual","kind":12},{"line":414,"name":"qual","kind":12},{"kind":12,"name":"qual","line":416},{"signature":{"label":"qualat($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: PrimaryQual.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimaryQual\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics@dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::PrimaryQual - Bioperl lightweight Quality Object\n\n=head1 SYNOPSIS\n\n use Bio::Seq::PrimaryQual;\n\n # you can use either a space-delimited string for quality\n\n my $string_quals = \"10 20 30 40 50 40 30 20 10\";\n my $qualobj = Bio::Seq::PrimaryQual->new\n \t      ( '-qual' => $string_quals,\n \t\t'-id'  => 'QualityFragment-12',\n \t\t'-accession_number' => 'X78121',\n \t\t);\n\n # _or_ you can use an array of quality values\n\n my @q2 = split/ /,$string_quals;\n $qualobj = Bio::Seq::PrimaryQual->new( '-qual' => \\@q2,\n       '-primary_id'     =>      'chads primary_id',\n       '-desc'           =>      'chads desc',\n       '-accession_number' => 'chads accession_number',\n      '-id'             =>      'chads id'\n      );\n\n # to get the quality values out:\n\n my @quals = @{$qualobj->qual()};\n\n # to give _new_ quality values\n\n my $newqualstring = \"50 90 1000 20 12 0 0\";\n $qualobj->qual($newqualstring);\n\n\n=head1 DESCRIPTION\n\nThis module provides a mechanism for storing quality\nvalues. Much more useful as part of\nBio::Seq::SeqWithQuality where these quality values\nare associated with the sequence information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics@dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::PrimaryQual;\nuse vars qw(%valid_type);\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Seq::QualI);\n\n\n=head2 new()\n\n Title   : new()\n Usage   : $qual = Bio::Seq::PrimaryQual->new\n\t( -qual => '10 20 30 40 50 50 20 10',\n\t  -id  => 'human_id',\n\t  -accession_number => 'AL000012',\n\t);\n\n Function: Returns a new Bio::Seq::PrimaryQual object from basic \n\tconstructors, being a string _or_ a reference to an array for the\n\tsequence and strings for id and accession_number. Note that you\n\tcan provide an empty quality string.\n Returns : a new Bio::Seq::PrimaryQual object\n\n\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # default: turn ON the warnings (duh)\n    my($qual,$id,$acc,$pid,$desc,$given_id,$header) =\n        $self->_rearrange([qw(QUAL\n                              DISPLAY_ID\n                              ACCESSION_NUMBER\n                              PRIMARY_ID\n                              DESC\n                              ID\n                              HEADER\n                              )],\n                          @args);\n    if( defined $id && defined $given_id ) {\n        if( $id ne $given_id ) {\n            $self->throw(\"Provided both id and display_id constructor functions. [$id] [$given_id]\");   \n        }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n    \n    # note: the sequence string may be empty\n    $self->qual(defined($qual) ? $qual : []);\n     $header && $self->header($header);\n    $id      && $self->display_id($id);\n    $acc     && $self->accession_number($acc);\n    $pid     && $self->primary_id($pid);\n    $desc    && $self->desc($desc);\n\n    return $self;\n}\n\n=head2 qual()\n\n Title   : qual()\n Usage   : @quality_values  = @{$obj->qual()};\n Function: Returns the quality as a reference to an array containing the\n           quality values. The individual elements of the quality array are\n           not validated and can be any numeric value.\n Returns : A reference to an array.\n\n\nsub qual {\n    my ($self,$value) = @_;\n\n    if( ! defined $value || length($value) == 0 ) { \n\t$self->{'qual'} ||= [];\n    } elsif( ref($value) =~ /ARRAY/i ) {\n\t# if the user passed in a reference to an array\n\t$self->{'qual'} = $value;\n    } elsif(! $self->validate_qual($value)){\n\t$self->throw(\"Attempting to set the quality to [$value] which does not look healthy\");\t    \n    } else {\n\t$value =~ s/^\\s+//;\n\t$self->{'qual'} = [split(/\\s+/,$value)];\n    }\n    \n    return $self->{'qual'};\n}\n\n=head2 validate_qual($qualstring)\n\n Title\t : validate_qual($qualstring)\n Usage\t : print(\"Valid.\") if { &validate_qual($self,$qualities); }\n Function: Make sure that the quality, if it has length > 0, contains at\n\tleast one digit. Note that quality strings are parsed into arrays\n\tusing split/\\d+/,$quality_string, so make sure that your quality\n\tscalar looks like this if you want it to be parsed properly.\n Returns : 1 for a valid sequence (WHY? Shouldn\\'t it return 0? <boggle>)\n Args    : a scalar (any scalar, why PrimarySeq author?) and a scalar\n\tcontaining the string to validate.\n\n\nsub validate_qual {\n    # how do I validate quality values?\n    # \\d+\\s+\\d+..., I suppose\n    my ($self,$qualstr) = @_;\n    # why the CORE?? -- (Because Bio::PrimarySeqI namespace has a \n    #                    length method, you have to qualify \n    #                    which length to use)\n    return 0 if (!defined $qualstr || CORE::length($qualstr) <= 0);   \n    return 1 if( $qualstr =~ /\\d/);\n    \n    return 0;\n}\n\n=head2 subqual($start,$end)\n\n Title   : subqual($start,$end)\n Usage   : @subset_of_quality_values = @{$obj->subqual(10,40)};\n Function: returns the quality values from $start to $end, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the\n\tfirst two bases of the sequence. Start cannot be larger than\n\tend but can be equal.\n Returns : A reference to an array.\n Args    : a start position and an end position\n\n\n\nsub subqual {\n   my ($self,$start,$end) = @_;\n\n   if( $start > $end ){\n       $self->throw(\"in subqual, start [$start] has to be greater than end [$end]\");\n   }\n\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"You have to have start positive and length less than the total length of sequence [$start:$end] Total \".$self->length.\"\");\n   }\n\n   # remove one from start, and then length is end-start\n\n   $start--;\n\t$end--;\n\tmy @sub_qual_array = @{$self->{qual}}[$start..$end];\n\n \t#   return substr $self->seq(), $start, ($end-$start);\n\treturn \\@sub_qual_array;\n\n}\n\n=head2 display_id()\n\n Title   : display_id()\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Quality\n        object.\n        The semantics of this is that it is the most likely string to be\n        used as an identifier of the quality sequence, and likely to have\n        \"human\" readability.  The id is equivalent to the ID field of the\n        GenBank/EMBL databanks and the id field of the Swissprot/sptrembl\n        database. In fasta format, the >(\\S+) is presumed to be the id,\n        though some people overload the id to embed other information.\n        Bioperl does not use any embedded information in the ID field,\n        and people are encouraged to use other mechanisms (accession\n\tfield for example, or extending the sequence object) to solve\n\tthis. Notice that $seq->id() maps to this function, mainly for\n        legacy/convience issues\n Returns : A string\n Args    : None\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 header()\n\n Title   : header()\n Usage   : $header = $obj->header();\n Function: Get/set the header that the user wants printed for this\n     quality object.\n Returns : A string\n Args    : None\n\n\nsub header {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'header'} = $value;\n    }\n    return $obj->{'header'};\n\n}\n\n=head2 accession_number()\n\n Title   : accession_number()\n Usage   : $unique_biological_key = $obj->accession_number();\n Function: Returns the unique biological id for a sequence, commonly\n        called the accession_number. For sequences from established\n        databases, the implementors should try to use the correct\n        accession number. Notice that primary_id() provides the unique id\n        for the implemetation, allowing multiple objects to have the same\n        accession number in a particular implementation. For sequences\n        with no accession number, this method should return \"unknown\".\n Returns : A string\n Args    : None\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id()\n\n Title   : primary_id()\n Usage   : $unique_implementation_key = $obj->primary_id();\n Function: Returns the unique id for this object in this implementation.\n        This allows implementations to manage their own object ids in a\n        way the implementaiton can control clients can expect one id to\n        map to one object. For sequences with no accession number, this\n        method should return a stringified memory location.\n Returns : A string\n Args    : None\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'primary_id'} = $value;\n    }\n   return $obj->{'primary_id'};\n\n}\n\n=head2 desc()\n\n Title   : desc()\n Usage   : $qual->desc($newval);\n           $description = $qual->desc();\n Function: Get/set description text for a qual object\n Example :\n Returns : Value of desc\n Args    : newvalue (optional)\n\n\nsub desc {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'desc'} = $value;\n    }\n    return $obj->{'desc'};\n\n}\n\n=head2 id()\n\n Title   : id()\n Usage   : $id = $qual->id();\n Function: Return the ID of the quality. This should normally be (and\n\tactually is in the implementation provided here) just a synonym\n\tfor display_id().\n Returns : A string.\n Args    : None.\n\n\nsub id {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n        return $self->display_id($value);\n   }\n   return $self->display_id();\n}\n\n=head2 length()\n\n Title\t : length()\n Usage\t : $length = $qual->length();\n Function: Return the length of the array holding the quality values.\n\tUnder most circumstances, this should match the number of quality\n\tvalues but no validation is done when the PrimaryQual object is\n\tconstructed and non-digits could be put into this array. Is this\n\ta bug? Just enough rope...\n Returns : A scalar (the number of elements in the quality array).\n Args    : None.\n\n\nsub length {\n    my $self = shift;\n    if (ref($self->{qual}) ne \"ARRAY\") {\n\t$self->warn(\"{qual} is not an array here. Why? It appears to be \".ref($self->{qual}).\"(\".$self->{qual}.\"). Good thing this can _never_ happen.\");\n    }\n    return scalar(@{$self->{qual}});\n}\n\n=head2 qualat($position)\n\n Title   : qualat($position)\n Usage   : $quality = $obj->qualat(10);\n Function: Return the quality value at the given location, where the\n        first value is 1 and the number is inclusive, ie 1-2 are the first\n        two bases of the sequence. Start cannot be larger than end but can\n        be equal.\n Returns : A scalar.\n Args    : A position."},"line":432,"kind":12,"range":{"start":{"character":0,"line":432},"end":{"character":9999,"line":434}},"definition":"sub","detail":"($self,$val)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"qualat","name":"$self","line":433},{"line":433,"kind":13,"containerName":"qualat","name":"$val"},{"line":434,"kind":13,"localvar":"my","containerName":"qualat","name":"@qualat","definition":"my"},{"line":434,"name":"$self","containerName":"qualat","kind":13},{"kind":12,"containerName":"qualat","name":"subqual","line":434},{"name":"$val","containerName":"qualat","kind":13,"line":434},{"kind":13,"containerName":"qualat","name":"$val","line":434}],"containerName":"main::","name":"qualat"},{"kind":13,"containerName":null,"name":"@qualat","line":435},{"name":"@qualat","kind":13,"containerName":null,"line":436},{"kind":13,"containerName":null,"name":"$self","line":439},{"containerName":"main::","kind":12,"name":"throw","line":439},{"range":{"end":{"line":463,"character":9999},"start":{"line":461,"character":0}},"kind":12,"line":461,"definition":"sub","name":"to_string","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"to_string","name":"$self","line":462},{"line":462,"name":"$out","kind":13,"containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$result","line":462},{"line":463,"containerName":"to_string","kind":13,"name":"$out"},{"line":463,"containerName":"to_string","kind":13,"name":"$self"},{"kind":12,"containerName":"to_string","name":"qual","line":463}]},{"line":465,"name":"$result","kind":13,"containerName":null},{"line":465,"name":"$self","containerName":null,"kind":13},{"line":466,"kind":13,"containerName":null,"name":"%result"},{"containerName":null,"kind":13,"name":"$result","line":466},{"name":"$out","kind":13,"containerName":null,"line":467},{"name":"$out","containerName":null,"kind":13,"line":469},{"range":{"end":{"line":489,"character":9999},"start":{"character":0,"line":473}},"kind":12,"line":473,"name":"to_string_automatic","containerName":"main::","children":[{"line":474,"name":"$self","kind":13,"localvar":"my","containerName":"to_string_automatic","definition":"my"},{"line":474,"containerName":"to_string_automatic","kind":13,"name":"$sub_result"},{"name":"$out","kind":13,"containerName":"to_string_automatic","line":474},{"name":"$self","containerName":"to_string_automatic","kind":13,"line":475},{"kind":13,"containerName":"to_string_automatic","name":"$self","line":477},{"line":478,"kind":13,"containerName":"to_string_automatic","name":"$sub_result"},{"line":479,"name":"$sub_result","containerName":"to_string_automatic","kind":13},{"containerName":"to_string_automatic","kind":13,"name":"$self","line":479},{"name":"$sub_result","containerName":"to_string_automatic","kind":13,"line":480},{"name":"$sub_result","kind":13,"containerName":"to_string_automatic","line":482},{"line":484,"containerName":"to_string_automatic","kind":13,"name":"$sub_result"},{"name":"$sub_result","containerName":"to_string_automatic","kind":13,"line":484},{"line":486,"kind":13,"containerName":"to_string_automatic","name":"$out"},{"name":"$sub_result","containerName":"to_string_automatic","kind":13,"line":486},{"kind":13,"containerName":"to_string_automatic","name":"$out","line":488}],"definition":"sub"}]}