{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":464},{"children":[{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$caller","line":482},{"line":482,"kind":13,"containerName":"new","name":"@args"},{"line":484,"containerName":"new","kind":13,"name":"$caller"},{"line":485,"name":"$caller","containerName":"new","kind":13},{"line":485,"containerName":"new","kind":13,"name":"$caller"},{"line":485,"name":"$caller","kind":13,"containerName":"new"},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$self","line":489},{"kind":12,"containerName":"new","name":"new","line":489},{"line":489,"name":"@args","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":490},{"name":"$caller","kind":13,"containerName":"new","line":490},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$pseq","line":496},{"line":496,"kind":12,"containerName":"new","name":"new"},{"containerName":"new","kind":13,"name":"@args","line":496},{"kind":13,"containerName":"new","name":"$self","line":501},{"line":501,"containerName":"new","kind":13,"name":"$pseq"},{"name":"$ann","containerName":"new","localvar":"my","kind":13,"line":508,"definition":"my"},{"kind":13,"containerName":"new","name":"$pid","line":508},{"containerName":"new","kind":13,"name":"$feat","line":508},{"name":"$species","kind":13,"containerName":"new","line":508},{"line":508,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":13,"name":"@args","line":508},{"line":513,"name":"$ann","containerName":"new","kind":13},{"line":513,"name":"$pid","containerName":"new","kind":13},{"name":"$feat","kind":13,"containerName":"new","line":513},{"kind":13,"containerName":"new","name":"$species","line":513},{"name":"$pid","containerName":"new","kind":13,"line":514},{"line":514,"name":"$self","kind":13,"containerName":"new"},{"line":514,"containerName":"new","kind":12,"name":"primary_id"},{"line":514,"kind":13,"containerName":"new","name":"$pid"},{"name":"$species","containerName":"new","kind":13,"line":515},{"line":515,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"species","line":515},{"line":515,"kind":13,"containerName":"new","name":"$species"},{"line":516,"containerName":"new","kind":13,"name":"$ann"},{"line":516,"kind":13,"containerName":"new","name":"$self"},{"line":516,"kind":12,"containerName":"new","name":"annotation"},{"line":516,"containerName":"new","kind":13,"name":"$ann"},{"name":"$feat","containerName":"new","kind":13,"line":518},{"line":519,"containerName":"new","kind":13,"name":"$feat"},{"line":520,"name":"$feat","containerName":"new","kind":13},{"line":520,"name":"$feat","containerName":"new","kind":13},{"name":"isa","kind":12,"containerName":"new","line":520},{"containerName":"new","kind":13,"name":"$self","line":521},{"line":521,"containerName":"new","kind":12,"name":"add_SeqFeature"},{"containerName":"new","kind":13,"name":"$feat","line":521},{"name":"$self","containerName":"new","kind":13,"line":523},{"name":"warn","containerName":"new","kind":12,"line":523},{"name":"$self","kind":13,"containerName":"new","line":523},{"definition":"my","name":"$feature","kind":13,"localvar":"my","containerName":"new","line":526},{"name":"$feat","kind":13,"containerName":"new","line":526},{"line":527,"kind":13,"containerName":"new","name":"$self"},{"name":"add_SeqFeature","kind":12,"containerName":"new","line":527},{"line":527,"name":"$feature","containerName":"new","kind":13},{"line":533,"name":"$self","containerName":"new","kind":13}],"name":"new","containerName":"main::","definition":"sub","detail":"($caller,@args)","line":481,"range":{"start":{"character":0,"line":481},"end":{"character":9999,"line":534}},"kind":12,"signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: Seq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq - Sequence object, with features\n\n=head1 SYNOPSIS\n\n    # This is the main sequence object in Bioperl\n\n    # gets a sequence from a file\n    $seqio  = Bio::SeqIO->new( '-format' => 'embl' , -file => 'myfile.dat');\n    $seqobj = $seqio->next_seq();\n\n    # SeqIO can both read and write sequences; see Bio::SeqIO\n    # for more information and examples\n\n    # get from database\n    $db = Bio::DB::GenBank->new();\n    $seqobj = $db->get_Seq_by_acc('X78121');\n\n    # make from strings in script\n    $seqobj = Bio::Seq->new( -display_id => 'my_id',\n\t\t\t     -seq => $sequence_as_string);\n\n    # gets sequence as a string from sequence object\n    $seqstr   = $seqobj->seq(); # actual sequence as a string\n    $seqstr   = $seqobj->subseq(10,50); # slice in biological coordinates\n\n    # retrieves information from the sequence\n    # features must implement Bio::SeqFeatureI interface\n\n    @features = $seqobj->get_SeqFeatures(); # just top level\n    foreach my $feat ( @features ) {\n\tprint \"Feature \",$feat->primary_tag,\" starts \",$feat->start,\" ends \",\n\t$feat->end,\" strand \",$feat->strand,\"\\n\";\n\n        # features retain link to underlying sequence object\n        print \"Feature sequence is \",$feat->seq->seq(),\"\\n\"\n    }\n\n    # sequences may have a species\n\n    if( defined $seq->species ) {\n\tprint \"Sequence is from \",$species->binomial,\" [\",$species->common_name,\"]\\n\";\n    }\n\n    # annotation objects are Bio::AnnotationCollectionI's\n    $ann      = $seqobj->annotation(); # annotation object\n\n    # references is one type of annotations to get. Also get\n    # comment and dblink. Look at Bio::AnnotationCollection for\n    # more information\n\n    foreach my $ref ( $ann->get_Annotations('reference') ) {\n\tprint \"Reference \",$ref->title,\"\\n\";\n    }\n\n    # you can get truncations, translations and reverse complements, these\n    # all give back Bio::Seq objects themselves, though currently with no\n    # features transfered\n\n    my $trunc = $seqobj->trunc(100,200);\n    my $rev   = $seqobj->revcom();\n\n    # there are many options to translate - check out the docs\n    my $trans = $seqobj->translate();\n\n    # these functions can be chained together\n\n    my $trans_trunc_rev = $seqobj->trunc(100,200)->revcom->translate();\n\n\n\n=head1 DESCRIPTION\n\nA Seq object is a sequence with sequence features placed on it. The\nSeq object contains a PrimarySeq object for the actual sequence and\nalso implements its interface.\n\nIn Bioperl we have 3 main players that people are going to use frequently\n\n  Bio::PrimarySeq  - just the sequence and its names, nothing else.\n  Bio::SeqFeatureI - a feature on a sequence, potentially with a sequence\n                     and a location and annotation.\n  Bio::Seq         - A sequence and a collection of sequence features\n                     (an aggregate) with its own annotation.\n\nAlthough Bioperl is not tied heavily to file formats these distinctions do\nmap to file formats sensibly and for some bioinformaticians this might help\n\n  Bio::PrimarySeq  - Fasta file of a sequence\n  Bio::SeqFeatureI - A single entry in an EMBL/GenBank/DDBJ feature table\n  Bio::Seq         - A single EMBL/GenBank/DDBJ entry\n\nBy having this split we avoid a lot of nasty circular references\n(sequence features can hold a reference to a sequence without the sequence\nholding a reference to the sequence feature). See L<Bio::PrimarySeq> and\nL<Bio::SeqFeatureI> for more information.\n\nIan Korf really helped in the design of the Seq and SeqFeature system.\n\n=head2 Examples\n\nA simple and fundamental block of code:\n\n  use Bio::SeqIO;\n\n  my $seqIOobj = Bio::SeqIO->new(-file=>\"1.fa\"); # create a SeqIO object\n  my $seqobj = $seqIOobj->next_seq;              # get a Seq object\n\nWith the Seq object in hand one has access to a powerful set of Bioperl\nmethods and related Bioperl objects. This next script will take a file of sequences\nin EMBL format and create a file of the reverse-complemented sequences\nin Fasta format using Seq objects. It also prints out details about the\nexons it finds as sequence features in Genbank Flat File format.\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\n  while((my $seqobj = $seqin->next_seq())) {\n      print \"Seen sequence \",$seqobj->display_id,\", start of seq \",\n            substr($seqobj->seq,1,10),\"\\n\";\n      if( $seqobj->alphabet eq 'dna') {\n\t    $rev = $seqobj->revcom;\n\t    $id  = $seqobj->display_id();\n            $id  = \"$id.rev\";\n            $rev->display_id($id);\n            $seqout->write_seq($rev);\n      }\n\n      foreach $feat ( $seqobj->get_SeqFeatures() ) {\n           if( $feat->primary_tag eq 'exon' ) {\n              print STDOUT \"Location \",$feat->start,\":\",\n                    $feat->end,\" GFF[\",$feat->gff_string,\"]\\n\";\n\t   }\n      }\n  }\n\nLet's examine the script. The lines below import the Bioperl modules.\nSeq is the main Bioperl sequence object and SeqIO is the Bioperl support\nfor reading sequences from files and to files\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n\nThese two lines create two SeqIO streams: one for reading in sequences\nand one for outputting sequences:\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\nNotice that in the \"$seqout\" case there is a greater-than sign,\nindicating the file is being opened for writing.\n\nUsing the\n\n  '-argument' => value\n\nsyntax is common in Bioperl. The file argument is like an argument\nto open() . You can also pass in filehandles or FileHandle objects by\nusing the -fh argument (see L<Bio::SeqIO> documentation for details).\nMany formats in Bioperl are handled, including Fasta, EMBL, GenBank,\nSwissprot (swiss), PIR, and GCG.\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\nThis is the main loop which will loop progressively through sequences\nin a file, and each call to $seqio-E<gt>next_seq() provides a new Seq\nobject from the file:\n\n  while((my $seqobj = $seqio->next_seq())) {\n\nThis print line below accesses fields in the Seq object directly. The\n$seqobj-E<gt>display_id is the way to access the display_id attribute\nof the Seq object. The $seqobj-E<gt>seq method gets the actual\nsequence out as string. Then you can do manipulation of this if\nyou want to (there are however easy ways of doing truncation,\nreverse-complement and translation).\n\n  print \"Seen sequence \",$seqobj->display_id,\", start of seq \",\n               substr($seqobj->seq,1,10),\"\\n\";\n\nBioperl has to guess the alphabet of the sequence, being either 'dna',\n'rna', or 'protein'. The alphabet attribute is one of these three\npossibilities.\n\n  if( $seqobj->alphabet eq 'dna') {\n\nThe $seqobj-E<gt>revcom method provides the reverse complement of the Seq\nobject as another Seq object. Thus, the $rev variable is a reference to\nanother Seq object. For example, one could repeat the above print line\nfor this Seq object (putting $rev in place of $seqobj). In this\ncase we are going to output the object into the file stream we built\nearlier on.\n\n  $rev = $seqobj->revcom;\n\nWhen we output it, we want the id of the outputted object\nto be changed to \"$id.rev\", ie, with .rev on the end of the name. The\nfollowing lines retrieve the id of the sequence object, add .rev\nto this and then set the display_id of the rev sequence object to\nthis. Notice that to set the display_id attribute you just need\ncall the same method, display_id(), with the new value as an argument.\nGetting and setting values with the same method is common in Bioperl.\n\n  $id  = $seqobj->display_id();\n  $id  = \"$id.rev\";\n  $rev->display_id($id);\n\nThe write_seq method on the SeqIO output object, $seqout, writes the\n$rev object to the filestream we built at the top of the script.\nThe filestream knows that it is outputting in fasta format, and\nso it provides fasta output.\n\n  $seqout->write_seq($rev);\n\nThis block of code loops over sequence features in the sequence\nobject, trying to find ones who have been tagged as 'exon'.\nFeatures have start and end attributes and can be outputted\nin Genbank Flat File format, GFF, a standarized format for sequence\nfeatures.\n\n  foreach $feat ( $seqobj->get_SeqFeatures() ) {\n      if( $feat->primary_tag eq 'exon' ) {\n          print STDOUT \"Location \",$feat->start,\":\",\n             $feat->end,\" GFF[\",$feat->gff_string,\"]\\n\";\n      }\n  }\n\nThe code above shows how a few Bio::Seq methods suffice to read, parse,\nreformat and analyze sequences from a file. A full list of methods\navailable to Bio::Seq objects is shown below. Bear in mind that some of\nthese methods come from PrimarySeq objects, which are simpler\nthan Seq objects, stripped of features (see L<Bio::PrimarySeq> for\nmore information).\n\n  # these methods return strings, and accept strings in some cases:\n\n  $seqobj->seq();              # string of sequence\n  $seqobj->subseq(5,10);       # part of the sequence as a string\n  $seqobj->accession_number(); # when there, the accession number\n  $seqobj->alphabet();         # one of 'dna','rna',or 'protein'\n  $seqobj->seq_version()       # when there, the version\n  $seqobj->keywords();         # when there, the Keywords line\n  $seqobj->length()            # length\n  $seqobj->desc();             # description\n  $seqobj->primary_id();       # a unique id for this sequence regardless\n                               # of its display_id or accession number\n  $seqobj->display_id();       # the human readable id of the sequence\n\nSome of these values map to fields in common formats. For example, The\ndisplay_id() method returns the LOCUS name of a Genbank entry,\nthe (\\S+) following the E<gt> character in a Fasta file, the ID from\na SwissProt file, and so on. The desc() method will return the DEFINITION\nline of a Genbank file, the description following the display_id in a\nFasta file, and the DE field in a SwissProt file.\n\n  # the following methods return new Seq objects, but\n  # do not transfer features across to the new object:\n\n  $seqobj->trunc(5,10)  # truncation from 5 to 10 as new object\n  $seqobj->revcom       # reverse complements sequence\n  $seqobj->translate    # translation of the sequence\n\n  # if new() can be called this method returns 1, else 0\n\n  $seqobj->can_call_new\n\n  # the following method determines if the given string will be accepted\n  # by the seq() method - if the string is acceptable then validate()\n  # returns 1, or 0 if not\n\n  $seqobj->validate_seq($string)\n\n  # the following method returns or accepts a Species object:\n\n  $seqobj->species();\n\nPlease see L<Bio::Species> for more information on this object.\n\n  # the following method returns or accepts an Annotation object\n  # which in turn allows access to Annotation::Reference\n  # and Annotation::Comment objects:\n\n  $seqobj->annotation();\n\nThese annotations typically refer to entire sequences, unlike\nfeatures.  See L<Bio::AnnotationCollectionI>,\nL<Bio::Annotation::Collection>, L<Bio::Annotation::Reference>, and\nL<Bio::Annotation::Comment> for details.\n\nIt is also important to be able to describe defined portions of a\nsequence. The combination of some description and the corresponding\nsub-sequence is called a feature - an exon and its coordinates within\na gene is an example of a feature, or a domain within a protein.\n\n  # the following methods return an array of SeqFeatureI objects:\n\n  $seqobj->get_SeqFeatures # The 'top level' sequence features\n  $seqobj->get_all_SeqFeatures # All sequence features, including sub-seq\n                               # features, such as features in an exon\n\n  # to find out the number of features use:\n\n  $seqobj->feature_count\n\nHere are just some of the methods available to SeqFeatureI objects:\n\n  # these methods return numbers:\n\n  $feat->start          # start position (1 is the first base)\n  $feat->end            # end position (2 is the second base)\n  $feat->strand         # 1 means forward, -1 reverse, 0 not relevant\n\n  # these methods return or accept strings:\n\n  $feat->primary_tag    # the name of the sequence feature, eg\n                        # 'exon', 'glycoslyation site', 'TM domain'\n  $feat->source_tag     # where the feature comes from, eg, 'EMBL_GenBank',\n                        # or 'BLAST'\n\n  # this method returns the more austere PrimarySeq object, not a\n  # Seq object - the main difference is that PrimarySeq objects do not\n  # themselves contain sequence features\n\n  $feat->seq            # the sequence between start,end on the\n                        # correct strand of the sequence\n\nSee L<Bio::PrimarySeq> for more details on PrimarySeq objects.\n\n  # useful methods for feature comparisons, for start/end points\n\n  $feat->overlaps($other)  # do $feat and $other overlap?\n  $feat->contains($other)  # is $other completely within $feat?\n  $feat->equals($other)    # do $feat and $other completely agree?\n\n  # one can also add features\n\n  $seqobj->add_SeqFeature($feat)     # returns 1 if successful\n  $seqobj->add_SeqFeature(@features) # returns 1 if successful\n\n  # sub features. For complex join() statements, the feature\n  # is one sequence feature with many sub SeqFeatures\n\n  $feat->sub_SeqFeature  # returns array of sub seq features\n\nPlease see L<Bio::SeqFeatureI> and L<Bio::SeqFeature::Generic>,\nfor more information on sequence features.\n\nIt is worth mentioning that one can also retrieve the start and end\npositions of a feature using a Bio::LocationI object:\n\n  $location = $feat->location # $location is a Bio::LocationI object\n  $location->start;           # start position\n  $location->end;             # end position\n\nThis is useful because one needs a Bio::Location::SplitLocationI object\nin order to retrieve the coordinates inside the Genbank or EMBL join()\nstatements (e.g. \"CDS    join(51..142,273..495,1346..1474)\"):\n\n  if ( $feat->location->isa('Bio::Location::SplitLocationI') &&\n\t       $feat->primary_tag eq 'CDS' )  {\n    foreach $loc ( $feat->location->sub_Location ) {\n      print $loc->start . \"..\" . $loc->end . \"\\n\";\n    }\n  }\n\nSee L<Bio::LocationI> and L<Bio::Location::SplitLocationI> for more\ninformation.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqI\n\nNote that this includes implementing Bio::PrimarySeqI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, inspired by Ian Korf objects\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Seq;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::SeqI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::FeatureHolderI);\n\n=head2 new\n\n Title   : new\n Usage   : $seq = Bio::Seq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                 -id  => 'human_id',\n\t\t\t\t -accession_number => 'AL000012',\n\t\t\t       );\n\n Function: Returns a new Seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number\n Returns : a new Bio::Seq object","label":"new($caller,@args)"}},{"line":489,"containerName":"Root::Root","kind":12,"name":"Bio"},{"line":496,"name":"Bio","kind":12,"containerName":"PrimarySeq"},{"name":"Bio","kind":12,"containerName":"Root::RootI::_rearrange","line":508},{"line":567,"kind":12,"range":{"end":{"character":9999,"line":569},"start":{"line":567,"character":0}},"children":[{"line":568,"name":"primary_seq","kind":12,"containerName":"seq"},{"line":568,"name":"seq","containerName":"seq","kind":12}],"name":"seq","containerName":"main::","definition":"sub"},{"children":[{"name":"primary_seq","kind":12,"containerName":"validate_seq","line":595},{"containerName":"validate_seq","kind":12,"name":"validate_seq","line":595}],"containerName":"main::","name":"validate_seq","definition":"sub","line":594,"kind":12,"range":{"start":{"line":594,"character":0},"end":{"line":596,"character":9999}}},{"children":[{"line":610,"name":"primary_seq","containerName":"length","kind":12},{"kind":12,"containerName":"length","name":"length","line":610}],"name":"length","containerName":"main::","definition":"sub","line":609,"kind":12,"range":{"start":{"line":609,"character":0},"end":{"character":9999,"line":611}}},{"name":"subseq","containerName":"main::","children":[{"kind":12,"containerName":"subseq","name":"primary_seq","line":634},{"kind":12,"containerName":"subseq","name":"subseq","line":634}],"definition":"sub","range":{"end":{"character":9999,"line":635},"start":{"line":633,"character":0}},"kind":12,"line":633},{"definition":"sub","name":"display_id","containerName":"main::","children":[{"line":664,"name":"primary_seq","containerName":"display_id","kind":12},{"line":664,"containerName":"display_id","kind":12,"name":"display_id"}],"kind":12,"range":{"end":{"line":665,"character":9999},"start":{"character":0,"line":663}},"line":663},{"kind":12,"range":{"start":{"character":0,"line":691},"end":{"line":693,"character":9999}},"line":691,"definition":"sub","containerName":"main::","name":"accession_number","children":[{"line":692,"kind":12,"containerName":"accession_number","name":"primary_seq"},{"line":692,"kind":12,"containerName":"accession_number","name":"accession_number"}]},{"line":707,"kind":12,"range":{"end":{"line":709,"character":9999},"start":{"character":0,"line":707}},"children":[{"kind":12,"containerName":"desc","name":"primary_seq","line":708},{"name":"desc","containerName":"desc","kind":12,"line":708}],"name":"desc","containerName":"main::","definition":"sub"},{"kind":12,"range":{"end":{"line":748,"character":9999},"start":{"character":0,"line":734}},"line":734,"definition":"sub","containerName":"main::","name":"primary_id","children":[{"containerName":"primary_id","kind":12,"name":"primary_seq","line":747},{"name":"primary_id","containerName":"primary_id","kind":12,"line":747}]},{"name":"can_call_new","containerName":"main::","children":[],"definition":"sub","range":{"start":{"character":0,"line":774},"end":{"line":776,"character":9999}},"kind":12,"line":774},{"children":[{"line":797,"localvar":"my","kind":13,"containerName":"alphabet","name":"$self","definition":"my"},{"containerName":"alphabet","kind":13,"name":"$self","line":798},{"containerName":"alphabet","kind":12,"name":"primary_seq","line":798},{"name":"alphabet","kind":12,"containerName":"alphabet","line":798},{"containerName":"alphabet","kind":13,"name":"$self","line":799},{"name":"primary_seq","containerName":"alphabet","kind":12,"line":799},{"containerName":"alphabet","kind":12,"name":"alphabet","line":799}],"name":"alphabet","containerName":"main::","definition":"sub","line":796,"kind":12,"range":{"start":{"line":796,"character":0},"end":{"character":9999,"line":800}}},{"containerName":"main::","name":"is_circular","children":[{"containerName":"is_circular","kind":12,"name":"primary_seq","line":813},{"line":813,"name":"is_circular","containerName":"is_circular","kind":12}],"definition":"sub","range":{"end":{"line":814,"character":9999},"start":{"line":812,"character":0}},"kind":12,"line":812},{"kind":12,"range":{"start":{"character":0,"line":835},"end":{"character":9999,"line":837}},"line":835,"name":"object_id","containerName":"main::","children":[{"line":836,"name":"accession_number","containerName":"object_id","kind":12}],"definition":"sub"},{"range":{"start":{"character":0,"line":852},"end":{"character":9999,"line":854}},"kind":12,"line":852,"containerName":"main::","name":"version","children":[{"kind":12,"containerName":"version","name":"primary_seq","line":853},{"line":853,"containerName":"version","kind":12,"name":"version"}],"definition":"sub"},{"range":{"end":{"character":9999,"line":871},"start":{"line":869,"character":0}},"kind":12,"line":869,"definition":"sub","name":"authority","containerName":"main::","children":[{"line":870,"name":"primary_seq","containerName":"authority","kind":12},{"line":870,"name":"authority","containerName":"authority","kind":12}]},{"line":886,"kind":12,"range":{"start":{"character":0,"line":886},"end":{"character":9999,"line":888}},"children":[{"name":"primary_seq","kind":12,"containerName":"namespace","line":887},{"name":"namespace","containerName":"namespace","kind":12,"line":887}],"containerName":"main::","name":"namespace","definition":"sub"},{"kind":12,"range":{"start":{"character":0,"line":909},"end":{"line":911,"character":9999}},"line":909,"definition":"sub","name":"display_name","containerName":"main::","children":[{"name":"display_id","kind":12,"containerName":"display_name","line":910}]},{"definition":"sub","name":"description","containerName":"main::","children":[{"line":930,"name":"desc","kind":12,"containerName":"description"}],"range":{"end":{"character":9999,"line":931},"start":{"character":0,"line":929}},"kind":12,"line":929},{"definition":"sub","detail":"($obj,$value)","children":[{"localvar":"my","containerName":"annotation","kind":13,"name":"$obj","line":952,"definition":"my"},{"name":"$value","kind":13,"containerName":"annotation","line":952},{"kind":13,"containerName":"annotation","name":"$value","line":953},{"containerName":"annotation","kind":13,"name":"$obj","line":954},{"line":954,"containerName":"annotation","kind":12,"name":"throw"},{"name":"$value","containerName":"annotation","kind":13,"line":954},{"line":956,"name":"$value","containerName":"annotation","kind":13},{"line":956,"containerName":"annotation","kind":12,"name":"isa"},{"name":"$obj","containerName":"annotation","kind":13,"line":957},{"containerName":"annotation","kind":13,"name":"$value","line":957},{"containerName":"annotation","kind":13,"name":"$obj","line":958},{"line":959,"kind":13,"containerName":"annotation","name":"$obj"},{"line":959,"kind":12,"containerName":"annotation","name":"new"},{"line":961,"name":"$obj","containerName":"annotation","kind":13}],"containerName":"main::","name":"annotation","signature":{"label":"annotation($obj,$value)","documentation":"1;\n# $Id: Seq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq - Sequence object, with features\n\n=head1 SYNOPSIS\n\n    # This is the main sequence object in Bioperl\n\n    # gets a sequence from a file\n    $seqio  = Bio::SeqIO->new( '-format' => 'embl' , -file => 'myfile.dat');\n    $seqobj = $seqio->next_seq();\n\n    # SeqIO can both read and write sequences; see Bio::SeqIO\n    # for more information and examples\n\n    # get from database\n    $db = Bio::DB::GenBank->new();\n    $seqobj = $db->get_Seq_by_acc('X78121');\n\n    # make from strings in script\n    $seqobj = Bio::Seq->new( -display_id => 'my_id',\n\t\t\t     -seq => $sequence_as_string);\n\n    # gets sequence as a string from sequence object\n    $seqstr   = $seqobj->seq(); # actual sequence as a string\n    $seqstr   = $seqobj->subseq(10,50); # slice in biological coordinates\n\n    # retrieves information from the sequence\n    # features must implement Bio::SeqFeatureI interface\n\n    @features = $seqobj->get_SeqFeatures(); # just top level\n    foreach my $feat ( @features ) {\n\tprint \"Feature \",$feat->primary_tag,\" starts \",$feat->start,\" ends \",\n\t$feat->end,\" strand \",$feat->strand,\"\\n\";\n\n        # features retain link to underlying sequence object\n        print \"Feature sequence is \",$feat->seq->seq(),\"\\n\"\n    }\n\n    # sequences may have a species\n\n    if( defined $seq->species ) {\n\tprint \"Sequence is from \",$species->binomial,\" [\",$species->common_name,\"]\\n\";\n    }\n\n    # annotation objects are Bio::AnnotationCollectionI's\n    $ann      = $seqobj->annotation(); # annotation object\n\n    # references is one type of annotations to get. Also get\n    # comment and dblink. Look at Bio::AnnotationCollection for\n    # more information\n\n    foreach my $ref ( $ann->get_Annotations('reference') ) {\n\tprint \"Reference \",$ref->title,\"\\n\";\n    }\n\n    # you can get truncations, translations and reverse complements, these\n    # all give back Bio::Seq objects themselves, though currently with no\n    # features transfered\n\n    my $trunc = $seqobj->trunc(100,200);\n    my $rev   = $seqobj->revcom();\n\n    # there are many options to translate - check out the docs\n    my $trans = $seqobj->translate();\n\n    # these functions can be chained together\n\n    my $trans_trunc_rev = $seqobj->trunc(100,200)->revcom->translate();\n\n\n\n=head1 DESCRIPTION\n\nA Seq object is a sequence with sequence features placed on it. The\nSeq object contains a PrimarySeq object for the actual sequence and\nalso implements its interface.\n\nIn Bioperl we have 3 main players that people are going to use frequently\n\n  Bio::PrimarySeq  - just the sequence and its names, nothing else.\n  Bio::SeqFeatureI - a feature on a sequence, potentially with a sequence\n                     and a location and annotation.\n  Bio::Seq         - A sequence and a collection of sequence features\n                     (an aggregate) with its own annotation.\n\nAlthough Bioperl is not tied heavily to file formats these distinctions do\nmap to file formats sensibly and for some bioinformaticians this might help\n\n  Bio::PrimarySeq  - Fasta file of a sequence\n  Bio::SeqFeatureI - A single entry in an EMBL/GenBank/DDBJ feature table\n  Bio::Seq         - A single EMBL/GenBank/DDBJ entry\n\nBy having this split we avoid a lot of nasty circular references\n(sequence features can hold a reference to a sequence without the sequence\nholding a reference to the sequence feature). See L<Bio::PrimarySeq> and\nL<Bio::SeqFeatureI> for more information.\n\nIan Korf really helped in the design of the Seq and SeqFeature system.\n\n=head2 Examples\n\nA simple and fundamental block of code:\n\n  use Bio::SeqIO;\n\n  my $seqIOobj = Bio::SeqIO->new(-file=>\"1.fa\"); # create a SeqIO object\n  my $seqobj = $seqIOobj->next_seq;              # get a Seq object\n\nWith the Seq object in hand one has access to a powerful set of Bioperl\nmethods and related Bioperl objects. This next script will take a file of sequences\nin EMBL format and create a file of the reverse-complemented sequences\nin Fasta format using Seq objects. It also prints out details about the\nexons it finds as sequence features in Genbank Flat File format.\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\n  while((my $seqobj = $seqin->next_seq())) {\n      print \"Seen sequence \",$seqobj->display_id,\", start of seq \",\n            substr($seqobj->seq,1,10),\"\\n\";\n      if( $seqobj->alphabet eq 'dna') {\n\t    $rev = $seqobj->revcom;\n\t    $id  = $seqobj->display_id();\n            $id  = \"$id.rev\";\n            $rev->display_id($id);\n            $seqout->write_seq($rev);\n      }\n\n      foreach $feat ( $seqobj->get_SeqFeatures() ) {\n           if( $feat->primary_tag eq 'exon' ) {\n              print STDOUT \"Location \",$feat->start,\":\",\n                    $feat->end,\" GFF[\",$feat->gff_string,\"]\\n\";\n\t   }\n      }\n  }\n\nLet's examine the script. The lines below import the Bioperl modules.\nSeq is the main Bioperl sequence object and SeqIO is the Bioperl support\nfor reading sequences from files and to files\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n\nThese two lines create two SeqIO streams: one for reading in sequences\nand one for outputting sequences:\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\nNotice that in the \"$seqout\" case there is a greater-than sign,\nindicating the file is being opened for writing.\n\nUsing the\n\n  '-argument' => value\n\nsyntax is common in Bioperl. The file argument is like an argument\nto open() . You can also pass in filehandles or FileHandle objects by\nusing the -fh argument (see L<Bio::SeqIO> documentation for details).\nMany formats in Bioperl are handled, including Fasta, EMBL, GenBank,\nSwissprot (swiss), PIR, and GCG.\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\nThis is the main loop which will loop progressively through sequences\nin a file, and each call to $seqio-E<gt>next_seq() provides a new Seq\nobject from the file:\n\n  while((my $seqobj = $seqio->next_seq())) {\n\nThis print line below accesses fields in the Seq object directly. The\n$seqobj-E<gt>display_id is the way to access the display_id attribute\nof the Seq object. The $seqobj-E<gt>seq method gets the actual\nsequence out as string. Then you can do manipulation of this if\nyou want to (there are however easy ways of doing truncation,\nreverse-complement and translation).\n\n  print \"Seen sequence \",$seqobj->display_id,\", start of seq \",\n               substr($seqobj->seq,1,10),\"\\n\";\n\nBioperl has to guess the alphabet of the sequence, being either 'dna',\n'rna', or 'protein'. The alphabet attribute is one of these three\npossibilities.\n\n  if( $seqobj->alphabet eq 'dna') {\n\nThe $seqobj-E<gt>revcom method provides the reverse complement of the Seq\nobject as another Seq object. Thus, the $rev variable is a reference to\nanother Seq object. For example, one could repeat the above print line\nfor this Seq object (putting $rev in place of $seqobj). In this\ncase we are going to output the object into the file stream we built\nearlier on.\n\n  $rev = $seqobj->revcom;\n\nWhen we output it, we want the id of the outputted object\nto be changed to \"$id.rev\", ie, with .rev on the end of the name. The\nfollowing lines retrieve the id of the sequence object, add .rev\nto this and then set the display_id of the rev sequence object to\nthis. Notice that to set the display_id attribute you just need\ncall the same method, display_id(), with the new value as an argument.\nGetting and setting values with the same method is common in Bioperl.\n\n  $id  = $seqobj->display_id();\n  $id  = \"$id.rev\";\n  $rev->display_id($id);\n\nThe write_seq method on the SeqIO output object, $seqout, writes the\n$rev object to the filestream we built at the top of the script.\nThe filestream knows that it is outputting in fasta format, and\nso it provides fasta output.\n\n  $seqout->write_seq($rev);\n\nThis block of code loops over sequence features in the sequence\nobject, trying to find ones who have been tagged as 'exon'.\nFeatures have start and end attributes and can be outputted\nin Genbank Flat File format, GFF, a standarized format for sequence\nfeatures.\n\n  foreach $feat ( $seqobj->get_SeqFeatures() ) {\n      if( $feat->primary_tag eq 'exon' ) {\n          print STDOUT \"Location \",$feat->start,\":\",\n             $feat->end,\" GFF[\",$feat->gff_string,\"]\\n\";\n      }\n  }\n\nThe code above shows how a few Bio::Seq methods suffice to read, parse,\nreformat and analyze sequences from a file. A full list of methods\navailable to Bio::Seq objects is shown below. Bear in mind that some of\nthese methods come from PrimarySeq objects, which are simpler\nthan Seq objects, stripped of features (see L<Bio::PrimarySeq> for\nmore information).\n\n  # these methods return strings, and accept strings in some cases:\n\n  $seqobj->seq();              # string of sequence\n  $seqobj->subseq(5,10);       # part of the sequence as a string\n  $seqobj->accession_number(); # when there, the accession number\n  $seqobj->alphabet();         # one of 'dna','rna',or 'protein'\n  $seqobj->seq_version()       # when there, the version\n  $seqobj->keywords();         # when there, the Keywords line\n  $seqobj->length()            # length\n  $seqobj->desc();             # description\n  $seqobj->primary_id();       # a unique id for this sequence regardless\n                               # of its display_id or accession number\n  $seqobj->display_id();       # the human readable id of the sequence\n\nSome of these values map to fields in common formats. For example, The\ndisplay_id() method returns the LOCUS name of a Genbank entry,\nthe (\\S+) following the E<gt> character in a Fasta file, the ID from\na SwissProt file, and so on. The desc() method will return the DEFINITION\nline of a Genbank file, the description following the display_id in a\nFasta file, and the DE field in a SwissProt file.\n\n  # the following methods return new Seq objects, but\n  # do not transfer features across to the new object:\n\n  $seqobj->trunc(5,10)  # truncation from 5 to 10 as new object\n  $seqobj->revcom       # reverse complements sequence\n  $seqobj->translate    # translation of the sequence\n\n  # if new() can be called this method returns 1, else 0\n\n  $seqobj->can_call_new\n\n  # the following method determines if the given string will be accepted\n  # by the seq() method - if the string is acceptable then validate()\n  # returns 1, or 0 if not\n\n  $seqobj->validate_seq($string)\n\n  # the following method returns or accepts a Species object:\n\n  $seqobj->species();\n\nPlease see L<Bio::Species> for more information on this object.\n\n  # the following method returns or accepts an Annotation object\n  # which in turn allows access to Annotation::Reference\n  # and Annotation::Comment objects:\n\n  $seqobj->annotation();\n\nThese annotations typically refer to entire sequences, unlike\nfeatures.  See L<Bio::AnnotationCollectionI>,\nL<Bio::Annotation::Collection>, L<Bio::Annotation::Reference>, and\nL<Bio::Annotation::Comment> for details.\n\nIt is also important to be able to describe defined portions of a\nsequence. The combination of some description and the corresponding\nsub-sequence is called a feature - an exon and its coordinates within\na gene is an example of a feature, or a domain within a protein.\n\n  # the following methods return an array of SeqFeatureI objects:\n\n  $seqobj->get_SeqFeatures # The 'top level' sequence features\n  $seqobj->get_all_SeqFeatures # All sequence features, including sub-seq\n                               # features, such as features in an exon\n\n  # to find out the number of features use:\n\n  $seqobj->feature_count\n\nHere are just some of the methods available to SeqFeatureI objects:\n\n  # these methods return numbers:\n\n  $feat->start          # start position (1 is the first base)\n  $feat->end            # end position (2 is the second base)\n  $feat->strand         # 1 means forward, -1 reverse, 0 not relevant\n\n  # these methods return or accept strings:\n\n  $feat->primary_tag    # the name of the sequence feature, eg\n                        # 'exon', 'glycoslyation site', 'TM domain'\n  $feat->source_tag     # where the feature comes from, eg, 'EMBL_GenBank',\n                        # or 'BLAST'\n\n  # this method returns the more austere PrimarySeq object, not a\n  # Seq object - the main difference is that PrimarySeq objects do not\n  # themselves contain sequence features\n\n  $feat->seq            # the sequence between start,end on the\n                        # correct strand of the sequence\n\nSee L<Bio::PrimarySeq> for more details on PrimarySeq objects.\n\n  # useful methods for feature comparisons, for start/end points\n\n  $feat->overlaps($other)  # do $feat and $other overlap?\n  $feat->contains($other)  # is $other completely within $feat?\n  $feat->equals($other)    # do $feat and $other completely agree?\n\n  # one can also add features\n\n  $seqobj->add_SeqFeature($feat)     # returns 1 if successful\n  $seqobj->add_SeqFeature(@features) # returns 1 if successful\n\n  # sub features. For complex join() statements, the feature\n  # is one sequence feature with many sub SeqFeatures\n\n  $feat->sub_SeqFeature  # returns array of sub seq features\n\nPlease see L<Bio::SeqFeatureI> and L<Bio::SeqFeature::Generic>,\nfor more information on sequence features.\n\nIt is worth mentioning that one can also retrieve the start and end\npositions of a feature using a Bio::LocationI object:\n\n  $location = $feat->location # $location is a Bio::LocationI object\n  $location->start;           # start position\n  $location->end;             # end position\n\nThis is useful because one needs a Bio::Location::SplitLocationI object\nin order to retrieve the coordinates inside the Genbank or EMBL join()\nstatements (e.g. \"CDS    join(51..142,273..495,1346..1474)\"):\n\n  if ( $feat->location->isa('Bio::Location::SplitLocationI') &&\n\t       $feat->primary_tag eq 'CDS' )  {\n    foreach $loc ( $feat->location->sub_Location ) {\n      print $loc->start . \"..\" . $loc->end . \"\\n\";\n    }\n  }\n\nSee L<Bio::LocationI> and L<Bio::Location::SplitLocationI> for more\ninformation.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqI\n\nNote that this includes implementing Bio::PrimarySeqI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, inspired by Ian Korf objects\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Seq;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::SeqI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::FeatureHolderI);\n\n=head2 new\n\n Title   : new\n Usage   : $seq = Bio::Seq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                 -id  => 'human_id',\n\t\t\t\t -accession_number => 'AL000012',\n\t\t\t       );\n\n Function: Returns a new Seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number\n Returns : a new Bio::Seq object\n\n\nsub new {\n    my($caller,@args) = @_;\n\n    if( $caller ne 'Bio::Seq') {\n\t$caller = ref($caller) if ref($caller);\n    }\n\n    # we know our inherietance heirarchy\n    my $self = Bio::Root::Root->new(@args);\n    bless $self,$caller;\n\n    # this is way too sneaky probably. We delegate the construction of\n    # the Seq object onto PrimarySeq and then pop primary_seq into\n    # our primary_seq slot\n\n    my $pseq = Bio::PrimarySeq->new(@args);\n\n    # as we have just made this, we know it is ok to set hash directly\n    # rather than going through the method\n\n    $self->{'primary_seq'} = $pseq;\n\n    # setting this array is now delayed until the final\n    # moment, again speed ups for non feature containing things\n    # $self->{'_as_feat'} = [];\n\n\n    my ($ann, $pid,$feat,$species) = &Bio::Root::RootI::_rearrange($self,[qw(ANNOTATION PRIMARY_ID FEATURES SPECIES)], @args);\n\n    # for a number of cases - reading fasta files - these are never set. This\n    # gives a quick optimisation around testing things later on\n\n    if( defined $ann || defined $pid || defined $feat || defined $species ) {\n\t$pid && $self->primary_id($pid);\n\t$species && $self->species($species);\n\t$ann && $self->annotation($ann);\n\t\n\tif( defined $feat ) {\n\t    if( ref($feat) !~ /ARRAY/i ) {\n\t\tif( ref($feat) && $feat->isa('Bio::SeqFeatureI') ) {\n\t\t    $self->add_SeqFeature($feat);\n\t\t} else {\n\t\t    $self->warn(\"Must specify a valid Bio::SeqFeatureI or ArrayRef of Bio::SeqFeatureI's with the -features init parameter for \".ref($self));\n\t\t}\n\t    } else {\n\t\tforeach my $feature ( @$feat ) {\n\t\t    $self->add_SeqFeature($feature);\n\t\t}\t\n\t    }\n\t}\n    }\n\n    return $self;\n}\n\n=head1 PrimarySeq interface\n\n\nThe PrimarySeq interface provides the basic sequence getting\nand setting methods for on all sequences.\n\nThese methods implement the Bio::PrimarySeq interface by delegating\nto the primary_seq inside the object. This means that you\ncan use a Seq object wherever there is a PrimarySeq, and\nof course, you are free to use these functions anyway.\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Get/Set the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n    return shift->primary_seq()->seq(@_);\n}\n\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of type \",\n\t\t      ref($seq), \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z), '-','.','*','=', and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    return shift->primary_seq()->validate_seq(@_);\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Example :\n Returns : Integer representing the length of the sequence.\n Args    : None\n\n\nsub length {\n    return shift->primary_seq()->length(@_);\n}\n\n=head1 Methods from the Bio::PrimarySeqI interface\n\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : A string\n Args    : 2 integers\n\n\n\nsub subseq {\n    return shift->primary_seq()->subseq(@_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id = $obj->display_id or $obj->display_id($newid);\n Function: Gets or sets the display id, also known as the common name of\n           the Seq object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the LOCUS\n           field of the GenBank/EMBL databanks and the ID field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience issues.\n Returns : A string\n Args    : None or a new id\n\n\n\nsub display_id {\n   return shift->primary_seq->display_id(@_);\n}\n\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n\n           Can also be used to set the accession number.\n Example : $key = $seq->accession_number or $seq->accession_number($key)\n Returns : A string\n Args    : None or an accession number\n\n\n\nsub accession_number {\n   return shift->primary_seq->accession_number(@_);\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $seqobj->desc($string) or $seqobj->desc()\n Function: Sets or gets the description of the sequence\n Example :\n Returns : The description\n Args    : The description or none\n\n\n\nsub desc {\n   return shift->primary_seq->desc(@_);\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage\n           their own object ids in a way the implementation can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural id, this method should return\n           a stringified memory location.\n\n           Can also be used to set the primary_id (or unset to undef).\n\n           [Note this method name is likely to change in 1.3]\n\n Example : $id = $seq->primary_id or $seq->primary_id($id)\n Returns : A string\n Args    : None or an id, or undef to unset the primary id.\n\n\n\nsub primary_id {\n    # Note: this used to not delegate to the primary seq. This is\n    # really bad in very subtle ways. E.g., if you created the object\n    # with a primary id given to the constructor and then later you\n    # change the primary id, if this method wouldn't delegate you'd\n    # have different values for primary id in the PrimarySeq object\n    # compared to this instance. Not good.\n\n    # I can't remember why not delegating was ever deemed\n    # advantageous, but I hereby claim that its problems far outweigh\n    # its advantages, if there are any. Convince me otherwise if you\n    # disagree. HL 2004/08/05\n\n    return shift->primary_seq->primary_id(@_);\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if ( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t   }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t );\n Example :\n Returns : 1 or 0\n Args    : None\n\n\n\nsub can_call_new {\n    return 1;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if ( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->primary_seq->alphabet(@_) if @_ && defined $_[0];\n   return $self->primary_seq->alphabet();\n}\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular {\n    return shift->primary_seq()->is_circular(@_);\n}\n\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n Returns : A number\n\n\nsub version{\n    return shift->primary_seq->version(@_);\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n\n\nsub authority {\n    return shift->primary_seq()->authority(@_);\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection\n\n Returns : A scalar\n\n\n\nsub namespace{\n    return shift->primary_seq()->namespace(@_);\n}\n\n=head1 Methods for Bio::DescribableI compliance\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking\n           this is a good idea)\n\n           This is aliased to display_id().\n Returns : A scalar\n\n\nsub display_name {\n    return shift->display_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a\n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is aliased to desc().\n Returns : A scalar\n\n\nsub description {\n    return shift->desc(@_);\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $seq->annotation or \n           $seq->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information","parameters":[{"label":"$obj"},{"label":"$value"}]},"line":951,"kind":12,"range":{"end":{"line":962,"character":9999},"start":{"line":951,"character":0}}},{"line":959,"name":"Bio","kind":12,"containerName":"Annotation::Collection"},{"name":"get_SeqFeatures","containerName":"main::","children":[{"line":995,"name":"$self","localvar":"my","containerName":"get_SeqFeatures","kind":13,"definition":"my"},{"line":997,"name":"$self","kind":13,"containerName":"get_SeqFeatures"},{"line":998,"kind":13,"containerName":"get_SeqFeatures","name":"$self"},{"line":1001,"kind":13,"containerName":"get_SeqFeatures","name":"$self"}],"definition":"sub","kind":12,"range":{"end":{"line":1001,"character":9999},"start":{"line":994,"character":0}},"line":994},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Seq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq - Sequence object, with features\n\n=head1 SYNOPSIS\n\n    # This is the main sequence object in Bioperl\n\n    # gets a sequence from a file\n    $seqio  = Bio::SeqIO->new( '-format' => 'embl' , -file => 'myfile.dat');\n    $seqobj = $seqio->next_seq();\n\n    # SeqIO can both read and write sequences; see Bio::SeqIO\n    # for more information and examples\n\n    # get from database\n    $db = Bio::DB::GenBank->new();\n    $seqobj = $db->get_Seq_by_acc('X78121');\n\n    # make from strings in script\n    $seqobj = Bio::Seq->new( -display_id => 'my_id',\n\t\t\t     -seq => $sequence_as_string);\n\n    # gets sequence as a string from sequence object\n    $seqstr   = $seqobj->seq(); # actual sequence as a string\n    $seqstr   = $seqobj->subseq(10,50); # slice in biological coordinates\n\n    # retrieves information from the sequence\n    # features must implement Bio::SeqFeatureI interface\n\n    @features = $seqobj->get_SeqFeatures(); # just top level\n    foreach my $feat ( @features ) {\n\tprint \"Feature \",$feat->primary_tag,\" starts \",$feat->start,\" ends \",\n\t$feat->end,\" strand \",$feat->strand,\"\\n\";\n\n        # features retain link to underlying sequence object\n        print \"Feature sequence is \",$feat->seq->seq(),\"\\n\"\n    }\n\n    # sequences may have a species\n\n    if( defined $seq->species ) {\n\tprint \"Sequence is from \",$species->binomial,\" [\",$species->common_name,\"]\\n\";\n    }\n\n    # annotation objects are Bio::AnnotationCollectionI's\n    $ann      = $seqobj->annotation(); # annotation object\n\n    # references is one type of annotations to get. Also get\n    # comment and dblink. Look at Bio::AnnotationCollection for\n    # more information\n\n    foreach my $ref ( $ann->get_Annotations('reference') ) {\n\tprint \"Reference \",$ref->title,\"\\n\";\n    }\n\n    # you can get truncations, translations and reverse complements, these\n    # all give back Bio::Seq objects themselves, though currently with no\n    # features transfered\n\n    my $trunc = $seqobj->trunc(100,200);\n    my $rev   = $seqobj->revcom();\n\n    # there are many options to translate - check out the docs\n    my $trans = $seqobj->translate();\n\n    # these functions can be chained together\n\n    my $trans_trunc_rev = $seqobj->trunc(100,200)->revcom->translate();\n\n\n\n=head1 DESCRIPTION\n\nA Seq object is a sequence with sequence features placed on it. The\nSeq object contains a PrimarySeq object for the actual sequence and\nalso implements its interface.\n\nIn Bioperl we have 3 main players that people are going to use frequently\n\n  Bio::PrimarySeq  - just the sequence and its names, nothing else.\n  Bio::SeqFeatureI - a feature on a sequence, potentially with a sequence\n                     and a location and annotation.\n  Bio::Seq         - A sequence and a collection of sequence features\n                     (an aggregate) with its own annotation.\n\nAlthough Bioperl is not tied heavily to file formats these distinctions do\nmap to file formats sensibly and for some bioinformaticians this might help\n\n  Bio::PrimarySeq  - Fasta file of a sequence\n  Bio::SeqFeatureI - A single entry in an EMBL/GenBank/DDBJ feature table\n  Bio::Seq         - A single EMBL/GenBank/DDBJ entry\n\nBy having this split we avoid a lot of nasty circular references\n(sequence features can hold a reference to a sequence without the sequence\nholding a reference to the sequence feature). See L<Bio::PrimarySeq> and\nL<Bio::SeqFeatureI> for more information.\n\nIan Korf really helped in the design of the Seq and SeqFeature system.\n\n=head2 Examples\n\nA simple and fundamental block of code:\n\n  use Bio::SeqIO;\n\n  my $seqIOobj = Bio::SeqIO->new(-file=>\"1.fa\"); # create a SeqIO object\n  my $seqobj = $seqIOobj->next_seq;              # get a Seq object\n\nWith the Seq object in hand one has access to a powerful set of Bioperl\nmethods and related Bioperl objects. This next script will take a file of sequences\nin EMBL format and create a file of the reverse-complemented sequences\nin Fasta format using Seq objects. It also prints out details about the\nexons it finds as sequence features in Genbank Flat File format.\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\n  while((my $seqobj = $seqin->next_seq())) {\n      print \"Seen sequence \",$seqobj->display_id,\", start of seq \",\n            substr($seqobj->seq,1,10),\"\\n\";\n      if( $seqobj->alphabet eq 'dna') {\n\t    $rev = $seqobj->revcom;\n\t    $id  = $seqobj->display_id();\n            $id  = \"$id.rev\";\n            $rev->display_id($id);\n            $seqout->write_seq($rev);\n      }\n\n      foreach $feat ( $seqobj->get_SeqFeatures() ) {\n           if( $feat->primary_tag eq 'exon' ) {\n              print STDOUT \"Location \",$feat->start,\":\",\n                    $feat->end,\" GFF[\",$feat->gff_string,\"]\\n\";\n\t   }\n      }\n  }\n\nLet's examine the script. The lines below import the Bioperl modules.\nSeq is the main Bioperl sequence object and SeqIO is the Bioperl support\nfor reading sequences from files and to files\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n\nThese two lines create two SeqIO streams: one for reading in sequences\nand one for outputting sequences:\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\nNotice that in the \"$seqout\" case there is a greater-than sign,\nindicating the file is being opened for writing.\n\nUsing the\n\n  '-argument' => value\n\nsyntax is common in Bioperl. The file argument is like an argument\nto open() . You can also pass in filehandles or FileHandle objects by\nusing the -fh argument (see L<Bio::SeqIO> documentation for details).\nMany formats in Bioperl are handled, including Fasta, EMBL, GenBank,\nSwissprot (swiss), PIR, and GCG.\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\nThis is the main loop which will loop progressively through sequences\nin a file, and each call to $seqio-E<gt>next_seq() provides a new Seq\nobject from the file:\n\n  while((my $seqobj = $seqio->next_seq())) {\n\nThis print line below accesses fields in the Seq object directly. The\n$seqobj-E<gt>display_id is the way to access the display_id attribute\nof the Seq object. The $seqobj-E<gt>seq method gets the actual\nsequence out as string. Then you can do manipulation of this if\nyou want to (there are however easy ways of doing truncation,\nreverse-complement and translation).\n\n  print \"Seen sequence \",$seqobj->display_id,\", start of seq \",\n               substr($seqobj->seq,1,10),\"\\n\";\n\nBioperl has to guess the alphabet of the sequence, being either 'dna',\n'rna', or 'protein'. The alphabet attribute is one of these three\npossibilities.\n\n  if( $seqobj->alphabet eq 'dna') {\n\nThe $seqobj-E<gt>revcom method provides the reverse complement of the Seq\nobject as another Seq object. Thus, the $rev variable is a reference to\nanother Seq object. For example, one could repeat the above print line\nfor this Seq object (putting $rev in place of $seqobj). In this\ncase we are going to output the object into the file stream we built\nearlier on.\n\n  $rev = $seqobj->revcom;\n\nWhen we output it, we want the id of the outputted object\nto be changed to \"$id.rev\", ie, with .rev on the end of the name. The\nfollowing lines retrieve the id of the sequence object, add .rev\nto this and then set the display_id of the rev sequence object to\nthis. Notice that to set the display_id attribute you just need\ncall the same method, display_id(), with the new value as an argument.\nGetting and setting values with the same method is common in Bioperl.\n\n  $id  = $seqobj->display_id();\n  $id  = \"$id.rev\";\n  $rev->display_id($id);\n\nThe write_seq method on the SeqIO output object, $seqout, writes the\n$rev object to the filestream we built at the top of the script.\nThe filestream knows that it is outputting in fasta format, and\nso it provides fasta output.\n\n  $seqout->write_seq($rev);\n\nThis block of code loops over sequence features in the sequence\nobject, trying to find ones who have been tagged as 'exon'.\nFeatures have start and end attributes and can be outputted\nin Genbank Flat File format, GFF, a standarized format for sequence\nfeatures.\n\n  foreach $feat ( $seqobj->get_SeqFeatures() ) {\n      if( $feat->primary_tag eq 'exon' ) {\n          print STDOUT \"Location \",$feat->start,\":\",\n             $feat->end,\" GFF[\",$feat->gff_string,\"]\\n\";\n      }\n  }\n\nThe code above shows how a few Bio::Seq methods suffice to read, parse,\nreformat and analyze sequences from a file. A full list of methods\navailable to Bio::Seq objects is shown below. Bear in mind that some of\nthese methods come from PrimarySeq objects, which are simpler\nthan Seq objects, stripped of features (see L<Bio::PrimarySeq> for\nmore information).\n\n  # these methods return strings, and accept strings in some cases:\n\n  $seqobj->seq();              # string of sequence\n  $seqobj->subseq(5,10);       # part of the sequence as a string\n  $seqobj->accession_number(); # when there, the accession number\n  $seqobj->alphabet();         # one of 'dna','rna',or 'protein'\n  $seqobj->seq_version()       # when there, the version\n  $seqobj->keywords();         # when there, the Keywords line\n  $seqobj->length()            # length\n  $seqobj->desc();             # description\n  $seqobj->primary_id();       # a unique id for this sequence regardless\n                               # of its display_id or accession number\n  $seqobj->display_id();       # the human readable id of the sequence\n\nSome of these values map to fields in common formats. For example, The\ndisplay_id() method returns the LOCUS name of a Genbank entry,\nthe (\\S+) following the E<gt> character in a Fasta file, the ID from\na SwissProt file, and so on. The desc() method will return the DEFINITION\nline of a Genbank file, the description following the display_id in a\nFasta file, and the DE field in a SwissProt file.\n\n  # the following methods return new Seq objects, but\n  # do not transfer features across to the new object:\n\n  $seqobj->trunc(5,10)  # truncation from 5 to 10 as new object\n  $seqobj->revcom       # reverse complements sequence\n  $seqobj->translate    # translation of the sequence\n\n  # if new() can be called this method returns 1, else 0\n\n  $seqobj->can_call_new\n\n  # the following method determines if the given string will be accepted\n  # by the seq() method - if the string is acceptable then validate()\n  # returns 1, or 0 if not\n\n  $seqobj->validate_seq($string)\n\n  # the following method returns or accepts a Species object:\n\n  $seqobj->species();\n\nPlease see L<Bio::Species> for more information on this object.\n\n  # the following method returns or accepts an Annotation object\n  # which in turn allows access to Annotation::Reference\n  # and Annotation::Comment objects:\n\n  $seqobj->annotation();\n\nThese annotations typically refer to entire sequences, unlike\nfeatures.  See L<Bio::AnnotationCollectionI>,\nL<Bio::Annotation::Collection>, L<Bio::Annotation::Reference>, and\nL<Bio::Annotation::Comment> for details.\n\nIt is also important to be able to describe defined portions of a\nsequence. The combination of some description and the corresponding\nsub-sequence is called a feature - an exon and its coordinates within\na gene is an example of a feature, or a domain within a protein.\n\n  # the following methods return an array of SeqFeatureI objects:\n\n  $seqobj->get_SeqFeatures # The 'top level' sequence features\n  $seqobj->get_all_SeqFeatures # All sequence features, including sub-seq\n                               # features, such as features in an exon\n\n  # to find out the number of features use:\n\n  $seqobj->feature_count\n\nHere are just some of the methods available to SeqFeatureI objects:\n\n  # these methods return numbers:\n\n  $feat->start          # start position (1 is the first base)\n  $feat->end            # end position (2 is the second base)\n  $feat->strand         # 1 means forward, -1 reverse, 0 not relevant\n\n  # these methods return or accept strings:\n\n  $feat->primary_tag    # the name of the sequence feature, eg\n                        # 'exon', 'glycoslyation site', 'TM domain'\n  $feat->source_tag     # where the feature comes from, eg, 'EMBL_GenBank',\n                        # or 'BLAST'\n\n  # this method returns the more austere PrimarySeq object, not a\n  # Seq object - the main difference is that PrimarySeq objects do not\n  # themselves contain sequence features\n\n  $feat->seq            # the sequence between start,end on the\n                        # correct strand of the sequence\n\nSee L<Bio::PrimarySeq> for more details on PrimarySeq objects.\n\n  # useful methods for feature comparisons, for start/end points\n\n  $feat->overlaps($other)  # do $feat and $other overlap?\n  $feat->contains($other)  # is $other completely within $feat?\n  $feat->equals($other)    # do $feat and $other completely agree?\n\n  # one can also add features\n\n  $seqobj->add_SeqFeature($feat)     # returns 1 if successful\n  $seqobj->add_SeqFeature(@features) # returns 1 if successful\n\n  # sub features. For complex join() statements, the feature\n  # is one sequence feature with many sub SeqFeatures\n\n  $feat->sub_SeqFeature  # returns array of sub seq features\n\nPlease see L<Bio::SeqFeatureI> and L<Bio::SeqFeature::Generic>,\nfor more information on sequence features.\n\nIt is worth mentioning that one can also retrieve the start and end\npositions of a feature using a Bio::LocationI object:\n\n  $location = $feat->location # $location is a Bio::LocationI object\n  $location->start;           # start position\n  $location->end;             # end position\n\nThis is useful because one needs a Bio::Location::SplitLocationI object\nin order to retrieve the coordinates inside the Genbank or EMBL join()\nstatements (e.g. \"CDS    join(51..142,273..495,1346..1474)\"):\n\n  if ( $feat->location->isa('Bio::Location::SplitLocationI') &&\n\t       $feat->primary_tag eq 'CDS' )  {\n    foreach $loc ( $feat->location->sub_Location ) {\n      print $loc->start . \"..\" . $loc->end . \"\\n\";\n    }\n  }\n\nSee L<Bio::LocationI> and L<Bio::Location::SplitLocationI> for more\ninformation.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqI\n\nNote that this includes implementing Bio::PrimarySeqI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, inspired by Ian Korf objects\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Seq;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::SeqI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::FeatureHolderI);\n\n=head2 new\n\n Title   : new\n Usage   : $seq = Bio::Seq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                 -id  => 'human_id',\n\t\t\t\t -accession_number => 'AL000012',\n\t\t\t       );\n\n Function: Returns a new Seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number\n Returns : a new Bio::Seq object\n\n\nsub new {\n    my($caller,@args) = @_;\n\n    if( $caller ne 'Bio::Seq') {\n\t$caller = ref($caller) if ref($caller);\n    }\n\n    # we know our inherietance heirarchy\n    my $self = Bio::Root::Root->new(@args);\n    bless $self,$caller;\n\n    # this is way too sneaky probably. We delegate the construction of\n    # the Seq object onto PrimarySeq and then pop primary_seq into\n    # our primary_seq slot\n\n    my $pseq = Bio::PrimarySeq->new(@args);\n\n    # as we have just made this, we know it is ok to set hash directly\n    # rather than going through the method\n\n    $self->{'primary_seq'} = $pseq;\n\n    # setting this array is now delayed until the final\n    # moment, again speed ups for non feature containing things\n    # $self->{'_as_feat'} = [];\n\n\n    my ($ann, $pid,$feat,$species) = &Bio::Root::RootI::_rearrange($self,[qw(ANNOTATION PRIMARY_ID FEATURES SPECIES)], @args);\n\n    # for a number of cases - reading fasta files - these are never set. This\n    # gives a quick optimisation around testing things later on\n\n    if( defined $ann || defined $pid || defined $feat || defined $species ) {\n\t$pid && $self->primary_id($pid);\n\t$species && $self->species($species);\n\t$ann && $self->annotation($ann);\n\t\n\tif( defined $feat ) {\n\t    if( ref($feat) !~ /ARRAY/i ) {\n\t\tif( ref($feat) && $feat->isa('Bio::SeqFeatureI') ) {\n\t\t    $self->add_SeqFeature($feat);\n\t\t} else {\n\t\t    $self->warn(\"Must specify a valid Bio::SeqFeatureI or ArrayRef of Bio::SeqFeatureI's with the -features init parameter for \".ref($self));\n\t\t}\n\t    } else {\n\t\tforeach my $feature ( @$feat ) {\n\t\t    $self->add_SeqFeature($feature);\n\t\t}\t\n\t    }\n\t}\n    }\n\n    return $self;\n}\n\n=head1 PrimarySeq interface\n\n\nThe PrimarySeq interface provides the basic sequence getting\nand setting methods for on all sequences.\n\nThese methods implement the Bio::PrimarySeq interface by delegating\nto the primary_seq inside the object. This means that you\ncan use a Seq object wherever there is a PrimarySeq, and\nof course, you are free to use these functions anyway.\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Get/Set the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n    return shift->primary_seq()->seq(@_);\n}\n\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of type \",\n\t\t      ref($seq), \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z), '-','.','*','=', and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    return shift->primary_seq()->validate_seq(@_);\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Example :\n Returns : Integer representing the length of the sequence.\n Args    : None\n\n\nsub length {\n    return shift->primary_seq()->length(@_);\n}\n\n=head1 Methods from the Bio::PrimarySeqI interface\n\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : A string\n Args    : 2 integers\n\n\n\nsub subseq {\n    return shift->primary_seq()->subseq(@_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id = $obj->display_id or $obj->display_id($newid);\n Function: Gets or sets the display id, also known as the common name of\n           the Seq object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the LOCUS\n           field of the GenBank/EMBL databanks and the ID field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience issues.\n Returns : A string\n Args    : None or a new id\n\n\n\nsub display_id {\n   return shift->primary_seq->display_id(@_);\n}\n\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n\n           Can also be used to set the accession number.\n Example : $key = $seq->accession_number or $seq->accession_number($key)\n Returns : A string\n Args    : None or an accession number\n\n\n\nsub accession_number {\n   return shift->primary_seq->accession_number(@_);\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $seqobj->desc($string) or $seqobj->desc()\n Function: Sets or gets the description of the sequence\n Example :\n Returns : The description\n Args    : The description or none\n\n\n\nsub desc {\n   return shift->primary_seq->desc(@_);\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage\n           their own object ids in a way the implementation can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural id, this method should return\n           a stringified memory location.\n\n           Can also be used to set the primary_id (or unset to undef).\n\n           [Note this method name is likely to change in 1.3]\n\n Example : $id = $seq->primary_id or $seq->primary_id($id)\n Returns : A string\n Args    : None or an id, or undef to unset the primary id.\n\n\n\nsub primary_id {\n    # Note: this used to not delegate to the primary seq. This is\n    # really bad in very subtle ways. E.g., if you created the object\n    # with a primary id given to the constructor and then later you\n    # change the primary id, if this method wouldn't delegate you'd\n    # have different values for primary id in the PrimarySeq object\n    # compared to this instance. Not good.\n\n    # I can't remember why not delegating was ever deemed\n    # advantageous, but I hereby claim that its problems far outweigh\n    # its advantages, if there are any. Convince me otherwise if you\n    # disagree. HL 2004/08/05\n\n    return shift->primary_seq->primary_id(@_);\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if ( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t   }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t );\n Example :\n Returns : 1 or 0\n Args    : None\n\n\n\nsub can_call_new {\n    return 1;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if ( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->primary_seq->alphabet(@_) if @_ && defined $_[0];\n   return $self->primary_seq->alphabet();\n}\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular {\n    return shift->primary_seq()->is_circular(@_);\n}\n\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n Returns : A number\n\n\nsub version{\n    return shift->primary_seq->version(@_);\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n\n\nsub authority {\n    return shift->primary_seq()->authority(@_);\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection\n\n Returns : A scalar\n\n\n\nsub namespace{\n    return shift->primary_seq()->namespace(@_);\n}\n\n=head1 Methods for Bio::DescribableI compliance\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking\n           this is a good idea)\n\n           This is aliased to display_id().\n Returns : A scalar\n\n\nsub display_name {\n    return shift->display_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a\n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is aliased to desc().\n Returns : A scalar\n\n\nsub description {\n    return shift->desc(@_);\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $seq->annotation or \n           $seq->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n    if( defined $value ) {\n\t$obj->throw(\"object of class \".ref($value).\" does not implement \".\n\t\t    \"Bio::AnnotationCollectionI. Too bad.\")\n\t    unless $value->isa(\"Bio::AnnotationCollectionI\");\n\t$obj->{'_annotation'} = $value;\n    } elsif( ! defined $obj->{'_annotation'}) {\n\t$obj->{'_annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $obj->{'_annotation'};\n}\n\n=head1 Methods to implement Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing features.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   :\n Function: Get the feature objects held by this feature holder.\n\n           Features which are not top-level are subfeatures of one or\n           more of the returned feature objects, which means that you\n           must traverse the subfeature arrays of each top-level\n           feature object in order to traverse all features associated\n           with this sequence.\n\n           Use get_all_SeqFeatures() if you want the feature tree\n           flattened into one single array.\n\n Example :\n Returns : an array of Bio::SeqFeatureI implementing objects\n Args    : none\n\nAt some day we may want to expand this method to allow for a feature\nfilter to be passed in.\n\n\nsub get_SeqFeatures{\n   my $self = shift;\n\n   if( !defined $self->{'_as_feat'} ) {\n       $self->{'_as_feat'} = [];\n   }\n\n   return @{$self->{'_as_feat'}};\n}\n\n=head2 get_all_SeqFeatures\n\n Title   : get_all_SeqFeatures\n Usage   : @feat_ary = $seq->get_all_SeqFeatures();\n Function: Returns the tree of feature objects attached to this\n           sequence object flattened into one single array. Top-level\n           features will still contain their subfeature-arrays, which\n           means that you will encounter subfeatures twice if you\n           traverse the subfeature tree of the returned objects.\n\n           Use get_SeqFeatures() if you want the array to contain only\n           the top-level features.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : None\n\n\n\n# this implementation is inherited from FeatureHolderI\n\n=head2 feature_count\n\n Title   : feature_count\n Usage   : $seq->feature_count()\n Function: Return the number of SeqFeatures attached to a sequence\n Returns : integer representing the number of SeqFeatures\n Args    : None","label":"feature_count($self)"},"range":{"end":{"line":1041,"character":9999},"start":{"line":1036,"character":0}},"kind":12,"line":1036,"detail":"($self)","definition":"sub","name":"feature_count","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"feature_count","kind":13,"line":1037,"definition":"my"},{"line":1039,"kind":13,"containerName":"feature_count","name":"$self"},{"name":"$self","kind":13,"containerName":"feature_count","line":1040}]},{"containerName":"main::","name":"add_SeqFeature","children":[{"line":1062,"localvar":"my","containerName":"add_SeqFeature","kind":13,"name":"$self","definition":"my"},{"name":"@feat","kind":13,"containerName":"add_SeqFeature","line":1062},{"name":"$self","kind":13,"containerName":"add_SeqFeature","line":1064},{"line":1064,"containerName":"add_SeqFeature","kind":13,"name":"$self"},{"definition":"my","line":1066,"name":"$feat","localvar":"my","containerName":"add_SeqFeature","kind":13},{"kind":13,"containerName":"add_SeqFeature","name":"@feat","line":1066},{"name":"$feat","containerName":"add_SeqFeature","kind":13,"line":1067},{"line":1067,"name":"isa","containerName":"add_SeqFeature","kind":12},{"kind":13,"containerName":"add_SeqFeature","name":"$self","line":1068},{"kind":12,"containerName":"add_SeqFeature","name":"throw","line":1068},{"definition":"my","name":"$aseq","kind":13,"localvar":"my","containerName":"add_SeqFeature","line":1072},{"line":1072,"name":"$self","kind":13,"containerName":"add_SeqFeature"},{"line":1072,"kind":12,"containerName":"add_SeqFeature","name":"primary_seq"},{"name":"$feat","kind":13,"containerName":"add_SeqFeature","line":1073},{"name":"attach_seq","kind":12,"containerName":"add_SeqFeature","line":1073},{"kind":13,"containerName":"add_SeqFeature","name":"$aseq","line":1073},{"line":1073,"name":"$aseq","containerName":"add_SeqFeature","kind":13},{"name":"$self","containerName":"add_SeqFeature","kind":13,"line":1075},{"line":1075,"name":"$feat","containerName":"add_SeqFeature","kind":13}],"detail":"($self,@feat)","definition":"sub","range":{"start":{"line":1061,"character":0},"end":{"line":1076,"character":9999}},"kind":12,"line":1061,"signature":{"documentation":"1;\n# $Id: Seq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq - Sequence object, with features\n\n=head1 SYNOPSIS\n\n    # This is the main sequence object in Bioperl\n\n    # gets a sequence from a file\n    $seqio  = Bio::SeqIO->new( '-format' => 'embl' , -file => 'myfile.dat');\n    $seqobj = $seqio->next_seq();\n\n    # SeqIO can both read and write sequences; see Bio::SeqIO\n    # for more information and examples\n\n    # get from database\n    $db = Bio::DB::GenBank->new();\n    $seqobj = $db->get_Seq_by_acc('X78121');\n\n    # make from strings in script\n    $seqobj = Bio::Seq->new( -display_id => 'my_id',\n\t\t\t     -seq => $sequence_as_string);\n\n    # gets sequence as a string from sequence object\n    $seqstr   = $seqobj->seq(); # actual sequence as a string\n    $seqstr   = $seqobj->subseq(10,50); # slice in biological coordinates\n\n    # retrieves information from the sequence\n    # features must implement Bio::SeqFeatureI interface\n\n    @features = $seqobj->get_SeqFeatures(); # just top level\n    foreach my $feat ( @features ) {\n\tprint \"Feature \",$feat->primary_tag,\" starts \",$feat->start,\" ends \",\n\t$feat->end,\" strand \",$feat->strand,\"\\n\";\n\n        # features retain link to underlying sequence object\n        print \"Feature sequence is \",$feat->seq->seq(),\"\\n\"\n    }\n\n    # sequences may have a species\n\n    if( defined $seq->species ) {\n\tprint \"Sequence is from \",$species->binomial,\" [\",$species->common_name,\"]\\n\";\n    }\n\n    # annotation objects are Bio::AnnotationCollectionI's\n    $ann      = $seqobj->annotation(); # annotation object\n\n    # references is one type of annotations to get. Also get\n    # comment and dblink. Look at Bio::AnnotationCollection for\n    # more information\n\n    foreach my $ref ( $ann->get_Annotations('reference') ) {\n\tprint \"Reference \",$ref->title,\"\\n\";\n    }\n\n    # you can get truncations, translations and reverse complements, these\n    # all give back Bio::Seq objects themselves, though currently with no\n    # features transfered\n\n    my $trunc = $seqobj->trunc(100,200);\n    my $rev   = $seqobj->revcom();\n\n    # there are many options to translate - check out the docs\n    my $trans = $seqobj->translate();\n\n    # these functions can be chained together\n\n    my $trans_trunc_rev = $seqobj->trunc(100,200)->revcom->translate();\n\n\n\n=head1 DESCRIPTION\n\nA Seq object is a sequence with sequence features placed on it. The\nSeq object contains a PrimarySeq object for the actual sequence and\nalso implements its interface.\n\nIn Bioperl we have 3 main players that people are going to use frequently\n\n  Bio::PrimarySeq  - just the sequence and its names, nothing else.\n  Bio::SeqFeatureI - a feature on a sequence, potentially with a sequence\n                     and a location and annotation.\n  Bio::Seq         - A sequence and a collection of sequence features\n                     (an aggregate) with its own annotation.\n\nAlthough Bioperl is not tied heavily to file formats these distinctions do\nmap to file formats sensibly and for some bioinformaticians this might help\n\n  Bio::PrimarySeq  - Fasta file of a sequence\n  Bio::SeqFeatureI - A single entry in an EMBL/GenBank/DDBJ feature table\n  Bio::Seq         - A single EMBL/GenBank/DDBJ entry\n\nBy having this split we avoid a lot of nasty circular references\n(sequence features can hold a reference to a sequence without the sequence\nholding a reference to the sequence feature). See L<Bio::PrimarySeq> and\nL<Bio::SeqFeatureI> for more information.\n\nIan Korf really helped in the design of the Seq and SeqFeature system.\n\n=head2 Examples\n\nA simple and fundamental block of code:\n\n  use Bio::SeqIO;\n\n  my $seqIOobj = Bio::SeqIO->new(-file=>\"1.fa\"); # create a SeqIO object\n  my $seqobj = $seqIOobj->next_seq;              # get a Seq object\n\nWith the Seq object in hand one has access to a powerful set of Bioperl\nmethods and related Bioperl objects. This next script will take a file of sequences\nin EMBL format and create a file of the reverse-complemented sequences\nin Fasta format using Seq objects. It also prints out details about the\nexons it finds as sequence features in Genbank Flat File format.\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\n  while((my $seqobj = $seqin->next_seq())) {\n      print \"Seen sequence \",$seqobj->display_id,\", start of seq \",\n            substr($seqobj->seq,1,10),\"\\n\";\n      if( $seqobj->alphabet eq 'dna') {\n\t    $rev = $seqobj->revcom;\n\t    $id  = $seqobj->display_id();\n            $id  = \"$id.rev\";\n            $rev->display_id($id);\n            $seqout->write_seq($rev);\n      }\n\n      foreach $feat ( $seqobj->get_SeqFeatures() ) {\n           if( $feat->primary_tag eq 'exon' ) {\n              print STDOUT \"Location \",$feat->start,\":\",\n                    $feat->end,\" GFF[\",$feat->gff_string,\"]\\n\";\n\t   }\n      }\n  }\n\nLet's examine the script. The lines below import the Bioperl modules.\nSeq is the main Bioperl sequence object and SeqIO is the Bioperl support\nfor reading sequences from files and to files\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n\nThese two lines create two SeqIO streams: one for reading in sequences\nand one for outputting sequences:\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\nNotice that in the \"$seqout\" case there is a greater-than sign,\nindicating the file is being opened for writing.\n\nUsing the\n\n  '-argument' => value\n\nsyntax is common in Bioperl. The file argument is like an argument\nto open() . You can also pass in filehandles or FileHandle objects by\nusing the -fh argument (see L<Bio::SeqIO> documentation for details).\nMany formats in Bioperl are handled, including Fasta, EMBL, GenBank,\nSwissprot (swiss), PIR, and GCG.\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\nThis is the main loop which will loop progressively through sequences\nin a file, and each call to $seqio-E<gt>next_seq() provides a new Seq\nobject from the file:\n\n  while((my $seqobj = $seqio->next_seq())) {\n\nThis print line below accesses fields in the Seq object directly. The\n$seqobj-E<gt>display_id is the way to access the display_id attribute\nof the Seq object. The $seqobj-E<gt>seq method gets the actual\nsequence out as string. Then you can do manipulation of this if\nyou want to (there are however easy ways of doing truncation,\nreverse-complement and translation).\n\n  print \"Seen sequence \",$seqobj->display_id,\", start of seq \",\n               substr($seqobj->seq,1,10),\"\\n\";\n\nBioperl has to guess the alphabet of the sequence, being either 'dna',\n'rna', or 'protein'. The alphabet attribute is one of these three\npossibilities.\n\n  if( $seqobj->alphabet eq 'dna') {\n\nThe $seqobj-E<gt>revcom method provides the reverse complement of the Seq\nobject as another Seq object. Thus, the $rev variable is a reference to\nanother Seq object. For example, one could repeat the above print line\nfor this Seq object (putting $rev in place of $seqobj). In this\ncase we are going to output the object into the file stream we built\nearlier on.\n\n  $rev = $seqobj->revcom;\n\nWhen we output it, we want the id of the outputted object\nto be changed to \"$id.rev\", ie, with .rev on the end of the name. The\nfollowing lines retrieve the id of the sequence object, add .rev\nto this and then set the display_id of the rev sequence object to\nthis. Notice that to set the display_id attribute you just need\ncall the same method, display_id(), with the new value as an argument.\nGetting and setting values with the same method is common in Bioperl.\n\n  $id  = $seqobj->display_id();\n  $id  = \"$id.rev\";\n  $rev->display_id($id);\n\nThe write_seq method on the SeqIO output object, $seqout, writes the\n$rev object to the filestream we built at the top of the script.\nThe filestream knows that it is outputting in fasta format, and\nso it provides fasta output.\n\n  $seqout->write_seq($rev);\n\nThis block of code loops over sequence features in the sequence\nobject, trying to find ones who have been tagged as 'exon'.\nFeatures have start and end attributes and can be outputted\nin Genbank Flat File format, GFF, a standarized format for sequence\nfeatures.\n\n  foreach $feat ( $seqobj->get_SeqFeatures() ) {\n      if( $feat->primary_tag eq 'exon' ) {\n          print STDOUT \"Location \",$feat->start,\":\",\n             $feat->end,\" GFF[\",$feat->gff_string,\"]\\n\";\n      }\n  }\n\nThe code above shows how a few Bio::Seq methods suffice to read, parse,\nreformat and analyze sequences from a file. A full list of methods\navailable to Bio::Seq objects is shown below. Bear in mind that some of\nthese methods come from PrimarySeq objects, which are simpler\nthan Seq objects, stripped of features (see L<Bio::PrimarySeq> for\nmore information).\n\n  # these methods return strings, and accept strings in some cases:\n\n  $seqobj->seq();              # string of sequence\n  $seqobj->subseq(5,10);       # part of the sequence as a string\n  $seqobj->accession_number(); # when there, the accession number\n  $seqobj->alphabet();         # one of 'dna','rna',or 'protein'\n  $seqobj->seq_version()       # when there, the version\n  $seqobj->keywords();         # when there, the Keywords line\n  $seqobj->length()            # length\n  $seqobj->desc();             # description\n  $seqobj->primary_id();       # a unique id for this sequence regardless\n                               # of its display_id or accession number\n  $seqobj->display_id();       # the human readable id of the sequence\n\nSome of these values map to fields in common formats. For example, The\ndisplay_id() method returns the LOCUS name of a Genbank entry,\nthe (\\S+) following the E<gt> character in a Fasta file, the ID from\na SwissProt file, and so on. The desc() method will return the DEFINITION\nline of a Genbank file, the description following the display_id in a\nFasta file, and the DE field in a SwissProt file.\n\n  # the following methods return new Seq objects, but\n  # do not transfer features across to the new object:\n\n  $seqobj->trunc(5,10)  # truncation from 5 to 10 as new object\n  $seqobj->revcom       # reverse complements sequence\n  $seqobj->translate    # translation of the sequence\n\n  # if new() can be called this method returns 1, else 0\n\n  $seqobj->can_call_new\n\n  # the following method determines if the given string will be accepted\n  # by the seq() method - if the string is acceptable then validate()\n  # returns 1, or 0 if not\n\n  $seqobj->validate_seq($string)\n\n  # the following method returns or accepts a Species object:\n\n  $seqobj->species();\n\nPlease see L<Bio::Species> for more information on this object.\n\n  # the following method returns or accepts an Annotation object\n  # which in turn allows access to Annotation::Reference\n  # and Annotation::Comment objects:\n\n  $seqobj->annotation();\n\nThese annotations typically refer to entire sequences, unlike\nfeatures.  See L<Bio::AnnotationCollectionI>,\nL<Bio::Annotation::Collection>, L<Bio::Annotation::Reference>, and\nL<Bio::Annotation::Comment> for details.\n\nIt is also important to be able to describe defined portions of a\nsequence. The combination of some description and the corresponding\nsub-sequence is called a feature - an exon and its coordinates within\na gene is an example of a feature, or a domain within a protein.\n\n  # the following methods return an array of SeqFeatureI objects:\n\n  $seqobj->get_SeqFeatures # The 'top level' sequence features\n  $seqobj->get_all_SeqFeatures # All sequence features, including sub-seq\n                               # features, such as features in an exon\n\n  # to find out the number of features use:\n\n  $seqobj->feature_count\n\nHere are just some of the methods available to SeqFeatureI objects:\n\n  # these methods return numbers:\n\n  $feat->start          # start position (1 is the first base)\n  $feat->end            # end position (2 is the second base)\n  $feat->strand         # 1 means forward, -1 reverse, 0 not relevant\n\n  # these methods return or accept strings:\n\n  $feat->primary_tag    # the name of the sequence feature, eg\n                        # 'exon', 'glycoslyation site', 'TM domain'\n  $feat->source_tag     # where the feature comes from, eg, 'EMBL_GenBank',\n                        # or 'BLAST'\n\n  # this method returns the more austere PrimarySeq object, not a\n  # Seq object - the main difference is that PrimarySeq objects do not\n  # themselves contain sequence features\n\n  $feat->seq            # the sequence between start,end on the\n                        # correct strand of the sequence\n\nSee L<Bio::PrimarySeq> for more details on PrimarySeq objects.\n\n  # useful methods for feature comparisons, for start/end points\n\n  $feat->overlaps($other)  # do $feat and $other overlap?\n  $feat->contains($other)  # is $other completely within $feat?\n  $feat->equals($other)    # do $feat and $other completely agree?\n\n  # one can also add features\n\n  $seqobj->add_SeqFeature($feat)     # returns 1 if successful\n  $seqobj->add_SeqFeature(@features) # returns 1 if successful\n\n  # sub features. For complex join() statements, the feature\n  # is one sequence feature with many sub SeqFeatures\n\n  $feat->sub_SeqFeature  # returns array of sub seq features\n\nPlease see L<Bio::SeqFeatureI> and L<Bio::SeqFeature::Generic>,\nfor more information on sequence features.\n\nIt is worth mentioning that one can also retrieve the start and end\npositions of a feature using a Bio::LocationI object:\n\n  $location = $feat->location # $location is a Bio::LocationI object\n  $location->start;           # start position\n  $location->end;             # end position\n\nThis is useful because one needs a Bio::Location::SplitLocationI object\nin order to retrieve the coordinates inside the Genbank or EMBL join()\nstatements (e.g. \"CDS    join(51..142,273..495,1346..1474)\"):\n\n  if ( $feat->location->isa('Bio::Location::SplitLocationI') &&\n\t       $feat->primary_tag eq 'CDS' )  {\n    foreach $loc ( $feat->location->sub_Location ) {\n      print $loc->start . \"..\" . $loc->end . \"\\n\";\n    }\n  }\n\nSee L<Bio::LocationI> and L<Bio::Location::SplitLocationI> for more\ninformation.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqI\n\nNote that this includes implementing Bio::PrimarySeqI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, inspired by Ian Korf objects\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Seq;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::SeqI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::FeatureHolderI);\n\n=head2 new\n\n Title   : new\n Usage   : $seq = Bio::Seq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                 -id  => 'human_id',\n\t\t\t\t -accession_number => 'AL000012',\n\t\t\t       );\n\n Function: Returns a new Seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number\n Returns : a new Bio::Seq object\n\n\nsub new {\n    my($caller,@args) = @_;\n\n    if( $caller ne 'Bio::Seq') {\n\t$caller = ref($caller) if ref($caller);\n    }\n\n    # we know our inherietance heirarchy\n    my $self = Bio::Root::Root->new(@args);\n    bless $self,$caller;\n\n    # this is way too sneaky probably. We delegate the construction of\n    # the Seq object onto PrimarySeq and then pop primary_seq into\n    # our primary_seq slot\n\n    my $pseq = Bio::PrimarySeq->new(@args);\n\n    # as we have just made this, we know it is ok to set hash directly\n    # rather than going through the method\n\n    $self->{'primary_seq'} = $pseq;\n\n    # setting this array is now delayed until the final\n    # moment, again speed ups for non feature containing things\n    # $self->{'_as_feat'} = [];\n\n\n    my ($ann, $pid,$feat,$species) = &Bio::Root::RootI::_rearrange($self,[qw(ANNOTATION PRIMARY_ID FEATURES SPECIES)], @args);\n\n    # for a number of cases - reading fasta files - these are never set. This\n    # gives a quick optimisation around testing things later on\n\n    if( defined $ann || defined $pid || defined $feat || defined $species ) {\n\t$pid && $self->primary_id($pid);\n\t$species && $self->species($species);\n\t$ann && $self->annotation($ann);\n\t\n\tif( defined $feat ) {\n\t    if( ref($feat) !~ /ARRAY/i ) {\n\t\tif( ref($feat) && $feat->isa('Bio::SeqFeatureI') ) {\n\t\t    $self->add_SeqFeature($feat);\n\t\t} else {\n\t\t    $self->warn(\"Must specify a valid Bio::SeqFeatureI or ArrayRef of Bio::SeqFeatureI's with the -features init parameter for \".ref($self));\n\t\t}\n\t    } else {\n\t\tforeach my $feature ( @$feat ) {\n\t\t    $self->add_SeqFeature($feature);\n\t\t}\t\n\t    }\n\t}\n    }\n\n    return $self;\n}\n\n=head1 PrimarySeq interface\n\n\nThe PrimarySeq interface provides the basic sequence getting\nand setting methods for on all sequences.\n\nThese methods implement the Bio::PrimarySeq interface by delegating\nto the primary_seq inside the object. This means that you\ncan use a Seq object wherever there is a PrimarySeq, and\nof course, you are free to use these functions anyway.\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Get/Set the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n    return shift->primary_seq()->seq(@_);\n}\n\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of type \",\n\t\t      ref($seq), \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z), '-','.','*','=', and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    return shift->primary_seq()->validate_seq(@_);\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Example :\n Returns : Integer representing the length of the sequence.\n Args    : None\n\n\nsub length {\n    return shift->primary_seq()->length(@_);\n}\n\n=head1 Methods from the Bio::PrimarySeqI interface\n\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : A string\n Args    : 2 integers\n\n\n\nsub subseq {\n    return shift->primary_seq()->subseq(@_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id = $obj->display_id or $obj->display_id($newid);\n Function: Gets or sets the display id, also known as the common name of\n           the Seq object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the LOCUS\n           field of the GenBank/EMBL databanks and the ID field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience issues.\n Returns : A string\n Args    : None or a new id\n\n\n\nsub display_id {\n   return shift->primary_seq->display_id(@_);\n}\n\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n\n           Can also be used to set the accession number.\n Example : $key = $seq->accession_number or $seq->accession_number($key)\n Returns : A string\n Args    : None or an accession number\n\n\n\nsub accession_number {\n   return shift->primary_seq->accession_number(@_);\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $seqobj->desc($string) or $seqobj->desc()\n Function: Sets or gets the description of the sequence\n Example :\n Returns : The description\n Args    : The description or none\n\n\n\nsub desc {\n   return shift->primary_seq->desc(@_);\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage\n           their own object ids in a way the implementation can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural id, this method should return\n           a stringified memory location.\n\n           Can also be used to set the primary_id (or unset to undef).\n\n           [Note this method name is likely to change in 1.3]\n\n Example : $id = $seq->primary_id or $seq->primary_id($id)\n Returns : A string\n Args    : None or an id, or undef to unset the primary id.\n\n\n\nsub primary_id {\n    # Note: this used to not delegate to the primary seq. This is\n    # really bad in very subtle ways. E.g., if you created the object\n    # with a primary id given to the constructor and then later you\n    # change the primary id, if this method wouldn't delegate you'd\n    # have different values for primary id in the PrimarySeq object\n    # compared to this instance. Not good.\n\n    # I can't remember why not delegating was ever deemed\n    # advantageous, but I hereby claim that its problems far outweigh\n    # its advantages, if there are any. Convince me otherwise if you\n    # disagree. HL 2004/08/05\n\n    return shift->primary_seq->primary_id(@_);\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if ( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t   }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t );\n Example :\n Returns : 1 or 0\n Args    : None\n\n\n\nsub can_call_new {\n    return 1;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if ( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->primary_seq->alphabet(@_) if @_ && defined $_[0];\n   return $self->primary_seq->alphabet();\n}\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular {\n    return shift->primary_seq()->is_circular(@_);\n}\n\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n Returns : A number\n\n\nsub version{\n    return shift->primary_seq->version(@_);\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n\n\nsub authority {\n    return shift->primary_seq()->authority(@_);\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection\n\n Returns : A scalar\n\n\n\nsub namespace{\n    return shift->primary_seq()->namespace(@_);\n}\n\n=head1 Methods for Bio::DescribableI compliance\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking\n           this is a good idea)\n\n           This is aliased to display_id().\n Returns : A scalar\n\n\nsub display_name {\n    return shift->display_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a\n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is aliased to desc().\n Returns : A scalar\n\n\nsub description {\n    return shift->desc(@_);\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $seq->annotation or \n           $seq->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n    if( defined $value ) {\n\t$obj->throw(\"object of class \".ref($value).\" does not implement \".\n\t\t    \"Bio::AnnotationCollectionI. Too bad.\")\n\t    unless $value->isa(\"Bio::AnnotationCollectionI\");\n\t$obj->{'_annotation'} = $value;\n    } elsif( ! defined $obj->{'_annotation'}) {\n\t$obj->{'_annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $obj->{'_annotation'};\n}\n\n=head1 Methods to implement Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing features.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   :\n Function: Get the feature objects held by this feature holder.\n\n           Features which are not top-level are subfeatures of one or\n           more of the returned feature objects, which means that you\n           must traverse the subfeature arrays of each top-level\n           feature object in order to traverse all features associated\n           with this sequence.\n\n           Use get_all_SeqFeatures() if you want the feature tree\n           flattened into one single array.\n\n Example :\n Returns : an array of Bio::SeqFeatureI implementing objects\n Args    : none\n\nAt some day we may want to expand this method to allow for a feature\nfilter to be passed in.\n\n\nsub get_SeqFeatures{\n   my $self = shift;\n\n   if( !defined $self->{'_as_feat'} ) {\n       $self->{'_as_feat'} = [];\n   }\n\n   return @{$self->{'_as_feat'}};\n}\n\n=head2 get_all_SeqFeatures\n\n Title   : get_all_SeqFeatures\n Usage   : @feat_ary = $seq->get_all_SeqFeatures();\n Function: Returns the tree of feature objects attached to this\n           sequence object flattened into one single array. Top-level\n           features will still contain their subfeature-arrays, which\n           means that you will encounter subfeatures twice if you\n           traverse the subfeature tree of the returned objects.\n\n           Use get_SeqFeatures() if you want the array to contain only\n           the top-level features.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : None\n\n\n\n# this implementation is inherited from FeatureHolderI\n\n=head2 feature_count\n\n Title   : feature_count\n Usage   : $seq->feature_count()\n Function: Return the number of SeqFeatures attached to a sequence\n Returns : integer representing the number of SeqFeatures\n Args    : None\n\n\n\nsub feature_count {\n    my ($self) = @_;\n\n    if (defined($self->{'_as_feat'})) {\n\treturn ($#{$self->{'_as_feat'}} + 1);\n    } else {\n\treturn 0;\n    }\n}\n\n=head2 add_SeqFeature\n\n Title   : add_SeqFeature\n Usage   : $seq->add_SeqFeature($feat);\n           $seq->add_SeqFeature(@feat);\n Function: Adds the given feature object (or each of an array of feature\n           objects to the feature array of this\n           sequence. The object passed is required to implement the\n           Bio::SeqFeatureI interface.\n Returns : 1 on success\n Args    : A Bio::SeqFeatureI implementing object, or an array of such objects.","parameters":[{"label":"$self"},{"label":"@feat"}],"label":"add_SeqFeature($self,@feat)"}},{"definition":"sub","name":"remove_SeqFeatures","containerName":"main::","children":[{"definition":"my","line":1096,"containerName":"remove_SeqFeatures","localvar":"my","kind":13,"name":"$self"},{"line":1098,"name":"$self","kind":13,"containerName":"remove_SeqFeatures"},{"definition":"my","containerName":"remove_SeqFeatures","localvar":"my","kind":13,"name":"@feats","line":1099},{"containerName":"remove_SeqFeatures","kind":13,"name":"$self","line":1099}],"kind":12,"range":{"end":{"character":9999,"line":1099},"start":{"character":0,"line":1095}},"line":1095},{"kind":13,"containerName":null,"name":"%self","line":1100},{"line":1101,"name":"@feats","containerName":null,"kind":13},{"line":1168,"range":{"start":{"character":0,"line":1168},"end":{"character":9999,"line":1170}},"kind":12,"definition":"sub","children":[{"containerName":"id","kind":12,"name":"display_id","line":1169}],"containerName":"main::","name":"id"},{"line":1191,"kind":12,"range":{"end":{"character":9999,"line":1210},"start":{"character":0,"line":1191}},"signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: Seq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq - Sequence object, with features\n\n=head1 SYNOPSIS\n\n    # This is the main sequence object in Bioperl\n\n    # gets a sequence from a file\n    $seqio  = Bio::SeqIO->new( '-format' => 'embl' , -file => 'myfile.dat');\n    $seqobj = $seqio->next_seq();\n\n    # SeqIO can both read and write sequences; see Bio::SeqIO\n    # for more information and examples\n\n    # get from database\n    $db = Bio::DB::GenBank->new();\n    $seqobj = $db->get_Seq_by_acc('X78121');\n\n    # make from strings in script\n    $seqobj = Bio::Seq->new( -display_id => 'my_id',\n\t\t\t     -seq => $sequence_as_string);\n\n    # gets sequence as a string from sequence object\n    $seqstr   = $seqobj->seq(); # actual sequence as a string\n    $seqstr   = $seqobj->subseq(10,50); # slice in biological coordinates\n\n    # retrieves information from the sequence\n    # features must implement Bio::SeqFeatureI interface\n\n    @features = $seqobj->get_SeqFeatures(); # just top level\n    foreach my $feat ( @features ) {\n\tprint \"Feature \",$feat->primary_tag,\" starts \",$feat->start,\" ends \",\n\t$feat->end,\" strand \",$feat->strand,\"\\n\";\n\n        # features retain link to underlying sequence object\n        print \"Feature sequence is \",$feat->seq->seq(),\"\\n\"\n    }\n\n    # sequences may have a species\n\n    if( defined $seq->species ) {\n\tprint \"Sequence is from \",$species->binomial,\" [\",$species->common_name,\"]\\n\";\n    }\n\n    # annotation objects are Bio::AnnotationCollectionI's\n    $ann      = $seqobj->annotation(); # annotation object\n\n    # references is one type of annotations to get. Also get\n    # comment and dblink. Look at Bio::AnnotationCollection for\n    # more information\n\n    foreach my $ref ( $ann->get_Annotations('reference') ) {\n\tprint \"Reference \",$ref->title,\"\\n\";\n    }\n\n    # you can get truncations, translations and reverse complements, these\n    # all give back Bio::Seq objects themselves, though currently with no\n    # features transfered\n\n    my $trunc = $seqobj->trunc(100,200);\n    my $rev   = $seqobj->revcom();\n\n    # there are many options to translate - check out the docs\n    my $trans = $seqobj->translate();\n\n    # these functions can be chained together\n\n    my $trans_trunc_rev = $seqobj->trunc(100,200)->revcom->translate();\n\n\n\n=head1 DESCRIPTION\n\nA Seq object is a sequence with sequence features placed on it. The\nSeq object contains a PrimarySeq object for the actual sequence and\nalso implements its interface.\n\nIn Bioperl we have 3 main players that people are going to use frequently\n\n  Bio::PrimarySeq  - just the sequence and its names, nothing else.\n  Bio::SeqFeatureI - a feature on a sequence, potentially with a sequence\n                     and a location and annotation.\n  Bio::Seq         - A sequence and a collection of sequence features\n                     (an aggregate) with its own annotation.\n\nAlthough Bioperl is not tied heavily to file formats these distinctions do\nmap to file formats sensibly and for some bioinformaticians this might help\n\n  Bio::PrimarySeq  - Fasta file of a sequence\n  Bio::SeqFeatureI - A single entry in an EMBL/GenBank/DDBJ feature table\n  Bio::Seq         - A single EMBL/GenBank/DDBJ entry\n\nBy having this split we avoid a lot of nasty circular references\n(sequence features can hold a reference to a sequence without the sequence\nholding a reference to the sequence feature). See L<Bio::PrimarySeq> and\nL<Bio::SeqFeatureI> for more information.\n\nIan Korf really helped in the design of the Seq and SeqFeature system.\n\n=head2 Examples\n\nA simple and fundamental block of code:\n\n  use Bio::SeqIO;\n\n  my $seqIOobj = Bio::SeqIO->new(-file=>\"1.fa\"); # create a SeqIO object\n  my $seqobj = $seqIOobj->next_seq;              # get a Seq object\n\nWith the Seq object in hand one has access to a powerful set of Bioperl\nmethods and related Bioperl objects. This next script will take a file of sequences\nin EMBL format and create a file of the reverse-complemented sequences\nin Fasta format using Seq objects. It also prints out details about the\nexons it finds as sequence features in Genbank Flat File format.\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\n  while((my $seqobj = $seqin->next_seq())) {\n      print \"Seen sequence \",$seqobj->display_id,\", start of seq \",\n            substr($seqobj->seq,1,10),\"\\n\";\n      if( $seqobj->alphabet eq 'dna') {\n\t    $rev = $seqobj->revcom;\n\t    $id  = $seqobj->display_id();\n            $id  = \"$id.rev\";\n            $rev->display_id($id);\n            $seqout->write_seq($rev);\n      }\n\n      foreach $feat ( $seqobj->get_SeqFeatures() ) {\n           if( $feat->primary_tag eq 'exon' ) {\n              print STDOUT \"Location \",$feat->start,\":\",\n                    $feat->end,\" GFF[\",$feat->gff_string,\"]\\n\";\n\t   }\n      }\n  }\n\nLet's examine the script. The lines below import the Bioperl modules.\nSeq is the main Bioperl sequence object and SeqIO is the Bioperl support\nfor reading sequences from files and to files\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n\nThese two lines create two SeqIO streams: one for reading in sequences\nand one for outputting sequences:\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\nNotice that in the \"$seqout\" case there is a greater-than sign,\nindicating the file is being opened for writing.\n\nUsing the\n\n  '-argument' => value\n\nsyntax is common in Bioperl. The file argument is like an argument\nto open() . You can also pass in filehandles or FileHandle objects by\nusing the -fh argument (see L<Bio::SeqIO> documentation for details).\nMany formats in Bioperl are handled, including Fasta, EMBL, GenBank,\nSwissprot (swiss), PIR, and GCG.\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\nThis is the main loop which will loop progressively through sequences\nin a file, and each call to $seqio-E<gt>next_seq() provides a new Seq\nobject from the file:\n\n  while((my $seqobj = $seqio->next_seq())) {\n\nThis print line below accesses fields in the Seq object directly. The\n$seqobj-E<gt>display_id is the way to access the display_id attribute\nof the Seq object. The $seqobj-E<gt>seq method gets the actual\nsequence out as string. Then you can do manipulation of this if\nyou want to (there are however easy ways of doing truncation,\nreverse-complement and translation).\n\n  print \"Seen sequence \",$seqobj->display_id,\", start of seq \",\n               substr($seqobj->seq,1,10),\"\\n\";\n\nBioperl has to guess the alphabet of the sequence, being either 'dna',\n'rna', or 'protein'. The alphabet attribute is one of these three\npossibilities.\n\n  if( $seqobj->alphabet eq 'dna') {\n\nThe $seqobj-E<gt>revcom method provides the reverse complement of the Seq\nobject as another Seq object. Thus, the $rev variable is a reference to\nanother Seq object. For example, one could repeat the above print line\nfor this Seq object (putting $rev in place of $seqobj). In this\ncase we are going to output the object into the file stream we built\nearlier on.\n\n  $rev = $seqobj->revcom;\n\nWhen we output it, we want the id of the outputted object\nto be changed to \"$id.rev\", ie, with .rev on the end of the name. The\nfollowing lines retrieve the id of the sequence object, add .rev\nto this and then set the display_id of the rev sequence object to\nthis. Notice that to set the display_id attribute you just need\ncall the same method, display_id(), with the new value as an argument.\nGetting and setting values with the same method is common in Bioperl.\n\n  $id  = $seqobj->display_id();\n  $id  = \"$id.rev\";\n  $rev->display_id($id);\n\nThe write_seq method on the SeqIO output object, $seqout, writes the\n$rev object to the filestream we built at the top of the script.\nThe filestream knows that it is outputting in fasta format, and\nso it provides fasta output.\n\n  $seqout->write_seq($rev);\n\nThis block of code loops over sequence features in the sequence\nobject, trying to find ones who have been tagged as 'exon'.\nFeatures have start and end attributes and can be outputted\nin Genbank Flat File format, GFF, a standarized format for sequence\nfeatures.\n\n  foreach $feat ( $seqobj->get_SeqFeatures() ) {\n      if( $feat->primary_tag eq 'exon' ) {\n          print STDOUT \"Location \",$feat->start,\":\",\n             $feat->end,\" GFF[\",$feat->gff_string,\"]\\n\";\n      }\n  }\n\nThe code above shows how a few Bio::Seq methods suffice to read, parse,\nreformat and analyze sequences from a file. A full list of methods\navailable to Bio::Seq objects is shown below. Bear in mind that some of\nthese methods come from PrimarySeq objects, which are simpler\nthan Seq objects, stripped of features (see L<Bio::PrimarySeq> for\nmore information).\n\n  # these methods return strings, and accept strings in some cases:\n\n  $seqobj->seq();              # string of sequence\n  $seqobj->subseq(5,10);       # part of the sequence as a string\n  $seqobj->accession_number(); # when there, the accession number\n  $seqobj->alphabet();         # one of 'dna','rna',or 'protein'\n  $seqobj->seq_version()       # when there, the version\n  $seqobj->keywords();         # when there, the Keywords line\n  $seqobj->length()            # length\n  $seqobj->desc();             # description\n  $seqobj->primary_id();       # a unique id for this sequence regardless\n                               # of its display_id or accession number\n  $seqobj->display_id();       # the human readable id of the sequence\n\nSome of these values map to fields in common formats. For example, The\ndisplay_id() method returns the LOCUS name of a Genbank entry,\nthe (\\S+) following the E<gt> character in a Fasta file, the ID from\na SwissProt file, and so on. The desc() method will return the DEFINITION\nline of a Genbank file, the description following the display_id in a\nFasta file, and the DE field in a SwissProt file.\n\n  # the following methods return new Seq objects, but\n  # do not transfer features across to the new object:\n\n  $seqobj->trunc(5,10)  # truncation from 5 to 10 as new object\n  $seqobj->revcom       # reverse complements sequence\n  $seqobj->translate    # translation of the sequence\n\n  # if new() can be called this method returns 1, else 0\n\n  $seqobj->can_call_new\n\n  # the following method determines if the given string will be accepted\n  # by the seq() method - if the string is acceptable then validate()\n  # returns 1, or 0 if not\n\n  $seqobj->validate_seq($string)\n\n  # the following method returns or accepts a Species object:\n\n  $seqobj->species();\n\nPlease see L<Bio::Species> for more information on this object.\n\n  # the following method returns or accepts an Annotation object\n  # which in turn allows access to Annotation::Reference\n  # and Annotation::Comment objects:\n\n  $seqobj->annotation();\n\nThese annotations typically refer to entire sequences, unlike\nfeatures.  See L<Bio::AnnotationCollectionI>,\nL<Bio::Annotation::Collection>, L<Bio::Annotation::Reference>, and\nL<Bio::Annotation::Comment> for details.\n\nIt is also important to be able to describe defined portions of a\nsequence. The combination of some description and the corresponding\nsub-sequence is called a feature - an exon and its coordinates within\na gene is an example of a feature, or a domain within a protein.\n\n  # the following methods return an array of SeqFeatureI objects:\n\n  $seqobj->get_SeqFeatures # The 'top level' sequence features\n  $seqobj->get_all_SeqFeatures # All sequence features, including sub-seq\n                               # features, such as features in an exon\n\n  # to find out the number of features use:\n\n  $seqobj->feature_count\n\nHere are just some of the methods available to SeqFeatureI objects:\n\n  # these methods return numbers:\n\n  $feat->start          # start position (1 is the first base)\n  $feat->end            # end position (2 is the second base)\n  $feat->strand         # 1 means forward, -1 reverse, 0 not relevant\n\n  # these methods return or accept strings:\n\n  $feat->primary_tag    # the name of the sequence feature, eg\n                        # 'exon', 'glycoslyation site', 'TM domain'\n  $feat->source_tag     # where the feature comes from, eg, 'EMBL_GenBank',\n                        # or 'BLAST'\n\n  # this method returns the more austere PrimarySeq object, not a\n  # Seq object - the main difference is that PrimarySeq objects do not\n  # themselves contain sequence features\n\n  $feat->seq            # the sequence between start,end on the\n                        # correct strand of the sequence\n\nSee L<Bio::PrimarySeq> for more details on PrimarySeq objects.\n\n  # useful methods for feature comparisons, for start/end points\n\n  $feat->overlaps($other)  # do $feat and $other overlap?\n  $feat->contains($other)  # is $other completely within $feat?\n  $feat->equals($other)    # do $feat and $other completely agree?\n\n  # one can also add features\n\n  $seqobj->add_SeqFeature($feat)     # returns 1 if successful\n  $seqobj->add_SeqFeature(@features) # returns 1 if successful\n\n  # sub features. For complex join() statements, the feature\n  # is one sequence feature with many sub SeqFeatures\n\n  $feat->sub_SeqFeature  # returns array of sub seq features\n\nPlease see L<Bio::SeqFeatureI> and L<Bio::SeqFeature::Generic>,\nfor more information on sequence features.\n\nIt is worth mentioning that one can also retrieve the start and end\npositions of a feature using a Bio::LocationI object:\n\n  $location = $feat->location # $location is a Bio::LocationI object\n  $location->start;           # start position\n  $location->end;             # end position\n\nThis is useful because one needs a Bio::Location::SplitLocationI object\nin order to retrieve the coordinates inside the Genbank or EMBL join()\nstatements (e.g. \"CDS    join(51..142,273..495,1346..1474)\"):\n\n  if ( $feat->location->isa('Bio::Location::SplitLocationI') &&\n\t       $feat->primary_tag eq 'CDS' )  {\n    foreach $loc ( $feat->location->sub_Location ) {\n      print $loc->start . \"..\" . $loc->end . \"\\n\";\n    }\n  }\n\nSee L<Bio::LocationI> and L<Bio::Location::SplitLocationI> for more\ninformation.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqI\n\nNote that this includes implementing Bio::PrimarySeqI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, inspired by Ian Korf objects\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Seq;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::SeqI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::FeatureHolderI);\n\n=head2 new\n\n Title   : new\n Usage   : $seq = Bio::Seq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                 -id  => 'human_id',\n\t\t\t\t -accession_number => 'AL000012',\n\t\t\t       );\n\n Function: Returns a new Seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number\n Returns : a new Bio::Seq object\n\n\nsub new {\n    my($caller,@args) = @_;\n\n    if( $caller ne 'Bio::Seq') {\n\t$caller = ref($caller) if ref($caller);\n    }\n\n    # we know our inherietance heirarchy\n    my $self = Bio::Root::Root->new(@args);\n    bless $self,$caller;\n\n    # this is way too sneaky probably. We delegate the construction of\n    # the Seq object onto PrimarySeq and then pop primary_seq into\n    # our primary_seq slot\n\n    my $pseq = Bio::PrimarySeq->new(@args);\n\n    # as we have just made this, we know it is ok to set hash directly\n    # rather than going through the method\n\n    $self->{'primary_seq'} = $pseq;\n\n    # setting this array is now delayed until the final\n    # moment, again speed ups for non feature containing things\n    # $self->{'_as_feat'} = [];\n\n\n    my ($ann, $pid,$feat,$species) = &Bio::Root::RootI::_rearrange($self,[qw(ANNOTATION PRIMARY_ID FEATURES SPECIES)], @args);\n\n    # for a number of cases - reading fasta files - these are never set. This\n    # gives a quick optimisation around testing things later on\n\n    if( defined $ann || defined $pid || defined $feat || defined $species ) {\n\t$pid && $self->primary_id($pid);\n\t$species && $self->species($species);\n\t$ann && $self->annotation($ann);\n\t\n\tif( defined $feat ) {\n\t    if( ref($feat) !~ /ARRAY/i ) {\n\t\tif( ref($feat) && $feat->isa('Bio::SeqFeatureI') ) {\n\t\t    $self->add_SeqFeature($feat);\n\t\t} else {\n\t\t    $self->warn(\"Must specify a valid Bio::SeqFeatureI or ArrayRef of Bio::SeqFeatureI's with the -features init parameter for \".ref($self));\n\t\t}\n\t    } else {\n\t\tforeach my $feature ( @$feat ) {\n\t\t    $self->add_SeqFeature($feature);\n\t\t}\t\n\t    }\n\t}\n    }\n\n    return $self;\n}\n\n=head1 PrimarySeq interface\n\n\nThe PrimarySeq interface provides the basic sequence getting\nand setting methods for on all sequences.\n\nThese methods implement the Bio::PrimarySeq interface by delegating\nto the primary_seq inside the object. This means that you\ncan use a Seq object wherever there is a PrimarySeq, and\nof course, you are free to use these functions anyway.\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Get/Set the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n    return shift->primary_seq()->seq(@_);\n}\n\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of type \",\n\t\t      ref($seq), \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z), '-','.','*','=', and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    return shift->primary_seq()->validate_seq(@_);\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Example :\n Returns : Integer representing the length of the sequence.\n Args    : None\n\n\nsub length {\n    return shift->primary_seq()->length(@_);\n}\n\n=head1 Methods from the Bio::PrimarySeqI interface\n\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : A string\n Args    : 2 integers\n\n\n\nsub subseq {\n    return shift->primary_seq()->subseq(@_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id = $obj->display_id or $obj->display_id($newid);\n Function: Gets or sets the display id, also known as the common name of\n           the Seq object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the LOCUS\n           field of the GenBank/EMBL databanks and the ID field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience issues.\n Returns : A string\n Args    : None or a new id\n\n\n\nsub display_id {\n   return shift->primary_seq->display_id(@_);\n}\n\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n\n           Can also be used to set the accession number.\n Example : $key = $seq->accession_number or $seq->accession_number($key)\n Returns : A string\n Args    : None or an accession number\n\n\n\nsub accession_number {\n   return shift->primary_seq->accession_number(@_);\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $seqobj->desc($string) or $seqobj->desc()\n Function: Sets or gets the description of the sequence\n Example :\n Returns : The description\n Args    : The description or none\n\n\n\nsub desc {\n   return shift->primary_seq->desc(@_);\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage\n           their own object ids in a way the implementation can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural id, this method should return\n           a stringified memory location.\n\n           Can also be used to set the primary_id (or unset to undef).\n\n           [Note this method name is likely to change in 1.3]\n\n Example : $id = $seq->primary_id or $seq->primary_id($id)\n Returns : A string\n Args    : None or an id, or undef to unset the primary id.\n\n\n\nsub primary_id {\n    # Note: this used to not delegate to the primary seq. This is\n    # really bad in very subtle ways. E.g., if you created the object\n    # with a primary id given to the constructor and then later you\n    # change the primary id, if this method wouldn't delegate you'd\n    # have different values for primary id in the PrimarySeq object\n    # compared to this instance. Not good.\n\n    # I can't remember why not delegating was ever deemed\n    # advantageous, but I hereby claim that its problems far outweigh\n    # its advantages, if there are any. Convince me otherwise if you\n    # disagree. HL 2004/08/05\n\n    return shift->primary_seq->primary_id(@_);\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if ( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t   }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t );\n Example :\n Returns : 1 or 0\n Args    : None\n\n\n\nsub can_call_new {\n    return 1;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if ( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->primary_seq->alphabet(@_) if @_ && defined $_[0];\n   return $self->primary_seq->alphabet();\n}\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular {\n    return shift->primary_seq()->is_circular(@_);\n}\n\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n Returns : A number\n\n\nsub version{\n    return shift->primary_seq->version(@_);\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n\n\nsub authority {\n    return shift->primary_seq()->authority(@_);\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection\n\n Returns : A scalar\n\n\n\nsub namespace{\n    return shift->primary_seq()->namespace(@_);\n}\n\n=head1 Methods for Bio::DescribableI compliance\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking\n           this is a good idea)\n\n           This is aliased to display_id().\n Returns : A scalar\n\n\nsub display_name {\n    return shift->display_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a\n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is aliased to desc().\n Returns : A scalar\n\n\nsub description {\n    return shift->desc(@_);\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $seq->annotation or \n           $seq->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n    if( defined $value ) {\n\t$obj->throw(\"object of class \".ref($value).\" does not implement \".\n\t\t    \"Bio::AnnotationCollectionI. Too bad.\")\n\t    unless $value->isa(\"Bio::AnnotationCollectionI\");\n\t$obj->{'_annotation'} = $value;\n    } elsif( ! defined $obj->{'_annotation'}) {\n\t$obj->{'_annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $obj->{'_annotation'};\n}\n\n=head1 Methods to implement Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing features.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   :\n Function: Get the feature objects held by this feature holder.\n\n           Features which are not top-level are subfeatures of one or\n           more of the returned feature objects, which means that you\n           must traverse the subfeature arrays of each top-level\n           feature object in order to traverse all features associated\n           with this sequence.\n\n           Use get_all_SeqFeatures() if you want the feature tree\n           flattened into one single array.\n\n Example :\n Returns : an array of Bio::SeqFeatureI implementing objects\n Args    : none\n\nAt some day we may want to expand this method to allow for a feature\nfilter to be passed in.\n\n\nsub get_SeqFeatures{\n   my $self = shift;\n\n   if( !defined $self->{'_as_feat'} ) {\n       $self->{'_as_feat'} = [];\n   }\n\n   return @{$self->{'_as_feat'}};\n}\n\n=head2 get_all_SeqFeatures\n\n Title   : get_all_SeqFeatures\n Usage   : @feat_ary = $seq->get_all_SeqFeatures();\n Function: Returns the tree of feature objects attached to this\n           sequence object flattened into one single array. Top-level\n           features will still contain their subfeature-arrays, which\n           means that you will encounter subfeatures twice if you\n           traverse the subfeature tree of the returned objects.\n\n           Use get_SeqFeatures() if you want the array to contain only\n           the top-level features.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : None\n\n\n\n# this implementation is inherited from FeatureHolderI\n\n=head2 feature_count\n\n Title   : feature_count\n Usage   : $seq->feature_count()\n Function: Return the number of SeqFeatures attached to a sequence\n Returns : integer representing the number of SeqFeatures\n Args    : None\n\n\n\nsub feature_count {\n    my ($self) = @_;\n\n    if (defined($self->{'_as_feat'})) {\n\treturn ($#{$self->{'_as_feat'}} + 1);\n    } else {\n\treturn 0;\n    }\n}\n\n=head2 add_SeqFeature\n\n Title   : add_SeqFeature\n Usage   : $seq->add_SeqFeature($feat);\n           $seq->add_SeqFeature(@feat);\n Function: Adds the given feature object (or each of an array of feature\n           objects to the feature array of this\n           sequence. The object passed is required to implement the\n           Bio::SeqFeatureI interface.\n Returns : 1 on success\n Args    : A Bio::SeqFeatureI implementing object, or an array of such objects.\n\n\n\nsub add_SeqFeature {\n   my ($self,@feat) = @_;\n\n   $self->{'_as_feat'} = [] unless $self->{'_as_feat'};\n\n   foreach my $feat ( @feat ) {\n       if( !$feat->isa(\"Bio::SeqFeatureI\") ) {\n\t   $self->throw(\"$feat is not a SeqFeatureI and that's what we expect...\");\n       }\n\n       # make sure we attach ourselves to the feature if the feature wants it\n       my $aseq = $self->primary_seq;\n       $feat->attach_seq($aseq) if $aseq;\n\n       push(@{$self->{'_as_feat'}},$feat);\n   }\n   return 1;\n}\n\n=head2 remove_SeqFeatures\n\n Title   : remove_SeqFeatures\n Usage   : $seq->remove_SeqFeatures();\n Function: Flushes all attached SeqFeatureI objects.\n\n           To remove individual feature objects, delete those from the returned\n           array and re-add the rest.\n Example :\n Returns : The array of Bio::SeqFeatureI objects removed from this seq.\n Args    : None\n\n\n\nsub remove_SeqFeatures {\n    my $self = shift;\n\n    return () unless $self->{'_as_feat'};\n    my @feats = @{$self->{'_as_feat'}};\n    $self->{'_as_feat'} = [];\n    return @feats;\n}\n\n=head1 Methods provided in the Bio::PrimarySeqI interface\n\n\nThese methods are inherited from the PrimarySeq interface\nand work as one expects, building new Bio::Seq objects\nor other information as expected. See L<Bio::PrimarySeq>\nfor more information.\n\nSequence Features are B<not> transfered to the new objects.\nThis is possibly a mistake. Anyone who feels the urge in\ndealing with this is welcome to give it a go.\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::Seq object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a protein.\n           Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also identical. If someone wants to track\n           that this sequence has be reversed, it needs to define its own\n           extensions\n\n           To do an in-place edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage collection of\n           the old object, but it is roughly speaking as efficient as an\n           in-place edit.\n\n Returns : A new (fresh) Bio::Seq object\n Args    : None\n\n\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence\n\n Example :\n Returns : A fresh Seq object\n Args    : A Seq object\n\n\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Returns : value of display_id()\n Args    : [optional] value to update display_id\n\n\n\nsub  id {\n    return shift->display_id(@_);\n}\n\n\n=head1 Seq only methods\n\n\nThese methods are specific to the Bio::Seq object, and not\nfound on the Bio::PrimarySeq object\n\n=head2 primary_seq\n\n Title   : primary_seq\n Usage   : $seq->primary_seq or $seq->primary_seq($newval)\n Function: Get or set a PrimarySeq object\n Example :\n Returns : PrimarySeq object\n Args    : None or PrimarySeq object","label":"primary_seq($obj,$value)"},"children":[{"name":"$obj","localvar":"my","containerName":"primary_seq","kind":13,"line":1192,"definition":"my"},{"line":1192,"kind":13,"containerName":"primary_seq","name":"$value"},{"line":1194,"name":"$value","containerName":"primary_seq","kind":13},{"line":1195,"name":"$value","containerName":"primary_seq","kind":13},{"containerName":"primary_seq","kind":13,"name":"$value","line":1195},{"name":"isa","containerName":"primary_seq","kind":12,"line":1195},{"line":1196,"containerName":"primary_seq","kind":13,"name":"$obj"},{"line":1196,"name":"throw","containerName":"primary_seq","kind":12},{"line":1199,"name":"$obj","kind":13,"containerName":"primary_seq"},{"containerName":"primary_seq","kind":13,"name":"$value","line":1199},{"definition":"my","line":1203,"name":"$sf","kind":13,"localvar":"my","containerName":"primary_seq"},{"line":1203,"kind":13,"containerName":"primary_seq","name":"$obj"},{"kind":12,"containerName":"primary_seq","name":"get_SeqFeatures","line":1203},{"name":"$sf","kind":13,"containerName":"primary_seq","line":1204},{"containerName":"primary_seq","kind":12,"name":"attach_seq","line":1204},{"containerName":"primary_seq","kind":13,"name":"$value","line":1204},{"line":1208,"containerName":"primary_seq","kind":13,"name":"$obj"}],"containerName":"main::","name":"primary_seq","definition":"sub","detail":"($obj,$value)"},{"range":{"start":{"line":1224,"character":0},"end":{"line":1231,"character":9999}},"kind":12,"line":1224,"signature":{"documentation":"1;\n# $Id: Seq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq - Sequence object, with features\n\n=head1 SYNOPSIS\n\n    # This is the main sequence object in Bioperl\n\n    # gets a sequence from a file\n    $seqio  = Bio::SeqIO->new( '-format' => 'embl' , -file => 'myfile.dat');\n    $seqobj = $seqio->next_seq();\n\n    # SeqIO can both read and write sequences; see Bio::SeqIO\n    # for more information and examples\n\n    # get from database\n    $db = Bio::DB::GenBank->new();\n    $seqobj = $db->get_Seq_by_acc('X78121');\n\n    # make from strings in script\n    $seqobj = Bio::Seq->new( -display_id => 'my_id',\n\t\t\t     -seq => $sequence_as_string);\n\n    # gets sequence as a string from sequence object\n    $seqstr   = $seqobj->seq(); # actual sequence as a string\n    $seqstr   = $seqobj->subseq(10,50); # slice in biological coordinates\n\n    # retrieves information from the sequence\n    # features must implement Bio::SeqFeatureI interface\n\n    @features = $seqobj->get_SeqFeatures(); # just top level\n    foreach my $feat ( @features ) {\n\tprint \"Feature \",$feat->primary_tag,\" starts \",$feat->start,\" ends \",\n\t$feat->end,\" strand \",$feat->strand,\"\\n\";\n\n        # features retain link to underlying sequence object\n        print \"Feature sequence is \",$feat->seq->seq(),\"\\n\"\n    }\n\n    # sequences may have a species\n\n    if( defined $seq->species ) {\n\tprint \"Sequence is from \",$species->binomial,\" [\",$species->common_name,\"]\\n\";\n    }\n\n    # annotation objects are Bio::AnnotationCollectionI's\n    $ann      = $seqobj->annotation(); # annotation object\n\n    # references is one type of annotations to get. Also get\n    # comment and dblink. Look at Bio::AnnotationCollection for\n    # more information\n\n    foreach my $ref ( $ann->get_Annotations('reference') ) {\n\tprint \"Reference \",$ref->title,\"\\n\";\n    }\n\n    # you can get truncations, translations and reverse complements, these\n    # all give back Bio::Seq objects themselves, though currently with no\n    # features transfered\n\n    my $trunc = $seqobj->trunc(100,200);\n    my $rev   = $seqobj->revcom();\n\n    # there are many options to translate - check out the docs\n    my $trans = $seqobj->translate();\n\n    # these functions can be chained together\n\n    my $trans_trunc_rev = $seqobj->trunc(100,200)->revcom->translate();\n\n\n\n=head1 DESCRIPTION\n\nA Seq object is a sequence with sequence features placed on it. The\nSeq object contains a PrimarySeq object for the actual sequence and\nalso implements its interface.\n\nIn Bioperl we have 3 main players that people are going to use frequently\n\n  Bio::PrimarySeq  - just the sequence and its names, nothing else.\n  Bio::SeqFeatureI - a feature on a sequence, potentially with a sequence\n                     and a location and annotation.\n  Bio::Seq         - A sequence and a collection of sequence features\n                     (an aggregate) with its own annotation.\n\nAlthough Bioperl is not tied heavily to file formats these distinctions do\nmap to file formats sensibly and for some bioinformaticians this might help\n\n  Bio::PrimarySeq  - Fasta file of a sequence\n  Bio::SeqFeatureI - A single entry in an EMBL/GenBank/DDBJ feature table\n  Bio::Seq         - A single EMBL/GenBank/DDBJ entry\n\nBy having this split we avoid a lot of nasty circular references\n(sequence features can hold a reference to a sequence without the sequence\nholding a reference to the sequence feature). See L<Bio::PrimarySeq> and\nL<Bio::SeqFeatureI> for more information.\n\nIan Korf really helped in the design of the Seq and SeqFeature system.\n\n=head2 Examples\n\nA simple and fundamental block of code:\n\n  use Bio::SeqIO;\n\n  my $seqIOobj = Bio::SeqIO->new(-file=>\"1.fa\"); # create a SeqIO object\n  my $seqobj = $seqIOobj->next_seq;              # get a Seq object\n\nWith the Seq object in hand one has access to a powerful set of Bioperl\nmethods and related Bioperl objects. This next script will take a file of sequences\nin EMBL format and create a file of the reverse-complemented sequences\nin Fasta format using Seq objects. It also prints out details about the\nexons it finds as sequence features in Genbank Flat File format.\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\n  while((my $seqobj = $seqin->next_seq())) {\n      print \"Seen sequence \",$seqobj->display_id,\", start of seq \",\n            substr($seqobj->seq,1,10),\"\\n\";\n      if( $seqobj->alphabet eq 'dna') {\n\t    $rev = $seqobj->revcom;\n\t    $id  = $seqobj->display_id();\n            $id  = \"$id.rev\";\n            $rev->display_id($id);\n            $seqout->write_seq($rev);\n      }\n\n      foreach $feat ( $seqobj->get_SeqFeatures() ) {\n           if( $feat->primary_tag eq 'exon' ) {\n              print STDOUT \"Location \",$feat->start,\":\",\n                    $feat->end,\" GFF[\",$feat->gff_string,\"]\\n\";\n\t   }\n      }\n  }\n\nLet's examine the script. The lines below import the Bioperl modules.\nSeq is the main Bioperl sequence object and SeqIO is the Bioperl support\nfor reading sequences from files and to files\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n\nThese two lines create two SeqIO streams: one for reading in sequences\nand one for outputting sequences:\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\nNotice that in the \"$seqout\" case there is a greater-than sign,\nindicating the file is being opened for writing.\n\nUsing the\n\n  '-argument' => value\n\nsyntax is common in Bioperl. The file argument is like an argument\nto open() . You can also pass in filehandles or FileHandle objects by\nusing the -fh argument (see L<Bio::SeqIO> documentation for details).\nMany formats in Bioperl are handled, including Fasta, EMBL, GenBank,\nSwissprot (swiss), PIR, and GCG.\n\n  $seqin = Bio::SeqIO->new( -format => 'EMBL' , -file => 'myfile.dat');\n  $seqout= Bio::SeqIO->new( -format => 'Fasta', -file => '>output.fa');\n\nThis is the main loop which will loop progressively through sequences\nin a file, and each call to $seqio-E<gt>next_seq() provides a new Seq\nobject from the file:\n\n  while((my $seqobj = $seqio->next_seq())) {\n\nThis print line below accesses fields in the Seq object directly. The\n$seqobj-E<gt>display_id is the way to access the display_id attribute\nof the Seq object. The $seqobj-E<gt>seq method gets the actual\nsequence out as string. Then you can do manipulation of this if\nyou want to (there are however easy ways of doing truncation,\nreverse-complement and translation).\n\n  print \"Seen sequence \",$seqobj->display_id,\", start of seq \",\n               substr($seqobj->seq,1,10),\"\\n\";\n\nBioperl has to guess the alphabet of the sequence, being either 'dna',\n'rna', or 'protein'. The alphabet attribute is one of these three\npossibilities.\n\n  if( $seqobj->alphabet eq 'dna') {\n\nThe $seqobj-E<gt>revcom method provides the reverse complement of the Seq\nobject as another Seq object. Thus, the $rev variable is a reference to\nanother Seq object. For example, one could repeat the above print line\nfor this Seq object (putting $rev in place of $seqobj). In this\ncase we are going to output the object into the file stream we built\nearlier on.\n\n  $rev = $seqobj->revcom;\n\nWhen we output it, we want the id of the outputted object\nto be changed to \"$id.rev\", ie, with .rev on the end of the name. The\nfollowing lines retrieve the id of the sequence object, add .rev\nto this and then set the display_id of the rev sequence object to\nthis. Notice that to set the display_id attribute you just need\ncall the same method, display_id(), with the new value as an argument.\nGetting and setting values with the same method is common in Bioperl.\n\n  $id  = $seqobj->display_id();\n  $id  = \"$id.rev\";\n  $rev->display_id($id);\n\nThe write_seq method on the SeqIO output object, $seqout, writes the\n$rev object to the filestream we built at the top of the script.\nThe filestream knows that it is outputting in fasta format, and\nso it provides fasta output.\n\n  $seqout->write_seq($rev);\n\nThis block of code loops over sequence features in the sequence\nobject, trying to find ones who have been tagged as 'exon'.\nFeatures have start and end attributes and can be outputted\nin Genbank Flat File format, GFF, a standarized format for sequence\nfeatures.\n\n  foreach $feat ( $seqobj->get_SeqFeatures() ) {\n      if( $feat->primary_tag eq 'exon' ) {\n          print STDOUT \"Location \",$feat->start,\":\",\n             $feat->end,\" GFF[\",$feat->gff_string,\"]\\n\";\n      }\n  }\n\nThe code above shows how a few Bio::Seq methods suffice to read, parse,\nreformat and analyze sequences from a file. A full list of methods\navailable to Bio::Seq objects is shown below. Bear in mind that some of\nthese methods come from PrimarySeq objects, which are simpler\nthan Seq objects, stripped of features (see L<Bio::PrimarySeq> for\nmore information).\n\n  # these methods return strings, and accept strings in some cases:\n\n  $seqobj->seq();              # string of sequence\n  $seqobj->subseq(5,10);       # part of the sequence as a string\n  $seqobj->accession_number(); # when there, the accession number\n  $seqobj->alphabet();         # one of 'dna','rna',or 'protein'\n  $seqobj->seq_version()       # when there, the version\n  $seqobj->keywords();         # when there, the Keywords line\n  $seqobj->length()            # length\n  $seqobj->desc();             # description\n  $seqobj->primary_id();       # a unique id for this sequence regardless\n                               # of its display_id or accession number\n  $seqobj->display_id();       # the human readable id of the sequence\n\nSome of these values map to fields in common formats. For example, The\ndisplay_id() method returns the LOCUS name of a Genbank entry,\nthe (\\S+) following the E<gt> character in a Fasta file, the ID from\na SwissProt file, and so on. The desc() method will return the DEFINITION\nline of a Genbank file, the description following the display_id in a\nFasta file, and the DE field in a SwissProt file.\n\n  # the following methods return new Seq objects, but\n  # do not transfer features across to the new object:\n\n  $seqobj->trunc(5,10)  # truncation from 5 to 10 as new object\n  $seqobj->revcom       # reverse complements sequence\n  $seqobj->translate    # translation of the sequence\n\n  # if new() can be called this method returns 1, else 0\n\n  $seqobj->can_call_new\n\n  # the following method determines if the given string will be accepted\n  # by the seq() method - if the string is acceptable then validate()\n  # returns 1, or 0 if not\n\n  $seqobj->validate_seq($string)\n\n  # the following method returns or accepts a Species object:\n\n  $seqobj->species();\n\nPlease see L<Bio::Species> for more information on this object.\n\n  # the following method returns or accepts an Annotation object\n  # which in turn allows access to Annotation::Reference\n  # and Annotation::Comment objects:\n\n  $seqobj->annotation();\n\nThese annotations typically refer to entire sequences, unlike\nfeatures.  See L<Bio::AnnotationCollectionI>,\nL<Bio::Annotation::Collection>, L<Bio::Annotation::Reference>, and\nL<Bio::Annotation::Comment> for details.\n\nIt is also important to be able to describe defined portions of a\nsequence. The combination of some description and the corresponding\nsub-sequence is called a feature - an exon and its coordinates within\na gene is an example of a feature, or a domain within a protein.\n\n  # the following methods return an array of SeqFeatureI objects:\n\n  $seqobj->get_SeqFeatures # The 'top level' sequence features\n  $seqobj->get_all_SeqFeatures # All sequence features, including sub-seq\n                               # features, such as features in an exon\n\n  # to find out the number of features use:\n\n  $seqobj->feature_count\n\nHere are just some of the methods available to SeqFeatureI objects:\n\n  # these methods return numbers:\n\n  $feat->start          # start position (1 is the first base)\n  $feat->end            # end position (2 is the second base)\n  $feat->strand         # 1 means forward, -1 reverse, 0 not relevant\n\n  # these methods return or accept strings:\n\n  $feat->primary_tag    # the name of the sequence feature, eg\n                        # 'exon', 'glycoslyation site', 'TM domain'\n  $feat->source_tag     # where the feature comes from, eg, 'EMBL_GenBank',\n                        # or 'BLAST'\n\n  # this method returns the more austere PrimarySeq object, not a\n  # Seq object - the main difference is that PrimarySeq objects do not\n  # themselves contain sequence features\n\n  $feat->seq            # the sequence between start,end on the\n                        # correct strand of the sequence\n\nSee L<Bio::PrimarySeq> for more details on PrimarySeq objects.\n\n  # useful methods for feature comparisons, for start/end points\n\n  $feat->overlaps($other)  # do $feat and $other overlap?\n  $feat->contains($other)  # is $other completely within $feat?\n  $feat->equals($other)    # do $feat and $other completely agree?\n\n  # one can also add features\n\n  $seqobj->add_SeqFeature($feat)     # returns 1 if successful\n  $seqobj->add_SeqFeature(@features) # returns 1 if successful\n\n  # sub features. For complex join() statements, the feature\n  # is one sequence feature with many sub SeqFeatures\n\n  $feat->sub_SeqFeature  # returns array of sub seq features\n\nPlease see L<Bio::SeqFeatureI> and L<Bio::SeqFeature::Generic>,\nfor more information on sequence features.\n\nIt is worth mentioning that one can also retrieve the start and end\npositions of a feature using a Bio::LocationI object:\n\n  $location = $feat->location # $location is a Bio::LocationI object\n  $location->start;           # start position\n  $location->end;             # end position\n\nThis is useful because one needs a Bio::Location::SplitLocationI object\nin order to retrieve the coordinates inside the Genbank or EMBL join()\nstatements (e.g. \"CDS    join(51..142,273..495,1346..1474)\"):\n\n  if ( $feat->location->isa('Bio::Location::SplitLocationI') &&\n\t       $feat->primary_tag eq 'CDS' )  {\n    foreach $loc ( $feat->location->sub_Location ) {\n      print $loc->start . \"..\" . $loc->end . \"\\n\";\n    }\n  }\n\nSee L<Bio::LocationI> and L<Bio::Location::SplitLocationI> for more\ninformation.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqI\n\nNote that this includes implementing Bio::PrimarySeqI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, inspired by Ian Korf objects\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Seq;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root Bio::SeqI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::FeatureHolderI);\n\n=head2 new\n\n Title   : new\n Usage   : $seq = Bio::Seq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                 -id  => 'human_id',\n\t\t\t\t -accession_number => 'AL000012',\n\t\t\t       );\n\n Function: Returns a new Seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number\n Returns : a new Bio::Seq object\n\n\nsub new {\n    my($caller,@args) = @_;\n\n    if( $caller ne 'Bio::Seq') {\n\t$caller = ref($caller) if ref($caller);\n    }\n\n    # we know our inherietance heirarchy\n    my $self = Bio::Root::Root->new(@args);\n    bless $self,$caller;\n\n    # this is way too sneaky probably. We delegate the construction of\n    # the Seq object onto PrimarySeq and then pop primary_seq into\n    # our primary_seq slot\n\n    my $pseq = Bio::PrimarySeq->new(@args);\n\n    # as we have just made this, we know it is ok to set hash directly\n    # rather than going through the method\n\n    $self->{'primary_seq'} = $pseq;\n\n    # setting this array is now delayed until the final\n    # moment, again speed ups for non feature containing things\n    # $self->{'_as_feat'} = [];\n\n\n    my ($ann, $pid,$feat,$species) = &Bio::Root::RootI::_rearrange($self,[qw(ANNOTATION PRIMARY_ID FEATURES SPECIES)], @args);\n\n    # for a number of cases - reading fasta files - these are never set. This\n    # gives a quick optimisation around testing things later on\n\n    if( defined $ann || defined $pid || defined $feat || defined $species ) {\n\t$pid && $self->primary_id($pid);\n\t$species && $self->species($species);\n\t$ann && $self->annotation($ann);\n\t\n\tif( defined $feat ) {\n\t    if( ref($feat) !~ /ARRAY/i ) {\n\t\tif( ref($feat) && $feat->isa('Bio::SeqFeatureI') ) {\n\t\t    $self->add_SeqFeature($feat);\n\t\t} else {\n\t\t    $self->warn(\"Must specify a valid Bio::SeqFeatureI or ArrayRef of Bio::SeqFeatureI's with the -features init parameter for \".ref($self));\n\t\t}\n\t    } else {\n\t\tforeach my $feature ( @$feat ) {\n\t\t    $self->add_SeqFeature($feature);\n\t\t}\t\n\t    }\n\t}\n    }\n\n    return $self;\n}\n\n=head1 PrimarySeq interface\n\n\nThe PrimarySeq interface provides the basic sequence getting\nand setting methods for on all sequences.\n\nThese methods implement the Bio::PrimarySeq interface by delegating\nto the primary_seq inside the object. This means that you\ncan use a Seq object wherever there is a PrimarySeq, and\nof course, you are free to use these functions anyway.\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Get/Set the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n           but implementations are suggested to keep an open mind about\n           case (some users... want mixed case!)\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n    return shift->primary_seq()->seq(@_);\n}\n\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of type \",\n\t\t      ref($seq), \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z), '-','.','*','=', and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    return shift->primary_seq()->validate_seq(@_);\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Example :\n Returns : Integer representing the length of the sequence.\n Args    : None\n\n\nsub length {\n    return shift->primary_seq()->length(@_);\n}\n\n=head1 Methods from the Bio::PrimarySeqI interface\n\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal\n\n Returns : A string\n Args    : 2 integers\n\n\n\nsub subseq {\n    return shift->primary_seq()->subseq(@_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id = $obj->display_id or $obj->display_id($newid);\n Function: Gets or sets the display id, also known as the common name of\n           the Seq object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the LOCUS\n           field of the GenBank/EMBL databanks and the ID field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience issues.\n Returns : A string\n Args    : None or a new id\n\n\n\nsub display_id {\n   return shift->primary_seq->display_id(@_);\n}\n\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n\n           Can also be used to set the accession number.\n Example : $key = $seq->accession_number or $seq->accession_number($key)\n Returns : A string\n Args    : None or an accession number\n\n\n\nsub accession_number {\n   return shift->primary_seq->accession_number(@_);\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $seqobj->desc($string) or $seqobj->desc()\n Function: Sets or gets the description of the sequence\n Example :\n Returns : The description\n Args    : The description or none\n\n\n\nsub desc {\n   return shift->primary_seq->desc(@_);\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage\n           their own object ids in a way the implementation can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural id, this method should return\n           a stringified memory location.\n\n           Can also be used to set the primary_id (or unset to undef).\n\n           [Note this method name is likely to change in 1.3]\n\n Example : $id = $seq->primary_id or $seq->primary_id($id)\n Returns : A string\n Args    : None or an id, or undef to unset the primary id.\n\n\n\nsub primary_id {\n    # Note: this used to not delegate to the primary seq. This is\n    # really bad in very subtle ways. E.g., if you created the object\n    # with a primary id given to the constructor and then later you\n    # change the primary id, if this method wouldn't delegate you'd\n    # have different values for primary id in the PrimarySeq object\n    # compared to this instance. Not good.\n\n    # I can't remember why not delegating was ever deemed\n    # advantageous, but I hereby claim that its problems far outweigh\n    # its advantages, if there are any. Convince me otherwise if you\n    # disagree. HL 2004/08/05\n\n    return shift->primary_seq->primary_id(@_);\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if ( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t   }\n Function: can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t );\n Example :\n Returns : 1 or 0\n Args    : None\n\n\n\nsub can_call_new {\n    return 1;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if ( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no type specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n   my $self = shift;\n   return $self->primary_seq->alphabet(@_) if @_ && defined $_[0];\n   return $self->primary_seq->alphabet();\n}\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular {\n    return shift->primary_seq()->is_circular(@_);\n}\n\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n Returns : A number\n\n\nsub version{\n    return shift->primary_seq->version(@_);\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n\n\nsub authority {\n    return shift->primary_seq()->authority(@_);\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection\n\n Returns : A scalar\n\n\n\nsub namespace{\n    return shift->primary_seq()->namespace(@_);\n}\n\n=head1 Methods for Bio::DescribableI compliance\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking\n           this is a good idea)\n\n           This is aliased to display_id().\n Returns : A scalar\n\n\nsub display_name {\n    return shift->display_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a\n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is aliased to desc().\n Returns : A scalar\n\n\nsub description {\n    return shift->desc(@_);\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $seq->annotation or \n           $seq->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n    if( defined $value ) {\n\t$obj->throw(\"object of class \".ref($value).\" does not implement \".\n\t\t    \"Bio::AnnotationCollectionI. Too bad.\")\n\t    unless $value->isa(\"Bio::AnnotationCollectionI\");\n\t$obj->{'_annotation'} = $value;\n    } elsif( ! defined $obj->{'_annotation'}) {\n\t$obj->{'_annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $obj->{'_annotation'};\n}\n\n=head1 Methods to implement Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing features.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   :\n Function: Get the feature objects held by this feature holder.\n\n           Features which are not top-level are subfeatures of one or\n           more of the returned feature objects, which means that you\n           must traverse the subfeature arrays of each top-level\n           feature object in order to traverse all features associated\n           with this sequence.\n\n           Use get_all_SeqFeatures() if you want the feature tree\n           flattened into one single array.\n\n Example :\n Returns : an array of Bio::SeqFeatureI implementing objects\n Args    : none\n\nAt some day we may want to expand this method to allow for a feature\nfilter to be passed in.\n\n\nsub get_SeqFeatures{\n   my $self = shift;\n\n   if( !defined $self->{'_as_feat'} ) {\n       $self->{'_as_feat'} = [];\n   }\n\n   return @{$self->{'_as_feat'}};\n}\n\n=head2 get_all_SeqFeatures\n\n Title   : get_all_SeqFeatures\n Usage   : @feat_ary = $seq->get_all_SeqFeatures();\n Function: Returns the tree of feature objects attached to this\n           sequence object flattened into one single array. Top-level\n           features will still contain their subfeature-arrays, which\n           means that you will encounter subfeatures twice if you\n           traverse the subfeature tree of the returned objects.\n\n           Use get_SeqFeatures() if you want the array to contain only\n           the top-level features.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : None\n\n\n\n# this implementation is inherited from FeatureHolderI\n\n=head2 feature_count\n\n Title   : feature_count\n Usage   : $seq->feature_count()\n Function: Return the number of SeqFeatures attached to a sequence\n Returns : integer representing the number of SeqFeatures\n Args    : None\n\n\n\nsub feature_count {\n    my ($self) = @_;\n\n    if (defined($self->{'_as_feat'})) {\n\treturn ($#{$self->{'_as_feat'}} + 1);\n    } else {\n\treturn 0;\n    }\n}\n\n=head2 add_SeqFeature\n\n Title   : add_SeqFeature\n Usage   : $seq->add_SeqFeature($feat);\n           $seq->add_SeqFeature(@feat);\n Function: Adds the given feature object (or each of an array of feature\n           objects to the feature array of this\n           sequence. The object passed is required to implement the\n           Bio::SeqFeatureI interface.\n Returns : 1 on success\n Args    : A Bio::SeqFeatureI implementing object, or an array of such objects.\n\n\n\nsub add_SeqFeature {\n   my ($self,@feat) = @_;\n\n   $self->{'_as_feat'} = [] unless $self->{'_as_feat'};\n\n   foreach my $feat ( @feat ) {\n       if( !$feat->isa(\"Bio::SeqFeatureI\") ) {\n\t   $self->throw(\"$feat is not a SeqFeatureI and that's what we expect...\");\n       }\n\n       # make sure we attach ourselves to the feature if the feature wants it\n       my $aseq = $self->primary_seq;\n       $feat->attach_seq($aseq) if $aseq;\n\n       push(@{$self->{'_as_feat'}},$feat);\n   }\n   return 1;\n}\n\n=head2 remove_SeqFeatures\n\n Title   : remove_SeqFeatures\n Usage   : $seq->remove_SeqFeatures();\n Function: Flushes all attached SeqFeatureI objects.\n\n           To remove individual feature objects, delete those from the returned\n           array and re-add the rest.\n Example :\n Returns : The array of Bio::SeqFeatureI objects removed from this seq.\n Args    : None\n\n\n\nsub remove_SeqFeatures {\n    my $self = shift;\n\n    return () unless $self->{'_as_feat'};\n    my @feats = @{$self->{'_as_feat'}};\n    $self->{'_as_feat'} = [];\n    return @feats;\n}\n\n=head1 Methods provided in the Bio::PrimarySeqI interface\n\n\nThese methods are inherited from the PrimarySeq interface\nand work as one expects, building new Bio::Seq objects\nor other information as expected. See L<Bio::PrimarySeq>\nfor more information.\n\nSequence Features are B<not> transfered to the new objects.\nThis is possibly a mistake. Anyone who feels the urge in\ndealing with this is welcome to give it a go.\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::Seq object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a protein.\n           Cannot revcom\"\n\n           The id is the same id as the original sequence, and the\n           accession number is also identical. If someone wants to track\n           that this sequence has be reversed, it needs to define its own\n           extensions\n\n           To do an in-place edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage collection of\n           the old object, but it is roughly speaking as efficient as an\n           in-place edit.\n\n Returns : A new (fresh) Bio::Seq object\n Args    : None\n\n\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence\n\n Example :\n Returns : A fresh Seq object\n Args    : A Seq object\n\n\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Returns : value of display_id()\n Args    : [optional] value to update display_id\n\n\n\nsub  id {\n    return shift->display_id(@_);\n}\n\n\n=head1 Seq only methods\n\n\nThese methods are specific to the Bio::Seq object, and not\nfound on the Bio::PrimarySeq object\n\n=head2 primary_seq\n\n Title   : primary_seq\n Usage   : $seq->primary_seq or $seq->primary_seq($newval)\n Function: Get or set a PrimarySeq object\n Example :\n Returns : PrimarySeq object\n Args    : None or PrimarySeq object\n\n\n\nsub primary_seq {\n   my ($obj,$value) = @_;\n\n   if( defined $value) {\n       if( ! ref $value || ! $value->isa('Bio::PrimarySeqI') ) {\n\t   $obj->throw(\"$value is not a Bio::PrimarySeq compliant object\");\n       }\n\n       $obj->{'primary_seq'} = $value;\n       # descend down over all seqfeature objects, seeing whether they\n       # want an attached seq.\n\n       foreach my $sf ( $obj->get_SeqFeatures() ) {\n\t   $sf->attach_seq($value);\n       }\n\n   }\n   return $obj->{'primary_seq'};\n\n}\n\n=head2 species\n\n Title   : species\n Usage   : $species = $seq->species() or $seq->species($species)\n Function: Gets or sets the species\n Returns : L<Bio::Species> object\n Args    : None or L<Bio::Species> object\n\nSee L<Bio::Species> for more information","parameters":[{"label":"$self"},{"label":"$species"}],"label":"species($self,$species)"},"name":"species","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"species","line":1225},{"line":1225,"containerName":"species","kind":13,"name":"$species"},{"line":1226,"name":"$species","containerName":"species","kind":13},{"containerName":"species","kind":13,"name":"$self","line":1227},{"containerName":"species","kind":13,"name":"$species","line":1227},{"line":1229,"containerName":"species","kind":13,"name":"$self"}],"detail":"($self,$species)","definition":"sub"},{"kind":12,"range":{"end":{"line":1238,"character":9999},"start":{"character":0,"line":1238}},"line":1238,"name":"DESTROY","containerName":"main::","children":[],"definition":"sub"},{"definition":"sub","containerName":"main::","name":"all_SeqFeatures","children":[{"line":1254,"kind":12,"containerName":"all_SeqFeatures","name":"get_all_SeqFeatures"}],"kind":12,"range":{"end":{"character":9999,"line":1255},"start":{"line":1253,"character":0}},"line":1253},{"kind":12,"range":{"start":{"character":0,"line":1257},"end":{"character":9999,"line":1262}},"line":1257,"definition":"sub","containerName":"main::","name":"accession","children":[{"localvar":"my","kind":13,"containerName":"accession","name":"$self","line":1258,"definition":"my"},{"name":"$self","containerName":"accession","kind":13,"line":1259},{"line":1259,"name":"warn","kind":12,"containerName":"accession"},{"line":1259,"name":"$self","kind":13,"containerName":"accession"},{"line":1261,"name":"$self","kind":13,"containerName":"accession"},{"line":1261,"name":"accession_number","kind":12,"containerName":"accession"}]}]}