{"vars":[{"line":80,"name":"vars","containerName":"","kind":2},{"kind":13,"containerName":null,"name":"$DefaultProgramName","line":87},{"line":87,"name":"ResultFactory","kind":2,"containerName":"strict::Bio::Search::HSP::HSPFactory::Bio::Search::Hit::HitFactory::Bio::Search::Result"},{"line":88,"kind":13,"containerName":null,"name":"$DEFAULT_WRITER_CLASS"},{"line":91,"name":"%MODEMAP","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%MAPPING","line":98},{"name":"base","containerName":"","kind":2,"line":137},{"containerName":"main::","name":"_initialize","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_initialize","line":151},{"containerName":"_initialize","kind":13,"name":"@args","line":151},{"containerName":"_initialize","kind":13,"name":"$self","line":152},{"line":152,"name":"@args","kind":13,"containerName":"_initialize"},{"definition":"my","name":"$pname","localvar":"my","kind":13,"containerName":"_initialize","line":153},{"containerName":"_initialize","kind":13,"name":"$self","line":153},{"name":"_rearrange","kind":12,"containerName":"_initialize","line":153},{"name":"@args","containerName":"_initialize","kind":13,"line":153},{"kind":13,"containerName":"_initialize","name":"$self","line":154},{"line":154,"kind":12,"containerName":"_initialize","name":"program_name"},{"line":154,"name":"$pname","kind":13,"containerName":"_initialize"},{"line":154,"name":"$DefaultProgramName","containerName":"_initialize","kind":13},{"line":155,"containerName":"_initialize","kind":13,"name":"$self"},{"line":155,"kind":12,"containerName":"_initialize","name":"_eventHandler"},{"containerName":"_initialize","kind":12,"name":"register_factory","line":155},{"kind":12,"containerName":"_initialize","name":"new","line":157},{"line":162,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"_eventHandler","kind":12,"containerName":"_initialize","line":162},{"line":162,"containerName":"_initialize","kind":12,"name":"register_factory"},{"kind":12,"containerName":"_initialize","name":"new","line":164},{"line":168,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"_eventHandler","containerName":"_initialize","kind":12,"line":168},{"line":168,"kind":12,"containerName":"_initialize","name":"register_factory"},{"kind":12,"containerName":"_initialize","name":"new","line":170}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":174},"start":{"character":0,"line":150}},"line":150,"signature":{"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"}},{"containerName":"_initialize","kind":12,"name":"SUPER","line":152},{"kind":12,"containerName":"Search::Result::ResultFactory","name":"Bio","line":157},{"name":"Bio","containerName":"Search::Hit::HitFactory","kind":12,"line":164},{"line":170,"containerName":"Search::HSP::HSPFactory","kind":12,"name":"Bio"},{"line":186,"range":{"start":{"line":186,"character":0},"end":{"line":428,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none","label":"next_result($self)"},"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"next_result","line":187},{"line":188,"name":"$lastquery","kind":13,"localvar":"my","containerName":"next_result","definition":"my"},{"line":188,"containerName":"next_result","kind":13,"name":"$lasthit"},{"name":"$self","containerName":"next_result","kind":13,"line":193},{"line":193,"kind":12,"containerName":"next_result","name":"_readline"},{"kind":13,"containerName":"next_result","name":"$self","line":194},{"name":"_pushback","kind":12,"containerName":"next_result","line":194},{"line":197,"containerName":"next_result","kind":13,"name":"$self"},{"line":197,"name":"_readline","kind":12,"containerName":"next_result"},{"definition":"my","line":198,"name":"$matches","localvar":"my","containerName":"next_result","kind":13},{"line":199,"name":"$mismatches","kind":13,"containerName":"next_result"},{"line":199,"containerName":"next_result","kind":13,"name":"$rep_matches"},{"containerName":"next_result","kind":13,"name":"$n_count","line":199},{"line":200,"name":"$q_num_insert","kind":13,"containerName":"next_result"},{"line":200,"kind":13,"containerName":"next_result","name":"$q_base_insert"},{"line":200,"containerName":"next_result","kind":13,"name":"$t_num_insert"},{"line":200,"containerName":"next_result","kind":13,"name":"$t_base_insert"},{"line":201,"kind":13,"containerName":"next_result","name":"$strand"},{"line":201,"containerName":"next_result","kind":13,"name":"$q_name"},{"line":201,"kind":13,"containerName":"next_result","name":"$q_length"},{"containerName":"next_result","kind":13,"name":"$q_start","line":201},{"line":202,"name":"$q_end","kind":13,"containerName":"next_result"},{"name":"$t_name","kind":13,"containerName":"next_result","line":202},{"line":202,"name":"$t_length","kind":13,"containerName":"next_result"},{"line":202,"kind":13,"containerName":"next_result","name":"$t_start"},{"name":"$t_end","containerName":"next_result","kind":13,"line":203},{"line":203,"kind":13,"containerName":"next_result","name":"$block_count"},{"containerName":"next_result","kind":13,"name":"$block_sizes","line":203},{"name":"$q_starts","containerName":"next_result","kind":13,"line":203},{"name":"$t_starts","containerName":"next_result","kind":13,"line":205},{"kind":13,"containerName":"next_result","name":"$q_length","line":207},{"name":"$self","kind":13,"containerName":"next_result","line":207},{"line":207,"name":"throw","containerName":"next_result","kind":12},{"line":208,"kind":13,"localvar":"my","containerName":"next_result","name":"$score","definition":"my"},{"line":208,"name":"$matches","kind":13,"containerName":"next_result"},{"line":208,"name":"$mismatches","kind":13,"containerName":"next_result"},{"line":208,"kind":13,"containerName":"next_result","name":"$rep_matches"},{"line":208,"name":"$q_length","containerName":"next_result","kind":13},{"line":211,"name":"$match_total","localvar":"my","kind":13,"containerName":"next_result","definition":"my"},{"name":"$matches","containerName":"next_result","kind":13,"line":211},{"kind":13,"containerName":"next_result","name":"$mismatches","line":211},{"line":211,"name":"$rep_matches","kind":13,"containerName":"next_result"},{"line":212,"kind":13,"containerName":"next_result","name":"$match_total"},{"line":213,"name":"$self","kind":13,"containerName":"next_result"},{"line":213,"kind":12,"containerName":"next_result","name":"throw"},{"definition":"my","line":214,"name":"$percent_id","containerName":"next_result","localvar":"my","kind":13},{"containerName":"next_result","kind":13,"name":"$matches","line":214},{"name":"$rep_matches","containerName":"next_result","kind":13,"line":214},{"line":214,"kind":13,"containerName":"next_result","name":"$match_total"},{"name":"$lastquery","kind":13,"containerName":"next_result","line":218},{"kind":13,"containerName":"next_result","name":"$lastquery","line":218},{"containerName":"next_result","kind":13,"name":"$q_name","line":218},{"name":"$self","kind":13,"containerName":"next_result","line":220},{"kind":12,"containerName":"next_result","name":"end_element","line":220},{"containerName":"next_result","kind":13,"name":"$self","line":221},{"line":221,"containerName":"next_result","kind":12,"name":"end_element"},{"name":"$self","containerName":"next_result","kind":13,"line":222},{"line":222,"containerName":"next_result","kind":12,"name":"_pushback"},{"name":"$self","kind":13,"containerName":"next_result","line":223},{"name":"end_document","containerName":"next_result","kind":12,"line":223},{"line":225,"name":"$lastquery","kind":13,"containerName":"next_result"},{"line":226,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":13,"name":"$self","line":227},{"line":227,"name":"start_element","containerName":"next_result","kind":12},{"line":228,"name":"$self","kind":13,"containerName":"next_result"},{"line":228,"name":"element","kind":12,"containerName":"next_result"},{"line":231,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":12,"name":"program_name","line":232},{"name":"$self","kind":13,"containerName":"next_result","line":234},{"line":234,"name":"element","containerName":"next_result","kind":12},{"line":238,"containerName":"next_result","kind":13,"name":"$q_name"},{"name":"$self","kind":13,"containerName":"next_result","line":240},{"name":"element","containerName":"next_result","kind":12,"line":240},{"name":"$q_length","containerName":"next_result","kind":13,"line":244},{"name":"$self","kind":13,"containerName":"next_result","line":246},{"line":246,"kind":12,"containerName":"next_result","name":"start_element"},{"containerName":"next_result","kind":13,"name":"$self","line":247},{"containerName":"next_result","kind":12,"name":"element","line":247},{"name":"$t_name","kind":13,"containerName":"next_result","line":251},{"containerName":"next_result","kind":13,"name":"$self","line":253},{"name":"element","kind":12,"containerName":"next_result","line":253},{"line":257,"containerName":"next_result","kind":13,"name":"$t_length"},{"line":259,"kind":13,"containerName":"next_result","name":"$self"},{"line":259,"name":"element","kind":12,"containerName":"next_result"},{"line":263,"kind":13,"containerName":"next_result","name":"$score"},{"name":"$lasthit","kind":13,"containerName":"next_result","line":266},{"name":"$t_name","containerName":"next_result","kind":13,"line":266},{"kind":13,"containerName":"next_result","name":"$self","line":267},{"containerName":"next_result","kind":12,"name":"end_element","line":267},{"name":"$self","containerName":"next_result","kind":13,"line":268},{"containerName":"next_result","kind":12,"name":"start_element","line":268},{"line":269,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":269},{"line":273,"containerName":"next_result","kind":13,"name":"$t_name"},{"line":275,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"element","line":275},{"name":"$t_length","kind":13,"containerName":"next_result","line":279},{"line":281,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"element","line":281},{"line":285,"containerName":"next_result","kind":13,"name":"$score"},{"line":289,"name":"$identical","localvar":"my","kind":13,"containerName":"next_result","definition":"my"},{"line":289,"containerName":"next_result","kind":13,"name":"$matches"},{"line":289,"kind":13,"containerName":"next_result","name":"$rep_matches"},{"kind":13,"containerName":"next_result","name":"$self","line":290},{"line":290,"name":"start_element","kind":12,"containerName":"next_result"},{"line":291,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":291},{"line":295,"name":"$score","containerName":"next_result","kind":13},{"name":"$self","kind":13,"containerName":"next_result","line":297},{"line":297,"containerName":"next_result","kind":12,"name":"element"},{"containerName":"next_result","kind":13,"name":"$identical","line":301},{"kind":13,"containerName":"next_result","name":"$self","line":303},{"kind":12,"containerName":"next_result","name":"element","line":303},{"name":"$identical","kind":13,"containerName":"next_result","line":307},{"line":309,"name":"$self","containerName":"next_result","kind":13},{"line":309,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"containerName":"next_result","name":"$mismatches","line":313},{"line":315,"name":"$self","containerName":"next_result","kind":13},{"line":315,"containerName":"next_result","kind":12,"name":"element"},{"line":318,"containerName":"next_result","kind":13,"name":"$q_base_insert"},{"containerName":"next_result","kind":13,"name":"$t_base_insert","line":319},{"name":"$self","kind":13,"containerName":"next_result","line":323},{"line":323,"name":"element","containerName":"next_result","kind":12},{"line":327,"name":"$t_base_insert","kind":13,"containerName":"next_result"},{"name":"$self","kind":13,"containerName":"next_result","line":329},{"containerName":"next_result","kind":12,"name":"element","line":329},{"containerName":"next_result","kind":13,"name":"$q_base_insert","line":333},{"line":335,"kind":13,"containerName":"next_result","name":"$strand"},{"kind":13,"containerName":"next_result","name":"$self","line":336},{"line":336,"name":"element","kind":12,"containerName":"next_result"},{"line":339,"containerName":"next_result","kind":13,"name":"$q_start"},{"kind":13,"containerName":"next_result","name":"$self","line":342},{"name":"element","containerName":"next_result","kind":12,"line":342},{"line":346,"containerName":"next_result","kind":13,"name":"$q_end"},{"kind":13,"containerName":"next_result","name":"$self","line":350},{"containerName":"next_result","kind":12,"name":"element","line":350},{"name":"$q_start","containerName":"next_result","kind":13,"line":353},{"name":"$self","kind":13,"containerName":"next_result","line":356},{"name":"element","kind":12,"containerName":"next_result","line":356},{"line":360,"containerName":"next_result","kind":13,"name":"$q_end"},{"definition":"my","name":"$hsplen","containerName":"next_result","localvar":"my","kind":13,"line":363},{"line":364,"name":"$q_base_insert","containerName":"next_result","kind":13},{"name":"$t_base_insert","kind":13,"containerName":"next_result","line":365},{"line":366,"containerName":"next_result","kind":13,"name":"$t_end"},{"name":"$t_start","kind":13,"containerName":"next_result","line":366},{"line":367,"name":"$q_end","kind":13,"containerName":"next_result"},{"line":367,"name":"$q_start","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$self","line":368},{"line":368,"name":"element","containerName":"next_result","kind":12},{"name":"$t_start","kind":13,"containerName":"next_result","line":371},{"name":"$self","containerName":"next_result","kind":13,"line":374},{"line":374,"containerName":"next_result","kind":12,"name":"element"},{"containerName":"next_result","kind":13,"name":"$t_end","line":378},{"kind":13,"containerName":"next_result","name":"$self","line":380},{"line":380,"name":"element","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$hsplen","line":384},{"line":388,"kind":13,"containerName":"next_result","name":"$block_sizes"},{"name":"$q_starts","kind":13,"containerName":"next_result","line":389},{"line":390,"name":"$t_starts","kind":13,"containerName":"next_result"},{"definition":"my","line":391,"name":"@blocksizes","kind":13,"localvar":"my","containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$block_sizes","line":391},{"definition":"my","line":392,"name":"@qstarts","localvar":"my","kind":13,"containerName":"next_result"},{"line":392,"containerName":"next_result","kind":13,"name":"$q_starts"},{"definition":"my","name":"@tstarts","kind":13,"localvar":"my","containerName":"next_result","line":394},{"line":394,"kind":13,"containerName":"next_result","name":"$t_starts"},{"kind":13,"localvar":"my","containerName":"next_result","name":"@qgapblocks","line":396,"definition":"my"},{"name":"@hgapblocks","containerName":"next_result","kind":13,"line":396},{"line":398,"name":"$i","localvar":"my","kind":13,"containerName":"next_result","definition":"my"},{"line":398,"name":"$i","containerName":"next_result","kind":13},{"line":398,"name":"$block_count","kind":13,"containerName":"next_result"},{"line":398,"name":"$i","kind":13,"containerName":"next_result"},{"line":399,"kind":13,"containerName":"next_result","name":"$strand"},{"line":400,"name":"@qgapblocks","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$qstarts","line":400},{"kind":13,"containerName":"next_result","name":"$i","line":400},{"line":400,"containerName":"next_result","kind":13,"name":"$blocksizes"},{"name":"$i","containerName":"next_result","kind":13,"line":400},{"containerName":"next_result","kind":13,"name":"@qgapblocks","line":403},{"line":403,"name":"$q_length","containerName":"next_result","kind":13},{"line":403,"kind":13,"containerName":"next_result","name":"$qstarts"},{"line":403,"containerName":"next_result","kind":13,"name":"$i"},{"line":403,"kind":13,"containerName":"next_result","name":"$blocksizes"},{"line":403,"name":"$i","kind":13,"containerName":"next_result"},{"name":"@hgapblocks","containerName":"next_result","kind":13,"line":405},{"name":"$tstarts","containerName":"next_result","kind":13,"line":405},{"kind":13,"containerName":"next_result","name":"$i","line":405},{"name":"$blocksizes","kind":13,"containerName":"next_result","line":405},{"name":"$i","kind":13,"containerName":"next_result","line":405},{"name":"$self","containerName":"next_result","kind":13,"line":407},{"kind":12,"containerName":"next_result","name":"element","line":407},{"line":411,"containerName":"next_result","kind":13,"name":"@qgapblocks"},{"containerName":"next_result","kind":13,"name":"$self","line":413},{"line":413,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","kind":13,"name":"@hgapblocks","line":417},{"containerName":"next_result","kind":13,"name":"$self","line":419},{"line":419,"name":"end_element","kind":12,"containerName":"next_result"},{"name":"$lastquery","kind":13,"containerName":"next_result","line":420},{"containerName":"next_result","kind":13,"name":"$q_name","line":420},{"line":421,"name":"$lasthit","containerName":"next_result","kind":13},{"name":"$t_name","kind":13,"containerName":"next_result","line":421},{"line":423,"name":"$lasthit","containerName":"next_result","kind":13},{"line":423,"name":"$lastquery","kind":13,"containerName":"next_result"},{"line":424,"name":"$self","containerName":"next_result","kind":13},{"line":424,"kind":12,"containerName":"next_result","name":"end_element"},{"line":425,"kind":13,"containerName":"next_result","name":"$self"},{"name":"end_element","kind":12,"containerName":"next_result","line":425},{"line":426,"kind":13,"containerName":"next_result","name":"$self"},{"line":426,"name":"end_document","containerName":"next_result","kind":12}],"containerName":"main::","name":"next_result","definition":"sub","detail":"($self)"},{"detail":"($self,$data)","definition":"sub","containerName":"main::","name":"start_element","children":[{"definition":"my","line":442,"localvar":"my","containerName":"start_element","kind":13,"name":"$self"},{"name":"$data","kind":13,"containerName":"start_element","line":442},{"kind":13,"localvar":"my","containerName":"start_element","name":"$nm","line":445,"definition":"my"},{"name":"$data","kind":13,"containerName":"start_element","line":445},{"line":446,"name":"$type","containerName":"start_element","localvar":"my","kind":13,"definition":"my"},{"name":"$MODEMAP","containerName":"start_element","kind":13,"line":446},{"containerName":"start_element","kind":13,"name":"$nm","line":446},{"line":447,"kind":13,"containerName":"start_element","name":"$self"},{"kind":12,"containerName":"start_element","name":"_mode","line":447},{"name":"$type","kind":13,"containerName":"start_element","line":447},{"name":"$self","kind":13,"containerName":"start_element","line":448},{"name":"_eventHandler","kind":12,"containerName":"start_element","line":448},{"line":448,"containerName":"start_element","kind":12,"name":"will_handle"},{"line":448,"kind":13,"containerName":"start_element","name":"$type"},{"definition":"my","line":449,"localvar":"my","containerName":"start_element","kind":13,"name":"$func"},{"name":"$type","kind":13,"containerName":"start_element","line":449},{"line":450,"kind":13,"containerName":"start_element","name":"$self"},{"line":450,"kind":12,"containerName":"start_element","name":"_eventHandler"},{"containerName":"start_element","kind":13,"name":"$func","line":450},{"line":450,"name":"$data","kind":13,"containerName":"start_element"},{"line":452,"name":"$self","kind":13,"containerName":"start_element"},{"line":452,"name":"$type","containerName":"start_element","kind":13}],"signature":{"label":"start_element($self,$data)","documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}]},"kind":12,"range":{"start":{"character":0,"line":441},"end":{"character":9999,"line":453}},"line":441},{"containerName":null,"kind":13,"name":"%nm","line":454},{"line":455,"containerName":null,"kind":13,"name":"%self"},{"line":456,"name":"%self","containerName":null,"kind":13},{"name":"%self","kind":13,"containerName":null,"line":457},{"signature":{"label":"end_element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'"},"line":473,"kind":12,"range":{"end":{"character":9999,"line":489},"start":{"character":0,"line":473}},"definition":"sub","detail":"($self,$data)","children":[{"line":474,"name":"$self","localvar":"my","containerName":"end_element","kind":13,"definition":"my"},{"name":"$data","kind":13,"containerName":"end_element","line":474},{"line":475,"localvar":"my","containerName":"end_element","kind":13,"name":"$nm","definition":"my"},{"name":"$data","kind":13,"containerName":"end_element","line":475},{"definition":"my","line":476,"name":"$rc","localvar":"my","kind":13,"containerName":"end_element"},{"line":481,"name":"$type","containerName":"end_element","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"end_element","name":"$MODEMAP","line":481},{"line":481,"containerName":"end_element","kind":13,"name":"$nm"},{"line":482,"name":"$self","containerName":"end_element","kind":13},{"line":482,"name":"_eventHandler","containerName":"end_element","kind":12},{"containerName":"end_element","kind":12,"name":"will_handle","line":482},{"line":482,"name":"$type","containerName":"end_element","kind":13},{"line":483,"name":"$func","kind":13,"localvar":"my","containerName":"end_element","definition":"my"},{"line":483,"name":"$type","kind":13,"containerName":"end_element"},{"containerName":"end_element","kind":13,"name":"$rc","line":484},{"line":484,"containerName":"end_element","kind":13,"name":"$self"},{"line":484,"kind":12,"containerName":"end_element","name":"_eventHandler"},{"name":"$func","containerName":"end_element","kind":13,"line":484},{"line":484,"name":"$self","kind":13,"containerName":"end_element"},{"kind":13,"containerName":"end_element","name":"$self","line":485},{"line":487,"name":"$self","kind":13,"containerName":"end_element"}],"containerName":"main::","name":"end_element"},{"containerName":null,"kind":13,"name":"%MAPPING","line":490},{"line":490,"containerName":null,"kind":13,"name":"%nm"},{"line":491,"name":"%MAPPING","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%nm","line":491},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$key","line":492},{"line":492,"name":"%MAPPING","containerName":null,"kind":13},{"name":"@nm","containerName":null,"kind":13,"line":492},{"containerName":null,"kind":13,"name":"%self","line":493},{"name":"%key","containerName":null,"kind":13,"line":493},{"containerName":null,"kind":13,"name":"%MAPPING","line":493},{"line":493,"kind":13,"containerName":null,"name":"%nm"},{"containerName":null,"kind":13,"name":"$key","line":493},{"name":"%self","kind":13,"containerName":null,"line":494},{"containerName":null,"kind":13,"name":"%self","line":497},{"name":"%MAPPING","containerName":null,"kind":13,"line":497},{"line":497,"name":"$nm","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":497},{"kind":13,"containerName":null,"name":"$self","line":501},{"line":501,"name":"warn","containerName":"main::","kind":12},{"line":504,"kind":13,"containerName":null,"name":"%self"},{"line":506,"name":"%self","kind":13,"containerName":null},{"line":507,"name":"$rc","containerName":null,"kind":13},{"line":508,"name":"$nm","kind":13,"containerName":null},{"line":508,"name":"%MODEMAP","containerName":null,"kind":13},{"line":508,"containerName":null,"kind":13,"name":"$nm"},{"containerName":null,"kind":13,"name":"%MODEMAP","line":509},{"line":509,"name":"$nm","containerName":null,"kind":13},{"name":"$rc","containerName":null,"kind":13,"line":510},{"children":[{"definition":"my","localvar":"my","containerName":"element","kind":13,"name":"$self","line":526},{"line":526,"containerName":"element","kind":13,"name":"$data"},{"name":"$self","kind":13,"containerName":"element","line":527},{"line":527,"name":"start_element","kind":12,"containerName":"element"},{"containerName":"element","kind":13,"name":"$data","line":527},{"containerName":"element","kind":13,"name":"$self","line":528},{"line":528,"name":"characters","containerName":"element","kind":12},{"kind":13,"containerName":"element","name":"$data","line":528},{"kind":13,"containerName":"element","name":"$self","line":529},{"name":"end_element","containerName":"element","kind":12,"line":529},{"containerName":"element","kind":13,"name":"$data","line":529}],"name":"element","containerName":"main::","definition":"sub","detail":"($self,$data)","line":525,"kind":12,"range":{"end":{"character":9999,"line":530},"start":{"character":0,"line":525}},"signature":{"label":"element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'"}},{"children":[{"line":544,"localvar":"my","containerName":"characters","kind":13,"name":"$self","definition":"my"},{"line":544,"name":"$data","containerName":"characters","kind":13},{"line":546,"name":"$data","kind":13,"containerName":"characters"},{"line":547,"containerName":"characters","kind":13,"name":"$data"},{"line":548,"name":"$data","containerName":"characters","kind":13},{"line":551,"name":"$self","kind":13,"containerName":"characters"},{"name":"in_element","containerName":"characters","kind":12,"line":551},{"name":"$data","kind":13,"containerName":"characters","line":552},{"name":"$self","kind":13,"containerName":"characters","line":555},{"line":555,"name":"$data","kind":13,"containerName":"characters"},{"line":555,"name":"$data","containerName":"characters","kind":13},{"containerName":"characters","kind":13,"name":"$self","line":558},{"containerName":"characters","kind":13,"name":"$data","line":558}],"containerName":"main::","name":"characters","definition":"sub","detail":"($self,$data)","line":543,"range":{"start":{"character":0,"line":543},"end":{"line":559,"character":9999}},"kind":12,"signature":{"label":"characters($self,$data)","documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}]}},{"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_mode","name":"$self","line":574},{"containerName":"_mode","kind":13,"name":"$value","line":574},{"line":575,"name":"$value","containerName":"_mode","kind":13},{"line":576,"name":"$self","containerName":"_mode","kind":13},{"line":576,"name":"$value","kind":13,"containerName":"_mode"},{"containerName":"_mode","kind":13,"name":"$self","line":578}],"name":"_mode","containerName":"main::","definition":"sub","detail":"($self,$value)","line":573,"range":{"end":{"line":579,"character":9999},"start":{"line":573,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)","label":"_mode($self,$value)"}},{"containerName":"main::","name":"within_element","children":[{"definition":"my","line":595,"name":"$self","localvar":"my","kind":13,"containerName":"within_element"},{"name":"$name","containerName":"within_element","kind":13,"line":595},{"kind":13,"containerName":"within_element","name":"$name","line":597},{"line":597,"kind":13,"containerName":"within_element","name":"$self"},{"line":598,"name":"$self","containerName":"within_element","kind":13}],"detail":"($self,$name)","definition":"sub","range":{"start":{"line":594,"character":0},"end":{"line":598,"character":9999}},"kind":12,"line":594,"signature":{"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}],"label":"within_element($self,$name)"}},{"line":599,"name":"%self","kind":13,"containerName":null},{"line":600,"containerName":null,"kind":13,"name":"%name"},{"signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","label":"in_element($self,$name)"},"line":620,"range":{"start":{"line":620,"character":0},"end":{"line":624,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$name)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"in_element","line":621,"definition":"my"},{"name":"$name","kind":13,"containerName":"in_element","line":621},{"line":622,"name":"$self","containerName":"in_element","kind":13},{"name":"$self","kind":13,"containerName":"in_element","line":623},{"line":623,"containerName":"in_element","kind":13,"name":"$name"}],"name":"in_element","containerName":"main::"},{"signature":{"label":"start_document($self)","documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none","parameters":[{"label":"$self"}]},"range":{"end":{"character":9999,"line":644},"start":{"character":0,"line":637}},"kind":12,"line":637,"detail":"($self)","definition":"sub","containerName":"main::","name":"start_document","children":[{"name":"$self","containerName":"start_document","localvar":"my","kind":13,"line":638,"definition":"my"},{"line":639,"containerName":"start_document","kind":13,"name":"$self"},{"line":640,"name":"$self","kind":13,"containerName":"start_document"},{"containerName":"start_document","kind":13,"name":"$self","line":641},{"line":642,"kind":13,"containerName":"start_document","name":"$self"},{"kind":13,"containerName":"start_document","name":"$self","line":643}]},{"line":657,"range":{"end":{"line":660,"character":9999},"start":{"character":0,"line":657}},"kind":12,"signature":{"label":"end_document($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_mode'}     = '';\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none"},"children":[{"kind":13,"localvar":"my","containerName":"end_document","name":"$self","line":658,"definition":"my"},{"kind":13,"containerName":"end_document","name":"@args","line":658},{"line":659,"name":"$self","kind":13,"containerName":"end_document"}],"name":"end_document","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"definition":"sub","children":[{"localvar":"my","kind":13,"containerName":"result_count","name":"$self","line":674,"definition":"my"},{"name":"$self","kind":13,"containerName":"result_count","line":675}],"name":"result_count","containerName":"main::","line":673,"kind":12,"range":{"end":{"character":9999,"line":676},"start":{"line":673,"character":0}}},{"line":678,"kind":12,"range":{"start":{"character":0,"line":678},"end":{"character":9999,"line":678}},"definition":"sub","children":[{"name":"result_count","containerName":"report_count","kind":12,"line":678}],"containerName":"main::","name":"report_count"},{"kind":12,"range":{"start":{"character":0,"line":691},"end":{"character":9999,"line":696}},"line":691,"definition":"sub","containerName":"main::","name":"program_name","children":[{"definition":"my","line":692,"name":"$self","kind":13,"localvar":"my","containerName":"program_name"},{"line":694,"kind":13,"containerName":"program_name","name":"$self"},{"line":695,"kind":13,"containerName":"program_name","name":"$self"},{"containerName":"program_name","kind":13,"name":"$DefaultProgramName","line":695}]}],"version":5}