{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":88},{"containerName":"main::","name":"_initialize","children":[{"definition":"my","name":"$self","containerName":"_initialize","localvar":"my","kind":13,"line":112},{"containerName":"_initialize","kind":13,"name":"@args","line":112},{"line":116,"name":"$writer","localvar":"my","kind":13,"containerName":"_initialize","definition":"my"},{"name":"$file","kind":13,"containerName":"_initialize","line":116},{"line":116,"kind":13,"containerName":"_initialize","name":"$fh"},{"kind":13,"containerName":"_initialize","name":"$piped_behaviour","line":116},{"name":"$evalue","containerName":"_initialize","kind":13,"line":116},{"line":116,"kind":13,"containerName":"_initialize","name":"$score"},{"name":"$hsps","kind":13,"containerName":"_initialize","line":116},{"containerName":"_initialize","kind":13,"name":"$self","line":117},{"line":117,"name":"_rearrange","containerName":"_initialize","kind":12},{"line":122,"name":"@args","kind":13,"containerName":"_initialize"},{"line":123,"name":"$self","containerName":"_initialize","kind":13},{"name":"writer","kind":12,"containerName":"_initialize","line":123},{"name":"$writer","containerName":"_initialize","kind":13,"line":123},{"containerName":"_initialize","kind":13,"name":"$writer","line":123},{"line":125,"containerName":"_initialize","kind":13,"name":"$self"},{"name":"_fields","kind":12,"containerName":"_initialize","line":125},{"line":141,"name":"$self","kind":13,"containerName":"_initialize"},{"kind":12,"containerName":"_initialize","name":"_fields","line":141},{"containerName":"_initialize","kind":13,"name":"$evalue","line":141},{"line":141,"containerName":"_initialize","kind":13,"name":"$evalue"},{"line":142,"name":"$self","containerName":"_initialize","kind":13},{"name":"_fields","containerName":"_initialize","kind":12,"line":142},{"name":"$score","kind":13,"containerName":"_initialize","line":142},{"line":142,"containerName":"_initialize","kind":13,"name":"$score"},{"containerName":"_initialize","kind":13,"name":"$self","line":143},{"kind":12,"containerName":"_initialize","name":"_fields","line":143},{"containerName":"_initialize","kind":13,"name":"$hsps","line":143},{"line":143,"name":"$hsps","containerName":"_initialize","kind":13},{"line":145,"name":"$self","kind":13,"containerName":"_initialize"},{"line":145,"name":"_dependencies","kind":12,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"$self","line":152},{"line":152,"kind":12,"containerName":"_initialize","name":"chunk"},{"name":"$file","containerName":"_initialize","kind":13,"line":152},{"line":152,"kind":13,"containerName":"_initialize","name":"$fh"},{"kind":13,"containerName":"_initialize","name":"$self","line":152},{"containerName":"_initialize","kind":12,"name":"throw","line":152},{"line":153,"containerName":"_initialize","kind":13,"name":"$piped_behaviour"}],"detail":"($self,@args)","definition":"sub","range":{"start":{"character":0,"line":111},"end":{"character":9999,"line":154}},"kind":12,"line":111,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: hmmer_pull.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer_pull\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer_pull - A parser for HMMER output\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                               -file   => 't/data/hmmpfam.bigout');\n    while (my $result = $in->next_result) {\n        # this is a Bio::Search::Result::HmmpfamResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while (my $hit = $result->next_hit) {\n            print $hit->name(), \"\\n\";\n            while (my $hsp = $hit->next_hsp) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a pull-parser for HMMER output. It is fast since it\nonly does work on request (hence 'pull').\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer_pull;\n\nuse strict;\n\n\nuse base qw(Bio::SearchIO Bio::PullParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer_pull->new();\n Function: Builds a new Bio::SearchIO::hmmer_pull object \n Returns : Bio::SearchIO::hmmer_pull\n Args    : -fh/-file => HMMER output filename\n           -format   => 'hmmer_pull'\n           -evalue   => float or scientific notation number to be used\n                        as an evalue cutoff for hits\n           -score    => integer or scientific notation number to be used\n                        as a score value cutoff for hits\n           -hsps     => integer minimum number of hsps (domains) a hit must have\n           -piped_behaviour => 'temp_file'|'memory'|'sequential_read'\n\n           -piped_behaviour defines what the parser should do if the input is\n            an unseekable filehandle (eg. piped input), see\n            Bio::PullParserI::chunk for details. Default is 'sequential_read'.","label":"_initialize($self,@args)"}},{"line":125,"name":"header","kind":12},{"name":"algorithm","kind":12,"line":126},{"line":127,"name":"algorithm_version","kind":12},{"kind":12,"name":"algorithm_reference","line":128},{"line":129,"name":"hmm_file","kind":12},{"kind":12,"name":"hmm_name","line":130},{"kind":12,"name":"sequence_file","line":131},{"kind":12,"name":"sequence_database","line":132},{"name":"database_name","kind":12,"line":133},{"line":134,"kind":12,"name":"database_letters"},{"kind":12,"name":"database_entries","line":135},{"line":136,"name":"next_result","kind":12},{"name":"evalue_cutoff","kind":12,"line":137},{"name":"score_cutoff","kind":12,"line":138},{"kind":12,"name":"hsps_cutoff","line":139},{"name":"evalue_cutoff","kind":12,"line":141},{"line":142,"name":"score_cutoff","kind":12},{"name":"hsps_cutoff","kind":12,"line":143},{"name":"algorithm","kind":12,"line":145},{"line":146,"name":"algorithm_version","kind":12},{"line":147,"name":"hmm_file","kind":12},{"line":148,"name":"hmm_name","kind":12},{"line":149,"name":"sequence_file","kind":12},{"line":150,"name":"sequence_database","kind":12},{"range":{"start":{"line":156,"character":0},"end":{"line":174,"character":9999}},"kind":12,"line":156,"definition":"sub","containerName":"main::","name":"_discover_header","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_discover_header","line":157,"definition":"my"},{"line":158,"name":"$self","kind":13,"containerName":"_discover_header"},{"name":"_chunk_seek","containerName":"_discover_header","kind":12,"line":158},{"definition":"my","localvar":"my","containerName":"_discover_header","kind":13,"name":"$header","line":159},{"name":"$self","kind":13,"containerName":"_discover_header","line":159},{"kind":12,"containerName":"_discover_header","name":"_get_chunk_by_nol","line":159},{"line":160,"containerName":"_discover_header","kind":13,"name":"$self"},{"line":160,"containerName":"_discover_header","kind":13,"name":"$self"},{"name":"_chunk_tell","kind":12,"containerName":"_discover_header","line":160},{"definition":"my","localvar":"my","containerName":"_discover_header","kind":13,"name":"$algo","line":162},{"line":162,"kind":13,"containerName":"_discover_header","name":"$header"},{"name":"$self","containerName":"_discover_header","kind":13,"line":163},{"line":163,"containerName":"_discover_header","kind":12,"name":"_fields"},{"name":"$algo","containerName":"_discover_header","kind":13,"line":163},{"line":165,"containerName":"_discover_header","kind":13,"name":"$self"},{"name":"_fields","kind":12,"containerName":"_discover_header","line":165},{"line":165,"name":"$header","containerName":"_discover_header","kind":13},{"name":"$self","kind":13,"containerName":"_discover_header","line":167},{"kind":12,"containerName":"_discover_header","name":"_fields","line":167},{"containerName":"_discover_header","kind":13,"name":"$header","line":167},{"line":168,"name":"$self","containerName":"_discover_header","kind":13},{"line":168,"name":"_fields","kind":12,"containerName":"_discover_header"},{"containerName":"_discover_header","kind":13,"name":"$self","line":168},{"kind":12,"containerName":"_discover_header","name":"_fields","line":168},{"line":170,"name":"$self","kind":13,"containerName":"_discover_header"},{"name":"_fields","kind":12,"containerName":"_discover_header","line":170},{"line":170,"containerName":"_discover_header","kind":13,"name":"$header"},{"kind":13,"containerName":"_discover_header","name":"$self","line":171},{"name":"_fields","kind":12,"containerName":"_discover_header","line":171},{"containerName":"_discover_header","kind":13,"name":"$self","line":171},{"name":"_fields","containerName":"_discover_header","kind":12,"line":171},{"line":173,"kind":13,"containerName":"_discover_header","name":"$self"},{"name":"_fields","containerName":"_discover_header","kind":12,"line":173}]},{"line":160,"kind":12,"name":"_after_header"},{"kind":12,"name":"algorithm","line":163},{"line":165,"kind":12,"name":"algorithm_version"},{"kind":12,"name":"hmm_file","line":167},{"kind":12,"name":"hmm_name","line":168},{"name":"hmm_file","kind":12,"line":168},{"name":"sequence_file","kind":12,"line":170},{"line":171,"name":"sequence_database","kind":12},{"name":"sequence_file","kind":12,"line":171},{"line":173,"kind":12,"name":"header"},{"range":{"end":{"character":9999,"line":186},"start":{"line":176,"character":0}},"kind":12,"line":176,"name":"_discover_database_name","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_discover_database_name","line":177,"definition":"my"},{"line":178,"name":"$type","localvar":"my","containerName":"_discover_database_name","kind":13,"definition":"my"},{"containerName":"_discover_database_name","kind":13,"name":"$self","line":178},{"line":178,"containerName":"_discover_database_name","kind":12,"name":"get_field"},{"kind":13,"containerName":"_discover_database_name","name":"$type","line":180},{"name":"$self","containerName":"_discover_database_name","kind":13,"line":181},{"name":"_fields","containerName":"_discover_database_name","kind":12,"line":181},{"kind":13,"containerName":"_discover_database_name","name":"$self","line":181},{"line":181,"name":"get_field","containerName":"_discover_database_name","kind":12},{"containerName":"_discover_database_name","kind":13,"name":"$type","line":183},{"line":184,"kind":13,"containerName":"_discover_database_name","name":"$self"},{"line":184,"name":"_fields","kind":12,"containerName":"_discover_database_name"},{"line":184,"name":"$self","containerName":"_discover_database_name","kind":13},{"line":184,"kind":12,"containerName":"_discover_database_name","name":"get_field"}],"definition":"sub"},{"name":"database_name","kind":12,"line":181},{"line":184,"kind":12,"name":"database_name"},{"range":{"start":{"line":188,"character":0},"end":{"line":221,"character":9999}},"kind":12,"line":188,"definition":"sub","name":"_discover_next_result","containerName":"main::","children":[{"definition":"my","line":189,"localvar":"my","kind":13,"containerName":"_discover_next_result","name":"$self"},{"line":190,"name":"$type","kind":13,"localvar":"my","containerName":"_discover_next_result","definition":"my"},{"line":190,"kind":13,"containerName":"_discover_next_result","name":"$self"},{"containerName":"_discover_next_result","kind":12,"name":"get_field","line":190},{"line":192,"name":"$type","kind":13,"containerName":"_discover_next_result"},{"kind":13,"containerName":"_discover_next_result","name":"$self","line":195},{"line":195,"containerName":"_discover_next_result","kind":12,"name":"_sequential"},{"line":196,"name":"$self","kind":13,"containerName":"_discover_next_result"},{"line":196,"name":"_chunk_seek","kind":12,"containerName":"_discover_next_result"},{"name":"$self","containerName":"_discover_next_result","kind":13,"line":196},{"name":"$self","containerName":"_discover_next_result","kind":13,"line":196},{"kind":13,"localvar":"my","containerName":"_discover_next_result","name":"$start","line":198,"definition":"my"},{"containerName":"_discover_next_result","kind":13,"name":"$end","line":198},{"kind":13,"containerName":"_discover_next_result","name":"$self","line":198},{"line":198,"name":"_find_chunk_by_end","kind":12,"containerName":"_discover_next_result"},{"name":"$start","kind":13,"containerName":"_discover_next_result","line":199},{"containerName":"_discover_next_result","kind":13,"name":"$end","line":199},{"line":200,"name":"$self","kind":13,"containerName":"_discover_next_result"},{"line":200,"name":"_fields","kind":12,"containerName":"_discover_next_result"},{"line":200,"name":"new","kind":12,"containerName":"_discover_next_result"},{"kind":13,"containerName":"_discover_next_result","name":"$self","line":200},{"line":200,"name":"chunk","containerName":"_discover_next_result","kind":12},{"containerName":"_discover_next_result","kind":13,"name":"$start","line":200},{"name":"$end","kind":13,"containerName":"_discover_next_result","line":200},{"line":201,"containerName":"_discover_next_result","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"_discover_next_result","line":203},{"line":203,"name":"$end","containerName":"_discover_next_result","kind":13},{"definition":"my","name":"$chunk","localvar":"my","kind":13,"containerName":"_discover_next_result","line":209},{"name":"$self","containerName":"_discover_next_result","kind":13,"line":209},{"containerName":"_discover_next_result","kind":12,"name":"_get_chunk_by_end","line":209},{"line":210,"name":"$chunk","containerName":"_discover_next_result","kind":13},{"containerName":"_discover_next_result","kind":13,"name":"$self","line":211},{"line":211,"kind":12,"containerName":"_discover_next_result","name":"_fields"},{"line":211,"containerName":"_discover_next_result","kind":12,"name":"new"},{"line":211,"kind":13,"containerName":"_discover_next_result","name":"$chunk"},{"name":"$self","kind":13,"containerName":"_discover_next_result","line":212},{"name":"$type","containerName":"_discover_next_result","kind":13,"line":215},{"name":"$self","kind":13,"containerName":"_discover_next_result","line":216},{"line":216,"name":"throw","containerName":"_discover_next_result","kind":12},{"line":219,"name":"$self","containerName":"_discover_next_result","kind":13},{"name":"throw","kind":12,"containerName":"_discover_next_result","line":219}]},{"line":195,"containerName":"Bio::Search::Result","kind":2,"name":"HmmpfamResult"},{"name":"_end_of_previous_result","kind":12,"line":196},{"line":196,"name":"_after_header","kind":12},{"line":200,"kind":12,"name":"next_result"},{"containerName":"Search::Result::HmmpfamResult","kind":12,"name":"Bio","line":200},{"line":203,"name":"_end_of_previous_result","kind":12},{"line":211,"kind":12,"name":"next_result"},{"kind":12,"containerName":"Search::Result::HmmpfamResult","name":"Bio","line":211},{"kind":12,"range":{"start":{"character":0,"line":233},"end":{"line":241,"character":9999}},"line":233,"definition":"sub","containerName":"main::","name":"next_result","children":[{"definition":"my","line":234,"localvar":"my","containerName":"next_result","kind":13,"name":"$self"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_result","name":"$result","line":235},{"line":235,"kind":13,"containerName":"next_result","name":"$self"},{"line":235,"kind":12,"containerName":"next_result","name":"get_field"},{"line":237,"kind":13,"containerName":"next_result","name":"$self"},{"line":237,"containerName":"next_result","kind":12,"name":"_fields"},{"line":239,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":13,"name":"$result","line":240}]},{"line":237,"name":"next_result","kind":12},{"line":253,"kind":12,"range":{"start":{"line":253,"character":0},"end":{"character":9999,"line":256}},"children":[{"line":254,"name":"$self","localvar":"my","kind":13,"containerName":"result_count","definition":"my"},{"name":"$self","kind":13,"containerName":"result_count","line":255}],"containerName":"main::","name":"result_count","definition":"sub"},{"line":275,"kind":12,"range":{"end":{"character":9999,"line":281},"start":{"character":0,"line":275}},"definition":"sub","children":[{"line":276,"localvar":"my","containerName":"rewind","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"rewind","name":"$self","line":277},{"line":277,"kind":12,"containerName":"rewind","name":"_sequential"},{"kind":13,"containerName":"rewind","name":"$self","line":278},{"name":"warn","kind":12,"containerName":"rewind","line":278},{"line":280,"name":"$self","containerName":"rewind","kind":13}],"containerName":"main::","name":"rewind"},{"line":280,"name":"_end_of_previous_result","kind":12}]}