{"vars":[{"containerName":"","kind":2,"name":"vars","line":88},{"line":91,"containerName":"","kind":2,"name":"base"},{"line":96,"containerName":null,"kind":13,"name":"%MODEMAP"},{"line":102,"kind":13,"containerName":null,"name":"%MAPPING"},{"definition":"sub","detail":"($self,@args)","children":[{"name":"$self","localvar":"my","containerName":"_initialize","kind":13,"line":153,"definition":"my"},{"line":153,"containerName":"_initialize","kind":13,"name":"@args"},{"line":154,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","kind":13,"name":"@args","line":154},{"name":"$handler","localvar":"my","kind":13,"containerName":"_initialize","line":155,"definition":"my"},{"name":"$self","containerName":"_initialize","kind":13,"line":155},{"name":"_eventHandler","kind":12,"containerName":"_initialize","line":155},{"kind":13,"containerName":"_initialize","name":"$handler","line":156},{"line":156,"kind":12,"containerName":"_initialize","name":"register_factory"},{"name":"new","containerName":"_initialize","kind":12,"line":158},{"line":164,"name":"$handler","containerName":"_initialize","kind":13},{"line":164,"kind":12,"containerName":"_initialize","name":"register_factory"},{"name":"new","kind":12,"containerName":"_initialize","line":166},{"line":172,"containerName":"_initialize","kind":13,"name":"$handler"},{"name":"register_factory","containerName":"_initialize","kind":12,"line":172},{"line":174,"kind":12,"containerName":"_initialize","name":"new"},{"kind":13,"containerName":"_initialize","name":"$self","line":179}],"containerName":"main::","name":"_initialize","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'"},"line":152,"kind":12,"range":{"end":{"line":180,"character":9999},"start":{"character":0,"line":152}}},{"line":154,"kind":12,"containerName":"_initialize","name":"SUPER"},{"kind":12,"containerName":"Factory::ObjectFactory","name":"Bio","line":158},{"line":166,"kind":12,"containerName":"Factory::ObjectFactory","name":"Bio"},{"line":174,"name":"Bio","kind":12,"containerName":"Factory::ObjectFactory"},{"containerName":"main::","name":"next_result","children":[{"line":193,"containerName":"next_result","localvar":"my","kind":13,"name":"$self","definition":"my"},{"definition":"my","line":194,"name":"$seentop","localvar":"my","containerName":"next_result","kind":13},{"definition":"my","line":195,"localvar":"my","kind":13,"containerName":"next_result","name":"$reporttype"},{"definition":"my","line":196,"containerName":"next_result","localvar":"my","kind":13,"name":"$last"},{"line":196,"name":"@hitinfo","containerName":"next_result","kind":13},{"line":196,"name":"@hspinfo","kind":13,"containerName":"next_result"},{"line":196,"name":"%hspinfo","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"%hitinfo","line":196},{"name":"$verbose","kind":13,"localvar":"my","containerName":"next_result","line":200,"definition":"my"},{"kind":13,"containerName":"next_result","name":"$self","line":200},{"kind":12,"containerName":"next_result","name":"verbose","line":200},{"line":201,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"start_document","line":201},{"containerName":"next_result","kind":13,"name":"$self","line":203},{"kind":12,"containerName":"next_result","name":"_readline","line":203},{"line":204,"name":"$lineorig","kind":13,"localvar":"my","containerName":"next_result","definition":"my"},{"name":"$prog","localvar":"my","kind":13,"containerName":"next_result","line":207,"definition":"my"},{"name":"$version","containerName":"next_result","kind":13,"line":207},{"name":"$seentop","kind":13,"containerName":"next_result","line":208},{"line":209,"containerName":"next_result","kind":13,"name":"$self"},{"name":"_pushback","containerName":"next_result","kind":12,"line":209},{"line":210,"name":"$self","containerName":"next_result","kind":13},{"name":"end_element","containerName":"next_result","kind":12,"line":210},{"kind":13,"containerName":"next_result","name":"$self","line":211},{"containerName":"next_result","kind":12,"name":"end_document","line":211},{"containerName":"next_result","kind":13,"name":"$self","line":213},{"name":"$self","containerName":"next_result","kind":13,"line":214},{"line":214,"name":"start_element","kind":12,"containerName":"next_result"},{"line":215,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$seentop","line":216},{"kind":13,"containerName":"next_result","name":"$last","line":217},{"name":"$reporttype","containerName":"next_result","kind":13,"line":218},{"line":218,"name":"$last","containerName":"next_result","kind":13},{"line":219,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"element","line":219},{"name":"$reporttype","containerName":"next_result","kind":13,"line":222},{"line":226,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"element","line":226},{"line":230,"name":"$version","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$self","line":234},{"name":"$lineorig","kind":13,"containerName":"next_result","line":234},{"name":"$self","kind":13,"containerName":"next_result","line":235},{"name":"element","kind":12,"containerName":"next_result","line":235},{"line":243,"name":"$self","kind":13,"containerName":"next_result"},{"name":"$lineorig","containerName":"next_result","kind":13,"line":243},{"name":"$self","containerName":"next_result","kind":13,"line":245},{"containerName":"next_result","kind":12,"name":"element","line":245},{"name":"$self","kind":13,"containerName":"next_result","line":252},{"kind":12,"containerName":"next_result","name":"element","line":252},{"name":"$seentop","kind":13,"containerName":"next_result","line":260},{"kind":13,"containerName":"next_result","name":"$self","line":263},{"kind":12,"containerName":"next_result","name":"_pushback","line":263},{"line":263,"name":"$self","kind":13,"containerName":"next_result"},{"line":264,"kind":13,"containerName":"next_result","name":"$self"},{"line":264,"name":"_pushback","kind":12,"containerName":"next_result"},{"line":264,"containerName":"next_result","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"next_result","line":265},{"containerName":"next_result","kind":12,"name":"_pushback","line":265},{"name":"$self","kind":13,"containerName":"next_result","line":265},{"containerName":"next_result","kind":13,"name":"$self","line":266},{"line":266,"name":"_pushback","containerName":"next_result","kind":12},{"line":266,"name":"$lineorig","kind":13,"containerName":"next_result"},{"line":270,"name":"$self","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"element","line":270},{"kind":13,"containerName":"next_result","name":"$self","line":279},{"containerName":"next_result","kind":12,"name":"element","line":279},{"line":288,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":288},{"line":295,"name":"$self","containerName":"next_result","kind":13},{"line":296,"name":"$self","kind":13,"containerName":"next_result"},{"line":301,"kind":13,"containerName":"next_result","name":"$self"},{"name":"_readline","kind":12,"containerName":"next_result","line":301},{"definition":"my","line":304,"kind":13,"localvar":"my","containerName":"next_result","name":"@line"},{"line":305,"name":"$name","localvar":"my","containerName":"next_result","kind":13,"definition":"my"},{"name":"$n","kind":13,"containerName":"next_result","line":305},{"name":"$evalue","kind":13,"containerName":"next_result","line":305},{"line":305,"name":"$score","kind":13,"containerName":"next_result"},{"name":"@line","kind":13,"containerName":"next_result","line":306},{"line":306,"name":"@line","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"@line","line":306},{"kind":13,"containerName":"next_result","name":"@line","line":306},{"definition":"my","localvar":"my","containerName":"next_result","kind":13,"name":"$desc","line":307},{"line":307,"name":"@line","containerName":"next_result","kind":13},{"line":308,"name":"@hitinfo","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$name","line":308},{"line":308,"name":"$desc","containerName":"next_result","kind":13},{"line":308,"containerName":"next_result","kind":13,"name":"$evalue"},{"line":308,"name":"$score","containerName":"next_result","kind":13},{"line":309,"kind":13,"containerName":"next_result","name":"$hitinfo"},{"line":309,"kind":13,"containerName":"next_result","name":"$name"},{"name":"@hspinfo","containerName":"next_result","kind":13,"line":313},{"line":315,"name":"$self","kind":13,"containerName":"next_result"},{"line":315,"name":"_readline","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":318},{"line":318,"name":"_pushback","containerName":"next_result","kind":12},{"definition":"my","line":325,"localvar":"my","containerName":"next_result","kind":13,"name":"$n"},{"name":"$domainnum","kind":13,"containerName":"next_result","line":325},{"kind":13,"containerName":"next_result","name":"$domainct","line":325},{"name":"@vals","containerName":"next_result","kind":13,"line":325},{"definition":"my","line":340,"name":"$info","containerName":"next_result","localvar":"my","kind":13},{"name":"$hitinfo","kind":13,"containerName":"next_result","line":340},{"line":340,"name":"$hitinfo","kind":13,"containerName":"next_result"},{"name":"$n","kind":13,"containerName":"next_result","line":340},{"line":341,"name":"$info","containerName":"next_result","kind":13},{"line":342,"containerName":"next_result","kind":13,"name":"$self"},{"line":342,"name":"warn","containerName":"next_result","kind":12},{"line":347,"name":"@hspinfo","kind":13,"containerName":"next_result"},{"name":"$n","kind":13,"containerName":"next_result","line":347},{"line":347,"kind":13,"containerName":"next_result","name":"@vals"},{"line":352,"name":"$prelength","kind":13,"localvar":"my","containerName":"next_result","definition":"my"},{"line":352,"name":"$lastdomain","kind":13,"containerName":"next_result"},{"line":352,"name":"$count","kind":13,"containerName":"next_result"},{"line":352,"name":"$width","kind":13,"containerName":"next_result"},{"line":353,"containerName":"next_result","kind":13,"name":"$count"},{"definition":"my","line":354,"localvar":"my","kind":13,"containerName":"next_result","name":"%domaincounter"},{"line":355,"name":"$second_tier","localvar":"my","kind":13,"containerName":"next_result","definition":"my"},{"line":356,"name":"$self","containerName":"next_result","kind":13},{"name":"_readline","kind":12,"containerName":"next_result","line":356},{"containerName":"next_result","kind":13,"name":"$self","line":360},{"line":360,"name":"in_element","containerName":"next_result","kind":12},{"line":361,"kind":13,"containerName":"next_result","name":"$self"},{"line":361,"containerName":"next_result","kind":12,"name":"end_element"},{"kind":13,"containerName":"next_result","name":"$self","line":363},{"line":363,"name":"within_element","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$self","line":364},{"line":364,"name":"end_element","kind":12,"containerName":"next_result"},{"line":375,"name":"$name","kind":13,"localvar":"my","containerName":"next_result","definition":"my"},{"line":375,"kind":13,"containerName":"next_result","name":"$domainct"},{"kind":13,"containerName":"next_result","name":"$domaintotal","line":375},{"containerName":"next_result","kind":13,"name":"$from","line":375},{"name":"$to","containerName":"next_result","kind":13,"line":375},{"line":377,"kind":13,"containerName":"next_result","name":"$domaincounter"},{"line":377,"name":"$name","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$self","line":378},{"line":378,"kind":12,"containerName":"next_result","name":"within_element"},{"line":379,"name":"$self","containerName":"next_result","kind":13},{"line":379,"name":"within_element","containerName":"next_result","kind":12},{"line":380,"name":"$self","kind":13,"containerName":"next_result"},{"line":380,"containerName":"next_result","kind":12,"name":"end_element"},{"name":"$self","containerName":"next_result","kind":13,"line":382},{"name":"end_element","containerName":"next_result","kind":12,"line":382},{"line":385,"containerName":"next_result","kind":13,"name":"$self"},{"line":385,"kind":12,"containerName":"next_result","name":"start_element"},{"line":386,"name":"$info","localvar":"my","containerName":"next_result","kind":13,"definition":"my"},{"line":388,"containerName":"next_result","kind":13,"name":"$hitinfo"},{"line":388,"kind":13,"containerName":"next_result","name":"$hitinfo"},{"line":388,"kind":13,"containerName":"next_result","name":"$name"},{"line":388,"containerName":"next_result","kind":13,"name":"$self"},{"kind":12,"containerName":"next_result","name":"throw","line":388},{"containerName":"next_result","kind":13,"name":"$info","line":393},{"name":"$name","containerName":"next_result","kind":13,"line":393},{"line":394,"containerName":"next_result","kind":13,"name":"$self"},{"line":394,"containerName":"next_result","kind":12,"name":"throw"},{"containerName":"next_result","kind":13,"name":"$info","line":396},{"name":"$self","kind":13,"containerName":"next_result","line":399},{"line":399,"kind":12,"containerName":"next_result","name":"element"},{"name":"$info","containerName":"next_result","kind":13,"line":402},{"line":405,"containerName":"next_result","kind":13,"name":"$self"},{"line":405,"kind":12,"containerName":"next_result","name":"element"},{"line":408,"name":"$info","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$self","line":411},{"line":411,"name":"element","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$info","line":414},{"containerName":"next_result","kind":13,"name":"$self","line":417},{"line":417,"name":"element","containerName":"next_result","kind":12},{"line":420,"kind":13,"containerName":"next_result","name":"$info"},{"line":424,"kind":13,"containerName":"next_result","name":"$self"},{"name":"start_element","kind":12,"containerName":"next_result","line":424},{"kind":13,"containerName":"next_result","name":"$self","line":425},{"line":425,"name":"element","kind":12,"containerName":"next_result"},{"line":431,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"element","line":431},{"definition":"my","line":437,"name":"$HSPinfo","localvar":"my","kind":13,"containerName":"next_result"},{"line":437,"kind":13,"containerName":"next_result","name":"@hspinfo"},{"line":438,"containerName":"next_result","localvar":"my","kind":13,"name":"$id","definition":"my"},{"name":"$HSPinfo","containerName":"next_result","kind":13,"line":438},{"name":"$id","containerName":"next_result","kind":13,"line":440},{"line":440,"name":"$name","kind":13,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":441},{"line":441,"containerName":"next_result","kind":12,"name":"throw"},{"name":"$domaincounter","kind":13,"containerName":"next_result","line":445},{"name":"$name","containerName":"next_result","kind":13,"line":445},{"kind":13,"containerName":"next_result","name":"$domaintotal","line":445},{"containerName":"next_result","kind":13,"name":"$hitinfo","line":446},{"name":"$hitinfo","containerName":"next_result","kind":13,"line":446},{"name":"$name","kind":13,"containerName":"next_result","line":446},{"name":"$self","kind":13,"containerName":"next_result","line":448},{"line":448,"name":"element","kind":12,"containerName":"next_result"},{"line":452,"name":"$HSPinfo","kind":13,"containerName":"next_result"},{"name":"$self","kind":13,"containerName":"next_result","line":454},{"name":"element","containerName":"next_result","kind":12,"line":454},{"line":458,"containerName":"next_result","kind":13,"name":"$HSPinfo"},{"name":"$self","kind":13,"containerName":"next_result","line":460},{"line":460,"name":"element","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$HSPinfo","line":464},{"kind":13,"containerName":"next_result","name":"$self","line":466},{"containerName":"next_result","kind":12,"name":"element","line":466},{"line":470,"name":"$HSPinfo","containerName":"next_result","kind":13},{"line":472,"name":"$self","kind":13,"containerName":"next_result"},{"name":"element","containerName":"next_result","kind":12,"line":472},{"line":476,"name":"$HSPinfo","containerName":"next_result","kind":13},{"line":478,"name":"$self","containerName":"next_result","kind":13},{"name":"element","containerName":"next_result","kind":12,"line":478},{"line":482,"kind":13,"containerName":"next_result","name":"$HSPinfo"},{"line":484,"containerName":"next_result","kind":13,"name":"$lastdomain"},{"line":484,"containerName":"next_result","kind":13,"name":"$name"}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":192},"end":{"line":485,"character":9999}},"line":192,"signature":{"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}],"label":"next_result($self)"}},{"line":309,"name":"hitinfo","kind":12},{"containerName":null,"kind":13,"name":"$prelength","line":493},{"name":"CORE","kind":12,"containerName":"length","line":493},{"line":494,"name":"$width","kind":13,"containerName":null},{"definition":"my","name":"$data","containerName":null,"localvar":"my","kind":13,"line":497},{"line":498,"name":"%data","containerName":null,"kind":13},{"line":500,"containerName":null,"kind":13,"name":"$width"},{"name":"CORE","containerName":"length","kind":12,"line":500},{"containerName":null,"kind":13,"name":"$data","line":500},{"name":"$self","containerName":null,"kind":13,"line":503},{"kind":12,"containerName":"main::","name":"element","line":503},{"kind":13,"containerName":null,"name":"$data","line":507},{"line":509,"name":"$count","containerName":null,"kind":13},{"name":"%second_tier","containerName":null,"kind":13,"line":510},{"name":"$self","kind":13,"containerName":null,"line":513},{"line":513,"name":"element","kind":12,"containerName":"main::"},{"name":"$width","kind":13,"containerName":null,"line":519},{"line":519,"name":"CORE","kind":12,"containerName":"length"},{"line":520,"name":"$count","containerName":null,"kind":13},{"line":522,"containerName":null,"kind":13,"name":"$count"},{"line":523,"name":"CORE","containerName":"length","kind":12},{"line":528,"name":"%count","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$prelength","line":529},{"line":529,"kind":13,"containerName":null,"name":"$second_tier"},{"name":"%prelength","kind":13,"containerName":null,"line":530},{"kind":13,"containerName":null,"name":"$self","line":535},{"name":"element","kind":12,"containerName":"main::","line":535},{"name":"$prelength","kind":13,"containerName":null,"line":538},{"line":542,"kind":13,"containerName":null,"name":"%count"},{"name":"%prelength","containerName":null,"kind":13,"line":543},{"kind":13,"containerName":null,"name":"$self","line":544},{"containerName":"main::","kind":12,"name":"warn","line":544},{"name":"%width","kind":13,"containerName":null,"line":546},{"line":547,"containerName":null,"kind":13,"name":"$self"},{"line":547,"containerName":"main::","kind":12,"name":"element"},{"kind":13,"containerName":null,"name":"$prelength","line":551},{"name":"%width","containerName":null,"kind":13,"line":551},{"line":556,"name":"$self","containerName":null,"kind":13},{"line":556,"name":"element","kind":12,"containerName":"main::"},{"line":559,"containerName":null,"kind":13,"name":"$prelength"},{"line":564,"name":"%count","kind":13,"containerName":null},{"name":"$self","containerName":null,"kind":13,"line":566},{"line":566,"name":"element","containerName":"main::","kind":12},{"name":"$self","kind":13,"containerName":null,"line":574},{"kind":12,"containerName":"main::","name":"warn","line":574},{"name":"$count","kind":13,"containerName":null,"line":577},{"line":577,"kind":13,"containerName":null,"name":"%count"},{"localvar":"my","kind":13,"containerName":null,"name":"$HSPinfo","line":582,"definition":"my"},{"line":582,"name":"@hspinfo","containerName":null,"kind":13},{"name":"$id","kind":13,"localvar":"my","containerName":null,"line":583,"definition":"my"},{"line":583,"kind":13,"containerName":null,"name":"$HSPinfo"},{"name":"@info","localvar":"my","kind":13,"containerName":null,"line":584,"definition":"my"},{"name":"@hitinfo","containerName":null,"kind":13,"line":584},{"kind":13,"containerName":null,"name":"%hitinfo","line":584},{"name":"$id","containerName":null,"kind":13,"line":584},{"containerName":null,"kind":13,"name":"$info","line":585},{"containerName":null,"kind":13,"name":"$self","line":586},{"name":"start_element","containerName":"main::","kind":12,"line":586},{"line":587,"name":"$self","kind":13,"containerName":null},{"line":587,"containerName":"main::","kind":12,"name":"element"},{"line":590,"containerName":null,"kind":13,"name":"$info"},{"containerName":null,"kind":13,"name":"$self","line":593},{"kind":12,"containerName":"main::","name":"element","line":593},{"name":"$info","kind":13,"containerName":null,"line":596},{"name":"$self","containerName":null,"kind":13,"line":599},{"line":599,"kind":12,"containerName":"main::","name":"element"},{"line":602,"name":"$info","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":605},{"containerName":"main::","kind":12,"name":"element","line":605},{"line":608,"containerName":null,"kind":13,"name":"$info"},{"name":"$self","containerName":null,"kind":13,"line":611},{"name":"start_element","kind":12,"containerName":"main::","line":611},{"kind":13,"containerName":null,"name":"$self","line":612},{"line":612,"containerName":"main::","kind":12,"name":"element"},{"containerName":null,"kind":13,"name":"$HSPinfo","line":616},{"name":"$self","kind":13,"containerName":null,"line":618},{"line":618,"kind":12,"containerName":"main::","name":"element"},{"line":622,"name":"$HSPinfo","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$self","line":624},{"containerName":"main::","kind":12,"name":"element","line":624},{"containerName":null,"kind":13,"name":"$HSPinfo","line":628},{"containerName":null,"kind":13,"name":"$self","line":630},{"line":630,"kind":12,"containerName":"main::","name":"element"},{"line":634,"name":"$HSPinfo","kind":13,"containerName":null},{"line":636,"kind":13,"containerName":null,"name":"$self"},{"name":"element","kind":12,"containerName":"main::","line":636},{"line":640,"name":"$HSPinfo","kind":13,"containerName":null},{"line":642,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"element","line":642},{"line":646,"kind":13,"containerName":null,"name":"$HSPinfo"},{"line":648,"containerName":null,"kind":13,"name":"$self"},{"line":648,"kind":12,"containerName":"main::","name":"element"},{"containerName":null,"kind":13,"name":"$self","line":654},{"kind":12,"containerName":"main::","name":"element","line":654},{"line":660,"containerName":null,"kind":13,"name":"$self"},{"containerName":"main::","kind":12,"name":"element","line":660},{"kind":13,"containerName":null,"name":"$self","line":666},{"containerName":"main::","kind":12,"name":"end_element","line":666},{"line":667,"name":"$self","containerName":null,"kind":13},{"name":"end_element","kind":12,"containerName":"main::","line":667},{"line":669,"containerName":null,"kind":13,"name":"@hitinfo"},{"kind":13,"containerName":null,"name":"%hitinfo","line":670},{"containerName":null,"kind":13,"name":"%self","line":674},{"containerName":null,"kind":13,"name":"%self","line":675},{"line":679,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"_readline","line":679},{"line":683,"name":"@line","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":684,"name":"$model","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":684,"containerName":null,"kind":13,"name":"$n"},{"name":"$evalue","kind":13,"containerName":null,"line":684},{"kind":13,"containerName":null,"name":"$score","line":684},{"kind":13,"containerName":null,"name":"@line","line":685},{"line":685,"name":"@line","kind":13,"containerName":null},{"name":"@line","containerName":null,"kind":13,"line":685},{"line":685,"containerName":null,"kind":13,"name":"@line"},{"definition":"my","line":686,"localvar":"my","kind":13,"containerName":null,"name":"$desc"},{"line":686,"name":"@line","containerName":null,"kind":13},{"line":687,"containerName":null,"kind":13,"name":"@hitinfo"},{"containerName":null,"kind":13,"name":"$model","line":687},{"line":687,"name":"$desc","kind":13,"containerName":null},{"name":"$score","containerName":null,"kind":13,"line":687},{"name":"$evalue","containerName":null,"kind":13,"line":687},{"containerName":null,"kind":13,"name":"$n","line":687},{"line":688,"name":"%hitinfo","kind":13,"containerName":null},{"line":688,"name":"$model","kind":13,"containerName":null},{"kind":12,"name":"hitinfo","line":688},{"line":692,"containerName":null,"kind":13,"name":"@hspinfo"},{"line":693,"kind":13,"containerName":null,"name":"$self"},{"line":693,"name":"_readline","containerName":"main::","kind":12},{"name":"$self","containerName":null,"kind":13,"line":696},{"line":696,"name":"_pushback","containerName":"main::","kind":12},{"localvar":"my","containerName":null,"kind":13,"name":"$n","line":702,"definition":"my"},{"kind":13,"containerName":null,"name":"$domainnum","line":702},{"line":702,"name":"$domainct","kind":13,"containerName":null},{"name":"@vals","containerName":null,"kind":13,"line":702},{"definition":"my","line":714,"name":"$hindex","containerName":null,"localvar":"my","kind":13},{"line":714,"kind":13,"containerName":null,"name":"%hitinfo"},{"line":714,"kind":13,"containerName":null,"name":"$n"},{"line":715,"kind":13,"containerName":null,"name":"%hindex"},{"line":716,"name":"@hitinfo","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$n","line":717},{"containerName":null,"kind":13,"name":"@vals","line":717},{"line":717,"name":"@vals","kind":13,"containerName":null},{"line":717,"kind":13,"containerName":null,"name":"$domainct"},{"name":"%hitinfo","kind":13,"containerName":null,"line":718},{"kind":13,"containerName":null,"name":"$n","line":718},{"kind":12,"name":"hitinfo","line":718},{"line":719,"kind":13,"containerName":null,"name":"$hindex"},{"line":719,"name":"hitinfo","kind":12},{"definition":"my","line":721,"name":"$info","kind":13,"localvar":"my","containerName":null},{"line":721,"name":"@hitinfo","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$hindex","line":721},{"line":722,"kind":13,"containerName":null,"name":"%info"},{"line":723,"containerName":null,"kind":13,"name":"$self"},{"line":723,"name":"warn","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"@hspinfo","line":728},{"containerName":null,"kind":13,"name":"$n","line":728},{"name":"@vals","kind":13,"containerName":null,"line":728},{"name":"$prelength","localvar":"my","containerName":null,"kind":13,"line":733,"definition":"my"},{"line":733,"name":"$lastdomain","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$count","line":733},{"kind":13,"containerName":null,"name":"$width","line":733},{"containerName":null,"kind":13,"name":"$count","line":734},{"definition":"my","line":735,"containerName":null,"localvar":"my","kind":13,"name":"$second_tier"},{"line":736,"kind":13,"containerName":null,"name":"$self"},{"name":"_readline","kind":12,"containerName":"main::","line":736},{"line":740,"kind":13,"containerName":null,"name":"$count"},{"name":"%count","kind":13,"containerName":null,"line":744},{"line":746,"containerName":null,"kind":13,"name":"$self"},{"containerName":"main::","kind":12,"name":"in_element","line":746},{"kind":13,"containerName":null,"name":"$self","line":747},{"name":"end_element","kind":12,"containerName":"main::","line":747},{"line":749,"kind":13,"containerName":null,"name":"$self"},{"line":749,"name":"in_element","kind":12,"containerName":"main::"},{"name":"$self","containerName":null,"kind":13,"line":750},{"line":750,"containerName":"main::","kind":12,"name":"end_element"},{"line":752,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"_pushback","line":752},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$name","line":757},{"containerName":null,"kind":13,"name":"$from","line":757},{"line":757,"kind":13,"containerName":null,"name":"$to"},{"line":759,"containerName":null,"kind":13,"name":"$self"},{"line":759,"containerName":"main::","kind":12,"name":"within_element"},{"name":"$self","containerName":null,"kind":13,"line":760},{"kind":12,"containerName":"main::","name":"in_element","line":760},{"line":761,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"end_element","line":761},{"line":763,"name":"$self","kind":13,"containerName":null},{"line":763,"containerName":"main::","kind":12,"name":"end_element"},{"localvar":"my","containerName":null,"kind":13,"name":"@info","line":765,"definition":"my"},{"containerName":null,"kind":13,"name":"@hitinfo","line":765},{"containerName":null,"kind":13,"name":"%hitinfo","line":765},{"line":765,"name":"$name","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$info","line":767},{"line":767,"name":"@info","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%name","line":767},{"line":769,"name":"$self","kind":13,"containerName":null},{"name":"warn","kind":12,"containerName":"main::","line":769},{"name":"@info","kind":13,"containerName":null,"line":771},{"line":774,"name":"@info","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$name","line":775},{"name":"@hitinfo","containerName":null,"kind":13,"line":778},{"name":"$info","containerName":null,"kind":13,"line":778},{"kind":13,"containerName":null,"name":"%hitinfo","line":779},{"kind":13,"containerName":null,"name":"$name","line":779},{"name":"hitinfo","kind":12,"line":779},{"line":781,"kind":13,"containerName":null,"name":"$self"},{"line":781,"name":"start_element","kind":12,"containerName":"main::"},{"line":783,"kind":13,"containerName":null,"name":"$self"},{"name":"element","kind":12,"containerName":"main::","line":783},{"line":786,"kind":13,"containerName":null,"name":"$info"},{"name":"$self","kind":13,"containerName":null,"line":789},{"containerName":"main::","kind":12,"name":"element","line":789},{"kind":13,"containerName":null,"name":"$info","line":792},{"line":795,"name":"$self","containerName":null,"kind":13},{"name":"element","kind":12,"containerName":"main::","line":795},{"containerName":null,"kind":13,"name":"$info","line":798},{"line":801,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"element","line":801},{"containerName":null,"kind":13,"name":"$info","line":804},{"name":"$self","containerName":null,"kind":13,"line":808},{"line":808,"kind":12,"containerName":"main::","name":"start_element"},{"containerName":null,"kind":13,"name":"$self","line":809},{"line":809,"kind":12,"containerName":"main::","name":"element"},{"line":815,"name":"$self","containerName":null,"kind":13},{"name":"element","containerName":"main::","kind":12,"line":815},{"definition":"my","name":"$HSPinfo","kind":13,"localvar":"my","containerName":null,"line":821},{"name":"@hspinfo","kind":13,"containerName":null,"line":821},{"definition":"my","name":"$id","kind":13,"localvar":"my","containerName":null,"line":822},{"line":822,"name":"$HSPinfo","containerName":null,"kind":13},{"line":824,"name":"$id","containerName":null,"kind":13},{"line":824,"name":"%name","kind":13,"containerName":null},{"line":825,"kind":13,"containerName":null,"name":"$self"},{"line":825,"kind":12,"containerName":"main::","name":"throw"},{"name":"$self","kind":13,"containerName":null,"line":829},{"containerName":"main::","kind":12,"name":"element","line":829},{"containerName":null,"kind":13,"name":"$HSPinfo","line":833},{"line":835,"kind":13,"containerName":null,"name":"$self"},{"line":835,"name":"element","containerName":"main::","kind":12},{"name":"$HSPinfo","containerName":null,"kind":13,"line":839},{"line":841,"name":"$self","containerName":null,"kind":13},{"line":841,"name":"element","containerName":"main::","kind":12},{"line":845,"kind":13,"containerName":null,"name":"$HSPinfo"},{"line":847,"name":"$self","containerName":null,"kind":13},{"name":"element","containerName":"main::","kind":12,"line":847},{"line":851,"containerName":null,"kind":13,"name":"$HSPinfo"},{"name":"$self","kind":13,"containerName":null,"line":853},{"name":"element","kind":12,"containerName":"main::","line":853},{"line":857,"name":"$HSPinfo","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$self","line":859},{"name":"element","containerName":"main::","kind":12,"line":859},{"line":863,"containerName":null,"kind":13,"name":"$HSPinfo"},{"name":"$lastdomain","containerName":null,"kind":13,"line":865},{"line":865,"name":"%name","containerName":null,"kind":13},{"line":871,"name":"$prelength","containerName":null,"kind":13},{"name":"CORE","kind":12,"containerName":"length","line":871},{"name":"$width","kind":13,"containerName":null,"line":872},{"definition":"my","name":"$data","localvar":"my","containerName":null,"kind":13,"line":875},{"line":876,"name":"%data","kind":13,"containerName":null},{"name":"$width","kind":13,"containerName":null,"line":878},{"kind":12,"containerName":"length","name":"CORE","line":878},{"line":878,"kind":13,"containerName":null,"name":"$data"},{"name":"$self","containerName":null,"kind":13,"line":881},{"line":881,"containerName":"main::","kind":12,"name":"element"},{"name":"$data","containerName":null,"kind":13,"line":885},{"line":887,"name":"$count","kind":13,"containerName":null},{"line":888,"name":"%second_tier","kind":13,"containerName":null},{"name":"$prelength","kind":13,"containerName":null,"line":894},{"line":894,"kind":13,"containerName":null,"name":"$second_tier"},{"name":"$self","kind":13,"containerName":null,"line":895},{"line":895,"kind":12,"containerName":"main::","name":"element"},{"line":901,"name":"$width","kind":13,"containerName":null},{"kind":12,"containerName":"length","name":"CORE","line":901},{"name":"$count","containerName":null,"kind":13,"line":902},{"name":"CORE","kind":12,"containerName":"length","line":904},{"containerName":null,"kind":13,"name":"%count","line":905},{"name":"%count","kind":13,"containerName":null,"line":910},{"line":911,"name":"$prelength","containerName":null,"kind":13},{"line":911,"name":"$second_tier","containerName":null,"kind":13},{"line":912,"name":"%prelength","kind":13,"containerName":null},{"line":917,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"element","line":917},{"line":920,"name":"$prelength","kind":13,"containerName":null},{"line":924,"containerName":null,"kind":13,"name":"%count"},{"line":925,"kind":13,"containerName":null,"name":"%prelength"},{"line":926,"name":"$self","containerName":null,"kind":13},{"name":"warn","containerName":"main::","kind":12,"line":926},{"kind":13,"containerName":null,"name":"%width","line":928},{"kind":13,"containerName":null,"name":"$self","line":929},{"kind":12,"containerName":"main::","name":"element","line":929},{"line":933,"kind":13,"containerName":null,"name":"$prelength"},{"line":933,"name":"%width","kind":13,"containerName":null},{"name":"$self","containerName":null,"kind":13,"line":938},{"line":938,"name":"element","containerName":"main::","kind":12},{"line":941,"name":"$prelength","kind":13,"containerName":null},{"name":"%count","kind":13,"containerName":null,"line":946},{"line":950,"kind":13,"containerName":null,"name":"$self"},{"line":950,"name":"element","kind":12,"containerName":"main::"},{"name":"$self","containerName":null,"kind":13,"line":958},{"line":958,"containerName":"main::","kind":12,"name":"throw"},{"name":"$count","kind":13,"containerName":null,"line":962},{"line":962,"containerName":null,"kind":13,"name":"%count"},{"localvar":"my","containerName":null,"kind":13,"name":"$HSPinfo","line":968,"definition":"my"},{"name":"@hspinfo","containerName":null,"kind":13,"line":968},{"line":969,"name":"$id","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":969,"containerName":null,"kind":13,"name":"$HSPinfo"},{"definition":"my","name":"@info","containerName":null,"localvar":"my","kind":13,"line":970},{"kind":13,"containerName":null,"name":"@hitinfo","line":970},{"line":970,"name":"%hitinfo","containerName":null,"kind":13},{"line":970,"kind":13,"containerName":null,"name":"$id"},{"line":971,"name":"$info","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$self","line":972},{"containerName":"main::","kind":12,"name":"start_element","line":972},{"line":973,"name":"$self","containerName":null,"kind":13},{"line":973,"name":"element","containerName":"main::","kind":12},{"name":"$info","kind":13,"containerName":null,"line":976},{"line":979,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"element","line":979},{"line":982,"name":"$info","containerName":null,"kind":13},{"name":"$self","kind":13,"containerName":null,"line":985},{"line":985,"name":"element","kind":12,"containerName":"main::"},{"name":"$info","kind":13,"containerName":null,"line":988},{"line":991,"name":"$self","kind":13,"containerName":null},{"name":"element","containerName":"main::","kind":12,"line":991},{"line":994,"containerName":null,"kind":13,"name":"$info"},{"line":997,"name":"$self","containerName":null,"kind":13},{"line":997,"name":"start_element","kind":12,"containerName":"main::"},{"line":998,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"element","line":998},{"kind":13,"containerName":null,"name":"$HSPinfo","line":1002},{"name":"$self","kind":13,"containerName":null,"line":1004},{"line":1004,"kind":12,"containerName":"main::","name":"element"},{"kind":13,"containerName":null,"name":"$HSPinfo","line":1008},{"line":1010,"kind":13,"containerName":null,"name":"$self"},{"line":1010,"name":"element","containerName":"main::","kind":12},{"line":1014,"name":"$HSPinfo","kind":13,"containerName":null},{"line":1016,"name":"$self","containerName":null,"kind":13},{"line":1016,"kind":12,"containerName":"main::","name":"element"},{"line":1020,"name":"$HSPinfo","containerName":null,"kind":13},{"line":1022,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"element","line":1022},{"line":1026,"containerName":null,"kind":13,"name":"$HSPinfo"},{"name":"$self","containerName":null,"kind":13,"line":1028},{"line":1028,"kind":12,"containerName":"main::","name":"element"},{"name":"$HSPinfo","containerName":null,"kind":13,"line":1032},{"name":"$self","kind":13,"containerName":null,"line":1034},{"line":1034,"name":"element","containerName":"main::","kind":12},{"name":"$self","containerName":null,"kind":13,"line":1040},{"line":1040,"name":"element","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$self","line":1046},{"line":1046,"kind":12,"containerName":"main::","name":"element"},{"kind":13,"containerName":null,"name":"$self","line":1052},{"name":"end_element","kind":12,"containerName":"main::","line":1052},{"name":"$self","containerName":null,"kind":13,"line":1053},{"containerName":"main::","kind":12,"name":"end_element","line":1053},{"line":1055,"kind":13,"containerName":null,"name":"@hitinfo"},{"line":1056,"kind":13,"containerName":null,"name":"%hitinfo"},{"line":1064,"name":"$last","kind":13,"containerName":null},{"name":"$self","kind":13,"containerName":null,"line":1066},{"containerName":"main::","kind":12,"name":"end_element","line":1066},{"line":1066,"containerName":null,"kind":13,"name":"$seentop"},{"kind":13,"containerName":null,"name":"$self","line":1067},{"line":1067,"containerName":"main::","kind":12,"name":"end_document"},{"detail":"($self,$data)","definition":"sub","containerName":"main::","name":"start_element","children":[{"line":1082,"name":"$self","containerName":"start_element","localvar":"my","kind":13,"definition":"my"},{"line":1082,"name":"$data","containerName":"start_element","kind":13},{"definition":"my","line":1085,"name":"$nm","containerName":"start_element","localvar":"my","kind":13},{"line":1085,"containerName":"start_element","kind":13,"name":"$data"},{"line":1086,"localvar":"my","containerName":"start_element","kind":13,"name":"$type","definition":"my"},{"line":1086,"containerName":"start_element","kind":13,"name":"$MODEMAP"},{"containerName":"start_element","kind":13,"name":"$nm","line":1086},{"name":"$type","kind":13,"containerName":"start_element","line":1087},{"kind":13,"containerName":"start_element","name":"$self","line":1088},{"containerName":"start_element","kind":12,"name":"_eventHandler","line":1088},{"containerName":"start_element","kind":12,"name":"will_handle","line":1088},{"line":1088,"name":"$type","kind":13,"containerName":"start_element"},{"line":1089,"kind":13,"localvar":"my","containerName":"start_element","name":"$func","definition":"my"},{"line":1089,"name":"$type","kind":13,"containerName":"start_element"},{"line":1090,"name":"$self","containerName":"start_element","kind":13},{"line":1090,"name":"_eventHandler","containerName":"start_element","kind":12},{"containerName":"start_element","kind":13,"name":"$func","line":1090},{"line":1090,"name":"$data","kind":13,"containerName":"start_element"},{"line":1092,"kind":13,"containerName":"start_element","name":"$self"},{"name":"$type","kind":13,"containerName":"start_element","line":1092}],"signature":{"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"start_element($self,$data)"},"range":{"start":{"character":0,"line":1081},"end":{"line":1093,"character":9999}},"kind":12,"line":1081},{"kind":13,"containerName":null,"name":"$type","line":1095},{"line":1095,"name":"%type","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%self","line":1097},{"name":"%self","kind":13,"containerName":null,"line":1098},{"signature":{"label":"end_element($self,$data)","documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}]},"line":1113,"range":{"end":{"line":1150,"character":9999},"start":{"character":0,"line":1113}},"kind":12,"definition":"sub","detail":"($self,$data)","children":[{"line":1114,"name":"$self","localvar":"my","kind":13,"containerName":"end_element","definition":"my"},{"line":1114,"kind":13,"containerName":"end_element","name":"$data"},{"line":1115,"name":"$nm","containerName":"end_element","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"end_element","name":"$data","line":1115},{"definition":"my","line":1116,"name":"$type","containerName":"end_element","localvar":"my","kind":13},{"line":1116,"kind":13,"containerName":"end_element","name":"$MODEMAP"},{"line":1116,"name":"$nm","kind":13,"containerName":"end_element"},{"kind":13,"localvar":"my","containerName":"end_element","name":"$rc","line":1117,"definition":"my"},{"line":1119,"kind":13,"containerName":"end_element","name":"$nm"},{"line":1120,"name":"$self","containerName":"end_element","kind":13},{"name":"$self","kind":13,"containerName":"end_element","line":1121},{"name":"$nm","containerName":"end_element","kind":13,"line":1127},{"definition":"my","name":"$data","containerName":"end_element","localvar":"my","kind":13,"line":1129},{"name":"$self","kind":13,"containerName":"end_element","line":1129},{"line":1130,"containerName":"end_element","kind":13,"name":"$data"},{"name":"$data","kind":13,"containerName":"end_element","line":1132},{"line":1134,"name":"$self","kind":13,"containerName":"end_element"},{"line":1134,"containerName":"end_element","kind":12,"name":"element"},{"line":1138,"name":"$data","kind":13,"containerName":"end_element"},{"kind":13,"containerName":"end_element","name":"$self","line":1141},{"line":1143,"containerName":"end_element","kind":13,"name":"$type"},{"line":1144,"name":"$self","kind":13,"containerName":"end_element"},{"line":1144,"name":"_eventHandler","kind":12,"containerName":"end_element"},{"line":1144,"kind":12,"containerName":"end_element","name":"will_handle"},{"containerName":"end_element","kind":13,"name":"$type","line":1144},{"kind":13,"localvar":"my","containerName":"end_element","name":"$func","line":1145,"definition":"my"},{"line":1145,"kind":13,"containerName":"end_element","name":"$type"},{"line":1146,"name":"$rc","kind":13,"containerName":"end_element"},{"line":1146,"name":"$self","kind":13,"containerName":"end_element"},{"name":"_eventHandler","kind":12,"containerName":"end_element","line":1146},{"name":"$func","containerName":"end_element","kind":13,"line":1146},{"name":"$self","containerName":"end_element","kind":13,"line":1146},{"kind":13,"containerName":"end_element","name":"$self","line":1147},{"name":"$lastelem","containerName":"end_element","localvar":"my","kind":13,"line":1149,"definition":"my"},{"kind":13,"containerName":"end_element","name":"$self","line":1149}],"name":"end_element","containerName":"main::"},{"containerName":null,"kind":13,"name":"%MAPPING","line":1151},{"line":1151,"kind":13,"containerName":null,"name":"%nm"},{"line":1152,"name":"%MAPPING","containerName":null,"kind":13},{"line":1152,"name":"%nm","containerName":null,"kind":13},{"line":1153,"name":"$key","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":1153,"name":"%MAPPING","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@nm","line":1153},{"kind":13,"containerName":null,"name":"%self","line":1154},{"kind":13,"containerName":null,"name":"%key","line":1154},{"line":1154,"containerName":null,"kind":13,"name":"%MAPPING"},{"name":"%nm","kind":13,"containerName":null,"line":1154},{"line":1154,"containerName":null,"kind":13,"name":"$key"},{"line":1155,"name":"%self","containerName":null,"kind":13},{"line":1158,"name":"%self","kind":13,"containerName":null},{"line":1158,"name":"%MAPPING","kind":13,"containerName":null},{"line":1158,"name":"$nm","containerName":null,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":1158},{"name":"$self","containerName":null,"kind":13,"line":1162},{"name":"debug","kind":12,"containerName":"main::","line":1162},{"line":1164,"name":"%self","kind":13,"containerName":null},{"line":1166,"name":"%self","containerName":null,"kind":13},{"name":"$rc","kind":13,"containerName":null,"line":1166},{"containerName":null,"kind":13,"name":"$type","line":1166},{"line":1166,"name":"$type","kind":13,"containerName":null},{"name":"$rc","containerName":null,"kind":13,"line":1167},{"name":"element","containerName":"main::","children":[{"definition":"my","line":1182,"name":"$self","containerName":"element","localvar":"my","kind":13},{"line":1182,"name":"$data","kind":13,"containerName":"element"},{"line":1183,"containerName":"element","kind":13,"name":"$self"},{"line":1183,"name":"start_element","kind":12,"containerName":"element"},{"containerName":"element","kind":13,"name":"$data","line":1183},{"containerName":"element","kind":13,"name":"$self","line":1184},{"name":"characters","kind":12,"containerName":"element","line":1184},{"line":1184,"kind":13,"containerName":"element","name":"$data"},{"line":1185,"name":"$self","containerName":"element","kind":13},{"line":1185,"name":"end_element","kind":12,"containerName":"element"},{"line":1185,"kind":13,"containerName":"element","name":"$data"}],"detail":"($self,$data)","definition":"sub","kind":12,"range":{"end":{"line":1186,"character":9999},"start":{"character":0,"line":1181}},"line":1181,"signature":{"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ( $nm eq 'HMMER_program' ) {\n        if ( $self->{'_last_data'} =~ /(HMM\\S+)/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n    }\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            my $data = $self->{'_last_hspdata'}->{$_};\n            if ($data && $_ eq 'Hsp_hseq') {\n                # replace hmm '.' gap symbol by '-'\n                $data =~ s/\\./-/g;\n            }\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $data\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"element($self,$data)"}},{"line":1199,"kind":12,"range":{"end":{"line":1211,"character":9999},"start":{"character":0,"line":1199}},"signature":{"label":"characters($self,$data)","documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ( $nm eq 'HMMER_program' ) {\n        if ( $self->{'_last_data'} =~ /(HMM\\S+)/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n    }\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            my $data = $self->{'_last_hspdata'}->{$_};\n            if ($data && $_ eq 'Hsp_hseq') {\n                # replace hmm '.' gap symbol by '-'\n                $data =~ s/\\./-/g;\n            }\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $data\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}]},"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"characters","line":1200},{"kind":13,"containerName":"characters","name":"$data","line":1200},{"name":"$self","kind":13,"containerName":"characters","line":1202},{"line":1202,"name":"in_element","kind":12,"containerName":"characters"},{"name":"$data","kind":13,"containerName":"characters","line":1203},{"name":"$data","kind":13,"containerName":"characters","line":1204},{"line":1206,"kind":13,"containerName":"characters","name":"$self"},{"line":1206,"name":"$data","containerName":"characters","kind":13},{"line":1206,"name":"$data","containerName":"characters","kind":13},{"kind":13,"containerName":"characters","name":"$data","line":1208},{"name":"$data","containerName":"characters","kind":13,"line":1208},{"line":1210,"name":"$self","kind":13,"containerName":"characters"},{"line":1210,"kind":13,"containerName":"characters","name":"$data"}],"name":"characters","containerName":"main::","definition":"sub","detail":"($self,$data)"},{"definition":"sub","detail":"($self,$name)","children":[{"line":1227,"localvar":"my","kind":13,"containerName":"within_element","name":"$self","definition":"my"},{"line":1227,"containerName":"within_element","kind":13,"name":"$name"},{"line":1230,"name":"$name","kind":13,"containerName":"within_element"},{"kind":13,"containerName":"within_element","name":"$self","line":1230},{"kind":13,"containerName":"within_element","name":"$self","line":1231}],"name":"within_element","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ( $nm eq 'HMMER_program' ) {\n        if ( $self->{'_last_data'} =~ /(HMM\\S+)/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n    }\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            my $data = $self->{'_last_hspdata'}->{$_};\n            if ($data && $_ eq 'Hsp_hseq') {\n                # replace hmm '.' gap symbol by '-'\n                $data =~ s/\\./-/g;\n            }\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $data\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/o\n        && defined $data->{'Data'} )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","label":"within_element($self,$name)"},"line":1226,"range":{"end":{"character":9999,"line":1231},"start":{"line":1226,"character":0}},"kind":12},{"line":1232,"name":"%self","containerName":null,"kind":13},{"name":"$name","kind":13,"containerName":null,"line":1233},{"signature":{"label":"in_element($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ( $nm eq 'HMMER_program' ) {\n        if ( $self->{'_last_data'} =~ /(HMM\\S+)/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n    }\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            my $data = $self->{'_last_hspdata'}->{$_};\n            if ($data && $_ eq 'Hsp_hseq') {\n                # replace hmm '.' gap symbol by '-'\n                $data =~ s/\\./-/g;\n            }\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $data\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/o\n        && defined $data->{'Data'} )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediete parent.\n Returns : boolean\n Args    : string element name "},"line":1251,"range":{"start":{"character":0,"line":1251},"end":{"character":9999,"line":1255}},"kind":12,"definition":"sub","detail":"($self,$name)","children":[{"line":1252,"name":"$self","localvar":"my","containerName":"in_element","kind":13,"definition":"my"},{"containerName":"in_element","kind":13,"name":"$name","line":1252},{"line":1253,"name":"$self","kind":13,"containerName":"in_element"},{"line":1254,"containerName":"in_element","kind":13,"name":"$self"},{"line":1254,"kind":13,"containerName":"in_element","name":"$name"}],"containerName":"main::","name":"in_element"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ( $nm eq 'HMMER_program' ) {\n        if ( $self->{'_last_data'} =~ /(HMM\\S+)/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n    }\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            my $data = $self->{'_last_hspdata'}->{$_};\n            if ($data && $_ eq 'Hsp_hseq') {\n                # replace hmm '.' gap symbol by '-'\n                $data =~ s/\\./-/g;\n            }\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $data\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/o\n        && defined $data->{'Data'} )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediete parent.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none","label":"start_document($self)"},"line":1268,"range":{"start":{"character":0,"line":1268},"end":{"line":1274,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"start_document","name":"$self","line":1269},{"line":1270,"containerName":"start_document","kind":13,"name":"$self"},{"line":1271,"containerName":"start_document","kind":13,"name":"$self"},{"line":1272,"name":"$self","kind":13,"containerName":"start_document"},{"containerName":"start_document","kind":13,"name":"$self","line":1273}],"name":"start_document","containerName":"main::"},{"name":"end_document","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"end_document","kind":13,"line":1288,"definition":"my"},{"line":1289,"name":"$self","kind":13,"containerName":"end_document"}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":1287},"end":{"character":9999,"line":1290}},"line":1287,"signature":{"documentation":"1;\n# $Id: hmmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer - A parser for HMMER output (hmmpfam, hmmsearch)\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer',\n                               -file   => 't/data/L77119.hmmer');\n    while( my $result = $in->next_result ) {\n        # this is a Bio::Search::Result::HMMERResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while( my $hit = $result->next_hit ) {\n            print $hit->name(), \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for HMMER output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer;\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse vars qw(%MAPPING %MODEMAP\n);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n\n    # mapping of HMMER items to Bioperl hash keys\n    %MODEMAP = (\n        'HMMER_Output' => 'result',\n        'Hit'          => 'hit',\n        'Hsp'          => 'hsp'\n    );\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_desc'      => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        'Hit_score'     => 'HIT-score',\n\n        'HMMER_program'   => 'RESULT-algorithm_name',\n        'HMMER_version'   => 'RESULT-algorithm_version',\n        'HMMER_query-def' => 'RESULT-query_name',\n        'HMMER_query-len' => 'RESULT-query_length',\n        'HMMER_query-acc' => 'RESULT-query_accession',\n        'HMMER_querydesc' => 'RESULT-query_description',\n        'HMMER_hmm'       => 'RESULT-hmm_name',\n        'HMMER_seqfile'   => 'RESULT-sequence_file',\n        'HMMER_db'        => 'RESULT-database_name',\n    );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer->new();\n Function: Builds a new Bio::SearchIO::hmmer object \n Returns : Bio::SearchIO::hmmer\n Args    : -fh/-file => HMMER filename\n           -format   => 'hmmer'\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::HMMERResult',\n            -interface => 'Bio::Search::Result::ResultI'\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::HMMERHit',\n            -interface => 'Bio::Search::Hit::HitI'\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::HMMERHSP',\n            -interface => 'Bio::Search::HSP::HSPI'\n        )\n    );\n    $self->{'_hmmidline'} = 'HMMER 2.2g (August 2001)';\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    my $reporttype;\n    my ( $last, @hitinfo, @hspinfo, %hspinfo, %hitinfo );\n    local $/ = \"\\n\";\n    local $_;\n\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    local ($_);\n    while ( defined( $_ = $self->_readline ) ) {\n        my $lineorig = $_;\n        chomp;\n        if (/^HMMER\\s+(\\S+)\\s+\\((.+)\\)/o) {\n            my ( $prog, $version ) = split;\n            if ($seentop) {\n                $self->_pushback($_);\n                $self->end_element( { 'Name' => 'HMMER_Output' } );\n                return $self->end_document();\n            }\n            $self->{'_hmmidline'} = $_;\n            $self->start_element( { 'Name' => 'HMMER_Output' } );\n            $self->{'_result_count'}++;\n            $seentop = 1;\n            if ( defined $last ) {\n                ($reporttype) = split( /\\s+/, $last );\n                $self->element(\n                    {\n                        'Name' => 'HMMER_program',\n                        'Data' => uc($reporttype)\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_version',\n                    'Data' => $version\n                }\n            );\n        }\n        elsif (s/^HMM file:\\s+//o) {\n            $self->{'_hmmfileline'} = $lineorig;\n            $self->element(\n                {\n                    'Name' => 'HMMER_hmm',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Sequence\\s+(file|database):\\s+//o) {\n            $self->{'_hmmseqline'} = $lineorig;\n            if ( $1 eq 'database' ) {\n                $self->element(\n                    {\n                        'Name' => 'HMMER_db',\n                        'Data' => $_\n                    }\n                );\n            }\n            $self->element(\n                {\n                    'Name' => 'HMMER_seqfile',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Query(\\s+(sequence|HMM))?(?:\\s+\\d+)?:\\s+//o) {\n            if ( !$seentop ) {\n\n                # we're in a multi-query report\n                $self->_pushback( $self->{'_hmmidline'} );\n                $self->_pushback( $self->{'_hmmfileline'} );\n                $self->_pushback( $self->{'_hmmseqline'} );\n                $self->_pushback($lineorig);\n                next;\n            }\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-def',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Accession:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_query-acc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif (s/^Description:\\s+//o) {\n            s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'HMMER_querydesc',\n                    'Data' => $_\n                }\n            );\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMSEARCH' )\n        {\n\n            # PROCESS HMMSEARCH RESULTS HERE\n            if (/^Scores for complete sequences/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Sequence\\s+Description/o || /^\\-\\-\\-/o );\n                    my @line = split;\n                    my ( $name, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $name, $desc, $evalue, $score ];\n                    $hitinfo{$name} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^(Model|Sequence)\\s+Domain/ || /^\\-\\-\\-/ );\n\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+      # host name\n\t\t\t(\\d+)/(\\d+)\\s+   # num/num (ie 1 of 2) \n\t\t\t(\\d+)\\s+(\\d+).+? # sequence start and end\n\t\t\t(\\d+)\\s+(\\d+)\\s+ # hmm start and end\n\t\t\t\\S+\\s+           # []\n\t\t\t(\\S+)\\s+         # score\n\t\t\t(\\S+)            # evalue\n\t\t\t\\s*$!ox\n                        )\n                      )\n                    {\n\n                        # array lookup so that we can get rid of things\n                        # when they've been processed\n                        my $info = $hitinfo[ $hitinfo{$n} ];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"Incomplete Sequence information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my %domaincounter;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next if ( /^Align/o\n                        || /^\\s+RF\\s+[x\\s]+$/o );\n                    if ( /^Histogram/o || m!^//!o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->within_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        last;\n                    }\n                    chomp;\n\n                    if (\n                        m/^\\s*(.+):\\s+domain\\s+(\\d+)\\s+of\\s+(\\d+)\\,\\s+\n                        from\\s+(\\d+)\\s+to\\s+(\\d+)/x\n                      )\n                    {\n                        my ( $name, $domainct, $domaintotal, $from, $to ) =\n                          ( $1, $2, $3, $4, $5 );\n                        $domaincounter{$name}++;\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->within_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n\n                        $self->start_element( { 'Name' => 'Hit' } );\n                        my $info = [\n                            @{\n                                $hitinfo[ $hitinfo{$name} ] || $self->throw(\n\"Could not find hit info for $name: Insure that your database contains only unique sequence names\"\n                                )\n                              }\n                        ];\n                        if ( $info->[0] ne $name ) {\n                            $self->throw(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name)\" );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        if ( $domaincounter{$name} == $domaintotal ) {\n                            $hitinfo[ $hitinfo{$name} ] = undef;\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n\n                        # Might want to change this so that it\n                        # accumulates all the of the alignment lines into\n                        # three array slots and then tests for the\n                        # end of the line\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {    # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                                $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-\\*\\s*$/o) {    #end of domain\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (( $count != 1 && /^\\s+$/o )\n                            || CORE::length($_) == 0\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_qseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (/^\\s+(\\S+)\\s+(\\d+|\\-)\\s+(\\S*)\\s+(\\d+|\\-)/o) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_hseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->warn(\"unrecognized line: $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n        }\n        elsif ( defined $self->{'_reporttype'}\n            && $self->{'_reporttype'} eq 'HMMPFAM' )\n        {\n            # process HMMPFAM results here\n            if (/^Scores for sequence family/o) {\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    next if ( /^Model\\s+Description/o || /^\\-\\-\\-/o );\n                    chomp;\n                    my @line = split;\n                    my ( $model, $n, $evalue, $score ) =\n                      ( shift @line, pop @line, pop @line, pop @line );\n                    my $desc = join( ' ', @line );\n                    push @hitinfo, [ $model, $desc, $score, $evalue, $n ];\n                    $hitinfo{$model} = $#hitinfo;\n                }\n            }\n            elsif (/^Parsed for domains:/o) {\n                @hspinfo = ();\n                while ( defined( $_ = $self->_readline ) ) {\n                    last if (/^\\s+$/);\n                    if (m!^//!) {\n                        $self->_pushback($_);\n                        last;\n                    }\n                    next if ( /^Model\\s+Domain/o || /^\\-\\-\\-/o );\n                    chomp;\n                    if (\n                        my ( $n, $domainnum, $domainct, @vals ) = (\n                            m!^(\\S+)\\s+         # domain name\n                            (\\d+)/(\\d+)\\s+      # domain num out of num\n                            (\\d+)\\s+(\\d+).+?    # seq start, end\n                            (\\d+)\\s+(\\d+)\\s+    # hmm start, end\n                            \\S+\\s+              # []\n                            (\\S+)\\s+            # score       \n                            (\\S+)               # evalue\n                            \\s*$!ox\n                        )\n                      )\n                    {\n                        my $hindex = $hitinfo{$n};\n                        if ( !defined $hindex ) {\n                            push @hitinfo,\n                              [ $n, '', $vals[5], $vals[6], $domainct ];\n                            $hitinfo{$n} = $#hitinfo;\n                            $hindex = $#hitinfo;\n                        }\n                        my $info = $hitinfo[$hindex];\n                        if ( !defined $info ) {\n                            $self->warn(\n\"incomplete Domain information, can't find $n hitinfo says $hitinfo{$n}\"\n                            );\n                            next;\n                        }\n                        push @hspinfo, [ $n, @vals ];\n                    }\n                }\n            }\n            elsif (/^Alignments of top/o) {\n                my ( $prelength, $lastdomain, $count, $width );\n                $count = 0;\n                my $second_tier = 0;\n                while ( defined( $_ = $self->_readline ) ) {\n                    next\n                      if (\n                        /^Align/o\n                        || ( $count != 1\n                            && /^\\s+RF\\s+[x\\s]+$/o )\n                      );\n                    # fix for bug 2632\n                    next if ($_ =~ m/^\\s+CS\\s+/o && $count == 0);\n                    if ( /^Histogram/o || m!^//!o || /^Query sequence/o ) {\n                        if ( $self->in_element('hsp') ) {\n                            $self->end_element( { 'Name' => 'Hsp' } );\n                        }\n                        if ( $self->in_element('hit') ) {\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        $self->_pushback($_);\n                        last;\n                    }\n                    chomp;\n                    if (m/(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/o) {\n                        my ( $name, $from, $to ) = ( $1, $2, $3 );\n\n                        if ( $self->within_element('hit') ) {\n                            if ( $self->in_element('hsp') ) {\n                                $self->end_element( { 'Name' => 'Hsp' } );\n                            }\n                            $self->end_element( { 'Name' => 'Hit' } );\n                        }\n                        my $info = [ @{ $hitinfo[ $hitinfo{$name} ] } ];\n                        if ( !defined $info\n                            || $info->[0] ne $name )\n                        {\n                            $self->warn(\n\"Somehow the Model table order does not match the order in the domains (got \"\n                                  . $info->[0]\n                                  . \", expected $name). We're back loading this from the alignment information instead\"\n                            );\n                            $info = [\n                                $name, '',\n                                /score\\s+([^,\\s]+),\\s+E\\s+=\\s+(\\S+)/ox\n                            ];\n                            push @hitinfo, $info;\n                            $hitinfo{$name} = $#hitinfo;\n                        }\n                        $self->start_element( { 'Name' => 'Hit' } );\n\n                        $self->element(\n                            {\n                                'Name' => 'Hit_id',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_desc',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_score',\n                                'Data' => shift @{$info}\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hit_signif',\n                                'Data' => shift @{$info}\n                            }\n                        );\n\n                        $self->start_element( { 'Name' => 'Hsp' } );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_identity',\n                                'Data' => 0\n                            }\n                        );                     \n                        $self->element(\n                            {\n                                'Name' => 'Hsp_positive',\n                                'Data' => 0\n                            }\n                        );\n                        my $HSPinfo = shift @hspinfo;\n                        my $id      = shift @$HSPinfo;\n\n                        if ( $id ne $name ) {\n                            $self->throw(\n\"Somehow the domain list details do not match the table (got $id, expected $name)\"\n                            );\n                        }\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_query-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-from',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_hit-to',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_score',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Hsp_evalue',\n                                'Data' => shift @$HSPinfo\n                            }\n                        );\n                        $lastdomain = $name;\n                    }\n                    else {\n                        if (/^(\\s+\\*\\-\\>)(\\S+)/o) {\n\n                            # start of domain\n                            $prelength = CORE::length($1);\n                            $width     = 0;\n\n                            # deal with fact that start en stop is on same line\n                            my $data = $2;\n                            if ($data =~ s/\\<\\-?\\*?\\s*$//)\n                            {\n                              $width = CORE::length($data);\n                            }\n \n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $data\n                                }\n                            );\n                            $count       = 0;\n                            $second_tier = 0;\n\n                        }\n                        elsif (/^(\\s+)(\\S+)\\<\\-?\\*?\\s*$/o) {\n\n                            #end of domain\n                            $prelength -= 3 unless ( $second_tier++ );\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => $2\n                                }\n                            );\n                            $width = CORE::length($2);\n                            $count = 0;\n                        }\n                        elsif (CORE::length($_) == 0\n                            || ( $count != 1 && /^\\s+$/o )\n                            || /^\\s+\\-?\\*\\s*$/ )\n                        {\n                            next;\n                        }\n                        elsif ( $count == 0 ) {\n                            $prelength -= 3 unless ( $second_tier++ );\n                            unless ( defined $prelength ) {\n\n                                # $self->warn(\"prelength not set\");\n                                next;\n                            }\n                            $self->element(\n                                {\n                                    'Name' => 'Hsp_hseq',\n                                    'Data' => substr( $_, $prelength )\n                                }\n                            );\n                        }\n                        elsif ( $count == 1 ) {\n                            if ( !defined $prelength ) {\n                                $self->warn(\"prelength not set\");\n                            }\n                            if ($width) {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' =>\n                                          substr( $_, $prelength, $width )\n                                    }\n                                );\n                            }\n                            else {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_midline',\n                                        'Data' => substr( $_, $prelength )\n                                    }\n                                );\n                            }\n                        }\n                        elsif ( $count == 2 ) {\n                            if (   /^\\s+(\\S+)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)/o\n                                || /^\\s+(\\S+)\\s+(\\-)\\s+(\\S*)\\s+(\\-)/o )\n                            {\n                                $self->element(\n                                    {\n                                        'Name' => 'Hsp_qseq',\n                                        'Data' => $3\n                                    }\n                                );\n                            }\n                            else {\n                                $self->throw(\n                                    \"unrecognized line ($count): $_\\n\");\n                            }\n                        }\n                        $count = 0 if $count++ >= 2;\n                    }\n                }\n            }\n            elsif ( /^Histogram/o || m!^//!o ) {\n\n                while ( my $HSPinfo = shift @hspinfo ) {\n                    my $id   = shift @$HSPinfo;\n                    my $info = [ @{ $hitinfo[ $hitinfo{$id} ] } ];\n                    next unless defined $info;\n                    $self->start_element( { 'Name' => 'Hit' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_id',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_desc',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_signif',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hit_score',\n                            'Data' => shift @{$info}\n                        }\n                    );\n                    $self->start_element( { 'Name' => 'Hsp' } );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );                    \n                    $self->element(\n                        {\n                            'Name' => 'Hsp_query-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-from',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_hit-to',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_score',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_evalue',\n                            'Data' => shift @$HSPinfo\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_identity',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'Hsp_positive',\n                            'Data' => 0\n                        }\n                    );\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    $self->end_element( { 'Name' => 'Hit' } );\n                }\n                @hitinfo = ();\n                %hitinfo = ();\n                last;\n            }\n            # uncomment to see missed lines with verbose on\n            #else {\n            #    $self->debug($_);\n            #}\n        }\n        $last = $_;\n    }\n    $self->end_element( { 'Name' => 'HMMER_Output' } ) unless !$seentop;\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ( $nm eq 'HMMER_program' ) {\n        if ( $self->{'_last_data'} =~ /(HMM\\S+)/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n    }\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq)) {\n            my $data = $self->{'_last_hspdata'}->{$_};\n            if ($data && $_ eq 'Hsp_hseq') {\n                # replace hmm '.' gap symbol by '-'\n                $data =~ s/\\./-/g;\n            }\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $data\n                }\n            );\n        }\n        $self->{'_last_hspdata'} = {};\n    }\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/o\n        && defined $data->{'Data'} )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediete parent.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}],"label":"end_document($self)"}},{"definition":"sub","name":"result_count","containerName":"main::","children":[{"definition":"my","line":1304,"name":"$self","localvar":"my","containerName":"result_count","kind":13},{"line":1305,"name":"$self","kind":13,"containerName":"result_count"}],"range":{"end":{"line":1306,"character":9999},"start":{"line":1303,"character":0}},"kind":12,"line":1303}],"version":5}