{"vars":[{"name":"vars","kind":2,"containerName":"","line":146},{"kind":2,"containerName":"","name":"base","line":155},{"line":161,"name":"%MODEMAP","kind":13,"containerName":null},{"line":161,"containerName":"Data","kind":2,"name":"Dumper"},{"name":"%MAPPING","kind":13,"containerName":null,"line":171},{"line":270,"name":"%frame","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":271,"localvar":"my","containerName":null,"kind":13,"name":"%strand","definition":"my"},{"definition":"my","name":"%ind","localvar":"my","kind":13,"containerName":null,"line":272},{"line":277,"name":"%MAPPING","containerName":null,"kind":13},{"definition":"my","line":280,"name":"%val","kind":13,"localvar":"my","containerName":null},{"name":"%type","containerName":null,"localvar":"my","kind":13,"line":281,"definition":"my"},{"definition":"my","line":282,"localvar":"my","containerName":null,"kind":13,"name":"$key"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"%val","line":283},{"line":286,"containerName":null,"kind":13,"name":"%MAPPING"},{"line":286,"name":"$key","containerName":null,"kind":13},{"name":"$val","containerName":null,"kind":13,"line":286},{"line":293,"name":"%stats","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"localvar":"my","containerName":null,"kind":13,"name":"$key","line":304,"definition":"my"},{"definition":"my","line":305,"localvar":"my","containerName":null,"kind":13,"name":"%val"},{"line":305,"kind":13,"containerName":null,"name":"$stats"},{"line":306,"name":"%MAPPING","containerName":null,"kind":13},{"name":"$key","kind":13,"containerName":null,"line":306},{"line":306,"kind":13,"containerName":null,"name":"$val"},{"name":"%param","localvar":"my","kind":13,"containerName":null,"line":310,"definition":"my"},{"line":318,"name":"$key","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":319,"localvar":"my","containerName":null,"kind":13,"name":"%val","definition":"my"},{"kind":13,"containerName":null,"name":"$param","line":319},{"line":320,"name":"%MAPPING","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$key","line":320},{"name":"$val","kind":13,"containerName":null,"line":320},{"line":323,"containerName":null,"kind":13,"name":"$DEFAULT_BLAST_WRITER_CLASS"},{"name":"$MAX_HSP_OVERLAP","kind":13,"containerName":null,"line":324},{"kind":13,"containerName":null,"name":"$DEFAULTREPORTTYPE","line":325},{"definition":"sub","detail":"($self,@args)","children":[{"line":387,"localvar":"my","containerName":"_initialize","kind":13,"name":"$self","definition":"my"},{"name":"@args","kind":13,"containerName":"_initialize","line":387},{"kind":13,"containerName":"_initialize","name":"$self","line":388},{"name":"@args","containerName":"_initialize","kind":13,"line":388},{"name":"$handler","localvar":"my","kind":13,"containerName":"_initialize","line":395,"definition":"my"},{"line":395,"name":"new","kind":12,"containerName":"_initialize"},{"line":395,"name":"@args","containerName":"_initialize","kind":13},{"line":396,"name":"$self","containerName":"_initialize","kind":13},{"name":"attach_EventHandler","kind":12,"containerName":"_initialize","line":396},{"kind":13,"containerName":"_initialize","name":"$handler","line":396},{"name":"$min_qlen","localvar":"my","kind":13,"containerName":"_initialize","line":405,"definition":"my"},{"kind":13,"containerName":"_initialize","name":"$check_all","line":405},{"line":405,"name":"$overlap","kind":13,"containerName":"_initialize"},{"line":405,"kind":13,"containerName":"_initialize","name":"$best"},{"containerName":"_initialize","kind":13,"name":"$rpttype","line":405},{"line":405,"name":"$self","containerName":"_initialize","kind":13},{"line":405,"kind":12,"containerName":"_initialize","name":"_rearrange"},{"containerName":"_initialize","kind":13,"name":"@args","line":412},{"line":414,"containerName":"_initialize","kind":13,"name":"$min_qlen"},{"name":"$self","kind":13,"containerName":"_initialize","line":414},{"line":414,"kind":12,"containerName":"_initialize","name":"min_query_length"},{"line":414,"name":"$min_qlen","containerName":"_initialize","kind":13},{"kind":13,"containerName":"_initialize","name":"$best","line":415},{"line":415,"name":"$self","containerName":"_initialize","kind":13},{"line":415,"containerName":"_initialize","kind":12,"name":"best_hit_only"},{"kind":13,"containerName":"_initialize","name":"$best","line":415},{"line":416,"name":"$check_all","containerName":"_initialize","kind":13},{"line":416,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"check_all_hits","kind":12,"containerName":"_initialize","line":416},{"kind":13,"containerName":"_initialize","name":"$check_all","line":416},{"name":"$rpttype","containerName":"_initialize","kind":13,"line":417},{"line":417,"kind":13,"containerName":"_initialize","name":"$self"},{"line":417,"name":"$rpttype","kind":13,"containerName":"_initialize"}],"containerName":"main::","name":"_initialize","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false."},"line":386,"range":{"end":{"character":9999,"line":418},"start":{"character":0,"line":386}},"kind":12},{"name":"SUPER","containerName":"_initialize","kind":12,"line":388},{"kind":12,"containerName":"SearchIO::IteratedSearchResultEventBuilder","name":"Bio","line":395},{"containerName":"main::","name":"attach_EventHandler","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"attach_EventHandler","kind":13,"line":421},{"line":421,"containerName":"attach_EventHandler","kind":13,"name":"$handler"},{"line":423,"containerName":"attach_EventHandler","kind":13,"name":"$self"},{"kind":13,"containerName":"attach_EventHandler","name":"$handler","line":423},{"line":428,"name":"$self","kind":13,"containerName":"attach_EventHandler"},{"line":428,"name":"$handler","containerName":"attach_EventHandler","kind":13}],"detail":"($self,$handler)","definition":"sub","kind":12,"range":{"end":{"line":430,"character":9999},"start":{"character":0,"line":420}},"line":420,"signature":{"label":"attach_EventHandler($self,$handler)","parameters":[{"label":"$self"},{"label":"$handler"}],"documentation":""}},{"name":"SUPER","kind":12,"containerName":"attach_EventHandler","line":423},{"signature":{"parameters":[{"label":"$self"}],"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","label":"next_result($self)"},"line":442,"kind":12,"range":{"end":{"line":1855,"character":9999},"start":{"character":0,"line":442}},"definition":"sub","detail":"($self)","children":[{"line":443,"localvar":"my","kind":13,"containerName":"next_result","name":"$self","definition":"my"},{"line":444,"localvar":"my","containerName":"next_result","kind":13,"name":"$v","definition":"my"},{"line":444,"name":"$self","kind":13,"containerName":"next_result"},{"line":444,"name":"verbose","containerName":"next_result","kind":12},{"definition":"my","line":445,"kind":13,"localvar":"my","containerName":"next_result","name":"$data"},{"definition":"my","containerName":"next_result","localvar":"my","kind":13,"name":"$flavor","line":446},{"name":"$self","containerName":"next_result","kind":13,"line":447},{"line":448,"containerName":"next_result","kind":13,"name":"$self"},{"line":449,"localvar":"my","kind":13,"containerName":"next_result","name":"$reporttype","definition":"my"},{"line":449,"kind":13,"containerName":"next_result","name":"$seenquery"},{"kind":13,"containerName":"next_result","name":"$reportline","line":449},{"containerName":"next_result","localvar":"my","kind":13,"name":"$seeniteration","line":450,"definition":"my"},{"kind":13,"containerName":"next_result","name":"$found_again","line":450},{"definition":"my","line":451,"name":"$incl_threshold","localvar":"my","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$self","line":451},{"name":"inclusion_threshold","containerName":"next_result","kind":12,"line":451},{"definition":"my","line":452,"name":"$bl2seq_fix","localvar":"my","containerName":"next_result","kind":13},{"name":"$self","kind":13,"containerName":"next_result","line":453},{"line":453,"kind":12,"containerName":"next_result","name":"start_document"},{"definition":"my","name":"@hit_signifs","localvar":"my","kind":13,"containerName":"next_result","line":454},{"name":"$gapped_stats","kind":13,"localvar":"my","containerName":"next_result","line":455,"definition":"my"},{"name":"$self","kind":13,"containerName":"next_result","line":459},{"line":459,"name":"_readline","containerName":"next_result","kind":12},{"name":"$reporttype","kind":13,"containerName":"next_result","line":469},{"line":469,"name":"$reportversion","containerName":"next_result","localvar":"my","kind":13,"definition":"my"},{"name":"$reportversion","containerName":"next_result","kind":13,"line":471},{"line":471,"name":"$reportversion","containerName":"next_result","kind":13},{"line":472,"containerName":"next_result","kind":13,"name":"$self"},{"name":"$self","containerName":"next_result","kind":13,"line":474},{"kind":12,"containerName":"next_result","name":"debug","line":474},{"line":475,"name":"$self","containerName":"next_result","kind":13},{"line":477,"kind":13,"containerName":"next_result","name":"$self"},{"name":"_pushback","kind":12,"containerName":"next_result","line":477},{"line":480,"kind":13,"containerName":"next_result","name":"$self"},{"line":480,"name":"_start_blastoutput","containerName":"next_result","kind":12},{"name":"$reporttype","kind":13,"containerName":"next_result","line":481},{"containerName":"next_result","kind":13,"name":"$reporttype","line":482},{"containerName":"next_result","kind":13,"name":"$reportline","line":484},{"line":485,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"element","line":485},{"line":489,"name":"$reporttype","kind":13,"containerName":"next_result"},{"line":492,"kind":13,"containerName":"next_result","name":"$self"},{"line":492,"name":"element","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$reportversion","line":496},{"name":"$self","kind":13,"containerName":"next_result","line":498},{"line":498,"kind":12,"containerName":"next_result","name":"element"},{"name":"$incl_threshold","containerName":"next_result","kind":13,"line":502},{"line":508,"containerName":"next_result","kind":13,"name":"$self"},{"name":"debug","containerName":"next_result","kind":12,"line":508},{"line":510,"containerName":"next_result","kind":13,"name":"$self"},{"line":510,"containerName":"next_result","kind":12,"name":"in_element"},{"line":511,"name":"$self","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"end_element","line":511},{"containerName":"next_result","kind":13,"name":"$self","line":512},{"name":"in_element","containerName":"next_result","kind":12,"line":512},{"line":513,"containerName":"next_result","kind":13,"name":"$self"},{"name":"end_element","containerName":"next_result","kind":12,"line":513},{"line":514,"kind":13,"containerName":"next_result","name":"$seeniteration"},{"containerName":"next_result","kind":13,"name":"$self","line":515},{"name":"within_element","kind":12,"containerName":"next_result","line":515},{"kind":13,"containerName":"next_result","name":"$self","line":516},{"name":"end_element","containerName":"next_result","kind":12,"line":516},{"line":517,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":12,"name":"start_element","line":517},{"containerName":"next_result","kind":13,"name":"$self","line":520},{"line":520,"name":"start_element","kind":12,"containerName":"next_result"},{"name":"$seeniteration","containerName":"next_result","kind":13,"line":522},{"kind":13,"localvar":"my","containerName":"next_result","name":"$q","line":525,"definition":"my"},{"line":526,"containerName":"next_result","kind":13,"name":"$self"},{"name":"debug","kind":12,"containerName":"next_result","line":526},{"line":527,"name":"$size","kind":13,"localvar":"my","containerName":"next_result","definition":"my"},{"name":"$seenquery","containerName":"next_result","kind":13,"line":528},{"line":529,"name":"$self","containerName":"next_result","kind":13},{"line":529,"containerName":"next_result","kind":12,"name":"_pushback"},{"line":529,"containerName":"next_result","kind":13,"name":"$reportline"},{"name":"$reportline","containerName":"next_result","kind":13,"line":529},{"line":530,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"_pushback","line":530},{"name":"$reporttype","kind":13,"containerName":"next_result","line":534},{"containerName":"next_result","kind":13,"name":"$self","line":535},{"line":535,"name":"_start_blastoutput","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$seeniteration","line":536},{"line":537,"name":"$self","kind":13,"containerName":"next_result"},{"line":537,"containerName":"next_result","kind":12,"name":"in_element"},{"name":"$self","kind":13,"containerName":"next_result","line":538},{"line":538,"containerName":"next_result","kind":12,"name":"end_element"},{"name":"$self","kind":13,"containerName":"next_result","line":539},{"line":539,"containerName":"next_result","kind":12,"name":"start_element"},{"name":"$self","containerName":"next_result","kind":13,"line":542},{"line":542,"name":"start_element","containerName":"next_result","kind":12},{"line":544,"name":"$seeniteration","containerName":"next_result","kind":13},{"line":547,"name":"$seenquery","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$q","line":547},{"line":548,"kind":13,"containerName":"next_result","name":"$self"},{"line":548,"name":"_readline","kind":12,"containerName":"next_result"},{"line":551,"kind":13,"containerName":"next_result","name":"$self"},{"line":551,"name":"_pushback","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$size","line":557},{"line":558,"name":"$size","containerName":"next_result","kind":13},{"name":"$q","containerName":"next_result","kind":13,"line":563},{"name":"$q","kind":13,"containerName":"next_result","line":563},{"line":564,"name":"$q","kind":13,"containerName":"next_result"},{"name":"$q","kind":13,"containerName":"next_result","line":565},{"line":568,"name":"$self","kind":13,"containerName":"next_result"},{"line":568,"containerName":"next_result","kind":12,"name":"_readline"},{"containerName":"next_result","kind":13,"name":"$q","line":570},{"line":571,"kind":13,"localvar":"my","containerName":"next_result","name":"$nm","definition":"my"},{"containerName":"next_result","kind":13,"name":"$desc","line":571},{"line":571,"name":"$q","containerName":"next_result","kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":572},{"name":"element","containerName":"next_result","kind":12,"line":572},{"line":576,"name":"$nm","containerName":"next_result","kind":13},{"line":577,"name":"$nm","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$self","line":578},{"containerName":"next_result","kind":12,"name":"element","line":578},{"name":"$size","containerName":"next_result","kind":13,"line":582},{"line":584,"containerName":"next_result","kind":13,"name":"$desc"},{"line":584,"containerName":"next_result","kind":13,"name":"$desc"},{"name":"$self","kind":13,"containerName":"next_result","line":585},{"line":585,"name":"element","containerName":"next_result","kind":12},{"line":589,"name":"$desc","kind":13,"containerName":"next_result"},{"definition":"my","localvar":"my","kind":13,"containerName":"next_result","name":"$gi","line":591},{"line":591,"kind":13,"containerName":"next_result","name":"$acc"},{"name":"$version","containerName":"next_result","kind":13,"line":591},{"containerName":"next_result","kind":13,"name":"$self","line":591},{"line":591,"kind":12,"containerName":"next_result","name":"_get_seq_identifiers"},{"line":591,"containerName":"next_result","kind":13,"name":"$nm"},{"line":592,"name":"$version","kind":13,"containerName":"next_result"},{"name":"$version","kind":13,"containerName":"next_result","line":592},{"line":592,"name":"$version","containerName":"next_result","kind":13},{"line":593,"name":"$self","kind":13,"containerName":"next_result"},{"name":"element","kind":12,"containerName":"next_result","line":593},{"line":598,"kind":13,"containerName":"next_result","name":"$acc"},{"line":604,"name":"$self","containerName":"next_result","kind":13},{"line":604,"name":"debug","containerName":"next_result","kind":12},{"line":605,"name":"$self","containerName":"next_result","kind":13},{"name":"_readline","containerName":"next_result","kind":12,"line":605},{"line":607,"name":"$self","containerName":"next_result","kind":13},{"line":607,"kind":12,"containerName":"next_result","name":"_pushback"},{"kind":13,"containerName":"next_result","name":"$self","line":610},{"line":610,"name":"debug","kind":12,"containerName":"next_result"},{"name":"$flavor","containerName":"next_result","kind":13,"line":611},{"name":"$self","kind":13,"containerName":"next_result","line":621},{"line":621,"kind":12,"containerName":"next_result","name":"in_element"},{"line":622,"kind":13,"containerName":"next_result","name":"$self"},{"name":"start_element","containerName":"next_result","kind":12,"line":622},{"line":626,"name":"$self","kind":13,"containerName":"next_result"},{"line":626,"containerName":"next_result","kind":12,"name":"element"},{"name":"$self","kind":13,"containerName":"next_result","line":629},{"containerName":"next_result","kind":13,"name":"$self","line":631},{"line":632,"name":"$self","containerName":"next_result","kind":13},{"name":"element","containerName":"next_result","kind":12,"line":632},{"line":635,"containerName":"next_result","kind":13,"name":"$self"},{"line":637,"name":"$self","kind":13,"containerName":"next_result"},{"line":638,"name":"$self","containerName":"next_result","kind":13},{"name":"element","kind":12,"containerName":"next_result","line":638},{"name":"$self","kind":13,"containerName":"next_result","line":641},{"kind":13,"containerName":"next_result","name":"$self","line":643},{"line":647,"containerName":"next_result","localvar":"my","kind":13,"name":"$h_regex","definition":"my"},{"name":"$seen_block","localvar":"my","containerName":"next_result","kind":13,"line":648,"definition":"my"},{"kind":13,"localvar":"my","containerName":"next_result","name":"$descline","line":650,"definition":"my"},{"line":650,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"_readline","line":650},{"containerName":"next_result","kind":13,"name":"$descline","line":651},{"line":652,"name":"$seen_block","containerName":"next_result","kind":13},{"line":656,"kind":13,"containerName":"next_result","name":"$seen_block"},{"name":"$descline","kind":13,"containerName":"next_result","line":658},{"line":659,"name":"$id","localvar":"my","containerName":"next_result","kind":13,"definition":"my"},{"line":659,"name":"$nextline","containerName":"next_result","kind":13},{"line":659,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"_readline","line":659},{"line":660,"containerName":"next_result","kind":13,"name":"$nextline"},{"containerName":"next_result","kind":13,"name":"$descline","line":661},{"line":664,"containerName":"next_result","kind":13,"name":"$descline"},{"definition":"my","line":670,"name":"$score","localvar":"my","containerName":"next_result","kind":13},{"line":670,"name":"$evalue","containerName":"next_result","kind":13},{"name":"$evalue","kind":13,"containerName":"next_result","line":673},{"definition":"my","line":676,"containerName":"next_result","localvar":"my","kind":13,"name":"@line"},{"line":676,"kind":13,"containerName":"next_result","name":"$descline"},{"containerName":"next_result","kind":13,"name":"@line","line":679},{"line":679,"kind":13,"containerName":"next_result","name":"@line"},{"line":683,"containerName":"next_result","kind":13,"name":"@line"},{"name":"@hit_signifs","containerName":"next_result","kind":13,"line":687},{"kind":13,"containerName":"next_result","name":"$evalue","line":687},{"line":687,"containerName":"next_result","kind":13,"name":"$score"},{"line":687,"kind":13,"containerName":"next_result","name":"@line"},{"line":687,"kind":13,"containerName":"next_result","name":"@line"},{"line":688,"containerName":"next_result","kind":13,"name":"$descline"},{"line":689,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"element","line":689},{"kind":13,"containerName":"next_result","name":"$self","line":696},{"name":"_pushback","containerName":"next_result","kind":12,"line":696},{"line":696,"name":"$descline","containerName":"next_result","kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":705},{"line":705,"containerName":"next_result","kind":12,"name":"debug"},{"name":"$self","containerName":"next_result","kind":13,"line":706},{"line":706,"kind":12,"containerName":"next_result","name":"_readline"},{"kind":13,"containerName":"next_result","name":"$flavor","line":707},{"line":709,"kind":13,"containerName":"next_result","name":"$self"},{"line":709,"name":"in_element","containerName":"next_result","kind":12},{"line":710,"name":"$self","kind":13,"containerName":"next_result"},{"line":710,"name":"start_element","kind":12,"containerName":"next_result"},{"line":713,"name":"$self","kind":13,"containerName":"next_result"},{"line":713,"containerName":"next_result","kind":12,"name":"_readline"},{"name":"@line","localvar":"my","kind":13,"containerName":"next_result","line":716,"definition":"my"},{"kind":13,"containerName":"next_result","name":"@line","line":717},{"containerName":"next_result","kind":13,"name":"@hit_signifs","line":721},{"name":"@line","containerName":"next_result","kind":13,"line":722},{"line":722,"containerName":"next_result","kind":13,"name":"@line"},{"line":722,"containerName":"next_result","kind":13,"name":"@line"},{"line":722,"kind":13,"containerName":"next_result","name":"@line"},{"name":"$self","containerName":"next_result","kind":13,"line":728},{"kind":12,"containerName":"next_result","name":"debug","line":728},{"definition":"my","name":"$db","kind":13,"localvar":"my","containerName":"next_result","line":729},{"line":730,"containerName":"next_result","kind":13,"name":"$self"},{"name":"_readline","kind":12,"containerName":"next_result","line":730},{"definition":"my","line":737,"localvar":"my","containerName":"next_result","kind":13,"name":"$s"},{"line":737,"kind":13,"containerName":"next_result","name":"$l"},{"line":738,"name":"$s","kind":13,"containerName":"next_result"},{"name":"$l","kind":13,"containerName":"next_result","line":739},{"name":"$self","kind":13,"containerName":"next_result","line":740},{"containerName":"next_result","kind":12,"name":"element","line":740},{"line":744,"containerName":"next_result","kind":13,"name":"$s"},{"name":"$self","kind":13,"containerName":"next_result","line":746},{"name":"element","kind":12,"containerName":"next_result","line":746},{"containerName":"next_result","kind":13,"name":"$l","line":750},{"line":753,"containerName":"next_result","kind":13,"name":"$self"},{"line":753,"containerName":"next_result","kind":13,"name":"$db"},{"containerName":"next_result","kind":13,"name":"$self","line":754},{"line":754,"name":"$s","containerName":"next_result","kind":13},{"line":755,"containerName":"next_result","kind":13,"name":"$self"},{"name":"$l","containerName":"next_result","kind":13,"line":755},{"line":760,"containerName":"next_result","kind":13,"name":"$db"},{"line":763,"containerName":"next_result","kind":13,"name":"$self"},{"line":763,"containerName":"next_result","kind":12,"name":"element"},{"name":"$db","containerName":"next_result","kind":13,"line":767},{"name":"$featline","localvar":"my","kind":13,"containerName":"next_result","line":773,"definition":"my"},{"kind":13,"containerName":"next_result","name":"$self","line":774},{"line":774,"name":"_readline","kind":12,"containerName":"next_result"},{"line":777,"containerName":"next_result","kind":13,"name":"$featline"},{"line":778,"kind":13,"containerName":"next_result","name":"$self"},{"line":778,"containerName":"next_result","kind":12,"name":"_readline"},{"name":"$self","containerName":"next_result","kind":13,"line":780},{"name":"_pushback","kind":12,"containerName":"next_result","line":780},{"name":"$featline","containerName":"next_result","kind":13,"line":781},{"line":782,"name":"$featline","kind":13,"containerName":"next_result"},{"name":"$self","kind":13,"containerName":"next_result","line":783},{"containerName":"next_result","kind":13,"name":"$featline","line":783},{"line":790,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"debug","line":790},{"name":"$self","kind":13,"containerName":"next_result","line":791},{"line":791,"name":"in_element","containerName":"next_result","kind":12},{"line":792,"name":"$self","containerName":"next_result","kind":13},{"line":792,"containerName":"next_result","kind":12,"name":"end_element"},{"line":793,"name":"$self","containerName":"next_result","kind":13},{"line":793,"name":"in_element","containerName":"next_result","kind":12},{"line":794,"kind":13,"containerName":"next_result","name":"$self"},{"name":"end_element","kind":12,"containerName":"next_result","line":794},{"name":"$self","kind":13,"containerName":"next_result","line":798},{"line":798,"name":"within_element","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$self","line":799},{"name":"_start_blastoutput","kind":12,"containerName":"next_result","line":799},{"kind":13,"containerName":"next_result","name":"$self","line":800},{"containerName":"next_result","kind":12,"name":"start_element","line":800},{"line":802,"name":"$self","kind":13,"containerName":"next_result"},{"name":"within_element","containerName":"next_result","kind":12,"line":802},{"name":"$self","kind":13,"containerName":"next_result","line":803},{"containerName":"next_result","kind":12,"name":"start_element","line":803},{"line":805,"name":"$self","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"start_element","line":805},{"definition":"my","name":"$id","containerName":"next_result","localvar":"my","kind":13,"line":806},{"definition":"my","name":"$restofline","containerName":"next_result","localvar":"my","kind":13,"line":807},{"line":809,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"debug","line":809},{"name":"$self","containerName":"next_result","kind":13,"line":810},{"name":"element","kind":12,"containerName":"next_result","line":810},{"name":"$id","containerName":"next_result","kind":13,"line":814},{"definition":"my","name":"$gi","containerName":"next_result","localvar":"my","kind":13,"line":816},{"kind":13,"containerName":"next_result","name":"$acc","line":816},{"name":"$version","kind":13,"containerName":"next_result","line":816},{"line":816,"kind":13,"containerName":"next_result","name":"$self"},{"line":816,"name":"_get_seq_identifiers","containerName":"next_result","kind":12},{"name":"$id","containerName":"next_result","kind":13,"line":816},{"line":817,"name":"$self","kind":13,"containerName":"next_result"},{"line":817,"kind":12,"containerName":"next_result","name":"element"},{"name":"$acc","containerName":"next_result","kind":13,"line":821},{"line":830,"localvar":"my","containerName":"next_result","kind":13,"name":"$v","definition":"my"},{"line":830,"name":"@hit_signifs","containerName":"next_result","kind":13},{"definition":"my","localvar":"my","containerName":"next_result","kind":13,"name":"$tableid","line":831},{"line":831,"name":"$v","containerName":"next_result","kind":13},{"name":"$tableid","containerName":"next_result","kind":13,"line":832},{"containerName":"next_result","kind":13,"name":"$self","line":833},{"line":833,"name":"debug","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":839},{"line":839,"kind":12,"containerName":"next_result","name":"_readline"},{"definition":"my","name":"$l","containerName":"next_result","localvar":"my","kind":13,"line":843},{"line":844,"name":"$l","kind":13,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":845},{"name":"element","kind":12,"containerName":"next_result","line":845},{"line":849,"containerName":"next_result","kind":13,"name":"$l"},{"line":855,"name":"$restofline","containerName":"next_result","kind":13},{"line":858,"kind":13,"containerName":"next_result","name":"$restofline"},{"line":859,"containerName":"next_result","kind":13,"name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":859},{"line":863,"name":"$restofline","kind":13,"containerName":"next_result"},{"line":870,"name":"$self","containerName":"next_result","kind":13},{"line":870,"name":"in_element","kind":12,"containerName":"next_result"},{"name":"$self","kind":13,"containerName":"next_result","line":870},{"line":870,"kind":12,"containerName":"next_result","name":"in_element"},{"name":"$self","containerName":"next_result","kind":13,"line":878},{"line":878,"containerName":"next_result","kind":12,"name":"in_element"},{"line":879,"containerName":"next_result","kind":13,"name":"$self"},{"name":"end_element","containerName":"next_result","kind":12,"line":879},{"line":880,"containerName":"next_result","kind":13,"name":"$self"},{"kind":12,"containerName":"next_result","name":"start_element","line":880},{"kind":13,"containerName":"next_result","name":"$self","line":882},{"kind":12,"containerName":"next_result","name":"debug","line":882},{"name":"$bits","containerName":"next_result","localvar":"my","kind":13,"line":885,"definition":"my"},{"line":885,"kind":13,"containerName":"next_result","name":"$score"},{"line":885,"kind":13,"containerName":"next_result","name":"$evalue"},{"containerName":"next_result","kind":13,"name":"$evalue","line":886},{"kind":13,"containerName":"next_result","name":"$self","line":887},{"containerName":"next_result","kind":12,"name":"element","line":887},{"line":891,"kind":13,"containerName":"next_result","name":"$score"},{"name":"$self","containerName":"next_result","kind":13,"line":893},{"line":893,"containerName":"next_result","kind":12,"name":"element"},{"containerName":"next_result","kind":13,"name":"$bits","line":897},{"containerName":"next_result","kind":13,"name":"$self","line":899},{"kind":12,"containerName":"next_result","name":"element","line":899},{"line":903,"name":"$evalue","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$self","line":907},{"line":907,"name":"in_element","kind":12,"containerName":"next_result"},{"line":907,"kind":13,"containerName":"next_result","name":"$self"},{"name":"in_element","containerName":"next_result","kind":12,"line":907},{"line":915,"kind":13,"containerName":"next_result","name":"$self"},{"line":915,"containerName":"next_result","kind":12,"name":"in_element"},{"containerName":"next_result","kind":13,"name":"$self","line":916},{"name":"end_element","kind":12,"containerName":"next_result","line":916},{"kind":13,"containerName":"next_result","name":"$self","line":917},{"name":"start_element","kind":12,"containerName":"next_result","line":917},{"kind":13,"containerName":"next_result","name":"$self","line":919},{"containerName":"next_result","kind":12,"name":"debug","line":919},{"definition":"my","name":"$score","containerName":"next_result","localvar":"my","kind":13,"line":922},{"kind":13,"containerName":"next_result","name":"$evalue","line":922},{"line":922,"name":"$pvalue","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$evalue","line":923},{"line":923,"name":"$evalue","containerName":"next_result","kind":13},{"line":924,"containerName":"next_result","kind":13,"name":"$pvalue"},{"line":924,"name":"$pvalue","containerName":"next_result","kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":926},{"containerName":"next_result","kind":12,"name":"element","line":926},{"line":930,"name":"$score","containerName":"next_result","kind":13},{"line":932,"name":"$self","containerName":"next_result","kind":13},{"name":"element","containerName":"next_result","kind":12,"line":932},{"containerName":"next_result","kind":13,"name":"$evalue","line":936},{"line":938,"kind":13,"containerName":"next_result","name":"$self"},{"line":938,"containerName":"next_result","kind":12,"name":"element"},{"line":942,"name":"$pvalue","kind":13,"containerName":"next_result"},{"name":"$self","kind":13,"containerName":"next_result","line":946},{"line":946,"containerName":"next_result","kind":12,"name":"in_element"},{"name":"$self","kind":13,"containerName":"next_result","line":946},{"line":946,"containerName":"next_result","kind":12,"name":"in_element"},{"containerName":"next_result","kind":13,"name":"$self","line":957},{"name":"in_element","kind":12,"containerName":"next_result","line":957},{"line":958,"containerName":"next_result","kind":13,"name":"$self"},{"line":958,"name":"end_element","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$self","line":959},{"line":959,"name":"start_element","containerName":"next_result","kind":12},{"definition":"my","line":962,"name":"$score","kind":13,"localvar":"my","containerName":"next_result"},{"line":962,"name":"$bits","kind":13,"containerName":"next_result"},{"name":"$evalue","containerName":"next_result","kind":13,"line":962},{"line":962,"containerName":"next_result","kind":13,"name":"$pvalue"},{"line":962,"containerName":"next_result","kind":13,"name":"$group"},{"name":"$evalue","containerName":"next_result","kind":13,"line":964},{"containerName":"next_result","kind":13,"name":"$pvalue","line":965},{"line":967,"kind":13,"containerName":"next_result","name":"$self"},{"line":967,"name":"element","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$score","line":971},{"line":973,"containerName":"next_result","kind":13,"name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":973},{"name":"$bits","kind":13,"containerName":"next_result","line":977},{"kind":13,"containerName":"next_result","name":"$self","line":979},{"containerName":"next_result","kind":12,"name":"element","line":979},{"kind":13,"containerName":"next_result","name":"$evalue","line":983},{"name":"$self","containerName":"next_result","kind":13,"line":985},{"name":"element","kind":12,"containerName":"next_result","line":985},{"line":989,"containerName":"next_result","kind":13,"name":"$pvalue"},{"line":992,"name":"$group","containerName":"next_result","kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":993},{"line":993,"name":"element","containerName":"next_result","kind":12},{"line":997,"name":"$group","kind":13,"containerName":"next_result"},{"line":1003,"containerName":"next_result","kind":13,"name":"$self"},{"kind":12,"containerName":"next_result","name":"in_element","line":1003},{"line":1003,"kind":13,"containerName":"next_result","name":"$self"},{"line":1003,"kind":12,"containerName":"next_result","name":"in_element"},{"name":"$self","containerName":"next_result","kind":13,"line":1011},{"line":1011,"name":"in_element","kind":12,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1012},{"containerName":"next_result","kind":12,"name":"end_element","line":1012},{"line":1015,"name":"$bits","kind":13,"localvar":"my","containerName":"next_result","definition":"my"},{"name":"$score","kind":13,"containerName":"next_result","line":1015},{"kind":13,"containerName":"next_result","name":"$n","line":1015},{"line":1015,"containerName":"next_result","kind":13,"name":"$evalue"},{"name":"$evalue","containerName":"next_result","kind":13,"line":1016},{"line":1017,"name":"$self","kind":13,"containerName":"next_result"},{"line":1017,"kind":12,"containerName":"next_result","name":"start_element"},{"containerName":"next_result","kind":13,"name":"$self","line":1018},{"line":1018,"name":"element","containerName":"next_result","kind":12},{"line":1022,"name":"$score","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$self","line":1024},{"line":1024,"name":"element","containerName":"next_result","kind":12},{"name":"$bits","containerName":"next_result","kind":13,"line":1028},{"containerName":"next_result","kind":13,"name":"$self","line":1030},{"line":1030,"name":"element","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$evalue","line":1034},{"line":1036,"name":"$self","containerName":"next_result","kind":13},{"line":1036,"containerName":"next_result","kind":12,"name":"element"},{"line":1040,"name":"$n","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$n","line":1041},{"name":"$score","kind":13,"containerName":"next_result","line":1042},{"line":1042,"kind":13,"containerName":"next_result","name":"$score"},{"line":1044,"name":"$self","containerName":"next_result","kind":13},{"name":"debug","kind":12,"containerName":"next_result","line":1044},{"line":1047,"name":"$self","containerName":"next_result","kind":13},{"line":1047,"name":"in_element","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$self","line":1054},{"containerName":"next_result","kind":12,"name":"element","line":1054},{"line":1060,"kind":13,"containerName":"next_result","name":"$self"},{"line":1060,"kind":12,"containerName":"next_result","name":"element"},{"line":1067,"containerName":"next_result","kind":13,"name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":1067},{"line":1075,"name":"$self","kind":13,"containerName":"next_result"},{"line":1075,"name":"element","kind":12,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1083},{"name":"element","containerName":"next_result","kind":12,"line":1083},{"line":1091,"name":"$self","containerName":"next_result","kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":1092},{"line":1097,"containerName":"next_result","kind":13,"name":"$self"},{"line":1097,"kind":12,"containerName":"next_result","name":"_pushback"},{"line":1100,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"in_element","line":1100},{"containerName":"next_result","kind":13,"name":"$reporttype","line":1105},{"line":1106,"kind":13,"containerName":"next_result","name":"$self"},{"name":"$reporttype","kind":13,"containerName":"next_result","line":1106},{"name":"$bl2seq_fix","kind":13,"containerName":"next_result","line":1107},{"containerName":"next_result","kind":13,"name":"$self","line":1112},{"kind":12,"containerName":"next_result","name":"in_element","line":1112},{"line":1115,"name":"$self","containerName":"next_result","kind":13},{"line":1115,"name":"element","kind":12,"containerName":"next_result"},{"line":1122,"containerName":"next_result","kind":13,"name":"$self"},{"line":1122,"name":"in_element","containerName":"next_result","kind":12},{"line":1127,"containerName":"next_result","kind":13,"name":"$reporttype"},{"name":"$bl2seq_fix","containerName":"next_result","kind":13,"line":1128},{"kind":13,"containerName":"next_result","name":"$reporttype","line":1129},{"name":"$reporttype","containerName":"next_result","kind":13,"line":1131},{"line":1135,"name":"$self","kind":13,"containerName":"next_result"},{"line":1135,"name":"$reporttype","kind":13,"containerName":"next_result"},{"definition":"my","line":1138,"name":"$queryframe","localvar":"my","kind":13,"containerName":"next_result"},{"line":1138,"name":"$hitframe","kind":13,"containerName":"next_result"},{"line":1139,"name":"$reporttype","containerName":"next_result","kind":13},{"name":"$queryframe","containerName":"next_result","kind":13,"line":1140},{"kind":13,"containerName":"next_result","name":"$hitframe","line":1140},{"name":"$hitframe","kind":13,"containerName":"next_result","line":1141},{"name":"$reporttype","kind":13,"containerName":"next_result","line":1143},{"line":1143,"name":"$reporttype","kind":13,"containerName":"next_result"},{"line":1144,"containerName":"next_result","kind":13,"name":"$hitframe"},{"containerName":"next_result","kind":13,"name":"$queryframe","line":1144},{"line":1146,"name":"$reporttype","kind":13,"containerName":"next_result"},{"line":1146,"kind":13,"containerName":"next_result","name":"$reporttype"},{"containerName":"next_result","kind":13,"name":"$queryframe","line":1147},{"name":"$hitframe","containerName":"next_result","kind":13,"line":1147},{"containerName":"next_result","kind":13,"name":"$reporttype","line":1150},{"containerName":"next_result","kind":13,"name":"$self","line":1151},{"line":1151,"containerName":"next_result","kind":12,"name":"element"},{"containerName":"next_result","kind":13,"name":"$self","line":1159},{"name":"element","containerName":"next_result","kind":12,"line":1159},{"line":1163,"containerName":"next_result","kind":13,"name":"$queryframe"},{"line":1166,"containerName":"next_result","kind":13,"name":"$self"},{"line":1166,"containerName":"next_result","kind":12,"name":"element"},{"line":1170,"containerName":"next_result","kind":13,"name":"$hitframe"},{"kind":13,"containerName":"next_result","name":"$self","line":1178},{"line":1178,"name":"in_element","containerName":"next_result","kind":12},{"name":"$self","kind":13,"containerName":"next_result","line":1183},{"line":1183,"kind":12,"containerName":"next_result","name":"debug"},{"line":1185,"name":"$self","containerName":"next_result","kind":13},{"line":1185,"name":"in_element","kind":12,"containerName":"next_result"},{"line":1186,"name":"$self","containerName":"next_result","kind":13},{"line":1186,"containerName":"next_result","kind":12,"name":"end_element"},{"name":"$self","kind":13,"containerName":"next_result","line":1187},{"containerName":"next_result","kind":12,"name":"in_element","line":1187},{"kind":13,"containerName":"next_result","name":"$self","line":1188},{"line":1188,"name":"end_element","kind":12,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1192},{"line":1192,"kind":12,"containerName":"next_result","name":"_cleanup_hits"},{"kind":13,"containerName":"next_result","name":"@hit_signifs","line":1192},{"kind":13,"containerName":"next_result","name":"@hit_signifs","line":1192},{"line":1193,"name":"$self","containerName":"next_result","kind":13},{"name":"within_element","containerName":"next_result","kind":12,"line":1193},{"containerName":"next_result","kind":13,"name":"$self","line":1194},{"line":1194,"name":"end_element","containerName":"next_result","kind":12},{"name":"$blast","containerName":"next_result","localvar":"my","kind":13,"line":1197,"definition":"my"},{"line":1199,"name":"$blast","kind":13,"containerName":"next_result"},{"line":1202,"localvar":"my","kind":13,"containerName":"next_result","name":"$last","definition":"my"},{"kind":13,"containerName":"next_result","name":"$self","line":1205},{"line":1205,"kind":12,"containerName":"next_result","name":"element"},{"name":"$self","kind":13,"containerName":"next_result","line":1211},{"line":1211,"name":"_readline","containerName":"next_result","kind":12},{"line":1218,"kind":13,"containerName":"next_result","name":"$self"},{"line":1218,"containerName":"next_result","kind":12,"name":"_pushback"},{"name":"$self","kind":13,"containerName":"next_result","line":1224},{"line":1224,"name":"_pushback","containerName":"next_result","kind":12},{"name":"$reportline","containerName":"next_result","kind":13,"line":1224},{"containerName":"next_result","kind":13,"name":"$reportline","line":1224},{"name":"$self","containerName":"next_result","kind":13,"line":1225},{"line":1225,"kind":12,"containerName":"next_result","name":"_pushback"},{"containerName":"next_result","localvar":"my","kind":13,"name":"$c","line":1234,"definition":"my"},{"line":1235,"name":"$c","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$self","line":1236},{"name":"element","containerName":"next_result","kind":12,"line":1236},{"kind":13,"containerName":"next_result","name":"$c","line":1240},{"line":1244,"name":"$s","localvar":"my","containerName":"next_result","kind":13,"definition":"my"},{"line":1245,"kind":13,"containerName":"next_result","name":"$s"},{"line":1246,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"element","line":1246},{"name":"$s","kind":13,"containerName":"next_result","line":1250},{"line":1253,"name":"$blast","containerName":"next_result","kind":13},{"name":"$blast","containerName":"next_result","kind":13,"line":1256},{"line":1260,"name":"$self","kind":13,"containerName":"next_result"},{"line":1260,"name":"element","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$self","line":1268},{"name":"element","containerName":"next_result","kind":12,"line":1268},{"containerName":"next_result","kind":13,"name":"$self","line":1276},{"containerName":"next_result","kind":12,"name":"element","line":1276},{"line":1287,"name":"$self","containerName":"next_result","kind":13},{"name":"element","containerName":"next_result","kind":12,"line":1287},{"name":"$self","containerName":"next_result","kind":13,"line":1295},{"name":"element","containerName":"next_result","kind":12,"line":1295},{"line":1302,"name":"$last","containerName":"next_result","kind":13},{"localvar":"my","containerName":"next_result","kind":13,"name":"$firstgapinfo","line":1303,"definition":"my"},{"localvar":"my","kind":13,"containerName":"next_result","name":"$frame","line":1304,"definition":"my"},{"kind":13,"containerName":"next_result","name":"$firstgapinfo","line":1309},{"line":1311,"name":"$firstgapinfo","kind":13,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1313},{"line":1313,"name":"element","kind":12,"containerName":"next_result"},{"line":1319,"containerName":"next_result","kind":13,"name":"$self"},{"line":1319,"containerName":"next_result","kind":12,"name":"element"},{"definition":"my","name":"@fields","localvar":"my","kind":13,"containerName":"next_result","line":1325},{"definition":"my","name":"$type","kind":13,"localvar":"my","containerName":"next_result","line":1327},{"line":1333,"containerName":"next_result","kind":13,"name":"$type"},{"name":"@fields","kind":13,"containerName":"next_result","line":1334},{"line":1338,"name":"$self","kind":13,"containerName":"next_result"},{"name":"element","kind":12,"containerName":"next_result","line":1338},{"line":1343,"containerName":"next_result","kind":13,"name":"@fields"},{"definition":"my","name":"$frameo","localvar":"my","containerName":"next_result","kind":13,"line":1348},{"containerName":"next_result","kind":13,"name":"$matid","line":1348},{"line":1348,"name":"$matrix","containerName":"next_result","kind":13},{"name":"@fields","kind":13,"containerName":"next_result","line":1348},{"kind":13,"containerName":"next_result","name":"$frame","line":1350},{"name":"$self","kind":13,"containerName":"next_result","line":1354},{"containerName":"next_result","kind":12,"name":"element","line":1354},{"line":1358,"name":"$matrix","kind":13,"containerName":"next_result"},{"name":"$self","kind":13,"containerName":"next_result","line":1360},{"line":1360,"kind":12,"containerName":"next_result","name":"element"},{"line":1363,"containerName":"next_result","kind":13,"name":"$fields"},{"line":1366,"name":"$self","kind":13,"containerName":"next_result"},{"line":1366,"containerName":"next_result","kind":12,"name":"element"},{"line":1369,"name":"$fields","kind":13,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":1372},{"name":"element","containerName":"next_result","kind":12,"line":1372},{"containerName":"next_result","kind":13,"name":"$fields","line":1375},{"line":1379,"name":"$frame","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$frameo","line":1379},{"line":1380,"name":"$ii","containerName":"next_result","localvar":"my","kind":13,"definition":"my"},{"kind":13,"localvar":"my","containerName":"next_result","name":"$type","line":1381,"definition":"my"},{"line":1390,"name":"$f","containerName":"next_result","localvar":"my","kind":13,"definition":"my"},{"line":1390,"name":"$fields","containerName":"next_result","kind":13},{"line":1390,"name":"$ii","containerName":"next_result","kind":13},{"line":1391,"name":"$f","kind":13,"containerName":"next_result"},{"line":1392,"name":"$f","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$f","line":1393},{"line":1393,"name":"$fields","kind":13,"containerName":"next_result"},{"line":1393,"name":"$ii","containerName":"next_result","kind":13},{"line":1395,"name":"$ii","containerName":"next_result","kind":13},{"name":"$self","kind":13,"containerName":"next_result","line":1396},{"line":1396,"name":"element","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$f","line":1401},{"containerName":"next_result","kind":13,"name":"$self","line":1408},{"containerName":"next_result","kind":12,"name":"_readline","line":1408},{"name":"$last","containerName":"next_result","kind":13,"line":1410},{"line":1412,"name":"$last","containerName":"next_result","kind":13},{"line":1413,"name":"$frame","localvar":"my","containerName":"next_result","kind":13,"definition":"my"},{"name":"@fields","localvar":"my","containerName":"next_result","kind":13,"line":1417,"definition":"my"},{"line":1418,"containerName":"next_result","kind":13,"name":"@fields"},{"definition":"my","containerName":"next_result","localvar":"my","kind":13,"name":"$type","line":1419},{"containerName":"next_result","kind":13,"name":"@fields","line":1420},{"line":1421,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"element","line":1421},{"line":1426,"containerName":"next_result","kind":13,"name":"@fields"},{"name":"$type","localvar":"my","kind":13,"containerName":"next_result","line":1432,"definition":"my"},{"name":"$self","containerName":"next_result","kind":13,"line":1438},{"line":1438,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","kind":13,"name":"@fields","line":1443},{"kind":13,"containerName":"next_result","name":"$self","line":1447},{"line":1447,"kind":12,"containerName":"next_result","name":"_readline"},{"name":"$last","containerName":"next_result","kind":13,"line":1449},{"line":1453,"name":"$self","kind":13,"containerName":"next_result"},{"line":1453,"kind":12,"containerName":"next_result","name":"element"},{"line":1461,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"element","line":1461},{"containerName":"next_result","kind":13,"name":"$self","line":1474},{"line":1474,"name":"element","containerName":"next_result","kind":12},{"line":1482,"containerName":"next_result","kind":13,"name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":1482},{"definition":"my","line":1495,"kind":13,"localvar":"my","containerName":"next_result","name":"$cputype"},{"kind":13,"containerName":"next_result","name":"$self","line":1496},{"containerName":"next_result","kind":12,"name":"element","line":1496},{"name":"$self","kind":13,"containerName":"next_result","line":1502},{"line":1502,"kind":12,"containerName":"next_result","name":"element"},{"definition":"my","line":1510,"localvar":"my","kind":13,"containerName":"next_result","name":"$junk"},{"line":1510,"kind":13,"containerName":"next_result","name":"$start"},{"line":1510,"name":"$stime","containerName":"next_result","kind":13},{"line":1510,"kind":13,"containerName":"next_result","name":"$end"},{"name":"$etime","containerName":"next_result","kind":13,"line":1510},{"line":1512,"containerName":"next_result","kind":13,"name":"$stime"},{"line":1513,"name":"$self","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"element","line":1513},{"kind":13,"containerName":"next_result","name":"$stime","line":1517},{"line":1519,"containerName":"next_result","kind":13,"name":"$etime"},{"kind":13,"containerName":"next_result","name":"$self","line":1520},{"line":1520,"kind":12,"containerName":"next_result","name":"element"},{"line":1524,"name":"$etime","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$self","line":1528},{"kind":12,"containerName":"next_result","name":"element","line":1528},{"definition":"my","localvar":"my","containerName":"next_result","kind":13,"name":"$d","line":1537},{"line":1538,"name":"$d","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$self","line":1539},{"line":1539,"kind":12,"containerName":"next_result","name":"element"},{"name":"$d","kind":13,"containerName":"next_result","line":1543},{"containerName":"next_result","kind":13,"name":"$blast","line":1547},{"line":1550,"containerName":"next_result","kind":13,"name":"$self"},{"line":1550,"kind":12,"containerName":"next_result","name":"element"},{"line":1558,"kind":13,"containerName":"next_result","name":"$gapped_stats"},{"name":"$self","containerName":"next_result","kind":13,"line":1561},{"name":"_readline","containerName":"next_result","kind":12,"line":1561},{"definition":"my","line":1563,"name":"$lambda","localvar":"my","containerName":"next_result","kind":13},{"line":1563,"name":"$kappa","containerName":"next_result","kind":13},{"line":1563,"name":"$entropy","containerName":"next_result","kind":13},{"name":"$gapped_stats","containerName":"next_result","kind":13,"line":1564},{"name":"$self","containerName":"next_result","kind":13,"line":1565},{"line":1565,"name":"element","containerName":"next_result","kind":12},{"line":1569,"name":"$lambda","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$self","line":1571},{"line":1571,"name":"element","kind":12,"containerName":"next_result"},{"name":"$kappa","containerName":"next_result","kind":13,"line":1575},{"name":"$self","kind":13,"containerName":"next_result","line":1577},{"line":1577,"name":"element","kind":12,"containerName":"next_result"},{"line":1581,"name":"$entropy","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$self","line":1585},{"containerName":"next_result","kind":12,"name":"element","line":1585},{"containerName":"next_result","kind":13,"name":"$lambda","line":1589},{"name":"$self","kind":13,"containerName":"next_result","line":1591},{"line":1591,"containerName":"next_result","kind":12,"name":"element"},{"line":1595,"name":"$kappa","kind":13,"containerName":"next_result"},{"line":1597,"name":"$self","kind":13,"containerName":"next_result"},{"name":"element","containerName":"next_result","kind":12,"line":1597},{"line":1601,"name":"$entropy","kind":13,"containerName":"next_result"},{"line":1606,"name":"$self","kind":13,"containerName":"next_result"},{"line":1606,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","kind":13,"name":"$self","line":1614},{"containerName":"next_result","kind":12,"name":"element","line":1614},{"containerName":"next_result","kind":13,"name":"$self","line":1626},{"line":1626,"name":"element","containerName":"next_result","kind":12},{"line":1632,"containerName":"next_result","kind":13,"name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":1632},{"name":"$self","kind":13,"containerName":"next_result","line":1640},{"kind":12,"containerName":"next_result","name":"element","line":1640},{"containerName":"next_result","localvar":"my","kind":13,"name":"$c","line":1648,"definition":"my"},{"line":1649,"kind":13,"containerName":"next_result","name":"$c"},{"line":1650,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":12,"name":"element","line":1650},{"name":"$c","kind":13,"containerName":"next_result","line":1654},{"name":"$c","containerName":"next_result","localvar":"my","kind":13,"line":1658,"definition":"my"},{"name":"$c","containerName":"next_result","kind":13,"line":1659},{"containerName":"next_result","kind":13,"name":"$self","line":1660},{"line":1660,"containerName":"next_result","kind":12,"name":"element"},{"line":1664,"containerName":"next_result","kind":13,"name":"$c"},{"definition":"my","name":"$v","localvar":"my","kind":13,"containerName":"next_result","line":1671},{"name":"$v","kind":13,"containerName":"next_result","line":1672},{"line":1673,"name":"$self","kind":13,"containerName":"next_result"},{"line":1673,"kind":12,"containerName":"next_result","name":"element"},{"name":"$v","containerName":"next_result","kind":13,"line":1677},{"line":1680,"name":"$self","kind":13,"containerName":"next_result"},{"line":1680,"name":"element","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":1693},{"line":1693,"kind":12,"containerName":"next_result","name":"element"},{"line":1699,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":1699},{"kind":13,"containerName":"next_result","name":"$self","line":1707},{"name":"element","containerName":"next_result","kind":12,"line":1707},{"name":"$self","containerName":"next_result","kind":13,"line":1715},{"name":"element","kind":12,"containerName":"next_result","line":1715},{"line":1727,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"element","line":1727},{"line":1739,"containerName":"next_result","kind":13,"name":"$self"},{"line":1739,"containerName":"next_result","kind":12,"name":"element"},{"containerName":"next_result","kind":13,"name":"$self","line":1745},{"name":"element","containerName":"next_result","kind":12,"line":1745},{"definition":"my","name":"$d","localvar":"my","containerName":"next_result","kind":13,"line":1753},{"name":"$d","containerName":"next_result","kind":13,"line":1754},{"containerName":"next_result","kind":13,"name":"$self","line":1755},{"name":"element","containerName":"next_result","kind":12,"line":1755},{"containerName":"next_result","kind":13,"name":"$d","line":1759},{"line":1766,"name":"$last","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$self","line":1768},{"line":1768,"name":"in_element","kind":12,"containerName":"next_result"},{"line":1769,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"debug","line":1769},{"line":1772,"kind":13,"containerName":"next_result","name":"$self"},{"line":1772,"containerName":"next_result","kind":13,"name":"$DEFAULTREPORTTYPE"},{"definition":"my","name":"%data","containerName":"next_result","localvar":"my","kind":13,"line":1773},{"line":1778,"name":"$len","containerName":"next_result","localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"$i","localvar":"my","kind":13,"containerName":"next_result","line":1779},{"line":1779,"kind":13,"containerName":"next_result","name":"$i"},{"line":1779,"kind":13,"containerName":"next_result","name":"$i"},{"name":"$i","kind":13,"containerName":"next_result","line":1781},{"containerName":"next_result","kind":13,"name":"$self","line":1784},{"line":1784,"name":"_pushback","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":1785},{"line":1785,"name":"end_element","containerName":"next_result","kind":12},{"definition":"my","line":1790,"containerName":"next_result","localvar":"my","kind":13,"name":"$full"},{"name":"$type","kind":13,"containerName":"next_result","line":1790},{"name":"$start","kind":13,"containerName":"next_result","line":1790},{"name":"$str","containerName":"next_result","kind":13,"line":1790},{"line":1790,"kind":13,"containerName":"next_result","name":"$end"},{"name":"$str","kind":13,"containerName":"next_result","line":1793},{"line":1794,"name":"$i","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$type","line":1794},{"kind":13,"containerName":"next_result","name":"$data","line":1797},{"containerName":"next_result","kind":13,"name":"$type","line":1797},{"line":1797,"name":"$str","kind":13,"containerName":"next_result"},{"name":"$len","containerName":"next_result","kind":13,"line":1799},{"name":"$full","containerName":"next_result","kind":13,"line":1799},{"containerName":"next_result","kind":13,"name":"$self","line":1800},{"name":"$start","containerName":"next_result","kind":13,"line":1801},{"kind":13,"containerName":"next_result","name":"$self","line":1801},{"containerName":"next_result","kind":13,"name":"$self","line":1802},{"line":1802,"kind":13,"containerName":"next_result","name":"$end"},{"name":"$self","kind":13,"containerName":"next_result","line":1804},{"line":1804,"name":"throw","kind":12,"containerName":"next_result"},{"line":1805,"containerName":"next_result","kind":13,"name":"$len"},{"line":1806,"name":"$data","kind":13,"containerName":"next_result"},{"name":"$len","containerName":"next_result","kind":13,"line":1806},{"name":"$self","containerName":"next_result","kind":13,"line":1808},{"line":1808,"kind":12,"containerName":"next_result","name":"_readline"},{"line":1810,"kind":13,"containerName":"next_result","name":"$self"},{"line":1810,"kind":12,"containerName":"next_result","name":"characters"},{"line":1813,"name":"$data","kind":13,"containerName":"next_result"},{"line":1816,"name":"$self","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"characters","line":1816},{"line":1819,"name":"$data","kind":13,"containerName":"next_result"},{"line":1822,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":12,"name":"characters","line":1822},{"line":1825,"containerName":"next_result","kind":13,"name":"$data"},{"name":"$self","containerName":"next_result","kind":13,"line":1834},{"line":1834,"containerName":"next_result","kind":12,"name":"debug"},{"line":1835,"containerName":"next_result","kind":13,"name":"$self"},{"line":1836,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"within_element","line":1836},{"line":1837,"name":"$self","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"end_element","line":1837},{"line":1838,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"within_element","line":1838},{"line":1839,"kind":13,"containerName":"next_result","name":"$self"},{"line":1839,"containerName":"next_result","kind":12,"name":"end_element"},{"kind":13,"containerName":"next_result","name":"$self","line":1841},{"kind":12,"containerName":"next_result","name":"_cleanup_hits","line":1841},{"name":"@hit_signifs","containerName":"next_result","kind":13,"line":1841},{"name":"@hit_signifs","kind":13,"containerName":"next_result","line":1841},{"line":1842,"name":"$self","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"within_element","line":1842},{"name":"$self","kind":13,"containerName":"next_result","line":1843},{"line":1843,"name":"end_element","containerName":"next_result","kind":12},{"line":1844,"name":"$bl2seq_fix","kind":13,"containerName":"next_result"},{"line":1845,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":1845},{"kind":13,"containerName":"next_result","name":"$reporttype","line":1849},{"name":"$self","kind":13,"containerName":"next_result","line":1852},{"line":1852,"name":"end_element","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$self","line":1854},{"line":1854,"containerName":"next_result","kind":12,"name":"end_document"}],"name":"next_result","containerName":"main::"},{"name":"PARSER","kind":12,"line":458},{"kind":12,"name":"PARSER","line":478},{"name":"PARSER","kind":12,"line":531},{"name":"DESCLINE","kind":12,"line":649},{"name":"DESCLINE","kind":12,"line":652},{"line":653,"name":"DESCLINE","kind":12},{"name":"DESCLINE","kind":12,"line":697},{"kind":12,"name":"HITTABLE","line":829},{"line":834,"name":"HITTABLE","kind":12},{"name":"HITTABLE","kind":12,"line":836},{"line":1226,"kind":12,"name":"PARSER"},{"line":1858,"range":{"start":{"character":0,"line":1858},"end":{"line":1864,"character":9999}},"kind":12,"definition":"sub","children":[{"line":1859,"containerName":"_start_blastoutput","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"_start_blastoutput","line":1860},{"line":1860,"kind":12,"containerName":"_start_blastoutput","name":"start_element"},{"line":1861,"name":"$self","containerName":"_start_blastoutput","kind":13},{"line":1862,"name":"$self","kind":13,"containerName":"_start_blastoutput"},{"line":1863,"kind":13,"containerName":"_start_blastoutput","name":"$self"}],"containerName":"main::","name":"_start_blastoutput"},{"kind":12,"range":{"start":{"character":0,"line":1904},"end":{"line":1914,"character":9999}},"line":1904,"signature":{"label":"_will_handle($self,$type)","documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().","parameters":[{"label":"$self"},{"label":"$type"}]},"name":"_will_handle","containerName":"main::","children":[{"line":1905,"localvar":"my","containerName":"_will_handle","kind":13,"name":"$self","definition":"my"},{"name":"$type","containerName":"_will_handle","kind":13,"line":1905},{"definition":"my","line":1906,"kind":13,"localvar":"my","containerName":"_will_handle","name":"$handler"},{"containerName":"_will_handle","kind":13,"name":"$self","line":1906},{"definition":"my","name":"$will_handle","localvar":"my","kind":13,"containerName":"_will_handle","line":1907},{"containerName":"_will_handle","kind":13,"name":"$self","line":1908},{"name":"$type","kind":13,"containerName":"_will_handle","line":1908},{"name":"$self","kind":13,"containerName":"_will_handle","line":1909},{"line":1909,"kind":13,"containerName":"_will_handle","name":"$type"},{"kind":13,"containerName":"_will_handle","name":"$self","line":1910},{"line":1910,"containerName":"_will_handle","kind":13,"name":"$type"},{"line":1911,"name":"$handler","containerName":"_will_handle","kind":13},{"name":"will_handle","kind":12,"containerName":"_will_handle","line":1911},{"kind":13,"containerName":"_will_handle","name":"$type","line":1911},{"line":1913,"name":"$will_handle","containerName":"_will_handle","kind":13},{"line":1913,"name":"$handler","containerName":"_will_handle","kind":13}],"detail":"($self,$type)","definition":"sub"},{"children":[{"line":1927,"localvar":"my","containerName":"start_element","kind":13,"name":"$self","definition":"my"},{"line":1927,"name":"$data","containerName":"start_element","kind":13},{"definition":"my","name":"$nm","containerName":"start_element","localvar":"my","kind":13,"line":1930},{"name":"$data","containerName":"start_element","kind":13,"line":1930},{"line":1931,"localvar":"my","containerName":"start_element","kind":13,"name":"$type","definition":"my"},{"name":"$MODEMAP","containerName":"start_element","kind":13,"line":1931},{"kind":13,"containerName":"start_element","name":"$nm","line":1931},{"kind":13,"containerName":"start_element","name":"$type","line":1932},{"definition":"my","name":"$handler","localvar":"my","kind":13,"containerName":"start_element","line":1933},{"line":1933,"kind":13,"containerName":"start_element","name":"$self"},{"name":"_will_handle","kind":12,"containerName":"start_element","line":1933},{"line":1933,"name":"$type","kind":13,"containerName":"start_element"},{"name":"$handler","kind":13,"containerName":"start_element","line":1934},{"localvar":"my","containerName":"start_element","kind":13,"name":"$func","line":1935,"definition":"my"},{"line":1935,"containerName":"start_element","kind":13,"name":"$type"},{"line":1936,"name":"$self","kind":13,"containerName":"start_element"},{"name":"$handler","containerName":"start_element","kind":13,"line":1936},{"line":1936,"containerName":"start_element","kind":13,"name":"$func"},{"kind":13,"containerName":"start_element","name":"$data","line":1936},{"line":1944,"name":"$self","containerName":"start_element","kind":13},{"name":"$type","containerName":"start_element","kind":13,"line":1944},{"line":1945,"name":"$type","kind":13,"containerName":"start_element"},{"name":"$self","containerName":"start_element","kind":13,"line":1946},{"line":1947,"containerName":"start_element","kind":13,"name":"$self"},{"line":1950,"kind":13,"containerName":"start_element","name":"$self"},{"line":1951,"localvar":"my","containerName":"start_element","kind":13,"name":"$k","definition":"my"},{"containerName":"start_element","kind":13,"name":"$self","line":1953},{"line":1956,"containerName":"start_element","kind":13,"name":"$self"},{"kind":13,"containerName":"start_element","name":"$k","line":1956}],"containerName":"main::","name":"start_element","definition":"sub","detail":"($self,$data)","line":1926,"range":{"end":{"character":9999,"line":1959},"start":{"character":0,"line":1926}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"start_element($self,$data)"}},{"kind":12,"range":{"end":{"line":2036,"character":9999},"start":{"line":1974,"character":0}},"line":1974,"signature":{"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"end_element($self,$data)"},"name":"end_element","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"end_element","kind":13,"line":1975},{"line":1975,"name":"$data","containerName":"end_element","kind":13},{"definition":"my","line":1977,"localvar":"my","kind":13,"containerName":"end_element","name":"$nm"},{"name":"$data","kind":13,"containerName":"end_element","line":1977},{"definition":"my","name":"$type","localvar":"my","containerName":"end_element","kind":13,"line":1978},{"localvar":"my","kind":13,"containerName":"end_element","name":"$rc","line":1979,"definition":"my"},{"line":1980,"name":"$nm","containerName":"end_element","kind":13},{"name":"$self","containerName":"end_element","kind":13,"line":1981},{"line":1982,"containerName":"end_element","kind":13,"name":"$self"},{"line":1984,"containerName":"end_element","kind":13,"name":"$self"},{"name":"$DEFAULTREPORTTYPE","containerName":"end_element","kind":13,"line":1984},{"kind":13,"containerName":"end_element","name":"$nm","line":1989},{"containerName":"end_element","kind":13,"name":"$self","line":1991},{"kind":12,"containerName":"end_element","name":"element","line":1991},{"name":"$self","kind":13,"containerName":"end_element","line":1994},{"line":1996,"name":"$self","kind":13,"containerName":"end_element"},{"line":1998,"name":"$self","containerName":"end_element","kind":13},{"kind":13,"containerName":"end_element","name":"$self","line":1999},{"name":"element","containerName":"end_element","kind":12,"line":1999},{"line":2002,"name":"$self","kind":13,"containerName":"end_element"},{"line":2005,"name":"$self","kind":13,"containerName":"end_element"},{"line":2005,"name":"element","containerName":"end_element","kind":12},{"containerName":"end_element","kind":13,"name":"$self","line":2008},{"kind":13,"containerName":"end_element","name":"$self","line":2012},{"name":"element","containerName":"end_element","kind":12,"line":2012},{"name":"$self","containerName":"end_element","kind":13,"line":2015},{"name":"$self","containerName":"end_element","kind":13,"line":2018},{"line":2018,"name":"element","kind":12,"containerName":"end_element"},{"line":2021,"name":"$self","kind":13,"containerName":"end_element"},{"name":"$type","containerName":"end_element","kind":13,"line":2028},{"kind":13,"containerName":"end_element","name":"$MODEMAP","line":2028},{"line":2028,"name":"$nm","kind":13,"containerName":"end_element"},{"definition":"my","line":2029,"localvar":"my","containerName":"end_element","kind":13,"name":"$handler"},{"containerName":"end_element","kind":13,"name":"$self","line":2029},{"containerName":"end_element","kind":12,"name":"_will_handle","line":2029},{"kind":13,"containerName":"end_element","name":"$type","line":2029},{"line":2030,"name":"$handler","containerName":"end_element","kind":13},{"name":"$func","containerName":"end_element","localvar":"my","kind":13,"line":2031,"definition":"my"},{"kind":13,"containerName":"end_element","name":"$type","line":2031},{"containerName":"end_element","kind":13,"name":"$rc","line":2032},{"line":2032,"kind":13,"containerName":"end_element","name":"$handler"},{"containerName":"end_element","kind":13,"name":"$func","line":2032},{"containerName":"end_element","kind":13,"name":"$self","line":2032},{"name":"$self","containerName":"end_element","kind":13,"line":2032},{"line":2034,"containerName":"end_element","kind":13,"name":"$self"}],"detail":"($self,$data)","definition":"sub"},{"line":2037,"containerName":null,"kind":13,"name":"%MAPPING"},{"name":"%nm","kind":13,"containerName":null,"line":2037},{"line":2038,"name":"%MAPPING","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%nm","line":2038},{"line":2042,"containerName":null,"localvar":"my","kind":13,"name":"$key","definition":"my"},{"name":"%MAPPING","containerName":null,"kind":13,"line":2042},{"name":"@nm","kind":13,"containerName":null,"line":2042},{"containerName":null,"kind":13,"name":"%self","line":2043},{"kind":13,"containerName":null,"name":"%key","line":2043},{"name":"%MAPPING","kind":13,"containerName":null,"line":2043},{"containerName":null,"kind":13,"name":"%nm","line":2043},{"line":2043,"containerName":null,"kind":13,"name":"$key"},{"name":"%self","kind":13,"containerName":null,"line":2044},{"line":2047,"name":"%self","containerName":null,"kind":13},{"line":2047,"name":"%MAPPING","kind":13,"containerName":null},{"name":"$nm","kind":13,"containerName":null,"line":2047},{"containerName":null,"kind":13,"name":"%self","line":2047},{"line":2053,"name":"%self","kind":13,"containerName":null},{"name":"%self","containerName":null,"kind":13,"line":2055},{"name":"$rc","containerName":null,"kind":13,"line":2055},{"line":2055,"name":"$type","kind":13,"containerName":null},{"line":2055,"name":"$type","containerName":null,"kind":13},{"name":"$rc","containerName":null,"kind":13,"line":2056},{"line":2070,"range":{"end":{"character":9999,"line":2077},"start":{"character":0,"line":2070}},"kind":12,"signature":{"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    \n    my $nm   = $data->{'Name'};\n    my $type;\n    my $rc;\n    if ( $nm eq 'BlastOutput_program' ) {\n        if ( $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n        $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n    }\n\n    # Hsps are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq Hsp_features)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            ) if defined $self->{'_last_hspdata'}->{$_};\n        }\n        $self->{'_last_hspdata'} = {};\n        $self->element(\n            {\n                'Name' => 'Hsp_query-from',\n                'Data' => $self->{'_Query'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_query-to',\n                'Data' => $self->{'_Query'}->{'end'}\n            }\n        );\n\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $self->{'_Sbjct'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $self->{'_Sbjct'}->{'end'}\n            }\n        );\n\n        #    } elsif( $nm eq 'Iteration' ) {\n        # Nothing special needs to be done here.\n    }\n    if ( $type = $MODEMAP{$nm} ) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n\n            # this is where we shove in the data from the\n            # hashref info about params or statistics\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        #$self->debug(\"blast.pm: unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"element($self,$data)"},"children":[{"line":2071,"name":"$self","localvar":"my","containerName":"element","kind":13,"definition":"my"},{"line":2071,"name":"$data","kind":13,"containerName":"element"},{"containerName":"element","kind":13,"name":"$self","line":2075},{"kind":12,"containerName":"element","name":"characters","line":2075},{"line":2075,"containerName":"element","kind":13,"name":"$data"},{"line":2076,"name":"$self","kind":13,"containerName":"element"},{"name":"end_element","kind":12,"containerName":"element","line":2076},{"line":2076,"name":"$data","containerName":"element","kind":13}],"name":"element","containerName":"main::","definition":"sub","detail":"($self,$data)"},{"definition":"sub","detail":"($self,$data)","children":[{"name":"$self","localvar":"my","containerName":"characters","kind":13,"line":2091,"definition":"my"},{"line":2091,"containerName":"characters","kind":13,"name":"$data"},{"name":"$self","kind":13,"containerName":"characters","line":2092},{"name":"in_element","containerName":"characters","kind":12,"line":2092},{"line":2093,"containerName":"characters","kind":13,"name":"$data"},{"name":"$self","containerName":"characters","kind":13,"line":2095},{"line":2095,"name":"$data","containerName":"characters","kind":13},{"line":2095,"name":"$data","kind":13,"containerName":"characters"},{"name":"$data","containerName":"characters","kind":13,"line":2096},{"line":2098,"name":"$data","containerName":"characters","kind":13},{"name":"$data","kind":13,"containerName":"characters","line":2098},{"name":"$self","kind":13,"containerName":"characters","line":2099},{"name":"$data","containerName":"characters","kind":13,"line":2099}],"name":"characters","containerName":"main::","signature":{"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    \n    my $nm   = $data->{'Name'};\n    my $type;\n    my $rc;\n    if ( $nm eq 'BlastOutput_program' ) {\n        if ( $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n        $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n    }\n\n    # Hsps are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq Hsp_features)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            ) if defined $self->{'_last_hspdata'}->{$_};\n        }\n        $self->{'_last_hspdata'} = {};\n        $self->element(\n            {\n                'Name' => 'Hsp_query-from',\n                'Data' => $self->{'_Query'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_query-to',\n                'Data' => $self->{'_Query'}->{'end'}\n            }\n        );\n\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $self->{'_Sbjct'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $self->{'_Sbjct'}->{'end'}\n            }\n        );\n\n        #    } elsif( $nm eq 'Iteration' ) {\n        # Nothing special needs to be done here.\n    }\n    if ( $type = $MODEMAP{$nm} ) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n\n            # this is where we shove in the data from the\n            # hashref info about params or statistics\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        #$self->debug(\"blast.pm: unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # Note that start element isn't needed for character data\n    # Not too SAX-y, though\n    #$self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}],"label":"characters($self,$data)"},"line":2090,"kind":12,"range":{"end":{"character":9999,"line":2100},"start":{"line":2090,"character":0}}},{"signature":{"label":"within_element($self,$name)","documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    \n    my $nm   = $data->{'Name'};\n    my $type;\n    my $rc;\n    if ( $nm eq 'BlastOutput_program' ) {\n        if ( $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n        $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n    }\n\n    # Hsps are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq Hsp_features)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            ) if defined $self->{'_last_hspdata'}->{$_};\n        }\n        $self->{'_last_hspdata'} = {};\n        $self->element(\n            {\n                'Name' => 'Hsp_query-from',\n                'Data' => $self->{'_Query'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_query-to',\n                'Data' => $self->{'_Query'}->{'end'}\n            }\n        );\n\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $self->{'_Sbjct'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $self->{'_Sbjct'}->{'end'}\n            }\n        );\n\n        #    } elsif( $nm eq 'Iteration' ) {\n        # Nothing special needs to be done here.\n    }\n    if ( $type = $MODEMAP{$nm} ) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n\n            # this is where we shove in the data from the\n            # hashref info about params or statistics\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        #$self->debug(\"blast.pm: unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # Note that start element isn't needed for character data\n    # Not too SAX-y, though\n    #$self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /^Hsp\\_(qseq|hseq|midline)$/ )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'}\n          if defined $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<in_element>","parameters":[{"label":"$self"},{"label":"$name"}]},"range":{"start":{"line":2116,"character":0},"end":{"character":9999,"line":2120}},"kind":12,"line":2116,"detail":"($self,$name)","definition":"sub","name":"within_element","containerName":"main::","children":[{"definition":"my","containerName":"within_element","localvar":"my","kind":13,"name":"$self","line":2117},{"line":2117,"kind":13,"containerName":"within_element","name":"$name"},{"line":2119,"kind":13,"containerName":"within_element","name":"$name"},{"name":"$self","kind":13,"containerName":"within_element","line":2119},{"line":2120,"kind":13,"containerName":"within_element","name":"$self"}]},{"containerName":null,"kind":13,"name":"%self","line":2121},{"line":2122,"containerName":null,"kind":13,"name":"%name"},{"line":2143,"range":{"end":{"character":9999,"line":2147},"start":{"line":2143,"character":0}},"kind":12,"signature":{"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    \n    my $nm   = $data->{'Name'};\n    my $type;\n    my $rc;\n    if ( $nm eq 'BlastOutput_program' ) {\n        if ( $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n        $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n    }\n\n    # Hsps are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq Hsp_features)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            ) if defined $self->{'_last_hspdata'}->{$_};\n        }\n        $self->{'_last_hspdata'} = {};\n        $self->element(\n            {\n                'Name' => 'Hsp_query-from',\n                'Data' => $self->{'_Query'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_query-to',\n                'Data' => $self->{'_Query'}->{'end'}\n            }\n        );\n\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $self->{'_Sbjct'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $self->{'_Sbjct'}->{'end'}\n            }\n        );\n\n        #    } elsif( $nm eq 'Iteration' ) {\n        # Nothing special needs to be done here.\n    }\n    if ( $type = $MODEMAP{$nm} ) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n\n            # this is where we shove in the data from the\n            # hashref info about params or statistics\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        #$self->debug(\"blast.pm: unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # Note that start element isn't needed for character data\n    # Not too SAX-y, though\n    #$self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /^Hsp\\_(qseq|hseq|midline)$/ )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'}\n          if defined $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<in_element>\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within_element' because within\n           can be tested for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<within_element>","parameters":[{"label":"$self"},{"label":"$name"}],"label":"in_element($self,$name)"},"children":[{"definition":"my","line":2144,"containerName":"in_element","localvar":"my","kind":13,"name":"$self"},{"line":2144,"name":"$name","kind":13,"containerName":"in_element"},{"containerName":"in_element","kind":13,"name":"$self","line":2145},{"line":2146,"name":"$self","kind":13,"containerName":"in_element"},{"containerName":"in_element","kind":13,"name":"$name","line":2146}],"name":"in_element","containerName":"main::","definition":"sub","detail":"($self,$name)"},{"signature":{"label":"start_document($self)","documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    \n    my $nm   = $data->{'Name'};\n    my $type;\n    my $rc;\n    if ( $nm eq 'BlastOutput_program' ) {\n        if ( $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n        $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n    }\n\n    # Hsps are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq Hsp_features)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            ) if defined $self->{'_last_hspdata'}->{$_};\n        }\n        $self->{'_last_hspdata'} = {};\n        $self->element(\n            {\n                'Name' => 'Hsp_query-from',\n                'Data' => $self->{'_Query'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_query-to',\n                'Data' => $self->{'_Query'}->{'end'}\n            }\n        );\n\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $self->{'_Sbjct'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $self->{'_Sbjct'}->{'end'}\n            }\n        );\n\n        #    } elsif( $nm eq 'Iteration' ) {\n        # Nothing special needs to be done here.\n    }\n    if ( $type = $MODEMAP{$nm} ) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n\n            # this is where we shove in the data from the\n            # hashref info about params or statistics\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        #$self->debug(\"blast.pm: unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # Note that start element isn't needed for character data\n    # Not too SAX-y, though\n    #$self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /^Hsp\\_(qseq|hseq|midline)$/ )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'}\n          if defined $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<in_element>\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within_element' because within\n           can be tested for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<within_element>\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none","parameters":[{"label":"$self"}]},"line":2160,"kind":12,"range":{"start":{"line":2160,"character":0},"end":{"character":9999,"line":2166}},"definition":"sub","detail":"($self)","children":[{"definition":"my","line":2161,"name":"$self","kind":13,"localvar":"my","containerName":"start_document"},{"line":2162,"kind":13,"containerName":"start_document","name":"$self"},{"line":2163,"name":"$self","kind":13,"containerName":"start_document"},{"line":2164,"kind":13,"containerName":"start_document","name":"$self"},{"line":2165,"containerName":"start_document","kind":13,"name":"$self"}],"name":"start_document","containerName":"main::"},{"children":[{"line":2180,"localvar":"my","kind":13,"containerName":"end_document","name":"$self","definition":"my"},{"line":2180,"name":"@args","containerName":"end_document","kind":13},{"line":2183,"kind":13,"containerName":"end_document","name":"$self"}],"name":"end_document","containerName":"main::","definition":"sub","detail":"($self,@args)","line":2179,"kind":12,"range":{"start":{"line":2179,"character":0},"end":{"character":9999,"line":2184}},"signature":{"label":"end_document($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"(Sesame Street aficionados note: This answer was NOT given by Mr. Noodle ;-P)\n# $Id: blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n# 20030409 - sac\n#          PSI-BLAST full parsing support. Rollout of new\n#          model which will remove Steve's old psiblast driver\n# 20030424 - jason\n#          Megablast parsing fix as reported by Neil Saunders\n# 20030427 - jason\n#          Support bl2seq parsing\n# 20031124 - jason\n#          Parse more blast statistics, lambda, entropy, etc\n#          from WU-BLAST in frame-specific manner\n# 20060216 - cjf - fixed blast parsing for BLAST v2.2.13 output\n# 20071104 - dmessina - added support for WUBLAST -echofilter\n# 20071121 - cjf - fixed several bugs (bugs 2391, 2399, 2409)\n\n=head1 NAME\n\nBio::SearchIO::blast - Event generator for event based parsing of\nblast reports\n\n=head1 SYNOPSIS\n\n   # Do not use this object directly - it is used as part of the\n   # Bio::SearchIO system.\n\n    use Bio::SearchIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast',\n                                     -file   => 't/data/ecolitst.bls');\n    while( my $result = $searchio->next_result ) {\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object encapsulated the necessary methods for generating events\nsuitable for building Bio::Search objects from a BLAST report file.\nRead the L<Bio::SearchIO> for more information about how to use this.\n\nThis driver can parse:\n\n=over 4\n\n* * \n\nNCBI produced plain text BLAST reports from blastall, this also\nincludes PSIBLAST, PSITBLASTN, RPSBLAST, and bl2seq reports.  NCBI XML\nBLAST output is parsed with the blastxml SearchIO driver\n\n* *\n\nWU-BLAST all reports\n\n* *\n\nJim Kent's BLAST-like output from his programs (BLASTZ, BLAT)\n\n* *\n\nBLAST-like output from Paracel BTK output\n\n\n=head2 bl2seq parsing\n\nSince I cannot differentiate between BLASTX and TBLASTN since bl2seq\ndoesn't report the algorithm used - I assume it is BLASTX by default -\nyou can supply the program type with -report_type in the SearchIO\nconstructor i.e.\n\n  my $parser = Bio::SearchIO->new(-format => 'blast',\n                                 -file => 'bl2seq.tblastn.report',\n                                 -report_type => 'tblastn');\n\nThis only really affects where the frame and strand information are\nput - they will always be on the $hsp-E<gt>query instead of on the\n$hsp-E<gt>hit part of the feature pair for blastx and tblastn bl2seq\nproduced reports.  Hope that's clear...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSteve Chervitz sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...'\n\npackage Bio::SearchIO::blast;\n\nuse Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP\n  $DEFAULT_BLAST_WRITER_CLASS\n  $MAX_HSP_OVERLAP\n  $DEFAULT_SIGNIF\n  $DEFAULT_SCORE\n  $DEFAULTREPORTTYPE\n);\n\n\nuse base qw(Bio::SearchIO);\nuse Data::Dumper;\n\nBEGIN {\n\n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = (\n        'BlastOutput' => 'result',\n        'Iteration'   => 'iteration',\n        'Hit'         => 'hit',\n        'Hsp'         => 'hsp'\n    );\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING = (\n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue',\n        'Hsp_n',          => 'HSP-n',\n        'Hsp_pvalue'      => 'HSP-pvalue',\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start',\n        'Hsp_hit-to'      => 'HSP-hit_end',\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n        'Hsp_gaps'        => 'HSP-hsp_gaps',\n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_query-frame' => 'HSP-query_frame',\n        'Hsp_hit-frame'   => 'HSP-hit_frame',\n        'Hsp_links'       => 'HSP-links',\n        'Hsp_group'       => 'HSP-hsp_group',\n        'Hsp_features'    => 'HSP-hit_features',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance',\n        # For NCBI blast, the description line contains bits.\n        # For WU-blast, the  description line contains score.\n        'Hit_score' => 'HIT-score',\n        'Hit_bits'  => 'HIT-bits',\n\n        'Iteration_iter-num'  => 'ITERATION-number',\n        'Iteration_converged' => 'ITERATION-converged',\n\n        'BlastOutput_program'             => 'RESULT-algorithm_name',\n        'BlastOutput_version'             => 'RESULT-algorithm_version',\n        'BlastOutput_query-def'           => 'RESULT-query_name',\n        'BlastOutput_query-len'           => 'RESULT-query_length',\n        'BlastOutput_query-acc'           => 'RESULT-query_accession',\n        'BlastOutput_query-gi'            => 'RESULT-query_gi',\n        'BlastOutput_querydesc'           => 'RESULT-query_description',\n        'BlastOutput_db'                  => 'RESULT-database_name',\n        'BlastOutput_db-len'              => 'RESULT-database_entries',\n        'BlastOutput_db-let'              => 'RESULT-database_letters',\n        'BlastOutput_inclusion-threshold' => 'RESULT-inclusion_threshold',\n\n        'Parameters_matrix'      => { 'RESULT-parameters' => 'matrix' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },\n        'Statistics_db-len'      => { 'RESULT-statistics' => 'dbentries' },\n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n        'Statistics_hsp-len'     =>\n          { 'RESULT-statistics' => 'effective_hsplength' },\n        'Statistics_query-len' => { 'RESULT-statistics' => 'querylength' },\n        'Statistics_eff-space' => { 'RESULT-statistics' => 'effectivespace' },\n        'Statistics_eff-spaceused' =>\n          { 'RESULT-statistics' => 'effectivespaceused' },\n        'Statistics_eff-dblen' =>\n          { 'RESULT-statistics' => 'effectivedblength' },\n        'Statistics_kappa'         => { 'RESULT-statistics' => 'kappa' },\n        'Statistics_lambda'        => { 'RESULT-statistics' => 'lambda' },\n        'Statistics_entropy'       => { 'RESULT-statistics' => 'entropy' },\n        'Statistics_gapped_kappa'  => { 'RESULT-statistics' => 'kappa_gapped' },\n        'Statistics_gapped_lambda' =>\n          { 'RESULT-statistics' => 'lambda_gapped' },\n        'Statistics_gapped_entropy' =>\n          { 'RESULT-statistics' => 'entropy_gapped' },\n\n        'Statistics_framewindow' =>\n          { 'RESULT-statistics' => 'frameshiftwindow' },\n        'Statistics_decay' => { 'RESULT-statistics' => 'decayconst' },\n\n        'Statistics_hit_to_db' => { 'RESULT-statistics' => 'Hits_to_DB' },\n        'Statistics_num_suc_extensions' =>\n          { 'RESULT-statistics' => 'num_successful_extensions' },\n\n        # WU-BLAST stats\n        'Statistics_DFA_states' => { 'RESULT-statistics' => 'num_dfa_states' },\n        'Statistics_DFA_size'   => { 'RESULT-statistics' => 'dfa_size' },\n        'Statistics_noprocessors' =>\n          { 'RESULT-statistics' => 'no_of_processors' },\n        'Statistics_neighbortime' =>\n          { 'RESULT-statistics' => 'neighborhood_generate_time' },\n        'Statistics_starttime' => { 'RESULT-statistics' => 'start_time' },\n        'Statistics_endtime'   => { 'RESULT-statistics' => 'end_time' },\n    );\n\n    # add WU-BLAST Frame-Based Statistics\n    for my $frame ( 0 .. 3 ) {\n        for my $strand ( '+', '-' ) {\n            for my $ind (\n                qw(length efflength E S W T X X_gapped E2\n                E2_gapped S2)\n              )\n            {\n                $MAPPING{\"Statistics_frame$strand$frame\\_$ind\"} =\n                  { 'RESULT-statistics' => \"Frame$strand$frame\\_$ind\" };\n            }\n            for my $val (qw(lambda kappa entropy )) {\n                for my $type (qw(used computed gapped)) {\n                    my $key = \"Statistics_frame$strand$frame\\_$val\\_$type\";\n                    my $val =\n                      { 'RESULT-statistics' =>\n                          \"Frame$strand$frame\\_$val\\_$type\" };\n                    $MAPPING{$key} = $val;\n                }\n            }\n        }\n    }\n\n    # add Statistics\n    for my $stats (\n        qw(T A X1 X2 X3 S1 S2 X1_bits X2_bits X3_bits\n        S1_bits S2_bits  num_extensions\n        num_successful_extensions\n        seqs_better_than_cutoff\n        posted_date\n        search_cputime total_cputime\n        search_actualtime total_actualtime\n        no_of_processors ctxfactor)\n      )\n    {\n        my $key = \"Statistics_$stats\";\n        my $val = { 'RESULT-statistics' => $stats };\n        $MAPPING{$key} = $val;\n    }\n\n    # add WU-BLAST Parameters\n    for my $param (\n        qw(span span1 span2 links warnings notes hspsepsmax\n        hspsepqmax topcomboN topcomboE postsw cpus wordmask\n        filter sort_by_pvalue sort_by_count sort_by_highscore\n        sort_by_totalscore sort_by_subjectlength noseqs gi qtype\n        qres V B Z Y M N)\n      )\n    {\n        my $key = \"Parameters_$param\";\n        my $val = { 'RESULT-parameters' => $param };\n        $MAPPING{$key} = $val;\n    }\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n    $MAX_HSP_OVERLAP   = 2;           # Used when tiling multiple HSPs.\n    $DEFAULTREPORTTYPE = 'BLASTP';    # for bl2seq\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new(%args);\n Function: Builds a new Bio::SearchIO::blast object \n Returns : Bio::SearchIO::blast\n Args    : Key-value pairs:\n           -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n           -report_type => 'blastx', 'tblastn', etc -- only for bl2seq\n                           reports when you want to distinguish between\n                           tblastn and blastx reports (this only controls\n                           where the frame information is put - on the query\n                           or subject object.\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n                           All hits of each BLAST report must satisfy \n                           this criteria to be retained. \n                           If a hit fails this test, it is ignored.\n                           This function should take a\n                           Bio::Search::Hit::BlastHit.pm object as its first\n                           argument and return true\n                           if the hit should be retained.\n                           Sample filter function:\n                              -hit_filter => sub { $hit = shift;\n                                                   $hit->gaps == 0; },\n                           (Note: -filt_func is synonymous with -hit_filter)\n           -overlap     => integer. The amount of overlap to permit between\n                           adjacent HSPs when tiling HSPs. A reasonable value is 2.\n                           Default = $Bio::SearchIO::blast::MAX_HSP_OVERLAP.\n\n            The following criteria are not yet supported:\n            (these are probably best applied within this module rather than in the \n             event handler since they would permit the parser to take some shortcuts.)\n\n           -check_all_hits => boolean. Check all hits for significance against\n                              significance criteria.  Default = false.\n                              If false, stops processing hits after the first\n                              non-significant hit or the first hit that fails\n                              the hit_filter call. This speeds parsing,\n                              taking advantage of the fact that the hits\n                              are processed in the order they appear in the report.\n           -min_query_len => integer to be used as a minimum for query sequence length.\n                             Reports with query sequences below this length will\n                             not be processed. Default = no minimum length.\n           -best        => boolean. Only process the best hit of each report;\n                           default = false.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n\n    # Blast reports require a specialized version of the SREB due to the\n    # possibility of iterations (PSI-BLAST). Forwarding all arguments to it. An\n    # issue here is that we want to set new default object factories if none are\n    # supplied.\n\n    my $handler = Bio::SearchIO::IteratedSearchResultEventBuilder->new(@args);\n    $self->attach_EventHandler($handler);\n    \n    # 2006-04-26 move this to the attach_handler function in this module so we\n    # can really reset the handler \n    # Optimization: caching\n    # the EventHandler since it is used a lot during the parse.\n    \n    # $self->{'_handler_cache'} = $handler;\n\n    my ( $min_qlen, $check_all, $overlap, $best, $rpttype ) = $self->_rearrange(\n        [\n            qw(MIN_LENGTH CHECK_ALL_HITS\n              OVERLAP BEST\n              REPORT_TYPE)\n        ],\n        @args\n    );\n\n    defined $min_qlen  && $self->min_query_length($min_qlen);\n    defined $best      && $self->best_hit_only($best);\n    defined $check_all && $self->check_all_hits($check_all);\n    defined $rpttype   && ( $self->{'_reporttype'} = $rpttype );\n}\n\nsub attach_EventHandler {\n    my ($self,$handler) = @_;\n\n    $self->SUPER::attach_EventHandler($handler);    \n\n    # Optimization: caching the EventHandler since it is used a lot\n    # during the parse.\n\n    $self->{'_handler_cache'} = $handler;\n    return;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $v      = $self->verbose;\n    my $data   = '';\n    my $flavor = '';\n    $self->{'_seentop'} = 0;     # start next report at top\n    $self->{'_seentop'} = 0;\n    my ( $reporttype, $seenquery, $reportline );  \n    my ( $seeniteration, $found_again );\n    my $incl_threshold = $self->inclusion_threshold;\n    my $bl2seq_fix;\n    $self->start_document();  # let the fun begin...\n    my (@hit_signifs);\n    my $gapped_stats = 0;    # for switching between gapped/ungapped\n                             # lambda, K, H\n    local $_ = \"\\n\";   #consistency\n    PARSER:\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/);       # skip empty lines\n        next if (/CPU time:/);\n        next if (/^>\\s*$/);\n        if (\n               /^((?:\\S+?)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                   # RPSBLAST, MEGABLAST\n            || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n          )\n        {\n            ($reporttype, my $reportversion) = ($1, $2);\n            # need to keep track of whether this is WU-BLAST\n            if ($reportversion && $reportversion =~ m{WashU$}) {\n                $self->{'_wublast'}++;\n            }\n            $self->debug(\"blast.pm: Start of new report: $reporttype, $reportversion\\n\");\n            if ( $self->{'_seentop'} ) { \n                # This handles multi-result input streams\n                $self->_pushback($_);\n                last PARSER;\n            }\n            $self->_start_blastoutput;\n            if ($reporttype =~ /RPS-BLAST/) {\n                $reporttype .= '(BLASTP)'; # default RPS-BLAST type\n            }\n            $reportline = $_;   # to fix the fact that RPS-BLAST output is wrong\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_version',\n                    'Data' => $reportversion\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_inclusion-threshold',\n                    'Data' => $incl_threshold\n                }\n            );\n        }\n        # added Windows workaround for bug 1985\n        elsif (/^(Searching|Results from round)/) { \n            next unless $1 =~ /Results from round/; \n            $self->debug(\"blast.pm: Possible psi blast iterations found...\\n\");\n            \n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n            if ( defined $seeniteration ) {\n                $self->within_element('iteration')\n                  && $self->end_element( { 'Name' => 'Iteration' } );\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            else {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $seeniteration = 1;\n        }\n        elsif (/^Query=\\s*(.*)$/) {\n            my $q    = $1;\n            $self->debug(\"blast.pm: Query= found...$_\\n\");\n            my $size = 0;\n            if ( defined $seenquery ) {\n                $self->_pushback($reportline) if $reportline;\n                $self->_pushback($_);\n                last PARSER;\n            }\n            else {\n                if ( !defined $reporttype ) {\n                    $self->_start_blastoutput;\n                    if ( defined $seeniteration ) {\n                        $self->in_element('iteration')\n                          && $self->end_element( { 'Name' => 'Iteration' } );\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    else {\n                        $self->start_element( { 'Name' => 'Iteration' } );\n                    }\n                    $seeniteration = 1;\n                }\n            }\n            $seenquery = $q;\n            $_ = $self->_readline;\n            while ( defined($_) ) {\n                if (/^Database:/) {\n                    $self->_pushback($_);\n                    last;\n                }\n                # below line fixes length issue with BLAST v2.2.13; still works \n                # with BLAST v2.2.12\n                if ( /\\((\\-?[\\d,]+)\\s+letters.*\\)/ || /^Length=(\\-?[\\d,]+)/ ) {\n                    $size = $1;\n                    $size =~ s/,//g;\n                    last;\n                }\n                else {\n                    # bug 2391\n                    $q .= ($q =~ /\\w$/ && $_ =~ /^\\w/) ? \" $_\" : $_;\n                    $q =~ s/\\s+/ /g; # this catches the newline as well\n                    $q =~ s/^ | $//g;\n                }\n\n                $_ = $self->_readline;\n            }\n            chomp($q);\n            my ( $nm, $desc ) = split( /\\s+/, $q, 2 );\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-def',\n                    'Data' => $nm\n                }\n            ) if $nm;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-len',\n                    'Data' => $size\n                }\n            );\n            defined $desc && $desc =~ s/\\s+$//;\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_querydesc',\n                    'Data' => $desc\n                }\n            );\n            my ( $gi, $acc, $version ) = $self->_get_seq_identifiers($nm);\n            $version = defined($version) && length($version) ? \".$version\" : \"\";\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_query-acc',\n                    'Data' => \"$acc$version\"\n                }\n            ) if $acc;\n        }\n\t\t# added check for WU-BLAST -echofilter option (bug 2388)\n\t\telsif (/^>Unfiltered[+-]1$/) {\n        \t# skip all of the lines of unfiltered sequence\n\t\t\twhile($_ !~ /^Database:/) {\n\t\t\t\t$self->debug(\"Bypassing features line: $_\");\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n\t\t}\n        elsif (/Sequences producing significant alignments:/) {\n            $self->debug(\"blast.pm: Processing NCBI-BLAST descriptions\\n\");\n            $flavor = 'ncbi';\n            \n            # PSI-BLAST parsing needs to be fixed to specifically look\n            # for old vs new per iteration, as sorting based on duplication\n            # leads to bugs, see bug 1986\n            \n            # The next line is not necessarily whitespace in psiblast reports.\n            # Also note that we must look for the end of this section by testing\n            # for a line with a leading >. Blank lines occur with this section\n            # for psiblast.\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            # these elements are dropped with some multiquery reports; add\n            # back here\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-len',\n                    'Data' => $self->{'_blsdb_length'}\n                } \n            ) if $self->{'_blsdb_length'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db-let',\n                    'Data' => $self->{'_blsdb_letters'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $self->{'_blsdb'}\n                }\n            ) if $self->{'_blsdb_letters'};\n            \n            # changed 8/28/2008 to exit hit table if blank line is found after an\n            # appropriate line\n            my $h_regex;\n            my $seen_block;\n          DESCLINE:\n            while ( defined( my $descline = $self->_readline() ) ) {\n                if ($descline =~ m{^\\s*$}) {\n                    last DESCLINE if $seen_block;\n                    next DESCLINE;\n                }\n                # any text match is part of block...\n                $seen_block++;\n                # GCG multiline oddness...\n                if ($descline =~ /^(\\S+)\\s+Begin:\\s\\d+\\s+End:\\s+\\d+/xms) {\n                    my ($id, $nextline) = ($1, $self->_readline);\n                    $nextline =~ s{^!}{};\n                    $descline = \"$id $nextline\";\n                }\n                # NCBI style hit table (no N)\n                if ($descline =~ /(?<!cor)          # negative lookahead\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s+                             # space\n                    (\\d*\\.?(?:[\\+\\-eE]+)?\\d+)       # number (float or scientific notation)\n                    \\s*$/xms) {\n                    \n                    my ( $score, $evalue ) = ($1, $2);\n                    \n                    # Some data clean-up so e-value will appear numeric to perl\n                    $evalue =~ s/^e/1e/i;\n\n                    # This to handle no-HSP case\n                    my @line = split ' ',$descline;\n                    \n                    # we want to throw away the score, evalue\n                    pop @line, pop @line;\n\n                    # and N if it is present (of course they are not\n                    # really in that order, but it doesn't matter\n                    if ($3) { pop @line }\n\n                    # add the last 2 entries s.t. we can reconstruct\n                    # a minimal Hit object at the end of the day\n                    push @hit_signifs, [ $evalue, $score, shift @line, join( ' ', @line ) ];\n                } elsif ($descline =~ /^CONVERGED/i) {\n                    $self->element(\n                        {\n                            'Name' => 'Iteration_converged',\n                            'Data' => 1\n                        }\n                    );\n                } else {\n                    $self->_pushback($descline); # Catch leading > (end of section)\n                    last DESCLINE;\n                }\n            }\n        }\n        elsif (/Sequences producing High-scoring Segment Pairs:/) {\n\n     # This block is for WU-BLAST, so we don't have to check for psi-blast stuff\n     # skip the next line\n            $self->debug(\"blast.pm: Processing WU-BLAST descriptions\\n\");\n            $_      = $self->_readline();\n            $flavor = 'wu';\n\n            if ( !$self->in_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n\n            while ( defined( $_ = $self->_readline() )\n                && !/^\\s+$/ )\n            {\n                my @line = split;\n                pop @line;    # throw away first number which is for 'N'col\n\n                # add the last 2 entries to array s.t. we can reconstruct\n                # a minimal Hit object at the end of the day\n                push @hit_signifs,\n                  [ pop @line, pop @line, shift @line, join( ' ', @line ) ];\n            }\n            \n        }\n        elsif (/^Database:\\s*(.+)$/) {\n\n            $self->debug(\"blast.pm: Database: $1\\n\");\n            my $db = $1;\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^\\s+(\\-?[\\d\\,]+|\\S+)\\s+sequences\\;\n                   \\s+(\\-?[\\d,]+|\\S+)\\s+ # Deal with NCBI 2.2.8 OSX problems\n                   total\\s+letters/ox\n                  )\n                {\n                    my ( $s, $l ) = ( $1, $2 );\n                    $s =~ s/,//g;\n                    $l =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-len',\n                            'Data' => $s\n                        }\n                    );\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_db-let',\n                            'Data' => $l\n                        }\n                    );\n                    # cache for next round in cases with multiple queries\n                    $self->{'_blsdb'} = $db;\n                    $self->{'_blsdb_length'} = $s;\n                    $self->{'_blsdb_letters'} = $l;                    \n                    last;\n                }\n                else {\n                    chomp;\n                    $db .= $_;\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_db',\n                    'Data' => $db\n                }\n            );\n        }\n        # bypasses this NCBI blast 2.2.13 extra output for now...\n\t\t# Features in/flanking this part of subject sequence:\n        elsif (/^\\sFeatures\\s\\w+\\sthis\\spart/xmso) {\n            my $featline;\n            $_ = $self->_readline;\n\t\t\twhile($_ !~ /^\\s*$/) {\n                chomp;\n                $featline .= $_;\n        \t\t$_ = $self->_readline;\n        \t}\n\t\t\t$self->_pushback($_);\n            $featline =~ s{(?:^\\s+|\\s+^)}{}g;\n            $featline =~ s{\\n}{;}g;\n            $self->{'_last_hspdata'}->{'Hsp_features'} = $featline;\n        }\n        \n        # move inside of a hit\n        elsif (/^>\\s*(\\S+)\\s*(.*)?/) {\n            chomp;\n\n            $self->debug(\"blast.pm: Hit: $1\\n\");\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # special case when bl2seq reports don't have a leading\n            # Query=\n            if ( !$self->within_element('result') ) {\n                $self->_start_blastoutput;\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            elsif ( !$self->within_element('iteration') ) {\n                $self->start_element( { 'Name' => 'Iteration' } );\n            }\n            $self->start_element( { 'Name' => 'Hit' } );\n            my $id         = $1;\n            my $restofline = $2;\n\n            $self->debug(\"Starting a hit: $1 $2\\n\");\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $id\n                }\n            );\n            my ($gi, $acc, $version ) = $self->_get_seq_identifiers($id);\n            $self->element(\n                {\n                    'Name' => 'Hit_accession',\n                    'Data' => $acc\n                }\n            );\n            # add hit significance (from the hit table)\n            # this is where Bug 1986 went awry\n            \n            # Changed for Bug2409; hit->significance and hit->score/bits derived\n            # from HSPs, not hit table unless necessary\n            \n            HITTABLE:\n            while (my $v = shift @hit_signifs) {        \n                my $tableid = $v->[2];\n                if ($tableid !~ m{\\Q$id\\E}) {\n                    $self->debug(\"Hit table ID $tableid doesn't match current hit id $id, checking next hit table entry...\\n\");\n                    next HITTABLE;\n                } else {\n                    last HITTABLE;\n                }\n            }\n            while ( defined( $_ = $self->_readline() ) ) {\n                next if (/^\\s+$/);\n                chomp;\n                if (/Length\\s*=\\s*([\\d,]+)/) {\n                    my $l = $1;\n                    $l =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Hit_len',\n                            'Data' => $l\n                        }\n                    );\n                    last;\n                }\n                else {\n                    s/^\\s(?!\\s)/\\x01/; #new line to concatenate desc lines with <soh>\n                    $restofline .= $_;\n                }\n            }\n            $restofline =~ s/\\s+/ /g;\n            $self->element(\n                {\n                    'Name' => 'Hit_def',\n                    'Data' => $restofline\n                }\n            );\n        }\n        elsif (/\\s+(Plus|Minus) Strand HSPs:/i) {\n            next;\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel genewise BTK\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,                 # Raw score\n\t\t\\s+Log\\-Length\\sScore\\s*=\\s*(\\d+) # Log-Length score\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel genewise HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $evalue ) = ( $1, $2, $3 );\n            $evalue =~ s/^e/1e/i;\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # paracel hframe BTK\n            m/Score\\s*=\\s*([^,\\s]+),     # Raw score\n\t\t\\s*Expect\\s*=\\s*([^,\\s]+),  # E-value\n                \\s*P(?:\\(\\S+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                /ox\n          )\n        {\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            $self->debug( \"Got paracel hframe HSP score=$1\\n\");\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $evalue, $pvalue ) = ( $1, $2, $3 );\n            $evalue = \"1$evalue\" if $evalue =~ /^e/;\n            $pvalue = \"1$pvalue\" if $pvalue =~ /^e/;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # wublast\n            m/Score\\s*=\\s*(\\S+)\\s*         # Bit score\n                \\(([\\d\\.]+)\\s*bits\\),         # Raw score\n                \\s*Expect\\s*=\\s*([^,\\s]+),    # E-value\n                \\s*(?:Sum)?\\s*                # SUM\n                P(?:\\(\\d+\\))?\\s*=\\s*([^,\\s]+) # P-value\n                (?:\\s*,\\s+Group\\s*\\=\\s*(\\d+))?    # HSP Group\n                /ox\n          )\n        {         # wu-blast HSP parse\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->start_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $score, $bits, $evalue, $pvalue, $group ) =\n              ( $1, $2, $3, $4, $5 );\n            $evalue =~ s/^e/1e/i;\n            $pvalue =~ s/^e/1e/i;\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_pvalue',\n                    'Data' => $pvalue\n                }\n            );\n\n            if ( defined $group ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_group',\n                        'Data' => $group\n                    }\n                );\n            }\n\n        }\n        elsif (\n            ( $self->in_element('hit') || $self->in_element('hsp') )\n            &&    # ncbi blast, works with 2.2.17\n            m/Score\\s*=\\s*(\\S+)\\s*bits\\s* # Bit score\n                (?:\\((\\d+)\\))?,            # Missing for BLAT pseudo-BLAST fmt \n                \\s*Expect(?:\\((\\d+\\+?)\\))?\\s*=\\s*([^,\\s]+) # E-value\n                /ox\n          )\n        {         # parse NCBI blast HSP\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n\n            # Some data clean-up so e-value will appear numeric to perl\n            my ( $bits, $score, $n, $evalue ) = ( $1, $2, $3, $4 );\n            $evalue =~ s/^e/1e/i;\n            $self->start_element( { 'Name' => 'Hsp' } );\n            $self->element(\n                {\n                    'Name' => 'Hsp_score',\n                    'Data' => $score\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_bit-score',\n                    'Data' => $bits\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_evalue',\n                    'Data' => $evalue\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_n',\n                    'Data' => $n\n                }\n            ) if defined $n;\n            $score = '' unless defined $score;    # deal with BLAT which\n                                                  # has no score only bits\n            $self->debug(\"Got NCBI HSP score=$score, evalue $evalue\\n\");\n        }\n        elsif (\n            $self->in_element('hsp')\n            && m/Identities\\s*=\\s*(\\d+)\\s*\\/\\s*(\\d+)\\s*[\\d\\%\\(\\)]+\\s*\n                (?:,\\s*Positives\\s*=\\s*(\\d+)\\/(\\d+)\\s*[\\d\\%\\(\\)]+\\s*)? # pos only valid for Protein alignments\n                (?:\\,\\s*Gaps\\s*=\\s*(\\d+)\\/(\\d+))? # Gaps\n                /oxi\n          )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_identity',\n                    'Data' => $1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_align-len',\n                    'Data' => $2\n                }\n            );\n            if ( defined $3 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $3\n                    }\n                );\n            }\n            else {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_positive',\n                        'Data' => $1\n                    }\n                );\n            }\n            if ( defined $6 ) {\n                $self->element(\n                    {\n                        'Name' => 'Hsp_gaps',\n                        'Data' => $5\n                    }\n                );\n            }\n\n            $self->{'_Query'} = { 'begin' => 0, 'end' => 0 };\n            $self->{'_Sbjct'} = { 'begin' => 0, 'end' => 0 };\n\n            if (/(Frame\\s*=\\s*.+)$/) {\n\n                # handle wu-blast Frame listing on same line\n                $self->_pushback($1);\n            }\n        }\n        elsif ( $self->in_element('hsp')\n            && /Strand\\s*=\\s*(Plus|Minus)\\s*\\/\\s*(Plus|Minus)/i )\n        {\n\n            # consume this event ( we infer strand from start/end)\n            unless ($reporttype) {\n                $self->{'_reporttype'} = $reporttype = 'BLASTN';\n                $bl2seq_fix = 1;    # special case to resubmit the algorithm\n                                    # reporttype\n            }\n            next;\n        }\n        elsif ( $self->in_element('hsp')\n            && /Links\\s*=\\s*(\\S+)/ox )\n        {\n            $self->element(\n                {\n                    'Name' => 'Hsp_links',\n                    'Data' => $1\n                }\n            );\n        }\n        elsif ( $self->in_element('hsp')\n            && /Frame\\s*=\\s*([\\+\\-][1-3])\\s*(\\/\\s*([\\+\\-][1-3]))?/ )\n        {\n\n            # this is for bl2seq only\n            unless ( defined $reporttype ) {\n                $bl2seq_fix = 1;\n                if ( $1 && $2 ) { $reporttype = 'TBLASTX' }\n                else {\n                    $reporttype = 'BLASTX';\n\n    # we can't distinguish between BLASTX and TBLASTN straight from the report }\n                }\n                $self->{'_reporttype'} = $reporttype;\n            }\n\n            my ( $queryframe, $hitframe );\n            if ( $reporttype eq 'TBLASTX' ) {\n                ( $queryframe, $hitframe ) = ( $1, $2 );\n                $hitframe =~ s/\\/\\s*//g;\n            }\n            elsif ( $reporttype eq 'TBLASTN' || $reporttype eq 'PSITBLASTN') {\n                ( $hitframe, $queryframe ) = ( $1, 0 );\n            }\n            elsif ( $reporttype eq 'BLASTX' || $reporttype eq 'RPS-BLAST(BLASTP)') {\n                ( $queryframe, $hitframe ) = ( $1, 0 );\n                # though NCBI doesn't report it, this is a special BLASTX-like\n                # RPS-BLAST; should be handled differently\n                if ($reporttype eq 'RPS-BLAST(BLASTP)') {\n                    $self->element(\n                        {\n                            'Name' => 'BlastOutput_program',\n                            'Data' => 'RPS-BLAST(BLASTX)'\n                        }\n                    );\n                }\n            }\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-frame',\n                    'Data' => $queryframe\n                }\n            );\n\n            $self->element(\n                {\n                    'Name' => 'Hsp_hit-frame',\n                    'Data' => $hitframe\n                }\n            );\n        }\n        elsif (/^Parameters:/\n            || /^\\s+Database:\\s+?/\n            || /^\\s+Subset/\n            || /^\\s*Lambda/\n            || /^\\s*Histogram/\n            || ( $self->in_element('hsp') && /WARNING|NOTE/ ) )\n        {\n\n            # Note: Lambda check was necessary to parse\n            # t/data/ecoli_domains.rpsblast AND to parse bl2seq\n            $self->debug(\"blast.pm: found parameters section \\n\");\n\n            $self->in_element('hsp')\n              && $self->end_element( { 'Name' => 'Hsp' } );\n            $self->in_element('hit')\n              && $self->end_element( { 'Name' => 'Hit' } );\n\n            # This is for the case when we specify -b 0 (or B=0 for WU-BLAST)\n            # and still want to construct minimal Hit objects\n            $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n            $self->within_element('iteration')\n              && $self->end_element( { 'Name' => 'Iteration' } );\n\n            next if /^\\s+Subset/;\n            my $blast = (/^(\\s+Database\\:)|(\\s*Lambda)/) ? 'ncbi' : 'wublast';\n            if (/^\\s*Histogram/) {\n                $blast = 'btk';\n            }\n\n            my $last = '';\n\n            # default is that gaps are allowed\n            $self->element(\n                {\n                    'Name' => 'Parameters_allowgaps',\n                    'Data' => 'yes'\n                }\n            );\n            while ( defined( $_ = $self->_readline ) ) {\n                if (\n                    /^((?:\\S+)?BLAST[NPX]?)\\s+(.+)$/i  # NCBI BLAST, PSIBLAST\n                                                      # RPSBLAST, MEGABLAST\n                    || /^(P?GENEWISE|HFRAME|SWN|TSWN)\\s+(.+)/i    #Paracel BTK\n                  )\n                {\n                    $self->_pushback($_);\n\n                    # let's handle this in the loop\n                    last;\n                }\n                elsif (/^Query=/) {\n                    $self->_pushback($reportline) if $reportline;\n                    $self->_pushback($_);\n                    last PARSER;\n                }\n\n                # here is where difference between wublast and ncbiblast\n                # is better handled by different logic\n                if (   /Number of Sequences:\\s+([\\d\\,]+)/i\n                    || /of sequences in database:\\s+(\\-?[\\d,]+)/i )\n                {\n                    my $c = $1;\n                    $c =~ s/\\,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-len',\n                            'Data' => $c\n                        }\n                    );\n                }\n                elsif (/letters in database:\\s+(\\-?[\\d,]+)/i) {\n                    my $s = $1;\n                    $s =~ s/,//g;\n                    $self->element(\n                        {\n                            'Name' => 'Statistics_db-let',\n                            'Data' => $s\n                        }\n                    );\n                }\n                elsif ( $blast eq 'btk' ) {\n                    next;\n                }\n                elsif ( $blast eq 'wublast' ) {\n\n                    #\t\t   warn($_);\n                    if (/E=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/nogaps/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_allowgaps',\n                                'Data' => 'no'\n                            }\n                        );\n                    }\n                    elsif (/ctxfactor=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_ctxfactor',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n/(postsw|links|span[12]?|warnings|notes|gi|noseqs|qres|qype)/\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => 'yes'\n                            }\n                        );\n                    }\n                    elsif (/(\\S+)=(\\S+)/) {\n                        $self->element(\n                            {\n                                'Name' => \"Parameters_$1\",\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Matrix name/i ) {\n                        my $firstgapinfo = 1;\n                        my $frame        = undef;\n                        while ( defined($_) && !/^\\s+$/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            if ( $firstgapinfo\n                                && s/Q=(\\d+),R=(\\d+)\\s+//x )\n                            {\n                                $firstgapinfo = 0;\n\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-open',\n                                        'Data' => $1\n                                    }\n                                );\n                                $self->element(\n                                    {\n                                        'Name' => 'Parameters_gap-extend',\n                                        'Data' => $2\n                                    }\n                                );\n                                my @fields = split;\n\n                                for my $type (\n                                    qw(lambda_gapped\n                                    kappa_gapped\n                                    entropy_gapped)\n                                  )\n                                {\n                                    next if $type eq 'n/a';\n                                    if ( !@fields ) {\n                                        warn \"fields is empty for $type\\n\";\n                                        next;\n                                    }\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n                                my ( $frameo, $matid, $matrix, @fields ) =\n                                  split;\n                                if ( !defined $frame ) {\n\n                                    # keep some sort of default feature I guess\n                                    # even though this is sort of wrong\n                                    $self->element(\n                                        {\n                                            'Name' => 'Parameters_matrix',\n                                            'Data' => $matrix\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_lambda',\n                                            'Data' => $fields[0]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_kappa',\n                                            'Data' => $fields[1]\n                                        }\n                                    );\n                                    $self->element(\n                                        {\n                                            'Name' => 'Statistics_entropy',\n                                            'Data' => $fields[2]\n                                        }\n                                    );\n                                }\n                                $frame = $frameo;\n                                my $ii = 0;\n                                for my $type (\n                                    qw(lambda_used\n                                    kappa_used\n                                    entropy_used\n                                    lambda_computed\n                                    kappa_computed\n                                    entropy_computed)\n                                  )\n                                {\n                                    my $f = $fields[$ii];\n                                    next unless defined $f;    # deal with n/a\n                                    if ( $f eq 'same' ) {\n                                        $f = $fields[ $ii - 3 ];\n                                    }\n                                    $ii++;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => $f\n                                        }\n                                    );\n\n                                }\n                            }\n\n                            # get the next line\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif ( $last =~ /(Frame|Strand)\\s+MatID\\s+Length/i ) {\n                        my $frame = undef;\n                        while ( defined($_) && !/^\\s+/ ) {\n                            s/^\\s+//;\n                            s/\\s+$//;\n                            my @fields = split;\n                            if ( @fields <= 3 ) {\n                                for my $type (qw(X_gapped E2_gapped S2)) {\n                                    last unless @fields;\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            else {\n\n                                for my $type (\n                                    qw(length\n                                    efflength\n                                    E S W T X E2 S2)\n                                  )\n                                {\n                                    $self->element(\n                                        {\n                                            'Name' =>\n                                              \"Statistics_frame$frame\\_$type\",\n                                            'Data' => shift @fields\n                                        }\n                                    );\n                                }\n                            }\n                            $_ = $self->_readline;\n                        }\n                        $last = $_;\n                    }\n                    elsif (/(\\S+\\s+\\S+)\\s+DFA:\\s+(\\S+)\\s+\\((.+)\\)/) {\n                        if ( $1 eq 'states in' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_states',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                        elsif ( $1 eq 'size of' ) {\n                            $self->element(\n                                {\n                                    'Name' => 'Statistics_DFA_size',\n                                    'Data' => \"$2 $3\"\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/^\\s+Time to generate neighborhood:\\s+\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_neighbortime',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/processors\\s+used:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_noprocessors',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^\\s+(\\S+)\\s+cpu\\s+time:\\s+# cputype\n\t\t\t    (\\S+\\s+\\S+\\s+\\S+)           # cputime\n\t\t\t    \\s+Elapsed:\\s+(\\S+)/x\n                      )\n                    {\n                        my $cputype = lc($1);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_cputime\",\n                                'Data' => $2\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$cputype\\_actualtime\",\n                                'Data' => $3\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Start:/) {\n                        my ( $junk, $start, $stime, $end, $etime ) =\n                          split( /\\s+(Start|End)\\:\\s+/, $_ );\n                        chomp($stime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_starttime',\n                                'Data' => $stime\n                            }\n                        );\n                        chomp($etime);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_endtime',\n                                'Data' => $etime\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Database:\\s+(.+)$/) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_full_dbpath',\n                                'Data' => $1\n                            }\n                        );\n\n                    }\n                    elsif (/^\\s+Posted:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                }\n                elsif ( $blast eq 'ncbi' ) {\n\n                    if (m/^Matrix:\\s+(.+)\\s*$/oxi) {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_matrix',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/^Gapped/) {\n                        $gapped_stats = 1;\n                    }\n                    elsif (/^Lambda/) {\n                        $_ = $self->_readline;\n                        s/^\\s+//;\n                        my ( $lambda, $kappa, $entropy ) = split;\n                        if ($gapped_stats) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_gapped_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                        else {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_lambda\",\n                                    'Data' => $lambda\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_kappa\",\n                                    'Data' => $kappa\n                                }\n                            );\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_entropy\",\n                                    'Data' => $entropy\n                                }\n                            );\n                        }\n                    }\n                    elsif (m/effective\\s+search\\s+space\\s+used:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-spaceused',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/effective\\s+search\\s+space:\\s+(\\d+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-space',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/Gap\\s+Penalties:\\s+Existence:\\s+(\\d+)\\,\n\t\t\t    \\s+Extension:\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-open',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_gap-extend',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+HSP\\s+length:\\s+(\\d+)/) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hsp-len',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+query:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_query-len',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (/effective\\s+length\\s+of\\s+database:\\s+([\\d\\,]+)/) {\n                        my $c = $1;\n                        $c =~ s/\\,//g;\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_eff-dblen',\n                                'Data' => $c\n                            }\n                        );\n                    }\n                    elsif (\n/^(T|A|X1|X2|X3|S1|S2):\\s+(\\d+(\\.\\d+)?)\\s+(?:\\(\\s*(\\d+\\.\\d+) bits\\))?/\n                      )\n                    {\n                        my $v = $2;\n                        chomp($v);\n                        $self->element(\n                            {\n                                'Name' => \"Statistics_$1\",\n                                'Data' => $v\n                            }\n                        );\n                        if ( defined $4 ) {\n                            $self->element(\n                                {\n                                    'Name' => \"Statistics_$1_bits\",\n                                    'Data' => $4\n                                }\n                            );\n                        }\n                    }\n                    elsif (\n                        m/frameshift\\s+window\\,\n\t\t\t    \\s+decay\\s+const:\\s+(\\d+)\\,\\s+([\\.\\d]+)/x\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_framewindow',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_decay',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+Hits\\s+to\\s+DB:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_hit_to_db',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (m/^Number\\s+of\\s+extensions:\\s+(\\S+)/ox) {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+successful\\s+extensions:\\s+\n\t\t\t    (\\S+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_num_suc_extensions',\n                                'Data' => $1\n                            }\n                        );\n                    }\n                    elsif (\n                        m/^Number\\s+of\\s+sequences\\s+better\\s+than\\s+\n\t\t\t    (\\S+):\\s+(\\d+)/ox\n                      )\n                    {\n                        $self->element(\n                            {\n                                'Name' => 'Parameters_expect',\n                                'Data' => $1\n                            }\n                        );\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_seqs_better_than_cutoff',\n                                'Data' => $2\n                            }\n                        );\n                    }\n                    elsif (/^\\s+Posted\\s+date:\\s+(.+)/) {\n                        my $d = $1;\n                        chomp($d);\n                        $self->element(\n                            {\n                                'Name' => 'Statistics_posted_date',\n                                'Data' => $d\n                            }\n                        );\n                    }\n                    elsif ( !/^\\s+$/ ) {\n                        #$self->debug( \"unmatched stat $_\");\n                    }\n                }\n                $last = $_;\n            }\n        } elsif ( $self->in_element('hsp') ) {\n            $self->debug(\"blast.pm: Processing HSP\\n\");\n            # let's read 3 lines at a time;\n            # bl2seq hackiness... Not sure I like\n            $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n            my %data = (\n                'Query' => '',\n                'Mid'   => '',\n                'Hit'   => ''\n            );\n            my $len;\n            for ( my $i = 0 ; defined($_) && $i < 3 ; $i++ ) {\n                # $self->debug(\"$i: $_\") if $v;\n                if ( ( $i == 0 && /^\\s+$/) || \n\t\t     /^\\s*(?:Lambda|Minus|Plus|Score)/i )\n                {\n                    $self->_pushback($_) if defined $_;\n                    $self->end_element( { 'Name' => 'Hsp' } );\n                    last;\n                }\n                chomp;\n                if (/^((Query|Sbjct):?\\s+(\\-?\\d+)\\s*)(\\S+)\\s+(\\-?\\d+)/) {\n                    my ( $full, $type, $start, $str, $end ) =\n                      ( $1, $2, $3, $4, $5 );\n\n                    if ( $str eq '-' ) {\n                        $i = 3 if $type eq 'Sbjct';\n                    }\n                    else {\n                        $data{$type} = $str;\n                    }\n                    $len = length($full);\n                    $self->{\"\\_$type\"}->{'begin'} = $start\n                      unless $self->{\"_$type\"}->{'begin'};\n                    $self->{\"\\_$type\"}->{'end'} = $end;\n                } else {\n                    $self->throw(\"no data for midline $_\")\n                      unless ( defined $_ && defined $len );\n                    $data{'Mid'} = substr( $_, $len );\n                }\n                $_ = $self->_readline();\n            }\n            $self->characters(\n                {\n                    'Name' => 'Hsp_qseq',\n                    'Data' => $data{'Query'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_hseq',\n                    'Data' => $data{'Sbjct'}\n                }\n            );\n            $self->characters(\n                {\n                    'Name' => 'Hsp_midline',\n                    'Data' => $data{'Mid'}\n                }\n            );\n        }\n        else {\n            #$self->debug(\"blast.pm: unrecognized line $_\");\n        }\n    }\n\n    $self->debug(\"blast.pm: End of BlastOutput\\n\");\n    if ( $self->{'_seentop'} ) {\n        $self->within_element('hsp')\n          && $self->end_element( { 'Name' => 'Hsp' } );\n        $self->within_element('hit')\n          && $self->end_element( { 'Name' => 'Hit' } );\n        # cleanup extra hits\n        $self->_cleanup_hits(\\@hit_signifs) if scalar(@hit_signifs);\n        $self->within_element('iteration')\n          && $self->end_element( { 'Name' => 'Iteration' } );\n        if ($bl2seq_fix) {\n            $self->element(\n                {\n                    'Name' => 'BlastOutput_program',\n                    'Data' => $reporttype\n                }\n            );\n        }\n        $self->end_element( { 'Name' => 'BlastOutput' } );\n    }\n    return $self->end_document();\n}\n\n# Private method for internal use only.\nsub _start_blastoutput {\n    my $self = shift;\n    $self->start_element( { 'Name' => 'BlastOutput' } );\n    $self->{'_seentop'} = 1;\n    $self->{'_result_count'}++;\n    $self->{'_handler_rc'} = undef;\n}\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().\n\n\nsub _will_handle {\n    my ( $self, $type ) = @_;\n    my $handler     = $self->{'_handler_cache'};\n    my $will_handle =\n      defined( $self->{'_will_handle_cache'}->{$type} )\n      ? $self->{'_will_handle_cache'}->{$type}\n      : ( $self->{'_will_handle_cache'}->{$type} =\n          $handler->will_handle($type) );\n\n    return $will_handle ? $handler : undef;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->{'_handler_rc'} = $handler->$func( $data->{'Attributes'} );\n        }\n        #else {\n            #$self->debug( # changed 4/29/2006 to play nice with other event handlers\n            #    \"Bio::SearchIO::InternalParserError \".\n            #    \"\\nCan't handle elements of type \\'$type.\\'\"\n            #);\n        #}\n        unshift @{ $self->{'_elements'} }, $type;\n        if ( $type eq 'result' ) {\n            $self->{'_values'} = {};\n            $self->{'_result'} = undef;\n        } else {\n            # cleanup some things\n            if ( defined $self->{'_values'} ) {\n                foreach my $k (\n                    grep { /^\\U$type\\-/ }\n                    keys %{ $self->{'_values'} }\n                  )\n                {\n                    delete $self->{'_values'}->{$k};\n                }\n            }\n        }\n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : hashref with an element's worth of data\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    \n    my $nm   = $data->{'Name'};\n    my $type;\n    my $rc;\n    if ( $nm eq 'BlastOutput_program' ) {\n        if ( $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n            $self->{'_reporttype'} = uc $1;\n        }\n        $self->{'_reporttype'} ||= $DEFAULTREPORTTYPE;\n    }\n\n    # Hsps are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if ( $nm eq 'Hsp' ) {\n        foreach (qw(Hsp_qseq Hsp_midline Hsp_hseq Hsp_features)) {\n            $self->element(\n                {\n                    'Name' => $_,\n                    'Data' => $self->{'_last_hspdata'}->{$_}\n                }\n            ) if defined $self->{'_last_hspdata'}->{$_};\n        }\n        $self->{'_last_hspdata'} = {};\n        $self->element(\n            {\n                'Name' => 'Hsp_query-from',\n                'Data' => $self->{'_Query'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_query-to',\n                'Data' => $self->{'_Query'}->{'end'}\n            }\n        );\n\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $self->{'_Sbjct'}->{'begin'}\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $self->{'_Sbjct'}->{'end'}\n            }\n        );\n\n        #    } elsif( $nm eq 'Iteration' ) {\n        # Nothing special needs to be done here.\n    }\n    if ( $type = $MODEMAP{$nm} ) {\n        my $handler = $self->_will_handle($type);\n        if ($handler) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $handler->$func( $self->{'_reporttype'}, $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n\n            # this is where we shove in the data from the\n            # hashref info about params or statistics\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        #$self->debug(\"blast.pm: unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # Note that start element isn't needed for character data\n    # Not too SAX-y, though\n    #$self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /^Hsp\\_(qseq|hseq|midline)$/ )\n    {\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'}\n          if defined $data->{'Data'};\n    }\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<in_element>\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within_element' because within\n           can be tested for a whole block.\n Returns : boolean\n Args    : string element name \n\nSee Also: L<within_element>\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none"}},{"detail":"($self,$blast,@args)","definition":"sub","containerName":"main::","name":"write_result","children":[{"line":2187,"name":"$self","localvar":"my","kind":13,"containerName":"write_result","definition":"my"},{"containerName":"write_result","kind":13,"name":"$blast","line":2187},{"line":2187,"name":"@args","containerName":"write_result","kind":13},{"line":2189,"name":"$self","containerName":"write_result","kind":13},{"line":2189,"containerName":"write_result","kind":12,"name":"writer"},{"line":2190,"name":"$self","containerName":"write_result","kind":13},{"line":2190,"name":"warn","containerName":"write_result","kind":12},{"name":"$self","containerName":"write_result","kind":13,"line":2191},{"name":"writer","containerName":"write_result","kind":12,"line":2191},{"name":"$DEFAULT_BLAST_WRITER_CLASS","kind":13,"containerName":"write_result","line":2191},{"name":"new","containerName":"write_result","kind":12,"line":2191},{"line":2193,"containerName":"write_result","kind":13,"name":"$self"},{"containerName":"write_result","kind":13,"name":"$blast","line":2193},{"name":"@args","containerName":"write_result","kind":13,"line":2193}],"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$blast"},{"label":"@args"}],"label":"write_result($self,$blast,@args)"},"range":{"end":{"line":2194,"character":9999},"start":{"line":2186,"character":0}},"kind":12,"line":2186},{"line":2193,"name":"SUPER","kind":12,"containerName":"write_result"},{"line":2196,"range":{"start":{"character":0,"line":2196},"end":{"line":2199,"character":9999}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"result_count","kind":13,"line":2197},{"line":2198,"containerName":"result_count","kind":13,"name":"$self"}],"containerName":"main::","name":"result_count"},{"range":{"end":{"character":9999,"line":2201},"start":{"character":0,"line":2201}},"kind":12,"line":2201,"containerName":"main::","name":"report_count","children":[{"line":2201,"name":"result_count","kind":12,"containerName":"report_count"}],"definition":"sub"},{"definition":"sub","children":[{"line":2219,"name":"_eventHandler","kind":12,"containerName":"inclusion_threshold"},{"line":2219,"containerName":"inclusion_threshold","kind":12,"name":"inclusion_threshold"}],"name":"inclusion_threshold","containerName":"main::","line":2218,"kind":12,"range":{"start":{"line":2218,"character":0},"end":{"line":2220,"character":9999}}},{"line":2236,"range":{"start":{"line":2236,"character":0},"end":{"character":9999,"line":2236}},"kind":12,"children":[{"kind":12,"containerName":"max_significance","name":"max_significance","line":2236}],"name":"max_significance","containerName":"main::","definition":"sub"},{"name":"signif","containerName":"main::","children":[{"line":2244,"name":"max_significance","kind":12,"containerName":"signif"}],"definition":"sub","kind":12,"range":{"end":{"line":2244,"character":9999},"start":{"line":2244,"character":0}},"line":2244},{"name":"min_score","containerName":"main::","children":[{"line":2259,"containerName":"min_score","kind":12,"name":"max_significance"}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":2259},"end":{"line":2259,"character":9999}},"line":2259},{"line":2272,"range":{"start":{"character":0,"line":2272},"end":{"character":9999,"line":2289}},"kind":12,"children":[{"definition":"my","line":2273,"kind":13,"localvar":"my","containerName":"min_query_length","name":"$self"},{"definition":"my","line":2275,"name":"$min_qlen","containerName":"min_query_length","localvar":"my","kind":13},{"kind":13,"containerName":"min_query_length","name":"$min_qlen","line":2276},{"line":2276,"name":"$min_qlen","kind":13,"containerName":"min_query_length"},{"kind":13,"containerName":"min_query_length","name":"$self","line":2277},{"line":2277,"name":"throw","kind":12,"containerName":"min_query_length"},{"name":"$min_qlen","containerName":"min_query_length","kind":13,"line":2282},{"kind":13,"containerName":"min_query_length","name":"$self","line":2284},{"containerName":"min_query_length","kind":13,"name":"$self","line":2285},{"containerName":"min_query_length","kind":13,"name":"$min_qlen","line":2285},{"line":2288,"containerName":"min_query_length","kind":13,"name":"$self"}],"name":"min_query_length","containerName":"main::","definition":"sub"},{"line":2302,"range":{"end":{"character":9999,"line":2306},"start":{"character":0,"line":2302}},"kind":12,"definition":"sub","children":[{"localvar":"my","kind":13,"containerName":"best_hit_only","name":"$self","line":2303,"definition":"my"},{"line":2304,"name":"$self","containerName":"best_hit_only","kind":13},{"name":"$self","containerName":"best_hit_only","kind":13,"line":2305}],"containerName":"main::","name":"best_hit_only"},{"line":2321,"range":{"end":{"character":9999,"line":2325},"start":{"character":0,"line":2321}},"kind":12,"children":[{"localvar":"my","kind":13,"containerName":"check_all_hits","name":"$self","line":2322,"definition":"my"},{"containerName":"check_all_hits","kind":13,"name":"$self","line":2323},{"containerName":"check_all_hits","kind":13,"name":"$self","line":2324}],"containerName":"main::","name":"check_all_hits","definition":"sub"},{"kind":12,"range":{"start":{"character":0,"line":2380},"end":{"character":9999,"line":2382}},"line":2380,"signature":{"label":"_cleanup_hits($self,$hits)","parameters":[{"label":"$self"},{"label":"$hits"}],"documentation":" commented out, using common base class util method\n=head2 _get_accession_version\n\n Title   : _get_accession_version\n Usage   : my ($acc,$ver) = &_get_accession_version($id)\n Function:Private function to get an accession,version pair\n           for an ID (if it is in NCBI format)\n Returns : 2-pule of accession, version\n Args    : ID string to process\n\n\n=cut\n\nsub _get_accession_version {\n    my $id = shift;\n\n    # handle case when this is accidently called as a class method\n    if ( ref($id) && $id->isa('Bio::SearchIO') ) {\n        $id = shift;\n    }\n    return unless defined $id;\n    my ( $acc, $version );\n    if ( $id =~ /(gb|emb|dbj|sp|pdb|bbs|ref|lcl)\\|(.*)\\|(.*)/ ) {\n        ( $acc, $version ) = split /\\./, $2;\n    }\n    elsif ( $id =~ /(pir|prf|pat|gnl)\\|(.*)\\|(.*)/ ) {\n        ( $acc, $version ) = split /\\./, $3;\n    }\n    else {\n\n        #punt, not matching the db's at ftp://ftp.ncbi.nih.gov/blast/db/README\n        #Database Name                     Identifier Syntax\n        #GenBank                           gb|accession|locus\n        #EMBL Data Library                 emb|accession|locus\n        #DDBJ, DNA Database of Japan       dbj|accession|locus\n        #NBRF PIR                          pir||entry\n        #Protein Research Foundation       prf||name\n        #SWISS-PROT                        sp|accession|entry name\n        #Brookhaven Protein Data Bank      pdb|entry|chain\n        #Patents                           pat|country|number\n        #GenInfo Backbone Id               bbs|number\n        #General database identifier           gnl|database|identifier\n        #NCBI Reference Sequence           ref|accession|locus\n        #Local Sequence identifier         lcl|identifier\n        $acc = $id;\n    }\n    return ( $acc, $version );\n}\n general private method used to make minimal hits from leftover\n data in the hit table"},"containerName":"main::","name":"_cleanup_hits","children":[{"line":2381,"name":"$self","localvar":"my","containerName":"_cleanup_hits","kind":13,"definition":"my"},{"kind":13,"containerName":"_cleanup_hits","name":"$hits","line":2381},{"containerName":"_cleanup_hits","localvar":"my","kind":13,"name":"$v","line":2382,"definition":"my"},{"containerName":"_cleanup_hits","kind":13,"name":"$hits","line":2382}],"detail":"($self,$hits)","definition":"sub"},{"line":2383,"name":"$v","containerName":null,"kind":13},{"line":2384,"kind":13,"containerName":null,"name":"$self"},{"line":2384,"kind":12,"containerName":"main::","name":"start_element"},{"containerName":null,"localvar":"my","kind":13,"name":"$id","line":2385,"definition":"my"},{"line":2385,"containerName":null,"kind":13,"name":"@v"},{"line":2386,"localvar":"my","containerName":null,"kind":13,"name":"$desc","definition":"my"},{"name":"@v","kind":13,"containerName":null,"line":2386},{"name":"$self","containerName":null,"kind":13,"line":2387},{"line":2387,"containerName":"main::","kind":12,"name":"element"},{"line":2391,"containerName":null,"kind":13,"name":"$id"},{"definition":"my","line":2393,"containerName":null,"localvar":"my","kind":13,"name":"$gi"},{"name":"$acc","kind":13,"containerName":null,"line":2393},{"containerName":null,"kind":13,"name":"$version","line":2393},{"name":"$self","kind":13,"containerName":null,"line":2393},{"line":2393,"containerName":"main::","kind":12,"name":"_get_seq_identifiers"},{"name":"$id","kind":13,"containerName":null,"line":2393},{"line":2394,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"element","line":2394},{"kind":13,"containerName":null,"name":"$acc","line":2398},{"containerName":null,"kind":13,"name":"%v","line":2400},{"line":2401,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"element","line":2401},{"name":"@v","containerName":null,"kind":13,"line":2404},{"line":2407,"containerName":null,"kind":13,"name":"%self"},{"containerName":null,"kind":13,"name":"$self","line":2408},{"line":2408,"name":"element","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"@v","line":2411},{"containerName":null,"kind":13,"name":"$self","line":2415},{"containerName":"main::","kind":12,"name":"element","line":2415},{"line":2418,"kind":13,"containerName":null,"name":"@v"},{"name":"$self","kind":13,"containerName":null,"line":2424},{"name":"element","containerName":"main::","kind":12,"line":2424},{"line":2428,"containerName":null,"kind":13,"name":"$desc"},{"kind":13,"containerName":null,"name":"$self","line":2430},{"line":2430,"containerName":"main::","kind":12,"name":"end_element"}],"version":5}