{"vars":[{"line":85,"name":"vars","kind":2,"containerName":""},{"line":90,"kind":2,"containerName":"","name":"base"},{"line":96,"containerName":null,"kind":13,"name":"%MODEMAP"},{"line":96,"containerName":"","kind":2,"name":"POSIX"},{"kind":13,"containerName":null,"name":"$GAPCHAR","line":100},{"name":"%MAPPING","kind":13,"containerName":null,"line":101},{"kind":12,"range":{"start":{"line":134,"character":0},"end":{"character":9999,"line":138}},"line":134,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :"},"name":"new","containerName":"main::","children":[{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$class","line":135},{"line":135,"name":"@args","kind":13,"containerName":"new"},{"line":136,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":136},{"name":"@args","kind":13,"containerName":"new","line":136},{"kind":13,"containerName":"new","name":"$self","line":137}],"detail":"($class,@args)","definition":"sub"},{"line":136,"name":"SUPER","containerName":"new","kind":12},{"children":[{"line":151,"localvar":"my","containerName":"next_result","kind":13,"name":"$self","definition":"my"},{"localvar":"my","containerName":"next_result","kind":13,"name":"$curquery","line":155,"definition":"my"},{"line":155,"containerName":"next_result","kind":13,"name":"$curhit"},{"kind":13,"containerName":"next_result","name":"$self","line":156},{"kind":12,"containerName":"next_result","name":"start_document","line":156},{"name":"@hit_signifs","kind":13,"localvar":"my","containerName":"next_result","line":157,"definition":"my"},{"kind":13,"containerName":"next_result","name":"$self","line":158},{"containerName":"next_result","kind":12,"name":"_readline","line":158},{"definition":"my","name":"$alnnum","localvar":"my","containerName":"next_result","kind":13,"line":168},{"line":168,"name":"$qname","containerName":"next_result","kind":13},{"line":168,"containerName":"next_result","kind":13,"name":"$qstart"},{"line":168,"name":"$qend","containerName":"next_result","kind":13},{"line":168,"kind":13,"containerName":"next_result","name":"$hname"},{"name":"$hstart","containerName":"next_result","kind":13,"line":169},{"line":169,"name":"$hend","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$hstrand","line":169},{"line":169,"name":"$score","kind":13,"containerName":"next_result"},{"line":171,"name":"$self","kind":13,"containerName":"next_result"},{"line":173,"name":"$qstart","kind":13,"containerName":"next_result"},{"line":173,"kind":13,"containerName":"next_result","name":"$qend"},{"name":"$hstart","kind":13,"containerName":"next_result","line":173},{"name":"$hend","containerName":"next_result","kind":13,"line":173},{"kind":13,"containerName":"next_result","name":"$curquery","line":174},{"name":"$curquery","containerName":"next_result","kind":13,"line":175},{"kind":13,"containerName":"next_result","name":"$qname","line":175},{"line":176,"containerName":"next_result","kind":13,"name":"$self"},{"line":176,"name":"end_element","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$self","line":177},{"line":177,"containerName":"next_result","kind":12,"name":"_pushback"},{"line":178,"containerName":"next_result","kind":13,"name":"$self"},{"name":"end_element","containerName":"next_result","kind":12,"line":178},{"containerName":"next_result","kind":13,"name":"$self","line":179},{"line":179,"name":"end_document","kind":12,"containerName":"next_result"},{"line":182,"name":"$curhit","containerName":"next_result","kind":13},{"name":"$curhit","containerName":"next_result","kind":13,"line":183},{"line":183,"kind":13,"containerName":"next_result","name":"$hname"},{"line":185,"name":"$self","containerName":"next_result","kind":13},{"line":185,"containerName":"next_result","kind":12,"name":"end_element"},{"name":"$self","containerName":"next_result","kind":13,"line":186},{"containerName":"next_result","kind":12,"name":"start_element","line":186},{"name":"$self","kind":13,"containerName":"next_result","line":187},{"line":187,"containerName":"next_result","kind":12,"name":"element"},{"containerName":"next_result","kind":13,"name":"$hname","line":188},{"containerName":"next_result","kind":13,"name":"$curquery","line":189},{"name":"$self","containerName":"next_result","kind":13,"line":190},{"line":190,"name":"start_element","kind":12,"containerName":"next_result"},{"line":191,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":13,"name":"$self","line":192},{"kind":12,"containerName":"next_result","name":"element","line":192},{"line":193,"name":"$qname","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$self","line":195},{"line":195,"kind":12,"containerName":"next_result","name":"start_element"},{"line":196,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"element","line":196},{"containerName":"next_result","kind":13,"name":"$hname","line":197},{"name":"$self","kind":13,"containerName":"next_result","line":199},{"containerName":"next_result","kind":12,"name":"start_element","line":199},{"definition":"my","name":"$queryalign","containerName":"next_result","localvar":"my","kind":13,"line":200},{"containerName":"next_result","kind":13,"name":"$self","line":200},{"line":200,"name":"_readline","kind":12,"containerName":"next_result"},{"line":201,"name":"$hitalign","localvar":"my","kind":13,"containerName":"next_result","definition":"my"},{"line":201,"name":"$self","containerName":"next_result","kind":13},{"line":201,"name":"_readline","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$queryalign","line":202},{"line":203,"kind":13,"containerName":"next_result","name":"$hitalign"},{"definition":"my","name":"$alnlen","kind":13,"localvar":"my","containerName":"next_result","line":204},{"line":204,"name":"$queryalign","kind":13,"containerName":"next_result"},{"definition":"my","line":205,"name":"$qgapnum","localvar":"my","containerName":"next_result","kind":13},{"name":"$queryalign","containerName":"next_result","kind":13,"line":205},{"line":206,"name":"$hgapnum","localvar":"my","containerName":"next_result","kind":13,"definition":"my"},{"line":206,"name":"$hitalign","containerName":"next_result","kind":13},{"name":"$totalgaps","localvar":"my","kind":13,"containerName":"next_result","line":207,"definition":"my"},{"name":"$qgapnum","kind":13,"containerName":"next_result","line":207},{"line":207,"kind":13,"containerName":"next_result","name":"$hgapnum"},{"name":"$hstrand","kind":13,"containerName":"next_result","line":209},{"name":"$hstart","kind":13,"containerName":"next_result","line":210},{"name":"$hend","kind":13,"containerName":"next_result","line":210},{"line":210,"name":"$hend","kind":13,"containerName":"next_result"},{"line":210,"name":"$hstart","kind":13,"containerName":"next_result"},{"line":212,"name":"$self","containerName":"next_result","kind":13},{"line":212,"kind":12,"containerName":"next_result","name":"element"},{"line":213,"containerName":"next_result","kind":13,"name":"$score"},{"name":"$self","kind":13,"containerName":"next_result","line":214},{"name":"element","containerName":"next_result","kind":12,"line":214},{"kind":13,"containerName":"next_result","name":"$qstart","line":215},{"kind":13,"containerName":"next_result","name":"$self","line":216},{"name":"element","containerName":"next_result","kind":12,"line":216},{"name":"$qend","containerName":"next_result","kind":13,"line":217},{"line":218,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"element","line":218},{"name":"$hstart","kind":13,"containerName":"next_result","line":219},{"line":220,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"element","line":220},{"name":"$hend","kind":13,"containerName":"next_result","line":221},{"line":222,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"element","line":222},{"name":"$qgapnum","containerName":"next_result","kind":13,"line":223},{"containerName":"next_result","kind":13,"name":"$hgapnum","line":223},{"line":224,"name":"$self","kind":13,"containerName":"next_result"},{"line":224,"name":"element","containerName":"next_result","kind":12},{"line":225,"containerName":"next_result","kind":13,"name":"$qgapnum"},{"name":"$self","containerName":"next_result","kind":13,"line":226},{"line":226,"name":"element","containerName":"next_result","kind":12},{"name":"$hgapnum","kind":13,"containerName":"next_result","line":227},{"name":"$self","containerName":"next_result","kind":13,"line":229},{"line":229,"containerName":"next_result","kind":12,"name":"element"},{"kind":13,"containerName":"next_result","name":"$alnlen","line":230},{"name":"$totalgaps","containerName":"next_result","kind":13,"line":230},{"name":"$self","containerName":"next_result","kind":13,"line":231},{"line":231,"name":"element","kind":12,"containerName":"next_result"},{"line":232,"kind":13,"containerName":"next_result","name":"$alnlen"},{"line":232,"containerName":"next_result","kind":13,"name":"$totalgaps"},{"line":233,"containerName":"next_result","kind":13,"name":"$self"},{"line":233,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","kind":13,"name":"$queryalign","line":234},{"line":235,"containerName":"next_result","kind":13,"name":"$self"},{"line":235,"name":"element","kind":12,"containerName":"next_result"},{"line":236,"name":"$hitalign","containerName":"next_result","kind":13},{"line":238,"name":"$self","kind":13,"containerName":"next_result"},{"line":238,"name":"end_element","kind":12,"containerName":"next_result"},{"name":"$curquery","containerName":"next_result","kind":13,"line":239},{"line":239,"name":"$qname","containerName":"next_result","kind":13},{"line":240,"containerName":"next_result","kind":13,"name":"$curhit"},{"name":"$hname","kind":13,"containerName":"next_result","line":240},{"line":244,"kind":13,"containerName":"next_result","name":"$curquery"},{"line":245,"kind":13,"containerName":"next_result","name":"$self"},{"line":245,"name":"end_element","kind":12,"containerName":"next_result"},{"name":"$self","kind":13,"containerName":"next_result","line":246},{"line":246,"name":"end_element","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":247},{"containerName":"next_result","kind":12,"name":"end_document","line":247}],"name":"next_result","containerName":"main::","definition":"sub","detail":"($self)","line":150,"range":{"start":{"character":0,"line":150},"end":{"line":250,"character":9999}},"kind":12,"signature":{"label":"next_result($self)","documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}]}},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","containerName":"_initialize","localvar":"my","kind":13,"name":"$self","line":253},{"line":253,"containerName":"_initialize","kind":13,"name":"@args"},{"name":"$self","kind":13,"containerName":"_initialize","line":254},{"kind":13,"containerName":"_initialize","name":"@args","line":254},{"name":"$self","containerName":"_initialize","kind":13,"line":255},{"line":255,"kind":12,"containerName":"_initialize","name":"_eventHandler"},{"line":255,"name":"register_factory","containerName":"_initialize","kind":12},{"line":255,"containerName":"_initialize","kind":12,"name":"new"},{"line":257,"name":"$self","kind":13,"containerName":"_initialize"},{"kind":12,"containerName":"_initialize","name":"_eventHandler","line":257},{"line":257,"name":"register_factory","containerName":"_initialize","kind":12},{"name":"new","containerName":"_initialize","kind":12,"line":257}],"containerName":"main::","name":"_initialize","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"line":252,"range":{"end":{"line":258,"character":9999},"start":{"character":0,"line":252}},"kind":12},{"name":"SUPER","kind":12,"containerName":"_initialize","line":254},{"line":255,"name":"Bio","kind":12,"containerName":"Search::Result::ResultFactory"},{"line":257,"name":"Bio","containerName":"Search::HSP::HSPFactory","kind":12},{"children":[{"definition":"my","line":273,"localvar":"my","containerName":"start_element","kind":13,"name":"$self"},{"kind":13,"containerName":"start_element","name":"$data","line":273},{"definition":"my","name":"$nm","localvar":"my","kind":13,"containerName":"start_element","line":275},{"name":"$data","containerName":"start_element","kind":13,"line":275},{"localvar":"my","containerName":"start_element","kind":13,"name":"$type","line":276,"definition":"my"},{"line":276,"kind":13,"containerName":"start_element","name":"$MODEMAP"},{"kind":13,"containerName":"start_element","name":"$nm","line":276},{"line":277,"name":"$self","containerName":"start_element","kind":13},{"line":277,"containerName":"start_element","kind":12,"name":"_mode"},{"name":"$type","kind":13,"containerName":"start_element","line":277},{"line":278,"name":"$self","containerName":"start_element","kind":13},{"line":278,"name":"_eventHandler","containerName":"start_element","kind":12},{"containerName":"start_element","kind":12,"name":"will_handle","line":278},{"name":"$type","kind":13,"containerName":"start_element","line":278},{"definition":"my","name":"$func","containerName":"start_element","localvar":"my","kind":13,"line":279},{"kind":13,"containerName":"start_element","name":"$type","line":279},{"containerName":"start_element","kind":13,"name":"$self","line":280},{"name":"_eventHandler","kind":12,"containerName":"start_element","line":280},{"name":"$func","kind":13,"containerName":"start_element","line":280},{"name":"$data","containerName":"start_element","kind":13,"line":280},{"line":282,"name":"$self","kind":13,"containerName":"start_element"},{"line":282,"containerName":"start_element","kind":13,"name":"$type"}],"containerName":"main::","name":"start_element","definition":"sub","detail":"($self,$data)","line":272,"kind":12,"range":{"end":{"character":9999,"line":283},"start":{"character":0,"line":272}},"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"start_element($self,$data)"}},{"line":284,"name":"%nm","containerName":null,"kind":13},{"name":"%self","kind":13,"containerName":null,"line":285},{"line":286,"kind":13,"containerName":null,"name":"%self"},{"line":287,"kind":13,"containerName":null,"name":"%self"},{"detail":"($self,$data)","definition":"sub","containerName":"main::","name":"end_element","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"end_element","line":304},{"name":"$data","containerName":"end_element","kind":13,"line":304},{"containerName":"end_element","localvar":"my","kind":13,"name":"$nm","line":305,"definition":"my"},{"name":"$data","kind":13,"containerName":"end_element","line":305},{"definition":"my","name":"$rc","kind":13,"localvar":"my","containerName":"end_element","line":306},{"definition":"my","line":310,"name":"$type","kind":13,"localvar":"my","containerName":"end_element"},{"line":310,"name":"$MODEMAP","kind":13,"containerName":"end_element"},{"containerName":"end_element","kind":13,"name":"$nm","line":310},{"line":311,"name":"$self","kind":13,"containerName":"end_element"},{"line":311,"containerName":"end_element","kind":12,"name":"_eventHandler"},{"name":"will_handle","containerName":"end_element","kind":12,"line":311},{"containerName":"end_element","kind":13,"name":"$type","line":311},{"localvar":"my","containerName":"end_element","kind":13,"name":"$func","line":312,"definition":"my"},{"line":312,"kind":13,"containerName":"end_element","name":"$type"},{"line":313,"containerName":"end_element","kind":13,"name":"$rc"},{"containerName":"end_element","kind":13,"name":"$self","line":313},{"kind":12,"containerName":"end_element","name":"_eventHandler","line":313},{"kind":13,"containerName":"end_element","name":"$func","line":313},{"line":313,"containerName":"end_element","kind":13,"name":"$self"},{"line":314,"kind":13,"containerName":"end_element","name":"$self"},{"name":"$self","kind":13,"containerName":"end_element","line":316}],"signature":{"label":"end_element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'"},"kind":12,"range":{"start":{"character":0,"line":303},"end":{"character":9999,"line":318}},"line":303},{"name":"%MAPPING","kind":13,"containerName":null,"line":318},{"kind":13,"containerName":null,"name":"%nm","line":318},{"kind":13,"containerName":null,"name":"%MAPPING","line":319},{"name":"%nm","containerName":null,"kind":13,"line":319},{"line":320,"localvar":"my","kind":13,"containerName":null,"name":"$key","definition":"my"},{"containerName":null,"kind":13,"name":"%MAPPING","line":320},{"containerName":null,"kind":13,"name":"@nm","line":320},{"kind":13,"containerName":null,"name":"%self","line":321},{"line":321,"name":"%key","containerName":null,"kind":13},{"name":"%MAPPING","containerName":null,"kind":13,"line":321},{"line":321,"name":"%nm","containerName":null,"kind":13},{"line":321,"name":"$key","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%self","line":321},{"line":323,"name":"%self","kind":13,"containerName":null},{"line":323,"containerName":null,"kind":13,"name":"%MAPPING"},{"line":323,"name":"$nm","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%self","line":323},{"kind":13,"containerName":null,"name":"$self","line":326},{"kind":12,"containerName":"main::","name":"warn","line":326},{"line":328,"name":"%self","containerName":null,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":330},{"name":"$rc","kind":13,"containerName":null,"line":330},{"name":"$nm","containerName":null,"kind":13,"line":330},{"name":"$rc","containerName":null,"kind":13,"line":331},{"definition":"sub","detail":"($self,$data)","children":[{"line":347,"kind":13,"localvar":"my","containerName":"element","name":"$self","definition":"my"},{"line":347,"containerName":"element","kind":13,"name":"$data"},{"kind":13,"containerName":"element","name":"$self","line":348},{"line":348,"name":"start_element","containerName":"element","kind":12},{"name":"$data","containerName":"element","kind":13,"line":348},{"name":"$self","kind":13,"containerName":"element","line":349},{"line":349,"containerName":"element","kind":12,"name":"characters"},{"name":"$data","containerName":"element","kind":13,"line":349},{"name":"$self","containerName":"element","kind":13,"line":350},{"line":350,"name":"end_element","containerName":"element","kind":12},{"name":"$data","kind":13,"containerName":"element","line":350}],"containerName":"main::","name":"element","signature":{"label":"element($self,$data)","documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","parameters":[{"label":"$self"},{"label":"$data"}]},"line":346,"range":{"end":{"character":9999,"line":351},"start":{"character":0,"line":346}},"kind":12},{"children":[{"definition":"my","line":366,"name":"$self","kind":13,"localvar":"my","containerName":"characters"},{"name":"$data","kind":13,"containerName":"characters","line":366},{"line":368,"containerName":"characters","kind":13,"name":"$data"},{"line":369,"containerName":"characters","kind":13,"name":"$data"},{"name":"$data","containerName":"characters","kind":13,"line":370},{"line":373,"containerName":"characters","kind":13,"name":"$self"},{"kind":12,"containerName":"characters","name":"in_element","line":373},{"line":374,"containerName":"characters","kind":13,"name":"$data"},{"containerName":"characters","kind":13,"name":"$self","line":376},{"kind":13,"containerName":"characters","name":"$data","line":376},{"kind":13,"containerName":"characters","name":"$data","line":376},{"line":379,"name":"$self","kind":13,"containerName":"characters"},{"line":379,"containerName":"characters","kind":13,"name":"$data"}],"containerName":"main::","name":"characters","definition":"sub","detail":"($self,$data)","line":365,"kind":12,"range":{"end":{"line":380,"character":9999},"start":{"line":365,"character":0}},"signature":{"label":"characters($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string"}},{"children":[{"definition":"my","line":395,"name":"$self","containerName":"_mode","localvar":"my","kind":13},{"line":395,"name":"$value","kind":13,"containerName":"_mode"},{"name":"$value","kind":13,"containerName":"_mode","line":396},{"containerName":"_mode","kind":13,"name":"$self","line":397},{"line":397,"kind":13,"containerName":"_mode","name":"$value"},{"line":399,"name":"$self","containerName":"_mode","kind":13}],"name":"_mode","containerName":"main::","definition":"sub","detail":"($self,$value)","line":394,"range":{"end":{"character":9999,"line":400},"start":{"character":0,"line":394}},"kind":12,"signature":{"label":"_mode($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)"}},{"line":415,"kind":12,"range":{"end":{"character":9999,"line":419},"start":{"character":0,"line":415}},"signature":{"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}],"label":"within_element($self,$name)"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"within_element","line":416,"definition":"my"},{"line":416,"kind":13,"containerName":"within_element","name":"$name"},{"name":"$name","containerName":"within_element","kind":13,"line":417},{"line":418,"name":"$self","kind":13,"containerName":"within_element"},{"line":419,"containerName":"within_element","kind":13,"name":"$self"}],"containerName":"main::","name":"within_element","definition":"sub","detail":"($self,$name)"},{"kind":13,"containerName":null,"name":"%self","line":420},{"kind":13,"containerName":null,"name":"%name","line":421},{"signature":{"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}],"label":"in_element($self,$name)"},"line":441,"range":{"start":{"character":0,"line":441},"end":{"character":9999,"line":445}},"kind":12,"definition":"sub","detail":"($self,$name)","children":[{"definition":"my","line":442,"name":"$self","localvar":"my","kind":13,"containerName":"in_element"},{"line":442,"name":"$name","kind":13,"containerName":"in_element"},{"containerName":"in_element","kind":13,"name":"$self","line":443},{"kind":13,"containerName":"in_element","name":"$self","line":444},{"line":444,"name":"$name","containerName":"in_element","kind":13}],"name":"in_element","containerName":"main::"},{"name":"start_document","containerName":"main::","children":[{"definition":"my","line":460,"name":"$self","localvar":"my","containerName":"start_document","kind":13},{"line":461,"kind":13,"containerName":"start_document","name":"$self"},{"line":462,"containerName":"start_document","kind":13,"name":"$self"},{"line":463,"name":"$self","containerName":"start_document","kind":13},{"line":464,"name":"$self","containerName":"start_document","kind":13},{"line":465,"kind":13,"containerName":"start_document","name":"$self"}],"detail":"($self)","definition":"sub","range":{"end":{"line":466,"character":9999},"start":{"line":459,"character":0}},"kind":12,"line":459,"signature":{"label":"start_document($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none"}},{"range":{"start":{"character":0,"line":480},"end":{"line":483,"character":9999}},"kind":12,"line":480,"signature":{"label":"end_document($self,@args)","documentation":"1;\n# $Id: axt.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::axt\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::axt - a parser for axt format reports\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-format => 'axt',\n                                 -file   => 't/data/report.blastz');\n  while( my $result = $parser->next_result ) {\n    while( my $hit = $result->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser and event-generator for AXT format reports.  BLASTZ\nreports (Schwartz et al,(2003) Genome Research, 13:103-107) are normally\nin LAV format but are commonly post-processed to AXT format; many precomputed\nBLASTZ reports, such as those found in the UCSC Genome\nBrowser, are in AXT format.   This parser will also parse any\nAXT format produced from any lav report and directly out of BLAT.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::axt;\nuse vars qw(%MODEMAP %MAPPING @STATES $GAPCHAR);\nuse strict;\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\nuse base qw(Bio::SearchIO);\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('AXTOutput'   => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    $GAPCHAR = '-';\n    %MAPPING = \n\t( \n\t  'Hsp_score'      => 'HSP-score',\n          'Hsp_query-from' => 'HSP-query_start',\n          'Hsp_query-to'   => 'HSP-query_end',\n          'Hsp_hit-from'   => 'HSP-hit_start',\n          'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hsp_positive'   => 'HSP-conserved',\n          'Hsp_identity'   => 'HSP-identical',\n          'Hsp_gaps'       => 'HSP-hsp_gaps',\n          'Hsp_hitgaps'    => 'HSP-hit_gaps',\n          'Hsp_querygaps'  => 'HSP-query_gaps',\n          'Hsp_qseq'       => 'HSP-query_seq',\n          'Hsp_hseq'       => 'HSP-hit_seq',\n          'Hsp_midline'    => 'HSP-homology_seq', # ignoring this for now\n          'Hsp_align-len'  => 'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\t  \n\t  'AXTOutput_query-def'=> 'RESULT-query_name',\t  \n\t  );\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::axt->new();\n Function: Builds a new Bio::SearchIO::axt object \n Returns : an instance of Bio::SearchIO::axt\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    my ($curquery,$curhit);\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\tnext if (/^\\s+$/);\n\tif( m/^(\\d+)\\s+      # alignment number - we'll throw this away anyways\n\t    (\\S+)\\s+         # Query name      \n\t    (\\d+)\\s+(\\d+)\\s+ # Query start Query end (always + strand, 0 based)\n\t    (\\S+)\\s+         # Hit name\n\t    (\\d+)\\s+(\\d+)\\s+ # Hit start Hit end (0 based)\n\t    ([\\-\\+])\\s+      # Hit strand\n\t    ([\\d\\.\\-]+)\\s+   # Score\n\t    /ox ) {\n\t    my ($alnnum, $qname,$qstart,$qend, $hname,\n\t\t$hstart,$hend,$hstrand, $score) = ($1,$2,$3,$4,$5,\n\t\t\t\t\t\t   $6,$7,$8,$9);\n\t    $self->{'_reporttype'} = 'AXT';\n\t    # Jim's code is 0 based\n\t    $qstart++;  $qend++; $hstart++; $hend++;\n\t    if( defined $curquery && \n\t\t$curquery ne $qname ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'AXTOutput'});\n\t\treturn $self->end_document();\n\t    }\n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hname) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    } elsif ( ! defined $curquery ) { \n\t\t$self->start_element({'Name' => 'AXTOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'AXTOutput_query-def',\n\t\t\t\t'Data' => $qname });\n\t\t\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hname});\n\t    }\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    my $queryalign = $self->_readline;\n\t    my $hitalign   = $self->_readline;\n\t    chomp($queryalign);\n\t    chomp($hitalign);\n\t    my $alnlen = length($queryalign);\n\t    my $qgapnum = ( $queryalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $hgapnum = ( $hitalign =~ s/\\Q$GAPCHAR/$GAPCHAR/g); \n\t    my $totalgaps = ($qgapnum + $hgapnum);\n\t    \n\t    if( $hstrand eq '-' ) { # strand gets inferred by start/end\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\t    $self->element({'Name' => 'Hsp_score',\n\t\t\t    'Data' => $score});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_gaps',\n\t\t\t    'Data' => $qgapnum + $hgapnum});\n\t    $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t    'Data' => $qgapnum});\n\t    $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t    'Data' => $hgapnum});\n\t    \n\t    $self->element({'Name' => 'Hsp_identity',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_positive',\n\t\t\t    'Data' => $alnlen - $totalgaps});\n\t    $self->element({'Name' => 'Hsp_qseq',\n\t\t\t    'Data' => $queryalign});\n\t    $self->element({'Name' => 'Hsp_hseq',\n\t\t\t    'Data' => $hitalign});\n\t    \n\t    $self->end_element({'Name' => 'Hsp'});\t    \n\t    $curquery = $qname;\n\t    $curhit   = $hname;\t   \n\t}\n    }\n    # fence post\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'AXTOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'AXTOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'AXTOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_mode'} = '';\n    $self->{'_elements'} = [];\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"name":"end_document","containerName":"main::","children":[{"definition":"my","line":481,"name":"$self","kind":13,"localvar":"my","containerName":"end_document"},{"containerName":"end_document","kind":13,"name":"@args","line":481},{"line":482,"kind":13,"containerName":"end_document","name":"$self"}],"detail":"($self,@args)","definition":"sub"},{"definition":"sub","name":"result_count","containerName":"main::","children":[{"definition":"my","line":497,"name":"$self","kind":13,"localvar":"my","containerName":"result_count"},{"line":498,"name":"$self","containerName":"result_count","kind":13}],"kind":12,"range":{"start":{"character":0,"line":496},"end":{"character":9999,"line":499}},"line":496},{"definition":"sub","children":[{"line":501,"containerName":"report_count","kind":12,"name":"result_count"}],"name":"report_count","containerName":"main::","line":501,"kind":12,"range":{"start":{"character":0,"line":501},"end":{"character":9999,"line":501}}}],"version":5}