{"vars":[{"name":"vars","kind":2,"containerName":"","line":128},{"kind":13,"containerName":null,"name":"$MaxDescLen","line":134},{"line":134,"name":"strict","kind":2,"containerName":""},{"containerName":null,"kind":13,"name":"%AlignmentLineWidth","line":135},{"name":"$TextWrapLoaded","containerName":null,"kind":13,"line":136},{"name":"Text","containerName":"Wrap","kind":12,"line":136},{"kind":13,"containerName":null,"name":"$TextWrapLoaded","line":138},{"name":"base","containerName":"","kind":2,"line":144},{"signature":{"documentation":"1;\n# $Id: TextResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::TextResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::TextResultWriter - Object to implement writing\na Bio::Search::ResultI in Text.\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::TextResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::TextResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of Text for a specific Bio::Search::Report::ReportI interface.\n\nYou can also provide the argument -filters =E<gt> \\%hash to filter the at\nthe hsp, hit, or result level.  %hash is an associative array which\ncontains any or all of the keys (HSP, HIT, RESULT).  The values\npointed to by these keys would be references to a subroutine which\nexpects to be passed an object - one of Bio::Search::HSP::HSPI,\nBio::Search::Hit::HitI, and Bio::Search::Result::ResultI respectively.\nEach function needs to return a boolean value as to whether or not the\npassed element should be included in the output report - true if it is\nto be included, false if it to be omitted.\n\nFor example to filter on sequences in the database which are too short\nfor your criteria you would do the following.\n\nDefine a hit filter method \n\n  sub hit_filter { \n      my $hit = shift;\n      return $hit->length E<gt> 100; # test if length of the hit sequence\n                                     # long enough    \n  }\n  my $writer = Bio::SearchIO::Writer::TextResultWriter->new(\n       -filters => { 'HIT' =E<gt> \\&hit_filter }  \n      );\n\nAnother example would be to filter HSPs on percent identity, let's\nonly include HSPs which are 75% identical or better.\n\n   sub hsp_filter {\n       my $hsp = shift;\n       return $hsp->percent_identity E<gt> 75;\n   }\n   my $writer = Bio::SearchIO::Writer::TextResultWriter->new(\n       -filters => { 'HSP' =E<gt> \\&hsp_filter }  \n      );\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n\nThis module will use the module Text::Wrap if it is installed to wrap\nthe Query description line.  If you do not have Text::Wrap installed\nthis module will work fine but you won't have the Query line wrapped.\nYou will see a warning about this when you first instantiate a\nTextResultWriter - to avoid these warnings from showing up, simply set\nthe verbosity upon initialization to -1 like this: my $writer = new\nBio::SearchIO::Writer::TextResultWriter(-verbose =E<gt> -1);\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::Writer::TextResultWriter;\nuse vars qw($MaxNameLen $MaxDescLen $AlignmentLineWidth \t    $DescLineLen $TextWrapLoaded);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $MaxDescLen = 65;\n    $AlignmentLineWidth = 60;    \n    eval { require Text::Wrap; $TextWrapLoaded = 1;};\n    if( $@ ) {\n\t$TextWrapLoaded = 0;\n    }\n}\n\nuse POSIX;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::TextResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::TextResultWriter object \n Returns : Bio::SearchIO::Writer::TextResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a Hit,HSP, Result object respectively\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines even if \n                               they are parsed out\n                               Links = (1) ","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"kind":12,"range":{"end":{"line":176,"character":9999},"start":{"character":0,"line":161}},"line":161,"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"definition":"my","line":162,"localvar":"my","containerName":"new","kind":13,"name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":162},{"localvar":"my","kind":13,"containerName":"new","name":"$self","line":164,"definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":164},{"name":"@args","kind":13,"containerName":"new","line":164},{"localvar":"my","containerName":"new","kind":13,"name":"$filters","line":165,"definition":"my"},{"name":"$nowublastlinks","kind":13,"containerName":"new","line":165},{"name":"$self","kind":13,"containerName":"new","line":165},{"line":165,"name":"_rearrange","containerName":"new","kind":12},{"name":"@args","kind":13,"containerName":"new","line":167},{"line":168,"name":"$filters","kind":13,"containerName":"new"},{"name":"$filters","containerName":"new","kind":13,"line":169},{"kind":13,"containerName":"new","name":"$self","line":170},{"line":170,"kind":12,"containerName":"new","name":"warn"},{"definition":"my","line":172,"name":"$type","kind":13,"localvar":"my","containerName":"new"},{"containerName":"new","kind":13,"name":"$code","line":172},{"line":172,"containerName":"new","kind":13,"name":"$filters"},{"containerName":"new","kind":13,"name":"$self","line":173},{"line":173,"containerName":"new","kind":12,"name":"filter"},{"name":"$type","kind":13,"containerName":"new","line":173},{"line":173,"name":"$code","containerName":"new","kind":13}]},{"line":164,"kind":12,"containerName":"new","name":"SUPER"},{"name":"$self","containerName":null,"kind":13,"line":177},{"kind":12,"containerName":"main::","name":"no_wublastlinks","line":177},{"line":177,"name":"$nowublastlinks","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%TextWrapLoaded","line":178},{"containerName":null,"kind":13,"name":"$self","line":179},{"containerName":"main::","kind":12,"name":"warn","line":179},{"name":"$Text","containerName":null,"kind":13,"line":181},{"line":181,"name":"Wrap","containerName":"columns","kind":12},{"kind":13,"containerName":null,"name":"$MaxDescLen","line":181},{"containerName":null,"kind":13,"name":"$self","line":183},{"definition":"sub","detail":"($self,$result,$num)","children":[{"definition":"my","line":203,"name":"$self","containerName":"to_string","localvar":"my","kind":13},{"line":203,"name":"$result","containerName":"to_string","kind":13},{"kind":13,"containerName":"to_string","name":"$num","line":203},{"name":"$num","kind":13,"containerName":"to_string","line":204},{"line":205,"containerName":"to_string","kind":13,"name":"$result"},{"definition":"my","line":206,"kind":13,"localvar":"my","containerName":"to_string","name":"$links"},{"line":206,"name":"$self","containerName":"to_string","kind":13},{"kind":12,"containerName":"to_string","name":"no_wublastlinks","line":206},{"line":207,"name":"$resultfilter","kind":13,"localvar":"my","containerName":"to_string","definition":"my"},{"line":207,"containerName":"to_string","kind":13,"name":"$hitfilter"},{"line":207,"kind":13,"containerName":"to_string","name":"$hspfilter"},{"line":207,"name":"$self","containerName":"to_string","kind":13},{"kind":12,"containerName":"to_string","name":"filter","line":207},{"line":208,"kind":13,"containerName":"to_string","name":"$self"},{"name":"filter","kind":12,"containerName":"to_string","line":208},{"line":209,"name":"$self","kind":13,"containerName":"to_string"},{"containerName":"to_string","kind":12,"name":"filter","line":209},{"line":210,"name":"$resultfilter","kind":13,"containerName":"to_string"},{"line":210,"name":"$resultfilter","kind":13,"containerName":"to_string"}],"containerName":"main::","name":"to_string","signature":{"parameters":[{"label":"$self"},{"label":"$result"},{"label":"$num"}],"documentation":"1;\n# $Id: TextResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::TextResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::TextResultWriter - Object to implement writing\na Bio::Search::ResultI in Text.\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  use Bio::SearchIO::Writer::TextResultWriter;\n\n  my $in = Bio::SearchIO->new(-format => 'blast',\n\t\t\t     -file   => shift @ARGV);\n\n  my $writer = Bio::SearchIO::Writer::TextResultWriter->new();\n  my $out = Bio::SearchIO->new(-writer => $writer);\n  $out->write_result($in->next_result);\n\n=head1 DESCRIPTION\n\nThis object implements the SearchWriterI interface which will produce\na set of Text for a specific Bio::Search::Report::ReportI interface.\n\nYou can also provide the argument -filters =E<gt> \\%hash to filter the at\nthe hsp, hit, or result level.  %hash is an associative array which\ncontains any or all of the keys (HSP, HIT, RESULT).  The values\npointed to by these keys would be references to a subroutine which\nexpects to be passed an object - one of Bio::Search::HSP::HSPI,\nBio::Search::Hit::HitI, and Bio::Search::Result::ResultI respectively.\nEach function needs to return a boolean value as to whether or not the\npassed element should be included in the output report - true if it is\nto be included, false if it to be omitted.\n\nFor example to filter on sequences in the database which are too short\nfor your criteria you would do the following.\n\nDefine a hit filter method \n\n  sub hit_filter { \n      my $hit = shift;\n      return $hit->length E<gt> 100; # test if length of the hit sequence\n                                     # long enough    \n  }\n  my $writer = Bio::SearchIO::Writer::TextResultWriter->new(\n       -filters => { 'HIT' =E<gt> \\&hit_filter }  \n      );\n\nAnother example would be to filter HSPs on percent identity, let's\nonly include HSPs which are 75% identical or better.\n\n   sub hsp_filter {\n       my $hsp = shift;\n       return $hsp->percent_identity E<gt> 75;\n   }\n   my $writer = Bio::SearchIO::Writer::TextResultWriter->new(\n       -filters => { 'HSP' =E<gt> \\&hsp_filter }  \n      );\n\nSee L<Bio::SearchIO::SearchWriterI> for more info on the filter method.\n\n\nThis module will use the module Text::Wrap if it is installed to wrap\nthe Query description line.  If you do not have Text::Wrap installed\nthis module will work fine but you won't have the Query line wrapped.\nYou will see a warning about this when you first instantiate a\nTextResultWriter - to avoid these warnings from showing up, simply set\nthe verbosity upon initialization to -1 like this: my $writer = new\nBio::SearchIO::Writer::TextResultWriter(-verbose =E<gt> -1);\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::Writer::TextResultWriter;\nuse vars qw($MaxNameLen $MaxDescLen $AlignmentLineWidth \t    $DescLineLen $TextWrapLoaded);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::RootI\n\nBEGIN {\n    $MaxDescLen = 65;\n    $AlignmentLineWidth = 60;    \n    eval { require Text::Wrap; $TextWrapLoaded = 1;};\n    if( $@ ) {\n\t$TextWrapLoaded = 0;\n    }\n}\n\nuse POSIX;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::TextResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::TextResultWriter object \n Returns : Bio::SearchIO::Writer::TextResultWriter\n Args    : -filters => hashref with any or all of the keys (HSP HIT RESULT)\n           which have values pointing to a subroutine reference\n           which will expect to get a Hit,HSP, Result object respectively\n           -no_wublastlinks => boolean. Do not display WU-BLAST lines even if \n                               they are parsed out\n                               Links = (1) \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($filters,$nowublastlinks) = $self->_rearrange([qw(FILTERS \n\t\t\t\t\t\t\tNO_WUBLASTLINKS)],\n\t\t\t\t\t\t    @args);\n  if( defined $filters ) {\n      if( !ref($filters) =~ /HASH/i ) { \n\t  $self->warn(\"Did not provide a hashref for the FILTERS option, ignoring.\");\n      } else { \n\t  while( my ($type,$code) = each %{$filters} ) {\n\t      $self->filter($type,$code);\n\t  }\n      }\n  }\n  $self->no_wublastlinks(! $nowublastlinks);\n  unless( $TextWrapLoaded ) {\n      $self->warn(\"Could not load Text::Wrap - the Query Description will not be line wrapped\\n\");\n  } else { \n      $Text::Wrap::columns =  $MaxDescLen;\n  }\n  return $self;\n}\n\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a","label":"to_string($self,$result,$num)"},"line":202,"kind":12,"range":{"start":{"character":0,"line":202},"end":{"character":9999,"line":210}}},{"line":210,"kind":13,"containerName":null,"name":"$result"},{"name":"$qtype","containerName":null,"localvar":"my","kind":13,"line":212,"definition":"my"},{"kind":13,"containerName":null,"name":"$dbtype","line":212},{"name":"$dbseqtype","containerName":null,"kind":13,"line":212},{"line":212,"name":"$type","containerName":null,"kind":13},{"line":213,"name":"$alg","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":213,"name":"$result","containerName":null,"kind":13},{"line":213,"kind":12,"containerName":"main::","name":"algorithm"},{"containerName":null,"localvar":"my","kind":13,"name":"$wublast","line":215,"definition":"my"},{"name":"$result","containerName":null,"kind":13,"line":215},{"line":215,"name":"algorithm_version","kind":12,"containerName":"main::"},{"line":218,"kind":13,"containerName":null,"name":"%alg"},{"name":"$qtype","kind":13,"containerName":null,"line":219},{"name":"$dbtype","kind":13,"containerName":null,"line":219},{"line":220,"kind":13,"containerName":null,"name":"$dbseqtype"},{"name":"$type","containerName":null,"kind":13,"line":220},{"name":"%alg","containerName":null,"kind":13,"line":221},{"line":222,"kind":13,"containerName":null,"name":"$qtype"},{"line":223,"kind":13,"containerName":null,"name":"$dbtype"},{"line":224,"kind":13,"containerName":null,"name":"$type"},{"line":225,"containerName":null,"kind":13,"name":"$dbseqtype"},{"line":226,"name":"$alg","containerName":null,"kind":13},{"line":227,"name":"%alg","kind":13,"containerName":null},{"line":228,"name":"$qtype","containerName":null,"kind":13},{"line":228,"containerName":null,"kind":13,"name":"$dbtype"},{"line":229,"containerName":null,"kind":13,"name":"$type"},{"kind":13,"containerName":null,"name":"$dbseqtype","line":229},{"line":230,"name":"$alg","kind":13,"containerName":null},{"line":231,"containerName":null,"kind":13,"name":"%alg"},{"line":232,"name":"$qtype","kind":13,"containerName":null},{"name":"$dbtype","containerName":null,"kind":13,"line":232},{"containerName":null,"kind":13,"name":"$type","line":233},{"name":"$dbseqtype","containerName":null,"kind":13,"line":233},{"line":234,"containerName":null,"kind":13,"name":"%alg"},{"kind":13,"containerName":null,"name":"$qtype","line":235},{"line":236,"kind":13,"containerName":null,"name":"$dbtype"},{"line":237,"name":"$dbseqtype","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%type","line":237},{"line":239,"name":"$result","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"algorithm","line":239},{"definition":"my","name":"%baselens","localvar":"my","containerName":null,"kind":13,"line":243},{"line":243,"containerName":null,"kind":13,"name":"$dbtype"},{"name":"$qtype","kind":13,"containerName":null,"line":244},{"definition":"my","line":246,"containerName":null,"localvar":"my","kind":13,"name":"$str"},{"kind":13,"containerName":null,"name":"$num","line":247},{"name":"%num","containerName":null,"kind":13,"line":247},{"kind":13,"containerName":null,"name":"$str","line":248},{"line":248,"kind":13,"containerName":null,"name":"$self"},{"line":248,"kind":12,"containerName":"main::","name":"start_report"},{"line":248,"containerName":null,"kind":13,"name":"$result"},{"line":251,"name":"$str","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$self","line":251},{"name":"title","kind":12,"containerName":"main::","line":251},{"line":251,"kind":13,"containerName":null,"name":"$result"},{"line":253,"kind":13,"containerName":null,"name":"$str"},{"kind":13,"containerName":null,"name":"$result","line":253},{"containerName":"main::","kind":12,"name":"algorithm_reference","line":253},{"line":253,"name":"$self","kind":13,"containerName":null},{"line":253,"name":"algorithm_reference","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$result","line":253},{"line":254,"containerName":null,"kind":13,"name":"$str"},{"kind":13,"containerName":null,"name":"$self","line":254},{"line":254,"name":"introduction","kind":12,"containerName":"main::"},{"line":254,"containerName":null,"kind":13,"name":"$result"},{"line":257,"name":"$str","containerName":null,"kind":13},{"kind":13,"localvar":"my","containerName":null,"name":"$hspstr","line":262,"definition":"my"},{"line":263,"containerName":null,"kind":13,"name":"$result"},{"kind":12,"containerName":"main::","name":"can","line":263},{"name":"$result","containerName":null,"kind":13,"line":264},{"line":264,"name":"rewind","kind":12,"containerName":"main::"},{"definition":"my","line":266,"name":"$hit","containerName":null,"localvar":"my","kind":13},{"name":"$result","kind":13,"containerName":null,"line":266},{"line":266,"kind":12,"containerName":"main::","name":"next_hit"},{"line":267,"kind":13,"containerName":null,"name":"$hitfilter"},{"kind":13,"containerName":null,"name":"$hitfilter","line":267},{"containerName":null,"kind":13,"name":"$hit","line":267},{"name":"$nm","containerName":null,"localvar":"my","kind":13,"line":268,"definition":"my"},{"line":268,"kind":13,"containerName":null,"name":"$hit"},{"line":268,"kind":12,"containerName":"main::","name":"name"},{"line":269,"name":"$self","containerName":null,"kind":13},{"name":"debug","containerName":"main::","kind":12,"line":269},{"line":269,"name":"$hit","kind":13,"containerName":null},{"line":269,"name":"description","containerName":"main::","kind":12},{"name":"$nm","containerName":null,"kind":13,"line":270},{"definition":"my","line":271,"containerName":null,"localvar":"my","kind":13,"name":"$gi"},{"line":271,"kind":13,"containerName":null,"name":"$acc"},{"name":"$self","containerName":null,"kind":13,"line":271},{"kind":12,"containerName":"main::","name":"id_parser","line":271},{"line":271,"containerName":null,"kind":13,"name":"$nm"},{"name":"$p","localvar":"my","containerName":null,"kind":13,"line":272,"definition":"my"},{"line":273,"name":"$descsub","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"$desc","kind":13,"localvar":"my","containerName":null,"line":274,"definition":"my"},{"line":274,"containerName":null,"kind":13,"name":"$nm"},{"name":"$hit","containerName":null,"kind":13,"line":274},{"name":"description","containerName":"main::","kind":12,"line":274},{"line":275,"containerName":null,"kind":13,"name":"$desc"},{"containerName":null,"kind":13,"name":"%MaxDescLen","line":275},{"line":276,"name":"$descsub","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$p","line":276},{"containerName":null,"kind":13,"name":"$desc","line":277},{"kind":13,"containerName":null,"name":"%MaxDescLen","line":277},{"name":"$descsub","kind":13,"containerName":null,"line":280},{"line":280,"containerName":null,"kind":13,"name":"$p"},{"name":"$desc","kind":13,"containerName":null,"line":280},{"name":"$str","kind":13,"containerName":null,"line":282},{"line":282,"kind":13,"containerName":null,"name":"$wublast"},{"name":"$descsub","containerName":null,"kind":13,"line":283},{"kind":13,"containerName":null,"name":"$hit","line":284},{"name":"raw_score","containerName":"main::","kind":12,"line":284},{"line":284,"kind":13,"containerName":null,"name":"$hit"},{"name":"raw_score","kind":12,"containerName":"main::","line":284},{"kind":13,"containerName":null,"name":"$hit","line":285},{"kind":12,"containerName":"main::","name":"significance","line":285},{"containerName":null,"kind":13,"name":"$hit","line":285},{"line":285,"name":"significance","kind":12,"containerName":"main::"},{"name":"$descsub","kind":13,"containerName":null,"line":287},{"line":288,"kind":13,"containerName":null,"name":"$hit"},{"name":"bits","containerName":"main::","kind":12,"line":288},{"kind":13,"containerName":null,"name":"$hit","line":288},{"kind":12,"containerName":"main::","name":"bits","line":288},{"containerName":null,"kind":13,"name":"$hit","line":289},{"name":"significance","containerName":"main::","kind":12,"line":289},{"line":289,"name":"$hit","kind":13,"containerName":null},{"line":289,"name":"significance","kind":12,"containerName":"main::"},{"line":290,"name":"@hsps","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":290,"containerName":null,"kind":13,"name":"$hit"},{"kind":12,"containerName":"main::","name":"hsps","line":290},{"name":"@hsps","containerName":null,"kind":13,"line":291},{"line":292,"kind":13,"containerName":null,"name":"$hspstr"},{"line":293,"name":"$hit","kind":13,"containerName":null},{"line":293,"name":"name","kind":12,"containerName":"main::"},{"line":294,"name":"$hit","kind":13,"containerName":null},{"line":294,"name":"description","kind":12,"containerName":"main::"},{"line":294,"containerName":null,"kind":13,"name":"$hit"},{"containerName":"main::","kind":12,"name":"description","line":294},{"line":296,"kind":13,"containerName":null,"name":"$hit"},{"line":296,"name":"length","kind":12,"containerName":"main::"},{"name":"$hsp","localvar":"my","kind":13,"containerName":null,"line":298,"definition":"my"},{"containerName":null,"kind":13,"name":"@hsps","line":298},{"line":299,"kind":13,"containerName":null,"name":"$hspfilter"},{"containerName":null,"kind":13,"name":"$hspfilter","line":299},{"line":299,"containerName":null,"kind":13,"name":"$hsp"},{"line":300,"name":"$hspstr","containerName":null,"kind":13},{"line":301,"kind":13,"containerName":null,"name":"$hsp"},{"line":301,"kind":12,"containerName":"main::","name":"bits"},{"line":301,"containerName":null,"kind":13,"name":"$hsp"},{"line":301,"name":"score","kind":12,"containerName":"main::"},{"line":301,"containerName":null,"kind":13,"name":"$hsp"},{"containerName":"main::","kind":12,"name":"evalue","line":301},{"name":"$hsp","containerName":null,"kind":13,"line":302},{"name":"pvalue","containerName":"main::","kind":12,"line":302},{"name":"$hspstr","kind":13,"containerName":null,"line":303},{"line":303,"kind":13,"containerName":null,"name":"$hsp"},{"kind":12,"containerName":"main::","name":"pvalue","line":303},{"name":"$hspstr","containerName":null,"kind":13,"line":305},{"line":306,"name":"$hspstr","containerName":null,"kind":13},{"line":307,"name":"$hsp","containerName":null,"kind":13},{"name":"frac_identical","containerName":"main::","kind":12,"line":307},{"line":308,"containerName":null,"kind":13,"name":"$hsp"},{"line":308,"containerName":"main::","kind":12,"name":"length"},{"kind":13,"containerName":null,"name":"$hsp","line":309},{"name":"length","containerName":"main::","kind":12,"line":309},{"name":"POSIX","kind":12,"containerName":"floor","line":310},{"line":310,"kind":13,"containerName":null,"name":"$hsp"},{"name":"frac_identical","containerName":"main::","kind":12,"line":310},{"line":313,"kind":13,"containerName":null,"name":"%type"},{"line":314,"kind":13,"containerName":null,"name":"$hspstr"},{"kind":13,"containerName":null,"name":"$hsp","line":315},{"line":315,"name":"frac_conserved","containerName":"main::","kind":12},{"name":"$hsp","kind":13,"containerName":null,"line":316},{"name":"length","containerName":"main::","kind":12,"line":316},{"line":317,"name":"$hsp","kind":13,"containerName":null},{"name":"length","kind":12,"containerName":"main::","line":317},{"name":"POSIX","kind":12,"containerName":"floor","line":318},{"line":318,"kind":13,"containerName":null,"name":"$hsp"},{"name":"frac_conserved","containerName":"main::","kind":12,"line":318},{"name":"$hsp","kind":13,"containerName":null,"line":321},{"kind":12,"containerName":"main::","name":"gaps","line":321},{"kind":13,"containerName":null,"name":"$hspstr","line":322},{"name":"$hsp","containerName":null,"kind":13,"line":323},{"line":323,"name":"gaps","kind":12,"containerName":"main::"},{"line":324,"kind":13,"containerName":null,"name":"$hsp"},{"line":324,"containerName":"main::","kind":12,"name":"length"},{"name":"POSIX","containerName":"floor","kind":12,"line":325},{"line":325,"name":"$hsp","kind":13,"containerName":null},{"line":325,"name":"gaps","kind":12,"containerName":"main::"},{"line":326,"name":"$hsp","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"length","line":326},{"line":328,"name":"$hspstr","containerName":null,"kind":13},{"definition":"my","line":329,"localvar":"my","kind":13,"containerName":null,"name":"$hframe"},{"name":"$qframe","kind":13,"containerName":null,"line":329},{"kind":13,"containerName":null,"name":"$hsp","line":329},{"kind":12,"containerName":"main::","name":"hit","line":329},{"kind":12,"containerName":"main::","name":"frame","line":329},{"kind":13,"containerName":null,"name":"$hsp","line":330},{"line":330,"containerName":"main::","kind":12,"name":"query"},{"containerName":"main::","kind":12,"name":"frame","line":330},{"definition":"my","line":331,"name":"$hstrand","kind":13,"localvar":"my","containerName":null},{"kind":13,"containerName":null,"name":"$qstrand","line":331},{"line":331,"containerName":null,"kind":13,"name":"$hsp"},{"name":"hit","containerName":"main::","kind":12,"line":331},{"name":"strand","kind":12,"containerName":"main::","line":331},{"line":331,"name":"$hsp","containerName":null,"kind":13},{"line":331,"containerName":"main::","kind":12,"name":"query"},{"line":331,"containerName":"main::","kind":12,"name":"strand"},{"line":335,"name":"$hstrand","kind":13,"containerName":null},{"name":"%qstrand","kind":13,"containerName":null,"line":335},{"name":"$hspstr","containerName":null,"kind":13,"line":336},{"definition":"my","line":337,"name":"$signq","localvar":"my","kind":13,"containerName":null},{"line":337,"name":"$signh","containerName":null,"kind":13},{"line":338,"containerName":null,"kind":13,"name":"%hstrand"},{"line":339,"containerName":null,"kind":13,"name":"%hframe"},{"line":343,"name":"$signh","kind":13,"containerName":null},{"name":"$hstrand","kind":13,"containerName":null,"line":343},{"line":345,"name":"%qstrand","kind":13,"containerName":null},{"name":"%qframe","containerName":null,"kind":13,"line":346},{"name":"$signq","containerName":null,"kind":13,"line":349},{"line":349,"containerName":null,"kind":13,"name":"$qstrand"},{"line":354,"name":"$hframe","containerName":null,"kind":13},{"line":354,"name":"%qframe","containerName":null,"kind":13},{"line":355,"containerName":null,"kind":13,"name":"$hspstr"},{"name":"$hframe","kind":13,"containerName":null,"line":355},{"line":356,"name":"$qframe","containerName":null,"kind":13},{"line":356,"name":"%hframe","kind":13,"containerName":null},{"name":"$hspstr","kind":13,"containerName":null,"line":357},{"name":"%qframe","containerName":null,"kind":13,"line":357},{"line":359,"kind":13,"containerName":null,"name":"$hspstr"},{"line":360,"name":"$signq","kind":13,"containerName":null},{"line":360,"name":"$qframe","kind":13,"containerName":null},{"line":361,"containerName":null,"kind":13,"name":"$signh"},{"line":361,"kind":13,"containerName":null,"name":"$hframe"},{"line":365,"name":"$links","containerName":null,"kind":13},{"line":366,"name":"$hsp","kind":13,"containerName":null},{"name":"can","kind":12,"containerName":"main::","line":366},{"definition":"my","name":"$lnks","kind":13,"localvar":"my","containerName":null,"line":366},{"line":366,"containerName":null,"kind":13,"name":"$hsp"},{"line":366,"kind":12,"containerName":"main::","name":"links"},{"line":367,"kind":13,"containerName":null,"name":"$hspstr"},{"kind":13,"containerName":null,"name":"$lnks","line":367},{"line":369,"name":"$hspstr","containerName":null,"kind":13},{"definition":"my","line":371,"kind":13,"localvar":"my","containerName":null,"name":"@hspvals"},{"containerName":null,"kind":13,"name":"$hsp","line":372},{"line":372,"containerName":"main::","kind":12,"name":"query_string"},{"line":373,"kind":13,"containerName":null,"name":"$qstrand"},{"line":374,"name":"$hsp","kind":13,"containerName":null},{"line":374,"containerName":"main::","kind":12,"name":"query"},{"name":"start","kind":12,"containerName":"main::","line":374},{"name":"$hsp","containerName":null,"kind":13,"line":375},{"name":"query","kind":12,"containerName":"main::","line":375},{"name":"end","containerName":"main::","kind":12,"line":375},{"line":376,"kind":13,"containerName":null,"name":"$qstrand"},{"kind":13,"containerName":null,"name":"$hsp","line":377},{"line":377,"kind":12,"containerName":"main::","name":"query"},{"kind":12,"containerName":"main::","name":"end","line":377},{"name":"$hsp","kind":13,"containerName":null,"line":378},{"name":"query","containerName":"main::","kind":12,"line":378},{"name":"start","containerName":"main::","kind":12,"line":378},{"kind":13,"containerName":null,"name":"%qstrand","line":380},{"line":382,"name":"x6","kind":12},{"name":"$hsp","kind":13,"containerName":null,"line":383},{"line":383,"kind":12,"containerName":"main::","name":"homology_string"},{"line":390,"containerName":null,"kind":13,"name":"$hsp"},{"name":"hit_string","containerName":"main::","kind":12,"line":390},{"line":391,"name":"$hstrand","kind":13,"containerName":null},{"line":392,"containerName":null,"kind":13,"name":"$hsp"},{"containerName":"main::","kind":12,"name":"hit","line":392},{"containerName":"main::","kind":12,"name":"start","line":392},{"name":"$hsp","kind":13,"containerName":null,"line":392},{"line":392,"kind":12,"containerName":"main::","name":"hit"},{"name":"end","containerName":"main::","kind":12,"line":392},{"name":"$hstrand","kind":13,"containerName":null,"line":393},{"containerName":null,"kind":13,"name":"$hsp","line":394},{"containerName":"main::","kind":12,"name":"hit","line":394},{"line":394,"containerName":"main::","kind":12,"name":"end"},{"containerName":null,"kind":13,"name":"$hsp","line":394},{"kind":12,"containerName":"main::","name":"hit","line":394},{"kind":12,"containerName":"main::","name":"start","line":394},{"name":"$hstrand","kind":13,"containerName":null,"line":396},{"line":405,"name":"%numwidth","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":405,"name":"$b","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$a","line":405},{"name":"@hspvals","containerName":null,"kind":13,"line":405},{"name":"@hspvals","containerName":null,"kind":13,"line":406},{"line":407,"name":"@hspvals","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@hspvals","line":408},{"line":409,"kind":13,"localvar":"my","containerName":null,"name":"$count","definition":"my"},{"line":410,"containerName":null,"kind":13,"name":"$count"},{"name":"$hsp","kind":13,"containerName":null,"line":410},{"name":"length","kind":12,"containerName":"main::","line":410},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$v","line":411},{"name":"@hspvals","kind":13,"containerName":null,"line":411},{"definition":"my","line":412,"name":"$piece","containerName":null,"localvar":"my","kind":13},{"line":412,"name":"%v","kind":13,"containerName":null},{"name":"%v","kind":13,"containerName":null,"line":412},{"line":412,"kind":13,"containerName":null,"name":"$count"},{"line":413,"containerName":null,"kind":13,"name":"$AlignmentLineWidth"},{"line":414,"name":"$cp","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"kind":13,"containerName":null,"name":"$piece","line":414},{"name":"$plen","containerName":null,"localvar":"my","kind":13,"line":415,"definition":"my"},{"line":415,"name":"$cp","kind":13,"containerName":null},{"localvar":"my","containerName":null,"kind":13,"name":"$start","line":416,"definition":"my"},{"name":"$end","kind":13,"containerName":null,"line":416},{"name":"%v","kind":13,"containerName":null,"line":417},{"line":418,"name":"$start","containerName":null,"kind":13},{"name":"%v","kind":13,"containerName":null,"line":418},{"definition":"my","line":421,"name":"$d","containerName":null,"localvar":"my","kind":13},{"containerName":null,"kind":13,"name":"%v","line":421},{"name":"$AlignmentLineWidth","kind":13,"containerName":null,"line":421},{"kind":13,"containerName":null,"name":"$plen","line":421},{"line":422,"name":"%baselens","kind":13,"containerName":null},{"line":422,"name":"%v","kind":13,"containerName":null},{"line":423,"kind":13,"containerName":null,"name":"$piece"},{"line":423,"containerName":null,"kind":13,"name":"%AlignmentLineWidth"},{"containerName":null,"kind":13,"name":"$d","line":424},{"kind":13,"containerName":null,"name":"$piece","line":424},{"name":"$plen","kind":13,"containerName":null,"line":424},{"line":424,"name":"%v","kind":13,"containerName":null},{"name":"%baselens","containerName":null,"kind":13,"line":425},{"containerName":null,"kind":13,"name":"%v","line":425},{"line":427,"name":"$end","kind":13,"containerName":null},{"line":427,"containerName":null,"kind":13,"name":"%v"},{"containerName":null,"kind":13,"name":"$d","line":427},{"name":"%v","containerName":null,"kind":13,"line":427},{"line":428,"kind":13,"containerName":null,"name":"%v"},{"name":"$d","kind":13,"containerName":null,"line":428},{"line":430,"containerName":null,"kind":13,"name":"$hspstr"},{"line":430,"name":"$numwidth","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%v","line":431},{"containerName":null,"kind":13,"name":"$start","line":432},{"containerName":null,"kind":13,"name":"$piece","line":433},{"line":435,"name":"$end","containerName":null,"kind":13},{"line":437,"name":"$count","kind":13,"containerName":null},{"line":437,"name":"$AlignmentLineWidth","kind":13,"containerName":null},{"line":438,"kind":13,"containerName":null,"name":"$hspstr"},{"line":441,"name":"$hspstr","containerName":null,"kind":13},{"name":"$str","containerName":null,"kind":13,"line":444},{"line":444,"containerName":null,"kind":13,"name":"$hspstr"},{"line":446,"name":"$str","containerName":null,"kind":13},{"name":"$result","containerName":null,"kind":13,"line":453},{"name":"database_name","containerName":"main::","kind":12,"line":453},{"name":"$result","kind":13,"containerName":null,"line":454},{"containerName":"main::","kind":12,"name":"get_statistic","line":454},{"line":455,"kind":12,"containerName":"strftime","name":"POSIX"},{"line":456,"name":"_numwithcommas","kind":12},{"line":456,"kind":13,"containerName":null,"name":"$result"},{"name":"database_letters","containerName":"main::","kind":12,"line":456},{"line":457,"name":"_numwithcommas","kind":12},{"name":"$result","kind":13,"containerName":null,"line":457},{"kind":12,"containerName":"main::","name":"database_entries","line":457},{"line":458,"name":"$result","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"get_parameter","line":458},{"line":460,"localvar":"my","kind":13,"containerName":null,"name":"$open","definition":"my"},{"kind":13,"containerName":null,"name":"$result","line":460},{"line":460,"kind":12,"containerName":"main::","name":"get_parameter"},{"line":461,"kind":13,"containerName":null,"name":"$str"},{"kind":13,"containerName":null,"name":"$open","line":462},{"line":462,"containerName":null,"kind":13,"name":"$result"},{"kind":12,"containerName":"main::","name":"get_parameter","line":462},{"definition":"my","line":466,"kind":13,"localvar":"my","containerName":null,"name":"%param"},{"name":"$result","containerName":null,"kind":13,"line":467},{"name":"available_parameters","kind":12,"containerName":"main::","line":467},{"line":468,"name":"$str","kind":13,"containerName":null},{"line":468,"containerName":null,"kind":13,"name":"$result"},{"containerName":"main::","kind":12,"name":"get_parameter","line":468},{"line":468,"name":"$param","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$str","line":471},{"definition":"my","line":473,"containerName":null,"localvar":"my","kind":13,"name":"%stat"},{"name":"$result","containerName":null,"kind":13,"line":474},{"name":"available_statistics","kind":12,"containerName":"main::","line":474},{"containerName":null,"localvar":"my","kind":13,"name":"$expect","line":475,"definition":"my"},{"kind":13,"containerName":null,"name":"$result","line":475},{"line":475,"kind":12,"containerName":"main::","name":"get_parameter"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$v","line":476},{"line":476,"name":"$result","containerName":null,"kind":13},{"line":476,"name":"get_statistic","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$stat","line":476},{"kind":13,"containerName":null,"name":"%v","line":477},{"kind":13,"containerName":null,"name":"$v","line":478},{"name":"_numwithcommas","kind":12,"line":478},{"line":478,"name":"$v","containerName":null,"kind":13},{"line":480,"name":"$expect","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%stat","line":481},{"line":482,"containerName":null,"kind":13,"name":"%str"},{"line":484,"name":"$v","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"name":"$str","kind":13,"containerName":null,"line":485},{"line":488,"name":"$str","kind":13,"containerName":null},{"line":489,"containerName":null,"kind":13,"name":"$str"},{"children":[{"name":"$self","localvar":"my","containerName":"start_report","kind":13,"line":513,"definition":"my"},{"containerName":"start_report","kind":13,"name":"$code","line":513},{"line":514,"containerName":"start_report","kind":13,"name":"$code"},{"containerName":"start_report","kind":13,"name":"$self","line":515},{"name":"$code","containerName":"start_report","kind":13,"line":515},{"line":517,"containerName":"start_report","kind":13,"name":"$self"}],"name":"start_report","containerName":"main::","definition":"sub","detail":"($self,$code)","line":512,"kind":12,"range":{"end":{"line":518,"character":9999},"start":{"line":512,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"","label":"start_report($self,$code)"}},{"name":"default_start_report","kind":12,"line":517},{"line":530,"range":{"start":{"character":0,"line":530},"end":{"character":9999,"line":533}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$result"}],"label":"default_start_report($result)"},"children":[{"definition":"my","containerName":"default_start_report","localvar":"my","kind":13,"name":"$result","line":531}],"containerName":"main::","name":"default_start_report","definition":"sub","detail":"($result)"},{"definition":"sub","detail":"($self,$code)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"title","name":"$self","line":553},{"kind":13,"containerName":"title","name":"$code","line":553},{"name":"$code","kind":13,"containerName":"title","line":554},{"line":555,"kind":13,"containerName":"title","name":"$self"},{"name":"$code","kind":13,"containerName":"title","line":555},{"line":557,"containerName":"title","kind":13,"name":"$self"}],"name":"title","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"","label":"title($self,$code)"},"line":552,"kind":12,"range":{"end":{"line":558,"character":9999},"start":{"character":0,"line":552}}},{"name":"default_title","kind":12,"line":557},{"line":571,"range":{"end":{"line":579,"character":9999},"start":{"character":0,"line":571}},"kind":12,"signature":{"parameters":[{"label":"$result"}],"documentation":"","label":"default_title($result)"},"children":[{"definition":"my","name":"$result","containerName":"default_title","localvar":"my","kind":13,"line":572}],"name":"default_title","containerName":"main::","definition":"sub","detail":"($result)"},{"signature":{"parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"","label":"introduction($self,$code)"},"line":600,"range":{"start":{"line":600,"character":0},"end":{"line":606,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$code)","children":[{"line":601,"name":"$self","localvar":"my","kind":13,"containerName":"introduction","definition":"my"},{"name":"$code","kind":13,"containerName":"introduction","line":601},{"line":602,"name":"$code","containerName":"introduction","kind":13},{"line":603,"kind":13,"containerName":"introduction","name":"$self"},{"line":603,"containerName":"introduction","kind":13,"name":"$code"},{"line":605,"containerName":"introduction","kind":13,"name":"$self"}],"name":"introduction","containerName":"main::"},{"name":"default_introduction","kind":12,"line":605},{"definition":"sub","detail":"($result)","children":[{"containerName":"default_introduction","localvar":"my","kind":13,"name":"$result","line":621,"definition":"my"},{"name":"$result","containerName":"default_introduction","kind":13,"line":632},{"name":"query_name","kind":12,"containerName":"default_introduction","line":632},{"line":633,"kind":13,"containerName":"default_introduction","name":"$result"},{"line":633,"name":"query_description","containerName":"default_introduction","kind":12},{"name":"$result","kind":13,"containerName":"default_introduction","line":634},{"line":634,"name":"query_length","containerName":"default_introduction","kind":12},{"line":635,"kind":13,"containerName":"default_introduction","name":"$result"},{"containerName":"default_introduction","kind":12,"name":"database_name","line":635},{"line":636,"containerName":"default_introduction","kind":13,"name":"$result"},{"name":"database_entries","containerName":"default_introduction","kind":12,"line":636},{"line":637,"name":"$result","containerName":"default_introduction","kind":13},{"line":637,"name":"database_letters","kind":12,"containerName":"default_introduction"}],"name":"default_introduction","containerName":"main::","signature":{"label":"default_introduction($result)","documentation":"","parameters":[{"label":"$result"}]},"line":620,"range":{"start":{"line":620,"character":0},"end":{"line":639,"character":9999}},"kind":12},{"line":632,"kind":12,"name":"_linewrap"},{"line":634,"kind":12,"name":"_numwithcommas"},{"line":636,"name":"_numwithcommas","kind":12},{"name":"_numwithcommas","kind":12,"line":637},{"definition":"sub","children":[],"name":"end_report","containerName":"main::","line":654,"kind":12,"range":{"end":{"character":9999,"line":656},"start":{"character":0,"line":654}}},{"children":[{"definition":"my","containerName":"id_parser","localvar":"my","kind":13,"name":"$self","line":682},{"line":682,"name":"$code","containerName":"id_parser","kind":13},{"kind":13,"containerName":"id_parser","name":"$code","line":684},{"line":685,"kind":13,"containerName":"id_parser","name":"$self"},{"line":685,"name":"$code","kind":13,"containerName":"id_parser"},{"line":687,"name":"$self","containerName":"id_parser","kind":13}],"containerName":"main::","name":"id_parser","definition":"sub","detail":"($self,$code)","line":681,"range":{"start":{"character":0,"line":681},"end":{"character":9999,"line":688}},"kind":12,"signature":{"label":"id_parser($self,$code)","parameters":[{"label":"$self"},{"label":"$code"}],"documentation":""}},{"kind":12,"name":"default_id_parser","line":687},{"children":[{"definition":"my","line":705,"localvar":"my","kind":13,"containerName":"default_id_parser","name":"$string"},{"line":706,"localvar":"my","containerName":"default_id_parser","kind":13,"name":"$gi","definition":"my"},{"name":"$acc","kind":13,"containerName":"default_id_parser","line":706},{"line":707,"name":"$string","kind":13,"containerName":"default_id_parser"},{"line":708,"name":"$gi","containerName":"default_id_parser","kind":13},{"line":708,"name":"$acc","containerName":"default_id_parser","kind":13},{"line":710,"kind":13,"containerName":"default_id_parser","name":"$string"},{"line":711,"name":"$acc","kind":13,"containerName":"default_id_parser"},{"line":713,"containerName":"default_id_parser","kind":13,"name":"$acc"},{"line":713,"name":"$string","kind":13,"containerName":"default_id_parser"},{"line":714,"kind":13,"containerName":"default_id_parser","name":"$acc"},{"line":715,"containerName":"default_id_parser","kind":13,"name":"$acc"},{"line":717,"name":"$gi","containerName":"default_id_parser","kind":13},{"line":717,"name":"$acc","containerName":"default_id_parser","kind":13}],"containerName":"main::","name":"default_id_parser","definition":"sub","detail":"($string)","line":704,"range":{"end":{"line":718,"character":9999},"start":{"line":704,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$string"}],"documentation":"","label":"default_id_parser($string)"}},{"definition":"sub","children":[{"name":"$a","containerName":"MIN","kind":13,"line":720},{"line":720,"name":"$b","containerName":"MIN","kind":13},{"name":"$a","kind":13,"containerName":"MIN","line":720},{"line":720,"kind":13,"containerName":"MIN","name":"$b"}],"containerName":"main::","name":"MIN","line":720,"kind":12,"range":{"start":{"line":720,"character":0},"end":{"character":9999,"line":720}}},{"kind":12,"range":{"start":{"line":721,"character":0},"end":{"character":9999,"line":721}},"line":721,"definition":"sub","name":"MAX","containerName":"main::","children":[{"line":721,"containerName":"MAX","kind":13,"name":"$a"},{"containerName":"MAX","kind":13,"name":"$b","line":721},{"line":721,"name":"$b","containerName":"MAX","kind":13},{"containerName":"MAX","kind":13,"name":"$a","line":721}]},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"algorithm_reference","name":"$self","line":737},{"kind":13,"containerName":"algorithm_reference","name":"$result","line":737},{"name":"$result","containerName":"algorithm_reference","kind":13,"line":738},{"line":738,"containerName":"algorithm_reference","kind":13,"name":"$result"},{"line":739,"name":"$result","kind":13,"containerName":"algorithm_reference"},{"containerName":"algorithm_reference","kind":12,"name":"isa","line":739},{"line":740,"name":"$result","containerName":"algorithm_reference","kind":13},{"line":740,"name":"algorithm","kind":12,"containerName":"algorithm_reference"},{"definition":"my","line":741,"name":"$res","localvar":"my","kind":13,"containerName":"algorithm_reference"},{"line":741,"name":"$result","kind":13,"containerName":"algorithm_reference"},{"line":741,"kind":12,"containerName":"algorithm_reference","name":"algorithm"},{"name":"$result","kind":13,"containerName":"algorithm_reference","line":741},{"line":741,"name":"algorithm_version","containerName":"algorithm_reference","kind":12},{"line":742,"name":"$result","containerName":"algorithm_reference","kind":13},{"line":742,"name":"algorithm_version","kind":12,"containerName":"algorithm_reference"},{"line":743,"containerName":"algorithm_reference","kind":13,"name":"$res"},{"name":"$res","kind":13,"containerName":"algorithm_reference","line":751},{"line":759,"name":"$result","kind":13,"containerName":"algorithm_reference"},{"containerName":"algorithm_reference","kind":12,"name":"algorithm","line":759},{"name":"$result","containerName":"algorithm_reference","kind":13,"line":760},{"line":760,"kind":12,"containerName":"algorithm_reference","name":"algorithm"},{"line":760,"containerName":"algorithm_reference","kind":13,"name":"$result"},{"kind":12,"containerName":"algorithm_reference","name":"algorithm_version","line":760}],"name":"algorithm_reference","containerName":"main::","definition":"sub","detail":"($self,$result)","line":736,"kind":12,"range":{"end":{"line":765,"character":9999},"start":{"line":736,"character":0}},"signature":{"label":"algorithm_reference($self,$result)","documentation":"","parameters":[{"label":"$self"},{"label":"$result"}]}},{"kind":12,"range":{"start":{"character":0,"line":768},"end":{"character":9999,"line":772}},"line":768,"name":"_numwithcommas","containerName":"main::","children":[{"name":"$num","kind":13,"localvar":"my","containerName":"_numwithcommas","line":769,"definition":"my"},{"line":770,"name":"$num","containerName":"_numwithcommas","kind":13},{"line":771,"name":"$num","containerName":"_numwithcommas","kind":13}],"definition":"sub"},{"detail":"($str)","definition":"sub","name":"_linewrap","containerName":"main::","children":[{"definition":"my","line":775,"localvar":"my","containerName":"_linewrap","kind":13,"name":"$str"},{"containerName":"_linewrap","kind":13,"name":"$TextWrapLoaded","line":776},{"name":"$str","kind":13,"containerName":"_linewrap","line":777},{"kind":13,"containerName":"_linewrap","name":"$str","line":778}],"signature":{"documentation":"","parameters":[{"label":"$str"}],"label":"_linewrap($str)"},"range":{"start":{"character":0,"line":774},"end":{"character":9999,"line":779}},"kind":12,"line":774},{"kind":12,"containerName":"Wrap::wrap","name":"Text","line":777},{"line":809,"range":{"end":{"line":814,"character":9999},"start":{"character":0,"line":809}},"kind":12,"children":[{"definition":"my","line":810,"localvar":"my","kind":13,"containerName":"no_wublastlinks","name":"$self"},{"kind":13,"containerName":"no_wublastlinks","name":"$self","line":812},{"containerName":"no_wublastlinks","kind":13,"name":"$self","line":813}],"containerName":"main::","name":"no_wublastlinks","definition":"sub"}],"version":5}