{"vars":[{"name":"vars","containerName":"","kind":2,"line":78},{"line":83,"kind":2,"containerName":"","name":"base"},{"range":{"end":{"character":9999,"line":121},"start":{"line":99,"character":0}},"kind":12,"line":99,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information"},"containerName":"main::","name":"new","children":[{"definition":"my","line":100,"name":"$class","kind":13,"localvar":"my","containerName":"new"},{"kind":13,"containerName":"new","name":"@args","line":100},{"containerName":"new","localvar":"my","kind":13,"name":"$self","line":101,"definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":101},{"line":101,"containerName":"new","kind":13,"name":"@args"},{"name":"$hspF","containerName":"new","localvar":"my","kind":13,"line":102,"definition":"my"},{"name":"$hitF","kind":13,"containerName":"new","line":102},{"containerName":"new","kind":13,"name":"$resultF","line":102},{"name":"$self","containerName":"new","kind":13,"line":102},{"name":"_rearrange","kind":12,"containerName":"new","line":102},{"line":104,"kind":13,"containerName":"new","name":"@args"},{"line":105,"name":"$self","containerName":"new","kind":13},{"line":105,"containerName":"new","kind":12,"name":"register_factory"},{"name":"$hspF","containerName":"new","kind":13,"line":105},{"name":"new","kind":12,"containerName":"new","line":106},{"line":110,"containerName":"new","kind":13,"name":"$self"},{"line":110,"name":"register_factory","kind":12,"containerName":"new"},{"line":110,"name":"$hitF","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"new","line":111},{"name":"$self","kind":13,"containerName":"new","line":115},{"line":115,"name":"register_factory","containerName":"new","kind":12},{"containerName":"new","kind":13,"name":"$resultF","line":115},{"line":116,"kind":12,"containerName":"new","name":"new"},{"containerName":"new","kind":13,"name":"$self","line":120}],"detail":"($class,@args)","definition":"sub"},{"kind":12,"containerName":"new","name":"SUPER","line":101},{"line":106,"kind":12,"containerName":"Factory::ObjectFactory","name":"Bio"},{"name":"Bio","containerName":"Factory::ObjectFactory","kind":12,"line":111},{"line":116,"kind":12,"containerName":"Factory::ObjectFactory","name":"Bio"},{"children":[{"line":137,"name":"$self","localvar":"my","containerName":"will_handle","kind":13,"definition":"my"},{"line":137,"name":"$type","kind":13,"containerName":"will_handle"},{"kind":13,"containerName":"will_handle","name":"$type","line":139},{"containerName":"will_handle","kind":13,"name":"$type","line":139},{"line":139,"name":"$type","containerName":"will_handle","kind":13}],"name":"will_handle","containerName":"main::","definition":"sub","detail":"($self,$type)","line":136,"range":{"end":{"character":9999,"line":140},"start":{"line":136,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name","label":"will_handle($self,$type)"}},{"line":156,"kind":12,"range":{"start":{"character":0,"line":156},"end":{"line":163,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report","label":"start_result($self,$type)"},"children":[{"line":157,"kind":13,"localvar":"my","containerName":"start_result","name":"$self","definition":"my"},{"line":157,"kind":13,"containerName":"start_result","name":"$type"},{"name":"$self","containerName":"start_result","kind":13,"line":158},{"line":158,"containerName":"start_result","kind":13,"name":"$type"},{"kind":13,"containerName":"start_result","name":"$self","line":159},{"line":160,"name":"$self","containerName":"start_result","kind":13},{"name":"$self","containerName":"start_result","kind":13,"line":161}],"containerName":"main::","name":"start_result","definition":"sub","detail":"($self,$type)"},{"line":178,"range":{"start":{"line":178,"character":0},"end":{"character":9999,"line":201}},"kind":12,"signature":{"label":"end_result($self,$type,$data)","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n this is overridden by IteratedSearchResultEventBuilder\n so keep that in mind when debugging"},"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"end_result","line":179,"definition":"my"},{"name":"$type","kind":13,"containerName":"end_result","line":179},{"line":179,"name":"$data","containerName":"end_result","kind":13},{"kind":13,"containerName":"end_result","name":"$data","line":181},{"line":182,"containerName":"end_result","kind":13,"name":"$data"},{"name":"$data","containerName":"end_result","kind":13,"line":184},{"name":"$data","kind":13,"containerName":"end_result","line":185},{"line":185,"kind":13,"containerName":"end_result","name":"$data"},{"kind":13,"containerName":"end_result","name":"$data","line":187},{"kind":13,"containerName":"end_result","name":"$data","line":188},{"kind":13,"containerName":"end_result","name":"$data","line":189},{"name":"@a","containerName":"end_result","localvar":"my","kind":13,"line":192,"definition":"my"},{"kind":13,"containerName":"end_result","name":"$data","line":192},{"line":193,"localvar":"my","kind":13,"containerName":"end_result","name":"$acc","definition":"my"},{"name":"@a","kind":13,"containerName":"end_result","line":193},{"containerName":"end_result","kind":13,"name":"$acc","line":195},{"containerName":"end_result","kind":13,"name":"@a","line":195},{"line":195,"name":"$acc","kind":13,"containerName":"end_result"},{"line":195,"containerName":"end_result","kind":13,"name":"$acc"},{"line":196,"name":"$data","containerName":"end_result","kind":13},{"line":196,"name":"$acc","containerName":"end_result","kind":13},{"name":"$data","containerName":"end_result","kind":13,"line":198},{"line":200,"name":"%args","kind":13,"localvar":"my","containerName":"end_result","definition":"my"},{"line":200,"name":"$v","localvar":"my","kind":13,"containerName":"end_result","definition":"my"},{"line":200,"containerName":"end_result","kind":13,"name":"$data"},{"line":200,"name":"$v","kind":13,"containerName":"end_result"},{"line":201,"name":"$data","kind":13,"containerName":"end_result"}],"containerName":"main::","name":"end_result","definition":"sub","detail":"($self,$type,$data)"},{"line":203,"name":"%args","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%args","line":203},{"line":204,"name":"%data","kind":13,"containerName":null},{"line":204,"kind":13,"containerName":null,"name":"$type"},{"kind":13,"containerName":null,"name":"%args","line":205},{"containerName":null,"kind":13,"name":"%self","line":205},{"definition":"my","line":206,"containerName":null,"localvar":"my","kind":13,"name":"$result"},{"line":206,"containerName":null,"kind":13,"name":"$self"},{"line":206,"containerName":"main::","kind":12,"name":"factory"},{"containerName":"main::","kind":12,"name":"create_object","line":206},{"line":206,"kind":13,"containerName":null,"name":"%args"},{"line":207,"containerName":null,"kind":13,"name":"$result"},{"line":207,"kind":12,"containerName":"main::","name":"hit_factory"},{"kind":13,"containerName":null,"name":"$self","line":207},{"kind":12,"containerName":"main::","name":"factory","line":207},{"line":208,"kind":13,"containerName":null,"name":"%self"},{"line":209,"containerName":null,"kind":13,"name":"$result"},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":224,"containerName":"start_hsp","localvar":"my","kind":13,"name":"$self"},{"containerName":"start_hsp","kind":13,"name":"@args","line":224}],"name":"start_hsp","containerName":"main::","signature":{"label":"start_hsp($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\n# this is overridden by IteratedSearchResultEventBuilder\n# so keep that in mind when debugging\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create_object(%args);\n    $result->hit_factory($self->factory('hit'));\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($name,$data)\n Function: Begins processing a HSP event\n Returns : none\n Args    : type of element \n           associated data (hashref)"},"line":223,"range":{"start":{"character":0,"line":223},"end":{"line":226,"character":9999}},"kind":12},{"signature":{"label":"end_hsp($self,$type,$data)","documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\n# this is overridden by IteratedSearchResultEventBuilder\n# so keep that in mind when debugging\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create_object(%args);\n    $result->hit_factory($self->factory('hit'));\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($name,$data)\n Function: Begins processing a HSP event\n Returns : none\n Args    : type of element \n           associated data (hashref)\n\n\nsub start_hsp {\n    my ($self,@args) = @_;\n    return;\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Finish processing a HSP event\n Returns : none\n Args    : type of event and associated hashref","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}]},"kind":12,"range":{"start":{"character":0,"line":239},"end":{"character":9999,"line":302}},"line":239,"detail":"($self,$type,$data)","definition":"sub","containerName":"main::","name":"end_hsp","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"end_hsp","kind":13,"line":240},{"kind":13,"containerName":"end_hsp","name":"$type","line":240},{"containerName":"end_hsp","kind":13,"name":"$data","line":240},{"line":242,"containerName":"end_hsp","kind":13,"name":"$data"},{"name":"$data","containerName":"end_hsp","kind":13,"line":243},{"name":"$data","kind":13,"containerName":"end_hsp","line":245},{"line":246,"name":"$data","kind":13,"containerName":"end_hsp"},{"line":246,"name":"$data","kind":13,"containerName":"end_hsp"},{"line":248,"kind":13,"containerName":"end_hsp","name":"$data"},{"name":"$data","kind":13,"containerName":"end_hsp","line":249},{"containerName":"end_hsp","kind":13,"name":"$data","line":250},{"definition":"my","line":253,"kind":13,"localvar":"my","containerName":"end_hsp","name":"@a"},{"line":253,"name":"$data","kind":13,"containerName":"end_hsp"},{"line":254,"containerName":"end_hsp","localvar":"my","kind":13,"name":"$acc","definition":"my"},{"containerName":"end_hsp","kind":13,"name":"@a","line":254},{"line":256,"name":"$acc","containerName":"end_hsp","kind":13},{"name":"@a","kind":13,"containerName":"end_hsp","line":256},{"name":"$acc","containerName":"end_hsp","kind":13,"line":256},{"line":256,"containerName":"end_hsp","kind":13,"name":"$acc"},{"kind":13,"containerName":"end_hsp","name":"$data","line":257},{"kind":13,"containerName":"end_hsp","name":"$acc","line":257},{"containerName":"end_hsp","kind":13,"name":"$data","line":259},{"containerName":"end_hsp","kind":13,"name":"$data","line":267},{"line":268,"name":"$data","kind":13,"containerName":"end_hsp"},{"name":"$data","containerName":"end_hsp","kind":13,"line":269},{"kind":13,"containerName":"end_hsp","name":"$data","line":269},{"name":"$data","kind":13,"containerName":"end_hsp","line":270},{"line":271,"kind":13,"containerName":"end_hsp","name":"$data"},{"containerName":"end_hsp","kind":13,"name":"$data","line":271},{"name":"$data","containerName":"end_hsp","kind":13,"line":275},{"line":276,"name":"$data","kind":13,"containerName":"end_hsp"},{"name":"$data","containerName":"end_hsp","kind":13,"line":276},{"line":277,"name":"$data","kind":13,"containerName":"end_hsp"},{"kind":13,"containerName":"end_hsp","name":"$data","line":279},{"kind":13,"containerName":"end_hsp","name":"$data","line":280},{"containerName":"end_hsp","kind":13,"name":"$data","line":280},{"name":"$data","kind":13,"containerName":"end_hsp","line":281},{"line":281,"containerName":"end_hsp","kind":13,"name":"$data"},{"line":282,"name":"$data","containerName":"end_hsp","kind":13},{"containerName":"end_hsp","kind":13,"name":"$data","line":282},{"name":"$data","containerName":"end_hsp","kind":13,"line":283},{"kind":13,"containerName":"end_hsp","name":"$data","line":283},{"line":287,"name":"$data","kind":13,"containerName":"end_hsp"},{"kind":13,"containerName":"end_hsp","name":"$data","line":288},{"kind":13,"containerName":"end_hsp","name":"$data","line":288},{"name":"$data","kind":13,"containerName":"end_hsp","line":289},{"line":291,"name":"$data","containerName":"end_hsp","kind":13},{"name":"$data","kind":13,"containerName":"end_hsp","line":292},{"line":294,"name":"$data","kind":13,"containerName":"end_hsp"},{"line":294,"name":"$data","kind":13,"containerName":"end_hsp"},{"kind":13,"containerName":"end_hsp","name":"$data","line":295},{"line":295,"containerName":"end_hsp","kind":13,"name":"$data"},{"line":296,"name":"$data","kind":13,"containerName":"end_hsp"},{"kind":13,"containerName":"end_hsp","name":"$data","line":296},{"line":297,"kind":13,"containerName":"end_hsp","name":"$data"},{"line":297,"name":"$data","kind":13,"containerName":"end_hsp"},{"line":299,"name":"$data","containerName":"end_hsp","kind":13},{"kind":13,"containerName":"end_hsp","name":"$data","line":299},{"definition":"my","localvar":"my","containerName":"end_hsp","kind":13,"name":"%args","line":301},{"kind":13,"localvar":"my","containerName":"end_hsp","name":"$v","line":301,"definition":"my"},{"containerName":"end_hsp","kind":13,"name":"$data","line":301},{"containerName":"end_hsp","kind":13,"name":"$v","line":301},{"line":302,"kind":13,"containerName":"end_hsp","name":"$data"}]},{"line":304,"name":"%args","containerName":null,"kind":13},{"line":304,"name":"%args","containerName":null,"kind":13},{"line":305,"name":"%data","kind":13,"containerName":null},{"line":305,"kind":13,"containerName":null,"name":"$type"},{"line":307,"name":"%args","kind":13,"containerName":null},{"line":307,"kind":13,"containerName":null,"name":"%data"},{"line":308,"kind":13,"containerName":null,"name":"%args"},{"line":308,"containerName":null,"kind":13,"name":"%data"},{"line":309,"name":"$rank","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":309,"name":"%self","kind":13,"containerName":null},{"line":310,"containerName":null,"kind":13,"name":"%args"},{"kind":13,"containerName":null,"name":"$rank","line":310},{"name":"%args","containerName":null,"kind":13,"line":312},{"line":312,"containerName":null,"kind":13,"name":"%data"},{"kind":13,"containerName":null,"name":"%args","line":313},{"name":"%data","containerName":null,"kind":13,"line":313},{"definition":"my","line":315,"containerName":null,"localvar":"my","kind":13,"name":"$bits"},{"line":315,"kind":13,"containerName":null,"name":"%args"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$hsp","line":316},{"name":"%args","kind":13,"containerName":null,"line":316},{"line":317,"name":"%self","containerName":null,"kind":13},{"name":"$hsp","kind":13,"containerName":null,"line":317},{"kind":13,"containerName":null,"name":"$hsp","line":319},{"signature":{"label":"start_hit($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\n# this is overridden by IteratedSearchResultEventBuilder\n# so keep that in mind when debugging\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create_object(%args);\n    $result->hit_factory($self->factory('hit'));\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($name,$data)\n Function: Begins processing a HSP event\n Returns : none\n Args    : type of element \n           associated data (hashref)\n\n\nsub start_hsp {\n    my ($self,@args) = @_;\n    return;\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Finish processing a HSP event\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub end_hsp {\n    my ($self,$type,$data) = @_;\n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n\n    # this code is to deal with the fact that Blast XML data\n    # always has start < end and one has to infer strandedness\n    # from the frame which is a problem for the Search::HSP object\n    # which expect to be able to infer strand from the order of \n    # of the begin/end of the query and hit coordinates\n    if( defined $data->{'HSP-query_frame'} && # this is here to protect from undefs\n        (( $data->{'HSP-query_frame'} < 0 && \n           $data->{'HSP-query_start'} < $data->{'HSP-query_end'} ) ||       \n         $data->{'HSP-query_frame'} > 0 && \n         ( $data->{'HSP-query_start'} > $data->{'HSP-query_end'} ) ) \n        )\n    { \n        # swap\n        ($data->{'HSP-query_start'},\n         $data->{'HSP-query_end'}) = ($data->{'HSP-query_end'},\n                                      $data->{'HSP-query_start'});\n    } \n    if( defined $data->{'HSP-hit_frame'} && # this is here to protect from undefs\n        ((defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} < 0 && \n          $data->{'HSP-hit_start'} < $data->{'HSP-hit_end'} ) ||       \n         defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} > 0 && \n         ( $data->{'HSP-hit_start'} > $data->{'HSP-hit_end'} ) )\n        ) \n    { \n        # swap\n        ($data->{'HSP-hit_start'},\n         $data->{'HSP-hit_end'}) = ($data->{'HSP-hit_end'},\n                                    $data->{'HSP-hit_start'});\n    }\n    $data->{'HSP-query_frame'} ||= 0;\n    $data->{'HSP-hit_frame'} ||= 0;\n    # handle Blast 2.1.2 which did not support data member: hsp_align-len\n    $data->{'HSP-query_length'} ||= $data->{'RESULT-query_length'};\n    $data->{'HSP-query_length'} ||= length ($data->{'HSP-query_seq'} || '');\n    $data->{'HSP-hit_length'}   ||= $data->{'HIT-length'};\n    $data->{'HSP-hit_length'}   ||= length ($data->{'HSP-hit_seq'} || '');\n    \n    $data->{'HSP-hsp_length'}   ||= length ($data->{'HSP-homology_seq'} || '');\n    \n    my %args = map { my $v = $data->{$_}; s/HSP//; ($_ => $v) } \n               grep { /^HSP/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    # copy this over from result\n    $args{'-query_name'} = $data->{'RESULT-query_name'};\n    $args{'-hit_name'} = $data->{'HIT-name'};\n    my ($rank) = scalar @{$self->{'_hsps'} || []} + 1;\n    $args{'-rank'} = $rank;\n    \n    $args{'-hit_desc'} = $data->{'HIT-description'};\n    $args{'-query_desc'} = $data->{'RESULT-query_description'};\n    \n    my $bits = $args{'-bits'};\n    my $hsp = \\%args;\n    push @{$self->{'_hsps'}}, $hsp;\n    \n    return $hsp;\n}\n\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref"},"line":334,"kind":12,"range":{"start":{"character":0,"line":334},"end":{"line":338,"character":9999}},"definition":"sub","detail":"($self,$type)","children":[{"line":335,"name":"$self","containerName":"start_hit","localvar":"my","kind":13,"definition":"my"},{"line":335,"containerName":"start_hit","kind":13,"name":"$type"},{"line":336,"name":"$self","kind":13,"containerName":"start_hit"}],"name":"start_hit","containerName":"main::"},{"children":[{"definition":"my","localvar":"my","containerName":"end_hit","kind":13,"name":"$self","line":353},{"line":353,"name":"$type","kind":13,"containerName":"end_hit"},{"name":"$data","kind":13,"containerName":"end_hit","line":353},{"definition":"my","line":354,"name":"%args","kind":13,"localvar":"my","containerName":"end_hit"},{"definition":"my","name":"$v","kind":13,"localvar":"my","containerName":"end_hit","line":354},{"containerName":"end_hit","kind":13,"name":"$data","line":354},{"kind":13,"containerName":"end_hit","name":"$v","line":354},{"name":"$data","kind":13,"containerName":"end_hit","line":354}],"name":"end_hit","containerName":"main::","definition":"sub","detail":"($self,$type,$data)","line":352,"range":{"start":{"character":0,"line":352},"end":{"character":9999,"line":354}},"kind":12,"signature":{"label":"end_hit($self,$type,$data)","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\n# this is overridden by IteratedSearchResultEventBuilder\n# so keep that in mind when debugging\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create_object(%args);\n    $result->hit_factory($self->factory('hit'));\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($name,$data)\n Function: Begins processing a HSP event\n Returns : none\n Args    : type of element \n           associated data (hashref)\n\n\nsub start_hsp {\n    my ($self,@args) = @_;\n    return;\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Finish processing a HSP event\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub end_hsp {\n    my ($self,$type,$data) = @_;\n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n\n    # this code is to deal with the fact that Blast XML data\n    # always has start < end and one has to infer strandedness\n    # from the frame which is a problem for the Search::HSP object\n    # which expect to be able to infer strand from the order of \n    # of the begin/end of the query and hit coordinates\n    if( defined $data->{'HSP-query_frame'} && # this is here to protect from undefs\n        (( $data->{'HSP-query_frame'} < 0 && \n           $data->{'HSP-query_start'} < $data->{'HSP-query_end'} ) ||       \n         $data->{'HSP-query_frame'} > 0 && \n         ( $data->{'HSP-query_start'} > $data->{'HSP-query_end'} ) ) \n        )\n    { \n        # swap\n        ($data->{'HSP-query_start'},\n         $data->{'HSP-query_end'}) = ($data->{'HSP-query_end'},\n                                      $data->{'HSP-query_start'});\n    } \n    if( defined $data->{'HSP-hit_frame'} && # this is here to protect from undefs\n        ((defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} < 0 && \n          $data->{'HSP-hit_start'} < $data->{'HSP-hit_end'} ) ||       \n         defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} > 0 && \n         ( $data->{'HSP-hit_start'} > $data->{'HSP-hit_end'} ) )\n        ) \n    { \n        # swap\n        ($data->{'HSP-hit_start'},\n         $data->{'HSP-hit_end'}) = ($data->{'HSP-hit_end'},\n                                    $data->{'HSP-hit_start'});\n    }\n    $data->{'HSP-query_frame'} ||= 0;\n    $data->{'HSP-hit_frame'} ||= 0;\n    # handle Blast 2.1.2 which did not support data member: hsp_align-len\n    $data->{'HSP-query_length'} ||= $data->{'RESULT-query_length'};\n    $data->{'HSP-query_length'} ||= length ($data->{'HSP-query_seq'} || '');\n    $data->{'HSP-hit_length'}   ||= $data->{'HIT-length'};\n    $data->{'HSP-hit_length'}   ||= length ($data->{'HSP-hit_seq'} || '');\n    \n    $data->{'HSP-hsp_length'}   ||= length ($data->{'HSP-homology_seq'} || '');\n    \n    my %args = map { my $v = $data->{$_}; s/HSP//; ($_ => $v) } \n               grep { /^HSP/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    # copy this over from result\n    $args{'-query_name'} = $data->{'RESULT-query_name'};\n    $args{'-hit_name'} = $data->{'HIT-name'};\n    my ($rank) = scalar @{$self->{'_hsps'} || []} + 1;\n    $args{'-rank'} = $rank;\n    \n    $args{'-hit_desc'} = $data->{'HIT-description'};\n    $args{'-query_desc'} = $data->{'RESULT-query_description'};\n    \n    my $bits = $args{'-bits'};\n    my $hsp = \\%args;\n    push @{$self->{'_hsps'}}, $hsp;\n    \n    return $hsp;\n}\n\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit{\n    my ($self,$type) = @_;\n    $self->{'_hsps'} = [];\n    return;\n}\n\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref"}},{"line":358,"name":"%args","kind":13,"containerName":null},{"line":358,"kind":13,"containerName":null,"name":"%args"},{"name":"%args","containerName":null,"kind":13,"line":359},{"kind":13,"containerName":null,"name":"%args","line":359},{"line":359,"name":"%args","containerName":null,"kind":13},{"name":"%args","containerName":null,"kind":13,"line":361},{"kind":13,"containerName":null,"name":"%args","line":361},{"line":362,"kind":13,"containerName":null,"name":"%data"},{"line":362,"name":"$type","containerName":null,"kind":13},{"line":363,"name":"%args","kind":13,"containerName":null},{"line":363,"containerName":null,"kind":13,"name":"%self"},{"line":364,"containerName":null,"kind":13,"name":"%args"},{"kind":13,"containerName":null,"name":"%data","line":364},{"containerName":null,"kind":13,"name":"%args","line":365},{"containerName":null,"kind":13,"name":"%self","line":365},{"name":"%args","kind":13,"containerName":null,"line":366},{"line":367,"kind":13,"containerName":null,"name":"%args"},{"kind":13,"containerName":null,"name":"%args","line":368},{"kind":13,"containerName":null,"name":"%args","line":370},{"name":"%args","kind":13,"containerName":null,"line":370},{"line":370,"kind":13,"containerName":null,"name":"%args"},{"name":"$hit","kind":13,"localvar":"my","containerName":null,"line":373,"definition":"my"},{"name":"%args","containerName":null,"kind":13,"line":373},{"line":374,"kind":13,"containerName":null,"name":"%hit"},{"line":374,"name":"$self","kind":13,"containerName":null},{"line":374,"name":"factory","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$self","line":375},{"name":"_add_hit","kind":12,"containerName":"main::","line":375},{"name":"$hit","kind":13,"containerName":null,"line":375},{"line":376,"name":"%self","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$hit","line":377},{"children":[{"definition":"my","localvar":"my","containerName":"_add_hit","kind":13,"name":"$self","line":382},{"line":382,"containerName":"_add_hit","kind":13,"name":"$hit"},{"line":383,"kind":13,"containerName":"_add_hit","name":"$self"}],"containerName":"main::","name":"_add_hit","definition":"sub","detail":"($self,$hit)","line":381,"range":{"end":{"character":9999,"line":383},"start":{"line":381,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$hit"}],"documentation":" TODO: Optionally impose hit filtering here","label":"_add_hit($self,$hit)"}},{"line":383,"kind":13,"containerName":null,"name":"$hit"},{"name":"%self","kind":13,"containerName":null,"line":384},{"name":"%self","containerName":null,"kind":13,"line":384},{"name":"register_factory","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"register_factory","name":"$self","line":405,"definition":"my"},{"line":405,"name":"$type","containerName":"register_factory","kind":13},{"name":"$f","containerName":"register_factory","kind":13,"line":405},{"line":406,"kind":13,"containerName":"register_factory","name":"$f"},{"name":"$f","containerName":"register_factory","kind":13,"line":406},{"name":"$f","kind":13,"containerName":"register_factory","line":407},{"line":407,"name":"isa","kind":12,"containerName":"register_factory"},{"line":408,"name":"$self","kind":13,"containerName":"register_factory"},{"line":408,"kind":12,"containerName":"register_factory","name":"throw"},{"line":408,"name":"$f","containerName":"register_factory","kind":13},{"line":410,"kind":13,"containerName":"register_factory","name":"$self"},{"kind":13,"containerName":"register_factory","name":"$type","line":410},{"name":"$f","kind":13,"containerName":"register_factory","line":410}],"detail":"($self,$type,$f)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":411},"start":{"line":404,"character":0}},"line":404,"signature":{"label":"register_factory($self,$type,$f)","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$f"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\n# this is overridden by IteratedSearchResultEventBuilder\n# so keep that in mind when debugging\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create_object(%args);\n    $result->hit_factory($self->factory('hit'));\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($name,$data)\n Function: Begins processing a HSP event\n Returns : none\n Args    : type of element \n           associated data (hashref)\n\n\nsub start_hsp {\n    my ($self,@args) = @_;\n    return;\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Finish processing a HSP event\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub end_hsp {\n    my ($self,$type,$data) = @_;\n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n\n    # this code is to deal with the fact that Blast XML data\n    # always has start < end and one has to infer strandedness\n    # from the frame which is a problem for the Search::HSP object\n    # which expect to be able to infer strand from the order of \n    # of the begin/end of the query and hit coordinates\n    if( defined $data->{'HSP-query_frame'} && # this is here to protect from undefs\n        (( $data->{'HSP-query_frame'} < 0 && \n           $data->{'HSP-query_start'} < $data->{'HSP-query_end'} ) ||       \n         $data->{'HSP-query_frame'} > 0 && \n         ( $data->{'HSP-query_start'} > $data->{'HSP-query_end'} ) ) \n        )\n    { \n        # swap\n        ($data->{'HSP-query_start'},\n         $data->{'HSP-query_end'}) = ($data->{'HSP-query_end'},\n                                      $data->{'HSP-query_start'});\n    } \n    if( defined $data->{'HSP-hit_frame'} && # this is here to protect from undefs\n        ((defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} < 0 && \n          $data->{'HSP-hit_start'} < $data->{'HSP-hit_end'} ) ||       \n         defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} > 0 && \n         ( $data->{'HSP-hit_start'} > $data->{'HSP-hit_end'} ) )\n        ) \n    { \n        # swap\n        ($data->{'HSP-hit_start'},\n         $data->{'HSP-hit_end'}) = ($data->{'HSP-hit_end'},\n                                    $data->{'HSP-hit_start'});\n    }\n    $data->{'HSP-query_frame'} ||= 0;\n    $data->{'HSP-hit_frame'} ||= 0;\n    # handle Blast 2.1.2 which did not support data member: hsp_align-len\n    $data->{'HSP-query_length'} ||= $data->{'RESULT-query_length'};\n    $data->{'HSP-query_length'} ||= length ($data->{'HSP-query_seq'} || '');\n    $data->{'HSP-hit_length'}   ||= $data->{'HIT-length'};\n    $data->{'HSP-hit_length'}   ||= length ($data->{'HSP-hit_seq'} || '');\n    \n    $data->{'HSP-hsp_length'}   ||= length ($data->{'HSP-homology_seq'} || '');\n    \n    my %args = map { my $v = $data->{$_}; s/HSP//; ($_ => $v) } \n               grep { /^HSP/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    # copy this over from result\n    $args{'-query_name'} = $data->{'RESULT-query_name'};\n    $args{'-hit_name'} = $data->{'HIT-name'};\n    my ($rank) = scalar @{$self->{'_hsps'} || []} + 1;\n    $args{'-rank'} = $rank;\n    \n    $args{'-hit_desc'} = $data->{'HIT-description'};\n    $args{'-query_desc'} = $data->{'RESULT-query_description'};\n    \n    my $bits = $args{'-bits'};\n    my $hsp = \\%args;\n    push @{$self->{'_hsps'}}, $hsp;\n    \n    return $hsp;\n}\n\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit{\n    my ($self,$type) = @_;\n    $self->{'_hsps'} = [];\n    return;\n}\n\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref\n\n\n\nsub end_hit{\n    my ($self,$type,$data) = @_;   \n    my %args = map { my $v = $data->{$_}; s/HIT//; ($_ => $v); } grep { /^HIT/ } keys %{$data};\n\n    # I hate special cases, but this is here because NCBI BLAST XML\n    # doesn't play nice and is undergoing mutation -jason\n    if(exists $args{'-name'} && $args{'-name'} =~ /BL_ORD_ID/ ) {\n        ($args{'-name'}, $args{'-description'}) = split(/\\s+/,$args{'-description'},2);\n    }\n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hsps'}      = $self->{'_hsps'};\n    $args{'-query_len'} =  $data->{'RESULT-query_length'};\n    $args{'-rank'}      = $self->{'_hitcount'} + 1;\n    unless( defined $args{'-significance'} ) {\n        if( defined $args{'-hsps'} && \n            $args{'-hsps'}->[0] ) {\n            # use pvalue if present (WU-BLAST), otherwise evalue (NCBI BLAST)\n            $args{'-significance'} = $args{'-hsps'}->[0]->{'-pvalue'} || $args{'-hsps'}->[0]->{'-evalue'};\n        }\n    }\n    my $hit = \\%args;\n    $hit->{'-hsp_factory'} = $self->factory('hsp');\n    $self->_add_hit($hit);\n    $self->{'_hsps'} = [];\n    return $hit;\n}\n\n# TODO: Optionally impose hit filtering here\nsub _add_hit {\n    my ($self, $hit) = @_;\n    push @{$self->{'_hits'}}, $hit;\n    $self->{'_hitcount'} = scalar @{$self->{'_hits'}};\n}\n\n=head2 Factory methods\n\n\n=head2 register_factory\n\n Title   : register_factory\n Usage   : $handler->register_factory('TYPE',$factory);\n Function: Register a specific factory for a object type class\n Returns : none\n Args    : string representing the class and\n           Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information"}},{"children":[{"definition":"my","line":428,"localvar":"my","kind":13,"containerName":"factory","name":"$self"},{"line":428,"name":"$type","kind":13,"containerName":"factory"},{"line":429,"containerName":"factory","kind":13,"name":"$self"},{"line":429,"name":"$type","kind":13,"containerName":"factory"},{"line":430,"name":"$self","kind":13,"containerName":"factory"},{"containerName":"factory","kind":12,"name":"throw","line":430}],"name":"factory","containerName":"main::","definition":"sub","detail":"($self,$type)","line":427,"kind":12,"range":{"start":{"character":0,"line":427},"end":{"character":9999,"line":432}},"signature":{"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\n# this is overridden by IteratedSearchResultEventBuilder\n# so keep that in mind when debugging\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create_object(%args);\n    $result->hit_factory($self->factory('hit'));\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($name,$data)\n Function: Begins processing a HSP event\n Returns : none\n Args    : type of element \n           associated data (hashref)\n\n\nsub start_hsp {\n    my ($self,@args) = @_;\n    return;\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Finish processing a HSP event\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub end_hsp {\n    my ($self,$type,$data) = @_;\n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n\n    # this code is to deal with the fact that Blast XML data\n    # always has start < end and one has to infer strandedness\n    # from the frame which is a problem for the Search::HSP object\n    # which expect to be able to infer strand from the order of \n    # of the begin/end of the query and hit coordinates\n    if( defined $data->{'HSP-query_frame'} && # this is here to protect from undefs\n        (( $data->{'HSP-query_frame'} < 0 && \n           $data->{'HSP-query_start'} < $data->{'HSP-query_end'} ) ||       \n         $data->{'HSP-query_frame'} > 0 && \n         ( $data->{'HSP-query_start'} > $data->{'HSP-query_end'} ) ) \n        )\n    { \n        # swap\n        ($data->{'HSP-query_start'},\n         $data->{'HSP-query_end'}) = ($data->{'HSP-query_end'},\n                                      $data->{'HSP-query_start'});\n    } \n    if( defined $data->{'HSP-hit_frame'} && # this is here to protect from undefs\n        ((defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} < 0 && \n          $data->{'HSP-hit_start'} < $data->{'HSP-hit_end'} ) ||       \n         defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} > 0 && \n         ( $data->{'HSP-hit_start'} > $data->{'HSP-hit_end'} ) )\n        ) \n    { \n        # swap\n        ($data->{'HSP-hit_start'},\n         $data->{'HSP-hit_end'}) = ($data->{'HSP-hit_end'},\n                                    $data->{'HSP-hit_start'});\n    }\n    $data->{'HSP-query_frame'} ||= 0;\n    $data->{'HSP-hit_frame'} ||= 0;\n    # handle Blast 2.1.2 which did not support data member: hsp_align-len\n    $data->{'HSP-query_length'} ||= $data->{'RESULT-query_length'};\n    $data->{'HSP-query_length'} ||= length ($data->{'HSP-query_seq'} || '');\n    $data->{'HSP-hit_length'}   ||= $data->{'HIT-length'};\n    $data->{'HSP-hit_length'}   ||= length ($data->{'HSP-hit_seq'} || '');\n    \n    $data->{'HSP-hsp_length'}   ||= length ($data->{'HSP-homology_seq'} || '');\n    \n    my %args = map { my $v = $data->{$_}; s/HSP//; ($_ => $v) } \n               grep { /^HSP/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    # copy this over from result\n    $args{'-query_name'} = $data->{'RESULT-query_name'};\n    $args{'-hit_name'} = $data->{'HIT-name'};\n    my ($rank) = scalar @{$self->{'_hsps'} || []} + 1;\n    $args{'-rank'} = $rank;\n    \n    $args{'-hit_desc'} = $data->{'HIT-description'};\n    $args{'-query_desc'} = $data->{'RESULT-query_description'};\n    \n    my $bits = $args{'-bits'};\n    my $hsp = \\%args;\n    push @{$self->{'_hsps'}}, $hsp;\n    \n    return $hsp;\n}\n\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit{\n    my ($self,$type) = @_;\n    $self->{'_hsps'} = [];\n    return;\n}\n\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref\n\n\n\nsub end_hit{\n    my ($self,$type,$data) = @_;   \n    my %args = map { my $v = $data->{$_}; s/HIT//; ($_ => $v); } grep { /^HIT/ } keys %{$data};\n\n    # I hate special cases, but this is here because NCBI BLAST XML\n    # doesn't play nice and is undergoing mutation -jason\n    if(exists $args{'-name'} && $args{'-name'} =~ /BL_ORD_ID/ ) {\n        ($args{'-name'}, $args{'-description'}) = split(/\\s+/,$args{'-description'},2);\n    }\n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hsps'}      = $self->{'_hsps'};\n    $args{'-query_len'} =  $data->{'RESULT-query_length'};\n    $args{'-rank'}      = $self->{'_hitcount'} + 1;\n    unless( defined $args{'-significance'} ) {\n        if( defined $args{'-hsps'} && \n            $args{'-hsps'}->[0] ) {\n            # use pvalue if present (WU-BLAST), otherwise evalue (NCBI BLAST)\n            $args{'-significance'} = $args{'-hsps'}->[0]->{'-pvalue'} || $args{'-hsps'}->[0]->{'-evalue'};\n        }\n    }\n    my $hit = \\%args;\n    $hit->{'-hsp_factory'} = $self->factory('hsp');\n    $self->_add_hit($hit);\n    $self->{'_hsps'} = [];\n    return $hit;\n}\n\n# TODO: Optionally impose hit filtering here\nsub _add_hit {\n    my ($self, $hit) = @_;\n    push @{$self->{'_hits'}}, $hit;\n    $self->{'_hitcount'} = scalar @{$self->{'_hits'}};\n}\n\n=head2 Factory methods\n\n\n=head2 register_factory\n\n Title   : register_factory\n Usage   : $handler->register_factory('TYPE',$factory);\n Function: Register a specific factory for a object type class\n Returns : none\n Args    : string representing the class and\n           Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub register_factory{\n   my ($self, $type,$f) = @_;\n   if( ! defined $f || ! ref($f) || \n       ! $f->isa('Bio::Factory::ObjectFactoryI') ) { \n       $self->throw(\"Cannot set factory to value $f\".ref($f).\"\\n\");\n   }\n   $self->{'_factories'}->{lc($type)} = $f;\n}\n\n\n=head2 factory\n\n Title   : factory\n Usage   : my $f = $handler->factory('TYPE');\n Function: Retrieves the associated factory for requested 'TYPE'\n Returns : a Bio::Factory::ObjectFactoryI \n Throws  : Bio::Root::BadParameter if none registered for the supplied type\n Args    : name of factory class to retrieve\n\nSee L<Bio::Factory::ObjectFactoryI> for more information","parameters":[{"label":"$self"},{"label":"$type"}],"label":"factory($self,$type)"}},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"inclusion_threshold","line":441,"definition":"my"},{"kind":13,"containerName":"inclusion_threshold","name":"$self","line":442},{"line":443,"containerName":"inclusion_threshold","kind":13,"name":"$self"}],"name":"inclusion_threshold","containerName":"main::","definition":"sub","line":440,"kind":12,"range":{"start":{"character":0,"line":440},"end":{"character":9999,"line":444}}}],"version":5}