{"version":5,"vars":[{"line":84,"kind":2,"containerName":"","name":"vars"},{"name":"base","kind":2,"containerName":"","line":92},{"line":97,"containerName":null,"kind":13,"name":"$DEFAULT_INCLUSION_THRESHOLD"},{"kind":13,"containerName":null,"name":"$MAX_HSP_OVERLAP","line":100},{"line":128,"kind":12,"range":{"start":{"line":128,"character":0},"end":{"character":9999,"line":165}},"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n#------------------------------------------------------------------\n# $Id: IteratedSearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::IteratedSearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org> and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n#------------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::IteratedSearchResultEventBuilder - Event Handler for\nSearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nParts of code based on SearchResultEventBuilder by Jason Stajich\njason@bioperl.org\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::IteratedSearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS             $DEFAULT_INCLUSION_THRESHOLD\n            $MAX_HSP_OVERLAP\n);\n\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SearchIO::SearchResultEventBuilder);\n\n# e-value threshold for inclusion in the PSI-BLAST score matrix model (blastpgp)\n# NOTE: Executing `blastpgp -` incorrectly reports that the default is 0.005.\n#       (version 2.2.2 [Jan-08-2002])\n$DEFAULT_INCLUSION_THRESHOLD = 0.001;\n\n\n$MAX_HSP_OVERLAP  = 2;  # Used when tiling multiple HSPs.\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::IteratedSearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::IteratedSearchResultEventBuilder object \n Returns : Bio::SearchIO::IteratedSearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n           -iteration_factory => Bio::Factory::ObjectFactoryI\n           -inclusion_threshold => e-value threshold for inclusion in the\n                                   PSI-BLAST score matrix model (blastpgp)\n           -signif      => float or scientific notation number to be used\n                           as a P- or Expect value cutoff\n           -score       => integer or scientific notation number to be used\n                           as a blast score value cutoff\n           -bits        => integer or scientific notation number to be used\n                           as a bit score value cutoff\n           -hit_filter  => reference to a function to be used for\n                           filtering hits based on arbitrary criteria.\n\n\nSee L<Bio::SearchIO::SearchResultEventBuilder> for more information"},"children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":129},{"name":"@args","kind":13,"containerName":"new","line":129},{"definition":"my","line":130,"name":"$self","localvar":"my","kind":13,"containerName":"new"},{"line":130,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":130},{"definition":"my","line":131,"name":"$hitF","localvar":"my","containerName":"new","kind":13},{"line":131,"name":"$resultF","containerName":"new","kind":13},{"line":131,"containerName":"new","kind":13,"name":"$hspF"},{"name":"$iterationF","containerName":"new","kind":13,"line":131},{"line":132,"name":"$self","containerName":"new","kind":13},{"kind":12,"containerName":"new","name":"_rearrange","line":132},{"name":"@args","containerName":"new","kind":13,"line":138},{"kind":13,"containerName":"new","name":"$self","line":140},{"line":140,"kind":12,"containerName":"new","name":"_init_parse_params"},{"kind":13,"containerName":"new","name":"@args","line":140},{"line":144,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"register_factory","line":144},{"line":144,"name":"$resultF","kind":13,"containerName":"new"},{"line":145,"kind":12,"containerName":"new","name":"new"},{"line":149,"name":"$self","kind":13,"containerName":"new"},{"name":"register_factory","containerName":"new","kind":12,"line":149},{"line":149,"name":"$hitF","containerName":"new","kind":13},{"line":150,"name":"new","kind":12,"containerName":"new"},{"line":154,"kind":13,"containerName":"new","name":"$self"},{"line":154,"name":"register_factory","containerName":"new","kind":12},{"line":154,"kind":13,"containerName":"new","name":"$hspF"},{"line":155,"name":"new","containerName":"new","kind":12},{"line":160,"name":"$self","kind":13,"containerName":"new"},{"name":"register_factory","kind":12,"containerName":"new","line":160},{"line":160,"containerName":"new","kind":13,"name":"$iterationF"},{"kind":12,"containerName":"new","name":"new","line":161},{"name":"$self","containerName":"new","kind":13,"line":164}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"line":130,"name":"SUPER","containerName":"new","kind":12},{"containerName":"Factory::ObjectFactory","kind":12,"name":"Bio","line":145},{"line":150,"kind":12,"containerName":"Factory::ObjectFactory","name":"Bio"},{"line":155,"kind":12,"containerName":"Factory::ObjectFactory","name":"Bio"},{"name":"Bio","containerName":"Factory::ObjectFactory","kind":12,"line":161},{"range":{"start":{"line":169,"character":0},"end":{"character":9999,"line":185}},"kind":12,"line":169,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_init_parse_params($self,@args)"},"name":"_init_parse_params","containerName":"main::","children":[{"definition":"my","line":171,"localvar":"my","kind":13,"containerName":"_init_parse_params","name":"$self"},{"name":"@args","kind":13,"containerName":"_init_parse_params","line":171},{"line":174,"name":"$ithresh","localvar":"my","containerName":"_init_parse_params","kind":13,"definition":"my"},{"kind":13,"containerName":"_init_parse_params","name":"$signif","line":174},{"line":174,"name":"$score","containerName":"_init_parse_params","kind":13},{"line":174,"name":"$bits","kind":13,"containerName":"_init_parse_params"},{"line":174,"name":"$hit_filter","kind":13,"containerName":"_init_parse_params"},{"kind":13,"containerName":"_init_parse_params","name":"$filt_func","line":174},{"line":175,"containerName":"_init_parse_params","kind":13,"name":"$self"},{"line":175,"containerName":"_init_parse_params","kind":12,"name":"_rearrange"},{"name":"@args","containerName":"_init_parse_params","kind":13,"line":177},{"line":179,"containerName":"_init_parse_params","kind":13,"name":"$self"},{"line":179,"name":"inclusion_threshold","containerName":"_init_parse_params","kind":12},{"line":179,"name":"$ithresh","containerName":"_init_parse_params","kind":13},{"containerName":"_init_parse_params","kind":13,"name":"$ithresh","line":179},{"containerName":"_init_parse_params","kind":13,"name":"$DEFAULT_INCLUSION_THRESHOLD","line":179},{"name":"$hit_filt","containerName":"_init_parse_params","localvar":"my","kind":13,"line":180,"definition":"my"},{"line":180,"containerName":"_init_parse_params","kind":13,"name":"$hit_filter"},{"kind":13,"containerName":"_init_parse_params","name":"$filt_func","line":180},{"line":181,"name":"$hit_filter","containerName":"_init_parse_params","kind":13},{"kind":13,"containerName":"_init_parse_params","name":"$self","line":181},{"containerName":"_init_parse_params","kind":12,"name":"hit_filter","line":181},{"line":181,"kind":13,"containerName":"_init_parse_params","name":"$hit_filt"},{"name":"$signif","containerName":"_init_parse_params","kind":13,"line":182},{"line":182,"name":"$self","containerName":"_init_parse_params","kind":13},{"line":182,"containerName":"_init_parse_params","kind":12,"name":"max_significance"},{"line":182,"name":"$signif","containerName":"_init_parse_params","kind":13},{"line":183,"containerName":"_init_parse_params","kind":13,"name":"$score"},{"kind":13,"containerName":"_init_parse_params","name":"$self","line":183},{"line":183,"kind":12,"containerName":"_init_parse_params","name":"min_score"},{"containerName":"_init_parse_params","kind":13,"name":"$score","line":183},{"line":184,"containerName":"_init_parse_params","kind":13,"name":"$bits"},{"line":184,"kind":13,"containerName":"_init_parse_params","name":"$self"},{"kind":12,"containerName":"_init_parse_params","name":"min_bits","line":184},{"line":184,"name":"$bits","containerName":"_init_parse_params","kind":13}],"detail":"($self,@args)","definition":"sub"},{"children":[{"line":199,"localvar":"my","kind":13,"containerName":"will_handle","name":"$self","definition":"my"},{"containerName":"will_handle","kind":13,"name":"$type","line":199},{"name":"$type","kind":13,"containerName":"will_handle","line":201},{"containerName":"will_handle","kind":13,"name":"$type","line":201},{"line":201,"name":"$type","kind":13,"containerName":"will_handle"},{"line":201,"containerName":"will_handle","kind":13,"name":"$type"},{"line":202,"kind":13,"containerName":"will_handle","name":"$type"},{"line":202,"kind":13,"containerName":"will_handle","name":"$type"}],"name":"will_handle","containerName":"main::","definition":"sub","detail":"($self,$type)","line":198,"kind":12,"range":{"end":{"character":9999,"line":203},"start":{"character":0,"line":198}},"signature":{"label":"will_handle($self,$type)","documentation":"","parameters":[{"label":"$self"},{"label":"$type"}]}},{"range":{"start":{"line":219,"character":0},"end":{"character":9999,"line":228}},"kind":12,"line":219,"definition":"sub","containerName":"main::","name":"start_result","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"start_result","line":220},{"containerName":"start_result","kind":13,"name":"$self","line":222},{"line":223,"kind":13,"containerName":"start_result","name":"$self"},{"name":"$self","containerName":"start_result","kind":13,"line":224},{"line":225,"kind":13,"containerName":"start_result","name":"$self"},{"containerName":"start_result","kind":13,"name":"$self","line":226}]},{"name":"SUPER","kind":12,"containerName":"start_result","line":222},{"children":[{"name":"$self","containerName":"end_result","localvar":"my","kind":13,"line":241,"definition":"my"},{"line":241,"name":"$type","containerName":"end_result","kind":13},{"kind":13,"containerName":"end_result","name":"$data","line":241},{"line":244,"name":"$data","kind":13,"containerName":"end_result"},{"containerName":"end_result","kind":13,"name":"$data","line":245},{"name":"$data","containerName":"end_result","kind":13,"line":247},{"line":248,"name":"$data","containerName":"end_result","kind":13},{"line":248,"containerName":"end_result","kind":13,"name":"$data"},{"line":250,"name":"$data","kind":13,"containerName":"end_result"},{"line":250,"containerName":"end_result","kind":13,"name":"$data"},{"line":251,"name":"$data","containerName":"end_result","kind":13},{"definition":"my","line":254,"name":"@a","containerName":"end_result","localvar":"my","kind":13},{"containerName":"end_result","kind":13,"name":"$data","line":254},{"line":255,"name":"$acc","localvar":"my","containerName":"end_result","kind":13,"definition":"my"},{"line":255,"kind":13,"containerName":"end_result","name":"@a"},{"name":"$acc","kind":13,"containerName":"end_result","line":257},{"containerName":"end_result","kind":13,"name":"@a","line":257},{"name":"$acc","kind":13,"containerName":"end_result","line":257},{"kind":13,"containerName":"end_result","name":"$acc","line":257},{"line":258,"containerName":"end_result","kind":13,"name":"$data"},{"containerName":"end_result","kind":13,"name":"$acc","line":258},{"name":"$data","containerName":"end_result","kind":13,"line":260},{"kind":13,"localvar":"my","containerName":"end_result","name":"%args","line":262,"definition":"my"},{"name":"$v","kind":13,"localvar":"my","containerName":"end_result","line":262,"definition":"my"},{"name":"$data","kind":13,"containerName":"end_result","line":262},{"line":262,"containerName":"end_result","kind":13,"name":"$v"},{"line":263,"containerName":"end_result","kind":13,"name":"$data"}],"containerName":"main::","name":"end_result","definition":"sub","detail":"($self,$type,$data)","line":240,"range":{"start":{"line":240,"character":0},"end":{"line":263,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}],"documentation":"","label":"end_result($self,$type,$data)"}},{"name":"%args","containerName":null,"kind":13,"line":265},{"line":265,"kind":13,"containerName":null,"name":"%args"},{"line":266,"name":"%data","containerName":null,"kind":13},{"line":266,"containerName":null,"kind":13,"name":"$type"},{"name":"%args","containerName":null,"kind":13,"line":268},{"line":268,"name":"%self","kind":13,"containerName":null},{"line":270,"localvar":"my","containerName":null,"kind":13,"name":"$result","definition":"my"},{"line":270,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"factory","line":270},{"name":"create_object","kind":12,"containerName":"main::","line":270},{"line":270,"name":"%args","kind":13,"containerName":null},{"line":271,"name":"$result","kind":13,"containerName":null},{"name":"hit_factory","containerName":"main::","kind":12,"line":271},{"line":271,"containerName":null,"kind":13,"name":"$self"},{"line":271,"name":"factory","kind":12,"containerName":"main::"},{"line":272,"name":"%self","kind":13,"containerName":null},{"line":273,"name":"$result","kind":13,"containerName":null},{"children":[{"kind":13,"localvar":"my","containerName":"_add_hit","name":"$self","line":282,"definition":"my"},{"line":282,"containerName":"_add_hit","kind":13,"name":"$hit"},{"line":284,"localvar":"my","containerName":"_add_hit","kind":13,"name":"$hit_name","definition":"my"},{"name":"$hit","kind":13,"containerName":"_add_hit","line":284},{"definition":"my","line":285,"name":"$hit_signif","localvar":"my","kind":13,"containerName":"_add_hit"},{"name":"$hit","kind":13,"containerName":"_add_hit","line":285},{"localvar":"my","containerName":"_add_hit","kind":13,"name":"$ithresh","line":286,"definition":"my"},{"line":286,"name":"$self","containerName":"_add_hit","kind":13},{"definition":"my","name":"$add_hit","localvar":"my","kind":13,"containerName":"_add_hit","line":289},{"definition":"my","line":291,"name":"$hit_filter","localvar":"my","containerName":"_add_hit","kind":13},{"name":"$self","containerName":"_add_hit","kind":13,"line":291},{"name":"$hit_filter","kind":13,"containerName":"_add_hit","line":293},{"name":"$hit","containerName":"_add_hit","kind":13,"line":296},{"line":296,"containerName":"_add_hit","kind":13,"name":"$self"},{"name":"factory","containerName":"_add_hit","kind":12,"line":296},{"line":296,"name":"create_object","kind":12,"containerName":"_add_hit"},{"containerName":"_add_hit","kind":13,"name":"$hit","line":296},{"containerName":"_add_hit","kind":13,"name":"$add_hit","line":297},{"line":297,"name":"$hit","containerName":"_add_hit","kind":13}],"containerName":"main::","name":"_add_hit","definition":"sub","detail":"($self,$hit)","line":281,"kind":12,"range":{"start":{"character":0,"line":281},"end":{"line":298,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$hit"}],"documentation":"","label":"_add_hit($self,$hit)"}},{"kind":12,"name":"hit_filter","line":297},{"line":299,"kind":13,"containerName":null,"name":"%self"},{"line":300,"name":"$add_hit","kind":13,"containerName":null},{"line":300,"name":"$hit_signif","containerName":null,"kind":13},{"name":"%self","kind":13,"containerName":null,"line":300},{"kind":13,"containerName":null,"name":"%self","line":302},{"definition":"my","line":303,"name":"$hit_score","containerName":null,"localvar":"my","kind":13},{"name":"%hit","containerName":null,"kind":13,"line":303},{"line":303,"containerName":null,"kind":13,"name":"%hit"},{"line":304,"name":"$add_hit","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$hit_score","line":304},{"name":"%self","kind":13,"containerName":null,"line":304},{"containerName":null,"kind":13,"name":"%self","line":306},{"line":307,"localvar":"my","kind":13,"containerName":null,"name":"$hit_bits","definition":"my"},{"containerName":null,"kind":13,"name":"%hit","line":307},{"containerName":null,"kind":13,"name":"%hit","line":307},{"kind":13,"containerName":null,"name":"$add_hit","line":308},{"line":308,"name":"$hit_bits","containerName":null,"kind":13},{"line":308,"kind":13,"containerName":null,"name":"%self"},{"name":"$add_hit","containerName":null,"kind":13,"line":312},{"line":312,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"_store_hit","line":312},{"kind":13,"containerName":null,"name":"$hit","line":312},{"kind":13,"containerName":null,"name":"$hit_name","line":312},{"containerName":null,"kind":13,"name":"$hit_signif","line":312},{"line":315,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"kind":13,"name":"$hit_name","line":315},{"name":"%self","containerName":null,"kind":13,"line":316},{"containerName":null,"kind":13,"name":"$hit_name","line":316},{"line":316,"name":"$hit_signif","containerName":null,"kind":13},{"name":"$ithresh","containerName":null,"kind":13,"line":316},{"containerName":"main::","name":"_store_hit","children":[{"definition":"my","line":348,"kind":13,"localvar":"my","containerName":"_store_hit","name":"$self"},{"name":"$hit","containerName":"_store_hit","kind":13,"line":348},{"containerName":"_store_hit","kind":13,"name":"$hit_name","line":348},{"containerName":"_store_hit","kind":13,"name":"$hit_signif","line":348},{"definition":"my","name":"$ithresh","containerName":"_store_hit","localvar":"my","kind":13,"line":350},{"name":"$self","kind":13,"containerName":"_store_hit","line":350},{"line":358,"containerName":"_store_hit","kind":13,"name":"$self"},{"name":"$hit_name","kind":13,"containerName":"_store_hit","line":358},{"line":359,"containerName":"_store_hit","kind":13,"name":"$self"}],"detail":"($self,$hit,$hit_name,$hit_signif)","definition":"sub","range":{"start":{"line":347,"character":0},"end":{"line":359,"character":9999}},"kind":12,"line":347,"signature":{"parameters":[{"label":"$self"},{"label":"$hit"},{"label":"$hit_name"},{"label":"$hit_signif"}],"documentation":"","label":"_store_hit($self,$hit,$hit_name,$hit_signif)"}},{"line":359,"kind":12,"name":"_iterations"},{"containerName":null,"kind":13,"name":"%self","line":360},{"name":"%hit_name","containerName":null,"kind":13,"line":360},{"line":361,"kind":13,"containerName":null,"name":"%self"},{"name":"$hit","containerName":null,"kind":13,"line":361},{"name":"$hit_signif","containerName":null,"kind":13,"line":362},{"name":"%ithresh","containerName":null,"kind":13,"line":362},{"containerName":null,"kind":13,"name":"%self","line":363},{"kind":13,"containerName":null,"name":"%hit","line":363},{"line":365,"name":"%self","containerName":null,"kind":13},{"name":"%hit","containerName":null,"kind":13,"line":365},{"containerName":null,"kind":13,"name":"$hit_signif","line":368},{"kind":13,"containerName":null,"name":"%ithresh","line":368},{"name":"%self","containerName":null,"kind":13,"line":369},{"name":"%hit","containerName":null,"kind":13,"line":369},{"line":371,"name":"%self","containerName":null,"kind":13},{"name":"$hit","kind":13,"containerName":null,"line":371},{"name":"%self","kind":13,"containerName":null,"line":374},{"children":[{"line":388,"localvar":"my","kind":13,"containerName":"start_iteration","name":"$self","definition":"my"},{"line":388,"kind":13,"containerName":"start_iteration","name":"$type"},{"containerName":"start_iteration","kind":13,"name":"$self","line":391},{"kind":13,"containerName":"start_iteration","name":"$self","line":395},{"line":396,"kind":13,"containerName":"start_iteration","name":"$self"},{"kind":13,"containerName":"start_iteration","name":"$self","line":397},{"containerName":"start_iteration","kind":13,"name":"$self","line":398},{"name":"$self","kind":13,"containerName":"start_iteration","line":399},{"containerName":"start_iteration","kind":13,"name":"$self","line":400}],"name":"start_iteration","containerName":"main::","definition":"sub","detail":"($self,$type)","line":387,"kind":12,"range":{"end":{"character":9999,"line":402},"start":{"line":387,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"","label":"start_iteration($self,$type)"}},{"definition":"sub","detail":"($self,$type,$data)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"end_iteration","name":"$self","line":417},{"containerName":"end_iteration","kind":13,"name":"$type","line":417},{"containerName":"end_iteration","kind":13,"name":"$data","line":417},{"definition":"my","line":421,"name":"%args","localvar":"my","kind":13,"containerName":"end_iteration"},{"line":421,"localvar":"my","containerName":"end_iteration","kind":13,"name":"$v","definition":"my"},{"containerName":"end_iteration","kind":13,"name":"$data","line":421},{"containerName":"end_iteration","kind":13,"name":"$v","line":421},{"line":422,"kind":13,"containerName":"end_iteration","name":"$data"}],"name":"end_iteration","containerName":"main::","signature":{"label":"end_iteration($self,$type,$data)","documentation":"","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}]},"line":416,"kind":12,"range":{"start":{"character":0,"line":416},"end":{"character":9999,"line":422}}},{"line":424,"name":"%args","kind":13,"containerName":null},{"line":424,"containerName":null,"kind":13,"name":"%self"},{"line":425,"name":"%args","containerName":null,"kind":13},{"line":425,"containerName":null,"kind":13,"name":"%self"},{"line":426,"containerName":null,"kind":13,"name":"%args"},{"line":426,"containerName":null,"kind":13,"name":"%self"},{"line":427,"containerName":null,"kind":13,"name":"%args"},{"name":"%self","containerName":null,"kind":13,"line":427},{"name":"%args","containerName":null,"kind":13,"line":428},{"line":428,"kind":13,"containerName":null,"name":"%self"},{"line":429,"kind":13,"containerName":null,"name":"%args"},{"name":"%self","containerName":null,"kind":13,"line":429},{"line":430,"kind":13,"containerName":null,"name":"%args"},{"name":"$self","kind":13,"containerName":null,"line":430},{"name":"factory","containerName":"main::","kind":12,"line":430},{"definition":"my","line":432,"localvar":"my","kind":13,"containerName":null,"name":"$it"},{"containerName":null,"kind":13,"name":"$self","line":432},{"containerName":"main::","kind":12,"name":"factory","line":432},{"line":432,"name":"create_object","kind":12,"containerName":"main::"},{"line":432,"kind":13,"containerName":null,"name":"%args"},{"containerName":null,"kind":13,"name":"%self","line":433},{"name":"$it","kind":13,"containerName":null,"line":433},{"line":434,"name":"$it","containerName":null,"kind":13},{"line":453,"kind":12,"range":{"start":{"line":453,"character":0},"end":{"line":467,"character":9999}},"children":[{"definition":"my","line":454,"name":"$self","localvar":"my","kind":13,"containerName":"max_significance"},{"name":"$sig","localvar":"my","containerName":"max_significance","kind":13,"line":456,"definition":"my"},{"kind":13,"containerName":"max_significance","name":"$sig","line":457},{"line":457,"containerName":"max_significance","kind":13,"name":"$sig"},{"name":"$self","containerName":"max_significance","kind":13,"line":458},{"line":458,"kind":12,"containerName":"max_significance","name":"throw"},{"line":461,"containerName":"max_significance","kind":13,"name":"$sig"},{"kind":13,"containerName":"max_significance","name":"$self","line":463},{"line":464,"containerName":"max_significance","kind":13,"name":"$self"},{"line":464,"containerName":"max_significance","kind":13,"name":"$sig"},{"name":"$self","containerName":"max_significance","kind":13,"line":466}],"containerName":"main::","name":"max_significance","definition":"sub"},{"kind":12,"range":{"start":{"character":0,"line":476},"end":{"line":476,"character":9999}},"line":476,"definition":"sub","containerName":"main::","name":"signif","children":[{"line":476,"name":"max_significance","kind":12,"containerName":"signif"}]},{"containerName":"main::","name":"min_score","children":[{"name":"$self","containerName":"min_score","localvar":"my","kind":13,"line":494,"definition":"my"},{"definition":"my","containerName":"min_score","localvar":"my","kind":13,"name":"$score","line":496},{"kind":13,"containerName":"min_score","name":"$score","line":497},{"name":"$score","containerName":"min_score","kind":13,"line":497},{"line":498,"kind":13,"containerName":"min_score","name":"$self"},{"kind":12,"containerName":"min_score","name":"throw","line":498},{"line":501,"containerName":"min_score","kind":13,"name":"$score"},{"line":503,"name":"$self","containerName":"min_score","kind":13},{"name":"$self","containerName":"min_score","kind":13,"line":504},{"line":504,"containerName":"min_score","kind":13,"name":"$score"},{"line":506,"containerName":"min_score","kind":13,"name":"$self"}],"definition":"sub","range":{"end":{"character":9999,"line":507},"start":{"character":0,"line":493}},"kind":12,"line":493},{"definition":"sub","children":[{"definition":"my","line":526,"name":"$self","localvar":"my","containerName":"min_bits","kind":13},{"definition":"my","line":528,"name":"$bits","containerName":"min_bits","localvar":"my","kind":13},{"name":"$bits","containerName":"min_bits","kind":13,"line":529},{"kind":13,"containerName":"min_bits","name":"$bits","line":529},{"line":530,"name":"$self","kind":13,"containerName":"min_bits"},{"line":530,"name":"throw","kind":12,"containerName":"min_bits"},{"name":"$bits","kind":13,"containerName":"min_bits","line":533},{"line":535,"name":"$self","kind":13,"containerName":"min_bits"},{"containerName":"min_bits","kind":13,"name":"$self","line":536},{"line":536,"name":"$bits","kind":13,"containerName":"min_bits"},{"name":"$self","containerName":"min_bits","kind":13,"line":538}],"name":"min_bits","containerName":"main::","line":525,"kind":12,"range":{"end":{"line":539,"character":9999},"start":{"character":0,"line":525}}},{"kind":12,"range":{"start":{"character":0,"line":555},"end":{"line":568,"character":9999}},"line":555,"definition":"sub","name":"hit_filter","containerName":"main::","children":[{"localvar":"my","containerName":"hit_filter","kind":13,"name":"$self","line":556,"definition":"my"},{"definition":"my","localvar":"my","containerName":"hit_filter","kind":13,"name":"$func","line":558},{"name":"$func","kind":13,"containerName":"hit_filter","line":559},{"name":"$self","kind":13,"containerName":"hit_filter","line":560},{"line":560,"name":"throw","containerName":"hit_filter","kind":12},{"line":563,"name":"$func","containerName":"hit_filter","kind":13},{"line":565,"name":"$self","kind":13,"containerName":"hit_filter"},{"name":"$func","kind":13,"containerName":"hit_filter","line":565},{"containerName":"hit_filter","kind":13,"name":"$self","line":567}]},{"kind":12,"range":{"start":{"character":0,"line":576},"end":{"line":580,"character":9999}},"line":576,"definition":"sub","name":"inclusion_threshold","containerName":"main::","children":[{"definition":"my","line":577,"name":"$self","localvar":"my","kind":13,"containerName":"inclusion_threshold"},{"line":578,"containerName":"inclusion_threshold","kind":13,"name":"$self"},{"line":579,"kind":13,"containerName":"inclusion_threshold","name":"$self"}]}]}