{"vars":[{"line":93,"name":"vars","kind":2,"containerName":""},{"line":100,"name":"base","kind":2,"containerName":""},{"line":115,"kind":12,"range":{"start":{"character":0,"line":115},"end":{"character":9999,"line":131}},"signature":{"documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"children":[{"kind":13,"localvar":"my","containerName":"new","name":"$class","line":116,"definition":"my"},{"name":"@args","kind":13,"containerName":"new","line":116},{"name":"$self","localvar":"my","kind":13,"containerName":"new","line":117,"definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":117},{"containerName":"new","kind":13,"name":"@args","line":117},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$hitF","line":118},{"line":118,"containerName":"new","kind":13,"name":"$resultF"},{"name":"$self","kind":13,"containerName":"new","line":118},{"name":"_rearrange","kind":12,"containerName":"new","line":118},{"kind":13,"containerName":"new","name":"@args","line":119},{"name":"$self","containerName":"new","kind":13,"line":120},{"line":120,"containerName":"new","kind":12,"name":"register_factory"},{"containerName":"new","kind":13,"name":"$hitF","line":120},{"kind":12,"containerName":"new","name":"new","line":121},{"line":125,"containerName":"new","kind":13,"name":"$self"},{"name":"register_factory","containerName":"new","kind":12,"line":125},{"kind":13,"containerName":"new","name":"$resultF","line":125},{"containerName":"new","kind":12,"name":"new","line":126},{"name":"$self","containerName":"new","kind":13,"line":130}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"kind":12,"containerName":"new","name":"SUPER","line":117},{"containerName":"Factory::ObjectFactory","kind":12,"name":"Bio","line":121},{"line":126,"name":"Bio","kind":12,"containerName":"Factory::ObjectFactory"},{"signature":{"documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name","parameters":[{"label":"$self"},{"label":"$type"}],"label":"will_handle($self,$type)"},"line":146,"kind":12,"range":{"end":{"line":150,"character":9999},"start":{"line":146,"character":0}},"definition":"sub","detail":"($self,$type)","children":[{"line":147,"name":"$self","containerName":"will_handle","localvar":"my","kind":13,"definition":"my"},{"name":"$type","containerName":"will_handle","kind":13,"line":147},{"line":149,"name":"$type","containerName":"will_handle","kind":13},{"containerName":"will_handle","kind":13,"name":"$type","line":149}],"containerName":"main::","name":"will_handle"},{"detail":"($self,$type)","definition":"sub","containerName":"main::","name":"start_result","children":[{"definition":"my","line":167,"localvar":"my","kind":13,"containerName":"start_result","name":"$self"},{"name":"$type","kind":13,"containerName":"start_result","line":167},{"line":168,"name":"$self","containerName":"start_result","kind":13},{"name":"$type","containerName":"start_result","kind":13,"line":168},{"line":169,"kind":13,"containerName":"start_result","name":"$self"}],"signature":{"label":"start_result($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report"},"range":{"end":{"line":171,"character":9999},"start":{"line":166,"character":0}},"kind":12,"line":166},{"signature":{"label":"end_result($self,$type,$data)","documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle Returns : A Bio::Search::Result::ResultI\n Args    : none","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}]},"line":182,"range":{"start":{"character":0,"line":182},"end":{"line":202,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$type,$data)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"end_result","line":183},{"kind":13,"containerName":"end_result","name":"$type","line":183},{"line":183,"name":"$data","containerName":"end_result","kind":13},{"kind":13,"containerName":"end_result","name":"$data","line":184},{"kind":13,"containerName":"end_result","name":"$data","line":185},{"name":"$data","containerName":"end_result","kind":13,"line":187},{"name":"$data","containerName":"end_result","kind":13,"line":188},{"line":188,"kind":13,"containerName":"end_result","name":"$data"},{"kind":13,"containerName":"end_result","name":"$data","line":190},{"line":190,"kind":13,"containerName":"end_result","name":"$data"},{"line":190,"containerName":"end_result","kind":13,"name":"$data"},{"definition":"my","line":193,"name":"@a","kind":13,"localvar":"my","containerName":"end_result"},{"containerName":"end_result","kind":13,"name":"$data","line":193},{"definition":"my","line":194,"kind":13,"localvar":"my","containerName":"end_result","name":"$acc"},{"kind":13,"containerName":"end_result","name":"@a","line":194},{"name":"$acc","kind":13,"containerName":"end_result","line":196},{"name":"@a","containerName":"end_result","kind":13,"line":196},{"line":196,"containerName":"end_result","kind":13,"name":"$acc"},{"name":"$acc","containerName":"end_result","kind":13,"line":196},{"line":197,"containerName":"end_result","kind":13,"name":"$data"},{"line":197,"kind":13,"containerName":"end_result","name":"$acc"},{"line":199,"name":"$data","containerName":"end_result","kind":13},{"containerName":"end_result","localvar":"my","kind":13,"name":"%args","line":201,"definition":"my"},{"definition":"my","localvar":"my","containerName":"end_result","kind":13,"name":"$v","line":201},{"line":201,"name":"$data","kind":13,"containerName":"end_result"},{"kind":13,"containerName":"end_result","name":"$v","line":201},{"line":202,"name":"$data","containerName":"end_result","kind":13}],"name":"end_result","containerName":"main::"},{"kind":13,"containerName":null,"name":"%args","line":204},{"containerName":null,"kind":13,"name":"%args","line":204},{"name":"$type","kind":13,"containerName":null,"line":204},{"containerName":null,"kind":13,"name":"%args","line":205},{"line":205,"name":"%self","containerName":null,"kind":13},{"definition":"my","line":206,"name":"$result","localvar":"my","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$self","line":206},{"line":206,"containerName":"main::","kind":12,"name":"factory"},{"kind":12,"containerName":"main::","name":"create","line":206},{"line":206,"name":"%args","containerName":null,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":207},{"line":208,"name":"$result","kind":13,"containerName":null},{"definition":"sub","detail":"($self,$type)","children":[{"name":"$self","localvar":"my","containerName":"start_hit","kind":13,"line":223,"definition":"my"},{"kind":13,"containerName":"start_hit","name":"$type","line":223}],"name":"start_hit","containerName":"main::","signature":{"documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n    if( defined $data->{'runid'} &&\n\t$data->{'runid'} !~ /^\\s+$/ ) {\t\n\t\n\tif( $data->{'runid'} !~ /^lcl\\|/) { \n\t    $data->{\"RESULT-query_name\"}= $data->{'runid'};\n\t} else { \n\t    ($data->{\"RESULT-query_name\"},$data->{\"RESULT-query_description\"}) = split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n\t}\n\t\n\tif( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n\t    my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n\t    # this is for |123|gb|ABC1.1|\n\t    $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n\t    $data->{\"RESULT-query_accession\"}= $acc;\n\t}\n\tdelete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create(%args);\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref","parameters":[{"label":"$self"},{"label":"$type"}],"label":"start_hit($self,$type)"},"line":222,"range":{"end":{"character":9999,"line":225},"start":{"character":0,"line":222}},"kind":12},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"end_hit","name":"$self","line":240},{"line":240,"name":"$type","kind":13,"containerName":"end_hit"},{"line":240,"kind":13,"containerName":"end_hit","name":"$data"},{"line":241,"localvar":"my","kind":13,"containerName":"end_hit","name":"%args","definition":"my"},{"name":"$v","kind":13,"localvar":"my","containerName":"end_hit","line":241,"definition":"my"},{"kind":13,"containerName":"end_hit","name":"$data","line":241},{"name":"$v","kind":13,"containerName":"end_hit","line":241},{"containerName":"end_hit","kind":13,"name":"$data","line":241}],"containerName":"main::","name":"end_hit","definition":"sub","detail":"($self,$type,$data)","line":239,"range":{"start":{"line":239,"character":0},"end":{"character":9999,"line":241}},"kind":12,"signature":{"documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n    if( defined $data->{'runid'} &&\n\t$data->{'runid'} !~ /^\\s+$/ ) {\t\n\t\n\tif( $data->{'runid'} !~ /^lcl\\|/) { \n\t    $data->{\"RESULT-query_name\"}= $data->{'runid'};\n\t} else { \n\t    ($data->{\"RESULT-query_name\"},$data->{\"RESULT-query_description\"}) = split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n\t}\n\t\n\tif( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n\t    my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n\t    # this is for |123|gb|ABC1.1|\n\t    $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n\t    $data->{\"RESULT-query_accession\"}= $acc;\n\t}\n\tdelete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create(%args);\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit{\n    my ($self,$type) = @_;\n    return;\n}\n\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}],"label":"end_hit($self,$type,$data)"}},{"line":242,"containerName":null,"kind":13,"name":"%args"},{"name":"%args","kind":13,"containerName":null,"line":242},{"name":"$type","kind":13,"containerName":null,"line":242},{"kind":13,"containerName":null,"name":"%args","line":243},{"line":243,"containerName":null,"kind":13,"name":"%data"},{"kind":13,"localvar":"my","containerName":null,"name":"$hitrank","line":244,"definition":"my"},{"line":244,"containerName":null,"kind":13,"name":"%self"},{"name":"%args","kind":13,"containerName":null,"line":245},{"line":245,"kind":13,"containerName":null,"name":"$hitrank"},{"line":246,"name":"$hit","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":246,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"factory","line":246},{"kind":12,"containerName":"main::","name":"create","line":246},{"line":246,"name":"%args","kind":13,"containerName":null},{"line":247,"containerName":null,"kind":13,"name":"%self"},{"containerName":null,"kind":13,"name":"$hit","line":247},{"line":248,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"containerName":null,"name":"$hit","line":249},{"line":269,"range":{"end":{"line":276,"character":9999},"start":{"character":0,"line":269}},"kind":12,"signature":{"documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n    if( defined $data->{'runid'} &&\n\t$data->{'runid'} !~ /^\\s+$/ ) {\t\n\t\n\tif( $data->{'runid'} !~ /^lcl\\|/) { \n\t    $data->{\"RESULT-query_name\"}= $data->{'runid'};\n\t} else { \n\t    ($data->{\"RESULT-query_name\"},$data->{\"RESULT-query_description\"}) = split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n\t}\n\t\n\tif( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n\t    my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n\t    # this is for |123|gb|ABC1.1|\n\t    $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n\t    $data->{\"RESULT-query_accession\"}= $acc;\n\t}\n\tdelete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create(%args);\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit{\n    my ($self,$type) = @_;\n    return;\n}\n\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref\n\n\n\nsub end_hit{\n    my ($self,$type,$data) = @_;   \n    my %args = map { my $v = $data->{$_}; s/HIT//; ($_ => $v); } grep { /^HIT/ } keys %{$data};\n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || $type);\n    $args{'-query_len'} =  $data->{'RESULT-query_length'};\n    my ($hitrank) = scalar @{$self->{'_hits'}} + 1;\n    $args{'-rank'} = $hitrank;\n    my $hit = $self->factory('hit')->create(%args);\n    push @{$self->{'_hits'}}, $hit;\n    $self->{'_hsps'} = [];\n    return $hit;\n}\n\n=head2 Factory methods\n\n\n=head2 register_factory\n\n Title   : register_factory\n Usage   : $handler->register_factory('TYPE',$factory);\n Function: Register a specific factory for a object type class\n Returns : none\n Args    : string representing the class and\n           Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$f"}],"label":"register_factory($self,$type,$f)"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"register_factory","line":270,"definition":"my"},{"kind":13,"containerName":"register_factory","name":"$type","line":270},{"name":"$f","kind":13,"containerName":"register_factory","line":270},{"containerName":"register_factory","kind":13,"name":"$f","line":271},{"containerName":"register_factory","kind":13,"name":"$f","line":271},{"kind":13,"containerName":"register_factory","name":"$f","line":272},{"name":"isa","kind":12,"containerName":"register_factory","line":272},{"kind":13,"containerName":"register_factory","name":"$self","line":273},{"kind":12,"containerName":"register_factory","name":"throw","line":273},{"containerName":"register_factory","kind":13,"name":"$f","line":273},{"name":"$self","kind":13,"containerName":"register_factory","line":275},{"name":"$type","kind":13,"containerName":"register_factory","line":275},{"name":"$f","kind":13,"containerName":"register_factory","line":275}],"name":"register_factory","containerName":"main::","definition":"sub","detail":"($self,$type,$f)"},{"line":291,"kind":12,"range":{"start":{"line":291,"character":0},"end":{"line":294,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: FastHitEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::FastHitEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::FastHitEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n  # Do not use this object directly, this object is part of the SearchIO\n  # event based parsing system.\n\n  # to use the FastHitEventBuilder do this\n\n  use Bio::SearchIO::FastHitEventBuilder;\n\n  my $searchio = Bio::SearchIO->new(-format => $format, -file => $file);\n\n  $searchio->attach_EventHandler(Bio::SearchIO::FastHitEventBuilder->new());\n\n  while( my $r = $searchio->next_result ) {\n   while( my $h = $r->next_hit ) {\n    # note that Hits will NOT have HSPs\n   }\n  }\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.  This object\nis intended for lightweight parsers which only want Hits and not deal\nwith the overhead of HSPs.  It is a lot faster than the standard\nparser event handler but of course you are getting less information\nand less objects out.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::FastHitEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::FastHitEventBuilder->new();\n Function: Builds a new Bio::SearchIO::FastHitEventBuilder object \n Returns : Bio::SearchIO::FastHitEventBuilder\n Args    : -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hitF,$resultF) = $self->_rearrange([qw(HIT_FACTORY\n\t\t\t\t\t\t      RESULT_FACTORY)],@args);\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n    if( defined $data->{'runid'} &&\n\t$data->{'runid'} !~ /^\\s+$/ ) {\t\n\t\n\tif( $data->{'runid'} !~ /^lcl\\|/) { \n\t    $data->{\"RESULT-query_name\"}= $data->{'runid'};\n\t} else { \n\t    ($data->{\"RESULT-query_name\"},$data->{\"RESULT-query_description\"}) = split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n\t}\n\t\n\tif( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n\t    my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n\t    # this is for |123|gb|ABC1.1|\n\t    $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n\t    $data->{\"RESULT-query_accession\"}= $acc;\n\t}\n\tdelete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create(%args);\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit{\n    my ($self,$type) = @_;\n    return;\n}\n\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref\n\n\n\nsub end_hit{\n    my ($self,$type,$data) = @_;   \n    my %args = map { my $v = $data->{$_}; s/HIT//; ($_ => $v); } grep { /^HIT/ } keys %{$data};\n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || $type);\n    $args{'-query_len'} =  $data->{'RESULT-query_length'};\n    my ($hitrank) = scalar @{$self->{'_hits'}} + 1;\n    $args{'-rank'} = $hitrank;\n    my $hit = $self->factory('hit')->create(%args);\n    push @{$self->{'_hits'}}, $hit;\n    $self->{'_hsps'} = [];\n    return $hit;\n}\n\n=head2 Factory methods\n\n\n=head2 register_factory\n\n Title   : register_factory\n Usage   : $handler->register_factory('TYPE',$factory);\n Function: Register a specific factory for a object type class\n Returns : none\n Args    : string representing the class and\n           Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub register_factory{\n   my ($self, $type,$f) = @_;\n   if( ! defined $f || ! ref($f) || \n       ! $f->isa('Bio::Factory::ObjectFactoryI') ) { \n       $self->throw(\"Cannot set factory to value $f\".ref($f).\"\\n\");\n   }\n   $self->{'_factories'}->{lc($type)} = $f;\n}\n\n\n=head2 factory\n\n Title   : factory\n Usage   : my $f = $handler->factory('TYPE');\n Function: Retrieves the associated factory for requested 'TYPE'\n Returns : a Bio::Factory::ObjectFactoryI or undef if none registered\n Args    : name of factory class to retrieve\n\nSee L<Bio::Factory::ObjectFactoryI> for more information","label":"factory($self,$type)"},"children":[{"line":292,"localvar":"my","kind":13,"containerName":"factory","name":"$self","definition":"my"},{"containerName":"factory","kind":13,"name":"$type","line":292},{"line":293,"kind":13,"containerName":"factory","name":"$self"},{"name":"$type","containerName":"factory","kind":13,"line":293},{"name":"$self","containerName":"factory","kind":13,"line":293},{"name":"throw","containerName":"factory","kind":12,"line":293}],"name":"factory","containerName":"main::","definition":"sub","detail":"($self,$type)"},{"line":302,"kind":12,"range":{"start":{"line":302,"character":0},"end":{"line":306,"character":9999}},"definition":"sub","children":[{"line":303,"name":"$self","kind":13,"localvar":"my","containerName":"inclusion_threshold","definition":"my"},{"name":"$self","kind":13,"containerName":"inclusion_threshold","line":304},{"name":"$self","kind":13,"containerName":"inclusion_threshold","line":305}],"name":"inclusion_threshold","containerName":"main::"}],"version":5}