{"vars":[{"kind":13,"containerName":null,"name":"@Bio","line":121},{"kind":2,"containerName":"strict::Bio::SearchIO::SearchResultEventBuilder::SearchIO::InternalParserError","name":"ISA","line":121},{"name":"base","kind":2,"containerName":"","line":125},{"name":"new","containerName":"main::","children":[{"line":151,"containerName":"new","localvar":"my","kind":13,"name":"$caller","definition":"my"},{"line":151,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","name":"$class","localvar":"my","containerName":"new","kind":13,"line":152},{"line":152,"kind":13,"containerName":"new","name":"$caller"},{"line":152,"containerName":"new","kind":13,"name":"$caller"},{"name":"$class","kind":13,"containerName":"new","line":156},{"containerName":"new","localvar":"my","kind":13,"name":"$self","line":157,"definition":"my"},{"line":157,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":157},{"line":158,"name":"$self","kind":13,"containerName":"new"},{"line":158,"kind":12,"containerName":"new","name":"_initialize"},{"name":"@args","kind":13,"containerName":"new","line":158},{"kind":13,"containerName":"new","name":"$self","line":159},{"line":161,"containerName":"new","localvar":"my","kind":13,"name":"%param","definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":161},{"line":162,"containerName":"new","kind":13,"name":"@param"},{"containerName":"new","kind":13,"name":"%param","line":162},{"name":"%param","containerName":"new","kind":13,"line":162},{"definition":"my","line":163,"localvar":"my","kind":13,"containerName":"new","name":"$format"},{"line":163,"containerName":"new","kind":13,"name":"$param"},{"name":"$class","kind":13,"containerName":"new","line":164},{"name":"_guess_format","containerName":"new","kind":12,"line":164},{"line":164,"name":"$param","containerName":"new","kind":13},{"line":164,"name":"$ARGV","kind":13,"containerName":"new"},{"definition":"my","line":166,"localvar":"my","kind":13,"containerName":"new","name":"$output_format"},{"line":166,"name":"$param","containerName":"new","kind":13},{"line":167,"containerName":"new","localvar":"my","kind":13,"name":"$writer","definition":"my"},{"line":169,"kind":13,"containerName":"new","name":"$output_format"},{"containerName":"new","kind":13,"name":"$param","line":170},{"definition":"my","name":"$dummy","containerName":"new","localvar":"my","kind":13,"line":171},{"line":171,"containerName":"new","kind":12,"name":"new"},{"line":172,"kind":13,"containerName":"new","name":"$dummy"},{"containerName":"new","kind":12,"name":"throw","line":172},{"kind":13,"containerName":"new","name":"$output_format","line":175},{"name":"$output_format","containerName":"new","kind":13,"line":176},{"definition":"my","line":178,"name":"$output_module","kind":13,"localvar":"my","containerName":"new"},{"line":178,"name":"$output_format","kind":13,"containerName":"new"},{"line":179,"name":"$class","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"_load_module","line":179},{"kind":13,"containerName":"new","name":"$output_module","line":179},{"line":180,"kind":13,"containerName":"new","name":"$writer"},{"name":"$output_module","containerName":"new","kind":13,"line":180},{"line":180,"name":"new","kind":12,"containerName":"new"},{"line":180,"name":"@args","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"@args","line":181},{"line":181,"containerName":"new","kind":13,"name":"$writer"},{"line":186,"kind":13,"containerName":"new","name":"$format"},{"line":188,"name":"$class","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"_load_format_module","line":188},{"line":188,"kind":13,"containerName":"new","name":"$format"},{"line":189,"name":"new","kind":12,"containerName":"new"},{"name":"@args","kind":13,"containerName":"new","line":189}],"detail":"($caller,@args)","definition":"sub","kind":12,"range":{"start":{"line":150,"character":0},"end":{"character":9999,"line":191}},"line":150,"signature":{"label":"new($caller,@args)","documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.","parameters":[{"label":"$caller"},{"label":"@args"}]}},{"line":157,"name":"SUPER","containerName":"new","kind":12},{"kind":12,"containerName":"Root::Root","name":"Bio","line":171},{"definition":"sub","name":"newFh","containerName":"main::","children":[{"definition":"my","containerName":"newFh","localvar":"my","kind":13,"name":"$class","line":209},{"definition":"my","localvar":"my","containerName":"newFh","kind":13,"name":"$self","line":210},{"name":"$class","kind":13,"containerName":"newFh","line":210},{"line":210,"name":"new","containerName":"newFh","kind":12},{"name":"$self","kind":13,"containerName":"newFh","line":211},{"name":"fh","containerName":"newFh","kind":12,"line":211}],"kind":12,"range":{"end":{"line":212,"character":9999},"start":{"character":0,"line":208}},"line":208},{"line":228,"range":{"end":{"line":234,"character":9999},"start":{"character":0,"line":228}},"kind":12,"definition":"sub","children":[{"line":229,"kind":13,"localvar":"my","containerName":"fh","name":"$self","definition":"my"},{"line":230,"localvar":"my","kind":13,"containerName":"fh","name":"$class","definition":"my"},{"kind":13,"containerName":"fh","name":"$self","line":230},{"line":230,"name":"$self","containerName":"fh","kind":13},{"line":231,"name":"$s","localvar":"my","containerName":"fh","kind":13,"definition":"my"},{"line":232,"name":"$class","kind":13,"containerName":"fh"},{"name":"$self","containerName":"fh","kind":13,"line":232},{"line":233,"name":"$s","containerName":"fh","kind":13}],"name":"fh","containerName":"main::"},{"containerName":"gensym","kind":12,"name":"Symbol","line":232},{"name":"attach_EventHandler","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"attach_EventHandler","kind":13,"line":249},{"line":249,"name":"$handler","containerName":"attach_EventHandler","kind":13},{"line":250,"kind":13,"containerName":"attach_EventHandler","name":"$handler"},{"line":251,"kind":13,"containerName":"attach_EventHandler","name":"$handler"},{"line":251,"containerName":"attach_EventHandler","kind":12,"name":"isa"},{"name":"$self","kind":13,"containerName":"attach_EventHandler","line":252},{"name":"warn","kind":12,"containerName":"attach_EventHandler","line":252},{"line":252,"kind":13,"containerName":"attach_EventHandler","name":"$handler"},{"line":254,"containerName":"attach_EventHandler","kind":13,"name":"$self"},{"name":"$handler","containerName":"attach_EventHandler","kind":13,"line":254}],"detail":"($self,$handler)","definition":"sub","range":{"start":{"character":0,"line":248},"end":{"character":9999,"line":256}},"kind":12,"line":248,"signature":{"parameters":[{"label":"$self"},{"label":"$handler"}],"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>","label":"attach_EventHandler($self,$handler)"}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>","label":"_eventHandler($self)"},"range":{"start":{"line":270,"character":0},"end":{"character":9999,"line":273}},"kind":12,"line":270,"detail":"($self)","definition":"sub","containerName":"main::","name":"_eventHandler","children":[{"definition":"my","line":271,"localvar":"my","containerName":"_eventHandler","kind":13,"name":"$self"},{"name":"$self","containerName":"_eventHandler","kind":13,"line":272}]},{"containerName":"main::","name":"_initialize","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_initialize","line":276,"definition":"my"},{"line":276,"containerName":"_initialize","kind":13,"name":"@args"},{"line":277,"containerName":"_initialize","kind":13,"name":"$self"},{"line":282,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"_initialize_io","containerName":"_initialize","kind":12,"line":282},{"name":"@args","containerName":"_initialize","kind":13,"line":282},{"name":"$self","containerName":"_initialize","kind":13,"line":283},{"line":283,"name":"attach_EventHandler","containerName":"_initialize","kind":12},{"containerName":"_initialize","kind":12,"name":"new","line":283},{"name":"@args","containerName":"_initialize","kind":13,"line":283},{"line":284,"containerName":"_initialize","kind":13,"name":"$self"},{"line":285,"containerName":"_initialize","kind":13,"name":"$self"},{"line":286,"name":"$writer","localvar":"my","containerName":"_initialize","kind":13,"definition":"my"},{"containerName":"_initialize","kind":13,"name":"$self","line":286},{"kind":12,"containerName":"_initialize","name":"_rearrange","line":286},{"line":286,"containerName":"_initialize","kind":13,"name":"@args"},{"kind":13,"containerName":"_initialize","name":"$self","line":288},{"kind":12,"containerName":"_initialize","name":"writer","line":288},{"line":288,"name":"$writer","containerName":"_initialize","kind":13},{"line":288,"kind":13,"containerName":"_initialize","name":"$writer"}],"detail":"($self,@args)","definition":"sub","range":{"start":{"line":275,"character":0},"end":{"character":9999,"line":289}},"kind":12,"line":275,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize($self,@args)"}},{"name":"Bio","kind":12,"containerName":"SearchIO::SearchResultEventBuilder","line":283},{"kind":12,"name":"_notfirsttime","line":285},{"line":314,"kind":12,"range":{"start":{"line":314,"character":0},"end":{"character":9999,"line":317}},"signature":{"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    # not really necessary unless we put more in RootI\n    #$self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::SearchIO::SearchResultEventBuilder->new(@args));\n    $self->{'_reporttype'} = '';\n    $self->{_notfirsttime} = 0;\n    my ( $writer ) = $self->_rearrange([qw(WRITER)], @args);\n\n    $self->writer( $writer ) if $writer;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = stream->next_result\n Function: Reads the next ResultI object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::Root::RootI POD page).\n Returns : A Bio::Search::Result::ResultI object\n Args    : n/a\n\nSee L<Bio::Root::RootI>","parameters":[{"label":"$self"}],"label":"next_result($self)"},"children":[{"definition":"my","localvar":"my","containerName":"next_result","kind":13,"name":"$self","line":315},{"name":"$self","containerName":"next_result","kind":13,"line":316},{"line":316,"kind":12,"containerName":"next_result","name":"throw_not_implemented"}],"name":"next_result","containerName":"main::","definition":"sub","detail":"($self)"},{"line":335,"kind":12,"range":{"start":{"line":335,"character":0},"end":{"line":349,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$result"},{"label":"@args"}],"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    # not really necessary unless we put more in RootI\n    #$self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::SearchIO::SearchResultEventBuilder->new(@args));\n    $self->{'_reporttype'} = '';\n    $self->{_notfirsttime} = 0;\n    my ( $writer ) = $self->_rearrange([qw(WRITER)], @args);\n\n    $self->writer( $writer ) if $writer;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = stream->next_result\n Function: Reads the next ResultI object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::Root::RootI POD page).\n Returns : A Bio::Search::Result::ResultI object\n Args    : n/a\n\nSee L<Bio::Root::RootI>\n\n\nsub next_result {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 write_result\n\n Title   : write_result\n Usage   : $stream->write_result($result_result, @other_args)\n Function: Writes data from the $result_result object into the stream.\n         : Delegates to the to_string() method of the associated \n         : WriterI object.\n Returns : 1 for success and 0 for error\n Args    : Bio::Search:Result::ResultI object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>","label":"write_result($self,$result,@args)"},"children":[{"line":336,"kind":13,"localvar":"my","containerName":"write_result","name":"$self","definition":"my"},{"line":336,"kind":13,"containerName":"write_result","name":"$result"},{"line":336,"name":"@args","containerName":"write_result","kind":13},{"name":"$self","containerName":"write_result","kind":13,"line":338},{"name":"$self","kind":13,"containerName":"write_result","line":339},{"line":339,"name":"throw","containerName":"write_result","kind":12},{"line":341,"name":"@args","kind":13,"containerName":"write_result"},{"kind":13,"containerName":"write_result","name":"$self","line":341},{"line":341,"kind":13,"containerName":"write_result","name":"@args"},{"definition":"my","name":"$str","localvar":"my","containerName":"write_result","kind":13,"line":343},{"name":"$self","kind":13,"containerName":"write_result","line":343},{"line":343,"name":"writer","containerName":"write_result","kind":12},{"name":"to_string","containerName":"write_result","kind":12,"line":343},{"containerName":"write_result","kind":13,"name":"$result","line":343},{"line":343,"containerName":"write_result","kind":13,"name":"@args"},{"line":344,"kind":13,"containerName":"write_result","name":"$self"},{"line":345,"name":"$self","containerName":"write_result","kind":13},{"line":345,"kind":12,"containerName":"write_result","name":"_print"},{"line":345,"name":"$str","kind":13,"containerName":"write_result"},{"name":"$self","containerName":"write_result","kind":13,"line":347},{"kind":12,"containerName":"write_result","name":"flush","line":347},{"name":"$self","containerName":"write_result","kind":13,"line":347},{"line":347,"containerName":"write_result","kind":12,"name":"_flush_on_write"},{"line":347,"containerName":"write_result","kind":13,"name":"$self"},{"kind":12,"containerName":"write_result","name":"_fh","line":347}],"containerName":"main::","name":"write_result","definition":"sub","detail":"($self,$result,@args)"},{"detail":"($self,$result,@args)","definition":"sub","name":"write_report","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"write_report","name":"$self","line":369,"definition":"my"},{"line":369,"kind":13,"containerName":"write_report","name":"$result"},{"containerName":"write_report","kind":13,"name":"@args","line":369},{"name":"$self","containerName":"write_report","kind":13,"line":371},{"line":372,"name":"$self","kind":13,"containerName":"write_report"},{"kind":12,"containerName":"write_report","name":"throw","line":372},{"containerName":"write_report","kind":13,"name":"@args","line":374},{"line":374,"name":"$self","containerName":"write_report","kind":13},{"line":374,"kind":13,"containerName":"write_report","name":"@args"},{"localvar":"my","kind":13,"containerName":"write_report","name":"$str","line":376,"definition":"my"},{"name":"$self","kind":13,"containerName":"write_report","line":376},{"name":"writer","containerName":"write_report","kind":12,"line":376},{"line":376,"name":"to_string","containerName":"write_report","kind":12},{"name":"$result","containerName":"write_report","kind":13,"line":376},{"line":376,"kind":13,"containerName":"write_report","name":"@args"},{"line":377,"name":"$self","kind":13,"containerName":"write_report"},{"line":378,"name":"$self","kind":13,"containerName":"write_report"},{"line":378,"kind":12,"containerName":"write_report","name":"_print"},{"line":378,"name":"$str","containerName":"write_report","kind":13},{"line":380,"name":"$self","containerName":"write_report","kind":13},{"line":380,"name":"flush","containerName":"write_report","kind":12},{"line":380,"containerName":"write_report","kind":13,"name":"$self"},{"line":380,"name":"_flush_on_write","containerName":"write_report","kind":12},{"containerName":"write_report","kind":13,"name":"$self","line":380},{"kind":12,"containerName":"write_report","name":"_fh","line":380}],"signature":{"parameters":[{"label":"$self"},{"label":"$result"},{"label":"@args"}],"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    # not really necessary unless we put more in RootI\n    #$self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::SearchIO::SearchResultEventBuilder->new(@args));\n    $self->{'_reporttype'} = '';\n    $self->{_notfirsttime} = 0;\n    my ( $writer ) = $self->_rearrange([qw(WRITER)], @args);\n\n    $self->writer( $writer ) if $writer;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = stream->next_result\n Function: Reads the next ResultI object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::Root::RootI POD page).\n Returns : A Bio::Search::Result::ResultI object\n Args    : n/a\n\nSee L<Bio::Root::RootI>\n\n\nsub next_result {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 write_result\n\n Title   : write_result\n Usage   : $stream->write_result($result_result, @other_args)\n Function: Writes data from the $result_result object into the stream.\n         : Delegates to the to_string() method of the associated \n         : WriterI object.\n Returns : 1 for success and 0 for error\n Args    : Bio::Search:Result::ResultI object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_result {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n=head2 write_report\n\n Title   : write_report\n Usage   : $stream->write_report(SearchIO stream, @other_args)\n Function: Writes data directly from the SearchIO stream object into the\n         : writer.  This is mainly useful if one has multiple ResultI objects\n         : in a SearchIO stream and you don't want to reiterate header/footer\n         : between each call.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO stream object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>","label":"write_report($self,$result,@args)"},"range":{"end":{"line":382,"character":9999},"start":{"line":368,"character":0}},"kind":12,"line":368},{"name":"writer","containerName":"main::","children":[{"definition":"my","line":398,"localvar":"my","containerName":"writer","kind":13,"name":"$self"},{"line":398,"name":"$writer","containerName":"writer","kind":13},{"kind":13,"containerName":"writer","name":"$writer","line":399},{"name":"$writer","containerName":"writer","kind":13,"line":399},{"name":"isa","kind":12,"containerName":"writer","line":399},{"line":400,"containerName":"writer","kind":13,"name":"$self"},{"name":"$writer","kind":13,"containerName":"writer","line":400},{"line":402,"name":"$writer","containerName":"writer","kind":13},{"name":"$self","containerName":"writer","kind":13,"line":403},{"line":403,"name":"throw","kind":12,"containerName":"writer"},{"containerName":"writer","kind":13,"name":"$self","line":405}],"detail":"($self,$writer)","definition":"sub","range":{"start":{"line":397,"character":0},"end":{"line":406,"character":9999}},"kind":12,"line":397,"signature":{"parameters":[{"label":"$self"},{"label":"$writer"}],"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    # not really necessary unless we put more in RootI\n    #$self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::SearchIO::SearchResultEventBuilder->new(@args));\n    $self->{'_reporttype'} = '';\n    $self->{_notfirsttime} = 0;\n    my ( $writer ) = $self->_rearrange([qw(WRITER)], @args);\n\n    $self->writer( $writer ) if $writer;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = stream->next_result\n Function: Reads the next ResultI object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::Root::RootI POD page).\n Returns : A Bio::Search::Result::ResultI object\n Args    : n/a\n\nSee L<Bio::Root::RootI>\n\n\nsub next_result {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 write_result\n\n Title   : write_result\n Usage   : $stream->write_result($result_result, @other_args)\n Function: Writes data from the $result_result object into the stream.\n         : Delegates to the to_string() method of the associated \n         : WriterI object.\n Returns : 1 for success and 0 for error\n Args    : Bio::Search:Result::ResultI object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_result {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n=head2 write_report\n\n Title   : write_report\n Usage   : $stream->write_report(SearchIO stream, @other_args)\n Function: Writes data directly from the SearchIO stream object into the\n         : writer.  This is mainly useful if one has multiple ResultI objects\n         : in a SearchIO stream and you don't want to reiterate header/footer\n         : between each call.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO stream object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_report {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n\n=head2 writer\n\n Title   : writer\n Usage   : $writer = $stream->writer;\n Function: Sets/Gets a SearchWriterI object to be used for this searchIO.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO::SearchWriterI object (when setting)\n Throws  : Bio::Root::Exception if a non-Bio::SearchIO::SearchWriterI object\n           is passed in.","label":"writer($self,$writer)"}},{"range":{"end":{"character":9999,"line":425},"start":{"line":422,"character":0}},"kind":12,"line":422,"containerName":"main::","name":"result_count","children":[{"line":423,"name":"$self","localvar":"my","kind":13,"containerName":"result_count","definition":"my"},{"name":"$self","kind":13,"containerName":"result_count","line":424},{"line":424,"name":"throw_not_implemented","kind":12,"containerName":"result_count"}],"definition":"sub"},{"signature":{"label":"_load_format_module($self,$format)","parameters":[{"label":"$self"},{"label":"$format"}],"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    # not really necessary unless we put more in RootI\n    #$self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::SearchIO::SearchResultEventBuilder->new(@args));\n    $self->{'_reporttype'} = '';\n    $self->{_notfirsttime} = 0;\n    my ( $writer ) = $self->_rearrange([qw(WRITER)], @args);\n\n    $self->writer( $writer ) if $writer;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = stream->next_result\n Function: Reads the next ResultI object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::Root::RootI POD page).\n Returns : A Bio::Search::Result::ResultI object\n Args    : n/a\n\nSee L<Bio::Root::RootI>\n\n\nsub next_result {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 write_result\n\n Title   : write_result\n Usage   : $stream->write_result($result_result, @other_args)\n Function: Writes data from the $result_result object into the stream.\n         : Delegates to the to_string() method of the associated \n         : WriterI object.\n Returns : 1 for success and 0 for error\n Args    : Bio::Search:Result::ResultI object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_result {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n=head2 write_report\n\n Title   : write_report\n Usage   : $stream->write_report(SearchIO stream, @other_args)\n Function: Writes data directly from the SearchIO stream object into the\n         : writer.  This is mainly useful if one has multiple ResultI objects\n         : in a SearchIO stream and you don't want to reiterate header/footer\n         : between each call.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO stream object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_report {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n\n=head2 writer\n\n Title   : writer\n Usage   : $writer = $stream->writer;\n Function: Sets/Gets a SearchWriterI object to be used for this searchIO.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO::SearchWriterI object (when setting)\n Throws  : Bio::Root::Exception if a non-Bio::SearchIO::SearchWriterI object\n           is passed in.\n\n\nsub writer {\n    my ($self, $writer) = @_;\n    if( ref($writer) and $writer->isa( 'Bio::SearchIO::SearchWriterI' )) {\n        $self->{'_result_writer'} = $writer;\n    }\n    elsif( defined $writer ) {\n        $self->throw(\"Can't set ResultWriter. Not a Bio::SearchIO::SearchWriterI: $writer\");\n    }\n    return $self->{'_result_writer'};\n}\n\n\n=head2 result_count\n\n Title   : result_count\n Usage   : $num = $stream->result_count;\n Function: Gets the number of Blast results that have been successfully parsed\n           at the point of the method call.  This is not the total # of results\n           in the file.\n Returns : integer\n Args    : none\n Throws  : none\n\n\nsub result_count {\n    my $self = shift;\n    $self->throw_not_implemented;\n}\n\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL SearchIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example : \n Returns : \n Args    : "},"line":439,"kind":12,"range":{"start":{"character":0,"line":439},"end":{"line":457,"character":9999}},"definition":"sub","detail":"($self,$format)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_load_format_module","line":440,"definition":"my"},{"line":440,"kind":13,"containerName":"_load_format_module","name":"$format"},{"definition":"my","line":441,"name":"$module","localvar":"my","containerName":"_load_format_module","kind":13},{"name":"$format","containerName":"_load_format_module","kind":13,"line":441},{"definition":"my","line":442,"name":"$ok","containerName":"_load_format_module","localvar":"my","kind":13},{"line":445,"name":"$ok","kind":13,"containerName":"_load_format_module"},{"name":"$self","containerName":"_load_format_module","kind":13,"line":445},{"line":445,"name":"_load_module","kind":12,"containerName":"_load_format_module"},{"line":445,"name":"$module","kind":13,"containerName":"_load_format_module"},{"line":456,"name":"$ok","containerName":"_load_format_module","kind":13}],"name":"_load_format_module","containerName":"main::"},{"kind":12,"range":{"end":{"character":9999,"line":505},"start":{"character":0,"line":471}},"line":471,"signature":{"label":"_get_seq_identifiers($self,$id)","parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"__END__\n# $Id: SearchIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO - Driver for parsing Sequence Database Searches \n(BLAST, FASTA, ...)\n\n=head1 SYNOPSIS\n\n   use Bio::SearchIO;\n   # format can be 'fasta', 'blast', 'exonerate', ...\n   my $searchio = Bio::SearchIO->new( -format => 'blastxml',\n                                     -file   => 'blastout.xml' );\n   while ( my $result = $searchio->next_result() ) {\n       while( my $hit = $result->next_hit ) {\n        # process the Bio::Search::Hit::HitI object\n           while( my $hsp = $hit->next_hsp ) { \n            # process the Bio::Search::HSP::HSPI object\n           }\n       }\n   }\n\n\n=head1 DESCRIPTION\n\nThis is a driver for instantiating a parser for report files from\nsequence database searches. This object serves as a wrapper for the\nformat parsers in Bio::SearchIO::* - you should not need to ever\nuse those format parsers directly. (For people used to the SeqIO\nsystem it, we are deliberately using the same pattern).\n\nOnce you get a SearchIO object, calling next_result() gives you back\na L<Bio::Search::Result::ResultI> compliant object, which is an object that\nrepresents one Blast/Fasta/HMMER whatever report.\n\nA list of module names and formats is below:\n\n  blast      BLAST (WUBLAST, NCBIBLAST,bl2seq)   \n  fasta      FASTA -m9 and -m0\n  blasttable BLAST -m9 or -m8 output (both NCBI and WUBLAST tabular)\n  megablast  MEGABLAST\n  psl        UCSC PSL format\n  waba       WABA output\n  axt        AXT format\n  sim4       Sim4\n  hmmer      HMMER hmmpfam and hmmsearch\n  exonerate  Exonerate CIGAR and VULGAR format\n  blastxml   NCBI BLAST XML\n  wise       Genewise -genesf format\n\nAlso see the SearchIO HOWTO:\nhttp://bioperl.open-bio.org/wiki/HOWTO:SearchIO\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich & Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::IO\n\nuse Bio::SearchIO::SearchResultEventBuilder;\n\n# Special exception class for exceptions during parsing.\n# End users should not ever see these.\n# For an example of usage, see blast.pm.\n@Bio::SearchIO::InternalParserError::ISA = qw(Bio::Root::Exception);\n\nuse Symbol;\n\nuse base qw(Bio::Root::IO Bio::Event::EventGeneratorI Bio::AnalysisParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO object \n Returns : Bio::SearchIO initialized with the correct format\n Args    : -file           => $filename\n           -format         => format\n           -fh             => filehandle to attach to\n           -result_factory => Object implementing Bio::Factory::ObjectFactoryI\n           -hit_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -hsp_factory    => Object implementing Bio::Factory::ObjectFactoryI\n           -writer         => Object implementing Bio::SearchIO::SearchWriterI\n           -output_format  => output format, which will dynamically load writer\n\nSee L<Bio::Factory::ObjectFactoryI>, L<Bio::SearchIO::SearchWriterI>\n\nAny factory objects in the arguments are passed along to the\nSearchResultEventBuilder object which holds these factories and sets\ndefault ones if none are supplied as arguments.\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::SearchIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);        \n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'blast';\n\n    my $output_format = $param{'-output_format'};\n    my $writer = undef;\n\n    if( defined $output_format ) {\n        if( defined $param{'-writer'} ) {\n            my $dummy = Bio::Root::Root->new();\n            $dummy->throw(\"Both writer and output format specified - not good\");\n        }\n\n        if( $output_format =~ /^blast$/i ) {\n            $output_format = 'TextResultWriter';\n        }\n        my $output_module = \"Bio::SearchIO::Writer::\".$output_format;\n        $class->_load_module($output_module);\n        $writer = $output_module->new(@args);\n        push(@args,\"-writer\",$writer);\n    }\n\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::SearchIO::${format}\"->new(@args);\n  }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SearchIO->newFh(-file=>$filename,\n                                      -format=>'Format')\n           $result = <$fh>;   # read a ResultI object\n           print $fh $result; # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $result = <$fh>;     # read a ResultI object\n           print $fh $result;   # write a ResultI object\n Returns : filehandle tied to the Bio::SearchIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::SearchIO::EventHandlerI\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::SearchIO::EventHandlerI') ) {\n        $self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::SearchIO::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::SearchIO::EventHandlerI\n Args    : none\n\nSee L<Bio::SearchIO::EventHandlerI>\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    # not really necessary unless we put more in RootI\n    #$self->SUPER::_initialize(@args);\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::SearchIO::SearchResultEventBuilder->new(@args));\n    $self->{'_reporttype'} = '';\n    $self->{_notfirsttime} = 0;\n    my ( $writer ) = $self->_rearrange([qw(WRITER)], @args);\n\n    $self->writer( $writer ) if $writer;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = stream->next_result\n Function: Reads the next ResultI object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::Root::RootI POD page).\n Returns : A Bio::Search::Result::ResultI object\n Args    : n/a\n\nSee L<Bio::Root::RootI>\n\n\nsub next_result {\n   my ($self) = @_;\n   $self->throw_not_implemented;\n}\n\n=head2 write_result\n\n Title   : write_result\n Usage   : $stream->write_result($result_result, @other_args)\n Function: Writes data from the $result_result object into the stream.\n         : Delegates to the to_string() method of the associated \n         : WriterI object.\n Returns : 1 for success and 0 for error\n Args    : Bio::Search:Result::ResultI object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_result {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n=head2 write_report\n\n Title   : write_report\n Usage   : $stream->write_report(SearchIO stream, @other_args)\n Function: Writes data directly from the SearchIO stream object into the\n         : writer.  This is mainly useful if one has multiple ResultI objects\n         : in a SearchIO stream and you don't want to reiterate header/footer\n         : between each call.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO stream object,\n         : plus any other arguments for the Writer\n Throws  : Bio::Root::Exception if a Writer has not been set.\n\nSee L<Bio::Root::Exception>\n\n\nsub write_report {\n   my ($self, $result, @args) = @_;\n\n   if( not ref($self->{'_result_writer'}) ) {\n       $self->throw(\"ResultWriter not defined.\");\n   }\n   @args = $self->{'_notfirsttime'} unless( @args );\n\n   my $str = $self->writer->to_string( $result, @args);\n   $self->{'_notfirsttime'} = 1;\n   $self->_print( \"$str\" ) if defined $str;\n   \n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n\n=head2 writer\n\n Title   : writer\n Usage   : $writer = $stream->writer;\n Function: Sets/Gets a SearchWriterI object to be used for this searchIO.\n Returns : 1 for success and 0 for error\n Args    : Bio::SearchIO::SearchWriterI object (when setting)\n Throws  : Bio::Root::Exception if a non-Bio::SearchIO::SearchWriterI object\n           is passed in.\n\n\nsub writer {\n    my ($self, $writer) = @_;\n    if( ref($writer) and $writer->isa( 'Bio::SearchIO::SearchWriterI' )) {\n        $self->{'_result_writer'} = $writer;\n    }\n    elsif( defined $writer ) {\n        $self->throw(\"Can't set ResultWriter. Not a Bio::SearchIO::SearchWriterI: $writer\");\n    }\n    return $self->{'_result_writer'};\n}\n\n\n=head2 result_count\n\n Title   : result_count\n Usage   : $num = $stream->result_count;\n Function: Gets the number of Blast results that have been successfully parsed\n           at the point of the method call.  This is not the total # of results\n           in the file.\n Returns : integer\n Args    : none\n Throws  : none\n\n\nsub result_count {\n    my $self = shift;\n    $self->throw_not_implemented;\n}\n\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL SearchIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example : \n Returns : \n Args    : \n\n\nsub _load_format_module {\n  my ($self,$format) = @_;\n  my $module = \"Bio::SearchIO::\" . $format;\n  my $ok;\n  \n  eval {\n      $ok = $self->_load_module($module);\n  };\n  if ( $@ ) {\n      print STDERR <<END;\n$self: $format cannot be found\nException $@\nFor more information about the SearchIO system please see the SearchIO docs.\nThis includes ways of checking for formats at compile time, not run time\nEND\n  ;\n  }\n  return $ok;\n}\n\n=head2 _get_seq_identifiers\n\n Title   : _get_seq_identifiers\n Usage   : my ($gi, $acc,$ver) = &_get_seq_identifiers($id)\n Function: Private function to get the gi, accession, version data\n           for an ID (if it is in NCBI format)\n Returns : 3-pule of gi, accession, version\n Args    : ID string to process (NCBI format)"},"containerName":"main::","name":"_get_seq_identifiers","children":[{"line":472,"name":"$self","localvar":"my","containerName":"_get_seq_identifiers","kind":13,"definition":"my"},{"containerName":"_get_seq_identifiers","kind":13,"name":"$id","line":472},{"line":474,"name":"$id","containerName":"_get_seq_identifiers","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"_get_seq_identifiers","name":"$gi","line":475},{"line":475,"containerName":"_get_seq_identifiers","kind":13,"name":"$acc"},{"line":475,"name":"$version","containerName":"_get_seq_identifiers","kind":13},{"name":"$id","kind":13,"containerName":"_get_seq_identifiers","line":476},{"line":477,"kind":13,"containerName":"_get_seq_identifiers","name":"$gi"},{"line":479,"kind":13,"containerName":"_get_seq_identifiers","name":"$id"},{"line":480,"name":"$acc","kind":13,"containerName":"_get_seq_identifiers"},{"kind":13,"containerName":"_get_seq_identifiers","name":"$version","line":480},{"line":482,"name":"$id","containerName":"_get_seq_identifiers","kind":13},{"line":483,"name":"$acc","kind":13,"containerName":"_get_seq_identifiers"},{"containerName":"_get_seq_identifiers","kind":13,"name":"$version","line":483},{"containerName":"_get_seq_identifiers","kind":13,"name":"$acc","line":502},{"containerName":"_get_seq_identifiers","kind":13,"name":"$id","line":502},{"kind":13,"containerName":"_get_seq_identifiers","name":"$gi","line":504},{"kind":13,"containerName":"_get_seq_identifiers","name":"$acc","line":504},{"line":504,"kind":13,"containerName":"_get_seq_identifiers","name":"$version"}],"detail":"($self,$id)","definition":"sub"},{"definition":"sub","name":"_guess_format","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_guess_format","name":"$class","line":519}],"range":{"start":{"line":518,"character":0},"end":{"character":9999,"line":530}},"kind":12,"line":518},{"definition":"sub","name":"close","containerName":"main::","children":[{"definition":"my","line":533,"localvar":"my","containerName":"close","kind":13,"name":"$self"},{"line":535,"name":"$self","kind":13,"containerName":"close"},{"line":535,"containerName":"close","kind":12,"name":"writer"},{"name":"$self","containerName":"close","kind":13,"line":536},{"containerName":"close","kind":12,"name":"_print","line":536},{"name":"$self","containerName":"close","kind":13,"line":536},{"line":536,"containerName":"close","kind":12,"name":"writer"},{"line":536,"kind":12,"containerName":"close","name":"end_report"},{"line":537,"name":"$self","containerName":"close","kind":13},{"containerName":"close","kind":13,"name":"$self","line":539}],"kind":12,"range":{"end":{"line":540,"character":9999},"start":{"character":0,"line":532}},"line":532},{"name":"SUPER","containerName":"close","kind":12,"line":539},{"line":542,"kind":12,"range":{"start":{"character":0,"line":542},"end":{"character":9999,"line":546}},"definition":"sub","children":[{"line":543,"localvar":"my","kind":13,"containerName":"DESTROY","name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"DESTROY","line":544},{"line":544,"containerName":"DESTROY","kind":12,"name":"close"},{"name":"$self","kind":13,"containerName":"DESTROY","line":544},{"line":544,"containerName":"DESTROY","kind":12,"name":"_fh"},{"kind":13,"containerName":"DESTROY","name":"$self","line":545}],"containerName":"main::","name":"DESTROY"},{"definition":"sub","name":"TIEHANDLE","containerName":"main::","children":[{"line":549,"localvar":"my","containerName":"TIEHANDLE","kind":13,"name":"$class","definition":"my"},{"name":"$class","containerName":"TIEHANDLE","kind":13,"line":550}],"kind":12,"range":{"start":{"character":0,"line":548},"end":{"line":551,"character":9999}},"line":548},{"line":549,"name":"SUPER","kind":12,"containerName":"DESTROY"},{"line":550,"name":"processor","kind":12},{"definition":"sub","children":[{"line":554,"localvar":"my","kind":13,"containerName":"READLINE","name":"$self","definition":"my"},{"line":555,"containerName":"READLINE","kind":13,"name":"$self"},{"name":"next_result","containerName":"READLINE","kind":12,"line":555},{"line":556,"containerName":"READLINE","localvar":"my","kind":13,"name":"@list","definition":"my"},{"containerName":"READLINE","kind":13,"name":"$obj","line":556},{"line":557,"kind":13,"containerName":"READLINE","name":"@list"},{"kind":13,"containerName":"READLINE","name":"$obj","line":557},{"line":557,"kind":13,"containerName":"READLINE","name":"$obj"},{"line":557,"kind":13,"containerName":"READLINE","name":"$self"},{"line":557,"name":"next_result","kind":12,"containerName":"READLINE"},{"line":558,"name":"@list","kind":13,"containerName":"READLINE"}],"containerName":"main::","name":"READLINE","line":553,"range":{"start":{"character":0,"line":553},"end":{"character":9999,"line":559}},"kind":12},{"children":[{"name":"$self","containerName":"PRINT","localvar":"my","kind":13,"line":562,"definition":"my"},{"line":563,"kind":13,"containerName":"PRINT","name":"$self"},{"line":563,"name":"write_result","containerName":"PRINT","kind":12}],"containerName":"main::","name":"PRINT","definition":"sub","line":561,"range":{"end":{"character":9999,"line":564},"start":{"character":0,"line":561}},"kind":12}],"version":5}