{"vars":[{"definition":"our","line":7,"kind":13,"containerName":"main::","name":"@ISA"},{"line":7,"kind":2,"containerName":"","name":"Exporter"},{"line":8,"containerName":"main::","kind":13,"name":"@EXPORT","definition":"our"},{"line":52,"kind":12,"range":{"end":{"character":9999,"line":54},"start":{"line":52,"character":0}},"definition":"sub","children":[{"definition":"my","localvar":"my","containerName":"interval_tiling","kind":13,"name":"$n","line":54}],"name":"interval_tiling","containerName":"main::"},{"line":55,"localvar":"my","containerName":null,"kind":13,"name":"%input","definition":"my"},{"name":"@input","containerName":null,"kind":13,"line":56},{"line":56,"name":"@n","kind":13,"containerName":null},{"containerName":null,"localvar":"my","kind":13,"name":"@active","line":57,"definition":"my"},{"line":57,"name":"$n","kind":13,"containerName":null},{"line":58,"name":"@hold","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":59,"name":"@tiled_ints","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":60,"name":"@ret","localvar":"my","containerName":null,"kind":13},{"line":61,"name":"@active","kind":13,"containerName":null},{"line":62,"name":"$tgt","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"%input","containerName":null,"kind":13,"line":62},{"kind":13,"localvar":"my","containerName":null,"name":"$tgt_i","line":62,"definition":"my"},{"line":62,"containerName":null,"kind":13,"name":"@active"},{"line":63,"kind":13,"containerName":null,"name":"@tiled_ints"},{"line":63,"kind":13,"containerName":null,"name":"$tgt_i"},{"name":"$tgt_not_disjoint","localvar":"my","containerName":null,"kind":13,"line":64,"definition":"my"},{"name":"%tgt_not_disjoint","containerName":null,"kind":13,"line":65},{"line":66,"containerName":null,"kind":13,"name":"$tgt_not_disjoint"},{"definition":"my","line":67,"kind":13,"localvar":"my","containerName":null,"name":"$try_i"},{"name":"@active","containerName":null,"kind":13,"line":67},{"line":68,"name":"$try","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":null,"name":"%input","line":68},{"line":68,"name":"$try_i","containerName":null,"kind":13},{"line":69,"kind":12,"name":"are_disjoint"},{"line":69,"name":"$tgt","kind":13,"containerName":null},{"line":69,"kind":13,"containerName":null,"name":"%try"},{"kind":13,"containerName":null,"name":"$tgt","line":70},{"kind":12,"name":"min_covering_interval","line":70},{"kind":13,"containerName":null,"name":"$tgt","line":70},{"line":70,"name":"$try","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@tiled_ints","line":71},{"line":71,"name":"$try_i","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%tgt_not_disjoint","line":72},{"containerName":null,"kind":13,"name":"@hold","line":75},{"line":75,"containerName":null,"kind":13,"name":"$try_i"},{"name":"%tgt_not_disjoint","kind":13,"containerName":null,"line":78},{"kind":13,"containerName":null,"name":"@ret","line":79},{"line":79,"name":"@tgt","containerName":null,"kind":13},{"line":79,"name":"@tiled_ints","kind":13,"containerName":null},{"line":80,"name":"@tiled_ints","containerName":null,"kind":13},{"name":"@active","containerName":null,"kind":13,"line":82},{"line":82,"containerName":null,"kind":13,"name":"@hold"},{"line":83,"kind":13,"containerName":null,"name":"@hold"},{"containerName":null,"kind":13,"name":"@ret","line":86},{"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"decompose_interval","name":"@ints","line":114}],"containerName":"main::","name":"decompose_interval","line":112,"range":{"end":{"character":9999,"line":114},"start":{"line":112,"character":0}},"kind":12},{"definition":"my","line":115,"name":"%flat","localvar":"my","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@flat","line":115},{"name":"@ints","kind":13,"containerName":null,"line":122},{"line":123,"name":"%flat","containerName":null,"kind":13},{"line":124,"containerName":null,"kind":13,"name":"%flat"},{"line":125,"name":"%flat","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%flat","line":126},{"name":"@a","localvar":"my","kind":13,"containerName":null,"line":129,"definition":"my"},{"line":130,"kind":13,"containerName":null,"name":"@a"},{"line":130,"name":"$a","kind":13,"containerName":null},{"name":"$b","kind":13,"containerName":null,"line":130},{"kind":13,"containerName":null,"name":"%flat","line":130},{"containerName":null,"kind":13,"name":"@a","line":132},{"line":132,"kind":13,"containerName":null,"name":"@a"},{"line":134,"name":"@flat","containerName":null,"kind":13},{"line":134,"containerName":null,"kind":13,"name":"@a"},{"line":134,"kind":13,"containerName":null,"name":"@a"},{"line":135,"name":"@flat","containerName":null,"kind":13},{"name":"@flat","kind":13,"containerName":null,"line":135},{"containerName":null,"kind":13,"name":"@flat","line":136},{"line":136,"kind":13,"containerName":null,"name":"@flat"},{"name":"@flat","kind":13,"containerName":null,"line":136},{"line":136,"containerName":null,"kind":13,"name":"@flat"},{"definition":"my","line":138,"name":"$a","kind":13,"localvar":"my","containerName":null},{"name":"@a","containerName":null,"kind":13,"line":138},{"name":"$a","containerName":null,"kind":13,"line":139},{"line":139,"name":"@flat","containerName":null,"kind":13},{"line":140,"name":"@flat","kind":13,"containerName":null},{"line":140,"containerName":null,"kind":13,"name":"@flat"},{"line":142,"name":"@flat","kind":13,"containerName":null},{"name":"$a","kind":13,"containerName":null,"line":142},{"line":144,"containerName":null,"kind":13,"name":"@flat"},{"containerName":null,"kind":13,"name":"@flat","line":144},{"name":"@flat","kind":13,"containerName":null,"line":144},{"line":145,"containerName":null,"kind":13,"name":"@flat"},{"line":145,"containerName":null,"kind":13,"name":"@flat"},{"definition":"my","line":148,"name":"@decomp","containerName":null,"localvar":"my","kind":13},{"definition":"my","name":"$a","kind":13,"localvar":"my","containerName":null,"line":149},{"line":149,"name":"@flat","kind":13,"containerName":null},{"line":150,"kind":13,"containerName":null,"name":"@decomp"},{"line":150,"name":"$a","containerName":null,"kind":13},{"line":150,"kind":13,"containerName":null,"name":"@flat"},{"definition":"my","name":"@coverage","localvar":"my","containerName":null,"kind":13,"line":155},{"definition":"my","name":"$i","kind":13,"localvar":"my","containerName":null,"line":156},{"line":156,"kind":12,"name":"decomp"},{"line":157,"name":"$j","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":157,"name":"ints","kind":12},{"line":158,"name":"are_disjoint","kind":12},{"name":"@decomp","kind":13,"containerName":null,"line":158},{"line":158,"kind":13,"containerName":null,"name":"$i"},{"line":158,"kind":13,"containerName":null,"name":"@ints"},{"name":"%j","containerName":null,"kind":13,"line":158},{"name":"@coverage","kind":13,"containerName":null,"line":159},{"line":159,"containerName":null,"kind":13,"name":"%i"},{"line":160,"name":"@coverage","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$i","line":160},{"name":"%j","containerName":null,"kind":13,"line":160},{"line":163,"kind":13,"containerName":null,"name":"@coverage"},{"kind":13,"containerName":null,"name":"@i","line":163},{"line":163,"name":"%j","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@decomp","line":168},{"name":"@coverage","containerName":null,"kind":13,"line":168},{"kind":12,"name":"decomp","line":168},{"containerName":"main::","name":"are_disjoint","children":[{"definition":"my","name":"$int1","localvar":"my","containerName":"are_disjoint","kind":13,"line":182},{"name":"$int2","containerName":"are_disjoint","kind":13,"line":182}],"detail":"($int1,$int2)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":181},"end":{"character":9999,"line":185}},"line":181,"signature":{"documentation":"1;\n#$Id: MapTileUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\npackage Bio::Search::Tiling::MapTileUtils;\nuse strict;\nuse warnings;\nuse Exporter;\n\nBEGIN {\n    our @ISA = qw( Exporter );\n    our @EXPORT = qw( get_intervals_from_hsps \n                      interval_tiling \n                      decompose_interval\n                      _allowable_filters \n                      _set_attributes\n                      _mapping_coeff);\n}\n\n# tiling trials\n# assumed: intervals are [$a0, $a1], with $a0 <= $a1\n=head1 NAME\n\nBio::Search::Tiling::MapTileUtils - utilities for manipulating closed intervals for an HSP tiling algorithm\n\n=head1 SYNOPSIS\n\nNot used directly.\n\n=head1 DESCRIPTION\n\nNot used directly.\n\n=head1 NOTE\n\nAn \"interval\" in this module is defined as an arrayref C<[$a0, $a1]>, where\nC<$a0, $a1> are scalar numbers satisfying C<$a0 E<lt>= $a1>.\n\n=head1 AUTHOR\n\nMark A. Jensen - maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\n=head2 interval_tiling    \n\n Title   : interval_tiling()\n Usage   : @tiling = interval_tiling( \\@array_of_intervals )\n Function: Find minimal set of intervals covering the input set\n Returns : array of arrayrefs of the form\n  ( [$interval => [ @indices_of_collapsed_input_intervals ]], ...)\n Args    : arrayref of intervals\n\n\nsub interval_tiling {\n    return unless $_[0]; # no input\n    my $n = scalar @{$_[0]};\n    my %input;\n    @input{(0..$n-1)} = @{$_[0]};\n    my @active = (0..$n-1);\n    my @hold;\n    my @tiled_ints;\n    my @ret;\n    while (@active) {\n\tmy $tgt = $input{my $tgt_i = shift @active};\n\tpush @tiled_ints, $tgt_i;\n\tmy $tgt_not_disjoint = 1;\n\twhile ($tgt_not_disjoint) {\n\t    $tgt_not_disjoint = 0;\n\t    while (my $try_i = shift @active) {\n\t\tmy $try = $input{$try_i};\n\t\tif ( !are_disjoint($tgt, $try) ) {\n\t\t    $tgt = min_covering_interval($tgt,$try);\n\t\t    push @tiled_ints, $try_i;\n\t\t    $tgt_not_disjoint = 1;\n\t\t}\n\t\telse {\n\t\t    push @hold, $try_i;\n\t\t}\n\t    }\n\t    if (!$tgt_not_disjoint) {\n\t\tpush @ret, [ $tgt => [@tiled_ints] ];\n\t\t@tiled_ints = ();\n\t    }\n\t    @active = @hold;\n\t    @hold = ();\n\t}\n    }\n    return @ret;\n}\n\n=head2 decompose_interval\n\n Title   : decompose_interval\n Usage   : @decomposition = decompose_interval( \\@overlappers )\n Function: Calculate the disjoint decomposition of a set of\n           overlapping intervals, each annotated with a list of\n           covering intervals\n Returns : array of arrayrefs of the form\n           ( [[@interval] => [@indices_of_coverers]], ... )\n Args    : arrayref of intervals (arrayrefs like [$a0, $a1], with\n Note    : Each returned interval is associated with a list of indices of the\n           original intervals that cover that decomposition component\n           (scalar size of this list could be called the 'coverage coefficient')\n Note    : Coverage: each component of the decomp is completely contained\n           in the input intervals that overlap it, by construction.\n Caveat  : This routine expects the members of @overlappers to overlap,\n           but doesn't check this.\n\n\n### what if the input intervals don't overlap?? They MUST overlap; that's\n### what interval_tiling() is for.\n\nsub decompose_interval {\n    return unless $_[0]; # no input\n    my @ints = @{$_[0]};\n    my (%flat,@flat);\n    ### this is ok, but need to handle the case where a lh and rh endpoint\n    ### coincide...\n    # decomposition --\n    # flatten:\n    # every lh endpoint generates (lh-1, lh)\n    # every rh endpoint generates (rh, rh+)\n    foreach (@ints) {\n\t$flat{$$_[0]-1}++;\n\t$flat{$$_[0]}++;\n\t$flat{$$_[1]}++;\n\t$flat{$$_[1]+1}++;\n    }\n    # sort, create singletons if nec.\n    my @a;\n    @a = sort {$a<=>$b} keys %flat;\n    # throw out first and last (meeting a boundary condition)\n    shift @a; pop @a;\n    # look for singletons\n    @flat = (shift @a, shift @a);\n    if ( $flat[1]-$flat[0] == 1 ) {\n\t@flat = ($flat[0],$flat[0], $flat[1]);\n    }\n    while (my $a = shift @a) {\n\tif ($a-$flat[-2]==2) {\n\t    push @flat, $flat[-1]; # create singleton interval\n\t}\n\tpush @flat, $a;\n    }\n    if ($flat[-1]-$flat[-2]==1 and @flat % 2) {\n\tpush @flat, $flat[-1];\n    }\n    # component intervals are consecutive pairs\n    my @decomp;\n    while (my $a = shift @flat) {\n\tpush @decomp, [$a, shift @flat];\n    }\n\n    # for each component, return a list of the indices of the input intervals\n    # that cover the component.\n    my @coverage;\n    foreach my $i (0..$#decomp) {\n\tforeach my $j (0..$#ints) {\n\t    unless (are_disjoint($decomp[$i], $ints[$j])) {\n\t\tif (defined $coverage[$i]) {\n\t\t    push @{$coverage[$i]}, $j;\n\t\t}\n\t\telse {\n\t\t    $coverage[$i] = [$j];\n\t\t}\n\t    }\n\t}\n    }\n    return map { [$decomp[$_] => $coverage[$_]] } (0..$#decomp);\n}    \n\n=head2 are_disjoint\n\n Title   : are_disjoint\n Usage   : are_disjoint( [$a0, $a1], [$b0, $b1] )\n Function: Determine if two intervals are disjoint\n Returns : True if the intervals are disjoint, false if they overlap\n Args    : array of two intervals","parameters":[{"label":"$int1"},{"label":"$int2"}],"label":"are_disjoint($int1,$int2)"}},{"name":"int1","kind":12,"line":183},{"line":183,"name":"int2","kind":12},{"line":183,"kind":12,"name":"int2"},{"line":183,"kind":12,"name":"int1"},{"containerName":"main::","name":"min_covering_interval","children":[{"definition":"my","line":198,"containerName":"min_covering_interval","localvar":"my","kind":13,"name":"$int1"},{"containerName":"min_covering_interval","kind":13,"name":"$int2","line":198},{"line":199,"name":"@a","containerName":"min_covering_interval","localvar":"my","kind":13,"definition":"my"},{"name":"$a","kind":13,"containerName":"min_covering_interval","line":199},{"name":"$b","containerName":"min_covering_interval","kind":13,"line":199},{"line":199,"name":"$int1","kind":13,"containerName":"min_covering_interval"},{"line":199,"kind":13,"containerName":"min_covering_interval","name":"$int2"},{"line":200,"containerName":"min_covering_interval","kind":13,"name":"$a"},{"containerName":"min_covering_interval","kind":13,"name":"$a","line":200}],"detail":"($int1,$int2)","definition":"sub","kind":12,"range":{"end":{"line":201,"character":9999},"start":{"character":0,"line":197}},"line":197,"signature":{"documentation":"1;\n#$Id: MapTileUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\npackage Bio::Search::Tiling::MapTileUtils;\nuse strict;\nuse warnings;\nuse Exporter;\n\nBEGIN {\n    our @ISA = qw( Exporter );\n    our @EXPORT = qw( get_intervals_from_hsps \n                      interval_tiling \n                      decompose_interval\n                      _allowable_filters \n                      _set_attributes\n                      _mapping_coeff);\n}\n\n# tiling trials\n# assumed: intervals are [$a0, $a1], with $a0 <= $a1\n=head1 NAME\n\nBio::Search::Tiling::MapTileUtils - utilities for manipulating closed intervals for an HSP tiling algorithm\n\n=head1 SYNOPSIS\n\nNot used directly.\n\n=head1 DESCRIPTION\n\nNot used directly.\n\n=head1 NOTE\n\nAn \"interval\" in this module is defined as an arrayref C<[$a0, $a1]>, where\nC<$a0, $a1> are scalar numbers satisfying C<$a0 E<lt>= $a1>.\n\n=head1 AUTHOR\n\nMark A. Jensen - maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\n=head2 interval_tiling    \n\n Title   : interval_tiling()\n Usage   : @tiling = interval_tiling( \\@array_of_intervals )\n Function: Find minimal set of intervals covering the input set\n Returns : array of arrayrefs of the form\n  ( [$interval => [ @indices_of_collapsed_input_intervals ]], ...)\n Args    : arrayref of intervals\n\n\nsub interval_tiling {\n    return unless $_[0]; # no input\n    my $n = scalar @{$_[0]};\n    my %input;\n    @input{(0..$n-1)} = @{$_[0]};\n    my @active = (0..$n-1);\n    my @hold;\n    my @tiled_ints;\n    my @ret;\n    while (@active) {\n\tmy $tgt = $input{my $tgt_i = shift @active};\n\tpush @tiled_ints, $tgt_i;\n\tmy $tgt_not_disjoint = 1;\n\twhile ($tgt_not_disjoint) {\n\t    $tgt_not_disjoint = 0;\n\t    while (my $try_i = shift @active) {\n\t\tmy $try = $input{$try_i};\n\t\tif ( !are_disjoint($tgt, $try) ) {\n\t\t    $tgt = min_covering_interval($tgt,$try);\n\t\t    push @tiled_ints, $try_i;\n\t\t    $tgt_not_disjoint = 1;\n\t\t}\n\t\telse {\n\t\t    push @hold, $try_i;\n\t\t}\n\t    }\n\t    if (!$tgt_not_disjoint) {\n\t\tpush @ret, [ $tgt => [@tiled_ints] ];\n\t\t@tiled_ints = ();\n\t    }\n\t    @active = @hold;\n\t    @hold = ();\n\t}\n    }\n    return @ret;\n}\n\n=head2 decompose_interval\n\n Title   : decompose_interval\n Usage   : @decomposition = decompose_interval( \\@overlappers )\n Function: Calculate the disjoint decomposition of a set of\n           overlapping intervals, each annotated with a list of\n           covering intervals\n Returns : array of arrayrefs of the form\n           ( [[@interval] => [@indices_of_coverers]], ... )\n Args    : arrayref of intervals (arrayrefs like [$a0, $a1], with\n Note    : Each returned interval is associated with a list of indices of the\n           original intervals that cover that decomposition component\n           (scalar size of this list could be called the 'coverage coefficient')\n Note    : Coverage: each component of the decomp is completely contained\n           in the input intervals that overlap it, by construction.\n Caveat  : This routine expects the members of @overlappers to overlap,\n           but doesn't check this.\n\n\n### what if the input intervals don't overlap?? They MUST overlap; that's\n### what interval_tiling() is for.\n\nsub decompose_interval {\n    return unless $_[0]; # no input\n    my @ints = @{$_[0]};\n    my (%flat,@flat);\n    ### this is ok, but need to handle the case where a lh and rh endpoint\n    ### coincide...\n    # decomposition --\n    # flatten:\n    # every lh endpoint generates (lh-1, lh)\n    # every rh endpoint generates (rh, rh+)\n    foreach (@ints) {\n\t$flat{$$_[0]-1}++;\n\t$flat{$$_[0]}++;\n\t$flat{$$_[1]}++;\n\t$flat{$$_[1]+1}++;\n    }\n    # sort, create singletons if nec.\n    my @a;\n    @a = sort {$a<=>$b} keys %flat;\n    # throw out first and last (meeting a boundary condition)\n    shift @a; pop @a;\n    # look for singletons\n    @flat = (shift @a, shift @a);\n    if ( $flat[1]-$flat[0] == 1 ) {\n\t@flat = ($flat[0],$flat[0], $flat[1]);\n    }\n    while (my $a = shift @a) {\n\tif ($a-$flat[-2]==2) {\n\t    push @flat, $flat[-1]; # create singleton interval\n\t}\n\tpush @flat, $a;\n    }\n    if ($flat[-1]-$flat[-2]==1 and @flat % 2) {\n\tpush @flat, $flat[-1];\n    }\n    # component intervals are consecutive pairs\n    my @decomp;\n    while (my $a = shift @flat) {\n\tpush @decomp, [$a, shift @flat];\n    }\n\n    # for each component, return a list of the indices of the input intervals\n    # that cover the component.\n    my @coverage;\n    foreach my $i (0..$#decomp) {\n\tforeach my $j (0..$#ints) {\n\t    unless (are_disjoint($decomp[$i], $ints[$j])) {\n\t\tif (defined $coverage[$i]) {\n\t\t    push @{$coverage[$i]}, $j;\n\t\t}\n\t\telse {\n\t\t    $coverage[$i] = [$j];\n\t\t}\n\t    }\n\t}\n    }\n    return map { [$decomp[$_] => $coverage[$_]] } (0..$#decomp);\n}    \n\n=head2 are_disjoint\n\n Title   : are_disjoint\n Usage   : are_disjoint( [$a0, $a1], [$b0, $b1] )\n Function: Determine if two intervals are disjoint\n Returns : True if the intervals are disjoint, false if they overlap\n Args    : array of two intervals\n\n\nsub are_disjoint {\n    my ($int1, $int2) = @_;\n    return 1 if ( $$int1[1] < $$int2[0] ) || ( $$int2[1] < $$int1[0]);\n    return 0;\n}\n\n=head2 min_covering_interval\n\n Title   : min_covering_interval \n Usage   : $interval = min_covering_interval( [$a0,$a1],[$b0,$b1] )\n Function: Determine the minimal covering interval for two intervals\n Returns : an interval\n Args    : two intervals","parameters":[{"label":"$int1"},{"label":"$int2"}],"label":"min_covering_interval($int1,$int2)"}},{"definition":"sub","children":[{"line":216,"containerName":"get_intervals_from_hsps","localvar":"my","kind":13,"name":"$type","definition":"my"},{"name":"@hsps","localvar":"my","kind":13,"containerName":"get_intervals_from_hsps","line":217,"definition":"my"},{"line":218,"containerName":"get_intervals_from_hsps","kind":13,"name":"$type"},{"line":219,"kind":13,"containerName":"get_intervals_from_hsps","name":"@hsps"},{"name":"$type","containerName":"get_intervals_from_hsps","kind":13,"line":219},{"containerName":"get_intervals_from_hsps","kind":13,"name":"$type","line":220},{"kind":13,"containerName":"get_intervals_from_hsps","name":"$type","line":225},{"line":225,"containerName":"get_intervals_from_hsps","kind":13,"name":"$type"},{"kind":13,"containerName":"get_intervals_from_hsps","name":"@hsps","line":226},{"definition":"my","line":227,"localvar":"my","kind":13,"containerName":"get_intervals_from_hsps","name":"@ret"},{"containerName":"get_intervals_from_hsps","kind":13,"name":"@hsps","line":228},{"line":230,"containerName":"get_intervals_from_hsps","kind":13,"name":"@ret"},{"line":230,"name":"range","containerName":"get_intervals_from_hsps","kind":12},{"name":"$type","containerName":"get_intervals_from_hsps","kind":13,"line":230},{"line":232,"name":"@ret","kind":13,"containerName":"get_intervals_from_hsps"}],"containerName":"main::","name":"get_intervals_from_hsps","line":215,"range":{"end":{"character":9999,"line":233},"start":{"character":0,"line":215}},"kind":12},{"definition":"my","line":240,"localvar":"my","kind":13,"containerName":null,"name":"%alg_lookup"},{"definition":"sub","children":[{"line":292,"name":"$hit","containerName":"_allowable_filters","localvar":"my","kind":13,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"_allowable_filters","name":"$type","line":293},{"line":294,"name":"$type","kind":13,"containerName":"_allowable_filters"},{"line":299,"name":"$type","containerName":"_allowable_filters","kind":13},{"kind":13,"containerName":"_allowable_filters","name":"$type","line":299},{"definition":"my","name":"$alg","kind":13,"localvar":"my","containerName":"_allowable_filters","line":300},{"name":"$hit","kind":13,"containerName":"_allowable_filters","line":300},{"line":300,"kind":12,"containerName":"_allowable_filters","name":"algorithm"},{"line":303,"kind":13,"containerName":"_allowable_filters","name":"$alg"},{"name":"$alg","containerName":"_allowable_filters","kind":13,"line":303},{"name":"$alg","kind":13,"containerName":"_allowable_filters","line":303},{"containerName":"_allowable_filters","kind":13,"name":"$hit","line":305},{"kind":12,"containerName":"_allowable_filters","name":"algorithm","line":305},{"name":"$type","kind":13,"containerName":"_allowable_filters","line":310},{"name":"$type","kind":13,"containerName":"_allowable_filters","line":313}],"containerName":"main::","name":"_allowable_filters","line":291,"range":{"end":{"line":320,"character":9999},"start":{"line":291,"character":0}},"kind":12},{"kind":12,"name":"alg_lookup","line":310},{"name":"alg_lookup","kind":12,"line":313},{"line":336,"range":{"start":{"character":0,"line":336},"end":{"line":360,"character":9999}},"kind":12,"definition":"sub","children":[{"definition":"my","line":337,"name":"$self","kind":13,"localvar":"my","containerName":"_set_attributes"},{"definition":"my","containerName":"_set_attributes","localvar":"my","kind":13,"name":"$alg","line":338},{"line":338,"name":"$self","kind":13,"containerName":"_set_attributes"},{"name":"hit","kind":12,"containerName":"_set_attributes","line":338},{"name":"algorithm","kind":12,"containerName":"_set_attributes","line":338},{"containerName":"_set_attributes","kind":13,"name":"$alg","line":341},{"name":"$alg","containerName":"_set_attributes","kind":13,"line":341},{"containerName":"_set_attributes","kind":13,"name":"$alg","line":341},{"name":"$alg","kind":13,"containerName":"_set_attributes","line":343},{"line":345,"kind":13,"containerName":"_set_attributes","name":"$self"},{"name":"$self","containerName":"_set_attributes","kind":13,"line":345},{"name":"$self","containerName":"_set_attributes","kind":13,"line":346},{"line":346,"kind":13,"containerName":"_set_attributes","name":"$self"},{"line":348,"containerName":"_set_attributes","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"_set_attributes","line":348},{"line":350,"containerName":"_set_attributes","kind":13,"name":"$self"},{"line":350,"containerName":"_set_attributes","kind":13,"name":"$self"},{"kind":13,"containerName":"_set_attributes","name":"$self","line":355},{"containerName":"_set_attributes","kind":13,"name":"$self","line":355},{"name":"$self","kind":13,"containerName":"_set_attributes","line":357},{"name":"$self","kind":13,"containerName":"_set_attributes","line":357},{"line":359,"containerName":"_set_attributes","kind":13,"name":"$self"},{"containerName":"_set_attributes","kind":13,"name":"$self","line":359}],"name":"_set_attributes","containerName":"main::"},{"line":345,"kind":12,"name":"_mapping_query"},{"kind":12,"name":"_mapping_hit","line":345},{"line":346,"name":"_def_context_query","kind":12},{"line":346,"kind":12,"name":"_def_context_hit"},{"line":348,"kind":12,"name":"_has_frame_query"},{"name":"_has_frame_hit","kind":12,"line":348},{"line":350,"kind":12,"name":"_has_strand_query"},{"line":350,"name":"_has_strand_hit","kind":12},{"line":355,"kind":12,"name":"_mapping_query"},{"kind":12,"name":"_mapping_hit","line":355},{"line":356,"kind":12,"name":"alg_lookup"},{"kind":12,"name":"mapping","line":356},{"line":357,"name":"_def_context_query","kind":12},{"name":"_def_context_hit","kind":12,"line":357},{"kind":12,"name":"alg_lookup","line":358},{"name":"def_context","kind":12,"line":358},{"kind":12,"name":"_has_frame_query","line":359},{"line":359,"name":"_has_frame_hit","kind":12},{"name":"alg_lookup","kind":12,"line":360},{"line":360,"name":"has_frame","kind":12},{"line":361,"name":"%self","containerName":null,"kind":13},{"kind":12,"name":"_has_strand_query","line":361},{"kind":13,"containerName":null,"name":"%self","line":361},{"kind":12,"name":"_has_strand_hit","line":361},{"kind":12,"name":"alg_lookup","line":362},{"name":"has_strand","kind":12,"line":362},{"kind":13,"containerName":null,"name":"%self","line":366},{"line":366,"name":"_mapping_query","kind":12},{"line":366,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"name":"_mapping_hit","line":366},{"name":"alg_lookup","kind":12,"line":367},{"line":367,"name":"mapping","kind":12},{"name":"%self","containerName":null,"kind":13,"line":368},{"name":"_def_context_query","kind":12,"line":368},{"line":368,"containerName":null,"kind":13,"name":"%self"},{"name":"_def_context_hit","kind":12,"line":368},{"line":369,"kind":12,"name":"alg_lookup"},{"line":369,"kind":12,"name":"def_context"},{"name":"%self","kind":13,"containerName":null,"line":370},{"kind":12,"name":"_has_frame_query","line":370},{"name":"%self","containerName":null,"kind":13,"line":370},{"kind":12,"name":"_has_frame_hit","line":370},{"line":371,"kind":12,"name":"alg_lookup"},{"line":371,"kind":12,"name":"has_frame"},{"containerName":null,"kind":13,"name":"%self","line":372},{"line":372,"name":"_has_strand_query","kind":12},{"line":372,"containerName":null,"kind":13,"name":"%self"},{"line":372,"name":"_has_strand_hit","kind":12},{"name":"alg_lookup","kind":12,"line":373},{"name":"has_strand","kind":12,"line":373},{"name":"$self","containerName":null,"kind":13,"line":377},{"line":377,"name":"warn","containerName":"main::","kind":12},{"name":"%self","containerName":null,"kind":13,"line":378},{"name":"_mapping_query","kind":12,"line":378},{"line":378,"name":"%self","containerName":null,"kind":13},{"line":378,"kind":12,"name":"_mapping_hit"},{"kind":13,"containerName":null,"name":"%self","line":379},{"line":379,"kind":12,"name":"_def_context_query"},{"kind":13,"containerName":null,"name":"%self","line":379},{"line":379,"kind":12,"name":"_def_context_hit"},{"line":381,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"name":"_has_frame_query","line":381},{"line":381,"containerName":null,"kind":13,"name":"%self"},{"line":381,"name":"_has_frame_hit","kind":12},{"line":383,"kind":13,"containerName":null,"name":"%self"},{"name":"_has_strand_query","kind":12,"line":383},{"kind":13,"containerName":null,"name":"%self","line":383},{"name":"_has_strand_hit","kind":12,"line":383},{"definition":"sub","children":[{"definition":"my","line":393,"name":"$obj","localvar":"my","kind":13,"containerName":"_mapping_coeff"},{"definition":"my","containerName":"_mapping_coeff","localvar":"my","kind":13,"name":"$type","line":394},{"kind":13,"localvar":"my","containerName":"_mapping_coeff","name":"%type_i","line":395,"definition":"my"},{"line":396,"name":"$obj","containerName":"_mapping_coeff","kind":13},{"line":396,"containerName":"_mapping_coeff","kind":13,"name":"$obj"},{"containerName":"_mapping_coeff","kind":12,"name":"can","line":396},{"line":397,"kind":13,"containerName":"_mapping_coeff","name":"$obj"},{"line":397,"name":"warn","kind":12,"containerName":"_mapping_coeff"},{"containerName":"_mapping_coeff","kind":13,"name":"$type","line":400},{"name":"$obj","containerName":"_mapping_coeff","kind":13,"line":402},{"line":402,"containerName":"_mapping_coeff","kind":12,"name":"warn"},{"name":"$type","kind":13,"containerName":"_mapping_coeff","line":405},{"line":405,"kind":13,"containerName":"_mapping_coeff","name":"$type"},{"definition":"my","line":406,"kind":13,"localvar":"my","containerName":"_mapping_coeff","name":"$alg"},{"name":"$obj","containerName":"_mapping_coeff","kind":13,"line":406},{"kind":12,"containerName":"_mapping_coeff","name":"algorithm","line":406},{"containerName":"_mapping_coeff","kind":13,"name":"$alg","line":409},{"name":"$alg","kind":13,"containerName":"_mapping_coeff","line":409},{"name":"$alg","containerName":"_mapping_coeff","kind":13,"line":409},{"line":411,"name":"$alg","kind":13,"containerName":"_mapping_coeff"},{"name":"$type_i","kind":13,"containerName":"_mapping_coeff","line":416},{"name":"$type","kind":13,"containerName":"_mapping_coeff","line":416},{"kind":13,"containerName":"_mapping_coeff","name":"$type_i","line":419},{"line":419,"name":"$type","containerName":"_mapping_coeff","kind":13}],"name":"_mapping_coeff","containerName":"main::","line":392,"kind":12,"range":{"start":{"character":0,"line":392},"end":{"line":426,"character":9999}}},{"name":"alg_lookup","kind":12,"line":416},{"name":"alg_lookup","kind":12,"line":419},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"matches_MT","line":453,"definition":"my"},{"name":"@args","containerName":"matches_MT","kind":13,"line":453},{"definition":"my","line":454,"name":"$type","localvar":"my","kind":13,"containerName":"matches_MT"},{"line":454,"kind":13,"containerName":"matches_MT","name":"$action"},{"line":454,"name":"$beg","kind":13,"containerName":"matches_MT"},{"line":454,"name":"$end","kind":13,"containerName":"matches_MT"},{"line":454,"name":"$self","containerName":"matches_MT","kind":13},{"name":"_rearrange","containerName":"matches_MT","kind":12,"line":454},{"name":"@args","kind":13,"containerName":"matches_MT","line":454},{"definition":"my","name":"@actions","localvar":"my","containerName":"matches_MT","kind":13,"line":455},{"name":"$self","containerName":"matches_MT","kind":13,"line":458},{"name":"throw","containerName":"matches_MT","kind":12,"line":458},{"name":"$type","containerName":"matches_MT","kind":13,"line":458},{"name":"$self","containerName":"matches_MT","kind":13,"line":459},{"containerName":"matches_MT","kind":12,"name":"throw","line":459},{"kind":13,"containerName":"matches_MT","name":"$type","line":460},{"kind":13,"containerName":"matches_MT","name":"$type","line":460},{"name":"$self","kind":13,"containerName":"matches_MT","line":463},{"name":"throw","kind":12,"containerName":"matches_MT","line":463},{"line":463,"containerName":"matches_MT","kind":13,"name":"$action"},{"line":464,"name":"$self","containerName":"matches_MT","kind":13},{"line":464,"name":"throw","kind":12,"containerName":"matches_MT"},{"containerName":"matches_MT","kind":13,"name":"@actions","line":464},{"definition":"my","line":466,"localvar":"my","kind":13,"containerName":"matches_MT","name":"$len_id"},{"line":466,"kind":13,"containerName":"matches_MT","name":"$len_cons"},{"definition":"my","kind":13,"localvar":"my","containerName":"matches_MT","name":"$c","line":467},{"line":467,"kind":13,"containerName":"matches_MT","name":"$self"},{"name":"$type","containerName":"matches_MT","kind":13,"line":467},{"name":"$beg","containerName":"matches_MT","kind":13,"line":468},{"line":468,"containerName":"matches_MT","kind":13,"name":"$end"},{"line":468,"name":"$beg","kind":13,"containerName":"matches_MT"},{"line":468,"containerName":"matches_MT","kind":13,"name":"$end"},{"name":"$self","containerName":"matches_MT","kind":13,"line":469},{"line":469,"name":"throw","containerName":"matches_MT","kind":12},{"containerName":"matches_MT","kind":13,"name":"$beg","line":471},{"kind":13,"containerName":"matches_MT","name":"$end","line":471},{"name":"$self","kind":13,"containerName":"matches_MT","line":471},{"line":471,"name":"seq_str","kind":12,"containerName":"matches_MT"},{"kind":13,"containerName":"matches_MT","name":"$self","line":474},{"containerName":"matches_MT","kind":12,"name":"debug","line":474},{"containerName":"matches_MT","kind":13,"name":"$self","line":474},{"containerName":"matches_MT","kind":12,"name":"seq_str","line":474},{"line":475,"name":"$len_id","kind":13,"containerName":"matches_MT"},{"containerName":"matches_MT","kind":13,"name":"$len_cons","line":475},{"containerName":"matches_MT","kind":13,"name":"$c","line":475},{"kind":13,"containerName":"matches_MT","name":"$self","line":475},{"line":475,"kind":12,"containerName":"matches_MT","name":"num_identical"},{"line":475,"containerName":"matches_MT","kind":13,"name":"$self"},{"kind":12,"containerName":"matches_MT","name":"num_conserved","line":475},{"line":476,"name":"$action","containerName":"matches_MT","kind":13},{"name":"$len_id","kind":13,"containerName":"matches_MT","line":478},{"kind":13,"containerName":"matches_MT","name":"$len_cons","line":481},{"name":"$len_id","containerName":"matches_MT","kind":13,"line":484},{"line":484,"name":"$len_cons","kind":13,"containerName":"matches_MT"},{"kind":13,"containerName":"matches_MT","name":"$self","line":487},{"line":487,"containerName":"matches_MT","kind":12,"name":"throw"},{"containerName":"matches_MT","localvar":"my","kind":13,"name":"$start","line":493,"definition":"my"},{"name":"$stop","kind":13,"containerName":"matches_MT","line":493},{"kind":13,"containerName":"matches_MT","name":"$self","line":493},{"containerName":"matches_MT","kind":12,"name":"range","line":493},{"name":"$type","kind":13,"containerName":"matches_MT","line":493},{"line":494,"name":"$beg","containerName":"matches_MT","kind":13},{"kind":13,"containerName":"matches_MT","name":"$start","line":494},{"kind":13,"containerName":"matches_MT","name":"$stop","line":494},{"line":494,"name":"$end","kind":13,"containerName":"matches_MT"},{"name":"$self","containerName":"matches_MT","kind":13,"line":495},{"line":495,"name":"throw","containerName":"matches_MT","kind":12},{"definition":"my","localvar":"my","kind":13,"containerName":"matches_MT","name":"$match_str","line":499},{"line":499,"name":"$self","containerName":"matches_MT","kind":13},{"name":"seq_str","containerName":"matches_MT","kind":12,"line":499},{"line":500,"containerName":"matches_MT","kind":13,"name":"$self"},{"containerName":"matches_MT","kind":12,"name":"gaps","line":500},{"name":"$match_str","containerName":"matches_MT","kind":13,"line":503},{"line":503,"name":"$self","containerName":"matches_MT","kind":13},{"name":"seq_str","kind":12,"containerName":"matches_MT","line":503},{"line":504,"name":"$tgt","kind":13,"localvar":"my","containerName":"matches_MT","definition":"my"},{"kind":13,"containerName":"matches_MT","name":"$self","line":504},{"containerName":"matches_MT","kind":12,"name":"seq_str","line":504},{"line":504,"name":"$type","containerName":"matches_MT","kind":13},{"definition":"my","line":505,"name":"$encode","localvar":"my","kind":13,"containerName":"matches_MT"},{"name":"$match_str","kind":13,"containerName":"matches_MT","line":505},{"line":505,"containerName":"matches_MT","kind":13,"name":"$tgt"},{"definition":"my","line":506,"kind":13,"localvar":"my","containerName":"matches_MT","name":"$zap"},{"line":507,"name":"$encode","kind":13,"containerName":"matches_MT"},{"line":508,"containerName":"matches_MT","kind":13,"name":"$tgt"},{"kind":13,"containerName":"matches_MT","name":"$match_str","line":509},{"line":509,"name":"$tgt","containerName":"matches_MT","kind":13},{"line":509,"containerName":"matches_MT","kind":13,"name":"$encode"},{"definition":"my","containerName":"matches_MT","localvar":"my","kind":13,"name":"$seq","line":515},{"line":516,"containerName":"matches_MT","kind":13,"name":"$seq"},{"line":516,"containerName":"matches_MT","kind":13,"name":"$match_str"},{"line":517,"name":"$beg","containerName":"matches_MT","kind":13},{"line":517,"name":"$start","containerName":"matches_MT","kind":13},{"line":517,"kind":13,"containerName":"matches_MT","name":"$self"},{"kind":13,"containerName":"matches_MT","name":"$type","line":517},{"kind":13,"containerName":"matches_MT","name":"$end","line":518},{"name":"$beg","containerName":"matches_MT","kind":13,"line":518},{"line":518,"containerName":"matches_MT","kind":13,"name":"$self"},{"line":518,"kind":13,"containerName":"matches_MT","name":"$type"},{"line":521,"containerName":"matches_MT","kind":13,"name":"$seq"},{"kind":13,"containerName":"matches_MT","name":"$self","line":522},{"kind":12,"containerName":"matches_MT","name":"throw","line":522},{"line":525,"name":"$seq","containerName":"matches_MT","kind":13},{"line":526,"kind":13,"containerName":"matches_MT","name":"$len_cons"},{"name":"$seq","containerName":"matches_MT","kind":13,"line":526},{"line":526,"name":"$self","containerName":"matches_MT","kind":13},{"name":"$type","kind":13,"containerName":"matches_MT","line":526},{"kind":13,"containerName":"matches_MT","name":"$seq","line":527},{"containerName":"matches_MT","kind":13,"name":"$len_id","line":528},{"name":"$seq","containerName":"matches_MT","kind":13,"line":528},{"kind":13,"containerName":"matches_MT","name":"$self","line":528},{"containerName":"matches_MT","kind":13,"name":"$type","line":528},{"line":529,"name":"$action","kind":13,"containerName":"matches_MT"},{"name":"$len_id","containerName":"matches_MT","kind":13,"line":531},{"line":534,"kind":13,"containerName":"matches_MT","name":"$len_cons"},{"name":"$len_id","kind":13,"containerName":"matches_MT","line":537},{"kind":13,"containerName":"matches_MT","name":"$len_cons","line":537},{"name":"$self","containerName":"matches_MT","kind":13,"line":540},{"line":540,"containerName":"matches_MT","kind":12,"name":"throw"}],"name":"matches_MT","containerName":"main::","definition":"sub","detail":"($self,@args)","line":452,"range":{"end":{"line":544,"character":9999},"start":{"character":0,"line":452}},"kind":12,"signature":{"label":"matches_MT($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#$Id: MapTileUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\npackage Bio::Search::Tiling::MapTileUtils;\nuse strict;\nuse warnings;\nuse Exporter;\n\nBEGIN {\n    our @ISA = qw( Exporter );\n    our @EXPORT = qw( get_intervals_from_hsps \n                      interval_tiling \n                      decompose_interval\n                      _allowable_filters \n                      _set_attributes\n                      _mapping_coeff);\n}\n\n# tiling trials\n# assumed: intervals are [$a0, $a1], with $a0 <= $a1\n=head1 NAME\n\nBio::Search::Tiling::MapTileUtils - utilities for manipulating closed intervals for an HSP tiling algorithm\n\n=head1 SYNOPSIS\n\nNot used directly.\n\n=head1 DESCRIPTION\n\nNot used directly.\n\n=head1 NOTE\n\nAn \"interval\" in this module is defined as an arrayref C<[$a0, $a1]>, where\nC<$a0, $a1> are scalar numbers satisfying C<$a0 E<lt>= $a1>.\n\n=head1 AUTHOR\n\nMark A. Jensen - maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\n=head2 interval_tiling    \n\n Title   : interval_tiling()\n Usage   : @tiling = interval_tiling( \\@array_of_intervals )\n Function: Find minimal set of intervals covering the input set\n Returns : array of arrayrefs of the form\n  ( [$interval => [ @indices_of_collapsed_input_intervals ]], ...)\n Args    : arrayref of intervals\n\n\nsub interval_tiling {\n    return unless $_[0]; # no input\n    my $n = scalar @{$_[0]};\n    my %input;\n    @input{(0..$n-1)} = @{$_[0]};\n    my @active = (0..$n-1);\n    my @hold;\n    my @tiled_ints;\n    my @ret;\n    while (@active) {\n\tmy $tgt = $input{my $tgt_i = shift @active};\n\tpush @tiled_ints, $tgt_i;\n\tmy $tgt_not_disjoint = 1;\n\twhile ($tgt_not_disjoint) {\n\t    $tgt_not_disjoint = 0;\n\t    while (my $try_i = shift @active) {\n\t\tmy $try = $input{$try_i};\n\t\tif ( !are_disjoint($tgt, $try) ) {\n\t\t    $tgt = min_covering_interval($tgt,$try);\n\t\t    push @tiled_ints, $try_i;\n\t\t    $tgt_not_disjoint = 1;\n\t\t}\n\t\telse {\n\t\t    push @hold, $try_i;\n\t\t}\n\t    }\n\t    if (!$tgt_not_disjoint) {\n\t\tpush @ret, [ $tgt => [@tiled_ints] ];\n\t\t@tiled_ints = ();\n\t    }\n\t    @active = @hold;\n\t    @hold = ();\n\t}\n    }\n    return @ret;\n}\n\n=head2 decompose_interval\n\n Title   : decompose_interval\n Usage   : @decomposition = decompose_interval( \\@overlappers )\n Function: Calculate the disjoint decomposition of a set of\n           overlapping intervals, each annotated with a list of\n           covering intervals\n Returns : array of arrayrefs of the form\n           ( [[@interval] => [@indices_of_coverers]], ... )\n Args    : arrayref of intervals (arrayrefs like [$a0, $a1], with\n Note    : Each returned interval is associated with a list of indices of the\n           original intervals that cover that decomposition component\n           (scalar size of this list could be called the 'coverage coefficient')\n Note    : Coverage: each component of the decomp is completely contained\n           in the input intervals that overlap it, by construction.\n Caveat  : This routine expects the members of @overlappers to overlap,\n           but doesn't check this.\n\n\n### what if the input intervals don't overlap?? They MUST overlap; that's\n### what interval_tiling() is for.\n\nsub decompose_interval {\n    return unless $_[0]; # no input\n    my @ints = @{$_[0]};\n    my (%flat,@flat);\n    ### this is ok, but need to handle the case where a lh and rh endpoint\n    ### coincide...\n    # decomposition --\n    # flatten:\n    # every lh endpoint generates (lh-1, lh)\n    # every rh endpoint generates (rh, rh+)\n    foreach (@ints) {\n\t$flat{$$_[0]-1}++;\n\t$flat{$$_[0]}++;\n\t$flat{$$_[1]}++;\n\t$flat{$$_[1]+1}++;\n    }\n    # sort, create singletons if nec.\n    my @a;\n    @a = sort {$a<=>$b} keys %flat;\n    # throw out first and last (meeting a boundary condition)\n    shift @a; pop @a;\n    # look for singletons\n    @flat = (shift @a, shift @a);\n    if ( $flat[1]-$flat[0] == 1 ) {\n\t@flat = ($flat[0],$flat[0], $flat[1]);\n    }\n    while (my $a = shift @a) {\n\tif ($a-$flat[-2]==2) {\n\t    push @flat, $flat[-1]; # create singleton interval\n\t}\n\tpush @flat, $a;\n    }\n    if ($flat[-1]-$flat[-2]==1 and @flat % 2) {\n\tpush @flat, $flat[-1];\n    }\n    # component intervals are consecutive pairs\n    my @decomp;\n    while (my $a = shift @flat) {\n\tpush @decomp, [$a, shift @flat];\n    }\n\n    # for each component, return a list of the indices of the input intervals\n    # that cover the component.\n    my @coverage;\n    foreach my $i (0..$#decomp) {\n\tforeach my $j (0..$#ints) {\n\t    unless (are_disjoint($decomp[$i], $ints[$j])) {\n\t\tif (defined $coverage[$i]) {\n\t\t    push @{$coverage[$i]}, $j;\n\t\t}\n\t\telse {\n\t\t    $coverage[$i] = [$j];\n\t\t}\n\t    }\n\t}\n    }\n    return map { [$decomp[$_] => $coverage[$_]] } (0..$#decomp);\n}    \n\n=head2 are_disjoint\n\n Title   : are_disjoint\n Usage   : are_disjoint( [$a0, $a1], [$b0, $b1] )\n Function: Determine if two intervals are disjoint\n Returns : True if the intervals are disjoint, false if they overlap\n Args    : array of two intervals\n\n\nsub are_disjoint {\n    my ($int1, $int2) = @_;\n    return 1 if ( $$int1[1] < $$int2[0] ) || ( $$int2[1] < $$int1[0]);\n    return 0;\n}\n\n=head2 min_covering_interval\n\n Title   : min_covering_interval \n Usage   : $interval = min_covering_interval( [$a0,$a1],[$b0,$b1] )\n Function: Determine the minimal covering interval for two intervals\n Returns : an interval\n Args    : two intervals\n\n\nsub min_covering_interval {\n    my ($int1, $int2) = @_;\n    my @a = sort {$a <=> $b} (@$int1, @$int2);\n    return [$a[0],$a[-1]];\n}\n\n=head2 get_intervals_from_hsps\n\n Title   : get_intervals_from_hsps\n Usage   : @intervals = get_intervals_from_hsps($type, @hsp_objects)\n Function: Return array of intervals of the form [ $start, $end ],\n           from an array of hsp objects\n Returns : an array of intervals\n Args    : scalar $type, array of HSPI objects; where $type is one of 'hit',\n           'subject', 'query'\n\n\nsub get_intervals_from_hsps {\n    my $type = shift;\n    my @hsps;\n    if (ref($type) =~ /HSP/) {\n\tpush @hsps, $type;\n\t$type = 'query';\n    }\n    elsif ( !grep /^$type$/,qw( hit subject query ) ) {\n\tdie \"Unknown HSP type '$type'\";\n    }\n    $type = 'hit' if $type eq 'subject';\n    push @hsps, @_;\n    my @ret;\n    foreach (@hsps) {\n#\tpush @ret, [ $_->start($type), $_->end($type)];\n\tpush @ret, [ $_->range($type) ];\n    }\n    return @ret;\n}\n\n# fast, clear, nasty, brutish and short.\n# for _allowable_filters(), _set_mapping()\n# covers BLAST, FAST families\n# FASTA is ambiguous (nt or aa) based on alg name only\n\nmy $alg_lookup = {\n    'N'  => { 'mapping' => [1,1],\n              'def_context' => ['p_','p_'],\n\t      'has_strand' => [1, 1],\n              'has_frame' => [0, 0]},\n    'P'  => { 'mapping' => [1,1],\n              'def_context' => ['all','all'],\n\t      'has_strand' => [0, 0],\n\t      'has_frame' => [0, 0]},\n    'X'  => { 'mapping' => [3, 1],\n              'def_context' => [undef,'all'],\n\t      'has_strand' => [1, 0],\n\t      'has_frame' => [1, 0]}, \n    'Y'  => { 'mapping' => [3, 1],\n              'def_context' => [undef,'all'],\n\t      'has_strand' => [1, 0],\n\t      'has_frame' => [1, 0]}, \n    'TA' => { 'mapping' => [1, 3],\n              'def_context' => ['all',undef],\n\t      'has_strand' => [0, 1],\n\t      'has_frame' => [0, 1]}, \n    'TN' => { 'mapping' => [1, 3],\n              'def_context' => ['p_',undef],\n\t      'has_strand' => [1,1],\n\t      'has_frame' => [0, 1]}, \n    'TX' => { 'mapping' => [3, 3],\n              'def_context' => [undef,undef],\n\t      'has_strand' => [1, 1],\n\t      'has_frame' => [1, 1]}, \n    'TY' => { 'mapping' => [3, 3],\n              'def_context' => [undef,undef],\n\t      'has_strand' => [1, 1],\n\t      'has_frame' => [1, 1]}\n};\n   \n=head2 _allowable_filters\n    \n Title   : _allowable_filters\n Usage   : _allowable_filters($Bio_Search_Hit_HitI, $type)\n Function: Return the HSP filters (strand, frame) allowed, \n           based on the reported algorithm\n Returns : String encoding allowable filters: \n           s = strand, f = frame\n           Empty string if no filters allowed\n           undef if algorithm unrecognized\n Args    : A Bio::Search::Hit::HitI object,\n           scalar $type, one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub _allowable_filters {\n    my $hit = shift;\n    my $type = shift;\n    $type ||= 'q';\n    unless (grep /^$type$/, qw( h q s ) ) {\n\twarn(\"Unknown type '$type'; returning ''\");\n\treturn '';\n    }\n    $type = 'h' if $type eq 's';\n    my $alg = $hit->algorithm;\n\n    # pretreat (i.e., kludge it)\n    $alg =~ /^RPS/ and ($alg) = ($alg =~ /\\(([^)]+)\\)/);\n\n    for ($hit->algorithm) {\n\t/MEGABLAST/i && do {\n\t    return qr/[s]/;\n\t};\n\t/(.?)BLAST(.?)/i && do {\n\t    return $$alg_lookup{$1.$2}{$type};\n\t};\n\t/(.?)FAST(.?)/ && do {\n\t    return $$alg_lookup{$1.$2}{$type};\n\t};\n\tdo { # unrecognized\n\t    last;\n\t};\n    }\n    return;\n}\n\n\n=head2 _set_attributes\n\n Title   : _set_attributes\n Usage   : $tiling->_set_attributes()\n Function: Sets attributes for invocant\n           that depend on algorithm name\n Returns : True on success\n Args    : none\n Note    : setting based on the configuration table\n           %alg_lookup\n\n\nsub _set_attributes {\n    my $self = shift;\n    my $alg = $self->hit->algorithm;\n\n    # pretreat (i.e., kludge it)\n    $alg =~ /^RPS/ and ($alg) = ($alg =~ /\\(([^)]+)\\)/);\n    \n    for ($alg) {\n\t/MEGABLAST/i && do {\n\t    ($self->{_mapping_query},$self->{_mapping_hit}) = (1,1);\n\t    ($self->{_def_context_query},$self->{_def_context_hit}) =\n\t\t('p_','p_');\n\t    ($self->{_has_frame_query},$self->{_has_frame_hit}) =\n\t\t(0, 0);\n\t    ($self->{_has_strand_query},$self->{_has_strand_hit}) =\n\t\t(1, 1);\n\t    last;\n\t};\n\t/(.?)BLAST(.?)/i && do {\n\t    ($self->{_mapping_query},$self->{_mapping_hit}) = \n\t\t@{$$alg_lookup{$1.$2}{mapping}};\n\t    ($self->{_def_context_query},$self->{_def_context_hit}) =\n\t\t@{$$alg_lookup{$1.$2}{def_context}};\n\t    ($self->{_has_frame_query},$self->{_has_frame_hit}) =\t    \n\t\t@{$$alg_lookup{$1.$2}{has_frame}};\n\t    ($self->{_has_strand_query},$self->{_has_strand_hit}) =\t    \n\t\t@{$$alg_lookup{$1.$2}{has_strand}};\n\t    last;\n\t};\n\t/(.?)FAST(.?)/ && do {\n\t    ($self->{_mapping_query},$self->{_mapping_hit}) = \n\t\t@{$$alg_lookup{$1.$2}{mapping}};\n\t    ($self->{_def_context_query},$self->{_def_context_hit}) =\n\t\t@{$$alg_lookup{$1.$2}{def_context}};\n\t    ($self->{_has_frame_query},$self->{_has_frame_hit}) =\t    \n\t\t@{$$alg_lookup{$1.$2}{has_frame}};\n\t    ($self->{_has_strand_query},$self->{_has_strand_hit}) =\t    \n\t\t@{$$alg_lookup{$1.$2}{has_strand}};\n\t    last;\n\t};\n\tdo { # unrecognized\n\t    $self->warn(\"Unrecognized algorithm '$alg'; defaults may not work\");\n\t    ($self->{_mapping_query},$self->{_mapping_hit}) = (1,1);\n\t    ($self->{_def_context_query},$self->{_def_context_hit}) =\n\t\t('all','all');\n\t    ($self->{_has_frame_query},$self->{_has_frame_hit}) =\t    \n\t\t(0,0);\n\t    ($self->{_has_strand_query},$self->{_has_strand_hit}) =\t    \n\t\t(0,0);\n\t    return 0;\n\t    last;\n\t};\n    }\n    return 1;\n}\n           \nsub _mapping_coeff {\n    my $obj = shift;\n    my $type = shift;\n    my %type_i = ( 'query' => 0, 'hit' => 1 );\n    unless ( ref($obj) && $obj->can('algorithm') ) {\n\t$obj->warn(\"Object type unrecognized\");\n\treturn undef;\n    }\n    $type ||= 'query';\n    unless ( grep(/^$type$/, qw( query hit subject ) ) ) {\n\t$obj->warn(\"Sequence type unrecognized\");\n\treturn undef;\n    }\n    $type = 'hit' if $type eq 'subject';\n    my $alg = $obj->algorithm;\n\n    # pretreat (i.e., kludge it)\n    $alg =~ /^RPS/ and ($alg) = ($alg =~ /\\(([^)]+)\\)/);\n    \n    for ($alg) {\n\t/MEGABLAST/i && do {\n\t    return 1;\n\t};\n\t/(.?)BLAST(.?)/i && do {\n\t    return $$alg_lookup{$1.$2}{'mapping'}[$type_i{$type}];\n\t};\n\t/(.?)FAST(.?)/ && do {\n\t    return $$alg_lookup{$1.$2}{'mapping'}[$type_i{$type}];\n\t};\n\tdo { # unrecognized\n\t    last;\n\t};\n    }\n    return;\n}\n\n1;\n# need our own subsequencer for hsps. \n\npackage Bio::Search::HSP::HSPI;\n\nuse strict;\nuse warnings;\n\n=head2 matches_MT\n\n Title   : matches_MT\n Usage   : $hsp->matches($type, $action, $start, $end)\n Purpose   : Get the total number of identical or conserved matches \n             in the query or sbjct sequence for the given HSP. Optionally can\n             report data within a defined interval along the seq.\n Returns   : scalar int \n Args      : \n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n             between the query and sbjct lines which are used for determining\n             the number of identical and conservative matches.\n Note      : Modeled on Bio::Search::HSP::HSPI::matches"}},{"line":453,"name":"warnings","kind":2,"containerName":""},{"containerName":"Search::Tiling::MapTileUtils::_mapping_coeff","kind":12,"name":"Bio","line":467},{"line":517,"kind":12,"containerName":"Search::Tiling::MapTileUtils::_mapping_coeff","name":"Bio"},{"containerName":"Search::Tiling::MapTileUtils::_mapping_coeff","kind":12,"name":"Bio","line":518},{"line":521,"name":"CORE","containerName":"length","kind":12},{"kind":12,"containerName":"length","name":"CORE","line":526},{"line":526,"kind":12,"containerName":"Search::Tiling::MapTileUtils::_mapping_coeff","name":"Bio"},{"line":528,"kind":12,"containerName":"length","name":"CORE"},{"kind":12,"containerName":"Search::Tiling::MapTileUtils::_mapping_coeff","name":"Bio","line":528},{"line":549,"range":{"end":{"line":574,"character":9999},"start":{"line":549,"character":0}},"kind":12,"definition":"sub","children":[{"definition":"my","localvar":"my","containerName":"_ints_as_text","kind":13,"name":"$ints","line":550},{"definition":"my","line":551,"localvar":"my","containerName":"_ints_as_text","kind":13,"name":"@ints"},{"line":551,"name":"$ints","containerName":"_ints_as_text","kind":13},{"line":552,"containerName":"_ints_as_text","localvar":"my","kind":13,"name":"%pos","definition":"my"},{"name":"@ints","kind":13,"containerName":"_ints_as_text","line":553},{"kind":13,"containerName":"_ints_as_text","name":"$pos","line":554},{"kind":13,"containerName":"_ints_as_text","name":"$pos","line":555},{"line":558,"name":"@pos","localvar":"my","containerName":"_ints_as_text","kind":13,"definition":"my"},{"kind":13,"containerName":"_ints_as_text","name":"$a","line":558},{"containerName":"_ints_as_text","kind":13,"name":"$b","line":558},{"name":"%pos","kind":13,"containerName":"_ints_as_text","line":558},{"line":559,"name":"@pos","containerName":"_ints_as_text","kind":13},{"kind":13,"containerName":"_ints_as_text","name":"@pos","line":559},{"definition":"my","name":"$max","kind":13,"localvar":"my","containerName":"_ints_as_text","line":561},{"name":"$max","containerName":"_ints_as_text","kind":13,"line":562},{"name":"$max","kind":13,"containerName":"_ints_as_text","line":562},{"containerName":"_ints_as_text","kind":13,"name":"$max","line":562},{"containerName":"_ints_as_text","kind":13,"name":"@pos","line":562},{"containerName":"_ints_as_text","localvar":"my","kind":13,"name":"$j","line":563,"definition":"my"},{"line":563,"name":"$max","containerName":"_ints_as_text","kind":13},{"definition":"my","name":"$i","localvar":"my","containerName":"_ints_as_text","kind":13,"line":564},{"line":564,"containerName":"_ints_as_text","kind":13,"name":"$max"},{"name":"$j","kind":13,"containerName":"_ints_as_text","line":564},{"kind":13,"localvar":"my","containerName":"_ints_as_text","name":"@line","line":565,"definition":"my"},{"line":565,"kind":13,"containerName":"_ints_as_text","name":"$j"},{"name":"@pos","containerName":"_ints_as_text","kind":13,"line":565},{"line":566,"name":"@line","containerName":"_ints_as_text","kind":13},{"containerName":"_ints_as_text","kind":13,"name":"@pos","line":568},{"kind":13,"containerName":"_ints_as_text","name":"%pos","line":569},{"line":570,"containerName":"_ints_as_text","kind":13,"name":"@pos"},{"line":570,"name":"@pos","containerName":"_ints_as_text","kind":13},{"kind":13,"containerName":"_ints_as_text","name":"@pos","line":570},{"kind":13,"containerName":"_ints_as_text","name":"@ints","line":571},{"name":"$pos","containerName":"_ints_as_text","kind":13,"line":572},{"line":572,"name":"$pos","kind":13,"containerName":"_ints_as_text"},{"name":"$pos","containerName":"_ints_as_text","kind":13,"line":572},{"line":572,"name":"@pos","kind":13,"containerName":"_ints_as_text"},{"line":572,"kind":13,"containerName":"_ints_as_text","name":"$pos"}],"name":"_ints_as_text","containerName":"main::"},{"line":550,"name":"Bio::Search::Tiling::MapTileUtils","kind":2,"definition":1}],"version":5}