{"vars":[{"line":81,"containerName":"","kind":2,"name":"base"},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","name":"$class","kind":13,"localvar":"my","containerName":"new","line":95},{"line":95,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":97,"name":"$self","kind":13,"localvar":"my","containerName":"new"},{"line":97,"name":"$class","containerName":"new","kind":13},{"name":"@args","kind":13,"containerName":"new","line":97},{"definition":"my","line":98,"name":"$db","kind":13,"localvar":"my","containerName":"new"},{"line":98,"name":"$self","containerName":"new","kind":13},{"name":"_rearrange","kind":12,"containerName":"new","line":98},{"kind":13,"containerName":"new","name":"@args","line":98},{"line":99,"kind":13,"containerName":"new","name":"$db"},{"name":"$self","kind":13,"containerName":"new","line":99},{"containerName":"new","kind":12,"name":"query_database","line":99},{"line":99,"name":"$db","containerName":"new","kind":13},{"line":100,"name":"$self","containerName":"new","kind":13}],"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: WABAResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::WABAResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::WABAResult - Result object for WABA alignment output\n\n=head1 SYNOPSIS\n\n# use this object exactly as you would a GenericResult\n# the only extra method is query_database which is the \n# name of the file where the query sequence came from\n\n=head1 DESCRIPTION\n\nThis object is for WABA result output, there is little difference\nbetween this object and a GenericResult save the addition of one\nmethod query_database.  Expect many of the fields for GenericResult to\nbe empty however as WABA was not intended to provide a lot of extra\ninformation other than the alignment.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::WABAResult;\nuse strict;\n\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::WABAResult->new();\n Function: Builds a new Bio::Search::Result::WABAResult object \n Returns : Bio::Search::Result::WABAResult\n Args    : -query_database => \"name of the database where the query came from\"","parameters":[{"label":"$class"},{"label":"@args"}]},"kind":12,"range":{"end":{"line":101,"character":9999},"start":{"character":0,"line":94}},"line":94},{"line":97,"containerName":"new","kind":12,"name":"SUPER"},{"signature":{"documentation":"1;\n# $Id: WABAResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::WABAResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::WABAResult - Result object for WABA alignment output\n\n=head1 SYNOPSIS\n\n# use this object exactly as you would a GenericResult\n# the only extra method is query_database which is the \n# name of the file where the query sequence came from\n\n=head1 DESCRIPTION\n\nThis object is for WABA result output, there is little difference\nbetween this object and a GenericResult save the addition of one\nmethod query_database.  Expect many of the fields for GenericResult to\nbe empty however as WABA was not intended to provide a lot of extra\ninformation other than the alignment.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::WABAResult;\nuse strict;\n\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::WABAResult->new();\n Function: Builds a new Bio::Search::Result::WABAResult object \n Returns : Bio::Search::Result::WABAResult\n Args    : -query_database => \"name of the database where the query came from\"\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($db) = $self->_rearrange([qw(QUERY_DATABASE)], @args);\n  defined $db && $self->query_database($db);\n  return $self;\n}\n\n=head2 query_database\n\n Title   : query_database\n Usage   : $obj->query_database($newval)\n Function: Data field for the database filename where the \n           query sequence came from\n Returns : value of query_database\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"query_database($self,$value)"},"line":115,"kind":12,"range":{"end":{"character":9999,"line":121},"start":{"line":115,"character":0}},"definition":"sub","detail":"($self,$value)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"query_database","line":116,"definition":"my"},{"line":116,"name":"$value","containerName":"query_database","kind":13},{"kind":13,"containerName":"query_database","name":"$value","line":117},{"line":118,"containerName":"query_database","kind":13,"name":"$self"},{"line":118,"kind":13,"containerName":"query_database","name":"$value"},{"line":120,"containerName":"query_database","kind":13,"name":"$self"}],"containerName":"main::","name":"query_database"}],"version":5}