{"vars":[{"line":117,"name":"base","containerName":"","kind":2},{"children":[{"name":"$self","localvar":"my","containerName":"_setup","kind":13,"line":131,"definition":"my"},{"name":"@args","containerName":"_setup","kind":13,"line":131},{"name":"$self","kind":13,"containerName":"_setup","line":134},{"name":"_fields","kind":12,"containerName":"_setup","line":134},{"definition":"my","containerName":"_setup","localvar":"my","kind":13,"name":"$parent","line":143},{"containerName":"_setup","kind":13,"name":"$chunk","line":143},{"line":143,"containerName":"_setup","kind":13,"name":"$params"},{"containerName":"_setup","kind":13,"name":"$stats","line":143},{"line":143,"kind":13,"containerName":"_setup","name":"$self"},{"line":143,"name":"_rearrange","kind":12,"containerName":"_setup"},{"line":147,"name":"@args","kind":13,"containerName":"_setup"},{"name":"$self","containerName":"_setup","kind":13,"line":148},{"line":148,"containerName":"_setup","kind":12,"name":"throw"},{"name":"$parent","kind":13,"containerName":"_setup","line":148},{"line":148,"name":"$chunk","containerName":"_setup","kind":13},{"name":"$self","containerName":"_setup","kind":13,"line":150},{"line":150,"name":"parent","kind":12,"containerName":"_setup"},{"kind":13,"containerName":"_setup","name":"$parent","line":150},{"containerName":"_setup","kind":13,"name":"$parent","line":150},{"line":152,"name":"$chunk","containerName":"_setup","kind":13},{"definition":"my","containerName":"_setup","localvar":"my","kind":13,"name":"$io","line":153},{"kind":13,"containerName":"_setup","name":"$start","line":153},{"containerName":"_setup","kind":13,"name":"$end","line":153},{"name":"$chunk","kind":13,"containerName":"_setup","line":154},{"line":155,"containerName":"_setup","kind":13,"name":"$io"},{"name":"$start","kind":13,"containerName":"_setup","line":155},{"kind":13,"containerName":"_setup","name":"$end","line":155},{"line":155,"name":"$chunk","containerName":"_setup","kind":13},{"line":158,"name":"$io","containerName":"_setup","kind":13},{"line":158,"kind":13,"containerName":"_setup","name":"$chunk"},{"name":"$self","kind":13,"containerName":"_setup","line":160},{"name":"chunk","kind":12,"containerName":"_setup","line":160},{"line":160,"name":"$io","kind":13,"containerName":"_setup"},{"line":160,"containerName":"_setup","kind":13,"name":"$start"},{"line":160,"name":"$end","kind":13,"containerName":"_setup"}],"name":"_setup","containerName":"main::","definition":"sub","detail":"($self,@args)","line":130,"kind":12,"range":{"start":{"line":130,"character":0},"end":{"character":9999,"line":161}},"signature":{"label":"_setup($self,@args)","documentation":"1;\n# $Id: PullResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::PullResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::PullResultI - Bio::Search::Result::ResultI interface for\n                                  'pull' parsers\n\n=head1 SYNOPSIS\n\n    # This is an interface and cannot be instantiated\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                -file   => 't/data/hmmpfam.out');\n\n    my $result = $io->next_result;\n\n    while( $hit = $result->next_hit()) {\n        # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n    my $desc = $result->query_description();\n    my $dbname = $result->database_name();\n    my $size = $result->database_letters();\n    my $num_entries = $result->database_entries();\n    my $gap_ext = $result->get_parameter('gapext');\n    my @params = $result->available_parameters;\n    my $kappa = $result->get_statistic('kappa');\n    my @statnames = $result->available_statistics;\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\nPullResultI is for fast implementations that only do parsing work on the result\ndata when you actually request information by calling one of the ResultI\nmethods.\n\nMany methods of ResultI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullResult modules to\nbe created by (and have as a -parent) SearchIO modules written using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::PullResultI;\n\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\nuse base qw(Bio::PullParserI Bio::Search::Result::ResultI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().","parameters":[{"label":"$self"},{"label":"@args"}]}},{"name":"next_hit","kind":12,"line":134},{"line":135,"kind":12,"name":"num_hits"},{"line":136,"kind":12,"name":"hits"},{"name":"no_hits_found","kind":12,"line":137},{"kind":12,"name":"query_name","line":138},{"line":139,"name":"query_accession","kind":12},{"line":140,"kind":12,"name":"query_length"},{"line":141,"kind":12,"name":"query_description"},{"line":163,"containerName":null,"kind":13,"name":"%params"},{"line":164,"kind":13,"containerName":null,"name":"%params"},{"kind":13,"containerName":null,"name":"$self","line":165},{"containerName":"main::","kind":12,"name":"throw","line":165},{"definition":"my","name":"$key","localvar":"my","containerName":null,"kind":13,"line":167},{"name":"$value","kind":13,"containerName":null,"line":167},{"line":167,"name":"%params","kind":13,"containerName":null},{"line":168,"name":"$self","containerName":null,"kind":13},{"line":168,"containerName":"main::","kind":12,"name":"add_parameter"},{"line":168,"name":"$key","containerName":null,"kind":13},{"line":168,"containerName":null,"kind":13,"name":"$value"},{"kind":13,"containerName":null,"name":"%stats","line":171},{"line":172,"name":"%stats","kind":13,"containerName":null},{"line":173,"name":"$self","containerName":null,"kind":13},{"name":"throw","kind":12,"containerName":"main::","line":173},{"definition":"my","line":175,"name":"$key","localvar":"my","containerName":null,"kind":13},{"name":"$value","kind":13,"containerName":null,"line":175},{"name":"%stats","containerName":null,"kind":13,"line":175},{"name":"$self","containerName":null,"kind":13,"line":176},{"line":176,"name":"add_statistic","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$key","line":176},{"kind":13,"containerName":null,"name":"$value","line":176},{"range":{"start":{"line":198,"character":0},"end":{"line":200,"character":9999}},"kind":12,"line":198,"definition":"sub","containerName":"main::","name":"next_hit","children":[{"line":199,"containerName":"next_hit","kind":12,"name":"get_field"}]},{"containerName":"main::","name":"query_name","children":[{"line":235,"name":"get_field","kind":12,"containerName":"query_name"}],"definition":"sub","kind":12,"range":{"end":{"line":236,"character":9999},"start":{"line":234,"character":0}},"line":234},{"line":248,"range":{"end":{"line":250,"character":9999},"start":{"line":248,"character":0}},"kind":12,"children":[{"line":249,"name":"get_field","kind":12,"containerName":"query_accession"}],"containerName":"main::","name":"query_accession","definition":"sub"},{"line":262,"kind":12,"range":{"end":{"line":264,"character":9999},"start":{"character":0,"line":262}},"children":[{"line":263,"name":"get_field","kind":12,"containerName":"query_length"}],"name":"query_length","containerName":"main::","definition":"sub"},{"kind":12,"range":{"end":{"line":279,"character":9999},"start":{"character":0,"line":277}},"line":277,"name":"query_description","containerName":"main::","children":[{"name":"get_field","kind":12,"containerName":"query_description","line":278}],"definition":"sub"},{"line":292,"range":{"end":{"line":294,"character":9999},"start":{"character":0,"line":292}},"kind":12,"children":[{"name":"get_field","containerName":"database_name","kind":12,"line":293}],"name":"database_name","containerName":"main::","definition":"sub"},{"definition":"sub","children":[{"line":309,"name":"get_field","containerName":"database_letters","kind":12}],"name":"database_letters","containerName":"main::","line":308,"kind":12,"range":{"end":{"line":310,"character":9999},"start":{"character":0,"line":308}}},{"children":[{"line":324,"kind":12,"containerName":"database_entries","name":"get_field"}],"containerName":"main::","name":"database_entries","definition":"sub","line":323,"range":{"start":{"line":323,"character":0},"end":{"character":9999,"line":325}},"kind":12},{"children":[{"name":"get_field","kind":12,"containerName":"algorithm","line":338}],"containerName":"main::","name":"algorithm","definition":"sub","line":337,"kind":12,"range":{"start":{"line":337,"character":0},"end":{"character":9999,"line":339}}},{"name":"algorithm_version","containerName":"main::","children":[{"name":"get_field","kind":12,"containerName":"algorithm_version","line":352}],"definition":"sub","kind":12,"range":{"end":{"line":353,"character":9999},"start":{"character":0,"line":351}},"line":351},{"signature":{"documentation":"1;\n# $Id: PullResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::PullResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::PullResultI - Bio::Search::Result::ResultI interface for\n                                  'pull' parsers\n\n=head1 SYNOPSIS\n\n    # This is an interface and cannot be instantiated\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                -file   => 't/data/hmmpfam.out');\n\n    my $result = $io->next_result;\n\n    while( $hit = $result->next_hit()) {\n        # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n    my $desc = $result->query_description();\n    my $dbname = $result->database_name();\n    my $size = $result->database_letters();\n    my $num_entries = $result->database_entries();\n    my $gap_ext = $result->get_parameter('gapext');\n    my @params = $result->available_parameters;\n    my $kappa = $result->get_statistic('kappa');\n    my @statnames = $result->available_statistics;\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\nPullResultI is for fast implementations that only do parsing work on the result\ndata when you actually request information by calling one of the ResultI\nmethods.\n\nMany methods of ResultI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullResult modules to\nbe created by (and have as a -parent) SearchIO modules written using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::PullResultI;\n\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\nuse base qw(Bio::PullParserI Bio::Search::Result::ResultI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hit => undef,\n                        num_hits => undef,\n                        hits => undef,\n                        no_hits_found => undef,\n                        query_name => undef,\n                        query_accession => undef,\n                        query_length => undef,\n                        query_description => undef  ) } );\n    \n    my ($parent, $chunk, $params, $stats) = $self->_rearrange([qw(PARENT\n                                                                  CHUNK\n                                                                  PARAMETERS\n                                                                  STATISTICS)],\n                                                              @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    if (defined $params) {\n        if (ref($params) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-parameters\");\n        }\n        while (my ($key,$value) = each %{$params}) {\n            $self->add_parameter($key, $value);\n        }\n    }\n    if (defined $stats) {\n        if (ref($stats) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-statistics\");\n        }\n        while (my ($key,$value) = each %{$stats}) {\n            $self->add_statistic($key, $value);\n        }\n    }\n}\n\n#\n# Some of these methods are written explitely to avoid ResultI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought all them.\n#\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n    return shift->get_field('next_hit');\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function.\n              Defaults to sort by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort()\n              function the user function must access Bio::Search::Result::ResultI namespace. \n              For example, use : \n              $result->sort_hits(sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t                 $Bio::Search::Result::ResultI::b->length});\n              NOT $result->sort_hits($a->length <=>$b->length);\n\n\n# In ResultI. subclasses will probably want to override since sort_hits normally\n# calls hits().\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    return shift->get_field('query_name');\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    return shift->get_field('query_accession');\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    return shift->get_field('query_length');\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    return shift->get_field('query_description');\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    return shift->get_field('database_name');\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\nsub database_letters {\n    return shift->get_field('database_letters');\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\nsub database_entries {\n    return shift->get_field('database_entries');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm {\n   return shift->get_field('algorithm');\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version {\n   return shift->get_field('algorithm_version');\n}\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : value of the literature reference for the algorithm\n Args    : newvalue (optional)\n Comments: The default implementation in ResultI returns an empty string\n           rather than throwing a NotImplemented exception, since\n           the ref may not always be available and is not critical.","parameters":[{"label":"$self"}],"label":"algorithm_reference($self)"},"line":368,"range":{"end":{"line":371,"character":9999},"start":{"line":368,"character":0}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","line":369,"name":"$self","localvar":"my","kind":13,"containerName":"algorithm_reference"}],"name":"algorithm_reference","containerName":"main::"},{"range":{"start":{"character":0,"line":383},"end":{"line":385,"character":9999}},"kind":12,"line":383,"name":"num_hits","containerName":"main::","children":[{"line":384,"name":"get_field","containerName":"num_hits","kind":12}],"definition":"sub"},{"line":399,"kind":12,"range":{"start":{"line":399,"character":0},"end":{"line":401,"character":9999}},"definition":"sub","children":[{"line":400,"kind":12,"containerName":"hits","name":"get_field"}],"containerName":"main::","name":"hits"},{"line":422,"kind":12,"range":{"end":{"character":9999,"line":424},"start":{"line":422,"character":0}},"definition":"sub","children":[{"kind":12,"containerName":"no_hits_found","name":"get_field","line":423}],"name":"no_hits_found","containerName":"main::"},{"children":[{"line":438,"name":"throw_not_implemented","kind":12,"containerName":"rewind"}],"name":"rewind","containerName":"main::","definition":"sub","line":437,"kind":12,"range":{"start":{"line":437,"character":0},"end":{"line":439,"character":9999}}},{"signature":{"label":"get_parameter($self,$param)","parameters":[{"label":"$self"},{"label":"$param"}],"documentation":"1;\n# $Id: PullResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::PullResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::PullResultI - Bio::Search::Result::ResultI interface for\n                                  'pull' parsers\n\n=head1 SYNOPSIS\n\n    # This is an interface and cannot be instantiated\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                -file   => 't/data/hmmpfam.out');\n\n    my $result = $io->next_result;\n\n    while( $hit = $result->next_hit()) {\n        # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n    my $desc = $result->query_description();\n    my $dbname = $result->database_name();\n    my $size = $result->database_letters();\n    my $num_entries = $result->database_entries();\n    my $gap_ext = $result->get_parameter('gapext');\n    my @params = $result->available_parameters;\n    my $kappa = $result->get_statistic('kappa');\n    my @statnames = $result->available_statistics;\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\nPullResultI is for fast implementations that only do parsing work on the result\ndata when you actually request information by calling one of the ResultI\nmethods.\n\nMany methods of ResultI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullResult modules to\nbe created by (and have as a -parent) SearchIO modules written using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::PullResultI;\n\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\nuse base qw(Bio::PullParserI Bio::Search::Result::ResultI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hit => undef,\n                        num_hits => undef,\n                        hits => undef,\n                        no_hits_found => undef,\n                        query_name => undef,\n                        query_accession => undef,\n                        query_length => undef,\n                        query_description => undef  ) } );\n    \n    my ($parent, $chunk, $params, $stats) = $self->_rearrange([qw(PARENT\n                                                                  CHUNK\n                                                                  PARAMETERS\n                                                                  STATISTICS)],\n                                                              @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    if (defined $params) {\n        if (ref($params) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-parameters\");\n        }\n        while (my ($key,$value) = each %{$params}) {\n            $self->add_parameter($key, $value);\n        }\n    }\n    if (defined $stats) {\n        if (ref($stats) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-statistics\");\n        }\n        while (my ($key,$value) = each %{$stats}) {\n            $self->add_statistic($key, $value);\n        }\n    }\n}\n\n#\n# Some of these methods are written explitely to avoid ResultI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought all them.\n#\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n    return shift->get_field('next_hit');\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function.\n              Defaults to sort by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort()\n              function the user function must access Bio::Search::Result::ResultI namespace. \n              For example, use : \n              $result->sort_hits(sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t                 $Bio::Search::Result::ResultI::b->length});\n              NOT $result->sort_hits($a->length <=>$b->length);\n\n\n# In ResultI. subclasses will probably want to override since sort_hits normally\n# calls hits().\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    return shift->get_field('query_name');\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    return shift->get_field('query_accession');\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    return shift->get_field('query_length');\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    return shift->get_field('query_description');\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    return shift->get_field('database_name');\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\nsub database_letters {\n    return shift->get_field('database_letters');\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\nsub database_entries {\n    return shift->get_field('database_entries');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm {\n   return shift->get_field('algorithm');\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version {\n   return shift->get_field('algorithm_version');\n}\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : value of the literature reference for the algorithm\n Args    : newvalue (optional)\n Comments: The default implementation in ResultI returns an empty string\n           rather than throwing a NotImplemented exception, since\n           the ref may not always be available and is not critical.\n\n\nsub algorithm_reference {\n   my ($self) = @_;\n   return '';\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n\n\nsub num_hits {\n   return shift->get_field('num_hits');\n}\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the HitI objects contained within this Result\n Returns : Array of Bio::Search::Hit::HitI objects\n Args    : none\n\nSee Also: L<Bio::Search::Hit::HitI>\n\n\nsub hits {\n   return shift->get_field('hits');\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found();\n Function  : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the\n             parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Args      : none\n\n\nsub no_hits_found {\n    return shift->get_field('no_hits_found');\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   shift->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)"},"line":452,"range":{"start":{"line":452,"character":0},"end":{"line":457,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$param)","children":[{"name":"$self","localvar":"my","containerName":"get_parameter","kind":13,"line":453,"definition":"my"},{"line":453,"containerName":"get_parameter","kind":13,"name":"$param"},{"name":"$param","containerName":"get_parameter","kind":13,"line":454},{"containerName":"get_parameter","kind":13,"name":"$self","line":455},{"line":456,"containerName":"get_parameter","kind":13,"name":"$self"},{"kind":12,"containerName":"get_parameter","name":"get_parameter","line":456},{"name":"$param","containerName":"get_parameter","kind":13,"line":456}],"name":"get_parameter","containerName":"main::"},{"kind":12,"name":"_parameters","line":455},{"line":456,"kind":12,"name":"_parameters"},{"line":469,"kind":12,"range":{"end":{"line":473,"character":9999},"start":{"line":469,"character":0}},"children":[{"line":470,"localvar":"my","kind":13,"containerName":"available_parameters","name":"$self","definition":"my"},{"line":471,"kind":13,"containerName":"available_parameters","name":"$self"},{"line":472,"name":"$self","containerName":"available_parameters","kind":13},{"line":472,"containerName":"available_parameters","kind":12,"name":"available_parameters"}],"containerName":"main::","name":"available_parameters","definition":"sub"},{"name":"_parameters","kind":12,"line":471},{"line":472,"name":"_parameters","kind":12},{"name":"add_parameter","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"add_parameter","line":487,"definition":"my"},{"kind":13,"containerName":"add_parameter","name":"$key","line":487},{"name":"$value","kind":13,"containerName":"add_parameter","line":487},{"line":488,"kind":13,"containerName":"add_parameter","name":"$self"},{"line":489,"kind":13,"containerName":"add_parameter","name":"$self"},{"line":489,"name":"new","containerName":"add_parameter","kind":12},{"containerName":"add_parameter","kind":13,"name":"$self","line":491},{"line":491,"name":"set_parameter","kind":12,"containerName":"add_parameter"},{"name":"$key","containerName":"add_parameter","kind":13,"line":491},{"line":491,"kind":13,"containerName":"add_parameter","name":"$value"}],"detail":"($self,$key,$value)","definition":"sub","kind":12,"range":{"end":{"line":492,"character":9999},"start":{"line":486,"character":0}},"line":486,"signature":{"label":"add_parameter($self,$key,$value)","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}],"documentation":"1;\n# $Id: PullResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::PullResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::PullResultI - Bio::Search::Result::ResultI interface for\n                                  'pull' parsers\n\n=head1 SYNOPSIS\n\n    # This is an interface and cannot be instantiated\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                -file   => 't/data/hmmpfam.out');\n\n    my $result = $io->next_result;\n\n    while( $hit = $result->next_hit()) {\n        # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n    my $desc = $result->query_description();\n    my $dbname = $result->database_name();\n    my $size = $result->database_letters();\n    my $num_entries = $result->database_entries();\n    my $gap_ext = $result->get_parameter('gapext');\n    my @params = $result->available_parameters;\n    my $kappa = $result->get_statistic('kappa');\n    my @statnames = $result->available_statistics;\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\nPullResultI is for fast implementations that only do parsing work on the result\ndata when you actually request information by calling one of the ResultI\nmethods.\n\nMany methods of ResultI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullResult modules to\nbe created by (and have as a -parent) SearchIO modules written using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::PullResultI;\n\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\nuse base qw(Bio::PullParserI Bio::Search::Result::ResultI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hit => undef,\n                        num_hits => undef,\n                        hits => undef,\n                        no_hits_found => undef,\n                        query_name => undef,\n                        query_accession => undef,\n                        query_length => undef,\n                        query_description => undef  ) } );\n    \n    my ($parent, $chunk, $params, $stats) = $self->_rearrange([qw(PARENT\n                                                                  CHUNK\n                                                                  PARAMETERS\n                                                                  STATISTICS)],\n                                                              @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    if (defined $params) {\n        if (ref($params) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-parameters\");\n        }\n        while (my ($key,$value) = each %{$params}) {\n            $self->add_parameter($key, $value);\n        }\n    }\n    if (defined $stats) {\n        if (ref($stats) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-statistics\");\n        }\n        while (my ($key,$value) = each %{$stats}) {\n            $self->add_statistic($key, $value);\n        }\n    }\n}\n\n#\n# Some of these methods are written explitely to avoid ResultI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought all them.\n#\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n    return shift->get_field('next_hit');\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function.\n              Defaults to sort by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort()\n              function the user function must access Bio::Search::Result::ResultI namespace. \n              For example, use : \n              $result->sort_hits(sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t                 $Bio::Search::Result::ResultI::b->length});\n              NOT $result->sort_hits($a->length <=>$b->length);\n\n\n# In ResultI. subclasses will probably want to override since sort_hits normally\n# calls hits().\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    return shift->get_field('query_name');\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    return shift->get_field('query_accession');\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    return shift->get_field('query_length');\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    return shift->get_field('query_description');\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    return shift->get_field('database_name');\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\nsub database_letters {\n    return shift->get_field('database_letters');\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\nsub database_entries {\n    return shift->get_field('database_entries');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm {\n   return shift->get_field('algorithm');\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version {\n   return shift->get_field('algorithm_version');\n}\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : value of the literature reference for the algorithm\n Args    : newvalue (optional)\n Comments: The default implementation in ResultI returns an empty string\n           rather than throwing a NotImplemented exception, since\n           the ref may not always be available and is not critical.\n\n\nsub algorithm_reference {\n   my ($self) = @_;\n   return '';\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n\n\nsub num_hits {\n   return shift->get_field('num_hits');\n}\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the HitI objects contained within this Result\n Returns : Array of Bio::Search::Hit::HitI objects\n Args    : none\n\nSee Also: L<Bio::Search::Hit::HitI>\n\n\nsub hits {\n   return shift->get_field('hits');\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found();\n Function  : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the\n             parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Args      : none\n\n\nsub no_hits_found {\n    return shift->get_field('no_hits_found');\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   shift->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n    my ($self, $param) = @_;\n    $param || return;\n    return unless defined $self->{_parameters};\n    return $self->{_parameters}->get_parameter($param);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none\n\n\nsub available_parameters {\n    my $self = shift;\n    return () unless defined $self->{_parameters};\n    return $self->{_parameters}->available_parameters;\n}\n\n=head2 add_parameter\n\n Title   : add_parameter\n Usage   : $result->add_parameter('gapext', 11);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter"}},{"line":488,"name":"_parameters","kind":12},{"kind":12,"name":"_parameters","line":489},{"line":489,"name":"Bio","kind":12,"containerName":"Tools::Run::GenericParameters"},{"name":"_parameters","kind":12,"line":491},{"containerName":"main::","name":"get_statistic","children":[{"kind":13,"localvar":"my","containerName":"get_statistic","name":"$self","line":506,"definition":"my"},{"line":506,"name":"$stat","kind":13,"containerName":"get_statistic"},{"line":507,"name":"$stat","kind":13,"containerName":"get_statistic"},{"kind":13,"containerName":"get_statistic","name":"$self","line":508},{"line":509,"name":"$self","kind":13,"containerName":"get_statistic"},{"line":509,"name":"get_statistic","kind":12,"containerName":"get_statistic"},{"containerName":"get_statistic","kind":13,"name":"$stat","line":509}],"detail":"($self,$stat)","definition":"sub","kind":12,"range":{"end":{"line":510,"character":9999},"start":{"character":0,"line":505}},"line":505,"signature":{"documentation":"1;\n# $Id: PullResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::PullResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::PullResultI - Bio::Search::Result::ResultI interface for\n                                  'pull' parsers\n\n=head1 SYNOPSIS\n\n    # This is an interface and cannot be instantiated\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                -file   => 't/data/hmmpfam.out');\n\n    my $result = $io->next_result;\n\n    while( $hit = $result->next_hit()) {\n        # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n    my $desc = $result->query_description();\n    my $dbname = $result->database_name();\n    my $size = $result->database_letters();\n    my $num_entries = $result->database_entries();\n    my $gap_ext = $result->get_parameter('gapext');\n    my @params = $result->available_parameters;\n    my $kappa = $result->get_statistic('kappa');\n    my @statnames = $result->available_statistics;\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\nPullResultI is for fast implementations that only do parsing work on the result\ndata when you actually request information by calling one of the ResultI\nmethods.\n\nMany methods of ResultI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullResult modules to\nbe created by (and have as a -parent) SearchIO modules written using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::PullResultI;\n\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\nuse base qw(Bio::PullParserI Bio::Search::Result::ResultI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hit => undef,\n                        num_hits => undef,\n                        hits => undef,\n                        no_hits_found => undef,\n                        query_name => undef,\n                        query_accession => undef,\n                        query_length => undef,\n                        query_description => undef  ) } );\n    \n    my ($parent, $chunk, $params, $stats) = $self->_rearrange([qw(PARENT\n                                                                  CHUNK\n                                                                  PARAMETERS\n                                                                  STATISTICS)],\n                                                              @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    if (defined $params) {\n        if (ref($params) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-parameters\");\n        }\n        while (my ($key,$value) = each %{$params}) {\n            $self->add_parameter($key, $value);\n        }\n    }\n    if (defined $stats) {\n        if (ref($stats) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-statistics\");\n        }\n        while (my ($key,$value) = each %{$stats}) {\n            $self->add_statistic($key, $value);\n        }\n    }\n}\n\n#\n# Some of these methods are written explitely to avoid ResultI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought all them.\n#\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n    return shift->get_field('next_hit');\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function.\n              Defaults to sort by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort()\n              function the user function must access Bio::Search::Result::ResultI namespace. \n              For example, use : \n              $result->sort_hits(sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t                 $Bio::Search::Result::ResultI::b->length});\n              NOT $result->sort_hits($a->length <=>$b->length);\n\n\n# In ResultI. subclasses will probably want to override since sort_hits normally\n# calls hits().\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    return shift->get_field('query_name');\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    return shift->get_field('query_accession');\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    return shift->get_field('query_length');\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    return shift->get_field('query_description');\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    return shift->get_field('database_name');\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\nsub database_letters {\n    return shift->get_field('database_letters');\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\nsub database_entries {\n    return shift->get_field('database_entries');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm {\n   return shift->get_field('algorithm');\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version {\n   return shift->get_field('algorithm_version');\n}\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : value of the literature reference for the algorithm\n Args    : newvalue (optional)\n Comments: The default implementation in ResultI returns an empty string\n           rather than throwing a NotImplemented exception, since\n           the ref may not always be available and is not critical.\n\n\nsub algorithm_reference {\n   my ($self) = @_;\n   return '';\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n\n\nsub num_hits {\n   return shift->get_field('num_hits');\n}\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the HitI objects contained within this Result\n Returns : Array of Bio::Search::Hit::HitI objects\n Args    : none\n\nSee Also: L<Bio::Search::Hit::HitI>\n\n\nsub hits {\n   return shift->get_field('hits');\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found();\n Function  : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the\n             parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Args      : none\n\n\nsub no_hits_found {\n    return shift->get_field('no_hits_found');\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   shift->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n    my ($self, $param) = @_;\n    $param || return;\n    return unless defined $self->{_parameters};\n    return $self->{_parameters}->get_parameter($param);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none\n\n\nsub available_parameters {\n    my $self = shift;\n    return () unless defined $self->{_parameters};\n    return $self->{_parameters}->available_parameters;\n}\n\n=head2 add_parameter\n\n Title   : add_parameter\n Usage   : $result->add_parameter('gapext', 11);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter\n\n\nsub add_parameter {\n    my ($self, $key, $value) = @_;\n    unless (exists $self->{_parameters}) {\n        $self->{_parameters} = Bio::Tools::Run::GenericParameters->new();\n    }\n    $self->{_parameters}->set_parameter($key => $value);\n}\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $result->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this result\n Returns : string\n Args    : name of statistic (string)","parameters":[{"label":"$self"},{"label":"$stat"}],"label":"get_statistic($self,$stat)"}},{"line":508,"name":"_statistics","kind":12},{"line":509,"name":"_statistics","kind":12},{"range":{"start":{"character":0,"line":522},"end":{"character":9999,"line":526}},"kind":12,"line":522,"definition":"sub","name":"available_statistics","containerName":"main::","children":[{"definition":"my","containerName":"available_statistics","localvar":"my","kind":13,"name":"$self","line":523},{"containerName":"available_statistics","kind":13,"name":"$self","line":524},{"kind":13,"containerName":"available_statistics","name":"$self","line":525},{"containerName":"available_statistics","kind":12,"name":"available_statistics","line":525}]},{"name":"_statistics","kind":12,"line":524},{"line":525,"name":"_statistics","kind":12},{"definition":"sub","detail":"($self,$key,$value)","children":[{"line":540,"name":"$self","localvar":"my","containerName":"add_statistic","kind":13,"definition":"my"},{"line":540,"containerName":"add_statistic","kind":13,"name":"$key"},{"line":540,"name":"$value","containerName":"add_statistic","kind":13},{"line":541,"kind":13,"containerName":"add_statistic","name":"$self"},{"line":542,"kind":13,"containerName":"add_statistic","name":"$self"},{"name":"new","containerName":"add_statistic","kind":12,"line":542},{"name":"$self","kind":13,"containerName":"add_statistic","line":544},{"line":544,"name":"set_statistic","containerName":"add_statistic","kind":12},{"name":"$key","containerName":"add_statistic","kind":13,"line":544},{"name":"$value","containerName":"add_statistic","kind":13,"line":544}],"containerName":"main::","name":"add_statistic","signature":{"label":"add_statistic($self,$key,$value)","documentation":"1;\n# $Id: PullResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Result::PullResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::PullResultI - Bio::Search::Result::ResultI interface for\n                                  'pull' parsers\n\n=head1 SYNOPSIS\n\n    # This is an interface and cannot be instantiated\n\n    # typically one gets Results from a SearchIO stream\n    use Bio::SearchIO;\n    my $io = Bio::SearchIO->new(-format => 'hmmer_pull',\n                                -file   => 't/data/hmmpfam.out');\n\n    my $result = $io->next_result;\n\n    while( $hit = $result->next_hit()) {\n        # enter code here for hit processing\n    }\n\n    my $id = $result->query_name();\n    my $desc = $result->query_description();\n    my $dbname = $result->database_name();\n    my $size = $result->database_letters();\n    my $num_entries = $result->database_entries();\n    my $gap_ext = $result->get_parameter('gapext');\n    my @params = $result->available_parameters;\n    my $kappa = $result->get_statistic('kappa');\n    my @statnames = $result->available_statistics;\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\nPullResultI is for fast implementations that only do parsing work on the result\ndata when you actually request information by calling one of the ResultI\nmethods.\n\nMany methods of ResultI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullResult modules to\nbe created by (and have as a -parent) SearchIO modules written using\nPullParserI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::PullResultI;\n\nuse strict;\n\nuse Bio::Search::GenericStatistics;\nuse Bio::Tools::Run::GenericParameters;\n\nuse base qw(Bio::PullParserI Bio::Search::Result::ResultI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n    \n    # fields most subclasses probably will want\n    $self->_fields( { ( next_hit => undef,\n                        num_hits => undef,\n                        hits => undef,\n                        no_hits_found => undef,\n                        query_name => undef,\n                        query_accession => undef,\n                        query_length => undef,\n                        query_description => undef  ) } );\n    \n    my ($parent, $chunk, $params, $stats) = $self->_rearrange([qw(PARENT\n                                                                  CHUNK\n                                                                  PARAMETERS\n                                                                  STATISTICS)],\n                                                              @args);\n    $self->throw(\"Need -parent or -chunk to be defined\") unless $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n    if (defined $params) {\n        if (ref($params) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-parameters\");\n        }\n        while (my ($key,$value) = each %{$params}) {\n            $self->add_parameter($key, $value);\n        }\n    }\n    if (defined $stats) {\n        if (ref($stats) !~ /hash/i) {\n            $self->throw(\"Must specify a hash reference with the the parameter '-statistics\");\n        }\n        while (my ($key,$value) = each %{$stats}) {\n            $self->add_statistic($key, $value);\n        }\n    }\n}\n\n#\n# Some of these methods are written explitely to avoid ResultI throwing not\n# implemented; if it didn't do that then PullParserI AUTOLOAD would have\n# cought all them.\n#\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n    return shift->get_field('next_hit');\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits(\\&sort_function)\n Function\t: Sorts the available hit objects by a user-supplied function.\n              Defaults to sort by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort()\n              function the user function must access Bio::Search::Result::ResultI namespace. \n              For example, use : \n              $result->sort_hits(sub{$Bio::Search::Result::ResultI::a->length <=> \n\t\t\t\t\t                 $Bio::Search::Result::ResultI::b->length});\n              NOT $result->sort_hits($a->length <=>$b->length);\n\n\n# In ResultI. subclasses will probably want to override since sort_hits normally\n# calls hits().\n\n=head2 query_name\n\n Title   : query_name\n Usage   : $id = $result->query_name();\n Function: Get the string identifier of the query used by the\n           algorithm that performed the search.\n Returns : a string.\n Args    : none\n\n\nsub query_name {\n    return shift->get_field('query_name');\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : $id = $result->query_accession();\n Function: Get the accession (if available) for the query sequence\n Returns : a string\n Args    : none\n\n\nsub query_accession {\n    return shift->get_field('query_accession');\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $id = $result->query_length();\n Function: Get the length of the query sequence used in the search.\n Returns : a number\n Args    : none\n\n\nsub query_length {\n    return shift->get_field('query_length');\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : $id = $result->query_description();\n Function: Get the description of the query sequence\n           used in the search.\n Returns : a string\n Args    : none\n\n\nsub query_description {\n    return shift->get_field('query_description');\n}\n\n=head2 database_name\n\n Title   : database_name\n Usage   : $name = $result->database_name()\n Function: Used to obtain the name of the database that the query was searched\n           against by the algorithm.\n Returns : a scalar string\n Args    : none\n\n\nsub database_name {\n    return shift->get_field('database_name');\n}\n\n=head2 database_letters\n\n Title   : database_letters\n Usage   : $size = $result->database_letters()\n Function: Used to obtain the size of database that was searched against.\n Returns : a scalar integer (units specific to algorithm, but probably the\n           total number of residues in the database, if available) or undef if\n           the information was not available to the Processor object.\n Args    : none\n\n\nsub database_letters {\n    return shift->get_field('database_letters');\n}\n\n=head2 database_entries\n\n Title   : database_entries\n Usage   : $num_entries = $result->database_entries()\n Function: Used to obtain the number of entries contained in the database.\n Returns : a scalar integer representing the number of entities in the database\n           or undef if the information was not available.\n Args    : none\n\n\nsub database_entries {\n    return shift->get_field('database_entries');\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $result->algorithm\n Function: Obtain the name of the algorithm used to obtain the Result\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm {\n   return shift->get_field('algorithm');\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $r_version = $result->algorithm_version\n Function: Obtain the version of the algorithm used to obtain the Result\n Returns : string (e.g., 2.1.2)\n Args    : [optional] scalar string to set algorithm version value\n\n\nsub algorithm_version {\n   return shift->get_field('algorithm_version');\n}\n\n=head2 algorithm_reference\n\n Title   : algorithm_reference\n Usage   : $obj->algorithm_reference($newval)\n Function: \n Returns : value of the literature reference for the algorithm\n Args    : newvalue (optional)\n Comments: The default implementation in ResultI returns an empty string\n           rather than throwing a NotImplemented exception, since\n           the ref may not always be available and is not critical.\n\n\nsub algorithm_reference {\n   my ($self) = @_;\n   return '';\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n\n\nsub num_hits {\n   return shift->get_field('num_hits');\n}\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the HitI objects contained within this Result\n Returns : Array of Bio::Search::Hit::HitI objects\n Args    : none\n\nSee Also: L<Bio::Search::Hit::HitI>\n\n\nsub hits {\n   return shift->get_field('hits');\n}\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found();\n Function  : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the\n             parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Args      : none\n\n\nsub no_hits_found {\n    return shift->get_field('no_hits_found');\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind {\n   shift->throw_not_implemented();\n}\n\n=head2 get_parameter\n\n Title   : get_parameter\n Usage   : my $gap_ext = $result->get_parameter('gapext')\n Function: Returns the value for a specific parameter used\n           when running this result\n Returns : string\n Args    : name of parameter (string)\n\n\nsub get_parameter {\n    my ($self, $param) = @_;\n    $param || return;\n    return unless defined $self->{_parameters};\n    return $self->{_parameters}->get_parameter($param);\n}\n\n=head2 available_parameters\n\n Title   : available_parameters\n Usage   : my @params = $result->available_parameters\n Function: Returns the names of the available parameters\n Returns : Return list of available parameters used for this result\n Args    : none\n\n\nsub available_parameters {\n    my $self = shift;\n    return () unless defined $self->{_parameters};\n    return $self->{_parameters}->available_parameters;\n}\n\n=head2 add_parameter\n\n Title   : add_parameter\n Usage   : $result->add_parameter('gapext', 11);\n Function: Adds a parameter\n Returns : none\n Args    : key  - key value name for this parama\n           value - value for this parameter\n\n\nsub add_parameter {\n    my ($self, $key, $value) = @_;\n    unless (exists $self->{_parameters}) {\n        $self->{_parameters} = Bio::Tools::Run::GenericParameters->new();\n    }\n    $self->{_parameters}->set_parameter($key => $value);\n}\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : my $gap_ext = $result->get_statistic('kappa')\n Function: Returns the value for a specific statistic available \n           from this result\n Returns : string\n Args    : name of statistic (string)\n\n\nsub get_statistic {\n    my ($self, $stat) = @_;\n    $stat || return;\n    return unless defined $self->{_statistics};\n    return $self->{_statistics}->get_statistic($stat);\n}\n\n=head2 available_statistics\n\n Title   : available_statistics\n Usage   : my @statnames = $result->available_statistics\n Function: Returns the names of the available statistics\n Returns : Return list of available statistics used for this result\n Args    : none\n\n\nsub available_statistics {\n    my $self = shift;\n    return () unless defined $self->{_statistics};\n    return $self->{_statistics}->available_statistics;\n}\n\n=head2 add_statistic\n\n Title   : add_statistic\n Usage   : $result->add_statistic('lambda', 2.3);\n Function: Adds a statistic\n Returns : none\n Args    : key  - key value name for this statistic\n           value - value for this statistic","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}]},"line":539,"range":{"end":{"character":9999,"line":545},"start":{"character":0,"line":539}},"kind":12},{"line":541,"name":"_statistics","kind":12},{"line":542,"kind":12,"name":"_statistics"},{"name":"Bio","kind":12,"containerName":"Search::GenericStatistics","line":542},{"line":544,"kind":12,"name":"_statistics"}],"version":5}