{"version":5,"vars":[{"line":96,"name":"base","containerName":"","kind":2},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)","label":"new($class,@args)"},"line":112,"kind":12,"range":{"end":{"character":9999,"line":132},"start":{"line":112,"character":0}},"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":113,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"line":113,"containerName":"new","kind":13,"name":"@args"},{"name":"$self","kind":13,"localvar":"my","containerName":"new","line":115,"definition":"my"},{"line":115,"kind":13,"containerName":"new","name":"$class"},{"line":115,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","kind":13,"name":"$self","line":117},{"line":118,"kind":13,"containerName":"new","name":"$self"},{"line":119,"name":"$self","kind":13,"containerName":"new"},{"definition":"my","line":121,"kind":13,"localvar":"my","containerName":"new","name":"$iters"},{"containerName":"new","kind":13,"name":"$ithresh","line":121},{"line":121,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"_rearrange","line":121},{"line":122,"name":"@args","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":124},{"line":124,"containerName":"new","kind":13,"name":"$ithresh"},{"name":"$iters","kind":13,"containerName":"new","line":126},{"name":"$self","containerName":"new","kind":13,"line":127},{"line":127,"kind":12,"containerName":"new","name":"throw"},{"line":127,"containerName":"new","kind":13,"name":"$iters"},{"definition":"my","line":129,"containerName":"new","localvar":"my","kind":13,"name":"$i"},{"line":129,"kind":13,"containerName":"new","name":"$iters"},{"line":130,"kind":13,"containerName":"new","name":"$self"},{"line":130,"containerName":"new","kind":12,"name":"add_iteration"},{"line":130,"name":"$i","containerName":"new","kind":13}],"name":"new","containerName":"main::"},{"line":115,"containerName":"new","kind":12,"name":"SUPER"},{"containerName":null,"kind":13,"name":"%self","line":136},{"line":139,"kind":13,"containerName":null,"name":"$self"},{"definition":"sub","children":[{"line":162,"name":"$self","localvar":"my","containerName":"hits","kind":13,"definition":"my"},{"kind":13,"containerName":"hits","name":"$self","line":163},{"kind":13,"containerName":"hits","name":"$self","line":164},{"name":"@hits","containerName":"hits","localvar":"my","kind":13,"line":166,"definition":"my"},{"definition":"my","localvar":"my","containerName":"hits","kind":13,"name":"$it","line":167},{"name":"$self","kind":13,"containerName":"hits","line":167},{"line":167,"name":"iterations","containerName":"hits","kind":12},{"line":168,"name":"@hits","kind":13,"containerName":"hits"},{"line":168,"kind":13,"containerName":"hits","name":"$it"},{"containerName":"hits","kind":12,"name":"hits","line":168},{"line":170,"name":"@hits","kind":13,"containerName":"hits"}],"containerName":"main::","name":"hits","line":161,"range":{"end":{"character":9999,"line":171},"start":{"line":161,"character":0}},"kind":12},{"name":"SUPER","containerName":"hits","kind":12,"line":166},{"signature":{"label":"next_hit($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>"},"line":193,"kind":12,"range":{"end":{"line":206,"character":9999},"start":{"character":0,"line":193}},"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"next_hit","kind":13,"line":194},{"line":194,"containerName":"next_hit","kind":13,"name":"@args"},{"containerName":"next_hit","kind":13,"name":"$self","line":195},{"containerName":"next_hit","kind":13,"name":"$self","line":196},{"kind":13,"containerName":"next_hit","name":"@args","line":196},{"definition":"my","name":"$iter_index","localvar":"my","kind":13,"containerName":"next_hit","line":199},{"line":200,"containerName":"next_hit","kind":13,"name":"$self"},{"line":201,"kind":13,"containerName":"next_hit","name":"$iter_index"},{"line":201,"name":"$self","kind":13,"containerName":"next_hit"},{"line":201,"kind":13,"containerName":"next_hit","name":"$self"},{"line":201,"name":"_next_iteration_index","containerName":"next_hit","kind":12},{"kind":13,"containerName":"next_hit","name":"$iter_index","line":203},{"line":203,"name":"$self","containerName":"next_hit","kind":13},{"name":"$iter_index","kind":13,"containerName":"next_hit","line":206},{"kind":13,"containerName":"next_hit","name":"$self","line":206}],"name":"next_hit","containerName":"main::"},{"kind":12,"containerName":"next_hit","name":"SUPER","line":196},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$it","line":208},{"line":208,"name":"%self","containerName":null,"kind":13},{"name":"$iter_index","kind":13,"containerName":null,"line":208},{"line":209,"localvar":"my","containerName":null,"kind":13,"name":"$hit","definition":"my"},{"name":"%self","containerName":null,"kind":13,"line":209},{"line":209,"containerName":null,"kind":13,"name":"$it"},{"line":209,"kind":12,"containerName":"main::","name":"next_hit"},{"line":211,"kind":13,"containerName":null,"name":"$hit"},{"kind":13,"containerName":null,"name":"$hit","line":211},{"line":211,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"next_hit","line":211},{"name":"num_hits","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"num_hits","kind":13,"line":235,"definition":"my"},{"name":"$self","kind":13,"containerName":"num_hits","line":236},{"name":"$self","kind":13,"containerName":"num_hits","line":237},{"line":239,"name":"$self","containerName":"num_hits","kind":13},{"kind":13,"containerName":"num_hits","name":"$self","line":240},{"name":"throw","kind":12,"containerName":"num_hits","line":240},{"kind":13,"containerName":"num_hits","name":"$self","line":242},{"name":"hits","kind":12,"containerName":"num_hits","line":242}],"definition":"sub","range":{"start":{"character":0,"line":234},"end":{"line":243,"character":9999}},"kind":12,"line":234},{"kind":12,"containerName":"num_hits","name":"SUPER","line":239},{"signature":{"label":"add_hit($self,$hit)","parameters":[{"label":"$self"},{"label":"$hit"}],"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI"},"kind":12,"range":{"end":{"line":265,"character":9999},"start":{"line":255,"character":0}},"line":255,"detail":"($self,$hit)","definition":"sub","name":"add_hit","containerName":"main::","children":[{"definition":"my","line":256,"kind":13,"localvar":"my","containerName":"add_hit","name":"$self"},{"line":256,"name":"$hit","containerName":"add_hit","kind":13},{"line":257,"name":"$iter","localvar":"my","containerName":"add_hit","kind":13,"definition":"my"},{"line":257,"kind":13,"containerName":"add_hit","name":"$self"},{"name":"iteration","kind":12,"containerName":"add_hit","line":257},{"line":258,"containerName":"add_hit","kind":13,"name":"$hit"},{"kind":12,"containerName":"add_hit","name":"isa","line":258},{"line":259,"name":"$iter","containerName":"add_hit","kind":13},{"containerName":"add_hit","kind":12,"name":"add_hit","line":259},{"name":"$hit","containerName":"add_hit","kind":13,"line":259},{"line":261,"name":"$self","containerName":"add_hit","kind":13},{"line":261,"containerName":"add_hit","kind":12,"name":"throw"},{"containerName":"add_hit","kind":13,"name":"$hit","line":261},{"line":264,"containerName":"add_hit","kind":13,"name":"$iter"},{"line":264,"name":"num_hits","containerName":"add_hit","kind":12}]},{"children":[{"line":278,"localvar":"my","kind":13,"containerName":"add_iteration","name":"$self","definition":"my"},{"kind":13,"containerName":"add_iteration","name":"$i","line":278},{"line":279,"name":"$i","kind":13,"containerName":"add_iteration"},{"containerName":"add_iteration","kind":12,"name":"isa","line":279},{"line":280,"name":"$self","containerName":"add_iteration","kind":13},{"line":280,"name":"$i","containerName":"add_iteration","kind":13},{"line":281,"name":"$self","containerName":"add_iteration","kind":13}],"containerName":"main::","name":"add_iteration","definition":"sub","detail":"($self,$i)","line":277,"kind":12,"range":{"start":{"character":0,"line":277},"end":{"line":282,"character":9999}},"signature":{"label":"add_iteration($self,$i)","parameters":[{"label":"$self"},{"label":"$i"}],"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI"}},{"containerName":null,"kind":13,"name":"$self","line":283},{"name":"throw","containerName":"main::","kind":12,"line":283},{"line":283,"containerName":null,"kind":13,"name":"$i"},{"name":"%self","containerName":null,"kind":13,"line":286},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::Iteration::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given PSI-Blast iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none","label":"next_iteration($self)"},"range":{"end":{"character":9999,"line":308},"start":{"character":0,"line":301}},"kind":12,"line":301,"detail":"($self)","definition":"sub","name":"next_iteration","containerName":"main::","children":[{"definition":"my","line":302,"localvar":"my","kind":13,"containerName":"next_iteration","name":"$self"},{"name":"$self","kind":13,"containerName":"next_iteration","line":304},{"containerName":"next_iteration","kind":13,"name":"$self","line":305},{"containerName":"next_iteration","kind":13,"name":"$self","line":305},{"line":305,"name":"iterations","kind":12,"containerName":"next_iteration"},{"containerName":"next_iteration","kind":13,"name":"$self","line":306},{"containerName":"next_iteration","kind":13,"name":"$self","line":308}]},{"signature":{"label":"iteration($self,$num)","parameters":[{"label":"$self"},{"label":"$num"}],"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::Iteration::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given PSI-Blast iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1"},"kind":12,"range":{"end":{"character":9999,"line":326},"start":{"character":0,"line":324}},"line":324,"detail":"($self,$num)","definition":"sub","containerName":"main::","name":"iteration","children":[{"definition":"my","line":325,"name":"$self","localvar":"my","kind":13,"containerName":"iteration"},{"name":"$num","containerName":"iteration","kind":13,"line":325},{"line":326,"kind":13,"containerName":"iteration","name":"$num"},{"containerName":"iteration","kind":13,"name":"$self","line":326}]},{"kind":13,"containerName":null,"name":"$num","line":326},{"kind":13,"containerName":null,"name":"$num","line":327},{"line":327,"kind":13,"containerName":null,"name":"$num"},{"line":327,"name":"%self","containerName":null,"kind":13},{"line":328,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"throw","line":328},{"name":"$num","containerName":null,"kind":13,"line":330},{"line":332,"name":"%self","kind":13,"containerName":null},{"line":332,"name":"$num","containerName":null,"kind":13},{"line":344,"kind":12,"range":{"end":{"character":9999,"line":344},"start":{"line":344,"character":0}},"definition":"sub","children":[],"containerName":"main::","name":"num_iterations"},{"kind":12,"range":{"end":{"character":9999,"line":359},"start":{"line":359,"character":0}},"line":359,"definition":"sub","containerName":"main::","name":"number_of_iterations","children":[{"line":359,"kind":12,"containerName":"number_of_iterations","name":"num_iterations"}]},{"kind":12,"range":{"start":{"line":375,"character":0},"end":{"character":9999,"line":375}},"line":375,"containerName":"main::","name":"round","children":[{"line":375,"kind":12,"containerName":"round","name":"iteration"}],"definition":"sub"},{"line":388,"range":{"end":{"line":393,"character":9999},"start":{"line":388,"character":0}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$self","containerName":"iterations","localvar":"my","kind":13,"line":389},{"name":"@its","kind":13,"localvar":"my","containerName":"iterations","line":390,"definition":"my"},{"kind":13,"containerName":"iterations","name":"$self","line":391},{"line":392,"name":"@its","containerName":"iterations","kind":13},{"line":392,"name":"$self","containerName":"iterations","kind":13}],"name":"iterations","containerName":"main::"},{"name":"@its","kind":13,"containerName":null,"line":394},{"line":408,"range":{"start":{"line":408,"character":0},"end":{"line":415,"character":9999}},"kind":12,"signature":{"label":"psiblast($self,$val)","documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::Iteration::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given PSI-Blast iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\n Usage     : $num_iterations = $blast->number_of_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n Note      : Alias of L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\n Usage     : $round = $blast->round( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n Note      : Alias of L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 psiblast\n\n Usage     : if( $blast->psiblast ) { ... }\n Purpose   : Set/get a boolean indicator whether or not the report \n             is a PSI-BLAST report.\n Returns   : 1 if PSI-BLAST, undef if not.\n Argument  : 1 (when setting)","parameters":[{"label":"$self"},{"label":"$val"}]},"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"psiblast","kind":13,"line":410},{"name":"$val","kind":13,"containerName":"psiblast","line":410},{"line":411,"name":"$val","containerName":"psiblast","kind":13},{"containerName":"psiblast","kind":13,"name":"$self","line":412},{"line":414,"name":"$self","containerName":"psiblast","kind":13}],"name":"psiblast","containerName":"main::","definition":"sub","detail":"($self,$val)"},{"name":"no_hits_found","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"no_hits_found","kind":13,"line":440},{"line":440,"containerName":"no_hits_found","kind":13,"name":"$round"},{"line":442,"name":"$result","localvar":"my","kind":13,"containerName":"no_hits_found","definition":"my"},{"kind":13,"containerName":"no_hits_found","name":"$round","line":449},{"line":450,"containerName":"no_hits_found","kind":13,"name":"$self"},{"line":451,"name":"$result","kind":13,"containerName":"no_hits_found"},{"definition":"my","line":452,"containerName":"no_hits_found","localvar":"my","kind":13,"name":"$i"},{"name":"$self","kind":13,"containerName":"no_hits_found","line":452},{"line":453,"containerName":"no_hits_found","kind":13,"name":"$self"},{"line":454,"containerName":"no_hits_found","kind":13,"name":"$result"},{"line":460,"name":"$result","containerName":"no_hits_found","kind":13},{"name":"$self","kind":13,"containerName":"no_hits_found","line":460},{"name":"$result","containerName":"no_hits_found","kind":13,"line":464},{"line":464,"name":"$self","containerName":"no_hits_found","kind":13},{"line":467,"kind":13,"containerName":"no_hits_found","name":"$result"}],"detail":"($self,$round)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":439},"end":{"line":468,"character":9999}},"line":439,"signature":{"label":"no_hits_found($self,$round)","parameters":[{"label":"$self"},{"label":"$round"}],"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::Iteration::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given PSI-Blast iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\n Usage     : $num_iterations = $blast->number_of_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n Note      : Alias of L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\n Usage     : $round = $blast->round( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n Note      : Alias of L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 psiblast\n\n Usage     : if( $blast->psiblast ) { ... }\n Purpose   : Set/get a boolean indicator whether or not the report \n             is a PSI-BLAST report.\n Returns   : 1 if PSI-BLAST, undef if not.\n Argument  : 1 (when setting)\n\n\n#----------------\nsub psiblast {\n#----------------\n    my ($self, $val ) = @_;\n    if( $val ) {\n        $self->{'_psiblast'} = 1;\n    }\n    return $self->{'_psiblast'};\n}\n\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found( $iteration_number );\n Purpose   : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Argument  : (optional) integer indicating the iteration number (PSI-BLAST)\n             If iteration number is not specified and this is a PSI-BLAST result,\n             then this method will return true only if all iterations had\n             no hits found."}},{"signature":{"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::Iteration::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given PSI-Blast iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\n Usage     : $num_iterations = $blast->number_of_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n Note      : Alias of L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\n Usage     : $round = $blast->round( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n Note      : Alias of L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 psiblast\n\n Usage     : if( $blast->psiblast ) { ... }\n Purpose   : Set/get a boolean indicator whether or not the report \n             is a PSI-BLAST report.\n Returns   : 1 if PSI-BLAST, undef if not.\n Argument  : 1 (when setting)\n\n\n#----------------\nsub psiblast {\n#----------------\n    my ($self, $val ) = @_;\n    if( $val ) {\n        $self->{'_psiblast'} = 1;\n    }\n    return $self->{'_psiblast'};\n}\n\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found( $iteration_number );\n Purpose   : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Argument  : (optional) integer indicating the iteration number (PSI-BLAST)\n             If iteration number is not specified and this is a PSI-BLAST result,\n             then this method will return true only if all iterations had\n             no hits found.\n\n\nsub no_hits_found {\n    my ($self, $round) = @_;\n\n    my $result = 0;   # final return value of this method.\n    # Watch the double negative! \n    # result = 0 means \"yes hits were found\"\n    # result = 1 means \"no hits were found\" (for the indicated iteration or all iterations)\n\n    # If a iteration was not specified and there were multiple iterations,\n    # this method should return true only if all iterations had no hits found.\n    if( not defined $round ) {\n        if( $self->{'_iterations'} > 1) {\n            $result = 1;\n            foreach my $i( 1..$self->{'_iterations'} ) {\n                if( not defined $self->{\"_iteration_$i\"}->{'_no_hits_found'} ) {\n                    $result = 0;\n                    last;\n                }\n            }\n        }\n        else {\n            $result = $self->{\"_iteration_1\"}->{'_no_hits_found'};\n        }\n    }\n    else {\n        $result = $self->{\"_iteration_$round\"}->{'_no_hits_found'};\n    }\n\n    return $result;\n}\n\n\n=head2 set_no_hits_found\n\n Usage     : $blast->set_no_hits_found( $iteration_number ); \n Purpose   : Set boolean indicator indicating whether or not any hits\n             were present in the report.\n Returns   : n/a\n Argument  : (optional) integer indicating the iteration number (PSI-BLAST)","parameters":[{"label":"$self"},{"label":"$round"}],"label":"set_no_hits_found($self,$round)"},"line":481,"range":{"end":{"line":485,"character":9999},"start":{"line":481,"character":0}},"kind":12,"definition":"sub","detail":"($self,$round)","children":[{"definition":"my","line":482,"localvar":"my","containerName":"set_no_hits_found","kind":13,"name":"$self"},{"name":"$round","containerName":"set_no_hits_found","kind":13,"line":482},{"containerName":"set_no_hits_found","kind":13,"name":"$round","line":483},{"name":"$self","kind":13,"containerName":"set_no_hits_found","line":484}],"name":"set_no_hits_found","containerName":"main::"},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":495,"containerName":"_next_iteration_index","localvar":"my","kind":13,"name":"$self"},{"line":495,"kind":13,"containerName":"_next_iteration_index","name":"@args"},{"line":496,"kind":13,"containerName":"_next_iteration_index","name":"$self"}],"containerName":"main::","name":"_next_iteration_index","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: BlastResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Copyright Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastResult - Blast-specific subclass of Bio::Search::Result::GenericResult\n\n=head1 SYNOPSIS\n\n    # Working with iterations (PSI-BLAST results)\n\n    $result->next_iteration();\n    $result->num_iterations();\n    $result->iteration();\n    $result->iterations();\n\n# See Bio::Search::Result::GenericResult for information about working with Results.\n\n# See L<Bio::Search::Iteration::IterationI|Bio::Search::Iteration::IterationI>\n# for details about working with iterations.\n\n# TODO:\n#     * Show how to configure a SearchIO stream so that it generates\n#       BlastResult objects.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::Search::Result::GenericResult\nand provides some operations that facilitate working with BLAST\nand PSI-BLAST results.\n\nFor general information about working with Results, see \nBio::Search::Result::GenericResult.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz\n\nEmail sac@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Result::BlastResult;\nuse strict;\n\nuse Bio::Search::BlastStatistics;\n\nuse base qw(Bio::Search::Result::GenericResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Result::BlastResult->new();\n Function: Builds a new Bio::Search::Result::BlastResult object\n Returns : Bio::Search::Result::BlastResult\n Args    : See Bio::Search::Result::GenericResult();\n           The following parameters are specific to BlastResult:\n             -iterations  => array ref of Bio::Search::Iteration::IterationI objects\n             -inclusion_threshold => e-value threshold for inclusion in the\n                                     PSI-BLAST score matrix model (blastpgp)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'_iterations'} = [];\n  $self->{'_iteration_index'} = 0;\n  $self->{'_iteration_count'} = 0;\n\n  my( $iters, $ithresh ) = $self->_rearrange([qw(ITERATIONS\n                                                 INCLUSION_THRESHOLD)],@args);\n\n  $self->{'_inclusion_threshold'} = $ithresh;  # This is a read-only variable\n\n  if( defined $iters  ) {\n      $self->throw(\"Must define arrayref of Iterations when initializing a $class\\n\") unless ref($iters) =~ /array/i;\n\n      foreach my $i ( @{$iters} ) {\n          $self->add_iteration($i);\n      }\n  } \n  else {\n      # This shouldn't get called with the new SearchIO::blast.\n      print STDERR \"BlastResult::new(): Not adding iterations.\\n\";\n      $self->{'_no_iterations'} = 1;\n  }\n\n  return $self;\n}\n\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the available hits for this Result\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::hits> to\n           take into account the possibility of multiple iterations, as occurs\n           in PSI-BLAST reports.\n           If there are multiple iterations, all 'new' hits for all iterations\n           are returned. These are the hits that did not occur in a previous\n           iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::hits>\n\n\nsub hits {\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::hits;\n   }\n   my @hits = ();\n   foreach my $it ($self->iterations) {\n       push @hits, $it->hits;\n   }\n   return @hits;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::next_hit>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling next_hit() traverses the\n           all of the hits, old and new, for each iteration, calling next_hit()\n           on each iteration.\n\n           See Also: L<Bio::Search::Iteration::GenericIteration::next_hit>\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    if ($self->{'_no_iterations'}) {\n        return $self->SUPER::next_hit(@args);\n    }\n\n    my $iter_index;\n    if (not defined $self->{'_last_hit'}) {\n        $iter_index = $self->{'_iter_index'} = $self->_next_iteration_index;\n    } else {\n        $iter_index = $self->{'_iter_index'};\n    }\n\n    return if $iter_index >= scalar @{$self->{'_iterations'}};\n\n    my $it = $self->{'_iterations'}->[$iter_index];\n    my $hit = $self->{'_last_hit'} = $it->next_hit;\n\n    return defined($hit) ? $hit : $self->next_hit;\n}\n\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount= $result->num_hits\n Function: returns the number of hits for this query result\n Returns : integer\n Args    : none\n Note    : This method overrides L<Bio::Search::Result::GenericResult::num_hits>\n           to take into account the possibility of multiple iterations, as\n           occurs in PSI-BLAST reports.\n\n           If there are multiple iterations, calling num_hits() returns the\n           number of 'new' hits for each iteration. These are the hits that did\n           not occur in a previous iteration.\n\n           See Also: L<Bio::Search::Result::GenericResult::num_hits>\n\n\nsub num_hits{\n   my ($self) = shift;\n   if ($self->{'_no_iterations'}) {\n       return $self->SUPER::num_hits;\n   }\n   if (not defined $self->{'_iterations'}) {\n       $self->throw(\"Can't get Hits: data not collected.\");\n    }\n    return scalar( $self->hits );\n}\n\n=head2 add_hit\n\n Title   : add_hit\n Usage   : $report->add_hit($hit)\n Function: Adds a HitI to the stored list of hits\n Returns : Number of HitI currently stored\n Args    : Bio::Search::Hit::HitI\n\n\nsub add_hit {\n    my ($self,$hit) = @_;\n    my $iter = $self->iteration;\n    if( $hit->isa('Bio::Search::Hit::HitI') ) { \n\treturn $iter->add_hit(-hit => $hit);\n    } else { \n        $self->throw(\"Passed in a \" .ref($hit). \n                     \" as a Iteration which is not a Bio::Search::Hit::HitI.\");\n    }\n    return $iter->num_hits;\n}\n\n=head2 add_iteration\n\n Title   : add_iteration\n Usage   : $report->add_iteration($iteration)\n Function: Adds a IterationI to the stored list of iterations\n Returns : Number of IterationI currently stored\n Args    : Bio::Search::Iteration::IterationI\n\n\nsub add_iteration {\n    my ($self,$i) = @_;\n    if( $i->isa('Bio::Search::Iteration::IterationI') ) { \n        push @{$self->{'_iterations'}}, $i;\n        $self->{'_iteration_count'}++;\n    } else { \n        $self->throw(\"Passed in a \" .ref($i). \n                     \" as a Iteration which is not a Bio::Search::Iteration::IterationI.\");\n    }\n    return scalar @{$self->{'_iterations'}};\n}\n\n\n=head2 next_iteration\n\n Title   : next_iteration\n Usage   : while( $it = $result->next_iteration()) { ... }\n Function: Returns the next Iteration object, representing all hits\n           found within a given PSI-Blast iteration.\n Returns : a Bio::Search::Iteration::IterationI object or undef if there are no more.\n Args    : none\n\n\nsub next_iteration {\n    my ($self) = @_;\n\n   unless($self->{'_iter_queue_started'}) {\n       $self->{'_iter_queue'} = [$self->iterations()];\n       $self->{'_iter_queue_started'} = 1;\n   }\n   return shift @{$self->{'_iter_queue'}};\n}\n\n=head2 iteration\n\n Usage     : $iteration = $blast->iteration( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n\n\nsub iteration {\n    my ($self,$num) = @_;\n    $num = scalar @{$self->{'_iterations'}} unless defined $num;\n    unless ($num >= 1 and $num <= scalar $self->{'_iteration_count'}) {\n        $self->throw(-class=>'Bio::Root::NoSuchThing',\n                     -text=>\"No such iteration number: $num. Valid range=1-$self->{'_iteration_count'}\",\n                     -value=>$num);\n    }\n    return $self->{'_iterations'}->[$num-1];\n}\n\n=head2 num_iterations\n\n Usage     : $num_iterations = $blast->num_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n\n\nsub num_iterations { shift->{'_iteration_count'} }\n\n# Methods provided for consistency with BPpsilite.pm (now deprecated);\n# these are now merely synonyms\n\n=head2 number_of_iterations\n\n Usage     : $num_iterations = $blast->number_of_iterations; \n Purpose   : Get the number of iterations in the search result (PSI-BLAST).\n Returns   : Total number of iterations in the report\n Argument  : none (read-only)\n Note      : Alias of L<num_iterations>.\n\n\nsub number_of_iterations { shift->num_iterations }\n\n=head2 round\n\n Usage     : $round = $blast->round( $number );\n Purpose   : Get an IterationI object for the specified iteration\n             in the search result (PSI-BLAST).\n Returns   : Bio::Search::Iteration::IterationI object\n Throws    : Bio::Root::NoSuchThing exception if $number is not within \n             range of the number of iterations in this report.\n Argument  : integer (optional, if not specified get the last iteration)\n             First iteration = 1\n Note      : Alias of L<iteration>.\n\n\nsub round { shift->iteration(@_) }\n\n\n=head2 iterations\n\n Title   : iterations\n Usage   : my @iterations = $result->iterations\n Function: Returns the IterationI objects contained within this Result\n Returns : Array of L<Bio::Search::Iteration::IterationI> objects\n Args    : none\n\n\nsub iterations { \n    my $self = shift;\n    my @its = ();\n    if( ref($self->{'_iterations'}) =~ /ARRAY/i ) {\n       @its = @{$self->{'_iterations'}};\n    }\n    return @its;\n}\n\n=head2 psiblast\n\n Usage     : if( $blast->psiblast ) { ... }\n Purpose   : Set/get a boolean indicator whether or not the report \n             is a PSI-BLAST report.\n Returns   : 1 if PSI-BLAST, undef if not.\n Argument  : 1 (when setting)\n\n\n#----------------\nsub psiblast {\n#----------------\n    my ($self, $val ) = @_;\n    if( $val ) {\n        $self->{'_psiblast'} = 1;\n    }\n    return $self->{'_psiblast'};\n}\n\n\n=head2 no_hits_found\n\n Usage     : $nohits = $blast->no_hits_found( $iteration_number );\n Purpose   : Get boolean indicator indicating whether or not any hits\n             were present in the report.\n\n             This is NOT the same as determining the number of hits via\n             the hits() method, which will return zero hits if there were no\n             hits in the report or if all hits were filtered out during the parse.\n\n             Thus, this method can be used to distinguish these possibilities\n             for hitless reports generated when filtering.\n\n Returns   : Boolean\n Argument  : (optional) integer indicating the iteration number (PSI-BLAST)\n             If iteration number is not specified and this is a PSI-BLAST result,\n             then this method will return true only if all iterations had\n             no hits found.\n\n\nsub no_hits_found {\n    my ($self, $round) = @_;\n\n    my $result = 0;   # final return value of this method.\n    # Watch the double negative! \n    # result = 0 means \"yes hits were found\"\n    # result = 1 means \"no hits were found\" (for the indicated iteration or all iterations)\n\n    # If a iteration was not specified and there were multiple iterations,\n    # this method should return true only if all iterations had no hits found.\n    if( not defined $round ) {\n        if( $self->{'_iterations'} > 1) {\n            $result = 1;\n            foreach my $i( 1..$self->{'_iterations'} ) {\n                if( not defined $self->{\"_iteration_$i\"}->{'_no_hits_found'} ) {\n                    $result = 0;\n                    last;\n                }\n            }\n        }\n        else {\n            $result = $self->{\"_iteration_1\"}->{'_no_hits_found'};\n        }\n    }\n    else {\n        $result = $self->{\"_iteration_$round\"}->{'_no_hits_found'};\n    }\n\n    return $result;\n}\n\n\n=head2 set_no_hits_found\n\n Usage     : $blast->set_no_hits_found( $iteration_number ); \n Purpose   : Set boolean indicator indicating whether or not any hits\n             were present in the report.\n Returns   : n/a\n Argument  : (optional) integer indicating the iteration number (PSI-BLAST)\n\n\nsub set_no_hits_found {\n    my ($self, $round) = @_;\n    $round ||= 1;\n    $self->{\"_iteration_$round\"}->{'_no_hits_found'} = 1;\n}\n\n=head2 _next_iteration_index\n\n Title   : _next_iteration_index\n Usage   : private","label":"_next_iteration_index($self,@args)"},"line":494,"range":{"start":{"line":494,"character":0},"end":{"line":497,"character":9999}},"kind":12},{"range":{"start":{"character":0,"line":511},"end":{"line":518,"character":9999}},"kind":12,"line":511,"name":"rewind","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"rewind","name":"$self","line":512},{"name":"$self","kind":13,"containerName":"rewind","line":513},{"name":"$self","containerName":"rewind","kind":13,"line":514},{"kind":13,"containerName":"rewind","name":"$self","line":515},{"line":515,"name":"iterations","containerName":"rewind","kind":12},{"containerName":"rewind","kind":12,"name":"rewind","line":516}],"definition":"sub"},{"line":513,"containerName":"rewind","kind":12,"name":"SUPER"},{"name":"inclusion_threshold","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"inclusion_threshold","kind":13,"name":"$self","line":534},{"containerName":"inclusion_threshold","kind":13,"name":"$self","line":535}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":533},"end":{"character":9999,"line":536}},"line":533}]}