{"version":5,"vars":[{"line":252,"kind":2,"containerName":"","name":"base"},{"definition":"sub","detail":"($self,@args)","children":[{"line":266,"kind":13,"localvar":"my","containerName":"number","name":"$self","definition":"my"},{"name":"@args","kind":13,"containerName":"number","line":266},{"line":267,"containerName":"number","kind":13,"name":"$self"},{"name":"throw_not_implemented","containerName":"number","kind":12,"line":267}],"name":"number","containerName":"main::","signature":{"label":"number($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration","parameters":[{"label":"$self"},{"label":"@args"}]},"line":265,"kind":12,"range":{"end":{"character":9999,"line":268},"start":{"line":265,"character":0}}},{"definition":"sub","detail":"($self,@args)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"converged","line":281,"definition":"my"},{"line":281,"containerName":"converged","kind":13,"name":"@args"},{"name":"$self","kind":13,"containerName":"converged","line":282},{"line":282,"kind":12,"containerName":"converged","name":"throw_not_implemented"}],"containerName":"main::","name":"converged","signature":{"label":"converged($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration","parameters":[{"label":"$self"},{"label":"@args"}]},"line":280,"kind":12,"range":{"end":{"character":9999,"line":283},"start":{"character":0,"line":280}}},{"kind":12,"range":{"end":{"line":314,"character":9999},"start":{"character":0,"line":311}},"line":311,"signature":{"label":"next_hit($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration\n\n\nsub converged {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $iteration->next_hit( [$found_again]) ) { ... }\n Purpose : Iterates through all of the HitI objects\n           including new hits and old hits found in a previous iteration\n           and both below and above the inclusion threshold.\n           Corresponds to subset A in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<hits>, L<Classification of Hits>\n\nnext_hit() iterates through all hits, including the new ones\nfor this iteration and those found in previous iterations.\nYou can interrogate each hit using L<Bio::Search::Hit::HitI::found_again>\nto determine whether it is new or old.\n\nTo get just the new hits, use L<next_hit_new>.\nTo get just the old hits, use L<next_hit_old>."},"name":"next_hit","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"next_hit","line":312},{"name":"@args","kind":13,"containerName":"next_hit","line":312},{"line":313,"kind":13,"containerName":"next_hit","name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"next_hit","line":313}],"detail":"($self,@args)","definition":"sub"},{"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"next_hit_new","line":334},{"line":334,"containerName":"next_hit_new","kind":13,"name":"@args"},{"name":"$self","containerName":"next_hit_new","kind":13,"line":335},{"containerName":"next_hit_new","kind":12,"name":"throw_not_implemented","line":335}],"containerName":"main::","name":"next_hit_new","definition":"sub","detail":"($self,@args)","line":333,"range":{"start":{"line":333,"character":0},"end":{"character":9999,"line":336}},"kind":12,"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration\n\n\nsub converged {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $iteration->next_hit( [$found_again]) ) { ... }\n Purpose : Iterates through all of the HitI objects\n           including new hits and old hits found in a previous iteration\n           and both below and above the inclusion threshold.\n           Corresponds to subset A in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<hits>, L<Classification of Hits>\n\nnext_hit() iterates through all hits, including the new ones\nfor this iteration and those found in previous iterations.\nYou can interrogate each hit using L<Bio::Search::Hit::HitI::found_again>\nto determine whether it is new or old.\n\nTo get just the new hits, use L<next_hit_new>.\nTo get just the old hits, use L<next_hit_old>.\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_new\n\n Title   : next_hit_new\n Usage   : while( $hit = $iteration->next_hit_new() ) { ... }\n Purpose : Iterates through all newly found hits (did not occur in a\n           previous iteration) and are either below or above the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<newhits>, L<Classification of Hits>","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_hit_new($self,@args)"}},{"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration\n\n\nsub converged {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $iteration->next_hit( [$found_again]) ) { ... }\n Purpose : Iterates through all of the HitI objects\n           including new hits and old hits found in a previous iteration\n           and both below and above the inclusion threshold.\n           Corresponds to subset A in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<hits>, L<Classification of Hits>\n\nnext_hit() iterates through all hits, including the new ones\nfor this iteration and those found in previous iterations.\nYou can interrogate each hit using L<Bio::Search::Hit::HitI::found_again>\nto determine whether it is new or old.\n\nTo get just the new hits, use L<next_hit_new>.\nTo get just the old hits, use L<next_hit_old>.\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_new\n\n Title   : next_hit_new\n Usage   : while( $hit = $iteration->next_hit_new() ) { ... }\n Purpose : Iterates through all newly found hits (did not occur in a\n           previous iteration) and are either below or above the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<newhits>, L<Classification of Hits>\n\n\nsub next_hit_new {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_old\n\n Title   : next_hit_old\n Usage   : while( $hit = $iteration->next_hit_old() ) { ... }\n Purpose : Iterates through the Hit objects representing just the\n           hits that have been found in a previous iteration, whether\n           below or above the inclusion threshold.\n           Corresponds to subset C in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<oldhits>, L<Classification of Hits>","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_hit_old($self,@args)"},"line":356,"kind":12,"range":{"end":{"character":9999,"line":359},"start":{"line":356,"character":0}},"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"next_hit_old","kind":13,"line":357},{"line":357,"containerName":"next_hit_old","kind":13,"name":"@args"},{"name":"$self","containerName":"next_hit_old","kind":13,"line":358},{"containerName":"next_hit_old","kind":12,"name":"throw_not_implemented","line":358}],"containerName":"main::","name":"next_hit_old"},{"children":[{"line":375,"name":"$self","containerName":"num_hits","localvar":"my","kind":13,"definition":"my"},{"name":"@args","containerName":"num_hits","kind":13,"line":375},{"line":376,"containerName":"num_hits","kind":13,"name":"$self"},{"line":376,"name":"throw_not_implemented","kind":12,"containerName":"num_hits"}],"name":"num_hits","containerName":"main::","definition":"sub","detail":"($self,@args)","line":374,"range":{"end":{"character":9999,"line":377},"start":{"character":0,"line":374}},"kind":12,"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration\n\n\nsub converged {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $iteration->next_hit( [$found_again]) ) { ... }\n Purpose : Iterates through all of the HitI objects\n           including new hits and old hits found in a previous iteration\n           and both below and above the inclusion threshold.\n           Corresponds to subset A in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<hits>, L<Classification of Hits>\n\nnext_hit() iterates through all hits, including the new ones\nfor this iteration and those found in previous iterations.\nYou can interrogate each hit using L<Bio::Search::Hit::HitI::found_again>\nto determine whether it is new or old.\n\nTo get just the new hits, use L<next_hit_new>.\nTo get just the old hits, use L<next_hit_old>.\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_new\n\n Title   : next_hit_new\n Usage   : while( $hit = $iteration->next_hit_new() ) { ... }\n Purpose : Iterates through all newly found hits (did not occur in a\n           previous iteration) and are either below or above the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<newhits>, L<Classification of Hits>\n\n\nsub next_hit_new {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_old\n\n Title   : next_hit_old\n Usage   : while( $hit = $iteration->next_hit_old() ) { ... }\n Purpose : Iterates through the Hit objects representing just the\n           hits that have been found in a previous iteration, whether\n           below or above the inclusion threshold.\n           Corresponds to subset C in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<oldhits>, L<Classification of Hits>\n\n\nsub next_hit_old {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount_total = $iteration->num_hits\n Purpose : Returns the total number of hits for this query result, including new and old\n           below and above inclusion threshold.\n Returns : integer\n Args    : none\n\nSee Also: L<num_hits_new>, L<num_hits_old>, L<Classification of Hits>","parameters":[{"label":"$self"},{"label":"@args"}],"label":"num_hits($self,@args)"}},{"definition":"sub","detail":"($self,@args)","children":[{"line":399,"name":"$self","kind":13,"localvar":"my","containerName":"num_hits_new","definition":"my"},{"name":"@args","kind":13,"containerName":"num_hits_new","line":399},{"name":"$self","kind":13,"containerName":"num_hits_new","line":400},{"line":400,"containerName":"num_hits_new","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"num_hits_new","signature":{"label":"num_hits_new($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration\n\n\nsub converged {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $iteration->next_hit( [$found_again]) ) { ... }\n Purpose : Iterates through all of the HitI objects\n           including new hits and old hits found in a previous iteration\n           and both below and above the inclusion threshold.\n           Corresponds to subset A in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<hits>, L<Classification of Hits>\n\nnext_hit() iterates through all hits, including the new ones\nfor this iteration and those found in previous iterations.\nYou can interrogate each hit using L<Bio::Search::Hit::HitI::found_again>\nto determine whether it is new or old.\n\nTo get just the new hits, use L<next_hit_new>.\nTo get just the old hits, use L<next_hit_old>.\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_new\n\n Title   : next_hit_new\n Usage   : while( $hit = $iteration->next_hit_new() ) { ... }\n Purpose : Iterates through all newly found hits (did not occur in a\n           previous iteration) and are either below or above the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<newhits>, L<Classification of Hits>\n\n\nsub next_hit_new {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_old\n\n Title   : next_hit_old\n Usage   : while( $hit = $iteration->next_hit_old() ) { ... }\n Purpose : Iterates through the Hit objects representing just the\n           hits that have been found in a previous iteration, whether\n           below or above the inclusion threshold.\n           Corresponds to subset C in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<oldhits>, L<Classification of Hits>\n\n\nsub next_hit_old {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount_total = $iteration->num_hits\n Purpose : Returns the total number of hits for this query result, including new and old\n           below and above inclusion threshold.\n Returns : integer\n Args    : none\n\nSee Also: L<num_hits_new>, L<num_hits_old>, L<Classification of Hits>\n\n\nsub num_hits {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 num_hits_new\n\n Title   : num_hits_new\n Usage   : my $hitcount_new = $result->num_hits_new;\n         : my $hitcount_new_below_thresh = $result->num_hits_new( 1 );\n Purpose : Returns the number of new hits in this iteration that were not\n           found in a previous iteration and are either below or above the\n           the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : integer\n Args    : (optional) boolean, true if you want to get a count of just the new hits\n           that are below the inclusion threshold.\n\n\nSee Also: L<num_hits>, L<num_hits_old>, L<Classification of Hits>"},"line":398,"kind":12,"range":{"start":{"line":398,"character":0},"end":{"line":401,"character":9999}}},{"containerName":"main::","name":"num_hits_old","children":[{"definition":"my","line":422,"name":"$self","containerName":"num_hits_old","localvar":"my","kind":13},{"line":422,"kind":13,"containerName":"num_hits_old","name":"@args"},{"line":423,"name":"$self","containerName":"num_hits_old","kind":13},{"containerName":"num_hits_old","kind":12,"name":"throw_not_implemented","line":423}],"detail":"($self,@args)","definition":"sub","range":{"end":{"character":9999,"line":424},"start":{"character":0,"line":421}},"kind":12,"line":421,"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: IterationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Iteration::IterationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Iteration::IterationI - Abstract interface to an\niteration from an iterated search result, such as PSI-BLAST.\n\n=head1 SYNOPSIS\n\n    # Bio::Search::Iteration::IterationI objects cannot be \n    # instantiated since this module defines a pure interface.\n    # Given an object that implements the \n    # Bio::Search::Iteration::IterationI interface, \n    # you can do the following things with it:\n\n    # First, open up a SearchIO stream\n    use Bio::SearchIO;\n    my $file = shift or die \"Usage: $0 <BLAST-report-file>\\n\";\n    my $in = Bio::SearchIO->new(-format => 'blast',\n                               -file => $file # comment out this line to read STDIN\n                              );\n    # Iterate over all results in the input stream\n    while (my $result = $in->next_result) {\n\n        printf \"Result #%d: %s\\n\", $in->result_count, $result->to_string;\n        printf \"Total Iterations: %d\\n\", $result->num_iterations();\n\n        # Iterate over all iterations and process old and new hits\n        # separately.\n\n        while( my $it = $result->next_iteration) { \n            printf \"\\nIteration %d\\n\", $it->number;\n            printf \"Converged: %d\\n\", $it->converged;\n\n            # Print out the hits not found in previous iteration\n            printf \"New hits: %d\\n\", $it->num_hits_new;\n            while( my $hit = $it->next_hit_new ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n\n            # Print out the hits found in previous iteration\n            printf \"Old hits: %d\\n\", $it->num_hits_old; \n            while( my $hit = $it->next_hit_old ) {\n                printf \"  %s, Expect=%g\\n\", $hit->name, $hit->expect; \n            }\n        }\n        printf \"%s\\n\\n\", '-' x 50;\n    }\n\n    printf \"Total Reports processed: %d: %s\\n\", $in->result_count;\n\n    __END__\n\n    # NOTE: The following functionality is just proposed\n    # (does not yet exist but might, given sufficient hew and cry):\n\n    # Zero-in on the new hits found in last iteration.\n    # By default, iteration() returns the last one.\n\n    my $last_iteration = $result->iteration();\n    while( my $hit = $last_iteration->next_hit) {\n        # Do something with new hit...\n    }\n\n    # Get the first iteration\n\n    my $first_iteration = $result->iteration(1);\n\n\n=head1 DESCRIPTION\n\nBio::Search::Result::ResultI objects are data structures containing\nthe results from the execution of a search algorithm.  As such, it may\ncontain various algorithm specific information as well as details of\nthe execution, but will contain a few fundamental elements, including\nthe ability to return Bio::Search::Hit::HitI objects.\n\n=head2 Classification of Hits\n\nWithin a given iteration, the hits can be classified into a number of\nuseful subsets based on whether or not the hit appeard in a previous\niteration and whether or not the hit is below the threshold E-value\nfor inclusion in the score matrix model.\n\n                           All hits\n                             (A)\n               _______________|_________________\n               |                               |\n            New hits                        Old hits\n              (B)                             (C)\n      _________|________                _______|_________\n      |                |                |               |\n    Below            Above             Below          Above\n  threshold        threshold         threshold      threshold\n     (D)              (E)              (F)             (G)\n                               _________|___________\n                               |                   |\n                         Occurred in a         Occurred in a\n                         previous iteration    previous iteration\n                         below threshold       above threshold\n                              (H)                  (I)\n\nNotes: The term I<threshold> in the diagram and descriptions below\nrefer to this inclusion threshold. I<Below threshold> actually means\nI<at or below threshold>.\n\nThe IterationI interface defines a number of methods for extracting\nthese subsets of hits.\n\n=over 4\n\n* * newhits_below_threshold() [subset D]\n\nHits that did not appear in a previous iteration and are below\nthreshold in the current iteration.\n\n* * newhits_not_below_threshold() [subset E]\n\nHits that did not appear in a previous iteration and are not below\nthreshold in the current iteration.\n\n* * newhits() [subset B]\n\nAll newly found hits, below and above the inclusion threshold.  This\nis the union of newhits_below_threshold() + newhits_not_below_threshold()\n[subset D + subset E].\n\n* * oldhits_below_threshold() [subset H]\n\nHits that appeared in a previous iteration below threshold and are\nstill below threshold in the current iteration.\n\n* * oldhits_newly_below_threshold() [subset I]\n\nHits that appeared in a previous iteration above threshold but are\nbelow threshold in the current iteration. (Not applicable to the first\niteration.)\n\n* * oldhits_not_below_threshold() [subset G]\n\nHits that appeared in a previous iteration not below threshold and\nare still not below threshold in the current iteration.\n\n* * oldhits()  [subset C]\n\nAll hits that occured in a previous iteration, whether below or above\nthreshold in the current iteration. Union of oldhits_below_threshold()\n+ oldhits_newly_below_threshold() + oldhits_not_below_threshold()\n[subset H + subset I + subset G]. (Not applicable to the first\niteration.)\n\n* * hits_below_threshold() [subset D + subset F]\n\nAll hits, old and new, that are below the inclusion threshold in this\niteration. This is the union of newhits_below_threshold() +\noldhits_below_threshold() + oldhits_newly_below_threshold()\n[subset D + subset H + subset I].\n\n* * hits() [subset A]\n\nThe union of newhits() and oldhits() [subset B + subset C].\n\n\nFor the first iteration, the methods L<oldhits>, L<oldhits_below_threshold>,\nL<oldhits_newly_below_threshold>, and oldhits_not_below_threshold()\nwill return empty lists.\n\nIterator and numbers-of-hit methods are provided for subsets A, B, and C:\n\n=over 4\n\n* * next_hit_new(), num_hits_new() [subset B]\n\n* * next_hit_old(), num_hits_old() [subset C]\n\n* * next_hit(), num_hits() [subset A]\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Search::Iteration::IterationI;\n\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 number\n\n Title   : number\n Usage   : $it_number = $iteration->number();\n Purpose : returns the number of the iteration (a.k.a \"round\") \n           within the Result.\n Returns : integer\n Args    : [optional] integer to set the number of the iteration\n\n\nsub number {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 converged\n\n Title   : converged\n Usage   : $it_converged = $iteration->converged();\n Purpose : Indicates whether or not the iteration has converged \n Returns : boolean \n Args    : [optional] boolean value to set the converged of the iteration\n\n\nsub converged {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $iteration->next_hit( [$found_again]) ) { ... }\n Purpose : Iterates through all of the HitI objects\n           including new hits and old hits found in a previous iteration\n           and both below and above the inclusion threshold.\n           Corresponds to subset A in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<hits>, L<Classification of Hits>\n\nnext_hit() iterates through all hits, including the new ones\nfor this iteration and those found in previous iterations.\nYou can interrogate each hit using L<Bio::Search::Hit::HitI::found_again>\nto determine whether it is new or old.\n\nTo get just the new hits, use L<next_hit_new>.\nTo get just the old hits, use L<next_hit_old>.\n\n\nsub next_hit {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_new\n\n Title   : next_hit_new\n Usage   : while( $hit = $iteration->next_hit_new() ) { ... }\n Purpose : Iterates through all newly found hits (did not occur in a\n           previous iteration) and are either below or above the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<newhits>, L<Classification of Hits>\n\n\nsub next_hit_new {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 next_hit_old\n\n Title   : next_hit_old\n Usage   : while( $hit = $iteration->next_hit_old() ) { ... }\n Purpose : Iterates through the Hit objects representing just the\n           hits that have been found in a previous iteration, whether\n           below or above the inclusion threshold.\n           Corresponds to subset C in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : A Bio::Search::Hit::HitI object or undef if there are no more.\n           Hits will be returned in the order in which they occur in the report\n           unless otherwise specified.\n Args    : none\n\nSee Also: L<next_hit>, L<next_hit_old>, L<oldhits>, L<Classification of Hits>\n\n\nsub next_hit_old {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 num_hits\n\n Title   : num_hits\n Usage   : my $hitcount_total = $iteration->num_hits\n Purpose : Returns the total number of hits for this query result, including new and old\n           below and above inclusion threshold.\n Returns : integer\n Args    : none\n\nSee Also: L<num_hits_new>, L<num_hits_old>, L<Classification of Hits>\n\n\nsub num_hits {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 num_hits_new\n\n Title   : num_hits_new\n Usage   : my $hitcount_new = $result->num_hits_new;\n         : my $hitcount_new_below_thresh = $result->num_hits_new( 1 );\n Purpose : Returns the number of new hits in this iteration that were not\n           found in a previous iteration and are either below or above the\n           the inclusion threshold.\n           Corresponds to subset B in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : integer\n Args    : (optional) boolean, true if you want to get a count of just the new hits\n           that are below the inclusion threshold.\n\n\nSee Also: L<num_hits>, L<num_hits_old>, L<Classification of Hits>\n\n\nsub num_hits_new {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 num_hits_old\n\n Title   : num_hits_old\n Usage   : my $hitcount_old = $result->num_hits_old;\n         : my $hitcount_old_below_thresh = $result->num_hits_old( 1 );\n Purpose : Returns the number of new hits in this iteration that were\n           found in a previous iteration and are either below or above the\n           the inclusion threshold.\n           Corresponds to subset C in the \"Classification of Hits\"\n           documentation section of this module.\n Returns : integer\n Args    : (optional) boolean, true if you want to get a count of just the old hits\n           that are below the inclusion threshold.\n\nSee Also: L<num_hits>, L<num_hits_new>, L<Classification of Hits>","parameters":[{"label":"$self"},{"label":"@args"}],"label":"num_hits_old($self,@args)"}},{"definition":"sub","children":[{"containerName":"hits","kind":12,"name":"throw_not_implemented","line":443}],"name":"hits","containerName":"main::","line":443,"kind":12,"range":{"end":{"line":443,"character":9999},"start":{"character":0,"line":443}}},{"kind":12,"range":{"end":{"line":462,"character":9999},"start":{"line":462,"character":0}},"line":462,"definition":"sub","name":"newhits","containerName":"main::","children":[{"kind":12,"containerName":"newhits","name":"throw_not_implemented","line":462}]},{"line":481,"kind":12,"range":{"end":{"character":9999,"line":481},"start":{"character":0,"line":481}},"children":[{"containerName":"oldhits","kind":12,"name":"throw_not_implemented","line":481}],"name":"oldhits","containerName":"main::","definition":"sub"},{"line":500,"range":{"end":{"character":9999,"line":500},"start":{"line":500,"character":0}},"kind":12,"definition":"sub","children":[{"line":500,"name":"throw_not_implemented","kind":12,"containerName":"newhits_below_threshold"}],"name":"newhits_below_threshold","containerName":"main::"},{"definition":"sub","children":[{"kind":12,"containerName":"oldhits_below_threshold","name":"throw_not_implemented","line":519}],"name":"oldhits_below_threshold","containerName":"main::","line":519,"range":{"end":{"line":519,"character":9999},"start":{"character":0,"line":519}},"kind":12},{"children":[{"line":539,"name":"throw_not_implemented","containerName":"oldhits_newly_below_threshold","kind":12}],"name":"oldhits_newly_below_threshold","containerName":"main::","definition":"sub","line":539,"range":{"end":{"line":539,"character":9999},"start":{"character":0,"line":539}},"kind":12},{"children":[{"kind":12,"containerName":"oldhits_not_below_threshold","name":"throw_not_implemented","line":558}],"containerName":"main::","name":"oldhits_not_below_threshold","definition":"sub","line":558,"kind":12,"range":{"start":{"line":558,"character":0},"end":{"line":558,"character":9999}}},{"definition":"sub","containerName":"main::","name":"newhits_not_below_threshold","children":[{"containerName":"newhits_not_below_threshold","kind":12,"name":"throw_not_implemented","line":578}],"kind":12,"range":{"start":{"character":0,"line":578},"end":{"character":9999,"line":578}},"line":578},{"line":596,"kind":12,"range":{"end":{"character":9999,"line":596},"start":{"character":0,"line":596}},"definition":"sub","children":[{"kind":12,"containerName":"hits_below_threshold","name":"throw_not_implemented","line":596}],"name":"hits_below_threshold","containerName":"main::"},{"range":{"end":{"character":9999,"line":625},"start":{"character":0,"line":625}},"kind":12,"line":625,"definition":"sub","containerName":"main::","name":"add_hit","children":[{"containerName":"add_hit","kind":12,"name":"throw_not_implemented","line":625}]},{"name":"get_hit","containerName":"main::","children":[{"name":"throw_not_implemented","kind":12,"containerName":"get_hit","line":646}],"definition":"sub","kind":12,"range":{"end":{"line":646,"character":9999},"start":{"character":0,"line":646}},"line":646}]}