{"vars":[{"line":211,"containerName":"","kind":2,"name":"vars"},{"line":214,"name":"overload","kind":2,"containerName":""},{"kind":12,"name":"to_string","line":214},{"line":216,"name":"base","kind":2,"containerName":""},{"name":"new","containerName":"main::","children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":259},{"containerName":"new","kind":13,"name":"@args","line":259},{"line":260,"name":"$self","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":260},{"line":260,"kind":13,"containerName":"new","name":"@args"},{"name":"$raw_data","localvar":"my","containerName":"new","kind":13,"line":262,"definition":"my"},{"containerName":"new","kind":13,"name":"$signif","line":262},{"line":262,"name":"$is_pval","kind":13,"containerName":"new"},{"line":262,"containerName":"new","kind":13,"name":"$hold_raw"},{"containerName":"new","kind":13,"name":"$self","line":264},{"line":264,"kind":13,"containerName":"new","name":"$self"},{"line":264,"containerName":"new","kind":13,"name":"$raw_data"},{"line":264,"containerName":"new","kind":13,"name":"$hold_raw"},{"line":265,"kind":13,"containerName":"new","name":"$self"},{"name":"$self","kind":13,"containerName":"new","line":265},{"name":"$signif","kind":13,"containerName":"new","line":265},{"line":265,"kind":13,"containerName":"new","name":"$is_pval"},{"line":266,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":266},{"line":267,"name":"$self","kind":13,"containerName":"new"},{"line":267,"kind":12,"containerName":"new","name":"_rearrange"},{"line":276,"containerName":"new","kind":13,"name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":279},{"line":279,"containerName":"new","kind":12,"name":"_set_id"},{"name":"$raw_data","kind":13,"containerName":"new","line":279},{"name":"$is_pval","containerName":"new","kind":13,"line":281},{"line":282,"name":"$self","containerName":"new","kind":13},{"line":282,"containerName":"new","kind":13,"name":"$signif"},{"line":284,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"containerName":"new","name":"$signif","line":284},{"containerName":"new","kind":13,"name":"$hold_raw","line":287},{"line":288,"name":"$self","kind":13,"containerName":"new"},{"line":288,"kind":13,"containerName":"new","name":"$raw_data"},{"line":291,"kind":13,"containerName":"new","name":"$self"}],"detail":"($class,@args)","definition":"sub","range":{"start":{"character":0,"line":257},"end":{"line":292,"character":9999}},"kind":12,"line":257,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>","label":"new($class,@args)"}},{"name":"SUPER","kind":12,"containerName":"new","line":260},{"line":294,"kind":12,"range":{"end":{"character":9999,"line":297},"start":{"character":0,"line":294}},"children":[{"line":295,"name":"$self","localvar":"my","containerName":"DESTROY","kind":13,"definition":"my"}],"containerName":"main::","name":"DESTROY","definition":"sub"},{"detail":"($self,@args)","definition":"sub","name":"algorithm","containerName":"main::","children":[{"definition":"my","line":321,"name":"$self","containerName":"algorithm","localvar":"my","kind":13},{"containerName":"algorithm","kind":13,"name":"@args","line":321},{"name":"$self","containerName":"algorithm","kind":13,"line":322}],"signature":{"label":"algorithm($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"range":{"start":{"character":0,"line":319},"end":{"line":323,"character":9999}},"line":319},{"definition":"sub","children":[{"definition":"my","line":345,"name":"$self","containerName":"name","localvar":"my","kind":13},{"definition":"my","line":347,"name":"$name","kind":13,"localvar":"my","containerName":"name"},{"kind":13,"containerName":"name","name":"$name","line":348},{"containerName":"name","kind":13,"name":"$self","line":349},{"line":349,"kind":13,"containerName":"name","name":"$name"},{"line":351,"containerName":"name","kind":13,"name":"$self"}],"containerName":"main::","name":"name","line":343,"range":{"end":{"character":9999,"line":352},"start":{"character":0,"line":343}},"kind":12},{"signature":{"label":"description($self,$len)","parameters":[{"label":"$self"},{"label":"$len"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n'"},"kind":12,"range":{"start":{"line":372,"character":0},"end":{"character":9999,"line":377}},"line":372,"detail":"($self,$len)","definition":"sub","name":"description","containerName":"main::","children":[{"definition":"my","line":374,"kind":13,"localvar":"my","containerName":"description","name":"$self"},{"containerName":"description","kind":13,"name":"$len","line":374},{"name":"$len","kind":13,"containerName":"description","line":375},{"line":375,"containerName":"description","kind":13,"name":"$len"},{"name":"$len","kind":13,"containerName":"description","line":375},{"name":"$self","containerName":"description","kind":13,"line":375},{"kind":13,"containerName":"description","name":"$self","line":376},{"line":376,"name":"$len","kind":13,"containerName":"description"}]},{"line":375,"name":"CORE","containerName":"length","kind":12},{"containerName":"main::","name":"accession","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"accession","line":397},{"line":398,"name":"$self","containerName":"accession","kind":13},{"name":"$self","containerName":"accession","kind":13,"line":399}],"definition":"sub","kind":12,"range":{"start":{"line":395,"character":0},"end":{"line":400,"character":9999}},"line":395},{"line":416,"range":{"start":{"line":416,"character":0},"end":{"line":430,"character":9999}},"kind":12,"children":[{"localvar":"my","kind":13,"containerName":"raw_score","name":"$self","line":418,"definition":"my"},{"definition":"my","line":423,"name":"$score","containerName":"raw_score","localvar":"my","kind":13},{"name":"$self","kind":13,"containerName":"raw_score","line":424},{"line":425,"kind":13,"containerName":"raw_score","name":"$score"},{"kind":13,"containerName":"raw_score","name":"$self","line":425},{"line":425,"name":"hsp","kind":12,"containerName":"raw_score"},{"line":425,"name":"score","containerName":"raw_score","kind":12},{"line":427,"containerName":"raw_score","kind":13,"name":"$score"},{"name":"$self","containerName":"raw_score","kind":13,"line":427},{"name":"$score","containerName":"raw_score","kind":13,"line":429}],"name":"raw_score","containerName":"main::","definition":"sub"},{"line":449,"range":{"end":{"character":9999,"line":453},"start":{"line":449,"character":0}},"kind":12,"children":[{"line":451,"name":"$self","kind":13,"localvar":"my","containerName":"length","definition":"my"},{"line":452,"name":"$self","kind":13,"containerName":"length"}],"containerName":"main::","name":"length","definition":"sub"},{"line":462,"kind":12,"range":{"end":{"character":9999,"line":462},"start":{"line":462,"character":0}},"definition":"sub","children":[{"line":462,"kind":12,"containerName":"significance","name":"signif"}],"containerName":"main::","name":"significance"},{"definition":"sub","containerName":"main::","name":"next_hsp","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"next_hsp","line":480,"definition":"my"},{"line":482,"name":"$self","containerName":"next_hsp","kind":13},{"kind":13,"containerName":"next_hsp","name":"$self","line":483},{"containerName":"next_hsp","kind":13,"name":"$self","line":483},{"kind":12,"containerName":"next_hsp","name":"hsps","line":483},{"name":"$self","kind":13,"containerName":"next_hsp","line":484},{"line":486,"kind":13,"containerName":"next_hsp","name":"$self"}],"kind":12,"range":{"end":{"line":486,"character":9999},"start":{"line":478,"character":0}},"line":478},{"line":497,"kind":12,"range":{"start":{"character":0,"line":497},"end":{"line":501,"character":9999}},"definition":"sub","children":[{"line":499,"name":"$self","localvar":"my","containerName":"hit_name","kind":13,"definition":"my"},{"kind":13,"containerName":"hit_name","name":"$self","line":500},{"line":500,"containerName":"hit_name","kind":12,"name":"name"}],"name":"hit_name","containerName":"main::"},{"definition":"sub","containerName":"main::","name":"desc","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"desc","line":507,"definition":"my"},{"name":"$self","kind":13,"containerName":"desc","line":508},{"line":508,"containerName":"desc","kind":12,"name":"description"}],"range":{"start":{"line":505,"character":0},"end":{"character":9999,"line":509}},"kind":12,"line":505},{"kind":12,"range":{"start":{"character":0,"line":514},"end":{"line":518,"character":9999}},"line":514,"name":"hit_description","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"hit_description","line":516},{"line":517,"name":"$self","containerName":"hit_description","kind":13},{"line":517,"name":"description","containerName":"hit_description","kind":12}],"definition":"sub"},{"definition":"sub","children":[{"line":527,"containerName":"score","kind":12,"name":"raw_score"}],"name":"score","containerName":"main::","line":527,"kind":12,"range":{"start":{"character":0,"line":527},"end":{"line":527,"character":9999}}},{"name":"hit_length","containerName":"main::","children":[{"containerName":"hit_length","kind":12,"name":"length","line":539}],"definition":"sub","range":{"end":{"line":539,"character":9999},"start":{"line":539,"character":0}},"kind":12,"line":539},{"containerName":"main::","name":"signif","children":[{"name":"$self","containerName":"signif","localvar":"my","kind":13,"line":587,"definition":"my"},{"line":587,"kind":13,"containerName":"signif","name":"$fmt"},{"line":589,"name":"$val","localvar":"my","containerName":"signif","kind":13,"definition":"my"},{"kind":13,"containerName":"signif","name":"$self","line":589},{"kind":13,"containerName":"signif","name":"$self","line":589},{"kind":13,"containerName":"signif","name":"$self","line":589},{"line":592,"name":"$val","kind":13,"containerName":"signif"},{"line":592,"containerName":"signif","kind":13,"name":"$self"},{"kind":12,"containerName":"signif","name":"throw","line":592},{"name":"$val","kind":13,"containerName":"signif","line":594},{"line":594,"name":"$fmt","kind":13,"containerName":"signif"},{"line":594,"kind":13,"containerName":"signif","name":"$fmt"},{"line":596,"name":"$val","containerName":"signif","kind":13},{"line":596,"containerName":"signif","kind":13,"name":"$fmt"},{"name":"$val","kind":13,"containerName":"signif","line":597},{"line":597,"name":"$fmt","containerName":"signif","kind":13},{"kind":13,"containerName":"signif","name":"$val","line":600}],"detail":"($self,$fmt)","definition":"sub","range":{"start":{"character":0,"line":584},"end":{"character":9999,"line":601}},"kind":12,"line":584,"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>","parameters":[{"label":"$self"},{"label":"$fmt"}],"label":"signif($self,$fmt)"}},{"line":596,"containerName":"Search::BlastUtils::get_exponent","kind":12,"name":"Bio"},{"definition":"sub","name":"raw_hit_data","containerName":"main::","children":[{"definition":"my","line":606,"kind":13,"localvar":"my","containerName":"raw_hit_data","name":"$self"},{"definition":"my","name":"$data","containerName":"raw_hit_data","localvar":"my","kind":13,"line":607},{"line":609,"name":"$self","kind":13,"containerName":"raw_hit_data"}],"range":{"end":{"character":9999,"line":609},"start":{"line":604,"character":0}},"kind":12,"line":604},{"line":611,"name":"%data","containerName":null,"kind":13},{"line":614,"name":"$data","kind":13,"containerName":null},{"line":617,"kind":13,"containerName":null,"name":"$data"},{"line":633,"kind":12,"range":{"end":{"character":9999,"line":638},"start":{"line":633,"character":0}},"signature":{"label":"_set_length($self,$len)","parameters":[{"label":"$self"},{"label":"$len"}],"documentation":"=head2 _set_length\n\n Usage     : $hit_object->_set_length( \"233\" );\n Purpose   : Set the total length of the hit sequence.\n Example   : $hit_object->_set_length( $len );\n Returns   : n/a\n Argument  : Integer (only when setting). Any commas will be stripped out.\n Throws    : n/a\n\n=cut"},"children":[{"definition":"my","line":635,"name":"$self","localvar":"my","kind":13,"containerName":"_set_length"},{"kind":13,"containerName":"_set_length","name":"$len","line":635},{"line":636,"name":"$len","containerName":"_set_length","kind":13},{"kind":13,"containerName":"_set_length","name":"$self","line":637},{"name":"$len","containerName":"_set_length","kind":13,"line":637}],"containerName":"main::","name":"_set_length","definition":"sub","detail":"($self,$len)"},{"signature":{"label":"_set_description($self,@desc)","documentation":"=head2 _set_description\n\n Usage     : Private method; called automatically during construction\n Purpose   : Sets the description of the hit sequence.\n            : For sequence without descriptions, does not set any description.\n Argument  : Array containing description (multiple lines).\n Comments  : Processes the supplied description:\n                1. Join all lines into one string.\n                2. Remove sequence id at the beginning of description.\n                3. Removes junk charactes at begin and end of description.\n\n=cut","parameters":[{"label":"$self"},{"label":"@desc"}]},"range":{"end":{"character":9999,"line":676},"start":{"character":0,"line":654}},"kind":12,"line":654,"detail":"($self,@desc)","definition":"sub","name":"_set_description","containerName":"main::","children":[{"line":656,"name":"$self","containerName":"_set_description","localvar":"my","kind":13,"definition":"my"},{"line":656,"kind":13,"containerName":"_set_description","name":"@desc"},{"definition":"my","line":657,"name":"$desc","localvar":"my","containerName":"_set_description","kind":13},{"kind":13,"containerName":"_set_description","name":"$desc","line":661},{"line":661,"containerName":"_set_description","kind":13,"name":"@desc"},{"line":663,"containerName":"_set_description","localvar":"my","kind":13,"name":"$name","definition":"my"},{"line":663,"kind":13,"containerName":"_set_description","name":"$self"},{"line":663,"name":"name","containerName":"_set_description","kind":12},{"line":665,"containerName":"_set_description","kind":13,"name":"$desc"},{"line":666,"name":"$desc","containerName":"_set_description","kind":13},{"containerName":"_set_description","kind":13,"name":"$desc","line":668},{"line":669,"containerName":"_set_description","kind":13,"name":"$desc"},{"line":670,"containerName":"_set_description","kind":13,"name":"$desc"},{"line":671,"containerName":"_set_description","kind":13,"name":"$desc"},{"line":672,"kind":13,"containerName":"_set_description","name":"$self"},{"line":672,"kind":13,"containerName":"_set_description","name":"$desc"}]},{"definition":"sub","children":[{"line":696,"kind":13,"localvar":"my","containerName":"to_string","name":"$self","definition":"my"},{"kind":13,"containerName":"to_string","name":"$self","line":697},{"line":697,"containerName":"to_string","kind":12,"name":"name"},{"line":697,"name":"$self","containerName":"to_string","kind":13},{"containerName":"to_string","kind":12,"name":"description","line":697}],"containerName":"main::","name":"to_string","line":694,"range":{"start":{"character":0,"line":694},"end":{"character":9999,"line":698}},"kind":12},{"range":{"end":{"character":9999,"line":746},"start":{"line":720,"character":0}},"kind":12,"line":720,"signature":{"parameters":[{"label":"$self"},{"label":"$desc"}],"documentation":"=head2 _set_id\n\n Usage     : Private method; automatically called by new()\n Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n           : The identifier is assumed to be the first\n           : chunk of non-whitespace characters in the description line\n           : Does not assume any semantics in the structure of the identifier\n           : (Formerly, this method attempted to extract database name from\n           : the seq identifiers, but this was prone to break).\n Returns   : n/a\n Argument  : String containing description line of the hit from Blast report\n           : or first line of an alignment section (with or without the leading '>').\n Throws    : Warning if cannot locate sequence ID.\n\nSee Also   : L<new()|new>, L<accession()|accession>\n\n=cut","label":"_set_id($self,$desc)"},"name":"_set_id","containerName":"main::","children":[{"definition":"my","line":722,"localvar":"my","containerName":"_set_id","kind":13,"name":"$self"},{"line":722,"name":"$desc","kind":13,"containerName":"_set_id"},{"line":727,"containerName":"_set_id","kind":13,"name":"$desc"},{"name":"$name","localvar":"my","kind":13,"containerName":"_set_id","line":728,"definition":"my"},{"containerName":"_set_id","kind":13,"name":"$desc","line":728},{"line":729,"kind":13,"containerName":"_set_id","name":"$self"},{"kind":12,"containerName":"_set_id","name":"name","line":729},{"line":729,"name":"$name","containerName":"_set_id","kind":13},{"line":730,"containerName":"_set_id","kind":13,"name":"$self"},{"line":730,"name":"$desc","kind":13,"containerName":"_set_id"},{"definition":"my","line":737,"name":"@pieces","localvar":"my","containerName":"_set_id","kind":13},{"line":737,"kind":13,"containerName":"_set_id","name":"$name"},{"localvar":"my","kind":13,"containerName":"_set_id","name":"$acc","line":738,"definition":"my"},{"line":738,"name":"@pieces","containerName":"_set_id","kind":13},{"line":739,"kind":13,"containerName":"_set_id","name":"$self"},{"kind":12,"containerName":"_set_id","name":"accession","line":739},{"name":"$acc","containerName":"_set_id","kind":13,"line":739},{"containerName":"_set_id","kind":13,"name":"$self","line":742},{"line":742,"name":"warn","containerName":"_set_id","kind":12},{"name":"$desc","containerName":"_set_id","kind":13,"line":743},{"line":743,"name":"$desc","kind":13,"containerName":"_set_id"},{"line":744,"name":"$self","containerName":"_set_id","kind":13},{"containerName":"_set_id","kind":12,"name":"name","line":744},{"containerName":"_set_id","kind":13,"name":"$desc","line":744}],"detail":"($self,$desc)","definition":"sub"},{"line":773,"kind":12,"range":{"start":{"line":773,"character":0},"end":{"character":9999,"line":778}},"children":[{"line":775,"name":"$self","containerName":"ambiguous_aln","localvar":"my","kind":13,"definition":"my"},{"line":776,"name":"$self","kind":13,"containerName":"ambiguous_aln"},{"name":"$self","kind":13,"containerName":"ambiguous_aln","line":777}],"name":"ambiguous_aln","containerName":"main::","definition":"sub"},{"definition":"sub","children":[{"line":803,"name":"$self","localvar":"my","kind":13,"containerName":"overlap","definition":"my"},{"name":"$self","containerName":"overlap","kind":13,"line":804},{"line":805,"kind":13,"containerName":"overlap","name":"$self"},{"line":805,"containerName":"overlap","kind":13,"name":"$self"}],"containerName":"main::","name":"overlap","line":801,"range":{"end":{"line":806,"character":9999},"start":{"character":0,"line":801}},"kind":12},{"range":{"end":{"character":9999,"line":842},"start":{"line":828,"character":0}},"kind":12,"line":828,"definition":"sub","containerName":"main::","name":"bits","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"bits","name":"$self","line":830},{"definition":"my","line":835,"localvar":"my","kind":13,"containerName":"bits","name":"$bits"},{"name":"$self","kind":13,"containerName":"bits","line":836},{"containerName":"bits","kind":13,"name":"$bits","line":837},{"line":837,"kind":13,"containerName":"bits","name":"$self"},{"line":837,"name":"hsp","kind":12,"containerName":"bits"},{"name":"bits","kind":12,"containerName":"bits","line":837},{"containerName":"bits","kind":13,"name":"$bits","line":839},{"line":839,"containerName":"bits","kind":13,"name":"$self"},{"line":841,"kind":13,"containerName":"bits","name":"$bits"}]},{"definition":"sub","children":[{"definition":"my","containerName":"n","localvar":"my","kind":13,"name":"$self","line":871},{"localvar":"my","kind":13,"containerName":"n","name":"$n","line":876,"definition":"my"},{"kind":13,"containerName":"n","name":"$self","line":877},{"line":878,"kind":13,"containerName":"n","name":"$n"},{"line":878,"kind":13,"containerName":"n","name":"$self"},{"kind":12,"containerName":"n","name":"hsp","line":878},{"name":"n","containerName":"n","kind":12,"line":878},{"name":"$n","kind":13,"containerName":"n","line":880},{"line":880,"kind":13,"containerName":"n","name":"$self"},{"containerName":"n","kind":13,"name":"$n","line":882},{"line":882,"name":"$self","kind":13,"containerName":"n"},{"kind":12,"containerName":"n","name":"num_hsps","line":882},{"name":"$n","kind":13,"containerName":"n","line":884}],"containerName":"main::","name":"n","line":869,"range":{"start":{"character":0,"line":869},"end":{"line":885,"character":9999}},"kind":12},{"line":908,"range":{"start":{"character":0,"line":908},"end":{"character":9999,"line":924}},"kind":12,"children":[{"definition":"my","line":910,"localvar":"my","kind":13,"containerName":"frame","name":"$self"},{"containerName":"frame","kind":13,"name":"$self","line":912},{"name":"$self","kind":13,"containerName":"frame","line":912},{"line":917,"localvar":"my","containerName":"frame","kind":13,"name":"$frame","definition":"my"},{"containerName":"frame","kind":13,"name":"$self","line":918},{"name":"$frame","containerName":"frame","kind":13,"line":919},{"line":919,"containerName":"frame","kind":13,"name":"$self"},{"line":919,"name":"hsp","containerName":"frame","kind":12},{"kind":12,"containerName":"frame","name":"frame","line":919},{"line":921,"kind":13,"containerName":"frame","name":"$frame"},{"kind":13,"containerName":"frame","name":"$self","line":921},{"name":"$frame","kind":13,"containerName":"frame","line":923}],"name":"frame","containerName":"main::","definition":"sub"},{"kind":12,"containerName":"Search::BlastUtils::tile_hsps","name":"Bio","line":912},{"definition":"sub","detail":"($self,$fmt)","children":[{"kind":13,"localvar":"my","containerName":"p","name":"$self","line":961,"definition":"my"},{"kind":13,"containerName":"p","name":"$fmt","line":961},{"definition":"my","name":"$val","containerName":"p","localvar":"my","kind":13,"line":963},{"line":963,"containerName":"p","kind":13,"name":"$self"},{"line":966,"containerName":"p","kind":13,"name":"$val"},{"line":969,"name":"$self","containerName":"p","kind":13},{"line":969,"kind":12,"containerName":"p","name":"warn"},{"containerName":"p","kind":13,"name":"$val","line":970},{"line":970,"kind":13,"containerName":"p","name":"$self"},{"line":973,"kind":13,"containerName":"p","name":"$val"},{"line":973,"kind":13,"containerName":"p","name":"$fmt"},{"line":973,"name":"$fmt","kind":13,"containerName":"p"},{"containerName":"p","kind":13,"name":"$val","line":975},{"line":975,"name":"$fmt","containerName":"p","kind":13},{"line":976,"name":"$val","containerName":"p","kind":13},{"line":976,"name":"$fmt","kind":13,"containerName":"p"},{"line":979,"kind":13,"containerName":"p","name":"$val"}],"containerName":"main::","name":"p","signature":{"parameters":[{"label":"$self"},{"label":"$fmt"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-------------\nsub signif {\n#-------------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get P- or Expect value: HSPs may not have been set.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P/Expect-value.\n    return $val;\n}\n\n#----------------\nsub raw_hit_data {\n#----------------\n    my $self = shift;\n    my $data = '>';\n    # Need to add blank lines where we've removed them.\n    foreach( @{$self->{'_hit_data'}} ) {\n        if( $_ eq 'end') {\n            $data .= \"\\n\";\n        }\n        else {\n            $data .= /^\\s*(Score|Query)/ ? \"\\n$_\" : $_;\n        }\n    }\n    return $data;\n}\n\n\n#=head2 _set_length\n#\n# Usage     : $hit_object->_set_length( \"233\" );\n# Purpose   : Set the total length of the hit sequence.\n# Example   : $hit_object->_set_length( $len );\n# Returns   : n/a\n# Argument  : Integer (only when setting). Any commas will be stripped out.\n# Throws    : n/a\n#\n#=cut\n\n#-----------\nsub _set_length {\n#-----------\n    my ($self, $len) = @_;\n    $len =~ s/,//g; # get rid of commas\n    $self->{'_length'} = $len;\n}\n\n#=head2 _set_description\n#\n# Usage     : Private method; called automatically during construction\n# Purpose   : Sets the description of the hit sequence.\n#            : For sequence without descriptions, does not set any description.\n# Argument  : Array containing description (multiple lines).\n# Comments  : Processes the supplied description:\n#                1. Join all lines into one string.\n#                2. Remove sequence id at the beginning of description.\n#                3. Removes junk charactes at begin and end of description.\n#\n#=cut\n\n#--------------\nsub _set_description {\n#--------------\n    my( $self, @desc ) = @_;\n    my( $desc);\n\n#    print STDERR \"PsiBlastHit: RAW DESC:\\n@desc\\n\";\n\n    $desc = join(\" \", @desc);\n\n    my $name = $self->name;\n\n    if($desc) {\n        $desc =~ s/^\\s*\\S+\\s+//; # remove the sequence ID(s)\n                                 # This won't work if there's no description.\n        $desc =~ s/^\\s*$name//;  # ...but this should.\n        $desc =~ s/^[\\s!]+//;\n        $desc =~ s/ \\d+$//;\n        $desc =~ s/\\.+$//;\n        $self->{'_description'} = $desc;\n    }\n\n#    print STDERR \"PsiBlastHit: _set_description =  $desc\\n\";\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hit->to_string;\n Function: Returns a string representation for the Blast Hit.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHit] <name> <description>\n           e.g.:\n           [PsiBlastHit] emb|Z46660|SC9725 S.cerevisiae chromosome XIII cosmid\n Args    : None\n\n\n#----------------\nsub to_string {\n#----------------\n    my $self = shift;\n    return \"[PsiBlastHit] \" . $self->name . \" \" . $self->description;\n}\n\n\n#=head2 _set_id\n#\n# Usage     : Private method; automatically called by new()\n# Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n#           : The identifier is assumed to be the first\n#           : chunk of non-whitespace characters in the description line\n#           : Does not assume any semantics in the structure of the identifier\n#           : (Formerly, this method attempted to extract database name from\n#           : the seq identifiers, but this was prone to break).\n# Returns   : n/a\n# Argument  : String containing description line of the hit from Blast report\n#           : or first line of an alignment section (with or without the leading '>').\n# Throws    : Warning if cannot locate sequence ID.\n#\n#See Also   : L<new()|new>, L<accession()|accession>\n#\n#=cut\n\n#---------------\nsub _set_id {\n#---------------\n    my( $self, $desc ) = @_;\n\n    # New strategy: Assume only that the ID is the first white space\n    # delimited chunk. Not attempting to extract accession & database name.\n    # Clients will have to interpret it as necessary.\n    if($desc =~ /^>?(\\S+)\\s*(.*)/) {\n        my ($name, $desc) = ($1, $2);\n        $self->name($name);\n        $self->{'_description'} = $desc;\n        # Note that this description comes from the summary section of the\n        # BLAST report and so may be truncated. The full description will be\n        # set from the alignment section. We're setting description here in case\n        # the alignment section isn't being parsed.\n\n        # Assuming accession is delimited with | symbols (NCBI-style)\n        my @pieces = split(/\\|/,$name);\n        my $acc = pop @pieces;\n        $self->accession( $acc );\n    }\n    else {\n        $self->warn(\"Can't locate sequence identifier in summary line.\", \"Line = $desc\");\n        $desc = 'Unknown sequence ID' if not $desc;\n        $self->name($desc);\n    }\n}\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences\n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences\n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains\n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Status    : Experimental\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps>, L<HSP Tiling and Ambiguous Alignments>\n\n\n#--------------------\nsub ambiguous_aln {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n\n\n=head2 overlap\n\n Usage     : $blast_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $blast_object->overlap(5);\n           : $overlap = $blast_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by Bio::Search::BlastUtils::_adjust_contigs().\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap {\n#-------------\n    my $self = shift;\n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n\n\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the BLAST bit score of the best HSP for the current Blast hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if bit score is not set.\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits {\n#---------\n    my $self = shift;\n\n    # The check for $self->{'_bits'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($bits);\n    if(not defined($self->{'_bits'})) {\n        $bits = $self->hsp->bits;\n    } else {\n        $bits = $self->{'_bits'};\n    }\n    return $bits;\n}\n\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n {\n#-----\n    my $self = shift;\n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n        $n = $self->hsp->n;\n    } else {\n        $n = $self->{'_n'};\n    }\n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\n#----------'\nsub frame {\n#----------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'};\n    }\n    return $frame;\n}\n\n\n\n\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>","label":"p($self,$fmt)"},"line":958,"range":{"end":{"line":980,"character":9999},"start":{"line":958,"character":0}},"kind":12},{"line":975,"name":"Bio","kind":12,"containerName":"Search::BlastUtils::get_exponent"},{"signature":{"label":"expect($self,$fmt)","parameters":[{"label":"$self"},{"label":"$fmt"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-------------\nsub signif {\n#-------------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get P- or Expect value: HSPs may not have been set.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P/Expect-value.\n    return $val;\n}\n\n#----------------\nsub raw_hit_data {\n#----------------\n    my $self = shift;\n    my $data = '>';\n    # Need to add blank lines where we've removed them.\n    foreach( @{$self->{'_hit_data'}} ) {\n        if( $_ eq 'end') {\n            $data .= \"\\n\";\n        }\n        else {\n            $data .= /^\\s*(Score|Query)/ ? \"\\n$_\" : $_;\n        }\n    }\n    return $data;\n}\n\n\n#=head2 _set_length\n#\n# Usage     : $hit_object->_set_length( \"233\" );\n# Purpose   : Set the total length of the hit sequence.\n# Example   : $hit_object->_set_length( $len );\n# Returns   : n/a\n# Argument  : Integer (only when setting). Any commas will be stripped out.\n# Throws    : n/a\n#\n#=cut\n\n#-----------\nsub _set_length {\n#-----------\n    my ($self, $len) = @_;\n    $len =~ s/,//g; # get rid of commas\n    $self->{'_length'} = $len;\n}\n\n#=head2 _set_description\n#\n# Usage     : Private method; called automatically during construction\n# Purpose   : Sets the description of the hit sequence.\n#            : For sequence without descriptions, does not set any description.\n# Argument  : Array containing description (multiple lines).\n# Comments  : Processes the supplied description:\n#                1. Join all lines into one string.\n#                2. Remove sequence id at the beginning of description.\n#                3. Removes junk charactes at begin and end of description.\n#\n#=cut\n\n#--------------\nsub _set_description {\n#--------------\n    my( $self, @desc ) = @_;\n    my( $desc);\n\n#    print STDERR \"PsiBlastHit: RAW DESC:\\n@desc\\n\";\n\n    $desc = join(\" \", @desc);\n\n    my $name = $self->name;\n\n    if($desc) {\n        $desc =~ s/^\\s*\\S+\\s+//; # remove the sequence ID(s)\n                                 # This won't work if there's no description.\n        $desc =~ s/^\\s*$name//;  # ...but this should.\n        $desc =~ s/^[\\s!]+//;\n        $desc =~ s/ \\d+$//;\n        $desc =~ s/\\.+$//;\n        $self->{'_description'} = $desc;\n    }\n\n#    print STDERR \"PsiBlastHit: _set_description =  $desc\\n\";\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hit->to_string;\n Function: Returns a string representation for the Blast Hit.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHit] <name> <description>\n           e.g.:\n           [PsiBlastHit] emb|Z46660|SC9725 S.cerevisiae chromosome XIII cosmid\n Args    : None\n\n\n#----------------\nsub to_string {\n#----------------\n    my $self = shift;\n    return \"[PsiBlastHit] \" . $self->name . \" \" . $self->description;\n}\n\n\n#=head2 _set_id\n#\n# Usage     : Private method; automatically called by new()\n# Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n#           : The identifier is assumed to be the first\n#           : chunk of non-whitespace characters in the description line\n#           : Does not assume any semantics in the structure of the identifier\n#           : (Formerly, this method attempted to extract database name from\n#           : the seq identifiers, but this was prone to break).\n# Returns   : n/a\n# Argument  : String containing description line of the hit from Blast report\n#           : or first line of an alignment section (with or without the leading '>').\n# Throws    : Warning if cannot locate sequence ID.\n#\n#See Also   : L<new()|new>, L<accession()|accession>\n#\n#=cut\n\n#---------------\nsub _set_id {\n#---------------\n    my( $self, $desc ) = @_;\n\n    # New strategy: Assume only that the ID is the first white space\n    # delimited chunk. Not attempting to extract accession & database name.\n    # Clients will have to interpret it as necessary.\n    if($desc =~ /^>?(\\S+)\\s*(.*)/) {\n        my ($name, $desc) = ($1, $2);\n        $self->name($name);\n        $self->{'_description'} = $desc;\n        # Note that this description comes from the summary section of the\n        # BLAST report and so may be truncated. The full description will be\n        # set from the alignment section. We're setting description here in case\n        # the alignment section isn't being parsed.\n\n        # Assuming accession is delimited with | symbols (NCBI-style)\n        my @pieces = split(/\\|/,$name);\n        my $acc = pop @pieces;\n        $self->accession( $acc );\n    }\n    else {\n        $self->warn(\"Can't locate sequence identifier in summary line.\", \"Line = $desc\");\n        $desc = 'Unknown sequence ID' if not $desc;\n        $self->name($desc);\n    }\n}\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences\n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences\n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains\n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Status    : Experimental\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps>, L<HSP Tiling and Ambiguous Alignments>\n\n\n#--------------------\nsub ambiguous_aln {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n\n\n=head2 overlap\n\n Usage     : $blast_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $blast_object->overlap(5);\n           : $overlap = $blast_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by Bio::Search::BlastUtils::_adjust_contigs().\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap {\n#-------------\n    my $self = shift;\n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n\n\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the BLAST bit score of the best HSP for the current Blast hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if bit score is not set.\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits {\n#---------\n    my $self = shift;\n\n    # The check for $self->{'_bits'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($bits);\n    if(not defined($self->{'_bits'})) {\n        $bits = $self->hsp->bits;\n    } else {\n        $bits = $self->{'_bits'};\n    }\n    return $bits;\n}\n\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n {\n#-----\n    my $self = shift;\n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n        $n = $self->hsp->n;\n    } else {\n        $n = $self->{'_n'};\n    }\n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\n#----------'\nsub frame {\n#----------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'};\n    }\n    return $frame;\n}\n\n\n\n\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p {\n#--------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(not defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using expect() instead.\");\n        $val = $self->{'_expect'};\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n\n\n=head2 expect\n\n Usage     : $hit_object->expect( [format] );\n Purpose   : Get the Expect value for the best HSP of the given BLAST hit.\n Example   : $e =  $sbjct->expect;\n           : $e =  $sbjct->expect('exp');  # get exponent only.\n           : ($num, $exp) = $sbjct->expect('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and Expect\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : Exception if the Expect value is not defined.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>"},"line":1011,"kind":12,"range":{"start":{"character":0,"line":1011},"end":{"character":9999,"line":1044}},"definition":"sub","detail":"($self,$fmt)","children":[{"line":1014,"localvar":"my","containerName":"expect","kind":13,"name":"$self","definition":"my"},{"name":"$fmt","kind":13,"containerName":"expect","line":1014},{"definition":"my","line":1016,"name":"$val","kind":13,"localvar":"my","containerName":"expect"},{"containerName":"expect","kind":13,"name":"$self","line":1021},{"containerName":"expect","kind":13,"name":"$self","line":1022},{"name":"$self","containerName":"expect","kind":13,"line":1023},{"containerName":"expect","kind":13,"name":"$val","line":1023},{"line":1023,"containerName":"expect","kind":13,"name":"$self"},{"line":1023,"name":"hsp","kind":12,"containerName":"expect"},{"kind":12,"containerName":"expect","name":"expect","line":1023},{"line":1028,"name":"$self","containerName":"expect","kind":13},{"line":1028,"kind":12,"containerName":"expect","name":"throw"},{"name":"$val","kind":13,"containerName":"expect","line":1031},{"line":1031,"name":"$self","kind":13,"containerName":"expect"},{"line":1035,"kind":13,"containerName":"expect","name":"$val"},{"containerName":"expect","kind":13,"name":"$self","line":1035},{"name":"throw","containerName":"expect","kind":12,"line":1035},{"line":1037,"name":"$val","kind":13,"containerName":"expect"},{"containerName":"expect","kind":13,"name":"$fmt","line":1037},{"line":1037,"kind":13,"containerName":"expect","name":"$fmt"},{"line":1039,"kind":13,"containerName":"expect","name":"$val"},{"line":1039,"name":"$fmt","containerName":"expect","kind":13},{"line":1040,"kind":13,"containerName":"expect","name":"$val"},{"line":1040,"containerName":"expect","kind":13,"name":"$fmt"},{"line":1043,"name":"$val","containerName":"expect","kind":13}],"name":"expect","containerName":"main::"},{"containerName":"Search::BlastUtils::get_exponent","kind":12,"name":"Bio","line":1039},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"hsps","line":1067,"definition":"my"},{"line":1069,"name":"$self","kind":13,"containerName":"hsps"},{"line":1070,"name":"$self","kind":13,"containerName":"hsps"},{"containerName":"hsps","kind":12,"name":"throw","line":1070},{"name":"$self","containerName":"hsps","kind":13,"line":1075}],"containerName":"main::","name":"hsps","definition":"sub","line":1065,"kind":12,"range":{"end":{"character":9999,"line":1075},"start":{"line":1065,"character":0}}},{"line":1077,"kind":13,"containerName":null,"name":"%self"},{"range":{"start":{"line":1102,"character":0},"end":{"line":1111,"character":9999}},"kind":12,"line":1102,"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-------------\nsub signif {\n#-------------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get P- or Expect value: HSPs may not have been set.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P/Expect-value.\n    return $val;\n}\n\n#----------------\nsub raw_hit_data {\n#----------------\n    my $self = shift;\n    my $data = '>';\n    # Need to add blank lines where we've removed them.\n    foreach( @{$self->{'_hit_data'}} ) {\n        if( $_ eq 'end') {\n            $data .= \"\\n\";\n        }\n        else {\n            $data .= /^\\s*(Score|Query)/ ? \"\\n$_\" : $_;\n        }\n    }\n    return $data;\n}\n\n\n#=head2 _set_length\n#\n# Usage     : $hit_object->_set_length( \"233\" );\n# Purpose   : Set the total length of the hit sequence.\n# Example   : $hit_object->_set_length( $len );\n# Returns   : n/a\n# Argument  : Integer (only when setting). Any commas will be stripped out.\n# Throws    : n/a\n#\n#=cut\n\n#-----------\nsub _set_length {\n#-----------\n    my ($self, $len) = @_;\n    $len =~ s/,//g; # get rid of commas\n    $self->{'_length'} = $len;\n}\n\n#=head2 _set_description\n#\n# Usage     : Private method; called automatically during construction\n# Purpose   : Sets the description of the hit sequence.\n#            : For sequence without descriptions, does not set any description.\n# Argument  : Array containing description (multiple lines).\n# Comments  : Processes the supplied description:\n#                1. Join all lines into one string.\n#                2. Remove sequence id at the beginning of description.\n#                3. Removes junk charactes at begin and end of description.\n#\n#=cut\n\n#--------------\nsub _set_description {\n#--------------\n    my( $self, @desc ) = @_;\n    my( $desc);\n\n#    print STDERR \"PsiBlastHit: RAW DESC:\\n@desc\\n\";\n\n    $desc = join(\" \", @desc);\n\n    my $name = $self->name;\n\n    if($desc) {\n        $desc =~ s/^\\s*\\S+\\s+//; # remove the sequence ID(s)\n                                 # This won't work if there's no description.\n        $desc =~ s/^\\s*$name//;  # ...but this should.\n        $desc =~ s/^[\\s!]+//;\n        $desc =~ s/ \\d+$//;\n        $desc =~ s/\\.+$//;\n        $self->{'_description'} = $desc;\n    }\n\n#    print STDERR \"PsiBlastHit: _set_description =  $desc\\n\";\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hit->to_string;\n Function: Returns a string representation for the Blast Hit.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHit] <name> <description>\n           e.g.:\n           [PsiBlastHit] emb|Z46660|SC9725 S.cerevisiae chromosome XIII cosmid\n Args    : None\n\n\n#----------------\nsub to_string {\n#----------------\n    my $self = shift;\n    return \"[PsiBlastHit] \" . $self->name . \" \" . $self->description;\n}\n\n\n#=head2 _set_id\n#\n# Usage     : Private method; automatically called by new()\n# Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n#           : The identifier is assumed to be the first\n#           : chunk of non-whitespace characters in the description line\n#           : Does not assume any semantics in the structure of the identifier\n#           : (Formerly, this method attempted to extract database name from\n#           : the seq identifiers, but this was prone to break).\n# Returns   : n/a\n# Argument  : String containing description line of the hit from Blast report\n#           : or first line of an alignment section (with or without the leading '>').\n# Throws    : Warning if cannot locate sequence ID.\n#\n#See Also   : L<new()|new>, L<accession()|accession>\n#\n#=cut\n\n#---------------\nsub _set_id {\n#---------------\n    my( $self, $desc ) = @_;\n\n    # New strategy: Assume only that the ID is the first white space\n    # delimited chunk. Not attempting to extract accession & database name.\n    # Clients will have to interpret it as necessary.\n    if($desc =~ /^>?(\\S+)\\s*(.*)/) {\n        my ($name, $desc) = ($1, $2);\n        $self->name($name);\n        $self->{'_description'} = $desc;\n        # Note that this description comes from the summary section of the\n        # BLAST report and so may be truncated. The full description will be\n        # set from the alignment section. We're setting description here in case\n        # the alignment section isn't being parsed.\n\n        # Assuming accession is delimited with | symbols (NCBI-style)\n        my @pieces = split(/\\|/,$name);\n        my $acc = pop @pieces;\n        $self->accession( $acc );\n    }\n    else {\n        $self->warn(\"Can't locate sequence identifier in summary line.\", \"Line = $desc\");\n        $desc = 'Unknown sequence ID' if not $desc;\n        $self->name($desc);\n    }\n}\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences\n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences\n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains\n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Status    : Experimental\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps>, L<HSP Tiling and Ambiguous Alignments>\n\n\n#--------------------\nsub ambiguous_aln {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n\n\n=head2 overlap\n\n Usage     : $blast_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $blast_object->overlap(5);\n           : $overlap = $blast_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by Bio::Search::BlastUtils::_adjust_contigs().\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap {\n#-------------\n    my $self = shift;\n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n\n\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the BLAST bit score of the best HSP for the current Blast hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if bit score is not set.\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits {\n#---------\n    my $self = shift;\n\n    # The check for $self->{'_bits'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($bits);\n    if(not defined($self->{'_bits'})) {\n        $bits = $self->hsp->bits;\n    } else {\n        $bits = $self->{'_bits'};\n    }\n    return $bits;\n}\n\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n {\n#-----\n    my $self = shift;\n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n        $n = $self->hsp->n;\n    } else {\n        $n = $self->{'_n'};\n    }\n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\n#----------'\nsub frame {\n#----------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'};\n    }\n    return $frame;\n}\n\n\n\n\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p {\n#--------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(not defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using expect() instead.\");\n        $val = $self->{'_expect'};\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n\n\n=head2 expect\n\n Usage     : $hit_object->expect( [format] );\n Purpose   : Get the Expect value for the best HSP of the given BLAST hit.\n Example   : $e =  $sbjct->expect;\n           : $e =  $sbjct->expect('exp');  # get exponent only.\n           : ($num, $exp) = $sbjct->expect('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and Expect\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : Exception if the Expect value is not defined.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-----------\nsub expect {\n#-----------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val;\n\n    # For Blast reports that list the P value on the description line,\n    # getting the expect value requires fully parsing the HSP data.\n    # For NCBI blast, there's no problem.\n    if(not defined($self->{'_expect'})) {\n        if( defined $self->{'_hsps'}) {\n            $self->{'_expect'} = $val = $self->hsp->expect;\n        } else {\n            # If _expect is not set and _hsps are not set,\n            # then this must be a P-value-based report that was\n            # run without setting the HSPs (shallow parsing).\n            $self->throw(\"Can't get expect value. HSPs have not been set.\");\n        }\n    } else {\n        $val = $self->{'_expect'};\n    }\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get Expect value.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw Expect-value.\n    return $val;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return wantarray\n        #  returning list containing all HSPs.\n        ? @{$self->{'_hsps'}}\n        #  returning number of HSPs.\n        : scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single BlastHSP.pm object for the present PsiBlastHit.pm object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()","parameters":[{"label":"$self"},{"label":"$option"}],"label":"hsp($self,$option)"},"containerName":"main::","name":"hsp","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"hsp","kind":13,"line":1104},{"line":1104,"containerName":"hsp","kind":13,"name":"$option"},{"kind":13,"containerName":"hsp","name":"$option","line":1105},{"name":"$self","kind":13,"containerName":"hsp","line":1107},{"containerName":"hsp","kind":13,"name":"$self","line":1108},{"line":1108,"name":"throw","containerName":"hsp","kind":12},{"line":1111,"containerName":"hsp","localvar":"my","kind":13,"name":"@hsps","definition":"my"},{"name":"$self","containerName":"hsp","kind":13,"line":1111}],"detail":"($self,$option)","definition":"sub"},{"line":1113,"containerName":null,"kind":13,"name":"@hsps"},{"line":1113,"name":"$option","containerName":null,"kind":13},{"line":1114,"name":"@hsps","kind":13,"containerName":null},{"kind":12,"name":"hsps","line":1114},{"line":1114,"name":"$option","containerName":null,"kind":13},{"name":"$self","kind":13,"containerName":null,"line":1116},{"line":1116,"containerName":"main::","kind":12,"name":"throw"},{"kind":12,"range":{"start":{"character":0,"line":1136},"end":{"line":1144,"character":9999}},"line":1136,"name":"num_hsps","containerName":"main::","children":[{"line":1138,"localvar":"my","containerName":"num_hsps","kind":13,"name":"$self","definition":"my"},{"line":1140,"name":"$self","kind":13,"containerName":"num_hsps"},{"containerName":"num_hsps","kind":13,"name":"$self","line":1141},{"line":1141,"name":"throw","containerName":"num_hsps","kind":12},{"line":1144,"containerName":"num_hsps","kind":13,"name":"$self"}],"definition":"sub"},{"definition":"sub","children":[{"line":1174,"name":"$self","containerName":"logical_length","localvar":"my","kind":13,"definition":"my"},{"localvar":"my","containerName":"logical_length","kind":13,"name":"$seqType","line":1175,"definition":"my"},{"containerName":"logical_length","kind":13,"name":"$seqType","line":1176},{"kind":13,"containerName":"logical_length","name":"$seqType","line":1176},{"definition":"my","name":"$length","localvar":"my","kind":13,"containerName":"logical_length","line":1178},{"name":"$seqType","containerName":"logical_length","kind":13,"line":1181},{"name":"$length","containerName":"logical_length","kind":13,"line":1182},{"line":1182,"name":"$self","kind":13,"containerName":"logical_length"},{"line":1182,"name":"$self","containerName":"logical_length","kind":13},{"containerName":"logical_length","kind":13,"name":"$length","line":1186},{"name":"$self","kind":13,"containerName":"logical_length","line":1186},{"name":"$self","containerName":"logical_length","kind":13,"line":1189},{"line":1190,"containerName":"logical_length","kind":13,"name":"$length"},{"name":"$length","kind":13,"containerName":"logical_length","line":1193}],"name":"logical_length","containerName":"main::","line":1172,"range":{"end":{"line":1194,"character":9999},"start":{"character":0,"line":1172}},"kind":12},{"children":[{"kind":13,"localvar":"my","containerName":"length_aln","name":"$self","line":1224,"definition":"my"},{"line":1224,"name":"$seqType","kind":13,"containerName":"length_aln"},{"name":"$seqType","kind":13,"containerName":"length_aln","line":1226},{"line":1227,"name":"$seqType","containerName":"length_aln","kind":13},{"line":1227,"kind":13,"containerName":"length_aln","name":"$seqType"},{"line":1229,"kind":13,"containerName":"length_aln","name":"$self"},{"line":1229,"name":"$self","kind":13,"containerName":"length_aln"},{"definition":"my","line":1231,"containerName":"length_aln","localvar":"my","kind":13,"name":"$data"},{"kind":13,"containerName":"length_aln","name":"$self","line":1231},{"line":1231,"name":"$seqType","kind":13,"containerName":"length_aln"},{"line":1234,"containerName":"length_aln","kind":13,"name":"$data"},{"line":1235,"kind":13,"containerName":"length_aln","name":"$self"},{"line":1235,"name":"throw","containerName":"length_aln","kind":12},{"containerName":"length_aln","kind":13,"name":"$data","line":1238}],"containerName":"main::","name":"length_aln","definition":"sub","detail":"($self,$seqType)","line":1222,"kind":12,"range":{"start":{"character":0,"line":1222},"end":{"line":1239,"character":9999}},"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-------------\nsub signif {\n#-------------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get P- or Expect value: HSPs may not have been set.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P/Expect-value.\n    return $val;\n}\n\n#----------------\nsub raw_hit_data {\n#----------------\n    my $self = shift;\n    my $data = '>';\n    # Need to add blank lines where we've removed them.\n    foreach( @{$self->{'_hit_data'}} ) {\n        if( $_ eq 'end') {\n            $data .= \"\\n\";\n        }\n        else {\n            $data .= /^\\s*(Score|Query)/ ? \"\\n$_\" : $_;\n        }\n    }\n    return $data;\n}\n\n\n#=head2 _set_length\n#\n# Usage     : $hit_object->_set_length( \"233\" );\n# Purpose   : Set the total length of the hit sequence.\n# Example   : $hit_object->_set_length( $len );\n# Returns   : n/a\n# Argument  : Integer (only when setting). Any commas will be stripped out.\n# Throws    : n/a\n#\n#=cut\n\n#-----------\nsub _set_length {\n#-----------\n    my ($self, $len) = @_;\n    $len =~ s/,//g; # get rid of commas\n    $self->{'_length'} = $len;\n}\n\n#=head2 _set_description\n#\n# Usage     : Private method; called automatically during construction\n# Purpose   : Sets the description of the hit sequence.\n#            : For sequence without descriptions, does not set any description.\n# Argument  : Array containing description (multiple lines).\n# Comments  : Processes the supplied description:\n#                1. Join all lines into one string.\n#                2. Remove sequence id at the beginning of description.\n#                3. Removes junk charactes at begin and end of description.\n#\n#=cut\n\n#--------------\nsub _set_description {\n#--------------\n    my( $self, @desc ) = @_;\n    my( $desc);\n\n#    print STDERR \"PsiBlastHit: RAW DESC:\\n@desc\\n\";\n\n    $desc = join(\" \", @desc);\n\n    my $name = $self->name;\n\n    if($desc) {\n        $desc =~ s/^\\s*\\S+\\s+//; # remove the sequence ID(s)\n                                 # This won't work if there's no description.\n        $desc =~ s/^\\s*$name//;  # ...but this should.\n        $desc =~ s/^[\\s!]+//;\n        $desc =~ s/ \\d+$//;\n        $desc =~ s/\\.+$//;\n        $self->{'_description'} = $desc;\n    }\n\n#    print STDERR \"PsiBlastHit: _set_description =  $desc\\n\";\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hit->to_string;\n Function: Returns a string representation for the Blast Hit.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHit] <name> <description>\n           e.g.:\n           [PsiBlastHit] emb|Z46660|SC9725 S.cerevisiae chromosome XIII cosmid\n Args    : None\n\n\n#----------------\nsub to_string {\n#----------------\n    my $self = shift;\n    return \"[PsiBlastHit] \" . $self->name . \" \" . $self->description;\n}\n\n\n#=head2 _set_id\n#\n# Usage     : Private method; automatically called by new()\n# Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n#           : The identifier is assumed to be the first\n#           : chunk of non-whitespace characters in the description line\n#           : Does not assume any semantics in the structure of the identifier\n#           : (Formerly, this method attempted to extract database name from\n#           : the seq identifiers, but this was prone to break).\n# Returns   : n/a\n# Argument  : String containing description line of the hit from Blast report\n#           : or first line of an alignment section (with or without the leading '>').\n# Throws    : Warning if cannot locate sequence ID.\n#\n#See Also   : L<new()|new>, L<accession()|accession>\n#\n#=cut\n\n#---------------\nsub _set_id {\n#---------------\n    my( $self, $desc ) = @_;\n\n    # New strategy: Assume only that the ID is the first white space\n    # delimited chunk. Not attempting to extract accession & database name.\n    # Clients will have to interpret it as necessary.\n    if($desc =~ /^>?(\\S+)\\s*(.*)/) {\n        my ($name, $desc) = ($1, $2);\n        $self->name($name);\n        $self->{'_description'} = $desc;\n        # Note that this description comes from the summary section of the\n        # BLAST report and so may be truncated. The full description will be\n        # set from the alignment section. We're setting description here in case\n        # the alignment section isn't being parsed.\n\n        # Assuming accession is delimited with | symbols (NCBI-style)\n        my @pieces = split(/\\|/,$name);\n        my $acc = pop @pieces;\n        $self->accession( $acc );\n    }\n    else {\n        $self->warn(\"Can't locate sequence identifier in summary line.\", \"Line = $desc\");\n        $desc = 'Unknown sequence ID' if not $desc;\n        $self->name($desc);\n    }\n}\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences\n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences\n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains\n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Status    : Experimental\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps>, L<HSP Tiling and Ambiguous Alignments>\n\n\n#--------------------\nsub ambiguous_aln {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n\n\n=head2 overlap\n\n Usage     : $blast_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $blast_object->overlap(5);\n           : $overlap = $blast_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by Bio::Search::BlastUtils::_adjust_contigs().\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap {\n#-------------\n    my $self = shift;\n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n\n\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the BLAST bit score of the best HSP for the current Blast hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if bit score is not set.\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits {\n#---------\n    my $self = shift;\n\n    # The check for $self->{'_bits'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($bits);\n    if(not defined($self->{'_bits'})) {\n        $bits = $self->hsp->bits;\n    } else {\n        $bits = $self->{'_bits'};\n    }\n    return $bits;\n}\n\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n {\n#-----\n    my $self = shift;\n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n        $n = $self->hsp->n;\n    } else {\n        $n = $self->{'_n'};\n    }\n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\n#----------'\nsub frame {\n#----------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'};\n    }\n    return $frame;\n}\n\n\n\n\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p {\n#--------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(not defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using expect() instead.\");\n        $val = $self->{'_expect'};\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n\n\n=head2 expect\n\n Usage     : $hit_object->expect( [format] );\n Purpose   : Get the Expect value for the best HSP of the given BLAST hit.\n Example   : $e =  $sbjct->expect;\n           : $e =  $sbjct->expect('exp');  # get exponent only.\n           : ($num, $exp) = $sbjct->expect('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and Expect\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : Exception if the Expect value is not defined.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-----------\nsub expect {\n#-----------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val;\n\n    # For Blast reports that list the P value on the description line,\n    # getting the expect value requires fully parsing the HSP data.\n    # For NCBI blast, there's no problem.\n    if(not defined($self->{'_expect'})) {\n        if( defined $self->{'_hsps'}) {\n            $self->{'_expect'} = $val = $self->hsp->expect;\n        } else {\n            # If _expect is not set and _hsps are not set,\n            # then this must be a P-value-based report that was\n            # run without setting the HSPs (shallow parsing).\n            $self->throw(\"Can't get expect value. HSPs have not been set.\");\n        }\n    } else {\n        $val = $self->{'_expect'};\n    }\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get Expect value.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw Expect-value.\n    return $val;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return wantarray\n        #  returning list containing all HSPs.\n        ? @{$self->{'_hsps'}}\n        #  returning number of HSPs.\n        : scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single BlastHSP.pm object for the present PsiBlastHit.pm object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp {\n#----------\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = @{$self->{'_hsps'}};\n\n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    my $self = shift;\n\n    if (not defined $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : For query sequence of BLASTX and TBLASTX reports and the hit\n           : sequence of TBLASTN and TBLASTX reports, the returned length\n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len = $hit_object->logical_length();\n Returns   : Integer\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with T?BLASTX type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length {\n#--------------------\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my $length;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->{'_logical_length'} || $self->{'_length'};\n    }\n    else {\n        # Otherwise, return logical query length\n        $length = $self->{'_query_length'};\n\n        # Adjust length based on BLAST flavor.\n        if($self->{'_blast_program'} =~ /T?BLASTX/ ) {\n            $length /= 3;\n        }\n    }\n    return $length;\n}\n\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           :\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n---------------'","parameters":[{"label":"$self"},{"label":"$seqType"}],"label":"length_aln($self,$seqType)"}},{"name":"Bio","containerName":"Search::BlastUtils::tile_hsps","kind":12,"line":1229},{"line":1277,"kind":12,"range":{"start":{"character":0,"line":1277},"end":{"character":9999,"line":1297}},"signature":{"label":"gaps($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-------------\nsub signif {\n#-------------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get P- or Expect value: HSPs may not have been set.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P/Expect-value.\n    return $val;\n}\n\n#----------------\nsub raw_hit_data {\n#----------------\n    my $self = shift;\n    my $data = '>';\n    # Need to add blank lines where we've removed them.\n    foreach( @{$self->{'_hit_data'}} ) {\n        if( $_ eq 'end') {\n            $data .= \"\\n\";\n        }\n        else {\n            $data .= /^\\s*(Score|Query)/ ? \"\\n$_\" : $_;\n        }\n    }\n    return $data;\n}\n\n\n#=head2 _set_length\n#\n# Usage     : $hit_object->_set_length( \"233\" );\n# Purpose   : Set the total length of the hit sequence.\n# Example   : $hit_object->_set_length( $len );\n# Returns   : n/a\n# Argument  : Integer (only when setting). Any commas will be stripped out.\n# Throws    : n/a\n#\n#=cut\n\n#-----------\nsub _set_length {\n#-----------\n    my ($self, $len) = @_;\n    $len =~ s/,//g; # get rid of commas\n    $self->{'_length'} = $len;\n}\n\n#=head2 _set_description\n#\n# Usage     : Private method; called automatically during construction\n# Purpose   : Sets the description of the hit sequence.\n#            : For sequence without descriptions, does not set any description.\n# Argument  : Array containing description (multiple lines).\n# Comments  : Processes the supplied description:\n#                1. Join all lines into one string.\n#                2. Remove sequence id at the beginning of description.\n#                3. Removes junk charactes at begin and end of description.\n#\n#=cut\n\n#--------------\nsub _set_description {\n#--------------\n    my( $self, @desc ) = @_;\n    my( $desc);\n\n#    print STDERR \"PsiBlastHit: RAW DESC:\\n@desc\\n\";\n\n    $desc = join(\" \", @desc);\n\n    my $name = $self->name;\n\n    if($desc) {\n        $desc =~ s/^\\s*\\S+\\s+//; # remove the sequence ID(s)\n                                 # This won't work if there's no description.\n        $desc =~ s/^\\s*$name//;  # ...but this should.\n        $desc =~ s/^[\\s!]+//;\n        $desc =~ s/ \\d+$//;\n        $desc =~ s/\\.+$//;\n        $self->{'_description'} = $desc;\n    }\n\n#    print STDERR \"PsiBlastHit: _set_description =  $desc\\n\";\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hit->to_string;\n Function: Returns a string representation for the Blast Hit.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHit] <name> <description>\n           e.g.:\n           [PsiBlastHit] emb|Z46660|SC9725 S.cerevisiae chromosome XIII cosmid\n Args    : None\n\n\n#----------------\nsub to_string {\n#----------------\n    my $self = shift;\n    return \"[PsiBlastHit] \" . $self->name . \" \" . $self->description;\n}\n\n\n#=head2 _set_id\n#\n# Usage     : Private method; automatically called by new()\n# Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n#           : The identifier is assumed to be the first\n#           : chunk of non-whitespace characters in the description line\n#           : Does not assume any semantics in the structure of the identifier\n#           : (Formerly, this method attempted to extract database name from\n#           : the seq identifiers, but this was prone to break).\n# Returns   : n/a\n# Argument  : String containing description line of the hit from Blast report\n#           : or first line of an alignment section (with or without the leading '>').\n# Throws    : Warning if cannot locate sequence ID.\n#\n#See Also   : L<new()|new>, L<accession()|accession>\n#\n#=cut\n\n#---------------\nsub _set_id {\n#---------------\n    my( $self, $desc ) = @_;\n\n    # New strategy: Assume only that the ID is the first white space\n    # delimited chunk. Not attempting to extract accession & database name.\n    # Clients will have to interpret it as necessary.\n    if($desc =~ /^>?(\\S+)\\s*(.*)/) {\n        my ($name, $desc) = ($1, $2);\n        $self->name($name);\n        $self->{'_description'} = $desc;\n        # Note that this description comes from the summary section of the\n        # BLAST report and so may be truncated. The full description will be\n        # set from the alignment section. We're setting description here in case\n        # the alignment section isn't being parsed.\n\n        # Assuming accession is delimited with | symbols (NCBI-style)\n        my @pieces = split(/\\|/,$name);\n        my $acc = pop @pieces;\n        $self->accession( $acc );\n    }\n    else {\n        $self->warn(\"Can't locate sequence identifier in summary line.\", \"Line = $desc\");\n        $desc = 'Unknown sequence ID' if not $desc;\n        $self->name($desc);\n    }\n}\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences\n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences\n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains\n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Status    : Experimental\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps>, L<HSP Tiling and Ambiguous Alignments>\n\n\n#--------------------\nsub ambiguous_aln {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n\n\n=head2 overlap\n\n Usage     : $blast_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $blast_object->overlap(5);\n           : $overlap = $blast_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by Bio::Search::BlastUtils::_adjust_contigs().\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap {\n#-------------\n    my $self = shift;\n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n\n\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the BLAST bit score of the best HSP for the current Blast hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if bit score is not set.\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits {\n#---------\n    my $self = shift;\n\n    # The check for $self->{'_bits'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($bits);\n    if(not defined($self->{'_bits'})) {\n        $bits = $self->hsp->bits;\n    } else {\n        $bits = $self->{'_bits'};\n    }\n    return $bits;\n}\n\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n {\n#-----\n    my $self = shift;\n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n        $n = $self->hsp->n;\n    } else {\n        $n = $self->{'_n'};\n    }\n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\n#----------'\nsub frame {\n#----------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'};\n    }\n    return $frame;\n}\n\n\n\n\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p {\n#--------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(not defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using expect() instead.\");\n        $val = $self->{'_expect'};\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n\n\n=head2 expect\n\n Usage     : $hit_object->expect( [format] );\n Purpose   : Get the Expect value for the best HSP of the given BLAST hit.\n Example   : $e =  $sbjct->expect;\n           : $e =  $sbjct->expect('exp');  # get exponent only.\n           : ($num, $exp) = $sbjct->expect('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and Expect\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : Exception if the Expect value is not defined.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-----------\nsub expect {\n#-----------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val;\n\n    # For Blast reports that list the P value on the description line,\n    # getting the expect value requires fully parsing the HSP data.\n    # For NCBI blast, there's no problem.\n    if(not defined($self->{'_expect'})) {\n        if( defined $self->{'_hsps'}) {\n            $self->{'_expect'} = $val = $self->hsp->expect;\n        } else {\n            # If _expect is not set and _hsps are not set,\n            # then this must be a P-value-based report that was\n            # run without setting the HSPs (shallow parsing).\n            $self->throw(\"Can't get expect value. HSPs have not been set.\");\n        }\n    } else {\n        $val = $self->{'_expect'};\n    }\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get Expect value.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw Expect-value.\n    return $val;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return wantarray\n        #  returning list containing all HSPs.\n        ? @{$self->{'_hsps'}}\n        #  returning number of HSPs.\n        : scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single BlastHSP.pm object for the present PsiBlastHit.pm object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp {\n#----------\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = @{$self->{'_hsps'}};\n\n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    my $self = shift;\n\n    if (not defined $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : For query sequence of BLASTX and TBLASTX reports and the hit\n           : sequence of TBLASTN and TBLASTX reports, the returned length\n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len = $hit_object->logical_length();\n Returns   : Integer\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with T?BLASTX type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length {\n#--------------------\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my $length;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->{'_logical_length'} || $self->{'_length'};\n    }\n    else {\n        # Otherwise, return logical query length\n        $length = $self->{'_query_length'};\n\n        # Adjust length based on BLAST flavor.\n        if($self->{'_blast_program'} =~ /T?BLASTX/ ) {\n            $length /= 3;\n        }\n    }\n    return $length;\n}\n\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           :\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\n#---------------'\nsub length_aln {\n#---------------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    my $data = $self->{'_length_aln_'.$seqType};\n\n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\"\" .\n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }\n    $data;\n}\n\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, sbjct, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers\n           :    (queryGaps, sbjctGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed\n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations\n           : such as printf \"%d\", $hit->gaps() in which you might expect to\n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>"},"children":[{"localvar":"my","containerName":"gaps","kind":13,"name":"$self","line":1279,"definition":"my"},{"line":1279,"kind":13,"containerName":"gaps","name":"$seqType"},{"line":1281,"name":"$seqType","containerName":"gaps","kind":13},{"line":1282,"name":"$seqType","kind":13,"containerName":"gaps"},{"line":1282,"name":"$seqType","kind":13,"containerName":"gaps"},{"name":"$self","containerName":"gaps","kind":13,"line":1284},{"containerName":"gaps","kind":13,"name":"$self","line":1284},{"containerName":"gaps","kind":13,"name":"$seqType","line":1286},{"line":1286,"kind":13,"containerName":"gaps","name":"$seqType"},{"name":"$seqType","kind":13,"containerName":"gaps","line":1288},{"containerName":"gaps","kind":13,"name":"$self","line":1289},{"containerName":"gaps","kind":13,"name":"$self","line":1289},{"line":1292,"kind":13,"containerName":"gaps","name":"$seqType"},{"line":1293,"name":"$self","kind":13,"containerName":"gaps"},{"line":1293,"containerName":"gaps","kind":13,"name":"$self"},{"line":1295,"name":"$self","kind":13,"containerName":"gaps"},{"name":"$seqType","containerName":"gaps","kind":13,"line":1295}],"name":"gaps","containerName":"main::","definition":"sub","detail":"($self,$seqType)"},{"containerName":"Search::BlastUtils::tile_hsps","kind":12,"name":"Bio","line":1284},{"children":[{"line":1332,"containerName":"matches","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":1332,"name":"$arg","kind":13,"containerName":"matches"},{"line":1333,"containerName":"matches","localvar":"my","kind":13,"name":"@data","definition":"my"},{"name":"$data","containerName":"matches","kind":13,"line":1333},{"name":"$arg","containerName":"matches","kind":13,"line":1335},{"containerName":"matches","kind":13,"name":"@data","line":1336},{"kind":13,"containerName":"matches","name":"$self","line":1336},{"line":1336,"name":"$self","kind":13,"containerName":"matches"},{"containerName":"matches","kind":13,"name":"@data","line":1338},{"line":1338,"name":"@data","containerName":"matches","kind":13},{"line":1342,"kind":13,"containerName":"matches","name":"$arg"},{"kind":13,"containerName":"matches","name":"$data","line":1343},{"name":"$self","kind":13,"containerName":"matches","line":1343},{"line":1345,"containerName":"matches","kind":13,"name":"$data"},{"name":"$self","kind":13,"containerName":"matches","line":1345},{"containerName":"matches","kind":13,"name":"$data","line":1347},{"line":1347,"name":"$data","kind":13,"containerName":"matches"},{"line":1351,"name":"$self","containerName":"matches","kind":13},{"line":1351,"name":"throw","containerName":"matches","kind":12}],"name":"matches","containerName":"main::","definition":"sub","detail":"($self,$arg)","line":1330,"kind":12,"range":{"end":{"character":9999,"line":1352},"start":{"character":0,"line":1330}},"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-------------\nsub signif {\n#-------------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get P- or Expect value: HSPs may not have been set.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P/Expect-value.\n    return $val;\n}\n\n#----------------\nsub raw_hit_data {\n#----------------\n    my $self = shift;\n    my $data = '>';\n    # Need to add blank lines where we've removed them.\n    foreach( @{$self->{'_hit_data'}} ) {\n        if( $_ eq 'end') {\n            $data .= \"\\n\";\n        }\n        else {\n            $data .= /^\\s*(Score|Query)/ ? \"\\n$_\" : $_;\n        }\n    }\n    return $data;\n}\n\n\n#=head2 _set_length\n#\n# Usage     : $hit_object->_set_length( \"233\" );\n# Purpose   : Set the total length of the hit sequence.\n# Example   : $hit_object->_set_length( $len );\n# Returns   : n/a\n# Argument  : Integer (only when setting). Any commas will be stripped out.\n# Throws    : n/a\n#\n#=cut\n\n#-----------\nsub _set_length {\n#-----------\n    my ($self, $len) = @_;\n    $len =~ s/,//g; # get rid of commas\n    $self->{'_length'} = $len;\n}\n\n#=head2 _set_description\n#\n# Usage     : Private method; called automatically during construction\n# Purpose   : Sets the description of the hit sequence.\n#            : For sequence without descriptions, does not set any description.\n# Argument  : Array containing description (multiple lines).\n# Comments  : Processes the supplied description:\n#                1. Join all lines into one string.\n#                2. Remove sequence id at the beginning of description.\n#                3. Removes junk charactes at begin and end of description.\n#\n#=cut\n\n#--------------\nsub _set_description {\n#--------------\n    my( $self, @desc ) = @_;\n    my( $desc);\n\n#    print STDERR \"PsiBlastHit: RAW DESC:\\n@desc\\n\";\n\n    $desc = join(\" \", @desc);\n\n    my $name = $self->name;\n\n    if($desc) {\n        $desc =~ s/^\\s*\\S+\\s+//; # remove the sequence ID(s)\n                                 # This won't work if there's no description.\n        $desc =~ s/^\\s*$name//;  # ...but this should.\n        $desc =~ s/^[\\s!]+//;\n        $desc =~ s/ \\d+$//;\n        $desc =~ s/\\.+$//;\n        $self->{'_description'} = $desc;\n    }\n\n#    print STDERR \"PsiBlastHit: _set_description =  $desc\\n\";\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hit->to_string;\n Function: Returns a string representation for the Blast Hit.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHit] <name> <description>\n           e.g.:\n           [PsiBlastHit] emb|Z46660|SC9725 S.cerevisiae chromosome XIII cosmid\n Args    : None\n\n\n#----------------\nsub to_string {\n#----------------\n    my $self = shift;\n    return \"[PsiBlastHit] \" . $self->name . \" \" . $self->description;\n}\n\n\n#=head2 _set_id\n#\n# Usage     : Private method; automatically called by new()\n# Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n#           : The identifier is assumed to be the first\n#           : chunk of non-whitespace characters in the description line\n#           : Does not assume any semantics in the structure of the identifier\n#           : (Formerly, this method attempted to extract database name from\n#           : the seq identifiers, but this was prone to break).\n# Returns   : n/a\n# Argument  : String containing description line of the hit from Blast report\n#           : or first line of an alignment section (with or without the leading '>').\n# Throws    : Warning if cannot locate sequence ID.\n#\n#See Also   : L<new()|new>, L<accession()|accession>\n#\n#=cut\n\n#---------------\nsub _set_id {\n#---------------\n    my( $self, $desc ) = @_;\n\n    # New strategy: Assume only that the ID is the first white space\n    # delimited chunk. Not attempting to extract accession & database name.\n    # Clients will have to interpret it as necessary.\n    if($desc =~ /^>?(\\S+)\\s*(.*)/) {\n        my ($name, $desc) = ($1, $2);\n        $self->name($name);\n        $self->{'_description'} = $desc;\n        # Note that this description comes from the summary section of the\n        # BLAST report and so may be truncated. The full description will be\n        # set from the alignment section. We're setting description here in case\n        # the alignment section isn't being parsed.\n\n        # Assuming accession is delimited with | symbols (NCBI-style)\n        my @pieces = split(/\\|/,$name);\n        my $acc = pop @pieces;\n        $self->accession( $acc );\n    }\n    else {\n        $self->warn(\"Can't locate sequence identifier in summary line.\", \"Line = $desc\");\n        $desc = 'Unknown sequence ID' if not $desc;\n        $self->name($desc);\n    }\n}\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences\n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences\n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains\n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Status    : Experimental\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps>, L<HSP Tiling and Ambiguous Alignments>\n\n\n#--------------------\nsub ambiguous_aln {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n\n\n=head2 overlap\n\n Usage     : $blast_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $blast_object->overlap(5);\n           : $overlap = $blast_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by Bio::Search::BlastUtils::_adjust_contigs().\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap {\n#-------------\n    my $self = shift;\n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n\n\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the BLAST bit score of the best HSP for the current Blast hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if bit score is not set.\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits {\n#---------\n    my $self = shift;\n\n    # The check for $self->{'_bits'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($bits);\n    if(not defined($self->{'_bits'})) {\n        $bits = $self->hsp->bits;\n    } else {\n        $bits = $self->{'_bits'};\n    }\n    return $bits;\n}\n\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n {\n#-----\n    my $self = shift;\n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n        $n = $self->hsp->n;\n    } else {\n        $n = $self->{'_n'};\n    }\n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\n#----------'\nsub frame {\n#----------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'};\n    }\n    return $frame;\n}\n\n\n\n\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p {\n#--------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(not defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using expect() instead.\");\n        $val = $self->{'_expect'};\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n\n\n=head2 expect\n\n Usage     : $hit_object->expect( [format] );\n Purpose   : Get the Expect value for the best HSP of the given BLAST hit.\n Example   : $e =  $sbjct->expect;\n           : $e =  $sbjct->expect('exp');  # get exponent only.\n           : ($num, $exp) = $sbjct->expect('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and Expect\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : Exception if the Expect value is not defined.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-----------\nsub expect {\n#-----------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val;\n\n    # For Blast reports that list the P value on the description line,\n    # getting the expect value requires fully parsing the HSP data.\n    # For NCBI blast, there's no problem.\n    if(not defined($self->{'_expect'})) {\n        if( defined $self->{'_hsps'}) {\n            $self->{'_expect'} = $val = $self->hsp->expect;\n        } else {\n            # If _expect is not set and _hsps are not set,\n            # then this must be a P-value-based report that was\n            # run without setting the HSPs (shallow parsing).\n            $self->throw(\"Can't get expect value. HSPs have not been set.\");\n        }\n    } else {\n        $val = $self->{'_expect'};\n    }\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get Expect value.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw Expect-value.\n    return $val;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return wantarray\n        #  returning list containing all HSPs.\n        ? @{$self->{'_hsps'}}\n        #  returning number of HSPs.\n        : scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single BlastHSP.pm object for the present PsiBlastHit.pm object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp {\n#----------\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = @{$self->{'_hsps'}};\n\n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    my $self = shift;\n\n    if (not defined $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : For query sequence of BLASTX and TBLASTX reports and the hit\n           : sequence of TBLASTN and TBLASTX reports, the returned length\n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len = $hit_object->logical_length();\n Returns   : Integer\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with T?BLASTX type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length {\n#--------------------\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my $length;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->{'_logical_length'} || $self->{'_length'};\n    }\n    else {\n        # Otherwise, return logical query length\n        $length = $self->{'_query_length'};\n\n        # Adjust length based on BLAST flavor.\n        if($self->{'_blast_program'} =~ /T?BLASTX/ ) {\n            $length /= 3;\n        }\n    }\n    return $length;\n}\n\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           :\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\n#---------------'\nsub length_aln {\n#---------------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    my $data = $self->{'_length_aln_'.$seqType};\n\n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\"\" .\n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }\n    $data;\n}\n\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, sbjct, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers\n           :    (queryGaps, sbjctGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed\n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations\n           : such as printf \"%d\", $hit->gaps() in which you might expect to\n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\n#----------\nsub gaps {\n#----------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    $seqType = lc($seqType);\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}\n\n\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches\n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives'\n           :         in the Blast report.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons');\n Returns   : Integer or a 2-element array of integers\n Argument  : class = 'id' | 'cons' OR none.\n           : If no argument is provided, both identical and conservative\n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the\n           : conservative matches are returned.)\n Throws    : Exception if the requested data cannot be obtained.\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : Does not rely on wantarray to return a list. Only checks for\n           : the presence of an argument (no arg = return list).\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::matches()|Bio::Search::HSP::BlastHSP>, L<hsps()|hsps>","parameters":[{"label":"$self"},{"label":"$arg"}],"label":"matches($self,$arg)"}},{"range":{"start":{"line":1381,"character":0},"end":{"character":9999,"line":1401}},"kind":12,"line":1381,"signature":{"label":"start($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-------------\nsub signif {\n#-------------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get P- or Expect value: HSPs may not have been set.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P/Expect-value.\n    return $val;\n}\n\n#----------------\nsub raw_hit_data {\n#----------------\n    my $self = shift;\n    my $data = '>';\n    # Need to add blank lines where we've removed them.\n    foreach( @{$self->{'_hit_data'}} ) {\n        if( $_ eq 'end') {\n            $data .= \"\\n\";\n        }\n        else {\n            $data .= /^\\s*(Score|Query)/ ? \"\\n$_\" : $_;\n        }\n    }\n    return $data;\n}\n\n\n#=head2 _set_length\n#\n# Usage     : $hit_object->_set_length( \"233\" );\n# Purpose   : Set the total length of the hit sequence.\n# Example   : $hit_object->_set_length( $len );\n# Returns   : n/a\n# Argument  : Integer (only when setting). Any commas will be stripped out.\n# Throws    : n/a\n#\n#=cut\n\n#-----------\nsub _set_length {\n#-----------\n    my ($self, $len) = @_;\n    $len =~ s/,//g; # get rid of commas\n    $self->{'_length'} = $len;\n}\n\n#=head2 _set_description\n#\n# Usage     : Private method; called automatically during construction\n# Purpose   : Sets the description of the hit sequence.\n#            : For sequence without descriptions, does not set any description.\n# Argument  : Array containing description (multiple lines).\n# Comments  : Processes the supplied description:\n#                1. Join all lines into one string.\n#                2. Remove sequence id at the beginning of description.\n#                3. Removes junk charactes at begin and end of description.\n#\n#=cut\n\n#--------------\nsub _set_description {\n#--------------\n    my( $self, @desc ) = @_;\n    my( $desc);\n\n#    print STDERR \"PsiBlastHit: RAW DESC:\\n@desc\\n\";\n\n    $desc = join(\" \", @desc);\n\n    my $name = $self->name;\n\n    if($desc) {\n        $desc =~ s/^\\s*\\S+\\s+//; # remove the sequence ID(s)\n                                 # This won't work if there's no description.\n        $desc =~ s/^\\s*$name//;  # ...but this should.\n        $desc =~ s/^[\\s!]+//;\n        $desc =~ s/ \\d+$//;\n        $desc =~ s/\\.+$//;\n        $self->{'_description'} = $desc;\n    }\n\n#    print STDERR \"PsiBlastHit: _set_description =  $desc\\n\";\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hit->to_string;\n Function: Returns a string representation for the Blast Hit.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHit] <name> <description>\n           e.g.:\n           [PsiBlastHit] emb|Z46660|SC9725 S.cerevisiae chromosome XIII cosmid\n Args    : None\n\n\n#----------------\nsub to_string {\n#----------------\n    my $self = shift;\n    return \"[PsiBlastHit] \" . $self->name . \" \" . $self->description;\n}\n\n\n#=head2 _set_id\n#\n# Usage     : Private method; automatically called by new()\n# Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n#           : The identifier is assumed to be the first\n#           : chunk of non-whitespace characters in the description line\n#           : Does not assume any semantics in the structure of the identifier\n#           : (Formerly, this method attempted to extract database name from\n#           : the seq identifiers, but this was prone to break).\n# Returns   : n/a\n# Argument  : String containing description line of the hit from Blast report\n#           : or first line of an alignment section (with or without the leading '>').\n# Throws    : Warning if cannot locate sequence ID.\n#\n#See Also   : L<new()|new>, L<accession()|accession>\n#\n#=cut\n\n#---------------\nsub _set_id {\n#---------------\n    my( $self, $desc ) = @_;\n\n    # New strategy: Assume only that the ID is the first white space\n    # delimited chunk. Not attempting to extract accession & database name.\n    # Clients will have to interpret it as necessary.\n    if($desc =~ /^>?(\\S+)\\s*(.*)/) {\n        my ($name, $desc) = ($1, $2);\n        $self->name($name);\n        $self->{'_description'} = $desc;\n        # Note that this description comes from the summary section of the\n        # BLAST report and so may be truncated. The full description will be\n        # set from the alignment section. We're setting description here in case\n        # the alignment section isn't being parsed.\n\n        # Assuming accession is delimited with | symbols (NCBI-style)\n        my @pieces = split(/\\|/,$name);\n        my $acc = pop @pieces;\n        $self->accession( $acc );\n    }\n    else {\n        $self->warn(\"Can't locate sequence identifier in summary line.\", \"Line = $desc\");\n        $desc = 'Unknown sequence ID' if not $desc;\n        $self->name($desc);\n    }\n}\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences\n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences\n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains\n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Status    : Experimental\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps>, L<HSP Tiling and Ambiguous Alignments>\n\n\n#--------------------\nsub ambiguous_aln {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n\n\n=head2 overlap\n\n Usage     : $blast_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $blast_object->overlap(5);\n           : $overlap = $blast_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by Bio::Search::BlastUtils::_adjust_contigs().\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap {\n#-------------\n    my $self = shift;\n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n\n\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the BLAST bit score of the best HSP for the current Blast hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if bit score is not set.\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits {\n#---------\n    my $self = shift;\n\n    # The check for $self->{'_bits'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($bits);\n    if(not defined($self->{'_bits'})) {\n        $bits = $self->hsp->bits;\n    } else {\n        $bits = $self->{'_bits'};\n    }\n    return $bits;\n}\n\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n {\n#-----\n    my $self = shift;\n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n        $n = $self->hsp->n;\n    } else {\n        $n = $self->{'_n'};\n    }\n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\n#----------'\nsub frame {\n#----------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'};\n    }\n    return $frame;\n}\n\n\n\n\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p {\n#--------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(not defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using expect() instead.\");\n        $val = $self->{'_expect'};\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n\n\n=head2 expect\n\n Usage     : $hit_object->expect( [format] );\n Purpose   : Get the Expect value for the best HSP of the given BLAST hit.\n Example   : $e =  $sbjct->expect;\n           : $e =  $sbjct->expect('exp');  # get exponent only.\n           : ($num, $exp) = $sbjct->expect('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and Expect\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : Exception if the Expect value is not defined.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-----------\nsub expect {\n#-----------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val;\n\n    # For Blast reports that list the P value on the description line,\n    # getting the expect value requires fully parsing the HSP data.\n    # For NCBI blast, there's no problem.\n    if(not defined($self->{'_expect'})) {\n        if( defined $self->{'_hsps'}) {\n            $self->{'_expect'} = $val = $self->hsp->expect;\n        } else {\n            # If _expect is not set and _hsps are not set,\n            # then this must be a P-value-based report that was\n            # run without setting the HSPs (shallow parsing).\n            $self->throw(\"Can't get expect value. HSPs have not been set.\");\n        }\n    } else {\n        $val = $self->{'_expect'};\n    }\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get Expect value.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw Expect-value.\n    return $val;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return wantarray\n        #  returning list containing all HSPs.\n        ? @{$self->{'_hsps'}}\n        #  returning number of HSPs.\n        : scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single BlastHSP.pm object for the present PsiBlastHit.pm object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp {\n#----------\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = @{$self->{'_hsps'}};\n\n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    my $self = shift;\n\n    if (not defined $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : For query sequence of BLASTX and TBLASTX reports and the hit\n           : sequence of TBLASTN and TBLASTX reports, the returned length\n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len = $hit_object->logical_length();\n Returns   : Integer\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with T?BLASTX type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length {\n#--------------------\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my $length;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->{'_logical_length'} || $self->{'_length'};\n    }\n    else {\n        # Otherwise, return logical query length\n        $length = $self->{'_query_length'};\n\n        # Adjust length based on BLAST flavor.\n        if($self->{'_blast_program'} =~ /T?BLASTX/ ) {\n            $length /= 3;\n        }\n    }\n    return $length;\n}\n\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           :\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\n#---------------'\nsub length_aln {\n#---------------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    my $data = $self->{'_length_aln_'.$seqType};\n\n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\"\" .\n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }\n    $data;\n}\n\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, sbjct, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers\n           :    (queryGaps, sbjctGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed\n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations\n           : such as printf \"%d\", $hit->gaps() in which you might expect to\n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\n#----------\nsub gaps {\n#----------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    $seqType = lc($seqType);\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}\n\n\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches\n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives'\n           :         in the Blast report.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons');\n Returns   : Integer or a 2-element array of integers\n Argument  : class = 'id' | 'cons' OR none.\n           : If no argument is provided, both identical and conservative\n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the\n           : conservative matches are returned.)\n Throws    : Exception if the requested data cannot be obtained.\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : Does not rely on wantarray to return a list. Only checks for\n           : the presence of an argument (no arg = return list).\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::matches()|Bio::Search::HSP::BlastHSP>, L<hsps()|hsps>\n\n\n#---------------\nsub matches {\n#---------------\n    my( $self, $arg) = @_;\n    my(@data,$data);\n\n    if(!$arg) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data if @data;\n\n    } else {\n\n        if($arg =~ /^id/i) {\n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        return $data if $data;\n    }\n\n    ## Something went wrong if we make it to here.\n    $self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the PsiBlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If there is more than one\n           : HSP and they have not already been tiled, they will be tiled first automatically..\n           : Remember that the start and end coordinates of all HSPs are\n           : normalized so that start < end. Strand information can be\n           : obtained by calling $hit->strand().\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, L<HSP Tiling and Ambiguous Alignments>, L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>"},"name":"start","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"start","kind":13,"name":"$self","line":1383},{"name":"$seqType","containerName":"start","kind":13,"line":1383},{"containerName":"start","kind":13,"name":"$seqType","line":1385},{"line":1386,"name":"$seqType","kind":13,"containerName":"start"},{"line":1386,"containerName":"start","kind":13,"name":"$seqType"},{"name":"$self","kind":13,"containerName":"start","line":1389},{"line":1389,"containerName":"start","kind":12,"name":"num_hsps"},{"kind":13,"containerName":"start","name":"$self","line":1390},{"containerName":"start","kind":12,"name":"hsp","line":1390},{"line":1390,"name":"start","kind":12,"containerName":"start"},{"name":"$seqType","containerName":"start","kind":13,"line":1390},{"containerName":"start","kind":13,"name":"$self","line":1392},{"name":"$self","containerName":"start","kind":13,"line":1392},{"name":"$seqType","containerName":"start","kind":13,"line":1393},{"name":"$self","kind":13,"containerName":"start","line":1394},{"containerName":"start","kind":13,"name":"$self","line":1394},{"line":1397,"kind":13,"containerName":"start","name":"$seqType"},{"line":1398,"containerName":"start","kind":13,"name":"$self"},{"line":1398,"kind":13,"containerName":"start","name":"$seqType"}],"detail":"($self,$seqType)","definition":"sub"},{"line":1392,"kind":12,"containerName":"Search::BlastUtils::tile_hsps","name":"Bio"},{"kind":12,"range":{"start":{"line":1430,"character":0},"end":{"line":1450,"character":9999}},"line":1430,"signature":{"label":"end($self,$seqType)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-------------\nsub signif {\n#-------------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get P- or Expect value: HSPs may not have been set.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P/Expect-value.\n    return $val;\n}\n\n#----------------\nsub raw_hit_data {\n#----------------\n    my $self = shift;\n    my $data = '>';\n    # Need to add blank lines where we've removed them.\n    foreach( @{$self->{'_hit_data'}} ) {\n        if( $_ eq 'end') {\n            $data .= \"\\n\";\n        }\n        else {\n            $data .= /^\\s*(Score|Query)/ ? \"\\n$_\" : $_;\n        }\n    }\n    return $data;\n}\n\n\n#=head2 _set_length\n#\n# Usage     : $hit_object->_set_length( \"233\" );\n# Purpose   : Set the total length of the hit sequence.\n# Example   : $hit_object->_set_length( $len );\n# Returns   : n/a\n# Argument  : Integer (only when setting). Any commas will be stripped out.\n# Throws    : n/a\n#\n#=cut\n\n#-----------\nsub _set_length {\n#-----------\n    my ($self, $len) = @_;\n    $len =~ s/,//g; # get rid of commas\n    $self->{'_length'} = $len;\n}\n\n#=head2 _set_description\n#\n# Usage     : Private method; called automatically during construction\n# Purpose   : Sets the description of the hit sequence.\n#            : For sequence without descriptions, does not set any description.\n# Argument  : Array containing description (multiple lines).\n# Comments  : Processes the supplied description:\n#                1. Join all lines into one string.\n#                2. Remove sequence id at the beginning of description.\n#                3. Removes junk charactes at begin and end of description.\n#\n#=cut\n\n#--------------\nsub _set_description {\n#--------------\n    my( $self, @desc ) = @_;\n    my( $desc);\n\n#    print STDERR \"PsiBlastHit: RAW DESC:\\n@desc\\n\";\n\n    $desc = join(\" \", @desc);\n\n    my $name = $self->name;\n\n    if($desc) {\n        $desc =~ s/^\\s*\\S+\\s+//; # remove the sequence ID(s)\n                                 # This won't work if there's no description.\n        $desc =~ s/^\\s*$name//;  # ...but this should.\n        $desc =~ s/^[\\s!]+//;\n        $desc =~ s/ \\d+$//;\n        $desc =~ s/\\.+$//;\n        $self->{'_description'} = $desc;\n    }\n\n#    print STDERR \"PsiBlastHit: _set_description =  $desc\\n\";\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hit->to_string;\n Function: Returns a string representation for the Blast Hit.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHit] <name> <description>\n           e.g.:\n           [PsiBlastHit] emb|Z46660|SC9725 S.cerevisiae chromosome XIII cosmid\n Args    : None\n\n\n#----------------\nsub to_string {\n#----------------\n    my $self = shift;\n    return \"[PsiBlastHit] \" . $self->name . \" \" . $self->description;\n}\n\n\n#=head2 _set_id\n#\n# Usage     : Private method; automatically called by new()\n# Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n#           : The identifier is assumed to be the first\n#           : chunk of non-whitespace characters in the description line\n#           : Does not assume any semantics in the structure of the identifier\n#           : (Formerly, this method attempted to extract database name from\n#           : the seq identifiers, but this was prone to break).\n# Returns   : n/a\n# Argument  : String containing description line of the hit from Blast report\n#           : or first line of an alignment section (with or without the leading '>').\n# Throws    : Warning if cannot locate sequence ID.\n#\n#See Also   : L<new()|new>, L<accession()|accession>\n#\n#=cut\n\n#---------------\nsub _set_id {\n#---------------\n    my( $self, $desc ) = @_;\n\n    # New strategy: Assume only that the ID is the first white space\n    # delimited chunk. Not attempting to extract accession & database name.\n    # Clients will have to interpret it as necessary.\n    if($desc =~ /^>?(\\S+)\\s*(.*)/) {\n        my ($name, $desc) = ($1, $2);\n        $self->name($name);\n        $self->{'_description'} = $desc;\n        # Note that this description comes from the summary section of the\n        # BLAST report and so may be truncated. The full description will be\n        # set from the alignment section. We're setting description here in case\n        # the alignment section isn't being parsed.\n\n        # Assuming accession is delimited with | symbols (NCBI-style)\n        my @pieces = split(/\\|/,$name);\n        my $acc = pop @pieces;\n        $self->accession( $acc );\n    }\n    else {\n        $self->warn(\"Can't locate sequence identifier in summary line.\", \"Line = $desc\");\n        $desc = 'Unknown sequence ID' if not $desc;\n        $self->name($desc);\n    }\n}\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences\n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences\n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains\n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Status    : Experimental\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps>, L<HSP Tiling and Ambiguous Alignments>\n\n\n#--------------------\nsub ambiguous_aln {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n\n\n=head2 overlap\n\n Usage     : $blast_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $blast_object->overlap(5);\n           : $overlap = $blast_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by Bio::Search::BlastUtils::_adjust_contigs().\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap {\n#-------------\n    my $self = shift;\n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n\n\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the BLAST bit score of the best HSP for the current Blast hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if bit score is not set.\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits {\n#---------\n    my $self = shift;\n\n    # The check for $self->{'_bits'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($bits);\n    if(not defined($self->{'_bits'})) {\n        $bits = $self->hsp->bits;\n    } else {\n        $bits = $self->{'_bits'};\n    }\n    return $bits;\n}\n\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n {\n#-----\n    my $self = shift;\n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n        $n = $self->hsp->n;\n    } else {\n        $n = $self->{'_n'};\n    }\n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\n#----------'\nsub frame {\n#----------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'};\n    }\n    return $frame;\n}\n\n\n\n\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p {\n#--------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(not defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using expect() instead.\");\n        $val = $self->{'_expect'};\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n\n\n=head2 expect\n\n Usage     : $hit_object->expect( [format] );\n Purpose   : Get the Expect value for the best HSP of the given BLAST hit.\n Example   : $e =  $sbjct->expect;\n           : $e =  $sbjct->expect('exp');  # get exponent only.\n           : ($num, $exp) = $sbjct->expect('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and Expect\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : Exception if the Expect value is not defined.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-----------\nsub expect {\n#-----------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val;\n\n    # For Blast reports that list the P value on the description line,\n    # getting the expect value requires fully parsing the HSP data.\n    # For NCBI blast, there's no problem.\n    if(not defined($self->{'_expect'})) {\n        if( defined $self->{'_hsps'}) {\n            $self->{'_expect'} = $val = $self->hsp->expect;\n        } else {\n            # If _expect is not set and _hsps are not set,\n            # then this must be a P-value-based report that was\n            # run without setting the HSPs (shallow parsing).\n            $self->throw(\"Can't get expect value. HSPs have not been set.\");\n        }\n    } else {\n        $val = $self->{'_expect'};\n    }\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get Expect value.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw Expect-value.\n    return $val;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return wantarray\n        #  returning list containing all HSPs.\n        ? @{$self->{'_hsps'}}\n        #  returning number of HSPs.\n        : scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single BlastHSP.pm object for the present PsiBlastHit.pm object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp {\n#----------\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = @{$self->{'_hsps'}};\n\n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    my $self = shift;\n\n    if (not defined $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : For query sequence of BLASTX and TBLASTX reports and the hit\n           : sequence of TBLASTN and TBLASTX reports, the returned length\n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len = $hit_object->logical_length();\n Returns   : Integer\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with T?BLASTX type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length {\n#--------------------\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my $length;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->{'_logical_length'} || $self->{'_length'};\n    }\n    else {\n        # Otherwise, return logical query length\n        $length = $self->{'_query_length'};\n\n        # Adjust length based on BLAST flavor.\n        if($self->{'_blast_program'} =~ /T?BLASTX/ ) {\n            $length /= 3;\n        }\n    }\n    return $length;\n}\n\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           :\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\n#---------------'\nsub length_aln {\n#---------------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    my $data = $self->{'_length_aln_'.$seqType};\n\n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\"\" .\n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }\n    $data;\n}\n\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, sbjct, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers\n           :    (queryGaps, sbjctGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed\n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations\n           : such as printf \"%d\", $hit->gaps() in which you might expect to\n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\n#----------\nsub gaps {\n#----------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    $seqType = lc($seqType);\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}\n\n\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches\n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives'\n           :         in the Blast report.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons');\n Returns   : Integer or a 2-element array of integers\n Argument  : class = 'id' | 'cons' OR none.\n           : If no argument is provided, both identical and conservative\n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the\n           : conservative matches are returned.)\n Throws    : Exception if the requested data cannot be obtained.\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : Does not rely on wantarray to return a list. Only checks for\n           : the presence of an argument (no arg = return list).\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::matches()|Bio::Search::HSP::BlastHSP>, L<hsps()|hsps>\n\n\n#---------------\nsub matches {\n#---------------\n    my( $self, $arg) = @_;\n    my(@data,$data);\n\n    if(!$arg) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data if @data;\n\n    } else {\n\n        if($arg =~ /^id/i) {\n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        return $data if $data;\n    }\n\n    ## Something went wrong if we make it to here.\n    $self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the PsiBlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If there is more than one\n           : HSP and they have not already been tiled, they will be tiled first automatically..\n           : Remember that the start and end coordinates of all HSPs are\n           : normalized so that start < end. Strand information can be\n           : obtained by calling $hit->strand().\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, L<HSP Tiling and Ambiguous Alignments>, L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    } else {\n        Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the PsiBlastHit object. If there is more than one HSP, the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If there is more than one\n           : HSP and they have not already been tiled, they will be tiled first automatically..\n           : Remember that the start and end coordinates of all HSPs are\n           : normalized so that start < end. Strand information can be\n           : obtained by calling $hit->strand().\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>, L<HSP Tiling and Ambiguous Alignments>, L<Bio::Search::HSP::BlastHSP::end|Bio::Search::HSP::BlastHSP>","parameters":[{"label":"$self"},{"label":"$seqType"}]},"name":"end","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"end","kind":13,"name":"$self","line":1432},{"name":"$seqType","kind":13,"containerName":"end","line":1432},{"kind":13,"containerName":"end","name":"$seqType","line":1434},{"kind":13,"containerName":"end","name":"$seqType","line":1435},{"line":1435,"name":"$seqType","kind":13,"containerName":"end"},{"line":1438,"name":"$self","containerName":"end","kind":13},{"line":1438,"kind":12,"containerName":"end","name":"num_hsps"},{"name":"$self","kind":13,"containerName":"end","line":1439},{"line":1439,"name":"hsp","kind":12,"containerName":"end"},{"line":1439,"containerName":"end","kind":12,"name":"end"},{"line":1439,"containerName":"end","kind":13,"name":"$seqType"},{"line":1441,"containerName":"end","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"end","line":1441},{"line":1442,"name":"$seqType","containerName":"end","kind":13},{"kind":13,"containerName":"end","name":"$self","line":1443},{"line":1443,"containerName":"end","kind":13,"name":"$self"},{"line":1446,"name":"$seqType","containerName":"end","kind":13},{"containerName":"end","kind":13,"name":"$self","line":1447},{"kind":13,"containerName":"end","name":"$seqType","line":1447}],"detail":"($self,$seqType)","definition":"sub"},{"containerName":"Search::BlastUtils::tile_hsps","kind":12,"name":"Bio","line":1441},{"kind":12,"range":{"end":{"line":1475,"character":9999},"start":{"character":0,"line":1469}},"line":1469,"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-------------\nsub signif {\n#-------------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get P- or Expect value: HSPs may not have been set.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P/Expect-value.\n    return $val;\n}\n\n#----------------\nsub raw_hit_data {\n#----------------\n    my $self = shift;\n    my $data = '>';\n    # Need to add blank lines where we've removed them.\n    foreach( @{$self->{'_hit_data'}} ) {\n        if( $_ eq 'end') {\n            $data .= \"\\n\";\n        }\n        else {\n            $data .= /^\\s*(Score|Query)/ ? \"\\n$_\" : $_;\n        }\n    }\n    return $data;\n}\n\n\n#=head2 _set_length\n#\n# Usage     : $hit_object->_set_length( \"233\" );\n# Purpose   : Set the total length of the hit sequence.\n# Example   : $hit_object->_set_length( $len );\n# Returns   : n/a\n# Argument  : Integer (only when setting). Any commas will be stripped out.\n# Throws    : n/a\n#\n#=cut\n\n#-----------\nsub _set_length {\n#-----------\n    my ($self, $len) = @_;\n    $len =~ s/,//g; # get rid of commas\n    $self->{'_length'} = $len;\n}\n\n#=head2 _set_description\n#\n# Usage     : Private method; called automatically during construction\n# Purpose   : Sets the description of the hit sequence.\n#            : For sequence without descriptions, does not set any description.\n# Argument  : Array containing description (multiple lines).\n# Comments  : Processes the supplied description:\n#                1. Join all lines into one string.\n#                2. Remove sequence id at the beginning of description.\n#                3. Removes junk charactes at begin and end of description.\n#\n#=cut\n\n#--------------\nsub _set_description {\n#--------------\n    my( $self, @desc ) = @_;\n    my( $desc);\n\n#    print STDERR \"PsiBlastHit: RAW DESC:\\n@desc\\n\";\n\n    $desc = join(\" \", @desc);\n\n    my $name = $self->name;\n\n    if($desc) {\n        $desc =~ s/^\\s*\\S+\\s+//; # remove the sequence ID(s)\n                                 # This won't work if there's no description.\n        $desc =~ s/^\\s*$name//;  # ...but this should.\n        $desc =~ s/^[\\s!]+//;\n        $desc =~ s/ \\d+$//;\n        $desc =~ s/\\.+$//;\n        $self->{'_description'} = $desc;\n    }\n\n#    print STDERR \"PsiBlastHit: _set_description =  $desc\\n\";\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hit->to_string;\n Function: Returns a string representation for the Blast Hit.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHit] <name> <description>\n           e.g.:\n           [PsiBlastHit] emb|Z46660|SC9725 S.cerevisiae chromosome XIII cosmid\n Args    : None\n\n\n#----------------\nsub to_string {\n#----------------\n    my $self = shift;\n    return \"[PsiBlastHit] \" . $self->name . \" \" . $self->description;\n}\n\n\n#=head2 _set_id\n#\n# Usage     : Private method; automatically called by new()\n# Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n#           : The identifier is assumed to be the first\n#           : chunk of non-whitespace characters in the description line\n#           : Does not assume any semantics in the structure of the identifier\n#           : (Formerly, this method attempted to extract database name from\n#           : the seq identifiers, but this was prone to break).\n# Returns   : n/a\n# Argument  : String containing description line of the hit from Blast report\n#           : or first line of an alignment section (with or without the leading '>').\n# Throws    : Warning if cannot locate sequence ID.\n#\n#See Also   : L<new()|new>, L<accession()|accession>\n#\n#=cut\n\n#---------------\nsub _set_id {\n#---------------\n    my( $self, $desc ) = @_;\n\n    # New strategy: Assume only that the ID is the first white space\n    # delimited chunk. Not attempting to extract accession & database name.\n    # Clients will have to interpret it as necessary.\n    if($desc =~ /^>?(\\S+)\\s*(.*)/) {\n        my ($name, $desc) = ($1, $2);\n        $self->name($name);\n        $self->{'_description'} = $desc;\n        # Note that this description comes from the summary section of the\n        # BLAST report and so may be truncated. The full description will be\n        # set from the alignment section. We're setting description here in case\n        # the alignment section isn't being parsed.\n\n        # Assuming accession is delimited with | symbols (NCBI-style)\n        my @pieces = split(/\\|/,$name);\n        my $acc = pop @pieces;\n        $self->accession( $acc );\n    }\n    else {\n        $self->warn(\"Can't locate sequence identifier in summary line.\", \"Line = $desc\");\n        $desc = 'Unknown sequence ID' if not $desc;\n        $self->name($desc);\n    }\n}\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences\n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences\n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains\n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Status    : Experimental\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps>, L<HSP Tiling and Ambiguous Alignments>\n\n\n#--------------------\nsub ambiguous_aln {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n\n\n=head2 overlap\n\n Usage     : $blast_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $blast_object->overlap(5);\n           : $overlap = $blast_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by Bio::Search::BlastUtils::_adjust_contigs().\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap {\n#-------------\n    my $self = shift;\n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n\n\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the BLAST bit score of the best HSP for the current Blast hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if bit score is not set.\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits {\n#---------\n    my $self = shift;\n\n    # The check for $self->{'_bits'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($bits);\n    if(not defined($self->{'_bits'})) {\n        $bits = $self->hsp->bits;\n    } else {\n        $bits = $self->{'_bits'};\n    }\n    return $bits;\n}\n\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n {\n#-----\n    my $self = shift;\n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n        $n = $self->hsp->n;\n    } else {\n        $n = $self->{'_n'};\n    }\n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\n#----------'\nsub frame {\n#----------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'};\n    }\n    return $frame;\n}\n\n\n\n\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p {\n#--------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(not defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using expect() instead.\");\n        $val = $self->{'_expect'};\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n\n\n=head2 expect\n\n Usage     : $hit_object->expect( [format] );\n Purpose   : Get the Expect value for the best HSP of the given BLAST hit.\n Example   : $e =  $sbjct->expect;\n           : $e =  $sbjct->expect('exp');  # get exponent only.\n           : ($num, $exp) = $sbjct->expect('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and Expect\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : Exception if the Expect value is not defined.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-----------\nsub expect {\n#-----------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val;\n\n    # For Blast reports that list the P value on the description line,\n    # getting the expect value requires fully parsing the HSP data.\n    # For NCBI blast, there's no problem.\n    if(not defined($self->{'_expect'})) {\n        if( defined $self->{'_hsps'}) {\n            $self->{'_expect'} = $val = $self->hsp->expect;\n        } else {\n            # If _expect is not set and _hsps are not set,\n            # then this must be a P-value-based report that was\n            # run without setting the HSPs (shallow parsing).\n            $self->throw(\"Can't get expect value. HSPs have not been set.\");\n        }\n    } else {\n        $val = $self->{'_expect'};\n    }\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get Expect value.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw Expect-value.\n    return $val;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return wantarray\n        #  returning list containing all HSPs.\n        ? @{$self->{'_hsps'}}\n        #  returning number of HSPs.\n        : scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single BlastHSP.pm object for the present PsiBlastHit.pm object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp {\n#----------\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = @{$self->{'_hsps'}};\n\n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    my $self = shift;\n\n    if (not defined $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : For query sequence of BLASTX and TBLASTX reports and the hit\n           : sequence of TBLASTN and TBLASTX reports, the returned length\n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len = $hit_object->logical_length();\n Returns   : Integer\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with T?BLASTX type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length {\n#--------------------\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my $length;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->{'_logical_length'} || $self->{'_length'};\n    }\n    else {\n        # Otherwise, return logical query length\n        $length = $self->{'_query_length'};\n\n        # Adjust length based on BLAST flavor.\n        if($self->{'_blast_program'} =~ /T?BLASTX/ ) {\n            $length /= 3;\n        }\n    }\n    return $length;\n}\n\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           :\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\n#---------------'\nsub length_aln {\n#---------------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    my $data = $self->{'_length_aln_'.$seqType};\n\n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\"\" .\n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }\n    $data;\n}\n\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, sbjct, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers\n           :    (queryGaps, sbjctGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed\n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations\n           : such as printf \"%d\", $hit->gaps() in which you might expect to\n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\n#----------\nsub gaps {\n#----------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    $seqType = lc($seqType);\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}\n\n\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches\n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives'\n           :         in the Blast report.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons');\n Returns   : Integer or a 2-element array of integers\n Argument  : class = 'id' | 'cons' OR none.\n           : If no argument is provided, both identical and conservative\n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the\n           : conservative matches are returned.)\n Throws    : Exception if the requested data cannot be obtained.\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : Does not rely on wantarray to return a list. Only checks for\n           : the presence of an argument (no arg = return list).\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::matches()|Bio::Search::HSP::BlastHSP>, L<hsps()|hsps>\n\n\n#---------------\nsub matches {\n#---------------\n    my( $self, $arg) = @_;\n    my(@data,$data);\n\n    if(!$arg) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data if @data;\n\n    } else {\n\n        if($arg =~ /^id/i) {\n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        return $data if $data;\n    }\n\n    ## Something went wrong if we make it to here.\n    $self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the PsiBlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If there is more than one\n           : HSP and they have not already been tiled, they will be tiled first automatically..\n           : Remember that the start and end coordinates of all HSPs are\n           : normalized so that start < end. Strand information can be\n           : obtained by calling $hit->strand().\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, L<HSP Tiling and Ambiguous Alignments>, L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    } else {\n        Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the PsiBlastHit object. If there is more than one HSP, the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If there is more than one\n           : HSP and they have not already been tiled, they will be tiled first automatically..\n           : Remember that the start and end coordinates of all HSPs are\n           : normalized so that start < end. Strand information can be\n           : obtained by calling $hit->strand().\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>, L<HSP Tiling and Ambiguous Alignments>, L<Bio::Search::HSP::BlastHSP::end|Bio::Search::HSP::BlastHSP>\n\n\n#----------\nsub end {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    } else {\n        Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>","label":"range($self,$seqType)"},"name":"range","containerName":"main::","children":[{"definition":"my","line":1471,"name":"$self","kind":13,"localvar":"my","containerName":"range"},{"kind":13,"containerName":"range","name":"$seqType","line":1471},{"name":"$seqType","containerName":"range","kind":13,"line":1472},{"kind":13,"containerName":"range","name":"$seqType","line":1473},{"containerName":"range","kind":13,"name":"$seqType","line":1473},{"line":1474,"containerName":"range","kind":13,"name":"$self"},{"name":"start","containerName":"range","kind":12,"line":1474},{"kind":13,"containerName":"range","name":"$seqType","line":1474},{"name":"$self","kind":13,"containerName":"range","line":1474},{"line":1474,"kind":12,"containerName":"range","name":"end"},{"line":1474,"kind":13,"containerName":"range","name":"$seqType"}],"detail":"($self,$seqType)","definition":"sub"},{"detail":"($self,$seqType)","definition":"sub","name":"frac_identical","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"frac_identical","kind":13,"name":"$self","line":1518},{"line":1518,"containerName":"frac_identical","kind":13,"name":"$seqType"},{"line":1519,"name":"$seqType","containerName":"frac_identical","kind":13},{"name":"$seqType","containerName":"frac_identical","kind":13,"line":1520},{"name":"$seqType","containerName":"frac_identical","kind":13,"line":1520},{"line":1523,"name":"$seqType","containerName":"frac_identical","kind":13},{"line":1523,"kind":13,"containerName":"frac_identical","name":"$seqType"},{"name":"$self","containerName":"frac_identical","kind":13,"line":1525},{"containerName":"frac_identical","kind":13,"name":"$self","line":1525},{"line":1527,"name":"$self","kind":13,"containerName":"frac_identical"},{"name":"$self","kind":13,"containerName":"frac_identical","line":1527},{"line":1527,"name":"$seqType","containerName":"frac_identical","kind":13}],"signature":{"label":"frac_identical($self,$seqType)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-------------\nsub signif {\n#-------------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get P- or Expect value: HSPs may not have been set.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P/Expect-value.\n    return $val;\n}\n\n#----------------\nsub raw_hit_data {\n#----------------\n    my $self = shift;\n    my $data = '>';\n    # Need to add blank lines where we've removed them.\n    foreach( @{$self->{'_hit_data'}} ) {\n        if( $_ eq 'end') {\n            $data .= \"\\n\";\n        }\n        else {\n            $data .= /^\\s*(Score|Query)/ ? \"\\n$_\" : $_;\n        }\n    }\n    return $data;\n}\n\n\n#=head2 _set_length\n#\n# Usage     : $hit_object->_set_length( \"233\" );\n# Purpose   : Set the total length of the hit sequence.\n# Example   : $hit_object->_set_length( $len );\n# Returns   : n/a\n# Argument  : Integer (only when setting). Any commas will be stripped out.\n# Throws    : n/a\n#\n#=cut\n\n#-----------\nsub _set_length {\n#-----------\n    my ($self, $len) = @_;\n    $len =~ s/,//g; # get rid of commas\n    $self->{'_length'} = $len;\n}\n\n#=head2 _set_description\n#\n# Usage     : Private method; called automatically during construction\n# Purpose   : Sets the description of the hit sequence.\n#            : For sequence without descriptions, does not set any description.\n# Argument  : Array containing description (multiple lines).\n# Comments  : Processes the supplied description:\n#                1. Join all lines into one string.\n#                2. Remove sequence id at the beginning of description.\n#                3. Removes junk charactes at begin and end of description.\n#\n#=cut\n\n#--------------\nsub _set_description {\n#--------------\n    my( $self, @desc ) = @_;\n    my( $desc);\n\n#    print STDERR \"PsiBlastHit: RAW DESC:\\n@desc\\n\";\n\n    $desc = join(\" \", @desc);\n\n    my $name = $self->name;\n\n    if($desc) {\n        $desc =~ s/^\\s*\\S+\\s+//; # remove the sequence ID(s)\n                                 # This won't work if there's no description.\n        $desc =~ s/^\\s*$name//;  # ...but this should.\n        $desc =~ s/^[\\s!]+//;\n        $desc =~ s/ \\d+$//;\n        $desc =~ s/\\.+$//;\n        $self->{'_description'} = $desc;\n    }\n\n#    print STDERR \"PsiBlastHit: _set_description =  $desc\\n\";\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hit->to_string;\n Function: Returns a string representation for the Blast Hit.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHit] <name> <description>\n           e.g.:\n           [PsiBlastHit] emb|Z46660|SC9725 S.cerevisiae chromosome XIII cosmid\n Args    : None\n\n\n#----------------\nsub to_string {\n#----------------\n    my $self = shift;\n    return \"[PsiBlastHit] \" . $self->name . \" \" . $self->description;\n}\n\n\n#=head2 _set_id\n#\n# Usage     : Private method; automatically called by new()\n# Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n#           : The identifier is assumed to be the first\n#           : chunk of non-whitespace characters in the description line\n#           : Does not assume any semantics in the structure of the identifier\n#           : (Formerly, this method attempted to extract database name from\n#           : the seq identifiers, but this was prone to break).\n# Returns   : n/a\n# Argument  : String containing description line of the hit from Blast report\n#           : or first line of an alignment section (with or without the leading '>').\n# Throws    : Warning if cannot locate sequence ID.\n#\n#See Also   : L<new()|new>, L<accession()|accession>\n#\n#=cut\n\n#---------------\nsub _set_id {\n#---------------\n    my( $self, $desc ) = @_;\n\n    # New strategy: Assume only that the ID is the first white space\n    # delimited chunk. Not attempting to extract accession & database name.\n    # Clients will have to interpret it as necessary.\n    if($desc =~ /^>?(\\S+)\\s*(.*)/) {\n        my ($name, $desc) = ($1, $2);\n        $self->name($name);\n        $self->{'_description'} = $desc;\n        # Note that this description comes from the summary section of the\n        # BLAST report and so may be truncated. The full description will be\n        # set from the alignment section. We're setting description here in case\n        # the alignment section isn't being parsed.\n\n        # Assuming accession is delimited with | symbols (NCBI-style)\n        my @pieces = split(/\\|/,$name);\n        my $acc = pop @pieces;\n        $self->accession( $acc );\n    }\n    else {\n        $self->warn(\"Can't locate sequence identifier in summary line.\", \"Line = $desc\");\n        $desc = 'Unknown sequence ID' if not $desc;\n        $self->name($desc);\n    }\n}\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences\n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences\n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains\n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Status    : Experimental\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps>, L<HSP Tiling and Ambiguous Alignments>\n\n\n#--------------------\nsub ambiguous_aln {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n\n\n=head2 overlap\n\n Usage     : $blast_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $blast_object->overlap(5);\n           : $overlap = $blast_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by Bio::Search::BlastUtils::_adjust_contigs().\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap {\n#-------------\n    my $self = shift;\n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n\n\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the BLAST bit score of the best HSP for the current Blast hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if bit score is not set.\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits {\n#---------\n    my $self = shift;\n\n    # The check for $self->{'_bits'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($bits);\n    if(not defined($self->{'_bits'})) {\n        $bits = $self->hsp->bits;\n    } else {\n        $bits = $self->{'_bits'};\n    }\n    return $bits;\n}\n\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n {\n#-----\n    my $self = shift;\n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n        $n = $self->hsp->n;\n    } else {\n        $n = $self->{'_n'};\n    }\n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\n#----------'\nsub frame {\n#----------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'};\n    }\n    return $frame;\n}\n\n\n\n\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p {\n#--------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(not defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using expect() instead.\");\n        $val = $self->{'_expect'};\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n\n\n=head2 expect\n\n Usage     : $hit_object->expect( [format] );\n Purpose   : Get the Expect value for the best HSP of the given BLAST hit.\n Example   : $e =  $sbjct->expect;\n           : $e =  $sbjct->expect('exp');  # get exponent only.\n           : ($num, $exp) = $sbjct->expect('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and Expect\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : Exception if the Expect value is not defined.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-----------\nsub expect {\n#-----------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val;\n\n    # For Blast reports that list the P value on the description line,\n    # getting the expect value requires fully parsing the HSP data.\n    # For NCBI blast, there's no problem.\n    if(not defined($self->{'_expect'})) {\n        if( defined $self->{'_hsps'}) {\n            $self->{'_expect'} = $val = $self->hsp->expect;\n        } else {\n            # If _expect is not set and _hsps are not set,\n            # then this must be a P-value-based report that was\n            # run without setting the HSPs (shallow parsing).\n            $self->throw(\"Can't get expect value. HSPs have not been set.\");\n        }\n    } else {\n        $val = $self->{'_expect'};\n    }\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get Expect value.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw Expect-value.\n    return $val;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return wantarray\n        #  returning list containing all HSPs.\n        ? @{$self->{'_hsps'}}\n        #  returning number of HSPs.\n        : scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single BlastHSP.pm object for the present PsiBlastHit.pm object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp {\n#----------\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = @{$self->{'_hsps'}};\n\n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    my $self = shift;\n\n    if (not defined $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : For query sequence of BLASTX and TBLASTX reports and the hit\n           : sequence of TBLASTN and TBLASTX reports, the returned length\n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len = $hit_object->logical_length();\n Returns   : Integer\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with T?BLASTX type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length {\n#--------------------\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my $length;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->{'_logical_length'} || $self->{'_length'};\n    }\n    else {\n        # Otherwise, return logical query length\n        $length = $self->{'_query_length'};\n\n        # Adjust length based on BLAST flavor.\n        if($self->{'_blast_program'} =~ /T?BLASTX/ ) {\n            $length /= 3;\n        }\n    }\n    return $length;\n}\n\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           :\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\n#---------------'\nsub length_aln {\n#---------------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    my $data = $self->{'_length_aln_'.$seqType};\n\n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\"\" .\n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }\n    $data;\n}\n\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, sbjct, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers\n           :    (queryGaps, sbjctGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed\n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations\n           : such as printf \"%d\", $hit->gaps() in which you might expect to\n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\n#----------\nsub gaps {\n#----------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    $seqType = lc($seqType);\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}\n\n\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches\n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives'\n           :         in the Blast report.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons');\n Returns   : Integer or a 2-element array of integers\n Argument  : class = 'id' | 'cons' OR none.\n           : If no argument is provided, both identical and conservative\n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the\n           : conservative matches are returned.)\n Throws    : Exception if the requested data cannot be obtained.\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : Does not rely on wantarray to return a list. Only checks for\n           : the presence of an argument (no arg = return list).\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::matches()|Bio::Search::HSP::BlastHSP>, L<hsps()|hsps>\n\n\n#---------------\nsub matches {\n#---------------\n    my( $self, $arg) = @_;\n    my(@data,$data);\n\n    if(!$arg) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data if @data;\n\n    } else {\n\n        if($arg =~ /^id/i) {\n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        return $data if $data;\n    }\n\n    ## Something went wrong if we make it to here.\n    $self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the PsiBlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If there is more than one\n           : HSP and they have not already been tiled, they will be tiled first automatically..\n           : Remember that the start and end coordinates of all HSPs are\n           : normalized so that start < end. Strand information can be\n           : obtained by calling $hit->strand().\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, L<HSP Tiling and Ambiguous Alignments>, L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    } else {\n        Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the PsiBlastHit object. If there is more than one HSP, the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If there is more than one\n           : HSP and they have not already been tiled, they will be tiled first automatically..\n           : Remember that the start and end coordinates of all HSPs are\n           : normalized so that start < end. Strand information can be\n           : obtained by calling $hit->strand().\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>, L<HSP Tiling and Ambiguous Alignments>, L<Bio::Search::HSP::BlastHSP::end|Bio::Search::HSP::BlastHSP>\n\n\n#----------\nsub end {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    } else {\n        Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or\n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>","parameters":[{"label":"$self"},{"label":"$seqType"}]},"kind":12,"range":{"start":{"character":0,"line":1516},"end":{"line":1528,"character":9999}},"line":1516},{"name":"Bio","kind":12,"containerName":"Search::BlastUtils::tile_hsps","line":1525},{"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-------------\nsub signif {\n#-------------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get P- or Expect value: HSPs may not have been set.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P/Expect-value.\n    return $val;\n}\n\n#----------------\nsub raw_hit_data {\n#----------------\n    my $self = shift;\n    my $data = '>';\n    # Need to add blank lines where we've removed them.\n    foreach( @{$self->{'_hit_data'}} ) {\n        if( $_ eq 'end') {\n            $data .= \"\\n\";\n        }\n        else {\n            $data .= /^\\s*(Score|Query)/ ? \"\\n$_\" : $_;\n        }\n    }\n    return $data;\n}\n\n\n#=head2 _set_length\n#\n# Usage     : $hit_object->_set_length( \"233\" );\n# Purpose   : Set the total length of the hit sequence.\n# Example   : $hit_object->_set_length( $len );\n# Returns   : n/a\n# Argument  : Integer (only when setting). Any commas will be stripped out.\n# Throws    : n/a\n#\n#=cut\n\n#-----------\nsub _set_length {\n#-----------\n    my ($self, $len) = @_;\n    $len =~ s/,//g; # get rid of commas\n    $self->{'_length'} = $len;\n}\n\n#=head2 _set_description\n#\n# Usage     : Private method; called automatically during construction\n# Purpose   : Sets the description of the hit sequence.\n#            : For sequence without descriptions, does not set any description.\n# Argument  : Array containing description (multiple lines).\n# Comments  : Processes the supplied description:\n#                1. Join all lines into one string.\n#                2. Remove sequence id at the beginning of description.\n#                3. Removes junk charactes at begin and end of description.\n#\n#=cut\n\n#--------------\nsub _set_description {\n#--------------\n    my( $self, @desc ) = @_;\n    my( $desc);\n\n#    print STDERR \"PsiBlastHit: RAW DESC:\\n@desc\\n\";\n\n    $desc = join(\" \", @desc);\n\n    my $name = $self->name;\n\n    if($desc) {\n        $desc =~ s/^\\s*\\S+\\s+//; # remove the sequence ID(s)\n                                 # This won't work if there's no description.\n        $desc =~ s/^\\s*$name//;  # ...but this should.\n        $desc =~ s/^[\\s!]+//;\n        $desc =~ s/ \\d+$//;\n        $desc =~ s/\\.+$//;\n        $self->{'_description'} = $desc;\n    }\n\n#    print STDERR \"PsiBlastHit: _set_description =  $desc\\n\";\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hit->to_string;\n Function: Returns a string representation for the Blast Hit.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHit] <name> <description>\n           e.g.:\n           [PsiBlastHit] emb|Z46660|SC9725 S.cerevisiae chromosome XIII cosmid\n Args    : None\n\n\n#----------------\nsub to_string {\n#----------------\n    my $self = shift;\n    return \"[PsiBlastHit] \" . $self->name . \" \" . $self->description;\n}\n\n\n#=head2 _set_id\n#\n# Usage     : Private method; automatically called by new()\n# Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n#           : The identifier is assumed to be the first\n#           : chunk of non-whitespace characters in the description line\n#           : Does not assume any semantics in the structure of the identifier\n#           : (Formerly, this method attempted to extract database name from\n#           : the seq identifiers, but this was prone to break).\n# Returns   : n/a\n# Argument  : String containing description line of the hit from Blast report\n#           : or first line of an alignment section (with or without the leading '>').\n# Throws    : Warning if cannot locate sequence ID.\n#\n#See Also   : L<new()|new>, L<accession()|accession>\n#\n#=cut\n\n#---------------\nsub _set_id {\n#---------------\n    my( $self, $desc ) = @_;\n\n    # New strategy: Assume only that the ID is the first white space\n    # delimited chunk. Not attempting to extract accession & database name.\n    # Clients will have to interpret it as necessary.\n    if($desc =~ /^>?(\\S+)\\s*(.*)/) {\n        my ($name, $desc) = ($1, $2);\n        $self->name($name);\n        $self->{'_description'} = $desc;\n        # Note that this description comes from the summary section of the\n        # BLAST report and so may be truncated. The full description will be\n        # set from the alignment section. We're setting description here in case\n        # the alignment section isn't being parsed.\n\n        # Assuming accession is delimited with | symbols (NCBI-style)\n        my @pieces = split(/\\|/,$name);\n        my $acc = pop @pieces;\n        $self->accession( $acc );\n    }\n    else {\n        $self->warn(\"Can't locate sequence identifier in summary line.\", \"Line = $desc\");\n        $desc = 'Unknown sequence ID' if not $desc;\n        $self->name($desc);\n    }\n}\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences\n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences\n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains\n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Status    : Experimental\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps>, L<HSP Tiling and Ambiguous Alignments>\n\n\n#--------------------\nsub ambiguous_aln {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n\n\n=head2 overlap\n\n Usage     : $blast_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $blast_object->overlap(5);\n           : $overlap = $blast_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by Bio::Search::BlastUtils::_adjust_contigs().\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap {\n#-------------\n    my $self = shift;\n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n\n\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the BLAST bit score of the best HSP for the current Blast hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if bit score is not set.\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits {\n#---------\n    my $self = shift;\n\n    # The check for $self->{'_bits'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($bits);\n    if(not defined($self->{'_bits'})) {\n        $bits = $self->hsp->bits;\n    } else {\n        $bits = $self->{'_bits'};\n    }\n    return $bits;\n}\n\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n {\n#-----\n    my $self = shift;\n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n        $n = $self->hsp->n;\n    } else {\n        $n = $self->{'_n'};\n    }\n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\n#----------'\nsub frame {\n#----------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'};\n    }\n    return $frame;\n}\n\n\n\n\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p {\n#--------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(not defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using expect() instead.\");\n        $val = $self->{'_expect'};\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n\n\n=head2 expect\n\n Usage     : $hit_object->expect( [format] );\n Purpose   : Get the Expect value for the best HSP of the given BLAST hit.\n Example   : $e =  $sbjct->expect;\n           : $e =  $sbjct->expect('exp');  # get exponent only.\n           : ($num, $exp) = $sbjct->expect('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and Expect\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : Exception if the Expect value is not defined.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-----------\nsub expect {\n#-----------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val;\n\n    # For Blast reports that list the P value on the description line,\n    # getting the expect value requires fully parsing the HSP data.\n    # For NCBI blast, there's no problem.\n    if(not defined($self->{'_expect'})) {\n        if( defined $self->{'_hsps'}) {\n            $self->{'_expect'} = $val = $self->hsp->expect;\n        } else {\n            # If _expect is not set and _hsps are not set,\n            # then this must be a P-value-based report that was\n            # run without setting the HSPs (shallow parsing).\n            $self->throw(\"Can't get expect value. HSPs have not been set.\");\n        }\n    } else {\n        $val = $self->{'_expect'};\n    }\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get Expect value.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw Expect-value.\n    return $val;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return wantarray\n        #  returning list containing all HSPs.\n        ? @{$self->{'_hsps'}}\n        #  returning number of HSPs.\n        : scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single BlastHSP.pm object for the present PsiBlastHit.pm object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp {\n#----------\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = @{$self->{'_hsps'}};\n\n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    my $self = shift;\n\n    if (not defined $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : For query sequence of BLASTX and TBLASTX reports and the hit\n           : sequence of TBLASTN and TBLASTX reports, the returned length\n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len = $hit_object->logical_length();\n Returns   : Integer\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with T?BLASTX type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length {\n#--------------------\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my $length;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->{'_logical_length'} || $self->{'_length'};\n    }\n    else {\n        # Otherwise, return logical query length\n        $length = $self->{'_query_length'};\n\n        # Adjust length based on BLAST flavor.\n        if($self->{'_blast_program'} =~ /T?BLASTX/ ) {\n            $length /= 3;\n        }\n    }\n    return $length;\n}\n\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           :\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\n#---------------'\nsub length_aln {\n#---------------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    my $data = $self->{'_length_aln_'.$seqType};\n\n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\"\" .\n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }\n    $data;\n}\n\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, sbjct, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers\n           :    (queryGaps, sbjctGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed\n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations\n           : such as printf \"%d\", $hit->gaps() in which you might expect to\n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\n#----------\nsub gaps {\n#----------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    $seqType = lc($seqType);\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}\n\n\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches\n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives'\n           :         in the Blast report.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons');\n Returns   : Integer or a 2-element array of integers\n Argument  : class = 'id' | 'cons' OR none.\n           : If no argument is provided, both identical and conservative\n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the\n           : conservative matches are returned.)\n Throws    : Exception if the requested data cannot be obtained.\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : Does not rely on wantarray to return a list. Only checks for\n           : the presence of an argument (no arg = return list).\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::matches()|Bio::Search::HSP::BlastHSP>, L<hsps()|hsps>\n\n\n#---------------\nsub matches {\n#---------------\n    my( $self, $arg) = @_;\n    my(@data,$data);\n\n    if(!$arg) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data if @data;\n\n    } else {\n\n        if($arg =~ /^id/i) {\n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        return $data if $data;\n    }\n\n    ## Something went wrong if we make it to here.\n    $self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the PsiBlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If there is more than one\n           : HSP and they have not already been tiled, they will be tiled first automatically..\n           : Remember that the start and end coordinates of all HSPs are\n           : normalized so that start < end. Strand information can be\n           : obtained by calling $hit->strand().\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, L<HSP Tiling and Ambiguous Alignments>, L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    } else {\n        Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the PsiBlastHit object. If there is more than one HSP, the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If there is more than one\n           : HSP and they have not already been tiled, they will be tiled first automatically..\n           : Remember that the start and end coordinates of all HSPs are\n           : normalized so that start < end. Strand information can be\n           : obtained by calling $hit->strand().\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>, L<HSP Tiling and Ambiguous Alignments>, L<Bio::Search::HSP::BlastHSP::end|Bio::Search::HSP::BlastHSP>\n\n\n#----------\nsub end {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    } else {\n        Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or\n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n\n#------------------\nsub frac_identical {\n#------------------\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    sprintf( \"%.2f\", $self->{'_totalIdentical'}/$self->{'_length_aln_'.$seqType});\n}\n\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or\n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>","parameters":[{"label":"$self"},{"label":"$seqType"}],"label":"frac_conserved($self,$seqType)"},"range":{"start":{"line":1570,"character":0},"end":{"character":9999,"line":1582}},"kind":12,"line":1570,"detail":"($self,$seqType)","definition":"sub","name":"frac_conserved","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"frac_conserved","name":"$self","line":1572},{"line":1572,"kind":13,"containerName":"frac_conserved","name":"$seqType"},{"line":1573,"containerName":"frac_conserved","kind":13,"name":"$seqType"},{"kind":13,"containerName":"frac_conserved","name":"$seqType","line":1574},{"name":"$seqType","kind":13,"containerName":"frac_conserved","line":1574},{"name":"$seqType","kind":13,"containerName":"frac_conserved","line":1577},{"line":1577,"containerName":"frac_conserved","kind":13,"name":"$seqType"},{"containerName":"frac_conserved","kind":13,"name":"$self","line":1579},{"containerName":"frac_conserved","kind":13,"name":"$self","line":1579},{"name":"$self","kind":13,"containerName":"frac_conserved","line":1581},{"line":1581,"kind":13,"containerName":"frac_conserved","name":"$self"},{"name":"$seqType","containerName":"frac_conserved","kind":13,"line":1581}]},{"containerName":"Search::BlastUtils::tile_hsps","kind":12,"name":"Bio","line":1579},{"line":1612,"kind":12,"range":{"end":{"character":9999,"line":1619},"start":{"character":0,"line":1612}},"definition":"sub","children":[{"definition":"my","line":1614,"name":"$self","localvar":"my","containerName":"frac_aligned_query","kind":13},{"line":1616,"name":"$self","kind":13,"containerName":"frac_aligned_query"},{"name":"$self","kind":13,"containerName":"frac_aligned_query","line":1616},{"name":"$self","containerName":"frac_aligned_query","kind":13,"line":1618},{"line":1618,"kind":13,"containerName":"frac_aligned_query","name":"$self"},{"containerName":"frac_aligned_query","kind":12,"name":"logical_length","line":1618}],"containerName":"main::","name":"frac_aligned_query"},{"name":"Bio","kind":12,"containerName":"Search::BlastUtils::tile_hsps","line":1616},{"definition":"sub","name":"frac_aligned_hit","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"frac_aligned_hit","kind":13,"name":"$self","line":1650},{"containerName":"frac_aligned_hit","kind":13,"name":"$self","line":1652},{"name":"$self","kind":13,"containerName":"frac_aligned_hit","line":1652},{"line":1654,"name":"$self","kind":13,"containerName":"frac_aligned_hit"},{"line":1654,"containerName":"frac_aligned_hit","kind":13,"name":"$self"},{"line":1654,"name":"logical_length","containerName":"frac_aligned_hit","kind":12}],"kind":12,"range":{"end":{"line":1655,"character":9999},"start":{"line":1648,"character":0}},"line":1648},{"line":1652,"kind":12,"containerName":"Search::BlastUtils::tile_hsps","name":"Bio"},{"definition":"sub","children":[{"line":1667,"name":"$self","localvar":"my","kind":13,"containerName":"frac_aligned_sbjct","definition":"my"},{"line":1667,"kind":13,"containerName":"frac_aligned_sbjct","name":"$self"},{"line":1667,"kind":12,"containerName":"frac_aligned_sbjct","name":"frac_aligned_hit"}],"name":"frac_aligned_sbjct","containerName":"main::","line":1667,"range":{"start":{"character":0,"line":1667},"end":{"character":9999,"line":1667}},"kind":12},{"line":1677,"range":{"end":{"character":9999,"line":1677},"start":{"character":0,"line":1677}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"num_unaligned_sbjct","line":1677},{"line":1677,"containerName":"num_unaligned_sbjct","kind":13,"name":"$self"},{"line":1677,"name":"num_unaligned_hit","containerName":"num_unaligned_sbjct","kind":12}],"containerName":"main::","name":"num_unaligned_sbjct"},{"line":1703,"range":{"start":{"line":1703,"character":0},"end":{"character":9999,"line":1711}},"kind":12,"children":[{"kind":13,"localvar":"my","containerName":"num_unaligned_hit","name":"$self","line":1705,"definition":"my"},{"kind":13,"containerName":"num_unaligned_hit","name":"$self","line":1707},{"line":1707,"kind":13,"containerName":"num_unaligned_hit","name":"$self"},{"definition":"my","line":1709,"name":"$num","localvar":"my","kind":13,"containerName":"num_unaligned_hit"},{"name":"$self","kind":13,"containerName":"num_unaligned_hit","line":1709},{"name":"logical_length","kind":12,"containerName":"num_unaligned_hit","line":1709},{"line":1709,"kind":13,"containerName":"num_unaligned_hit","name":"$self"},{"line":1710,"name":"$num","containerName":"num_unaligned_hit","kind":13},{"name":"$num","kind":13,"containerName":"num_unaligned_hit","line":1710}],"name":"num_unaligned_hit","containerName":"main::","definition":"sub"},{"line":1707,"name":"Bio","containerName":"Search::BlastUtils::tile_hsps","kind":12},{"definition":"sub","containerName":"main::","name":"num_unaligned_query","children":[{"localvar":"my","containerName":"num_unaligned_query","kind":13,"name":"$self","line":1737,"definition":"my"},{"kind":13,"containerName":"num_unaligned_query","name":"$self","line":1739},{"name":"$self","kind":13,"containerName":"num_unaligned_query","line":1739},{"definition":"my","line":1741,"name":"$num","localvar":"my","containerName":"num_unaligned_query","kind":13},{"kind":13,"containerName":"num_unaligned_query","name":"$self","line":1741},{"name":"logical_length","containerName":"num_unaligned_query","kind":12,"line":1741},{"line":1741,"name":"$self","kind":13,"containerName":"num_unaligned_query"},{"name":"$num","kind":13,"containerName":"num_unaligned_query","line":1742},{"line":1742,"kind":13,"containerName":"num_unaligned_query","name":"$num"}],"range":{"start":{"line":1735,"character":0},"end":{"character":9999,"line":1743}},"kind":12,"line":1735},{"name":"Bio","kind":12,"containerName":"Search::BlastUtils::tile_hsps","line":1739},{"line":1777,"range":{"end":{"line":1800,"character":9999},"start":{"character":0,"line":1777}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$class"},{"label":"$collapse"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-------------\nsub signif {\n#-------------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get P- or Expect value: HSPs may not have been set.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P/Expect-value.\n    return $val;\n}\n\n#----------------\nsub raw_hit_data {\n#----------------\n    my $self = shift;\n    my $data = '>';\n    # Need to add blank lines where we've removed them.\n    foreach( @{$self->{'_hit_data'}} ) {\n        if( $_ eq 'end') {\n            $data .= \"\\n\";\n        }\n        else {\n            $data .= /^\\s*(Score|Query)/ ? \"\\n$_\" : $_;\n        }\n    }\n    return $data;\n}\n\n\n#=head2 _set_length\n#\n# Usage     : $hit_object->_set_length( \"233\" );\n# Purpose   : Set the total length of the hit sequence.\n# Example   : $hit_object->_set_length( $len );\n# Returns   : n/a\n# Argument  : Integer (only when setting). Any commas will be stripped out.\n# Throws    : n/a\n#\n#=cut\n\n#-----------\nsub _set_length {\n#-----------\n    my ($self, $len) = @_;\n    $len =~ s/,//g; # get rid of commas\n    $self->{'_length'} = $len;\n}\n\n#=head2 _set_description\n#\n# Usage     : Private method; called automatically during construction\n# Purpose   : Sets the description of the hit sequence.\n#            : For sequence without descriptions, does not set any description.\n# Argument  : Array containing description (multiple lines).\n# Comments  : Processes the supplied description:\n#                1. Join all lines into one string.\n#                2. Remove sequence id at the beginning of description.\n#                3. Removes junk charactes at begin and end of description.\n#\n#=cut\n\n#--------------\nsub _set_description {\n#--------------\n    my( $self, @desc ) = @_;\n    my( $desc);\n\n#    print STDERR \"PsiBlastHit: RAW DESC:\\n@desc\\n\";\n\n    $desc = join(\" \", @desc);\n\n    my $name = $self->name;\n\n    if($desc) {\n        $desc =~ s/^\\s*\\S+\\s+//; # remove the sequence ID(s)\n                                 # This won't work if there's no description.\n        $desc =~ s/^\\s*$name//;  # ...but this should.\n        $desc =~ s/^[\\s!]+//;\n        $desc =~ s/ \\d+$//;\n        $desc =~ s/\\.+$//;\n        $self->{'_description'} = $desc;\n    }\n\n#    print STDERR \"PsiBlastHit: _set_description =  $desc\\n\";\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hit->to_string;\n Function: Returns a string representation for the Blast Hit.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHit] <name> <description>\n           e.g.:\n           [PsiBlastHit] emb|Z46660|SC9725 S.cerevisiae chromosome XIII cosmid\n Args    : None\n\n\n#----------------\nsub to_string {\n#----------------\n    my $self = shift;\n    return \"[PsiBlastHit] \" . $self->name . \" \" . $self->description;\n}\n\n\n#=head2 _set_id\n#\n# Usage     : Private method; automatically called by new()\n# Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n#           : The identifier is assumed to be the first\n#           : chunk of non-whitespace characters in the description line\n#           : Does not assume any semantics in the structure of the identifier\n#           : (Formerly, this method attempted to extract database name from\n#           : the seq identifiers, but this was prone to break).\n# Returns   : n/a\n# Argument  : String containing description line of the hit from Blast report\n#           : or first line of an alignment section (with or without the leading '>').\n# Throws    : Warning if cannot locate sequence ID.\n#\n#See Also   : L<new()|new>, L<accession()|accession>\n#\n#=cut\n\n#---------------\nsub _set_id {\n#---------------\n    my( $self, $desc ) = @_;\n\n    # New strategy: Assume only that the ID is the first white space\n    # delimited chunk. Not attempting to extract accession & database name.\n    # Clients will have to interpret it as necessary.\n    if($desc =~ /^>?(\\S+)\\s*(.*)/) {\n        my ($name, $desc) = ($1, $2);\n        $self->name($name);\n        $self->{'_description'} = $desc;\n        # Note that this description comes from the summary section of the\n        # BLAST report and so may be truncated. The full description will be\n        # set from the alignment section. We're setting description here in case\n        # the alignment section isn't being parsed.\n\n        # Assuming accession is delimited with | symbols (NCBI-style)\n        my @pieces = split(/\\|/,$name);\n        my $acc = pop @pieces;\n        $self->accession( $acc );\n    }\n    else {\n        $self->warn(\"Can't locate sequence identifier in summary line.\", \"Line = $desc\");\n        $desc = 'Unknown sequence ID' if not $desc;\n        $self->name($desc);\n    }\n}\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences\n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences\n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains\n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Status    : Experimental\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps>, L<HSP Tiling and Ambiguous Alignments>\n\n\n#--------------------\nsub ambiguous_aln {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n\n\n=head2 overlap\n\n Usage     : $blast_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $blast_object->overlap(5);\n           : $overlap = $blast_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by Bio::Search::BlastUtils::_adjust_contigs().\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap {\n#-------------\n    my $self = shift;\n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n\n\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the BLAST bit score of the best HSP for the current Blast hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if bit score is not set.\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits {\n#---------\n    my $self = shift;\n\n    # The check for $self->{'_bits'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($bits);\n    if(not defined($self->{'_bits'})) {\n        $bits = $self->hsp->bits;\n    } else {\n        $bits = $self->{'_bits'};\n    }\n    return $bits;\n}\n\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n {\n#-----\n    my $self = shift;\n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n        $n = $self->hsp->n;\n    } else {\n        $n = $self->{'_n'};\n    }\n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\n#----------'\nsub frame {\n#----------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'};\n    }\n    return $frame;\n}\n\n\n\n\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p {\n#--------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(not defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using expect() instead.\");\n        $val = $self->{'_expect'};\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n\n\n=head2 expect\n\n Usage     : $hit_object->expect( [format] );\n Purpose   : Get the Expect value for the best HSP of the given BLAST hit.\n Example   : $e =  $sbjct->expect;\n           : $e =  $sbjct->expect('exp');  # get exponent only.\n           : ($num, $exp) = $sbjct->expect('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and Expect\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : Exception if the Expect value is not defined.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-----------\nsub expect {\n#-----------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val;\n\n    # For Blast reports that list the P value on the description line,\n    # getting the expect value requires fully parsing the HSP data.\n    # For NCBI blast, there's no problem.\n    if(not defined($self->{'_expect'})) {\n        if( defined $self->{'_hsps'}) {\n            $self->{'_expect'} = $val = $self->hsp->expect;\n        } else {\n            # If _expect is not set and _hsps are not set,\n            # then this must be a P-value-based report that was\n            # run without setting the HSPs (shallow parsing).\n            $self->throw(\"Can't get expect value. HSPs have not been set.\");\n        }\n    } else {\n        $val = $self->{'_expect'};\n    }\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get Expect value.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw Expect-value.\n    return $val;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return wantarray\n        #  returning list containing all HSPs.\n        ? @{$self->{'_hsps'}}\n        #  returning number of HSPs.\n        : scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single BlastHSP.pm object for the present PsiBlastHit.pm object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp {\n#----------\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = @{$self->{'_hsps'}};\n\n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    my $self = shift;\n\n    if (not defined $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : For query sequence of BLASTX and TBLASTX reports and the hit\n           : sequence of TBLASTN and TBLASTX reports, the returned length\n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len = $hit_object->logical_length();\n Returns   : Integer\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with T?BLASTX type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length {\n#--------------------\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my $length;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->{'_logical_length'} || $self->{'_length'};\n    }\n    else {\n        # Otherwise, return logical query length\n        $length = $self->{'_query_length'};\n\n        # Adjust length based on BLAST flavor.\n        if($self->{'_blast_program'} =~ /T?BLASTX/ ) {\n            $length /= 3;\n        }\n    }\n    return $length;\n}\n\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           :\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\n#---------------'\nsub length_aln {\n#---------------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    my $data = $self->{'_length_aln_'.$seqType};\n\n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\"\" .\n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }\n    $data;\n}\n\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, sbjct, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers\n           :    (queryGaps, sbjctGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed\n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations\n           : such as printf \"%d\", $hit->gaps() in which you might expect to\n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\n#----------\nsub gaps {\n#----------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    $seqType = lc($seqType);\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}\n\n\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches\n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives'\n           :         in the Blast report.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons');\n Returns   : Integer or a 2-element array of integers\n Argument  : class = 'id' | 'cons' OR none.\n           : If no argument is provided, both identical and conservative\n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the\n           : conservative matches are returned.)\n Throws    : Exception if the requested data cannot be obtained.\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : Does not rely on wantarray to return a list. Only checks for\n           : the presence of an argument (no arg = return list).\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::matches()|Bio::Search::HSP::BlastHSP>, L<hsps()|hsps>\n\n\n#---------------\nsub matches {\n#---------------\n    my( $self, $arg) = @_;\n    my(@data,$data);\n\n    if(!$arg) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data if @data;\n\n    } else {\n\n        if($arg =~ /^id/i) {\n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        return $data if $data;\n    }\n\n    ## Something went wrong if we make it to here.\n    $self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the PsiBlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If there is more than one\n           : HSP and they have not already been tiled, they will be tiled first automatically..\n           : Remember that the start and end coordinates of all HSPs are\n           : normalized so that start < end. Strand information can be\n           : obtained by calling $hit->strand().\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, L<HSP Tiling and Ambiguous Alignments>, L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    } else {\n        Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the PsiBlastHit object. If there is more than one HSP, the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If there is more than one\n           : HSP and they have not already been tiled, they will be tiled first automatically..\n           : Remember that the start and end coordinates of all HSPs are\n           : normalized so that start < end. Strand information can be\n           : obtained by calling $hit->strand().\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>, L<HSP Tiling and Ambiguous Alignments>, L<Bio::Search::HSP::BlastHSP::end|Bio::Search::HSP::BlastHSP>\n\n\n#----------\nsub end {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    } else {\n        Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or\n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n\n#------------------\nsub frac_identical {\n#------------------\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    sprintf( \"%.2f\", $self->{'_totalIdentical'}/$self->{'_length_aln_'.$seqType});\n}\n\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or\n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    sprintf( \"%.2f\", $self->{'_totalConserved'}/$self->{'_length_aln_'.$seqType});\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : To compute the fraction aligned, the logical length of the query\n           : sequence is used, meaning that for [T]BLASTX reports, the\n           : full length of the query sequence is converted into amino acids\n           : by dividing by 3. This is necessary because of the way\n           : the lengths of aligned sequences are computed.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n\n#----------------------\nsub frac_aligned_query {\n#----------------------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    sprintf( \"%.2f\", $self->{'_length_aln_query'}/$self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : To compute the fraction aligned, the logical length of the sbjct\n           : sequence is used, meaning that for TBLAST[NX] reports, the\n           : full length of the sbjct sequence is converted into amino acids\n           : by dividing by 3. This is necessary because of the way\n           : the lengths of aligned sequences are computed.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n\n#--------------------\nsub frac_aligned_hit {\n#--------------------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    sprintf( \"%.2f\", $self->{'_length_aln_sbjct'}/$self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility.\n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#----------------\nsub frac_aligned_sbjct {  my $self=shift; $self->frac_aligned_hit(@_); }\n#----------------\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n#----------------\nsub num_unaligned_sbjct {  my $self=shift; $self->num_unaligned_hit(@_); }\n#----------------\n\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#---------------------\nsub num_unaligned_hit {\n#---------------------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    my $num = $self->logical_length('sbjct') - $self->{'_length_aln_sbjct'};\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n\n#-----------------------\nsub num_unaligned_query {\n#-----------------------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    my $num = $self->logical_length('query') - $self->{'_length_aln_query'};\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers\n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\"\n           :             collapses to \"1-5 7 9-11\". This is useful for\n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : Note that HSPs are not tiled for this. This could be a problem\n           : for hits containing mutually exclusive HSPs.\n           : TODO: Consider tiling and then reporting seq_inds for the\n           : best HSP contig.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>","label":"seq_inds($self,$seqType,$class,$collapse)"},"children":[{"definition":"my","line":1779,"kind":13,"localvar":"my","containerName":"seq_inds","name":"$self"},{"line":1779,"kind":13,"containerName":"seq_inds","name":"$seqType"},{"name":"$class","containerName":"seq_inds","kind":13,"line":1779},{"line":1779,"containerName":"seq_inds","kind":13,"name":"$collapse"},{"name":"$seqType","kind":13,"containerName":"seq_inds","line":1781},{"line":1782,"name":"$class","kind":13,"containerName":"seq_inds"},{"name":"$collapse","containerName":"seq_inds","kind":13,"line":1783},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":1785},{"line":1785,"name":"$seqType","containerName":"seq_inds","kind":13},{"definition":"my","name":"@inds","containerName":"seq_inds","localvar":"my","kind":13,"line":1787},{"name":"$hsp","kind":13,"containerName":"seq_inds","line":1787},{"name":"$hsp","containerName":"seq_inds","kind":13,"line":1788},{"kind":13,"containerName":"seq_inds","name":"$self","line":1788},{"line":1788,"name":"hsps","kind":12,"containerName":"seq_inds"},{"name":"@inds","kind":13,"containerName":"seq_inds","line":1790},{"name":"$hsp","kind":13,"containerName":"seq_inds","line":1790},{"line":1790,"containerName":"seq_inds","kind":12,"name":"seq_inds"},{"line":1790,"name":"$seqType","containerName":"seq_inds","kind":13},{"name":"$class","containerName":"seq_inds","kind":13,"line":1790},{"line":1794,"containerName":"seq_inds","kind":13,"name":"@inds"},{"definition":"my","name":"%tmp","localvar":"my","containerName":"seq_inds","kind":13,"line":1795},{"line":1795,"kind":13,"containerName":"seq_inds","name":"@inds"},{"containerName":"seq_inds","kind":13,"name":"@inds","line":1796},{"line":1796,"name":"$a","kind":13,"containerName":"seq_inds"},{"line":1796,"name":"$b","kind":13,"containerName":"seq_inds"},{"name":"%tmp","kind":13,"containerName":"seq_inds","line":1796},{"containerName":"seq_inds","kind":13,"name":"$collapse","line":1799},{"name":"@inds","kind":13,"containerName":"seq_inds","line":1799},{"line":1799,"kind":13,"containerName":"seq_inds","name":"@inds"}],"name":"seq_inds","containerName":"main::","definition":"sub","detail":"($self,$seqType,$class,$collapse)"},{"line":1799,"kind":12,"containerName":"Search::BlastUtils::collapse_nums","name":"Bio"},{"definition":"sub","children":[],"name":"iteration","containerName":"main::","line":1819,"range":{"start":{"character":0,"line":1819},"end":{"character":9999,"line":1819}},"kind":12},{"kind":12,"range":{"start":{"character":0,"line":1848},"end":{"character":9999,"line":1848}},"line":1848,"name":"found_again","containerName":"main::","children":[],"definition":"sub"},{"children":[{"definition":"my","line":1895,"localvar":"my","containerName":"strand","kind":13,"name":"$self"},{"line":1895,"containerName":"strand","kind":13,"name":"$seqType"},{"line":1897,"kind":13,"containerName":"strand","name":"$self"},{"line":1897,"name":"$self","kind":13,"containerName":"strand"},{"line":1899,"name":"$seqType","containerName":"strand","kind":13},{"line":1900,"name":"$seqType","containerName":"strand","kind":13},{"kind":13,"containerName":"strand","name":"$seqType","line":1900},{"line":1902,"name":"$qstr","containerName":"strand","localvar":"my","kind":13,"definition":"my"},{"containerName":"strand","kind":13,"name":"$hstr","line":1902},{"kind":13,"containerName":"strand","name":"$self","line":1904},{"line":1904,"kind":12,"containerName":"strand","name":"num_hsps"},{"line":1905,"containerName":"strand","kind":13,"name":"$self"},{"line":1905,"kind":12,"containerName":"strand","name":"hsp"},{"line":1905,"containerName":"strand","kind":12,"name":"strand"},{"line":1905,"name":"$seqType","containerName":"strand","kind":13},{"line":1907,"name":"$self","containerName":"strand","kind":13},{"name":"$qstr","containerName":"strand","kind":13,"line":1909},{"containerName":"strand","kind":13,"name":"$self","line":1909},{"name":"$hstr","kind":13,"containerName":"strand","line":1910},{"line":1910,"kind":13,"containerName":"strand","name":"$self"},{"definition":"my","line":1917,"kind":13,"localvar":"my","containerName":"strand","name":"%qstr"},{"kind":13,"containerName":"strand","name":"%hstr","line":1917},{"definition":"my","containerName":"strand","localvar":"my","kind":13,"name":"$hsp","line":1918},{"name":"$self","kind":13,"containerName":"strand","line":1918},{"line":1918,"name":"hsps","kind":12,"containerName":"strand"},{"line":1919,"localvar":"my","containerName":"strand","kind":13,"name":"$q","definition":"my"},{"line":1919,"name":"$h","kind":13,"containerName":"strand"},{"containerName":"strand","kind":13,"name":"$hsp","line":1919},{"line":1919,"name":"strand","kind":12,"containerName":"strand"},{"containerName":"strand","kind":13,"name":"$qstr","line":1920},{"line":1920,"kind":13,"containerName":"strand","name":"$q"},{"line":1921,"kind":13,"containerName":"strand","name":"$hstr"},{"line":1921,"name":"$h","kind":13,"containerName":"strand"},{"containerName":"strand","kind":13,"name":"$qstr","line":1923},{"kind":13,"containerName":"strand","name":"%qstr","line":1923},{"name":"$hstr","containerName":"strand","kind":13,"line":1924},{"line":1924,"kind":13,"containerName":"strand","name":"%hstr"},{"name":"$seqType","kind":13,"containerName":"strand","line":1927},{"line":1928,"name":"$qstr","kind":13,"containerName":"strand"},{"line":1928,"containerName":"strand","kind":13,"name":"$hstr"},{"name":"$seqType","kind":13,"containerName":"strand","line":1929},{"line":1930,"containerName":"strand","kind":13,"name":"$qstr"},{"kind":13,"containerName":"strand","name":"$hstr","line":1932}],"name":"strand","containerName":"main::","definition":"sub","detail":"($self,$seqType)","line":1893,"range":{"end":{"character":9999,"line":1934},"start":{"character":0,"line":1893}},"kind":12,"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::PsiBlastHit\n#\n# (This module was originally called Bio::Tools::Blast::Sbjct)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::Hit::PsiBlastHit - Bioperl BLAST Hit object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Result::BlastResult>.\n\n=head1 DESCRIPTION\n\nThe Bio::Search::Hit::PsiBlastHit.pm module encapsulates data and\nmethods for manipulating \"hits\" from a BLAST report. A BLAST hit is a\ncollection of HSPs along with other metadata such as sequence name and\nscore information. Hit objects are accessed via\nL<Bio::Search::Result::BlastResult> objects after parsing a BLAST\nreport using the L<Bio::SearchIO> system.\n\nIn Blast lingo, the \"sbjct\" sequences are all the sequences in a\ntarget database which were compared against a \"query\" sequence.  The\nterms \"sbjct\" and \"hit\" will be used interchangeably in this module.\nAll methods that take 'sbjct' as an argument also support 'hit' as a\nsynonym.\n\nThis module supports BLAST versions 1.x and 2.x, gapped and ungapped,\nand PSI-BLAST.\n\nThe construction of PsiBlastHit objects is performed by\nBio::SearchIO::blast::PsiBlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::blast>).\nThe resulting PsiBlastHits are then accessed via\nL<Bio::Search::Result::BlastResult>). Therefore, you do not need to\nuse L<Bio::Search::Hit::PsiBlastHit>) directly. If you need to\nconstruct PsiBlastHits directly, see the C<new()> function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 HSP Tiling and Ambiguous Alignments\n\nIf a Blast hit has more than one HSP, the Bio::Search::Hit::PsiBlastHit.pm\nobject has the ability to merge overlapping HSPs into contiguous\nblocks. This permits the PsiBlastHit object to sum data across all HSPs\nwithout counting data in the overlapping regions multiple times, which\nwould happen if data from each overlapping HSP are simply summed.  HSP\ntiling is performed automatically when methods of the PsiBlastHit object\nthat rely on tiled data are invoked. These include\nL<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>,\nL<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>,\nL<num_unaligned_query()|num_unaligned_query>, L<num_unaligned_hit()|num_unaligned_hit>.\n\nIt also permits the assessment of an \"ambiguous alignment\" if the\nquery (or sbjct) sequences from different HSPs overlap\n(see L<ambiguous_aln()|ambiguous_aln>). The existence\nof an overlap could indicate a biologically interesting region in the\nsequence, such as a repeated domain.  The PsiBlastHit object uses the\nC<-OVERLAP> parameter to determine when two sequences overlap; if this is\nset to 2 -- the default -- then any two sbjct or query HSP sequences\nmust overlap by more than two residues to get merged into the same\ncontig and counted as an overlap. See the L<BUGS | BUGS> section below for\n\"issues\" with HSP tiling.\n\n\nThe results of the HSP tiling is reported with the following ambiguity codes:\n\n   'q' = Query sequence contains multiple sub-sequences matching\n         a single region in the sbjct sequence.\n\n   's' = Subject (PsiBlastHit) sequence contains multiple sub-sequences matching\n         a single region in the query sequence.\n\n   'qs' = Both query and sbjct sequences contain more than one\n          sub-sequence with similarity to the other sequence.\n\n\nFor addition information about ambiguous BLAST alignments, see\nL<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n=head1 DEPENDENCIES\n\nBio::Search::Hit::PsiBlastHit.pm is a concrete class that inherits from\nL<Bio::Root::Root> and L<Bio::Search::Hit::HitI>.  and relies on\nL<Bio::Search::HSP::BlastHSP>.\n\n\n=head1 BUGS\n\nOne consequence of the HSP tiling is that methods that rely on HSP\ntiling such as L<frac_identical()|frac_identical>, L<frac_conserved()|frac_conserved>, L<gaps()|gaps>\netc. may report misleading numbers when C<-OVERLAP> is set to a large\nnumber.  For example, say we have two HSPs and the query sequence tile\nas follows:\n\n            1      8             22      30        40             60\n Full seq:  ------------------------------------------------------------\n                    *  ** *   **\n HSP1:             ---------------                    (6 identical matches)\n                              **   **  **\n HSP2:                        -------------           (6 identical matches)\n\n\nIf C<-OVERLAP> is set to some number over 4, HSP1 and HSP2 will not be\ntiled into a single contig and their numbers of identical matches will\nbe added, giving a total of 12, not 10 if they had be combined into\none contig. This can lead to number greater than 1.0 for methods\nL<frac_identical()|frac_identical> and L<frac_conserved()|frac_conserved>. This is less of an issue\nwith gapped Blast since it tends to combine HSPs that would be listed\nseparately without gapping.  (Fractions E<gt>1.0 can be viewed as a\nsignal for an interesting alignment that warrants further inspection,\nthus turning this bug into a feature :-).\n\nUsing large values for C<-OVERLAP> can lead to incorrect numbers\nreported by methods that rely on HSP tiling but can be useful if you\ncare more about detecting ambiguous alignments.  Setting C<-OVERLAP>\nto zero will lead to the most accurate numbers for the\ntiling-dependent methods but will be useless for detecting overlapping\nHSPs since all HSPs will appear to overlap.\n\n\n=head1 SEE ALSO\n\n Bio::Search::HSP::BlastHSP.pm         - Blast HSP object.\n Bio::Search::Result::BlastResult.pm   - Blast Result object.\n Bio::Search::Hit::HitI.pm             - Interface implemented by PsiBlastHit.pm\n Bio::Root::Root.pm                    - Base class for PsiBlastHit.pm\n\nLinks:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n    http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::PsiBlastHit;\n\nuse strict;\nuse Bio::Search::BlastUtils;\nuse vars qw(%SUMMARY_OFFSET);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n\n=head2 new\n\n Usage     : $hit = Bio::Search::Hit::PsiBlastHit->new( %named_params );\n           : Bio::Search::Hit::PsiBlastHit.pm objects are constructed\n           : automatically by Bio::SearchIO::PsiBlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHit object and Initializes key variables\n           : for the hit.\n Returns   : A Bio::Search::Hit::PsiBlastHit object\n Argument  : Named Parameters:\n           : Parameter keys are case-insensitive.\n           :     -RAW_DATA   => array reference holding raw BLAST report data\n           :                    for a single hit. This includes all lines\n           :                    within the HSP alignment listing section of a\n           :                    traditional BLAST or PSI-BLAST (non-XML) report,\n           :                    starting at (or just after) the leading '>'.\n           :         -HOLD_RAW_DATA => boolean, should -RAW_DATA be saved within the object.\n           :         -QUERY_LEN  => Length of the query sequence\n           :         -ITERATION  => integer (PSI-BLAST iteration number in which hit was found)\n           :         -OVERLAP    => integer (maximum overlap between adjacent\n           :                    HSPs when tiling)\n           :         -PROGRAM    => string (type of Blast: BLASTP, BLASTN, etc)\n           :         -SIGNIF     => significance\n           :         -IS_PVAL    => boolean, true if -SIGNIF contains a P-value\n           :         -SCORE      => raw BLAST score\n           :         -FOUND_AGAIN   => boolean, true if this was a hit from the\n           :                       section of a PSI-BLAST with iteration > 1\n           :                       containing sequences that were also found\n           :                       in iteration 1.\n Comments  : This object accepts raw Blast report data not because it\n           : is required for parsing, but in order to retrieve it\n           : (only available if -HOLD_RAW_DATA is set to true).\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Root::Root::new()|Bio::Root::Root>\n\n\n#-------------------\nsub new {\n#-------------------\n    my ($class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ($raw_data, $signif, $is_pval, $hold_raw);\n\n    ($self->{'_blast_program'}, $self->{'_query_length'}, $raw_data, $hold_raw,\n     $self->{'_overlap'}, $self->{'_iteration'}, $signif, $is_pval,\n     $self->{'_score'}, $self->{'_found_again'} ) =\n       $self->_rearrange( [qw(PROGRAM\n                              QUERY_LEN\n                              RAW_DATA\n                              HOLD_RAW_DATA\n                              OVERLAP\n                              ITERATION\n                              SIGNIF\n                              IS_PVAL\n                              SCORE\n                              FOUND_AGAIN )], @args );\n\n    # TODO: Handle this in parser. Just pass in name parameter.\n    $self->_set_id( $raw_data->[0] );\n\n    if($is_pval) {\n        $self->{'_p'} = $signif;\n    } else {\n        $self->{'_expect'} = $signif;\n    }\n\n    if( $hold_raw ) {\n        $self->{'_hit_data'} = $raw_data;\n    }\n\n    return $self;\n}\n\nsub DESTROY {\n    my $self=shift;\n    #print STDERR \"-->DESTROYING $self\\n\";\n}\n\n\n#=================================================\n# Begin Bio::Search::Hit::HitI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_blast_program'};\n}\n\n=head2 name\n\n Usage     : $hit->name([string]);\n Purpose   : Set/Get a string to identify the hit.\n Example   : $name = $hit->name;\n           : $hit->name('M81707');\n Returns   : String consisting of the hit's name or undef if not set.\n Comments  : The name is parsed out of the \"Query=\" line as the first chunk of\n             non-whitespace text. If you want the rest of the line, use\n             $hit->description().\n\nSee Also: L<accession()|accession>\n\n\n#'\n\n#----------------\nsub name {\n#----------------\n    my $self = shift;\n    if (@_) {\n        my $name = shift;\n        $name =~ s/^\\s+|(\\s+|,)$//g;\n        $self->{'_name'} = $name;\n    }\n    return $self->{'_name'};\n}\n\n=head2 description\n\n Usage     : $hit_object->description( [integer] );\n Purpose   : Set/Get a description string for the hit.\n             This is parsed out of the \"Query=\" line as everything after\n             the first chunk of non-whitespace text. Use $hit->name()\n             to get the first chunk (the ID of the sequence).\n Example   : $description = $hit->description;\n           : $desc_60char = $hit->description(60);\n Argument  : Integer (optional) indicating the desired length of the\n           : description string to be returned.\n Returns   : String consisting of the hit's description or undef if not set.\n\n\n#'\n\n#----------------\nsub description {\n#----------------\n    my( $self, $len ) = @_;\n    $len = (defined $len) ? $len : (CORE::length $self->{'_description'});\n    return substr( $self->{'_description'}, 0 ,$len );\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n Comments: Accession numbers are extracted based on the assumption that they\n           are delimited by | characters (NCBI-style). If this is not the case,\n           use the name() method and parse it as necessary.\n\nSee Also: L<name()|name>\n\n\n#--------------------\nsub accession {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_accession'} = shift; }\n    $self->{'_accession'} || '';\n}\n\n=head2 raw_score\n\n Usage     : $hit_object->raw_score();\n Purpose   : Gets the BLAST score of the best HSP for the current Blast hit.\n Example   : $score = $hit_object->raw_score();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L<bits()|bits>\n\n\n#----------\nsub raw_score {\n#----------\n    my $self = shift;\n\n    # The check for $self->{'_score'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($score);\n    if(not defined($self->{'_score'})) {\n        $score = $self->hsp->score;\n    } else {\n        $score = $self->{'_score'};\n    }\n    return $score;\n}\n\n\n=head2 length\n\n Usage     : $hit_object->length();\n Purpose   : Get the total length of the hit sequence.\n Example   : $len = $hit_object->length();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : Developer note: when using the built-in length function within\n           : this module, call it as CORE::length().\n\nSee Also   : L<logical_length()|logical_length>,  L<length_aln()|length_aln>\n\n\n#-----------\nsub length {\n#-----------\n    my $self = shift;\n    return $self->{'_length'};\n}\n\n=head2 significance\n\nEquivalent to L<signif()|signif>\n\n\n#----------------\nsub significance { shift->signif( @_ ); }\n#----------------\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : $hsp = $obj->next_hsp();\n Function : returns the next available High Scoring Pair object\n Example  :\n Returns  : Bio::Search::HSP::BlastHSP or undef if finished\n Args     : none\n\n\n#----------------\nsub next_hsp {\n#----------------\n    my $self = shift;\n\n    unless($self->{'_hsp_queue_started'}) {\n        $self->{'_hsp_queue'} = [$self->hsps()];\n        $self->{'_hsp_queue_started'} = 1;\n    }\n    pop @{$self->{'_hsp_queue'}};\n}\n\n#=================================================\n# End Bio::Search::Hit::HitI implementation\n#=================================================\n\n\n# Providing a more explicit method for getting name of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_name {\n#----------------\n    my $self = shift;\n    $self->name( @_ );\n}\n\n# Older method Delegates to description()\n#----------------\nsub desc {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n# Providing a more explicit method for getting description of hit\n# (corresponds with column name in HitTableWriter)\n#----------------\nsub hit_description {\n#----------------\n    my $self = shift;\n    return $self->description( @_ );\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n#----------------\nsub score { shift->raw_score( @_ ); }\n#----------------\n\n\n=head2 hit_length\n\nEquivalent to L<length()|length>\n\n\n# Providing a more explicit method for getting length of hit\n#----------------\nsub hit_length { shift->length( @_ ); }\n#----------------\n\n\n=head2 signif\n\n Usage     : $hit_object->signif( [format] );\n Purpose   : Get the P or Expect value for the best HSP of the given BLAST hit.\n           : The value returned is the one which is reported in the description\n           : section of the Blast report. For Blast1 and WU-Blast2, this\n           : is a P-value, for Blast2, it is an Expect value.\n Example   : $obj->signif()        # returns 1.3e-34\n           : $obj->signif('exp')   # returns -34\n           : $obj->signif('parts') # returns (1.3, -34)\n Returns   : Float or scientific notation number (the raw P/Expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P/Expect value\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : n/a\n Comments  : The signif() method provides a way to deal with the fact that\n           : Blast1 and Blast2 formats (and WU- vs. NCBI-BLAST) differ in\n           : what is reported in the description lines of each hit in the\n           : Blast report. The signif() method frees any client code from\n           : having to know if this is a P-value or an Expect value,\n           : making it easier to write code that can process both\n           : Blast1 and Blast2 reports. This is not necessarily a good thing,\n           : since one should always know when one is working with P-values or\n           : Expect values (hence the deprecated status).\n           : Use of expect() is recommended since all hits will have an Expect value.\n           :\n           : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<expect()|expect>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-------------\nsub signif {\n#-------------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get P- or Expect value: HSPs may not have been set.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P/Expect-value.\n    return $val;\n}\n\n#----------------\nsub raw_hit_data {\n#----------------\n    my $self = shift;\n    my $data = '>';\n    # Need to add blank lines where we've removed them.\n    foreach( @{$self->{'_hit_data'}} ) {\n        if( $_ eq 'end') {\n            $data .= \"\\n\";\n        }\n        else {\n            $data .= /^\\s*(Score|Query)/ ? \"\\n$_\" : $_;\n        }\n    }\n    return $data;\n}\n\n\n#=head2 _set_length\n#\n# Usage     : $hit_object->_set_length( \"233\" );\n# Purpose   : Set the total length of the hit sequence.\n# Example   : $hit_object->_set_length( $len );\n# Returns   : n/a\n# Argument  : Integer (only when setting). Any commas will be stripped out.\n# Throws    : n/a\n#\n#=cut\n\n#-----------\nsub _set_length {\n#-----------\n    my ($self, $len) = @_;\n    $len =~ s/,//g; # get rid of commas\n    $self->{'_length'} = $len;\n}\n\n#=head2 _set_description\n#\n# Usage     : Private method; called automatically during construction\n# Purpose   : Sets the description of the hit sequence.\n#            : For sequence without descriptions, does not set any description.\n# Argument  : Array containing description (multiple lines).\n# Comments  : Processes the supplied description:\n#                1. Join all lines into one string.\n#                2. Remove sequence id at the beginning of description.\n#                3. Removes junk charactes at begin and end of description.\n#\n#=cut\n\n#--------------\nsub _set_description {\n#--------------\n    my( $self, @desc ) = @_;\n    my( $desc);\n\n#    print STDERR \"PsiBlastHit: RAW DESC:\\n@desc\\n\";\n\n    $desc = join(\" \", @desc);\n\n    my $name = $self->name;\n\n    if($desc) {\n        $desc =~ s/^\\s*\\S+\\s+//; # remove the sequence ID(s)\n                                 # This won't work if there's no description.\n        $desc =~ s/^\\s*$name//;  # ...but this should.\n        $desc =~ s/^[\\s!]+//;\n        $desc =~ s/ \\d+$//;\n        $desc =~ s/\\.+$//;\n        $self->{'_description'} = $desc;\n    }\n\n#    print STDERR \"PsiBlastHit: _set_description =  $desc\\n\";\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hit->to_string;\n Function: Returns a string representation for the Blast Hit.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHit] <name> <description>\n           e.g.:\n           [PsiBlastHit] emb|Z46660|SC9725 S.cerevisiae chromosome XIII cosmid\n Args    : None\n\n\n#----------------\nsub to_string {\n#----------------\n    my $self = shift;\n    return \"[PsiBlastHit] \" . $self->name . \" \" . $self->description;\n}\n\n\n#=head2 _set_id\n#\n# Usage     : Private method; automatically called by new()\n# Purpose   : Sets the name of the PsiBlastHit sequence from the BLAST summary line.\n#           : The identifier is assumed to be the first\n#           : chunk of non-whitespace characters in the description line\n#           : Does not assume any semantics in the structure of the identifier\n#           : (Formerly, this method attempted to extract database name from\n#           : the seq identifiers, but this was prone to break).\n# Returns   : n/a\n# Argument  : String containing description line of the hit from Blast report\n#           : or first line of an alignment section (with or without the leading '>').\n# Throws    : Warning if cannot locate sequence ID.\n#\n#See Also   : L<new()|new>, L<accession()|accession>\n#\n#=cut\n\n#---------------\nsub _set_id {\n#---------------\n    my( $self, $desc ) = @_;\n\n    # New strategy: Assume only that the ID is the first white space\n    # delimited chunk. Not attempting to extract accession & database name.\n    # Clients will have to interpret it as necessary.\n    if($desc =~ /^>?(\\S+)\\s*(.*)/) {\n        my ($name, $desc) = ($1, $2);\n        $self->name($name);\n        $self->{'_description'} = $desc;\n        # Note that this description comes from the summary section of the\n        # BLAST report and so may be truncated. The full description will be\n        # set from the alignment section. We're setting description here in case\n        # the alignment section isn't being parsed.\n\n        # Assuming accession is delimited with | symbols (NCBI-style)\n        my @pieces = split(/\\|/,$name);\n        my $acc = pop @pieces;\n        $self->accession( $acc );\n    }\n    else {\n        $self->warn(\"Can't locate sequence identifier in summary line.\", \"Line = $desc\");\n        $desc = 'Unknown sequence ID' if not $desc;\n        $self->name($desc);\n    }\n}\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences\n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences\n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains\n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Status    : Experimental\n\nSee Also   : L<Bio::Search::BlastUtils::tile_hsps>, L<HSP Tiling and Ambiguous Alignments>\n\n\n#--------------------\nsub ambiguous_aln {\n#--------------------\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n\n\n=head2 overlap\n\n Usage     : $blast_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $blast_object->overlap(5);\n           : $overlap = $blast_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by Bio::Search::BlastUtils::_adjust_contigs().\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap {\n#-------------\n    my $self = shift;\n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n\n\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the BLAST bit score of the best HSP for the current Blast hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if bit score is not set.\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits {\n#---------\n    my $self = shift;\n\n    # The check for $self->{'_bits'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($bits);\n    if(not defined($self->{'_bits'})) {\n        $bits = $self->hsp->bits;\n    } else {\n        $bits = $self->{'_bits'};\n    }\n    return $bits;\n}\n\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n {\n#-----\n    my $self = shift;\n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n        $n = $self->hsp->n;\n    } else {\n        $n = $self->{'_n'};\n    }\n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n\n\n=head2 frame\n\n Usage     : $hit_object->frame();\n Purpose   : Gets the reading frame for the best HSP after HSP tiling.\n           : This is only valid for BLASTX and TBLASTN/X reports.\n Example   : $frame = $hit_object->frame();\n Returns   : Integer (-2 .. +2)\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling frame() on each (use hsps() to get all HSPs).\n\nSee Also   : L<hsps()|hsps>\n\n\n#----------'\nsub frame {\n#----------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'};\n    }\n    return $frame;\n}\n\n\n\n\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p {\n#--------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(not defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using expect() instead.\");\n        $val = $self->{'_expect'};\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n\n\n=head2 expect\n\n Usage     : $hit_object->expect( [format] );\n Purpose   : Get the Expect value for the best HSP of the given BLAST hit.\n Example   : $e =  $sbjct->expect;\n           : $e =  $sbjct->expect('exp');  # get exponent only.\n           : ($num, $exp) = $sbjct->expect('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw expect value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and Expect\n           :                is in scientific notation (see Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a\n           :            2-element list (1.2, -34)  (see Comments).\n Throws    : Exception if the Expect value is not defined.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the expect value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<p()|p>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#-----------\nsub expect {\n#-----------\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val;\n\n    # For Blast reports that list the P value on the description line,\n    # getting the expect value requires fully parsing the HSP data.\n    # For NCBI blast, there's no problem.\n    if(not defined($self->{'_expect'})) {\n        if( defined $self->{'_hsps'}) {\n            $self->{'_expect'} = $val = $self->hsp->expect;\n        } else {\n            # If _expect is not set and _hsps are not set,\n            # then this must be a P-value-based report that was\n            # run without setting the HSPs (shallow parsing).\n            $self->throw(\"Can't get expect value. HSPs have not been set.\");\n        }\n    } else {\n        $val = $self->{'_expect'};\n    }\n\n    # $val can be zero.\n    defined($val) or $self->throw(\"Can't get Expect value.\");\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::BlastUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw Expect-value.\n    return $val;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return wantarray\n        #  returning list containing all HSPs.\n        ? @{$self->{'_hsps'}}\n        #  returning number of HSPs.\n        : scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single BlastHSP.pm object for the present PsiBlastHit.pm object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp {\n#----------\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n\n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = @{$self->{'_hsps'}};\n\n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    my $self = shift;\n\n    if (not defined $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    return scalar(@{$self->{'_hsps'}});\n}\n\n\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : For query sequence of BLASTX and TBLASTX reports and the hit\n           : sequence of TBLASTN and TBLASTX reports, the returned length\n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len = $hit_object->logical_length();\n Returns   : Integer\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with T?BLASTX type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length {\n#--------------------\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my $length;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->{'_logical_length'} || $self->{'_length'};\n    }\n    else {\n        # Otherwise, return logical query length\n        $length = $self->{'_query_length'};\n\n        # Adjust length based on BLAST flavor.\n        if($self->{'_blast_program'} =~ /T?BLASTX/ ) {\n            $length /= 3;\n        }\n    }\n    return $length;\n}\n\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           :\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\n#---------------'\nsub length_aln {\n#---------------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    my $data = $self->{'_length_aln_'.$seqType};\n\n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\"\" .\n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }\n    $data;\n}\n\n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, sbjct, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers\n           :    (queryGaps, sbjctGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed\n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations\n           : such as printf \"%d\", $hit->gaps() in which you might expect to\n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\n#----------\nsub gaps {\n#----------\n    my( $self, $seqType ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    $seqType = lc($seqType);\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}\n\n\n\n=head2 matches\n\n Usage     : $hit_object->matches( [class] );\n Purpose   : Get the total number of identical or conserved matches\n           : (or both) across all HSPs.\n           : (Note: 'conservative' matches are indicated as 'positives'\n           :         in the Blast report.)\n Example   : ($id,$cons) = $hit_object->matches(); # no argument\n           : $id = $hit_object->matches('id');\n           : $cons = $hit_object->matches('cons');\n Returns   : Integer or a 2-element array of integers\n Argument  : class = 'id' | 'cons' OR none.\n           : If no argument is provided, both identical and conservative\n           : numbers are returned in a two element list.\n           : (Other terms can be used to refer to the conservative\n           :  matches, e.g., 'positive'. All that is checked is whether or\n           :  not the supplied string starts with 'id'. If not, the\n           : conservative matches are returned.)\n Throws    : Exception if the requested data cannot be obtained.\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : Does not rely on wantarray to return a list. Only checks for\n           : the presence of an argument (no arg = return list).\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::matches()|Bio::Search::HSP::BlastHSP>, L<hsps()|hsps>\n\n\n#---------------\nsub matches {\n#---------------\n    my( $self, $arg) = @_;\n    my(@data,$data);\n\n    if(!$arg) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data if @data;\n\n    } else {\n\n        if($arg =~ /^id/i) {\n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        return $data if $data;\n    }\n\n    ## Something went wrong if we make it to here.\n    $self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the PsiBlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If there is more than one\n           : HSP and they have not already been tiled, they will be tiled first automatically..\n           : Remember that the start and end coordinates of all HSPs are\n           : normalized so that start < end. Strand information can be\n           : obtained by calling $hit->strand().\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, L<HSP Tiling and Ambiguous Alignments>, L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    } else {\n        Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the PsiBlastHit object. If there is more than one HSP, the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If there is more than one\n           : HSP and they have not already been tiled, they will be tiled first automatically..\n           : Remember that the start and end coordinates of all HSPs are\n           : normalized so that start < end. Strand information can be\n           : obtained by calling $hit->strand().\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>, L<HSP Tiling and Ambiguous Alignments>, L<Bio::Search::HSP::BlastHSP::end|Bio::Search::HSP::BlastHSP>\n\n\n#----------\nsub end {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    } else {\n        Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or\n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n\n#------------------\nsub frac_identical {\n#------------------\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    sprintf( \"%.2f\", $self->{'_totalIdentical'}/$self->{'_length_aln_'.$seqType});\n}\n\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or\n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    sprintf( \"%.2f\", $self->{'_totalConserved'}/$self->{'_length_aln_'.$seqType});\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : To compute the fraction aligned, the logical length of the query\n           : sequence is used, meaning that for [T]BLASTX reports, the\n           : full length of the query sequence is converted into amino acids\n           : by dividing by 3. This is necessary because of the way\n           : the lengths of aligned sequences are computed.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n\n#----------------------\nsub frac_aligned_query {\n#----------------------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    sprintf( \"%.2f\", $self->{'_length_aln_query'}/$self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : To compute the fraction aligned, the logical length of the sbjct\n           : sequence is used, meaning that for TBLAST[NX] reports, the\n           : full length of the sbjct sequence is converted into amino acids\n           : by dividing by 3. This is necessary because of the way\n           : the lengths of aligned sequences are computed.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n\n#--------------------\nsub frac_aligned_hit {\n#--------------------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    sprintf( \"%.2f\", $self->{'_length_aln_sbjct'}/$self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility.\n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#----------------\nsub frac_aligned_sbjct {  my $self=shift; $self->frac_aligned_hit(@_); }\n#----------------\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n#----------------\nsub num_unaligned_sbjct {  my $self=shift; $self->num_unaligned_hit(@_); }\n#----------------\n\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#---------------------\nsub num_unaligned_hit {\n#---------------------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    my $num = $self->logical_length('sbjct') - $self->{'_length_aln_sbjct'};\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::BlastUtils::tile_hsps()|Bio::Search::BlastUtils>\n\n\n#-----------------------\nsub num_unaligned_query {\n#-----------------------\n    my $self = shift;\n\n    Bio::Search::BlastUtils::tile_hsps($self) if not $self->{'_tile_hsps'};\n\n    my $num = $self->logical_length('query') - $self->{'_length_aln_query'};\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers\n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\"\n           :             collapses to \"1-5 7 9-11\". This is useful for\n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : Note that HSPs are not tiled for this. This could be a problem\n           : for hits containing mutually exclusive HSPs.\n           : TODO: Consider tiling and then reporting seq_inds for the\n           : best HSP contig.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>\n\n\n#-------------\nsub seq_inds {\n#-------------\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);\n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n\n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::BlastUtils::collapse_nums(@inds) : @inds;\n}\n\n\n=head2 iteration\n\n Usage     : $sbjct->iteration( );\n Purpose   : Gets the iteration number in which the Hit was found.\n Example   : $iteration_num = $sbjct->iteration();\n Returns   : Integer greater than or equal to 1\n             Non-PSI-BLAST reports will report iteration as 1, but this number\n             is only meaningful for PSI-BLAST reports.\n Argument  : none\n Throws    : none\n\nSee Also   : L<found_again()|found_again>\n\n\n#----------------\nsub iteration { shift->{'_iteration'} }\n#----------------\n\n\n=head2 found_again\n\n Usage     : $sbjct->found_again;\n Purpose   : Gets a boolean indicator whether or not the hit has\n             been found in a previous iteration.\n             This is only applicable to PSI-BLAST reports.\n\n              This method indicates if the hit was reported in the\n              \"Sequences used in model and found again\" section of the\n              PSI-BLAST report or if it was reported in the\n              \"Sequences not found previously or not previously below threshold\"\n              section of the PSI-BLAST report. Only for hits in iteration > 1.\n\n Example   : if( $sbjct->found_again()) { ... };\n Returns   : Boolean (1 or 0) for PSI-BLAST report iterations greater than 1.\n             Returns undef for PSI-BLAST report iteration 1 and non PSI_BLAST\n             reports.\n Argument  : none\n Throws    : none\n\nSee Also   : L<found_again()|found_again>\n\n\n#----------------\nsub found_again { shift->{'_found_again'} }\n#----------------\n\n\n=head2 strand\n\n Usage     : $sbjct->strand( [seq_type] );\n Purpose   : Gets the strand(s) for the query, sbjct, or both sequences\n           : in the best HSP of the PsiBlastHit object after HSP tiling.\n           : Only valid for BLASTN, TBLASTX, BLASTX-query, TBLASTN-hit.\n Example   : $qstrand = $sbjct->strand('query');\n           : $sstrand = $sbjct->strand('hit');\n           : ($qstrand, $sstrand) = $sbjct->strand();\n Returns   : scalar context: integer '1', '-1', or '0'\n           : array context without args: list of two strings (queryStrand, sbjctStrand)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling strand() on each (use hsps() to get all HSPs).\n           :\n           : Formerly (prior to 10/21/02), this method would return the\n           : string \"-1/1\" for hits with HSPs on both strands.\n           : However, now that strand and frame is properly being accounted\n           : for during HSP tiling, it makes more sense for strand()\n           : to return the strand data for the best HSP after tiling.\n           :\n           : If you really want to know about hits on opposite strands,\n           : you should be iterating through the HSPs using methods on the\n           : HSP objects.\n           :\n           : A possible use case where knowing whether a hit has HSPs\n           : on both strands would be when filtering via SearchIO for hits with\n           : this property. However, in this case it would be better to have a\n           : dedicated method such as $hit->hsps_on_both_strands(). Similarly\n           : for frame. This could be provided if there is interest.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::strand>()\n\n----------'","parameters":[{"label":"$self"},{"label":"$seqType"}],"label":"strand($self,$seqType)"}},{"kind":12,"containerName":"Search::BlastUtils::tile_hsps","name":"Bio","line":1897}],"version":5}