{"vars":[{"kind":2,"containerName":"","name":"base","line":102},{"children":[{"name":"$class","containerName":"new","localvar":"my","kind":13,"line":128,"definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":128},{"definition":"my","line":130,"localvar":"my","kind":13,"containerName":"new","name":"$self"},{"line":130,"containerName":"new","kind":13,"name":"$class"},{"name":"@args","containerName":"new","kind":13,"line":130},{"definition":"my","line":131,"localvar":"my","containerName":"new","kind":13,"name":"$hsps"},{"containerName":"new","kind":13,"name":"$name","line":131},{"kind":13,"containerName":"new","name":"$query_len","line":131},{"line":131,"kind":13,"containerName":"new","name":"$desc"},{"line":131,"name":"$acc","kind":13,"containerName":"new"},{"line":131,"kind":13,"containerName":"new","name":"$locus"},{"name":"$length","containerName":"new","kind":13,"line":131},{"name":"$score","containerName":"new","kind":13,"line":132},{"line":132,"name":"$algo","containerName":"new","kind":13},{"line":132,"containerName":"new","kind":13,"name":"$signif"},{"containerName":"new","kind":13,"name":"$bits","line":132},{"line":132,"name":"$p","containerName":"new","kind":13},{"line":133,"kind":13,"containerName":"new","name":"$rank"},{"line":133,"containerName":"new","kind":13,"name":"$hsp_factory"},{"name":"$gi","kind":13,"containerName":"new","line":133},{"kind":13,"containerName":"new","name":"$self","line":133},{"line":133,"name":"_rearrange","containerName":"new","kind":12},{"name":"@args","kind":13,"containerName":"new","line":143},{"kind":13,"containerName":"new","name":"$query_len","line":145},{"name":"$self","kind":13,"containerName":"new","line":145},{"line":145,"name":"query_length","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"$query_len","line":145},{"line":147,"containerName":"new","kind":13,"name":"$name"},{"name":"$self","containerName":"new","kind":13,"line":148},{"containerName":"new","kind":12,"name":"throw","line":148},{"kind":13,"containerName":"new","name":"$self","line":150},{"kind":12,"containerName":"new","name":"name","line":150},{"name":"$name","containerName":"new","kind":13,"line":150},{"line":153,"containerName":"new","kind":13,"name":"$acc"},{"line":153,"name":"$self","kind":13,"containerName":"new"},{"line":153,"name":"accession","containerName":"new","kind":12},{"line":153,"name":"$acc","containerName":"new","kind":13},{"line":154,"name":"$locus","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$self","line":154},{"containerName":"new","kind":12,"name":"locus","line":154},{"line":154,"name":"$locus","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$desc","line":155},{"line":155,"name":"$self","containerName":"new","kind":13},{"line":155,"containerName":"new","kind":12,"name":"description"},{"line":155,"kind":13,"containerName":"new","name":"$desc"},{"containerName":"new","kind":13,"name":"$length","line":156},{"line":156,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"length","line":156},{"line":156,"containerName":"new","kind":13,"name":"$length"},{"name":"$algo","kind":13,"containerName":"new","line":157},{"line":157,"name":"$self","containerName":"new","kind":13},{"line":157,"name":"algorithm","containerName":"new","kind":12},{"line":157,"name":"$algo","containerName":"new","kind":13},{"name":"$signif","kind":13,"containerName":"new","line":158},{"line":158,"name":"$self","containerName":"new","kind":13},{"line":158,"containerName":"new","kind":12,"name":"significance"},{"kind":13,"containerName":"new","name":"$signif","line":158},{"kind":13,"containerName":"new","name":"$score","line":159},{"containerName":"new","kind":13,"name":"$self","line":159},{"name":"raw_score","containerName":"new","kind":12,"line":159},{"containerName":"new","kind":13,"name":"$score","line":159},{"line":160,"containerName":"new","kind":13,"name":"$bits"},{"name":"$self","kind":13,"containerName":"new","line":160},{"line":160,"name":"bits","kind":12,"containerName":"new"},{"line":160,"name":"$bits","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$rank","line":161},{"line":161,"containerName":"new","kind":13,"name":"$self"},{"line":161,"containerName":"new","kind":12,"name":"rank"},{"line":161,"name":"$rank","containerName":"new","kind":13},{"line":162,"name":"$hsp_factory","containerName":"new","kind":13},{"line":162,"containerName":"new","kind":13,"name":"$self"},{"line":162,"kind":12,"containerName":"new","name":"hsp_factory"},{"line":162,"name":"$hsp_factory","kind":13,"containerName":"new"},{"line":163,"name":"$gi","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":163},{"containerName":"new","kind":12,"name":"ncbi_gi","line":163},{"containerName":"new","kind":13,"name":"$gi","line":163},{"line":165,"containerName":"new","kind":13,"name":"$p"},{"line":166,"name":"$self","containerName":"new","kind":13},{"line":166,"name":"$p","containerName":"new","kind":13},{"line":169,"containerName":"new","kind":13,"name":"$self"},{"line":170,"kind":13,"containerName":"new","name":"$hsps"},{"name":"$hsps","containerName":"new","kind":13,"line":171},{"line":172,"name":"$self","kind":13,"containerName":"new"},{"line":172,"kind":12,"containerName":"new","name":"warn"},{"definition":"my","name":"$hspcount","containerName":"new","localvar":"my","kind":13,"line":174},{"line":175,"name":"$hsps","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$hspcount","line":176},{"line":177,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"add_hsp","line":177},{"line":177,"name":"$hsps","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":179},{"line":179,"name":"$hspcount","containerName":"new","kind":13}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":127,"kind":12,"range":{"end":{"character":9999,"line":180},"start":{"character":0,"line":127}},"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.","parameters":[{"label":"$class"},{"label":"@args"}]}},{"containerName":"new","kind":12,"name":"SUPER","line":130},{"line":166,"name":"_p","kind":12},{"line":183,"kind":13,"containerName":null,"name":"%self"},{"line":186,"name":"$self","kind":13,"containerName":null},{"kind":12,"range":{"end":{"character":9999,"line":207},"start":{"line":200,"character":0}},"line":200,"signature":{"label":"add_hsp($self,$hsp)","parameters":[{"label":"$self"},{"label":"$hsp"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)"},"containerName":"main::","name":"add_hsp","children":[{"definition":"my","line":201,"localvar":"my","kind":13,"containerName":"add_hsp","name":"$self"},{"line":201,"containerName":"add_hsp","kind":13,"name":"$hsp"},{"kind":13,"containerName":"add_hsp","name":"$hsp","line":202},{"line":202,"name":"$hsp","containerName":"add_hsp","kind":13},{"name":"$hsp","containerName":"add_hsp","kind":13,"line":202},{"line":202,"name":"isa","kind":12,"containerName":"add_hsp"},{"name":"$self","containerName":"add_hsp","kind":13,"line":203},{"containerName":"add_hsp","kind":12,"name":"throw","line":203},{"line":207,"name":"$self","kind":13,"containerName":"add_hsp"}],"detail":"($self,$hsp)","definition":"sub"},{"containerName":null,"kind":13,"name":"$hsp","line":207},{"line":208,"name":"%hsp","kind":13,"containerName":null},{"line":209,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"name":"_hashes","line":209},{"containerName":null,"kind":13,"name":"%self","line":209},{"containerName":null,"kind":13,"name":"%self","line":211},{"children":[{"definition":"my","line":225,"name":"$self","containerName":"hsp_factory","localvar":"my","kind":13},{"line":226,"name":"$self","kind":13,"containerName":"hsp_factory"},{"line":227,"name":"$self","containerName":"hsp_factory","kind":13}],"containerName":"main::","name":"hsp_factory","definition":"sub","line":224,"kind":12,"range":{"start":{"character":0,"line":224},"end":{"line":228,"character":9999}}},{"name":"_hsp_factory","kind":12,"line":226},{"line":227,"name":"_hsp_factory","kind":12},{"signature":{"label":"name($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name"},"line":244,"range":{"start":{"character":0,"line":244},"end":{"character":9999,"line":252}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"name","kind":13,"line":245},{"line":245,"name":"$value","containerName":"name","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"name","name":"$previous","line":246},{"name":"$self","kind":13,"containerName":"name","line":246},{"line":247,"name":"$value","kind":13,"containerName":"name"},{"containerName":"name","kind":13,"name":"$previous","line":247},{"line":248,"name":"$value","containerName":"name","kind":13},{"containerName":"name","kind":13,"name":"$previous","line":248},{"line":248,"name":"$value","containerName":"name","kind":13},{"line":249,"containerName":"name","kind":13,"name":"$self"},{"containerName":"name","kind":13,"name":"$value","line":249},{"name":"$previous","containerName":"name","kind":13,"line":251}],"containerName":"main::","name":"name"},{"signature":{"label":"accession($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none"},"kind":12,"range":{"start":{"line":264,"character":0},"end":{"character":9999,"line":272}},"line":264,"detail":"($self,$value)","definition":"sub","name":"accession","containerName":"main::","children":[{"line":265,"localvar":"my","containerName":"accession","kind":13,"name":"$self","definition":"my"},{"name":"$value","kind":13,"containerName":"accession","line":265},{"definition":"my","kind":13,"localvar":"my","containerName":"accession","name":"$previous","line":266},{"line":266,"containerName":"accession","kind":13,"name":"$self"},{"name":"$value","containerName":"accession","kind":13,"line":267},{"containerName":"accession","kind":13,"name":"$previous","line":267},{"line":268,"containerName":"accession","kind":13,"name":"$value"},{"line":268,"name":"$previous","kind":13,"containerName":"accession"},{"line":268,"containerName":"accession","kind":13,"name":"$value"},{"name":"$self","containerName":"accession","kind":13,"line":269},{"name":"$value","containerName":"accession","kind":13,"line":269},{"containerName":"accession","kind":13,"name":"$previous","line":271}]},{"children":[{"line":285,"name":"$self","kind":13,"localvar":"my","containerName":"description","definition":"my"},{"line":285,"containerName":"description","kind":13,"name":"$value"},{"definition":"my","line":286,"name":"$previous","containerName":"description","localvar":"my","kind":13},{"line":286,"kind":13,"containerName":"description","name":"$self"},{"kind":13,"containerName":"description","name":"$value","line":287},{"name":"$previous","containerName":"description","kind":13,"line":287},{"name":"$value","kind":13,"containerName":"description","line":288},{"line":288,"kind":13,"containerName":"description","name":"$previous"},{"name":"$value","kind":13,"containerName":"description","line":288},{"line":289,"containerName":"description","kind":13,"name":"$self"},{"line":289,"kind":13,"containerName":"description","name":"$value"},{"name":"$previous","kind":13,"containerName":"description","line":291}],"containerName":"main::","name":"description","definition":"sub","detail":"($self,$value)","line":284,"kind":12,"range":{"end":{"line":292,"character":9999},"start":{"line":284,"character":0}},"signature":{"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition","parameters":[{"label":"$self"},{"label":"$value"}],"label":"description($self,$value)"}},{"signature":{"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length","parameters":[{"label":"$self"},{"label":"$value"}],"label":"length($self,$value)"},"line":304,"range":{"end":{"character":9999,"line":312},"start":{"line":304,"character":0}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"containerName":"length","localvar":"my","kind":13,"name":"$self","line":305,"definition":"my"},{"line":305,"name":"$value","kind":13,"containerName":"length"},{"kind":13,"localvar":"my","containerName":"length","name":"$previous","line":306,"definition":"my"},{"name":"$self","containerName":"length","kind":13,"line":306},{"line":307,"containerName":"length","kind":13,"name":"$value"},{"line":307,"containerName":"length","kind":13,"name":"$previous"},{"line":308,"name":"$value","containerName":"length","kind":13},{"name":"$previous","kind":13,"containerName":"length","line":308},{"line":308,"kind":13,"containerName":"length","name":"$value"},{"line":309,"name":"$self","kind":13,"containerName":"length"},{"line":309,"containerName":"length","kind":13,"name":"$value"},{"name":"$previous","containerName":"length","kind":13,"line":311}],"name":"length","containerName":"main::"},{"detail":"($self,$value)","definition":"sub","name":"algorithm","containerName":"main::","children":[{"definition":"my","line":330,"localvar":"my","kind":13,"containerName":"algorithm","name":"$self"},{"line":330,"containerName":"algorithm","kind":13,"name":"$value"},{"name":"$previous","localvar":"my","containerName":"algorithm","kind":13,"line":331,"definition":"my"},{"kind":13,"containerName":"algorithm","name":"$self","line":331},{"line":332,"name":"$value","kind":13,"containerName":"algorithm"},{"name":"$previous","kind":13,"containerName":"algorithm","line":332},{"line":333,"name":"$value","kind":13,"containerName":"algorithm"},{"line":333,"name":"$previous","containerName":"algorithm","kind":13},{"name":"$value","kind":13,"containerName":"algorithm","line":333},{"line":334,"name":"$self","kind":13,"containerName":"algorithm"},{"name":"$value","containerName":"algorithm","kind":13,"line":334},{"name":"$previous","containerName":"algorithm","kind":13,"line":336}],"signature":{"label":"algorithm($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm"},"range":{"start":{"character":0,"line":329},"end":{"character":9999,"line":337}},"kind":12,"line":329},{"signature":{"label":"raw_score($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score"},"line":351,"kind":12,"range":{"end":{"character":9999,"line":366},"start":{"line":351,"character":0}},"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"raw_score","line":352},{"line":352,"name":"$value","containerName":"raw_score","kind":13},{"kind":13,"localvar":"my","containerName":"raw_score","name":"$previous","line":353,"definition":"my"},{"containerName":"raw_score","kind":13,"name":"$self","line":353},{"name":"$value","containerName":"raw_score","kind":13,"line":354},{"name":"$self","kind":13,"containerName":"raw_score","line":355},{"line":355,"containerName":"raw_score","kind":13,"name":"$value"},{"line":356,"containerName":"raw_score","kind":13,"name":"$previous"},{"containerName":"raw_score","kind":13,"name":"$self","line":358},{"line":359,"name":"$self","containerName":"raw_score","kind":13},{"line":359,"name":"warn","containerName":"raw_score","kind":12},{"line":359,"containerName":"raw_score","kind":13,"name":"$self"},{"line":359,"kind":12,"containerName":"raw_score","name":"name"},{"containerName":"raw_score","kind":13,"name":"$previous","line":363},{"line":363,"kind":13,"containerName":"raw_score","name":"$self"},{"line":363,"kind":13,"containerName":"raw_score","name":"$self"},{"line":363,"kind":12,"containerName":"raw_score","name":"hsps"},{"name":"score","kind":12,"containerName":"raw_score","line":363},{"line":365,"containerName":"raw_score","kind":13,"name":"$previous"}],"name":"raw_score","containerName":"main::"},{"containerName":"main::","name":"score","children":[{"name":"raw_score","containerName":"score","kind":12,"line":374}],"definition":"sub","range":{"end":{"line":374,"character":9999},"start":{"line":374,"character":0}},"kind":12,"line":374},{"signature":{"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance","parameters":[{"label":"$self"},{"label":"$value"}],"label":"significance($self,$value)"},"line":389,"range":{"end":{"character":9999,"line":404},"start":{"character":0,"line":389}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"significance","line":390},{"line":390,"name":"$value","containerName":"significance","kind":13},{"definition":"my","line":391,"localvar":"my","kind":13,"containerName":"significance","name":"$previous"},{"name":"$self","kind":13,"containerName":"significance","line":391},{"name":"$value","kind":13,"containerName":"significance","line":392},{"line":393,"name":"$self","containerName":"significance","kind":13},{"line":393,"name":"$value","kind":13,"containerName":"significance"},{"kind":13,"containerName":"significance","name":"$previous","line":394},{"line":395,"name":"$self","containerName":"significance","kind":13},{"name":"$self","kind":13,"containerName":"significance","line":396},{"name":"warn","containerName":"significance","kind":12,"line":396},{"kind":13,"containerName":"significance","name":"$self","line":396},{"line":396,"kind":12,"containerName":"significance","name":"name"},{"name":"$previous","kind":13,"containerName":"significance","line":400},{"name":"$self","kind":13,"containerName":"significance","line":400},{"name":"$self","kind":13,"containerName":"significance","line":400},{"name":"hsps","kind":12,"containerName":"significance","line":400},{"line":400,"name":"significance","kind":12,"containerName":"significance"},{"name":"$previous","kind":13,"containerName":"significance","line":403}],"containerName":"main::","name":"significance"},{"signature":{"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>","parameters":[{"label":"$self"},{"label":"$value"}],"label":"bits($self,$value)"},"kind":12,"range":{"start":{"character":0,"line":419},"end":{"line":434,"character":9999}},"line":419,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"bits","children":[{"definition":"my","line":420,"name":"$self","containerName":"bits","localvar":"my","kind":13},{"line":420,"name":"$value","containerName":"bits","kind":13},{"containerName":"bits","localvar":"my","kind":13,"name":"$previous","line":421,"definition":"my"},{"containerName":"bits","kind":13,"name":"$self","line":421},{"line":422,"name":"$value","kind":13,"containerName":"bits"},{"line":423,"name":"$self","containerName":"bits","kind":13},{"line":423,"name":"$value","containerName":"bits","kind":13},{"name":"$previous","containerName":"bits","kind":13,"line":424},{"kind":13,"containerName":"bits","name":"$self","line":426},{"line":427,"name":"$self","containerName":"bits","kind":13},{"name":"warn","kind":12,"containerName":"bits","line":427},{"line":427,"name":"$self","kind":13,"containerName":"bits"},{"line":427,"name":"name","kind":12,"containerName":"bits"},{"line":431,"name":"$previous","kind":13,"containerName":"bits"},{"line":431,"name":"$self","kind":13,"containerName":"bits"},{"line":431,"name":"$self","containerName":"bits","kind":13},{"line":431,"kind":12,"containerName":"bits","name":"hsps"},{"name":"bits","kind":12,"containerName":"bits","line":431},{"name":"$previous","kind":13,"containerName":"bits","line":433}]},{"range":{"start":{"line":447,"character":0},"end":{"character":9999,"line":452}},"kind":12,"line":447,"definition":"sub","containerName":"main::","name":"next_hsp","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"next_hsp","name":"$self","line":448},{"line":449,"containerName":"next_hsp","kind":13,"name":"$self"},{"line":449,"name":"$self","containerName":"next_hsp","kind":13},{"kind":13,"containerName":"next_hsp","name":"$self","line":451},{"line":452,"name":"$self","containerName":"next_hsp","kind":13},{"kind":13,"containerName":"next_hsp","name":"$self","line":452}]},{"definition":"my","name":"$iterator","containerName":null,"localvar":"my","kind":13,"line":454},{"name":"%self","kind":13,"containerName":null,"line":454},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$hsp","line":455},{"containerName":null,"kind":13,"name":"%self","line":455},{"line":455,"name":"$iterator","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%hsp","line":456},{"localvar":"my","kind":13,"containerName":null,"name":"$factory","line":457,"definition":"my"},{"line":457,"kind":13,"containerName":null,"name":"$self"},{"name":"hsp_factory","kind":12,"containerName":"main::","line":457},{"kind":13,"containerName":null,"name":"$self","line":457},{"line":457,"kind":12,"containerName":"main::","name":"throw"},{"containerName":null,"kind":13,"name":"$hsp","line":458},{"containerName":null,"kind":13,"name":"$factory","line":458},{"containerName":"main::","kind":12,"name":"create_object","line":458},{"line":458,"containerName":null,"kind":13,"name":"$hsp"},{"containerName":null,"kind":13,"name":"%self","line":459},{"containerName":null,"kind":13,"name":"$iterator","line":459},{"line":459,"containerName":null,"kind":13,"name":"$hsp"},{"line":460,"name":"%self","containerName":null,"kind":13},{"line":460,"name":"_hashes","kind":12},{"line":460,"kind":13,"containerName":null,"name":"$iterator"},{"containerName":null,"kind":13,"name":"$hsp","line":462},{"definition":"sub","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"hsps","line":484,"definition":"my"},{"line":485,"localvar":"my","containerName":"hsps","kind":13,"name":"$i","definition":"my"},{"name":"$self","containerName":"hsps","kind":13,"line":485}],"containerName":"main::","name":"hsps","line":483,"kind":12,"range":{"end":{"character":9999,"line":485},"start":{"character":0,"line":483}}},{"name":"_hashes","kind":12,"line":485},{"definition":"my","line":486,"containerName":null,"localvar":"my","kind":13,"name":"$factory"},{"line":486,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"hsp_factory","line":486},{"line":486,"containerName":null,"kind":13,"name":"$self"},{"containerName":"main::","kind":12,"name":"throw","line":486},{"kind":13,"containerName":null,"name":"%self","line":487},{"line":487,"kind":13,"containerName":null,"name":"$i"},{"name":"$factory","containerName":null,"kind":13,"line":487},{"containerName":"main::","kind":12,"name":"create_object","line":487},{"line":487,"name":"%self","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$i","line":487},{"line":488,"kind":13,"containerName":null,"name":"%self"},{"line":488,"name":"_hashes","kind":12},{"line":488,"name":"$i","kind":13,"containerName":null},{"line":491,"name":"%self","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":491},{"containerName":"main::","name":"num_hsps","children":[{"definition":"my","containerName":"num_hsps","localvar":"my","kind":13,"name":"$self","line":507},{"containerName":"num_hsps","kind":13,"name":"$self","line":509},{"kind":13,"containerName":"num_hsps","name":"$self","line":513}],"definition":"sub","range":{"end":{"character":9999,"line":513},"start":{"character":0,"line":506}},"kind":12,"line":506},{"signature":{"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none","parameters":[{"label":"$self"}],"label":"rewind($self)"},"line":527,"range":{"start":{"character":0,"line":527},"end":{"line":530,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"rewind","name":"$self","line":528},{"name":"$self","kind":13,"containerName":"rewind","line":529}],"name":"rewind","containerName":"main::"},{"definition":"sub","containerName":"main::","name":"ambiguous_aln","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"ambiguous_aln","kind":13,"line":554},{"name":"$self","containerName":"ambiguous_aln","kind":13,"line":555},{"containerName":"ambiguous_aln","kind":13,"name":"$self","line":556}],"kind":12,"range":{"end":{"line":557,"character":9999},"start":{"line":553,"character":0}},"line":553},{"definition":"sub","name":"overlap","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"overlap","name":"$self","line":566,"definition":"my"},{"name":"$self","containerName":"overlap","kind":13,"line":567},{"name":"$self","containerName":"overlap","kind":13,"line":568},{"name":"$self","containerName":"overlap","kind":13,"line":568}],"kind":12,"range":{"end":{"character":9999,"line":569},"start":{"character":0,"line":565}},"line":565},{"kind":12,"range":{"start":{"line":594,"character":0},"end":{"line":612,"character":9999}},"line":594,"definition":"sub","containerName":"main::","name":"n","children":[{"line":595,"name":"$self","localvar":"my","kind":13,"containerName":"n","definition":"my"},{"definition":"my","name":"$n","kind":13,"localvar":"my","containerName":"n","line":601},{"name":"$self","kind":13,"containerName":"n","line":602},{"line":603,"kind":13,"containerName":"n","name":"$self"},{"kind":12,"containerName":"n","name":"hsp","line":603},{"name":"$n","containerName":"n","kind":13,"line":604},{"line":604,"kind":13,"containerName":"n","name":"$self"},{"line":604,"kind":12,"containerName":"n","name":"hsp"},{"name":"n","kind":12,"containerName":"n","line":604},{"line":607,"name":"$n","kind":13,"containerName":"n"},{"line":607,"name":"$self","kind":13,"containerName":"n"},{"kind":13,"containerName":"n","name":"$n","line":609},{"name":"$self","kind":13,"containerName":"n","line":609},{"name":"num_hsps","kind":12,"containerName":"n","line":609},{"line":611,"kind":13,"containerName":"n","name":"$n"}]},{"line":641,"kind":12,"range":{"end":{"character":9999,"line":662},"start":{"character":0,"line":641}},"signature":{"label":"p($self,$fmt)","parameters":[{"label":"$self"},{"label":"$fmt"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>"},"children":[{"localvar":"my","containerName":"p","kind":13,"name":"$self","line":643,"definition":"my"},{"line":643,"name":"$fmt","kind":13,"containerName":"p"},{"definition":"my","kind":13,"localvar":"my","containerName":"p","name":"$val","line":645},{"kind":13,"containerName":"p","name":"$self","line":645},{"line":648,"kind":13,"containerName":"p","name":"$val"},{"kind":13,"containerName":"p","name":"$self","line":651},{"name":"warn","containerName":"p","kind":12,"line":651},{"line":652,"kind":13,"containerName":"p","name":"$val"},{"line":652,"name":"$self","kind":13,"containerName":"p"},{"line":652,"kind":12,"containerName":"p","name":"significance"},{"line":655,"kind":13,"containerName":"p","name":"$val"},{"name":"$fmt","kind":13,"containerName":"p","line":655},{"line":655,"containerName":"p","kind":13,"name":"$fmt"},{"line":657,"containerName":"p","kind":13,"name":"$val"},{"name":"$fmt","containerName":"p","kind":13,"line":657},{"line":658,"containerName":"p","kind":13,"name":"$val"},{"name":"$fmt","kind":13,"containerName":"p","line":658},{"name":"$val","kind":13,"containerName":"p","line":661}],"containerName":"main::","name":"p","definition":"sub","detail":"($self,$fmt)"},{"line":657,"kind":12,"containerName":"Search::SearchUtils::get_exponent","name":"Bio"},{"detail":"($self,$option)","definition":"sub","name":"hsp","containerName":"main::","children":[{"line":684,"name":"$self","localvar":"my","containerName":"hsp","kind":13,"definition":"my"},{"line":684,"kind":13,"containerName":"hsp","name":"$option"},{"containerName":"hsp","kind":13,"name":"$option","line":685},{"kind":13,"containerName":"hsp","name":"$self","line":687},{"line":688,"name":"$self","containerName":"hsp","kind":13},{"name":"throw","kind":12,"containerName":"hsp","line":688},{"name":"@hsps","localvar":"my","kind":13,"containerName":"hsp","line":691,"definition":"my"},{"line":691,"name":"$self","kind":13,"containerName":"hsp"},{"containerName":"hsp","kind":12,"name":"hsps","line":691},{"line":693,"name":"$hsps","kind":13,"containerName":"hsp"},{"line":693,"name":"$option","containerName":"hsp","kind":13},{"line":694,"name":"$hsps","kind":13,"containerName":"hsp"},{"kind":13,"containerName":"hsp","name":"$option","line":694},{"line":696,"containerName":"hsp","kind":13,"name":"$self"},{"line":696,"name":"throw","containerName":"hsp","kind":12}],"signature":{"parameters":[{"label":"$self"},{"label":"$option"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()","label":"hsp($self,$option)"},"kind":12,"range":{"start":{"line":683,"character":0},"end":{"character":9999,"line":698}},"line":683},{"name":"hsps","kind":12,"line":694},{"range":{"end":{"character":9999,"line":749},"start":{"line":729,"character":0}},"kind":12,"line":729,"definition":"sub","containerName":"main::","name":"logical_length","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"logical_length","line":730},{"definition":"my","kind":13,"localvar":"my","containerName":"logical_length","name":"$seqType","line":731},{"line":732,"kind":13,"containerName":"logical_length","name":"$seqType"},{"line":732,"kind":13,"containerName":"logical_length","name":"$seqType"},{"definition":"my","line":734,"name":"$length","kind":13,"localvar":"my","containerName":"logical_length"},{"line":734,"name":"$logical","kind":13,"containerName":"logical_length"},{"definition":"my","name":"$algo","containerName":"logical_length","localvar":"my","kind":13,"line":735},{"name":"$self","containerName":"logical_length","kind":13,"line":735},{"line":735,"kind":12,"containerName":"logical_length","name":"algorithm"},{"line":738,"name":"$seqType","kind":13,"containerName":"logical_length"},{"name":"$length","kind":13,"containerName":"logical_length","line":739},{"kind":13,"containerName":"logical_length","name":"$self","line":739},{"kind":12,"containerName":"logical_length","name":"length","line":739},{"line":742,"containerName":"logical_length","kind":13,"name":"$length"},{"containerName":"logical_length","kind":13,"name":"$self","line":742},{"line":742,"name":"query_length","kind":12,"containerName":"logical_length"},{"kind":13,"containerName":"logical_length","name":"$self","line":743},{"name":"throw","kind":12,"containerName":"logical_length","line":743},{"kind":13,"containerName":"logical_length","name":"$length","line":743},{"name":"$logical","kind":13,"containerName":"logical_length","line":746},{"kind":13,"containerName":"logical_length","name":"$algo","line":746},{"line":746,"containerName":"logical_length","kind":13,"name":"$seqType"},{"line":746,"containerName":"logical_length","kind":13,"name":"$length"},{"line":748,"containerName":"logical_length","kind":13,"name":"$logical"}]},{"line":746,"containerName":"Search::SearchUtils::logical_length","kind":12,"name":"Bio"},{"line":775,"kind":12,"range":{"end":{"line":802,"character":9999},"start":{"line":775,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$num"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>","label":"length_aln($self,$seqType,$num)"},"children":[{"kind":13,"localvar":"my","containerName":"length_aln","name":"$self","line":776,"definition":"my"},{"name":"$seqType","containerName":"length_aln","kind":13,"line":776},{"line":776,"name":"$num","kind":13,"containerName":"length_aln"},{"name":"$seqType","containerName":"length_aln","kind":13,"line":778},{"line":779,"kind":13,"containerName":"length_aln","name":"$seqType"},{"line":779,"name":"$seqType","kind":13,"containerName":"length_aln"},{"kind":13,"containerName":"length_aln","name":"$num","line":782},{"containerName":"length_aln","kind":13,"name":"$self","line":783},{"name":"$seqType","containerName":"length_aln","kind":13,"line":783},{"containerName":"length_aln","kind":13,"name":"$num","line":783},{"line":786,"name":"$self","kind":13,"containerName":"length_aln"},{"name":"$self","kind":13,"containerName":"length_aln","line":788},{"containerName":"length_aln","kind":13,"name":"$self","line":792},{"line":792,"kind":13,"containerName":"length_aln","name":"$self"},{"line":792,"containerName":"length_aln","kind":12,"name":"tiled_hsps"},{"localvar":"my","kind":13,"containerName":"length_aln","name":"$data","line":794,"definition":"my"},{"kind":13,"containerName":"length_aln","name":"$self","line":794},{"line":794,"kind":13,"containerName":"length_aln","name":"$seqType"},{"name":"$data","kind":13,"containerName":"length_aln","line":797},{"line":798,"containerName":"length_aln","kind":13,"name":"$self"},{"containerName":"length_aln","kind":12,"name":"throw","line":798},{"name":"$data","containerName":"length_aln","kind":13,"line":801}],"name":"length_aln","containerName":"main::","definition":"sub","detail":"($self,$seqType,$num)"},{"name":"Bio","containerName":"Search::SearchUtils::_warn_about_no_hsps","kind":12,"line":788},{"line":792,"name":"Bio","kind":12,"containerName":"Search::SearchUtils::tile_hsps"},{"containerName":"main::","name":"gaps","children":[{"definition":"my","localvar":"my","containerName":"gaps","kind":13,"name":"$self","line":839},{"kind":13,"containerName":"gaps","name":"$seqType","line":839},{"line":839,"name":"$num","kind":13,"containerName":"gaps"},{"name":"$seqType","kind":13,"containerName":"gaps","line":841},{"line":842,"name":"$seqType","containerName":"gaps","kind":13},{"containerName":"gaps","kind":13,"name":"$seqType","line":842},{"line":844,"name":"$self","containerName":"gaps","kind":13},{"name":"$self","containerName":"gaps","kind":13,"line":845},{"line":850,"name":"$self","containerName":"gaps","kind":13},{"name":"$self","kind":13,"containerName":"gaps","line":850},{"line":850,"name":"tiled_hsps","containerName":"gaps","kind":12},{"line":852,"kind":13,"containerName":"gaps","name":"$seqType"},{"kind":13,"containerName":"gaps","name":"$seqType","line":852},{"line":854,"name":"$num","containerName":"gaps","kind":13},{"line":855,"name":"$self","kind":13,"containerName":"gaps"},{"name":"throw","kind":12,"containerName":"gaps","line":855},{"name":"$seqType","containerName":"gaps","kind":13,"line":855},{"kind":13,"containerName":"gaps","name":"$seqType","line":855},{"kind":13,"containerName":"gaps","name":"$self","line":857},{"line":857,"containerName":"gaps","kind":13,"name":"$seqType"},{"line":857,"containerName":"gaps","kind":13,"name":"$num"},{"line":859,"name":"$seqType","kind":13,"containerName":"gaps"},{"line":860,"name":"$self","kind":13,"containerName":"gaps"},{"line":860,"name":"$self","containerName":"gaps","kind":13},{"name":"$seqType","kind":13,"containerName":"gaps","line":862},{"line":863,"name":"$self","kind":13,"containerName":"gaps"},{"name":"$self","kind":13,"containerName":"gaps","line":863},{"containerName":"gaps","kind":13,"name":"$self","line":865},{"kind":13,"containerName":"gaps","name":"$seqType","line":865}],"detail":"($self,$seqType,$num)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":867},"start":{"line":838,"character":0}},"line":838,"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$num"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>","label":"gaps($self,$seqType,$num)"}},{"line":845,"kind":12,"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio"},{"kind":12,"containerName":"Search::SearchUtils::tile_hsps","name":"Bio","line":850},{"signature":{"label":"matches($self,$arg1,$arg2)","parameters":[{"label":"$self"},{"label":"$arg1"},{"label":"$arg2"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>"},"line":876,"kind":12,"range":{"start":{"character":0,"line":876},"end":{"character":9999,"line":913}},"definition":"sub","detail":"($self,$arg1,$arg2)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"matches","line":877},{"name":"$arg1","containerName":"matches","kind":13,"line":877},{"name":"$arg2","kind":13,"containerName":"matches","line":877},{"definition":"my","line":878,"name":"@data","localvar":"my","kind":13,"containerName":"matches"},{"name":"$data","containerName":"matches","kind":13,"line":878},{"containerName":"matches","kind":13,"name":"$self","line":880},{"line":881,"name":"$self","containerName":"matches","kind":13},{"name":"$self","kind":13,"containerName":"matches","line":885},{"line":885,"name":"$self","containerName":"matches","kind":13},{"name":"tiled_hsps","containerName":"matches","kind":12,"line":885},{"containerName":"matches","kind":13,"name":"$arg1","line":887},{"line":888,"kind":13,"containerName":"matches","name":"@data"},{"kind":13,"containerName":"matches","name":"$self","line":888},{"containerName":"matches","kind":13,"name":"$self","line":888},{"name":"@data","kind":13,"containerName":"matches","line":890},{"containerName":"matches","kind":13,"name":"$arg2","line":893},{"kind":13,"containerName":"matches","name":"$self","line":894},{"name":"$arg1","kind":13,"containerName":"matches","line":894},{"line":895,"name":"$self","kind":13,"containerName":"matches"},{"name":"$arg2","containerName":"matches","kind":13,"line":895},{"containerName":"matches","kind":13,"name":"$arg1","line":896},{"line":896,"name":"$arg2","containerName":"matches","kind":13},{"name":"$arg1","kind":13,"containerName":"matches","line":898},{"line":899,"kind":13,"containerName":"matches","name":"$data"},{"containerName":"matches","kind":13,"name":"$self","line":899},{"line":901,"name":"$data","containerName":"matches","kind":13},{"kind":13,"containerName":"matches","name":"$self","line":901},{"line":904,"containerName":"matches","kind":13,"name":"$data"}],"name":"matches","containerName":"main::"},{"line":881,"name":"Bio","containerName":"Search::SearchUtils::_warn_about_no_hsps","kind":12},{"name":"Bio","containerName":"Search::SearchUtils::tile_hsps","kind":12,"line":885},{"signature":{"label":"start($self,$seqType,$num)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$num"}]},"kind":12,"range":{"start":{"character":0,"line":937},"end":{"character":9999,"line":988}},"line":937,"detail":"($self,$seqType,$num)","definition":"sub","name":"start","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"start","kind":13,"line":938,"definition":"my"},{"line":938,"kind":13,"containerName":"start","name":"$seqType"},{"name":"$num","kind":13,"containerName":"start","line":938},{"line":940,"name":"$self","kind":13,"containerName":"start"},{"line":941,"kind":13,"containerName":"start","name":"$self"},{"line":945,"name":"$seqType","containerName":"start","kind":13},{"line":946,"name":"$seqType","kind":13,"containerName":"start"},{"containerName":"start","kind":13,"name":"$seqType","line":946},{"containerName":"start","kind":13,"name":"$num","line":948},{"line":949,"containerName":"start","kind":13,"name":"$seqType"},{"line":950,"name":"$self","kind":13,"containerName":"start"},{"name":"$seqType","containerName":"start","kind":13,"line":950},{"line":950,"containerName":"start","kind":13,"name":"$num"},{"line":954,"containerName":"start","kind":13,"name":"$self"},{"line":954,"name":"num_hsps","containerName":"start","kind":12},{"name":"$self","kind":13,"containerName":"start","line":955},{"line":955,"kind":12,"containerName":"start","name":"hsp"},{"kind":12,"containerName":"start","name":"start","line":955},{"containerName":"start","kind":13,"name":"$seqType","line":955},{"line":961,"name":"$self","containerName":"start","kind":13},{"line":962,"localvar":"my","kind":13,"containerName":"start","name":"$earliest_query_start","definition":"my"},{"line":963,"name":"$earliest_sbjct_start","kind":13,"localvar":"my","containerName":"start","definition":"my"},{"line":964,"name":"$hsp","localvar":"my","kind":13,"containerName":"start","definition":"my"},{"line":964,"containerName":"start","kind":13,"name":"$self"},{"line":964,"name":"hsps","containerName":"start","kind":12},{"line":965,"name":"$this_query_start","localvar":"my","kind":13,"containerName":"start","definition":"my"},{"line":965,"name":"$hsp","kind":13,"containerName":"start"},{"line":965,"name":"start","containerName":"start","kind":12},{"name":"$earliest_query_start","containerName":"start","kind":13,"line":966},{"line":966,"containerName":"start","kind":13,"name":"$this_query_start"},{"line":966,"kind":13,"containerName":"start","name":"$earliest_query_start"},{"line":967,"name":"$earliest_query_start","kind":13,"containerName":"start"},{"line":967,"name":"$this_query_start","containerName":"start","kind":13},{"definition":"my","line":970,"localvar":"my","kind":13,"containerName":"start","name":"$this_sbjct_start"},{"name":"$hsp","containerName":"start","kind":13,"line":970},{"line":970,"name":"start","kind":12,"containerName":"start"},{"name":"$earliest_sbjct_start","kind":13,"containerName":"start","line":971},{"name":"$this_sbjct_start","kind":13,"containerName":"start","line":971},{"line":971,"name":"$earliest_sbjct_start","kind":13,"containerName":"start"},{"containerName":"start","kind":13,"name":"$earliest_sbjct_start","line":972},{"name":"$this_sbjct_start","containerName":"start","kind":13,"line":972},{"line":975,"kind":13,"containerName":"start","name":"$self"},{"line":975,"containerName":"start","kind":13,"name":"$earliest_query_start"},{"kind":13,"containerName":"start","name":"$self","line":976},{"line":976,"containerName":"start","kind":13,"name":"$earliest_sbjct_start"},{"containerName":"start","kind":13,"name":"$seqType","line":980},{"line":981,"name":"$self","containerName":"start","kind":13},{"line":981,"name":"$self","containerName":"start","kind":13},{"line":984,"name":"$seqType","kind":13,"containerName":"start"},{"name":"$self","kind":13,"containerName":"start","line":985},{"kind":13,"containerName":"start","name":"$seqType","line":985}]},{"line":941,"kind":12,"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio"},{"definition":"sub","detail":"($self,$seqType,$num)","children":[{"name":"$self","containerName":"end","localvar":"my","kind":13,"line":1015,"definition":"my"},{"line":1015,"kind":13,"containerName":"end","name":"$seqType"},{"name":"$num","kind":13,"containerName":"end","line":1015},{"kind":13,"containerName":"end","name":"$self","line":1017},{"kind":13,"containerName":"end","name":"$seqType","line":1021},{"name":"$seqType","kind":13,"containerName":"end","line":1022},{"containerName":"end","kind":13,"name":"$seqType","line":1022},{"name":"$num","kind":13,"containerName":"end","line":1024},{"line":1025,"containerName":"end","kind":13,"name":"$seqType"},{"containerName":"end","kind":13,"name":"$self","line":1026},{"line":1026,"containerName":"end","kind":13,"name":"$seqType"},{"kind":13,"containerName":"end","name":"$num","line":1026},{"line":1030,"name":"$self","containerName":"end","kind":13},{"line":1030,"name":"num_hsps","containerName":"end","kind":12},{"containerName":"end","kind":13,"name":"$self","line":1031},{"name":"hsp","containerName":"end","kind":12,"line":1031},{"line":1031,"kind":12,"containerName":"end","name":"end"},{"line":1031,"name":"$seqType","kind":13,"containerName":"end"},{"line":1037,"kind":13,"containerName":"end","name":"$self"},{"definition":"my","line":1038,"name":"$latest_query_end","localvar":"my","containerName":"end","kind":13},{"line":1039,"localvar":"my","kind":13,"containerName":"end","name":"$latest_sbjct_end","definition":"my"},{"name":"$hsp","kind":13,"localvar":"my","containerName":"end","line":1040,"definition":"my"},{"name":"$self","kind":13,"containerName":"end","line":1040},{"containerName":"end","kind":12,"name":"hsps","line":1040},{"definition":"my","localvar":"my","containerName":"end","kind":13,"name":"$this_query_end","line":1041},{"line":1041,"kind":13,"containerName":"end","name":"$hsp"},{"line":1041,"containerName":"end","kind":12,"name":"end"},{"line":1042,"kind":13,"containerName":"end","name":"$latest_query_end"},{"name":"$this_query_end","kind":13,"containerName":"end","line":1042},{"line":1042,"name":"$latest_query_end","containerName":"end","kind":13},{"name":"$latest_query_end","containerName":"end","kind":13,"line":1043},{"line":1043,"kind":13,"containerName":"end","name":"$this_query_end"},{"definition":"my","line":1046,"containerName":"end","localvar":"my","kind":13,"name":"$this_sbjct_end"},{"name":"$hsp","kind":13,"containerName":"end","line":1046},{"line":1046,"kind":12,"containerName":"end","name":"end"},{"line":1047,"containerName":"end","kind":13,"name":"$latest_sbjct_end"},{"kind":13,"containerName":"end","name":"$this_sbjct_end","line":1047},{"line":1047,"kind":13,"containerName":"end","name":"$latest_sbjct_end"},{"line":1048,"name":"$latest_sbjct_end","containerName":"end","kind":13},{"line":1048,"containerName":"end","kind":13,"name":"$this_sbjct_end"},{"line":1051,"name":"$self","containerName":"end","kind":13},{"name":"$latest_query_end","kind":13,"containerName":"end","line":1051},{"name":"$self","containerName":"end","kind":13,"line":1052},{"name":"$latest_sbjct_end","containerName":"end","kind":13,"line":1052},{"line":1056,"containerName":"end","kind":13,"name":"$seqType"},{"line":1057,"kind":13,"containerName":"end","name":"$self"},{"line":1057,"name":"$self","kind":13,"containerName":"end"},{"line":1060,"kind":13,"containerName":"end","name":"$seqType"},{"line":1061,"containerName":"end","kind":13,"name":"$self"},{"line":1061,"name":"$seqType","kind":13,"containerName":"end"}],"name":"end","containerName":"main::","signature":{"label":"end($self,$seqType,$num)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$num"}]},"line":1014,"kind":12,"range":{"start":{"line":1014,"character":0},"end":{"character":9999,"line":1064}}},{"kind":12,"range":{"end":{"character":9999,"line":1087},"start":{"line":1082,"character":0}},"line":1082,"signature":{"label":"range($self,$seqType)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>","parameters":[{"label":"$self"},{"label":"$seqType"}]},"containerName":"main::","name":"range","children":[{"name":"$self","containerName":"range","localvar":"my","kind":13,"line":1083,"definition":"my"},{"line":1083,"name":"$seqType","containerName":"range","kind":13},{"line":1084,"kind":13,"containerName":"range","name":"$seqType"},{"line":1085,"name":"$seqType","containerName":"range","kind":13},{"line":1085,"name":"$seqType","kind":13,"containerName":"range"},{"line":1086,"kind":13,"containerName":"range","name":"$self"},{"line":1086,"kind":12,"containerName":"range","name":"start"},{"line":1086,"name":"$seqType","kind":13,"containerName":"range"},{"line":1086,"containerName":"range","kind":13,"name":"$self"},{"line":1086,"kind":12,"containerName":"range","name":"end"},{"line":1086,"name":"$seqType","containerName":"range","kind":13}],"detail":"($self,$seqType)","definition":"sub"},{"definition":"sub","detail":"($self,$seqType)","children":[{"localvar":"my","kind":13,"containerName":"frac_identical","name":"$self","line":1140,"definition":"my"},{"line":1140,"name":"$seqType","containerName":"frac_identical","kind":13},{"line":1141,"name":"$seqType","kind":13,"containerName":"frac_identical"},{"line":1142,"name":"$seqType","containerName":"frac_identical","kind":13},{"line":1142,"containerName":"frac_identical","kind":13,"name":"$seqType"},{"name":"$seqType","kind":13,"containerName":"frac_identical","line":1145},{"containerName":"frac_identical","kind":13,"name":"$seqType","line":1145},{"name":"$self","kind":13,"containerName":"frac_identical","line":1147},{"line":1148,"kind":13,"containerName":"frac_identical","name":"$self"},{"name":"$self","containerName":"frac_identical","kind":13,"line":1153},{"name":"$self","kind":13,"containerName":"frac_identical","line":1153},{"line":1153,"kind":12,"containerName":"frac_identical","name":"tiled_hsps"},{"definition":"my","line":1155,"name":"$ident","containerName":"frac_identical","localvar":"my","kind":13},{"line":1155,"name":"$self","containerName":"frac_identical","kind":13},{"line":1155,"name":"matches","kind":12,"containerName":"frac_identical"},{"definition":"my","name":"$total","kind":13,"localvar":"my","containerName":"frac_identical","line":1156},{"name":"$self","kind":13,"containerName":"frac_identical","line":1156},{"name":"length_aln","kind":12,"containerName":"frac_identical","line":1156},{"line":1156,"kind":13,"containerName":"frac_identical","name":"$seqType"},{"name":"$ratio","localvar":"my","kind":13,"containerName":"frac_identical","line":1157,"definition":"my"},{"line":1157,"name":"$ident","containerName":"frac_identical","kind":13},{"name":"$total","kind":13,"containerName":"frac_identical","line":1157},{"definition":"my","line":1158,"localvar":"my","kind":13,"containerName":"frac_identical","name":"$ratio_rounded"},{"line":1158,"kind":13,"containerName":"frac_identical","name":"$ratio"},{"line":1161,"name":"$ratio_rounded","kind":13,"containerName":"frac_identical"},{"line":1161,"name":"$ratio_rounded","kind":13,"containerName":"frac_identical"},{"name":"$ratio","containerName":"frac_identical","kind":13,"line":1161},{"containerName":"frac_identical","kind":13,"name":"$ratio_rounded","line":1162}],"containerName":"main::","name":"frac_identical","signature":{"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>","parameters":[{"label":"$self"},{"label":"$seqType"}],"label":"frac_identical($self,$seqType)"},"line":1139,"range":{"end":{"character":9999,"line":1163},"start":{"line":1139,"character":0}},"kind":12},{"kind":12,"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio","line":1148},{"containerName":"Search::SearchUtils::tile_hsps","kind":12,"name":"Bio","line":1153},{"children":[{"definition":"my","line":1216,"localvar":"my","containerName":"frac_conserved","kind":13,"name":"$self"},{"line":1216,"containerName":"frac_conserved","kind":13,"name":"$seqType"},{"name":"$seqType","containerName":"frac_conserved","kind":13,"line":1217},{"kind":13,"containerName":"frac_conserved","name":"$seqType","line":1218},{"containerName":"frac_conserved","kind":13,"name":"$seqType","line":1218},{"line":1221,"containerName":"frac_conserved","kind":13,"name":"$seqType"},{"line":1221,"kind":13,"containerName":"frac_conserved","name":"$seqType"},{"kind":13,"containerName":"frac_conserved","name":"$self","line":1223},{"name":"$self","containerName":"frac_conserved","kind":13,"line":1224},{"kind":13,"containerName":"frac_conserved","name":"$self","line":1229},{"line":1229,"kind":13,"containerName":"frac_conserved","name":"$self"},{"line":1229,"kind":12,"containerName":"frac_conserved","name":"tiled_hsps"},{"line":1231,"containerName":"frac_conserved","localvar":"my","kind":13,"name":"$consv","definition":"my"},{"line":1231,"name":"$self","containerName":"frac_conserved","kind":13},{"kind":12,"containerName":"frac_conserved","name":"matches","line":1231},{"line":1232,"name":"$total","localvar":"my","containerName":"frac_conserved","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"frac_conserved","line":1232},{"line":1232,"kind":12,"containerName":"frac_conserved","name":"length_aln"},{"line":1232,"name":"$seqType","kind":13,"containerName":"frac_conserved"},{"definition":"my","line":1233,"name":"$ratio","kind":13,"localvar":"my","containerName":"frac_conserved"},{"kind":13,"containerName":"frac_conserved","name":"$consv","line":1233},{"containerName":"frac_conserved","kind":13,"name":"$total","line":1233},{"line":1234,"containerName":"frac_conserved","localvar":"my","kind":13,"name":"$ratio_rounded","definition":"my"},{"line":1234,"name":"$ratio","kind":13,"containerName":"frac_conserved"},{"containerName":"frac_conserved","kind":13,"name":"$ratio_rounded","line":1237},{"line":1237,"kind":13,"containerName":"frac_conserved","name":"$ratio_rounded"},{"line":1237,"name":"$ratio","kind":13,"containerName":"frac_conserved"},{"line":1238,"kind":13,"containerName":"frac_conserved","name":"$ratio_rounded"}],"containerName":"main::","name":"frac_conserved","definition":"sub","detail":"($self,$seqType)","line":1215,"kind":12,"range":{"end":{"character":9999,"line":1239},"start":{"character":0,"line":1215}},"signature":{"label":"frac_conserved($self,$seqType)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>","parameters":[{"label":"$self"},{"label":"$seqType"}]}},{"kind":12,"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio","line":1224},{"line":1229,"name":"Bio","containerName":"Search::SearchUtils::tile_hsps","kind":12},{"line":1263,"range":{"start":{"character":0,"line":1263},"end":{"character":9999,"line":1276}},"kind":12,"definition":"sub","children":[{"definition":"my","line":1264,"kind":13,"localvar":"my","containerName":"frac_aligned_query","name":"$self"},{"kind":13,"containerName":"frac_aligned_query","name":"$self","line":1266},{"name":"$self","containerName":"frac_aligned_query","kind":13,"line":1267},{"line":1272,"name":"$self","containerName":"frac_aligned_query","kind":13},{"name":"$self","containerName":"frac_aligned_query","kind":13,"line":1272},{"line":1272,"kind":12,"containerName":"frac_aligned_query","name":"tiled_hsps"},{"name":"$self","containerName":"frac_aligned_query","kind":13,"line":1274},{"line":1274,"name":"length_aln","containerName":"frac_aligned_query","kind":12},{"kind":13,"containerName":"frac_aligned_query","name":"$self","line":1275},{"line":1275,"name":"logical_length","kind":12,"containerName":"frac_aligned_query"}],"containerName":"main::","name":"frac_aligned_query"},{"kind":12,"containerName":"Search::SearchUtils::_warn_about_no_hsps","name":"Bio","line":1267},{"kind":12,"containerName":"Search::SearchUtils::tile_hsps","name":"Bio","line":1272},{"children":[{"line":1300,"containerName":"frac_aligned_hit","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"frac_aligned_hit","line":1302},{"containerName":"frac_aligned_hit","kind":13,"name":"$self","line":1303},{"line":1308,"name":"$self","containerName":"frac_aligned_hit","kind":13},{"containerName":"frac_aligned_hit","kind":13,"name":"$self","line":1308},{"kind":12,"containerName":"frac_aligned_hit","name":"tiled_hsps","line":1308},{"name":"$self","kind":13,"containerName":"frac_aligned_hit","line":1310},{"line":1310,"name":"length_aln","kind":12,"containerName":"frac_aligned_hit"},{"name":"$self","kind":13,"containerName":"frac_aligned_hit","line":1310},{"containerName":"frac_aligned_hit","kind":12,"name":"logical_length","line":1310}],"containerName":"main::","name":"frac_aligned_hit","definition":"sub","line":1299,"range":{"start":{"line":1299,"character":0},"end":{"character":9999,"line":1311}},"kind":12},{"line":1303,"containerName":"Search::SearchUtils::_warn_about_no_hsps","kind":12,"name":"Bio"},{"line":1308,"containerName":"Search::SearchUtils::tile_hsps","kind":12,"name":"Bio"},{"line":1330,"kind":12,"name":"num_unaligned_hit"},{"line":1353,"kind":12,"range":{"end":{"character":9999,"line":1366},"start":{"character":0,"line":1353}},"definition":"sub","children":[{"localvar":"my","kind":13,"containerName":"num_unaligned_hit","name":"$self","line":1354,"definition":"my"},{"line":1356,"containerName":"num_unaligned_hit","kind":13,"name":"$self"},{"line":1357,"name":"$self","kind":13,"containerName":"num_unaligned_hit"},{"line":1362,"containerName":"num_unaligned_hit","kind":13,"name":"$self"},{"kind":13,"containerName":"num_unaligned_hit","name":"$self","line":1362},{"line":1362,"name":"tiled_hsps","kind":12,"containerName":"num_unaligned_hit"},{"definition":"my","line":1364,"localvar":"my","containerName":"num_unaligned_hit","kind":13,"name":"$num"},{"kind":13,"containerName":"num_unaligned_hit","name":"$self","line":1364},{"containerName":"num_unaligned_hit","kind":12,"name":"logical_length","line":1364},{"line":1364,"containerName":"num_unaligned_hit","kind":13,"name":"$self"},{"name":"length_aln","containerName":"num_unaligned_hit","kind":12,"line":1364},{"line":1365,"name":"$num","kind":13,"containerName":"num_unaligned_hit"},{"line":1365,"containerName":"num_unaligned_hit","kind":13,"name":"$num"}],"name":"num_unaligned_hit","containerName":"main::"},{"name":"Bio","kind":12,"containerName":"Search::SearchUtils::_warn_about_no_hsps","line":1357},{"kind":12,"containerName":"Search::SearchUtils::tile_hsps","name":"Bio","line":1362},{"line":1389,"kind":12,"range":{"start":{"line":1389,"character":0},"end":{"line":1402,"character":9999}},"definition":"sub","children":[{"name":"$self","containerName":"num_unaligned_query","localvar":"my","kind":13,"line":1390,"definition":"my"},{"line":1392,"containerName":"num_unaligned_query","kind":13,"name":"$self"},{"line":1393,"containerName":"num_unaligned_query","kind":13,"name":"$self"},{"line":1398,"name":"$self","containerName":"num_unaligned_query","kind":13},{"line":1398,"name":"$self","containerName":"num_unaligned_query","kind":13},{"name":"tiled_hsps","containerName":"num_unaligned_query","kind":12,"line":1398},{"definition":"my","line":1400,"name":"$num","localvar":"my","containerName":"num_unaligned_query","kind":13},{"line":1400,"containerName":"num_unaligned_query","kind":13,"name":"$self"},{"name":"logical_length","containerName":"num_unaligned_query","kind":12,"line":1400},{"containerName":"num_unaligned_query","kind":13,"name":"$self","line":1400},{"line":1400,"name":"length_aln","kind":12,"containerName":"num_unaligned_query"},{"name":"$num","kind":13,"containerName":"num_unaligned_query","line":1401},{"line":1401,"name":"$num","kind":13,"containerName":"num_unaligned_query"}],"containerName":"main::","name":"num_unaligned_query"},{"line":1393,"containerName":"Search::SearchUtils::_warn_about_no_hsps","kind":12,"name":"Bio"},{"line":1398,"containerName":"Search::SearchUtils::tile_hsps","kind":12,"name":"Bio"},{"signature":{"label":"seq_inds($self,$seqType,$class,$collapse)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$class"},{"label":"$collapse"}]},"line":1431,"kind":12,"range":{"start":{"character":0,"line":1431},"end":{"character":9999,"line":1453}},"definition":"sub","detail":"($self,$seqType,$class,$collapse)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"seq_inds","kind":13,"line":1432},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":1432},{"name":"$class","kind":13,"containerName":"seq_inds","line":1432},{"line":1432,"name":"$collapse","containerName":"seq_inds","kind":13},{"kind":13,"containerName":"seq_inds","name":"$seqType","line":1434},{"name":"$class","containerName":"seq_inds","kind":13,"line":1435},{"name":"$collapse","kind":13,"containerName":"seq_inds","line":1436},{"line":1438,"name":"$seqType","containerName":"seq_inds","kind":13},{"name":"$seqType","kind":13,"containerName":"seq_inds","line":1438},{"localvar":"my","containerName":"seq_inds","kind":13,"name":"@inds","line":1440,"definition":"my"},{"line":1440,"kind":13,"containerName":"seq_inds","name":"$hsp"},{"containerName":"seq_inds","kind":13,"name":"$hsp","line":1441},{"containerName":"seq_inds","kind":13,"name":"$self","line":1441},{"name":"hsps","containerName":"seq_inds","kind":12,"line":1441},{"line":1443,"name":"@inds","kind":13,"containerName":"seq_inds"},{"line":1443,"kind":13,"containerName":"seq_inds","name":"$hsp"},{"line":1443,"kind":12,"containerName":"seq_inds","name":"seq_inds"},{"line":1443,"name":"$seqType","containerName":"seq_inds","kind":13},{"line":1443,"kind":13,"containerName":"seq_inds","name":"$class"},{"line":1447,"kind":13,"containerName":"seq_inds","name":"@inds"},{"definition":"my","line":1448,"name":"%tmp","kind":13,"localvar":"my","containerName":"seq_inds"},{"name":"@inds","kind":13,"containerName":"seq_inds","line":1448},{"name":"@inds","kind":13,"containerName":"seq_inds","line":1449},{"name":"$a","kind":13,"containerName":"seq_inds","line":1449},{"kind":13,"containerName":"seq_inds","name":"$b","line":1449},{"name":"%tmp","containerName":"seq_inds","kind":13,"line":1449},{"name":"$collapse","kind":13,"containerName":"seq_inds","line":1452},{"line":1452,"containerName":"seq_inds","kind":13,"name":"@inds"},{"line":1452,"kind":13,"containerName":"seq_inds","name":"@inds"}],"containerName":"main::","name":"seq_inds"},{"name":"Bio","containerName":"Search::SearchUtils::collapse_nums","kind":12,"line":1452},{"range":{"end":{"line":1516,"character":9999},"start":{"character":0,"line":1462}},"kind":12,"line":1462,"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$strnd"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);\n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds; \n}\n\n\n=head2 strand\n\nSee documentation in L<Bio::Search::Hit::HitI::strand()|Bio::Search::Hit::HitI>","label":"strand($self,$seqType,$strnd)"},"name":"strand","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"strand","line":1463,"definition":"my"},{"line":1463,"kind":13,"containerName":"strand","name":"$seqType"},{"line":1463,"name":"$strnd","kind":13,"containerName":"strand"},{"name":"$self","kind":13,"containerName":"strand","line":1465},{"line":1466,"containerName":"strand","kind":13,"name":"$self"},{"name":"$self","containerName":"strand","kind":13,"line":1471},{"name":"$self","kind":13,"containerName":"strand","line":1471},{"kind":12,"containerName":"strand","name":"tiled_hsps","line":1471},{"line":1473,"containerName":"strand","kind":13,"name":"$seqType"},{"name":"$seqType","containerName":"strand","kind":13,"line":1474},{"line":1474,"name":"$seqType","containerName":"strand","kind":13},{"line":1476,"kind":13,"containerName":"strand","name":"$seqType"},{"line":1476,"kind":13,"containerName":"strand","name":"$seqType"},{"line":1478,"kind":13,"containerName":"strand","name":"$strnd"},{"line":1479,"kind":13,"containerName":"strand","name":"$self"},{"line":1479,"containerName":"strand","kind":12,"name":"throw"},{"line":1479,"name":"$seqType","containerName":"strand","kind":13},{"line":1479,"containerName":"strand","kind":13,"name":"$seqType"},{"name":"$self","kind":13,"containerName":"strand","line":1481},{"line":1481,"name":"$seqType","kind":13,"containerName":"strand"},{"name":"$strnd","kind":13,"containerName":"strand","line":1481},{"line":1484,"localvar":"my","kind":13,"containerName":"strand","name":"$qstr","definition":"my"},{"kind":13,"containerName":"strand","name":"$hstr","line":1484},{"name":"$self","kind":13,"containerName":"strand","line":1486},{"line":1486,"name":"num_hsps","containerName":"strand","kind":12},{"kind":13,"containerName":"strand","name":"$self","line":1487},{"kind":12,"containerName":"strand","name":"hsp","line":1487},{"line":1487,"containerName":"strand","kind":12,"name":"strand"},{"line":1487,"name":"$seqType","kind":13,"containerName":"strand"},{"name":"$self","kind":13,"containerName":"strand","line":1489},{"containerName":"strand","kind":13,"name":"$qstr","line":1491},{"line":1491,"name":"$self","kind":13,"containerName":"strand"},{"name":"$hstr","kind":13,"containerName":"strand","line":1492},{"line":1492,"name":"$self","containerName":"strand","kind":13},{"definition":"my","line":1499,"name":"%qstr","localvar":"my","containerName":"strand","kind":13},{"name":"%hstr","containerName":"strand","kind":13,"line":1499},{"name":"$hsp","kind":13,"localvar":"my","containerName":"strand","line":1500,"definition":"my"},{"line":1500,"name":"$self","containerName":"strand","kind":13},{"line":1500,"containerName":"strand","kind":12,"name":"hsps"},{"definition":"my","line":1501,"kind":13,"localvar":"my","containerName":"strand","name":"$q"},{"name":"$h","containerName":"strand","kind":13,"line":1501},{"name":"$hsp","containerName":"strand","kind":13,"line":1501},{"line":1501,"name":"strand","kind":12,"containerName":"strand"},{"containerName":"strand","kind":13,"name":"$qstr","line":1502},{"line":1502,"name":"$q","kind":13,"containerName":"strand"},{"line":1503,"kind":13,"containerName":"strand","name":"$hstr"},{"containerName":"strand","kind":13,"name":"$h","line":1503},{"line":1505,"name":"$qstr","containerName":"strand","kind":13},{"line":1505,"name":"%qstr","kind":13,"containerName":"strand"},{"line":1506,"name":"$hstr","containerName":"strand","kind":13},{"name":"%hstr","containerName":"strand","kind":13,"line":1506},{"name":"$seqType","kind":13,"containerName":"strand","line":1509},{"line":1510,"name":"$qstr","kind":13,"containerName":"strand"},{"name":"$hstr","kind":13,"containerName":"strand","line":1510},{"kind":13,"containerName":"strand","name":"$seqType","line":1511},{"name":"$qstr","kind":13,"containerName":"strand","line":1512},{"line":1514,"name":"$hstr","containerName":"strand","kind":13}],"detail":"($self,$seqType,$strnd)","definition":"sub"},{"line":1466,"containerName":"Search::SearchUtils::_warn_about_no_hsps","kind":12,"name":"Bio"},{"kind":12,"containerName":"Search::SearchUtils::tile_hsps","name":"Bio","line":1471},{"signature":{"parameters":[{"label":"$self"},{"label":"$frm"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);\n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds; \n}\n\n\n=head2 strand\n\nSee documentation in L<Bio::Search::Hit::HitI::strand()|Bio::Search::Hit::HitI>\n\n\nsub strand {\n    my ($self, $seqType, $strnd) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType = lc($seqType);\n\n    if( defined $strnd ) {\n        $self->throw(\"Can't set strand for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_strand_'.$seqType} = $strnd;\n    }\n\n    my ($qstr, $hstr);\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->strand($seqType);\n    } \n    elsif( defined $self->{'_strand_query'}) {\n        # Get the data computed during hsp tiling.\n        $qstr = $self->{'_strand_query'};\n        $hstr = $self->{'_strand_sbjct'}\n    }\n    else {\n        # otherwise, iterate through all HSPs collecting strand info.\n        # This will return the string \"-1/1\" if there are HSPs on different strands.\n        # NOTE: This was the pre-10/21/02 procedure which will no longer be used,\n        # (unless the above elsif{} is commented out).\n        my (%qstr, %hstr);\n        foreach my $hsp( $self->hsps ) {\n            my ( $q, $h ) = $hsp->strand();\n            $qstr{ $q }++;\n            $hstr{ $h }++;\n        }\n        $qstr = join( '/', sort keys %qstr);\n        $hstr = join( '/', sort keys %hstr);\n    }\n\n    if($seqType =~ /list|array/i) {\n        return ($qstr, $hstr);\n    } elsif( $seqType eq 'query' ) {\n        return $qstr;\n    } else {\n        return $hstr;\n    }\n}\n\n=head2 frame\n\nSee documentation in L<Bio::Search::Hit::HitI::frame()|Bio::Search::Hit::HitI>","label":"frame($self,$frm)"},"range":{"end":{"character":9999,"line":1549},"start":{"line":1524,"character":0}},"kind":12,"line":1524,"detail":"($self,$frm)","definition":"sub","containerName":"main::","name":"frame","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"frame","kind":13,"line":1525},{"name":"$frm","kind":13,"containerName":"frame","line":1525},{"name":"$self","kind":13,"containerName":"frame","line":1527},{"name":"$self","containerName":"frame","kind":13,"line":1528},{"line":1533,"name":"$self","containerName":"frame","kind":13},{"name":"$self","kind":13,"containerName":"frame","line":1533},{"line":1533,"kind":12,"containerName":"frame","name":"tiled_hsps"},{"kind":13,"containerName":"frame","name":"$frm","line":1535},{"line":1536,"name":"$self","kind":13,"containerName":"frame"},{"line":1536,"name":"$frm","containerName":"frame","kind":13},{"line":1542,"name":"$frame","localvar":"my","containerName":"frame","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"frame","line":1543},{"name":"$frame","kind":13,"containerName":"frame","line":1544},{"line":1544,"name":"$self","kind":13,"containerName":"frame"},{"kind":12,"containerName":"frame","name":"hsp","line":1544},{"line":1544,"name":"frame","containerName":"frame","kind":12},{"name":"$frame","kind":13,"containerName":"frame","line":1546},{"name":"$self","kind":13,"containerName":"frame","line":1546},{"line":1548,"containerName":"frame","kind":13,"name":"$frame"}]},{"name":"Bio","kind":12,"containerName":"Search::SearchUtils::_warn_about_no_hsps","line":1528},{"containerName":"Search::SearchUtils::tile_hsps","kind":12,"name":"Bio","line":1533},{"definition":"sub","children":[{"line":1564,"containerName":"rank","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":1565,"kind":13,"containerName":"rank","name":"$self"},{"name":"$self","containerName":"rank","kind":13,"line":1566}],"name":"rank","containerName":"main::","line":1563,"range":{"end":{"line":1567,"character":9999},"start":{"character":0,"line":1563}},"kind":12},{"name":"locus","containerName":"main::","children":[{"definition":"my","line":1580,"containerName":"locus","localvar":"my","kind":13,"name":"$self"},{"line":1580,"kind":13,"containerName":"locus","name":"$value"},{"line":1581,"name":"$previous","kind":13,"localvar":"my","containerName":"locus","definition":"my"},{"containerName":"locus","kind":13,"name":"$self","line":1581},{"name":"$value","containerName":"locus","kind":13,"line":1582},{"line":1582,"kind":13,"containerName":"locus","name":"$previous"},{"line":1583,"name":"$value","containerName":"locus","kind":13},{"name":"$self","containerName":"locus","kind":13,"line":1584},{"line":1585,"name":"$value","containerName":"locus","kind":13},{"line":1585,"name":"$previous","kind":13,"containerName":"locus"},{"containerName":"locus","kind":13,"name":"$value","line":1587},{"name":"$previous","kind":13,"containerName":"locus","line":1587},{"name":"$self","kind":13,"containerName":"locus","line":1590},{"line":1590,"name":"$value","containerName":"locus","kind":13},{"line":1592,"name":"$previous","kind":13,"containerName":"locus"}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":1593},"start":{"line":1579,"character":0}},"line":1579,"signature":{"label":"locus($self,$value)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);\n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds; \n}\n\n\n=head2 strand\n\nSee documentation in L<Bio::Search::Hit::HitI::strand()|Bio::Search::Hit::HitI>\n\n\nsub strand {\n    my ($self, $seqType, $strnd) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType = lc($seqType);\n\n    if( defined $strnd ) {\n        $self->throw(\"Can't set strand for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_strand_'.$seqType} = $strnd;\n    }\n\n    my ($qstr, $hstr);\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->strand($seqType);\n    } \n    elsif( defined $self->{'_strand_query'}) {\n        # Get the data computed during hsp tiling.\n        $qstr = $self->{'_strand_query'};\n        $hstr = $self->{'_strand_sbjct'}\n    }\n    else {\n        # otherwise, iterate through all HSPs collecting strand info.\n        # This will return the string \"-1/1\" if there are HSPs on different strands.\n        # NOTE: This was the pre-10/21/02 procedure which will no longer be used,\n        # (unless the above elsif{} is commented out).\n        my (%qstr, %hstr);\n        foreach my $hsp( $self->hsps ) {\n            my ( $q, $h ) = $hsp->strand();\n            $qstr{ $q }++;\n            $hstr{ $h }++;\n        }\n        $qstr = join( '/', sort keys %qstr);\n        $hstr = join( '/', sort keys %hstr);\n    }\n\n    if($seqType =~ /list|array/i) {\n        return ($qstr, $hstr);\n    } elsif( $seqType eq 'query' ) {\n        return $qstr;\n    } else {\n        return $hstr;\n    }\n}\n\n=head2 frame\n\nSee documentation in L<Bio::Search::Hit::HitI::frame()|Bio::Search::Hit::HitI>\n\n\nsub frame {\n    my( $self, $frm ) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    if( defined $frm ) {\n        return $self->{'_frame'} = $frm;\n    }\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'}; \n    } \n    return $frame;\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'_rank'} = shift if @_;\n    return $self->{'_rank'} || 1;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $locus = $hit->locus();\n Function: Retrieve the locus (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]}},{"kind":12,"range":{"start":{"line":1607,"character":0},"end":{"line":1647,"character":9999}},"line":1607,"signature":{"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);\n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds; \n}\n\n\n=head2 strand\n\nSee documentation in L<Bio::Search::Hit::HitI::strand()|Bio::Search::Hit::HitI>\n\n\nsub strand {\n    my ($self, $seqType, $strnd) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType = lc($seqType);\n\n    if( defined $strnd ) {\n        $self->throw(\"Can't set strand for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_strand_'.$seqType} = $strnd;\n    }\n\n    my ($qstr, $hstr);\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->strand($seqType);\n    } \n    elsif( defined $self->{'_strand_query'}) {\n        # Get the data computed during hsp tiling.\n        $qstr = $self->{'_strand_query'};\n        $hstr = $self->{'_strand_sbjct'}\n    }\n    else {\n        # otherwise, iterate through all HSPs collecting strand info.\n        # This will return the string \"-1/1\" if there are HSPs on different strands.\n        # NOTE: This was the pre-10/21/02 procedure which will no longer be used,\n        # (unless the above elsif{} is commented out).\n        my (%qstr, %hstr);\n        foreach my $hsp( $self->hsps ) {\n            my ( $q, $h ) = $hsp->strand();\n            $qstr{ $q }++;\n            $hstr{ $h }++;\n        }\n        $qstr = join( '/', sort keys %qstr);\n        $hstr = join( '/', sort keys %hstr);\n    }\n\n    if($seqType =~ /list|array/i) {\n        return ($qstr, $hstr);\n    } elsif( $seqType eq 'query' ) {\n        return $qstr;\n    } else {\n        return $hstr;\n    }\n}\n\n=head2 frame\n\nSee documentation in L<Bio::Search::Hit::HitI::frame()|Bio::Search::Hit::HitI>\n\n\nsub frame {\n    my( $self, $frm ) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    if( defined $frm ) {\n        return $self->{'_frame'} = $frm;\n    }\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'}; \n    } \n    return $frame;\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'_rank'} = shift if @_;\n    return $self->{'_rank'} || 1;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $locus = $hit->locus();\n Function: Retrieve the locus (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_locus'};\n    if( defined $value || ! defined $previous ) { \n      unless (defined $value) {\n        if ($self->{'_name'} =~/(gb|emb|dbj|ref)\\|(.*)\\|(.*)/) {\n                  $value = $previous = $3;\n                } else {\n          $value = $previous = '';\n        }\n      }\n          $self->{'_locus'} = $value;\n    } \n        return $previous;\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : @each_accession_number = $hit->each_accession_number();\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given\n Returns : list of all accession numbers in the description\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"each_accession_number($self,$value)"},"name":"each_accession_number","containerName":"main::","children":[{"definition":"my","line":1608,"kind":13,"localvar":"my","containerName":"each_accession_number","name":"$self"},{"line":1608,"containerName":"each_accession_number","kind":13,"name":"$value"},{"line":1609,"kind":13,"localvar":"my","containerName":"each_accession_number","name":"$desc","definition":"my"},{"line":1609,"name":"$self","kind":13,"containerName":"each_accession_number"},{"definition":"my","name":"@accnums","localvar":"my","kind":13,"containerName":"each_accession_number","line":1611},{"name":"@accnums","kind":13,"containerName":"each_accession_number","line":1612},{"containerName":"each_accession_number","kind":13,"name":"$self","line":1612},{"line":1613,"kind":13,"containerName":"each_accession_number","name":"$desc"},{"kind":13,"containerName":"each_accession_number","name":"$desc","line":1614},{"definition":"my","localvar":"my","kind":13,"containerName":"each_accession_number","name":"$id","line":1615},{"localvar":"my","containerName":"each_accession_number","kind":13,"name":"$acc","line":1616,"definition":"my"},{"kind":13,"containerName":"each_accession_number","name":"$version","line":1616},{"kind":13,"containerName":"each_accession_number","name":"$id","line":1617},{"kind":13,"containerName":"each_accession_number","name":"$acc","line":1618},{"line":1618,"name":"$version","kind":13,"containerName":"each_accession_number"},{"line":1619,"containerName":"each_accession_number","kind":13,"name":"$id"},{"line":1620,"containerName":"each_accession_number","kind":13,"name":"$acc"},{"line":1620,"name":"$version","containerName":"each_accession_number","kind":13},{"line":1621,"kind":13,"containerName":"each_accession_number","name":"$id"},{"name":"$acc","kind":13,"containerName":"each_accession_number","line":1622},{"line":1622,"name":"$id","containerName":"each_accession_number","kind":13},{"line":1623,"containerName":"each_accession_number","kind":13,"name":"$id"},{"line":1624,"name":"$acc","containerName":"each_accession_number","kind":13},{"line":1624,"containerName":"each_accession_number","kind":13,"name":"$version"},{"name":"$acc","kind":13,"containerName":"each_accession_number","line":1641},{"name":"$id","kind":13,"containerName":"each_accession_number","line":1641},{"name":"@accnums","kind":13,"containerName":"each_accession_number","line":1643},{"line":1643,"containerName":"each_accession_number","kind":13,"name":"$acc"},{"line":1646,"kind":13,"containerName":"each_accession_number","name":"@accnums"}],"detail":"($self,$value)","definition":"sub"},{"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"tiled_hsps","name":"$self","line":1656},{"line":1657,"name":"$self","containerName":"tiled_hsps","kind":13},{"name":"$self","kind":13,"containerName":"tiled_hsps","line":1658}],"containerName":"main::","name":"tiled_hsps","line":1655,"range":{"end":{"character":9999,"line":1659},"start":{"line":1655,"character":0}},"kind":12},{"containerName":"main::","name":"query_length","children":[{"line":1673,"name":"$self","kind":13,"localvar":"my","containerName":"query_length","definition":"my"},{"line":1675,"containerName":"query_length","kind":13,"name":"$self"},{"name":"$self","containerName":"query_length","kind":13,"line":1676}],"definition":"sub","range":{"start":{"line":1672,"character":0},"end":{"line":1677,"character":9999}},"kind":12,"line":1672},{"signature":{"label":"ncbi_gi($self,$value)","documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);\n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds; \n}\n\n\n=head2 strand\n\nSee documentation in L<Bio::Search::Hit::HitI::strand()|Bio::Search::Hit::HitI>\n\n\nsub strand {\n    my ($self, $seqType, $strnd) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType = lc($seqType);\n\n    if( defined $strnd ) {\n        $self->throw(\"Can't set strand for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_strand_'.$seqType} = $strnd;\n    }\n\n    my ($qstr, $hstr);\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->strand($seqType);\n    } \n    elsif( defined $self->{'_strand_query'}) {\n        # Get the data computed during hsp tiling.\n        $qstr = $self->{'_strand_query'};\n        $hstr = $self->{'_strand_sbjct'}\n    }\n    else {\n        # otherwise, iterate through all HSPs collecting strand info.\n        # This will return the string \"-1/1\" if there are HSPs on different strands.\n        # NOTE: This was the pre-10/21/02 procedure which will no longer be used,\n        # (unless the above elsif{} is commented out).\n        my (%qstr, %hstr);\n        foreach my $hsp( $self->hsps ) {\n            my ( $q, $h ) = $hsp->strand();\n            $qstr{ $q }++;\n            $hstr{ $h }++;\n        }\n        $qstr = join( '/', sort keys %qstr);\n        $hstr = join( '/', sort keys %hstr);\n    }\n\n    if($seqType =~ /list|array/i) {\n        return ($qstr, $hstr);\n    } elsif( $seqType eq 'query' ) {\n        return $qstr;\n    } else {\n        return $hstr;\n    }\n}\n\n=head2 frame\n\nSee documentation in L<Bio::Search::Hit::HitI::frame()|Bio::Search::Hit::HitI>\n\n\nsub frame {\n    my( $self, $frm ) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    if( defined $frm ) {\n        return $self->{'_frame'} = $frm;\n    }\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'}; \n    } \n    return $frame;\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'_rank'} = shift if @_;\n    return $self->{'_rank'} || 1;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $locus = $hit->locus();\n Function: Retrieve the locus (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_locus'};\n    if( defined $value || ! defined $previous ) { \n      unless (defined $value) {\n        if ($self->{'_name'} =~/(gb|emb|dbj|ref)\\|(.*)\\|(.*)/) {\n                  $value = $previous = $3;\n                } else {\n          $value = $previous = '';\n        }\n      }\n          $self->{'_locus'} = $value;\n    } \n        return $previous;\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : @each_accession_number = $hit->each_accession_number();\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given\n Returns : list of all accession numbers in the description\n Args    : none\n\n\nsub each_accession_number {\n    my ($self,$value) = @_;\n    my $desc = $self->{'_description'};\n    #put primary accnum on the list\n    my @accnums;\n    push (@accnums,$self->{'_accession'});\n    if( defined $desc )  { \n      while ($desc =~ /(\\b\\S+\\|\\S*\\|\\S*\\s?)/g) {\n        my $id = $1;\n        my ($acc, $version);\n\tif ($id =~ /(gb|emb|dbj|sp|pdb|bbs|ref|tp[gde])\\|(.*)\\|(.*)/) {\n\t    ($acc, $version) = split /\\./, $2; \n\t} elsif ($id =~ /(pir|prf|pat|gnl)\\|(.*)\\|(.*)/) {\n\t    ($acc, $version) = split /\\./, $3;  \n\t} elsif( $id =~ /(gim|gi|bbm|bbs|lcl)\\|(\\d*)/) {\n\t    $acc = $id;\n\t} elsif( $id =~ /(oth)\\|(.*)\\|(.*)\\|(.*)/ ) { # discontinued...\n\t    ($acc,$version) = ($2);\n\t} else {\n                     #punt, not matching the db's at ftp://ftp.ncbi.nih.gov/blast/db/README\n                     #Database Name                     Identifier Syntax\n          #============================      ========================\n          #GenBank                           gb|accession|locus\n          #EMBL Data Library                 emb|accession|locus\n          #DDBJ, DNA Database of Japan       dbj|accession|locus\n          #NBRF PIR                          pir||entry\n          #Protein Research Foundation       prf||name\n          #SWISS-PROT                        sp|accession|entry name\n          #Brookhaven Protein Data Bank      pdb|entry|chain\n          #Patents                           pat|country|number \n          #GenInfo Backbone Id               bbs|number \n          #General database identifier           gnl|database|identifier\n          #NCBI Reference Sequence           ref|accession|locus\n          #Local Sequence identifier         lcl|identifier\n              $acc=$id;\n            }\n            push(@accnums, $acc);\n          }\n    }  \n    return @accnums;\n}\n\n=head2 tiled_hsps\n\nSee documentation in L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub tiled_hsps { \n    my $self = shift;\n    return $self->{'_tiled_hsps'} = shift if @_;\n    return $self->{'_tiled_hsps'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $obj->query_length($newval)\n Function: Get/Set the query_length\n Returns : value of query_length (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub query_length {\n    my $self = shift;\n\n    return $self->{'_query_length'} = shift if @_;\n    return $self->{'_query_length'};\n}\n\n=head2 ncbi_gi\n\n Title   : ncbi_gi\n Usage   : $acc = $hit->ncbi_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]},"line":1690,"range":{"end":{"character":9999,"line":1698},"start":{"line":1690,"character":0}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"ncbi_gi","line":1691,"definition":"my"},{"line":1691,"containerName":"ncbi_gi","kind":13,"name":"$value"},{"containerName":"ncbi_gi","kind":13,"name":"$value","line":1692},{"name":"$self","containerName":"ncbi_gi","kind":13,"line":1693},{"line":1693,"name":"$value","kind":13,"containerName":"ncbi_gi"},{"line":1695,"name":"$self","kind":13,"containerName":"ncbi_gi"},{"line":1695,"name":"$self","containerName":"ncbi_gi","kind":13},{"line":1695,"name":"name","kind":12,"containerName":"ncbi_gi"},{"line":1697,"kind":13,"containerName":"ncbi_gi","name":"$self"}],"containerName":"main::","name":"ncbi_gi"},{"detail":"($self,$coderef)","definition":"sub","name":"sort_hsps","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"sort_hsps","name":"$self","line":1722,"definition":"my"},{"line":1722,"name":"$coderef","containerName":"sort_hsps","kind":13},{"definition":"my","line":1723,"name":"@sorted_hsps","containerName":"sort_hsps","localvar":"my","kind":13},{"line":1725,"name":"$coderef","containerName":"sort_hsps","kind":13},{"line":1726,"name":"$self","containerName":"sort_hsps","kind":13},{"containerName":"sort_hsps","kind":12,"name":"throw","line":1726},{"line":1727,"kind":13,"containerName":"sort_hsps","name":"$coderef"},{"name":"$coderef","kind":13,"containerName":"sort_hsps","line":1730},{"line":1734,"name":"@hsps","kind":13,"localvar":"my","containerName":"sort_hsps","definition":"my"},{"name":"$self","kind":13,"containerName":"sort_hsps","line":1734},{"name":"hsps","kind":12,"containerName":"sort_hsps","line":1734},{"name":"@sorted_hsps","kind":13,"containerName":"sort_hsps","line":1735},{"line":1735,"kind":13,"containerName":"sort_hsps","name":"$coderef"},{"line":1735,"kind":13,"containerName":"sort_hsps","name":"@hsps"},{"name":"$self","containerName":"sort_hsps","kind":13,"line":1738},{"line":1738,"kind":12,"containerName":"sort_hsps","name":"throw"},{"line":1741,"name":"$self","containerName":"sort_hsps","kind":13},{"line":1741,"kind":13,"containerName":"sort_hsps","name":"@sorted_hsps"}],"signature":{"parameters":[{"label":"$self"},{"label":"$coderef"}],"documentation":"1;\n# $Id: GenericHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::GenericHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::GenericHit - A generic implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::GenericHit;\n    my $hit = Bio::Search::Hit::GenericHit->new(-algorithm => 'blastp');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHit objects.\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a Database Sequence Search such\nas FASTA or BLAST.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHit or any other HitI-implementing object. If you use\nthe SearchIO system, HitI objects are created automatically from\na SearchIO stream which returns Bio::Search::Hit::HitI objects.\n\nFor documentation on what you can do with GenericHit (and other HitI\nobjects), please see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl-dot-org\nEmail sac-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::Hit::GenericHit;\nuse strict;\n\nuse Bio::Search::SearchUtils;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::HitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::GenericHit->new();\n Function: Builds a new Bio::Search::Hit::GenericHit object \n Returns : Bio::Search::Hit::GenericHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($hsps, $name,$query_len,$desc, $acc, $locus, $length,\n      $score,$algo,$signif,$bits, $p,\n      $rank, $hsp_factory, $gi) = $self->_rearrange([qw(HSPS\n                                     NAME \n                                     QUERY_LEN\n                                     DESCRIPTION\n                                     ACCESSION\n                                     LOCUS\n                                     LENGTH SCORE ALGORITHM \n                                     SIGNIFICANCE BITS P\n                                     RANK\n                                     HSP_FACTORY\n                                     NCBI_GI)], @args);\n  \n  defined $query_len && $self->query_length($query_len);\n\n  if( ! defined $name ) { \n      $self->throw(\"Must have defined a valid name for Hit\");\n  } else { \n      $self->name($name);\n  }  \n\n  defined $acc         && $self->accession($acc);\n  defined $locus       && $self->locus($locus);\n  defined $desc        && $self->description($desc);\n  defined $length      && $self->length($length);\n  defined $algo        && $self->algorithm($algo);\n  defined $signif      && $self->significance($signif);\n  defined $score       && $self->raw_score($score);\n  defined $bits        && $self->bits($bits);\n  defined $rank        && $self->rank($rank);\n  defined $hsp_factory && $self->hsp_factory($hsp_factory);\n  defined $gi          && $self->ncbi_gi($gi);\n  # p() has a weird interface, so this is a hack workaround\n  if (defined $p) {\n      $self->{_p} = $p;\n  }\n\n  $self->{'_iterator'} = 0;\n  if( defined $hsps  ) {\n      if( ref($hsps) !~ /array/i ) {\n          $self->warn(\"Did not specify a valid array ref for the param HSPS ($hsps)\");\n      } else {\n          my $hspcount=0;\n          while( @{$hsps} ) { \n              $hspcount++;\n              $self->add_hsp(shift @{$hsps} );\n          }\n          $self->{'_hsps'} = undef if $hspcount == 0;\n      }\n  } \n  else {\n      $self->{'_hsps'} = undef;\n  }\n\n  return $self;\n}\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\nsub add_hsp {\n   my ($self,$hsp) = @_;\n   if (!defined $hsp || (ref($hsp) ne 'HASH' && !$hsp->isa('Bio::Search::HSP::HSPI'))) { \n       $self->throw(\"Must provide a valid Bio::Search::HSP::HSPI object or hash ref to object: $self method: add_hsp value: $hsp\");\n       return;\n   }\n   \n   push @{$self->{'_hsps'}}, $hsp;\n   if (ref($hsp) eq 'HASH') {\n       $self->{_hashes}->{$#{$self->{'_hsps'}}} = 1;\n   }\n   return scalar @{$self->{'_hsps'}};\n}\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\nsub hsp_factory {\n    my $self = shift;\n    if (@_) { $self->{_hsp_factory} = shift }\n    return $self->{_hsp_factory} || return;\n}\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\nsub name {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_name'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_name'} = $value;\n    } \n    return $previous;\n}\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_accession'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_accession'} = $value;\n    } \n        return $previous;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\nsub description {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_description'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_description'} = $value;\n    } \n    return $previous;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\nsub length {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_length'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = 0 unless defined $value;\n        $self->{'_length'} = $value;\n    } \n    return $previous;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\nsub algorithm {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_algorithm'};\n    if( defined $value || ! defined $previous ) { \n        $value = $previous = '' unless defined $value;\n        $self->{'_algorithm'} = $value;\n    } \n    return $previous;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\nsub raw_score {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_score'};\n    if( defined $value ) { \n        $self->{'_score'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n        unless( defined $self->{'_hsps'}->[0] ) {\n            $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using NCBI BLAST, check bits() instead\");\n            return;\n        }   \n        $previous = $self->{'_score'} = ($self->hsps)[0]->score;\n    }    \n    return $previous;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\nsub significance {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_significance'};\n    if( defined $value ) { \n        $self->{'_significance'} = $value;\n    } elsif ( ! defined $previous ) {\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this Hit (\".$self->name.\")\");\n\t    return;\n\t}\n        # Set the significance of the Hit to that of the top HSP.\n        $previous = $self->{'_significance'} = ($self->hsps)[0]->significance;\n    }\n\n    return $previous;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\nsub bits {\n    my ($self,$value) = @_; \n    my $previous = $self->{'_bits'};\n    if( defined $value ) { \n        $self->{'_bits'} = $value;\n    } elsif ( ! defined $previous ) {\n        # Set the bits of the Hit to that of the top HSP.\n\tunless( defined $self->{'_hsps'}->[0] ) {\n\t    $self->warn(\"No HSPs for this minimal Hit (\".$self->name.\")\\n\".\n                    \"If using WU-BLAST, check raw_score() instead\");\n\t    return;\n\t}\n        $previous = $self->{'_bits'} = ($self->hsps)[0]->bits;\n    }    \n    return $previous;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    $self->{'_iterator'} = 0 unless defined $self->{'_iterator'};\n    return unless\n        defined($self->{'_hsps'}) \n        && $self->{'_iterator'} <= scalar @{$self->{'_hsps'}};\n    \n    my $iterator = $self->{'_iterator'}++;\n    my $hsp = $self->{'_hsps'}->[$iterator] || return;\n    if (ref($hsp) eq 'HASH') {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $hsp = $factory->create_object(%{$hsp});\n        $self->{'_hsps'}->[$iterator] = $hsp;\n        delete $self->{_hashes}->{$iterator};\n    }\n    return $hsp;  \n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\nsub hsps {\n    my $self = shift;\n    foreach my $i (keys %{$self->{_hashes} || {}}) {\n        my $factory = $self->hsp_factory || $self->throw(\"Tried to get a HSP, but it was a hash ref and we have no hsp factory\");\n        $self->{'_hsps'}->[$i] = $factory->create_object(%{$self->{'_hsps'}->[$i]});\n        delete $self->{_hashes}->{$i};\n    }\n    \n    return wantarray() ? @{$self->{'_hsps'} || []} : scalar(@{$self->{'_hsps'} || []});\n}\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\nsub num_hsps {\n    my $self = shift;\n    \n    unless ($self->{'_hsps'}) {\n        return '-';\n    }\n    \n    return scalar(@{$self->{'_hsps'}});\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->{'_iterator'} = 0;\n}\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\nsub ambiguous_aln {\n    my $self = shift;\n    if(@_) { $self->{'_ambiguous_aln'} = shift; }\n    $self->{'_ambiguous_aln'} || '-';\n}\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<significance()|significance>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\nsub p {\n# Some duplication of logic for p(), expect() and signif() for the sake of performance.\n    my ($self, $fmt) = @_;\n\n    my $val = $self->{'_p'};\n\n    # $val can be zero.\n    if(!defined $val) {\n        # P-value not defined, must be a NCBI Blast2 report.\n        # Use expect instead.\n        $self->warn( \"P-value not defined. Using significance() instead.\");\n        $val = $self->significance();\n    }\n\n    return $val if not $fmt or $fmt =~ /^raw/i;\n    ## Special formats: exponent-only or as list.\n    return &Bio::Search::SearchUtils::get_exponent($val) if $fmt =~ /^exp/i;\n    return (split (/eE/, $val)) if $fmt =~ /^parts/i;\n\n    ## Default: return the raw P-value.\n    return $val;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : This is necessary since the number of identical/conserved residues \n           : can be in terms of peptide sequence space, yet the query and/or hit\n           : sequence are in nucleotide space.\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : In the case of BLAST flavors:\n           : For TBLASTN reports, the length of the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           :\n           : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub logical_length {\n    my $self = shift;\n    my $seqType = shift || 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my ($length, $logical);\n    my $algo = $self->algorithm;\n\n    # For the sbjct, return logical sbjct length\n    if( $seqType eq 'sbjct' ) {\n        $length = $self->length;\n    } else {\n        # Otherwise, return logical query length\n        $length = $self->query_length();\n        $self->throw(\"Must have defined query_len\") unless ( $length );\n    }\n\n    $logical = Bio::Search::SearchUtils::logical_length($algo, $seqType, $length);\n\n    return int($logical);\n}\n\n=head2 length_aln\n\n Usage     : $hit_object->length_aln( [seq_type] );\n Purpose   : Get the total length of the aligned region for query or sbjct seq.\n           : This number will include all HSPs\n Example   : $len    = $hit_object->length_aln(); # default = query\n           : $lenAln = $hit_object->length_aln('query');\n Returns   : Integer \n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' (Default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument is not recognized.\n Comments  : This method will report the logical length of the alignment,\n           : meaning that for TBLAST[NX] reports, the length is reported\n           : using amino acid coordinate space (i.e., nucleotides / 3).\n           : \n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : If you don't want the tiled data, iterate through each HSP\n           : calling length() on each (use hsps() to get all HSPs).\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>, L<gaps()|gaps>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<Bio::Search::HSP::BlastHSP::length()|Bio::Search::HSP::BlastHSP>\n\n\nsub length_aln {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    # Setter:\n    if( defined $num) {\n        return $self->{'_length_aln_'.$seqType} = $num;\n    }\n\n    unless ($self->{'_hsps'}) {\n        #return wantarray ? ('-','-') : '-';\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $data = $self->{'_length_aln_'.$seqType};\n    \n    ## If we don't have data, figure out what went wrong.\n    if(!$data) {\n        $self->throw(\"Can't get length aln for sequence type \\\"$seqType\\\". \" . \n                     \"Valid types are 'query', 'hit', 'sbjct' ('sbjct' = 'hit')\");\n    }                \n    return $data;\n}    \n\n=head2 gaps\n\n Usage     : $hit_object->gaps( [seq_type] );\n Purpose   : Get the number of gaps in the aligned query, hit, or both sequences.\n           : Data is summed across all HSPs.\n Example   : $qgaps = $hit_object->gaps('query');\n           : $hgaps = $hit_object->gaps('hit');\n           : $tgaps = $hit_object->gaps();    # default = total (query + hit)\n Returns   : scalar context: integer\n           : array context without args: two-element list of integers  \n           :    (queryGaps, hitGaps)\n           : Array context can be forced by providing an argument of 'list' or 'array'.\n           :\n           : CAUTION: Calling this method within printf or sprintf is arrray context.\n           : So this function may not give you what you expect. For example:\n           :          printf \"Total gaps: %d\", $hit->gaps();\n           : Actually returns a two-element array, so what gets printed \n           : is the number of gaps in the query, not the total\n           :\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total' | 'list'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through each HSP object.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n           : Not relying on wantarray since that will fail in situations \n           : such as printf \"%d\", $hit->gaps() in which you might expect to \n           : be printing the total gaps, but evaluates to array context.\n\nSee Also   : L<length_aln()|length_aln>\n\n\nsub gaps {\n    my( $self, $seqType, $num ) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType = lc($seqType);\n\n    if( defined $num ) {\n        $self->throw(\"Can't set gaps for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_gaps_'.$seqType} = $num;\n    }\n    elsif($seqType =~ /list|array/i) {\n        return ($self->{'_gaps_query'}, $self->{'_gaps_sbjct'});\n    }\n    elsif($seqType eq 'total') {\n        return ($self->{'_gaps_query'} + $self->{'_gaps_sbjct'}) || 0;\n    } else {\n        return $self->{'_gaps_'.$seqType} || 0;\n    }\n}    \n\n\n=head2 matches\n\nSee documentation in L<Bio::Search::Hit::HitI::matches()|Bio::Search::Hit::HitI>\n\n\nsub matches {\n    my( $self, $arg1, $arg2) = @_;\n    my(@data,$data);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    unless( $arg1 ) {\n        @data = ($self->{'_totalIdentical'}, $self->{'_totalConserved'});\n\n        return @data;\n    } else {\n\n        if( defined $arg2 ) {\n            $self->{'_totalIdentical'} = $arg1;\n            $self->{'_totalConserved'} = $arg2;\n            return ( $arg1, $arg2 );\n        }\n        elsif($arg1 =~ /^id/i) { \n            $data = $self->{'_totalIdentical'};\n        } else {\n            $data = $self->{'_totalConserved'};\n        }\n        #print STDERR \"\\nmatches(): id=$self->{'_totalIdentical'}, cons=$self->{'_totalConserved'}\\n\\n\";\n        return $data;\n    }\n    \n    ## If we make it to here, it is likely the case that\n    ## the parser constructed a minimal hit object from the summary line only.\n    ## It either delibrately skipped parsing the alignment section,\n    ## or was not able to because it was absent (due to blast executable parameter\n    ## setting such as -b 0 (B=0 for WU-BLAST) )\n    #$self->throw(\"Can't get identical or conserved data: no data.\");\n}\n\n\n=head2 start\n\n Usage     : $sbjct->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, the lowest start\n           : value of all HSPs is returned.\n Example   : $qbeg = $sbjct->start('query');\n           : $sbeg = $sbjct->start('hit');\n           : ($qbeg, $sbeg) = $sbjct->start();\n Returns   : scalar context: integer \n           : array context without args: list of two integers (queryStart, sbjctStart)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<end()|end>, L<range()|range>, L<strand()|strand>, \n             L<Bio::Search::HSP::BlastHSP::start|Bio::Search::HSP::BlastHSP>\n\n\nsub start {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->start($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStart'} and\n        # $self->{'_sbjctStart'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStart'}) {\n            my $earliest_query_start;\n            my $earliest_sbjct_start;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_start = $hsp->start('query');\n                if (! defined $earliest_query_start || $this_query_start < $earliest_query_start) {\n                    $earliest_query_start = $this_query_start;\n                }\n                \n                my $this_sbjct_start = $hsp->start('sbjct');\n                if (! defined $earliest_sbjct_start || $this_sbjct_start < $earliest_sbjct_start) {\n                    $earliest_sbjct_start = $this_sbjct_start;\n                }\n            }\n            $self->{'_queryStart'} = $earliest_query_start;\n            $self->{'_sbjctStart'} = $earliest_sbjct_start;\n        }\n        \n        \n        if ($seqType =~ /list|array/i) {\n            return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Start'};\n        }\n    }\n}\n\n\n=head2 end\n\n Usage     : $sbjct->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the BlastHit object. If there is more than one HSP, \n             the largest end\n           : value of all HSPs is returned.\n Example   : $qend = $sbjct->end('query');\n           : $send = $sbjct->end('hit');\n           : ($qend, $send) = $sbjct->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers \n           : (queryEnd, sbjctEnd)\n           : Array context can be \"induced\" by providing an argument \n           : of 'list' or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'sbjct'\n           :  (case insensitive). If not supplied, 'query' is used.\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<range()|range>, L<strand()|strand>\n\n\nsub end {\n    my ($self, $seqType, $num) = @_;\n\n    unless ($self->{'_hsps'}) {\n        return wantarray ? ('-','-') : '-';\n    }\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if( defined $num ) {\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'} = $num;\n    }\n\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->end($seqType);\n    }\n    else {\n        # Tiling normally generates $self->{'_queryStop'} and\n        # $self->{'_sbjctStop'}, but is very slow. If we haven't tiled,\n        # find the answer quickly without tiling.\n        unless (defined $self->{'_queryStop'}) {\n            my $latest_query_end;\n            my $latest_sbjct_end;\n            foreach my $hsp ($self->hsps) {\n                my $this_query_end = $hsp->end('query');\n                if (! defined $latest_query_end || $this_query_end > $latest_query_end) {\n                    $latest_query_end = $this_query_end;\n                }\n                \n                my $this_sbjct_end = $hsp->end('sbjct');\n                if (! defined $latest_sbjct_end || $this_sbjct_end > $latest_sbjct_end) {\n                    $latest_sbjct_end = $this_sbjct_end;\n                }\n            }\n            $self->{'_queryStop'} = $latest_query_end;\n            $self->{'_sbjctStop'} = $latest_sbjct_end;\n        }\n        \n        \n        if($seqType =~ /list|array/i) {\n            return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n        } else {\n            ## Sensitive to member name changes.\n            $seqType = \"_\\L$seqType\\E\";\n            return $self->{$seqType.'Stop'};\n        }\n    }\n}\n\n=head2 range\n\n Usage     : $sbjct->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($qbeg, $qend) = $sbjct->range('query');\n           : ($sbeg, $send) = $sbjct->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L<start()|start>, L<end()|end>\n\n\nsub range {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    return ($self->start($seqType), $self->end($seqType));\n}\n\n\n=head2 frac_identical\n\n Usage     : $hit_object->frac_identical( [seq_type] );\n Purpose   : Get the overall fraction of identical positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_iden = $hit_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction identical, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of identical residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then iterate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_conserved()|frac_conserved>, L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_identical {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $ident = $self->matches('id');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $ident / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hit_object->frac_conserved( [seq_type] );\n Purpose   : Get the overall fraction of conserved positions across all HSPs.\n           : The number refers to only the aligned regions and does not\n           : account for unaligned regions in between the HSPs, if any.\n Example   : $frac_cons = $hit_object->frac_conserved('hit');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'\n           : default = 'query' (but see comments below).\n           : ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  :\n           : To compute the fraction conserved, the logical length of the \n           : aligned portion of the sequence is used, meaning that\n           : in the case of BLAST flavors, for TBLASTN reports, the length of \n           : the aligned portion of the \n           : nucleotide hit sequence is divided by 3; for BLASTX reports, \n           : the length of the aligned portion of the nucleotide query \n           : sequence is divided by 3. For TBLASTX reports, the length of \n           : both hit and query sequence are converted.\n           : This is necessary since the number of conserved residues is\n           : in terms of peptide sequence space.\n           :\n           : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Positives = 34/120 Positives = 67/120\".\n           : NCBI BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           :\n           : Therefore, when called with an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used. Total does NOT take into account HSP\n           : tiling, so it should not be used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method without an argument or \n           : with an argument of 'query' or 'hit'.\n           :\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_identical()|frac_identical>, L<matches()|matches>, L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_conserved {\n    my ($self, $seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = lc($seqType);\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $consv = $self->matches('cons');\n    my $total = $self->length_aln($seqType);\n    my $ratio = $consv / $total;\n    my $ratio_rounded = sprintf( \"%.3f\", $ratio);\n\n    # Round down iff normal rounding yields 1 (just like blast)\n    $ratio_rounded = 0.999 if (($ratio_rounded == 1) && ($ratio < 1));\n    return $ratio_rounded;\n}\n\n\n\n\n=head2 frac_aligned_query\n\n Usage     : $hit_object->frac_aligned_query();\n Purpose   : Get the fraction of the query sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_query();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_hit()|frac_aligned_hit>, L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('query') /\n             $self->logical_length('query'));\n}\n\n\n\n=head2 frac_aligned_hit\n\n Usage     : $hit_object->frac_aligned_hit();\n Purpose   : Get the fraction of the hit (sbjct) sequence which has been aligned\n           : across all HSPs (not including intervals between non-overlapping\n           : HSPs).\n Example   : $frac_alnq = $hit_object->frac_aligned_hit();\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : n/a\n Throws    : n/a\n Comments  : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically.\n\nSee Also   : L<frac_aligned_query()|frac_aligned_query>, L<matches()|matches>, , L<logical_length()|logical_length>, L<length_aln()|length_aln>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub frac_aligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    sprintf( \"%.2f\", $self->length_aln('sbjct') / $self->logical_length('sbjct'));\n}\n\n\n## These methods are being maintained for backward compatibility. \n\n=head2 frac_aligned_sbjct\n\nSame as L<frac_aligned_hit()|frac_aligned_hit>\n\n\n*frac_aligned_sbjct = \\&frac_aligned_hit;\n\n=head2 num_unaligned_sbjct\n\nSame as L<num_unaligned_hit()|num_unaligned_hit>\n\n\n*num_unaligned_sbjct = \\&num_unaligned_hit;\n\n\n=head2 num_unaligned_hit\n\n Usage     : $hit_object->num_unaligned_hit();\n Purpose   : Get the number of the unaligned residues in the hit sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_hit();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_hit().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_query()|num_unaligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\nsub num_unaligned_hit {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('sbjct') - $self->length_aln('sbjct');\n    ($num < 0 ? 0 : $num );\n}\n\n\n=head2 num_unaligned_query\n\n Usage     : $hit_object->num_unaligned_query();\n Purpose   : Get the number of the unaligned residues in the query sequence.\n           : Sums across all all HSPs.\n Example   : $num_unaln = $hit_object->num_unaligned_query();\n Returns   : Integer\n Argument  : n/a\n Throws    : n/a\n Comments  : See notes regarding logical lengths in the comments for frac_aligned_query().\n           : They apply here as well.\n           : If you need data for each HSP, use hsps() and then interate\n           : through the HSP objects.\n           : This method requires that all HSPs be tiled. If they have not\n           : already been tiled, they will be tiled first automatically..\n\nSee Also   : L<num_unaligned_hit()|num_unaligned_hit>, L<frac_aligned_query()|frac_aligned_query>,  L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub num_unaligned_query {\n    my $self = shift;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    my $num = $self->logical_length('query') - $self->length_aln('query');\n    ($num < 0 ? 0 : $num );\n}\n\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::BlastHSP::seq_inds()|Bio::Search::HSP::BlastHSP>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);\n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::SearchUtils::collapse_nums(@inds) : @inds; \n}\n\n\n=head2 strand\n\nSee documentation in L<Bio::Search::Hit::HitI::strand()|Bio::Search::Hit::HitI>\n\n\nsub strand {\n    my ($self, $seqType, $strnd) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        return wantarray ? ('-','-') : '-';\n        #return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType = lc($seqType);\n\n    if( defined $strnd ) {\n        $self->throw(\"Can't set strand for seqType '$seqType'. Must be 'query' or 'hit'\\n\") unless ($seqType eq 'sbjct' or $seqType eq 'query');\n\n        return $self->{'_strand_'.$seqType} = $strnd;\n    }\n\n    my ($qstr, $hstr);\n    # If there is only one HSP, defer this call to the solitary HSP.\n    if($self->num_hsps == 1) {\n        return $self->hsp->strand($seqType);\n    } \n    elsif( defined $self->{'_strand_query'}) {\n        # Get the data computed during hsp tiling.\n        $qstr = $self->{'_strand_query'};\n        $hstr = $self->{'_strand_sbjct'}\n    }\n    else {\n        # otherwise, iterate through all HSPs collecting strand info.\n        # This will return the string \"-1/1\" if there are HSPs on different strands.\n        # NOTE: This was the pre-10/21/02 procedure which will no longer be used,\n        # (unless the above elsif{} is commented out).\n        my (%qstr, %hstr);\n        foreach my $hsp( $self->hsps ) {\n            my ( $q, $h ) = $hsp->strand();\n            $qstr{ $q }++;\n            $hstr{ $h }++;\n        }\n        $qstr = join( '/', sort keys %qstr);\n        $hstr = join( '/', sort keys %hstr);\n    }\n\n    if($seqType =~ /list|array/i) {\n        return ($qstr, $hstr);\n    } elsif( $seqType eq 'query' ) {\n        return $qstr;\n    } else {\n        return $hstr;\n    }\n}\n\n=head2 frame\n\nSee documentation in L<Bio::Search::Hit::HitI::frame()|Bio::Search::Hit::HitI>\n\n\nsub frame {\n    my( $self, $frm ) = @_;\n\n    unless ($self->{'_hsps'}) {\n        Bio::Search::SearchUtils::_warn_about_no_hsps($self);\n        #return wantarray ? ('-','-') : '-';\n        return '-';\n    }\n\n    Bio::Search::SearchUtils::tile_hsps($self) unless $self->tiled_hsps;\n\n    if( defined $frm ) {\n        return $self->{'_frame'} = $frm;\n    }\n\n    # The check for $self->{'_frame'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description line only.\n\n    my ($frame);\n    if(not defined($self->{'_frame'})) {\n        $frame = $self->hsp->frame('hit');\n    } else {\n        $frame = $self->{'_frame'}; \n    } \n    return $frame;\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'_rank'} = shift if @_;\n    return $self->{'_rank'} || 1;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $locus = $hit->locus();\n Function: Retrieve the locus (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_locus'};\n    if( defined $value || ! defined $previous ) { \n      unless (defined $value) {\n        if ($self->{'_name'} =~/(gb|emb|dbj|ref)\\|(.*)\\|(.*)/) {\n                  $value = $previous = $3;\n                } else {\n          $value = $previous = '';\n        }\n      }\n          $self->{'_locus'} = $value;\n    } \n        return $previous;\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : @each_accession_number = $hit->each_accession_number();\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given\n Returns : list of all accession numbers in the description\n Args    : none\n\n\nsub each_accession_number {\n    my ($self,$value) = @_;\n    my $desc = $self->{'_description'};\n    #put primary accnum on the list\n    my @accnums;\n    push (@accnums,$self->{'_accession'});\n    if( defined $desc )  { \n      while ($desc =~ /(\\b\\S+\\|\\S*\\|\\S*\\s?)/g) {\n        my $id = $1;\n        my ($acc, $version);\n\tif ($id =~ /(gb|emb|dbj|sp|pdb|bbs|ref|tp[gde])\\|(.*)\\|(.*)/) {\n\t    ($acc, $version) = split /\\./, $2; \n\t} elsif ($id =~ /(pir|prf|pat|gnl)\\|(.*)\\|(.*)/) {\n\t    ($acc, $version) = split /\\./, $3;  \n\t} elsif( $id =~ /(gim|gi|bbm|bbs|lcl)\\|(\\d*)/) {\n\t    $acc = $id;\n\t} elsif( $id =~ /(oth)\\|(.*)\\|(.*)\\|(.*)/ ) { # discontinued...\n\t    ($acc,$version) = ($2);\n\t} else {\n                     #punt, not matching the db's at ftp://ftp.ncbi.nih.gov/blast/db/README\n                     #Database Name                     Identifier Syntax\n          #============================      ========================\n          #GenBank                           gb|accession|locus\n          #EMBL Data Library                 emb|accession|locus\n          #DDBJ, DNA Database of Japan       dbj|accession|locus\n          #NBRF PIR                          pir||entry\n          #Protein Research Foundation       prf||name\n          #SWISS-PROT                        sp|accession|entry name\n          #Brookhaven Protein Data Bank      pdb|entry|chain\n          #Patents                           pat|country|number \n          #GenInfo Backbone Id               bbs|number \n          #General database identifier           gnl|database|identifier\n          #NCBI Reference Sequence           ref|accession|locus\n          #Local Sequence identifier         lcl|identifier\n              $acc=$id;\n            }\n            push(@accnums, $acc);\n          }\n    }  \n    return @accnums;\n}\n\n=head2 tiled_hsps\n\nSee documentation in L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\nsub tiled_hsps { \n    my $self = shift;\n    return $self->{'_tiled_hsps'} = shift if @_;\n    return $self->{'_tiled_hsps'};\n}\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $obj->query_length($newval)\n Function: Get/Set the query_length\n Returns : value of query_length (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub query_length {\n    my $self = shift;\n\n    return $self->{'_query_length'} = shift if @_;\n    return $self->{'_query_length'};\n}\n\n=head2 ncbi_gi\n\n Title   : ncbi_gi\n Usage   : $acc = $hit->ncbi_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub ncbi_gi {\n    my ($self,$value) = @_;\n    if( defined $value ) {\n        $self->{'_ncbi_gi'} = $value;\n    } else {\n        $self->{'_ncbi_gi'} = $self->name =~ m{^gi\\|(\\d+)} ? $1 : '';\n    } \n    return $self->{'_ncbi_gi'};\n}\n\n\n# sort method for HSPs\n\n=head2 sort_hits\n\n Title\t\t: sort_hsps\n Usage\t\t: $result->sort_hsps(\\&sort_function)\n Function\t: Sorts the available HSP objects by a user-supplied function. Defaults to sort\n                  by descending score.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function.  See the documentation on the Perl sort()\n                  function for guidelines on writing sort functions.  \n Note\t\t: To access the special variables $a and $b used by the Perl sort() function \n                  the user function must access Bio::Search::Hit::HitI namespace. \n                  For example, use :\n                  $hit->sort_hsps( sub{$Bio::Search::Result::HitI::a->length <=> \n\t\t\t\t\t  $Bio::Search::Result::HitI::b->length});\n                   NOT $hit->sort_hsps($a->length <=> $b->length);","label":"sort_hsps($self,$coderef)"},"range":{"end":{"line":1744,"character":9999},"start":{"line":1721,"character":0}},"kind":12,"line":1721},{"kind":12,"name":"_default_sort_hsps","line":1730}],"version":5}