{"vars":[{"line":165,"kind":2,"containerName":"","name":"vars"},{"line":168,"name":"overload","containerName":"","kind":2},{"kind":12,"name":"to_string","line":168},{"name":"base","kind":2,"containerName":"","line":170},{"name":"$GAP_SYMBOL","containerName":null,"kind":13,"line":172},{"line":173,"name":"%STRAND_SYMBOL","kind":13,"containerName":null},{"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$class","line":212},{"line":212,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$self","line":214},{"line":214,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":214},{"name":"$self","containerName":"new","kind":13,"line":216},{"line":216,"name":"$self","kind":13,"containerName":"new"},{"name":"$raw_data","localvar":"my","kind":13,"containerName":"new","line":217,"definition":"my"},{"line":217,"name":"$qname","kind":13,"containerName":"new"},{"line":217,"containerName":"new","kind":13,"name":"$hname"},{"line":217,"containerName":"new","kind":13,"name":"$qlen"},{"containerName":"new","kind":13,"name":"$hlen","line":217},{"line":219,"containerName":"new","kind":13,"name":"$self"},{"name":"$self","containerName":"new","kind":13,"line":219},{"line":219,"name":"$raw_data","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$qname","line":220},{"containerName":"new","kind":13,"name":"$hname","line":220},{"name":"$self","kind":13,"containerName":"new","line":221},{"line":221,"containerName":"new","kind":12,"name":"_rearrange"},{"line":226,"containerName":"new","kind":13,"name":"@args"},{"name":"$self","kind":13,"containerName":"new","line":230},{"kind":12,"containerName":"new","name":"_set_data","line":230},{"line":230,"name":"$raw_data","containerName":"new","kind":13}],"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>"},"kind":12,"range":{"end":{"line":230,"character":9999},"start":{"line":210,"character":0}},"line":210},{"line":214,"name":"SUPER","containerName":"new","kind":12},{"line":232,"name":"$qb","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":232,"containerName":null,"kind":13,"name":"$hb"},{"name":"$self","containerName":null,"kind":13,"line":232},{"line":232,"containerName":"main::","kind":12,"name":"start"},{"definition":"my","name":"$qe","localvar":"my","containerName":null,"kind":13,"line":233},{"line":233,"kind":13,"containerName":null,"name":"$he"},{"kind":13,"containerName":null,"name":"$self","line":233},{"name":"end","kind":12,"containerName":"main::","line":233},{"line":234,"containerName":null,"localvar":"my","kind":13,"name":"$qs","definition":"my"},{"line":234,"name":"$hs","containerName":null,"kind":13},{"line":234,"containerName":null,"kind":13,"name":"$self"},{"name":"strand","kind":12,"containerName":"main::","line":234},{"definition":"my","name":"$qf","localvar":"my","kind":13,"containerName":null,"line":235},{"name":"$hf","containerName":null,"kind":13,"line":235},{"name":"$self","containerName":null,"kind":13,"line":235},{"name":"query","containerName":"main::","kind":12,"line":235},{"containerName":"main::","kind":12,"name":"frame","line":235},{"line":236,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"hit","line":236},{"kind":12,"containerName":"main::","name":"frame","line":236},{"kind":13,"containerName":null,"name":"$self","line":238},{"name":"query","containerName":"main::","kind":12,"line":238},{"kind":12,"containerName":"SeqFeature::Similarity","name":"Bio","line":238},{"kind":12,"containerName":"main::","name":"new","line":238},{"kind":13,"containerName":null,"name":"$qb","line":238},{"line":239,"containerName":null,"kind":13,"name":"$qe"},{"line":240,"kind":13,"containerName":null,"name":"$qs"},{"name":"$self","containerName":null,"kind":13,"line":241},{"name":"bits","containerName":"main::","kind":12,"line":241},{"name":"$self","kind":13,"containerName":null,"line":242},{"kind":12,"containerName":"main::","name":"score","line":242},{"name":"$qf","containerName":null,"kind":13,"line":243},{"line":244,"containerName":null,"kind":13,"name":"$qname"},{"name":"%self","kind":13,"containerName":null,"line":245},{"line":247,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"hit","line":247},{"line":247,"containerName":"SeqFeature::Similarity","kind":12,"name":"Bio"},{"name":"new","kind":12,"containerName":"main::","line":247},{"name":"$hb","kind":13,"containerName":null,"line":247},{"name":"$he","containerName":null,"kind":13,"line":248},{"line":249,"kind":13,"containerName":null,"name":"$hs"},{"line":250,"containerName":null,"kind":13,"name":"$self"},{"name":"bits","kind":12,"containerName":"main::","line":250},{"line":251,"kind":13,"containerName":null,"name":"$self"},{"line":251,"name":"score","containerName":"main::","kind":12},{"line":252,"name":"$hf","kind":13,"containerName":null},{"name":"$hname","containerName":null,"kind":13,"line":253},{"name":"%self","containerName":null,"kind":13,"line":254},{"line":257,"containerName":null,"kind":13,"name":"$self"},{"name":"query","containerName":"main::","kind":12,"line":257},{"containerName":"main::","kind":12,"name":"seqlength","line":257},{"name":"$qlen","kind":13,"containerName":null,"line":257},{"name":"$self","containerName":null,"kind":13,"line":258},{"line":258,"name":"hit","containerName":"main::","kind":12},{"kind":12,"containerName":"main::","name":"seqlength","line":258},{"line":258,"name":"$hlen","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$self","line":260},{"line":260,"kind":12,"containerName":"main::","name":"query"},{"line":260,"kind":12,"containerName":"main::","name":"frac_identical"},{"name":"$self","containerName":null,"kind":13,"line":260},{"line":260,"name":"frac_identical","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$self","line":261},{"line":261,"name":"hit","containerName":"main::","kind":12},{"containerName":"main::","kind":12,"name":"frac_identical","line":261},{"line":261,"containerName":null,"kind":13,"name":"$self"},{"name":"frac_identical","containerName":"main::","kind":12,"line":261},{"line":262,"name":"$self","containerName":null,"kind":13},{"line":276,"kind":12,"range":{"end":{"character":9999,"line":284},"start":{"character":0,"line":276}},"definition":"sub","children":[{"line":277,"localvar":"my","kind":13,"containerName":"_id_str","name":"$self","definition":"my"},{"kind":13,"containerName":"_id_str","name":"$self","line":278},{"definition":"my","name":"$qname","localvar":"my","containerName":"_id_str","kind":13,"line":279},{"kind":13,"containerName":"_id_str","name":"$self","line":279},{"kind":12,"containerName":"_id_str","name":"query","line":279},{"line":279,"name":"seqname","containerName":"_id_str","kind":12},{"definition":"my","name":"$hname","localvar":"my","containerName":"_id_str","kind":13,"line":280},{"line":280,"name":"$self","containerName":"_id_str","kind":13},{"line":280,"containerName":"_id_str","kind":12,"name":"hit"},{"line":280,"containerName":"_id_str","kind":12,"name":"seqname"},{"line":281,"kind":13,"containerName":"_id_str","name":"$self"},{"kind":13,"containerName":"_id_str","name":"$self","line":283}],"name":"_id_str","containerName":"main::"},{"signature":{"label":"algorithm($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none"},"line":305,"range":{"start":{"line":305,"character":0},"end":{"character":9999,"line":309}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","name":"$self","containerName":"algorithm","localvar":"my","kind":13,"line":307},{"line":307,"name":"@args","containerName":"algorithm","kind":13},{"containerName":"algorithm","kind":13,"name":"$self","line":308}],"containerName":"main::","name":"algorithm"},{"name":"signif","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"signif","kind":13,"line":334},{"definition":"my","line":335,"kind":13,"localvar":"my","containerName":"signif","name":"$val"},{"line":335,"containerName":"signif","kind":13,"name":"$self"},{"line":335,"name":"$self","kind":13,"containerName":"signif"},{"line":335,"containerName":"signif","kind":13,"name":"$self"},{"line":336,"name":"$val","kind":13,"containerName":"signif"}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":337},"start":{"character":0,"line":332}},"line":332},{"definition":"sub","children":[],"containerName":"main::","name":"evalue","line":357,"kind":12,"range":{"end":{"line":357,"character":9999},"start":{"line":357,"character":0}}},{"line":378,"range":{"end":{"character":9999,"line":378},"start":{"character":0,"line":378}},"kind":12,"definition":"sub","children":[{"definition":"my","line":378,"localvar":"my","kind":13,"containerName":"p","name":"$self"},{"containerName":"p","kind":13,"name":"$self","line":378}],"name":"p","containerName":"main::"},{"children":[{"line":382,"containerName":"pvalue","kind":12,"name":"p"}],"containerName":"main::","name":"pvalue","definition":"sub","line":382,"range":{"end":{"line":382,"character":9999},"start":{"line":382,"character":0}},"kind":12},{"range":{"end":{"line":415,"character":9999},"start":{"line":402,"character":0}},"kind":12,"line":402,"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>","parameters":[{"label":"$self"},{"label":"$seqType"}],"label":"length($self,$seqType)"},"containerName":"main::","name":"length","children":[{"line":406,"kind":13,"localvar":"my","containerName":"length","name":"$self","definition":"my"},{"line":406,"name":"$seqType","containerName":"length","kind":13},{"name":"$seqType","kind":13,"containerName":"length","line":407},{"line":408,"containerName":"length","kind":13,"name":"$seqType"},{"kind":13,"containerName":"length","name":"$seqType","line":408},{"line":410,"containerName":"length","kind":13,"name":"$seqType"},{"name":"$self","kind":13,"containerName":"length","line":410},{"name":"_set_seq_data","containerName":"length","kind":12,"line":410},{"name":"$self","containerName":"length","kind":13,"line":410},{"line":413,"name":"$seqType","kind":13,"containerName":"length"},{"name":"$self","kind":13,"containerName":"length","line":414},{"name":"$seqType","kind":13,"containerName":"length","line":414}],"detail":"($self,$seqType)","definition":"sub"},{"signature":{"label":"gaps($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>"},"line":441,"range":{"end":{"line":461,"character":9999},"start":{"character":0,"line":441}},"kind":12,"definition":"sub","detail":"($self,$seqType)","children":[{"line":443,"name":"$self","containerName":"gaps","localvar":"my","kind":13,"definition":"my"},{"containerName":"gaps","kind":13,"name":"$seqType","line":443},{"containerName":"gaps","kind":13,"name":"$self","line":445},{"containerName":"gaps","kind":12,"name":"_set_seq_data","line":445},{"line":445,"name":"$self","containerName":"gaps","kind":13},{"kind":13,"containerName":"gaps","name":"$seqType","line":447},{"line":448,"name":"$seqType","containerName":"gaps","kind":13},{"line":448,"name":"$seqType","containerName":"gaps","kind":13},{"containerName":"gaps","kind":13,"name":"$seqType","line":450},{"containerName":"gaps","kind":13,"name":"$self","line":451},{"line":451,"containerName":"gaps","kind":13,"name":"$self"},{"line":454,"containerName":"gaps","kind":13,"name":"$seqType"},{"name":"$self","kind":13,"containerName":"gaps","line":455},{"name":"$self","kind":13,"containerName":"gaps","line":455},{"line":458,"kind":13,"containerName":"gaps","name":"$seqType"},{"containerName":"gaps","kind":13,"name":"$self","line":459},{"line":459,"kind":13,"containerName":"gaps","name":"$seqType"}],"containerName":"main::","name":"gaps"},{"children":[{"line":499,"name":"$self","localvar":"my","kind":13,"containerName":"frac_identical","definition":"my"},{"kind":13,"containerName":"frac_identical","name":"$seqType","line":499},{"name":"$seqType","kind":13,"containerName":"frac_identical","line":500},{"kind":13,"containerName":"frac_identical","name":"$seqType","line":501},{"name":"$seqType","kind":13,"containerName":"frac_identical","line":501},{"line":503,"name":"$seqType","containerName":"frac_identical","kind":13},{"line":504,"kind":13,"containerName":"frac_identical","name":"$self"},{"line":504,"name":"_set_seq_data","kind":12,"containerName":"frac_identical"},{"line":504,"name":"$self","containerName":"frac_identical","kind":13},{"line":507,"kind":13,"containerName":"frac_identical","name":"$seqType"},{"containerName":"frac_identical","kind":13,"name":"$self","line":509},{"containerName":"frac_identical","kind":13,"name":"$self","line":509},{"name":"$seqType","kind":13,"containerName":"frac_identical","line":509}],"containerName":"main::","name":"frac_identical","definition":"sub","detail":"($self,$seqType)","line":493,"range":{"end":{"line":510,"character":9999},"start":{"character":0,"line":493}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>","label":"frac_identical($self,$seqType)"}},{"detail":"($self,$seqType)","definition":"sub","containerName":"main::","name":"frac_conserved","children":[{"line":550,"containerName":"frac_conserved","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":550,"name":"$seqType","containerName":"frac_conserved","kind":13},{"kind":13,"containerName":"frac_conserved","name":"$seqType","line":551},{"name":"$seqType","containerName":"frac_conserved","kind":13,"line":552},{"line":552,"kind":13,"containerName":"frac_conserved","name":"$seqType"},{"name":"$seqType","containerName":"frac_conserved","kind":13,"line":554},{"name":"$self","containerName":"frac_conserved","kind":13,"line":555},{"containerName":"frac_conserved","kind":12,"name":"_set_seq_data","line":555},{"name":"$self","kind":13,"containerName":"frac_conserved","line":555},{"line":559,"kind":13,"containerName":"frac_conserved","name":"$seqType"},{"name":"$self","kind":13,"containerName":"frac_conserved","line":561},{"containerName":"frac_conserved","kind":13,"name":"$self","line":561},{"name":"$seqType","containerName":"frac_conserved","kind":13,"line":561}],"signature":{"label":"frac_conserved($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>"},"kind":12,"range":{"start":{"line":544,"character":0},"end":{"line":562,"character":9999}},"line":544},{"definition":"sub","children":[{"containerName":"query_string","kind":12,"name":"seq_str","line":576}],"name":"query_string","containerName":"main::","line":576,"range":{"start":{"line":576,"character":0},"end":{"line":576,"character":9999}},"kind":12},{"containerName":"main::","name":"hit_string","children":[{"name":"seq_str","kind":12,"containerName":"hit_string","line":591}],"definition":"sub","range":{"start":{"line":591,"character":0},"end":{"line":591,"character":9999}},"kind":12,"line":591},{"line":609,"kind":12,"range":{"end":{"character":9999,"line":609},"start":{"character":0,"line":609}},"children":[{"containerName":"homology_string","kind":12,"name":"seq_str","line":609}],"name":"homology_string","containerName":"main::","definition":"sub"},{"definition":"sub","children":[{"line":625,"kind":12,"containerName":"expect","name":"evalue"}],"containerName":"main::","name":"expect","line":625,"kind":12,"range":{"start":{"character":0,"line":625},"end":{"character":9999,"line":625}}},{"children":[],"containerName":"main::","name":"rank","definition":"sub","line":642,"kind":12,"range":{"end":{"character":9999,"line":642},"start":{"line":642,"character":0}}},{"line":647,"kind":12,"range":{"end":{"character":9999,"line":647},"start":{"line":647,"character":0}},"definition":"sub","children":[{"name":"rank","containerName":"name","kind":12,"line":647}],"name":"name","containerName":"main::"},{"line":666,"kind":12,"range":{"start":{"line":666,"character":0},"end":{"character":9999,"line":670}},"definition":"sub","children":[{"line":668,"kind":13,"localvar":"my","containerName":"to_string","name":"$self","definition":"my"},{"line":669,"name":"$self","containerName":"to_string","kind":13},{"line":669,"kind":12,"containerName":"to_string","name":"rank"}],"name":"to_string","containerName":"main::"},{"definition":"sub","children":[{"name":"$self","containerName":"_set_data","localvar":"my","kind":13,"line":691,"definition":"my"},{"name":"@data","containerName":"_set_data","localvar":"my","kind":13,"line":692,"definition":"my"},{"line":693,"kind":13,"localvar":"my","containerName":"_set_data","name":"@queryList","definition":"my"},{"line":694,"localvar":"my","kind":13,"containerName":"_set_data","name":"@sbjctList","definition":"my"},{"line":695,"name":"@matchList","containerName":"_set_data","localvar":"my","kind":13,"definition":"my"},{"localvar":"my","kind":13,"containerName":"_set_data","name":"$matchLine","line":696,"definition":"my"},{"line":697,"name":"@linedat","kind":13,"localvar":"my","containerName":"_set_data","definition":"my"},{"localvar":"my","kind":13,"containerName":"_set_data","name":"$line","line":701,"definition":"my"},{"line":701,"kind":13,"containerName":"_set_data","name":"$aln_row_len"},{"line":701,"name":"$length_diff","kind":13,"containerName":"_set_data"},{"name":"$length_diff","kind":13,"containerName":"_set_data","line":702},{"line":713,"kind":13,"containerName":"_set_data","name":"$line"},{"line":713,"containerName":"_set_data","kind":13,"name":"@data"},{"containerName":"_set_data","kind":13,"name":"$line","line":714},{"line":716,"name":"$line","containerName":"_set_data","kind":13},{"kind":13,"containerName":"_set_data","name":"$self","line":717},{"containerName":"_set_data","kind":12,"name":"_set_score_stats","line":717},{"line":717,"containerName":"_set_data","kind":13,"name":"$line"},{"line":718,"name":"$line","kind":13,"containerName":"_set_data"},{"kind":13,"containerName":"_set_data","name":"$self","line":719},{"line":719,"kind":12,"containerName":"_set_data","name":"_set_match_stats"},{"line":719,"kind":13,"containerName":"_set_data","name":"$line"},{"kind":13,"containerName":"_set_data","name":"$line","line":720},{"name":"$frame","localvar":"my","containerName":"_set_data","kind":13,"line":724,"definition":"my"},{"kind":13,"containerName":"_set_data","name":"$self","line":725},{"name":"frame","kind":12,"containerName":"_set_data","line":725},{"kind":13,"containerName":"_set_data","name":"$frame","line":725},{"name":"$line","containerName":"_set_data","kind":13,"line":726},{"kind":13,"containerName":"_set_data","name":"@queryList","line":727},{"name":"$line","containerName":"_set_data","kind":13,"line":727},{"kind":13,"containerName":"_set_data","name":"$self","line":728},{"line":729,"name":"$aln_row_len","kind":13,"containerName":"_set_data"},{"line":730,"name":"$matchLine","containerName":"_set_data","kind":13},{"line":731,"name":"$matchLine","kind":13,"containerName":"_set_data"},{"line":733,"containerName":"_set_data","kind":13,"name":"$length_diff"},{"containerName":"_set_data","kind":13,"name":"$aln_row_len","line":733},{"line":733,"kind":13,"containerName":"_set_data","name":"$line"},{"kind":13,"containerName":"_set_data","name":"$length_diff","line":734},{"kind":13,"containerName":"_set_data","name":"$line","line":734},{"line":734,"containerName":"_set_data","kind":13,"name":"$length_diff"},{"containerName":"_set_data","kind":13,"name":"@matchList","line":735},{"line":735,"kind":13,"containerName":"_set_data","name":"$line"},{"line":736,"containerName":"_set_data","kind":13,"name":"$matchLine"},{"line":737,"name":"$line","kind":13,"containerName":"_set_data"},{"containerName":"_set_data","kind":13,"name":"@sbjctList","line":738},{"kind":13,"containerName":"_set_data","name":"$line","line":738},{"name":"$self","containerName":"_set_data","kind":13,"line":743},{"line":743,"kind":13,"containerName":"_set_data","name":"@queryList"},{"line":744,"kind":13,"containerName":"_set_data","name":"$self"},{"containerName":"_set_data","kind":13,"name":"@sbjctList","line":744},{"line":747,"containerName":"_set_data","kind":13,"name":"$self"},{"line":747,"containerName":"_set_data","kind":13,"name":"@matchList"},{"kind":13,"containerName":"_set_data","name":"$self","line":749},{"line":750,"containerName":"_set_data","localvar":"my","kind":13,"name":"$id_str","definition":"my"},{"name":"$self","kind":13,"containerName":"_set_data","line":750},{"name":"_id_str","kind":12,"containerName":"_set_data","line":750},{"line":751,"name":"$self","kind":13,"containerName":"_set_data"},{"containerName":"_set_data","kind":12,"name":"throw","line":751},{"line":754,"name":"@queryList","containerName":"_set_data","kind":13},{"name":"@sbjctList","kind":13,"containerName":"_set_data","line":754},{"definition":"my","name":"$id_str","localvar":"my","kind":13,"containerName":"_set_data","line":755},{"kind":13,"containerName":"_set_data","name":"$self","line":755},{"line":755,"name":"_id_str","kind":12,"containerName":"_set_data"},{"line":756,"kind":13,"containerName":"_set_data","name":"$self"},{"line":756,"name":"throw","containerName":"_set_data","kind":12}],"name":"_set_data","containerName":"main::","line":689,"range":{"start":{"character":0,"line":689},"end":{"character":9999,"line":758}},"kind":12},{"line":728,"containerName":"length","kind":12,"name":"CORE"},{"line":729,"name":"CORE","containerName":"length","kind":12},{"line":729,"containerName":"length","kind":12,"name":"CORE"},{"containerName":"length","kind":12,"name":"CORE","line":734},{"signature":{"label":"_set_score_stats($self,$data)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>","parameters":[{"label":"$self"},{"label":"$data"}]},"line":778,"range":{"end":{"line":823,"character":9999},"start":{"character":0,"line":778}},"kind":12,"definition":"sub","detail":"($self,$data)","children":[{"localvar":"my","containerName":"_set_score_stats","kind":13,"name":"$self","line":780,"definition":"my"},{"line":780,"kind":13,"containerName":"_set_score_stats","name":"$data"},{"name":"$expect","kind":13,"localvar":"my","containerName":"_set_score_stats","line":782,"definition":"my"},{"name":"$p","kind":13,"containerName":"_set_score_stats","line":782},{"line":784,"name":"$data","containerName":"_set_score_stats","kind":13},{"line":786,"containerName":"_set_score_stats","kind":13,"name":"$self"},{"line":786,"name":"bits","kind":12,"containerName":"_set_score_stats"},{"line":787,"kind":13,"containerName":"_set_score_stats","name":"$self"},{"line":787,"kind":12,"containerName":"_set_score_stats","name":"score"},{"line":788,"containerName":"_set_score_stats","kind":13,"name":"$expect"},{"name":"$data","kind":13,"containerName":"_set_score_stats","line":789},{"name":"$self","containerName":"_set_score_stats","kind":13,"line":791},{"kind":12,"containerName":"_set_score_stats","name":"bits","line":791},{"line":792,"name":"$self","containerName":"_set_score_stats","kind":13},{"line":792,"kind":12,"containerName":"_set_score_stats","name":"score"},{"line":793,"containerName":"_set_score_stats","kind":13,"name":"$self"},{"line":794,"name":"$expect","containerName":"_set_score_stats","kind":13},{"line":796,"name":"$data","containerName":"_set_score_stats","kind":13},{"kind":13,"containerName":"_set_score_stats","name":"$self","line":798},{"containerName":"_set_score_stats","kind":12,"name":"score","line":798},{"kind":13,"containerName":"_set_score_stats","name":"$self","line":799},{"containerName":"_set_score_stats","kind":12,"name":"bits","line":799},{"kind":13,"containerName":"_set_score_stats","name":"$expect","line":800},{"line":801,"kind":13,"containerName":"_set_score_stats","name":"$p"},{"containerName":"_set_score_stats","kind":13,"name":"$data","line":803},{"line":805,"containerName":"_set_score_stats","kind":13,"name":"$self"},{"line":805,"containerName":"_set_score_stats","kind":12,"name":"score"},{"line":806,"kind":13,"containerName":"_set_score_stats","name":"$self"},{"name":"bits","containerName":"_set_score_stats","kind":12,"line":806},{"line":807,"containerName":"_set_score_stats","kind":13,"name":"$expect"},{"name":"$self","containerName":"_set_score_stats","kind":13,"line":808},{"name":"$p","kind":13,"containerName":"_set_score_stats","line":809},{"line":812,"name":"$id_str","localvar":"my","containerName":"_set_score_stats","kind":13,"definition":"my"},{"name":"$self","containerName":"_set_score_stats","kind":13,"line":812},{"line":812,"containerName":"_set_score_stats","kind":12,"name":"_id_str"},{"line":813,"name":"$self","kind":13,"containerName":"_set_score_stats"},{"line":813,"kind":12,"containerName":"_set_score_stats","name":"throw"},{"name":"$data","kind":13,"containerName":"_set_score_stats","line":815},{"containerName":"_set_score_stats","kind":13,"name":"$expect","line":817},{"line":817,"name":"$expect","kind":13,"containerName":"_set_score_stats"},{"name":"$p","containerName":"_set_score_stats","kind":13,"line":818},{"name":"$p","kind":13,"containerName":"_set_score_stats","line":818},{"line":818,"name":"$p","containerName":"_set_score_stats","kind":13},{"name":"$self","containerName":"_set_score_stats","kind":13,"line":820},{"containerName":"_set_score_stats","kind":13,"name":"$expect","line":820},{"containerName":"_set_score_stats","kind":13,"name":"$self","line":821},{"name":"$p","kind":13,"containerName":"_set_score_stats","line":821},{"name":"$self","containerName":"_set_score_stats","kind":13,"line":822},{"line":822,"kind":12,"containerName":"_set_score_stats","name":"significance"},{"line":822,"containerName":"_set_score_stats","kind":13,"name":"$p"},{"kind":13,"containerName":"_set_score_stats","name":"$expect","line":822}],"name":"_set_score_stats","containerName":"main::"},{"signature":{"label":"_set_match_stats($self,$data)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>","parameters":[{"label":"$self"},{"label":"$data"}]},"line":849,"kind":12,"range":{"start":{"line":849,"character":0},"end":{"character":9999,"line":881}},"definition":"sub","detail":"($self,$data)","children":[{"definition":"my","line":851,"containerName":"_set_match_stats","localvar":"my","kind":13,"name":"$self"},{"kind":13,"containerName":"_set_match_stats","name":"$data","line":851},{"kind":13,"containerName":"_set_match_stats","name":"$data","line":853},{"name":"$self","kind":13,"containerName":"_set_match_stats","line":855},{"kind":13,"containerName":"_set_match_stats","name":"$self","line":856},{"name":"$data","kind":13,"containerName":"_set_match_stats","line":859},{"name":"$self","kind":13,"containerName":"_set_match_stats","line":861},{"line":862,"name":"$self","kind":13,"containerName":"_set_match_stats"},{"name":"$data","kind":13,"containerName":"_set_match_stats","line":865},{"containerName":"_set_match_stats","kind":13,"name":"$self","line":866},{"line":866,"name":"frame","containerName":"_set_match_stats","kind":12},{"line":871,"name":"$data","kind":13,"containerName":"_set_match_stats"},{"line":872,"name":"$self","kind":13,"containerName":"_set_match_stats"},{"line":873,"name":"$self","kind":13,"containerName":"_set_match_stats"}],"name":"_set_match_stats","containerName":"main::"},{"line":902,"range":{"start":{"line":902,"character":0},"end":{"character":9999,"line":906}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$self","containerName":"_set_seq_data","localvar":"my","kind":13,"line":904},{"line":906,"name":"$self","containerName":"_set_seq_data","kind":13},{"name":"_set_seq","kind":12,"containerName":"_set_seq_data","line":906},{"line":906,"containerName":"_set_seq_data","kind":13,"name":"$self"}],"name":"_set_seq_data","containerName":"main::"},{"name":"$self","containerName":null,"kind":13,"line":907},{"kind":12,"containerName":"main::","name":"_set_seq","line":907},{"containerName":null,"kind":13,"name":"%self","line":907},{"name":"%self","kind":13,"containerName":null,"line":910},{"kind":13,"containerName":null,"name":"%self","line":910},{"line":911,"name":"%self","containerName":null,"kind":13},{"line":912,"containerName":null,"kind":13,"name":"%self"},{"line":914,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"range":{"end":{"line":1005,"character":9999},"start":{"character":0,"line":942}},"line":942,"definition":"sub","containerName":"main::","name":"_set_seq","children":[{"definition":"my","line":944,"name":"$self","localvar":"my","kind":13,"containerName":"_set_seq"},{"line":945,"name":"$seqType","localvar":"my","containerName":"_set_seq","kind":13,"definition":"my"},{"definition":"my","containerName":"_set_seq","localvar":"my","kind":13,"name":"@data","line":946},{"definition":"my","line":947,"name":"@ranges","kind":13,"localvar":"my","containerName":"_set_seq"},{"containerName":"_set_seq","localvar":"my","kind":13,"name":"@sequence","line":948,"definition":"my"},{"name":"$numGaps","localvar":"my","kind":13,"containerName":"_set_seq","line":949,"definition":"my"},{"line":951,"name":"@data","containerName":"_set_seq","kind":13},{"line":953,"kind":13,"containerName":"_set_seq","name":"@ranges"},{"name":"@sequence","containerName":"_set_seq","kind":13,"line":954},{"line":957,"kind":13,"containerName":"_set_seq","name":"$self"},{"kind":12,"containerName":"_set_seq","name":"warn","line":957},{"kind":13,"containerName":"_set_seq","name":"@sequence","line":961},{"line":961,"name":"@ranges","kind":13,"containerName":"_set_seq"},{"definition":"my","name":"$id_str","kind":13,"localvar":"my","containerName":"_set_seq","line":962},{"containerName":"_set_seq","kind":13,"name":"$self","line":962},{"kind":12,"containerName":"_set_seq","name":"_id_str","line":962},{"name":"$self","kind":13,"containerName":"_set_seq","line":963},{"line":963,"containerName":"_set_seq","kind":12,"name":"throw"},{"line":967,"name":"$seqType","containerName":"_set_seq","kind":13},{"kind":13,"containerName":"_set_seq","name":"$self","line":968},{"line":968,"containerName":"_set_seq","kind":13,"name":"$seqType"},{"containerName":"_set_seq","kind":13,"name":"$ranges","line":968},{"name":"$self","containerName":"_set_seq","kind":13,"line":969},{"containerName":"_set_seq","kind":13,"name":"$seqType","line":969},{"name":"$ranges","containerName":"_set_seq","kind":13,"line":969},{"kind":13,"containerName":"_set_seq","name":"$self","line":970},{"kind":13,"containerName":"_set_seq","name":"$seqType","line":970},{"containerName":"_set_seq","kind":13,"name":"@sequence","line":970},{"line":972,"kind":13,"containerName":"_set_seq","name":"$self"},{"line":972,"name":"$seqType","kind":13,"containerName":"_set_seq"},{"kind":13,"containerName":"_set_seq","name":"$ranges","line":972},{"name":"$ranges","kind":13,"containerName":"_set_seq","line":972},{"name":"$prog","localvar":"my","kind":13,"containerName":"_set_seq","line":977,"definition":"my"},{"line":977,"kind":13,"containerName":"_set_seq","name":"$self"},{"name":"algorithm","kind":12,"containerName":"_set_seq","line":977},{"containerName":"_set_seq","kind":13,"name":"$prog","line":978},{"line":978,"containerName":"_set_seq","kind":13,"name":"$seqType"},{"line":979,"name":"$self","containerName":"_set_seq","kind":13},{"name":"$seqType","containerName":"_set_seq","kind":13,"line":979},{"containerName":"_set_seq","kind":13,"name":"$prog","line":980},{"line":980,"containerName":"_set_seq","kind":13,"name":"$seqType"},{"line":981,"containerName":"_set_seq","kind":13,"name":"$self"},{"line":981,"name":"$seqType","kind":13,"containerName":"_set_seq"},{"line":982,"kind":13,"containerName":"_set_seq","name":"$prog"},{"name":"$self","kind":13,"containerName":"_set_seq","line":983},{"name":"$seqType","kind":13,"containerName":"_set_seq","line":983},{"line":986,"containerName":"_set_seq","kind":13,"name":"$prog"},{"line":987,"name":"$self","kind":13,"containerName":"_set_seq"},{"line":987,"name":"$seqType","containerName":"_set_seq","kind":13},{"line":987,"kind":13,"containerName":"_set_seq","name":"$prog"},{"line":988,"name":"$self","kind":13,"containerName":"_set_seq"},{"line":988,"containerName":"_set_seq","kind":13,"name":"$seqType"},{"line":988,"containerName":"_set_seq","kind":13,"name":"$prog"},{"kind":13,"containerName":"_set_seq","name":"$seqType","line":988},{"containerName":"_set_seq","kind":13,"name":"$self","line":991},{"containerName":"_set_seq","kind":13,"name":"$seqType","line":991},{"line":991,"kind":13,"containerName":"_set_seq","name":"$self"},{"line":991,"containerName":"_set_seq","kind":13,"name":"$seqType"},{"name":"$self","containerName":"_set_seq","kind":13,"line":992},{"name":"$seqType","containerName":"_set_seq","kind":13,"line":992},{"containerName":"_set_seq","kind":13,"name":"$self","line":992},{"line":992,"name":"$seqType","kind":13,"containerName":"_set_seq"},{"kind":13,"containerName":"_set_seq","name":"$self","line":993},{"line":993,"kind":13,"containerName":"_set_seq","name":"$seqType"},{"line":993,"name":"$self","containerName":"_set_seq","kind":13},{"line":993,"kind":13,"containerName":"_set_seq","name":"$seqType"},{"line":994,"kind":13,"containerName":"_set_seq","name":"$self"},{"line":994,"containerName":"_set_seq","kind":13,"name":"$seqType"},{"definition":"my","line":1000,"containerName":"_set_seq","localvar":"my","kind":13,"name":"$seqstr"},{"line":1000,"name":"@sequence","containerName":"_set_seq","kind":13},{"kind":13,"containerName":"_set_seq","name":"$seqstr","line":1001},{"definition":"my","line":1002,"name":"$num_gaps","kind":13,"localvar":"my","containerName":"_set_seq"},{"name":"$seqstr","kind":13,"containerName":"_set_seq","line":1002},{"name":"$self","kind":13,"containerName":"_set_seq","line":1002},{"line":1002,"containerName":"_set_seq","kind":13,"name":"$seqType"},{"kind":13,"containerName":"_set_seq","name":"$self","line":1003},{"line":1003,"kind":13,"containerName":"_set_seq","name":"$seqType"},{"line":1003,"containerName":"_set_seq","kind":13,"name":"$num_gaps"},{"name":"$num_gaps","containerName":"_set_seq","kind":13,"line":1003}]},{"name":"ranges","kind":12,"line":969},{"line":972,"kind":12,"name":"ranges"},{"line":1002,"name":"CORE","kind":12,"containerName":"length"},{"definition":"sub","name":"_set_residues","containerName":"main::","children":[{"definition":"my","containerName":"_set_residues","localvar":"my","kind":13,"name":"$self","line":1027},{"localvar":"my","kind":13,"containerName":"_set_residues","name":"@sequence","line":1028,"definition":"my"},{"kind":13,"containerName":"_set_residues","name":"$self","line":1030},{"line":1030,"kind":12,"containerName":"_set_residues","name":"_set_seq_data"},{"name":"$self","kind":13,"containerName":"_set_residues","line":1030},{"definition":"my","name":"%identicalList_query","kind":13,"localvar":"my","containerName":"_set_residues","line":1033},{"line":1034,"containerName":"_set_residues","localvar":"my","kind":13,"name":"%identicalList_sbjct","definition":"my"},{"name":"%conservedList_query","localvar":"my","kind":13,"containerName":"_set_residues","line":1035,"definition":"my"},{"line":1036,"name":"%conservedList_sbjct","localvar":"my","containerName":"_set_residues","kind":13,"definition":"my"},{"definition":"my","line":1038,"name":"$aref","localvar":"my","containerName":"_set_residues","kind":13},{"containerName":"_set_residues","kind":13,"name":"$self","line":1038},{"containerName":"_set_residues","kind":12,"name":"_set_match_seq","line":1038},{"line":1038,"kind":13,"containerName":"_set_residues","name":"$self"},{"line":1039,"kind":13,"containerName":"_set_residues","name":"$aref"},{"line":1039,"name":"$self","kind":13,"containerName":"_set_residues"},{"definition":"my","name":"$seqString","localvar":"my","kind":13,"containerName":"_set_residues","line":1040},{"line":1040,"kind":13,"containerName":"_set_residues","name":"$aref"},{"definition":"my","containerName":"_set_residues","localvar":"my","kind":13,"name":"$qseq","line":1042},{"kind":13,"containerName":"_set_residues","name":"$self","line":1042}],"range":{"start":{"character":0,"line":1025},"end":{"line":1042,"character":9999}},"kind":12,"line":1025},{"definition":"my","line":1043,"localvar":"my","kind":13,"containerName":null,"name":"$sseq"},{"line":1043,"containerName":null,"kind":13,"name":"%self"},{"name":"$resCount_query","localvar":"my","kind":13,"containerName":null,"line":1044,"definition":"my"},{"line":1044,"containerName":null,"kind":13,"name":"%self"},{"line":1045,"name":"$resCount_sbjct","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"containerName":null,"kind":13,"name":"%self","line":1045},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$prog","line":1047},{"name":"$self","containerName":null,"kind":13,"line":1047},{"line":1047,"name":"algorithm","containerName":"main::","kind":12},{"line":1048,"kind":13,"containerName":null,"name":"%prog"},{"name":"%prog","kind":13,"containerName":null,"line":1049},{"line":1050,"name":"$resCount_sbjct","kind":13,"containerName":null},{"line":1051,"kind":13,"containerName":null,"name":"%prog"},{"line":1052,"name":"$resCount_query","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%prog","line":1053},{"line":1054,"name":"$resCount_query","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$resCount_sbjct","line":1055},{"containerName":null,"localvar":"my","kind":13,"name":"$mchar","line":1059,"definition":"my"},{"line":1059,"kind":13,"containerName":null,"name":"$schar"},{"line":1059,"kind":13,"containerName":null,"name":"$qchar"},{"line":1060,"name":"$mchar","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%seqString","line":1060},{"name":"$qchar","containerName":null,"kind":13,"line":1061},{"line":1061,"kind":13,"containerName":null,"name":"$schar"},{"line":1061,"name":"$qseq","containerName":null,"kind":13},{"line":1061,"name":"$sseq","containerName":null,"kind":13},{"name":"%mchar","containerName":null,"kind":13,"line":1062},{"containerName":null,"kind":13,"name":"%conservedList_query","line":1063},{"line":1063,"kind":13,"containerName":null,"name":"$resCount_query"},{"kind":13,"containerName":null,"name":"%conservedList_sbjct","line":1064},{"line":1064,"containerName":null,"kind":13,"name":"$resCount_sbjct"},{"line":1065,"name":"%mchar","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%identicalList_query","line":1066},{"name":"$resCount_query","kind":13,"containerName":null,"line":1066},{"containerName":null,"kind":13,"name":"%identicalList_sbjct","line":1067},{"kind":13,"containerName":null,"name":"$resCount_sbjct","line":1067},{"kind":13,"containerName":null,"name":"$resCount_query","line":1069},{"containerName":null,"kind":13,"name":"$qchar","line":1069},{"line":1069,"name":"$GAP_SYMBOL","containerName":null,"kind":13},{"name":"$resCount_sbjct","containerName":null,"kind":13,"line":1070},{"name":"$schar","kind":13,"containerName":null,"line":1070},{"kind":13,"containerName":null,"name":"$GAP_SYMBOL","line":1070},{"line":1072,"kind":13,"containerName":null,"name":"%self"},{"name":"%identicalList_query","containerName":null,"kind":13,"line":1072},{"line":1073,"name":"%self","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%conservedList_query","line":1073},{"line":1074,"name":"%self","kind":13,"containerName":null},{"line":1074,"kind":13,"containerName":null,"name":"%identicalList_sbjct"},{"containerName":null,"kind":13,"name":"%self","line":1075},{"name":"%conservedList_sbjct","containerName":null,"kind":13,"line":1075},{"children":[{"definition":"my","line":1101,"name":"$self","containerName":"_set_match_seq","localvar":"my","kind":13},{"line":1103,"name":"$self","containerName":"_set_match_seq","kind":13},{"line":1104,"kind":13,"localvar":"my","containerName":"_set_match_seq","name":"$id_str","definition":"my"},{"name":"$self","kind":13,"containerName":"_set_match_seq","line":1104},{"name":"_id_str","kind":12,"containerName":"_set_match_seq","line":1104},{"name":"$self","kind":13,"containerName":"_set_match_seq","line":1105},{"name":"throw","containerName":"_set_match_seq","kind":12,"line":1105},{"definition":"my","line":1108,"name":"@data","containerName":"_set_match_seq","localvar":"my","kind":13},{"name":"$self","containerName":"_set_match_seq","kind":13,"line":1108}],"name":"_set_match_seq","containerName":"main::","definition":"sub","line":1099,"range":{"end":{"line":1108,"character":9999},"start":{"character":0,"line":1099}},"kind":12},{"localvar":"my","containerName":null,"kind":13,"name":"@sequence","line":1110,"definition":"my"},{"line":1111,"name":"@data","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@sequence","line":1116},{"line":1119,"name":"%self","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":1120},{"name":"%self","kind":13,"containerName":null,"line":1122},{"name":"@sequence","kind":13,"containerName":null,"line":1122},{"line":1124,"kind":13,"containerName":null,"name":"%self"},{"children":[{"definition":"my","line":1147,"name":"$self","kind":13,"localvar":"my","containerName":"n"},{"containerName":"n","kind":13,"name":"$self","line":1147}],"containerName":"main::","name":"n","definition":"sub","line":1147,"kind":12,"range":{"start":{"line":1147,"character":0},"end":{"character":9999,"line":1147}}},{"detail":"($self,%param)","definition":"sub","containerName":"main::","name":"matches","children":[{"containerName":"matches","localvar":"my","kind":13,"name":"$self","line":1178,"definition":"my"},{"name":"%param","containerName":"matches","kind":13,"line":1178},{"definition":"my","line":1179,"localvar":"my","kind":13,"containerName":"matches","name":"@data"},{"name":"$seqType","kind":13,"localvar":"my","containerName":"matches","line":1180,"definition":"my"},{"line":1180,"name":"$beg","containerName":"matches","kind":13},{"name":"$end","containerName":"matches","kind":13,"line":1180},{"line":1180,"kind":13,"containerName":"matches","name":"$param"},{"kind":13,"containerName":"matches","name":"$param","line":1180},{"kind":13,"containerName":"matches","name":"$param","line":1180},{"kind":13,"containerName":"matches","name":"$seqType","line":1181},{"containerName":"matches","kind":13,"name":"$seqType","line":1182},{"kind":13,"containerName":"matches","name":"$seqType","line":1182},{"line":1184,"kind":13,"localvar":"my","containerName":"matches","name":"$start","definition":"my"},{"line":1184,"name":"$stop","containerName":"matches","kind":13},{"line":1186,"kind":13,"containerName":"matches","name":"$beg"},{"name":"$end","containerName":"matches","kind":13,"line":1186},{"line":1188,"containerName":"matches","kind":13,"name":"@data"},{"line":1188,"name":"$self","containerName":"matches","kind":13},{"line":1188,"kind":13,"containerName":"matches","name":"$self"},{"name":"$beg","kind":13,"containerName":"matches","line":1191},{"kind":13,"containerName":"matches","name":"$end","line":1192},{"name":"$start","kind":13,"containerName":"matches","line":1193},{"kind":13,"containerName":"matches","name":"$stop","line":1193},{"line":1193,"containerName":"matches","kind":13,"name":"$self"},{"line":1193,"containerName":"matches","kind":12,"name":"range"},{"line":1193,"containerName":"matches","kind":13,"name":"$seqType"},{"line":1194,"name":"$beg","kind":13,"containerName":"matches"},{"kind":13,"containerName":"matches","name":"$beg","line":1194},{"line":1194,"kind":13,"containerName":"matches","name":"$start"},{"name":"$end","kind":13,"containerName":"matches","line":1194},{"line":1194,"containerName":"matches","kind":13,"name":"$beg"},{"line":1194,"name":"$end","containerName":"matches","kind":13},{"line":1195,"name":"$end","containerName":"matches","kind":13},{"line":1195,"name":"$end","kind":13,"containerName":"matches"},{"line":1195,"name":"$stop","containerName":"matches","kind":13},{"kind":13,"containerName":"matches","name":"$beg","line":1195},{"line":1195,"name":"$end","kind":13,"containerName":"matches"},{"containerName":"matches","kind":13,"name":"$beg","line":1195},{"name":"$end","kind":13,"containerName":"matches","line":1197},{"line":1197,"kind":13,"containerName":"matches","name":"$stop"},{"name":"$end","kind":13,"containerName":"matches","line":1197},{"kind":13,"containerName":"matches","name":"$stop","line":1197},{"line":1198,"name":"$end","kind":13,"containerName":"matches"},{"kind":13,"containerName":"matches","name":"$beg","line":1201},{"line":1201,"containerName":"matches","kind":13,"name":"$start"},{"containerName":"matches","kind":13,"name":"$beg","line":1201},{"name":"$start","kind":13,"containerName":"matches","line":1201},{"line":1207,"name":"$seq","kind":13,"localvar":"my","containerName":"matches","definition":"my"},{"line":1208,"name":"$prog","kind":13,"localvar":"my","containerName":"matches","definition":"my"},{"line":1208,"name":"$self","kind":13,"containerName":"matches"},{"name":"algorithm","containerName":"matches","kind":12,"line":1208},{"name":"$prog","kind":13,"containerName":"matches","line":1209},{"line":1209,"name":"$seqType","containerName":"matches","kind":13},{"line":1211,"containerName":"matches","kind":13,"name":"$seq"},{"kind":13,"containerName":"matches","name":"$self","line":1211},{"name":"seq_str","kind":12,"containerName":"matches","line":1211},{"name":"$beg","containerName":"matches","kind":13,"line":1212},{"kind":13,"containerName":"matches","name":"$start","line":1212},{"line":1212,"kind":13,"containerName":"matches","name":"$end"},{"line":1212,"name":"$beg","containerName":"matches","kind":13},{"line":1214,"name":"$prog","kind":13,"containerName":"matches"},{"line":1214,"name":"$seqType","kind":13,"containerName":"matches"},{"name":"$seq","containerName":"matches","kind":13,"line":1216},{"line":1216,"kind":13,"containerName":"matches","name":"$self"},{"line":1216,"name":"seq_str","kind":12,"containerName":"matches"},{"line":1217,"containerName":"matches","kind":13,"name":"$beg"},{"line":1217,"name":"$start","containerName":"matches","kind":13},{"line":1217,"name":"$end","kind":13,"containerName":"matches"},{"name":"$beg","kind":13,"containerName":"matches","line":1217},{"name":"$seq","kind":13,"containerName":"matches","line":1219},{"name":"$self","kind":13,"containerName":"matches","line":1219},{"name":"seq_str","containerName":"matches","kind":12,"line":1219},{"line":1220,"kind":13,"containerName":"matches","name":"$beg"},{"kind":13,"containerName":"matches","name":"$start","line":1220},{"line":1220,"kind":13,"containerName":"matches","name":"$end"},{"name":"$beg","containerName":"matches","kind":13,"line":1220},{"line":1238,"name":"$seq","kind":13,"containerName":"matches"},{"line":1239,"name":"$id_str","localvar":"my","containerName":"matches","kind":13,"definition":"my"},{"line":1239,"name":"$self","kind":13,"containerName":"matches"},{"kind":12,"containerName":"matches","name":"_id_str","line":1239},{"line":1240,"kind":13,"containerName":"matches","name":"$self"},{"name":"throw","kind":12,"containerName":"matches","line":1240},{"kind":13,"containerName":"matches","name":"$seq","line":1245},{"definition":"my","localvar":"my","containerName":"matches","kind":13,"name":"$len_cons","line":1246},{"name":"$seq","containerName":"matches","kind":13,"line":1246},{"kind":13,"containerName":"matches","name":"$seq","line":1247},{"name":"$len_id","kind":13,"localvar":"my","containerName":"matches","line":1248,"definition":"my"},{"containerName":"matches","kind":13,"name":"$seq","line":1248},{"line":1249,"containerName":"matches","kind":13,"name":"@data"},{"line":1249,"kind":13,"containerName":"matches","name":"$len_id"},{"containerName":"matches","kind":13,"name":"$len_cons","line":1249},{"name":"@data","kind":13,"containerName":"matches","line":1252}],"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>","parameters":[{"label":"$self"},{"label":"%param"}],"label":"matches($self,%param)"},"kind":12,"range":{"end":{"line":1253,"character":9999},"start":{"character":0,"line":1176}},"line":1176},{"name":"CORE","containerName":"length","kind":12,"line":1238},{"name":"CORE","kind":12,"containerName":"length","line":1247},{"name":"CORE","containerName":"length","kind":12,"line":1249},{"kind":12,"range":{"end":{"character":9999,"line":1275},"start":{"line":1270,"character":0}},"line":1270,"containerName":"main::","name":"num_identical","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"num_identical","line":1272,"definition":"my"},{"kind":13,"containerName":"num_identical","name":"$self","line":1274}],"definition":"sub"},{"definition":"sub","containerName":"main::","name":"num_conserved","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"num_conserved","name":"$self","line":1294},{"line":1296,"kind":13,"containerName":"num_conserved","name":"$self"}],"range":{"end":{"character":9999,"line":1297},"start":{"character":0,"line":1292}},"kind":12,"line":1292},{"children":[{"definition":"my","line":1320,"name":"$self","localvar":"my","containerName":"range","kind":13},{"line":1320,"kind":13,"containerName":"range","name":"$seqType"},{"line":1322,"containerName":"range","kind":13,"name":"$self"},{"line":1322,"kind":12,"containerName":"range","name":"_set_seq_data"},{"line":1322,"name":"$self","kind":13,"containerName":"range"},{"name":"$seqType","containerName":"range","kind":13,"line":1324},{"line":1325,"name":"$seqType","kind":13,"containerName":"range"},{"name":"$seqType","kind":13,"containerName":"range","line":1325},{"line":1328,"name":"$seqType","containerName":"range","kind":13},{"line":1330,"containerName":"range","kind":13,"name":"$self"},{"line":1330,"name":"$seqType","kind":13,"containerName":"range"},{"line":1330,"name":"$self","kind":13,"containerName":"range"},{"line":1330,"name":"$seqType","kind":13,"containerName":"range"}],"containerName":"main::","name":"range","definition":"sub","detail":"($self,$seqType)","line":1318,"range":{"start":{"line":1318,"character":0},"end":{"line":1331,"character":9999}},"kind":12,"signature":{"label":"range($self,$seqType)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>","parameters":[{"label":"$self"},{"label":"$seqType"}]}},{"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    return ($self->{$seqType.'Start'},$self->{$seqType.'Stop'});\n}\n\n=head2 start\n\n Usage     : $hsp->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_beg = $hsp->start('query');\n           : $hit_beg = $hsp->start('hit');\n           : ($query_beg, $hit_beg) = $hsp->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</end>, L</range>","label":"start($self,$seqType)"},"range":{"start":{"character":0,"line":1355},"end":{"character":9999,"line":1371}},"kind":12,"line":1355,"detail":"($self,$seqType)","definition":"sub","name":"start","containerName":"main::","children":[{"definition":"my","line":1357,"name":"$self","containerName":"start","localvar":"my","kind":13},{"containerName":"start","kind":13,"name":"$seqType","line":1357},{"containerName":"start","kind":13,"name":"$seqType","line":1359},{"line":1360,"name":"$seqType","kind":13,"containerName":"start"},{"containerName":"start","kind":13,"name":"$seqType","line":1360},{"kind":13,"containerName":"start","name":"$self","line":1362},{"line":1362,"containerName":"start","kind":12,"name":"_set_seq_data"},{"kind":13,"containerName":"start","name":"$self","line":1362},{"name":"$seqType","containerName":"start","kind":13,"line":1364},{"name":"$self","kind":13,"containerName":"start","line":1365},{"line":1365,"name":"$self","kind":13,"containerName":"start"},{"line":1368,"name":"$seqType","containerName":"start","kind":13},{"line":1369,"name":"$self","kind":13,"containerName":"start"},{"line":1369,"name":"$seqType","kind":13,"containerName":"start"}]},{"containerName":"main::","name":"end","children":[{"definition":"my","line":1397,"kind":13,"localvar":"my","containerName":"end","name":"$self"},{"containerName":"end","kind":13,"name":"$seqType","line":1397},{"line":1399,"containerName":"end","kind":13,"name":"$seqType"},{"line":1400,"containerName":"end","kind":13,"name":"$seqType"},{"name":"$seqType","kind":13,"containerName":"end","line":1400},{"line":1402,"name":"$self","containerName":"end","kind":13},{"line":1402,"name":"_set_seq_data","kind":12,"containerName":"end"},{"name":"$self","containerName":"end","kind":13,"line":1402},{"line":1404,"name":"$seqType","kind":13,"containerName":"end"},{"line":1405,"containerName":"end","kind":13,"name":"$self"},{"line":1405,"kind":13,"containerName":"end","name":"$self"},{"line":1408,"containerName":"end","kind":13,"name":"$seqType"},{"containerName":"end","kind":13,"name":"$self","line":1409},{"line":1409,"name":"$seqType","containerName":"end","kind":13}],"detail":"($self,$seqType)","definition":"sub","range":{"start":{"character":0,"line":1395},"end":{"character":9999,"line":1411}},"kind":12,"line":1395,"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    return ($self->{$seqType.'Start'},$self->{$seqType.'Stop'});\n}\n\n=head2 start\n\n Usage     : $hsp->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_beg = $hsp->start('query');\n           : $hit_beg = $hsp->start('hit');\n           : ($query_beg, $hit_beg) = $hsp->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</end>, L</range>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'};\n    }\n}\n\n=head2 end\n\n Usage     : $hsp->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_end = $hsp->end('query');\n           : $hit_end = $hsp->end('hit');\n           : ($query_end, $hit_end) = $hsp->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</start>, L</range>, L</strand>","label":"end($self,$seqType)"}},{"signature":{"label":"strand($self,$seqType)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    return ($self->{$seqType.'Start'},$self->{$seqType.'Stop'});\n}\n\n=head2 start\n\n Usage     : $hsp->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_beg = $hsp->start('query');\n           : $hit_beg = $hsp->start('hit');\n           : ($query_beg, $hit_beg) = $hsp->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</end>, L</range>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'};\n    }\n}\n\n=head2 end\n\n Usage     : $hsp->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_end = $hsp->end('query');\n           : $hit_end = $hsp->end('hit');\n           : ($query_end, $hit_end) = $hsp->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</start>, L</range>, L</strand>\n\n\n#----------\nsub end {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'};\n    }\n}\n\n\n\n=head2 strand\n\n Usage     : $hsp_object->strand( [seq_type] )\n Purpose   : Get the strand of the query or sbjct sequence.\n Example   : print $hsp->strand('query');\n           : ($query_strand, $hit_strand) = $hsp->strand();\n Returns   : -1, 0, or 1\n           : -1 = Minus strand, +1 = Plus strand\n           : Returns 0 if strand is not defined, which occurs\n           : for BLASTP reports, and the query of TBLASTN\n           : as well as the hit if BLASTX reports.\n           : In scalar context without arguments, returns queryStrand value.\n           : In array context without arguments, returns a two-element list\n           :    of strings (queryStrand, sbjctStrand).\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or undef\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</_set_seq>, L</_set_match_stats>","parameters":[{"label":"$self"},{"label":"$seqType"}]},"range":{"start":{"character":0,"line":1439},"end":{"character":9999,"line":1478}},"kind":12,"line":1439,"detail":"($self,$seqType)","definition":"sub","name":"strand","containerName":"main::","children":[{"definition":"my","containerName":"strand","localvar":"my","kind":13,"name":"$self","line":1441},{"containerName":"strand","kind":13,"name":"$seqType","line":1441},{"line":1443,"containerName":"strand","kind":13,"name":"$seqType"},{"line":1444,"name":"$seqType","containerName":"strand","kind":13},{"kind":13,"containerName":"strand","name":"$seqType","line":1444},{"containerName":"strand","kind":13,"name":"$seqType","line":1447},{"line":1450,"kind":13,"containerName":"strand","name":"$self"},{"line":1450,"name":"$self","kind":13,"containerName":"strand"},{"name":"_set_seq_data","kind":12,"containerName":"strand","line":1450},{"kind":13,"containerName":"strand","name":"$self","line":1450},{"definition":"my","line":1452,"name":"$prog","localvar":"my","kind":13,"containerName":"strand"},{"name":"$self","containerName":"strand","kind":13,"line":1452},{"containerName":"strand","kind":12,"name":"algorithm","line":1452},{"kind":13,"containerName":"strand","name":"$seqType","line":1454},{"kind":13,"localvar":"my","containerName":"strand","name":"$qstr","line":1455,"definition":"my"},{"name":"$hstr","containerName":"strand","kind":13,"line":1455},{"kind":13,"containerName":"strand","name":"$prog","line":1456},{"containerName":"strand","kind":13,"name":"$qstr","line":1457},{"line":1458,"kind":13,"containerName":"strand","name":"$hstr"},{"name":"$prog","containerName":"strand","kind":13,"line":1460},{"name":"$qstr","containerName":"strand","kind":13,"line":1461},{"line":1462,"name":"$hstr","containerName":"strand","kind":13},{"line":1462,"name":"$STRAND_SYMBOL","kind":13,"containerName":"strand"},{"line":1462,"name":"$self","containerName":"strand","kind":13},{"line":1464,"kind":13,"containerName":"strand","name":"$prog"},{"line":1465,"name":"$qstr","containerName":"strand","kind":13},{"line":1465,"kind":13,"containerName":"strand","name":"$STRAND_SYMBOL"},{"kind":13,"containerName":"strand","name":"$self","line":1465},{"line":1466,"name":"$hstr","kind":13,"containerName":"strand"},{"line":1469,"name":"$qstr","containerName":"strand","kind":13},{"kind":13,"containerName":"strand","name":"$STRAND_SYMBOL","line":1469},{"line":1469,"name":"$self","containerName":"strand","kind":13},{"containerName":"strand","kind":13,"name":"$self","line":1469},{"line":1470,"name":"$hstr","kind":13,"containerName":"strand"},{"name":"$STRAND_SYMBOL","containerName":"strand","kind":13,"line":1470},{"kind":13,"containerName":"strand","name":"$self","line":1470},{"name":"$self","kind":13,"containerName":"strand","line":1470},{"line":1472,"name":"$qstr","kind":13,"containerName":"strand"},{"line":1473,"kind":13,"containerName":"strand","name":"$hstr"},{"line":1474,"name":"$qstr","containerName":"strand","kind":13},{"line":1474,"name":"$hstr","kind":13,"containerName":"strand"},{"line":1477,"containerName":"strand","kind":13,"name":"$STRAND_SYMBOL"},{"name":"$self","containerName":"strand","kind":13,"line":1477},{"kind":13,"containerName":"strand","name":"$seqType","line":1477}]},{"definition":"sub","detail":"($self,$seqType)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"seq","line":1502},{"line":1502,"containerName":"seq","kind":13,"name":"$seqType"},{"line":1503,"containerName":"seq","kind":13,"name":"$seqType"},{"line":1504,"containerName":"seq","kind":13,"name":"$seqType"},{"kind":13,"containerName":"seq","name":"$seqType","line":1504},{"line":1505,"name":"$str","localvar":"my","containerName":"seq","kind":13,"definition":"my"},{"name":"$self","containerName":"seq","kind":13,"line":1505},{"line":1505,"containerName":"seq","kind":12,"name":"seq_str"},{"line":1505,"name":"$seqType","containerName":"seq","kind":13},{"line":1509,"kind":12,"containerName":"seq","name":"new"},{"name":"$self","kind":13,"containerName":"seq","line":1509},{"line":1509,"containerName":"seq","kind":12,"name":"to_string"},{"line":1510,"containerName":"seq","kind":13,"name":"$str"}],"name":"seq","containerName":"main::","signature":{"label":"seq($self,$seqType)","parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    return ($self->{$seqType.'Start'},$self->{$seqType.'Stop'});\n}\n\n=head2 start\n\n Usage     : $hsp->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_beg = $hsp->start('query');\n           : $hit_beg = $hsp->start('hit');\n           : ($query_beg, $hit_beg) = $hsp->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</end>, L</range>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'};\n    }\n}\n\n=head2 end\n\n Usage     : $hsp->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_end = $hsp->end('query');\n           : $hit_end = $hsp->end('hit');\n           : ($query_end, $hit_end) = $hsp->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</start>, L</range>, L</strand>\n\n\n#----------\nsub end {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'};\n    }\n}\n\n\n\n=head2 strand\n\n Usage     : $hsp_object->strand( [seq_type] )\n Purpose   : Get the strand of the query or sbjct sequence.\n Example   : print $hsp->strand('query');\n           : ($query_strand, $hit_strand) = $hsp->strand();\n Returns   : -1, 0, or 1\n           : -1 = Minus strand, +1 = Plus strand\n           : Returns 0 if strand is not defined, which occurs\n           : for BLASTP reports, and the query of TBLASTN\n           : as well as the hit if BLASTX reports.\n           : In scalar context without arguments, returns queryStrand value.\n           : In array context without arguments, returns a two-element list\n           :    of strings (queryStrand, sbjctStrand).\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or undef\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</_set_seq>, L</_set_match_stats>\n\n\n#-----------\nsub strand {\n#-----------\n    my( $self, $seqType ) = @_;\n\n    $seqType  ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    # $seqType could be '_list'.\n    $self->{'_queryStrand'} or $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    my $prog = $self->algorithm;\n\n    if($seqType  =~ /list|array/i) {\n        my ($qstr, $hstr);\n        if( $prog eq 'BLASTP') {\n            $qstr = 0;\n            $hstr = 0;\n        }\n        elsif( $prog eq 'TBLASTN') {\n            $qstr = 0;\n            $hstr = $STRAND_SYMBOL{$self->{'_sbjctStrand'}};\n        }\n        elsif( $prog eq 'BLASTX') {\n            $qstr = $STRAND_SYMBOL{$self->{'_queryStrand'}};\n            $hstr = 0;\n        }\n        else {\n            $qstr = $STRAND_SYMBOL{$self->{'_queryStrand'}} if defined $self->{'_queryStrand'};\n            $hstr = $STRAND_SYMBOL{$self->{'_sbjctStrand'}} if defined $self->{'_sbjctStrand'};\n        }\n        $qstr ||= 0;\n        $hstr ||= 0;\n        return ($qstr, $hstr);\n    }\n    local $^W = 0;\n    $STRAND_SYMBOL{$self->{$seqType.'Strand'}} || 0;\n}\n\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L</seq_str>, L</seq_inds>, L<Bio::Seq>"},"line":1500,"range":{"start":{"character":0,"line":1500},"end":{"line":1513,"character":9999}},"kind":12},{"containerName":"Seq::Bio::Seq","kind":12,"name":"Bio","line":1509},{"signature":{"parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    return ($self->{$seqType.'Start'},$self->{$seqType.'Stop'});\n}\n\n=head2 start\n\n Usage     : $hsp->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_beg = $hsp->start('query');\n           : $hit_beg = $hsp->start('hit');\n           : ($query_beg, $hit_beg) = $hsp->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</end>, L</range>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'};\n    }\n}\n\n=head2 end\n\n Usage     : $hsp->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_end = $hsp->end('query');\n           : $hit_end = $hsp->end('hit');\n           : ($query_end, $hit_end) = $hsp->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</start>, L</range>, L</strand>\n\n\n#----------\nsub end {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'};\n    }\n}\n\n\n\n=head2 strand\n\n Usage     : $hsp_object->strand( [seq_type] )\n Purpose   : Get the strand of the query or sbjct sequence.\n Example   : print $hsp->strand('query');\n           : ($query_strand, $hit_strand) = $hsp->strand();\n Returns   : -1, 0, or 1\n           : -1 = Minus strand, +1 = Plus strand\n           : Returns 0 if strand is not defined, which occurs\n           : for BLASTP reports, and the query of TBLASTN\n           : as well as the hit if BLASTX reports.\n           : In scalar context without arguments, returns queryStrand value.\n           : In array context without arguments, returns a two-element list\n           :    of strings (queryStrand, sbjctStrand).\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or undef\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</_set_seq>, L</_set_match_stats>\n\n\n#-----------\nsub strand {\n#-----------\n    my( $self, $seqType ) = @_;\n\n    $seqType  ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    # $seqType could be '_list'.\n    $self->{'_queryStrand'} or $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    my $prog = $self->algorithm;\n\n    if($seqType  =~ /list|array/i) {\n        my ($qstr, $hstr);\n        if( $prog eq 'BLASTP') {\n            $qstr = 0;\n            $hstr = 0;\n        }\n        elsif( $prog eq 'TBLASTN') {\n            $qstr = 0;\n            $hstr = $STRAND_SYMBOL{$self->{'_sbjctStrand'}};\n        }\n        elsif( $prog eq 'BLASTX') {\n            $qstr = $STRAND_SYMBOL{$self->{'_queryStrand'}};\n            $hstr = 0;\n        }\n        else {\n            $qstr = $STRAND_SYMBOL{$self->{'_queryStrand'}} if defined $self->{'_queryStrand'};\n            $hstr = $STRAND_SYMBOL{$self->{'_sbjctStrand'}} if defined $self->{'_sbjctStrand'};\n        }\n        $qstr ||= 0;\n        $hstr ||= 0;\n        return ($qstr, $hstr);\n    }\n    local $^W = 0;\n    $STRAND_SYMBOL{$self->{$seqType.'Strand'}} || 0;\n}\n\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L</seq_str>, L</seq_inds>, L<Bio::Seq>\n\n\n#-------\nsub seq {\n#-------\n    my($self,$seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    my $str = $self->seq_str($seqType);\n\n    require Bio::Seq;\n\n    Bio::Seq->new(-ID   => $self->to_string,\n                  -SEQ  => $str,\n                  -DESC => \"$seqType sequence\",\n                  );\n}\n\n=head2 seq_str\n\n Usage     : $hsp->seq_str( seq_type );\n Purpose   : Get the full query, sbjct, or 'match' sequence as a string.\n           : The 'match' sequence is the string of symbols in between the\n           : query and sbjct sequences.\n Example   : $str = $hsp->seq_str('query');\n Returns   : String\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' or 'match'\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument does not match an accepted seq_type.\n Comments  : Calls _set_seq_data() to set the 'match' sequence if it has\n           : not been set already.\n\nSee Also   : L</seq>, L</seq_inds>, L</_set_match_seq>","label":"seq_str($self,$seqType)"},"range":{"end":{"line":1550,"character":9999},"start":{"line":1534,"character":0}},"kind":12,"line":1534,"detail":"($self,$seqType)","definition":"sub","containerName":"main::","name":"seq_str","children":[{"line":1536,"kind":13,"localvar":"my","containerName":"seq_str","name":"$self","definition":"my"},{"kind":13,"containerName":"seq_str","name":"$seqType","line":1536},{"line":1538,"containerName":"seq_str","kind":13,"name":"$seqType"},{"line":1539,"name":"$seqType","kind":13,"containerName":"seq_str"},{"line":1539,"kind":13,"containerName":"seq_str","name":"$seqType"},{"line":1541,"kind":13,"containerName":"seq_str","name":"$seqType"},{"name":"$self","containerName":"seq_str","kind":13,"line":1543},{"line":1543,"name":"_set_seq_data","kind":12,"containerName":"seq_str"},{"line":1543,"name":"$self","kind":13,"containerName":"seq_str"},{"line":1545,"name":"$seqType","kind":13,"containerName":"seq_str"},{"name":"$seq","localvar":"my","containerName":"seq_str","kind":13,"line":1546,"definition":"my"},{"kind":13,"containerName":"seq_str","name":"$self","line":1546},{"line":1546,"name":"$seqType","containerName":"seq_str","kind":13},{"containerName":"seq_str","kind":13,"name":"$seq","line":1547},{"line":1548,"name":"$seq","containerName":"seq_str","kind":13}]},{"kind":13,"containerName":null,"name":"%seqType","line":1550},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$aref","line":1552},{"line":1552,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"_set_match_seq","line":1552},{"name":"%self","containerName":null,"kind":13,"line":1552},{"line":1553,"name":"$aref","containerName":null,"kind":13},{"line":1553,"name":"%self","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%aref","line":1555},{"line":1558,"name":"$id_str","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"containerName":null,"kind":13,"name":"$self","line":1558},{"name":"_id_str","containerName":"main::","kind":12,"line":1558},{"line":1559,"containerName":null,"kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"main::","line":1559},{"line":1562,"name":"$seqType","kind":13,"containerName":null},{"line":1594,"range":{"start":{"character":0,"line":1594},"end":{"character":9999,"line":1612}},"kind":12,"signature":{"label":"seq_inds($self,$seqType,$class,$collapse)","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$class"},{"label":"$collapse"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: PsiBlastHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::HSP::PsiBlastHSP\n#\n# (This module was originally called Bio::Tools::Blast::HSP)\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Search::HSP::PsiBlastHSP - Bioperl BLAST High-Scoring Pair object\n\n=head1 SYNOPSIS\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nA Bio::Search::HSP::PsiBlastHSP object provides an interface to data\nobtained in a single alignment section of a Blast report (known as a\n\"High-scoring Segment Pair\"). This is essentially a pairwise\nalignment with score information.\n\nPsiBlastHSP objects are accessed via L<Bio::Search::Hit::BlastHit>\nobjects after parsing a BLAST report using the L<Bio::SearchIO>\nsystem.\n\nThe construction of PsiBlastHSP objects is performed by\nBio::Factory::BlastHitFactory in a process that is\norchestrated by the Blast parser (L<Bio::SearchIO::psiblast>).\nThe resulting PsiBlastHSPs are then accessed via\nL<Bio::Search::Hit::BlastHit>). Therefore, you do not need to\nuse L<Bio::Search::HSP::PsiBlastHSP>) directly. If you need to construct\nPsiBlastHSPs directly, see the new() function for details.\n\nFor L<Bio::SearchIO> BLAST parsing usage examples, see the\nC<examples/search-blast> directory of the Bioperl distribution.\n\n\n=head2 Start and End coordinates\n\nSequence endpoints are swapped so that start is always less than\nend. This affects For TBLASTN/X hits on the minus strand. Strand\ninformation can be recovered using the strand() method. This\nnormalization step is standard Bioperl practice. It also facilitates\nuse of range information by methods such as match().\n\n=over 1\n\n* * Supports BLAST versions 1.x and 2.x, gapped and ungapped.\n\n\nBio::Search::HSP::PsiBlastHSP.pm has the ability to extract a list of all\nresidue indices for identical and conservative matches along both\nquery and sbjct sequences. Since this degree of detail is not always\nneeded, this behavior does not occur during construction of the PsiBlastHSP\nobject.  These data will automatically be collected as necessary as\nthe PsiBlastHSP.pm object is used.\n\n=head1 DEPENDENCIES\n\nBio::Search::HSP::PsiBlastHSP.pm is a concrete class that inherits from\nL<Bio::SeqFeature::SimilarityPair> and L<Bio::Search::HSP::HSPI>.\nL<Bio::Seq> and L<Bio::SimpleAlign> are employed for creating\nsequence and alignment objects, respectively.\n\n=head2 Relationship to L<Bio::SimpleAlign> and L<Bio::Seq>\n\nPsiBlastHSP.pm can provide the query or sbjct sequence as a L<Bio::Seq>\nobject via the L<seq()|seq> method. The PsiBlastHSP.pm object can also create a\ntwo-sequence L<Bio::SimpleAlign> alignment object using the the query\nand sbjct sequences via the L<get_aln()|get_aln> method. Creation of alignment\nobjects is not automatic when constructing the PsiBlastHSP.pm object since\nthis level of functionality is not always required and would generate\na lot of extra overhead when crunching many reports.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports and comments.\n\n=head1 ACKNOWLEDGEMENTS\n\nThis software was originally developed in the Department of Genetics\nat Stanford University. I would also like to acknowledge my\ncolleagues at Affymetrix for useful feedback.\n\n=head1 SEE ALSO\n\n Bio::Search::Hit::BlastHit.pm          - Blast hit object.\n Bio::Search::Result::BlastResult.pm    - Blast Result object.\n Bio::Seq.pm                            - Biosequence object\n\n=head2 Links:\n\n http://bio.perl.org/                       - Bioperl Project Homepage\n\n=head1 COPYRIGHT\n\nCopyright (c) 1996-2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n\n\n# END of main POD documentation.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PsiBlastHSP;\n\nuse strict;\nuse Bio::SeqFeature::Similarity;\n\nuse vars qw($GAP_SYMBOL %STRAND_SYMBOL);\n\nuse overload\n    '\"\"' => \\&to_string;\n\nuse base qw(Bio::SeqFeature::SimilarityPair Bio::Search::HSP::HSPI);\n\n$GAP_SYMBOL    = '-';          # Need a more general way to handle gap symbols.\n%STRAND_SYMBOL = ('Plus' => 1, 'Minus' => -1 );\n\n\n=head2 new\n\n Usage     : $hsp = Bio::Search::HSP::PsiBlastHSP->new( %named_params );\n           : Bio::Search::HSP::PsiBlastHSP.pm objects are constructed\n           : automatically by Bio::SearchIO::BlastHitFactory.pm,\n           : so there is no need for direct instantiation.\n Purpose   : Constructs a new PsiBlastHSP object and Initializes key variables\n           : for the HSP.\n Returns   : A Bio::Search::HSP::PsiBlastHSP object\n Argument  : Named parameters:\n           : Parameter keys are case-insensitive.\n           :      -RAW_DATA  => array ref containing raw BLAST report data for\n           :                    for a single HSP. This includes all lines\n           :                    of the HSP alignment from a traditional BLAST\n                                or PSI-BLAST (non-XML) report,\n           :      -RANK         => integer (1..n).\n           :      -PROGRAM      => string ('TBLASTN', 'BLASTP', etc.).\n           :      -QUERY_NAME   => string, id of query sequence\n           :      -HIT_NAME     => string, id of hit sequence\n           :\n Comments  : Having the raw data allows this object to do lazy parsing of\n           : the raw HSP data (i.e., not parsed until needed).\n           :\n           : Note that there is a fair amount of basic parsing that is\n           : currently performed in this module that would be more appropriate\n           : to do within a separate factory object.\n           : This parsing code will likely be relocated and more initialization\n           : parameters will be added to new().\n           :\nSee Also   : L<Bio::SeqFeature::SimilarityPair::new()>, L<Bio::SeqFeature::Similarity::new()>\n\n\n#----------------\nsub new {\n#----------------\n    my ($class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    # Initialize placeholders\n    $self->{'_queryGaps'} = $self->{'_sbjctGaps'} = 0;\n    my ($raw_data, $qname, $hname, $qlen, $hlen);\n\n    ($self->{'_prog'}, $self->{'_rank'}, $raw_data,\n     $qname, $hname) =\n      $self->_rearrange([qw( PROGRAM\n                             RANK\n                             RAW_DATA\n                             QUERY_NAME\n                             HIT_NAME\n                           )], @args );\n\n    # _set_data() does a fair amount of parsing.\n    # This will likely change (see comment above.)\n    $self->_set_data( @{$raw_data} );\n    # Store the aligned query as sequence feature\n    my ($qb, $hb) = ($self->start());\n    my ($qe, $he) = ($self->end());\n    my ($qs, $hs) = ($self->strand());\n    my ($qf,$hf) = ($self->query->frame(),\n                    $self->hit->frame);\n\n    $self->query( Bio::SeqFeature::Similarity->new (-start   =>$qb,\n                                                    -end     =>$qe,\n                                                    -strand  =>$qs,\n                                                    -bits    =>$self->bits,\n                                                    -score   =>$self->score,\n                                                    -frame   =>$qf,\n                                                    -seq_id  => $qname,\n                                                    -source  =>$self->{'_prog'} ));\n\n    $self->hit( Bio::SeqFeature::Similarity->new (-start   =>$hb,\n                                                  -end     =>$he,\n                                                  -strand  =>$hs,\n                                                  -bits    =>$self->bits,\n                                                  -score   =>$self->score,\n                                                  -frame   =>$hf,\n                                                  -seq_id  => $hname,\n                                                  -source  =>$self->{'_prog'} ));\n\n    # set lengths\n    $self->query->seqlength($qlen); # query\n    $self->hit->seqlength($hlen); # subject\n\n    $self->query->frac_identical($self->frac_identical('query'));\n    $self->hit->frac_identical($self->frac_identical('hit'));\n    return $self;\n}\n\n#sub DESTROY {\n#    my $self = shift;\n#    #print STDERR \"--->DESTROYING $self\\n\";\n#}\n\n\n# Title   : _id_str;\n# Purpose : Intended for internal use only to provide a string for use\n#           within exception messages to help users figure out which\n#           query/hit caused the problem.\n# Returns : Short string with name of query and hit seq\nsub _id_str {\n    my $self = shift;\n    if( not defined $self->{'_id_str'}) {\n        my $qname = $self->query->seqname;\n        my $hname = $self->hit->seqname;\n        $self->{'_id_str'} = \"QUERY=\\\"$qname\\\" HIT=\\\"$hname\\\"\";\n    }\n    return $self->{'_id_str'};\n}\n\n#=================================================\n# Begin Bio::Search::HSP::HSPI implementation\n#=================================================\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hsp->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hsp\n           For BLAST, the algorithm denotes what type of sequence was aligned\n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated\n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated\n           dna-translated dna).\n Returns : a scalar string\n Args    : none\n\n\n#----------------\nsub algorithm {\n#----------------\n    my ($self,@args) = @_;\n    return $self->{'_prog'};\n}\n\n\n\n\n=head2 signif()\n\n Usage     : $hsp_obj->signif()\n Purpose   : Get the P-value or Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n           : Returns P-value if it is defined, otherwise, Expect value.\n Argument  : n/a\n Throws    : n/a\n Comments  : Provided for consistency with BlastHit::signif()\n           : Support for returning the significance data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>, L</expect>, L<Bio::Search::Hit::BlastHit::signif()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub signif {\n#-----------\n    my $self = shift;\n    my $val ||= defined($self->{'_p'}) ? $self->{'_p'} : $self->{'_expect'};\n    $val;\n}\n\n\n\n=head2 evalue\n\n Usage     : $hsp_obj->evalue()\n Purpose   : Get the Expect value for the HSP.\n Returns   : Float (0.001 or 1.3e-43)\n Argument  : n/a\n Throws    : n/a\n Comments  : Support for returning the expectation data in different\n           : formats (e.g., exponent only), is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</p>\n\n\n#----------\nsub evalue { shift->{'_expect'} }\n#----------\n\n\n=head2 p\n\n Usage     : $hsp_obj->p()\n Purpose   : Get the P-value for the HSP.\n Returns   : Float (0.001 or 1.3e-43) or undef if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : P-value is not defined with NCBI Blast2 reports.\n           : Support for returning the expectation data in different\n           : formats (e.g., exponent only) is not provided for HSP objects.\n           : This is only available for the BlastHit or Blast object.\n\nSee Also   : L</expect>\n\n\n#-----\nsub p { my $self = shift; $self->{'_p'}; }\n#-----\n\n# alias\nsub pvalue { shift->p(@_); }\n\n=head2 length\n\n Usage     : $hsp->length( [seq_type] )\n Purpose   : Get the length of the aligned portion of the query or sbjct.\n Example   : $hsp->length('query')\n Returns   : integer\n Argument  : seq_type: 'query' | 'hit' or 'sbjct' | 'total'  (default = 'total')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : 'total' length is the full length of the alignment\n           : as reported in the denominators in the alignment section:\n           : \"Identical = 34/120 Positives = 67/120\".\n\nSee Also   : L</gaps>\n\n\n#-----------\nsub length {\n#-----------\n## Developer note: when using the built-in length function within\n##                 this module, call it as CORE::length().\n    my( $self, $seqType ) = @_;\n    $seqType  ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $seqType ne 'total' and $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Length'};\n}\n\n\n\n=head2 gaps\n\n Usage     : $hsp->gaps( [seq_type] )\n Purpose   : Get the number of gap characters in the query, sbjct, or total alignment.\n           : Also can return query gap chars and sbjct gap chars as a two-element list\n           : when in array context.\n Example   : $total_gaps      = $hsp->gaps();\n           : ($qgaps, $sgaps) = $hsp->gaps();\n           : $qgaps           = $hsp->gaps('query');\n Returns   : scalar context: integer\n           : array context without args: (int, int) = ('queryGaps', 'sbjctGaps')\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : (default = 'total', scalar context)\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</length>, L</matches>\n\n\n#---------\nsub gaps {\n#---------\n    my( $self, $seqType ) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType  ||= (wantarray ? 'list' : 'total');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType =~ /list|array/i) {\n        return (($self->{'_queryGaps'} || 0), ($self->{'_sbjctGaps'} || 0));\n    }\n\n    if($seqType eq 'total') {\n        return ($self->{'_queryGaps'} + $self->{'_sbjctGaps'}) || 0;\n    } else {\n        ## Sensitive to member name format.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Gaps'} || 0;\n    }\n}\n\n\n=head2 frac_identical\n\n Usage     : $hsp_object->frac_identical( [seq_type] );\n Purpose   : Get the fraction of identical positions within the given HSP.\n Example   : $frac_iden = $hsp_object->frac_identical('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction identical among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct' ('sbjct' is synonymous with 'hit').\n\nSee Also   : L</frac_conserved>, L</num_identical>, L</matches>\n\n\n#-------------------\nsub frac_identical {\n#-------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numIdentical'}/$self->{$seqType.'Length'});\n}\n\n\n=head2 frac_conserved\n\n Usage     : $hsp_object->frac_conserved( [seq_type] );\n Purpose   : Get the fraction of conserved positions within the given HSP.\n           : (Note: 'conservative' positions are called 'positives' in the\n           : Blast report.)\n Example   : $frac_cons = $hsp_object->frac_conserved('query');\n Returns   : Float (2-decimal precision, e.g., 0.75).\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or 'total'\n           :  ('sbjct' is synonymous with 'hit')\n           : default = 'total' (but see comments below).\n Throws    : n/a\n Comments  : Different versions of Blast report different values for the total\n           : length of the alignment. This is the number reported in the\n           : denominators in the stats section:\n           : \"Identical = 34/120 Positives = 67/120\".\n           : NCBI-BLAST uses the total length of the alignment (with gaps)\n           : WU-BLAST uses the length of the query sequence (without gaps).\n           : Therefore, when called without an argument or an argument of 'total',\n           : this method will report different values depending on the\n           : version of BLAST used.\n           :\n           : To get the fraction conserved among only the aligned residues,\n           : ignoring the gaps, call this method with an argument of 'query'\n           : or 'sbjct'.\n\nSee Also   : L</frac_conserved>, L</num_conserved>, L</matches>\n\n\n#--------------------\nsub frac_conserved {\n#--------------------\n# The value is calculated as opposed to storing it from the parsed results.\n# This saves storage and also permits flexibility in determining for which\n# sequence (query or sbjct) the figure is to be calculated.\n\n    my( $self, $seqType ) = @_;\n    $seqType ||= 'total';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    if($seqType ne 'total') {\n      $self->_set_seq_data() unless $self->{'_set_seq_data'};\n    }\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    sprintf( \"%.2f\", $self->{'_numConserved'}/$self->{$seqType.'Length'});\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub query_string{ shift->seq_str('query'); }\n#----------------\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\n\n#----------------\nsub hit_string{ shift->seq_str('hit'); }\n#----------------\n\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\n#----------------\nsub homology_string{ shift->seq_str('match'); }\n#----------------\n\n#=================================================\n# End Bio::Search::HSP::HSPI implementation\n#=================================================\n\n# Older method delegating to method defined in HSPI.\n\n=head2 expect\n\nSee L<Bio::Search::HSP::HSPI::expect()|Bio::Search::HSP::HSPI>\n\n\n#----------\nsub expect { shift->evalue( @_ ); }\n#----------\n\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\n#'\n\n#----------\nsub rank { shift->{'_rank'} }\n#----------\n\n# For backward compatibility\n#----------\nsub name { shift->rank }\n#----------\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $hsp->to_string;\n Function: Returns a string representation for the Blast HSP.\n           Primarily intended for debugging purposes.\n Example : see usage\n Returns : A string of the form:\n           [PsiBlastHSP] <rank>\n           e.g.:\n           [BlastHit] 1\n Args    : None\n\n\n#----------\nsub to_string {\n#----------\n    my $self = shift;\n    return \"[PsiBlastHSP] \" . $self->rank();\n}\n\n\n=head2 _set_data\n\n Usage     : called automatically during object construction.\n Purpose   : Parses the raw HSP section from a flat BLAST report and\n             sets the query sequence, sbjct sequence, and the \"match\" data\n           : which consists of the symbols between the query and sbjct lines\n           : in the alignment.\n Argument  : Array (all lines for a single, complete HSP, from a raw,\n             flat (i.e., non-XML) BLAST report)\n Throws    : Propagates any exceptions from the methods called (\"See Also\")\n\nSee Also   : L</_set_seq>, L</_set_score_stats>, L</_set_match_stats>\n\n\n#--------------\nsub _set_data {\n#--------------\n    my $self = shift;\n    my @data = @_;\n    my @queryList  = ();  # 'Query' = SEQUENCE USED TO QUERY THE DATABASE.\n    my @sbjctList  = ();  # 'Sbjct' = HOMOLOGOUS SEQUENCE FOUND IN THE DATABASE.\n    my @matchList  = ();\n    my $matchLine  = 0;   # Alternating boolean: when true, load 'match' data.\n    my @linedat = ();\n\n    #print STDERR \"PsiBlastHSP: set_data()\\n\";\n\n    my($line, $aln_row_len, $length_diff);\n    $length_diff = 0;\n\n    # Collecting data for all lines in the alignment\n    # and then storing the collections for possible processing later.\n    #\n    # Note that \"match\" lines may not be properly padded with spaces.\n    # This loop now properly handles such cases:\n    # Query: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVIXXXXX 1200\n    #             PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVI\n    # Sbjct: 1141 PSLVELTIRDCPRLEVGPMIRSLPKFPMLKKLDLAVANIIEEDLDVIGSLEELVILSLKL 1200\n\n    foreach $line( @data ) {\n        next if $line =~ /^\\s*$/;\n\n        if( $line =~ /^ ?Score/ ) {\n            $self->_set_score_stats( $line );\n        } elsif( $line =~ /^ ?(Identities|Positives|Strand)/ ) {\n            $self->_set_match_stats( $line );\n        } elsif( $line =~ /^ ?Frame = ([\\d+-]+)/ ) {\n          # Version 2.0.8 has Frame information on a separate line.\n          # Storing frame according to SeqFeature::Generic::frame()\n          # which does not contain strand info (use strand()).\n          my $frame = abs($1) - 1;\n          $self->frame( $frame );\n        } elsif( $line =~ /^(Query:?[\\s\\d]+)([^\\s\\d]+)/ ) {\n            push @queryList, $line;\n            $self->{'_match_indent'} = CORE::length $1;\n            $aln_row_len = (CORE::length $1) + (CORE::length $2);\n            $matchLine = 1;\n        } elsif( $matchLine ) {\n            # Pad the match line with spaces if necessary.\n            $length_diff = $aln_row_len - CORE::length $line;\n            $length_diff and $line .= ' 'x $length_diff;\n            push @matchList, $line;\n            $matchLine = 0;\n        } elsif( $line =~ /^Sbjct/ ) {\n            push @sbjctList, $line;\n        }\n    }\n    # Storing the query and sbjct lists in case they are needed later.\n    # We could make this conditional to save memory.\n    $self->{'_queryList'} = \\@queryList;\n    $self->{'_sbjctList'} = \\@sbjctList;\n\n    # Storing the match list in case it is needed later.\n    $self->{'_matchList'} = \\@matchList;\n\n    if(not defined ($self->{'_numIdentical'})) {\n        my $id_str = $self->_id_str;\n        $self->throw( -text  => \"Can't parse match statistics. Possibly a new or unrecognized Blast format. ($id_str)\");\n    }\n\n    if(!scalar @queryList or !scalar @sbjctList) {\n        my $id_str = $self->_id_str;\n        $self->throw( \"Can't find query or sbjct alignment lines. Possibly unrecognized Blast format. ($id_str)\");\n    }\n}\n\n\n=head2 _set_score_stats\n\n Usage     : called automatically by _set_data()\n Purpose   : Sets various score statistics obtained from the HSP listing.\n Argument  : String with any of the following formats:\n           : blast2:  Score = 30.1 bits (66), Expect = 9.2\n           : blast2:  Score = 158.2 bits (544), Expect(2) = e-110\n           : blast1:  Score = 410 (144.3 bits), Expect = 1.7e-40, P = 1.7e-40\n           : blast1:  Score = 55 (19.4 bits), Expect = 5.3, Sum P(3) = 0.99\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n\nSee Also   : L</_set_data>\n\n\n#--------------------\nsub _set_score_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    my ($expect, $p);\n\n    if($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect = +([\\d.e+-]+)/) {\n        # blast2 format n = 1\n        $self->bits($1);\n        $self->score($2);\n        $expect            = $3;\n    } elsif($data =~ /Score = +([\\d.e+-]+) bits \\(([\\d.e+-]+)\\), +Expect\\((\\d+)\\) = +([\\d.e+-]+)/) {\n        # blast2 format n > 1\n        $self->bits($1);\n        $self->score($2);\n        $self->{'_n'}      = $3;\n        $expect            = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), P = +([\\d.e-]+)/) {\n        # blast1 format, n = 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $p                 = $4;\n\n    } elsif($data =~ /Score = +([\\d.e+-]+) \\(([\\d.e+-]+) bits\\), +Expect = +([\\d.e+-]+), +Sum P\\((\\d+)\\) = +([\\d.e-]+)/) {\n        # blast1 format, n > 1\n        $self->score($1);\n        $self->bits($2);\n        $expect            = $3;\n        $self->{'_n'}      = $4;\n        $p                 = $5;\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::Exception',\n                     -text => \"Can't parse score statistics: unrecognized format. ($id_str)\",\n                     -value => $data);\n    }\n    $expect = \"1$expect\" if $expect =~ /^e/i;\n    $p      = \"1$p\"      if defined $p and $p=~ /^e/i;\n\n    $self->{'_expect'} = $expect;\n    $self->{'_p'}      = $p || undef;\n    $self->significance( $p || $expect );\n}\n\n\n=head2 _set_match_stats\n\n Usage     : Private method; called automatically by _set_data()\n Purpose   : Sets various matching statistics obtained from the HSP listing.\n Argument  : blast2: Identities = 23/74 (31%), Positives = 29/74 (39%), Gaps = 17/74 (22%)\n           : blast2: Identities = 57/98 (58%), Positives = 74/98 (75%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%)\n           : blast1: Identities = 87/204 (42%), Positives = 126/204 (61%), Frame = -3\n           : WU-blast: Identities = 310/553 (56%), Positives = 310/553 (56%), Strand = Minus / Plus\n Throws    : Exception if the stats cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : The \"Gaps = \" data in the HSP header has a different meaning depending\n           : on the type of Blast: for BLASTP, this number is the total number of\n           : gaps in query+sbjct; for TBLASTN, it is the number of gaps in the\n           : query sequence only. Thus, it is safer to collect the data\n           : separately by examining the actual sequence strings as is done\n           : in _set_seq().\n\nSee Also   : L</_set_data>, L</_set_seq>\n\n\n#--------------------\nsub _set_match_stats {\n#--------------------\n    my ($self, $data) = @_;\n\n    if($data =~ m!Identities = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numIdentical'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Positives = (\\d+)/(\\d+)!) {\n      # blast1 or 2 format\n      $self->{'_numConserved'} = $1;\n      $self->{'_totalLength'}  = $2;\n    }\n\n    if($data =~ m!Frame = ([\\d+-]+)!) {\n      $self->frame($1);\n    }\n\n    # Strand data is not always present in this line.\n    # _set_seq() will also set strand information.\n    if($data =~ m!Strand = (\\w+) / (\\w+)!) {\n        $self->{'_queryStrand'} = $1;\n        $self->{'_sbjctStrand'} = $2;\n    }\n\n#    if($data =~ m!Gaps = (\\d+)/(\\d+)!) {\n#         $self->{'_totalGaps'} = $1;\n#    } else {\n#         $self->{'_totalGaps'} = 0;\n#    }\n}\n\n\n\n=head2 _set_seq_data\n\n Usage     : called automatically when sequence data is requested.\n Purpose   : Sets the HSP sequence data for both query and sbjct sequences.\n           : Includes: start, stop, length, gaps, and raw sequence.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_match_seq()\n Comments  : Uses raw data stored by _set_data() during object construction.\n           : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as gaps(), _set_residues(),\n           : etc. _set_seq() does the dirty work.\n\nSee Also   : L</_set_seq>\n\n\n#-----------------\nsub _set_seq_data {\n#-----------------\n    my $self = shift;\n\n    $self->_set_seq('query', @{$self->{'_queryList'}});\n    $self->_set_seq('sbjct', @{$self->{'_sbjctList'}});\n\n    # Liberate some memory.\n    @{$self->{'_queryList'}} = @{$self->{'_sbjctList'}} = ();\n    undef $self->{'_queryList'};\n    undef $self->{'_sbjctList'};\n\n    $self->{'_set_seq_data'} = 1;\n}\n\n\n\n=head2 _set_seq\n\n Usage     : called automatically by _set_seq_data()\n           : $hsp_obj->($seq_type, @data);\n Purpose   : Sets sequence information for both the query and sbjct sequences.\n           : Directly counts the number of gaps in each sequence (if gapped Blast).\n Argument  : $seq_type = 'query' or 'sbjct'\n           : @data = all seq lines with the form:\n           : Query: 61  SPHNVKDRKEQNGSINNAISPTATANTSGSQQINIDSALRDRSSNVAAQPSLSDASSGSN 120\n Throws    : Exception if data strings cannot be parsed, probably due to a change\n           : in the Blast report format.\n Comments  : Uses first argument to determine which data members to set\n           : making this method sensitive data member name changes.\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n Warning   : Sequence endpoints are normalized so that start < end. This affects HSPs\n           : for TBLASTN/X hits on the minus strand. Normalization facilitates use\n           : of range information by methods such as match().\n\nSee Also   : L</_set_seq_data>, L</matches>, L</range>, L</start>, L</end>\n\n\n#-------------\nsub _set_seq {\n#-------------\n    my $self      = shift;\n    my $seqType   = shift;\n    my @data      = @_;\n    my @ranges    = ();\n    my @sequence  = ();\n    my $numGaps   = 0;\n\n    foreach( @data ) {\n        if( m/(\\d+) *([^\\d\\s]+) *(\\d+)/) {\n            push @ranges, ( $1, $3 ) ;\n            push @sequence, $2;\n        #print STDERR \"_set_seq found sequence \\\"$2\\\"\\n\";\n        } else {\n            $self->warn(\"Bad sequence data: $_\");\n        }\n    }\n\n    if( !(scalar(@sequence) and scalar(@ranges))) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set sequence: missing data. Possibly unrecognized Blast format. ($id_str)\");\n   }\n\n    # Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n    $self->{$seqType.'Start'} = $ranges[0];\n    $self->{$seqType.'Stop'}  = $ranges[ $#ranges ];\n    $self->{$seqType.'Seq'}   = \\@sequence;\n\n    $self->{$seqType.'Length'} = abs($ranges[ $#ranges ] - $ranges[0]) + 1;\n\n    # Adjust lengths for BLASTX, TBLASTN, TBLASTX sequences\n    # Converting nucl coords to amino acid coords.\n\n    my $prog = $self->algorithm;\n    if($prog eq 'TBLASTN' and $seqType eq '_sbjct') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'BLASTX' and $seqType eq '_query') {\n        $self->{$seqType.'Length'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n        $self->{$seqType.'Length'} /= 3;\n    }\n\n    if( $prog ne 'BLASTP' ) {\n        $self->{$seqType.'Strand'} = 'Plus' if $prog =~ /BLASTN/;\n        $self->{$seqType.'Strand'} = 'Plus' if ($prog =~ /BLASTX/ and $seqType eq '_query');\n        # Normalize sequence endpoints so that start < end.\n        # Reverse complement or 'minus strand' HSPs get flipped here.\n        if($self->{$seqType.'Start'} > $self->{$seqType.'Stop'}) {\n            ($self->{$seqType.'Start'}, $self->{$seqType.'Stop'}) =\n                ($self->{$seqType.'Stop'}, $self->{$seqType.'Start'});\n            $self->{$seqType.'Strand'} = 'Minus';\n        }\n    }\n\n    ## Count number of gaps in each seq. Only need to do this for gapped Blasts.\n#    if($self->{'_gapped'}) {\n        my $seqstr = join('', @sequence);\n        $seqstr =~ s/\\s//g;\n        my $num_gaps = CORE::length($seqstr) - $self->{$seqType.'Length'};\n        $self->{$seqType.'Gaps'} = $num_gaps if $num_gaps > 0;\n#    }\n}\n\n\n=head2 _set_residues\n\n Usage     : called automatically when residue data is requested.\n Purpose   : Sets the residue numbers representing the identical and\n           : conserved positions. These data are obtained by analyzing the\n           : symbols between query and sbjct lines of the alignments.\n Argument  : n/a\n Throws    : Propagates any exception thrown by _set_seq_data() and _set_match_seq().\n Comments  : These data are not always needed, so it is conditionally\n           : executed only upon demand by methods such as seq_inds().\n           : Behavior is dependent on the type of BLAST analysis (TBLASTN, BLASTP, etc).\n\nSee Also   : L</_set_seq_data>, L</_set_match_seq>, L</seq_inds>\n\n\n#------------------\nsub _set_residues {\n#------------------\n    my $self      = shift;\n    my @sequence  = ();\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    # Using hashes to avoid saving duplicate residue numbers.\n    my %identicalList_query = ();\n    my %identicalList_sbjct = ();\n    my %conservedList_query = ();\n    my %conservedList_sbjct = ();\n\n    my $aref = $self->_set_match_seq() if not ref $self->{'_matchSeq'};\n    $aref  ||= $self->{'_matchSeq'};\n    my $seqString = join('', @$aref );\n\n    my $qseq = join('',@{$self->{'_querySeq'}});\n    my $sseq = join('',@{$self->{'_sbjctSeq'}});\n    my $resCount_query = $self->{'_queryStop'} || 0;\n    my $resCount_sbjct = $self->{'_sbjctStop'} || 0;\n\n    my $prog = $self->algorithm;\n    if($prog !~ /^BLASTP|^BLASTN/) {\n        if($prog eq 'TBLASTN') {\n            $resCount_sbjct /= 3;\n        } elsif($prog eq 'BLASTX') {\n            $resCount_query /= 3;\n        } elsif($prog eq 'TBLASTX') {\n            $resCount_query /= 3;\n            $resCount_sbjct /= 3;\n        }\n    }\n\n    my ($mchar, $schar, $qchar);\n    while( $mchar = chop($seqString) ) {\n        ($qchar, $schar) = (chop($qseq), chop($sseq));\n        if( $mchar eq '+' ) {\n            $conservedList_query{ $resCount_query } = 1;\n            $conservedList_sbjct{ $resCount_sbjct } = 1;\n        } elsif( $mchar ne ' ' ) {\n            $identicalList_query{ $resCount_query } = 1;\n            $identicalList_sbjct{ $resCount_sbjct } = 1;\n        }\n        $resCount_query-- if $qchar ne $GAP_SYMBOL;\n        $resCount_sbjct-- if $schar ne $GAP_SYMBOL;\n    }\n    $self->{'_identicalRes_query'} = \\%identicalList_query;\n    $self->{'_conservedRes_query'} = \\%conservedList_query;\n    $self->{'_identicalRes_sbjct'} = \\%identicalList_sbjct;\n    $self->{'_conservedRes_sbjct'} = \\%conservedList_sbjct;\n\n}\n\n\n\n\n=head2 _set_match_seq\n\n Usage     : $hsp_obj->_set_match_seq()\n Purpose   : Set the 'match' sequence for the current HSP (symbols in between\n           : the query and sbjct lines.)\n Returns   : Array reference holding the match sequences lines.\n Argument  : n/a\n Throws    : Exception if the _matchList field is not set.\n Comments  : The match information is not always necessary. This method\n           : allows it to be conditionally prepared.\n           : Called by _set_residues>() and seq_str().\n\nSee Also   : L</_set_residues>, L</seq_str>\n\n\n#-------------------\nsub _set_match_seq {\n#-------------------\n    my $self = shift;\n\n    if( ! ref($self->{'_matchList'}) ) {\n        my $id_str = $self->_id_str;\n        $self->throw(\"Can't set HSP match sequence: No data ($id_str)\");\n    }\n\n    my @data = @{$self->{'_matchList'}};\n\n    my(@sequence);\n    foreach( @data ) {\n        chomp($_);\n        ## Remove leading spaces; (note: aln may begin with a space\n        ## which is why we can't use s/^ +//).\n        s/^ {$self->{'_match_indent'}}//;\n        push @sequence, $_;\n    }\n    # Liberate some memory.\n    @{$self->{'_matchList'}} = undef;\n    $self->{'_matchList'} = undef;\n\n    $self->{'_matchSeq'} = \\@sequence;\n\n    return $self->{'_matchSeq'};\n}\n\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n           : This value is not defined with NCBI Blast2 with gapping.\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n           : To obtain the number of HSPs, use Bio::Search::Hit::BlastHit::num_hsps().\n\nSee Also   : L<Bio::SeqFeature::SimilarityPair::score()|Bio::SeqFeature::SimilarityPair>\n\n\n#-----\nsub n { my $self = shift; $self->{'_n'} || ''; }\n#-----\n\n\n=head2 matches\n\n Usage     : $hsp->matches([seq_type], [start], [stop]);\n Purpose   : Get the total number of identical and conservative matches\n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n           : (Note: 'conservative' matches are called 'positives' in the\n           : Blast report.)\n Example   : ($id,$cons) = $hsp_object->matches('hit');\n           : ($id,$cons) = $hsp_object->matches('query',300,400);\n Returns   : 2-element array of integers\n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n Throws    : Exception if the supplied coordinates are out of range.\n Comments  : Relies on seq_str('match') to get the string of alignment symbols\n           : between the query and sbjct lines which are used for determining\n           : the number of identical and conservative matches.\n\nSee Also   : L</length>, L</gaps>, L</seq_str>, L<Bio::Search::Hit::BlastHit::_adjust_contigs()|Bio::Search::Hit::BlastHit>\n\n\n#-----------\nsub matches {\n#-----------\n    my( $self, %param ) = @_;\n    my(@data);\n    my($seqType, $beg, $end) = ($param{-SEQ}, $param{-START}, $param{-STOP});\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my($start,$stop);\n\n    if(!defined $beg && !defined $end) {\n        ## Get data for the whole alignment.\n        push @data, ($self->{'_numIdentical'}, $self->{'_numConserved'});\n    } else {\n        ## Get the substring representing the desired sub-section of aln.\n        $beg ||= 0;\n        $end ||= 0;\n        ($start,$stop) = $self->range($seqType);\n        if($beg == 0) { $beg = $start; $end = $beg+$end; }\n        elsif($end == 0) { $end = $stop; $beg = $end-$beg; }\n\n        if($end >= $stop) { $end = $stop; } ##ML changed from if (end >stop)\n        else { $end += 1;}   ##ML moved from commented position below, makes\n                             ##more sense here\n#        if($end > $stop) { $end = $stop; }\n        if($beg < $start) { $beg = $start; }\n#        else { $end += 1;}\n\n#        my $seq = substr($self->seq_str('match'), $beg-$start, ($end-$beg));\n\n        ## ML: START fix for substr out of range error ------------------\n        my $seq = \"\";\n        my $prog = $self->algorithm;\n        if (($prog eq 'TBLASTN') and ($seqType eq 'sbjct'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n\n        } elsif (($prog eq 'BLASTX') and ($seqType eq 'query'))\n        {\n            $seq = substr($self->seq_str('match'),\n                          int(($beg-$start)/3), int(($end-$beg+1)/3));\n        } else {\n            $seq = substr($self->seq_str('match'),\n                          $beg-$start, ($end-$beg));\n        }\n        ## ML: End of fix for  substr out of range error -----------------\n\n\n        ## ML: debugging code\n        ## This is where we get our exception.  Try printing out the values going\n        ## into this:\n        ##\n#         print STDERR\n#             qq(*------------MY EXCEPTION --------------------\\nSeq: \") ,\n#             $self->seq_str(\"$seqType\"), qq(\"\\n),$self->rank,\",(  index:\";\n#         print STDERR  $beg-$start, \", len: \", $end-$beg,\" ), (HSPRealLen:\",\n#             CORE::length $self->seq_str(\"$seqType\");\n#         print STDERR \", HSPCalcLen: \", $stop - $start +1 ,\" ),\n#             ( beg: $beg, end: $end ), ( start: $start, stop: stop )\\n\";\n         ## ML: END DEBUGGING CODE----------\n\n        if(!CORE::length $seq) {\n            my $id_str = $self->_id_str;\n            $self->throw(\"Undefined $seqType sub-sequence ($beg,$end). Valid range = $start - $stop ($id_str)\");\n        }\n        ## Get data for a substring.\n#        printf \"Collecting HSP subsection data: beg,end = %d,%d; start,stop = %d,%d\\n%s<---\\n\", $beg, $end, $start, $stop, $seq;\n#        printf \"Original match seq:\\n%s\\n\",$self->seq_str('match');\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n#        printf \"  HSP = %s\\n  id = %d; cons = %d\\n\", $self->rank, $len_id, $len_cons; <STDIN>;\n    }\n    @data;\n}\n\n\n=head2 num_identical\n\n Usage     : $hsp_object->num_identical();\n Purpose   : Get the number of identical positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_identical();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_conserved>, L</frac_identical>\n\n\n#-------------------\nsub num_identical {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numIdentical'};\n}\n\n\n=head2 num_conserved\n\n Usage     : $hsp_object->num_conserved();\n Purpose   : Get the number of conserved positions within the given HSP.\n Example   : $num_iden = $hsp_object->num_conserved();\n Returns   : integer\n Argument  : n/a\n Throws    : n/a\n\nSee Also   : L</num_identical>, L</frac_conserved>\n\n\n#-------------------\nsub num_conserved {\n#-------------------\n    my( $self) = shift;\n\n    $self->{'_numConserved'};\n}\n\n\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers\n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</start>, L</end>\n\n\n#----------\nsub range {\n#----------\n    my ($self, $seqType) = @_;\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    return ($self->{$seqType.'Start'},$self->{$seqType.'Stop'});\n}\n\n=head2 start\n\n Usage     : $hsp->start( [seq_type] );\n Purpose   : Gets the start coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_beg = $hsp->start('query');\n           : $hit_beg = $hsp->start('hit');\n           : ($query_beg, $hit_beg) = $hsp->start();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</end>, L</range>\n\n\n#----------\nsub start {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStart'}, $self->{'_sbjctStart'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Start'};\n    }\n}\n\n=head2 end\n\n Usage     : $hsp->end( [seq_type] );\n Purpose   : Gets the end coordinate for the query, sbjct, or both sequences\n           : in the HSP alignment.\n           : NOTE: Start will always be less than end.\n           : To determine strand, use $hsp->strand()\n Example   : $query_end = $hsp->end('query');\n           : $hit_end = $hsp->end('hit');\n           : ($query_end, $hit_end) = $hsp->end();\n Returns   : scalar context: integer\n           : array context without args: list of two integers\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default= 'query')\n           :  ('sbjct' is synonymous with 'hit')\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Throws    : n/a\n\nSee Also   : L</start>, L</range>, L</strand>\n\n\n#----------\nsub end {\n#----------\n    my ($self, $seqType) = @_;\n\n    $seqType ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /list|array/i) {\n        return ($self->{'_queryStop'}, $self->{'_sbjctStop'});\n    } else {\n        ## Sensitive to member name changes.\n        $seqType = \"_\\L$seqType\\E\";\n        return $self->{$seqType.'Stop'};\n    }\n}\n\n\n\n=head2 strand\n\n Usage     : $hsp_object->strand( [seq_type] )\n Purpose   : Get the strand of the query or sbjct sequence.\n Example   : print $hsp->strand('query');\n           : ($query_strand, $hit_strand) = $hsp->strand();\n Returns   : -1, 0, or 1\n           : -1 = Minus strand, +1 = Plus strand\n           : Returns 0 if strand is not defined, which occurs\n           : for BLASTP reports, and the query of TBLASTN\n           : as well as the hit if BLASTX reports.\n           : In scalar context without arguments, returns queryStrand value.\n           : In array context without arguments, returns a two-element list\n           :    of strings (queryStrand, sbjctStrand).\n           : Array context can be \"induced\" by providing an argument of 'list' or 'array'.\n Argument  : seq_type: 'query' or 'hit' or 'sbjct' or undef\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n\nSee Also   : L</_set_seq>, L</_set_match_stats>\n\n\n#-----------\nsub strand {\n#-----------\n    my( $self, $seqType ) = @_;\n\n    $seqType  ||= (wantarray ? 'list' : 'query');\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    ## Sensitive to member name format.\n    $seqType = \"_\\L$seqType\\E\";\n\n    # $seqType could be '_list'.\n    $self->{'_queryStrand'} or $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    my $prog = $self->algorithm;\n\n    if($seqType  =~ /list|array/i) {\n        my ($qstr, $hstr);\n        if( $prog eq 'BLASTP') {\n            $qstr = 0;\n            $hstr = 0;\n        }\n        elsif( $prog eq 'TBLASTN') {\n            $qstr = 0;\n            $hstr = $STRAND_SYMBOL{$self->{'_sbjctStrand'}};\n        }\n        elsif( $prog eq 'BLASTX') {\n            $qstr = $STRAND_SYMBOL{$self->{'_queryStrand'}};\n            $hstr = 0;\n        }\n        else {\n            $qstr = $STRAND_SYMBOL{$self->{'_queryStrand'}} if defined $self->{'_queryStrand'};\n            $hstr = $STRAND_SYMBOL{$self->{'_sbjctStrand'}} if defined $self->{'_sbjctStrand'};\n        }\n        $qstr ||= 0;\n        $hstr ||= 0;\n        return ($qstr, $hstr);\n    }\n    local $^W = 0;\n    $STRAND_SYMBOL{$self->{$seqType.'Strand'}} || 0;\n}\n\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::Seq.pm object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : Propagates any exception that occurs during construction\n           : of the Bio::Seq.pm object.\n Comments  : The sequence is returned in an array of strings corresponding\n           : to the strings in the original format of the Blast alignment.\n           : (i.e., same spacing).\n\nSee Also   : L</seq_str>, L</seq_inds>, L<Bio::Seq>\n\n\n#-------\nsub seq {\n#-------\n    my($self,$seqType) = @_;\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    my $str = $self->seq_str($seqType);\n\n    require Bio::Seq;\n\n    Bio::Seq->new(-ID   => $self->to_string,\n                  -SEQ  => $str,\n                  -DESC => \"$seqType sequence\",\n                  );\n}\n\n=head2 seq_str\n\n Usage     : $hsp->seq_str( seq_type );\n Purpose   : Get the full query, sbjct, or 'match' sequence as a string.\n           : The 'match' sequence is the string of symbols in between the\n           : query and sbjct sequences.\n Example   : $str = $hsp->seq_str('query');\n Returns   : String\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' or 'match'\n           :  ('sbjct' is synonymous with 'hit')\n Throws    : Exception if the argument does not match an accepted seq_type.\n Comments  : Calls _set_seq_data() to set the 'match' sequence if it has\n           : not been set already.\n\nSee Also   : L</seq>, L</seq_inds>, L</_set_match_seq>\n\n\n#------------\nsub seq_str {\n#------------\n    my($self,$seqType) = @_;\n\n    $seqType ||= 'query';\n    $seqType = 'sbjct' if $seqType eq 'hit';\n    ## Sensitive to member name changes.\n    $seqType = \"_\\L$seqType\\E\";\n\n    $self->_set_seq_data() unless $self->{'_set_seq_data'};\n\n    if($seqType =~ /sbjct|query/) {\n        my $seq = join('',@{$self->{$seqType.'Seq'}});\n        $seq =~ s/\\s+//g;\n        return $seq;\n\n    } elsif( $seqType =~ /match/i) {\n        # Only need to call _set_match_seq() if the match seq is requested.\n        my $aref = $self->_set_match_seq() unless ref $self->{'_matchSeq'};\n        $aref =  $self->{'_matchSeq'};\n\n        return join('',@$aref);\n\n    } else {\n        my $id_str = $self->_id_str;\n        $self->throw(-class => 'Bio::Root::BadParameter',\n                     -text => \"Invalid or undefined sequence type: $seqType ($id_str)\\n\" .\n                               \"Valid types: query, sbjct, match\",\n                     -value => $seqType);\n    }\n}\n\n=head2 seq_inds\n\n Usage     : $hsp->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) for all identical\n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers\n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : class     = 'identical' or 'conserved' (default = identical)\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : collapse  = boolean, if true, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\"\n           :             collapses to \"1-5 7 9-11\". This is useful for\n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : Calls _set_residues() to set the 'match' sequence if it has\n           : not been set already.\n\nSee Also   : L</seq>, L</_set_residues>, L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::BlastHit::seq_inds()|Bio::Search::Hit::BlastHit>"},"children":[{"definition":"my","containerName":"seq_inds","localvar":"my","kind":13,"name":"$self","line":1596},{"line":1596,"kind":13,"containerName":"seq_inds","name":"$seqType"},{"name":"$class","containerName":"seq_inds","kind":13,"line":1596},{"name":"$collapse","containerName":"seq_inds","kind":13,"line":1596},{"line":1598,"name":"$seqType","kind":13,"containerName":"seq_inds"},{"line":1599,"name":"$class","kind":13,"containerName":"seq_inds"},{"line":1600,"name":"$collapse","kind":13,"containerName":"seq_inds"},{"kind":13,"containerName":"seq_inds","name":"$seqType","line":1601},{"line":1601,"kind":13,"containerName":"seq_inds","name":"$seqType"},{"line":1603,"name":"$self","kind":13,"containerName":"seq_inds"},{"line":1603,"name":"_set_residues","containerName":"seq_inds","kind":12},{"name":"$self","kind":13,"containerName":"seq_inds","line":1603},{"kind":13,"containerName":"seq_inds","name":"$seqType","line":1605},{"line":1605,"name":"$seqType","containerName":"seq_inds","kind":13},{"kind":13,"containerName":"seq_inds","name":"$class","line":1606},{"line":1606,"containerName":"seq_inds","kind":13,"name":"$class"},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":1609},{"line":1610,"containerName":"seq_inds","kind":13,"name":"$class"},{"line":1612,"kind":13,"localvar":"my","containerName":"seq_inds","name":"@ary","definition":"my"},{"containerName":"seq_inds","kind":13,"name":"$a","line":1612},{"kind":13,"containerName":"seq_inds","name":"$b","line":1612},{"kind":13,"containerName":"seq_inds","name":"$self","line":1612}],"containerName":"main::","name":"seq_inds","definition":"sub","detail":"($self,$seqType,$class,$collapse)"},{"name":"$collapse","kind":13,"containerName":null,"line":1614},{"line":1616,"containerName":null,"kind":13,"name":"$collapse"},{"containerName":"Search::BlastUtils","kind":12,"name":"Bio","line":1616},{"containerName":"Search::BlastUtils::collapse_nums","kind":12,"name":"Bio","line":1616},{"line":1616,"containerName":null,"kind":13,"name":"@ary"},{"line":1616,"kind":13,"containerName":null,"name":"@ary"},{"definition":"sub","name":"get_aln","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"get_aln","line":1642,"definition":"my"},{"definition":"my","line":1646,"name":"$qseq","containerName":"get_aln","localvar":"my","kind":13},{"line":1646,"containerName":"get_aln","kind":13,"name":"$self"},{"name":"seq","kind":12,"containerName":"get_aln","line":1646},{"definition":"my","line":1647,"containerName":"get_aln","localvar":"my","kind":13,"name":"$sseq"},{"line":1647,"name":"$self","kind":13,"containerName":"get_aln"},{"line":1647,"containerName":"get_aln","kind":12,"name":"seq"},{"definition":"my","line":1649,"localvar":"my","kind":13,"containerName":"get_aln","name":"$type"},{"line":1649,"name":"$self","containerName":"get_aln","kind":13},{"name":"algorithm","kind":12,"containerName":"get_aln","line":1649},{"definition":"my","line":1650,"name":"$aln","containerName":"get_aln","localvar":"my","kind":13},{"name":"new","kind":12,"containerName":"get_aln","line":1650},{"name":"$aln","containerName":"get_aln","kind":13,"line":1651},{"line":1651,"name":"add_seq","containerName":"get_aln","kind":12},{"line":1651,"containerName":"get_aln","kind":12,"name":"new"},{"line":1651,"name":"$qseq","kind":13,"containerName":"get_aln"},{"line":1651,"name":"seq","containerName":"get_aln","kind":12},{"name":"$qseq","containerName":"get_aln","kind":13,"line":1652},{"name":"display_id","containerName":"get_aln","kind":12,"line":1652},{"line":1654,"containerName":"get_aln","kind":13,"name":"$qseq"},{"kind":13,"containerName":"get_aln","name":"$aln","line":1656},{"kind":12,"containerName":"get_aln","name":"add_seq","line":1656},{"kind":12,"containerName":"get_aln","name":"new","line":1656},{"line":1656,"containerName":"get_aln","kind":13,"name":"$sseq"},{"line":1656,"kind":12,"containerName":"get_aln","name":"seq"},{"line":1657,"name":"$sseq","kind":13,"containerName":"get_aln"},{"name":"display_id","containerName":"get_aln","kind":12,"line":1657},{"line":1659,"kind":13,"containerName":"get_aln","name":"$sseq"},{"line":1661,"kind":13,"containerName":"get_aln","name":"$aln"}],"kind":12,"range":{"end":{"line":1662,"character":9999},"start":{"character":0,"line":1640}},"line":1640},{"line":1646,"name":"Bio","kind":12,"containerName":"SimpleAlign::Bio::LocatableSeq"},{"kind":12,"containerName":"SimpleAlign","name":"Bio","line":1650},{"line":1651,"kind":12,"containerName":"LocatableSeq","name":"Bio"},{"containerName":"length","kind":12,"name":"CORE","line":1654},{"line":1656,"kind":12,"containerName":"LocatableSeq","name":"Bio"},{"line":1659,"kind":12,"containerName":"length","name":"CORE"}],"version":5}