{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":122},{"kind":12,"range":{"end":{"line":214,"character":9999},"start":{"line":175,"character":0}},"line":175,"signature":{"parameters":[{"label":"$class"},{"label":"%args"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')","label":"new($class,%args)"},"containerName":"main::","name":"new","children":[{"definition":"my","name":"$class","kind":13,"localvar":"my","containerName":"new","line":176},{"line":176,"name":"%args","kind":13,"containerName":"new"},{"name":"$self","localvar":"my","kind":13,"containerName":"new","line":181,"definition":"my"},{"line":181,"containerName":"new","kind":13,"name":"$class"},{"definition":"my","name":"$arg","containerName":"new","localvar":"my","kind":13,"line":186},{"name":"$value","kind":13,"containerName":"new","line":186},{"line":186,"containerName":"new","kind":13,"name":"%args"},{"line":187,"name":"$arg","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":188},{"line":188,"containerName":"new","kind":13,"name":"$arg"},{"line":188,"name":"$value","kind":13,"containerName":"new"},{"line":190,"kind":13,"localvar":"my","containerName":"new","name":"$bits","definition":"my"},{"kind":13,"containerName":"new","name":"$self","line":190},{"containerName":"new","kind":13,"name":"$self","line":192},{"containerName":"new","kind":13,"name":"$self","line":192},{"line":192,"kind":12,"containerName":"new","name":"verbose"},{"kind":13,"containerName":"new","name":"$self","line":192},{"containerName":"new","kind":13,"name":"$self","line":193},{"containerName":"new","kind":13,"name":"$self","line":197},{"kind":12,"containerName":"new","name":"throw","line":197},{"line":198,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":13,"name":"$self","line":201},{"line":203,"name":"$self","containerName":"new","kind":13},{"line":204,"kind":13,"containerName":"new","name":"$self"},{"name":"$self","kind":13,"containerName":"new","line":206},{"containerName":"new","kind":13,"name":"$self","line":206},{"containerName":"new","kind":13,"name":"$self","line":207},{"containerName":"new","kind":12,"name":"throw","line":207},{"name":"$self","containerName":"new","kind":13,"line":210},{"kind":13,"containerName":"new","name":"$self","line":212},{"line":213,"kind":13,"containerName":"new","name":"$self"}],"detail":"($class,%args)","definition":"sub"},{"line":181,"kind":12,"containerName":"new","name":"SUPER"},{"name":"BITS","kind":12,"line":190},{"line":192,"kind":12,"name":"VERBOSE"},{"line":192,"kind":12,"name":"VERBOSE"},{"line":193,"kind":12,"name":"GAP_SYMBOL"},{"line":198,"name":"CORE","containerName":"length","kind":12},{"kind":12,"name":"GAP_SYMBOL","line":198},{"name":"GAP_SYMBOL","kind":12,"line":201},{"kind":12,"name":"ALGORITHM","line":203},{"line":204,"name":"STRANDED","kind":12},{"name":"QUERY_LENGTH","kind":12,"line":206},{"name":"HIT_LENGTH","kind":12,"line":206},{"line":212,"name":"_finished_new","kind":12},{"definition":"sub","detail":"($self,$type)","children":[{"localvar":"my","kind":13,"containerName":"_logical_length","name":"$self","line":217,"definition":"my"},{"name":"$type","kind":13,"containerName":"_logical_length","line":217},{"definition":"my","name":"$algo","localvar":"my","kind":13,"containerName":"_logical_length","line":218},{"line":218,"kind":13,"containerName":"_logical_length","name":"$self"},{"kind":12,"containerName":"_logical_length","name":"algorithm","line":218},{"line":219,"name":"$len","localvar":"my","containerName":"_logical_length","kind":13,"definition":"my"},{"containerName":"_logical_length","kind":13,"name":"$self","line":219},{"name":"length","kind":12,"containerName":"_logical_length","line":219},{"name":"$type","kind":13,"containerName":"_logical_length","line":219},{"definition":"my","line":220,"name":"$logical","localvar":"my","kind":13,"containerName":"_logical_length"},{"line":220,"containerName":"_logical_length","kind":13,"name":"$len"},{"line":221,"kind":13,"containerName":"_logical_length","name":"$algo"},{"line":222,"name":"$logical","containerName":"_logical_length","kind":13},{"kind":13,"containerName":"_logical_length","name":"$len","line":222},{"line":222,"name":"$type","kind":13,"containerName":"_logical_length"},{"kind":13,"containerName":"_logical_length","name":"$algo","line":223},{"line":224,"name":"$logical","kind":13,"containerName":"_logical_length"},{"containerName":"_logical_length","kind":13,"name":"$len","line":224},{"name":"$type","containerName":"_logical_length","kind":13,"line":224},{"line":225,"containerName":"_logical_length","kind":13,"name":"$algo"},{"name":"$logical","kind":13,"containerName":"_logical_length","line":226},{"containerName":"_logical_length","kind":13,"name":"$len","line":226},{"containerName":"_logical_length","kind":13,"name":"$logical","line":228}],"name":"_logical_length","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"","label":"_logical_length($self,$type)"},"line":216,"kind":12,"range":{"end":{"character":9999,"line":229},"start":{"line":216,"character":0}}},{"signature":{"label":"algorithm($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value"},"line":245,"kind":12,"range":{"start":{"line":245,"character":0},"end":{"line":254,"character":9999}},"definition":"sub","detail":"($self,$value)","children":[{"line":246,"kind":13,"localvar":"my","containerName":"algorithm","name":"$self","definition":"my"},{"line":246,"name":"$value","kind":13,"containerName":"algorithm"},{"definition":"my","name":"$previous","localvar":"my","kind":13,"containerName":"algorithm","line":247},{"line":247,"containerName":"algorithm","kind":13,"name":"$self"},{"line":248,"containerName":"algorithm","kind":13,"name":"$value"},{"line":248,"name":"$previous","containerName":"algorithm","kind":13},{"line":249,"name":"$value","kind":13,"containerName":"algorithm"},{"containerName":"algorithm","kind":13,"name":"$previous","line":249},{"name":"$value","containerName":"algorithm","kind":13,"line":249},{"line":250,"containerName":"algorithm","kind":13,"name":"$self"},{"line":250,"name":"$value","containerName":"algorithm","kind":13},{"line":253,"kind":13,"containerName":"algorithm","name":"$previous"}],"containerName":"main::","name":"algorithm"},{"signature":{"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value","parameters":[{"label":"$self"},{"label":"$value"}],"label":"pvalue($self,$value)"},"line":267,"range":{"start":{"line":267,"character":0},"end":{"character":9999,"line":274}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"pvalue","line":268,"definition":"my"},{"containerName":"pvalue","kind":13,"name":"$value","line":268},{"definition":"my","localvar":"my","containerName":"pvalue","kind":13,"name":"$previous","line":269},{"kind":13,"containerName":"pvalue","name":"$self","line":269},{"kind":13,"containerName":"pvalue","name":"$value","line":270},{"line":271,"name":"$self","kind":13,"containerName":"pvalue"},{"line":271,"containerName":"pvalue","kind":13,"name":"$value"},{"name":"$previous","kind":13,"containerName":"pvalue","line":273}],"name":"pvalue","containerName":"main::"},{"kind":12,"range":{"end":{"line":293,"character":9999},"start":{"line":286,"character":0}},"line":286,"signature":{"label":"evalue($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value"},"containerName":"main::","name":"evalue","children":[{"line":287,"name":"$self","localvar":"my","containerName":"evalue","kind":13,"definition":"my"},{"line":287,"containerName":"evalue","kind":13,"name":"$value"},{"definition":"my","line":288,"localvar":"my","kind":13,"containerName":"evalue","name":"$previous"},{"line":288,"kind":13,"containerName":"evalue","name":"$self"},{"line":289,"kind":13,"containerName":"evalue","name":"$value"},{"name":"$self","kind":13,"containerName":"evalue","line":290},{"line":290,"containerName":"evalue","kind":13,"name":"$value"},{"line":292,"containerName":"evalue","kind":13,"name":"$previous"}],"detail":"($self,$value)","definition":"sub"},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"frac_identical","line":312,"definition":"my"},{"name":"$type","kind":13,"containerName":"frac_identical","line":312},{"line":312,"name":"$value","containerName":"frac_identical","kind":13},{"name":"$self","containerName":"frac_identical","kind":13,"line":314},{"line":315,"kind":13,"containerName":"frac_identical","name":"$self"},{"line":315,"kind":12,"containerName":"frac_identical","name":"_pre_frac"},{"name":"$type","kind":13,"containerName":"frac_identical","line":318},{"containerName":"frac_identical","kind":13,"name":"$type","line":318},{"name":"$type","containerName":"frac_identical","kind":13,"line":318},{"name":"$type","kind":13,"containerName":"frac_identical","line":319},{"containerName":"frac_identical","kind":13,"name":"$type","line":319},{"line":320,"containerName":"frac_identical","kind":13,"name":"$type"},{"line":321,"containerName":"frac_identical","kind":13,"name":"$type"},{"line":321,"containerName":"frac_identical","kind":13,"name":"$type"},{"line":321,"name":"$type","containerName":"frac_identical","kind":13},{"kind":13,"containerName":"frac_identical","name":"$type","line":322},{"localvar":"my","containerName":"frac_identical","kind":13,"name":"$previous","line":323,"definition":"my"},{"line":323,"containerName":"frac_identical","kind":13,"name":"$self"},{"name":"$type","kind":13,"containerName":"frac_identical","line":323},{"containerName":"frac_identical","kind":13,"name":"$value","line":324},{"line":324,"name":"$previous","kind":13,"containerName":"frac_identical"},{"line":325,"name":"$value","containerName":"frac_identical","kind":13},{"line":325,"kind":13,"containerName":"frac_identical","name":"$previous"},{"line":325,"name":"$value","kind":13,"containerName":"frac_identical"},{"line":326,"kind":13,"containerName":"frac_identical","name":"$type"},{"name":"$type","containerName":"frac_identical","kind":13,"line":326},{"name":"$self","containerName":"frac_identical","kind":13,"line":327},{"name":"$type","kind":13,"containerName":"frac_identical","line":327},{"line":327,"name":"frac_identical","kind":12,"containerName":"frac_identical"},{"name":"$value","kind":13,"containerName":"frac_identical","line":327},{"line":329,"name":"$self","kind":13,"containerName":"frac_identical"},{"kind":13,"containerName":"frac_identical","name":"$type","line":329},{"line":329,"name":"$value","kind":13,"containerName":"frac_identical"},{"line":331,"name":"$previous","containerName":"frac_identical","kind":13}],"name":"frac_identical","containerName":"main::","definition":"sub","detail":"($self,$type,$value)","line":311,"range":{"end":{"character":9999,"line":333},"start":{"line":311,"character":0}},"kind":12,"signature":{"label":"frac_identical($self,$type,$value)","documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$value"}]}},{"line":314,"name":"_did_prefrac","kind":12},{"definition":"sub","detail":"($self,$type,$value)","children":[{"line":354,"name":"$self","localvar":"my","containerName":"frac_conserved","kind":13,"definition":"my"},{"containerName":"frac_conserved","kind":13,"name":"$type","line":354},{"line":354,"name":"$value","containerName":"frac_conserved","kind":13},{"kind":13,"containerName":"frac_conserved","name":"$self","line":356},{"line":357,"kind":13,"containerName":"frac_conserved","name":"$self"},{"kind":12,"containerName":"frac_conserved","name":"_pre_frac","line":357},{"line":360,"name":"$type","kind":13,"containerName":"frac_conserved"},{"kind":13,"containerName":"frac_conserved","name":"$type","line":360},{"line":360,"containerName":"frac_conserved","kind":13,"name":"$type"},{"line":361,"kind":13,"containerName":"frac_conserved","name":"$type"},{"line":361,"name":"$type","containerName":"frac_conserved","kind":13},{"line":361,"name":"$type","containerName":"frac_conserved","kind":13},{"kind":13,"containerName":"frac_conserved","name":"$type","line":362},{"kind":13,"containerName":"frac_conserved","name":"$type","line":362},{"name":"$type","containerName":"frac_conserved","kind":13,"line":362},{"line":363,"name":"$type","containerName":"frac_conserved","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"frac_conserved","name":"$previous","line":364},{"line":364,"kind":13,"containerName":"frac_conserved","name":"$self"},{"line":364,"name":"$type","containerName":"frac_conserved","kind":13},{"name":"$value","containerName":"frac_conserved","kind":13,"line":365},{"name":"$previous","kind":13,"containerName":"frac_conserved","line":365},{"kind":13,"containerName":"frac_conserved","name":"$value","line":366},{"name":"$previous","kind":13,"containerName":"frac_conserved","line":366},{"kind":13,"containerName":"frac_conserved","name":"$value","line":366},{"name":"$self","containerName":"frac_conserved","kind":13,"line":367},{"kind":13,"containerName":"frac_conserved","name":"$type","line":367},{"line":367,"kind":13,"containerName":"frac_conserved","name":"$value"},{"line":369,"name":"$previous","kind":13,"containerName":"frac_conserved"}],"name":"frac_conserved","containerName":"main::","signature":{"label":"frac_conserved($self,$type,$value)","documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$value"}]},"line":353,"kind":12,"range":{"start":{"line":353,"character":0},"end":{"line":370,"character":9999}}},{"name":"_did_prefrac","kind":12,"line":356},{"signature":{"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$value"}],"label":"gaps($self,$type,$value)"},"line":386,"kind":12,"range":{"end":{"character":9999,"line":403},"start":{"line":386,"character":0}},"definition":"sub","detail":"($self,$type,$value)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"gaps","line":387,"definition":"my"},{"containerName":"gaps","kind":13,"name":"$type","line":387},{"line":387,"name":"$value","containerName":"gaps","kind":13},{"containerName":"gaps","kind":13,"name":"$self","line":389},{"line":390,"kind":13,"containerName":"gaps","name":"$self"},{"name":"_pre_gaps","kind":12,"containerName":"gaps","line":390},{"containerName":"gaps","kind":13,"name":"$type","line":393},{"line":393,"name":"$type","kind":13,"containerName":"gaps"},{"containerName":"gaps","kind":13,"name":"$type","line":393},{"containerName":"gaps","kind":13,"name":"$type","line":394},{"line":394,"name":"$type","kind":13,"containerName":"gaps"},{"line":394,"kind":13,"containerName":"gaps","name":"$type"},{"line":395,"name":"$type","kind":13,"containerName":"gaps"},{"line":396,"name":"$type","containerName":"gaps","kind":13},{"containerName":"gaps","kind":13,"name":"$type","line":396},{"definition":"my","line":397,"localvar":"my","containerName":"gaps","kind":13,"name":"$previous"},{"kind":13,"containerName":"gaps","name":"$self","line":397},{"line":397,"kind":13,"containerName":"gaps","name":"$type"},{"line":398,"name":"$value","containerName":"gaps","kind":13},{"name":"$previous","containerName":"gaps","kind":13,"line":398},{"line":399,"name":"$value","containerName":"gaps","kind":13},{"line":399,"name":"$previous","containerName":"gaps","kind":13},{"kind":13,"containerName":"gaps","name":"$value","line":399},{"containerName":"gaps","kind":13,"name":"$self","line":400},{"line":400,"name":"$type","containerName":"gaps","kind":13},{"line":400,"name":"$value","containerName":"gaps","kind":13},{"line":402,"name":"$previous","containerName":"gaps","kind":13}],"name":"gaps","containerName":"main::"},{"line":389,"kind":12,"name":"_did_pregaps"},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence","label":"query_string($self,$value)"},"range":{"end":{"character":9999,"line":427},"start":{"line":416,"character":0}},"kind":12,"line":416,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"query_string","children":[{"line":417,"localvar":"my","containerName":"query_string","kind":13,"name":"$self","definition":"my"},{"containerName":"query_string","kind":13,"name":"$value","line":417},{"definition":"my","name":"$previous","containerName":"query_string","localvar":"my","kind":13,"line":418},{"name":"$self","containerName":"query_string","kind":13,"line":418},{"line":419,"name":"$value","containerName":"query_string","kind":13},{"line":419,"name":"$previous","kind":13,"containerName":"query_string"},{"kind":13,"containerName":"query_string","name":"$value","line":420},{"line":420,"kind":13,"containerName":"query_string","name":"$previous"},{"name":"$value","containerName":"query_string","kind":13,"line":420},{"line":421,"kind":13,"containerName":"query_string","name":"$self"},{"name":"$value","kind":13,"containerName":"query_string","line":421},{"line":424,"kind":13,"containerName":"query_string","name":"$self"},{"name":"$previous","kind":13,"containerName":"query_string","line":426}]},{"name":"QUERY_SEQ","kind":12,"line":418},{"line":421,"kind":12,"name":"QUERY_SEQ"},{"signature":{"label":"hit_string($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence"},"range":{"end":{"character":9999,"line":451},"start":{"line":440,"character":0}},"kind":12,"line":440,"detail":"($self,$value)","definition":"sub","name":"hit_string","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"hit_string","kind":13,"name":"$self","line":441},{"name":"$value","kind":13,"containerName":"hit_string","line":441},{"definition":"my","name":"$previous","localvar":"my","kind":13,"containerName":"hit_string","line":442},{"line":442,"name":"$self","containerName":"hit_string","kind":13},{"name":"$value","containerName":"hit_string","kind":13,"line":443},{"containerName":"hit_string","kind":13,"name":"$previous","line":443},{"kind":13,"containerName":"hit_string","name":"$value","line":444},{"kind":13,"containerName":"hit_string","name":"$previous","line":444},{"line":444,"kind":13,"containerName":"hit_string","name":"$value"},{"line":445,"containerName":"hit_string","kind":13,"name":"$self"},{"line":445,"kind":13,"containerName":"hit_string","name":"$value"},{"containerName":"hit_string","kind":13,"name":"$self","line":448},{"line":450,"name":"$previous","containerName":"hit_string","kind":13}]},{"kind":12,"name":"HIT_SEQ","line":442},{"name":"HIT_SEQ","kind":12,"line":445},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"homology_string","children":[{"definition":"my","line":467,"kind":13,"localvar":"my","containerName":"homology_string","name":"$self"},{"line":467,"containerName":"homology_string","kind":13,"name":"$value"},{"localvar":"my","containerName":"homology_string","kind":13,"name":"$previous","line":468,"definition":"my"},{"line":468,"name":"$self","kind":13,"containerName":"homology_string"},{"line":469,"containerName":"homology_string","kind":13,"name":"$value"},{"containerName":"homology_string","kind":13,"name":"$previous","line":469},{"line":470,"name":"$value","kind":13,"containerName":"homology_string"},{"name":"$previous","kind":13,"containerName":"homology_string","line":470},{"name":"$value","kind":13,"containerName":"homology_string","line":470},{"line":471,"name":"$self","containerName":"homology_string","kind":13},{"line":471,"kind":13,"containerName":"homology_string","name":"$value"},{"name":"$self","containerName":"homology_string","kind":13,"line":474},{"kind":13,"containerName":"homology_string","name":"$previous","line":476}],"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n\nsub hit_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HIT_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HIT_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence","label":"homology_string($self,$value)"},"kind":12,"range":{"start":{"line":466,"character":0},"end":{"line":477,"character":9999}},"line":466},{"line":468,"name":"HOMOLOGY_SEQ","kind":12},{"name":"HOMOLOGY_SEQ","kind":12,"line":471},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"length","line":498,"definition":"my"},{"definition":"my","name":"$type","containerName":"length","localvar":"my","kind":13,"line":499},{"line":501,"name":"$type","containerName":"length","kind":13},{"kind":13,"containerName":"length","name":"$type","line":501},{"line":502,"name":"$type","containerName":"length","kind":13},{"line":502,"containerName":"length","kind":13,"name":"$type"},{"line":504,"name":"$type","containerName":"length","kind":13},{"line":505,"name":"$self","kind":13,"containerName":"length"},{"kind":12,"containerName":"length","name":"query","line":505},{"name":"length","kind":12,"containerName":"length","line":505},{"line":506,"kind":13,"containerName":"length","name":"$type"},{"line":507,"name":"$self","kind":13,"containerName":"length"},{"containerName":"length","kind":12,"name":"hit","line":507},{"line":507,"containerName":"length","kind":12,"name":"length"},{"name":"$v","kind":13,"localvar":"my","containerName":"length","line":509,"definition":"my"},{"line":510,"kind":13,"containerName":"length","name":"$v"},{"name":"$self","containerName":"length","kind":13,"line":511},{"name":"$v","containerName":"length","kind":13,"line":511},{"line":513,"name":"$self","kind":13,"containerName":"length"}],"name":"length","containerName":"main::","definition":"sub","line":496,"kind":12,"range":{"end":{"line":516,"character":9999},"start":{"character":0,"line":496}}},{"line":511,"kind":12,"name":"HSP_LENGTH"},{"line":513,"kind":12,"name":"HSP_LENGTH"},{"kind":12,"range":{"start":{"line":528,"character":0},"end":{"character":9999,"line":528}},"line":528,"containerName":"main::","name":"hsp_length","children":[{"name":"length","containerName":"hsp_length","kind":12,"line":528}],"definition":"sub"},{"name":"percent_identity","containerName":"main::","children":[{"definition":"my","line":542,"name":"$self","localvar":"my","kind":13,"containerName":"percent_identity"},{"name":"$self","kind":13,"containerName":"percent_identity","line":544},{"name":"$self","containerName":"percent_identity","kind":13,"line":545},{"containerName":"percent_identity","kind":12,"name":"_pre_pi","line":545},{"name":"$self","kind":13,"containerName":"percent_identity","line":548}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":541},"end":{"character":9999,"line":549}},"line":541},{"line":544,"kind":12,"name":"_did_prepi"},{"line":548,"kind":12,"containerName":"percent_identity","name":"SUPER"},{"range":{"start":{"line":581,"character":0},"end":{"line":613,"character":9999}},"kind":12,"line":581,"definition":"sub","containerName":"main::","name":"frame","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"frame","name":"$self","line":582},{"name":"$val","kind":13,"localvar":"my","containerName":"frame","line":583,"definition":"my"},{"name":"$val","containerName":"frame","kind":13,"line":584},{"line":586,"containerName":"frame","kind":13,"name":"$self"},{"line":586,"name":"warn","containerName":"frame","kind":12},{"kind":13,"containerName":"frame","name":"$val","line":589},{"line":591,"containerName":"frame","kind":13,"name":"$val"},{"line":593,"name":"$val","kind":13,"containerName":"frame"},{"containerName":"frame","kind":13,"name":"$self","line":594},{"line":594,"kind":12,"containerName":"frame","name":"query"},{"line":594,"name":"frame","kind":12,"containerName":"frame"},{"line":595,"kind":13,"containerName":"frame","name":"$val"},{"name":"$self","kind":13,"containerName":"frame","line":596},{"line":596,"name":"hit","kind":12,"containerName":"frame"},{"line":596,"kind":12,"containerName":"frame","name":"frame"},{"line":597,"name":"$val","kind":13,"containerName":"frame"},{"name":"$self","containerName":"frame","kind":13,"line":598},{"containerName":"frame","kind":12,"name":"query","line":598},{"name":"frame","containerName":"frame","kind":12,"line":598},{"line":599,"kind":13,"containerName":"frame","name":"$self"},{"line":599,"kind":12,"containerName":"frame","name":"hit"},{"kind":12,"containerName":"frame","name":"frame","line":599},{"containerName":"frame","kind":13,"name":"$val","line":600},{"line":603,"name":"$self","containerName":"frame","kind":13},{"kind":12,"containerName":"frame","name":"warn","line":603},{"line":606,"containerName":"frame","kind":13,"name":"$self"},{"line":606,"name":"query","kind":12,"containerName":"frame"},{"name":"frame","kind":12,"containerName":"frame","line":606},{"line":606,"containerName":"frame","kind":13,"name":"$val"},{"kind":13,"containerName":"frame","name":"$self","line":607},{"line":607,"kind":12,"containerName":"frame","name":"hit"},{"line":607,"containerName":"frame","kind":12,"name":"frame"},{"name":"$self","kind":13,"containerName":"frame","line":608},{"line":608,"containerName":"frame","kind":12,"name":"hit"},{"line":608,"kind":12,"containerName":"frame","name":"frame"},{"line":608,"kind":13,"containerName":"frame","name":"$val"},{"kind":13,"containerName":"frame","name":"$self","line":610},{"line":610,"name":"warn","containerName":"frame","kind":12}]},{"detail":"($self)","definition":"sub","name":"get_aln","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"get_aln","name":"$self","line":626,"definition":"my"},{"localvar":"my","containerName":"get_aln","kind":13,"name":"$aln","line":629,"definition":"my"},{"line":629,"name":"new","containerName":"get_aln","kind":12},{"definition":"my","kind":13,"localvar":"my","containerName":"get_aln","name":"$hs","line":630},{"line":630,"kind":13,"containerName":"get_aln","name":"$self"},{"name":"hit_string","kind":12,"containerName":"get_aln","line":630},{"kind":13,"localvar":"my","containerName":"get_aln","name":"$qs","line":631,"definition":"my"},{"name":"$self","kind":13,"containerName":"get_aln","line":631},{"name":"query_string","containerName":"get_aln","kind":12,"line":631},{"definition":"my","kind":13,"localvar":"my","containerName":"get_aln","name":"$seqonly","line":633},{"kind":13,"containerName":"get_aln","name":"$qs","line":633},{"name":"$seqonly","kind":13,"containerName":"get_aln","line":634},{"line":635,"localvar":"my","containerName":"get_aln","kind":13,"name":"$q_nm","definition":"my"},{"name":"$s_nm","containerName":"get_aln","kind":13,"line":635},{"name":"$self","kind":13,"containerName":"get_aln","line":635},{"line":635,"name":"query","kind":12,"containerName":"get_aln"},{"line":635,"containerName":"get_aln","kind":12,"name":"seq_id"},{"line":636,"kind":13,"containerName":"get_aln","name":"$self"},{"line":636,"kind":12,"containerName":"get_aln","name":"hit"},{"line":636,"name":"seq_id","containerName":"get_aln","kind":12},{"definition":"my","name":"$query","containerName":"get_aln","localvar":"my","kind":13,"line":648},{"kind":12,"containerName":"get_aln","name":"new","line":648},{"line":648,"containerName":"get_aln","kind":13,"name":"$qs"},{"name":"$q_nm","containerName":"get_aln","kind":13,"line":649},{"containerName":"get_aln","kind":13,"name":"$self","line":650},{"name":"query","kind":12,"containerName":"get_aln","line":650},{"name":"start","kind":12,"containerName":"get_aln","line":650},{"kind":13,"containerName":"get_aln","name":"$self","line":651},{"line":651,"name":"query","kind":12,"containerName":"get_aln"},{"name":"end","containerName":"get_aln","kind":12,"line":651},{"line":652,"name":"$q_nm","kind":13,"containerName":"get_aln"},{"containerName":"get_aln","kind":13,"name":"$self","line":653},{"line":655,"kind":13,"containerName":"get_aln","name":"$seqonly"},{"line":655,"containerName":"get_aln","kind":13,"name":"$hs"},{"line":656,"containerName":"get_aln","kind":13,"name":"$seqonly"},{"definition":"my","line":657,"name":"$hit","localvar":"my","kind":13,"containerName":"get_aln"},{"line":657,"kind":12,"containerName":"get_aln","name":"new"},{"line":657,"name":"$hs","kind":13,"containerName":"get_aln"},{"line":658,"name":"$s_nm","kind":13,"containerName":"get_aln"},{"line":659,"containerName":"get_aln","kind":13,"name":"$self"},{"containerName":"get_aln","kind":12,"name":"hit","line":659},{"line":659,"kind":12,"containerName":"get_aln","name":"start"},{"containerName":"get_aln","kind":13,"name":"$self","line":660},{"line":660,"kind":12,"containerName":"get_aln","name":"hit"},{"containerName":"get_aln","kind":12,"name":"end","line":660},{"name":"$s_nm","kind":13,"containerName":"get_aln","line":661},{"line":662,"name":"$self","kind":13,"containerName":"get_aln"},{"line":664,"containerName":"get_aln","kind":13,"name":"$aln"},{"name":"add_seq","containerName":"get_aln","kind":12,"line":664},{"line":664,"name":"$query","containerName":"get_aln","kind":13},{"name":"$aln","kind":13,"containerName":"get_aln","line":665},{"line":665,"name":"add_seq","kind":12,"containerName":"get_aln"},{"line":665,"containerName":"get_aln","kind":13,"name":"$hit"},{"line":666,"kind":13,"containerName":"get_aln","name":"$aln"}],"signature":{"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n\nsub hit_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HIT_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HIT_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence\n\n\nsub homology_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HOMOLOGY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HOMOLOGY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment\n            (without gaps)\n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : arg 1: 'query' = length of query seq (without gaps)\n                   'hit'   = length of hit seq (without gaps) (synonyms: sbjct, subject)\n                   'total' = length of alignment (with gaps)\n                   default = 'total'\n            arg 2: [optional] integer length value to set for specific type\n\n\nsub length {\n\n    my $self = shift;\n    my $type = shift;\n\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if( $type =~ /^q/i ) {\n        return $self->query()->length(shift);\n    } elsif( $type =~ /^(hit|subject|sbjct)/ ) {\n        return $self->hit()->length(shift);\n    } else {\n        my $v = shift;\n        if( defined $v ) {\n            $self->{HSP_LENGTH} = $v;\n        }\n        return $self->{HSP_LENGTH};\n   }\n    return 0; # should never get here\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100\n Args    : none\n\n\nsub hsp_length { return shift->length('hsp', shift); }\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100\n Args    : none\n\n\n\nsub percent_identity {\n    my $self = shift;\n\n    unless ($self->{_did_prepi}) {\n        $self->_pre_pi;\n    }\n\n    return $self->SUPER::percent_identity(@_);\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : my ($qframe, $hframe) = $hsp->frame('list',$queryframe,$subjectframe)\n Function: Set the Frame for both query and subject and insure that\n           they agree.\n           This overrides the frame() method implementation in\n           FeaturePair.\n Returns : array of query and subject frame if return type wants an array\n           or query frame if defined or subject frame if not defined\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the frame of the subject (default)\n           'query' to retrieve the query frame \n           'list' or 'array' to retrieve both query and hit frames together\n Note    : Frames are stored in the GFF way (0-2) not 1-3\n           as they are in BLAST (negative frames are deduced by checking\n                                 the strand of the query or hit)\n\n\n# Note: changed 4/19/08 - bug 2485\n#\n# frame() is supposed to be a getter/setter (as is implied by the Function desc\n# above; this is also consistent with Bio::SeqFeature::SimilarityPair).  Also,\n# the API is not consistent with the other HSP/SimilarityPair methods such as\n# strand(), start(), end(), etc. \n#\n# In order to make this consistent with other methods all work is now done\n# when the features are instantiated and not delayed.  We compromise by\n# defaulting back 'to hit' w/o passed args.  Setting is now allowed.  \n\nsub frame {\n    my $self = shift;\n    my $val = shift;\n    if (!defined $val) {\n        # unfortunately, w/o args we need to warn about API changes\n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP;\\n\".\n                    \"returning query frame\");\n        $val = 'query';\n    }\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n        return $self->query->frame(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n        return $self->hit->frame(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n        return ($self->query->frame($_[0]), \n            $self->hit->frame($_[1]) );\n    } elsif ( $val =~ /^\\d+$/) {\n        # old API i.e. frame($query_frame, $hit_frame). This catches all but one\n        # case, where no arg is passed (so the hit is wanted).  \n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP\");\n        wantarray ? \n        return ($self->query->frame($val), \n            $self->hit->frame(@_) ) :\n        return $self->hit->frame($val,@_);\n    } else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->gel_aln\n Function: Returns a L<Bio::SimpleAlign> object representing the HSP alignment\n Returns : L<Bio::SimpleAlign>\n Args    : none","parameters":[{"label":"$self"}],"label":"get_aln($self)"},"range":{"start":{"line":625,"character":0},"end":{"line":667,"character":9999}},"kind":12,"line":625},{"line":629,"containerName":"LocatableSeq::Bio::SimpleAlign","kind":12,"name":"Bio"},{"kind":12,"containerName":"SimpleAlign","name":"Bio","line":629},{"name":"Bio","kind":12,"containerName":"LocatableSeq","line":648},{"line":653,"kind":12,"name":"_query_mapping"},{"line":657,"name":"Bio","kind":12,"containerName":"LocatableSeq"},{"line":662,"name":"_hit_mapping","kind":12},{"range":{"end":{"line":691,"character":9999},"start":{"character":0,"line":680}},"kind":12,"line":680,"signature":{"label":"num_conserved($self,$value)","documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n\nsub hit_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HIT_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HIT_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence\n\n\nsub homology_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HOMOLOGY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HOMOLOGY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment\n            (without gaps)\n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : arg 1: 'query' = length of query seq (without gaps)\n                   'hit'   = length of hit seq (without gaps) (synonyms: sbjct, subject)\n                   'total' = length of alignment (with gaps)\n                   default = 'total'\n            arg 2: [optional] integer length value to set for specific type\n\n\nsub length {\n\n    my $self = shift;\n    my $type = shift;\n\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if( $type =~ /^q/i ) {\n        return $self->query()->length(shift);\n    } elsif( $type =~ /^(hit|subject|sbjct)/ ) {\n        return $self->hit()->length(shift);\n    } else {\n        my $v = shift;\n        if( defined $v ) {\n            $self->{HSP_LENGTH} = $v;\n        }\n        return $self->{HSP_LENGTH};\n   }\n    return 0; # should never get here\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100\n Args    : none\n\n\nsub hsp_length { return shift->length('hsp', shift); }\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100\n Args    : none\n\n\n\nsub percent_identity {\n    my $self = shift;\n\n    unless ($self->{_did_prepi}) {\n        $self->_pre_pi;\n    }\n\n    return $self->SUPER::percent_identity(@_);\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : my ($qframe, $hframe) = $hsp->frame('list',$queryframe,$subjectframe)\n Function: Set the Frame for both query and subject and insure that\n           they agree.\n           This overrides the frame() method implementation in\n           FeaturePair.\n Returns : array of query and subject frame if return type wants an array\n           or query frame if defined or subject frame if not defined\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the frame of the subject (default)\n           'query' to retrieve the query frame \n           'list' or 'array' to retrieve both query and hit frames together\n Note    : Frames are stored in the GFF way (0-2) not 1-3\n           as they are in BLAST (negative frames are deduced by checking\n                                 the strand of the query or hit)\n\n\n# Note: changed 4/19/08 - bug 2485\n#\n# frame() is supposed to be a getter/setter (as is implied by the Function desc\n# above; this is also consistent with Bio::SeqFeature::SimilarityPair).  Also,\n# the API is not consistent with the other HSP/SimilarityPair methods such as\n# strand(), start(), end(), etc. \n#\n# In order to make this consistent with other methods all work is now done\n# when the features are instantiated and not delayed.  We compromise by\n# defaulting back 'to hit' w/o passed args.  Setting is now allowed.  \n\nsub frame {\n    my $self = shift;\n    my $val = shift;\n    if (!defined $val) {\n        # unfortunately, w/o args we need to warn about API changes\n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP;\\n\".\n                    \"returning query frame\");\n        $val = 'query';\n    }\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n        return $self->query->frame(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n        return $self->hit->frame(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n        return ($self->query->frame($_[0]), \n            $self->hit->frame($_[1]) );\n    } elsif ( $val =~ /^\\d+$/) {\n        # old API i.e. frame($query_frame, $hit_frame). This catches all but one\n        # case, where no arg is passed (so the hit is wanted).  \n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP\");\n        wantarray ? \n        return ($self->query->frame($val), \n            $self->hit->frame(@_) ) :\n        return $self->hit->frame($val,@_);\n    } else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->gel_aln\n Function: Returns a L<Bio::SimpleAlign> object representing the HSP alignment\n Returns : L<Bio::SimpleAlign>\n Args    : none\n\n\nsub get_aln {\n    my ($self) = @_;\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->hit_string();\n    my $qs = $self->query_string();\n    # FASTA specific stuff moved to the FastaHSP object\n    my $seqonly = $qs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my ($q_nm,$s_nm) = ($self->query->seq_id(),\n                        $self->hit->seq_id());\n    # Should we silently change the name of the query or hit if it isn't\n    # defined?  May need revisiting... cjfields 2008-12-3 (commented out below)\n    \n    #unless( defined $q_nm && CORE::length ($q_nm) ) {\n    #    $q_nm = 'query';\n    #}\n    #unless( defined $s_nm && CORE::length ($s_nm) ) {\n    #    $s_nm = 'hit';\n    #}\n    \n    # mapping: 1 residues for every x coordinate positions\n    my $query = Bio::LocatableSeq->new('-seq'   => $qs,\n                                      '-id'    => $q_nm,\n                                      '-start' => $self->query->start,\n                                      '-end'   => $self->query->end,\n                                      '-force_nse' => $q_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_query_mapping}]\n                                      );\n    $seqonly = $hs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my $hit =  Bio::LocatableSeq->new('-seq'    => $hs,\n                                      '-id'    => $s_nm,\n                                      '-start' => $self->hit->start,\n                                      '-end'   => $self->hit->end,\n                                      '-force_nse' => $s_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_hit_mapping}]\n                                      );\n    $aln->add_seq($query);\n    $aln->add_seq($hit);\n    return $aln;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : integer\n Args    : integer (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"name":"num_conserved","containerName":"main::","children":[{"containerName":"num_conserved","localvar":"my","kind":13,"name":"$self","line":681,"definition":"my"},{"name":"$value","containerName":"num_conserved","kind":13,"line":681},{"name":"$self","kind":13,"containerName":"num_conserved","line":683},{"line":684,"name":"$self","kind":13,"containerName":"num_conserved"},{"line":684,"name":"_pre_similar_stats","kind":12,"containerName":"num_conserved"},{"line":687,"name":"$value","containerName":"num_conserved","kind":13},{"line":688,"name":"$self","kind":13,"containerName":"num_conserved"},{"kind":13,"containerName":"num_conserved","name":"$value","line":688},{"name":"$self","kind":13,"containerName":"num_conserved","line":690}],"detail":"($self,$value)","definition":"sub"},{"line":683,"name":"_did_presimilar","kind":12},{"name":"CONSERVED","kind":12,"line":688},{"line":690,"kind":12,"name":"CONSERVED"},{"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"num_identical","kind":13,"line":705},{"line":705,"name":"$value","kind":13,"containerName":"num_identical"},{"line":707,"containerName":"num_identical","kind":13,"name":"$self"},{"line":708,"name":"$self","containerName":"num_identical","kind":13},{"kind":12,"containerName":"num_identical","name":"_pre_similar_stats","line":708},{"line":711,"kind":13,"containerName":"num_identical","name":"$value"},{"line":712,"kind":13,"containerName":"num_identical","name":"$self"},{"line":712,"name":"$value","containerName":"num_identical","kind":13},{"containerName":"num_identical","kind":13,"name":"$self","line":714}],"containerName":"main::","name":"num_identical","definition":"sub","detail":"($self,$value)","line":704,"kind":12,"range":{"end":{"character":9999,"line":715},"start":{"line":704,"character":0}},"signature":{"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n\nsub hit_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HIT_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HIT_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence\n\n\nsub homology_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HOMOLOGY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HOMOLOGY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment\n            (without gaps)\n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : arg 1: 'query' = length of query seq (without gaps)\n                   'hit'   = length of hit seq (without gaps) (synonyms: sbjct, subject)\n                   'total' = length of alignment (with gaps)\n                   default = 'total'\n            arg 2: [optional] integer length value to set for specific type\n\n\nsub length {\n\n    my $self = shift;\n    my $type = shift;\n\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if( $type =~ /^q/i ) {\n        return $self->query()->length(shift);\n    } elsif( $type =~ /^(hit|subject|sbjct)/ ) {\n        return $self->hit()->length(shift);\n    } else {\n        my $v = shift;\n        if( defined $v ) {\n            $self->{HSP_LENGTH} = $v;\n        }\n        return $self->{HSP_LENGTH};\n   }\n    return 0; # should never get here\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100\n Args    : none\n\n\nsub hsp_length { return shift->length('hsp', shift); }\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100\n Args    : none\n\n\n\nsub percent_identity {\n    my $self = shift;\n\n    unless ($self->{_did_prepi}) {\n        $self->_pre_pi;\n    }\n\n    return $self->SUPER::percent_identity(@_);\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : my ($qframe, $hframe) = $hsp->frame('list',$queryframe,$subjectframe)\n Function: Set the Frame for both query and subject and insure that\n           they agree.\n           This overrides the frame() method implementation in\n           FeaturePair.\n Returns : array of query and subject frame if return type wants an array\n           or query frame if defined or subject frame if not defined\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the frame of the subject (default)\n           'query' to retrieve the query frame \n           'list' or 'array' to retrieve both query and hit frames together\n Note    : Frames are stored in the GFF way (0-2) not 1-3\n           as they are in BLAST (negative frames are deduced by checking\n                                 the strand of the query or hit)\n\n\n# Note: changed 4/19/08 - bug 2485\n#\n# frame() is supposed to be a getter/setter (as is implied by the Function desc\n# above; this is also consistent with Bio::SeqFeature::SimilarityPair).  Also,\n# the API is not consistent with the other HSP/SimilarityPair methods such as\n# strand(), start(), end(), etc. \n#\n# In order to make this consistent with other methods all work is now done\n# when the features are instantiated and not delayed.  We compromise by\n# defaulting back 'to hit' w/o passed args.  Setting is now allowed.  \n\nsub frame {\n    my $self = shift;\n    my $val = shift;\n    if (!defined $val) {\n        # unfortunately, w/o args we need to warn about API changes\n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP;\\n\".\n                    \"returning query frame\");\n        $val = 'query';\n    }\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n        return $self->query->frame(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n        return $self->hit->frame(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n        return ($self->query->frame($_[0]), \n            $self->hit->frame($_[1]) );\n    } elsif ( $val =~ /^\\d+$/) {\n        # old API i.e. frame($query_frame, $hit_frame). This catches all but one\n        # case, where no arg is passed (so the hit is wanted).  \n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP\");\n        wantarray ? \n        return ($self->query->frame($val), \n            $self->hit->frame(@_) ) :\n        return $self->hit->frame($val,@_);\n    } else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->gel_aln\n Function: Returns a L<Bio::SimpleAlign> object representing the HSP alignment\n Returns : L<Bio::SimpleAlign>\n Args    : none\n\n\nsub get_aln {\n    my ($self) = @_;\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->hit_string();\n    my $qs = $self->query_string();\n    # FASTA specific stuff moved to the FastaHSP object\n    my $seqonly = $qs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my ($q_nm,$s_nm) = ($self->query->seq_id(),\n                        $self->hit->seq_id());\n    # Should we silently change the name of the query or hit if it isn't\n    # defined?  May need revisiting... cjfields 2008-12-3 (commented out below)\n    \n    #unless( defined $q_nm && CORE::length ($q_nm) ) {\n    #    $q_nm = 'query';\n    #}\n    #unless( defined $s_nm && CORE::length ($s_nm) ) {\n    #    $s_nm = 'hit';\n    #}\n    \n    # mapping: 1 residues for every x coordinate positions\n    my $query = Bio::LocatableSeq->new('-seq'   => $qs,\n                                      '-id'    => $q_nm,\n                                      '-start' => $self->query->start,\n                                      '-end'   => $self->query->end,\n                                      '-force_nse' => $q_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_query_mapping}]\n                                      );\n    $seqonly = $hs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my $hit =  Bio::LocatableSeq->new('-seq'    => $hs,\n                                      '-id'    => $s_nm,\n                                      '-start' => $self->hit->start,\n                                      '-end'   => $self->hit->end,\n                                      '-force_nse' => $s_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_hit_mapping}]\n                                      );\n    $aln->add_seq($query);\n    $aln->add_seq($hit);\n    return $aln;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    my ($self,$value) = @_;\n\n    unless ($self->{_did_presimilar}) {\n        $self->_pre_similar_stats;\n    }\n\n    if (defined $value) {\n        $self->{CONSERVED} = $value;\n    }\n    return $self->{CONSERVED};\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"num_identical($self,$value)"}},{"line":707,"name":"_did_presimilar","kind":12},{"name":"IDENTICAL","kind":12,"line":712},{"kind":12,"name":"IDENTICAL","line":714},{"detail":"($self,$value)","definition":"sub","name":"rank","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"rank","line":728},{"kind":13,"containerName":"rank","name":"$value","line":728},{"line":729,"containerName":"rank","kind":13,"name":"$value"},{"line":730,"kind":13,"containerName":"rank","name":"$self"},{"line":730,"name":"$value","containerName":"rank","kind":13},{"name":"$self","kind":13,"containerName":"rank","line":732}],"signature":{"label":"rank($self,$value)","documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n\nsub hit_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HIT_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HIT_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence\n\n\nsub homology_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HOMOLOGY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HOMOLOGY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment\n            (without gaps)\n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : arg 1: 'query' = length of query seq (without gaps)\n                   'hit'   = length of hit seq (without gaps) (synonyms: sbjct, subject)\n                   'total' = length of alignment (with gaps)\n                   default = 'total'\n            arg 2: [optional] integer length value to set for specific type\n\n\nsub length {\n\n    my $self = shift;\n    my $type = shift;\n\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if( $type =~ /^q/i ) {\n        return $self->query()->length(shift);\n    } elsif( $type =~ /^(hit|subject|sbjct)/ ) {\n        return $self->hit()->length(shift);\n    } else {\n        my $v = shift;\n        if( defined $v ) {\n            $self->{HSP_LENGTH} = $v;\n        }\n        return $self->{HSP_LENGTH};\n   }\n    return 0; # should never get here\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100\n Args    : none\n\n\nsub hsp_length { return shift->length('hsp', shift); }\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100\n Args    : none\n\n\n\nsub percent_identity {\n    my $self = shift;\n\n    unless ($self->{_did_prepi}) {\n        $self->_pre_pi;\n    }\n\n    return $self->SUPER::percent_identity(@_);\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : my ($qframe, $hframe) = $hsp->frame('list',$queryframe,$subjectframe)\n Function: Set the Frame for both query and subject and insure that\n           they agree.\n           This overrides the frame() method implementation in\n           FeaturePair.\n Returns : array of query and subject frame if return type wants an array\n           or query frame if defined or subject frame if not defined\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the frame of the subject (default)\n           'query' to retrieve the query frame \n           'list' or 'array' to retrieve both query and hit frames together\n Note    : Frames are stored in the GFF way (0-2) not 1-3\n           as they are in BLAST (negative frames are deduced by checking\n                                 the strand of the query or hit)\n\n\n# Note: changed 4/19/08 - bug 2485\n#\n# frame() is supposed to be a getter/setter (as is implied by the Function desc\n# above; this is also consistent with Bio::SeqFeature::SimilarityPair).  Also,\n# the API is not consistent with the other HSP/SimilarityPair methods such as\n# strand(), start(), end(), etc. \n#\n# In order to make this consistent with other methods all work is now done\n# when the features are instantiated and not delayed.  We compromise by\n# defaulting back 'to hit' w/o passed args.  Setting is now allowed.  \n\nsub frame {\n    my $self = shift;\n    my $val = shift;\n    if (!defined $val) {\n        # unfortunately, w/o args we need to warn about API changes\n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP;\\n\".\n                    \"returning query frame\");\n        $val = 'query';\n    }\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n        return $self->query->frame(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n        return $self->hit->frame(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n        return ($self->query->frame($_[0]), \n            $self->hit->frame($_[1]) );\n    } elsif ( $val =~ /^\\d+$/) {\n        # old API i.e. frame($query_frame, $hit_frame). This catches all but one\n        # case, where no arg is passed (so the hit is wanted).  \n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP\");\n        wantarray ? \n        return ($self->query->frame($val), \n            $self->hit->frame(@_) ) :\n        return $self->hit->frame($val,@_);\n    } else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->gel_aln\n Function: Returns a L<Bio::SimpleAlign> object representing the HSP alignment\n Returns : L<Bio::SimpleAlign>\n Args    : none\n\n\nsub get_aln {\n    my ($self) = @_;\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->hit_string();\n    my $qs = $self->query_string();\n    # FASTA specific stuff moved to the FastaHSP object\n    my $seqonly = $qs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my ($q_nm,$s_nm) = ($self->query->seq_id(),\n                        $self->hit->seq_id());\n    # Should we silently change the name of the query or hit if it isn't\n    # defined?  May need revisiting... cjfields 2008-12-3 (commented out below)\n    \n    #unless( defined $q_nm && CORE::length ($q_nm) ) {\n    #    $q_nm = 'query';\n    #}\n    #unless( defined $s_nm && CORE::length ($s_nm) ) {\n    #    $s_nm = 'hit';\n    #}\n    \n    # mapping: 1 residues for every x coordinate positions\n    my $query = Bio::LocatableSeq->new('-seq'   => $qs,\n                                      '-id'    => $q_nm,\n                                      '-start' => $self->query->start,\n                                      '-end'   => $self->query->end,\n                                      '-force_nse' => $q_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_query_mapping}]\n                                      );\n    $seqonly = $hs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my $hit =  Bio::LocatableSeq->new('-seq'    => $hs,\n                                      '-id'    => $s_nm,\n                                      '-start' => $self->hit->start,\n                                      '-end'   => $self->hit->end,\n                                      '-force_nse' => $s_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_hit_mapping}]\n                                      );\n    $aln->add_seq($query);\n    $aln->add_seq($hit);\n    return $aln;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    my ($self,$value) = @_;\n\n    unless ($self->{_did_presimilar}) {\n        $self->_pre_similar_stats;\n    }\n\n    if (defined $value) {\n        $self->{CONSERVED} = $value;\n    }\n    return $self->{CONSERVED};\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n   my ($self,$value) = @_;\n\n   unless ($self->{_did_presimilar}) {\n        $self->_pre_similar_stats;\n    }\n\n   if( defined $value) {\n       $self->{IDENTICAL} = $value;\n   }\n   return $self->{IDENTICAL};\n}\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"start":{"line":727,"character":0},"end":{"line":733,"character":9999}},"kind":12,"line":727},{"name":"RANK","kind":12,"line":730},{"name":"RANK","kind":12,"line":732},{"signature":{"documentation":"1;\n# $Id: GenericHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::GenericHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::GenericHSP - A \"Generic\" implementation of a High Scoring Pair\n\n=head1 SYNOPSIS\n\n    my $hsp = Bio::Search::HSP::GenericHSP->new( -algorithm => 'blastp',\n                                                -evalue    => '1e-30',\n                                                );\n\n    $r_type = $hsp->algorithm;\n\n    $pvalue = $hsp->p();\n\n    $evalue = $hsp->evalue();\n\n    $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n\n    $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n\n    $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n\n    $qseq = $hsp->query_string;\n\n    $hseq = $hsp->hit_string;\n\n    $homo_string = $hsp->homology_string;\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $len = $hsp->length( ['query'|'hit'|'total'] );\n\n    $rank = $hsp->rank;\n\n# TODO: Describe how to configure a SearchIO stream so that it generates\n#       GenericHSP objects.\n\n=head1 DESCRIPTION\n\nThis implementation is \"Generic\", meaning it is is suitable for\nholding information about High Scoring pairs from most Search reports\nsuch as BLAST and FastA.  Specialized objects can be derived from\nthis.\n\nUnless you're writing a parser, you won't ever need to create a\nGenericHSP or any other HSPI-implementing object. If you use\nthe SearchIO system, HSPI objects are created automatically from\na SearchIO stream which returns Bio::Search::Result::ResultI objects\nand you get the HSPI objects via the ResultI API.\n\nFor documentation on what you can do with GenericHSP (and other HSPI\nobjects), please see the API documentation in\nL<Bio::Search::HSP::HSPI|Bio::Search::HSP::HSPI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich and Steve Chervitz\n\nEmail jason-at-bioperl.org\nEmail sac-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::GenericHSP;\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Similarity;\n\nuse base qw(Bio::Search::HSP::HSPI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::GenericHSP->new();\n Function: Builds a new Bio::Search::HSP::GenericHSP object\n Returns : Bio::Search::HSP::GenericHSP\n Args    : -algorithm => algorithm used (BLASTP, TBLASTX, FASTX, etc)\n           -evalue    => evalue\n           -pvalue    => pvalue\n           -bits      => bit value for HSP\n           -score     => score value for HSP (typically z-score but depends on\n                                              analysis)\n           -hsp_length=> Length of the HSP (including gaps)\n           -identical => # of residues that that matched identically\n           -percent_identity => (optional) percent identity\n           -conserved => # of residues that matched conservatively\n                           (only protein comparisions;\n                            conserved == identical in nucleotide comparisons)\n           -hsp_gaps   => # of gaps in the HSP\n           -query_gaps => # of gaps in the query in the alignment\n           -hit_gaps   => # of gaps in the subject in the alignment\n           -query_name  => HSP Query sequence name (if available)\n           -query_start => HSP Query start (in original query sequence coords)\n           -query_end   => HSP Query end (in original query sequence coords)\n           -query_length=> total length of the query sequence\n           -query_seq   => query sequence portion of the HSP\n           -query_desc  => textual description of the query\n           -hit_name    => HSP Hit sequence name (if available)\n           -hit_start   => HSP Hit start (in original hit sequence coords)\n           -hit_end     => HSP Hit end (in original hit sequence coords)\n           -hit_length  => total length of the hit sequence\n           -hit_seq     => hit sequence portion of the HSP\n           -hit_desc    => textual description of the hit\n           -homology_seq=> homology sequence for the HSP\n           -hit_frame   => hit frame (only if hit is translated protein)\n           -query_frame => query frame (only if query is translated protein)\n           -rank        => HSP rank\n           -links       => HSP links information (WU-BLAST only)\n           -hsp_group   => HSP Group informat (WU-BLAST only)\n           -gap_symbol  => symbol representing a gap (default = '-')\n           -hit_features=> string of features found in or near HSP hit\n                           region (reported in some BLAST text output,\n                           v. 2.2.13 and up)\n           -stranded    => If the algorithm isn't known (i.e. defaults to\n                           'generic'), setting this will indicate start/end\n                           coordinates are to be used to determine the strand\n                           for 'query', 'subject', 'hit', 'both', or 'none'\n                           (default = 'none')\n\n\nsub new {\n    my($class,%args) = @_;\n\n    # don't pass anything to SUPER; complex hierarchy results in lots of work\n    # for nothing\n    \n    my $self = $class->SUPER::new();\n\n    # for speed, don't use _rearrange and just store all input data directly\n    # with no method calls and no work done. work can be carried\n    # out just-in-time later if desired\n    while (my ($arg, $value) = each %args) {\n        $arg =~ tr/a-z\\055/A-Z/d;\n        $self->{$arg} = $value;\n    }\n    my $bits = $self->{BITS};\n\n    defined $self->{VERBOSE} && $self->verbose($self->{VERBOSE});\n    if (exists $self->{GAP_SYMBOL}) {\n        # not checking anything else but the length (must be 1 as only one gap\n        # symbol allowed currently); can add in support for symbol checks or\n        # multiple symbols later if needed\n        $self->throw(\"Gap symbol must be of length 1\") if\n            CORE::length($self->{GAP_SYMBOL}) != 1;\n    } else {\n        # dafault\n        $self->{GAP_SYMBOL} = '-';\n    }\n    $self->{ALGORITHM} ||= 'GENERIC';\n    $self->{STRANDED} ||= 'NONE';\n    \n    if (! defined $self->{QUERY_LENGTH} || ! defined $self->{HIT_LENGTH}) {\n        $self->throw(\"Must define hit and query length\");\n    }\n\n    $self->{'_sequenceschanged'} = 1;\n    \n    $self->{_finished_new} = 1;\n    return $self;\n}\n\nsub _logical_length {\n    my ($self, $type) = @_;\n    my $algo = $self->algorithm;\n    my $len = $self->length($type);\n    my $logical = $len;\n    if($algo =~ /^(PSI)?T(BLAST|FAST)[NY]/oi ) {\n        $logical = $len/3 if $type =~ /sbjct|hit|tot/i;\n    } elsif($algo =~ /^(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3 if $type =~ /query|tot/i;\n    } elsif($algo =~ /^T(BLAST|FAST)(X|Y|XY)/oi ) {\n        $logical = $len/3;\n    }\n    return $logical;\n}\n\n=head2 L<Bio::Search::HSP::HSPI> methods\n\nImplementation of L<Bio::Search::HSP::HSPI> methods follow\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : [optional] scalar string to set value\n\n\nsub algorithm{\n    my ($self,$value) = @_;\n    my $previous = $self->{'ALGORITHM'};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'ALGORITHM'} = $value;\n    }\n\n    return $previous;\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef\n Returns : float or exponential (2e-10)\n           P-value is not defined with NCBI Blast2 reports.\n Args    : [optional] numeric to set value\n\n\nsub pvalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'PVALUE'};\n    if( defined $value  ) {\n        $self->{'PVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : [optional] numeric to set value\n\n\nsub evalue {\n    my ($self,$value) = @_;\n    my $previous = $self->{'EVALUE'};\n    if( defined $value  ) {\n        $self->{'EVALUE'} = $value;\n    }\n    return $previous;\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1:  'query' = num identical / length of query seq (without gaps)\n                   'hit'   = num identical / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                   'total' = num identical / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                   default = 'total'\n           arg 2: [optional] frac identical value to set for the type requested\n\n\nsub frac_identical {\n   my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n   $type = lc $type if defined $type;\n   $type = 'hit' if( defined $type &&\n\t\t     $type =~ /subject|sbjct/);\n   $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n   my $previous = $self->{'_frac_identical'}->{$type};\n   if( defined $value || ! defined $previous ) {\n       $value = $previous = '' unless defined $value;\n       if( $type eq 'hit' || $type eq 'query' ) {\n           $self->$type()->frac_identical( $value);\n       }\n       $self->{'_frac_identical'}->{$type} = $value;\n   }\n   return $previous;\n\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a\n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : arg 1: 'query' = num conserved / length of query seq (without gaps)\n                  'hit'   = num conserved / length of hit seq (without gaps)\n                             synonyms: 'sbjct', 'subject'\n                  'total' = num conserved / length of alignment (with gaps)\n                             synonyms: 'hsp'\n                  default = 'total'\n           arg 2: [optional] frac conserved value to set for the type requested\n\n\nsub frac_conserved {\n    my ($self, $type,$value) = @_;\n\n    unless ($self->{_did_prefrac}) {\n        $self->_pre_frac;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'hit' if( defined $type && $type =~ /subject|sbjct/);\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    my $previous = $self->{'_frac_conserved'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_frac_conserved'}->{$type} = $value;\n    }\n    return $previous;\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gaps or 0 if none\n Args     : arg 1: 'query' = num gap characters in query seq\n                   'hit'   = num gap characters in hit seq; synonyms: 'sbjct', 'subject'\n                   'total' = num gap characters in whole alignment;  synonyms: 'hsp'\n                   default = 'total'\n            arg 2: [optional] integer gap value to set for the type requested\n\n\nsub gaps {\n    my ($self, $type, $value) = @_;\n\n    unless ($self->{_did_pregaps}) {\n        $self->_pre_gaps;\n    }\n\n    $type = lc $type if defined $type;\n    $type = 'total' if( ! defined $type || $type eq 'hsp' ||\n                        $type !~ /query|hit|subject|sbjct|total/);\n    $type = 'hit' if $type =~ /sbjct|subject/;\n    my $previous = $self->{'_gaps'}->{$type};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{'_gaps'}->{$type} = $value;\n    }\n    return $previous || 0;\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for query sequence\n\n\n\nsub query_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{QUERY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{QUERY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : [optional] string to set for hit sequence\n\n\n\nsub hit_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HIT_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HIT_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the\n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : [optional] string to set for homology sequence\n\n\nsub homology_string{\n    my ($self,$value) = @_;\n    my $previous = $self->{HOMOLOGY_SEQ};\n    if( defined $value || ! defined $previous ) {\n        $value = $previous = '' unless defined $value;\n        $self->{HOMOLOGY_SEQ} = $value;\n        # do some housekeeping so we know when to\n        # re-run _calculate_seq_positions\n        $self->{'_sequenceschanged'} = 1;\n    }\n    return $previous;\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment\n            (without gaps)\n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : arg 1: 'query' = length of query seq (without gaps)\n                   'hit'   = length of hit seq (without gaps) (synonyms: sbjct, subject)\n                   'total' = length of alignment (with gaps)\n                   default = 'total'\n            arg 2: [optional] integer length value to set for specific type\n\n\nsub length {\n\n    my $self = shift;\n    my $type = shift;\n\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if( $type =~ /^q/i ) {\n        return $self->query()->length(shift);\n    } elsif( $type =~ /^(hit|subject|sbjct)/ ) {\n        return $self->hit()->length(shift);\n    } else {\n        my $v = shift;\n        if( defined $v ) {\n            $self->{HSP_LENGTH} = $v;\n        }\n        return $self->{HSP_LENGTH};\n   }\n    return 0; # should never get here\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100\n Args    : none\n\n\nsub hsp_length { return shift->length('hsp', shift); }\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100\n Args    : none\n\n\n\nsub percent_identity {\n    my $self = shift;\n\n    unless ($self->{_did_prepi}) {\n        $self->_pre_pi;\n    }\n\n    return $self->SUPER::percent_identity(@_);\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : my ($qframe, $hframe) = $hsp->frame('list',$queryframe,$subjectframe)\n Function: Set the Frame for both query and subject and insure that\n           they agree.\n           This overrides the frame() method implementation in\n           FeaturePair.\n Returns : array of query and subject frame if return type wants an array\n           or query frame if defined or subject frame if not defined\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the frame of the subject (default)\n           'query' to retrieve the query frame \n           'list' or 'array' to retrieve both query and hit frames together\n Note    : Frames are stored in the GFF way (0-2) not 1-3\n           as they are in BLAST (negative frames are deduced by checking\n                                 the strand of the query or hit)\n\n\n# Note: changed 4/19/08 - bug 2485\n#\n# frame() is supposed to be a getter/setter (as is implied by the Function desc\n# above; this is also consistent with Bio::SeqFeature::SimilarityPair).  Also,\n# the API is not consistent with the other HSP/SimilarityPair methods such as\n# strand(), start(), end(), etc. \n#\n# In order to make this consistent with other methods all work is now done\n# when the features are instantiated and not delayed.  We compromise by\n# defaulting back 'to hit' w/o passed args.  Setting is now allowed.  \n\nsub frame {\n    my $self = shift;\n    my $val = shift;\n    if (!defined $val) {\n        # unfortunately, w/o args we need to warn about API changes\n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP;\\n\".\n                    \"returning query frame\");\n        $val = 'query';\n    }\n    $val =~ s/^\\s+//;\n\n    if( $val =~ /^q/i ) {\n        return $self->query->frame(@_);\n    } elsif( $val =~ /^hi|^s/i ) {\n        return $self->hit->frame(@_);\n    } elsif (  $val =~ /^list|array/i ) {\n        return ($self->query->frame($_[0]), \n            $self->hit->frame($_[1]) );\n    } elsif ( $val =~ /^\\d+$/) {\n        # old API i.e. frame($query_frame, $hit_frame). This catches all but one\n        # case, where no arg is passed (so the hit is wanted).  \n        $self->warn(\"API for frame() has changed.\\n\".\n                    \"Please refer to documentation for Bio::Search::HSP::GenericHSP\");\n        wantarray ? \n        return ($self->query->frame($val), \n            $self->hit->frame(@_) ) :\n        return $self->hit->frame($val,@_);\n    } else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->gel_aln\n Function: Returns a L<Bio::SimpleAlign> object representing the HSP alignment\n Returns : L<Bio::SimpleAlign>\n Args    : none\n\n\nsub get_aln {\n    my ($self) = @_;\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->hit_string();\n    my $qs = $self->query_string();\n    # FASTA specific stuff moved to the FastaHSP object\n    my $seqonly = $qs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my ($q_nm,$s_nm) = ($self->query->seq_id(),\n                        $self->hit->seq_id());\n    # Should we silently change the name of the query or hit if it isn't\n    # defined?  May need revisiting... cjfields 2008-12-3 (commented out below)\n    \n    #unless( defined $q_nm && CORE::length ($q_nm) ) {\n    #    $q_nm = 'query';\n    #}\n    #unless( defined $s_nm && CORE::length ($s_nm) ) {\n    #    $s_nm = 'hit';\n    #}\n    \n    # mapping: 1 residues for every x coordinate positions\n    my $query = Bio::LocatableSeq->new('-seq'   => $qs,\n                                      '-id'    => $q_nm,\n                                      '-start' => $self->query->start,\n                                      '-end'   => $self->query->end,\n                                      '-force_nse' => $q_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_query_mapping}]\n                                      );\n    $seqonly = $hs;\n    $seqonly =~ s/[\\-\\s]//g;\n    my $hit =  Bio::LocatableSeq->new('-seq'    => $hs,\n                                      '-id'    => $s_nm,\n                                      '-start' => $self->hit->start,\n                                      '-end'   => $self->hit->end,\n                                      '-force_nse' => $s_nm ? 0 : 1,\n                                      '-mapping' => [1, $self->{_hit_mapping}]\n                                      );\n    $aln->add_seq($query);\n    $aln->add_seq($hit);\n    return $aln;\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_conserved{\n    my ($self,$value) = @_;\n\n    unless ($self->{_did_presimilar}) {\n        $self->_pre_similar_stats;\n    }\n\n    if (defined $value) {\n        $self->{CONSERVED} = $value;\n    }\n    return $self->{CONSERVED};\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\n\nsub num_identical{\n   my ($self,$value) = @_;\n\n   unless ($self->{_did_presimilar}) {\n        $self->_pre_similar_stats;\n    }\n\n   if( defined $value) {\n       $self->{IDENTICAL} = $value;\n   }\n   return $self->{IDENTICAL};\n}\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\nsub rank {\n    my ($self,$value) = @_;\n    if( defined $value) {\n        $self->{RANK} = $value;\n    }\n    return $self->{RANK};\n}\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical\n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved-not-identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers\n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n           :  ('sbjct' is synonymous with 'hit')\n           : class     = 'identical' - identical positions\n           :             'conserved' - conserved positions\n           :             'nomatch'   - mismatched residue or gap positions\n           :             'mismatch'  - mismatched residue positions (no gaps)\n           :             'gap'       - gap positions only\n           :             'frameshift'- frameshift positions only\n           :             'conserved-not-identical' - conserved positions w/o \n           :                            identical residues\n           :             The name can be shortened to 'id' or 'cons' unless\n           :             the name is ambiguous.  The default value is\n           :             'identical'\n           :\n           : collapse  = boolean, if true, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\"\n           :             collapses to \"1-5 7 9-11\". This is useful for\n           :             consolidating long lists. Default = no collapse.\n           :\n Throws    : n/a.\n Comments  : For HSPs partially or completely derived from translated sequences\n           : (TBLASTN, BLASTX, TBLASTX, or similar), some positional data\n           : cannot easily be attributed to a single position (i.e. the \n           : positional data is ambiguous).  In these cases all three codon \n           : positions are reported.  Under these conditions you can check \n           : ambiguous_seq_inds() to determine whether the query, subject, \n           : or both are ambiguous.\n           :\nSee Also   : L<Bio::Search::SearchUtils::collapse_nums()|Bio::Search::SearchUtils>,\n             L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$class"},{"label":"$collapse"}],"label":"seq_inds($self,$seqType,$class,$collapse)"},"line":779,"range":{"start":{"character":0,"line":779},"end":{"line":844,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$seqType,$class,$collapse)","children":[{"kind":13,"localvar":"my","containerName":"seq_inds","name":"$self","line":780,"definition":"my"},{"containerName":"seq_inds","kind":13,"name":"$seqType","line":780},{"line":780,"name":"$class","kind":13,"containerName":"seq_inds"},{"containerName":"seq_inds","kind":13,"name":"$collapse","line":780},{"containerName":"seq_inds","kind":13,"name":"$self","line":784},{"line":784,"kind":12,"containerName":"seq_inds","name":"_calculate_seq_positions"},{"line":786,"name":"$seqType","kind":13,"containerName":"seq_inds"},{"line":787,"kind":13,"containerName":"seq_inds","name":"$class"},{"line":788,"name":"$collapse","containerName":"seq_inds","kind":13},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":789},{"name":"$seqType","kind":13,"containerName":"seq_inds","line":789},{"line":790,"kind":13,"localvar":"my","containerName":"seq_inds","name":"$t","definition":"my"},{"name":"$seqType","kind":13,"containerName":"seq_inds","line":790},{"line":791,"name":"$t","containerName":"seq_inds","kind":13},{"containerName":"seq_inds","kind":13,"name":"$seqType","line":792},{"name":"$t","kind":13,"containerName":"seq_inds","line":793},{"line":793,"kind":13,"containerName":"seq_inds","name":"$t"},{"line":794,"name":"$seqType","kind":13,"containerName":"seq_inds"},{"kind":13,"containerName":"seq_inds","name":"$self","line":796},{"line":796,"name":"warn","containerName":"seq_inds","kind":12},{"line":797,"containerName":"seq_inds","kind":13,"name":"$seqType"},{"line":800,"name":"$t","containerName":"seq_inds","kind":13},{"line":800,"kind":13,"containerName":"seq_inds","name":"$class"},{"name":"$t","containerName":"seq_inds","kind":13,"line":802},{"kind":13,"containerName":"seq_inds","name":"$class","line":803},{"line":804,"name":"$class","kind":13,"containerName":"seq_inds"},{"line":806,"kind":13,"containerName":"seq_inds","name":"$class"},{"kind":13,"containerName":"seq_inds","name":"$t","line":808},{"line":809,"name":"$class","containerName":"seq_inds","kind":13},{"containerName":"seq_inds","kind":13,"name":"$t","line":810},{"line":811,"kind":13,"containerName":"seq_inds","name":"$class"},{"kind":13,"containerName":"seq_inds","name":"$t","line":812},{"line":813,"name":"$class","containerName":"seq_inds","kind":13},{"name":"$t","containerName":"seq_inds","kind":13,"line":814},{"line":815,"name":"$class","containerName":"seq_inds","kind":13},{"kind":13,"containerName":"seq_inds","name":"$t","line":816},{"name":"$class","kind":13,"containerName":"seq_inds","line":817},{"containerName":"seq_inds","kind":13,"name":"$self","line":819},{"containerName":"seq_inds","kind":12,"name":"warn","line":819},{"name":"$class","kind":13,"containerName":"seq_inds","line":820},{"line":824,"name":"$seqType","containerName":"seq_inds","kind":13},{"line":825,"name":"$class","kind":13,"containerName":"seq_inds"},{"definition":"my","line":826,"kind":13,"localvar":"my","containerName":"seq_inds","name":"@ary"},{"name":"$class","containerName":"seq_inds","kind":13,"line":828},{"line":837,"name":"@ary","containerName":"seq_inds","kind":13},{"definition":"my","localvar":"my","containerName":"seq_inds","kind":13,"name":"@tmp","line":837},{"localvar":"my","kind":13,"containerName":"seq_inds","name":"$g","line":839,"definition":"my"},{"name":"$self","containerName":"seq_inds","kind":13,"line":839},{"kind":13,"containerName":"seq_inds","name":"@tmp","line":840},{"line":842,"kind":13,"containerName":"seq_inds","name":"@tmp"},{"line":843,"kind":13,"containerName":"seq_inds","name":"$a"},{"line":843,"kind":13,"containerName":"seq_inds","name":"$b"},{"line":843,"name":"$self","kind":13,"containerName":"seq_inds"}],"name":"seq_inds","containerName":"main::"},{"line":839,"kind":12,"name":"seqinds"},{"name":"seqinds","kind":12,"line":843},{"kind":13,"containerName":null,"name":"%class","line":844},{"kind":13,"containerName":null,"name":"@ary","line":845},{"line":845,"containerName":null,"kind":13,"name":"$a"},{"containerName":null,"kind":13,"name":"$b","line":845},{"line":846,"name":"%self","kind":13,"containerName":null},{"line":846,"name":"seqinds","kind":12},{"line":847,"name":"%self","containerName":null,"kind":13},{"line":847,"name":"seqinds","kind":12},{"name":"@ary","kind":13,"containerName":null,"line":849},{"line":849,"kind":13,"containerName":null,"name":"$a"},{"line":849,"name":"$b","kind":13,"containerName":null},{"line":849,"name":"%self","kind":13,"containerName":null},{"line":849,"kind":12,"name":"seqinds"},{"name":"$collapse","kind":13,"containerName":null,"line":851},{"name":"$collapse","containerName":null,"kind":13,"line":853},{"kind":12,"containerName":"Search::BlastUtils","name":"Bio","line":853},{"kind":12,"containerName":"Search::SearchUtils::collapse_nums","name":"Bio","line":853},{"kind":13,"containerName":null,"name":"@ary","line":853},{"name":"@ary","containerName":null,"kind":13,"line":853},{"line":874,"kind":12,"range":{"start":{"line":874,"character":0},"end":{"character":9999,"line":879}},"definition":"sub","children":[{"line":875,"name":"$self","kind":13,"localvar":"my","containerName":"ambiguous_seq_inds","definition":"my"},{"line":876,"kind":13,"containerName":"ambiguous_seq_inds","name":"$self"},{"line":876,"name":"_calculate_seq_positions","containerName":"ambiguous_seq_inds","kind":12},{"containerName":"ambiguous_seq_inds","kind":13,"name":"$self","line":877},{"kind":13,"containerName":"ambiguous_seq_inds","name":"$self","line":877},{"line":878,"name":"$self","kind":13,"containerName":"ambiguous_seq_inds"}],"containerName":"main::","name":"ambiguous_seq_inds"},{"line":877,"kind":12,"name":"seqinds"},{"line":877,"name":"seqinds","kind":12},{"name":"seqinds","kind":12,"line":878},{"range":{"end":{"character":9999,"line":901},"start":{"character":0,"line":895}},"kind":12,"line":895,"name":"query","containerName":"main::","children":[{"definition":"my","line":896,"name":"$self","localvar":"my","kind":13,"containerName":"query"},{"line":897,"name":"$self","kind":13,"containerName":"query"},{"line":898,"kind":13,"containerName":"query","name":"$self"},{"kind":12,"containerName":"query","name":"_query_seq_feature","line":898},{"kind":13,"containerName":"query","name":"$self","line":900}],"definition":"sub"},{"line":897,"kind":12,"name":"_created_qff"},{"line":900,"containerName":"query","kind":12,"name":"SUPER"},{"children":[{"line":904,"containerName":"feature1","localvar":"my","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"feature1","name":"$self","line":905},{"name":"$self","containerName":"feature1","kind":13,"line":905},{"line":906,"name":"$self","containerName":"feature1","kind":13},{"name":"$self","kind":13,"containerName":"feature1","line":906},{"name":"$self","containerName":"feature1","kind":13,"line":907},{"name":"new","kind":12,"containerName":"feature1","line":907},{"kind":13,"containerName":"feature1","name":"$self","line":908},{"line":910,"containerName":"feature1","kind":13,"name":"$self"},{"line":911,"containerName":"feature1","kind":13,"name":"$self"},{"line":911,"containerName":"feature1","kind":12,"name":"_query_seq_feature"},{"line":913,"containerName":"feature1","kind":13,"name":"$self"}],"name":"feature1","containerName":"main::","definition":"sub","line":903,"range":{"end":{"line":914,"character":9999},"start":{"character":0,"line":903}},"kind":12},{"line":905,"name":"_finished_new","kind":12},{"line":905,"name":"_making_qff","kind":12},{"line":906,"name":"_sim1","kind":12},{"name":"_sim1","kind":12,"line":906},{"kind":12,"name":"_sim1","line":907},{"kind":12,"containerName":"SeqFeature::Similarity","name":"Bio","line":907},{"name":"_sim1","kind":12,"line":908},{"line":910,"kind":12,"name":"_created_qff"},{"line":913,"name":"SUPER","kind":12,"containerName":"feature1"},{"definition":"sub","containerName":"main::","name":"hit","children":[{"name":"$self","localvar":"my","containerName":"hit","kind":13,"line":927,"definition":"my"},{"line":928,"kind":13,"containerName":"hit","name":"$self"},{"containerName":"hit","kind":13,"name":"$self","line":929},{"name":"_subject_seq_feature","containerName":"hit","kind":12,"line":929},{"line":931,"containerName":"hit","kind":13,"name":"$self"}],"kind":12,"range":{"end":{"character":9999,"line":932},"start":{"character":0,"line":926}},"line":926},{"line":928,"kind":12,"name":"_created_sff"},{"name":"SUPER","containerName":"hit","kind":12,"line":931},{"line":934,"range":{"end":{"line":945,"character":9999},"start":{"line":934,"character":0}},"kind":12,"children":[{"line":935,"name":"$self","kind":13,"localvar":"my","containerName":"feature2","definition":"my"},{"kind":13,"containerName":"feature2","name":"$self","line":936},{"line":936,"name":"$self","containerName":"feature2","kind":13},{"name":"$self","containerName":"feature2","kind":13,"line":937},{"name":"$self","kind":13,"containerName":"feature2","line":937},{"name":"$self","kind":13,"containerName":"feature2","line":938},{"line":938,"containerName":"feature2","kind":12,"name":"new"},{"containerName":"feature2","kind":13,"name":"$self","line":939},{"line":941,"name":"$self","kind":13,"containerName":"feature2"},{"line":942,"containerName":"feature2","kind":13,"name":"$self"},{"containerName":"feature2","kind":12,"name":"_subject_seq_feature","line":942},{"containerName":"feature2","kind":13,"name":"$self","line":944}],"name":"feature2","containerName":"main::","definition":"sub"},{"line":936,"name":"_finished_new","kind":12},{"line":936,"name":"_making_sff","kind":12},{"line":937,"name":"_sim2","kind":12},{"line":937,"kind":12,"name":"_sim2"},{"kind":12,"name":"_sim2","line":938},{"line":938,"name":"Bio","kind":12,"containerName":"SeqFeature::Similarity"},{"line":939,"kind":12,"name":"_sim2"},{"name":"_created_sff","kind":12,"line":941},{"containerName":"feature2","kind":12,"name":"SUPER","line":944},{"children":[{"definition":"my","line":962,"name":"$self","localvar":"my","containerName":"significance","kind":13},{"name":"$val","containerName":"significance","kind":13,"line":962},{"line":963,"containerName":"significance","kind":13,"name":"$self"},{"line":963,"name":"$val","kind":13,"containerName":"significance"},{"kind":13,"containerName":"significance","name":"$self","line":964},{"name":"$val","kind":13,"containerName":"significance","line":964},{"name":"$val","containerName":"significance","kind":13,"line":964},{"line":965,"name":"$self","kind":13,"containerName":"significance"},{"name":"evalue","kind":12,"containerName":"significance","line":965},{"line":965,"name":"$self","containerName":"significance","kind":13},{"containerName":"significance","kind":12,"name":"evalue","line":965},{"line":966,"containerName":"significance","kind":13,"name":"$self"},{"line":966,"name":"pvalue","kind":12,"containerName":"significance"},{"line":966,"name":"pvalue","containerName":"significance","kind":12},{"kind":13,"containerName":"significance","name":"$self","line":968},{"containerName":"significance","kind":12,"name":"query","line":968},{"containerName":"significance","kind":12,"name":"significance","line":968},{"line":968,"name":"$self","kind":13,"containerName":"significance"},{"line":970,"name":"$self","containerName":"significance","kind":13}],"containerName":"main::","name":"significance","definition":"sub","detail":"($self,$val)","line":961,"range":{"end":{"character":9999,"line":971},"start":{"character":0,"line":961}},"kind":12,"signature":{"label":"significance($self,$val)","documentation":"","parameters":[{"label":"$self"},{"label":"$val"}]}},{"line":963,"name":"SIGNIFICANCE","kind":12},{"line":964,"kind":12,"name":"SIGNIFICANCE"},{"line":966,"name":"self","kind":12},{"kind":12,"name":"SIGNIFICANCE","line":968},{"line":970,"kind":12,"name":"SIGNIFICANCE"},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_calculate_seq_positions($self,@args)"},"kind":12,"range":{"start":{"character":0,"line":1019},"end":{"character":9999,"line":1183}},"line":1019,"detail":"($self,@args)","definition":"sub","name":"_calculate_seq_positions","containerName":"main::","children":[{"definition":"my","line":1020,"containerName":"_calculate_seq_positions","localvar":"my","kind":13,"name":"$self"},{"kind":13,"containerName":"_calculate_seq_positions","name":"@args","line":1020},{"line":1021,"name":"$self","containerName":"_calculate_seq_positions","kind":13},{"name":"$self","containerName":"_calculate_seq_positions","kind":13,"line":1022},{"localvar":"my","kind":13,"containerName":"_calculate_seq_positions","name":"$seqString","line":1023,"definition":"my"},{"name":"$qseq","kind":13,"containerName":"_calculate_seq_positions","line":1023},{"line":1023,"name":"$sseq","containerName":"_calculate_seq_positions","kind":13},{"kind":13,"containerName":"_calculate_seq_positions","name":"$self","line":1023},{"line":1023,"containerName":"_calculate_seq_positions","kind":12,"name":"homology_string"},{"line":1024,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"line":1024,"name":"query_string","kind":12,"containerName":"_calculate_seq_positions"},{"line":1025,"name":"$self","containerName":"_calculate_seq_positions","kind":13},{"name":"hit_string","containerName":"_calculate_seq_positions","kind":12,"line":1025},{"name":"$mlen","kind":13,"localvar":"my","containerName":"_calculate_seq_positions","line":1026,"definition":"my"},{"name":"$qlen","kind":13,"containerName":"_calculate_seq_positions","line":1026},{"line":1026,"containerName":"_calculate_seq_positions","kind":13,"name":"$slen"},{"kind":13,"containerName":"_calculate_seq_positions","name":"$seqString","line":1026},{"containerName":"_calculate_seq_positions","kind":13,"name":"$qseq","line":1026},{"line":1026,"name":"$sseq","kind":13,"containerName":"_calculate_seq_positions"},{"definition":"my","name":"$qdir","containerName":"_calculate_seq_positions","localvar":"my","kind":13,"line":1027},{"line":1027,"name":"$self","containerName":"_calculate_seq_positions","kind":13},{"line":1027,"containerName":"_calculate_seq_positions","kind":12,"name":"query"},{"line":1027,"containerName":"_calculate_seq_positions","kind":12,"name":"strand"},{"name":"$sdir","localvar":"my","kind":13,"containerName":"_calculate_seq_positions","line":1028,"definition":"my"},{"line":1028,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"line":1028,"kind":12,"containerName":"_calculate_seq_positions","name":"hit"},{"line":1028,"name":"strand","containerName":"_calculate_seq_positions","kind":12},{"definition":"my","name":"$resCount_query","containerName":"_calculate_seq_positions","localvar":"my","kind":13,"line":1029},{"containerName":"_calculate_seq_positions","kind":13,"name":"$endpoint_query","line":1029},{"line":1029,"containerName":"_calculate_seq_positions","kind":13,"name":"$qdir"},{"containerName":"_calculate_seq_positions","kind":13,"name":"$self","line":1029},{"line":1029,"kind":12,"containerName":"_calculate_seq_positions","name":"query"},{"name":"end","kind":12,"containerName":"_calculate_seq_positions","line":1029},{"kind":13,"containerName":"_calculate_seq_positions","name":"$self","line":1029},{"name":"query","containerName":"_calculate_seq_positions","kind":12,"line":1029},{"line":1029,"name":"start","kind":12,"containerName":"_calculate_seq_positions"},{"line":1030,"containerName":"_calculate_seq_positions","kind":13,"name":"$self"},{"kind":12,"containerName":"_calculate_seq_positions","name":"query","line":1030},{"name":"start","kind":12,"containerName":"_calculate_seq_positions","line":1030},{"containerName":"_calculate_seq_positions","kind":13,"name":"$self","line":1030},{"kind":12,"containerName":"_calculate_seq_positions","name":"query","line":1030},{"line":1030,"name":"end","containerName":"_calculate_seq_positions","kind":12},{"definition":"my","containerName":"_calculate_seq_positions","localvar":"my","kind":13,"name":"$resCount_sbjct","line":1031},{"kind":13,"containerName":"_calculate_seq_positions","name":"$endpoint_sbjct","line":1031},{"kind":13,"containerName":"_calculate_seq_positions","name":"$sdir","line":1031},{"line":1031,"containerName":"_calculate_seq_positions","kind":13,"name":"$self"},{"name":"hit","containerName":"_calculate_seq_positions","kind":12,"line":1031},{"line":1031,"name":"end","containerName":"_calculate_seq_positions","kind":12},{"line":1031,"containerName":"_calculate_seq_positions","kind":13,"name":"$self"},{"containerName":"_calculate_seq_positions","kind":12,"name":"hit","line":1031},{"line":1031,"name":"start","kind":12,"containerName":"_calculate_seq_positions"},{"name":"$self","containerName":"_calculate_seq_positions","kind":13,"line":1032},{"name":"hit","kind":12,"containerName":"_calculate_seq_positions","line":1032},{"line":1032,"name":"start","containerName":"_calculate_seq_positions","kind":12},{"line":1032,"name":"$self","kind":13,"containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","kind":12,"name":"hit","line":1032},{"line":1032,"name":"end","containerName":"_calculate_seq_positions","kind":12},{"localvar":"my","containerName":"_calculate_seq_positions","kind":13,"name":"$prog","line":1034,"definition":"my"},{"line":1034,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"line":1034,"containerName":"_calculate_seq_positions","kind":12,"name":"algorithm"},{"line":1036,"kind":13,"containerName":"_calculate_seq_positions","name":"$prog"},{"containerName":"_calculate_seq_positions","localvar":"my","kind":13,"name":"$start","line":1043,"definition":"my"},{"name":"$rest","containerName":"_calculate_seq_positions","kind":13,"line":1043},{"line":1044,"kind":13,"containerName":"_calculate_seq_positions","name":"$seqString"},{"kind":13,"containerName":"_calculate_seq_positions","name":"$start","line":1045},{"containerName":"_calculate_seq_positions","kind":13,"name":"$rest","line":1045},{"line":1048,"kind":13,"containerName":"_calculate_seq_positions","name":"$seqString"},{"kind":13,"containerName":"_calculate_seq_positions","name":"$seqString","line":1048},{"containerName":"_calculate_seq_positions","kind":13,"name":"$start","line":1048},{"line":1048,"containerName":"_calculate_seq_positions","kind":13,"name":"$rest"},{"line":1049,"kind":13,"containerName":"_calculate_seq_positions","name":"$qseq"},{"name":"$qseq","containerName":"_calculate_seq_positions","kind":13,"line":1049},{"line":1049,"containerName":"_calculate_seq_positions","kind":13,"name":"$start"},{"line":1049,"containerName":"_calculate_seq_positions","kind":13,"name":"$rest"},{"line":1050,"kind":13,"containerName":"_calculate_seq_positions","name":"$sseq"},{"line":1050,"name":"$sseq","containerName":"_calculate_seq_positions","kind":13},{"kind":13,"containerName":"_calculate_seq_positions","name":"$start","line":1050},{"line":1050,"name":"$rest","containerName":"_calculate_seq_positions","kind":13},{"containerName":"_calculate_seq_positions","kind":13,"name":"$self","line":1071},{"line":1072,"containerName":"_calculate_seq_positions","kind":13,"name":"$self"},{"line":1072,"name":"$self","kind":13,"containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","kind":13,"name":"$prog","line":1073},{"line":1074,"name":"$self","kind":13,"containerName":"_calculate_seq_positions"},{"name":"$self","kind":13,"containerName":"_calculate_seq_positions","line":1076},{"line":1077,"name":"$self","containerName":"_calculate_seq_positions","kind":13},{"name":"$self","containerName":"_calculate_seq_positions","kind":13,"line":1079},{"name":"$prog","kind":13,"containerName":"_calculate_seq_positions","line":1081},{"containerName":"_calculate_seq_positions","kind":13,"name":"$self","line":1082},{"line":1083,"containerName":"_calculate_seq_positions","kind":13,"name":"$self"},{"containerName":"_calculate_seq_positions","localvar":"my","kind":13,"name":"$qfs","line":1085,"definition":"my"},{"kind":13,"containerName":"_calculate_seq_positions","name":"$sfs","line":1085},{"line":1087,"name":"$pos","localvar":"my","kind":13,"containerName":"_calculate_seq_positions","definition":"my"},{"name":"$seqString","containerName":"_calculate_seq_positions","kind":13,"line":1087},{"definition":"my","line":1088,"name":"@qrange","kind":13,"localvar":"my","containerName":"_calculate_seq_positions"},{"line":1088,"name":"$qfs","containerName":"_calculate_seq_positions","kind":13},{"kind":13,"containerName":"_calculate_seq_positions","name":"$self","line":1088},{"line":1089,"name":"@srange","localvar":"my","containerName":"_calculate_seq_positions","kind":13,"definition":"my"},{"name":"$sfs","kind":13,"containerName":"_calculate_seq_positions","line":1089},{"name":"$self","kind":13,"containerName":"_calculate_seq_positions","line":1089},{"name":"$qfs","kind":13,"containerName":"_calculate_seq_positions","line":1091},{"line":1091,"containerName":"_calculate_seq_positions","kind":13,"name":"$sfs"},{"definition":"my","name":"$mchar","localvar":"my","containerName":"_calculate_seq_positions","kind":13,"line":1092},{"line":1092,"name":"$qchar","containerName":"_calculate_seq_positions","kind":13},{"containerName":"_calculate_seq_positions","kind":13,"name":"$schar","line":1092},{"line":1093,"kind":13,"containerName":"_calculate_seq_positions","name":"$seqString"},{"line":1094,"containerName":"_calculate_seq_positions","kind":13,"name":"$pos"},{"containerName":"_calculate_seq_positions","kind":13,"name":"$qseq","line":1094},{"name":"$qseq","kind":13,"containerName":"_calculate_seq_positions","line":1094},{"containerName":"_calculate_seq_positions","kind":13,"name":"$pos","line":1095},{"line":1095,"containerName":"_calculate_seq_positions","kind":13,"name":"$sseq"},{"containerName":"_calculate_seq_positions","kind":13,"name":"$sseq","line":1095},{"line":1097,"name":"$matchtype","localvar":"my","kind":13,"containerName":"_calculate_seq_positions","definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"_calculate_seq_positions","name":"$qgap","line":1098},{"kind":13,"containerName":"_calculate_seq_positions","name":"$sgap","line":1098},{"line":1099,"name":"$mchar","containerName":"_calculate_seq_positions","kind":13},{"name":"$mchar","kind":13,"containerName":"_calculate_seq_positions","line":1099},{"line":1100,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"line":1100,"name":"$resCount_query","containerName":"_calculate_seq_positions","kind":13},{"name":"$qdir","containerName":"_calculate_seq_positions","kind":13,"line":1100},{"line":1100,"name":"@qrange","kind":13,"containerName":"_calculate_seq_positions"},{"line":1101,"name":"$self","kind":13,"containerName":"_calculate_seq_positions"},{"line":1101,"name":"$resCount_sbjct","kind":13,"containerName":"_calculate_seq_positions"},{"containerName":"_calculate_seq_positions","kind":13,"name":"$sdir","line":1101},{"line":1101,"name":"@srange","containerName":"_calculate_seq_positions","kind":13},{"line":1102,"name":"$matchtype","kind":13,"containerName":"_calculate_seq_positions"},{"name":"$mchar","containerName":"_calculate_seq_positions","kind":13,"line":1103},{"name":"$mchar","containerName":"_calculate_seq_positions","kind":13,"line":1103},{"line":1104,"name":"$self","containerName":"_calculate_seq_positions","kind":13},{"kind":13,"containerName":"_calculate_seq_positions","name":"$resCount_query","line":1104},{"line":1104,"name":"$qdir","containerName":"_calculate_seq_positions","kind":13},{"name":"@qrange","kind":13,"containerName":"_calculate_seq_positions","line":1104},{"line":1105,"containerName":"_calculate_seq_positions","kind":13,"name":"$self"},{"line":1105,"name":"$resCount_sbjct","containerName":"_calculate_seq_positions","kind":13},{"name":"$sdir","containerName":"_calculate_seq_positions","kind":13,"line":1105},{"name":"@srange","kind":13,"containerName":"_calculate_seq_positions","line":1105},{"name":"$matchtype","containerName":"_calculate_seq_positions","kind":13,"line":1106},{"name":"$mchar","kind":13,"containerName":"_calculate_seq_positions","line":1107},{"line":1108,"name":"$qfs","kind":13,"containerName":"_calculate_seq_positions"},{"name":"$qchar","containerName":"_calculate_seq_positions","kind":13,"line":1108},{"line":1109,"containerName":"_calculate_seq_positions","kind":13,"name":"$qchar"},{"line":1111,"name":"$sfs","kind":13,"containerName":"_calculate_seq_positions"},{"name":"$schar","containerName":"_calculate_seq_positions","kind":13,"line":1111},{"line":1112,"containerName":"_calculate_seq_positions","kind":13,"name":"$schar"},{"line":1114,"name":"$qfs","containerName":"_calculate_seq_positions","kind":13},{"line":1131,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"line":1131,"name":"$resCount_query","kind":13,"containerName":"_calculate_seq_positions"},{"line":1131,"kind":13,"containerName":"_calculate_seq_positions","name":"$qdir"},{"containerName":"_calculate_seq_positions","kind":13,"name":"$qfs","line":1131},{"name":"$qfs","kind":13,"containerName":"_calculate_seq_positions","line":1131},{"name":"@qrange","containerName":"_calculate_seq_positions","kind":13,"line":1131},{"name":"$matchtype","kind":13,"containerName":"_calculate_seq_positions","line":1132},{"kind":13,"containerName":"_calculate_seq_positions","name":"$sgap","line":1133},{"line":1133,"containerName":"_calculate_seq_positions","kind":13,"name":"$qgap"},{"line":1135,"kind":13,"containerName":"_calculate_seq_positions","name":"$sfs"},{"containerName":"_calculate_seq_positions","kind":13,"name":"$self","line":1136},{"containerName":"_calculate_seq_positions","kind":13,"name":"$resCount_sbjct","line":1136},{"name":"$sdir","kind":13,"containerName":"_calculate_seq_positions","line":1136},{"name":"$sfs","kind":13,"containerName":"_calculate_seq_positions","line":1136},{"line":1136,"kind":13,"containerName":"_calculate_seq_positions","name":"$sfs"},{"line":1136,"name":"@srange","containerName":"_calculate_seq_positions","kind":13},{"name":"$matchtype","containerName":"_calculate_seq_positions","kind":13,"line":1137},{"name":"$sgap","containerName":"_calculate_seq_positions","kind":13,"line":1138},{"line":1138,"name":"$qgap","containerName":"_calculate_seq_positions","kind":13},{"line":1140,"name":"$qchar","containerName":"_calculate_seq_positions","kind":13},{"kind":13,"containerName":"_calculate_seq_positions","name":"$self","line":1140},{"name":"$self","containerName":"_calculate_seq_positions","kind":13,"line":1144},{"line":1144,"kind":13,"containerName":"_calculate_seq_positions","name":"$resCount_query"},{"name":"$qdir","containerName":"_calculate_seq_positions","kind":13,"line":1144},{"kind":13,"containerName":"_calculate_seq_positions","name":"@qrange","line":1144},{"containerName":"_calculate_seq_positions","kind":13,"name":"$matchtype","line":1145},{"line":1146,"containerName":"_calculate_seq_positions","kind":13,"name":"$qgap"},{"containerName":"_calculate_seq_positions","kind":13,"name":"$schar","line":1148},{"line":1148,"name":"$self","containerName":"_calculate_seq_positions","kind":13},{"name":"$self","kind":13,"containerName":"_calculate_seq_positions","line":1149},{"line":1149,"containerName":"_calculate_seq_positions","kind":13,"name":"$resCount_sbjct"},{"name":"$sdir","kind":13,"containerName":"_calculate_seq_positions","line":1149},{"containerName":"_calculate_seq_positions","kind":13,"name":"@srange","line":1149},{"name":"$matchtype","kind":13,"containerName":"_calculate_seq_positions","line":1150},{"line":1151,"containerName":"_calculate_seq_positions","kind":13,"name":"$sgap"},{"line":1155,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"kind":13,"containerName":"_calculate_seq_positions","name":"$resCount_query","line":1155},{"name":"$qdir","containerName":"_calculate_seq_positions","kind":13,"line":1155},{"line":1155,"containerName":"_calculate_seq_positions","kind":13,"name":"@qrange"},{"line":1156,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"name":"$resCount_sbjct","kind":13,"containerName":"_calculate_seq_positions","line":1156},{"name":"$sdir","kind":13,"containerName":"_calculate_seq_positions","line":1156},{"line":1156,"name":"@srange","containerName":"_calculate_seq_positions","kind":13},{"containerName":"_calculate_seq_positions","kind":13,"name":"$matchtype","line":1157},{"kind":13,"containerName":"_calculate_seq_positions","name":"$sgap","line":1160},{"name":"$self","containerName":"_calculate_seq_positions","kind":13,"line":1161},{"name":"$resCount_sbjct","containerName":"_calculate_seq_positions","kind":13,"line":1161},{"line":1161,"containerName":"_calculate_seq_positions","kind":13,"name":"$sdir"},{"line":1161,"kind":13,"containerName":"_calculate_seq_positions","name":"@srange"},{"containerName":"_calculate_seq_positions","kind":13,"name":"$qgap","line":1163},{"kind":13,"containerName":"_calculate_seq_positions","name":"$self","line":1164},{"line":1164,"containerName":"_calculate_seq_positions","kind":13,"name":"$resCount_query"},{"containerName":"_calculate_seq_positions","kind":13,"name":"$qdir","line":1164},{"line":1164,"name":"@qrange","containerName":"_calculate_seq_positions","kind":13},{"line":1167,"kind":13,"containerName":"_calculate_seq_positions","name":"$self"},{"line":1167,"containerName":"_calculate_seq_positions","kind":12,"name":"warn"},{"name":"$resCount_query","kind":13,"containerName":"_calculate_seq_positions","line":1179},{"line":1179,"kind":13,"containerName":"_calculate_seq_positions","name":"$qdir"},{"line":1179,"containerName":"_calculate_seq_positions","kind":13,"name":"@qrange"},{"name":"$qfs","containerName":"_calculate_seq_positions","kind":13,"line":1179},{"kind":13,"containerName":"_calculate_seq_positions","name":"$qgap","line":1179},{"line":1180,"containerName":"_calculate_seq_positions","kind":13,"name":"$resCount_sbjct"},{"line":1180,"name":"$sdir","containerName":"_calculate_seq_positions","kind":13},{"name":"@srange","containerName":"_calculate_seq_positions","kind":13,"line":1180},{"name":"$sfs","kind":13,"containerName":"_calculate_seq_positions","line":1180},{"kind":13,"containerName":"_calculate_seq_positions","name":"$sgap","line":1180}]},{"containerName":"length","kind":12,"name":"CORE","line":1026},{"name":"CORE","containerName":"length","kind":12,"line":1026},{"line":1026,"containerName":"length","kind":12,"name":"CORE"},{"line":1045,"containerName":"length","kind":12,"name":"CORE"},{"line":1045,"kind":12,"containerName":"length","name":"CORE"},{"kind":12,"name":"seqinds","line":1071},{"name":"_sbjct_offset","kind":12,"line":1072},{"kind":12,"name":"_query_offset","line":1072},{"name":"_sbjct_offset","kind":12,"line":1074},{"line":1076,"kind":12,"name":"_query_offset"},{"kind":12,"name":"seqinds","line":1077},{"kind":12,"name":"seqinds","line":1079},{"kind":12,"name":"_query_offset","line":1082},{"line":1083,"kind":12,"name":"seqinds"},{"line":1086,"name":"CHAR_LOOP","kind":12},{"name":"CORE","kind":12,"containerName":"length","line":1087},{"name":"_query_offset","kind":12,"line":1088},{"line":1089,"name":"_sbjct_offset","kind":12},{"line":1094,"kind":12,"containerName":"length","name":"CORE"},{"line":1095,"name":"CORE","containerName":"length","kind":12},{"kind":12,"name":"seqinds","line":1100},{"name":"_conservedRes_query","kind":12,"line":1100},{"line":1101,"kind":12,"name":"seqinds"},{"name":"_conservedRes_sbjct","kind":12,"line":1101},{"line":1104,"name":"seqinds","kind":12},{"line":1104,"name":"_identicalRes_query","kind":12},{"name":"seqinds","kind":12,"line":1105},{"line":1105,"kind":12,"name":"_identicalRes_sbjct"},{"line":1131,"kind":12,"name":"seqinds"},{"name":"_frameshiftRes_query","kind":12,"line":1131},{"name":"seqinds","kind":12,"line":1136},{"line":1136,"name":"_frameshiftRes_sbjct","kind":12},{"line":1140,"name":"GAP_SYMBOL","kind":12},{"line":1144,"name":"seqinds","kind":12},{"line":1144,"name":"_gapRes_query","kind":12},{"line":1148,"kind":12,"name":"GAP_SYMBOL"},{"kind":12,"name":"seqinds","line":1149},{"name":"_gapRes_sbjct","kind":12,"line":1149},{"name":"seqinds","kind":12,"line":1155},{"line":1155,"name":"_mismatchRes_query","kind":12},{"line":1156,"kind":12,"name":"seqinds"},{"name":"_mismatchRes_sbjct","kind":12,"line":1156},{"name":"seqinds","kind":12,"line":1161},{"name":"_nomatchRes_sbjct","kind":12,"line":1161},{"line":1164,"kind":12,"name":"seqinds"},{"kind":12,"name":"_nomatchRes_query","line":1164},{"range":{"end":{"line":1195,"character":9999},"start":{"character":0,"line":1191}},"kind":12,"line":1191,"definition":"sub","name":"n","containerName":"main::","children":[{"line":1192,"name":"$self","localvar":"my","kind":13,"containerName":"n","definition":"my"},{"line":1193,"name":"$self","kind":13,"containerName":"n"},{"line":1194,"kind":13,"containerName":"n","name":"$self"},{"line":1194,"containerName":"n","kind":13,"name":"$self"}]},{"containerName":"main::","name":"range","children":[{"definition":"my","line":1204,"localvar":"my","kind":13,"containerName":"range","name":"$self"},{"line":1204,"containerName":"range","kind":13,"name":"$seqType"},{"name":"$seqType","containerName":"range","kind":13,"line":1206},{"name":"$seqType","kind":13,"containerName":"range","line":1207},{"line":1207,"containerName":"range","kind":13,"name":"$seqType"},{"line":1209,"name":"$start","localvar":"my","kind":13,"containerName":"range","definition":"my"},{"line":1209,"containerName":"range","kind":13,"name":"$end"},{"name":"$seqType","containerName":"range","kind":13,"line":1210},{"line":1211,"name":"$start","containerName":"range","kind":13},{"line":1211,"kind":13,"containerName":"range","name":"$self"},{"containerName":"range","kind":12,"name":"query","line":1211},{"line":1211,"name":"start","kind":12,"containerName":"range"},{"line":1212,"containerName":"range","kind":13,"name":"$end"},{"kind":13,"containerName":"range","name":"$self","line":1212},{"line":1212,"name":"query","containerName":"range","kind":12},{"line":1212,"name":"end","kind":12,"containerName":"range"},{"line":1215,"kind":13,"containerName":"range","name":"$start"},{"containerName":"range","kind":13,"name":"$self","line":1215},{"containerName":"range","kind":12,"name":"hit","line":1215},{"name":"start","kind":12,"containerName":"range","line":1215},{"line":1216,"name":"$end","kind":13,"containerName":"range"},{"line":1216,"kind":13,"containerName":"range","name":"$self"},{"kind":12,"containerName":"range","name":"hit","line":1216},{"name":"end","kind":12,"containerName":"range","line":1216},{"line":1218,"name":"$start","containerName":"range","kind":13},{"name":"$end","kind":13,"containerName":"range","line":1218}],"detail":"($self,$seqType)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":1203},"end":{"character":9999,"line":1219}},"line":1203,"signature":{"label":"range($self,$seqType)","documentation":"","parameters":[{"label":"$self"},{"label":"$seqType"}]}},{"line":1234,"kind":12,"range":{"end":{"line":1239,"character":9999},"start":{"line":1234,"character":0}},"children":[{"definition":"my","line":1235,"kind":13,"localvar":"my","containerName":"links","name":"$self"},{"name":"$self","containerName":"links","kind":13,"line":1237},{"line":1238,"name":"$self","containerName":"links","kind":13}],"name":"links","containerName":"main::","definition":"sub"},{"name":"LINKS","kind":12,"line":1237},{"kind":12,"name":"LINKS","line":1238},{"line":1253,"kind":12,"range":{"start":{"character":0,"line":1253},"end":{"character":9999,"line":1258}},"children":[{"name":"$self","localvar":"my","containerName":"hsp_group","kind":13,"line":1254,"definition":"my"},{"line":1256,"containerName":"hsp_group","kind":13,"name":"$self"},{"line":1257,"kind":13,"containerName":"hsp_group","name":"$self"}],"name":"hsp_group","containerName":"main::","definition":"sub"},{"line":1256,"name":"HSP_GROUP","kind":12},{"kind":12,"name":"HSP_GROUP","line":1257},{"range":{"end":{"character":9999,"line":1278},"start":{"line":1273,"character":0}},"kind":12,"line":1273,"name":"hit_features","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"hit_features","line":1274},{"name":"$self","containerName":"hit_features","kind":13,"line":1276},{"line":1277,"name":"$self","containerName":"hit_features","kind":13}],"definition":"sub"},{"name":"HIT_FEATURES","kind":12,"line":1276},{"line":1277,"kind":12,"name":"HIT_FEATURES"},{"range":{"end":{"character":9999,"line":1340},"start":{"character":0,"line":1330}},"kind":12,"line":1330,"signature":{"parameters":[{"label":"$self"},{"label":"$arg"}],"documentation":"","label":"cigar_string($self,$arg)"},"name":"cigar_string","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"cigar_string","line":1331,"definition":"my"},{"name":"$arg","kind":13,"containerName":"cigar_string","line":1331},{"name":"$self","kind":13,"containerName":"cigar_string","line":1332},{"name":"warn","containerName":"cigar_string","kind":12,"line":1332},{"line":1332,"kind":13,"containerName":"cigar_string","name":"$arg"},{"line":1334,"kind":13,"containerName":"cigar_string","name":"$self"},{"line":1335,"name":"$cigar_string","containerName":"cigar_string","localvar":"my","kind":13,"definition":"my"},{"name":"$self","containerName":"cigar_string","kind":13,"line":1335},{"kind":12,"containerName":"cigar_string","name":"generate_cigar_string","line":1335},{"line":1335,"name":"$self","kind":13,"containerName":"cigar_string"},{"line":1335,"kind":12,"containerName":"cigar_string","name":"query_string"},{"line":1335,"name":"$self","kind":13,"containerName":"cigar_string"},{"name":"hit_string","containerName":"cigar_string","kind":12,"line":1335},{"line":1336,"name":"$self","containerName":"cigar_string","kind":13},{"line":1336,"name":"$cigar_string","kind":13,"containerName":"cigar_string"},{"kind":13,"containerName":"cigar_string","name":"$self","line":1339}],"detail":"($self,$arg)","definition":"sub"},{"line":1334,"name":"_cigar_string","kind":12},{"name":"_cigar_string","kind":12,"line":1336},{"line":1339,"name":"_cigar_string","kind":12},{"definition":"sub","detail":"($self,$qstr,$hstr)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"generate_cigar_string","line":1353,"definition":"my"},{"name":"$qstr","containerName":"generate_cigar_string","kind":13,"line":1353},{"name":"$hstr","kind":13,"containerName":"generate_cigar_string","line":1353},{"definition":"my","localvar":"my","containerName":"generate_cigar_string","kind":13,"name":"@qchars","line":1354},{"line":1354,"containerName":"generate_cigar_string","kind":13,"name":"$qstr"},{"localvar":"my","kind":13,"containerName":"generate_cigar_string","name":"@hchars","line":1355,"definition":"my"},{"kind":13,"containerName":"generate_cigar_string","name":"$hstr","line":1355},{"line":1357,"name":"@qchars","kind":13,"containerName":"generate_cigar_string"},{"name":"@hchars","containerName":"generate_cigar_string","kind":13,"line":1357},{"line":1358,"containerName":"generate_cigar_string","kind":13,"name":"$self"},{"name":"throw","containerName":"generate_cigar_string","kind":12,"line":1358},{"line":1361,"kind":13,"containerName":"generate_cigar_string","name":"$self"},{"line":1362,"name":"$self","containerName":"generate_cigar_string","kind":13},{"definition":"my","line":1364,"localvar":"my","kind":13,"containerName":"generate_cigar_string","name":"$cigar_string"},{"definition":"my","line":1365,"containerName":"generate_cigar_string","localvar":"my","kind":13,"name":"$i"},{"line":1365,"kind":13,"containerName":"generate_cigar_string","name":"$i"},{"line":1365,"containerName":"generate_cigar_string","kind":13,"name":"$i"},{"line":1366,"kind":13,"localvar":"my","containerName":"generate_cigar_string","name":"$qchar","definition":"my"},{"containerName":"generate_cigar_string","kind":13,"name":"$qchars","line":1366},{"name":"$i","kind":13,"containerName":"generate_cigar_string","line":1366},{"definition":"my","line":1367,"kind":13,"localvar":"my","containerName":"generate_cigar_string","name":"$hchar"},{"line":1367,"kind":13,"containerName":"generate_cigar_string","name":"$hchars"},{"name":"$i","kind":13,"containerName":"generate_cigar_string","line":1367},{"line":1368,"name":"$qchar","kind":13,"containerName":"generate_cigar_string"},{"line":1368,"name":"$self","containerName":"generate_cigar_string","kind":13},{"line":1368,"name":"$hchar","containerName":"generate_cigar_string","kind":13},{"containerName":"generate_cigar_string","kind":13,"name":"$self","line":1368},{"name":"$cigar_string","kind":13,"containerName":"generate_cigar_string","line":1369},{"line":1369,"kind":13,"containerName":"generate_cigar_string","name":"$self"},{"line":1369,"kind":12,"containerName":"generate_cigar_string","name":"_sub_cigar_string"},{"line":1370,"kind":13,"containerName":"generate_cigar_string","name":"$qchar"},{"line":1370,"containerName":"generate_cigar_string","kind":13,"name":"$self"},{"name":"$cigar_string","kind":13,"containerName":"generate_cigar_string","line":1371},{"line":1371,"name":"$self","kind":13,"containerName":"generate_cigar_string"},{"kind":12,"containerName":"generate_cigar_string","name":"_sub_cigar_string","line":1371},{"name":"$hchar","containerName":"generate_cigar_string","kind":13,"line":1372},{"line":1372,"containerName":"generate_cigar_string","kind":13,"name":"$self"},{"containerName":"generate_cigar_string","kind":13,"name":"$cigar_string","line":1373},{"line":1373,"name":"$self","containerName":"generate_cigar_string","kind":13},{"name":"_sub_cigar_string","containerName":"generate_cigar_string","kind":12,"line":1373},{"name":"$self","containerName":"generate_cigar_string","kind":13,"line":1375},{"line":1375,"name":"throw","containerName":"generate_cigar_string","kind":12},{"name":"$cigar_string","containerName":"generate_cigar_string","kind":13,"line":1378},{"containerName":"generate_cigar_string","kind":13,"name":"$self","line":1378},{"name":"_sub_cigar_string","containerName":"generate_cigar_string","kind":12,"line":1378},{"line":1379,"containerName":"generate_cigar_string","kind":13,"name":"$cigar_string"}],"containerName":"main::","name":"generate_cigar_string","signature":{"label":"generate_cigar_string($self,$qstr,$hstr)","parameters":[{"label":"$self"},{"label":"$qstr"},{"label":"$hstr"}],"documentation":""},"line":1352,"kind":12,"range":{"start":{"line":1352,"character":0},"end":{"line":1380,"character":9999}}},{"line":1361,"name":"_count_for_cigar_string","kind":12},{"line":1362,"name":"_state_for_cigar_string","kind":12},{"kind":12,"name":"qchars","line":1365},{"line":1368,"kind":12,"name":"GAP_SYMBOL"},{"kind":12,"name":"GAP_SYMBOL","line":1368},{"kind":12,"name":"GAP_SYMBOL","line":1370},{"line":1372,"name":"GAP_SYMBOL","kind":12},{"line":1384,"kind":12,"range":{"end":{"line":1398,"character":9999},"start":{"character":0,"line":1384}},"signature":{"parameters":[{"label":"$self"},{"label":"$new_state"}],"documentation":"","label":"_sub_cigar_string($self,$new_state)"},"children":[{"definition":"my","line":1385,"name":"$self","localvar":"my","kind":13,"containerName":"_sub_cigar_string"},{"line":1385,"name":"$new_state","kind":13,"containerName":"_sub_cigar_string"},{"line":1387,"name":"$sub_cigar_string","localvar":"my","kind":13,"containerName":"_sub_cigar_string","definition":"my"},{"line":1388,"kind":13,"containerName":"_sub_cigar_string","name":"$self"},{"line":1388,"name":"$new_state","containerName":"_sub_cigar_string","kind":13},{"name":"$self","kind":13,"containerName":"_sub_cigar_string","line":1389},{"containerName":"_sub_cigar_string","kind":13,"name":"$sub_cigar_string","line":1391},{"name":"$self","containerName":"_sub_cigar_string","kind":13,"line":1391},{"containerName":"_sub_cigar_string","kind":13,"name":"$self","line":1392},{"line":1393,"containerName":"_sub_cigar_string","kind":13,"name":"$sub_cigar_string"},{"line":1393,"kind":13,"containerName":"_sub_cigar_string","name":"$self"},{"line":1394,"containerName":"_sub_cigar_string","kind":13,"name":"$self"},{"line":1395,"name":"$self","kind":13,"containerName":"_sub_cigar_string"},{"line":1395,"name":"$new_state","kind":13,"containerName":"_sub_cigar_string"},{"name":"$sub_cigar_string","containerName":"_sub_cigar_string","kind":13,"line":1397}],"name":"_sub_cigar_string","containerName":"main::","definition":"sub","detail":"($self,$new_state)"},{"kind":12,"name":"_state_for_cigar_string","line":1388},{"line":1389,"kind":12,"name":"_count_for_cigar_string"},{"line":1391,"kind":12,"name":"_count_for_cigar_string"},{"line":1392,"kind":12,"name":"_count_for_cigar_string"},{"kind":12,"name":"_state_for_cigar_string","line":1393},{"line":1394,"kind":12,"name":"_count_for_cigar_string"},{"kind":12,"name":"_state_for_cigar_string","line":1395},{"range":{"start":{"line":1401,"character":0},"end":{"line":1438,"character":9999}},"kind":12,"line":1401,"name":"_pre_seq_feature","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_pre_seq_feature","line":1402},{"line":1403,"localvar":"my","kind":13,"containerName":"_pre_seq_feature","name":"$algo","definition":"my"},{"line":1403,"name":"$self","containerName":"_pre_seq_feature","kind":13},{"line":1405,"name":"$queryfactor","kind":13,"localvar":"my","containerName":"_pre_seq_feature","definition":"my"},{"name":"$hitfactor","containerName":"_pre_seq_feature","kind":13,"line":1405},{"definition":"my","kind":13,"localvar":"my","containerName":"_pre_seq_feature","name":"$hitmap","line":1406},{"line":1406,"kind":13,"containerName":"_pre_seq_feature","name":"$querymap"},{"line":1407,"name":"$algo","containerName":"_pre_seq_feature","kind":13},{"line":1408,"kind":13,"containerName":"_pre_seq_feature","name":"$hitfactor"},{"line":1409,"name":"$hitmap","containerName":"_pre_seq_feature","kind":13},{"line":1411,"name":"$algo","containerName":"_pre_seq_feature","kind":13},{"line":1411,"containerName":"_pre_seq_feature","kind":13,"name":"$algo"},{"line":1412,"kind":13,"containerName":"_pre_seq_feature","name":"$queryfactor"},{"containerName":"_pre_seq_feature","kind":13,"name":"$querymap","line":1413},{"line":1415,"containerName":"_pre_seq_feature","kind":13,"name":"$algo"},{"kind":13,"containerName":"_pre_seq_feature","name":"$algo","line":1415},{"line":1415,"containerName":"_pre_seq_feature","kind":13,"name":"$algo"},{"name":"$hitmap","kind":13,"containerName":"_pre_seq_feature","line":1417},{"line":1417,"name":"$querymap","containerName":"_pre_seq_feature","kind":13},{"line":1419,"name":"$hitfactor","containerName":"_pre_seq_feature","kind":13},{"line":1420,"kind":13,"containerName":"_pre_seq_feature","name":"$queryfactor"},{"name":"$algo","containerName":"_pre_seq_feature","kind":13,"line":1422},{"name":"$algo","kind":13,"containerName":"_pre_seq_feature","line":1423},{"containerName":"_pre_seq_feature","kind":13,"name":"$queryfactor","line":1424},{"line":1425,"containerName":"_pre_seq_feature","kind":13,"name":"$querymap"},{"name":"$hitfactor","containerName":"_pre_seq_feature","kind":13,"line":1427},{"containerName":"_pre_seq_feature","localvar":"my","kind":13,"name":"$stranded","line":1430,"definition":"my"},{"name":"$self","kind":13,"containerName":"_pre_seq_feature","line":1430},{"name":"$queryfactor","kind":13,"containerName":"_pre_seq_feature","line":1431},{"name":"$stranded","containerName":"_pre_seq_feature","kind":13,"line":1431},{"line":1431,"name":"$stranded","containerName":"_pre_seq_feature","kind":13},{"kind":13,"containerName":"_pre_seq_feature","name":"$hitfactor","line":1432},{"line":1432,"name":"$stranded","kind":13,"containerName":"_pre_seq_feature"},{"line":1432,"kind":13,"containerName":"_pre_seq_feature","name":"$stranded"},{"line":1432,"containerName":"_pre_seq_feature","kind":13,"name":"$stranded"},{"line":1434,"name":"$self","kind":13,"containerName":"_pre_seq_feature"},{"containerName":"_pre_seq_feature","kind":13,"name":"$queryfactor","line":1434},{"containerName":"_pre_seq_feature","kind":13,"name":"$self","line":1435},{"name":"$hitfactor","containerName":"_pre_seq_feature","kind":13,"line":1435},{"name":"$self","containerName":"_pre_seq_feature","kind":13,"line":1436},{"name":"$hitmap","containerName":"_pre_seq_feature","kind":13,"line":1436},{"line":1437,"name":"$self","containerName":"_pre_seq_feature","kind":13},{"name":"$querymap","containerName":"_pre_seq_feature","kind":13,"line":1437}],"definition":"sub"},{"line":1403,"name":"ALGORITHM","kind":12},{"line":1430,"name":"STRANDED","kind":12},{"line":1434,"name":"_query_factor","kind":12},{"line":1435,"name":"_hit_factor","kind":12},{"line":1436,"name":"_hit_mapping","kind":12},{"line":1437,"kind":12,"name":"_query_mapping"},{"range":{"start":{"line":1441,"character":0},"end":{"line":1516,"character":9999}},"kind":12,"line":1441,"definition":"sub","containerName":"main::","name":"_query_seq_feature","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_query_seq_feature","kind":13,"line":1442},{"containerName":"_query_seq_feature","kind":13,"name":"$self","line":1443},{"definition":"my","name":"$qs","containerName":"_query_seq_feature","localvar":"my","kind":13,"line":1444},{"name":"$self","containerName":"_query_seq_feature","kind":13,"line":1444},{"definition":"my","line":1445,"kind":13,"localvar":"my","containerName":"_query_seq_feature","name":"$qe"},{"containerName":"_query_seq_feature","kind":13,"name":"$self","line":1445},{"line":1446,"containerName":"_query_seq_feature","kind":13,"name":"$self"},{"name":"$self","containerName":"_query_seq_feature","kind":13,"line":1447},{"name":"_pre_seq_feature","kind":12,"containerName":"_query_seq_feature","line":1447},{"name":"$queryfactor","containerName":"_query_seq_feature","localvar":"my","kind":13,"line":1449,"definition":"my"},{"line":1449,"containerName":"_query_seq_feature","kind":13,"name":"$self"},{"containerName":"_query_seq_feature","kind":13,"name":"$qe","line":1451},{"line":1451,"name":"$qs","kind":13,"containerName":"_query_seq_feature"},{"name":"$self","kind":13,"containerName":"_query_seq_feature","line":1451},{"containerName":"_query_seq_feature","kind":12,"name":"throw","line":1451},{"name":"$strand","kind":13,"localvar":"my","containerName":"_query_seq_feature","line":1453,"definition":"my"},{"line":1454,"kind":13,"containerName":"_query_seq_feature","name":"$qe"},{"line":1454,"name":"$qs","containerName":"_query_seq_feature","kind":13},{"name":"$queryfactor","kind":13,"containerName":"_query_seq_feature","line":1455},{"line":1456,"containerName":"_query_seq_feature","kind":13,"name":"$strand"},{"name":"$strand","containerName":"_query_seq_feature","kind":13,"line":1459},{"name":"$queryfactor","containerName":"_query_seq_feature","kind":13,"line":1463},{"line":1464,"name":"$strand","kind":13,"containerName":"_query_seq_feature"},{"name":"$strand","kind":13,"containerName":"_query_seq_feature","line":1467},{"line":1469,"name":"$qs","kind":13,"containerName":"_query_seq_feature"},{"kind":13,"containerName":"_query_seq_feature","name":"$qe","line":1469},{"containerName":"_query_seq_feature","kind":13,"name":"$qe","line":1469},{"name":"$qs","containerName":"_query_seq_feature","kind":13,"line":1469},{"definition":"my","kind":13,"localvar":"my","containerName":"_query_seq_feature","name":"$sim1","line":1477},{"kind":13,"containerName":"_query_seq_feature","name":"$self","line":1477},{"line":1477,"name":"new","kind":12,"containerName":"_query_seq_feature"},{"name":"$sim1","containerName":"_query_seq_feature","kind":13,"line":1478},{"name":"start","containerName":"_query_seq_feature","kind":12,"line":1478},{"line":1478,"containerName":"_query_seq_feature","kind":13,"name":"$qs"},{"line":1479,"containerName":"_query_seq_feature","kind":13,"name":"$sim1"},{"line":1479,"kind":12,"containerName":"_query_seq_feature","name":"end"},{"name":"$qe","containerName":"_query_seq_feature","kind":13,"line":1479},{"kind":13,"containerName":"_query_seq_feature","name":"$sim1","line":1480},{"name":"significance","kind":12,"containerName":"_query_seq_feature","line":1480},{"kind":13,"containerName":"_query_seq_feature","name":"$self","line":1480},{"line":1481,"name":"$sim1","containerName":"_query_seq_feature","kind":13},{"line":1481,"name":"bits","kind":12,"containerName":"_query_seq_feature"},{"line":1481,"kind":13,"containerName":"_query_seq_feature","name":"$self"},{"kind":13,"containerName":"_query_seq_feature","name":"$sim1","line":1482},{"line":1482,"name":"score","containerName":"_query_seq_feature","kind":12},{"line":1482,"kind":13,"containerName":"_query_seq_feature","name":"$self"},{"line":1483,"name":"$sim1","containerName":"_query_seq_feature","kind":13},{"line":1483,"name":"strand","containerName":"_query_seq_feature","kind":12},{"name":"$strand","kind":13,"containerName":"_query_seq_feature","line":1483},{"line":1484,"kind":13,"containerName":"_query_seq_feature","name":"$sim1"},{"name":"seq_id","kind":12,"containerName":"_query_seq_feature","line":1484},{"line":1484,"name":"$self","containerName":"_query_seq_feature","kind":13},{"line":1485,"kind":13,"containerName":"_query_seq_feature","name":"$sim1"},{"kind":12,"containerName":"_query_seq_feature","name":"seqlength","line":1485},{"line":1485,"kind":13,"containerName":"_query_seq_feature","name":"$self"},{"line":1486,"name":"$sim1","containerName":"_query_seq_feature","kind":13},{"name":"source_tag","kind":12,"containerName":"_query_seq_feature","line":1486},{"containerName":"_query_seq_feature","kind":13,"name":"$self","line":1486},{"line":1487,"name":"$sim1","containerName":"_query_seq_feature","kind":13},{"name":"seqdesc","containerName":"_query_seq_feature","kind":12,"line":1487},{"line":1487,"containerName":"_query_seq_feature","kind":13,"name":"$self"},{"line":1488,"name":"$sim1","kind":13,"containerName":"_query_seq_feature"},{"name":"add_tag_value","containerName":"_query_seq_feature","kind":12,"line":1488},{"kind":13,"containerName":"_query_seq_feature","name":"$self","line":1488},{"kind":13,"containerName":"_query_seq_feature","name":"$self","line":1488},{"line":1488,"name":"can","containerName":"_query_seq_feature","kind":12},{"line":1491,"localvar":"my","containerName":"_query_seq_feature","kind":13,"name":"$qframe","definition":"my"},{"line":1491,"kind":13,"containerName":"_query_seq_feature","name":"$self"},{"line":1493,"containerName":"_query_seq_feature","kind":13,"name":"$strand"},{"line":1493,"name":"$qframe","kind":13,"containerName":"_query_seq_feature"},{"line":1493,"name":"$queryfactor","containerName":"_query_seq_feature","kind":13},{"line":1494,"name":"$qframe","containerName":"_query_seq_feature","kind":13},{"name":"$qs","kind":13,"containerName":"_query_seq_feature","line":1494},{"line":1494,"kind":13,"containerName":"_query_seq_feature","name":"$strand"},{"name":"$strand","containerName":"_query_seq_feature","kind":13,"line":1496},{"kind":13,"containerName":"_query_seq_feature","name":"$qframe","line":1497},{"line":1500,"kind":13,"containerName":"_query_seq_feature","name":"$qframe"},{"definition":"my","line":1501,"name":"$dir","localvar":"my","kind":13,"containerName":"_query_seq_feature"},{"line":1502,"kind":13,"containerName":"_query_seq_feature","name":"$qframe"},{"line":1502,"name":"$dir","containerName":"_query_seq_feature","kind":13},{"line":1502,"containerName":"_query_seq_feature","kind":13,"name":"$strand"},{"line":1502,"name":"$dir","containerName":"_query_seq_feature","kind":13},{"kind":13,"containerName":"_query_seq_feature","name":"$strand","line":1502},{"line":1503,"name":"$self","kind":13,"containerName":"_query_seq_feature"},{"line":1503,"kind":12,"containerName":"_query_seq_feature","name":"warn"},{"line":1505,"name":"$qframe","kind":13,"containerName":"_query_seq_feature"},{"containerName":"_query_seq_feature","kind":13,"name":"$self","line":1507},{"containerName":"_query_seq_feature","kind":12,"name":"warn","line":1507},{"kind":13,"containerName":"_query_seq_feature","name":"$qframe","line":1508},{"kind":13,"containerName":"_query_seq_feature","name":"$sim1","line":1511},{"line":1511,"name":"frame","kind":12,"containerName":"_query_seq_feature"},{"line":1511,"name":"$qframe","containerName":"_query_seq_feature","kind":13},{"line":1512,"kind":13,"containerName":"_query_seq_feature","name":"$self"},{"containerName":"_query_seq_feature","kind":13,"name":"$sim1","line":1512},{"containerName":"_query_seq_feature","kind":13,"name":"$self","line":1514},{"name":"$self","containerName":"_query_seq_feature","kind":13,"line":1515}]},{"line":1443,"kind":12,"name":"_making_qff"},{"line":1444,"name":"QUERY_START","kind":12},{"line":1445,"kind":12,"name":"QUERY_END"},{"name":"_query_factor","kind":12,"line":1446},{"line":1449,"kind":12,"name":"_query_factor"},{"kind":12,"name":"_sim1","line":1477},{"name":"Bio","containerName":"SeqFeature::Similarity","kind":12,"line":1477},{"line":1480,"kind":12,"name":"EVALUE"},{"kind":12,"name":"BITS","line":1481},{"line":1482,"kind":12,"name":"SCORE"},{"kind":12,"name":"QUERY_NAME","line":1484},{"kind":12,"name":"QUERY_LENGTH","line":1485},{"line":1486,"name":"ALGORITHM","kind":12},{"line":1487,"name":"QUERY_DESC","kind":12},{"line":1488,"name":"META","kind":12},{"kind":12,"name":"QUERY_FRAME","line":1491},{"name":"SUPER","containerName":"feature1","kind":12,"line":1512},{"line":1514,"name":"_created_qff","kind":12},{"name":"_making_qff","kind":12,"line":1515},{"definition":"sub","children":[{"containerName":"_subject_seq_feature","localvar":"my","kind":13,"name":"$self","line":1520,"definition":"my"},{"kind":13,"containerName":"_subject_seq_feature","name":"$self","line":1521},{"definition":"my","line":1522,"name":"$hs","localvar":"my","kind":13,"containerName":"_subject_seq_feature"},{"line":1522,"name":"$self","kind":13,"containerName":"_subject_seq_feature"},{"name":"$he","localvar":"my","containerName":"_subject_seq_feature","kind":13,"line":1523,"definition":"my"},{"kind":13,"containerName":"_subject_seq_feature","name":"$self","line":1523},{"kind":13,"containerName":"_subject_seq_feature","name":"$self","line":1524},{"kind":13,"containerName":"_subject_seq_feature","name":"$self","line":1525},{"line":1525,"containerName":"_subject_seq_feature","kind":12,"name":"_pre_seq_feature"},{"line":1527,"kind":13,"localvar":"my","containerName":"_subject_seq_feature","name":"$hitfactor","definition":"my"},{"line":1527,"kind":13,"containerName":"_subject_seq_feature","name":"$self"},{"containerName":"_subject_seq_feature","kind":13,"name":"$he","line":1529},{"name":"$hs","kind":13,"containerName":"_subject_seq_feature","line":1529},{"line":1529,"containerName":"_subject_seq_feature","kind":13,"name":"$self"},{"line":1529,"containerName":"_subject_seq_feature","kind":12,"name":"throw"},{"line":1531,"localvar":"my","containerName":"_subject_seq_feature","kind":13,"name":"$strand","definition":"my"},{"line":1532,"kind":13,"containerName":"_subject_seq_feature","name":"$he"},{"line":1532,"containerName":"_subject_seq_feature","kind":13,"name":"$hs"},{"kind":13,"containerName":"_subject_seq_feature","name":"$hitfactor","line":1533},{"line":1534,"kind":13,"containerName":"_subject_seq_feature","name":"$strand"},{"name":"$strand","containerName":"_subject_seq_feature","kind":13,"line":1537},{"name":"$hitfactor","containerName":"_subject_seq_feature","kind":13,"line":1541},{"kind":13,"containerName":"_subject_seq_feature","name":"$strand","line":1542},{"line":1545,"containerName":"_subject_seq_feature","kind":13,"name":"$strand"},{"line":1547,"name":"$hs","containerName":"_subject_seq_feature","kind":13},{"line":1547,"kind":13,"containerName":"_subject_seq_feature","name":"$he"},{"name":"$he","kind":13,"containerName":"_subject_seq_feature","line":1547},{"line":1547,"kind":13,"containerName":"_subject_seq_feature","name":"$hs"},{"localvar":"my","kind":13,"containerName":"_subject_seq_feature","name":"$sim2","line":1550,"definition":"my"},{"line":1550,"kind":13,"containerName":"_subject_seq_feature","name":"$self"},{"containerName":"_subject_seq_feature","kind":12,"name":"new","line":1550},{"line":1551,"kind":13,"containerName":"_subject_seq_feature","name":"$sim2"},{"name":"start","containerName":"_subject_seq_feature","kind":12,"line":1551},{"name":"$hs","kind":13,"containerName":"_subject_seq_feature","line":1551},{"name":"$sim2","kind":13,"containerName":"_subject_seq_feature","line":1552},{"line":1552,"containerName":"_subject_seq_feature","kind":12,"name":"end"},{"containerName":"_subject_seq_feature","kind":13,"name":"$he","line":1552},{"name":"$sim2","containerName":"_subject_seq_feature","kind":13,"line":1553},{"name":"significance","kind":12,"containerName":"_subject_seq_feature","line":1553},{"line":1553,"name":"$self","containerName":"_subject_seq_feature","kind":13},{"line":1554,"name":"$sim2","containerName":"_subject_seq_feature","kind":13},{"kind":12,"containerName":"_subject_seq_feature","name":"bits","line":1554},{"name":"$self","kind":13,"containerName":"_subject_seq_feature","line":1554},{"line":1555,"kind":13,"containerName":"_subject_seq_feature","name":"$sim2"},{"name":"score","containerName":"_subject_seq_feature","kind":12,"line":1555},{"line":1555,"name":"$self","containerName":"_subject_seq_feature","kind":13},{"name":"$sim2","kind":13,"containerName":"_subject_seq_feature","line":1556},{"line":1556,"containerName":"_subject_seq_feature","kind":12,"name":"strand"},{"line":1556,"name":"$strand","containerName":"_subject_seq_feature","kind":13},{"containerName":"_subject_seq_feature","kind":13,"name":"$sim2","line":1557},{"line":1557,"kind":12,"containerName":"_subject_seq_feature","name":"seq_id"},{"name":"$self","containerName":"_subject_seq_feature","kind":13,"line":1557},{"name":"$sim2","containerName":"_subject_seq_feature","kind":13,"line":1558},{"line":1558,"name":"seqlength","kind":12,"containerName":"_subject_seq_feature"},{"kind":13,"containerName":"_subject_seq_feature","name":"$self","line":1558},{"kind":13,"containerName":"_subject_seq_feature","name":"$sim2","line":1559},{"line":1559,"kind":12,"containerName":"_subject_seq_feature","name":"source_tag"},{"containerName":"_subject_seq_feature","kind":13,"name":"$self","line":1559},{"kind":13,"containerName":"_subject_seq_feature","name":"$sim2","line":1560},{"line":1560,"kind":12,"containerName":"_subject_seq_feature","name":"seqdesc"},{"line":1560,"kind":13,"containerName":"_subject_seq_feature","name":"$self"},{"line":1561,"name":"$sim2","containerName":"_subject_seq_feature","kind":13},{"kind":12,"containerName":"_subject_seq_feature","name":"add_tag_value","line":1561},{"containerName":"_subject_seq_feature","kind":13,"name":"$self","line":1561},{"line":1561,"name":"$self","containerName":"_subject_seq_feature","kind":13},{"kind":12,"containerName":"_subject_seq_feature","name":"can","line":1561},{"kind":13,"localvar":"my","containerName":"_subject_seq_feature","name":"$hframe","line":1562,"definition":"my"},{"line":1562,"name":"$self","containerName":"_subject_seq_feature","kind":13},{"kind":13,"containerName":"_subject_seq_feature","name":"$strand","line":1564},{"line":1564,"kind":13,"containerName":"_subject_seq_feature","name":"$hframe"},{"name":"$hitfactor","kind":13,"containerName":"_subject_seq_feature","line":1564},{"line":1565,"containerName":"_subject_seq_feature","kind":13,"name":"$hframe"},{"line":1565,"name":"$hs","kind":13,"containerName":"_subject_seq_feature"},{"line":1565,"containerName":"_subject_seq_feature","kind":13,"name":"$strand"},{"line":1567,"containerName":"_subject_seq_feature","kind":13,"name":"$strand"},{"containerName":"_subject_seq_feature","kind":13,"name":"$hframe","line":1568},{"name":"$hframe","containerName":"_subject_seq_feature","kind":13,"line":1571},{"definition":"my","name":"$dir","localvar":"my","kind":13,"containerName":"_subject_seq_feature","line":1572},{"kind":13,"containerName":"_subject_seq_feature","name":"$hframe","line":1573},{"kind":13,"containerName":"_subject_seq_feature","name":"$dir","line":1573},{"name":"$strand","containerName":"_subject_seq_feature","kind":13,"line":1573},{"line":1573,"containerName":"_subject_seq_feature","kind":13,"name":"$dir"},{"kind":13,"containerName":"_subject_seq_feature","name":"$strand","line":1573},{"line":1574,"name":"$self","containerName":"_subject_seq_feature","kind":13},{"line":1574,"name":"warn","containerName":"_subject_seq_feature","kind":12},{"name":"$hframe","kind":13,"containerName":"_subject_seq_feature","line":1576},{"line":1578,"name":"$self","kind":13,"containerName":"_subject_seq_feature"},{"line":1578,"kind":12,"containerName":"_subject_seq_feature","name":"warn"},{"line":1579,"name":"$hframe","kind":13,"containerName":"_subject_seq_feature"},{"line":1582,"containerName":"_subject_seq_feature","kind":13,"name":"$sim2"},{"name":"frame","kind":12,"containerName":"_subject_seq_feature","line":1582},{"line":1582,"name":"$hframe","kind":13,"containerName":"_subject_seq_feature"},{"containerName":"_subject_seq_feature","kind":13,"name":"$self","line":1583},{"name":"$sim2","containerName":"_subject_seq_feature","kind":13,"line":1583},{"name":"$self","kind":13,"containerName":"_subject_seq_feature","line":1585},{"kind":13,"containerName":"_subject_seq_feature","name":"$self","line":1586}],"name":"_subject_seq_feature","containerName":"main::","line":1519,"kind":12,"range":{"end":{"character":9999,"line":1587},"start":{"line":1519,"character":0}}},{"line":1521,"kind":12,"name":"_making_sff"},{"line":1522,"kind":12,"name":"HIT_START"},{"name":"HIT_END","kind":12,"line":1523},{"line":1524,"name":"_hit_factor","kind":12},{"line":1527,"kind":12,"name":"_hit_factor"},{"line":1550,"kind":12,"name":"_sim2"},{"kind":12,"containerName":"SeqFeature::Similarity","name":"Bio","line":1550},{"name":"EVALUE","kind":12,"line":1553},{"name":"BITS","kind":12,"line":1554},{"line":1555,"name":"SCORE","kind":12},{"line":1557,"kind":12,"name":"HIT_NAME"},{"name":"HIT_LENGTH","kind":12,"line":1558},{"kind":12,"name":"ALGORITHM","line":1559},{"name":"HIT_DESC","kind":12,"line":1560},{"line":1561,"kind":12,"name":"META"},{"line":1562,"name":"HIT_FRAME","kind":12},{"kind":12,"containerName":"feature2","name":"SUPER","line":1583},{"kind":12,"name":"_created_sff","line":1585},{"name":"_making_sff","kind":12,"line":1586},{"definition":"sub","containerName":"main::","name":"_pre_similar_stats","children":[{"line":1591,"name":"$self","containerName":"_pre_similar_stats","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":1592,"kind":13,"localvar":"my","containerName":"_pre_similar_stats","name":"$identical"},{"line":1592,"containerName":"_pre_similar_stats","kind":13,"name":"$self"},{"definition":"my","name":"$conserved","containerName":"_pre_similar_stats","localvar":"my","kind":13,"line":1593},{"name":"$self","containerName":"_pre_similar_stats","kind":13,"line":1593},{"definition":"my","line":1594,"name":"$percent_id","localvar":"my","containerName":"_pre_similar_stats","kind":13},{"line":1594,"name":"$self","kind":13,"containerName":"_pre_similar_stats"},{"containerName":"_pre_similar_stats","kind":13,"name":"$identical","line":1596},{"line":1597,"name":"$percent_id","containerName":"_pre_similar_stats","kind":13},{"line":1598,"name":"$self","kind":13,"containerName":"_pre_similar_stats"},{"name":"warn","kind":12,"containerName":"_pre_similar_stats","line":1598},{"line":1599,"name":"$identical","kind":13,"containerName":"_pre_similar_stats"},{"line":1602,"name":"$identical","kind":13,"containerName":"_pre_similar_stats"},{"name":"$percent_id","containerName":"_pre_similar_stats","kind":13,"line":1602},{"line":1602,"name":"$self","kind":13,"containerName":"_pre_similar_stats"},{"name":"$conserved","kind":13,"containerName":"_pre_similar_stats","line":1606},{"kind":13,"containerName":"_pre_similar_stats","name":"$self","line":1607},{"line":1607,"containerName":"_pre_similar_stats","kind":12,"name":"warn"},{"line":1608,"kind":13,"containerName":"_pre_similar_stats","name":"$self"},{"line":1609,"containerName":"_pre_similar_stats","kind":13,"name":"$conserved"},{"line":1609,"kind":13,"containerName":"_pre_similar_stats","name":"$identical"},{"line":1611,"name":"$self","containerName":"_pre_similar_stats","kind":13},{"name":"$identical","containerName":"_pre_similar_stats","kind":13,"line":1611},{"line":1612,"name":"$self","containerName":"_pre_similar_stats","kind":13},{"containerName":"_pre_similar_stats","kind":13,"name":"$conserved","line":1612},{"line":1613,"name":"$self","containerName":"_pre_similar_stats","kind":13}],"kind":12,"range":{"start":{"line":1590,"character":0},"end":{"line":1614,"character":9999}},"line":1590},{"line":1592,"name":"IDENTICAL","kind":12},{"kind":12,"name":"CONSERVED","line":1593},{"line":1594,"name":"PERCENT_IDENTITY","kind":12},{"name":"HSP_LENGTH","kind":12,"line":1602},{"name":"ALGORITHM","kind":12,"line":1608},{"line":1611,"name":"IDENTICAL","kind":12},{"line":1612,"kind":12,"name":"CONSERVED"},{"line":1613,"kind":12,"name":"_did_presimilar"},{"definition":"sub","containerName":"main::","name":"_pre_frac","children":[{"localvar":"my","containerName":"_pre_frac","kind":13,"name":"$self","line":1619,"definition":"my"},{"containerName":"_pre_frac","localvar":"my","kind":13,"name":"$hsp_len","line":1620,"definition":"my"},{"name":"$self","containerName":"_pre_frac","kind":13,"line":1620},{"localvar":"my","kind":13,"containerName":"_pre_frac","name":"$hit_len","line":1621,"definition":"my"},{"line":1621,"containerName":"_pre_frac","kind":13,"name":"$self"},{"definition":"my","kind":13,"localvar":"my","containerName":"_pre_frac","name":"$query_len","line":1622},{"line":1622,"kind":13,"containerName":"_pre_frac","name":"$self"},{"definition":"my","line":1624,"name":"$identical","kind":13,"localvar":"my","containerName":"_pre_frac"},{"kind":13,"containerName":"_pre_frac","name":"$self","line":1624},{"line":1624,"kind":12,"containerName":"_pre_frac","name":"num_identical"},{"definition":"my","line":1625,"localvar":"my","kind":13,"containerName":"_pre_frac","name":"$conserved"},{"name":"$self","containerName":"_pre_frac","kind":13,"line":1625},{"line":1625,"kind":12,"containerName":"_pre_frac","name":"num_conserved"},{"line":1627,"name":"$self","kind":13,"containerName":"_pre_frac"},{"definition":"my","containerName":"_pre_frac","localvar":"my","kind":13,"name":"$logical","line":1628},{"line":1629,"kind":13,"containerName":"_pre_frac","name":"$hsp_len"},{"line":1630,"kind":13,"containerName":"_pre_frac","name":"$self"},{"name":"length","kind":12,"containerName":"_pre_frac","line":1630},{"line":1630,"name":"$hsp_len","kind":13,"containerName":"_pre_frac"},{"line":1631,"name":"$logical","containerName":"_pre_frac","kind":13},{"line":1631,"name":"$self","kind":13,"containerName":"_pre_frac"},{"name":"_logical_length","kind":12,"containerName":"_pre_frac","line":1631},{"line":1632,"kind":13,"containerName":"_pre_frac","name":"$self"},{"kind":12,"containerName":"_pre_frac","name":"frac_identical","line":1632},{"kind":13,"containerName":"_pre_frac","name":"$identical","line":1632},{"line":1632,"kind":13,"containerName":"_pre_frac","name":"$hsp_len"},{"line":1633,"kind":13,"containerName":"_pre_frac","name":"$self"},{"containerName":"_pre_frac","kind":12,"name":"frac_conserved","line":1633},{"line":1633,"containerName":"_pre_frac","kind":13,"name":"$conserved"},{"line":1633,"name":"$hsp_len","kind":13,"containerName":"_pre_frac"},{"containerName":"_pre_frac","kind":13,"name":"$hit_len","line":1635},{"line":1636,"name":"$logical","kind":13,"containerName":"_pre_frac"},{"name":"$self","kind":13,"containerName":"_pre_frac","line":1636},{"name":"_logical_length","kind":12,"containerName":"_pre_frac","line":1636},{"line":1637,"containerName":"_pre_frac","kind":13,"name":"$self"},{"line":1637,"kind":12,"containerName":"_pre_frac","name":"frac_identical"},{"line":1637,"kind":13,"containerName":"_pre_frac","name":"$identical"},{"name":"$logical","kind":13,"containerName":"_pre_frac","line":1637},{"kind":13,"containerName":"_pre_frac","name":"$self","line":1638},{"name":"frac_conserved","containerName":"_pre_frac","kind":12,"line":1638},{"line":1638,"containerName":"_pre_frac","kind":13,"name":"$conserved"},{"name":"$logical","containerName":"_pre_frac","kind":13,"line":1638},{"line":1640,"name":"$query_len","kind":13,"containerName":"_pre_frac"},{"kind":13,"containerName":"_pre_frac","name":"$logical","line":1641},{"line":1641,"kind":13,"containerName":"_pre_frac","name":"$self"},{"kind":12,"containerName":"_pre_frac","name":"_logical_length","line":1641},{"line":1642,"containerName":"_pre_frac","kind":13,"name":"$self"},{"containerName":"_pre_frac","kind":12,"name":"frac_identical","line":1642},{"kind":13,"containerName":"_pre_frac","name":"$identical","line":1642},{"kind":13,"containerName":"_pre_frac","name":"$logical","line":1642},{"line":1643,"name":"$self","kind":13,"containerName":"_pre_frac"},{"line":1643,"name":"frac_conserved","kind":12,"containerName":"_pre_frac"},{"containerName":"_pre_frac","kind":13,"name":"$conserved","line":1643},{"kind":13,"containerName":"_pre_frac","name":"$logical","line":1643}],"range":{"end":{"character":9999,"line":1645},"start":{"line":1618,"character":0}},"kind":12,"line":1618},{"name":"HSP_LENGTH","kind":12,"line":1620},{"kind":12,"name":"HIT_LENGTH","line":1621},{"line":1622,"name":"QUERY_LENGTH","kind":12},{"line":1627,"name":"_did_prefrac","kind":12},{"definition":"sub","children":[{"line":1653,"name":"$self","containerName":"_pre_gaps","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":1654,"name":"$query_gaps","containerName":"_pre_gaps","localvar":"my","kind":13},{"containerName":"_pre_gaps","kind":13,"name":"$self","line":1654},{"definition":"my","name":"$query_seq","containerName":"_pre_gaps","localvar":"my","kind":13,"line":1655},{"kind":13,"containerName":"_pre_gaps","name":"$self","line":1655},{"line":1656,"kind":13,"localvar":"my","containerName":"_pre_gaps","name":"$hit_gaps","definition":"my"},{"name":"$self","kind":13,"containerName":"_pre_gaps","line":1656},{"definition":"my","line":1657,"kind":13,"localvar":"my","containerName":"_pre_gaps","name":"$hit_seq"},{"name":"$self","kind":13,"containerName":"_pre_gaps","line":1657},{"name":"$gaps","localvar":"my","containerName":"_pre_gaps","kind":13,"line":1658,"definition":"my"},{"line":1658,"kind":13,"containerName":"_pre_gaps","name":"$self"},{"line":1660,"kind":13,"containerName":"_pre_gaps","name":"$self"},{"line":1661,"containerName":"_pre_gaps","kind":13,"name":"$query_gaps"},{"name":"$self","kind":13,"containerName":"_pre_gaps","line":1662},{"line":1662,"kind":12,"containerName":"_pre_gaps","name":"gaps"},{"name":"$query_gaps","kind":13,"containerName":"_pre_gaps","line":1662},{"name":"$query_seq","kind":13,"containerName":"_pre_gaps","line":1663},{"line":1664,"name":"$qg","kind":13,"localvar":"my","containerName":"_pre_gaps","definition":"my"},{"name":"$self","containerName":"_pre_gaps","kind":13,"line":1664},{"name":"$self","containerName":"_pre_gaps","kind":13,"line":1664},{"containerName":"_pre_gaps","kind":12,"name":"seq_inds","line":1664},{"containerName":"_pre_gaps","kind":13,"name":"$query_seq","line":1664},{"line":1665,"containerName":"_pre_gaps","localvar":"my","kind":13,"name":"$offset","definition":"my"},{"line":1665,"kind":13,"containerName":"_pre_gaps","name":"$self"},{"name":"$self","containerName":"_pre_gaps","kind":13,"line":1666},{"line":1666,"kind":12,"containerName":"_pre_gaps","name":"gaps"},{"line":1666,"kind":13,"containerName":"_pre_gaps","name":"$qg"},{"line":1666,"name":"$offset","kind":13,"containerName":"_pre_gaps"},{"line":1668,"kind":13,"containerName":"_pre_gaps","name":"$hit_gaps"},{"line":1669,"name":"$self","kind":13,"containerName":"_pre_gaps"},{"name":"gaps","kind":12,"containerName":"_pre_gaps","line":1669},{"name":"$hit_gaps","containerName":"_pre_gaps","kind":13,"line":1669},{"line":1670,"name":"$hit_seq","kind":13,"containerName":"_pre_gaps"},{"definition":"my","localvar":"my","containerName":"_pre_gaps","kind":13,"name":"$hg","line":1671},{"line":1671,"kind":13,"containerName":"_pre_gaps","name":"$self"},{"line":1671,"containerName":"_pre_gaps","kind":13,"name":"$self"},{"line":1671,"name":"seq_inds","containerName":"_pre_gaps","kind":12},{"line":1671,"name":"$hit_seq","containerName":"_pre_gaps","kind":13},{"line":1672,"name":"$offset","localvar":"my","containerName":"_pre_gaps","kind":13,"definition":"my"},{"line":1672,"containerName":"_pre_gaps","kind":13,"name":"$self"},{"line":1673,"containerName":"_pre_gaps","kind":13,"name":"$self"},{"line":1673,"name":"gaps","containerName":"_pre_gaps","kind":12},{"line":1673,"name":"$hg","kind":13,"containerName":"_pre_gaps"},{"name":"$offset","kind":13,"containerName":"_pre_gaps","line":1673},{"line":1675,"kind":13,"containerName":"_pre_gaps","name":"$gaps"},{"line":1676,"name":"$gaps","kind":13,"containerName":"_pre_gaps"},{"name":"$self","containerName":"_pre_gaps","kind":13,"line":1676},{"line":1676,"name":"gaps","kind":12,"containerName":"_pre_gaps"},{"line":1676,"kind":13,"containerName":"_pre_gaps","name":"$self"},{"name":"gaps","containerName":"_pre_gaps","kind":12,"line":1676},{"name":"$self","containerName":"_pre_gaps","kind":13,"line":1678},{"line":1678,"kind":12,"containerName":"_pre_gaps","name":"gaps"},{"containerName":"_pre_gaps","kind":13,"name":"$gaps","line":1678}],"name":"_pre_gaps","containerName":"main::","line":1652,"range":{"start":{"character":0,"line":1652},"end":{"line":1679,"character":9999}},"kind":12},{"name":"QUERY_GAPS","kind":12,"line":1654},{"line":1655,"kind":12,"name":"QUERY_SEQ"},{"line":1656,"name":"HIT_GAPS","kind":12},{"line":1657,"kind":12,"name":"HIT_SEQ"},{"line":1658,"kind":12,"name":"HSP_GAPS"},{"kind":12,"name":"_did_pregaps","line":1660},{"definition":"sub","children":[{"definition":"my","line":1683,"localvar":"my","containerName":"_pre_pi","kind":13,"name":"$self"},{"line":1684,"kind":13,"containerName":"_pre_pi","name":"$self"},{"name":"$self","kind":13,"containerName":"_pre_pi","line":1685},{"name":"percent_identity","kind":12,"containerName":"_pre_pi","line":1685},{"line":1685,"name":"$self","kind":13,"containerName":"_pre_pi"},{"line":1685,"kind":13,"containerName":"_pre_pi","name":"$self"},{"line":1685,"name":"frac_identical","kind":12,"containerName":"_pre_pi"},{"line":1685,"kind":13,"containerName":"_pre_pi","name":"$self"}],"name":"_pre_pi","containerName":"main::","line":1682,"kind":12,"range":{"end":{"line":1686,"character":9999},"start":{"character":0,"line":1682}}},{"kind":12,"name":"_did_prepi","line":1684},{"kind":12,"name":"PERCENT_IDENTITY","line":1685},{"kind":12,"name":"HSP_LENGTH","line":1685}]}