{"version":5,"vars":[{"line":0,"kind":12,"name":"head1"},{"line":1,"name":"NAME","kind":12},{"line":2,"name":"Bio","kind":12,"containerName":"Search::BlastUtils"},{"name":"Utility","kind":12,"line":2},{"line":2,"kind":12,"name":"functions"},{"name":"objects","kind":12,"line":3},{"definition":"sub","name":"tile_hsps","containerName":"main::","children":[{"definition":"my","line":112,"name":"$sbjct","containerName":"tile_hsps","localvar":"my","kind":13},{"name":"$sbjct","kind":13,"containerName":"tile_hsps","line":114},{"line":115,"name":"$sbjct","kind":13,"containerName":"tile_hsps"},{"line":116,"name":"$sbjct","containerName":"tile_hsps","kind":13},{"kind":13,"containerName":"tile_hsps","name":"$sbjct","line":119},{"containerName":"tile_hsps","kind":13,"name":"$sbjct","line":119},{"line":119,"containerName":"tile_hsps","kind":13,"name":"$sbjct"},{"name":"num_hsps","kind":12,"containerName":"tile_hsps","line":119},{"definition":"my","name":"$hsp","containerName":"tile_hsps","localvar":"my","kind":13,"line":120},{"name":"$sbjct","kind":13,"containerName":"tile_hsps","line":120},{"line":120,"name":"hsp","kind":12,"containerName":"tile_hsps"},{"line":121,"containerName":"tile_hsps","kind":13,"name":"$sbjct"},{"containerName":"tile_hsps","kind":13,"name":"$hsp","line":121},{"line":121,"containerName":"tile_hsps","kind":12,"name":"length"},{"containerName":"tile_hsps","kind":13,"name":"$sbjct","line":122},{"line":122,"containerName":"tile_hsps","kind":13,"name":"$hsp"},{"line":122,"kind":12,"containerName":"tile_hsps","name":"length"},{"name":"$sbjct","kind":13,"containerName":"tile_hsps","line":123},{"line":123,"name":"$hsp","containerName":"tile_hsps","kind":13},{"line":123,"name":"length","kind":12,"containerName":"tile_hsps"},{"containerName":"tile_hsps","kind":13,"name":"$sbjct","line":124},{"name":"$sbjct","kind":13,"containerName":"tile_hsps","line":124},{"name":"$hsp","containerName":"tile_hsps","kind":13,"line":124},{"line":124,"containerName":"tile_hsps","kind":12,"name":"matches"},{"kind":13,"containerName":"tile_hsps","name":"$sbjct","line":125},{"name":"$hsp","containerName":"tile_hsps","kind":13,"line":125},{"kind":12,"containerName":"tile_hsps","name":"gaps","line":125},{"kind":13,"containerName":"tile_hsps","name":"$sbjct","line":126},{"line":126,"kind":13,"containerName":"tile_hsps","name":"$hsp"},{"line":126,"kind":12,"containerName":"tile_hsps","name":"gaps"},{"name":"$sbjct","kind":13,"containerName":"tile_hsps","line":132},{"line":133,"name":"$sbjct","containerName":"tile_hsps","kind":13},{"line":134,"name":"$sbjct","containerName":"tile_hsps","kind":13},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":135},{"line":136,"containerName":"tile_hsps","kind":13,"name":"$sbjct"},{"line":141,"name":"$hsp","localvar":"my","containerName":"tile_hsps","kind":13,"definition":"my"},{"line":141,"name":"$qstart","kind":13,"containerName":"tile_hsps"},{"name":"$qstop","kind":13,"containerName":"tile_hsps","line":141},{"kind":13,"containerName":"tile_hsps","name":"$sstart","line":141},{"line":141,"name":"$sstop","kind":13,"containerName":"tile_hsps"},{"definition":"my","name":"$frame","localvar":"my","kind":13,"containerName":"tile_hsps","line":142},{"line":142,"kind":13,"containerName":"tile_hsps","name":"$strand"},{"line":142,"name":"$qstrand","kind":13,"containerName":"tile_hsps"},{"line":142,"name":"$sstrand","kind":13,"containerName":"tile_hsps"},{"definition":"my","name":"@qcontigs","localvar":"my","kind":13,"containerName":"tile_hsps","line":143},{"line":143,"kind":13,"containerName":"tile_hsps","name":"@scontigs"},{"definition":"my","line":144,"name":"$qoverlap","localvar":"my","kind":13,"containerName":"tile_hsps"},{"name":"$soverlap","localvar":"my","containerName":"tile_hsps","kind":13,"line":145,"definition":"my"},{"definition":"my","line":146,"name":"$max_overlap","localvar":"my","kind":13,"containerName":"tile_hsps"},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":146},{"line":148,"kind":13,"containerName":"tile_hsps","name":"$hsp"},{"line":148,"name":"$sbjct","kind":13,"containerName":"tile_hsps"},{"line":148,"name":"hsps","kind":12,"containerName":"tile_hsps"},{"line":151,"kind":13,"containerName":"tile_hsps","name":"$qstart"},{"containerName":"tile_hsps","kind":13,"name":"$qstop","line":151},{"line":151,"name":"$hsp","containerName":"tile_hsps","kind":13},{"line":151,"name":"range","kind":12,"containerName":"tile_hsps"},{"kind":13,"containerName":"tile_hsps","name":"$sstart","line":152},{"kind":13,"containerName":"tile_hsps","name":"$sstop","line":152},{"name":"$hsp","kind":13,"containerName":"tile_hsps","line":152},{"line":152,"containerName":"tile_hsps","kind":12,"name":"range"},{"line":153,"kind":13,"containerName":"tile_hsps","name":"$frame"},{"containerName":"tile_hsps","kind":13,"name":"$hsp","line":153},{"name":"frame","containerName":"tile_hsps","kind":12,"line":153},{"line":154,"kind":13,"containerName":"tile_hsps","name":"$frame"},{"containerName":"tile_hsps","kind":13,"name":"$frame","line":154},{"line":155,"name":"$qstrand","kind":13,"containerName":"tile_hsps"},{"line":155,"kind":13,"containerName":"tile_hsps","name":"$sstrand"},{"name":"$hsp","kind":13,"containerName":"tile_hsps","line":155},{"line":155,"containerName":"tile_hsps","kind":12,"name":"strand"},{"line":157,"localvar":"my","containerName":"tile_hsps","kind":13,"name":"$qgaps","definition":"my"},{"containerName":"tile_hsps","kind":13,"name":"$sgaps","line":157},{"containerName":"tile_hsps","kind":13,"name":"$hsp","line":157},{"line":157,"name":"gaps","kind":12,"containerName":"tile_hsps"},{"kind":13,"containerName":"tile_hsps","name":"$sbjct","line":158},{"containerName":"tile_hsps","kind":13,"name":"$qgaps","line":158},{"kind":13,"containerName":"tile_hsps","name":"$sbjct","line":159},{"line":159,"name":"$sgaps","containerName":"tile_hsps","kind":13},{"kind":13,"containerName":"tile_hsps","name":"$sbjct","line":161},{"containerName":"tile_hsps","kind":13,"name":"$hsp","line":161},{"containerName":"tile_hsps","kind":12,"name":"length","line":161},{"line":163,"name":"$qoverlap","kind":13,"containerName":"tile_hsps"},{"name":"$hsp","containerName":"tile_hsps","kind":13,"line":163},{"kind":13,"containerName":"tile_hsps","name":"$qstart","line":163},{"kind":13,"containerName":"tile_hsps","name":"$qstop","line":163},{"name":"@qcontigs","kind":13,"containerName":"tile_hsps","line":163},{"name":"$max_overlap","kind":13,"containerName":"tile_hsps","line":163},{"name":"$frame","kind":13,"containerName":"tile_hsps","line":163},{"line":163,"name":"$qstrand","containerName":"tile_hsps","kind":13},{"containerName":"tile_hsps","kind":13,"name":"$soverlap","line":166},{"name":"$hsp","containerName":"tile_hsps","kind":13,"line":166},{"name":"$sstart","containerName":"tile_hsps","kind":13,"line":166},{"line":166,"containerName":"tile_hsps","kind":13,"name":"$sstop"},{"containerName":"tile_hsps","kind":13,"name":"@scontigs","line":166},{"kind":13,"containerName":"tile_hsps","name":"$max_overlap","line":166},{"line":166,"kind":13,"containerName":"tile_hsps","name":"$frame"},{"name":"$sstrand","kind":13,"containerName":"tile_hsps","line":166},{"line":169,"name":"$sbjct","kind":13,"containerName":"tile_hsps"},{"name":"$sbjct","kind":13,"containerName":"tile_hsps","line":170},{"line":170,"name":"$qstart","containerName":"tile_hsps","kind":13},{"line":171,"name":"$sbjct","kind":13,"containerName":"tile_hsps"},{"name":"$qstop","kind":13,"containerName":"tile_hsps","line":171},{"line":172,"kind":13,"containerName":"tile_hsps","name":"$sbjct"},{"line":172,"kind":13,"containerName":"tile_hsps","name":"$sstart"},{"containerName":"tile_hsps","kind":13,"name":"$sbjct","line":173},{"line":173,"kind":13,"containerName":"tile_hsps","name":"$sstop"},{"kind":13,"containerName":"tile_hsps","name":"$sbjct","line":175},{"name":"$qstart","containerName":"tile_hsps","kind":13,"line":175},{"line":175,"containerName":"tile_hsps","kind":13,"name":"$sbjct"},{"name":"$qstart","containerName":"tile_hsps","kind":13,"line":175},{"line":175,"kind":13,"containerName":"tile_hsps","name":"$sbjct"},{"line":176,"containerName":"tile_hsps","kind":13,"name":"$sbjct"},{"line":176,"name":"$qstop","containerName":"tile_hsps","kind":13},{"name":"$sbjct","kind":13,"containerName":"tile_hsps","line":176},{"name":"$qstop","kind":13,"containerName":"tile_hsps","line":176},{"name":"$sbjct","kind":13,"containerName":"tile_hsps","line":176},{"line":177,"name":"$sbjct","kind":13,"containerName":"tile_hsps"},{"containerName":"tile_hsps","kind":13,"name":"$sstart","line":177},{"containerName":"tile_hsps","kind":13,"name":"$sbjct","line":177},{"line":177,"name":"$sstart","kind":13,"containerName":"tile_hsps"},{"line":177,"kind":13,"containerName":"tile_hsps","name":"$sbjct"},{"line":178,"name":"$sbjct","kind":13,"containerName":"tile_hsps"},{"line":178,"kind":13,"containerName":"tile_hsps","name":"$sstop"},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":178},{"kind":13,"containerName":"tile_hsps","name":"$sstop","line":178},{"line":178,"name":"$sbjct","containerName":"tile_hsps","kind":13},{"line":189,"containerName":"tile_hsps","localvar":"my","kind":13,"name":"%qctg_dat","definition":"my"},{"line":190,"containerName":"tile_hsps","kind":13,"name":"@qcontigs"},{"kind":13,"containerName":"tile_hsps","name":"$frame","line":193},{"kind":13,"containerName":"tile_hsps","name":"$strand","line":193},{"line":194,"name":"$qctg_dat","kind":13,"containerName":"tile_hsps"},{"line":195,"containerName":"tile_hsps","kind":13,"name":"$qctg_dat"},{"line":196,"name":"$qctg_dat","containerName":"tile_hsps","kind":13},{"line":197,"containerName":"tile_hsps","kind":13,"name":"$qctg_dat"},{"name":"$strand","containerName":"tile_hsps","kind":13,"line":197},{"line":201,"name":"@sortedkeys","containerName":"tile_hsps","localvar":"my","kind":13,"definition":"my"},{"name":"$qctg_dat","kind":13,"containerName":"tile_hsps","line":201},{"name":"$a","containerName":"tile_hsps","kind":13,"line":201},{"line":201,"kind":13,"containerName":"tile_hsps","name":"$qctg_dat"},{"name":"$b","containerName":"tile_hsps","kind":13,"line":201},{"line":201,"kind":13,"containerName":"tile_hsps","name":"%qctg_dat"},{"line":204,"localvar":"my","containerName":"tile_hsps","kind":13,"name":"$longest","definition":"my"},{"line":204,"name":"$sortedkeys","kind":13,"containerName":"tile_hsps"},{"line":205,"name":"$sbjct","containerName":"tile_hsps","kind":13},{"name":"$qctg_dat","kind":13,"containerName":"tile_hsps","line":205},{"name":"$longest","kind":13,"containerName":"tile_hsps","line":205},{"kind":13,"containerName":"tile_hsps","name":"$sbjct","line":206},{"line":206,"name":"$qctg_dat","kind":13,"containerName":"tile_hsps"},{"name":"$longest","kind":13,"containerName":"tile_hsps","line":206},{"line":207,"containerName":"tile_hsps","kind":13,"name":"$sbjct"},{"line":207,"name":"$qctg_dat","containerName":"tile_hsps","kind":13},{"line":207,"containerName":"tile_hsps","kind":13,"name":"$longest"},{"containerName":"tile_hsps","kind":13,"name":"$sbjct","line":208},{"name":"$qctg_dat","containerName":"tile_hsps","kind":13,"line":208},{"line":208,"containerName":"tile_hsps","kind":13,"name":"$longest"},{"line":217,"name":"%sctg_dat","kind":13,"localvar":"my","containerName":"tile_hsps","definition":"my"},{"kind":13,"containerName":"tile_hsps","name":"@scontigs","line":218},{"line":221,"kind":13,"containerName":"tile_hsps","name":"$frame"},{"line":221,"kind":13,"containerName":"tile_hsps","name":"$strand"},{"line":222,"name":"$sctg_dat","containerName":"tile_hsps","kind":13},{"kind":13,"containerName":"tile_hsps","name":"$sctg_dat","line":223},{"name":"$frame","kind":13,"containerName":"tile_hsps","line":223},{"line":224,"kind":13,"containerName":"tile_hsps","name":"$sctg_dat"},{"line":224,"kind":13,"containerName":"tile_hsps","name":"$strand"},{"containerName":"tile_hsps","kind":13,"name":"@sortedkeys","line":227},{"name":"$sctg_dat","kind":13,"containerName":"tile_hsps","line":227},{"kind":13,"containerName":"tile_hsps","name":"$a","line":227},{"containerName":"tile_hsps","kind":13,"name":"$sctg_dat","line":227},{"line":227,"name":"$b","containerName":"tile_hsps","kind":13},{"containerName":"tile_hsps","kind":13,"name":"%sctg_dat","line":227},{"line":230,"name":"$longest","kind":13,"containerName":"tile_hsps"},{"line":230,"name":"$sortedkeys","containerName":"tile_hsps","kind":13},{"line":232,"containerName":"tile_hsps","kind":13,"name":"$sbjct"},{"line":232,"name":"$sctg_dat","kind":13,"containerName":"tile_hsps"},{"kind":13,"containerName":"tile_hsps","name":"$longest","line":232},{"line":233,"kind":13,"containerName":"tile_hsps","name":"$sbjct"},{"kind":13,"containerName":"tile_hsps","name":"$sctg_dat","line":233},{"line":233,"containerName":"tile_hsps","kind":13,"name":"$longest"},{"line":234,"containerName":"tile_hsps","kind":13,"name":"$sbjct"},{"kind":13,"containerName":"tile_hsps","name":"$sctg_dat","line":234},{"line":234,"kind":13,"containerName":"tile_hsps","name":"$longest"},{"kind":13,"containerName":"tile_hsps","name":"$qoverlap","line":236},{"kind":13,"containerName":"tile_hsps","name":"$soverlap","line":237},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":237},{"line":237,"name":"ambiguous_aln","kind":12,"containerName":"tile_hsps"},{"containerName":"tile_hsps","kind":13,"name":"$sbjct","line":240},{"name":"ambiguous_aln","containerName":"tile_hsps","kind":12,"line":240},{"line":243,"kind":13,"containerName":"tile_hsps","name":"$soverlap"},{"name":"$sbjct","containerName":"tile_hsps","kind":13,"line":244},{"line":244,"name":"ambiguous_aln","kind":12,"containerName":"tile_hsps"},{"line":249,"name":"$prog","kind":13,"localvar":"my","containerName":"tile_hsps","definition":"my"},{"line":249,"containerName":"tile_hsps","kind":13,"name":"$sbjct"},{"containerName":"tile_hsps","kind":12,"name":"algorithm","line":249},{"line":250,"name":"$prog","containerName":"tile_hsps","kind":13},{"containerName":"tile_hsps","kind":13,"name":"$sbjct","line":251},{"line":252,"containerName":"tile_hsps","kind":13,"name":"$prog"},{"kind":13,"containerName":"tile_hsps","name":"$sbjct","line":253},{"line":254,"name":"$prog","kind":13,"containerName":"tile_hsps"},{"containerName":"tile_hsps","kind":13,"name":"$sbjct","line":255},{"kind":13,"containerName":"tile_hsps","name":"$sbjct","line":256}],"kind":12,"range":{"start":{"line":110,"character":0},"end":{"line":258,"character":9999}},"line":110},{"kind":2,"containerName":"Bio::Search::BLAST::Bio::Search::BlastUtils::Bio::Root","name":"Version","line":112},{"kind":12,"name":"_adjust_contigs","line":163},{"line":166,"kind":12,"name":"_adjust_contigs"},{"definition":"sub","detail":"($seqType,$hsp,$start,$stop,$contigs_ref,$max_overlap,$frame,$strand)","children":[{"name":"$seqType","containerName":"_adjust_contigs","localvar":"my","kind":13,"line":285,"definition":"my"},{"line":285,"name":"$hsp","kind":13,"containerName":"_adjust_contigs"},{"kind":13,"containerName":"_adjust_contigs","name":"$start","line":285},{"kind":13,"containerName":"_adjust_contigs","name":"$stop","line":285},{"name":"$contigs_ref","kind":13,"containerName":"_adjust_contigs","line":285},{"line":285,"name":"$max_overlap","containerName":"_adjust_contigs","kind":13},{"line":285,"containerName":"_adjust_contigs","kind":13,"name":"$frame"},{"name":"$strand","containerName":"_adjust_contigs","kind":13,"line":285},{"definition":"my","line":287,"kind":13,"localvar":"my","containerName":"_adjust_contigs","name":"$overlap"},{"definition":"my","line":288,"kind":13,"localvar":"my","containerName":"_adjust_contigs","name":"$numID"},{"containerName":"_adjust_contigs","kind":13,"name":"$numCons","line":288},{"line":291,"name":"$contigs_ref","kind":13,"containerName":"_adjust_contigs"},{"line":295,"kind":13,"containerName":"_adjust_contigs","name":"$frame"},{"kind":13,"containerName":"_adjust_contigs","name":"$strand","line":295},{"name":"$start","kind":13,"containerName":"_adjust_contigs","line":298},{"containerName":"_adjust_contigs","kind":13,"name":"$stop","line":298},{"name":"$overlap","kind":13,"containerName":"_adjust_contigs","line":300},{"kind":13,"containerName":"_adjust_contigs","name":"$start","line":305},{"containerName":"_adjust_contigs","kind":13,"name":"$stop","line":305},{"name":"$max_overlap","containerName":"_adjust_contigs","kind":13,"line":305},{"line":309,"kind":13,"containerName":"_adjust_contigs","name":"$numID"},{"containerName":"_adjust_contigs","kind":13,"name":"$numCons","line":309},{"line":309,"kind":13,"containerName":"_adjust_contigs","name":"$hsp"},{"name":"matches","kind":12,"containerName":"_adjust_contigs","line":309},{"line":309,"name":"$seqType","kind":13,"containerName":"_adjust_contigs"},{"name":"$start","kind":13,"containerName":"_adjust_contigs","line":310},{"kind":13,"containerName":"_adjust_contigs","name":"$start","line":315},{"kind":13,"containerName":"_adjust_contigs","name":"$numID","line":316},{"line":317,"containerName":"_adjust_contigs","kind":13,"name":"$numCons"},{"line":318,"name":"$overlap","containerName":"_adjust_contigs","kind":13},{"line":323,"containerName":"_adjust_contigs","kind":13,"name":"$stop"},{"line":323,"name":"$start","kind":13,"containerName":"_adjust_contigs"},{"name":"$max_overlap","kind":13,"containerName":"_adjust_contigs","line":323},{"name":"$numID","containerName":"_adjust_contigs","kind":13,"line":327},{"name":"$numCons","kind":13,"containerName":"_adjust_contigs","line":327},{"kind":13,"containerName":"_adjust_contigs","name":"$hsp","line":327},{"name":"matches","kind":12,"containerName":"_adjust_contigs","line":327},{"line":327,"name":"$seqType","containerName":"_adjust_contigs","kind":13},{"name":"$stop","kind":13,"containerName":"_adjust_contigs","line":329},{"name":"$stop","kind":13,"containerName":"_adjust_contigs","line":333},{"name":"$numID","containerName":"_adjust_contigs","kind":13,"line":334},{"name":"$numCons","kind":13,"containerName":"_adjust_contigs","line":335},{"line":336,"name":"$overlap","kind":13,"containerName":"_adjust_contigs"},{"line":339,"name":"$overlap","containerName":"_adjust_contigs","kind":13},{"line":346,"name":"$overlap","kind":13,"containerName":"_adjust_contigs"},{"name":"$numID","containerName":"_adjust_contigs","kind":13,"line":348},{"line":348,"name":"$numCons","containerName":"_adjust_contigs","kind":13},{"kind":13,"containerName":"_adjust_contigs","name":"$hsp","line":348},{"name":"matches","kind":12,"containerName":"_adjust_contigs","line":348},{"name":"$seqType","kind":13,"containerName":"_adjust_contigs","line":348},{"line":349,"name":"$contigs_ref","containerName":"_adjust_contigs","kind":13},{"line":349,"containerName":"_adjust_contigs","kind":13,"name":"$start"},{"line":349,"name":"$stop","containerName":"_adjust_contigs","kind":13},{"line":350,"name":"$numID","containerName":"_adjust_contigs","kind":13},{"name":"$numCons","kind":13,"containerName":"_adjust_contigs","line":350},{"name":"$strand","kind":13,"containerName":"_adjust_contigs","line":351},{"name":"$frame","kind":13,"containerName":"_adjust_contigs","line":351},{"name":"$overlap","kind":13,"containerName":"_adjust_contigs","line":353}],"name":"_adjust_contigs","containerName":"main::","signature":{"label":"_adjust_contigs($seqType,$hsp,$start,$stop,$contigs_ref,$max_overlap,$frame,$strand)","documentation":"1;\n=head1 NAME\n\nBio::Search::BlastUtils - Utility functions for Bio::Search:: BLAST objects\n\n=head1 SYNOPSIS\n\n # This module is just a collection of subroutines, not an object.\n\nSee L<Bio::Search::Hit::BlastHit>.\n\n=head1 DESCRIPTION\n\nThe BlastUtils.pm module is a collection of subroutines used primarily by\nBio::Search::Hit::BlastHit objects for some of the additional\nfunctionality, such as HSP tiling. Right now, the BlastUtils is just a\ncollection of methods, not an object, and it's tightly coupled to\nBio::Search::Hit::BlastHit. A goal for the future is to generalize it\nto work based on the Bio::Search interfaces, then it can work with any\nobjects that implements them.\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\n\n#'\n\npackage Bio::Search::BlastUtils;\nuse Bio::Root::Version;\n\n\n=head2 tile_hsps\n\n Usage     : tile_hsps( $sbjct );\n           : This is called automatically by Bio::Search::Hit::BlastHit \n           : during object construction or\n           : as needed by methods that rely on having tiled data.\n Purpose   : Collect statistics about the aligned sequences in a set of HSPs.\n           : Calculates the following data across all HSPs: \n           :    -- total alignment length \n           :    -- total identical residues \n           :    -- total conserved residues\n Returns   : n/a\n Argument  : A Bio::Search::Hit::BlastHit object \n Throws    : n/a\n Comments  :\n \t   : This method is *strongly* coupled to Bio::Search::Hit::BlastHit\n \t   : (it accesses BlastHit data members directly).\n \t   : TODO: Re-write this to the Bio::Search::Hit::HitI interface.\n \t   :\n           : This method performs more careful summing of data across\n           : all HSPs in the Sbjct object. Only HSPs that are in the same strand \n           : and frame are tiled. Simply summing the data from all HSPs\n           : in the same strand and frame will overestimate the actual \n           : length of the alignment if there is overlap between different HSPs \n           : (often the case).\n           :\n           : The strategy is to tile the HSPs and sum over the\n           : contigs, collecting data separately from overlapping and\n           : non-overlapping regions of each HSP. To facilitate this, the\n           : HSP.pm object now permits extraction of data from sub-sections\n           : of an HSP.\n           : \n           : Additional useful information is collected from the results\n           : of the tiling. It is possible that sub-sequences in\n           : different HSPs will overlap significantly. In this case, it\n           : is impossible to create a single unambiguous alignment by\n           : concatenating the HSPs. The ambiguity may indicate the\n           : presence of multiple, similar domains in one or both of the\n           : aligned sequences. This ambiguity is recorded using the\n           : ambiguous_aln() method.\n           : \n           : This method does not attempt to discern biologically\n           : significant vs. insignificant overlaps. The allowable amount of \n           : overlap can be set with the overlap() method or with the -OVERLAP\n           : parameter used when constructing the Blast & Sbjct objects. \n           : \n           : For a given hit, both the query and the sbjct sequences are\n           : tiled independently.\n           : \n           :    -- If only query sequence HSPs overlap, \n           :          this may suggest multiple domains in the sbjct.\n           :    -- If only sbjct sequence HSPs overlap, \n           :          this may suggest multiple domains in the query.\n           :    -- If both query & sbjct sequence HSPs overlap, \n           :          this suggests multiple domains in both.\n           :    -- If neither query & sbjct sequence HSPs overlap, \n           :          this suggests either no multiple domains in either\n           :          sequence OR that both sequences have the same\n           :          distribution of multiple similar domains.\n           : \n           : This method can deal with the special case of when multiple\n           : HSPs exactly overlap.\n           : \n           : Efficiency concerns:\n           :  Speed will be an issue for sequences with numerous HSPs.\n           : \n Bugs      : Currently, tile_hsps() does not properly account for\n           : the number of non-tiled but overlapping HSPs, which becomes a problem\n           : as overlap() grows. Large values overlap() may thus lead to \n           : incorrect statistics for some hits. For best results, keep overlap()\n           : below 5 (DEFAULT IS 2). For more about this, see the \"HSP Tiling and\n           : Ambiguous Alignments\" section in L<Bio::Search::Hit::BlastHit>.\n\nSee Also   : L<_adjust_contigs>(), L<Bio::Search::Hit::BlastHit|Bio::Search::Hit::BlastHit>\n\n\n#--------------\nsub tile_hsps {\n#--------------\n    my $sbjct = shift;\n\n    $sbjct->{'_tile_hsps'} = 1;\n    $sbjct->{'_gaps_query'} = 0;\n    $sbjct->{'_gaps_sbjct'} = 0;\n\n    ## Simple summation scheme. Valid if there is only one HSP.\n    if((defined($sbjct->{'_n'}) and $sbjct->{'_n'} == 1) or $sbjct->num_hsps == 1) {\n\tmy $hsp = $sbjct->hsp;\n\t$sbjct->{'_length_aln_query'} = $hsp->length('query');\n\t$sbjct->{'_length_aln_sbjct'} = $hsp->length('sbjct');\n\t$sbjct->{'_length_aln_total'} = $hsp->length('total');\n\t($sbjct->{'_totalIdentical'},$sbjct->{'_totalConserved'}) = $hsp->matches();\n\t$sbjct->{'_gaps_query'} = $hsp->gaps('query');\n\t$sbjct->{'_gaps_sbjct'} = $hsp->gaps('sbjct');\n\n#\tprint \"_tile_hsps(): single HSP, easy stats.\\n\";\n\treturn;\n    } else {\n#\tprint STDERR \"Sbjct: _tile_hsps: summing multiple HSPs\\n\";\n\t$sbjct->{'_length_aln_query'} = 0;\n\t$sbjct->{'_length_aln_sbjct'} = 0;\n\t$sbjct->{'_length_aln_total'} = 0;\n\t$sbjct->{'_totalIdentical'}   = 0;\n\t$sbjct->{'_totalConserved'}   = 0;\n    }\n\n    ## More than one HSP. Must tile HSPs.\n#    print \"\\nTiling HSPs for $sbjct\\n\";\n    my($hsp, $qstart, $qstop, $sstart, $sstop);\n    my($frame, $strand, $qstrand, $sstrand);\n    my(@qcontigs, @scontigs);\n    my $qoverlap = 0;\n    my $soverlap = 0;\n    my $max_overlap = $sbjct->{'_overlap'};\n\n    foreach $hsp ($sbjct->hsps()) {\n#\tprintf \"  HSP: %s\\n%s\\n\",$hsp->name, $hsp->str('query');\n#\tprintf \"  Length = %d; Identical = %d; Conserved = %d; Conserved(1-10): %d\",$hsp->length, $hsp->length(-TYPE=>'iden'), $hsp->length(-TYPE=>'cons'), $hsp->length(-TYPE=>'cons',-START=>0,-STOP=>10); \n\t($qstart, $qstop) = $hsp->range('query');\n\t($sstart, $sstop) = $hsp->range('sbjct');\n\t$frame = $hsp->frame('hit');\n\t$frame = -1 unless defined $frame;\n\t($qstrand, $sstrand) = $hsp->strand;\n\n\tmy ($qgaps, $sgaps)  = $hsp->gaps();\n\t$sbjct->{'_gaps_query'} += $qgaps;\n\t$sbjct->{'_gaps_sbjct'} += $sgaps;\n\n\t$sbjct->{'_length_aln_total'} += $hsp->length;\n\t## Collect contigs in the query sequence.\n\t$qoverlap = &_adjust_contigs('query', $hsp, $qstart, $qstop, \\@qcontigs, $max_overlap, $frame, $qstrand);\n\n\t## Collect contigs in the sbjct sequence (needed for domain data and gapped Blast).\n\t$soverlap = &_adjust_contigs('sbjct', $hsp, $sstart, $sstop, \\@scontigs, $max_overlap, $frame, $sstrand);\n\n\t## Collect overall start and stop data for query and sbjct over all HSPs.\n\tif(not defined $sbjct->{'_queryStart'}) {\n\t    $sbjct->{'_queryStart'} = $qstart;\n\t    $sbjct->{'_queryStop'}  = $qstop;\n\t    $sbjct->{'_sbjctStart'} = $sstart;\n\t    $sbjct->{'_sbjctStop'}  = $sstop;\n\t} else {\n\t    $sbjct->{'_queryStart'} = ($qstart < $sbjct->{'_queryStart'} ? $qstart : $sbjct->{'_queryStart'});\n\t    $sbjct->{'_queryStop'}  = ($qstop  > $sbjct->{'_queryStop'}  ? $qstop  : $sbjct->{'_queryStop'});\n\t    $sbjct->{'_sbjctStart'} = ($sstart < $sbjct->{'_sbjctStart'} ? $sstart : $sbjct->{'_sbjctStart'});\n\t    $sbjct->{'_sbjctStop'}  = ($sstop  > $sbjct->{'_sbjctStop'}  ? $sstop  : $sbjct->{'_sbjctStop'});\n\t}\t    \n    }\n\n    ## Collect data across the collected contigs.\n\n#    print \"\\nQUERY CONTIGS:\\n\";\n#    print \"  gaps = $sbjct->{'_gaps_query'}\\n\";\n\n    # TODO: Account for strand/frame issue!\n    # Strategy: collect data on a per strand+frame basis and save the most significant one.\n    my (%qctg_dat);\n    foreach(@qcontigs) {\n#\tprint \"  query contig: $_->{'start'} - $_->{'stop'}\\n\";\n#\tprint \"         iden = $_->{'iden'}; cons = $_->{'cons'}\\n\";\n\t($frame, $strand) = ($_->{'frame'}, $_->{'strand'});\n\t$qctg_dat{ \"$frame$strand\" }->{'length_aln_query'} += $_->{'stop'} - $_->{'start'} + 1;\n\t$qctg_dat{ \"$frame$strand\" }->{'totalIdentical'}   += $_->{'iden'};\n\t$qctg_dat{ \"$frame$strand\" }->{'totalConserved'}   += $_->{'cons'};\n\t$qctg_dat{ \"$frame$strand\" }->{'qstrand'}   = $strand;\n    }\n\n    # Find longest contig.\n    my @sortedkeys = reverse sort { $qctg_dat{ $a }->{'length_aln_query'} <=> $qctg_dat{ $b }->{'length_aln_query'} } keys %qctg_dat;\n\n    # Save the largest to the sbjct:\n    my $longest = $sortedkeys[0];\n    $sbjct->{'_length_aln_query'} = $qctg_dat{ $longest }->{'length_aln_query'};\n    $sbjct->{'_totalIdentical'}   = $qctg_dat{ $longest }->{'totalIdentical'};\n    $sbjct->{'_totalConserved'}   = $qctg_dat{ $longest }->{'totalConserved'};\n    $sbjct->{'_qstrand'} = $qctg_dat{ $longest }->{'qstrand'};\n\n    ## Collect data for sbjct contigs. Important for gapped Blast.\n    ## The totalIdentical and totalConserved numbers will be the same\n    ## as determined for the query contigs.\n\n#    print \"\\nSBJCT CONTIGS:\\n\";\n#    print \"  gaps = $sbjct->{'_gaps_sbjct'}\\n\";\n\n    my (%sctg_dat);\n    foreach(@scontigs) {\n#\tprint \"  sbjct contig: $_->{'start'} - $_->{'stop'}\\n\";\n#\tprint \"         iden = $_->{'iden'}; cons = $_->{'cons'}\\n\";\n\t($frame, $strand) = ($_->{'frame'}, $_->{'strand'});\n\t$sctg_dat{ \"$frame$strand\" }->{'length_aln_sbjct'}   += $_->{'stop'} - $_->{'start'} + 1;\n\t$sctg_dat{ \"$frame$strand\" }->{'frame'}  = $frame;\n\t$sctg_dat{ \"$frame$strand\" }->{'sstrand'}  = $strand;\n    }\n\n    @sortedkeys = reverse sort { $sctg_dat{ $a }->{'length_aln_sbjct'} <=> $sctg_dat{ $b }->{'length_aln_sbjct'} } keys %sctg_dat;\n\n    # Save the largest to the sbjct:\n    $longest = $sortedkeys[0];\n\n    $sbjct->{'_length_aln_sbjct'} = $sctg_dat{ $longest }->{'length_aln_sbjct'};\n    $sbjct->{'_frame'} = $sctg_dat{ $longest }->{'frame'};\n    $sbjct->{'_sstrand'} = $sctg_dat{ $longest }->{'sstrand'};\n\n    if($qoverlap) {\n\tif($soverlap) { $sbjct->ambiguous_aln('qs'); \n#\t\t\tprint \"\\n*** AMBIGUOUS ALIGNMENT: Query and Sbjct\\n\\n\";\n\t\t      }\n\telse { $sbjct->ambiguous_aln('q');\n#\t       print \"\\n*** AMBIGUOUS ALIGNMENT: Query\\n\\n\";\n\t   }\n    } elsif($soverlap) { \n\t$sbjct->ambiguous_aln('s'); \n#\tprint \"\\n*** AMBIGUOUS ALIGNMENT: Sbjct\\n\\n\";\n    }\n\n    # Adjust length based on BLAST flavor.\n    my $prog = $sbjct->algorithm;\n    if($prog eq 'TBLASTN') {\n\t$sbjct->{'_length_aln_sbjct'} /= 3;\n    } elsif($prog eq 'BLASTX' ) {\n\t$sbjct->{'_length_aln_query'} /= 3;\n    } elsif($prog eq 'TBLASTX') {\n\t$sbjct->{'_length_aln_query'} /= 3;\n\t$sbjct->{'_length_aln_sbjct'} /= 3;\n    }\n}\n\n\n\n=head2 _adjust_contigs\n\n Usage     : n/a; called automatically during object construction.\n Purpose   : Builds HSP contigs for a given BLAST hit.\n           : Utility method called by _tile_hsps()\n Returns   : \n Argument  : \n Throws    : Exceptions propagated from Bio::Search::Hit::BlastHSP::matches()\n           : for invalid sub-sequence ranges.\n Status    : Experimental\n Comments  : This method does not currently support gapped alignments.\n           : Also, it does not keep track of the number of HSPs that\n           : overlap within the amount specified by overlap().\n           : This will lead to significant tracking errors for large\n           : overlap values.\n\nSee Also   : L<tile_hsps>(), L<Bio::Search::Hit::BlastHSP::matches|Bio::Search::Hit::BlastHSP>","parameters":[{"label":"$seqType"},{"label":"$hsp"},{"label":"$start"},{"label":"$stop"},{"label":"$contigs_ref"},{"label":"$max_overlap"},{"label":"$frame"},{"label":"$strand"}]},"line":283,"kind":12,"range":{"start":{"character":0,"line":283},"end":{"character":9999,"line":354}}},{"containerName":"main::","name":"get_exponent","children":[{"definition":"my","name":"$data","localvar":"my","kind":13,"containerName":"get_exponent","line":377},{"localvar":"my","containerName":"get_exponent","kind":13,"name":"$num","line":379,"definition":"my"},{"containerName":"get_exponent","kind":13,"name":"$exp","line":379},{"name":"$data","kind":13,"containerName":"get_exponent","line":379},{"kind":13,"containerName":"get_exponent","name":"$exp","line":381},{"kind":13,"containerName":"get_exponent","name":"$num","line":382},{"line":382,"name":"$num","containerName":"get_exponent","kind":13},{"line":383,"kind":13,"containerName":"get_exponent","name":"$num"},{"line":383,"name":"$exp","kind":13,"containerName":"get_exponent"},{"line":384,"name":"$num","kind":13,"containerName":"get_exponent"},{"kind":13,"containerName":"get_exponent","name":"$exp","line":384},{"name":"$num","kind":13,"containerName":"get_exponent","line":385},{"containerName":"get_exponent","kind":13,"name":"$exp","line":386},{"kind":13,"containerName":"get_exponent","name":"$num","line":387},{"line":388,"kind":13,"containerName":"get_exponent","name":"$exp"},{"line":388,"kind":13,"containerName":"get_exponent","name":"$num"},{"line":390,"containerName":"get_exponent","kind":13,"name":"$exp"},{"name":"$num","kind":13,"containerName":"get_exponent","line":391},{"line":391,"name":"$num","kind":13,"containerName":"get_exponent"},{"line":392,"name":"$c","localvar":"my","containerName":"get_exponent","kind":13,"definition":"my"},{"definition":"my","name":"$rev","localvar":"my","kind":13,"containerName":"get_exponent","line":393},{"line":394,"kind":13,"containerName":"get_exponent","name":"$num"},{"kind":13,"containerName":"get_exponent","name":"$num","line":395},{"line":395,"name":"$num","kind":13,"containerName":"get_exponent"},{"line":396,"kind":13,"containerName":"get_exponent","name":"$rev"},{"name":"$c","kind":13,"containerName":"get_exponent","line":398},{"name":"$num","kind":13,"containerName":"get_exponent","line":398},{"name":"$c","containerName":"get_exponent","kind":13,"line":399},{"containerName":"get_exponent","kind":13,"name":"$exp","line":399},{"name":"$c","containerName":"get_exponent","kind":13,"line":400},{"name":"$exp","kind":13,"containerName":"get_exponent","line":402},{"name":"$exp","kind":13,"containerName":"get_exponent","line":402},{"line":402,"containerName":"get_exponent","kind":13,"name":"$num"},{"line":402,"kind":13,"containerName":"get_exponent","name":"$rev"},{"line":403,"name":"$exp","kind":13,"containerName":"get_exponent"},{"kind":13,"containerName":"get_exponent","name":"$rev","line":403},{"line":405,"name":"$exp","containerName":"get_exponent","kind":13}],"definition":"sub","range":{"start":{"line":375,"character":0},"end":{"line":406,"character":9999}},"kind":12,"line":375},{"line":388,"name":"CORE","kind":12,"containerName":"length"},{"definition":"sub","containerName":"main::","name":"collapse_nums","children":[{"line":429,"name":"@a","containerName":"collapse_nums","localvar":"my","kind":13,"definition":"my"},{"line":430,"name":"$from","localvar":"my","containerName":"collapse_nums","kind":13,"definition":"my"},{"name":"$to","kind":13,"containerName":"collapse_nums","line":430},{"name":"$i","kind":13,"containerName":"collapse_nums","line":430},{"line":430,"kind":13,"containerName":"collapse_nums","name":"@ca"},{"containerName":"collapse_nums","kind":13,"name":"$consec","line":430},{"name":"$consec","containerName":"collapse_nums","kind":13,"line":432},{"line":433,"name":"$i","containerName":"collapse_nums","kind":13},{"line":433,"name":"$i","containerName":"collapse_nums","kind":13},{"kind":13,"containerName":"collapse_nums","name":"@a","line":433},{"line":433,"name":"$i","kind":13,"containerName":"collapse_nums"},{"kind":13,"containerName":"collapse_nums","name":"$from","line":434},{"kind":13,"containerName":"collapse_nums","name":"$from","line":434},{"kind":13,"containerName":"collapse_nums","name":"$a","line":434},{"name":"$i","containerName":"collapse_nums","kind":13,"line":434},{"line":435,"kind":13,"containerName":"collapse_nums","name":"$a"},{"name":"$i","containerName":"collapse_nums","kind":13,"line":435},{"name":"$a","containerName":"collapse_nums","kind":13,"line":435},{"name":"$i","containerName":"collapse_nums","kind":13,"line":435},{"line":436,"name":"$to","containerName":"collapse_nums","kind":13},{"name":"$a","kind":13,"containerName":"collapse_nums","line":436},{"line":436,"name":"$i","kind":13,"containerName":"collapse_nums"},{"line":437,"kind":13,"containerName":"collapse_nums","name":"$consec"},{"line":439,"name":"$consec","kind":13,"containerName":"collapse_nums"},{"name":"$from","containerName":"collapse_nums","kind":13,"line":439},{"line":440,"containerName":"collapse_nums","kind":13,"name":"$from"},{"name":"$consec","kind":13,"containerName":"collapse_nums","line":440},{"name":"@ca","containerName":"collapse_nums","kind":13,"line":441},{"line":441,"name":"$from","containerName":"collapse_nums","kind":13},{"line":442,"containerName":"collapse_nums","kind":13,"name":"$from"},{"line":442,"kind":13,"containerName":"collapse_nums","name":"$a"},{"line":442,"name":"$i","kind":13,"containerName":"collapse_nums"},{"line":443,"containerName":"collapse_nums","kind":13,"name":"$consec"},{"kind":13,"containerName":"collapse_nums","name":"$to","line":444},{"line":447,"kind":13,"containerName":"collapse_nums","name":"$to"},{"containerName":"collapse_nums","kind":13,"name":"$consec","line":448},{"kind":13,"containerName":"collapse_nums","name":"$from","line":448},{"containerName":"collapse_nums","kind":13,"name":"$from","line":449},{"line":449,"containerName":"collapse_nums","kind":13,"name":"$consec"},{"line":451,"name":"@ca","containerName":"collapse_nums","kind":13},{"name":"$from","containerName":"collapse_nums","kind":13,"line":451},{"line":451,"kind":13,"containerName":"collapse_nums","name":"$from"},{"name":"@ca","containerName":"collapse_nums","kind":13,"line":453}],"kind":12,"range":{"start":{"line":426,"character":0},"end":{"line":454,"character":9999}},"line":426},{"definition":"sub","children":[{"containerName":"strip_blast_html","localvar":"my","kind":13,"name":"$string_ref","line":501,"definition":"my"},{"name":"$string_ref","containerName":"strip_blast_html","kind":13,"line":503},{"definition":"my","line":507,"name":"$str","containerName":"strip_blast_html","localvar":"my","kind":13},{"name":"$stripped","kind":13,"localvar":"my","containerName":"strip_blast_html","line":508,"definition":"my"},{"line":512,"name":"$str","containerName":"strip_blast_html","kind":13},{"name":"$stripped","containerName":"strip_blast_html","kind":13,"line":512},{"line":515,"name":"$str","containerName":"strip_blast_html","kind":13},{"name":"$stripped","containerName":"strip_blast_html","kind":13,"line":515},{"line":518,"containerName":"strip_blast_html","kind":13,"name":"$str"},{"line":518,"kind":13,"containerName":"strip_blast_html","name":"$stripped"},{"kind":13,"containerName":"strip_blast_html","name":"$str","line":520},{"containerName":"strip_blast_html","kind":13,"name":"$stripped","line":521}],"name":"strip_blast_html","containerName":"main::","line":493,"range":{"start":{"character":0,"line":493},"end":{"line":522,"character":9999}},"kind":12},{"line":504,"name":"croak","kind":12},{"line":507,"kind":12,"name":"string_ref"},{"line":520,"kind":12,"name":"string_ref"}]}