{"version":5,"vars":[{"containerName":"strict::Data","kind":2,"name":"Dumper","line":102},{"kind":2,"containerName":"","name":"vars","line":107},{"line":108,"containerName":"","kind":2,"name":"base"},{"kind":12,"name":"Storable","line":112},{"containerName":"main::","kind":12,"name":"import","line":112},{"containerName":null,"kind":13,"name":"$BINARY","line":113},{"definition":"sub","detail":"($caller,@args)","children":[{"definition":"my","name":"$caller","containerName":"new","localvar":"my","kind":13,"line":133},{"name":"@args","containerName":"new","kind":13,"line":133},{"definition":"my","name":"$self","localvar":"my","containerName":"new","kind":13,"line":134},{"name":"$caller","containerName":"new","kind":13,"line":134},{"line":134,"name":"@args","containerName":"new","kind":13},{"line":135,"containerName":"new","kind":13,"name":"$self"},{"line":135,"containerName":"new","kind":12,"name":"_initialise_storable"},{"kind":13,"containerName":"new","name":"$self","line":136}],"containerName":"main::","name":"new","signature":{"label":"new($caller,@args)","parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: Storable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Root::Storable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Will Spooner <whs@sanger.ac.uk>\n#\n# Copyright Will Spooner <whs@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Root::Storable - object serialisation methods\n\n=head1 SYNOPSIS\n\n  my $storable = Bio::Root::Storable->new();\n\n  # Store/retrieve using class retriever\n  my $token     = $storable->store();\n  my $storable2 = Bio::Root::Storable->retrieve( $token );\n\n  # Store/retrieve using object retriever\n  my $storable2 = $storable->new_retrievable();\n  $storable2->retrieve();\n\n\n=head1 DESCRIPTION\n\nGeneric module that allows objects to be safely stored/retrieved from\ndisk.  Can be inhereted by any BioPerl object. As it will not usually\nbe the first class in the inheretence list, _initialise_storable()\nshould be called during object instantiation.\n\nObject storage is recursive; If the object being stored contains other\nstorable objects, these will be stored seperately, and replaced by a\nskeleton object in the parent heirarchy. When the parent is later\nretrieved, its children remain in the skeleton state until explicitly\nretrieved by the parent. This lazy-retrieve approach has obvious\nmemory efficiency benefits for certain applications.\n\n\nBy default, objects are stored in binary format (using the Perl\nStorable module). Earlier versions of Perl5 do not include Storable as\na core module. If this is the case, ASCII object storage (using the\nPerl Data::Dumper module) is used instead.\n\nASCII storage can be enabled by default by setting the value of\n$Bio::Root::Storable::BINARY to false.\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bio.perl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Will Spooner\n\nEmail whs@sanger.ac.uk\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\npackage Bio::Root::Storable;\n\nuse strict;\nuse Data::Dumper qw( Dumper );\n\nuse File::Spec;\nuse Bio::Root::IO;\n\nuse vars qw( $BINARY );\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n  if( eval \"require Storable\" ){\n    Storable->import( 'freeze', 'thaw' );\n    $BINARY = 1;\n  }\n}\n\n#----------------------------------------------------------------------\n\n=head2 new\n\n  Arg [1]   : -workdir  => filesystem path,\n              -template => tmpfile template,\n              -suffix   => tmpfile suffix,\n  Function  : Builds a new Bio::Root::Storable inhereting object\n  Returntype: Bio::Root::Storable inhereting object\n  Exceptions: \n  Caller    : \n  Example   : $storable = Bio::Root::Storable->new()"},"line":132,"range":{"start":{"character":0,"line":132},"end":{"character":9999,"line":137}},"kind":12},{"line":134,"name":"SUPER","kind":12,"containerName":"new"},{"kind":12,"range":{"start":{"character":0,"line":152},"end":{"character":9999,"line":160}},"line":152,"definition":"sub","containerName":"main::","name":"_initialise_storable","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_initialise_storable","kind":13,"line":153},{"kind":13,"localvar":"my","containerName":"_initialise_storable","name":"$workdir","line":154,"definition":"my"},{"line":154,"containerName":"_initialise_storable","kind":13,"name":"$template"},{"containerName":"_initialise_storable","kind":13,"name":"$suffix","line":154},{"name":"$self","containerName":"_initialise_storable","kind":13,"line":155},{"line":155,"name":"_rearrange","containerName":"_initialise_storable","kind":12},{"line":156,"name":"$workdir","containerName":"_initialise_storable","kind":13},{"line":156,"name":"$self","containerName":"_initialise_storable","kind":13},{"containerName":"_initialise_storable","kind":12,"name":"workdir","line":156},{"line":156,"kind":13,"containerName":"_initialise_storable","name":"$workdir"},{"line":157,"containerName":"_initialise_storable","kind":13,"name":"$template"},{"line":157,"kind":13,"containerName":"_initialise_storable","name":"$self"},{"line":157,"name":"template","containerName":"_initialise_storable","kind":12},{"name":"$template","kind":13,"containerName":"_initialise_storable","line":157},{"line":158,"name":"$suffix","kind":13,"containerName":"_initialise_storable"},{"name":"$self","containerName":"_initialise_storable","kind":13,"line":158},{"containerName":"_initialise_storable","kind":12,"name":"suffix","line":158},{"line":158,"name":"$suffix","kind":13,"containerName":"_initialise_storable"}]},{"kind":12,"range":{"end":{"character":9999,"line":204},"start":{"character":0,"line":179}},"line":179,"definition":"sub","name":"statefile","containerName":"main::","children":[{"definition":"my","name":"$key","localvar":"my","containerName":"statefile","kind":13,"line":181},{"name":"$self","containerName":"statefile","localvar":"my","kind":13,"line":182,"definition":"my"},{"name":"$self","kind":13,"containerName":"statefile","line":184},{"name":"$key","containerName":"statefile","kind":13,"line":184},{"name":"$self","kind":13,"containerName":"statefile","line":186},{"containerName":"statefile","kind":13,"name":"$key","line":186},{"definition":"my","line":188,"name":"$workdir","kind":13,"localvar":"my","containerName":"statefile"},{"name":"$self","kind":13,"containerName":"statefile","line":188},{"kind":12,"containerName":"statefile","name":"workdir","line":188},{"name":"$template","localvar":"my","kind":13,"containerName":"statefile","line":189,"definition":"my"},{"kind":13,"containerName":"statefile","name":"$self","line":189},{"line":189,"name":"template","kind":12,"containerName":"statefile"},{"name":"$suffix","localvar":"my","containerName":"statefile","kind":13,"line":190,"definition":"my"},{"line":190,"containerName":"statefile","kind":13,"name":"$self"},{"line":190,"containerName":"statefile","kind":12,"name":"suffix"},{"definition":"my","name":"@args","localvar":"my","kind":13,"containerName":"statefile","line":194},{"line":195,"kind":13,"containerName":"statefile","name":"$template"},{"line":195,"name":"@args","containerName":"statefile","kind":13},{"line":195,"kind":13,"containerName":"statefile","name":"$template"},{"name":"$workdir","containerName":"statefile","kind":13,"line":196},{"name":"@args","kind":13,"containerName":"statefile","line":196},{"containerName":"statefile","kind":13,"name":"$workdir","line":196},{"name":"$suffix","containerName":"statefile","kind":13,"line":197},{"name":"@args","containerName":"statefile","kind":13,"line":197},{"containerName":"statefile","kind":13,"name":"$suffix","line":197},{"kind":13,"localvar":"my","containerName":"statefile","name":"$fh","line":198,"definition":"my"},{"name":"$file","containerName":"statefile","kind":13,"line":198},{"line":198,"name":"new","containerName":"statefile","kind":12},{"line":198,"kind":12,"containerName":"statefile","name":"tempfile"},{"kind":13,"containerName":"statefile","name":"@args","line":198},{"name":"$self","containerName":"statefile","kind":13,"line":200},{"line":200,"name":"$key","kind":13,"containerName":"statefile"},{"line":200,"kind":13,"containerName":"statefile","name":"$file"},{"line":203,"kind":13,"containerName":"statefile","name":"$self"},{"name":"$key","containerName":"statefile","kind":13,"line":203}]},{"kind":12,"name":"CLEANUP","line":194},{"line":194,"name":"UNLINK","kind":12},{"name":"Bio","kind":12,"containerName":"Root::IO","line":198},{"definition":"sub","children":[{"name":"$key","localvar":"my","kind":13,"containerName":"workdir","line":220,"definition":"my"},{"definition":"my","line":221,"localvar":"my","kind":13,"containerName":"workdir","name":"$self"},{"line":223,"kind":13,"localvar":"my","containerName":"workdir","name":"$caller","definition":"my"},{"containerName":"workdir","kind":13,"name":"$self","line":224},{"line":224,"kind":13,"containerName":"workdir","name":"$key"},{"line":224,"kind":13,"containerName":"workdir","name":"$self"},{"line":224,"kind":12,"containerName":"workdir","name":"debug"},{"name":"$self","kind":13,"containerName":"workdir","line":225},{"line":225,"kind":13,"containerName":"workdir","name":"$key"},{"line":228,"containerName":"workdir","kind":13,"name":"$self"},{"line":228,"name":"$key","containerName":"workdir","kind":13},{"line":228,"name":"tmpdir","kind":12,"containerName":"workdir"},{"line":229,"name":"$self","containerName":"workdir","kind":13},{"line":229,"containerName":"workdir","kind":13,"name":"$key"}],"name":"workdir","containerName":"main::","line":219,"range":{"end":{"character":9999,"line":230},"start":{"line":219,"character":0}},"kind":12},{"line":228,"kind":12,"containerName":"Spec","name":"File"},{"line":245,"kind":12,"range":{"start":{"line":245,"character":0},"end":{"line":251,"character":9999}},"definition":"sub","children":[{"definition":"my","line":246,"name":"$key","localvar":"my","kind":13,"containerName":"template"},{"line":247,"localvar":"my","containerName":"template","kind":13,"name":"$self","definition":"my"},{"line":248,"containerName":"template","kind":13,"name":"$self"},{"kind":13,"containerName":"template","name":"$key","line":248},{"line":249,"kind":13,"containerName":"template","name":"$self"},{"line":249,"name":"$key","containerName":"template","kind":13},{"line":250,"containerName":"template","kind":13,"name":"$self"},{"name":"$key","kind":13,"containerName":"template","line":250}],"name":"template","containerName":"main::"},{"line":266,"kind":12,"range":{"start":{"line":266,"character":0},"end":{"character":9999,"line":271}},"definition":"sub","children":[{"localvar":"my","kind":13,"containerName":"suffix","name":"$key","line":267,"definition":"my"},{"definition":"my","name":"$self","localvar":"my","containerName":"suffix","kind":13,"line":268},{"name":"$self","containerName":"suffix","kind":13,"line":269},{"kind":13,"containerName":"suffix","name":"$key","line":269},{"line":270,"containerName":"suffix","kind":13,"name":"$self"},{"line":270,"name":"$key","kind":13,"containerName":"suffix"}],"containerName":"main::","name":"suffix"},{"line":290,"range":{"end":{"line":302,"character":9999},"start":{"character":0,"line":290}},"kind":12,"children":[{"definition":"my","containerName":"new_retrievable","localvar":"my","kind":13,"name":"$self","line":291},{"localvar":"my","containerName":"new_retrievable","kind":13,"name":"@args","line":292,"definition":"my"},{"line":294,"containerName":"new_retrievable","kind":13,"name":"$self"},{"containerName":"new_retrievable","kind":12,"name":"_initialise_storable","line":294},{"line":294,"containerName":"new_retrievable","kind":13,"name":"@args"},{"containerName":"new_retrievable","kind":13,"name":"$self","line":296},{"line":296,"name":"retrievable","containerName":"new_retrievable","kind":12},{"line":296,"name":"$self","kind":13,"containerName":"new_retrievable"},{"line":296,"containerName":"new_retrievable","kind":12,"name":"clone"},{"line":297,"name":"$self","containerName":"new_retrievable","kind":13},{"name":"store","kind":12,"containerName":"new_retrievable","line":297},{"containerName":"new_retrievable","kind":13,"name":"@args","line":297},{"name":"$self","kind":13,"containerName":"new_retrievable","line":298},{"line":298,"kind":12,"containerName":"new_retrievable","name":"workdir"},{"line":299,"containerName":"new_retrievable","kind":13,"name":"$self"},{"line":299,"kind":12,"containerName":"new_retrievable","name":"suffix"},{"line":300,"name":"$self","containerName":"new_retrievable","kind":13},{"kind":12,"containerName":"new_retrievable","name":"template","line":300},{"line":301,"containerName":"new_retrievable","kind":13,"name":"$self"}],"containerName":"main::","name":"new_retrievable","definition":"sub"},{"line":297,"kind":12,"name":"_statefile"},{"line":298,"kind":12,"name":"_workdir"},{"kind":12,"name":"_suffix","line":299},{"kind":12,"name":"_template","line":300},{"name":"_retrievable","kind":12,"line":301},{"kind":12,"range":{"end":{"character":9999,"line":322},"start":{"character":0,"line":318}},"line":318,"definition":"sub","name":"retrievable","containerName":"main::","children":[{"definition":"my","line":319,"containerName":"retrievable","localvar":"my","kind":13,"name":"$self"},{"kind":13,"containerName":"retrievable","name":"$self","line":320},{"name":"$self","kind":13,"containerName":"retrievable","line":321}]},{"line":320,"kind":12,"name":"_retrievable"},{"line":321,"name":"_retrievable","kind":12},{"definition":"sub","name":"token","containerName":"main::","children":[{"definition":"my","line":339,"localvar":"my","containerName":"token","kind":13,"name":"$self"},{"line":340,"kind":13,"containerName":"token","name":"$self"},{"containerName":"token","kind":12,"name":"statefile","line":340}],"range":{"start":{"character":0,"line":338},"end":{"line":341,"character":9999}},"kind":12,"line":338},{"definition":"sub","name":"store","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"store","localvar":"my","kind":13,"line":361},{"line":362,"containerName":"store","localvar":"my","kind":13,"name":"$statefile","definition":"my"},{"line":362,"name":"$self","kind":13,"containerName":"store"},{"line":362,"containerName":"store","kind":12,"name":"statefile"},{"definition":"my","localvar":"my","containerName":"store","kind":13,"name":"$store_obj","line":363},{"line":363,"kind":13,"containerName":"store","name":"$self"},{"name":"serialise","kind":12,"containerName":"store","line":363},{"line":364,"kind":13,"localvar":"my","containerName":"store","name":"$io","definition":"my"},{"line":364,"kind":12,"containerName":"store","name":"new"},{"kind":13,"containerName":"store","name":"$io","line":365},{"line":365,"name":"_print","kind":12,"containerName":"store"},{"name":"$store_obj","kind":13,"containerName":"store","line":365},{"line":366,"containerName":"store","kind":13,"name":"$self"},{"containerName":"store","kind":12,"name":"debug","line":366},{"line":367,"kind":13,"containerName":"store","name":"$statefile"}],"kind":12,"range":{"end":{"character":9999,"line":368},"start":{"character":0,"line":360}},"line":360},{"name":"Bio","kind":12,"containerName":"Root::IO","line":364},{"line":388,"range":{"end":{"character":9999,"line":446},"start":{"character":0,"line":388}},"kind":12,"definition":"sub","children":[{"line":389,"name":"$self","localvar":"my","kind":13,"containerName":"serialise","definition":"my"},{"containerName":"serialise","localvar":"my","kind":13,"name":"$store_obj","line":392,"definition":"my"},{"name":"$self","containerName":"serialise","kind":13,"line":392},{"line":394,"name":"%retargs","localvar":"my","containerName":"serialise","kind":13,"definition":"my"},{"line":394,"name":"$self","containerName":"serialise","kind":13},{"line":394,"containerName":"serialise","kind":12,"name":"workdir"},{"name":"$self","kind":13,"containerName":"serialise","line":395},{"line":395,"containerName":"serialise","kind":12,"name":"suffix"},{"name":"$self","containerName":"serialise","kind":13,"line":396},{"line":396,"kind":12,"containerName":"serialise","name":"template"},{"definition":"my","name":"$key","containerName":"serialise","localvar":"my","kind":13,"line":400},{"name":"$self","kind":13,"containerName":"serialise","line":400},{"line":401,"name":"$key","kind":13,"containerName":"serialise"},{"line":402,"containerName":"serialise","localvar":"my","kind":13,"name":"$value","definition":"my"},{"name":"$self","kind":13,"containerName":"serialise","line":402},{"name":"$key","kind":13,"containerName":"serialise","line":402},{"line":405,"name":"$value","containerName":"serialise","kind":13},{"line":406,"kind":13,"containerName":"serialise","name":"$store_obj"},{"line":406,"name":"$key","kind":13,"containerName":"serialise"},{"containerName":"serialise","kind":13,"name":"$value","line":406},{"line":410,"name":"$value","containerName":"serialise","kind":13},{"name":"$value","kind":13,"containerName":"serialise","line":410},{"containerName":"serialise","kind":12,"name":"isa","line":410},{"line":412,"containerName":"serialise","kind":13,"name":"$store_obj"},{"kind":13,"containerName":"serialise","name":"$key","line":412},{"kind":13,"containerName":"serialise","name":"$value","line":412},{"line":412,"kind":12,"containerName":"serialise","name":"new_retrievable"},{"kind":13,"containerName":"serialise","name":"%retargs","line":412},{"kind":13,"containerName":"serialise","name":"$value","line":417},{"line":418,"localvar":"my","kind":13,"containerName":"serialise","name":"@ary","definition":"my"},{"definition":"my","line":419,"name":"$val","kind":13,"localvar":"my","containerName":"serialise"},{"line":419,"name":"$value","kind":13,"containerName":"serialise"},{"name":"$val","containerName":"serialise","kind":13,"line":420},{"line":420,"name":"$val","containerName":"serialise","kind":13},{"line":420,"name":"isa","kind":12,"containerName":"serialise"},{"line":421,"kind":13,"containerName":"serialise","name":"@ary"},{"line":421,"containerName":"serialise","kind":13,"name":"$val"},{"kind":12,"containerName":"serialise","name":"new_retrievable","line":421},{"containerName":"serialise","kind":13,"name":"%retargs","line":421},{"containerName":"serialise","kind":13,"name":"@ary","line":423},{"line":423,"containerName":"serialise","kind":13,"name":"$val"},{"kind":13,"containerName":"serialise","name":"$store_obj","line":425},{"containerName":"serialise","kind":13,"name":"$key","line":425},{"containerName":"serialise","kind":13,"name":"@ary","line":425},{"line":429,"name":"$value","kind":13,"containerName":"serialise"},{"definition":"my","kind":13,"localvar":"my","containerName":"serialise","name":"%hash","line":430},{"line":431,"kind":13,"localvar":"my","containerName":"serialise","name":"$k2","definition":"my"},{"line":431,"kind":13,"containerName":"serialise","name":"$value"},{"kind":13,"localvar":"my","containerName":"serialise","name":"$val","line":432,"definition":"my"},{"line":432,"name":"$value","containerName":"serialise","kind":13},{"line":432,"containerName":"serialise","kind":13,"name":"$k2"},{"line":433,"containerName":"serialise","kind":13,"name":"$val"},{"name":"$val","kind":13,"containerName":"serialise","line":433},{"containerName":"serialise","kind":12,"name":"isa","line":433},{"line":434,"kind":13,"containerName":"serialise","name":"$hash"},{"name":"$k2","containerName":"serialise","kind":13,"line":434},{"line":434,"containerName":"serialise","kind":13,"name":"$val"},{"line":434,"kind":12,"containerName":"serialise","name":"new_retrievable"},{"line":434,"name":"%retargs","containerName":"serialise","kind":13},{"name":"$hash","containerName":"serialise","kind":13,"line":436},{"containerName":"serialise","kind":13,"name":"$k2","line":436},{"containerName":"serialise","kind":13,"name":"$val","line":436},{"name":"$store_obj","containerName":"serialise","kind":13,"line":438},{"name":"$key","kind":13,"containerName":"serialise","line":438},{"line":438,"containerName":"serialise","kind":13,"name":"%hash"},{"line":442,"name":"$store_obj","containerName":"serialise","kind":13},{"line":442,"name":"$key","kind":13,"containerName":"serialise"},{"name":"$value","containerName":"serialise","kind":13,"line":442},{"kind":13,"containerName":"serialise","name":"$store_obj","line":444},{"line":444,"kind":12,"containerName":"serialise","name":"retrievable"},{"line":445,"kind":13,"containerName":"serialise","name":"$self"},{"line":445,"name":"_freeze","containerName":"serialise","kind":12},{"line":445,"name":"$store_obj","kind":13,"containerName":"serialise"}],"containerName":"main::","name":"serialise"},{"name":"next","kind":12,"line":401},{"line":464,"range":{"end":{"character":9999,"line":514},"start":{"character":0,"line":464}},"kind":12,"signature":{"documentation":"1;\n# $Id: Storable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Root::Storable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Will Spooner <whs@sanger.ac.uk>\n#\n# Copyright Will Spooner <whs@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Root::Storable - object serialisation methods\n\n=head1 SYNOPSIS\n\n  my $storable = Bio::Root::Storable->new();\n\n  # Store/retrieve using class retriever\n  my $token     = $storable->store();\n  my $storable2 = Bio::Root::Storable->retrieve( $token );\n\n  # Store/retrieve using object retriever\n  my $storable2 = $storable->new_retrievable();\n  $storable2->retrieve();\n\n\n=head1 DESCRIPTION\n\nGeneric module that allows objects to be safely stored/retrieved from\ndisk.  Can be inhereted by any BioPerl object. As it will not usually\nbe the first class in the inheretence list, _initialise_storable()\nshould be called during object instantiation.\n\nObject storage is recursive; If the object being stored contains other\nstorable objects, these will be stored seperately, and replaced by a\nskeleton object in the parent heirarchy. When the parent is later\nretrieved, its children remain in the skeleton state until explicitly\nretrieved by the parent. This lazy-retrieve approach has obvious\nmemory efficiency benefits for certain applications.\n\n\nBy default, objects are stored in binary format (using the Perl\nStorable module). Earlier versions of Perl5 do not include Storable as\na core module. If this is the case, ASCII object storage (using the\nPerl Data::Dumper module) is used instead.\n\nASCII storage can be enabled by default by setting the value of\n$Bio::Root::Storable::BINARY to false.\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bio.perl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Will Spooner\n\nEmail whs@sanger.ac.uk\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\npackage Bio::Root::Storable;\n\nuse strict;\nuse Data::Dumper qw( Dumper );\n\nuse File::Spec;\nuse Bio::Root::IO;\n\nuse vars qw( $BINARY );\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n  if( eval \"require Storable\" ){\n    Storable->import( 'freeze', 'thaw' );\n    $BINARY = 1;\n  }\n}\n\n#----------------------------------------------------------------------\n\n=head2 new\n\n  Arg [1]   : -workdir  => filesystem path,\n              -template => tmpfile template,\n              -suffix   => tmpfile suffix,\n  Function  : Builds a new Bio::Root::Storable inhereting object\n  Returntype: Bio::Root::Storable inhereting object\n  Exceptions: \n  Caller    : \n  Example   : $storable = Bio::Root::Storable->new()\n\n\nsub new {\n  my ($caller, @args) = @_;\n  my $self = $caller->SUPER::new(@args);\n  $self->_initialise_storable;\n  return $self;\n}\n\n#----------------------------------------------------------------------\n\n=head2 _initialise_storable\n\n  Arg [1]   : See 'new' method\n  Function  : Initialises storable-specific attributes\n  Returntype: boolean\n  Exceptions: \n  Caller    : \n  Example   : \n\n\nsub _initialise_storable {\n  my $self = shift;\n  my( $workdir, $template, $suffix ) =\n    $self->_rearrange([qw(WORKDIR TEMPLATE SUFFIX)], @_ );\n  $workdir  && $self->workdir ( $workdir );\n  $template && $self->template( $template );\n  $suffix   && $self->suffix  ( $suffix   );\n  return 1;\n}\n\n\n\n#----------------------------------------------------------------------\n\n=head2 statefile\n\n  Arg [1]   : string (optional)\n  Function  : Accessor for the file to write state into.\n              Should not normaly use as a setter - let Root::IO\n              do this for you.\n  Returntype: string\n  Exceptions: \n  Caller    : Bio::Root::Storable->store\n  Example   : my $statefile = $obj->statefile();\n\n\nsub statefile{\n\n  my $key = '_statefile';\n  my $self  = shift;\n\n  if( @_ ){ $self->{$key} = shift }\n\n  if( ! $self->{$key} ){ # Create a new statefile\n\n    my $workdir  = $self->workdir;\n    my $template = $self->template;\n    my $suffix   = $self->suffix;\n\n    # TODO: add cleanup and unlink methods. For now, we'll keep the\n    # statefile hanging around.\n    my @args = ( CLEANUP=>0, UNLINK=>0 );\n    if( $template ){ push( @args, 'TEMPLATE' => $template )};\n    if( $workdir  ){ push( @args, 'DIR'      => $workdir  )};\n    if( $suffix   ){ push( @args, 'SUFFIX'   => $suffix   )};\n    my( $fh, $file ) = Bio::Root::IO->new->tempfile( @args );\n\n    $self->{$key} = $file;\n  }\n\n  return $self->{$key};\n}\n\n#----------------------------------------------------------------------\n\n=head2 workdir\n\n  Arg [1]   : string (optional) (TODO - convert to array for x-platform)\n  Function  : Accessor for the statefile directory. Defaults to File::Spec->tmpdir\n  Returntype: string\n  Exceptions: \n  Caller    : \n  Example   : $obj->workdir('/tmp/foo');\n\n\nsub workdir {\n  my $key = '_workdir';\n  my $self = shift;\n  if( @_ ){\n    my $caller = join( ', ', (caller(0))[1..2] );\n    $self->{$key} && $self->debug(\"Overwriting workdir: probably bad!\");\n    $self->{$key} = shift\n  }\n#  $self->{$key} ||= $Bio::Root::IO::TEMPDIR;\n  $self->{$key} ||= File::Spec->tmpdir();\n  return $self->{$key};\n}\n\n#----------------------------------------------------------------------\n\n=head2 template\n\n  Arg [1]   : string (optional)\n  Function  : Accessor for the statefile template. Defaults to XXXXXXXX\n  Returntype: string\n  Exceptions: \n  Caller    : \n  Example   : $obj->workdir('RES_XXXXXXXX');\n\n\nsub template {\n  my $key = '_template';\n  my $self = shift;\n  if( @_ ){ $self->{$key} = shift }\n  $self->{$key} ||= 'XXXXXXXX';\n  return $self->{$key};\n}\n\n#----------------------------------------------------------------------\n\n=head2 suffix\n\n  Arg [1]   : string (optional)\n  Function  : Accessor for the statefile template.\n  Returntype: string\n  Exceptions: \n  Caller    : \n  Example   : $obj->suffix('.state');\n\n\nsub suffix {\n  my $key = '_suffix';\n  my $self = shift;\n  if( @_ ){ $self->{$key} = shift }\n  return $self->{$key};\n}\n\n#----------------------------------------------------------------------\n\n=head2 new_retrievable\n\n  Arg [1]   : Same as for 'new'\n  Function  : Similar to store, except returns a 'skeleton' of the calling\n              object, rather than the statefile.\n              The skeleton can be repopulated by calling 'retrieve'. This\n              will be a clone of the original object.\n  Returntype: Bio::Root::Storable inhereting object\n  Exceptions: \n  Caller    : \n  Example   : my $skel = $obj->new_retrievable(); # skeleton \n              $skel->retrieve();                  # clone\n\n\nsub new_retrievable{\n   my $self = shift;\n   my @args = @_;\n\n   $self->_initialise_storable( @args );\n\n   if( $self->retrievable ){ return $self->clone } # Clone retrievable\n   return bless( { _statefile   => $self->store(@args),\n\t\t   _workdir     => $self->workdir,\n\t\t   _suffix      => $self->suffix,\n\t\t   _template    => $self->template,\n\t\t   _retrievable => 1 }, ref( $self ) );\n}\n\n#----------------------------------------------------------------------\n\n=head2 retrievable\n\n  Arg [1]   : none\n  Function  : Reports whether the object is in 'skeleton' state, and the\n              'retrieve' method can be called.\n  Returntype: boolean\n  Exceptions: \n  Caller    : \n  Example   : if( $obj->retrievable ){ $obj->retrieve }\n\n\nsub retrievable {\n   my $self = shift;\n   if( @_ ){ $self->{_retrievable} = shift }\n   return $self->{_retrievable};\n}\n\n#----------------------------------------------------------------------\n\n=head2 token\n\n  Arg [1]   : None\n  Function  : Accessor for token attribute\n  Returntype: string. Whatever retrieve needs to retrieve.\n              This base implementation returns the statefile\n  Exceptions: \n  Caller    : \n  Example   : my $token = $obj->token();\n\n\nsub token{\n  my $self = shift;\n  return $self->statefile;\n}\n\n\n#----------------------------------------------------------------------\n\n=head2 store\n\n  Arg [1]   : none\n  Function  : Saves a serialised representation of the object structure\n              to disk. Returns the name of the file that the object was\n              saved to.\n  Returntype: string\n\n  Exceptions: \n  Caller    : \n  Example   : my $token = $obj->store();\n\n\nsub store{\n  my $self = shift;\n  my $statefile = $self->statefile;\n  my $store_obj = $self->serialise;\n  my $io = Bio::Root::IO->new( \">$statefile\" );\n  $io->_print( $store_obj );\n  $self->debug( \"STORING $self to $statefile\\n\" );\n  return $statefile;\n}\n\n#----------------------------------------------------------------------\n\n=head2 serialise\n\n  Arg [1]   : none\n  Function  : Prepares the the serialised representation of the object.\n              Object attribute names starting with '__' are skipped.\n              This is useful for those that do not serialise too well\n              (e.g. filehandles).\n              Attributes are examined for other storable objects. If these\n              are found they are serialised seperately using 'new_retrievable'\n  Returntype: string\n  Exceptions: \n  Caller    : \n  Example   : my $serialised = $obj->serialise();\n\n\nsub serialise{\n  my $self = shift;\n\n  # Create a new object of same class that is going to be serialised\n  my $store_obj = bless( {}, ref( $self ) );\n\n  my %retargs = ( -workdir =>$self->workdir,\n\t\t  -suffix  =>$self->suffix,\n\t\t  -template=>$self->template );\n  # Assume that other storable bio objects held by this object are\n  # only 1-deep.\n\n  foreach my $key( keys( %$self ) ){\n    if( $key =~ /^__/ ){ next } # Ignore keys starting with '__'\n    my $value = $self->{$key};\n\n    # Scalar value\n    if( ! ref( $value ) ){\n      $store_obj->{$key} = $value;\n    }\n\n    # Bio::Root::Storable obj: save placeholder\n    elsif( ref($value) =~ /^Bio::/ and $value->isa('Bio::Root::Storable') ){\n      # Bio::Root::Storable\n      $store_obj->{$key} = $value->new_retrievable( %retargs );\n      next;\n    }\n\n    # Arrayref value. Look for Bio::Root::Storable objs\n    elsif( ref( $value ) eq 'ARRAY' ){\n      my @ary;\n      foreach my $val( @$value ){\n\tif( ref($val) =~ /^Bio::/ and $val->isa('Bio::Root::Storable') ){\n\t  push(  @ary, $val->new_retrievable( %retargs ) );\n\t}\n\telse{ push(  @ary, $val ) }\n      }\n      $store_obj->{$key} = \\@ary;\n    }\n\n    # Hashref value. Look for Bio::Root::Storable objs\n    elsif( ref( $value ) eq 'HASH' ){\n      my %hash;\n      foreach my $k2( keys %$value ){\n\tmy $val = $value->{$k2};\n\tif( ref($val) =~ /^Bio::/ and $val->isa('Bio::Root::Storable') ){\n\t  $hash{$k2} = $val->new_retrievable( %retargs );\n\t}\n\telse{ $hash{$k2} = $val }\n      }\n      $store_obj->{$key} = \\%hash;\n    }\n\n    # Unknown, just add to the store object regardless\n    else{ $store_obj->{$key} = $value }\n  }\n  $store_obj->retrievable(0); # Once deserialised, obj not retrievable\n  return $self->_freeze( $store_obj );\n}\n\n\n#----------------------------------------------------------------------\n\n=head2 retrieve\n\n  Arg [1]   : string; filesystem location of the state file to be retrieved\n  Function  : Retrieves a stored object from disk.\n              Note that the retrieved object will be blessed into its original\n              class, and not the\n  Returntype: Bio::Root::Storable inhereting object\n  Exceptions: \n  Caller    : \n  Example   : my $obj = Bio::Root::Storable->retrieve( $token );","parameters":[{"label":"$caller"},{"label":"$statefile"}],"label":"retrieve($caller,$statefile)"},"children":[{"line":465,"localvar":"my","containerName":"retrieve","kind":13,"name":"$caller","definition":"my"},{"line":465,"kind":13,"containerName":"retrieve","name":"$statefile"},{"kind":13,"localvar":"my","containerName":"retrieve","name":"$self","line":467,"definition":"my"},{"line":468,"name":"$class","kind":13,"localvar":"my","containerName":"retrieve","definition":"my"},{"line":468,"containerName":"retrieve","kind":13,"name":"$caller"},{"kind":13,"containerName":"retrieve","name":"$caller","line":468},{"kind":13,"containerName":"retrieve","name":"$caller","line":471},{"line":472,"kind":13,"containerName":"retrieve","name":"$caller"},{"line":472,"name":"retrievable","containerName":"retrieve","kind":12},{"line":473,"name":"$self","containerName":"retrieve","kind":13},{"line":473,"name":"$caller","kind":13,"containerName":"retrieve"},{"line":474,"name":"$statefile","kind":13,"containerName":"retrieve"},{"containerName":"retrieve","kind":13,"name":"$self","line":474},{"name":"statefile","kind":12,"containerName":"retrieve","line":474},{"containerName":"retrieve","kind":13,"name":"$self","line":476},{"line":476,"name":"$class","containerName":"retrieve","kind":13},{"line":479,"name":"$statefile","containerName":"retrieve","kind":13},{"kind":13,"containerName":"retrieve","name":"$self","line":480},{"name":"throw","containerName":"retrieve","kind":12,"line":480},{"line":482,"name":"$io","kind":13,"localvar":"my","containerName":"retrieve","definition":"my"},{"line":482,"containerName":"retrieve","kind":12,"name":"new"},{"line":482,"name":"$statefile","containerName":"retrieve","kind":13},{"definition":"my","line":484,"containerName":"retrieve","localvar":"my","kind":13,"name":"$state_str"},{"name":"$io","kind":13,"containerName":"retrieve","line":484},{"line":484,"name":"_readline","kind":12,"containerName":"retrieve"},{"definition":"my","line":487,"name":"$stored_obj","localvar":"my","kind":13,"containerName":"retrieve"},{"definition":"my","localvar":"my","kind":13,"containerName":"retrieve","name":"$success","line":488},{"line":489,"name":"$i","kind":13,"localvar":"my","containerName":"retrieve","definition":"my"},{"name":"$i","kind":13,"containerName":"retrieve","line":489},{"line":489,"kind":13,"containerName":"retrieve","name":"$i"},{"line":490,"containerName":"retrieve","kind":13,"name":"$stored_obj"},{"line":490,"kind":13,"containerName":"retrieve","name":"$self"},{"name":"_thaw","kind":12,"containerName":"retrieve","line":490},{"line":490,"name":"$state_str","containerName":"retrieve","kind":13},{"line":491,"name":"$success","containerName":"retrieve","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"retrieve","name":"$package","line":492},{"line":494,"name":"$postmatch","containerName":"retrieve","localvar":"my","kind":13,"definition":"my"},{"line":495,"name":"$postmatch","containerName":"retrieve","kind":13},{"line":496,"kind":13,"containerName":"retrieve","name":"$package"},{"name":"$package","kind":13,"containerName":"retrieve","line":499},{"containerName":"retrieve","kind":13,"name":"$self","line":500},{"line":500,"name":"throw","containerName":"retrieve","kind":12},{"kind":13,"containerName":"retrieve","name":"$self","line":502},{"line":502,"name":"throw","containerName":"retrieve","kind":12},{"containerName":"retrieve","kind":13,"name":"$success","line":504},{"name":"$self","containerName":"retrieve","kind":13,"line":504},{"line":504,"kind":12,"containerName":"retrieve","name":"throw"},{"name":"$stored_obj","containerName":"retrieve","kind":13,"line":506},{"name":"$self","kind":13,"containerName":"retrieve","line":507},{"containerName":"retrieve","kind":12,"name":"throw","line":507},{"line":509,"name":"$self","kind":13,"containerName":"retrieve"},{"line":509,"kind":13,"containerName":"retrieve","name":"$stored_obj"},{"containerName":"retrieve","kind":13,"name":"$stored_obj","line":509},{"line":510,"name":"$self","kind":13,"containerName":"retrieve"},{"line":510,"kind":12,"containerName":"retrieve","name":"retrievable"},{"kind":13,"containerName":"retrieve","name":"$self","line":513}],"name":"retrieve","containerName":"main::","definition":"sub","detail":"($caller,$statefile)"},{"containerName":"Root::IO","kind":12,"name":"Bio","line":482},{"definition":"sub","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"clone","line":531},{"definition":"my","line":532,"name":"$frozen","containerName":"clone","localvar":"my","kind":13},{"kind":13,"containerName":"clone","name":"$self","line":532},{"kind":12,"containerName":"clone","name":"_freeze","line":532},{"line":532,"containerName":"clone","kind":13,"name":"$self"},{"name":"$self","containerName":"clone","kind":13,"line":533},{"line":533,"name":"_thaw","kind":12,"containerName":"clone"},{"kind":13,"containerName":"clone","name":"$frozen","line":533}],"containerName":"main::","name":"clone","line":530,"kind":12,"range":{"start":{"line":530,"character":0},"end":{"line":534,"character":9999}}},{"definition":"sub","name":"remove","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"remove","name":"$self","line":552},{"name":"$self","kind":13,"containerName":"remove","line":553},{"name":"statefile","kind":12,"containerName":"remove","line":553},{"line":554,"containerName":"remove","kind":13,"name":"$self"},{"containerName":"remove","kind":12,"name":"statefile","line":554}],"range":{"end":{"character":9999,"line":557},"start":{"line":551,"character":0}},"kind":12,"line":551},{"range":{"start":{"line":574,"character":0},"end":{"character":9999,"line":584}},"kind":12,"line":574,"definition":"sub","containerName":"main::","name":"_freeze","children":[{"definition":"my","line":575,"name":"$self","localvar":"my","kind":13,"containerName":"_freeze"},{"definition":"my","line":576,"name":"$data","localvar":"my","kind":13,"containerName":"_freeze"},{"line":577,"name":"$BINARY","kind":13,"containerName":"_freeze"},{"line":578,"name":"$data","kind":13,"containerName":"_freeze"},{"name":"$Data","kind":13,"containerName":"_freeze","line":581},{"line":582,"name":"Dump","kind":12,"containerName":"_freeze"},{"line":582,"kind":13,"containerName":"_freeze","name":"$data"}]},{"name":"freeze","kind":12,"line":578},{"kind":12,"containerName":"Purity","name":"Dumper","line":581},{"line":582,"name":"Data","containerName":"Dumper","kind":12},{"kind":12,"range":{"start":{"character":0,"line":603},"end":{"character":9999,"line":617}},"line":603,"containerName":"main::","name":"_thaw","children":[{"definition":"my","line":604,"name":"$self","kind":13,"localvar":"my","containerName":"_thaw"},{"definition":"my","name":"$data","containerName":"_thaw","localvar":"my","kind":13,"line":605},{"kind":13,"containerName":"_thaw","name":"$BINARY","line":606},{"line":606,"name":"$data","containerName":"_thaw","kind":13},{"line":608,"localvar":"my","containerName":"_thaw","kind":13,"name":"$code","definition":"my"},{"line":609,"name":"$code","containerName":"_thaw","kind":13},{"line":609,"containerName":"_thaw","kind":13,"name":"$data"},{"line":611,"kind":13,"containerName":"_thaw","name":"$self"},{"line":611,"name":"throw","kind":12,"containerName":"_thaw"},{"kind":13,"containerName":"_thaw","name":"$code","line":613},{"name":"$self","kind":13,"containerName":"_thaw","line":614},{"containerName":"_thaw","kind":12,"name":"throw","line":614}],"definition":"sub"},{"kind":12,"name":"thaw","line":606},{"kind":12,"name":"code","line":615}]}