{"vars":[{"line":116,"name":"vars","kind":2,"containerName":""},{"name":"base","containerName":"","kind":2,"line":117},{"name":"%FORMAT","containerName":null,"kind":13,"line":119},{"name":"new","containerName":"main::","children":[{"definition":"my","line":149,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"line":149,"name":"%param","kind":13,"containerName":"new"},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$format","line":150},{"name":"@param","containerName":"new","kind":13,"line":152},{"kind":13,"containerName":"new","name":"%param","line":152},{"line":152,"name":"%param","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$format","line":153},{"name":"$FORMAT","kind":13,"containerName":"new","line":153},{"line":153,"name":"$param","kind":13,"containerName":"new"},{"line":153,"name":"$param","containerName":"new","kind":13},{"line":154,"name":"$format","containerName":"new","kind":13},{"line":154,"kind":13,"containerName":"new","name":"$class"},{"name":"_guess_format","kind":12,"containerName":"new","line":154},{"line":154,"kind":13,"containerName":"new","name":"$param"},{"name":"$ARGV","kind":13,"containerName":"new","line":154},{"line":156,"name":"$format","containerName":"new","kind":13},{"name":"$class","containerName":"new","kind":13,"line":158},{"line":158,"kind":12,"containerName":"new","name":"_load_format_module"},{"line":158,"name":"$format","containerName":"new","kind":13},{"kind":12,"containerName":"new","name":"new","line":159},{"name":"%param","kind":13,"containerName":"new","line":159}],"detail":"($class,%param)","definition":"sub","kind":12,"range":{"start":{"line":148,"character":0},"end":{"character":9999,"line":160}},"line":148,"signature":{"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Restriction::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rob Edwards <redwards@utmem.edu>\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Restriction::IO - Handler for sequence variation IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Restriction::IO;\n\n    $in  = Bio::Restriction::IO->new(-file => \"inputfilename\" ,\n                                     -format => 'withrefm');\n    my $res = $in->read; # a Bio::Restriction::EnzymeCollection\n\n=head1 DESCRIPTION\n\nL<Bio::Restriction::IO> is a handler module for the formats in the\nRestriction IO set, e.g. C<Bio::Restriction::IO::xxx>. It is the\nofficially sanctioned way of getting at the format objects, which most\npeople should use.\n\nThe structure, conventions and most of the code is inherited from\nL<Bio::SeqIO>. The main difference is that instead of using methods\nC<next_seq>, you drop C<_seq> from the method name.\n\nAlso, instead of dealing only with individual L<Bio::Restriction::Enzyme>\nobjects, C<read()> will slurp in all enzymes into a \nL<Bio::Restriction::EnzymeCollection> object.\n\nFor more details, see documentation in L<Bio::SeqIO>.\n\n=head1 TO DO\n\nAt the moment, these can be use mainly to get a custom set if enzymes in\nC<withrefm> or C<itype2> formats into L<Bio::Restriction::Enzyme> or\nL<Bio::Restriction::EnzymeCollection> objects.  Using C<bairoch> format is\nhighly experimental and is not recommmended at this time.\n\nThis class inherits from L<Bio::SeqIO> for convenience sake, though this should\ninherit from L<Bio::Root::Root>.  Get rid of L<Bio::SeqIO> inheritance by\ncopying relevant methods in.\n\nC<write()> methods are currently not implemented for any format except C<base>.\nUsing C<write()> even with C<base> format is not recommended as it does not\nsupport multicut/multisite enzyme output.\n\nShould additional formats be supported (such as XML)?\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, \nL<Bio::Restriction::Enzyme>, \nL<Bio::Restriction::EnzymeCollection>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Restriction::IO;\n\nuse strict;\nuse vars qw(%FORMAT);\nuse base qw(Bio::SeqIO);\n\n%FORMAT = (\n            'itype2'    => 'itype2',\n            '8'         => 'itype2',\n            'withrefm'  => 'withrefm',\n            '31'        => 'withrefm',\n            'base'      => 'base',\n            '0'         => 'base',\n            'bairoch'   => 'bairoch',\n            '19'        => 'bairoch',\n            'macvector' => 'bairoch',\n            'vectorNTI' => 'bairoch',\n            'neo'       => 'prototype',\n            'prototype' => 'prototype'\n);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Restriction::IO->new(-file => $filename,\n                                               -format => 'Format')\n Function: Returns a new seqstream\n Returns : A Bio::Restriction::IO::Handler initialised with\n           the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to","parameters":[{"label":"$class"},{"label":"%param"}],"label":"new($class,%param)"}},{"children":[{"localvar":"my","kind":13,"containerName":"_load_format_module","name":"$class","line":164,"definition":"my"},{"line":164,"containerName":"_load_format_module","kind":13,"name":"$format"},{"name":"$module","containerName":"_load_format_module","localvar":"my","kind":13,"line":165,"definition":"my"},{"name":"$format","kind":13,"containerName":"_load_format_module","line":165},{"line":166,"localvar":"my","containerName":"_load_format_module","kind":13,"name":"$ok","definition":"my"},{"containerName":"_load_format_module","kind":13,"name":"$ok","line":168},{"line":168,"containerName":"_load_format_module","kind":13,"name":"$class"},{"containerName":"_load_format_module","kind":12,"name":"_load_module","line":168},{"line":168,"containerName":"_load_format_module","kind":13,"name":"$module"},{"name":"$ok","kind":13,"containerName":"_load_format_module","line":179}],"name":"_load_format_module","containerName":"main::","definition":"sub","detail":"($class,$format)","line":163,"range":{"end":{"line":180,"character":9999},"start":{"character":0,"line":163}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"$format"}],"label":"_load_format_module($class,$format)"}},{"range":{"end":{"character":9999,"line":195},"start":{"character":0,"line":192}},"kind":12,"line":192,"signature":{"label":"read($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Restriction::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rob Edwards <redwards@utmem.edu>\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Restriction::IO - Handler for sequence variation IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Restriction::IO;\n\n    $in  = Bio::Restriction::IO->new(-file => \"inputfilename\" ,\n                                     -format => 'withrefm');\n    my $res = $in->read; # a Bio::Restriction::EnzymeCollection\n\n=head1 DESCRIPTION\n\nL<Bio::Restriction::IO> is a handler module for the formats in the\nRestriction IO set, e.g. C<Bio::Restriction::IO::xxx>. It is the\nofficially sanctioned way of getting at the format objects, which most\npeople should use.\n\nThe structure, conventions and most of the code is inherited from\nL<Bio::SeqIO>. The main difference is that instead of using methods\nC<next_seq>, you drop C<_seq> from the method name.\n\nAlso, instead of dealing only with individual L<Bio::Restriction::Enzyme>\nobjects, C<read()> will slurp in all enzymes into a \nL<Bio::Restriction::EnzymeCollection> object.\n\nFor more details, see documentation in L<Bio::SeqIO>.\n\n=head1 TO DO\n\nAt the moment, these can be use mainly to get a custom set if enzymes in\nC<withrefm> or C<itype2> formats into L<Bio::Restriction::Enzyme> or\nL<Bio::Restriction::EnzymeCollection> objects.  Using C<bairoch> format is\nhighly experimental and is not recommmended at this time.\n\nThis class inherits from L<Bio::SeqIO> for convenience sake, though this should\ninherit from L<Bio::Root::Root>.  Get rid of L<Bio::SeqIO> inheritance by\ncopying relevant methods in.\n\nC<write()> methods are currently not implemented for any format except C<base>.\nUsing C<write()> even with C<base> format is not recommended as it does not\nsupport multicut/multisite enzyme output.\n\nShould additional formats be supported (such as XML)?\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, \nL<Bio::Restriction::Enzyme>, \nL<Bio::Restriction::EnzymeCollection>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Restriction::IO;\n\nuse strict;\nuse vars qw(%FORMAT);\nuse base qw(Bio::SeqIO);\n\n%FORMAT = (\n            'itype2'    => 'itype2',\n            '8'         => 'itype2',\n            'withrefm'  => 'withrefm',\n            '31'        => 'withrefm',\n            'base'      => 'base',\n            '0'         => 'base',\n            'bairoch'   => 'bairoch',\n            '19'        => 'bairoch',\n            'macvector' => 'bairoch',\n            'vectorNTI' => 'bairoch',\n            'neo'       => 'prototype',\n            'prototype' => 'prototype'\n);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Restriction::IO->new(-file => $filename,\n                                               -format => 'Format')\n Function: Returns a new seqstream\n Returns : A Bio::Restriction::IO::Handler initialised with\n           the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n\n\nsub new {\n   my ($class, %param) = @_;\n   my ($format);\n\n   @param{ map { lc $_ } keys %param } = values %param;  # lowercase keys\n   $format = $FORMAT{$param{'-format'}} if defined $param{'-format'};\n   $format ||= $class->_guess_format( $param{-file} || $ARGV[0] )\n             || 'base';\n   $format = \"\\L$format\"; # normalize capitalization to lower case\n\n   return unless $class->_load_format_module($format);\n   return \"Bio::Restriction::IO::$format\"->new(%param);\n}\n\n\nsub _load_format_module {\n  my ($class, $format) = @_;\n  my $module = \"Bio::Restriction::IO::\" . $format;\n  my $ok;\n  eval {\n      $ok = $class->_load_module($module);\n  };\n  if ( $@ ) {\n    print STDERR <<END;\n$class: $format cannot be found\nException $@\nFor more information about the IO system please see the IO docs.\nThis includes ways of checking for formats at compile time, not run time\nEND\n  ;\n  }\n  return $ok;\n}\n\n=head2 read\n\n Title   : read\n Usage   : $renzs = $stream->read\n Function: reads all the restrction enzymes from the stream\n Returns : a Bio::Restriction::EnzymeCollection object\n Args    :"},"containerName":"main::","name":"read","children":[{"name":"$self","containerName":"read","localvar":"my","kind":13,"line":193,"definition":"my"},{"line":193,"name":"$seq","kind":13,"containerName":"read"},{"line":194,"containerName":"read","kind":13,"name":"$self"},{"name":"throw_not_implemented","containerName":"read","kind":12,"line":194}],"detail":"($self,$seq)","definition":"sub"},{"line":197,"kind":12,"range":{"end":{"character":9999,"line":200},"start":{"character":0,"line":197}},"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$seq"}],"label":"next($self,$seq)"},"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"next","line":198,"definition":"my"},{"kind":13,"containerName":"next","name":"$seq","line":198},{"name":"$self","containerName":"next","kind":13,"line":199},{"line":199,"name":"throw_not_implemented","kind":12,"containerName":"next"}],"name":"next","containerName":"main::","definition":"sub","detail":"($self,$seq)"},{"line":202,"kind":12,"range":{"end":{"line":205,"character":9999},"start":{"character":0,"line":202}},"signature":{"parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"","label":"next_seq($self,$seq)"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"next_seq","line":203,"definition":"my"},{"kind":13,"containerName":"next_seq","name":"$seq","line":203},{"line":204,"containerName":"next_seq","kind":13,"name":"$self"},{"line":204,"kind":12,"containerName":"next_seq","name":"throw_not_implemented"}],"name":"next_seq","containerName":"main::","definition":"sub","detail":"($self,$seq)"},{"definition":"sub","detail":"($self,$seq)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"write","name":"$self","line":218},{"name":"$seq","containerName":"write","kind":13,"line":218},{"containerName":"write","kind":13,"name":"$self","line":219},{"name":"throw","kind":12,"containerName":"write","line":219}],"name":"write","containerName":"main::","signature":{"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Restriction::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rob Edwards <redwards@utmem.edu>\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Restriction::IO - Handler for sequence variation IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Restriction::IO;\n\n    $in  = Bio::Restriction::IO->new(-file => \"inputfilename\" ,\n                                     -format => 'withrefm');\n    my $res = $in->read; # a Bio::Restriction::EnzymeCollection\n\n=head1 DESCRIPTION\n\nL<Bio::Restriction::IO> is a handler module for the formats in the\nRestriction IO set, e.g. C<Bio::Restriction::IO::xxx>. It is the\nofficially sanctioned way of getting at the format objects, which most\npeople should use.\n\nThe structure, conventions and most of the code is inherited from\nL<Bio::SeqIO>. The main difference is that instead of using methods\nC<next_seq>, you drop C<_seq> from the method name.\n\nAlso, instead of dealing only with individual L<Bio::Restriction::Enzyme>\nobjects, C<read()> will slurp in all enzymes into a \nL<Bio::Restriction::EnzymeCollection> object.\n\nFor more details, see documentation in L<Bio::SeqIO>.\n\n=head1 TO DO\n\nAt the moment, these can be use mainly to get a custom set if enzymes in\nC<withrefm> or C<itype2> formats into L<Bio::Restriction::Enzyme> or\nL<Bio::Restriction::EnzymeCollection> objects.  Using C<bairoch> format is\nhighly experimental and is not recommmended at this time.\n\nThis class inherits from L<Bio::SeqIO> for convenience sake, though this should\ninherit from L<Bio::Root::Root>.  Get rid of L<Bio::SeqIO> inheritance by\ncopying relevant methods in.\n\nC<write()> methods are currently not implemented for any format except C<base>.\nUsing C<write()> even with C<base> format is not recommended as it does not\nsupport multicut/multisite enzyme output.\n\nShould additional formats be supported (such as XML)?\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, \nL<Bio::Restriction::Enzyme>, \nL<Bio::Restriction::EnzymeCollection>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Restriction::IO;\n\nuse strict;\nuse vars qw(%FORMAT);\nuse base qw(Bio::SeqIO);\n\n%FORMAT = (\n            'itype2'    => 'itype2',\n            '8'         => 'itype2',\n            'withrefm'  => 'withrefm',\n            '31'        => 'withrefm',\n            'base'      => 'base',\n            '0'         => 'base',\n            'bairoch'   => 'bairoch',\n            '19'        => 'bairoch',\n            'macvector' => 'bairoch',\n            'vectorNTI' => 'bairoch',\n            'neo'       => 'prototype',\n            'prototype' => 'prototype'\n);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Restriction::IO->new(-file => $filename,\n                                               -format => 'Format')\n Function: Returns a new seqstream\n Returns : A Bio::Restriction::IO::Handler initialised with\n           the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n\n\nsub new {\n   my ($class, %param) = @_;\n   my ($format);\n\n   @param{ map { lc $_ } keys %param } = values %param;  # lowercase keys\n   $format = $FORMAT{$param{'-format'}} if defined $param{'-format'};\n   $format ||= $class->_guess_format( $param{-file} || $ARGV[0] )\n             || 'base';\n   $format = \"\\L$format\"; # normalize capitalization to lower case\n\n   return unless $class->_load_format_module($format);\n   return \"Bio::Restriction::IO::$format\"->new(%param);\n}\n\n\nsub _load_format_module {\n  my ($class, $format) = @_;\n  my $module = \"Bio::Restriction::IO::\" . $format;\n  my $ok;\n  eval {\n      $ok = $class->_load_module($module);\n  };\n  if ( $@ ) {\n    print STDERR <<END;\n$class: $format cannot be found\nException $@\nFor more information about the IO system please see the IO docs.\nThis includes ways of checking for formats at compile time, not run time\nEND\n  ;\n  }\n  return $ok;\n}\n\n=head2 read\n\n Title   : read\n Usage   : $renzs = $stream->read\n Function: reads all the restrction enzymes from the stream\n Returns : a Bio::Restriction::EnzymeCollection object\n Args    :\n\n\nsub read {\n   my ($self, $seq) = @_;\n   $self->throw_not_implemented();\n}\n\nsub next {\n   my ($self, $seq) = @_;\n   $self->throw_not_implemented();\n}\n\nsub next_seq {\n   my ($self, $seq) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 write\n\n Title   : write\n Usage   : $stream->write($seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Restriction::EnzymeCollection object","parameters":[{"label":"$self"},{"label":"$seq"}],"label":"write($self,$seq)"},"line":217,"kind":12,"range":{"start":{"character":0,"line":217},"end":{"character":9999,"line":221}}},{"definition":"sub","detail":"($self,$seq)","children":[{"line":224,"name":"$self","kind":13,"localvar":"my","containerName":"write_seq","definition":"my"},{"name":"$seq","kind":13,"containerName":"write_seq","line":224},{"line":225,"name":"$self","kind":13,"containerName":"write_seq"},{"name":"warn","kind":12,"containerName":"write_seq","line":225},{"line":227,"containerName":"write_seq","kind":13,"name":"$self"},{"name":"write","kind":12,"containerName":"write_seq","line":227},{"kind":13,"containerName":"write_seq","name":"$seq","line":227}],"containerName":"main::","name":"write_seq","signature":{"label":"write_seq($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":""},"line":223,"kind":12,"range":{"end":{"line":228,"character":9999},"start":{"line":223,"character":0}}},{"definition":"sub","name":"_guess_format","containerName":"main::","children":[{"name":"$class","localvar":"my","kind":13,"containerName":"_guess_format","line":242,"definition":"my"}],"kind":12,"range":{"end":{"character":9999,"line":246},"start":{"character":0,"line":241}},"line":241}],"version":5}