{"version":5,"vars":[{"kind":2,"containerName":"","name":"vars","line":207},{"containerName":"","kind":2,"name":"base","line":208},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$class","line":230},{"kind":13,"containerName":"new","name":"@args","line":230},{"line":231,"name":"$self","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"line":231,"name":"$class","containerName":"new","kind":13},{"line":231,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":232,"name":"$seq","containerName":"new","localvar":"my","kind":13},{"containerName":"new","kind":13,"name":"$enzymes","line":232},{"line":233,"name":"$self","containerName":"new","kind":13},{"line":233,"name":"_rearrange","containerName":"new","kind":12},{"line":237,"name":"@args","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$seq","line":239},{"containerName":"new","kind":13,"name":"$self","line":239},{"line":239,"containerName":"new","kind":12,"name":"seq"},{"containerName":"new","kind":13,"name":"$seq","line":239},{"line":241,"kind":13,"containerName":"new","name":"$enzymes"},{"containerName":"new","kind":13,"name":"$self","line":241},{"line":241,"name":"enzymes","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"$enzymes","line":241},{"name":"$self","containerName":"new","kind":13,"line":242},{"line":242,"name":"new","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$self","line":245},{"name":"$self","containerName":"new","kind":13,"line":249},{"containerName":"new","kind":13,"name":"$self","line":251},{"line":252,"containerName":"new","kind":13,"name":"$self"},{"line":253,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"containerName":"new","name":"$self","line":254},{"containerName":"new","kind":13,"name":"$self","line":255},{"name":"$self","kind":13,"containerName":"new","line":257}],"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Analysis.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Restriction::Analysis\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rob Edwards <redwards@utmem.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Restriction::Analysis - cutting sequences with restriction\nenzymes\n\n=head1 SYNOPSIS\n\n  # analyze a DNA sequence for restriction enzymes\n  use Bio::Restriction::Analysis;\n  use Bio::PrimarySeq;\n  use Data::Dumper;\n\n  # get a DNA sequence from somewhere\n  my $seq = Bio::PrimarySeq->new\n      (-seq =>'AGCTTAATTCATTAGCTCTGACTGCAACGGGCAATATGTCTC',\n       -primary_id => 'synopsis',\n       -molecule => 'dna');\n\n  # now start an analysis.\n  # this is using the default set of enzymes\n  my $ra = Bio::Restriction::Analysis->new(-seq=>$seq);\n\n  # find unique cutters. This returns a\n  # Bio::Restriction::EnzymeCollection object\n  my $enzymes = $ra->unique_cutters;\n  print \"Unique cutters: \", join (', ', \n      map {$_->name} $enzymes->unique_cutters), \"\\n\";\n\n  # AluI is one them. Where does it cut?\n  # This is will return an array of the sequence strings\n\n  my $enz = 'AluI';\n  my @frags = $ra->fragments($enz);\n  # how big are the fragments?\n  print \"AluI fragment lengths: \", join(' & ', map {length $_} @frags), \"\\n\";\n\n  # You can also bypass fragments and call sizes directly:\n  # to see all the fragment sizes\n  print \"All sizes: \", join \" \", $ra->sizes($enz), \"\\n\";\n  # to see all the fragment sizes sorted by size like on a gel\n  print \"All sizes, sorted \", join (\" \", $ra->sizes($enz, 0, 1)), \"\\n\";\n\n  # how many times does each enzyme cut\n  my $cuts = $ra->cuts_by_enzyme('BamHI');\n  print \"BamHI cuts $cuts times\\n\";\n\n  # How many enzymes do not cut at all?\n  print \"There are \", scalar $ra->zero_cutters->each_enzyme,\n        \" enzymes that do not cut\\n\";\n\n  # what about enzymes that cut twice?\n  my $two_cutters = $ra->cutters(2);\n  print join (\" \", map {$_->name} $two_cutters->each_enzyme),\n      \" cut the sequence twice\\n\";\n\n  # what are all the enzymes that cut, and how often do they cut\n  printf \"\\n%-10s%s\\n\", 'Enzyme', 'Number of Cuts';\n  my $all_cutters = $ra->cutters;\n  map {\n      printf \"%-10s%s\\n\", $_->name, $ra->cuts_by_enzyme($_->name)\n  } $all_cutters->each_enzyme;\n\n  # Finally, we can interact the restriction enzyme object by\n  # retrieving it from the collection object see the docs for\n  # Bio::Restriction::Enzyme.pm\n  my $enzobj = $enzymes->get_enzyme($enz);\n\n\n=head1 DESCRIPTION\n\nBio::Restriction::Analysis describes the results of cutting a DNA\nsequence with restriction enzymes.\n\nTo use this module you can pass a sequence object and optionally a\nBio::Restriction::EnzymeCollection that contains the enzyme(s) to cut the\nsequences with. There is a default set of enzymes that will be loaded\nif you do not pass in a Bio::Restriction::EnzymeCollection.\n\nTo cut a sequence, set up a Restriction::Analysis object with a sequence\nlike this:\n\n  use Bio::Restriction::Analysis;\n  my $ra = Bio::Restriction::Analysis->new(-seq=>$seqobj);\n\nor\n\n  my $ra = Bio::Restriction::Analysis->new\n      (-seq=>$seqobj, -enzymes=>$enzs);\n\nThen, to get the fragments for a particular enzyme use this:\n\n  @fragments = $ra->fragments('EcoRI');\n\nNote that the naming of restriction enzymes is that the last numbers\nare usually Roman numbers (I, II, III, etc). You may want to use\nsomething like this:\n\n  # get a reference to an array of unique (single) cutters\n  $singles = $re->unique_cutters;\n  foreach my $enz ($singles->each_enzyme) {\n      @fragments = $re->fragments($enz);\n      ... do something here ...\n  }\n\nNote that if your sequence is circular, the first and last fragment\nwill be joined so that they are the appropriate length and sequence\nfor further analysis. This fragment will also be checked for cuts\nby the enzyme(s).  However, this will change the start of the\nsequence!\n\nThere are two separate algorithms used depending on whether your\nenzyme has ambiguity. The non-ambiguous algoritm is a lot faster,\nand if you are using very large sequences you should try and use\nthis algorithm. If you have a large sequence (e.g. genome) and \nwant to use ambgiuous enzymes you may want to make separate\nBio::Restriction::Enzyme objects for each of the possible\nalternatives and make sure that you do not set is_ambiguous!\n\nThis version should correctly deal with overlapping cut sites\nin both ambiguous and non-ambiguous enzymes.\n\nI have tried to write this module with speed and memory in mind\nso that it can be effectively used for large (e.g. genome sized)\nsequence. This module only stores the cut positions internally,\nand calculates everything else on an as-needed basis. Therefore\nwhen you call fragment_maps (for example), there may be another\ndelay while these are generated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists \n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu, \nSteve Chervitz, sac@bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nMark A. Jensen, maj-at-fortinbras-dot-us\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Rob Edwards.  Some of this work is Copyright (c)\n1997-2002 Steve A. Chervitz. All Rights Reserved.\n\nThis module is free software; you can redistribute it and/or modify it\nunder the same terms as Perl itself.\n\n=head1 SEE ALSO\n\nL<Bio::Restriction::Enzyme>, \nL<Bio::Restriction::EnzymeCollection>\n\n=head1 APPENDIX\n\nMethods beginning with a leading underscore are considered private and\nare intended for internal use by this module. They are not considered\npart of the public interface and are described here for documentation\npurposes only.\n\n\npackage Bio::Restriction::Analysis;\nuse Bio::Restriction::EnzymeCollection;\nuse strict;\nuse Data::Dumper;\n\nuse vars qw ();\nuse base qw(Bio::Root::Root);\n\n=head1 new\n\n Title     : new\n Function  : Initializes the restriction enzyme object\n Returns   : The Restriction::Analysis object \n Arguments : \n\n\t     $re_anal->new(-seq=$seqobj, \n                 -enzymes=>Restriction::EnzymeCollection object)\n\t     -seq requires a Bio::PrimarySeq object\n\t     -enzymes is optional.\n              If ommitted it will use the default set of enzymes\n\nThis is the place to start. Pass in a sequence, and you will be able\nto get the fragments back out.  Several other things are available\nlike the number of zero cutters or single cutters."},"range":{"start":{"line":229,"character":0},"end":{"character":9999,"line":259}},"kind":12,"line":229},{"line":231,"name":"SUPER","containerName":"new","kind":12},{"line":242,"name":"Bio","containerName":"Restriction::EnzymeCollection","kind":12},{"line":249,"name":"maximum_cuts","kind":12},{"definition":"sub","name":"seq","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"seq","kind":13,"name":"$self","line":277},{"definition":"my","containerName":"seq","localvar":"my","kind":13,"name":"$seq","line":279},{"kind":13,"containerName":"seq","name":"$self","line":280},{"line":280,"name":"throw","containerName":"seq","kind":12},{"line":280,"containerName":"seq","kind":13,"name":"$seq"},{"kind":13,"containerName":"seq","name":"$seq","line":281},{"name":"isa","containerName":"seq","kind":12,"line":281},{"line":282,"name":"$self","kind":13,"containerName":"seq"},{"name":"throw","kind":12,"containerName":"seq","line":282},{"line":282,"containerName":"seq","kind":13,"name":"$seq"},{"name":"alphabet","kind":12,"containerName":"seq","line":282},{"line":283,"name":"$seq","kind":13,"containerName":"seq"},{"name":"alphabet","containerName":"seq","kind":12,"line":283},{"line":285,"containerName":"seq","kind":13,"name":"$self"},{"name":"$seq","kind":13,"containerName":"seq","line":285},{"line":286,"containerName":"seq","kind":13,"name":"$self"},{"containerName":"seq","kind":13,"name":"$self","line":288}],"range":{"start":{"character":0,"line":276},"end":{"line":289,"character":9999}},"kind":12,"line":276},{"definition":"sub","children":[{"definition":"my","line":310,"name":"$self","kind":13,"localvar":"my","containerName":"enzymes"},{"line":312,"containerName":"enzymes","kind":13,"name":"$self"},{"line":312,"name":"new","containerName":"enzymes","kind":12},{"name":"$self","containerName":"enzymes","kind":13,"line":313},{"containerName":"enzymes","kind":13,"name":"$self","line":314},{"name":"enzymes","containerName":"enzymes","kind":12,"line":314},{"containerName":"enzymes","kind":13,"name":"$self","line":315},{"line":317,"name":"$self","kind":13,"containerName":"enzymes"}],"containerName":"main::","name":"enzymes","line":309,"range":{"start":{"line":309,"character":0},"end":{"line":318,"character":9999}},"kind":12},{"line":312,"kind":12,"containerName":"Restriction::EnzymeCollection","name":"Bio"},{"signature":{"label":"cut($self,$opt,$ec)","parameters":[{"label":"$self"},{"label":"$opt"},{"label":"$ec"}],"documentation":""},"kind":12,"range":{"end":{"character":9999,"line":385},"start":{"line":359,"character":0}},"line":359,"detail":"($self,$opt,$ec)","definition":"sub","containerName":"main::","name":"cut","children":[{"line":360,"localvar":"my","containerName":"cut","kind":13,"name":"$self","definition":"my"},{"line":360,"containerName":"cut","kind":13,"name":"$opt"},{"name":"$ec","kind":13,"containerName":"cut","line":360},{"kind":13,"containerName":"cut","name":"$self","line":366},{"name":"throw","containerName":"cut","kind":12,"line":366},{"line":367,"name":"$self","kind":13,"containerName":"cut"},{"line":367,"kind":12,"containerName":"cut","name":"seq"},{"kind":13,"containerName":"cut","name":"$opt","line":369},{"containerName":"cut","kind":13,"name":"$self","line":370},{"line":370,"name":"throw","containerName":"cut","kind":12},{"kind":13,"containerName":"cut","name":"$ec","line":370},{"name":"$self","kind":13,"containerName":"cut","line":371},{"line":371,"name":"_multiple_cuts","kind":12,"containerName":"cut"},{"name":"$ec","containerName":"cut","kind":13,"line":371},{"line":374,"containerName":"cut","kind":13,"name":"$self"},{"line":375,"name":"$self","kind":13,"containerName":"cut"},{"line":376,"kind":13,"containerName":"cut","name":"$self"},{"line":377,"name":"$self","containerName":"cut","kind":13},{"line":378,"containerName":"cut","kind":13,"name":"$self"},{"kind":13,"containerName":"cut","name":"$self","line":379},{"name":"$self","containerName":"cut","kind":13,"line":380},{"line":380,"kind":12,"containerName":"cut","name":"_cuts"},{"line":383,"kind":13,"containerName":"cut","name":"$self"},{"line":384,"kind":13,"containerName":"cut","name":"$self"}]},{"line":374,"name":"maximum_cuts","kind":12},{"children":[{"kind":13,"localvar":"my","containerName":"multiple_digest","name":"$self","line":404,"definition":"my"},{"name":"$ec","kind":13,"containerName":"multiple_digest","line":404},{"line":405,"kind":13,"containerName":"multiple_digest","name":"$self"},{"containerName":"multiple_digest","kind":12,"name":"cut","line":405},{"line":405,"kind":13,"containerName":"multiple_digest","name":"$ec"}],"name":"multiple_digest","containerName":"main::","definition":"sub","detail":"($self,$ec)","line":403,"kind":12,"range":{"end":{"character":9999,"line":406},"start":{"line":403,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"$ec"}],"documentation":"","label":"multiple_digest($self,$ec)"}},{"containerName":"main::","name":"positions","children":[{"line":424,"name":"$self","localvar":"my","containerName":"positions","kind":13,"definition":"my"},{"line":424,"kind":13,"containerName":"positions","name":"$enz"},{"containerName":"positions","kind":13,"name":"$self","line":425},{"line":425,"name":"cut","containerName":"positions","kind":12},{"line":425,"name":"$self","kind":13,"containerName":"positions"},{"kind":13,"containerName":"positions","name":"$self","line":426},{"line":426,"name":"throw","containerName":"positions","kind":12},{"line":427,"containerName":"positions","kind":13,"name":"$enz"},{"kind":13,"containerName":"positions","name":"$self","line":429},{"line":429,"kind":13,"containerName":"positions","name":"$enz"},{"kind":13,"containerName":"positions","name":"$self","line":430},{"containerName":"positions","kind":13,"name":"$enz","line":430}],"detail":"($self,$enz)","definition":"sub","range":{"start":{"character":0,"line":423},"end":{"line":430,"character":9999}},"kind":12,"line":423,"signature":{"parameters":[{"label":"$self"},{"label":"$enz"}],"documentation":"","label":"positions($self,$enz)"}},{"detail":"($self,$enz)","definition":"sub","containerName":"main::","name":"fragments","children":[{"line":452,"localvar":"my","kind":13,"containerName":"fragments","name":"$self","definition":"my"},{"line":452,"kind":13,"containerName":"fragments","name":"$enz"},{"line":453,"containerName":"fragments","kind":13,"name":"$self"},{"line":453,"kind":12,"containerName":"fragments","name":"cut"},{"name":"$self","containerName":"fragments","kind":13,"line":453},{"name":"$self","containerName":"fragments","kind":13,"line":454},{"containerName":"fragments","kind":12,"name":"throw","line":454},{"line":455,"kind":13,"containerName":"fragments","name":"$enz"},{"kind":13,"localvar":"my","containerName":"fragments","name":"@fragments","line":456,"definition":"my"},{"line":457,"containerName":"fragments","kind":13,"name":"$self"},{"line":457,"containerName":"fragments","kind":12,"name":"fragment_maps"},{"name":"$enz","containerName":"fragments","kind":13,"line":457},{"kind":13,"containerName":"fragments","name":"@fragments","line":457},{"line":458,"name":"@fragments","kind":13,"containerName":"fragments"}],"signature":{"parameters":[{"label":"$self"},{"label":"$enz"}],"documentation":"","label":"fragments($self,$enz)"},"range":{"end":{"character":9999,"line":459},"start":{"line":451,"character":0}},"kind":12,"line":451},{"line":457,"name":"seq","kind":12},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$enz"}],"label":"fragment_maps($self,$enz)"},"range":{"start":{"line":514,"character":0},"end":{"character":9999,"line":528}},"kind":12,"line":514,"detail":"($self,$enz)","definition":"sub","containerName":"main::","name":"fragment_maps","children":[{"line":515,"name":"$self","localvar":"my","containerName":"fragment_maps","kind":13,"definition":"my"},{"line":515,"containerName":"fragment_maps","kind":13,"name":"$enz"},{"line":516,"kind":13,"containerName":"fragment_maps","name":"$self"},{"line":516,"name":"cut","kind":12,"containerName":"fragment_maps"},{"line":516,"name":"$self","containerName":"fragment_maps","kind":13},{"name":"$self","kind":13,"containerName":"fragment_maps","line":517},{"line":517,"name":"throw","containerName":"fragment_maps","kind":12},{"name":"$enz","containerName":"fragment_maps","kind":13,"line":518},{"name":"@cut_positions","kind":13,"localvar":"my","containerName":"fragment_maps","line":525,"definition":"my"},{"line":526,"name":"$enz","kind":13,"containerName":"fragment_maps"},{"line":527,"kind":13,"containerName":"fragment_maps","name":"@cut_positions"},{"containerName":"fragment_maps","kind":13,"name":"$self","line":527},{"line":527,"containerName":"fragment_maps","kind":13,"name":"$enz"}]},{"kind":13,"containerName":null,"name":"$enz","line":528},{"name":"isa","kind":12,"containerName":"main::","line":528},{"name":"@cut_positions","containerName":null,"kind":13,"line":529},{"line":529,"name":"%self","containerName":null,"kind":13},{"line":529,"name":"$enz","kind":13,"containerName":null},{"line":529,"kind":12,"containerName":"main::","name":"name"},{"name":"$enz","kind":13,"containerName":null,"line":530},{"name":"isa","kind":12,"containerName":"main::","line":530},{"kind":13,"containerName":null,"name":"$self","line":531},{"line":531,"name":"cut","kind":12,"containerName":"main::"},{"line":531,"name":"$enz","kind":13,"containerName":null},{"line":532,"kind":13,"containerName":null,"name":"@cut_positions"},{"name":"%self","kind":13,"containerName":null,"line":532},{"line":535,"containerName":null,"kind":13,"name":"@cut_positions"},{"localvar":"my","kind":13,"containerName":null,"name":"%map","line":539,"definition":"my"},{"line":541,"containerName":null,"kind":13,"name":"%self"},{"name":"length","kind":12,"containerName":"main::","line":541},{"kind":13,"containerName":null,"name":"%self","line":542},{"line":543,"containerName":"main::","kind":12,"name":"seq"},{"containerName":null,"kind":13,"name":"%self","line":544},{"name":"$enz","kind":13,"containerName":null,"line":544},{"name":"%map","kind":13,"containerName":null,"line":544},{"line":545,"name":"%self","containerName":null,"kind":13},{"line":545,"name":"$enz","kind":13,"containerName":null},{"line":546,"containerName":null,"kind":13,"name":"%self"},{"line":546,"name":"$enz","kind":13,"containerName":null},{"name":"@cut_positions","kind":13,"containerName":null,"line":549},{"containerName":null,"kind":13,"name":"$a","line":549},{"line":549,"name":"$b","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@cut_positions","line":549},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"@cuts","line":550},{"kind":13,"containerName":null,"name":"@cut_positions","line":550},{"line":551,"containerName":null,"localvar":"my","kind":13,"name":"$i","definition":"my"},{"line":551,"kind":13,"containerName":null,"name":"@cut_positions"},{"containerName":null,"kind":13,"name":"@cuts","line":552},{"line":552,"name":"$i","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$i","line":552},{"name":"@cuts","kind":13,"containerName":null,"line":552},{"line":552,"kind":12,"name":"cuts"},{"definition":"my","name":"$start","localvar":"my","containerName":null,"kind":13,"line":555},{"line":555,"kind":13,"localvar":"my","containerName":null,"name":"$stop","definition":"my"},{"definition":"my","line":555,"containerName":null,"localvar":"my","kind":13,"name":"%seq"},{"definition":"my","line":555,"name":"%stop","kind":13,"localvar":"my","containerName":null},{"name":"$stop","containerName":null,"kind":13,"line":556},{"name":"@cuts","containerName":null,"kind":13,"line":556},{"kind":13,"containerName":null,"name":"%seq","line":557},{"name":"$start","kind":13,"containerName":null,"line":557},{"line":557,"kind":13,"containerName":null,"name":"%self"},{"name":"subseq","containerName":"main::","kind":12,"line":557},{"line":557,"kind":13,"containerName":null,"name":"$start"},{"containerName":null,"kind":13,"name":"$stop","line":557},{"containerName":null,"kind":13,"name":"%stop","line":558},{"kind":13,"containerName":null,"name":"$start","line":558},{"line":558,"kind":13,"containerName":null,"name":"$stop"},{"line":559,"name":"$start","kind":13,"containerName":null},{"line":559,"kind":13,"containerName":null,"name":"$stop"},{"name":"$stop","containerName":null,"kind":13,"line":561},{"line":561,"name":"%self","containerName":null,"kind":13},{"line":561,"name":"length","kind":12,"containerName":"main::"},{"name":"$start","kind":13,"containerName":null,"line":562},{"line":562,"containerName":null,"kind":13,"name":"%stop"},{"name":"%seq","containerName":null,"kind":13,"line":567},{"line":567,"name":"$start","kind":13,"containerName":null},{"line":567,"kind":13,"containerName":null,"name":"%self"},{"line":567,"kind":12,"containerName":"main::","name":"subseq"},{"line":567,"name":"$start","kind":13,"containerName":null},{"line":567,"name":"$stop","kind":13,"containerName":null},{"line":568,"name":"%stop","kind":13,"containerName":null},{"line":568,"name":"$start","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$stop","line":568},{"line":571,"name":"%self","kind":13,"containerName":null},{"line":571,"name":"is_circular","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"%seq","line":573},{"line":573,"containerName":null,"kind":13,"name":"$start"},{"name":"%seq","containerName":null,"kind":13,"line":573},{"line":574,"name":"%seq","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%stop","line":575},{"line":575,"containerName":null,"kind":13,"name":"$start"},{"line":575,"containerName":null,"kind":13,"name":"%stop"},{"line":576,"name":"%stop","kind":13,"containerName":null},{"definition":"my","line":579,"name":"%start","localvar":"my","kind":13,"containerName":null},{"name":"$a","kind":13,"containerName":null,"line":579},{"name":"$b","containerName":null,"kind":13,"line":579},{"line":579,"kind":13,"containerName":null,"name":"%seq"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"%map","line":580},{"kind":13,"containerName":null,"name":"$start","line":581},{"line":582,"containerName":null,"kind":13,"name":"%stop"},{"name":"$start","kind":13,"containerName":null,"line":582},{"line":583,"name":"%seq","containerName":null,"kind":13},{"name":"$start","kind":13,"containerName":null,"line":583},{"line":585,"name":"%self","containerName":null,"kind":13},{"line":585,"name":"$enz","kind":13,"containerName":null},{"line":585,"name":"%map","kind":13,"containerName":null},{"line":588,"containerName":null,"kind":13,"name":"%self"},{"name":"$enz","kind":13,"containerName":null,"line":588},{"name":"%self","containerName":null,"kind":13,"line":589},{"kind":13,"containerName":null,"name":"$enz","line":589},{"kind":12,"range":{"start":{"line":618,"character":0},"end":{"character":9999,"line":624}},"line":618,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$enz"},{"label":"$kb"},{"label":"$sort"}],"label":"sizes($self,$enz,$kb,$sort)"},"name":"sizes","containerName":"main::","children":[{"definition":"my","line":619,"kind":13,"localvar":"my","containerName":"sizes","name":"$self"},{"name":"$enz","containerName":"sizes","kind":13,"line":619},{"name":"$kb","kind":13,"containerName":"sizes","line":619},{"name":"$sort","kind":13,"containerName":"sizes","line":619},{"kind":13,"containerName":"sizes","name":"$self","line":620},{"line":620,"name":"throw","kind":12,"containerName":"sizes"},{"containerName":"sizes","kind":13,"name":"$enz","line":621},{"line":622,"kind":13,"containerName":"sizes","name":"$self"},{"line":622,"containerName":"sizes","kind":12,"name":"cut"},{"name":"$self","containerName":"sizes","kind":13,"line":622},{"line":623,"name":"@frag","kind":13,"localvar":"my","containerName":"sizes","definition":"my"},{"kind":13,"localvar":"my","containerName":"sizes","name":"$lastsite","line":623,"definition":"my"},{"line":624,"localvar":"my","containerName":"sizes","kind":13,"name":"$site","definition":"my"},{"line":624,"name":"$self","kind":13,"containerName":"sizes"},{"line":624,"name":"$enz","kind":13,"containerName":"sizes"}],"detail":"($self,$enz,$kb,$sort)","definition":"sub"},{"containerName":null,"kind":13,"name":"$kb","line":625},{"name":"@frag","containerName":null,"kind":13,"line":625},{"line":625,"name":"$site","kind":13,"containerName":null},{"line":625,"kind":13,"containerName":null,"name":"$lastsite"},{"line":626,"name":"@frag","kind":13,"containerName":null},{"line":626,"name":"$site","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$lastsite","line":626},{"line":627,"kind":13,"containerName":null,"name":"$lastsite"},{"kind":13,"containerName":null,"name":"$site","line":627},{"line":629,"name":"$kb","kind":13,"containerName":null},{"line":629,"kind":13,"containerName":null,"name":"@frag"},{"line":629,"name":"%self","containerName":null,"kind":13},{"name":"length","kind":12,"containerName":"main::","line":629},{"containerName":null,"kind":13,"name":"$lastsite","line":629},{"line":630,"kind":13,"containerName":null,"name":"@frag"},{"containerName":null,"kind":13,"name":"%self","line":630},{"containerName":"main::","kind":12,"name":"length","line":630},{"line":630,"containerName":null,"kind":13,"name":"$lastsite"},{"kind":13,"containerName":null,"name":"%self","line":631},{"line":631,"containerName":"main::","kind":12,"name":"is_circular"},{"line":632,"name":"$first","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"containerName":null,"kind":13,"name":"@frag","line":632},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$last","line":633},{"name":"@frag","kind":13,"containerName":null,"line":633},{"name":"@frag","containerName":null,"kind":13,"line":634},{"line":634,"name":"$first","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$last","line":634},{"line":636,"kind":13,"containerName":null,"name":"$sort"},{"line":636,"name":"@frag","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$b","line":636},{"kind":13,"containerName":null,"name":"$a","line":636},{"line":636,"containerName":null,"kind":13,"name":"@frag"},{"name":"@frag","kind":13,"containerName":null,"line":638},{"signature":{"label":"cuts_by_enzyme($self,$enz)","documentation":"","parameters":[{"label":"$self"},{"label":"$enz"}]},"line":656,"range":{"end":{"line":663,"character":9999},"start":{"line":656,"character":0}},"kind":12,"definition":"sub","detail":"($self,$enz)","children":[{"line":657,"localvar":"my","kind":13,"containerName":"cuts_by_enzyme","name":"$self","definition":"my"},{"name":"$enz","kind":13,"containerName":"cuts_by_enzyme","line":657},{"kind":13,"containerName":"cuts_by_enzyme","name":"$self","line":659},{"line":659,"name":"throw","containerName":"cuts_by_enzyme","kind":12},{"line":660,"containerName":"cuts_by_enzyme","kind":13,"name":"$enz"},{"name":"$self","kind":13,"containerName":"cuts_by_enzyme","line":661},{"line":661,"containerName":"cuts_by_enzyme","kind":12,"name":"cut"},{"name":"$self","kind":13,"containerName":"cuts_by_enzyme","line":661},{"kind":13,"containerName":"cuts_by_enzyme","name":"$self","line":662},{"line":662,"name":"$enz","kind":13,"containerName":"cuts_by_enzyme"}],"name":"cuts_by_enzyme","containerName":"main::"},{"definition":"sub","detail":"($self,$a,$z)","children":[{"definition":"my","localvar":"my","containerName":"cutters","kind":13,"name":"$self","line":693},{"kind":13,"containerName":"cutters","name":"$a","line":693},{"kind":13,"containerName":"cutters","name":"$z","line":693},{"kind":13,"containerName":"cutters","name":"$self","line":695},{"name":"cut","kind":12,"containerName":"cutters","line":695},{"containerName":"cutters","kind":13,"name":"$self","line":695},{"line":697,"name":"$start","localvar":"my","kind":13,"containerName":"cutters","definition":"my"},{"containerName":"cutters","kind":13,"name":"$end","line":697},{"line":698,"containerName":"cutters","kind":13,"name":"$a"},{"line":699,"containerName":"cutters","kind":13,"name":"$self"},{"line":699,"name":"throw","containerName":"cutters","kind":12},{"line":700,"containerName":"cutters","kind":13,"name":"$a"},{"line":701,"name":"$start","containerName":"cutters","kind":13},{"line":701,"name":"$a","containerName":"cutters","kind":13},{"name":"$start","kind":13,"containerName":"cutters","line":703},{"line":705,"kind":13,"containerName":"cutters","name":"$start"},{"line":705,"name":"$self","containerName":"cutters","kind":13},{"line":705,"containerName":"cutters","kind":13,"name":"$start"},{"line":705,"kind":13,"containerName":"cutters","name":"$self"},{"kind":13,"containerName":"cutters","name":"$z","line":707},{"line":708,"name":"$self","containerName":"cutters","kind":13},{"line":708,"kind":12,"containerName":"cutters","name":"throw"},{"line":709,"name":"$z","kind":13,"containerName":"cutters"},{"containerName":"cutters","kind":13,"name":"$z","line":709},{"line":709,"containerName":"cutters","kind":13,"name":"$a"},{"line":710,"containerName":"cutters","kind":13,"name":"$end"},{"kind":13,"containerName":"cutters","name":"$z","line":710},{"name":"$a","kind":13,"containerName":"cutters","line":712},{"name":"$end","kind":13,"containerName":"cutters","line":713},{"line":713,"containerName":"cutters","kind":13,"name":"$start"},{"line":715,"name":"$end","kind":13,"containerName":"cutters"},{"name":"$self","kind":13,"containerName":"cutters","line":715},{"line":717,"kind":13,"containerName":"cutters","name":"$end"},{"line":717,"containerName":"cutters","kind":13,"name":"$self"},{"name":"$end","containerName":"cutters","kind":13,"line":717},{"line":717,"name":"$self","kind":13,"containerName":"cutters"},{"definition":"my","localvar":"my","containerName":"cutters","kind":13,"name":"$set","line":718},{"name":"new","kind":12,"containerName":"cutters","line":718},{"containerName":"cutters","kind":13,"name":"$set","line":721},{"line":721,"containerName":"cutters","kind":13,"name":"$self"},{"line":723,"name":"$i","localvar":"my","kind":13,"containerName":"cutters","definition":"my"},{"line":723,"name":"$start","kind":13,"containerName":"cutters"},{"line":723,"name":"$i","kind":13,"containerName":"cutters"},{"line":723,"kind":13,"containerName":"cutters","name":"$end"},{"name":"$i","containerName":"cutters","kind":13,"line":723},{"line":724,"name":"$set","containerName":"cutters","kind":13},{"containerName":"cutters","kind":12,"name":"enzymes","line":724},{"containerName":"cutters","kind":13,"name":"$self","line":724},{"name":"$i","kind":13,"containerName":"cutters","line":724},{"containerName":"cutters","kind":13,"name":"$self","line":725},{"containerName":"cutters","kind":13,"name":"$i","line":725}],"name":"cutters","containerName":"main::","signature":{"label":"cutters($self,$a,$z)","parameters":[{"label":"$self"},{"label":"$a"},{"label":"$z"}],"documentation":""},"line":692,"kind":12,"range":{"end":{"character":9999,"line":726},"start":{"line":692,"character":0}}},{"name":"Bio","containerName":"Restriction::EnzymeCollection","kind":12,"line":718},{"line":724,"kind":12,"name":"_number_of_cuts_by_cuts"},{"name":"_number_of_cuts_by_cuts","kind":12,"line":725},{"line":728,"containerName":null,"kind":13,"name":"$set"},{"kind":12,"range":{"end":{"character":9999,"line":746},"start":{"character":0,"line":744}},"line":744,"definition":"sub","name":"unique_cutters","containerName":"main::","children":[{"name":"cutters","kind":12,"containerName":"unique_cutters","line":745}]},{"children":[{"line":760,"name":"cutters","containerName":"zero_cutters","kind":12}],"containerName":"main::","name":"zero_cutters","definition":"sub","line":759,"range":{"start":{"character":0,"line":759},"end":{"character":9999,"line":761}},"kind":12},{"children":[],"containerName":"main::","name":"max_cuts","definition":"sub","line":774,"range":{"start":{"character":0,"line":774},"end":{"line":774,"character":9999}},"kind":12},{"line":774,"kind":12,"name":"maximum_cuts"},{"definition":"sub","name":"_cuts","containerName":"main::","children":[{"definition":"my","line":792,"localvar":"my","containerName":"_cuts","kind":13,"name":"$self"},{"definition":"my","line":794,"name":"$target_seq","localvar":"my","containerName":"_cuts","kind":13},{"line":794,"kind":13,"containerName":"_cuts","name":"$self"},{"line":794,"name":"seq","kind":12,"containerName":"_cuts"},{"definition":"my","line":798,"localvar":"my","containerName":"_cuts","kind":13,"name":"$enz"},{"kind":13,"containerName":"_cuts","name":"$self","line":798},{"kind":12,"containerName":"_cuts","name":"each_enzyme","line":798},{"definition":"my","containerName":"_cuts","localvar":"my","kind":13,"name":"@all_cuts","line":799},{"definition":"my","line":800,"localvar":"my","kind":13,"containerName":"_cuts","name":"@others"},{"line":800,"containerName":"_cuts","kind":13,"name":"$enz"},{"name":"others","kind":12,"containerName":"_cuts","line":800},{"line":800,"name":"$enz","containerName":"_cuts","kind":13},{"name":"can","kind":12,"containerName":"_cuts","line":800},{"line":801,"name":"$enzyme","localvar":"my","kind":13,"containerName":"_cuts","definition":"my"},{"line":801,"name":"$enz","containerName":"_cuts","kind":13},{"line":801,"name":"@others","containerName":"_cuts","kind":13},{"name":"$cut_positions","localvar":"my","kind":13,"containerName":"_cuts","line":806,"definition":"my"},{"line":806,"kind":13,"containerName":"_cuts","name":"$self"},{"line":806,"containerName":"_cuts","kind":12,"name":"_make_cuts"},{"line":806,"containerName":"_cuts","kind":13,"name":"$target_seq"},{"line":806,"containerName":"_cuts","kind":13,"name":"$enzyme"},{"line":808,"name":"@all_cuts","containerName":"_cuts","kind":13},{"kind":13,"containerName":"_cuts","name":"$cut_positions","line":808},{"line":814,"containerName":"_cuts","kind":13,"name":"$self"},{"line":814,"kind":12,"containerName":"_cuts","name":"is_circular"},{"name":"$cut_positions","kind":13,"containerName":"_cuts","line":815},{"line":815,"name":"$self","kind":13,"containerName":"_cuts"},{"line":815,"name":"_circular","containerName":"_cuts","kind":12},{"line":815,"name":"$target_seq","kind":13,"containerName":"_cuts"},{"line":815,"name":"$enzyme","containerName":"_cuts","kind":13},{"line":816,"containerName":"_cuts","kind":13,"name":"@all_cuts"},{"name":"$cut_positions","kind":13,"containerName":"_cuts","line":816},{"line":820,"kind":13,"containerName":"_cuts","name":"$enzyme"},{"line":820,"kind":12,"containerName":"_cuts","name":"is_symmetric"},{"kind":13,"containerName":"_cuts","name":"$cut_positions","line":824},{"name":"$self","kind":13,"containerName":"_cuts","line":824},{"line":824,"containerName":"_cuts","kind":12,"name":"_make_cuts"},{"name":"$target_seq","containerName":"_cuts","kind":13,"line":824},{"name":"$enzyme","containerName":"_cuts","kind":13,"line":824},{"name":"@all_cuts","kind":13,"containerName":"_cuts","line":825},{"line":825,"name":"$cut_positions","kind":13,"containerName":"_cuts"},{"name":"$self","kind":13,"containerName":"_cuts","line":827},{"kind":12,"containerName":"_cuts","name":"is_circular","line":827},{"line":828,"kind":13,"containerName":"_cuts","name":"$cut_positions"},{"name":"$self","kind":13,"containerName":"_cuts","line":828},{"name":"_circular","kind":12,"containerName":"_cuts","line":828},{"name":"$target_seq","kind":13,"containerName":"_cuts","line":828},{"name":"$enzyme","containerName":"_cuts","kind":13,"line":828},{"name":"@all_cuts","kind":13,"containerName":"_cuts","line":829},{"line":829,"name":"$cut_positions","containerName":"_cuts","kind":13},{"kind":13,"containerName":"_cuts","name":"$all_cuts","line":834},{"line":836,"containerName":"_cuts","kind":13,"name":"@all_cuts"},{"name":"$a","kind":13,"containerName":"_cuts","line":836},{"kind":13,"containerName":"_cuts","name":"$b","line":836},{"line":836,"containerName":"_cuts","kind":13,"name":"@all_cuts"},{"containerName":"_cuts","kind":13,"name":"$self","line":837},{"containerName":"_cuts","kind":13,"name":"$enz","line":837},{"name":"name","containerName":"_cuts","kind":12,"line":837},{"line":837,"name":"$all_cuts","containerName":"_cuts","kind":13},{"line":838,"name":"$i","localvar":"my","containerName":"_cuts","kind":13,"definition":"my"},{"name":"@all_cuts","kind":13,"containerName":"_cuts","line":838},{"kind":13,"containerName":"_cuts","name":"$self","line":839},{"line":839,"name":"$enz","containerName":"_cuts","kind":13},{"name":"name","containerName":"_cuts","kind":12,"line":839},{"name":"$i","kind":13,"containerName":"_cuts","line":839},{"line":840,"kind":13,"containerName":"_cuts","name":"$i"},{"line":840,"name":"$self","containerName":"_cuts","kind":13},{"line":840,"kind":13,"containerName":"_cuts","name":"$enz"},{"line":840,"name":"name","kind":12,"containerName":"_cuts"},{"line":840,"name":"$self","containerName":"_cuts","kind":13},{"name":"$enz","containerName":"_cuts","kind":13,"line":840},{"line":840,"name":"name","kind":12,"containerName":"_cuts"}],"range":{"start":{"character":0,"line":791},"end":{"line":840,"character":9999}},"kind":12,"line":791},{"line":844,"containerName":null,"kind":13,"name":"%self"},{"line":844,"containerName":null,"kind":13,"name":"$enz"},{"name":"name","containerName":"main::","kind":12,"line":844},{"line":855,"name":"$number_of_cuts","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":855,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"kind":13,"name":"$enz","line":855},{"line":855,"name":"name","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"%self","line":857},{"line":857,"name":"_number_of_cuts_by_enzyme","kind":12},{"line":857,"name":"$enz","containerName":null,"kind":13},{"line":857,"kind":12,"containerName":"main::","name":"name"},{"line":857,"containerName":null,"kind":13,"name":"$number_of_cuts"},{"kind":13,"containerName":null,"name":"%self","line":858},{"name":"_number_of_cuts_by_cuts","kind":12,"line":858},{"line":858,"name":"$number_of_cuts","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$enz","line":858},{"line":859,"name":"$number_of_cuts","containerName":null,"kind":13},{"line":859,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"name":"maximum_cuts","line":859},{"line":860,"containerName":null,"kind":13,"name":"%self"},{"line":860,"name":"maximum_cuts","kind":12},{"containerName":null,"kind":13,"name":"$number_of_cuts","line":860},{"children":[{"definition":"my","line":879,"kind":13,"localvar":"my","containerName":"_enzyme_sites","name":"$self"},{"kind":13,"containerName":"_enzyme_sites","name":"$enz","line":879},{"line":879,"name":"$comp","containerName":"_enzyme_sites","kind":13},{"name":"$site","containerName":"_enzyme_sites","localvar":"my","kind":13,"line":883,"definition":"my"},{"line":883,"containerName":"_enzyme_sites","kind":13,"name":"$comp"},{"line":883,"name":"$enz","containerName":"_enzyme_sites","kind":13},{"kind":12,"containerName":"_enzyme_sites","name":"complementary_cut","line":883},{"containerName":"_enzyme_sites","kind":13,"name":"$enz","line":883},{"name":"cut","kind":12,"containerName":"_enzyme_sites","line":883},{"containerName":"_enzyme_sites","kind":13,"name":"$site","line":885},{"name":"$site","kind":13,"containerName":"_enzyme_sites","line":885},{"definition":"my","line":889,"containerName":"_enzyme_sites","localvar":"my","kind":13,"name":"$beforeseq"},{"line":889,"kind":13,"containerName":"_enzyme_sites","name":"$afterseq"},{"line":902,"kind":13,"containerName":"_enzyme_sites","name":"$site"},{"kind":13,"containerName":"_enzyme_sites","name":"$afterseq","line":903},{"kind":13,"containerName":"_enzyme_sites","name":"$enz","line":903},{"name":"string","containerName":"_enzyme_sites","kind":12,"line":903},{"line":905,"name":"$site","containerName":"_enzyme_sites","kind":13},{"name":"$enz","kind":13,"containerName":"_enzyme_sites","line":905},{"kind":12,"containerName":"_enzyme_sites","name":"seq","line":905},{"containerName":"_enzyme_sites","kind":12,"name":"length","line":905},{"line":906,"kind":13,"containerName":"_enzyme_sites","name":"$beforeseq"},{"kind":13,"containerName":"_enzyme_sites","name":"$enz","line":906},{"line":906,"containerName":"_enzyme_sites","kind":12,"name":"string"},{"name":"$beforeseq","containerName":"_enzyme_sites","kind":13,"line":909},{"name":"$enz","containerName":"_enzyme_sites","kind":13,"line":909},{"name":"seq","containerName":"_enzyme_sites","kind":12,"line":909},{"line":909,"name":"subseq","kind":12,"containerName":"_enzyme_sites"},{"line":909,"name":"$site","containerName":"_enzyme_sites","kind":13},{"name":"$afterseq","kind":13,"containerName":"_enzyme_sites","line":910},{"containerName":"_enzyme_sites","kind":13,"name":"$enz","line":910},{"line":910,"containerName":"_enzyme_sites","kind":12,"name":"seq"},{"line":910,"name":"subseq","containerName":"_enzyme_sites","kind":12},{"line":910,"name":"$site","kind":13,"containerName":"_enzyme_sites"},{"line":910,"kind":13,"containerName":"_enzyme_sites","name":"$enz"},{"line":910,"name":"seq","containerName":"_enzyme_sites","kind":12},{"containerName":"_enzyme_sites","kind":12,"name":"length","line":910},{"line":913,"containerName":"_enzyme_sites","kind":13,"name":"$enz"},{"name":"is_ambiguous","containerName":"_enzyme_sites","kind":12,"line":913},{"name":"$beforeseq","containerName":"_enzyme_sites","kind":13,"line":914},{"kind":13,"containerName":"_enzyme_sites","name":"$self","line":914},{"kind":12,"containerName":"_enzyme_sites","name":"_expanded_string","line":914},{"name":"$beforeseq","kind":13,"containerName":"_enzyme_sites","line":914},{"name":"$afterseq","kind":13,"containerName":"_enzyme_sites","line":915},{"containerName":"_enzyme_sites","kind":13,"name":"$self","line":915},{"kind":12,"containerName":"_enzyme_sites","name":"_expanded_string","line":915},{"line":915,"containerName":"_enzyme_sites","kind":13,"name":"$afterseq"},{"name":"$beforeseq","containerName":"_enzyme_sites","kind":13,"line":918},{"line":918,"name":"$afterseq","kind":13,"containerName":"_enzyme_sites"}],"name":"_enzyme_sites","containerName":"main::","definition":"sub","detail":"($self,$enz,$comp)","line":878,"kind":12,"range":{"end":{"character":9999,"line":919},"start":{"line":878,"character":0}},"signature":{"label":"_enzyme_sites($self,$enz,$comp)","parameters":[{"label":"$self"},{"label":"$enz"},{"label":"$comp"}],"documentation":""}},{"signature":{"label":"_non_pal_enz($self,$target_seq,$enz)","parameters":[{"label":"$self"},{"label":"$target_seq"},{"label":"$enz"}],"documentation":""},"kind":12,"range":{"end":{"line":982,"character":9999},"start":{"line":934,"character":0}},"line":934,"detail":"($self,$target_seq,$enz)","definition":"sub","containerName":"main::","name":"_non_pal_enz","children":[{"localvar":"my","kind":13,"containerName":"_non_pal_enz","name":"$self","line":935,"definition":"my"},{"name":"$target_seq","containerName":"_non_pal_enz","kind":13,"line":935},{"name":"$enz","containerName":"_non_pal_enz","kind":13,"line":935},{"definition":"my","line":939,"name":"$site","localvar":"my","kind":13,"containerName":"_non_pal_enz"},{"name":"$enz","containerName":"_non_pal_enz","kind":13,"line":939},{"containerName":"_non_pal_enz","kind":12,"name":"complementary_cut","line":939},{"name":"$beforeseq","localvar":"my","containerName":"_non_pal_enz","kind":13,"line":951,"definition":"my"},{"name":"$afterseq","containerName":"_non_pal_enz","kind":13,"line":951},{"line":954,"localvar":"my","kind":13,"containerName":"_non_pal_enz","name":"$new_left_cut","definition":"my"},{"containerName":"_non_pal_enz","kind":13,"name":"$enz","line":954},{"line":954,"kind":12,"containerName":"_non_pal_enz","name":"seq"},{"line":954,"name":"length","containerName":"_non_pal_enz","kind":12},{"line":954,"kind":13,"containerName":"_non_pal_enz","name":"$site"},{"name":"$new_left_cut","containerName":"_non_pal_enz","kind":13,"line":957},{"name":"$afterseq","kind":13,"containerName":"_non_pal_enz","line":957},{"containerName":"_non_pal_enz","kind":13,"name":"$enz","line":957},{"line":957,"name":"seq","kind":12,"containerName":"_non_pal_enz"},{"name":"revcom","kind":12,"containerName":"_non_pal_enz","line":957},{"kind":12,"containerName":"_non_pal_enz","name":"seq","line":957},{"line":958,"kind":13,"containerName":"_non_pal_enz","name":"$new_left_cut"},{"line":958,"name":"$enz","kind":13,"containerName":"_non_pal_enz"},{"line":958,"containerName":"_non_pal_enz","kind":12,"name":"seq"},{"containerName":"_non_pal_enz","kind":12,"name":"length","line":958},{"line":958,"kind":13,"containerName":"_non_pal_enz","name":"$beforeseq"},{"line":958,"kind":13,"containerName":"_non_pal_enz","name":"$enz"},{"line":958,"containerName":"_non_pal_enz","kind":12,"name":"seq"},{"name":"revcom","kind":12,"containerName":"_non_pal_enz","line":958},{"kind":12,"containerName":"_non_pal_enz","name":"seq","line":958},{"containerName":"_non_pal_enz","kind":13,"name":"$beforeseq","line":961},{"line":961,"kind":13,"containerName":"_non_pal_enz","name":"$enz"},{"line":961,"kind":12,"containerName":"_non_pal_enz","name":"seq"},{"line":961,"name":"revcom","kind":12,"containerName":"_non_pal_enz"},{"line":961,"name":"subseq","kind":12,"containerName":"_non_pal_enz"},{"name":"$enz","containerName":"_non_pal_enz","kind":13,"line":961},{"line":961,"name":"seq","containerName":"_non_pal_enz","kind":12},{"name":"length","containerName":"_non_pal_enz","kind":12,"line":961},{"containerName":"_non_pal_enz","kind":13,"name":"$site","line":961},{"name":"$afterseq","kind":13,"containerName":"_non_pal_enz","line":962},{"containerName":"_non_pal_enz","kind":13,"name":"$enz","line":962},{"name":"seq","containerName":"_non_pal_enz","kind":12,"line":962},{"line":962,"containerName":"_non_pal_enz","kind":12,"name":"revcom"},{"line":962,"kind":12,"containerName":"_non_pal_enz","name":"subseq"},{"line":962,"containerName":"_non_pal_enz","kind":13,"name":"$enz"},{"line":962,"name":"seq","kind":12,"containerName":"_non_pal_enz"},{"line":962,"name":"length","kind":12,"containerName":"_non_pal_enz"},{"line":962,"containerName":"_non_pal_enz","kind":13,"name":"$site"},{"name":"$enz","kind":13,"containerName":"_non_pal_enz","line":962},{"name":"seq","kind":12,"containerName":"_non_pal_enz","line":962},{"kind":12,"containerName":"_non_pal_enz","name":"length","line":962},{"definition":"my","line":969,"name":"$results","kind":13,"localvar":"my","containerName":"_non_pal_enz"},{"line":970,"containerName":"_non_pal_enz","kind":13,"name":"$enz"},{"containerName":"_non_pal_enz","kind":12,"name":"is_ambiguous","line":970},{"kind":13,"containerName":"_non_pal_enz","name":"$results","line":971},{"line":971,"containerName":"_non_pal_enz","kind":13,"name":"$self"},{"line":971,"name":"_ambig_cuts","containerName":"_non_pal_enz","kind":12},{"containerName":"_non_pal_enz","kind":13,"name":"$beforeseq","line":971},{"line":971,"name":"$afterseq","kind":13,"containerName":"_non_pal_enz"},{"line":971,"name":"$target_seq","kind":13,"containerName":"_non_pal_enz"},{"line":971,"kind":13,"containerName":"_non_pal_enz","name":"$enz"},{"line":973,"name":"$results","kind":13,"containerName":"_non_pal_enz"},{"line":973,"name":"$self","containerName":"_non_pal_enz","kind":13},{"name":"_nonambig_cuts","containerName":"_non_pal_enz","kind":12,"line":973},{"name":"$beforeseq","containerName":"_non_pal_enz","kind":13,"line":973},{"kind":13,"containerName":"_non_pal_enz","name":"$afterseq","line":973},{"line":973,"name":"$target_seq","containerName":"_non_pal_enz","kind":13},{"line":973,"name":"$enz","containerName":"_non_pal_enz","kind":13},{"line":977,"name":"$more_results","localvar":"my","containerName":"_non_pal_enz","kind":13,"definition":"my"},{"line":978,"containerName":"_non_pal_enz","kind":13,"name":"$more_results"},{"name":"$self","containerName":"_non_pal_enz","kind":13,"line":978},{"name":"_circular","kind":12,"containerName":"_non_pal_enz","line":978},{"name":"$beforeseq","containerName":"_non_pal_enz","kind":13,"line":978},{"line":978,"containerName":"_non_pal_enz","kind":13,"name":"$afterseq"},{"line":978,"kind":13,"containerName":"_non_pal_enz","name":"$enz"},{"containerName":"_non_pal_enz","kind":13,"name":"$self","line":979},{"name":"is_circular","kind":12,"containerName":"_non_pal_enz","line":979},{"name":"$more_results","containerName":"_non_pal_enz","kind":13,"line":981},{"kind":13,"containerName":"_non_pal_enz","name":"$results","line":981}]},{"line":1000,"kind":12,"range":{"start":{"line":1000,"character":0},"end":{"character":9999,"line":1072}},"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$beforeseq"},{"label":"$afterseq"},{"label":"$target_seq"},{"label":"$enz"}],"label":"_ambig_cuts_depr($self,$beforeseq,$afterseq,$target_seq,$enz)"},"children":[{"line":1001,"kind":13,"localvar":"my","containerName":"_ambig_cuts_depr","name":"$self","definition":"my"},{"line":1001,"name":"$beforeseq","kind":13,"containerName":"_ambig_cuts_depr"},{"kind":13,"containerName":"_ambig_cuts_depr","name":"$afterseq","line":1001},{"name":"$target_seq","containerName":"_ambig_cuts_depr","kind":13,"line":1001},{"line":1001,"containerName":"_ambig_cuts_depr","kind":13,"name":"$enz"},{"name":"$target_seq","kind":13,"containerName":"_ambig_cuts_depr","line":1005},{"name":"$target_seq","containerName":"_ambig_cuts_depr","kind":13,"line":1005},{"definition":"my","line":1006,"kind":13,"localvar":"my","containerName":"_ambig_cuts_depr","name":"@cuts"},{"name":"$target_seq","kind":13,"containerName":"_ambig_cuts_depr","line":1006},{"line":1018,"localvar":"my","kind":13,"containerName":"_ambig_cuts_depr","name":"$i","definition":"my"},{"definition":"my","line":1019,"localvar":"my","containerName":"_ambig_cuts_depr","kind":13,"name":"@re_frags"},{"line":1021,"name":"$i","containerName":"_ambig_cuts_depr","kind":13},{"line":1022,"localvar":"my","kind":13,"containerName":"_ambig_cuts_depr","name":"$joinedseq","definition":"my"},{"name":"$i","containerName":"_ambig_cuts_depr","kind":13,"line":1024},{"name":"$joinedseq","containerName":"_ambig_cuts_depr","kind":13,"line":1025},{"line":1025,"name":"$cuts","kind":13,"containerName":"_ambig_cuts_depr"},{"name":"$i","containerName":"_ambig_cuts_depr","kind":13,"line":1025},{"line":1025,"kind":13,"containerName":"_ambig_cuts_depr","name":"$cuts"},{"line":1025,"name":"$i","kind":13,"containerName":"_ambig_cuts_depr"},{"line":1027,"name":"$joinedseq","containerName":"_ambig_cuts_depr","kind":13},{"line":1027,"kind":13,"containerName":"_ambig_cuts_depr","name":"$cuts"},{"kind":13,"containerName":"_ambig_cuts_depr","name":"$i","line":1027},{"kind":13,"containerName":"_ambig_cuts_depr","name":"$cuts","line":1027},{"line":1027,"kind":13,"containerName":"_ambig_cuts_depr","name":"$i"},{"line":1027,"kind":13,"containerName":"_ambig_cuts_depr","name":"$cuts"},{"containerName":"_ambig_cuts_depr","kind":13,"name":"$i","line":1027},{"line":1033,"name":"$joinedseq","containerName":"_ambig_cuts_depr","kind":13},{"kind":13,"containerName":"_ambig_cuts_depr","name":"$joinedseq","line":1034},{"line":1035,"containerName":"_ambig_cuts_depr","kind":13,"name":"@re_frags"},{"kind":13,"containerName":"_ambig_cuts_depr","name":"@re_frags","line":1037},{"kind":13,"containerName":"_ambig_cuts_depr","name":"$joinedseq","line":1037},{"line":1038,"name":"$i","containerName":"_ambig_cuts_depr","kind":13},{"definition":"my","line":1060,"localvar":"my","containerName":"_ambig_cuts_depr","kind":13,"name":"@cut_positions"},{"line":1060,"containerName":"_ambig_cuts_depr","kind":13,"name":"@re_frags"},{"line":1065,"localvar":"my","kind":13,"containerName":"_ambig_cuts_depr","name":"$i","definition":"my"},{"line":1065,"name":"$i","containerName":"_ambig_cuts_depr","kind":13},{"name":"$i","containerName":"_ambig_cuts_depr","kind":13,"line":1065},{"line":1066,"containerName":"_ambig_cuts_depr","kind":13,"name":"$cut_positions"},{"line":1066,"name":"$i","kind":13,"containerName":"_ambig_cuts_depr"},{"containerName":"_ambig_cuts_depr","kind":13,"name":"$cut_positions","line":1066},{"kind":13,"containerName":"_ambig_cuts_depr","name":"$i","line":1066},{"line":1071,"kind":13,"containerName":"_ambig_cuts_depr","name":"@cut_positions"}],"name":"_ambig_cuts_depr","containerName":"main::","definition":"sub","detail":"($self,$beforeseq,$afterseq,$target_seq,$enz)"},{"line":1020,"kind":12,"name":"cuts"},{"kind":12,"name":"cuts","line":1021},{"name":"cut_positions","kind":12,"line":1065},{"line":1076,"kind":12,"range":{"start":{"line":1076,"character":0},"end":{"line":1086,"character":9999}},"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$before"},{"label":"$after"},{"label":"$target"},{"label":"$enz"},{"label":"$comp"}],"label":"_ambig_cuts($self,$before,$after,$target,$enz,$comp)"},"children":[{"definition":"my","line":1077,"name":"$self","localvar":"my","kind":13,"containerName":"_ambig_cuts"},{"name":"$before","containerName":"_ambig_cuts","kind":13,"line":1077},{"line":1077,"name":"$after","kind":13,"containerName":"_ambig_cuts"},{"name":"$target","containerName":"_ambig_cuts","kind":13,"line":1077},{"containerName":"_ambig_cuts","kind":13,"name":"$enz","line":1077},{"line":1077,"kind":13,"containerName":"_ambig_cuts","name":"$comp"},{"kind":13,"localvar":"my","containerName":"_ambig_cuts","name":"$cut_site","line":1078,"definition":"my"},{"containerName":"_ambig_cuts","kind":13,"name":"$comp","line":1078},{"line":1078,"name":"$enz","kind":13,"containerName":"_ambig_cuts"},{"line":1078,"name":"complementary_cut","containerName":"_ambig_cuts","kind":12},{"containerName":"_ambig_cuts","kind":13,"name":"$enz","line":1078},{"line":1078,"containerName":"_ambig_cuts","kind":12,"name":"cut"},{"kind":13,"containerName":"_ambig_cuts","name":"$target","line":1079},{"definition":"my","line":1080,"localvar":"my","kind":13,"containerName":"_ambig_cuts","name":"@cuts"},{"line":1081,"kind":13,"localvar":"my","containerName":"_ambig_cuts","name":"$recog","definition":"my"},{"kind":13,"containerName":"_ambig_cuts","name":"$enz","line":1081},{"line":1081,"name":"recog","kind":12,"containerName":"_ambig_cuts"},{"line":1082,"name":"$site_re","localvar":"my","containerName":"_ambig_cuts","kind":13,"definition":"my"},{"name":"@cuts","containerName":"_ambig_cuts","kind":13,"line":1083},{"name":"$enz","containerName":"_ambig_cuts","kind":13,"line":1084},{"kind":12,"containerName":"_ambig_cuts","name":"recog","line":1084},{"name":"$cut_site","containerName":"_ambig_cuts","kind":13,"line":1084},{"line":1084,"name":"@cuts","containerName":"_ambig_cuts","kind":13},{"line":1085,"containerName":"_ambig_cuts","kind":13,"name":"@cuts"}],"containerName":"main::","name":"_ambig_cuts","definition":"sub","detail":"($self,$before,$after,$target,$enz,$comp)"},{"line":1104,"range":{"end":{"character":9999,"line":1126},"start":{"line":1104,"character":0}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$beforeseq"},{"label":"$afterseq"},{"label":"$target_seq"},{"label":"$enz"},{"label":"$comp"}],"label":"_nonambig_cuts($self,$beforeseq,$afterseq,$target_seq,$enz,$comp)"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_nonambig_cuts","line":1105,"definition":"my"},{"name":"$beforeseq","kind":13,"containerName":"_nonambig_cuts","line":1105},{"line":1105,"name":"$afterseq","containerName":"_nonambig_cuts","kind":13},{"line":1105,"containerName":"_nonambig_cuts","kind":13,"name":"$target_seq"},{"line":1105,"kind":13,"containerName":"_nonambig_cuts","name":"$enz"},{"line":1105,"name":"$comp","containerName":"_nonambig_cuts","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"_nonambig_cuts","name":"$cut_site","line":1106},{"name":"$comp","kind":13,"containerName":"_nonambig_cuts","line":1106},{"line":1106,"kind":13,"containerName":"_nonambig_cuts","name":"$enz"},{"line":1106,"name":"complementary_cut","containerName":"_nonambig_cuts","kind":12},{"name":"$enz","containerName":"_nonambig_cuts","kind":13,"line":1106},{"kind":12,"containerName":"_nonambig_cuts","name":"cut","line":1106},{"containerName":"_nonambig_cuts","kind":13,"name":"$beforeseq","line":1107},{"name":"$beforeseq","kind":13,"containerName":"_nonambig_cuts","line":1107},{"line":1108,"name":"$afterseq","kind":13,"containerName":"_nonambig_cuts"},{"line":1108,"kind":13,"containerName":"_nonambig_cuts","name":"$afterseq"},{"line":1109,"name":"$target_seq","kind":13,"containerName":"_nonambig_cuts"},{"line":1109,"kind":13,"containerName":"_nonambig_cuts","name":"$target_seq"},{"kind":13,"localvar":"my","containerName":"_nonambig_cuts","name":"$index_posn","line":1111,"definition":"my"},{"kind":13,"containerName":"_nonambig_cuts","name":"$target_seq","line":1111},{"name":"$enz","containerName":"_nonambig_cuts","kind":13,"line":1111},{"name":"recog","containerName":"_nonambig_cuts","kind":12,"line":1111},{"name":"$index_posn","containerName":"_nonambig_cuts","kind":13,"line":1112},{"definition":"my","line":1115,"name":"@cuts","localvar":"my","kind":13,"containerName":"_nonambig_cuts"},{"kind":13,"containerName":"_nonambig_cuts","name":"$index_posn","line":1116},{"name":"@cuts","containerName":"_nonambig_cuts","kind":13,"line":1120},{"line":1120,"name":"$index_posn","containerName":"_nonambig_cuts","kind":13},{"line":1120,"containerName":"_nonambig_cuts","kind":13,"name":"$cut_site"},{"line":1122,"name":"$index_posn","containerName":"_nonambig_cuts","kind":13},{"line":1122,"kind":13,"containerName":"_nonambig_cuts","name":"$target_seq"},{"containerName":"_nonambig_cuts","kind":13,"name":"$enz","line":1122},{"containerName":"_nonambig_cuts","kind":12,"name":"recog","line":1122},{"containerName":"_nonambig_cuts","kind":13,"name":"$index_posn","line":1122},{"containerName":"_nonambig_cuts","kind":13,"name":"@cuts","line":1125}],"name":"_nonambig_cuts","containerName":"main::","definition":"sub","detail":"($self,$beforeseq,$afterseq,$target_seq,$enz,$comp)"},{"detail":"($self,$target,$enz,$comp)","definition":"sub","name":"_make_cuts","containerName":"main::","children":[{"line":1144,"name":"$self","kind":13,"localvar":"my","containerName":"_make_cuts","definition":"my"},{"name":"$target","containerName":"_make_cuts","kind":13,"line":1144},{"line":1144,"kind":13,"containerName":"_make_cuts","name":"$enz"},{"line":1144,"kind":13,"containerName":"_make_cuts","name":"$comp"},{"line":1145,"kind":13,"containerName":"_make_cuts","name":"$target"},{"line":1147,"localvar":"my","containerName":"_make_cuts","kind":13,"name":"@cuts","definition":"my"},{"definition":"my","line":1149,"name":"@enzs","localvar":"my","containerName":"_make_cuts","kind":13},{"line":1149,"name":"$enz","kind":13,"containerName":"_make_cuts"},{"line":1149,"kind":13,"containerName":"_make_cuts","name":"$enz"},{"line":1149,"name":"can","containerName":"_make_cuts","kind":12},{"line":1149,"name":"$enz","containerName":"_make_cuts","kind":13},{"line":1149,"kind":12,"containerName":"_make_cuts","name":"others"},{"name":"$enz","kind":13,"containerName":"_make_cuts","line":1151},{"line":1151,"containerName":"_make_cuts","kind":13,"name":"@enzs"},{"line":1152,"kind":13,"localvar":"my","containerName":"_make_cuts","name":"$recog","definition":"my"},{"name":"$enz","containerName":"_make_cuts","kind":13,"line":1152},{"line":1152,"containerName":"_make_cuts","kind":12,"name":"recog"},{"definition":"my","name":"$cut_site","kind":13,"localvar":"my","containerName":"_make_cuts","line":1153},{"name":"$comp","containerName":"_make_cuts","kind":13,"line":1153},{"line":1153,"name":"$enz","containerName":"_make_cuts","kind":13},{"line":1153,"name":"complementary_cut","kind":12,"containerName":"_make_cuts"},{"line":1153,"name":"$enz","kind":13,"containerName":"_make_cuts"},{"name":"cut","kind":12,"containerName":"_make_cuts","line":1153},{"name":"@these_cuts","kind":13,"localvar":"my","containerName":"_make_cuts","line":1154,"definition":"my"},{"kind":13,"containerName":"_make_cuts","name":"$recog","line":1156},{"definition":"my","localvar":"my","containerName":"_make_cuts","kind":13,"name":"$site_re","line":1157},{"kind":13,"containerName":"_make_cuts","name":"@these_cuts","line":1158},{"line":1159,"name":"$enz","kind":13,"containerName":"_make_cuts"},{"line":1159,"kind":12,"containerName":"_make_cuts","name":"string"},{"line":1159,"kind":13,"containerName":"_make_cuts","name":"$cut_site"},{"line":1159,"name":"@these_cuts","containerName":"_make_cuts","kind":13},{"line":1160,"containerName":"_make_cuts","kind":13,"name":"$enz"},{"line":1160,"containerName":"_make_cuts","kind":12,"name":"is_palindromic"},{"definition":"my","kind":13,"localvar":"my","containerName":"_make_cuts","name":"@these_rev_cuts","line":1162},{"containerName":"_make_cuts","kind":13,"name":"$recog","line":1163},{"line":1163,"containerName":"_make_cuts","kind":13,"name":"$enz"},{"line":1163,"name":"revcom_recog","containerName":"_make_cuts","kind":12},{"kind":13,"containerName":"_make_cuts","name":"$cut_site","line":1164},{"line":1164,"containerName":"_make_cuts","kind":13,"name":"$enz"},{"line":1164,"kind":12,"containerName":"_make_cuts","name":"string"},{"line":1164,"containerName":"_make_cuts","kind":13,"name":"$comp"},{"name":"$enz","containerName":"_make_cuts","kind":13,"line":1164},{"name":"cut","kind":12,"containerName":"_make_cuts","line":1164},{"name":"$enz","kind":13,"containerName":"_make_cuts","line":1164},{"line":1164,"name":"complementary_cut","kind":12,"containerName":"_make_cuts"},{"containerName":"_make_cuts","kind":13,"name":"$site_re","line":1165},{"kind":13,"containerName":"_make_cuts","name":"@these_rev_cuts","line":1166},{"line":1167,"kind":13,"containerName":"_make_cuts","name":"$enz"},{"line":1167,"containerName":"_make_cuts","kind":12,"name":"string"},{"line":1167,"containerName":"_make_cuts","kind":13,"name":"$cut_site"},{"name":"@these_rev_cuts","containerName":"_make_cuts","kind":13,"line":1167},{"line":1168,"kind":13,"containerName":"_make_cuts","name":"@these_cuts"},{"line":1168,"kind":13,"containerName":"_make_cuts","name":"@these_rev_cuts"},{"definition":"my","localvar":"my","containerName":"_make_cuts","kind":13,"name":"$index_posn","line":1172},{"kind":13,"containerName":"_make_cuts","name":"$recog","line":1172},{"line":1173,"containerName":"_make_cuts","kind":13,"name":"$index_posn"},{"line":1174,"name":"@these_cuts","containerName":"_make_cuts","kind":13},{"name":"$index_posn","containerName":"_make_cuts","kind":13,"line":1174},{"kind":13,"containerName":"_make_cuts","name":"$cut_site","line":1174},{"containerName":"_make_cuts","kind":13,"name":"$index_posn","line":1175},{"line":1175,"name":"$recog","kind":13,"containerName":"_make_cuts"},{"line":1175,"containerName":"_make_cuts","kind":13,"name":"$index_posn"},{"line":1177,"name":"$enz","containerName":"_make_cuts","kind":13},{"containerName":"_make_cuts","kind":12,"name":"is_palindromic","line":1177},{"containerName":"_make_cuts","kind":13,"name":"$recog","line":1178},{"line":1178,"kind":13,"containerName":"_make_cuts","name":"$enz"},{"line":1178,"kind":12,"containerName":"_make_cuts","name":"revcom_recog"},{"containerName":"_make_cuts","kind":13,"name":"$cut_site","line":1179},{"containerName":"_make_cuts","kind":13,"name":"$enz","line":1179},{"name":"string","kind":12,"containerName":"_make_cuts","line":1179},{"name":"$comp","kind":13,"containerName":"_make_cuts","line":1179},{"name":"$enz","containerName":"_make_cuts","kind":13,"line":1179},{"kind":12,"containerName":"_make_cuts","name":"cut","line":1179},{"name":"$enz","kind":13,"containerName":"_make_cuts","line":1179},{"name":"complementary_cut","containerName":"_make_cuts","kind":12,"line":1179},{"line":1180,"name":"$index_posn","containerName":"_make_cuts","kind":13},{"line":1180,"name":"$recog","kind":13,"containerName":"_make_cuts"},{"kind":13,"containerName":"_make_cuts","name":"$index_posn","line":1181},{"containerName":"_make_cuts","kind":13,"name":"@these_cuts","line":1182},{"name":"$index_posn","containerName":"_make_cuts","kind":13,"line":1182},{"kind":13,"containerName":"_make_cuts","name":"$cut_site","line":1182},{"line":1183,"kind":13,"containerName":"_make_cuts","name":"$index_posn"},{"line":1183,"kind":13,"containerName":"_make_cuts","name":"$recog"},{"kind":13,"containerName":"_make_cuts","name":"$index_posn","line":1183},{"kind":13,"containerName":"_make_cuts","name":"@cuts","line":1187},{"kind":13,"containerName":"_make_cuts","name":"@these_cuts","line":1187},{"line":1189,"containerName":"_make_cuts","kind":13,"name":"@cuts"}],"signature":{"label":"_make_cuts($self,$target,$enz,$comp)","parameters":[{"label":"$self"},{"label":"$target"},{"label":"$enz"},{"label":"$comp"}],"documentation":""},"range":{"end":{"line":1190,"character":9999},"start":{"character":0,"line":1141}},"kind":12,"line":1141},{"name":"warnings","kind":12,"line":1142},{"line":1150,"kind":12,"name":"ENZ"},{"children":[{"line":1204,"kind":13,"localvar":"my","containerName":"_multiple_cuts","name":"$self","definition":"my"},{"name":"$ec","kind":13,"containerName":"_multiple_cuts","line":1204},{"kind":13,"containerName":"_multiple_cuts","name":"$self","line":1205},{"containerName":"_multiple_cuts","kind":12,"name":"cut","line":1205},{"name":"$self","containerName":"_multiple_cuts","kind":13,"line":1205},{"containerName":"_multiple_cuts","localvar":"my","kind":13,"name":"@cuts","line":1209,"definition":"my"},{"definition":"my","line":1210,"name":"$enz","containerName":"_multiple_cuts","localvar":"my","kind":13},{"line":1210,"name":"$ec","containerName":"_multiple_cuts","kind":13},{"name":"each_enzyme","containerName":"_multiple_cuts","kind":12,"line":1210},{"kind":13,"containerName":"_multiple_cuts","name":"@cuts","line":1211},{"kind":13,"containerName":"_multiple_cuts","name":"$self","line":1211},{"line":1211,"name":"$enz","kind":13,"containerName":"_multiple_cuts"},{"line":1211,"name":"name","containerName":"_multiple_cuts","kind":12},{"name":"$self","kind":13,"containerName":"_multiple_cuts","line":1212},{"line":1212,"name":"$enz","kind":13,"containerName":"_multiple_cuts"},{"line":1212,"containerName":"_multiple_cuts","kind":12,"name":"name"}],"name":"_multiple_cuts","containerName":"main::","definition":"sub","detail":"($self,$ec)","line":1203,"kind":12,"range":{"end":{"character":9999,"line":1213},"start":{"character":0,"line":1203}},"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$ec"}],"label":"_multiple_cuts($self,$ec)"}},{"name":"%self","containerName":null,"kind":13,"line":1214},{"line":1214,"name":"$a","containerName":null,"kind":13},{"line":1214,"name":"$b","kind":13,"containerName":null},{"name":"@cuts","kind":13,"containerName":null,"line":1214},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$number_of_cuts","line":1216},{"name":"$number_of_cuts","kind":13,"containerName":null,"line":1218},{"containerName":null,"kind":13,"name":"%self","line":1218},{"line":1219,"name":"%self","containerName":null,"kind":13},{"name":"_number_of_cuts_by_enzyme","kind":12,"line":1219},{"containerName":null,"kind":13,"name":"$number_of_cuts","line":1219},{"kind":13,"containerName":null,"name":"%self","line":1220},{"kind":12,"name":"_number_of_cuts_by_cuts","line":1220},{"containerName":null,"kind":13,"name":"$number_of_cuts","line":1220},{"line":1221,"name":"$number_of_cuts","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":1221},{"kind":12,"name":"maximum_cuts","line":1221},{"kind":13,"containerName":null,"name":"%self","line":1222},{"line":1222,"name":"maximum_cuts","kind":12},{"line":1222,"containerName":null,"kind":13,"name":"$number_of_cuts"},{"containerName":"main::","name":"_circular","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_circular","line":1238},{"name":"$target","containerName":"_circular","kind":13,"line":1238},{"containerName":"_circular","kind":13,"name":"$enz","line":1238},{"line":1238,"kind":13,"containerName":"_circular","name":"$comp"},{"line":1239,"containerName":"_circular","kind":13,"name":"$target"},{"kind":13,"containerName":"_circular","name":"$target","line":1239},{"line":1240,"kind":13,"localvar":"my","containerName":"_circular","name":"$patch_len","definition":"my"},{"line":1240,"name":"$target","kind":13,"containerName":"_circular"},{"containerName":"_circular","kind":13,"name":"$target","line":1240},{"definition":"my","line":1242,"name":"$first","kind":13,"localvar":"my","containerName":"_circular"},{"line":1242,"containerName":"_circular","kind":13,"name":"$last"},{"name":"$target","containerName":"_circular","kind":13,"line":1243},{"name":"$patch_len","containerName":"_circular","kind":13,"line":1243},{"line":1243,"name":"$target","containerName":"_circular","kind":13},{"line":1243,"name":"$patch_len","kind":13,"containerName":"_circular"},{"line":1244,"localvar":"my","containerName":"_circular","kind":13,"name":"$patch","definition":"my"},{"containerName":"_circular","kind":13,"name":"$last","line":1244},{"name":"$first","kind":13,"containerName":"_circular","line":1244},{"line":1248,"name":"$cut_positions","kind":13,"localvar":"my","containerName":"_circular","definition":"my"},{"line":1248,"containerName":"_circular","kind":13,"name":"$self"},{"line":1248,"name":"_make_cuts","kind":12,"containerName":"_circular"},{"line":1248,"name":"$patch","kind":13,"containerName":"_circular"},{"line":1248,"containerName":"_circular","kind":13,"name":"$enz"},{"containerName":"_circular","kind":13,"name":"$comp","line":1248},{"line":1251,"name":"$cut_positions","containerName":"_circular","kind":13},{"localvar":"my","kind":13,"containerName":"_circular","name":"@circ_cuts","line":1258,"definition":"my"},{"line":1259,"kind":13,"localvar":"my","containerName":"_circular","name":"$cut","definition":"my"},{"containerName":"_circular","kind":13,"name":"$cut_positions","line":1259},{"line":1260,"kind":13,"containerName":"_circular","name":"$cut"},{"line":1260,"name":"$last","containerName":"_circular","kind":13},{"name":"@circ_cuts","kind":13,"containerName":"_circular","line":1264},{"line":1267,"containerName":"_circular","kind":13,"name":"$cut"},{"line":1267,"name":"$last","kind":13,"containerName":"_circular"},{"line":1270,"name":"@circ_cuts","containerName":"_circular","kind":13},{"kind":13,"containerName":"_circular","name":"$self","line":1270},{"line":1270,"kind":12,"containerName":"_circular","name":"length"},{"kind":13,"containerName":"_circular","name":"$last","line":1270},{"containerName":"_circular","kind":13,"name":"$cut","line":1270},{"line":1276,"name":"@circ_cuts","kind":13,"containerName":"_circular"},{"containerName":"_circular","kind":13,"name":"$cut-length","line":1276},{"line":1276,"kind":13,"containerName":"_circular","name":"$last"},{"line":1279,"kind":13,"containerName":"_circular","name":"@circ_cuts"}],"detail":"($self,$target,$enz,$comp)","definition":"sub","range":{"end":{"line":1280,"character":9999},"start":{"line":1237,"character":0}},"kind":12,"line":1237,"signature":{"label":"_circular($self,$target,$enz,$comp)","parameters":[{"label":"$self"},{"label":"$target"},{"label":"$enz"},{"label":"$comp"}],"documentation":""}},{"kind":12,"range":{"end":{"line":1314,"character":9999},"start":{"line":1298,"character":0}},"line":1298,"signature":{"label":"_expanded_string($self,$str)","parameters":[{"label":"$self"},{"label":"$str"}],"documentation":""},"name":"_expanded_string","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_expanded_string","line":1299},{"kind":13,"containerName":"_expanded_string","name":"$str","line":1299},{"line":1301,"containerName":"_expanded_string","kind":13,"name":"$str"},{"kind":13,"containerName":"_expanded_string","name":"$str","line":1302},{"name":"$str","containerName":"_expanded_string","kind":13,"line":1303},{"line":1304,"kind":13,"containerName":"_expanded_string","name":"$str"},{"line":1305,"kind":13,"containerName":"_expanded_string","name":"$str"},{"line":1306,"kind":13,"containerName":"_expanded_string","name":"$str"},{"line":1307,"name":"$str","containerName":"_expanded_string","kind":13},{"name":"$str","containerName":"_expanded_string","kind":13,"line":1308},{"line":1309,"name":"$str","kind":13,"containerName":"_expanded_string"},{"line":1310,"name":"$str","containerName":"_expanded_string","kind":13},{"containerName":"_expanded_string","kind":13,"name":"$str","line":1311},{"line":1313,"name":"$str","containerName":"_expanded_string","kind":13}],"detail":"($self,$str)","definition":"sub"}]}