{"version":5,"vars":[{"line":86,"name":"Storable","containerName":"","kind":2},{"line":88,"name":"base","containerName":"","kind":2},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$USAGE","line":90},{"line":108,"range":{"end":{"character":9999,"line":126},"start":{"line":108,"character":0}},"kind":12,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# module Bio::PopGen::TagHaplotype.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n# Copyright Pedro M. Gomez-Fabre\n#\n# You may distribute this module under the same term as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::TagHaplotype.pm - Haplotype tag object.\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::TagHaplotype;\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n=head1 DESCRIPTION\n\nThis module take as input a haplotype and try toe get the minimal set\nof SNP that define the haplotype. This module can be use alone.  But\ndue to the tagging haplotype process is exponential one. My suggestion\nis that before to use this module you pass your data under Select.mp\nmodule also on this folder.  In any case if, you provide an haplotype\nthe module will try to find the answer to your question.\n\n=head1 CONSTRUCTORS\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n    were $hap is the reference to an array of array with the haplotype.\n\n    $hap= [[0, 0, 0],\n           [1, 0, 0],\n           [0, 1, 1]\n          ];\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::TagHaplotype;\nuse strict;\n\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = <<EOF\nUsage:\n    Bio::PopGen::TagHaplotype->new(-haplotype_block => \\$hapblockref)\n\nEOF\n;\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Returns : self hash\n Args    : input haplotype (array of array)\n Status  : public"},"children":[{"line":110,"name":"$class","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":110},{"name":"$self","containerName":"new","localvar":"my","kind":13,"line":112,"definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":112},{"line":112,"name":"@args","containerName":"new","kind":13},{"definition":"my","line":114,"localvar":"my","containerName":"new","kind":13,"name":"$haplotype_block"},{"line":114,"name":"$self","kind":13,"containerName":"new"},{"line":114,"containerName":"new","kind":12,"name":"_rearrange"},{"kind":13,"containerName":"new","name":"@args","line":114},{"name":"$haplotype_block","containerName":"new","kind":13,"line":116},{"line":117,"name":"$self","containerName":"new","kind":13},{"line":117,"containerName":"new","kind":12,"name":"haplotype_block"},{"line":117,"name":"$haplotype_block","kind":13,"containerName":"new"},{"line":120,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"throw","line":120},{"definition":"my","name":"$i","localvar":"my","containerName":"new","kind":13,"line":124},{"name":"$i","kind":13,"containerName":"new","line":124},{"kind":13,"containerName":"new","name":"$haplotype_block","line":124},{"name":"$i","kind":13,"containerName":"new","line":124},{"line":125,"containerName":"new","kind":13,"name":"$haplotype_block"},{"line":126,"name":"$haplotype_block","containerName":"new","kind":13},{"name":"$i","containerName":"new","kind":13,"line":126}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"name":"SUPER","containerName":"new","kind":12,"line":112},{"containerName":null,"kind":13,"name":"$self","line":128},{"line":128,"kind":12,"containerName":"main::","name":"throw"},{"line":133,"containerName":null,"localvar":"my","kind":13,"name":"$tag_list","definition":"my"},{"line":133,"name":"_scan_snp","kind":12},{"line":133,"name":"$self","kind":13,"containerName":null},{"name":"haplotype_block","kind":12,"containerName":"main::","line":133},{"line":135,"kind":13,"containerName":null,"name":"%tag_list"},{"name":"$self","kind":13,"containerName":null,"line":136},{"line":136,"name":"tag_list","containerName":"main::","kind":12},{"name":"%tag_list","kind":13,"containerName":null,"line":136},{"name":"$self","kind":13,"containerName":null,"line":139},{"line":139,"name":"tag_list","containerName":"main::","kind":12},{"line":142,"kind":13,"containerName":null,"name":"$self"},{"name":"tag_list","containerName":"main::","kind":12,"line":142},{"name":"$self","containerName":null,"kind":13,"line":143},{"containerName":"main::","kind":12,"name":"tag_length","line":143},{"line":143,"kind":13,"containerName":null,"name":"$self"},{"line":143,"name":"tag_list","containerName":"main::","kind":12},{"line":146,"name":"$self","kind":13,"containerName":null},{"line":146,"containerName":"main::","kind":12,"name":"tag_length"},{"line":149,"name":"$self","kind":13,"containerName":null},{"range":{"start":{"character":0,"line":163},"end":{"character":9999,"line":167}},"kind":12,"line":163,"definition":"sub","containerName":"main::","name":"haplotype_block","children":[{"definition":"my","line":164,"localvar":"my","containerName":"haplotype_block","kind":13,"name":"$self"},{"name":"$self","containerName":"haplotype_block","kind":13,"line":165},{"line":166,"kind":13,"containerName":"haplotype_block","name":"$self"}]},{"definition":"sub","children":[{"definition":"my","line":186,"name":"$self","localvar":"my","containerName":"input_block","kind":13},{"name":"$self","kind":13,"containerName":"input_block","line":188},{"containerName":"input_block","kind":12,"name":"warn","line":188},{"line":188,"name":"$self","containerName":"input_block","kind":13},{"kind":13,"containerName":"input_block","name":"$self","line":189},{"name":"haplotype_block","kind":12,"containerName":"input_block","line":189}],"name":"input_block","containerName":"main::","line":184,"range":{"start":{"line":184,"character":0},"end":{"line":190,"character":9999}},"kind":12},{"kind":12,"range":{"end":{"line":210,"character":9999},"start":{"character":0,"line":205}},"line":205,"definition":"sub","containerName":"main::","name":"tag_list","children":[{"line":207,"name":"$self","localvar":"my","containerName":"tag_list","kind":13,"definition":"my"},{"containerName":"tag_list","kind":13,"name":"$self","line":208},{"line":209,"kind":13,"containerName":"tag_list","name":"$self"}]},{"kind":12,"range":{"start":{"character":0,"line":224},"end":{"character":9999,"line":229}},"line":224,"name":"tag_length","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"tag_length","line":226},{"line":227,"containerName":"tag_length","kind":13,"name":"$self"},{"line":228,"name":"$self","containerName":"tag_length","kind":13}],"definition":"sub"},{"detail":"($hap)","definition":"sub","containerName":"main::","name":"_scan_snp","children":[{"definition":"my","line":246,"name":"$hap","kind":13,"localvar":"my","containerName":"_scan_snp"},{"definition":"my","containerName":"_scan_snp","localvar":"my","kind":13,"name":"$hap_length","line":248},{"line":248,"containerName":"_scan_snp","kind":13,"name":"$hap"}],"signature":{"label":"_scan_snp($hap)","parameters":[{"label":"$hap"}],"documentation":"1;\n# module Bio::PopGen::TagHaplotype.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n# Copyright Pedro M. Gomez-Fabre\n#\n# You may distribute this module under the same term as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::TagHaplotype.pm - Haplotype tag object.\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::TagHaplotype;\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n=head1 DESCRIPTION\n\nThis module take as input a haplotype and try toe get the minimal set\nof SNP that define the haplotype. This module can be use alone.  But\ndue to the tagging haplotype process is exponential one. My suggestion\nis that before to use this module you pass your data under Select.mp\nmodule also on this folder.  In any case if, you provide an haplotype\nthe module will try to find the answer to your question.\n\n=head1 CONSTRUCTORS\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n    were $hap is the reference to an array of array with the haplotype.\n\n    $hap= [[0, 0, 0],\n           [1, 0, 0],\n           [0, 1, 1]\n          ];\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::TagHaplotype;\nuse strict;\n\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = <<EOF\nUsage:\n    Bio::PopGen::TagHaplotype->new(-haplotype_block => \\$hapblockref)\n\nEOF\n;\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Returns : self hash\n Args    : input haplotype (array of array)\n Status  : public\n\n\n#------------------------\nsub new{\n#------------------------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($haplotype_block) = $self->_rearrange([qw(HAPLOTYPE_BLOCK)],@args);\n\n    if ($haplotype_block) {\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"haplotype has not been supplied\\n$USAGE\");\n    }\n\n    # check that the haplotype block is well formed.\n    for (my $i=0; $i<$#$haplotype_block+1; $i++){\n\tif ( $#{$haplotype_block->[0]} !=\n             $#{$haplotype_block->[$i]} ){\n\n            $self->throw(\"The haplotype matrix is not well formed (Not squared)\");\n        }\n    }\n\n    # make the calculation\n    my $tag_list =  _scan_snp( $self ->haplotype_block );\n\n    if ($tag_list){\n        $self ->tag_list($tag_list);\n    }\n    else { \n        $self ->tag_list(undef);\n    }\n\n    if ( defined $self->tag_list){\n        $self ->tag_length(scalar @{$self->tag_list});\n    }\n    else {\n        $self ->tag_length(0);  #\"NO TAGS FOUND!\"\n    }\n\n    return $self;\n}\n\n=head2 haplotype_block\n\n Title   : haplotype_block\n Usage   : my $haplotype_block = $TagHaplotype->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with haplotype pattern\n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n\n=head2 input_block \n\n Title   : input_block \n Usage   : $obj->input_block()\n Function: returns haplotype block. By now will produce the same ouput than\n           $self->haplotype_block. but for compatiblity, this method is kept. \n           This method is deprecated.\n Returns : reference to array of array with the haplotype input value \n Args    : none \n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n    my $self = shift;\n\n    $self->warn(ref($self). \"::input_block - deprecated method. Use haplotype_block() instead.\");\n    return $self->haplotype_block;\n}\n\n=head2 tag_list\n\n Title   : tag_list \n Usage   : $obj->tag_list()\n Function: returns the list of SNPs combination that identify the\n           haplotype. All combinations are displayed as arrays\n Returns : reference to array of array. \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_list{\n#------------------------\n    my ($self) = shift;\n    return $self->{'_tag_list'}= shift if @_;\n    return $self->{'_tag_list'};\n}\n\n=head2 tag_length \n\n Title   : tag_length \n Usage   : $obj->tag_length()\n Function: returns the length of the tag.\n Returns : scalar \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_length{\n#------------------------\n    my ($self) =shift;\n    return $self ->{'_tag_length'} = shift if @_;\n    return $self ->{'_tag_length'};\n}\n\n=head2 _scan_snp \n\n Title   : _scan_snp \n Usage   : internal\n Function: scan sets increasing the length until find a non degenerated\n           pattern. \n Returns : scalar\n Args    : none\n Status  : private"},"range":{"start":{"character":0,"line":244},"end":{"character":9999,"line":248}},"kind":12,"line":244},{"name":"$i","containerName":null,"localvar":"my","kind":13,"line":250,"definition":"my"},{"line":250,"kind":13,"containerName":null,"name":"%hap_length"},{"definition":"my","line":252,"containerName":null,"localvar":"my","kind":13,"name":"$list"},{"kind":12,"name":"_gen_comb","line":252},{"kind":13,"containerName":null,"name":"$hap_length","line":252},{"name":"$i","kind":13,"containerName":null,"line":252},{"kind":13,"localvar":"my","containerName":null,"name":"$snp_collection","line":254,"definition":"my"},{"name":"_scan_combinations","kind":12,"line":254},{"line":254,"name":"$hap","kind":13,"containerName":null},{"name":"$list","kind":13,"containerName":null,"line":254},{"line":259,"name":"%snp_collection","containerName":null,"kind":13},{"name":"$snp_collection","containerName":null,"kind":13,"line":260},{"signature":{"parameters":[{"label":"$hap_length"},{"label":"$n"}],"documentation":"1;\n# module Bio::PopGen::TagHaplotype.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n# Copyright Pedro M. Gomez-Fabre\n#\n# You may distribute this module under the same term as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::TagHaplotype.pm - Haplotype tag object.\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::TagHaplotype;\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n=head1 DESCRIPTION\n\nThis module take as input a haplotype and try toe get the minimal set\nof SNP that define the haplotype. This module can be use alone.  But\ndue to the tagging haplotype process is exponential one. My suggestion\nis that before to use this module you pass your data under Select.mp\nmodule also on this folder.  In any case if, you provide an haplotype\nthe module will try to find the answer to your question.\n\n=head1 CONSTRUCTORS\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n    were $hap is the reference to an array of array with the haplotype.\n\n    $hap= [[0, 0, 0],\n           [1, 0, 0],\n           [0, 1, 1]\n          ];\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::TagHaplotype;\nuse strict;\n\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = <<EOF\nUsage:\n    Bio::PopGen::TagHaplotype->new(-haplotype_block => \\$hapblockref)\n\nEOF\n;\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Returns : self hash\n Args    : input haplotype (array of array)\n Status  : public\n\n\n#------------------------\nsub new{\n#------------------------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($haplotype_block) = $self->_rearrange([qw(HAPLOTYPE_BLOCK)],@args);\n\n    if ($haplotype_block) {\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"haplotype has not been supplied\\n$USAGE\");\n    }\n\n    # check that the haplotype block is well formed.\n    for (my $i=0; $i<$#$haplotype_block+1; $i++){\n\tif ( $#{$haplotype_block->[0]} !=\n             $#{$haplotype_block->[$i]} ){\n\n            $self->throw(\"The haplotype matrix is not well formed (Not squared)\");\n        }\n    }\n\n    # make the calculation\n    my $tag_list =  _scan_snp( $self ->haplotype_block );\n\n    if ($tag_list){\n        $self ->tag_list($tag_list);\n    }\n    else { \n        $self ->tag_list(undef);\n    }\n\n    if ( defined $self->tag_list){\n        $self ->tag_length(scalar @{$self->tag_list});\n    }\n    else {\n        $self ->tag_length(0);  #\"NO TAGS FOUND!\"\n    }\n\n    return $self;\n}\n\n=head2 haplotype_block\n\n Title   : haplotype_block\n Usage   : my $haplotype_block = $TagHaplotype->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with haplotype pattern\n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n\n=head2 input_block \n\n Title   : input_block \n Usage   : $obj->input_block()\n Function: returns haplotype block. By now will produce the same ouput than\n           $self->haplotype_block. but for compatiblity, this method is kept. \n           This method is deprecated.\n Returns : reference to array of array with the haplotype input value \n Args    : none \n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n    my $self = shift;\n\n    $self->warn(ref($self). \"::input_block - deprecated method. Use haplotype_block() instead.\");\n    return $self->haplotype_block;\n}\n\n=head2 tag_list\n\n Title   : tag_list \n Usage   : $obj->tag_list()\n Function: returns the list of SNPs combination that identify the\n           haplotype. All combinations are displayed as arrays\n Returns : reference to array of array. \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_list{\n#------------------------\n    my ($self) = shift;\n    return $self->{'_tag_list'}= shift if @_;\n    return $self->{'_tag_list'};\n}\n\n=head2 tag_length \n\n Title   : tag_length \n Usage   : $obj->tag_length()\n Function: returns the length of the tag.\n Returns : scalar \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_length{\n#------------------------\n    my ($self) =shift;\n    return $self ->{'_tag_length'} = shift if @_;\n    return $self ->{'_tag_length'};\n}\n\n=head2 _scan_snp \n\n Title   : _scan_snp \n Usage   : internal\n Function: scan sets increasing the length until find a non degenerated\n           pattern. \n Returns : scalar\n Args    : none\n Status  : private\n\n\n#------------------------\nsub _scan_snp{\n#------------------------\n    my ($hap)=@_;\n\n    my $hap_length = scalar @{$hap->[0]};    ## store the haplotype length\n\n    for my $i(1..$hap_length){\n\n        my $list = _gen_comb($hap_length, $i);\n\n        my $snp_collection = _scan_combinations($hap, $list);\n\n        # if there is any element on the collection.\n        # We have reached our goal and \n        # we can stop the calculation.\n        if($#$snp_collection>-1){\n            return $snp_collection;\n        }\n    }\n}\n\n=head2 _gen_comb\n\n Title   : _gen_comb \n Usage   : internal\n Function: we supply the length of the haplotype and the length of the\n           word we need to find and the functions returns the possible\n           list of combinations.\n Returns : scalar\n Args    : none\n Status  : private","label":"_gen_comb($hap_length,$n)"},"range":{"start":{"line":279,"character":0},"end":{"line":306,"character":9999}},"kind":12,"line":279,"detail":"($hap_length,$n)","definition":"sub","name":"_gen_comb","containerName":"main::","children":[{"definition":"my","line":282,"name":"$hap_length","containerName":"_gen_comb","localvar":"my","kind":13},{"line":282,"name":"$n","kind":13,"containerName":"_gen_comb"},{"definition":"my","line":284,"localvar":"my","kind":13,"containerName":"_gen_comb","name":"@array"},{"line":287,"name":"$hap_length","kind":13,"containerName":"_gen_comb"},{"line":287,"name":"@array","kind":13,"containerName":"_gen_comb"},{"definition":"my","line":294,"localvar":"my","containerName":"_gen_comb","kind":13,"name":"$m"},{"definition":"my","name":"$value","localvar":"my","kind":13,"containerName":"_gen_comb","line":297},{"definition":"my","kind":13,"localvar":"my","containerName":"_gen_comb","name":"$list","line":300},{"containerName":"_gen_comb","kind":13,"name":"@array","line":302},{"kind":13,"containerName":"_gen_comb","name":"$m","line":302},{"line":302,"name":"$n","kind":13,"containerName":"_gen_comb"},{"name":"$value","containerName":"_gen_comb","kind":13,"line":302},{"line":302,"name":"$list","kind":13,"containerName":"_gen_comb"},{"name":"$list","containerName":"_gen_comb","kind":13,"line":304}]},{"line":302,"name":"_generateCombinations","kind":12},{"name":"_generateCombinations","containerName":"main::","children":[{"definition":"my","line":334,"name":"$rarr","kind":13,"localvar":"my","containerName":"_generateCombinations"},{"containerName":"_generateCombinations","kind":13,"name":"$rm","line":334},{"line":334,"name":"$rn","containerName":"_generateCombinations","kind":13},{"line":334,"name":"$rvalue","kind":13,"containerName":"_generateCombinations"},{"name":"$rlist","kind":13,"containerName":"_generateCombinations","line":334},{"definition":"my","line":336,"localvar":"my","kind":13,"containerName":"_generateCombinations","name":"$i"},{"line":336,"name":"$i","containerName":"_generateCombinations","kind":13},{"kind":13,"containerName":"_generateCombinations","name":"$rarr","line":336},{"line":336,"kind":13,"containerName":"_generateCombinations","name":"$i"},{"definition":"my","line":337,"name":"@value2","localvar":"my","containerName":"_generateCombinations","kind":13},{"kind":13,"containerName":"_generateCombinations","name":"$rvalue","line":337},{"line":337,"kind":13,"containerName":"_generateCombinations","name":"$rarr"},{"line":337,"kind":13,"containerName":"_generateCombinations","name":"$i"},{"line":338,"name":"@value2","containerName":"_generateCombinations","kind":13},{"line":339,"kind":13,"containerName":"_generateCombinations","name":"$rarr"},{"containerName":"_generateCombinations","kind":13,"name":"$i","line":339},{"containerName":"_generateCombinations","kind":13,"name":"$rn","line":339},{"name":"@value2","containerName":"_generateCombinations","kind":13,"line":339},{"line":339,"name":"$rlist","containerName":"_generateCombinations","kind":13},{"line":341,"kind":13,"containerName":"_generateCombinations","name":"@value2"},{"name":"$rlist","kind":13,"containerName":"_generateCombinations","line":342},{"kind":13,"containerName":"_generateCombinations","name":"@value2","line":342},{"line":344,"containerName":"_generateCombinations","kind":13,"name":"@value2"}],"detail":"($rarr,$rm,$rn,$rvalue,$rlist)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":348},"start":{"character":0,"line":332}},"line":332,"signature":{"documentation":"1;\n# module Bio::PopGen::TagHaplotype.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n# Copyright Pedro M. Gomez-Fabre\n#\n# You may distribute this module under the same term as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::TagHaplotype.pm - Haplotype tag object.\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::TagHaplotype;\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n=head1 DESCRIPTION\n\nThis module take as input a haplotype and try toe get the minimal set\nof SNP that define the haplotype. This module can be use alone.  But\ndue to the tagging haplotype process is exponential one. My suggestion\nis that before to use this module you pass your data under Select.mp\nmodule also on this folder.  In any case if, you provide an haplotype\nthe module will try to find the answer to your question.\n\n=head1 CONSTRUCTORS\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n    were $hap is the reference to an array of array with the haplotype.\n\n    $hap= [[0, 0, 0],\n           [1, 0, 0],\n           [0, 1, 1]\n          ];\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::TagHaplotype;\nuse strict;\n\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = <<EOF\nUsage:\n    Bio::PopGen::TagHaplotype->new(-haplotype_block => \\$hapblockref)\n\nEOF\n;\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Returns : self hash\n Args    : input haplotype (array of array)\n Status  : public\n\n\n#------------------------\nsub new{\n#------------------------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($haplotype_block) = $self->_rearrange([qw(HAPLOTYPE_BLOCK)],@args);\n\n    if ($haplotype_block) {\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"haplotype has not been supplied\\n$USAGE\");\n    }\n\n    # check that the haplotype block is well formed.\n    for (my $i=0; $i<$#$haplotype_block+1; $i++){\n\tif ( $#{$haplotype_block->[0]} !=\n             $#{$haplotype_block->[$i]} ){\n\n            $self->throw(\"The haplotype matrix is not well formed (Not squared)\");\n        }\n    }\n\n    # make the calculation\n    my $tag_list =  _scan_snp( $self ->haplotype_block );\n\n    if ($tag_list){\n        $self ->tag_list($tag_list);\n    }\n    else { \n        $self ->tag_list(undef);\n    }\n\n    if ( defined $self->tag_list){\n        $self ->tag_length(scalar @{$self->tag_list});\n    }\n    else {\n        $self ->tag_length(0);  #\"NO TAGS FOUND!\"\n    }\n\n    return $self;\n}\n\n=head2 haplotype_block\n\n Title   : haplotype_block\n Usage   : my $haplotype_block = $TagHaplotype->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with haplotype pattern\n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n\n=head2 input_block \n\n Title   : input_block \n Usage   : $obj->input_block()\n Function: returns haplotype block. By now will produce the same ouput than\n           $self->haplotype_block. but for compatiblity, this method is kept. \n           This method is deprecated.\n Returns : reference to array of array with the haplotype input value \n Args    : none \n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n    my $self = shift;\n\n    $self->warn(ref($self). \"::input_block - deprecated method. Use haplotype_block() instead.\");\n    return $self->haplotype_block;\n}\n\n=head2 tag_list\n\n Title   : tag_list \n Usage   : $obj->tag_list()\n Function: returns the list of SNPs combination that identify the\n           haplotype. All combinations are displayed as arrays\n Returns : reference to array of array. \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_list{\n#------------------------\n    my ($self) = shift;\n    return $self->{'_tag_list'}= shift if @_;\n    return $self->{'_tag_list'};\n}\n\n=head2 tag_length \n\n Title   : tag_length \n Usage   : $obj->tag_length()\n Function: returns the length of the tag.\n Returns : scalar \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_length{\n#------------------------\n    my ($self) =shift;\n    return $self ->{'_tag_length'} = shift if @_;\n    return $self ->{'_tag_length'};\n}\n\n=head2 _scan_snp \n\n Title   : _scan_snp \n Usage   : internal\n Function: scan sets increasing the length until find a non degenerated\n           pattern. \n Returns : scalar\n Args    : none\n Status  : private\n\n\n#------------------------\nsub _scan_snp{\n#------------------------\n    my ($hap)=@_;\n\n    my $hap_length = scalar @{$hap->[0]};    ## store the haplotype length\n\n    for my $i(1..$hap_length){\n\n        my $list = _gen_comb($hap_length, $i);\n\n        my $snp_collection = _scan_combinations($hap, $list);\n\n        # if there is any element on the collection.\n        # We have reached our goal and \n        # we can stop the calculation.\n        if($#$snp_collection>-1){\n            return $snp_collection;\n        }\n    }\n}\n\n=head2 _gen_comb\n\n Title   : _gen_comb \n Usage   : internal\n Function: we supply the length of the haplotype and the length of the\n           word we need to find and the functions returns the possible\n           list of combinations.\n Returns : scalar\n Args    : none\n Status  : private\n\n\n#------------------------\nsub _gen_comb{\n#------------------------\n\n    my ($hap_length,$n) = @_;\n\n    my @array = ();    # list with all elements we have to combine\n\n    \n    for(0..$hap_length-1){ push @array, $_ };\n\n    #\n    # we need some parameters to create the combination list.\n    # This parameters can be changed if we can modify the list values\n    #\n\n    my $m = -1;      # this parameter start the calculation at value\n                     # m+1 on the recursive cicle.\n\n    my $value = [];  ## seems to have not too much sense here, but is\n                     ## needed on the recursion and need to be started\n                     ## from here\n    my $list = [];\n\n    _generateCombinations ( \\@array, \\$m, \\$n, $value, $list);\n\n    return $list;\n\n}\n\n=head2 _generateCombinations \n\n Title   : _generateCombinations \n Usage   : internal\n Function: Recursive function that produce all combinations for a set\n\n           i.e.:\n\n           1, 2, 3, 4\n\n           and word of B<3> will produce:\n\n           1, 2, 3\n           1, 2, 4\n           1, 3, 4\n           2, 3, 4\n\n Returns :\n Args    : none\n Status  : private","parameters":[{"label":"$rarr"},{"label":"$rm"},{"label":"$rn"},{"label":"$rvalue"},{"label":"$rlist"}],"label":"_generateCombinations($rarr,$rm,$rn,$rvalue,$rlist)"}},{"line":336,"name":"rm","kind":12},{"kind":12,"name":"rn","line":338},{"name":"rn","kind":12,"line":341},{"line":344,"name":"rn","kind":12},{"containerName":"main::","name":"_scan_combinations","children":[{"name":"$hap","kind":13,"localvar":"my","containerName":"_scan_combinations","line":380,"definition":"my"},{"line":380,"containerName":"_scan_combinations","kind":13,"name":"$list"},{"definition":"my","localvar":"my","kind":13,"containerName":"_scan_combinations","name":"$valid_combination","line":382},{"definition":"my","localvar":"my","kind":13,"containerName":"_scan_combinations","name":"$i","line":385},{"line":385,"kind":13,"containerName":"_scan_combinations","name":"$list"},{"line":388,"localvar":"my","containerName":"_scan_combinations","kind":13,"name":"$subArray","definition":"my"},{"name":"$hap","kind":13,"containerName":"_scan_combinations","line":388},{"line":388,"name":"$list","kind":13,"containerName":"_scan_combinations"},{"name":"$i","containerName":"_scan_combinations","kind":13,"line":388},{"definition":"my","localvar":"my","containerName":"_scan_combinations","kind":13,"name":"$degeneration","line":390},{"name":"$subArray","kind":13,"containerName":"_scan_combinations","line":390},{"name":"$degeneration","kind":13,"containerName":"_scan_combinations","line":392},{"name":"$valid_combination","kind":13,"containerName":"_scan_combinations","line":393},{"name":"$list","containerName":"_scan_combinations","kind":13,"line":393},{"line":393,"containerName":"_scan_combinations","kind":13,"name":"$i"}],"detail":"($hap,$list)","definition":"sub","kind":12,"range":{"start":{"line":377,"character":0},"end":{"character":9999,"line":395}},"line":377,"signature":{"label":"_scan_combinations($hap,$list)","documentation":"1;\n# module Bio::PopGen::TagHaplotype.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n# Copyright Pedro M. Gomez-Fabre\n#\n# You may distribute this module under the same term as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::TagHaplotype.pm - Haplotype tag object.\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::TagHaplotype;\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n=head1 DESCRIPTION\n\nThis module take as input a haplotype and try toe get the minimal set\nof SNP that define the haplotype. This module can be use alone.  But\ndue to the tagging haplotype process is exponential one. My suggestion\nis that before to use this module you pass your data under Select.mp\nmodule also on this folder.  In any case if, you provide an haplotype\nthe module will try to find the answer to your question.\n\n=head1 CONSTRUCTORS\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n    were $hap is the reference to an array of array with the haplotype.\n\n    $hap= [[0, 0, 0],\n           [1, 0, 0],\n           [0, 1, 1]\n          ];\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::TagHaplotype;\nuse strict;\n\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = <<EOF\nUsage:\n    Bio::PopGen::TagHaplotype->new(-haplotype_block => \\$hapblockref)\n\nEOF\n;\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Returns : self hash\n Args    : input haplotype (array of array)\n Status  : public\n\n\n#------------------------\nsub new{\n#------------------------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($haplotype_block) = $self->_rearrange([qw(HAPLOTYPE_BLOCK)],@args);\n\n    if ($haplotype_block) {\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"haplotype has not been supplied\\n$USAGE\");\n    }\n\n    # check that the haplotype block is well formed.\n    for (my $i=0; $i<$#$haplotype_block+1; $i++){\n\tif ( $#{$haplotype_block->[0]} !=\n             $#{$haplotype_block->[$i]} ){\n\n            $self->throw(\"The haplotype matrix is not well formed (Not squared)\");\n        }\n    }\n\n    # make the calculation\n    my $tag_list =  _scan_snp( $self ->haplotype_block );\n\n    if ($tag_list){\n        $self ->tag_list($tag_list);\n    }\n    else { \n        $self ->tag_list(undef);\n    }\n\n    if ( defined $self->tag_list){\n        $self ->tag_length(scalar @{$self->tag_list});\n    }\n    else {\n        $self ->tag_length(0);  #\"NO TAGS FOUND!\"\n    }\n\n    return $self;\n}\n\n=head2 haplotype_block\n\n Title   : haplotype_block\n Usage   : my $haplotype_block = $TagHaplotype->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with haplotype pattern\n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n\n=head2 input_block \n\n Title   : input_block \n Usage   : $obj->input_block()\n Function: returns haplotype block. By now will produce the same ouput than\n           $self->haplotype_block. but for compatiblity, this method is kept. \n           This method is deprecated.\n Returns : reference to array of array with the haplotype input value \n Args    : none \n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n    my $self = shift;\n\n    $self->warn(ref($self). \"::input_block - deprecated method. Use haplotype_block() instead.\");\n    return $self->haplotype_block;\n}\n\n=head2 tag_list\n\n Title   : tag_list \n Usage   : $obj->tag_list()\n Function: returns the list of SNPs combination that identify the\n           haplotype. All combinations are displayed as arrays\n Returns : reference to array of array. \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_list{\n#------------------------\n    my ($self) = shift;\n    return $self->{'_tag_list'}= shift if @_;\n    return $self->{'_tag_list'};\n}\n\n=head2 tag_length \n\n Title   : tag_length \n Usage   : $obj->tag_length()\n Function: returns the length of the tag.\n Returns : scalar \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_length{\n#------------------------\n    my ($self) =shift;\n    return $self ->{'_tag_length'} = shift if @_;\n    return $self ->{'_tag_length'};\n}\n\n=head2 _scan_snp \n\n Title   : _scan_snp \n Usage   : internal\n Function: scan sets increasing the length until find a non degenerated\n           pattern. \n Returns : scalar\n Args    : none\n Status  : private\n\n\n#------------------------\nsub _scan_snp{\n#------------------------\n    my ($hap)=@_;\n\n    my $hap_length = scalar @{$hap->[0]};    ## store the haplotype length\n\n    for my $i(1..$hap_length){\n\n        my $list = _gen_comb($hap_length, $i);\n\n        my $snp_collection = _scan_combinations($hap, $list);\n\n        # if there is any element on the collection.\n        # We have reached our goal and \n        # we can stop the calculation.\n        if($#$snp_collection>-1){\n            return $snp_collection;\n        }\n    }\n}\n\n=head2 _gen_comb\n\n Title   : _gen_comb \n Usage   : internal\n Function: we supply the length of the haplotype and the length of the\n           word we need to find and the functions returns the possible\n           list of combinations.\n Returns : scalar\n Args    : none\n Status  : private\n\n\n#------------------------\nsub _gen_comb{\n#------------------------\n\n    my ($hap_length,$n) = @_;\n\n    my @array = ();    # list with all elements we have to combine\n\n    \n    for(0..$hap_length-1){ push @array, $_ };\n\n    #\n    # we need some parameters to create the combination list.\n    # This parameters can be changed if we can modify the list values\n    #\n\n    my $m = -1;      # this parameter start the calculation at value\n                     # m+1 on the recursive cicle.\n\n    my $value = [];  ## seems to have not too much sense here, but is\n                     ## needed on the recursion and need to be started\n                     ## from here\n    my $list = [];\n\n    _generateCombinations ( \\@array, \\$m, \\$n, $value, $list);\n\n    return $list;\n\n}\n\n=head2 _generateCombinations \n\n Title   : _generateCombinations \n Usage   : internal\n Function: Recursive function that produce all combinations for a set\n\n           i.e.:\n\n           1, 2, 3, 4\n\n           and word of B<3> will produce:\n\n           1, 2, 3\n           1, 2, 4\n           1, 3, 4\n           2, 3, 4\n\n Returns :\n Args    : none\n Status  : private\n\n\n#------------------------\nsub _generateCombinations{\n#------------------------\n    my ($rarr, $rm, $rn, $rvalue,$rlist)=@_;\n\n    for (my $i = ($$rm+1); $i<scalar @$rarr; $i++){\n        push (my @value2,@$rvalue,$rarr->[$i]);\n        if (scalar @value2<$$rn){\n            _generateCombinations($rarr,\\$i, $rn, \\@value2, $rlist);\n        }\n        if (scalar @value2==$$rn){\n            push @$rlist, [@value2];\n        }\n        if(scalar @value2>$$rn){\n            last;\n        }\n    }\n}\n\n# take the list of combinations\n# i.e.: 1 2 3\n#       1 2 4\n#       1 3 4\n#       2 3 4\n#\n# generate a sub array from the haplotype with the snp tag for the combination\n# and check all haplotypes for these columns.\n# if two haplotypes have the same value. we can not define the haplotype\n# without ambiguity.\n# Will return a list of valid combinations (SNP Tags)\n#\n\n=head2 _scan_combinations \n\n Title   : _scan_combinations \n Usage   : internal\n Function: take the haplotype and a list of possible combination\n           for that length. Generate a subset and scan it to find if\n           the information is enought to define the haplotype set.\n Returns :\n Args    : none\n Status  : private","parameters":[{"label":"$hap"},{"label":"$list"}]}},{"name":"_get_subArray","kind":12,"line":388},{"line":390,"name":"_deg_test","kind":12},{"line":396,"containerName":null,"kind":13,"name":"$valid_combination"},{"containerName":"main::","name":"_deg_test","children":[{"line":404,"name":"$hap","localvar":"my","containerName":"_deg_test","kind":13,"definition":"my"},{"name":"$c1","localvar":"my","containerName":"_deg_test","kind":13,"line":407,"definition":"my"},{"kind":13,"containerName":"_deg_test","name":"$hap","line":407},{"definition":"my","name":"$c2","localvar":"my","kind":13,"containerName":"_deg_test","line":408},{"name":"$c1","containerName":"_deg_test","kind":13,"line":408},{"line":408,"name":"$hap","containerName":"_deg_test","kind":13},{"kind":13,"localvar":"my","containerName":"_deg_test","name":"$degeneration","line":409,"definition":"my"},{"kind":13,"containerName":"_deg_test","name":"$hap","line":409},{"name":"$c1","containerName":"_deg_test","kind":13,"line":409},{"line":409,"name":"$hap","kind":13,"containerName":"_deg_test"},{"line":409,"name":"$c2","kind":13,"containerName":"_deg_test"},{"line":410,"name":"$degeneration","kind":13,"containerName":"_deg_test"}],"detail":"($hap)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":416},"start":{"character":0,"line":401}},"line":401,"signature":{"label":"_deg_test($hap)","parameters":[{"label":"$hap"}],"documentation":" return 1 if two arrays are degenerated (same haplotype)"}},{"line":409,"kind":12,"name":"compare_arrays"},{"signature":{"parameters":[{"label":"$hap"},{"label":"$combination"}],"documentation":"","label":"_get_subArray($hap,$combination)"},"line":419,"kind":12,"range":{"end":{"line":429,"character":9999},"start":{"line":419,"character":0}},"definition":"sub","detail":"($hap,$combination)","children":[{"definition":"my","containerName":"_get_subArray","localvar":"my","kind":13,"name":"$hap","line":421},{"line":421,"kind":13,"containerName":"_get_subArray","name":"$combination"},{"name":"$out","kind":13,"localvar":"my","containerName":"_get_subArray","line":423,"definition":"my"},{"line":425,"localvar":"my","containerName":"_get_subArray","kind":13,"name":"$i","definition":"my"},{"kind":13,"containerName":"_get_subArray","name":"$hap","line":425},{"line":426,"name":"$combination","containerName":"_get_subArray","kind":13},{"name":"$out","kind":13,"containerName":"_get_subArray","line":427},{"line":427,"name":"$i","containerName":"_get_subArray","kind":13},{"name":"$hap","containerName":"_get_subArray","kind":13,"line":427},{"line":427,"kind":13,"containerName":"_get_subArray","name":"$i"}],"name":"_get_subArray","containerName":"main::"},{"line":430,"name":"$out","containerName":null,"kind":13},{"range":{"end":{"line":448,"character":9999},"start":{"character":0,"line":440}},"kind":12,"line":440,"signature":{"documentation":" take two arrays and compare their values\n Returns : 1 if the two values are the same\n           0 if the values are different","parameters":[{"label":"$first"},{"label":"$second"}],"label":"compare_arrays($first,$second)"},"name":"compare_arrays","containerName":"main::","children":[{"line":442,"containerName":"compare_arrays","localvar":"my","kind":13,"name":"$first","definition":"my"},{"kind":13,"containerName":"compare_arrays","name":"$second","line":442},{"line":443,"kind":13,"containerName":"compare_arrays","name":"$first"},{"kind":13,"containerName":"compare_arrays","name":"$second","line":443},{"line":444,"localvar":"my","kind":13,"containerName":"compare_arrays","name":"$i","definition":"my"},{"kind":13,"containerName":"compare_arrays","name":"$i","line":444},{"kind":13,"containerName":"compare_arrays","name":"$first","line":444},{"line":444,"containerName":"compare_arrays","kind":13,"name":"$i"},{"line":445,"name":"$first","kind":13,"containerName":"compare_arrays"},{"kind":13,"containerName":"compare_arrays","name":"$i","line":445},{"kind":13,"containerName":"compare_arrays","name":"$second","line":445},{"name":"$i","kind":13,"containerName":"compare_arrays","line":445}],"detail":"($first,$second)","definition":"sub"}]}