{"version":5,"vars":[{"line":100,"name":"vars","kind":2,"containerName":""},{"line":103,"kind":13,"containerName":null,"name":"$PRECISION_DIGITS"},{"line":103,"kind":2,"containerName":"","name":"strict"},{"line":109,"name":"base","containerName":"","kind":2},{"children":[{"definition":"my","line":126,"name":"$class","kind":13,"localvar":"my","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":126},{"definition":"my","line":127,"localvar":"my","containerName":"new","kind":13,"name":"$self"},{"line":127,"name":"$class","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"@args","line":127},{"name":"$self","kind":13,"containerName":"new","line":129},{"name":"$self","containerName":"new","kind":13,"line":130},{"line":131,"name":"$maxcount","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"name":"$samps","containerName":"new","kind":13,"line":131},{"line":131,"kind":13,"containerName":"new","name":"$samplesize"},{"line":131,"kind":13,"containerName":"new","name":"$self"},{"line":131,"containerName":"new","kind":12,"name":"_rearrange"},{"kind":13,"containerName":"new","name":"@args","line":134},{"line":135,"localvar":"my","containerName":"new","kind":13,"name":"@samples","definition":"my"},{"kind":13,"containerName":"new","name":"$samps","line":137},{"line":138,"name":"$samplesize","kind":13,"containerName":"new"},{"line":138,"name":"$samplesize","kind":13,"containerName":"new"},{"line":139,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"throw","line":139},{"name":"$samplesize","kind":13,"containerName":"new","line":141},{"line":141,"containerName":"new","kind":13,"name":"@samples"},{"kind":13,"containerName":"new","name":"$samps","line":143},{"kind":13,"containerName":"new","name":"$self","line":144},{"line":144,"name":"throw","kind":12,"containerName":"new"},{"name":"@samples","kind":13,"containerName":"new","line":146},{"kind":13,"containerName":"new","name":"$samps","line":146},{"line":149,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"samples","line":149},{"line":149,"name":"@samples","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":150},{"line":150,"containerName":"new","kind":12,"name":"sample_size"},{"line":150,"name":"@samples","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$maxcount","line":151},{"name":"$self","kind":13,"containerName":"new","line":151},{"name":"maxcount","kind":12,"containerName":"new","line":151},{"containerName":"new","kind":13,"name":"$maxcount","line":151},{"kind":13,"containerName":"new","name":"$self","line":152}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":125,"range":{"end":{"line":153,"character":9999},"start":{"character":0,"line":125}},"kind":12,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide"}},{"name":"SUPER","kind":12,"containerName":"new","line":127},{"detail":"($self)","definition":"sub","name":"next_tree","containerName":"main::","children":[{"definition":"my","line":169,"name":"$self","localvar":"my","containerName":"next_tree","kind":13},{"line":173,"name":"$self","kind":13,"containerName":"next_tree"},{"containerName":"next_tree","kind":12,"name":"maxcount","line":173},{"line":174,"name":"$self","containerName":"next_tree","kind":13},{"line":174,"containerName":"next_tree","kind":13,"name":"$self"},{"containerName":"next_tree","kind":12,"name":"maxcount","line":174},{"line":175,"name":"$size","localvar":"my","containerName":"next_tree","kind":13,"definition":"my"},{"line":175,"name":"$self","kind":13,"containerName":"next_tree"},{"line":175,"name":"sample_size","containerName":"next_tree","kind":12},{"definition":"my","localvar":"my","kind":13,"containerName":"next_tree","name":"$in","line":177},{"definition":"my","localvar":"my","kind":13,"containerName":"next_tree","name":"@tree","line":178},{"line":179,"kind":13,"localvar":"my","containerName":"next_tree","name":"@list","definition":"my"},{"containerName":"next_tree","kind":13,"name":"$in","line":181},{"name":"$in","containerName":"next_tree","kind":13,"line":181},{"line":181,"containerName":"next_tree","kind":13,"name":"$size"},{"line":181,"name":"$in","containerName":"next_tree","kind":13},{"line":182,"name":"@tree","kind":13,"containerName":"next_tree"},{"name":"$in","kind":13,"containerName":"next_tree","line":192},{"containerName":"next_tree","kind":13,"name":"$in","line":192},{"line":192,"name":"$size","kind":13,"containerName":"next_tree"},{"line":192,"name":"$in","containerName":"next_tree","kind":13},{"line":193,"kind":13,"containerName":"next_tree","name":"$tree"},{"line":193,"name":"$in","kind":13,"containerName":"next_tree"},{"line":194,"name":"$tree","containerName":"next_tree","kind":13},{"name":"$in","kind":13,"containerName":"next_tree","line":194},{"name":"$tree","kind":13,"containerName":"next_tree","line":195},{"kind":13,"containerName":"next_tree","name":"$in","line":195},{"line":196,"kind":13,"containerName":"next_tree","name":"@list"},{"name":"$in","kind":13,"containerName":"next_tree","line":196},{"line":199,"name":"$t","containerName":"next_tree","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"next_tree","name":"$in","line":201},{"name":"$size","kind":13,"containerName":"next_tree","line":201},{"line":201,"name":"$in","containerName":"next_tree","kind":13},{"containerName":"next_tree","kind":13,"name":"$in","line":201},{"name":"$t","containerName":"next_tree","kind":13,"line":202},{"line":202,"kind":13,"containerName":"next_tree","name":"$self"},{"line":202,"name":"random","containerName":"next_tree","kind":12},{"line":202,"name":"$in","kind":13,"containerName":"next_tree"},{"name":"$in","containerName":"next_tree","kind":13,"line":202},{"name":"$tree","kind":13,"containerName":"next_tree","line":203},{"containerName":"next_tree","kind":13,"name":"$size","line":203},{"line":203,"name":"$in","containerName":"next_tree","kind":13},{"name":"$t","kind":13,"containerName":"next_tree","line":203},{"line":206,"kind":13,"containerName":"next_tree","name":"$in"},{"kind":13,"containerName":"next_tree","name":"$size","line":206},{"line":206,"name":"$in","containerName":"next_tree","kind":13},{"kind":13,"containerName":"next_tree","name":"$in","line":206},{"definition":"my","line":207,"localvar":"my","containerName":"next_tree","kind":13,"name":"$pick"},{"line":207,"kind":13,"containerName":"next_tree","name":"$self"},{"line":207,"name":"random","kind":12,"containerName":"next_tree"},{"line":207,"name":"$in","kind":13,"containerName":"next_tree"},{"definition":"my","line":208,"localvar":"my","kind":13,"containerName":"next_tree","name":"$nodeindex"},{"line":208,"name":"$list","kind":13,"containerName":"next_tree"},{"line":208,"kind":13,"containerName":"next_tree","name":"$pick"},{"name":"$swap","containerName":"next_tree","localvar":"my","kind":13,"line":209,"definition":"my"},{"line":209,"name":"$size","containerName":"next_tree","kind":13},{"line":209,"name":"$in","containerName":"next_tree","kind":13},{"kind":13,"containerName":"next_tree","name":"$tree","line":210},{"name":"$swap","containerName":"next_tree","kind":13,"line":210},{"line":210,"containerName":"next_tree","kind":13,"name":"$nodeindex"},{"line":211,"containerName":"next_tree","kind":13,"name":"$list"},{"line":211,"name":"$pick","containerName":"next_tree","kind":13},{"line":211,"name":"$list","containerName":"next_tree","kind":13},{"name":"$in","containerName":"next_tree","kind":13,"line":211},{"line":212,"kind":13,"containerName":"next_tree","name":"$pick"},{"name":"$in","containerName":"next_tree","kind":13,"line":212},{"line":213,"kind":13,"containerName":"next_tree","name":"$nodeindex"},{"line":213,"name":"$list","containerName":"next_tree","kind":13},{"name":"$pick","kind":13,"containerName":"next_tree","line":213},{"line":214,"name":"$tree","containerName":"next_tree","kind":13},{"line":214,"kind":13,"containerName":"next_tree","name":"$swap"},{"kind":13,"containerName":"next_tree","name":"$nodeindex","line":214},{"name":"$list","containerName":"next_tree","kind":13,"line":215},{"containerName":"next_tree","kind":13,"name":"$pick","line":215},{"line":215,"name":"$swap","containerName":"next_tree","kind":13},{"name":"@nodes","containerName":"next_tree","localvar":"my","kind":13,"line":219,"definition":"my"},{"localvar":"my","kind":13,"containerName":"next_tree","name":"$n","line":220,"definition":"my"},{"name":"@tree","kind":13,"containerName":"next_tree","line":220},{"line":221,"name":"@nodes","containerName":"next_tree","kind":13},{"name":"new","kind":12,"containerName":"next_tree","line":222},{"line":222,"name":"$n","containerName":"next_tree","kind":13},{"line":223,"kind":13,"containerName":"next_tree","name":"$n"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_tree","name":"$ct","line":225},{"line":226,"kind":13,"localvar":"my","containerName":"next_tree","name":"$node","definition":"my"},{"line":226,"containerName":"next_tree","kind":13,"name":"@nodes"},{"definition":"my","name":"$n","kind":13,"localvar":"my","containerName":"next_tree","line":227},{"line":227,"kind":13,"containerName":"next_tree","name":"$tree"},{"name":"$ct","containerName":"next_tree","kind":13,"line":227},{"name":"$n","containerName":"next_tree","kind":13,"line":228},{"line":229,"containerName":"next_tree","kind":13,"name":"$node"},{"kind":12,"containerName":"next_tree","name":"add_Descendent","line":229},{"name":"$nodes","containerName":"next_tree","kind":13,"line":229},{"line":229,"name":"$n","kind":13,"containerName":"next_tree"},{"containerName":"next_tree","kind":13,"name":"$n","line":231},{"name":"$node","kind":13,"containerName":"next_tree","line":232},{"line":232,"name":"add_Descendent","containerName":"next_tree","kind":12},{"line":232,"containerName":"next_tree","kind":13,"name":"$nodes"},{"name":"$n","kind":13,"containerName":"next_tree","line":232},{"line":235,"kind":13,"localvar":"my","containerName":"next_tree","name":"$T","definition":"my"},{"line":235,"kind":12,"containerName":"next_tree","name":"new"},{"line":235,"name":"@nodes","containerName":"next_tree","kind":13},{"line":236,"name":"$T","containerName":"next_tree","kind":13}],"signature":{"label":"next_tree($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($maxcount, $samps,$samplesize ) = $self->_rearrange([qw(MAXCOUNT\n\t\t\t\t\t\t\t       SAMPLES\n\t\t\t\t\t\t\t       SAMPLE_SIZE)],\n\t\t\t\t\t\t\t   @args);\n   my @samples;\n   \n   if( ! defined $samps ) { \n       if( ! defined $samplesize || $samplesize <= 0 ) { \n\t   $self->throw(\"Must specify a valid samplesize if parameter -SAMPLE is not specified (sampsize is $samplesize)\");\n       }\n       foreach ( 1..$samplesize ) { push @samples, \"Samp$_\"; }      \n   } else { \n       if( ref($samps) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -SAMPLES, did you forget a leading '\\\\'?\");\n       }\n       @samples = @$samps;\n   }\n   \n   $self->samples(\\@samples);\n   $self->sample_size(scalar @samples);\n   defined $maxcount && $self->maxcount($maxcount);   \n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n Returns : Bio::Tree::TreeI object\n Args    : none"},"range":{"start":{"character":0,"line":168},"end":{"character":9999,"line":237}},"kind":12,"line":168},{"name":"Bio","kind":12,"containerName":"Tree::AlleleNode","line":222},{"line":235,"name":"Bio","containerName":"Tree::Tree","kind":12},{"detail":"($self,$tree,$nummut,$precision)","definition":"sub","containerName":"main::","name":"add_Mutations","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"add_Mutations","line":255,"definition":"my"},{"containerName":"add_Mutations","kind":13,"name":"$tree","line":255},{"name":"$nummut","kind":13,"containerName":"add_Mutations","line":255},{"kind":13,"containerName":"add_Mutations","name":"$precision","line":255},{"kind":13,"containerName":"add_Mutations","name":"$precision","line":256},{"name":"$PRECISION_DIGITS","containerName":"add_Mutations","kind":13,"line":256},{"name":"$precision","containerName":"add_Mutations","kind":13,"line":257},{"containerName":"add_Mutations","kind":13,"name":"$precision","line":257},{"definition":"my","line":259,"localvar":"my","containerName":"add_Mutations","kind":13,"name":"@branches"},{"definition":"my","containerName":"add_Mutations","localvar":"my","kind":13,"name":"@lens","line":260},{"line":261,"name":"$branchlen","containerName":"add_Mutations","localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"$last","containerName":"add_Mutations","localvar":"my","kind":13,"line":262},{"line":263,"containerName":"add_Mutations","localvar":"my","kind":13,"name":"@nodes","definition":"my"},{"line":263,"kind":13,"containerName":"add_Mutations","name":"$tree"},{"containerName":"add_Mutations","kind":12,"name":"get_nodes","line":263},{"definition":"my","name":"$i","localvar":"my","containerName":"add_Mutations","kind":13,"line":264},{"line":273,"containerName":"add_Mutations","localvar":"my","kind":13,"name":"$node","definition":"my"},{"line":273,"name":"@nodes","kind":13,"containerName":"add_Mutations"},{"containerName":"add_Mutations","kind":13,"name":"$node","line":274},{"kind":12,"containerName":"add_Mutations","name":"ancestor","line":274},{"line":275,"containerName":"add_Mutations","localvar":"my","kind":13,"name":"$len","definition":"my"},{"name":"$node","kind":13,"containerName":"add_Mutations","line":275},{"line":275,"name":"ancestor","kind":12,"containerName":"add_Mutations"},{"line":275,"containerName":"add_Mutations","kind":12,"name":"branch_length"},{"name":"$node","containerName":"add_Mutations","kind":13,"line":276},{"name":"branch_length","kind":12,"containerName":"add_Mutations","line":276},{"kind":13,"containerName":"add_Mutations","name":"$precision","line":276},{"line":277,"name":"$len","kind":13,"containerName":"add_Mutations"},{"definition":"my","name":"$j","localvar":"my","containerName":"add_Mutations","kind":13,"line":278},{"line":278,"kind":13,"containerName":"add_Mutations","name":"$j"},{"line":278,"kind":13,"containerName":"add_Mutations","name":"$len"},{"line":278,"name":"$j","kind":13,"containerName":"add_Mutations"},{"name":"@branches","containerName":"add_Mutations","kind":13,"line":279},{"containerName":"add_Mutations","kind":13,"name":"$i","line":279},{"containerName":"add_Mutations","kind":13,"name":"$last","line":281},{"line":281,"name":"$len","kind":13,"containerName":"add_Mutations"},{"kind":13,"containerName":"add_Mutations","name":"$branchlen","line":283},{"line":283,"name":"$len","containerName":"add_Mutations","kind":13},{"line":285,"name":"$node","kind":13,"containerName":"add_Mutations"},{"line":285,"containerName":"add_Mutations","kind":12,"name":"isa"},{"name":"$node","kind":13,"containerName":"add_Mutations","line":286},{"line":290,"containerName":"add_Mutations","kind":13,"name":"$node"},{"name":"reset_Genotypes","containerName":"add_Mutations","kind":12,"line":290},{"name":"$i","containerName":"add_Mutations","kind":13,"line":291},{"line":294,"name":"$self","containerName":"add_Mutations","kind":13},{"name":"throw","kind":12,"containerName":"add_Mutations","line":294},{"name":"$branchlen","containerName":"add_Mutations","kind":13,"line":295},{"line":295,"name":"$last","kind":13,"containerName":"add_Mutations"},{"definition":"my","line":296,"containerName":"add_Mutations","localvar":"my","kind":13,"name":"@mutations"},{"line":297,"name":"$j","kind":13,"localvar":"my","containerName":"add_Mutations","definition":"my"},{"line":297,"containerName":"add_Mutations","kind":13,"name":"$j"},{"name":"$nummut","containerName":"add_Mutations","kind":13,"line":297},{"line":297,"name":"$j","kind":13,"containerName":"add_Mutations"},{"name":"$index","localvar":"my","containerName":"add_Mutations","kind":13,"line":298,"definition":"my"},{"line":298,"name":"$branchlen","containerName":"add_Mutations","kind":13},{"line":299,"name":"$branch","containerName":"add_Mutations","localvar":"my","kind":13,"definition":"my"},{"name":"$branches","containerName":"add_Mutations","kind":13,"line":299},{"containerName":"add_Mutations","kind":13,"name":"$index","line":299},{"definition":"my","line":303,"name":"$g","localvar":"my","containerName":"add_Mutations","kind":13},{"line":303,"containerName":"add_Mutations","kind":12,"name":"new"},{"name":"$nodes","kind":13,"containerName":"add_Mutations","line":305},{"line":305,"containerName":"add_Mutations","kind":13,"name":"$branch"},{"kind":12,"containerName":"add_Mutations","name":"add_Genotype","line":305},{"name":"$g","containerName":"add_Mutations","kind":13,"line":305},{"name":"@mutations","kind":13,"containerName":"add_Mutations","line":306},{"definition":"my","containerName":"add_Mutations","localvar":"my","kind":13,"name":"$child","line":309},{"kind":13,"containerName":"add_Mutations","name":"$nodes","line":309},{"name":"$branch","containerName":"add_Mutations","kind":13,"line":309},{"line":309,"name":"get_all_Descendents","containerName":"add_Mutations","kind":12},{"name":"$child","containerName":"add_Mutations","kind":13,"line":310},{"line":310,"name":"add_Genotype","containerName":"add_Mutations","kind":12},{"kind":13,"containerName":"add_Mutations","name":"$g","line":310},{"line":315,"name":"$node","localvar":"my","kind":13,"containerName":"add_Mutations","definition":"my"},{"line":315,"name":"@nodes","kind":13,"containerName":"add_Mutations"},{"line":316,"name":"$m","containerName":"add_Mutations","localvar":"my","kind":13,"definition":"my"},{"line":316,"kind":13,"containerName":"add_Mutations","name":"@mutations"},{"name":"$node","kind":13,"containerName":"add_Mutations","line":317},{"name":"has_Marker","containerName":"add_Mutations","kind":12,"line":317},{"line":317,"name":"$m","containerName":"add_Mutations","kind":13},{"line":318,"kind":13,"localvar":"my","containerName":"add_Mutations","name":"$emptyg","definition":"my"},{"name":"new","containerName":"add_Mutations","kind":12,"line":318},{"line":318,"containerName":"add_Mutations","kind":13,"name":"$m"},{"line":320,"kind":13,"containerName":"add_Mutations","name":"$node"},{"kind":12,"containerName":"add_Mutations","name":"add_Genotype","line":320},{"line":320,"name":"$emptyg","kind":13,"containerName":"add_Mutations"}],"signature":{"parameters":[{"label":"$self"},{"label":"$tree"},{"label":"$nummut"},{"label":"$precision"}],"documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($maxcount, $samps,$samplesize ) = $self->_rearrange([qw(MAXCOUNT\n\t\t\t\t\t\t\t       SAMPLES\n\t\t\t\t\t\t\t       SAMPLE_SIZE)],\n\t\t\t\t\t\t\t   @args);\n   my @samples;\n   \n   if( ! defined $samps ) { \n       if( ! defined $samplesize || $samplesize <= 0 ) { \n\t   $self->throw(\"Must specify a valid samplesize if parameter -SAMPLE is not specified (sampsize is $samplesize)\");\n       }\n       foreach ( 1..$samplesize ) { push @samples, \"Samp$_\"; }      \n   } else { \n       if( ref($samps) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -SAMPLES, did you forget a leading '\\\\'?\");\n       }\n       @samples = @$samps;\n   }\n   \n   $self->samples(\\@samples);\n   $self->sample_size(scalar @samples);\n   defined $maxcount && $self->maxcount($maxcount);   \n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   # If maxcount is set to something non-zero then next tree will\n   # continue to return valid trees until maxcount is reached\n   # otherwise will always return trees \n   return if( $self->maxcount &&\n\t      $self->{'_treecounter'}++ >= $self->maxcount );\n   my $size = $self->sample_size;\n   \n   my $in;\n   my @tree = ();\n   my @list = ();\n   \n   for($in=0;$in < 2*$size -1; $in++ ) { \n       push @tree, { 'nodenum' => \"Node$in\" };\n   }\n   # in C we would have 2 arrays\n   # an array of nodes (tree)\n   # and array of pointers to these nodes (list)\n   # and we just shuffle the list items to do the \n   # tree topology generation\n   # instead in perl, we will have a list of hashes (nodes) called @tree\n   # and a list of integers representing the indexes in tree called @list\n\n   for($in=0;$in < $size;$in++)  {\n       $tree[$in]->{'time'} = 0;\n       $tree[$in]->{'desc1'} = undef;\n       $tree[$in]->{'desc2'} = undef;\n       push @list, $in;\n   }\n\n   my $t=0;\n   # generate times for the nodes\n   for($in = $size; $in > 1; $in-- ) {\n\t$t+= -2.0 * log(1 - $self->random(1)) / ( $in * ($in-1) );    \n\t$tree[2 * $size - $in]->{'time'} =$t;\n    }\n   # topology generation\n   for ($in = $size; $in > 1; $in-- ) {\n       my $pick = int $self->random($in);    \n       my $nodeindex = $list[$pick];       \n       my $swap = 2 * $size - $in;       \n       $tree[$swap]->{'desc1'} = $nodeindex;\t\n       $list[$pick] = $list[$in-1];       \n       $pick = int rand($in - 1);    \n       $nodeindex = $list[$pick];\n       $tree[$swap]->{'desc2'} = $nodeindex;\t\n       $list[$pick] = $swap;\n   }\n   # Let's convert the hashes into nodes\n\n   my @nodes = ();   \n   foreach my $n ( @tree ) { \n       push @nodes, \n\t   Bio::Tree::AlleleNode->new(-id => $n->{'nodenum'},\n\t\t\t\t     -branch_length => $n->{'time'});\n   }\n   my $ct = 0;\n   foreach my $node ( @nodes ) { \n       my $n = $tree[$ct++];\n       if( defined $n->{'desc1'} ) {\n\t   $node->add_Descendent($nodes[$n->{'desc1'}]);\n       }\n       if( defined $n->{'desc2'} ) { \n\t   $node->add_Descendent($nodes[$n->{'desc2'}]);\n       }\n   }   \n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n=head2 add_Mutations\n\n Title   : add_Mutations\n Usage   : $factory->add_Mutations($tree, $mutcount);\n Function: Adds mutations to a tree via a random process weighted by \n           branch length (it is a poisson distribution \n\t\t\t  as part of a coalescent process) \n Returns : none\n Args    : $tree - Bio::Tree::TreeI \n           $nummut - number of mutations\n           $precision - optional # of digits for precision","label":"add_Mutations($self,$tree,$nummut,$precision)"},"kind":12,"range":{"start":{"character":0,"line":254},"end":{"line":324,"character":9999}},"line":254},{"line":303,"name":"Bio","containerName":"PopGen::Genotype","kind":12},{"line":318,"name":"Bio","kind":12,"containerName":"PopGen::Genotype"},{"containerName":"main::","name":"maxcount","children":[{"line":338,"containerName":"maxcount","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":338,"kind":13,"containerName":"maxcount","name":"$value"},{"name":"$value","containerName":"maxcount","kind":13,"line":339},{"line":340,"containerName":"maxcount","kind":13,"name":"$value"},{"line":341,"name":"$self","containerName":"maxcount","kind":13},{"line":343,"containerName":"maxcount","kind":13,"name":"$self"},{"kind":12,"containerName":"maxcount","name":"warn","line":343},{"name":"$self","containerName":"maxcount","kind":13,"line":344},{"line":347,"kind":13,"containerName":"maxcount","name":"$self"}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"end":{"line":348,"character":9999},"start":{"line":337,"character":0}},"line":337,"signature":{"documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($maxcount, $samps,$samplesize ) = $self->_rearrange([qw(MAXCOUNT\n\t\t\t\t\t\t\t       SAMPLES\n\t\t\t\t\t\t\t       SAMPLE_SIZE)],\n\t\t\t\t\t\t\t   @args);\n   my @samples;\n   \n   if( ! defined $samps ) { \n       if( ! defined $samplesize || $samplesize <= 0 ) { \n\t   $self->throw(\"Must specify a valid samplesize if parameter -SAMPLE is not specified (sampsize is $samplesize)\");\n       }\n       foreach ( 1..$samplesize ) { push @samples, \"Samp$_\"; }      \n   } else { \n       if( ref($samps) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -SAMPLES, did you forget a leading '\\\\'?\");\n       }\n       @samples = @$samps;\n   }\n   \n   $self->samples(\\@samples);\n   $self->sample_size(scalar @samples);\n   defined $maxcount && $self->maxcount($maxcount);   \n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   # If maxcount is set to something non-zero then next tree will\n   # continue to return valid trees until maxcount is reached\n   # otherwise will always return trees \n   return if( $self->maxcount &&\n\t      $self->{'_treecounter'}++ >= $self->maxcount );\n   my $size = $self->sample_size;\n   \n   my $in;\n   my @tree = ();\n   my @list = ();\n   \n   for($in=0;$in < 2*$size -1; $in++ ) { \n       push @tree, { 'nodenum' => \"Node$in\" };\n   }\n   # in C we would have 2 arrays\n   # an array of nodes (tree)\n   # and array of pointers to these nodes (list)\n   # and we just shuffle the list items to do the \n   # tree topology generation\n   # instead in perl, we will have a list of hashes (nodes) called @tree\n   # and a list of integers representing the indexes in tree called @list\n\n   for($in=0;$in < $size;$in++)  {\n       $tree[$in]->{'time'} = 0;\n       $tree[$in]->{'desc1'} = undef;\n       $tree[$in]->{'desc2'} = undef;\n       push @list, $in;\n   }\n\n   my $t=0;\n   # generate times for the nodes\n   for($in = $size; $in > 1; $in-- ) {\n\t$t+= -2.0 * log(1 - $self->random(1)) / ( $in * ($in-1) );    \n\t$tree[2 * $size - $in]->{'time'} =$t;\n    }\n   # topology generation\n   for ($in = $size; $in > 1; $in-- ) {\n       my $pick = int $self->random($in);    \n       my $nodeindex = $list[$pick];       \n       my $swap = 2 * $size - $in;       \n       $tree[$swap]->{'desc1'} = $nodeindex;\t\n       $list[$pick] = $list[$in-1];       \n       $pick = int rand($in - 1);    \n       $nodeindex = $list[$pick];\n       $tree[$swap]->{'desc2'} = $nodeindex;\t\n       $list[$pick] = $swap;\n   }\n   # Let's convert the hashes into nodes\n\n   my @nodes = ();   \n   foreach my $n ( @tree ) { \n       push @nodes, \n\t   Bio::Tree::AlleleNode->new(-id => $n->{'nodenum'},\n\t\t\t\t     -branch_length => $n->{'time'});\n   }\n   my $ct = 0;\n   foreach my $node ( @nodes ) { \n       my $n = $tree[$ct++];\n       if( defined $n->{'desc1'} ) {\n\t   $node->add_Descendent($nodes[$n->{'desc1'}]);\n       }\n       if( defined $n->{'desc2'} ) { \n\t   $node->add_Descendent($nodes[$n->{'desc2'}]);\n       }\n   }   \n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n=head2 add_Mutations\n\n Title   : add_Mutations\n Usage   : $factory->add_Mutations($tree, $mutcount);\n Function: Adds mutations to a tree via a random process weighted by \n           branch length (it is a poisson distribution \n\t\t\t  as part of a coalescent process) \n Returns : none\n Args    : $tree - Bio::Tree::TreeI \n           $nummut - number of mutations\n           $precision - optional # of digits for precision\n\n\n\nsub add_Mutations{\n   my ($self,$tree, $nummut,$precision) = @_;\n   $precision ||= $PRECISION_DIGITS;\n   $precision = 10**$precision;\n\n   my @branches;\n   my @lens;\n   my $branchlen = 0;\n   my $last = 0;\n   my @nodes = $tree->get_nodes();\n   my $i = 0;\n\n   # Jason's somewhat simplistics way of doing a poission\n   # distribution for a fixed number of mutations\n   # build an array and put the node number in a slot\n   # representing the branch to put a mutation on\n   # but weight the number of slots per branch by the \n   # length of the branch ( ancestor's time - node time)\n   \n   foreach my $node ( @nodes ) {\n       if( $node->ancestor ) { \n\t   my $len = int ( ($node->ancestor->branch_length - \n\t\t\t    $node->branch_length) * $precision);\n\t   if ( $len > 0 ) {\n\t       for( my $j =0;$j < $len;$j++) {\n\t\t   push @branches, $i;\n\t       }\n\t       $last += $len;\n\t   }\n\t   $branchlen += $len;\n       }\n       if( ! $node->isa('Bio::Tree::AlleleNode') ) {\n\t   bless $node, 'Bio::Tree::AlleleNode'; # rebless it to the right node\n       } \n       # This let's us reset the stored genotypes so we can keep reusing the \n       # same tree topology, but throw down mutations multiple times\n       $node->reset_Genotypes;\n       $i++;\n   }\n   # sanity check\n   $self->throw(\"branch len is $branchlen arraylen is $last\")\n        unless ( $branchlen == $last );\n   my @mutations;\n   for( my $j = 0; $j < $nummut; $j++)  {\n       my $index = int(rand($branchlen));\n       my $branch = $branches[$index];\n\n       # We're using an infinite sites model so every new\n       # mutation is a new site\n       my $g = Bio::PopGen::Genotype->new(-marker_name  => \"Mutation$j\",\n\t\t\t\t\t -alleles => [1]);\n       $nodes[$branch]->add_Genotype($g);\n       push @mutations, \"Mutation$j\";\n       # Let's add this mutation to all the children (push it down\n       # the branches to the tips)\n       foreach my $child ( $nodes[$branch]->get_all_Descendents ) {\n\t   $child->add_Genotype($g);\n       }\n   }\n   # Insure that everyone who doesn't have the mutation\n   # has the ancestral state, which is '0'\n   foreach my $node ( @nodes ) {\n       foreach my $m ( @mutations ) {\n\t   if( ! $node->has_Marker($m) ) {\n\t       my $emptyg = Bio::PopGen::Genotype->new(-marker_name => $m,\n\t\t\t\t\t\t      -alleles     => [0]);\n\t       $node->add_Genotype($emptyg);\n\t   }\n       }\n   }\n}\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"maxcount($self,$value)"}},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"samples","children":[{"kind":13,"localvar":"my","containerName":"samples","name":"$self","line":363,"definition":"my"},{"name":"$value","containerName":"samples","kind":13,"line":363},{"containerName":"samples","kind":13,"name":"$value","line":364},{"line":365,"name":"$value","containerName":"samples","kind":13},{"line":366,"name":"$self","kind":13,"containerName":"samples"},{"name":"warn","containerName":"samples","kind":12,"line":366},{"containerName":"samples","kind":13,"name":"$value","line":367},{"line":369,"name":"$self","containerName":"samples","kind":13},{"line":369,"containerName":"samples","kind":13,"name":"$value"},{"line":371,"containerName":"samples","kind":13,"name":"$self"}],"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($maxcount, $samps,$samplesize ) = $self->_rearrange([qw(MAXCOUNT\n\t\t\t\t\t\t\t       SAMPLES\n\t\t\t\t\t\t\t       SAMPLE_SIZE)],\n\t\t\t\t\t\t\t   @args);\n   my @samples;\n   \n   if( ! defined $samps ) { \n       if( ! defined $samplesize || $samplesize <= 0 ) { \n\t   $self->throw(\"Must specify a valid samplesize if parameter -SAMPLE is not specified (sampsize is $samplesize)\");\n       }\n       foreach ( 1..$samplesize ) { push @samples, \"Samp$_\"; }      \n   } else { \n       if( ref($samps) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -SAMPLES, did you forget a leading '\\\\'?\");\n       }\n       @samples = @$samps;\n   }\n   \n   $self->samples(\\@samples);\n   $self->sample_size(scalar @samples);\n   defined $maxcount && $self->maxcount($maxcount);   \n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   # If maxcount is set to something non-zero then next tree will\n   # continue to return valid trees until maxcount is reached\n   # otherwise will always return trees \n   return if( $self->maxcount &&\n\t      $self->{'_treecounter'}++ >= $self->maxcount );\n   my $size = $self->sample_size;\n   \n   my $in;\n   my @tree = ();\n   my @list = ();\n   \n   for($in=0;$in < 2*$size -1; $in++ ) { \n       push @tree, { 'nodenum' => \"Node$in\" };\n   }\n   # in C we would have 2 arrays\n   # an array of nodes (tree)\n   # and array of pointers to these nodes (list)\n   # and we just shuffle the list items to do the \n   # tree topology generation\n   # instead in perl, we will have a list of hashes (nodes) called @tree\n   # and a list of integers representing the indexes in tree called @list\n\n   for($in=0;$in < $size;$in++)  {\n       $tree[$in]->{'time'} = 0;\n       $tree[$in]->{'desc1'} = undef;\n       $tree[$in]->{'desc2'} = undef;\n       push @list, $in;\n   }\n\n   my $t=0;\n   # generate times for the nodes\n   for($in = $size; $in > 1; $in-- ) {\n\t$t+= -2.0 * log(1 - $self->random(1)) / ( $in * ($in-1) );    \n\t$tree[2 * $size - $in]->{'time'} =$t;\n    }\n   # topology generation\n   for ($in = $size; $in > 1; $in-- ) {\n       my $pick = int $self->random($in);    \n       my $nodeindex = $list[$pick];       \n       my $swap = 2 * $size - $in;       \n       $tree[$swap]->{'desc1'} = $nodeindex;\t\n       $list[$pick] = $list[$in-1];       \n       $pick = int rand($in - 1);    \n       $nodeindex = $list[$pick];\n       $tree[$swap]->{'desc2'} = $nodeindex;\t\n       $list[$pick] = $swap;\n   }\n   # Let's convert the hashes into nodes\n\n   my @nodes = ();   \n   foreach my $n ( @tree ) { \n       push @nodes, \n\t   Bio::Tree::AlleleNode->new(-id => $n->{'nodenum'},\n\t\t\t\t     -branch_length => $n->{'time'});\n   }\n   my $ct = 0;\n   foreach my $node ( @nodes ) { \n       my $n = $tree[$ct++];\n       if( defined $n->{'desc1'} ) {\n\t   $node->add_Descendent($nodes[$n->{'desc1'}]);\n       }\n       if( defined $n->{'desc2'} ) { \n\t   $node->add_Descendent($nodes[$n->{'desc2'}]);\n       }\n   }   \n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n=head2 add_Mutations\n\n Title   : add_Mutations\n Usage   : $factory->add_Mutations($tree, $mutcount);\n Function: Adds mutations to a tree via a random process weighted by \n           branch length (it is a poisson distribution \n\t\t\t  as part of a coalescent process) \n Returns : none\n Args    : $tree - Bio::Tree::TreeI \n           $nummut - number of mutations\n           $precision - optional # of digits for precision\n\n\n\nsub add_Mutations{\n   my ($self,$tree, $nummut,$precision) = @_;\n   $precision ||= $PRECISION_DIGITS;\n   $precision = 10**$precision;\n\n   my @branches;\n   my @lens;\n   my $branchlen = 0;\n   my $last = 0;\n   my @nodes = $tree->get_nodes();\n   my $i = 0;\n\n   # Jason's somewhat simplistics way of doing a poission\n   # distribution for a fixed number of mutations\n   # build an array and put the node number in a slot\n   # representing the branch to put a mutation on\n   # but weight the number of slots per branch by the \n   # length of the branch ( ancestor's time - node time)\n   \n   foreach my $node ( @nodes ) {\n       if( $node->ancestor ) { \n\t   my $len = int ( ($node->ancestor->branch_length - \n\t\t\t    $node->branch_length) * $precision);\n\t   if ( $len > 0 ) {\n\t       for( my $j =0;$j < $len;$j++) {\n\t\t   push @branches, $i;\n\t       }\n\t       $last += $len;\n\t   }\n\t   $branchlen += $len;\n       }\n       if( ! $node->isa('Bio::Tree::AlleleNode') ) {\n\t   bless $node, 'Bio::Tree::AlleleNode'; # rebless it to the right node\n       } \n       # This let's us reset the stored genotypes so we can keep reusing the \n       # same tree topology, but throw down mutations multiple times\n       $node->reset_Genotypes;\n       $i++;\n   }\n   # sanity check\n   $self->throw(\"branch len is $branchlen arraylen is $last\")\n        unless ( $branchlen == $last );\n   my @mutations;\n   for( my $j = 0; $j < $nummut; $j++)  {\n       my $index = int(rand($branchlen));\n       my $branch = $branches[$index];\n\n       # We're using an infinite sites model so every new\n       # mutation is a new site\n       my $g = Bio::PopGen::Genotype->new(-marker_name  => \"Mutation$j\",\n\t\t\t\t\t -alleles => [1]);\n       $nodes[$branch]->add_Genotype($g);\n       push @mutations, \"Mutation$j\";\n       # Let's add this mutation to all the children (push it down\n       # the branches to the tips)\n       foreach my $child ( $nodes[$branch]->get_all_Descendents ) {\n\t   $child->add_Genotype($g);\n       }\n   }\n   # Insure that everyone who doesn't have the mutation\n   # has the ancestral state, which is '0'\n   foreach my $node ( @nodes ) {\n       foreach my $m ( @mutations ) {\n\t   if( ! $node->has_Marker($m) ) {\n\t       my $emptyg = Bio::PopGen::Genotype->new(-marker_name => $m,\n\t\t\t\t\t\t      -alleles     => [0]);\n\t       $node->add_Genotype($emptyg);\n\t   }\n       }\n   }\n}\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n=head2 samples\n\n Title   : samples\n Usage   : $obj->samples($newval)\n Function: \n Example : \n Returns : value of samples\n Args    : newvalue (optional)","label":"samples($self,$value)"},"kind":12,"range":{"start":{"line":362,"character":0},"end":{"character":9999,"line":373}},"line":362},{"name":"sample_size","containerName":"main::","children":[{"containerName":"sample_size","localvar":"my","kind":13,"name":"$self","line":388,"definition":"my"},{"name":"$value","kind":13,"containerName":"sample_size","line":388},{"line":389,"kind":13,"containerName":"sample_size","name":"$value"},{"containerName":"sample_size","kind":13,"name":"$self","line":390},{"name":"$value","kind":13,"containerName":"sample_size","line":390},{"line":392,"name":"$self","kind":13,"containerName":"sample_size"}],"detail":"($self,$value)","definition":"sub","range":{"start":{"character":0,"line":387},"end":{"line":394,"character":9999}},"kind":12,"line":387,"signature":{"label":"sample_size($self,$value)","documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($maxcount, $samps,$samplesize ) = $self->_rearrange([qw(MAXCOUNT\n\t\t\t\t\t\t\t       SAMPLES\n\t\t\t\t\t\t\t       SAMPLE_SIZE)],\n\t\t\t\t\t\t\t   @args);\n   my @samples;\n   \n   if( ! defined $samps ) { \n       if( ! defined $samplesize || $samplesize <= 0 ) { \n\t   $self->throw(\"Must specify a valid samplesize if parameter -SAMPLE is not specified (sampsize is $samplesize)\");\n       }\n       foreach ( 1..$samplesize ) { push @samples, \"Samp$_\"; }      \n   } else { \n       if( ref($samps) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -SAMPLES, did you forget a leading '\\\\'?\");\n       }\n       @samples = @$samps;\n   }\n   \n   $self->samples(\\@samples);\n   $self->sample_size(scalar @samples);\n   defined $maxcount && $self->maxcount($maxcount);   \n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   # If maxcount is set to something non-zero then next tree will\n   # continue to return valid trees until maxcount is reached\n   # otherwise will always return trees \n   return if( $self->maxcount &&\n\t      $self->{'_treecounter'}++ >= $self->maxcount );\n   my $size = $self->sample_size;\n   \n   my $in;\n   my @tree = ();\n   my @list = ();\n   \n   for($in=0;$in < 2*$size -1; $in++ ) { \n       push @tree, { 'nodenum' => \"Node$in\" };\n   }\n   # in C we would have 2 arrays\n   # an array of nodes (tree)\n   # and array of pointers to these nodes (list)\n   # and we just shuffle the list items to do the \n   # tree topology generation\n   # instead in perl, we will have a list of hashes (nodes) called @tree\n   # and a list of integers representing the indexes in tree called @list\n\n   for($in=0;$in < $size;$in++)  {\n       $tree[$in]->{'time'} = 0;\n       $tree[$in]->{'desc1'} = undef;\n       $tree[$in]->{'desc2'} = undef;\n       push @list, $in;\n   }\n\n   my $t=0;\n   # generate times for the nodes\n   for($in = $size; $in > 1; $in-- ) {\n\t$t+= -2.0 * log(1 - $self->random(1)) / ( $in * ($in-1) );    \n\t$tree[2 * $size - $in]->{'time'} =$t;\n    }\n   # topology generation\n   for ($in = $size; $in > 1; $in-- ) {\n       my $pick = int $self->random($in);    \n       my $nodeindex = $list[$pick];       \n       my $swap = 2 * $size - $in;       \n       $tree[$swap]->{'desc1'} = $nodeindex;\t\n       $list[$pick] = $list[$in-1];       \n       $pick = int rand($in - 1);    \n       $nodeindex = $list[$pick];\n       $tree[$swap]->{'desc2'} = $nodeindex;\t\n       $list[$pick] = $swap;\n   }\n   # Let's convert the hashes into nodes\n\n   my @nodes = ();   \n   foreach my $n ( @tree ) { \n       push @nodes, \n\t   Bio::Tree::AlleleNode->new(-id => $n->{'nodenum'},\n\t\t\t\t     -branch_length => $n->{'time'});\n   }\n   my $ct = 0;\n   foreach my $node ( @nodes ) { \n       my $n = $tree[$ct++];\n       if( defined $n->{'desc1'} ) {\n\t   $node->add_Descendent($nodes[$n->{'desc1'}]);\n       }\n       if( defined $n->{'desc2'} ) { \n\t   $node->add_Descendent($nodes[$n->{'desc2'}]);\n       }\n   }   \n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n=head2 add_Mutations\n\n Title   : add_Mutations\n Usage   : $factory->add_Mutations($tree, $mutcount);\n Function: Adds mutations to a tree via a random process weighted by \n           branch length (it is a poisson distribution \n\t\t\t  as part of a coalescent process) \n Returns : none\n Args    : $tree - Bio::Tree::TreeI \n           $nummut - number of mutations\n           $precision - optional # of digits for precision\n\n\n\nsub add_Mutations{\n   my ($self,$tree, $nummut,$precision) = @_;\n   $precision ||= $PRECISION_DIGITS;\n   $precision = 10**$precision;\n\n   my @branches;\n   my @lens;\n   my $branchlen = 0;\n   my $last = 0;\n   my @nodes = $tree->get_nodes();\n   my $i = 0;\n\n   # Jason's somewhat simplistics way of doing a poission\n   # distribution for a fixed number of mutations\n   # build an array and put the node number in a slot\n   # representing the branch to put a mutation on\n   # but weight the number of slots per branch by the \n   # length of the branch ( ancestor's time - node time)\n   \n   foreach my $node ( @nodes ) {\n       if( $node->ancestor ) { \n\t   my $len = int ( ($node->ancestor->branch_length - \n\t\t\t    $node->branch_length) * $precision);\n\t   if ( $len > 0 ) {\n\t       for( my $j =0;$j < $len;$j++) {\n\t\t   push @branches, $i;\n\t       }\n\t       $last += $len;\n\t   }\n\t   $branchlen += $len;\n       }\n       if( ! $node->isa('Bio::Tree::AlleleNode') ) {\n\t   bless $node, 'Bio::Tree::AlleleNode'; # rebless it to the right node\n       } \n       # This let's us reset the stored genotypes so we can keep reusing the \n       # same tree topology, but throw down mutations multiple times\n       $node->reset_Genotypes;\n       $i++;\n   }\n   # sanity check\n   $self->throw(\"branch len is $branchlen arraylen is $last\")\n        unless ( $branchlen == $last );\n   my @mutations;\n   for( my $j = 0; $j < $nummut; $j++)  {\n       my $index = int(rand($branchlen));\n       my $branch = $branches[$index];\n\n       # We're using an infinite sites model so every new\n       # mutation is a new site\n       my $g = Bio::PopGen::Genotype->new(-marker_name  => \"Mutation$j\",\n\t\t\t\t\t -alleles => [1]);\n       $nodes[$branch]->add_Genotype($g);\n       push @mutations, \"Mutation$j\";\n       # Let's add this mutation to all the children (push it down\n       # the branches to the tips)\n       foreach my $child ( $nodes[$branch]->get_all_Descendents ) {\n\t   $child->add_Genotype($g);\n       }\n   }\n   # Insure that everyone who doesn't have the mutation\n   # has the ancestral state, which is '0'\n   foreach my $node ( @nodes ) {\n       foreach my $m ( @mutations ) {\n\t   if( ! $node->has_Marker($m) ) {\n\t       my $emptyg = Bio::PopGen::Genotype->new(-marker_name => $m,\n\t\t\t\t\t\t      -alleles     => [0]);\n\t       $node->add_Genotype($emptyg);\n\t   }\n       }\n   }\n}\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n=head2 samples\n\n Title   : samples\n Usage   : $obj->samples($newval)\n Function: \n Example : \n Returns : value of samples\n Args    : newvalue (optional)\n\n\n\nsub samples{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( ref($value) !~ /ARRAY/i ) { \n\t   $self->warn(\"Must specify a valid array ref to the method 'samples'\");\n\t   $value = [];\n       } \n      $self->{'samples'} = $value;\n    }\n    return $self->{'samples'};\n\n}\n\n=head2 sample_size\n\n Title   : sample_size\n Usage   : $obj->sample_size($newval)\n Function: \n Example : \n Returns : value of sample_size\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]}},{"signature":{"documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($maxcount, $samps,$samplesize ) = $self->_rearrange([qw(MAXCOUNT\n\t\t\t\t\t\t\t       SAMPLES\n\t\t\t\t\t\t\t       SAMPLE_SIZE)],\n\t\t\t\t\t\t\t   @args);\n   my @samples;\n   \n   if( ! defined $samps ) { \n       if( ! defined $samplesize || $samplesize <= 0 ) { \n\t   $self->throw(\"Must specify a valid samplesize if parameter -SAMPLE is not specified (sampsize is $samplesize)\");\n       }\n       foreach ( 1..$samplesize ) { push @samples, \"Samp$_\"; }      \n   } else { \n       if( ref($samps) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -SAMPLES, did you forget a leading '\\\\'?\");\n       }\n       @samples = @$samps;\n   }\n   \n   $self->samples(\\@samples);\n   $self->sample_size(scalar @samples);\n   defined $maxcount && $self->maxcount($maxcount);   \n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   # If maxcount is set to something non-zero then next tree will\n   # continue to return valid trees until maxcount is reached\n   # otherwise will always return trees \n   return if( $self->maxcount &&\n\t      $self->{'_treecounter'}++ >= $self->maxcount );\n   my $size = $self->sample_size;\n   \n   my $in;\n   my @tree = ();\n   my @list = ();\n   \n   for($in=0;$in < 2*$size -1; $in++ ) { \n       push @tree, { 'nodenum' => \"Node$in\" };\n   }\n   # in C we would have 2 arrays\n   # an array of nodes (tree)\n   # and array of pointers to these nodes (list)\n   # and we just shuffle the list items to do the \n   # tree topology generation\n   # instead in perl, we will have a list of hashes (nodes) called @tree\n   # and a list of integers representing the indexes in tree called @list\n\n   for($in=0;$in < $size;$in++)  {\n       $tree[$in]->{'time'} = 0;\n       $tree[$in]->{'desc1'} = undef;\n       $tree[$in]->{'desc2'} = undef;\n       push @list, $in;\n   }\n\n   my $t=0;\n   # generate times for the nodes\n   for($in = $size; $in > 1; $in-- ) {\n\t$t+= -2.0 * log(1 - $self->random(1)) / ( $in * ($in-1) );    \n\t$tree[2 * $size - $in]->{'time'} =$t;\n    }\n   # topology generation\n   for ($in = $size; $in > 1; $in-- ) {\n       my $pick = int $self->random($in);    \n       my $nodeindex = $list[$pick];       \n       my $swap = 2 * $size - $in;       \n       $tree[$swap]->{'desc1'} = $nodeindex;\t\n       $list[$pick] = $list[$in-1];       \n       $pick = int rand($in - 1);    \n       $nodeindex = $list[$pick];\n       $tree[$swap]->{'desc2'} = $nodeindex;\t\n       $list[$pick] = $swap;\n   }\n   # Let's convert the hashes into nodes\n\n   my @nodes = ();   \n   foreach my $n ( @tree ) { \n       push @nodes, \n\t   Bio::Tree::AlleleNode->new(-id => $n->{'nodenum'},\n\t\t\t\t     -branch_length => $n->{'time'});\n   }\n   my $ct = 0;\n   foreach my $node ( @nodes ) { \n       my $n = $tree[$ct++];\n       if( defined $n->{'desc1'} ) {\n\t   $node->add_Descendent($nodes[$n->{'desc1'}]);\n       }\n       if( defined $n->{'desc2'} ) { \n\t   $node->add_Descendent($nodes[$n->{'desc2'}]);\n       }\n   }   \n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n=head2 add_Mutations\n\n Title   : add_Mutations\n Usage   : $factory->add_Mutations($tree, $mutcount);\n Function: Adds mutations to a tree via a random process weighted by \n           branch length (it is a poisson distribution \n\t\t\t  as part of a coalescent process) \n Returns : none\n Args    : $tree - Bio::Tree::TreeI \n           $nummut - number of mutations\n           $precision - optional # of digits for precision\n\n\n\nsub add_Mutations{\n   my ($self,$tree, $nummut,$precision) = @_;\n   $precision ||= $PRECISION_DIGITS;\n   $precision = 10**$precision;\n\n   my @branches;\n   my @lens;\n   my $branchlen = 0;\n   my $last = 0;\n   my @nodes = $tree->get_nodes();\n   my $i = 0;\n\n   # Jason's somewhat simplistics way of doing a poission\n   # distribution for a fixed number of mutations\n   # build an array and put the node number in a slot\n   # representing the branch to put a mutation on\n   # but weight the number of slots per branch by the \n   # length of the branch ( ancestor's time - node time)\n   \n   foreach my $node ( @nodes ) {\n       if( $node->ancestor ) { \n\t   my $len = int ( ($node->ancestor->branch_length - \n\t\t\t    $node->branch_length) * $precision);\n\t   if ( $len > 0 ) {\n\t       for( my $j =0;$j < $len;$j++) {\n\t\t   push @branches, $i;\n\t       }\n\t       $last += $len;\n\t   }\n\t   $branchlen += $len;\n       }\n       if( ! $node->isa('Bio::Tree::AlleleNode') ) {\n\t   bless $node, 'Bio::Tree::AlleleNode'; # rebless it to the right node\n       } \n       # This let's us reset the stored genotypes so we can keep reusing the \n       # same tree topology, but throw down mutations multiple times\n       $node->reset_Genotypes;\n       $i++;\n   }\n   # sanity check\n   $self->throw(\"branch len is $branchlen arraylen is $last\")\n        unless ( $branchlen == $last );\n   my @mutations;\n   for( my $j = 0; $j < $nummut; $j++)  {\n       my $index = int(rand($branchlen));\n       my $branch = $branches[$index];\n\n       # We're using an infinite sites model so every new\n       # mutation is a new site\n       my $g = Bio::PopGen::Genotype->new(-marker_name  => \"Mutation$j\",\n\t\t\t\t\t -alleles => [1]);\n       $nodes[$branch]->add_Genotype($g);\n       push @mutations, \"Mutation$j\";\n       # Let's add this mutation to all the children (push it down\n       # the branches to the tips)\n       foreach my $child ( $nodes[$branch]->get_all_Descendents ) {\n\t   $child->add_Genotype($g);\n       }\n   }\n   # Insure that everyone who doesn't have the mutation\n   # has the ancestral state, which is '0'\n   foreach my $node ( @nodes ) {\n       foreach my $m ( @mutations ) {\n\t   if( ! $node->has_Marker($m) ) {\n\t       my $emptyg = Bio::PopGen::Genotype->new(-marker_name => $m,\n\t\t\t\t\t\t      -alleles     => [0]);\n\t       $node->add_Genotype($emptyg);\n\t   }\n       }\n   }\n}\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n=head2 samples\n\n Title   : samples\n Usage   : $obj->samples($newval)\n Function: \n Example : \n Returns : value of samples\n Args    : newvalue (optional)\n\n\n\nsub samples{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( ref($value) !~ /ARRAY/i ) { \n\t   $self->warn(\"Must specify a valid array ref to the method 'samples'\");\n\t   $value = [];\n       } \n      $self->{'samples'} = $value;\n    }\n    return $self->{'samples'};\n\n}\n\n=head2 sample_size\n\n Title   : sample_size\n Usage   : $obj->sample_size($newval)\n Function: \n Example : \n Returns : value of sample_size\n Args    : newvalue (optional)\n\n\n\nsub sample_size{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'sample_size'} = $value;\n    }\n    return $self->{'sample_size'};\n\n}\n\n=head2 random\n\n Title   : random\n Usage   : my $rfloat = $node->random($size)\n Function: Generates a random number between 0 and $size\n           This is abstracted so that someone can override and provide their\n           own special RNG.  This is expected to be a uniform RNG.\n Returns : Floating point random\n Args    : $maximum size for random number (defaults to 1)","parameters":[{"label":"$self"},{"label":"$max"}],"label":"random($self,$max)"},"kind":12,"range":{"start":{"character":0,"line":409},"end":{"line":412,"character":9999}},"line":409,"detail":"($self,$max)","definition":"sub","containerName":"main::","name":"random","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"random","line":410},{"line":410,"containerName":"random","kind":13,"name":"$max"},{"kind":13,"containerName":"random","name":"$max","line":411}]}]}