{"vars":[{"line":85,"name":"vars","containerName":"","kind":2},{"line":88,"name":"strict","containerName":"","kind":2},{"line":88,"containerName":null,"kind":13,"name":"$FieldDelim"},{"name":"$Header","kind":13,"containerName":null,"line":88},{"kind":2,"containerName":"","name":"base","line":95},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"_initialize","children":[{"line":114,"name":"$self","localvar":"my","containerName":"_initialize","kind":13,"definition":"my"},{"containerName":"_initialize","kind":13,"name":"@args","line":114},{"definition":"my","containerName":"_initialize","localvar":"my","kind":13,"name":"$fieldsep","line":115},{"line":116,"name":"$conv_indels","kind":13,"containerName":"_initialize"},{"line":117,"name":"$header","kind":13,"containerName":"_initialize"},{"line":117,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","kind":12,"name":"_rearrange","line":117},{"line":119,"name":"@args","containerName":"_initialize","kind":13},{"name":"$self","kind":13,"containerName":"_initialize","line":121},{"line":121,"kind":12,"containerName":"_initialize","name":"flag"},{"kind":13,"containerName":"_initialize","name":"$header","line":121},{"line":121,"containerName":"_initialize","kind":13,"name":"$header"},{"name":"$Header","containerName":"_initialize","kind":13,"line":121},{"line":122,"name":"$self","containerName":"_initialize","kind":13},{"line":122,"name":"flag","kind":12,"containerName":"_initialize"},{"name":"$fieldsep","containerName":"_initialize","kind":13,"line":122},{"line":122,"containerName":"_initialize","kind":13,"name":"$fieldsep"},{"kind":13,"containerName":"_initialize","name":"$FieldDelim","line":122},{"line":123,"kind":13,"containerName":"_initialize","name":"$self"},{"line":124,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","kind":13,"name":"$self","line":125},{"containerName":"_initialize","kind":13,"name":"$self","line":126},{"name":"flag","kind":12,"containerName":"_initialize","line":126},{"containerName":"_initialize","kind":13,"name":"$conv_indels","line":126}],"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: prettybase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::prettybase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::prettybase - Extract individual allele data from PrettyBase format\n\n=head1 SYNOPSIS\n\nDo not use directly, use through the Bio::PopGen::IO driver\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited PrettyBase output.  PrettyBase\nis defined by the SeattleSNPs http://pga.gs.washington.edu/\n\nThis is expected to be tab delimited (you can vary with the\nfield_delimiter flag SITE SAMPLE ALLELE1 ALLELE2\n\nThere are 2 initialization parameters, the delimiter\n(-field_delimiter) [default 'tab'] and a boolean -no_header which\nspecifies if there is no header line to read in.  All lines starting\nwith '#' will be skipped\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::prettybase;\nuse vars qw($FieldDelim $Header);\nuse strict;\n\n($FieldDelim,$Header) =( '\\t',0);\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::prettybase->new();\n Function: Builds a new Bio::PopGen::IO::prettybase object \n Returns : an instance of Bio::PopGen::IO::prettybase\n Args    : -field_delimiter      => a field delimiter character or regexp (default is /\\t/ ) \n           -header               => boolean if the file will have a header and parser should\n                                    skip first line in the file (default is false)\n           -convert_indel_states => convert alleles which are longer than one character\n                                    to an 'I' meaning insert state, and alleles which are\n                                    '-' to a delete state.\n                                    (default is false)"},"range":{"start":{"character":0,"line":113},"end":{"line":128,"character":9999}},"kind":12,"line":113},{"line":143,"kind":12,"range":{"end":{"character":9999,"line":150},"start":{"line":143,"character":0}},"definition":"sub","children":[{"localvar":"my","containerName":"flag","kind":13,"name":"$self","line":144,"definition":"my"},{"line":145,"name":"$fieldname","localvar":"my","kind":13,"containerName":"flag","definition":"my"},{"line":146,"kind":13,"containerName":"flag","name":"$fieldname"},{"name":"$self","containerName":"flag","kind":13,"line":148},{"line":148,"kind":13,"containerName":"flag","name":"$fieldname"},{"line":149,"containerName":"flag","kind":13,"name":"$self"},{"name":"$fieldname","kind":13,"containerName":"flag","line":149}],"containerName":"main::","name":"flag"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"next_individual","name":"$self","line":165},{"line":166,"name":"$self","containerName":"next_individual","kind":13},{"name":"$self","containerName":"next_individual","kind":13,"line":167},{"name":"_parse_prettybase","containerName":"next_individual","kind":12,"line":167},{"name":"$self","kind":13,"containerName":"next_individual","line":169},{"line":169,"containerName":"next_individual","kind":13,"name":"$self"}],"name":"next_individual","containerName":"main::","signature":{"label":"next_individual($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: prettybase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::prettybase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::prettybase - Extract individual allele data from PrettyBase format\n\n=head1 SYNOPSIS\n\nDo not use directly, use through the Bio::PopGen::IO driver\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited PrettyBase output.  PrettyBase\nis defined by the SeattleSNPs http://pga.gs.washington.edu/\n\nThis is expected to be tab delimited (you can vary with the\nfield_delimiter flag SITE SAMPLE ALLELE1 ALLELE2\n\nThere are 2 initialization parameters, the delimiter\n(-field_delimiter) [default 'tab'] and a boolean -no_header which\nspecifies if there is no header line to read in.  All lines starting\nwith '#' will be skipped\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::prettybase;\nuse vars qw($FieldDelim $Header);\nuse strict;\n\n($FieldDelim,$Header) =( '\\t',0);\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::prettybase->new();\n Function: Builds a new Bio::PopGen::IO::prettybase object \n Returns : an instance of Bio::PopGen::IO::prettybase\n Args    : -field_delimiter      => a field delimiter character or regexp (default is /\\t/ ) \n           -header               => boolean if the file will have a header and parser should\n                                    skip first line in the file (default is false)\n           -convert_indel_states => convert alleles which are longer than one character\n                                    to an 'I' meaning insert state, and alleles which are\n                                    '-' to a delete state.\n                                    (default is false)\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,\n\t$conv_indels,\n\t$header) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t CONVERT_INDEL_STATES\n\t\t\t\t\t HEADER)],@args);\n\n    $self->flag('header', defined $header ? $header : $Header);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->{'_header'} = undef;\n    $self->{'_parsed_individiuals'} = [];\n    $self->{'_parsed'} = 0;\n    $self->flag('convert_indel',$conv_indels || 0);\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : Bio::PopGen::IndividualI object\n Args    : none"},"line":164,"kind":12,"range":{"start":{"character":0,"line":164},"end":{"character":9999,"line":170}}},{"children":[{"definition":"my","line":190,"localvar":"my","kind":13,"containerName":"next_population","name":"$self"},{"name":"@inds","kind":13,"localvar":"my","containerName":"next_population","line":191,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"next_population","name":"$ind","line":192},{"line":192,"containerName":"next_population","kind":13,"name":"$self"},{"name":"next_individual","containerName":"next_population","kind":12,"line":192},{"line":193,"kind":13,"containerName":"next_population","name":"@inds"},{"name":"$ind","containerName":"next_population","kind":13,"line":193},{"containerName":"next_population","kind":13,"name":"@inds","line":195},{"line":196,"name":"new","containerName":"next_population","kind":12},{"containerName":"next_population","kind":13,"name":"@inds","line":196}],"containerName":"main::","name":"next_population","definition":"sub","detail":"($self)","line":189,"kind":12,"range":{"start":{"line":189,"character":0},"end":{"line":197,"character":9999}},"signature":{"documentation":"1;\n# $Id: prettybase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::prettybase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::prettybase - Extract individual allele data from PrettyBase format\n\n=head1 SYNOPSIS\n\nDo not use directly, use through the Bio::PopGen::IO driver\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited PrettyBase output.  PrettyBase\nis defined by the SeattleSNPs http://pga.gs.washington.edu/\n\nThis is expected to be tab delimited (you can vary with the\nfield_delimiter flag SITE SAMPLE ALLELE1 ALLELE2\n\nThere are 2 initialization parameters, the delimiter\n(-field_delimiter) [default 'tab'] and a boolean -no_header which\nspecifies if there is no header line to read in.  All lines starting\nwith '#' will be skipped\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::prettybase;\nuse vars qw($FieldDelim $Header);\nuse strict;\n\n($FieldDelim,$Header) =( '\\t',0);\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::prettybase->new();\n Function: Builds a new Bio::PopGen::IO::prettybase object \n Returns : an instance of Bio::PopGen::IO::prettybase\n Args    : -field_delimiter      => a field delimiter character or regexp (default is /\\t/ ) \n           -header               => boolean if the file will have a header and parser should\n                                    skip first line in the file (default is false)\n           -convert_indel_states => convert alleles which are longer than one character\n                                    to an 'I' meaning insert state, and alleles which are\n                                    '-' to a delete state.\n                                    (default is false)\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,\n\t$conv_indels,\n\t$header) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t CONVERT_INDEL_STATES\n\t\t\t\t\t HEADER)],@args);\n\n    $self->flag('header', defined $header ? $header : $Header);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->{'_header'} = undef;\n    $self->{'_parsed_individiuals'} = [];\n    $self->{'_parsed'} = 0;\n    $self->flag('convert_indel',$conv_indels || 0);\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : Bio::PopGen::IndividualI object\n Args    : none\n\n\n\nsub next_individual {\n    my ($self) = @_;\n    unless( $self->{'_parsed'} ) {\n\t$self->_parse_prettybase;\n    }\n    return $self->{'_parsed_individiuals'}->[$self->{'_iterator'}++];\n}\n\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : Bio::PopGen::PopulationI object\n Args    : none\n Note    : Many implementation will not implement this\n\n Plan is to just return the whole dataset as a single population by\n default I think - people would then have each population in a separate\n file.","parameters":[{"label":"$self"}],"label":"next_population($self)"}},{"name":"Bio","kind":12,"containerName":"PopGen::Population","line":196},{"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_parse_prettybase","name":"$self","line":201},{"definition":"my","name":"%inds","kind":13,"localvar":"my","containerName":"_parse_prettybase","line":202},{"definition":"my","line":203,"name":"$convert_indels","kind":13,"localvar":"my","containerName":"_parse_prettybase"},{"line":203,"name":"$self","kind":13,"containerName":"_parse_prettybase"},{"line":203,"kind":12,"containerName":"_parse_prettybase","name":"flag"},{"name":"$self","containerName":"_parse_prettybase","kind":13,"line":204},{"line":204,"name":"_readline","containerName":"_parse_prettybase","kind":12},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_prettybase","name":"$site","line":207},{"name":"$sample","kind":13,"containerName":"_parse_prettybase","line":207},{"name":"@alleles","kind":13,"containerName":"_parse_prettybase","line":207},{"line":207,"containerName":"_parse_prettybase","kind":13,"name":"$self"},{"line":207,"containerName":"_parse_prettybase","kind":12,"name":"flag"},{"name":"$sample","containerName":"_parse_prettybase","kind":13,"line":208},{"definition":"my","name":"$allele","containerName":"_parse_prettybase","localvar":"my","kind":13,"line":212},{"containerName":"_parse_prettybase","kind":13,"name":"@alleles","line":212},{"containerName":"_parse_prettybase","kind":13,"name":"$allele","line":213},{"name":"$allele","kind":13,"containerName":"_parse_prettybase","line":214},{"line":215,"name":"$convert_indels","containerName":"_parse_prettybase","kind":13},{"kind":13,"containerName":"_parse_prettybase","name":"$allele","line":216},{"line":218,"name":"$allele","kind":13,"containerName":"_parse_prettybase"},{"line":219,"containerName":"_parse_prettybase","kind":13,"name":"$allele"},{"line":221,"containerName":"_parse_prettybase","kind":13,"name":"$allele"},{"definition":"my","line":226,"localvar":"my","containerName":"_parse_prettybase","kind":13,"name":"$g"},{"name":"new","containerName":"_parse_prettybase","kind":12,"line":226},{"name":"@alleles","containerName":"_parse_prettybase","kind":13,"line":226},{"name":"$site","containerName":"_parse_prettybase","kind":13,"line":227},{"line":228,"containerName":"_parse_prettybase","kind":13,"name":"$sample"},{"line":231,"containerName":"_parse_prettybase","kind":13,"name":"$inds"},{"name":"$sample","kind":13,"containerName":"_parse_prettybase","line":231},{"line":232,"kind":13,"containerName":"_parse_prettybase","name":"$inds"},{"line":232,"name":"$sample","kind":13,"containerName":"_parse_prettybase"},{"name":"new","containerName":"_parse_prettybase","kind":12,"line":232},{"line":232,"name":"$sample","kind":13,"containerName":"_parse_prettybase"},{"line":234,"name":"$inds","containerName":"_parse_prettybase","kind":13},{"line":234,"kind":13,"containerName":"_parse_prettybase","name":"$sample"},{"line":234,"name":"add_Genotype","kind":12,"containerName":"_parse_prettybase"},{"line":234,"kind":13,"containerName":"_parse_prettybase","name":"$g"},{"kind":13,"containerName":"_parse_prettybase","name":"$self","line":236},{"line":236,"containerName":"_parse_prettybase","kind":13,"name":"%inds"},{"name":"$self","kind":13,"containerName":"_parse_prettybase","line":237}],"name":"_parse_prettybase","containerName":"main::","line":200,"kind":12,"range":{"start":{"line":200,"character":0},"end":{"character":9999,"line":239}}},{"name":"Bio","containerName":"PopGen::Genotype","kind":12,"line":226},{"containerName":"PopGen::Individual","kind":12,"name":"Bio","line":232},{"range":{"end":{"line":267,"character":9999},"start":{"line":252,"character":0}},"kind":12,"line":252,"signature":{"label":"write_individual($self,@inds)","documentation":"1;\n# $Id: prettybase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::prettybase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::prettybase - Extract individual allele data from PrettyBase format\n\n=head1 SYNOPSIS\n\nDo not use directly, use through the Bio::PopGen::IO driver\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited PrettyBase output.  PrettyBase\nis defined by the SeattleSNPs http://pga.gs.washington.edu/\n\nThis is expected to be tab delimited (you can vary with the\nfield_delimiter flag SITE SAMPLE ALLELE1 ALLELE2\n\nThere are 2 initialization parameters, the delimiter\n(-field_delimiter) [default 'tab'] and a boolean -no_header which\nspecifies if there is no header line to read in.  All lines starting\nwith '#' will be skipped\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::prettybase;\nuse vars qw($FieldDelim $Header);\nuse strict;\n\n($FieldDelim,$Header) =( '\\t',0);\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::prettybase->new();\n Function: Builds a new Bio::PopGen::IO::prettybase object \n Returns : an instance of Bio::PopGen::IO::prettybase\n Args    : -field_delimiter      => a field delimiter character or regexp (default is /\\t/ ) \n           -header               => boolean if the file will have a header and parser should\n                                    skip first line in the file (default is false)\n           -convert_indel_states => convert alleles which are longer than one character\n                                    to an 'I' meaning insert state, and alleles which are\n                                    '-' to a delete state.\n                                    (default is false)\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,\n\t$conv_indels,\n\t$header) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t CONVERT_INDEL_STATES\n\t\t\t\t\t HEADER)],@args);\n\n    $self->flag('header', defined $header ? $header : $Header);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->{'_header'} = undef;\n    $self->{'_parsed_individiuals'} = [];\n    $self->{'_parsed'} = 0;\n    $self->flag('convert_indel',$conv_indels || 0);\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : Bio::PopGen::IndividualI object\n Args    : none\n\n\n\nsub next_individual {\n    my ($self) = @_;\n    unless( $self->{'_parsed'} ) {\n\t$self->_parse_prettybase;\n    }\n    return $self->{'_parsed_individiuals'}->[$self->{'_iterator'}++];\n}\n\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : Bio::PopGen::PopulationI object\n Args    : none\n Note    : Many implementation will not implement this\n\n\n# Plan is to just return the whole dataset as a single population by \n# default I think - people would then have each population in a separate\n# file.\n\nsub next_population{\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    return unless @inds;\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n\nsub _parse_prettybase {\n    my $self = shift;\n    my %inds;\n    my $convert_indels = $self->flag('convert_indel');\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\t\n\tmy ($site,$sample,@alleles) = split($self->flag('field_delimiter'),$_);\n\tif( ! defined $sample ) { \n\t    warn(\"sample id is undefined for $_\");\n\t    next;\n\t}\n\tfor my $allele ( @alleles ) {\n\t    $allele =~ s/^\\s+//;\n\t    $allele =~ s/\\s+$//;\n\t    if( $convert_indels ) {\n\t\tif( length($allele) > 1 ) {\n\t\t    # we have an insert state\n\t\t    $allele = 'I';\n\t\t} elsif( $allele eq '-' ) {\n\t\t    # have a delete state\n\t\t    $allele = 'D';\n\t\t}\n\t    }\n\t}\n\t\n\tmy $g = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t  -marker_name  => $site,\n\t\t\t\t\t  -individual_id=> $sample); \n\t\n\n\tif( ! defined $inds{$sample} ) {\n\t    $inds{$sample} = Bio::PopGen::Individual->new(-unique_id => $sample);\n\t}\n\t$inds{$sample}->add_Genotype($g);\n    }\n    $self->{'_parsed_individiuals'} = [ values %inds ];\n    $self->{'_parsed'} = 1;\n    return;\n}\n\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)","parameters":[{"label":"$self"},{"label":"@inds"}]},"containerName":"main::","name":"write_individual","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"write_individual","kind":13,"line":253},{"line":253,"name":"@inds","containerName":"write_individual","kind":13},{"definition":"my","line":254,"localvar":"my","containerName":"write_individual","kind":13,"name":"$ind"},{"kind":13,"containerName":"write_individual","name":"@inds","line":254},{"name":"$ind","containerName":"write_individual","kind":13,"line":255},{"name":"$ind","kind":13,"containerName":"write_individual","line":255},{"line":255,"kind":12,"containerName":"write_individual","name":"isa"},{"name":"$self","kind":13,"containerName":"write_individual","line":256},{"kind":12,"containerName":"write_individual","name":"warn","line":256},{"definition":"my","line":259,"name":"$marker","kind":13,"localvar":"my","containerName":"write_individual"},{"line":259,"name":"$ind","kind":13,"containerName":"write_individual"},{"kind":12,"containerName":"write_individual","name":"get_marker_names","line":259},{"line":260,"name":"$g","localvar":"my","containerName":"write_individual","kind":13,"definition":"my"},{"kind":13,"containerName":"write_individual","name":"$ind","line":260},{"line":260,"containerName":"write_individual","kind":12,"name":"get_Genotypes"},{"line":260,"name":"$marker","kind":13,"containerName":"write_individual"},{"kind":13,"containerName":"write_individual","name":"$g","line":261},{"line":262,"containerName":"write_individual","kind":13,"name":"$self"},{"name":"_print","containerName":"write_individual","kind":12,"line":262},{"line":262,"name":"$marker","containerName":"write_individual","kind":13},{"line":262,"name":"$ind","kind":13,"containerName":"write_individual"},{"line":262,"kind":12,"containerName":"write_individual","name":"unique_id"},{"name":"$g","containerName":"write_individual","kind":13,"line":263},{"name":"get_Alleles","containerName":"write_individual","kind":12,"line":263}],"detail":"($self,@inds)","definition":"sub"},{"name":"write_population","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"write_population","line":283},{"line":283,"name":"@pops","containerName":"write_population","kind":13},{"definition":"my","name":"$pop","kind":13,"localvar":"my","containerName":"write_population","line":284},{"name":"@pops","kind":13,"containerName":"write_population","line":284},{"line":285,"containerName":"write_population","kind":13,"name":"$pop"},{"kind":13,"containerName":"write_population","name":"$pop","line":285},{"line":285,"containerName":"write_population","kind":12,"name":"isa"},{"containerName":"write_population","kind":13,"name":"$self","line":286},{"line":286,"name":"warn","containerName":"write_population","kind":12},{"name":"@mnames","containerName":"write_population","localvar":"my","kind":13,"line":289,"definition":"my"},{"line":289,"name":"$pop","kind":13,"containerName":"write_population"},{"line":289,"name":"get_marker_names","containerName":"write_population","kind":12},{"definition":"my","kind":13,"localvar":"my","containerName":"write_population","name":"$ind","line":290},{"line":290,"kind":13,"containerName":"write_population","name":"$pop"},{"name":"get_Individuals","containerName":"write_population","kind":12,"line":290},{"containerName":"write_population","kind":13,"name":"$ind","line":291},{"line":291,"containerName":"write_population","kind":13,"name":"$ind"},{"name":"isa","kind":12,"containerName":"write_population","line":291},{"line":292,"containerName":"write_population","kind":13,"name":"$self"},{"containerName":"write_population","kind":12,"name":"warn","line":292},{"definition":"my","name":"$marker","containerName":"write_population","localvar":"my","kind":13,"line":295},{"name":"@mnames","containerName":"write_population","kind":13,"line":295},{"definition":"my","localvar":"my","containerName":"write_population","kind":13,"name":"$g","line":296},{"line":296,"name":"$ind","containerName":"write_population","kind":13},{"kind":12,"containerName":"write_population","name":"get_Genotypes","line":296},{"name":"$marker","kind":13,"containerName":"write_population","line":296},{"containerName":"write_population","kind":13,"name":"$g","line":297},{"name":"$self","containerName":"write_population","kind":13,"line":298},{"name":"_print","containerName":"write_population","kind":12,"line":298},{"line":298,"name":"$marker","kind":13,"containerName":"write_population"},{"name":"$ind","containerName":"write_population","kind":13,"line":298},{"kind":12,"containerName":"write_population","name":"unique_id","line":298},{"line":299,"containerName":"write_population","kind":13,"name":"$g"},{"line":299,"kind":12,"containerName":"write_population","name":"get_Alleles"}],"detail":"($self,@pops)","definition":"sub","kind":12,"range":{"start":{"line":282,"character":0},"end":{"character":9999,"line":304}},"line":282,"signature":{"documentation":"1;\n# $Id: prettybase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::prettybase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::prettybase - Extract individual allele data from PrettyBase format\n\n=head1 SYNOPSIS\n\nDo not use directly, use through the Bio::PopGen::IO driver\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited PrettyBase output.  PrettyBase\nis defined by the SeattleSNPs http://pga.gs.washington.edu/\n\nThis is expected to be tab delimited (you can vary with the\nfield_delimiter flag SITE SAMPLE ALLELE1 ALLELE2\n\nThere are 2 initialization parameters, the delimiter\n(-field_delimiter) [default 'tab'] and a boolean -no_header which\nspecifies if there is no header line to read in.  All lines starting\nwith '#' will be skipped\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::prettybase;\nuse vars qw($FieldDelim $Header);\nuse strict;\n\n($FieldDelim,$Header) =( '\\t',0);\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::prettybase->new();\n Function: Builds a new Bio::PopGen::IO::prettybase object \n Returns : an instance of Bio::PopGen::IO::prettybase\n Args    : -field_delimiter      => a field delimiter character or regexp (default is /\\t/ ) \n           -header               => boolean if the file will have a header and parser should\n                                    skip first line in the file (default is false)\n           -convert_indel_states => convert alleles which are longer than one character\n                                    to an 'I' meaning insert state, and alleles which are\n                                    '-' to a delete state.\n                                    (default is false)\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,\n\t$conv_indels,\n\t$header) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t CONVERT_INDEL_STATES\n\t\t\t\t\t HEADER)],@args);\n\n    $self->flag('header', defined $header ? $header : $Header);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->{'_header'} = undef;\n    $self->{'_parsed_individiuals'} = [];\n    $self->{'_parsed'} = 0;\n    $self->flag('convert_indel',$conv_indels || 0);\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : Bio::PopGen::IndividualI object\n Args    : none\n\n\n\nsub next_individual {\n    my ($self) = @_;\n    unless( $self->{'_parsed'} ) {\n\t$self->_parse_prettybase;\n    }\n    return $self->{'_parsed_individiuals'}->[$self->{'_iterator'}++];\n}\n\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : Bio::PopGen::PopulationI object\n Args    : none\n Note    : Many implementation will not implement this\n\n\n# Plan is to just return the whole dataset as a single population by \n# default I think - people would then have each population in a separate\n# file.\n\nsub next_population{\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    return unless @inds;\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n\nsub _parse_prettybase {\n    my $self = shift;\n    my %inds;\n    my $convert_indels = $self->flag('convert_indel');\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\t\n\tmy ($site,$sample,@alleles) = split($self->flag('field_delimiter'),$_);\n\tif( ! defined $sample ) { \n\t    warn(\"sample id is undefined for $_\");\n\t    next;\n\t}\n\tfor my $allele ( @alleles ) {\n\t    $allele =~ s/^\\s+//;\n\t    $allele =~ s/\\s+$//;\n\t    if( $convert_indels ) {\n\t\tif( length($allele) > 1 ) {\n\t\t    # we have an insert state\n\t\t    $allele = 'I';\n\t\t} elsif( $allele eq '-' ) {\n\t\t    # have a delete state\n\t\t    $allele = 'D';\n\t\t}\n\t    }\n\t}\n\t\n\tmy $g = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t  -marker_name  => $site,\n\t\t\t\t\t  -individual_id=> $sample); \n\t\n\n\tif( ! defined $inds{$sample} ) {\n\t    $inds{$sample} = Bio::PopGen::Individual->new(-unique_id => $sample);\n\t}\n\t$inds{$sample}->add_Genotype($g);\n    }\n    $self->{'_parsed_individiuals'} = [ values %inds ];\n    $self->{'_parsed'} = 1;\n    return;\n}\n\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n\n\nsub write_individual{\n    my ($self,@inds) = @_;\n    foreach my $ind ( @inds ) {\n\tif (! ref($ind) || ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Cannot write an object that is not a Bio::PopGen::IndividualI object\");\n\t    next;\n\t}\n\tforeach my $marker ( $ind->get_marker_names ) { \n\t    my $g = $ind->get_Genotypes(-marker=> $marker);\n\t    next unless defined $g;\n\t    $self->_print( join(\"\\t\", $marker, $ind->unique_id, \n\t\t\t\t$g->get_Alleles), \"\\n\");\t    \n\t}\n    }\n    \n}\n\n\n\n=head2 write_population\n\n Title   : write_population\n Usage   : $popgenio->write_population($pop);\n Function: Write a population out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n Note    : Many implementation will not implement this","parameters":[{"label":"$self"},{"label":"@pops"}],"label":"write_population($self,@pops)"}}],"version":5}