{"vars":[{"kind":2,"containerName":"","name":"vars","line":90},{"line":93,"containerName":"","kind":2,"name":"strict"},{"line":93,"name":"$FieldDelim","containerName":null,"kind":13},{"name":"$AlleleDelim","containerName":null,"kind":13,"line":93},{"line":93,"kind":13,"containerName":null,"name":"$NoHeader"},{"line":102,"kind":2,"containerName":"","name":"base"},{"line":119,"kind":12,"range":{"end":{"character":9999,"line":137},"start":{"line":119,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: phase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::phase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::phase - A parser for Phase format data\n\n=head1 SYNOPSIS\n\n# Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'phase',\n                               -file   => 'data.phase');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing phase data.\n\nPHASE is defined in http://www.stat.washington.edu/stephens/instruct2.1.pdf\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::phase;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,","label":"_initialize($self,@args)"},"children":[{"line":121,"localvar":"my","containerName":"_initialize","kind":13,"name":"$self","definition":"my"},{"line":121,"name":"@args","containerName":"_initialize","kind":13},{"kind":13,"containerName":"_initialize","name":"$Bio","line":123},{"name":"$fieldsep","localvar":"my","containerName":"_initialize","kind":13,"line":125,"definition":"my"},{"line":125,"name":"$all_sep","kind":13,"containerName":"_initialize"},{"line":126,"name":"$noheader","containerName":"_initialize","kind":13},{"line":126,"kind":13,"containerName":"_initialize","name":"$self"},{"line":126,"containerName":"_initialize","kind":12,"name":"_rearrange"},{"name":"@args","kind":13,"containerName":"_initialize","line":128},{"line":130,"name":"$self","kind":13,"containerName":"_initialize"},{"line":130,"name":"flag","containerName":"_initialize","kind":12},{"name":"$noheader","containerName":"_initialize","kind":13,"line":130},{"line":130,"kind":13,"containerName":"_initialize","name":"$noheader"},{"containerName":"_initialize","kind":13,"name":"$NoHeader","line":130},{"kind":13,"containerName":"_initialize","name":"$self","line":131},{"line":131,"kind":12,"containerName":"_initialize","name":"flag"},{"containerName":"_initialize","kind":13,"name":"$fieldsep","line":131},{"line":131,"containerName":"_initialize","kind":13,"name":"$fieldsep"},{"name":"$FieldDelim","containerName":"_initialize","kind":13,"line":131},{"line":132,"kind":13,"containerName":"_initialize","name":"$self"},{"line":132,"kind":12,"containerName":"_initialize","name":"flag"},{"line":132,"name":"$all_sep","containerName":"_initialize","kind":13},{"line":132,"kind":13,"containerName":"_initialize","name":"$all_sep"},{"line":132,"kind":13,"containerName":"_initialize","name":"$AlleleDelim"},{"line":134,"name":"$self","containerName":"_initialize","kind":13}],"containerName":"main::","name":"_initialize","definition":"sub","detail":"($self,@args)"},{"name":"PopGen","kind":12,"containerName":"Genotype::BlankAlleles","line":123},{"definition":"sub","children":[{"name":"$self","localvar":"my","containerName":"flag","kind":13,"line":154,"definition":"my"},{"line":155,"localvar":"my","kind":13,"containerName":"flag","name":"$fieldname","definition":"my"},{"line":156,"kind":13,"containerName":"flag","name":"$fieldname"},{"line":158,"containerName":"flag","kind":13,"name":"$self"},{"line":158,"containerName":"flag","kind":13,"name":"$fieldname"},{"name":"$self","kind":13,"containerName":"flag","line":159},{"name":"$fieldname","containerName":"flag","kind":13,"line":159}],"containerName":"main::","name":"flag","line":152,"range":{"start":{"line":152,"character":0},"end":{"character":9999,"line":161}},"kind":12},{"signature":{"label":"next_individual($self)","documentation":"1;\n# $Id: phase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::phase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::phase - A parser for Phase format data\n\n=head1 SYNOPSIS\n\n# Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'phase',\n                               -file   => 'data.phase');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing phase data.\n\nPHASE is defined in http://www.stat.washington.edu/stephens/instruct2.1.pdf\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::phase;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none","parameters":[{"label":"$self"}]},"line":174,"kind":12,"range":{"start":{"line":174,"character":0},"end":{"line":232,"character":9999}},"definition":"sub","detail":"($self)","children":[{"localvar":"my","kind":13,"containerName":"next_individual","name":"$self","line":175,"definition":"my"},{"line":177,"name":"$sam","kind":13,"localvar":"my","containerName":"next_individual","definition":"my"},{"line":177,"kind":13,"containerName":"next_individual","name":"@marker_results"},{"containerName":"next_individual","kind":13,"name":"$number_of_ids","line":177},{"containerName":"next_individual","kind":13,"name":"$number_of_markers","line":177},{"line":178,"name":"$marker_positions","containerName":"next_individual","kind":13},{"kind":13,"containerName":"next_individual","name":"$micro_snp","line":178},{"line":180,"containerName":"next_individual","kind":13,"name":"$self"},{"line":180,"kind":12,"containerName":"next_individual","name":"_readline"},{"line":186,"kind":13,"containerName":"next_individual","name":"$self"},{"containerName":"next_individual","kind":12,"name":"flag","line":186},{"line":186,"name":"$self","containerName":"next_individual","kind":13},{"name":"$self","containerName":"next_individual","kind":13,"line":191},{"line":192,"kind":13,"containerName":"next_individual","name":"$self"},{"name":"flag","containerName":"next_individual","kind":12,"line":192},{"line":194,"name":"$self","kind":13,"containerName":"next_individual"},{"line":195,"containerName":"next_individual","kind":13,"name":"$self"},{"kind":12,"containerName":"next_individual","name":"next_individual","line":195},{"name":"$self","kind":13,"containerName":"next_individual","line":196},{"line":197,"containerName":"next_individual","kind":13,"name":"$self"},{"line":197,"name":"flag","kind":12,"containerName":"next_individual"},{"name":"$self","containerName":"next_individual","kind":13,"line":199},{"containerName":"next_individual","kind":13,"name":"$self","line":200},{"line":200,"containerName":"next_individual","kind":12,"name":"next_individual"},{"name":"$self","kind":13,"containerName":"next_individual","line":201},{"line":202,"containerName":"next_individual","kind":13,"name":"$self"},{"line":202,"name":"flag","containerName":"next_individual","kind":12},{"line":204,"containerName":"next_individual","kind":13,"name":"$self"},{"line":205,"name":"$self","kind":13,"containerName":"next_individual"},{"containerName":"next_individual","kind":12,"name":"next_individual","line":205},{"containerName":"next_individual","kind":13,"name":"$self","line":206},{"name":"$self","kind":13,"containerName":"next_individual","line":207},{"kind":12,"containerName":"next_individual","name":"flag","line":207},{"line":209,"containerName":"next_individual","kind":13,"name":"$self"},{"line":210,"name":"$self","containerName":"next_individual","kind":13},{"line":210,"name":"next_individual","containerName":"next_individual","kind":12},{"line":212,"name":"$self","kind":13,"containerName":"next_individual"},{"name":"$self","kind":13,"containerName":"next_individual","line":214},{"kind":13,"containerName":"next_individual","name":"$self","line":215},{"name":"next_individual","kind":12,"containerName":"next_individual","line":215},{"line":218,"containerName":"next_individual","kind":13,"name":"$self"},{"line":221,"name":"$self","containerName":"next_individual","kind":13},{"line":222,"kind":13,"containerName":"next_individual","name":"$self"},{"containerName":"next_individual","kind":12,"name":"flag","line":222},{"definition":"my","localvar":"my","containerName":"next_individual","kind":13,"name":"$i","line":224},{"line":224,"name":"$self","containerName":"next_individual","kind":13},{"kind":13,"containerName":"next_individual","name":"$self","line":226},{"containerName":"next_individual","kind":13,"name":"$self","line":227},{"kind":13,"containerName":"next_individual","name":"$i","line":227},{"line":228,"name":"$self","containerName":"next_individual","kind":13},{"line":228,"name":"flag","kind":12,"containerName":"next_individual"},{"line":229,"containerName":"next_individual","kind":13,"name":"$self"},{"line":229,"name":"$i","containerName":"next_individual","kind":13},{"containerName":"next_individual","kind":13,"name":"$self","line":231}],"name":"next_individual","containerName":"main::"},{"name":"%self","containerName":null,"kind":13,"line":234},{"kind":13,"containerName":null,"name":"%self","line":235},{"kind":13,"containerName":null,"name":"$self","line":235},{"name":"flag","kind":12,"containerName":"main::","line":235},{"name":"%self","kind":13,"containerName":null,"line":236},{"line":237,"kind":13,"containerName":null,"name":"$self"},{"line":237,"containerName":"main::","kind":12,"name":"next_individual"},{"definition":"my","name":"$i","kind":13,"localvar":"my","containerName":null,"line":241},{"line":242,"kind":13,"localvar":"my","containerName":null,"name":"$m","definition":"my"},{"line":242,"kind":13,"containerName":null,"name":"%self"},{"name":"$m","containerName":null,"kind":13,"line":243},{"containerName":null,"kind":13,"name":"$m","line":244},{"line":245,"containerName":null,"localvar":"my","kind":13,"name":"$markername","definition":"my"},{"name":"%self","containerName":null,"kind":13,"line":246},{"kind":13,"containerName":null,"name":"$markername","line":247},{"kind":13,"containerName":null,"name":"%self","line":247},{"containerName":null,"kind":13,"name":"%i","line":247},{"name":"$markername","containerName":null,"kind":13,"line":249},{"containerName":null,"kind":13,"name":"$self","line":251},{"line":251,"name":"debug","kind":12,"containerName":"main::"},{"line":252,"name":"@alleles","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":252,"name":"$self","containerName":null,"kind":13},{"name":"flag","kind":12,"containerName":"main::","line":252},{"line":252,"name":"$m","kind":13,"containerName":null},{"line":254,"name":"$m","containerName":null,"kind":13},{"name":"Bio","kind":12,"containerName":"PopGen::Genotype","line":254},{"name":"new","containerName":"main::","kind":12,"line":254},{"line":254,"name":"@alleles","containerName":null,"kind":13},{"line":255,"name":"$markername","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":256},{"line":257,"containerName":null,"kind":13,"name":"$i"},{"containerName":"PopGen::Individual","kind":12,"name":"Bio","line":259},{"line":259,"name":"new","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"%self","line":259},{"containerName":null,"kind":13,"name":"%self","line":260},{"line":265,"containerName":null,"kind":13,"name":"%self"},{"line":265,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"flag","line":265},{"line":266,"containerName":null,"kind":13,"name":"$self"},{"name":"next_individual","containerName":"main::","kind":12,"line":266},{"line":282,"kind":12,"range":{"end":{"character":9999,"line":289},"start":{"character":0,"line":282}},"signature":{"documentation":"1;\n# $Id: phase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::phase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::phase - A parser for Phase format data\n\n=head1 SYNOPSIS\n\n# Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'phase',\n                               -file   => 'data.phase');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing phase data.\n\nPHASE is defined in http://www.stat.washington.edu/stephens/instruct2.1.pdf\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::phase;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual  {\n    my ($self) = @_;\n\n    my ($sam,@marker_results,$number_of_ids,$number_of_markers,\n\t$marker_positions,$micro_snp);\n\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s+$/ || ! length($_) );\n\tlast;\n    }\n    \n    return unless defined $_; \n    if( $self->flag('no_header') || defined $self->{'_header'} ) {\n\n\t####### sometimes there is some marker info at the start of a phase input file\n\t####### we collect it in the next few lines if there is. Should this info be held in a marker object?\n\n\tif(!$self->{'_count'} && /^\\s*\\d+$/){\n\t    $self->flag('number_of_ids',$_);\n\t    #print \"number_of_ids : $number_of_ids\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 1 && /^\\s*\\d+$/){\n\t    $self->flag('number_of_markers',$_);\n\t    #print \"number_of_markers : $number_of_markers\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 2 && /^\\s*P\\s\\d/){\n\t    $self->flag('marker_positions',$_);\n\t    #print \"marker_position : $marker_positions\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 3 && /^\\s*(M|S)+\\s*$/i){\n\t    $self->flag('micro_snp',$_);\n\t    #print \"microsat or snp : $micro_snp\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif(/^\\s*\\#/){\n\t    ($self->{'_sam'}) = /^\\s*\\#(.+)/;\n\t    #print \"sample : $self->{'_sam'}\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} else {\n\t    chomp $_;\n\t    if( $self->{'_row1'} ) {\n\t\t# if we are looking at the 2nd row of alleles for this id\n\n\t\t@{$self->{'_second_row'}} = \n\t\t    split($self->flag('field_delimiter'),$_);\n\n\t\tfor my $i(0 .. $#{$self->{'_first_row'}}){\n\n\t\t    push(@{$self->{'_marker_results'}},\n\t\t\t $self->{'_first_row'}->[$i].\n\t\t\t $self->flag('field_delimiter').\n\t\t\t $self->{'_second_row'}->[$i]);\n\t\t}\n\t\t$self->{'_row1'} = 0;\n\t    } else {\n\t\t# if we are looking at the first row of alleles for this id\n\t\t@{$self->{'_marker_results'}} = ();\n\t\t@{$self->{'_first_row'}} = split($self->flag('field_delimiter'),$_);\n\t\t$self->{'_row1'} = 1;\n\t\treturn $self->next_individual;\n\t    }\n\t}\n\n\tmy $i = 1;\n\tforeach my $m ( @{$self->{'_marker_results'}} ) {\n\t    $m =~ s/^\\s+//;\n\t    $m =~ s/\\s+$//;\n\t    my $markername;\n\t    if( defined $self->{'_header'} ) {\n\t\t$markername = $self->{'_header'}->[$i] || \"Marker$i\";\n\t    } else { \n\t\t$markername = \"Marker$i\";\n\t    }\n\t    $self->debug( \"markername is $markername alleles are $m\\n\");\n\t    my @alleles = split($self->flag('allele_delimiter'), $m);\t\n\n\t    $m = Bio::PopGen::Genotype->new(-alleles      =>\\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $self->{'_sam'}); \n\t    $i++; \n\t}\n\treturn Bio::PopGen::Individual->new(-unique_id => $self->{'_sam'},\n\t\t\t\t\t   -genotypes =>\\@{$self->{'_marker_results'}},\n\t\t\t\t\t   );\n\n    } else {\n\tchomp;\n\t$self->{'_header'} = [split($self->flag('field_delimiter'),$_)];\n\treturn $self->next_individual; # rerun loop again\n    }\n    return;\n}\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this","parameters":[{"label":"$self"}],"label":"next_population($self)"},"children":[{"definition":"my","line":283,"kind":13,"localvar":"my","containerName":"next_population","name":"$self"},{"name":"@inds","localvar":"my","containerName":"next_population","kind":13,"line":284,"definition":"my"},{"line":285,"name":"$ind","localvar":"my","containerName":"next_population","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"next_population","line":285},{"line":285,"containerName":"next_population","kind":12,"name":"next_individual"},{"name":"@inds","kind":13,"containerName":"next_population","line":286},{"line":286,"containerName":"next_population","kind":13,"name":"$ind"},{"line":288,"name":"new","containerName":"next_population","kind":12},{"containerName":"next_population","kind":13,"name":"@inds","line":288}],"containerName":"main::","name":"next_population","definition":"sub","detail":"($self)"},{"line":288,"kind":12,"containerName":"PopGen::Population","name":"Bio"},{"detail":"($self,@inds)","definition":"sub","containerName":"main::","name":"write_individual","children":[{"definition":"my","line":303,"kind":13,"localvar":"my","containerName":"write_individual","name":"$self"},{"name":"@inds","kind":13,"containerName":"write_individual","line":303},{"name":"$fielddelim","kind":13,"localvar":"my","containerName":"write_individual","line":304,"definition":"my"},{"line":304,"name":"$self","kind":13,"containerName":"write_individual"},{"line":304,"name":"flag","kind":12,"containerName":"write_individual"},{"definition":"my","localvar":"my","containerName":"write_individual","kind":13,"name":"$alleledelim","line":305},{"line":305,"name":"$self","containerName":"write_individual","kind":13},{"line":305,"name":"flag","kind":12,"containerName":"write_individual"},{"line":307,"localvar":"my","kind":13,"containerName":"write_individual","name":"$ind","definition":"my"},{"line":307,"name":"@inds","kind":13,"containerName":"write_individual"},{"line":308,"name":"$ind","containerName":"write_individual","kind":13},{"line":308,"containerName":"write_individual","kind":13,"name":"$ind"},{"line":308,"name":"isa","containerName":"write_individual","kind":12},{"kind":13,"containerName":"write_individual","name":"$self","line":309},{"kind":12,"containerName":"write_individual","name":"warn","line":309},{"localvar":"my","containerName":"write_individual","kind":13,"name":"@marker_names","line":314,"definition":"my"},{"containerName":"write_individual","kind":13,"name":"$ind","line":314},{"name":"get_marker_names","containerName":"write_individual","kind":12,"line":314},{"line":315,"name":"$self","kind":13,"containerName":"write_individual"},{"name":"flag","kind":12,"containerName":"write_individual","line":315},{"line":316,"name":"$self","kind":13,"containerName":"write_individual"},{"line":316,"name":"flag","kind":12,"containerName":"write_individual"},{"line":317,"kind":13,"containerName":"write_individual","name":"$self"},{"name":"_print","containerName":"write_individual","kind":12,"line":317},{"name":"$fielddelim","containerName":"write_individual","kind":13,"line":317},{"kind":13,"containerName":"write_individual","name":"@marker_names","line":317},{"line":318,"name":"$self","containerName":"write_individual","kind":13},{"name":"flag","containerName":"write_individual","kind":12,"line":318},{"definition":"my","localvar":"my","containerName":"write_individual","kind":13,"name":"@row1","line":321},{"line":321,"name":"@row2","kind":13,"containerName":"write_individual"},{"line":323,"kind":13,"containerName":"write_individual","name":"@marker_names"},{"line":324,"name":"$geno","kind":13,"localvar":"my","containerName":"write_individual","definition":"my"},{"line":324,"name":"$ind","kind":13,"containerName":"write_individual"},{"name":"get_Genotypes","kind":12,"containerName":"write_individual","line":324},{"name":"@alleles","containerName":"write_individual","localvar":"my","kind":13,"line":325,"definition":"my"},{"line":325,"name":"$geno","containerName":"write_individual","kind":13},{"kind":12,"containerName":"write_individual","name":"get_Alleles","line":325},{"line":326,"name":"@row1","kind":13,"containerName":"write_individual"},{"containerName":"write_individual","kind":13,"name":"$alleles","line":326},{"line":327,"name":"@row2","containerName":"write_individual","kind":13},{"name":"$alleles","containerName":"write_individual","kind":13,"line":327},{"name":"$self","containerName":"write_individual","kind":13,"line":329},{"name":"_print","kind":12,"containerName":"write_individual","line":329},{"kind":13,"containerName":"write_individual","name":"$ind","line":329},{"line":329,"kind":12,"containerName":"write_individual","name":"unique_id"},{"name":"$fielddelim","containerName":"write_individual","kind":13,"line":330},{"line":330,"containerName":"write_individual","kind":13,"name":"@row1"},{"name":"$fielddelim","kind":13,"containerName":"write_individual","line":331},{"containerName":"write_individual","kind":13,"name":"@row2","line":331}],"signature":{"documentation":"1;\n# $Id: phase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::phase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::phase - A parser for Phase format data\n\n=head1 SYNOPSIS\n\n# Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'phase',\n                               -file   => 'data.phase');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing phase data.\n\nPHASE is defined in http://www.stat.washington.edu/stephens/instruct2.1.pdf\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::phase;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual  {\n    my ($self) = @_;\n\n    my ($sam,@marker_results,$number_of_ids,$number_of_markers,\n\t$marker_positions,$micro_snp);\n\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s+$/ || ! length($_) );\n\tlast;\n    }\n    \n    return unless defined $_; \n    if( $self->flag('no_header') || defined $self->{'_header'} ) {\n\n\t####### sometimes there is some marker info at the start of a phase input file\n\t####### we collect it in the next few lines if there is. Should this info be held in a marker object?\n\n\tif(!$self->{'_count'} && /^\\s*\\d+$/){\n\t    $self->flag('number_of_ids',$_);\n\t    #print \"number_of_ids : $number_of_ids\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 1 && /^\\s*\\d+$/){\n\t    $self->flag('number_of_markers',$_);\n\t    #print \"number_of_markers : $number_of_markers\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 2 && /^\\s*P\\s\\d/){\n\t    $self->flag('marker_positions',$_);\n\t    #print \"marker_position : $marker_positions\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 3 && /^\\s*(M|S)+\\s*$/i){\n\t    $self->flag('micro_snp',$_);\n\t    #print \"microsat or snp : $micro_snp\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif(/^\\s*\\#/){\n\t    ($self->{'_sam'}) = /^\\s*\\#(.+)/;\n\t    #print \"sample : $self->{'_sam'}\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} else {\n\t    chomp $_;\n\t    if( $self->{'_row1'} ) {\n\t\t# if we are looking at the 2nd row of alleles for this id\n\n\t\t@{$self->{'_second_row'}} = \n\t\t    split($self->flag('field_delimiter'),$_);\n\n\t\tfor my $i(0 .. $#{$self->{'_first_row'}}){\n\n\t\t    push(@{$self->{'_marker_results'}},\n\t\t\t $self->{'_first_row'}->[$i].\n\t\t\t $self->flag('field_delimiter').\n\t\t\t $self->{'_second_row'}->[$i]);\n\t\t}\n\t\t$self->{'_row1'} = 0;\n\t    } else {\n\t\t# if we are looking at the first row of alleles for this id\n\t\t@{$self->{'_marker_results'}} = ();\n\t\t@{$self->{'_first_row'}} = split($self->flag('field_delimiter'),$_);\n\t\t$self->{'_row1'} = 1;\n\t\treturn $self->next_individual;\n\t    }\n\t}\n\n\tmy $i = 1;\n\tforeach my $m ( @{$self->{'_marker_results'}} ) {\n\t    $m =~ s/^\\s+//;\n\t    $m =~ s/\\s+$//;\n\t    my $markername;\n\t    if( defined $self->{'_header'} ) {\n\t\t$markername = $self->{'_header'}->[$i] || \"Marker$i\";\n\t    } else { \n\t\t$markername = \"Marker$i\";\n\t    }\n\t    $self->debug( \"markername is $markername alleles are $m\\n\");\n\t    my @alleles = split($self->flag('allele_delimiter'), $m);\t\n\n\t    $m = Bio::PopGen::Genotype->new(-alleles      =>\\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $self->{'_sam'}); \n\t    $i++; \n\t}\n\treturn Bio::PopGen::Individual->new(-unique_id => $self->{'_sam'},\n\t\t\t\t\t   -genotypes =>\\@{$self->{'_marker_results'}},\n\t\t\t\t\t   );\n\n    } else {\n\tchomp;\n\t$self->{'_header'} = [split($self->flag('field_delimiter'),$_)];\n\treturn $self->next_individual; # rerun loop again\n    }\n    return;\n}\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this\n\n\nsub next_population{\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)","parameters":[{"label":"$self"},{"label":"@inds"}],"label":"write_individual($self,@inds)"},"kind":12,"range":{"end":{"character":9999,"line":333},"start":{"line":302,"character":0}},"line":302},{"detail":"($self,@pops)","definition":"sub","name":"write_population","containerName":"main::","children":[{"definition":"my","line":348,"kind":13,"localvar":"my","containerName":"write_population","name":"$self"},{"containerName":"write_population","kind":13,"name":"@pops","line":348},{"line":349,"name":"$fielddelim","kind":13,"localvar":"my","containerName":"write_population","definition":"my"},{"line":349,"kind":13,"containerName":"write_population","name":"$self"},{"line":349,"kind":12,"containerName":"write_population","name":"flag"},{"line":350,"localvar":"my","kind":13,"containerName":"write_population","name":"$alleledelim","definition":"my"},{"line":350,"containerName":"write_population","kind":13,"name":"$self"},{"name":"flag","containerName":"write_population","kind":12,"line":350},{"line":352,"name":"$pop","kind":13,"localvar":"my","containerName":"write_population","definition":"my"},{"name":"@pops","containerName":"write_population","kind":13,"line":352},{"line":353,"kind":13,"containerName":"write_population","name":"$pop"},{"name":"$pop","containerName":"write_population","kind":13,"line":353},{"line":353,"name":"isa","containerName":"write_population","kind":12},{"line":354,"name":"$self","containerName":"write_population","kind":13},{"name":"warn","kind":12,"containerName":"write_population","line":354},{"line":359,"name":"@marker_names","localvar":"my","kind":13,"containerName":"write_population","definition":"my"},{"line":359,"containerName":"write_population","kind":13,"name":"$pop"},{"name":"get_marker_names","containerName":"write_population","kind":12,"line":359},{"containerName":"write_population","kind":13,"name":"$self","line":360},{"kind":12,"containerName":"write_population","name":"flag","line":360},{"line":361,"kind":13,"containerName":"write_population","name":"$self"},{"name":"flag","kind":12,"containerName":"write_population","line":361},{"name":"$self","kind":13,"containerName":"write_population","line":362},{"line":362,"kind":12,"containerName":"write_population","name":"_print"},{"line":362,"containerName":"write_population","kind":13,"name":"$fielddelim"},{"line":362,"name":"@marker_names","containerName":"write_population","kind":13},{"name":"$self","kind":13,"containerName":"write_population","line":364},{"line":364,"kind":12,"containerName":"write_population","name":"flag"},{"localvar":"my","kind":13,"containerName":"write_population","name":"$ind","line":366,"definition":"my"},{"line":366,"name":"$pop","kind":13,"containerName":"write_population"},{"containerName":"write_population","kind":12,"name":"get_Individuals","line":366},{"definition":"my","localvar":"my","kind":13,"containerName":"write_population","name":"@row1","line":367},{"name":"@row2","kind":13,"containerName":"write_population","line":367},{"line":368,"containerName":"write_population","kind":13,"name":"@marker_names"},{"line":369,"name":"$geno","kind":13,"localvar":"my","containerName":"write_population","definition":"my"},{"containerName":"write_population","kind":13,"name":"$ind","line":369},{"line":369,"containerName":"write_population","kind":12,"name":"get_Genotypes"},{"definition":"my","name":"@alleles","kind":13,"localvar":"my","containerName":"write_population","line":370},{"name":"$geno","kind":13,"containerName":"write_population","line":370},{"line":370,"containerName":"write_population","kind":12,"name":"get_Alleles"},{"line":371,"kind":13,"containerName":"write_population","name":"@row1"},{"line":371,"name":"$alleles","kind":13,"containerName":"write_population"},{"line":372,"name":"@row2","containerName":"write_population","kind":13},{"name":"$alleles","containerName":"write_population","kind":13,"line":372},{"line":374,"name":"$self","kind":13,"containerName":"write_population"},{"kind":12,"containerName":"write_population","name":"_print","line":374},{"containerName":"write_population","kind":13,"name":"$ind","line":374},{"kind":12,"containerName":"write_population","name":"unique_id","line":374},{"name":"$fielddelim","kind":13,"containerName":"write_population","line":375},{"kind":13,"containerName":"write_population","name":"@row1","line":375},{"line":376,"containerName":"write_population","kind":13,"name":"$fielddelim"},{"line":376,"name":"@row2","kind":13,"containerName":"write_population"}],"signature":{"label":"write_population($self,@pops)","parameters":[{"label":"$self"},{"label":"@pops"}],"documentation":"1;\n# $Id: phase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::phase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::phase - A parser for Phase format data\n\n=head1 SYNOPSIS\n\n# Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'phase',\n                               -file   => 'data.phase');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing phase data.\n\nPHASE is defined in http://www.stat.washington.edu/stephens/instruct2.1.pdf\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::phase;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual  {\n    my ($self) = @_;\n\n    my ($sam,@marker_results,$number_of_ids,$number_of_markers,\n\t$marker_positions,$micro_snp);\n\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s+$/ || ! length($_) );\n\tlast;\n    }\n    \n    return unless defined $_; \n    if( $self->flag('no_header') || defined $self->{'_header'} ) {\n\n\t####### sometimes there is some marker info at the start of a phase input file\n\t####### we collect it in the next few lines if there is. Should this info be held in a marker object?\n\n\tif(!$self->{'_count'} && /^\\s*\\d+$/){\n\t    $self->flag('number_of_ids',$_);\n\t    #print \"number_of_ids : $number_of_ids\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 1 && /^\\s*\\d+$/){\n\t    $self->flag('number_of_markers',$_);\n\t    #print \"number_of_markers : $number_of_markers\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 2 && /^\\s*P\\s\\d/){\n\t    $self->flag('marker_positions',$_);\n\t    #print \"marker_position : $marker_positions\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 3 && /^\\s*(M|S)+\\s*$/i){\n\t    $self->flag('micro_snp',$_);\n\t    #print \"microsat or snp : $micro_snp\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif(/^\\s*\\#/){\n\t    ($self->{'_sam'}) = /^\\s*\\#(.+)/;\n\t    #print \"sample : $self->{'_sam'}\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} else {\n\t    chomp $_;\n\t    if( $self->{'_row1'} ) {\n\t\t# if we are looking at the 2nd row of alleles for this id\n\n\t\t@{$self->{'_second_row'}} = \n\t\t    split($self->flag('field_delimiter'),$_);\n\n\t\tfor my $i(0 .. $#{$self->{'_first_row'}}){\n\n\t\t    push(@{$self->{'_marker_results'}},\n\t\t\t $self->{'_first_row'}->[$i].\n\t\t\t $self->flag('field_delimiter').\n\t\t\t $self->{'_second_row'}->[$i]);\n\t\t}\n\t\t$self->{'_row1'} = 0;\n\t    } else {\n\t\t# if we are looking at the first row of alleles for this id\n\t\t@{$self->{'_marker_results'}} = ();\n\t\t@{$self->{'_first_row'}} = split($self->flag('field_delimiter'),$_);\n\t\t$self->{'_row1'} = 1;\n\t\treturn $self->next_individual;\n\t    }\n\t}\n\n\tmy $i = 1;\n\tforeach my $m ( @{$self->{'_marker_results'}} ) {\n\t    $m =~ s/^\\s+//;\n\t    $m =~ s/\\s+$//;\n\t    my $markername;\n\t    if( defined $self->{'_header'} ) {\n\t\t$markername = $self->{'_header'}->[$i] || \"Marker$i\";\n\t    } else { \n\t\t$markername = \"Marker$i\";\n\t    }\n\t    $self->debug( \"markername is $markername alleles are $m\\n\");\n\t    my @alleles = split($self->flag('allele_delimiter'), $m);\t\n\n\t    $m = Bio::PopGen::Genotype->new(-alleles      =>\\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $self->{'_sam'}); \n\t    $i++; \n\t}\n\treturn Bio::PopGen::Individual->new(-unique_id => $self->{'_sam'},\n\t\t\t\t\t   -genotypes =>\\@{$self->{'_marker_results'}},\n\t\t\t\t\t   );\n\n    } else {\n\tchomp;\n\t$self->{'_header'} = [split($self->flag('field_delimiter'),$_)];\n\treturn $self->next_individual; # rerun loop again\n    }\n    return;\n}\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this\n\n\nsub next_population{\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n\n\n\nsub write_individual {\n    my ($self,@inds) = @_;\n    my $fielddelim  = $self->flag('field_delimiter');\n    my $alleledelim = $self->flag('allele_delimiter');\n\n    foreach my $ind ( @inds ) {\n\tif (! ref($ind) || ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Cannot write an object that is not a Bio::PopGen::IndividualI object ($ind)\");\n\t    next;\n\t}\n\t# we'll go ahead and sort these until\n\t# we have a better way to insure a consistent order\n\tmy @marker_names = sort $ind->get_marker_names;\n\tif( ! $self->flag('no_header') && \n\t    ! $self->flag('header_written') ) {\n\t    $self->_print(join($fielddelim, ('SAM', @marker_names)), \"\\n\");\n\t    $self->flag('header_written',1);\n\t}\n\n\tmy(@row1,@row2);\n\n\tfor (@marker_names){\n\t    my $geno = $ind->get_Genotypes(-marker => $_);\n\t    my @alleles = $geno->get_Alleles();\n\t    push(@row1,$alleles[0]);\n\t    push(@row2,$alleles[1]);\n\t}\n\t$self->_print(\"#\",$ind->unique_id,\"\\n\",\n\t\t      join($fielddelim,@row1),\"\\n\",\n\t\t      join($fielddelim,@row2),\"\\n\");\n    }\n}\n\n=head2 write_population\n\n Title   : write_population\n Usage   : $popgenio->write_population($pop);\n Function: Write a population out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n Note    : Many implementation will not implement this"},"kind":12,"range":{"end":{"character":9999,"line":379},"start":{"character":0,"line":347}},"line":347}],"version":5}