{"vars":[{"name":"vars","containerName":"","kind":2,"line":86},{"line":89,"name":"strict","kind":2,"containerName":""},{"line":89,"containerName":null,"kind":13,"name":"$FieldDelim"},{"line":89,"containerName":null,"kind":13,"name":"$AlleleDelim"},{"line":89,"name":"$NoHeader","kind":13,"containerName":null},{"line":89,"name":"$StartingCol","containerName":null,"kind":13},{"containerName":"","kind":2,"name":"base","line":95},{"kind":12,"range":{"start":{"character":0,"line":113},"end":{"character":9999,"line":134}},"line":113,"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: hapmap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::hapmap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::hapmap - A parser for HapMap output data\n\n=head1 SYNOPSIS\n\n  # Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'hapmap',\n                               -file   => 'data.hapmap');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing hapmap data.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::IO::hapmap;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader $StartingCol);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader,$StartingCol) =( '\\s+','',0,11);\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n           -starting_column => 11"},"containerName":"main::","name":"_initialize","children":[{"definition":"my","line":115,"name":"$self","localvar":"my","containerName":"_initialize","kind":13},{"name":"@args","kind":13,"containerName":"_initialize","line":115},{"containerName":"_initialize","kind":13,"name":"$Bio","line":117},{"line":119,"name":"$fieldsep","kind":13,"localvar":"my","containerName":"_initialize","definition":"my"},{"line":119,"kind":13,"containerName":"_initialize","name":"$all_sep"},{"line":120,"name":"$noheader","containerName":"_initialize","kind":13},{"name":"$start_col","kind":13,"containerName":"_initialize","line":120},{"containerName":"_initialize","kind":13,"name":"$self","line":120},{"line":120,"name":"_rearrange","containerName":"_initialize","kind":12},{"line":124,"name":"@args","containerName":"_initialize","kind":13},{"line":126,"name":"$self","containerName":"_initialize","kind":13},{"kind":12,"containerName":"_initialize","name":"flag","line":126},{"kind":13,"containerName":"_initialize","name":"$noheader","line":126},{"line":126,"kind":13,"containerName":"_initialize","name":"$noheader"},{"line":126,"name":"$NoHeader","kind":13,"containerName":"_initialize"},{"line":127,"name":"$self","containerName":"_initialize","kind":13},{"line":127,"kind":12,"containerName":"_initialize","name":"flag"},{"line":127,"name":"$fieldsep","containerName":"_initialize","kind":13},{"line":127,"containerName":"_initialize","kind":13,"name":"$fieldsep"},{"kind":13,"containerName":"_initialize","name":"$FieldDelim","line":127},{"line":128,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"flag","containerName":"_initialize","kind":12,"line":128},{"kind":13,"containerName":"_initialize","name":"$all_sep","line":128},{"line":128,"containerName":"_initialize","kind":13,"name":"$all_sep"},{"kind":13,"containerName":"_initialize","name":"$AlleleDelim","line":128},{"name":"$self","kind":13,"containerName":"_initialize","line":129},{"name":"starting_column","kind":12,"containerName":"_initialize","line":129},{"name":"$start_col","kind":13,"containerName":"_initialize","line":129},{"containerName":"_initialize","kind":13,"name":"$start_col","line":129},{"name":"$StartingCol","kind":13,"containerName":"_initialize","line":129},{"kind":13,"containerName":"_initialize","name":"$self","line":131}],"detail":"($self,@args)","definition":"sub"},{"name":"PopGen","kind":12,"containerName":"Genotype::BlankAlleles","line":117},{"range":{"end":{"line":156,"character":9999},"start":{"character":0,"line":148}},"kind":12,"line":148,"definition":"sub","name":"flag","containerName":"main::","children":[{"line":150,"name":"$self","localvar":"my","containerName":"flag","kind":13,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"flag","name":"$fieldname","line":151},{"line":152,"kind":13,"containerName":"flag","name":"$fieldname"},{"line":153,"containerName":"flag","kind":13,"name":"$self"},{"name":"$fieldname","containerName":"flag","kind":13,"line":153},{"kind":13,"containerName":"flag","name":"$self","line":154},{"name":"$fieldname","containerName":"flag","kind":13,"line":154}]},{"detail":"($self)","definition":"sub","containerName":"main::","name":"_pivot","children":[{"definition":"my","localvar":"my","containerName":"_pivot","kind":13,"name":"$self","line":159},{"definition":"my","kind":13,"localvar":"my","containerName":"_pivot","name":"@cols","line":161},{"line":161,"name":"@rows","kind":13,"containerName":"_pivot"},{"containerName":"_pivot","kind":13,"name":"@idheader","line":161},{"line":162,"kind":13,"containerName":"_pivot","name":"$self"},{"line":162,"name":"_readline","containerName":"_pivot","kind":12},{"line":166,"kind":13,"containerName":"_pivot","name":"@idheader"},{"line":166,"name":"$self","kind":13,"containerName":"_pivot"},{"line":166,"containerName":"_pivot","kind":12,"name":"flag"},{"line":168,"name":"@cols","kind":13,"containerName":"_pivot"},{"line":168,"name":"$self","containerName":"_pivot","kind":13},{"name":"flag","containerName":"_pivot","kind":12,"line":168},{"kind":13,"localvar":"my","containerName":"_pivot","name":"$startingcol","line":171,"definition":"my"},{"line":171,"kind":13,"containerName":"_pivot","name":"$self"},{"kind":12,"containerName":"_pivot","name":"starting_column","line":171},{"name":"$self","containerName":"_pivot","kind":13,"line":173},{"kind":13,"containerName":"_pivot","name":"@cols","line":173},{"definition":"my","line":174,"localvar":"my","containerName":"_pivot","kind":13,"name":"$n"},{"line":174,"name":"$startingcol","containerName":"_pivot","kind":13},{"name":"$cols","kind":13,"containerName":"_pivot","line":174}],"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_pivot($self)"},"range":{"end":{"line":174,"character":9999},"start":{"character":0,"line":158}},"kind":12,"line":158},{"definition":"my","line":175,"kind":13,"localvar":"my","containerName":null,"name":"@column"},{"line":175,"name":"@idheader","containerName":null,"kind":13},{"name":"%n","containerName":null,"kind":13,"line":175},{"name":"$n","containerName":null,"kind":13,"line":176},{"line":176,"kind":13,"containerName":null,"name":"@cols"},{"name":"@rows","containerName":null,"kind":13,"line":177},{"name":"$column","containerName":null,"kind":13,"line":177},{"kind":13,"containerName":null,"name":"%self","line":179},{"containerName":null,"kind":13,"name":"@rows","line":179},{"containerName":null,"kind":13,"name":"%self","line":180},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"next_individual","line":197},{"line":198,"name":"$self","containerName":"next_individual","kind":13},{"line":201,"name":"$self","kind":13,"containerName":"next_individual"},{"containerName":"next_individual","kind":12,"name":"_pivot","line":201},{"line":204,"containerName":"next_individual","kind":13,"name":"$self"},{"line":204,"kind":13,"containerName":"next_individual","name":"$self"},{"definition":"my","localvar":"my","containerName":"next_individual","kind":13,"name":"$samp","line":213},{"line":213,"name":"@marker_results","kind":13,"containerName":"next_individual"},{"containerName":"next_individual","kind":13,"name":"$_","line":213},{"line":216,"name":"$i","kind":13,"localvar":"my","containerName":"next_individual","definition":"my"},{"containerName":"next_individual","localvar":"my","kind":13,"name":"$m","line":217,"definition":"my"},{"line":217,"containerName":"next_individual","kind":13,"name":"@marker_results"},{"line":218,"containerName":"next_individual","kind":13,"name":"$m"},{"name":"$m","kind":13,"containerName":"next_individual","line":219},{"line":220,"localvar":"my","kind":13,"containerName":"next_individual","name":"$markername","definition":"my"},{"name":"$self","containerName":"next_individual","kind":13,"line":221},{"line":222,"name":"$markername","kind":13,"containerName":"next_individual"},{"line":222,"kind":13,"containerName":"next_individual","name":"$self"},{"kind":13,"containerName":"next_individual","name":"$i","line":222},{"name":"$markername","kind":13,"containerName":"next_individual","line":224},{"kind":13,"localvar":"my","containerName":"next_individual","name":"@alleles","line":227,"definition":"my"},{"name":"$self","kind":13,"containerName":"next_individual","line":227},{"containerName":"next_individual","kind":12,"name":"flag","line":227},{"line":227,"kind":13,"containerName":"next_individual","name":"$m"},{"name":"@alleles","kind":13,"containerName":"next_individual","line":228},{"line":229,"kind":13,"containerName":"next_individual","name":"$self"},{"line":229,"containerName":"next_individual","kind":12,"name":"warn"},{"name":"$m","containerName":"next_individual","kind":13,"line":231},{"name":"new","kind":12,"containerName":"next_individual","line":231},{"line":231,"name":"@alleles","kind":13,"containerName":"next_individual"},{"kind":13,"containerName":"next_individual","name":"$markername","line":232},{"name":"$samp","containerName":"next_individual","kind":13,"line":233},{"line":235,"kind":13,"containerName":"next_individual","name":"$i"},{"line":238,"kind":13,"containerName":"next_individual","name":"$samp"},{"name":"@marker_results","containerName":"next_individual","kind":13,"line":239}],"name":"next_individual","containerName":"main::","definition":"sub","detail":"($self)","line":196,"kind":12,"range":{"start":{"character":0,"line":196},"end":{"line":241,"character":9999}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: hapmap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::hapmap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::hapmap - A parser for HapMap output data\n\n=head1 SYNOPSIS\n\n  # Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'hapmap',\n                               -file   => 'data.hapmap');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing hapmap data.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::IO::hapmap;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader $StartingCol);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader,$StartingCol) =( '\\s+','',0,11);\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n           -starting_column => 11\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader, $start_col) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t\t       ALLELE_DELIMITER\n\t\t\t\t\t\t       NO_HEADER\n\t\t\t\t\t\t       STARTING_COLUMN)],\n\t\t\t\t\t\t   @args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n    $self->starting_column(defined $start_col ? $start_col : $StartingCol );\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\nsub _pivot {\n    my ($self) = @_;\n\n    my (@cols,@rows,@idheader);\n    while ($_ = $self->_readline){\n\tchomp($_);\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tif( /^rs\\#\\s+alleles\\s+chrom\\s+pos\\s+strand/ ) {\n\t    @idheader = split $self->flag('field_delimiter');\n\t} else { \n\t    push @cols, [split $self->flag('field_delimiter')];\n\t}\n    }\n    my $startingcol = $self->starting_column;\n\n    $self->{'_header'} = [ map { $_->[0] } @cols];\n    for my $n ($startingcol.. $#{ $cols[ 0 ]}) { \n\tmy $column = [ $idheader[$n],\n\t\t       map{ $_->[ $n ] } @cols ];\t\n\tpush (@rows, $column); \n    }\n    $self->{'_pivot'} = [@rows];\n    $self->{'_i'} = 0;\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : A Bio::PopGen::IndividualI object\n Args    : none\n\nSee L<Bio::PopGen::IndividualI>","label":"next_individual($self)"}},{"name":"Bio","kind":12,"containerName":"PopGen::Genotype","line":231},{"line":238,"name":"new","kind":12},{"name":"Bio","kind":12,"containerName":"PopGen::Individual","line":238},{"children":[{"containerName":"next_population","localvar":"my","kind":13,"name":"$self","line":257,"definition":"my"},{"definition":"my","line":258,"kind":13,"localvar":"my","containerName":"next_population","name":"@inds"},{"line":259,"name":"$ind","localvar":"my","containerName":"next_population","kind":13,"definition":"my"},{"line":259,"name":"$self","containerName":"next_population","kind":13},{"line":259,"name":"next_individual","kind":12,"containerName":"next_population"},{"kind":13,"containerName":"next_population","name":"@inds","line":260},{"name":"$ind","kind":13,"containerName":"next_population","line":260},{"line":262,"name":"new","containerName":"next_population","kind":12},{"containerName":"next_population","kind":13,"name":"@inds","line":262}],"name":"next_population","containerName":"main::","definition":"sub","detail":"($self)","line":256,"kind":12,"range":{"start":{"line":256,"character":0},"end":{"line":263,"character":9999}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: hapmap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::hapmap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::hapmap - A parser for HapMap output data\n\n=head1 SYNOPSIS\n\n  # Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'hapmap',\n                               -file   => 'data.hapmap');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing hapmap data.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::IO::hapmap;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader $StartingCol);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader,$StartingCol) =( '\\s+','',0,11);\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n           -starting_column => 11\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader, $start_col) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t\t       ALLELE_DELIMITER\n\t\t\t\t\t\t       NO_HEADER\n\t\t\t\t\t\t       STARTING_COLUMN)],\n\t\t\t\t\t\t   @args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n    $self->starting_column(defined $start_col ? $start_col : $StartingCol );\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\nsub _pivot {\n    my ($self) = @_;\n\n    my (@cols,@rows,@idheader);\n    while ($_ = $self->_readline){\n\tchomp($_);\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tif( /^rs\\#\\s+alleles\\s+chrom\\s+pos\\s+strand/ ) {\n\t    @idheader = split $self->flag('field_delimiter');\n\t} else { \n\t    push @cols, [split $self->flag('field_delimiter')];\n\t}\n    }\n    my $startingcol = $self->starting_column;\n\n    $self->{'_header'} = [ map { $_->[0] } @cols];\n    for my $n ($startingcol.. $#{ $cols[ 0 ]}) { \n\tmy $column = [ $idheader[$n],\n\t\t       map{ $_->[ $n ] } @cols ];\t\n\tpush (@rows, $column); \n    }\n    $self->{'_pivot'} = [@rows];\n    $self->{'_i'} = 0;\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : A Bio::PopGen::IndividualI object\n Args    : none\n\nSee L<Bio::PopGen::IndividualI>\n\n\nsub next_individual  {\n    my ($self) = @_;\n    unless($self->{'_pivot'}){\n\t#if it's the first time then pivot the table and store.\n\t#Lines will now be read from the stored pivot version of the input file\n\t$self->_pivot;\n    }\n\n    $_ = $self->{'_pivot'}->[$self->{'_i'}++];\n\n    return unless defined $_;\n\n    # Store all the marker related info. Now that the pivot has taken\n    # place this is in the first few lines of the file Maybe this\n    # should be put in a marker object. Doesn't seem to fit too well\n    # though\n\n    my ($samp,@marker_results) = @$_;\n\n    # at some point use all this info\n    my $i = 1;\n    foreach my $m ( @marker_results ) {\n\t$m =~ s/^\\s+//;\n\t$m =~ s/\\s+$//;\n\tmy $markername;\n\tif( defined $self->{'_header'} ) {\n\t    $markername = $self->{'_header'}->[$i-1];\n\t} else { \n\t    $markername = \"Marker$i\";\n\t}\n\n\tmy @alleles = split($self->flag('allele_delimiter'), $m);\n\tif( @alleles != 2 ) { \n\t    $self->warn(\"$m for $samp\\n\");\n\t} else { \n\t    $m = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $samp);\n\t}\n\t$i++; \n    }\n\n    return new Bio::PopGen::Individual(-unique_id => $samp,\n\t\t\t\t       -genotypes => \\@marker_results);\n\n}\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : Bio::PopGen::PopulationI object\n Args    : none\n Note    : Many implementation will not implement this\n\nSee L<Bio::PopGen::PopulationI>","label":"next_population($self)"}},{"name":"Bio","containerName":"PopGen::Population","kind":12,"line":262},{"definition":"sub","detail":"($self,@inds)","children":[{"definition":"my","localvar":"my","containerName":"write_individual","kind":13,"name":"$self","line":279},{"line":279,"containerName":"write_individual","kind":13,"name":"@inds"},{"line":284,"containerName":"write_individual","kind":13,"name":"$self"},{"line":284,"name":"throw_not_implemented","containerName":"write_individual","kind":12}],"containerName":"main::","name":"write_individual","signature":{"label":"write_individual($self,@inds)","documentation":"1;\n# $Id: hapmap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::hapmap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::hapmap - A parser for HapMap output data\n\n=head1 SYNOPSIS\n\n  # Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'hapmap',\n                               -file   => 'data.hapmap');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing hapmap data.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::IO::hapmap;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader $StartingCol);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader,$StartingCol) =( '\\s+','',0,11);\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n           -starting_column => 11\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader, $start_col) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t\t       ALLELE_DELIMITER\n\t\t\t\t\t\t       NO_HEADER\n\t\t\t\t\t\t       STARTING_COLUMN)],\n\t\t\t\t\t\t   @args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n    $self->starting_column(defined $start_col ? $start_col : $StartingCol );\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\nsub _pivot {\n    my ($self) = @_;\n\n    my (@cols,@rows,@idheader);\n    while ($_ = $self->_readline){\n\tchomp($_);\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tif( /^rs\\#\\s+alleles\\s+chrom\\s+pos\\s+strand/ ) {\n\t    @idheader = split $self->flag('field_delimiter');\n\t} else { \n\t    push @cols, [split $self->flag('field_delimiter')];\n\t}\n    }\n    my $startingcol = $self->starting_column;\n\n    $self->{'_header'} = [ map { $_->[0] } @cols];\n    for my $n ($startingcol.. $#{ $cols[ 0 ]}) { \n\tmy $column = [ $idheader[$n],\n\t\t       map{ $_->[ $n ] } @cols ];\t\n\tpush (@rows, $column); \n    }\n    $self->{'_pivot'} = [@rows];\n    $self->{'_i'} = 0;\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : A Bio::PopGen::IndividualI object\n Args    : none\n\nSee L<Bio::PopGen::IndividualI>\n\n\nsub next_individual  {\n    my ($self) = @_;\n    unless($self->{'_pivot'}){\n\t#if it's the first time then pivot the table and store.\n\t#Lines will now be read from the stored pivot version of the input file\n\t$self->_pivot;\n    }\n\n    $_ = $self->{'_pivot'}->[$self->{'_i'}++];\n\n    return unless defined $_;\n\n    # Store all the marker related info. Now that the pivot has taken\n    # place this is in the first few lines of the file Maybe this\n    # should be put in a marker object. Doesn't seem to fit too well\n    # though\n\n    my ($samp,@marker_results) = @$_;\n\n    # at some point use all this info\n    my $i = 1;\n    foreach my $m ( @marker_results ) {\n\t$m =~ s/^\\s+//;\n\t$m =~ s/\\s+$//;\n\tmy $markername;\n\tif( defined $self->{'_header'} ) {\n\t    $markername = $self->{'_header'}->[$i-1];\n\t} else { \n\t    $markername = \"Marker$i\";\n\t}\n\n\tmy @alleles = split($self->flag('allele_delimiter'), $m);\n\tif( @alleles != 2 ) { \n\t    $self->warn(\"$m for $samp\\n\");\n\t} else { \n\t    $m = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $samp);\n\t}\n\t$i++; \n    }\n\n    return new Bio::PopGen::Individual(-unique_id => $samp,\n\t\t\t\t       -genotypes => \\@marker_results);\n\n}\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : Bio::PopGen::PopulationI object\n Args    : none\n Note    : Many implementation will not implement this\n\nSee L<Bio::PopGen::PopulationI>\n\n\nsub next_population {\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n           NOT SUPPORTED  BY hapmap format\n Returns : none\n Args    : Bio::PopGen::PopulationI object(s)\n\nSee L<Bio::PopGen::PopulationI>","parameters":[{"label":"$self"},{"label":"@inds"}]},"line":278,"range":{"end":{"line":285,"character":9999},"start":{"line":278,"character":0}},"kind":12},{"detail":"($self,@inds)","definition":"sub","name":"write_population","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"write_population","name":"$self","line":302},{"containerName":"write_population","kind":13,"name":"@inds","line":302},{"line":303,"kind":13,"containerName":"write_population","name":"$self"},{"kind":12,"containerName":"write_population","name":"throw_not_implemented","line":303}],"signature":{"documentation":"1;\n# $Id: hapmap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::hapmap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::hapmap - A parser for HapMap output data\n\n=head1 SYNOPSIS\n\n  # Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'hapmap',\n                               -file   => 'data.hapmap');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing hapmap data.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::IO::hapmap;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader $StartingCol);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader,$StartingCol) =( '\\s+','',0,11);\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n           -starting_column => 11\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader, $start_col) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t\t       ALLELE_DELIMITER\n\t\t\t\t\t\t       NO_HEADER\n\t\t\t\t\t\t       STARTING_COLUMN)],\n\t\t\t\t\t\t   @args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n    $self->starting_column(defined $start_col ? $start_col : $StartingCol );\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\nsub _pivot {\n    my ($self) = @_;\n\n    my (@cols,@rows,@idheader);\n    while ($_ = $self->_readline){\n\tchomp($_);\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tif( /^rs\\#\\s+alleles\\s+chrom\\s+pos\\s+strand/ ) {\n\t    @idheader = split $self->flag('field_delimiter');\n\t} else { \n\t    push @cols, [split $self->flag('field_delimiter')];\n\t}\n    }\n    my $startingcol = $self->starting_column;\n\n    $self->{'_header'} = [ map { $_->[0] } @cols];\n    for my $n ($startingcol.. $#{ $cols[ 0 ]}) { \n\tmy $column = [ $idheader[$n],\n\t\t       map{ $_->[ $n ] } @cols ];\t\n\tpush (@rows, $column); \n    }\n    $self->{'_pivot'} = [@rows];\n    $self->{'_i'} = 0;\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : A Bio::PopGen::IndividualI object\n Args    : none\n\nSee L<Bio::PopGen::IndividualI>\n\n\nsub next_individual  {\n    my ($self) = @_;\n    unless($self->{'_pivot'}){\n\t#if it's the first time then pivot the table and store.\n\t#Lines will now be read from the stored pivot version of the input file\n\t$self->_pivot;\n    }\n\n    $_ = $self->{'_pivot'}->[$self->{'_i'}++];\n\n    return unless defined $_;\n\n    # Store all the marker related info. Now that the pivot has taken\n    # place this is in the first few lines of the file Maybe this\n    # should be put in a marker object. Doesn't seem to fit too well\n    # though\n\n    my ($samp,@marker_results) = @$_;\n\n    # at some point use all this info\n    my $i = 1;\n    foreach my $m ( @marker_results ) {\n\t$m =~ s/^\\s+//;\n\t$m =~ s/\\s+$//;\n\tmy $markername;\n\tif( defined $self->{'_header'} ) {\n\t    $markername = $self->{'_header'}->[$i-1];\n\t} else { \n\t    $markername = \"Marker$i\";\n\t}\n\n\tmy @alleles = split($self->flag('allele_delimiter'), $m);\n\tif( @alleles != 2 ) { \n\t    $self->warn(\"$m for $samp\\n\");\n\t} else { \n\t    $m = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $samp);\n\t}\n\t$i++; \n    }\n\n    return new Bio::PopGen::Individual(-unique_id => $samp,\n\t\t\t\t       -genotypes => \\@marker_results);\n\n}\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : Bio::PopGen::PopulationI object\n Args    : none\n Note    : Many implementation will not implement this\n\nSee L<Bio::PopGen::PopulationI>\n\n\nsub next_population {\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n           NOT SUPPORTED  BY hapmap format\n Returns : none\n Args    : Bio::PopGen::PopulationI object(s)\n\nSee L<Bio::PopGen::PopulationI>\n\n\nsub write_individual {\n    my ($self,@inds) = @_;\n\n    # data from hapmap is output, not input, so \n    # we don't need a method for writing and input file\n\n    $self->throw_not_implemented();\n}\n\n=head2 write_population\n\n Title   : write_population\n Usage   : $popgenio->write_population($pop);\n Function: Write a population out in the file format\n           NOT SUPPORTED  BY hapmap format\n Returns : none\n Args    : Bio::PopGen::PopulationI object(s)\n Note    : Many implementation will not implement this\n\nSee L<Bio::PopGen::PopulationI>","parameters":[{"label":"$self"},{"label":"@inds"}],"label":"write_population($self,@inds)"},"range":{"start":{"line":301,"character":0},"end":{"character":9999,"line":304}},"kind":12,"line":301},{"name":"starting_column","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"starting_column","name":"$self","line":319},{"line":321,"name":"$self","containerName":"starting_column","kind":13},{"name":"$self","containerName":"starting_column","kind":13,"line":322}],"definition":"sub","range":{"end":{"line":323,"character":9999},"start":{"character":0,"line":318}},"kind":12,"line":318}],"version":5}