{"vars":[{"kind":2,"containerName":"","name":"vars","line":101},{"line":104,"containerName":"","kind":2,"name":"strict"},{"line":104,"name":"$FieldDelim","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$AlleleDelim","line":104},{"line":104,"name":"$NoHeader","containerName":null,"kind":13},{"name":"base","kind":2,"containerName":"","line":113},{"definition":"sub","detail":"($self,@args)","children":[{"name":"$self","containerName":"_initialize","localvar":"my","kind":13,"line":130,"definition":"my"},{"name":"@args","kind":13,"containerName":"_initialize","line":130},{"line":131,"name":"$fieldsep","localvar":"my","containerName":"_initialize","kind":13,"definition":"my"},{"name":"$all_sep","containerName":"_initialize","kind":13,"line":131},{"containerName":"_initialize","kind":13,"name":"$noheader","line":132},{"containerName":"_initialize","kind":13,"name":"$self","line":132},{"name":"_rearrange","kind":12,"containerName":"_initialize","line":132},{"line":134,"containerName":"_initialize","kind":13,"name":"@args"},{"line":137,"name":"$self","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":12,"name":"flag","line":137},{"containerName":"_initialize","kind":13,"name":"$noheader","line":137},{"line":137,"containerName":"_initialize","kind":13,"name":"$noheader"},{"line":137,"containerName":"_initialize","kind":13,"name":"$NoHeader"},{"line":138,"name":"$self","containerName":"_initialize","kind":13},{"line":138,"kind":12,"containerName":"_initialize","name":"flag"},{"kind":13,"containerName":"_initialize","name":"$fieldsep","line":138},{"line":138,"name":"$fieldsep","kind":13,"containerName":"_initialize"},{"name":"$FieldDelim","containerName":"_initialize","kind":13,"line":138},{"line":139,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"flag","kind":12,"containerName":"_initialize","line":139},{"line":139,"kind":13,"containerName":"_initialize","name":"$all_sep"},{"kind":13,"containerName":"_initialize","name":"$all_sep","line":139},{"containerName":"_initialize","kind":13,"name":"$AlleleDelim","line":139},{"name":"$self","containerName":"_initialize","kind":13,"line":141}],"name":"_initialize","containerName":"main::","signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: csv.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::csv\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::csv -Extract individual allele data from a CSV parser \n\n=head1 SYNOPSIS\n\n#Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited format (CSV) or whatever\ndelimiter you specify. It currently doesn't handle the more complex\nquote escaped CSV format.  There are 3 initialization parameters, \nthe delimiter (-field_delimiter) [default ','], (-allele_delimiter) \n[default ' '].    The third initialization parameter is a boolean \n-no_header which specifies if there is no header line to read in.  All lines starting with '#' will be skipped\n\nWhen no_header is not specific the data is assumed to be of the following form.\nHaving a header line this\nSAMPLE,MARKERNAME1,MARKERNAME2,...\n\nand each data line having the form (diploid data)\nSAMP1,101 102,100 90,a b\nor for haploid data\nSAMP1,101,100,a\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::csv;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::csv->new();\n Function: Builds a new Bio::PopGen::IO::csv object \n Returns : an instance of Bio::PopGen::IO::csv\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,","parameters":[{"label":"$self"},{"label":"@args"}]},"line":129,"range":{"end":{"character":9999,"line":143},"start":{"line":129,"character":0}},"kind":12},{"name":"flag","containerName":"main::","children":[{"definition":"my","containerName":"flag","localvar":"my","kind":13,"name":"$self","line":159},{"name":"$fieldname","localvar":"my","containerName":"flag","kind":13,"line":160,"definition":"my"},{"name":"$fieldname","containerName":"flag","kind":13,"line":161},{"name":"$self","containerName":"flag","kind":13,"line":163},{"line":163,"containerName":"flag","kind":13,"name":"$fieldname"},{"kind":13,"containerName":"flag","name":"$self","line":164},{"line":164,"kind":13,"containerName":"flag","name":"$fieldname"}],"definition":"sub","range":{"start":{"line":158,"character":0},"end":{"line":165,"character":9999}},"kind":12,"line":158},{"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"next_individual","line":180},{"line":181,"name":"$self","containerName":"next_individual","kind":13},{"line":181,"name":"_readline","kind":12,"containerName":"next_individual"},{"name":"$self","kind":13,"containerName":"next_individual","line":186},{"line":186,"name":"flag","containerName":"next_individual","kind":12},{"name":"$self","containerName":"next_individual","kind":13,"line":187},{"definition":"my","line":191,"name":"$samp","containerName":"next_individual","localvar":"my","kind":13},{"name":"@marker_results","containerName":"next_individual","kind":13,"line":191},{"line":193,"containerName":"next_individual","kind":13,"name":"$self"},{"name":"flag","kind":12,"containerName":"next_individual","line":193},{"name":"$self","kind":13,"containerName":"next_individual","line":193},{"line":193,"kind":12,"containerName":"next_individual","name":"flag"},{"kind":13,"containerName":"next_individual","name":"$samp","line":195},{"name":"@marker_results","containerName":"next_individual","kind":13,"line":195},{"line":195,"containerName":"next_individual","kind":13,"name":"$self"},{"line":195,"containerName":"next_individual","kind":12,"name":"flag"},{"kind":13,"localvar":"my","containerName":"next_individual","name":"$fielddelim","line":199,"definition":"my"},{"line":199,"kind":13,"containerName":"next_individual","name":"$self"},{"line":199,"name":"flag","containerName":"next_individual","kind":12},{"line":200,"localvar":"my","containerName":"next_individual","kind":13,"name":"$alleledelim","definition":"my"},{"line":200,"kind":13,"containerName":"next_individual","name":"$self"},{"name":"flag","kind":12,"containerName":"next_individual","line":200},{"line":202,"name":"$samp","containerName":"next_individual","kind":13},{"line":205,"kind":13,"containerName":"next_individual","name":"@marker_results"},{"line":211,"localvar":"my","containerName":"next_individual","kind":13,"name":"$i","definition":"my"},{"definition":"my","line":212,"localvar":"my","kind":13,"containerName":"next_individual","name":"$m"},{"line":212,"containerName":"next_individual","kind":13,"name":"@marker_results"},{"name":"$m","containerName":"next_individual","kind":13,"line":213},{"name":"$m","kind":13,"containerName":"next_individual","line":214},{"definition":"my","line":215,"name":"$markername","kind":13,"localvar":"my","containerName":"next_individual"},{"line":216,"containerName":"next_individual","kind":13,"name":"$self"},{"line":217,"name":"$markername","containerName":"next_individual","kind":13},{"name":"$self","kind":13,"containerName":"next_individual","line":217},{"line":217,"kind":13,"containerName":"next_individual","name":"$i"},{"kind":13,"containerName":"next_individual","name":"$markername","line":219},{"containerName":"next_individual","kind":13,"name":"$self","line":221},{"name":"debug","containerName":"next_individual","kind":12,"line":221},{"definition":"my","line":223,"containerName":"next_individual","localvar":"my","kind":13,"name":"@alleles"},{"line":223,"kind":13,"containerName":"next_individual","name":"$self"},{"name":"flag","containerName":"next_individual","kind":12,"line":223},{"containerName":"next_individual","kind":13,"name":"$m","line":223},{"line":225,"name":"$m","kind":13,"containerName":"next_individual"},{"line":225,"kind":12,"containerName":"next_individual","name":"new"},{"line":225,"containerName":"next_individual","kind":13,"name":"@alleles"},{"line":226,"name":"$markername","kind":13,"containerName":"next_individual"},{"line":227,"name":"$samp","containerName":"next_individual","kind":13},{"kind":13,"containerName":"next_individual","name":"$i","line":228},{"line":230,"kind":12,"containerName":"next_individual","name":"new"},{"name":"$samp","kind":13,"containerName":"next_individual","line":230},{"line":231,"name":"@marker_results","kind":13,"containerName":"next_individual"},{"line":234,"kind":13,"containerName":"next_individual","name":"$self"},{"line":234,"containerName":"next_individual","kind":13,"name":"$self"},{"line":234,"name":"flag","kind":12,"containerName":"next_individual"},{"kind":13,"containerName":"next_individual","name":"$self","line":235},{"line":235,"kind":12,"containerName":"next_individual","name":"next_individual"}],"name":"next_individual","containerName":"main::","signature":{"documentation":"1;\n# $Id: csv.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::csv\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::csv -Extract individual allele data from a CSV parser \n\n=head1 SYNOPSIS\n\n#Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited format (CSV) or whatever\ndelimiter you specify. It currently doesn't handle the more complex\nquote escaped CSV format.  There are 3 initialization parameters, \nthe delimiter (-field_delimiter) [default ','], (-allele_delimiter) \n[default ' '].    The third initialization parameter is a boolean \n-no_header which specifies if there is no header line to read in.  All lines starting with '#' will be skipped\n\nWhen no_header is not specific the data is assumed to be of the following form.\nHaving a header line this\nSAMPLE,MARKERNAME1,MARKERNAME2,...\n\nand each data line having the form (diploid data)\nSAMP1,101 102,100 90,a b\nor for haploid data\nSAMP1,101,100,a\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::csv;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::csv->new();\n Function: Builds a new Bio::PopGen::IO::csv object \n Returns : an instance of Bio::PopGen::IO::csv\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none","parameters":[{"label":"$self"}],"label":"next_individual($self)"},"line":179,"range":{"start":{"character":0,"line":179},"end":{"character":9999,"line":238}},"kind":12},{"line":225,"name":"Bio","kind":12,"containerName":"PopGen::Genotype"},{"line":230,"name":"Bio","containerName":"PopGen::Individual","kind":12},{"signature":{"label":"next_population($self)","documentation":"1;\n# $Id: csv.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::csv\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::csv -Extract individual allele data from a CSV parser \n\n=head1 SYNOPSIS\n\n#Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited format (CSV) or whatever\ndelimiter you specify. It currently doesn't handle the more complex\nquote escaped CSV format.  There are 3 initialization parameters, \nthe delimiter (-field_delimiter) [default ','], (-allele_delimiter) \n[default ' '].    The third initialization parameter is a boolean \n-no_header which specifies if there is no header line to read in.  All lines starting with '#' will be skipped\n\nWhen no_header is not specific the data is assumed to be of the following form.\nHaving a header line this\nSAMPLE,MARKERNAME1,MARKERNAME2,...\n\nand each data line having the form (diploid data)\nSAMP1,101 102,100 90,a b\nor for haploid data\nSAMP1,101,100,a\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::csv;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::csv->new();\n Function: Builds a new Bio::PopGen::IO::csv object \n Returns : an instance of Bio::PopGen::IO::csv\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual{\n    my ($self) = @_;\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tlast;\n    }\n    return if ! defined $_; \n    if( $self->flag('no_header') || \n\tdefined $self->{'_header'} ) {\n\n\t#########new (allows field delim to be the same as the allele delim\n\n\tmy ($samp,@marker_results);\n\n\tif($self->flag('field_delimiter') ne $self->flag('allele_delimiter')){\n\n\t\t($samp,@marker_results) = split($self->flag('field_delimiter'),$_);\n\t}\n\telse{\n\n\t\tmy $fielddelim = $self->flag('field_delimiter');\n\t\tmy $alleledelim = $self->flag('allele_delimiter');\n\n\t\t($samp) = /(^.+?)$fielddelim/;\n\t\ts/^.+?$fielddelim//;\n\t\n\t\t(@marker_results) = /([\\d|\\w]+$alleledelim[\\d|\\w]+)/g;\n\t\n\t}\n\n\t#########end new\n\n\tmy $i = 1;\n\tforeach my $m ( @marker_results ) {\n\t    $m =~ s/^\\s+//;\n\t    $m =~ s/\\s+$//;\n\t    my $markername;\n\t    if( defined $self->{'_header'} ) {\n\t\t$markername = $self->{'_header'}->[$i];\n\t    } else { \n\t\t$markername = \"Marker$i\";\n\t    }\n\t    $self->debug( \"markername is $markername alleles are $m\\n\");\n\n\t    my @alleles = split($self->flag('allele_delimiter'), $m);\n\t\t\n\t    $m = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $samp); \n\t    $i++; \n\t}\n\treturn Bio::PopGen::Individual->new(-unique_id => $samp,\n\t\t\t\t\t   -genotypes => \\@marker_results);\n    } else {\n\tchomp;\n\t$self->{'_header'} = [split($self->flag('field_delimiter'),$_)];\n\treturn $self->next_individual; # rerun loop again\n    }\n    return;\n}\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this\n\n Plan is to just return the whole dataset as a single population by\n default I think - people would then have each population in a separate\n file.","parameters":[{"label":"$self"}]},"line":256,"kind":12,"range":{"end":{"character":9999,"line":263},"start":{"line":256,"character":0}},"definition":"sub","detail":"($self)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"next_population","name":"$self","line":257},{"definition":"my","line":258,"name":"@inds","localvar":"my","containerName":"next_population","kind":13},{"kind":13,"localvar":"my","containerName":"next_population","name":"$ind","line":259,"definition":"my"},{"line":259,"name":"$self","kind":13,"containerName":"next_population"},{"line":259,"name":"next_individual","kind":12,"containerName":"next_population"},{"line":260,"containerName":"next_population","kind":13,"name":"@inds"},{"line":260,"name":"$ind","containerName":"next_population","kind":13},{"kind":12,"containerName":"next_population","name":"new","line":262},{"name":"@inds","kind":13,"containerName":"next_population","line":262}],"name":"next_population","containerName":"main::"},{"name":"Bio","containerName":"PopGen::Population","kind":12,"line":262},{"signature":{"label":"write_individual($self,@inds)","parameters":[{"label":"$self"},{"label":"@inds"}],"documentation":"1;\n# $Id: csv.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::csv\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::csv -Extract individual allele data from a CSV parser \n\n=head1 SYNOPSIS\n\n#Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited format (CSV) or whatever\ndelimiter you specify. It currently doesn't handle the more complex\nquote escaped CSV format.  There are 3 initialization parameters, \nthe delimiter (-field_delimiter) [default ','], (-allele_delimiter) \n[default ' '].    The third initialization parameter is a boolean \n-no_header which specifies if there is no header line to read in.  All lines starting with '#' will be skipped\n\nWhen no_header is not specific the data is assumed to be of the following form.\nHaving a header line this\nSAMPLE,MARKERNAME1,MARKERNAME2,...\n\nand each data line having the form (diploid data)\nSAMP1,101 102,100 90,a b\nor for haploid data\nSAMP1,101,100,a\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::csv;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::csv->new();\n Function: Builds a new Bio::PopGen::IO::csv object \n Returns : an instance of Bio::PopGen::IO::csv\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual{\n    my ($self) = @_;\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tlast;\n    }\n    return if ! defined $_; \n    if( $self->flag('no_header') || \n\tdefined $self->{'_header'} ) {\n\n\t#########new (allows field delim to be the same as the allele delim\n\n\tmy ($samp,@marker_results);\n\n\tif($self->flag('field_delimiter') ne $self->flag('allele_delimiter')){\n\n\t\t($samp,@marker_results) = split($self->flag('field_delimiter'),$_);\n\t}\n\telse{\n\n\t\tmy $fielddelim = $self->flag('field_delimiter');\n\t\tmy $alleledelim = $self->flag('allele_delimiter');\n\n\t\t($samp) = /(^.+?)$fielddelim/;\n\t\ts/^.+?$fielddelim//;\n\t\n\t\t(@marker_results) = /([\\d|\\w]+$alleledelim[\\d|\\w]+)/g;\n\t\n\t}\n\n\t#########end new\n\n\tmy $i = 1;\n\tforeach my $m ( @marker_results ) {\n\t    $m =~ s/^\\s+//;\n\t    $m =~ s/\\s+$//;\n\t    my $markername;\n\t    if( defined $self->{'_header'} ) {\n\t\t$markername = $self->{'_header'}->[$i];\n\t    } else { \n\t\t$markername = \"Marker$i\";\n\t    }\n\t    $self->debug( \"markername is $markername alleles are $m\\n\");\n\n\t    my @alleles = split($self->flag('allele_delimiter'), $m);\n\t\t\n\t    $m = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $samp); \n\t    $i++; \n\t}\n\treturn Bio::PopGen::Individual->new(-unique_id => $samp,\n\t\t\t\t\t   -genotypes => \\@marker_results);\n    } else {\n\tchomp;\n\t$self->{'_header'} = [split($self->flag('field_delimiter'),$_)];\n\treturn $self->next_individual; # rerun loop again\n    }\n    return;\n}\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this\n\n\n# Plan is to just return the whole dataset as a single population by \n# default I think - people would then have each population in a separate\n# file.\n\nsub next_population{\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n\n\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)"},"line":278,"kind":12,"range":{"end":{"character":9999,"line":311},"start":{"character":0,"line":278}},"definition":"sub","detail":"($self,@inds)","children":[{"definition":"my","line":279,"localvar":"my","containerName":"write_individual","kind":13,"name":"$self"},{"name":"@inds","kind":13,"containerName":"write_individual","line":279},{"name":"$fielddelim","containerName":"write_individual","localvar":"my","kind":13,"line":280,"definition":"my"},{"containerName":"write_individual","kind":13,"name":"$self","line":280},{"name":"flag","containerName":"write_individual","kind":12,"line":280},{"line":281,"containerName":"write_individual","localvar":"my","kind":13,"name":"$alleledelim","definition":"my"},{"line":281,"kind":13,"containerName":"write_individual","name":"$self"},{"line":281,"name":"flag","kind":12,"containerName":"write_individual"},{"definition":"my","name":"$ind","kind":13,"localvar":"my","containerName":"write_individual","line":283},{"name":"@inds","containerName":"write_individual","kind":13,"line":283},{"line":284,"name":"$ind","containerName":"write_individual","kind":13},{"containerName":"write_individual","kind":13,"name":"$ind","line":284},{"line":284,"name":"isa","containerName":"write_individual","kind":12},{"name":"$self","containerName":"write_individual","kind":13,"line":285},{"kind":12,"containerName":"write_individual","name":"warn","line":285},{"definition":"my","line":290,"containerName":"write_individual","localvar":"my","kind":13,"name":"@marker_names"},{"containerName":"write_individual","kind":13,"name":"$ind","line":290},{"line":290,"name":"get_marker_names","kind":12,"containerName":"write_individual"},{"line":291,"name":"$self","containerName":"write_individual","kind":13},{"line":291,"containerName":"write_individual","kind":12,"name":"flag"},{"line":292,"kind":13,"containerName":"write_individual","name":"$self"},{"line":292,"name":"flag","kind":12,"containerName":"write_individual"},{"line":293,"name":"$self","containerName":"write_individual","kind":13},{"line":293,"name":"_print","containerName":"write_individual","kind":12},{"line":293,"name":"$fielddelim","containerName":"write_individual","kind":13},{"line":293,"name":"@marker_names","kind":13,"containerName":"write_individual"},{"name":"$self","kind":13,"containerName":"write_individual","line":294},{"line":294,"name":"flag","kind":12,"containerName":"write_individual"},{"containerName":"write_individual","kind":13,"name":"$self","line":296},{"name":"_print","containerName":"write_individual","kind":12,"line":296},{"name":"$fielddelim","containerName":"write_individual","kind":13,"line":296},{"kind":13,"containerName":"write_individual","name":"$ind","line":296},{"name":"unique_id","kind":12,"containerName":"write_individual","line":296},{"line":302,"name":"$alleledelim","containerName":"write_individual","kind":13},{"name":"get_Alleles","kind":12,"containerName":"write_individual","line":302},{"line":308,"name":"$ind","kind":13,"containerName":"write_individual"},{"line":308,"containerName":"write_individual","kind":12,"name":"get_Genotypes"},{"kind":13,"containerName":"write_individual","name":"@marker_names","line":309}],"containerName":"main::","name":"write_individual"},{"name":"write_population","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"write_population","kind":13,"line":325},{"containerName":"write_population","kind":13,"name":"@pops","line":325},{"definition":"my","line":326,"name":"$fielddelim","containerName":"write_population","localvar":"my","kind":13},{"kind":13,"containerName":"write_population","name":"$self","line":326},{"containerName":"write_population","kind":12,"name":"flag","line":326},{"definition":"my","name":"$alleledelim","localvar":"my","containerName":"write_population","kind":13,"line":328},{"definition":"my","containerName":"write_population","localvar":"my","kind":13,"name":"$pop","line":329},{"name":"@pops","kind":13,"containerName":"write_population","line":329},{"line":330,"name":"$pop","containerName":"write_population","kind":13},{"kind":13,"containerName":"write_population","name":"$pop","line":330},{"name":"isa","kind":12,"containerName":"write_population","line":330},{"line":331,"name":"$self","kind":13,"containerName":"write_population"},{"line":331,"kind":12,"containerName":"write_population","name":"warn"},{"definition":"my","localvar":"my","containerName":"write_population","kind":13,"name":"@marker_names","line":336},{"line":336,"name":"$pop","kind":13,"containerName":"write_population"},{"line":336,"name":"get_marker_names","containerName":"write_population","kind":12},{"containerName":"write_population","kind":13,"name":"$self","line":337},{"line":337,"name":"flag","containerName":"write_population","kind":12},{"kind":13,"containerName":"write_population","name":"$self","line":338},{"kind":12,"containerName":"write_population","name":"flag","line":338},{"kind":13,"containerName":"write_population","name":"$self","line":339},{"line":339,"kind":12,"containerName":"write_population","name":"_print"},{"line":339,"name":"$fielddelim","kind":13,"containerName":"write_population"},{"line":339,"name":"@marker_names","containerName":"write_population","kind":13},{"line":341,"containerName":"write_population","kind":13,"name":"$self"},{"line":341,"name":"flag","containerName":"write_population","kind":12},{"definition":"my","line":343,"name":"$ind","localvar":"my","kind":13,"containerName":"write_population"},{"line":343,"kind":13,"containerName":"write_population","name":"$pop"},{"line":343,"name":"get_Individuals","kind":12,"containerName":"write_population"},{"name":"$self","containerName":"write_population","kind":13,"line":344},{"line":344,"containerName":"write_population","kind":12,"name":"_print"},{"name":"$fielddelim","kind":13,"containerName":"write_population","line":344},{"name":"$ind","kind":13,"containerName":"write_population","line":344},{"line":344,"name":"unique_id","containerName":"write_population","kind":12},{"line":351,"name":"$alleledelim","kind":13,"containerName":"write_population"},{"line":351,"name":"get_Alleles","containerName":"write_population","kind":12},{"line":357,"kind":13,"containerName":"write_population","name":"$ind"},{"name":"get_Genotypes","containerName":"write_population","kind":12,"line":357},{"containerName":"write_population","kind":13,"name":"@marker_names","line":358}],"detail":"($self,@pops)","definition":"sub","range":{"start":{"character":0,"line":324},"end":{"line":361,"character":9999}},"kind":12,"line":324,"signature":{"label":"write_population($self,@pops)","documentation":"1;\n# $Id: csv.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::csv\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::csv -Extract individual allele data from a CSV parser \n\n=head1 SYNOPSIS\n\n#Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited format (CSV) or whatever\ndelimiter you specify. It currently doesn't handle the more complex\nquote escaped CSV format.  There are 3 initialization parameters, \nthe delimiter (-field_delimiter) [default ','], (-allele_delimiter) \n[default ' '].    The third initialization parameter is a boolean \n-no_header which specifies if there is no header line to read in.  All lines starting with '#' will be skipped\n\nWhen no_header is not specific the data is assumed to be of the following form.\nHaving a header line this\nSAMPLE,MARKERNAME1,MARKERNAME2,...\n\nand each data line having the form (diploid data)\nSAMP1,101 102,100 90,a b\nor for haploid data\nSAMP1,101,100,a\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::csv;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::csv->new();\n Function: Builds a new Bio::PopGen::IO::csv object \n Returns : an instance of Bio::PopGen::IO::csv\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual{\n    my ($self) = @_;\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tlast;\n    }\n    return if ! defined $_; \n    if( $self->flag('no_header') || \n\tdefined $self->{'_header'} ) {\n\n\t#########new (allows field delim to be the same as the allele delim\n\n\tmy ($samp,@marker_results);\n\n\tif($self->flag('field_delimiter') ne $self->flag('allele_delimiter')){\n\n\t\t($samp,@marker_results) = split($self->flag('field_delimiter'),$_);\n\t}\n\telse{\n\n\t\tmy $fielddelim = $self->flag('field_delimiter');\n\t\tmy $alleledelim = $self->flag('allele_delimiter');\n\n\t\t($samp) = /(^.+?)$fielddelim/;\n\t\ts/^.+?$fielddelim//;\n\t\n\t\t(@marker_results) = /([\\d|\\w]+$alleledelim[\\d|\\w]+)/g;\n\t\n\t}\n\n\t#########end new\n\n\tmy $i = 1;\n\tforeach my $m ( @marker_results ) {\n\t    $m =~ s/^\\s+//;\n\t    $m =~ s/\\s+$//;\n\t    my $markername;\n\t    if( defined $self->{'_header'} ) {\n\t\t$markername = $self->{'_header'}->[$i];\n\t    } else { \n\t\t$markername = \"Marker$i\";\n\t    }\n\t    $self->debug( \"markername is $markername alleles are $m\\n\");\n\n\t    my @alleles = split($self->flag('allele_delimiter'), $m);\n\t\t\n\t    $m = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $samp); \n\t    $i++; \n\t}\n\treturn Bio::PopGen::Individual->new(-unique_id => $samp,\n\t\t\t\t\t   -genotypes => \\@marker_results);\n    } else {\n\tchomp;\n\t$self->{'_header'} = [split($self->flag('field_delimiter'),$_)];\n\treturn $self->next_individual; # rerun loop again\n    }\n    return;\n}\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this\n\n\n# Plan is to just return the whole dataset as a single population by \n# default I think - people would then have each population in a separate\n# file.\n\nsub next_population{\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n\n\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n\n\nsub write_individual{\n    my ($self,@inds) = @_;\n    my $fielddelim  = $self->flag('field_delimiter');\n    my $alleledelim= $self->flag('allele_delimiter');\n    \n    foreach my $ind ( @inds ) {\n\tif (! ref($ind) || ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Cannot write an object that is not a Bio::PopGen::IndividualI object ($ind)\");\n\t    next;\n\t}\n\t# we'll go ahead and sort these until\n\t# we have a better way to insure a consistent order\n\tmy @marker_names = sort $ind->get_marker_names;\n\tif( ! $self->flag('no_header') && \n\t    ! $self->flag('header_written') ) {\n\t    $self->_print(join($fielddelim, ('SAMPLE', @marker_names)), \"\\n\");\n\t    $self->flag('header_written',1);\n\t}\n\t$self->_print( join($fielddelim, $ind->unique_id, \n\t\t\t    # we're chaining map here, pay attention and read\n\t\t\t    # starting with the last map\n\t\t\t    \n\t\t\t    # we'll turn genotypes into allele pairs\n\t\t\t    # which will be separated by the allele delimiter\n\t\t\t    map { join($alleledelim,$_->get_Alleles) } \n\t\t\t    # marker names will be sorted so we don't\n\t\t\t    # have to worry about this between individuals\n\t\t\t    # unless the individual set you pass in has \n\t\t\t    # a mixed set of markers...\n\t\t\t    # this will turn marker names into Genotypes\n\t\t\t    map {$ind->get_Genotypes(-marker => $_)} \n\t\t\t    @marker_names), \"\\n\")\n    }    \n}\n\n=head2 write_population\n\n Title   : write_population\n Usage   : $popgenio->write_population($pop);\n Function: Write a population out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n Note    : Many implementation will not implement this","parameters":[{"label":"$self"},{"label":"@pops"}]}}],"version":5}