{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":64},{"line":100,"kind":12,"range":{"end":{"character":9999,"line":127},"start":{"line":100,"character":0}},"signature":{"documentation":"1;\n# $Id: RandomFactory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::RandomFactory - Module to generate random\nPhylogenetic Networks\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::RandomFactory;\n\n # Will generate at random all the 66 binary tree-child phylogenetic\n # networks with 3 leaves\n\n my $factory=Bio::PhyloNetwork::RandomFactory->new(-numleaves=>3,-norepeat=>1);\n\n my @nets;\n\n for (my $i=0; $i<66; $i++) {\n   my $net=$factory->next_network();\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nBuilds a random (binary tree-child) phylogenetic network each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::RandomFactory;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\nuse Math::Random;\nuse Bio::Tree::RandomFactory;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::RandomFactory();\n Function: Creates a new Bio::PhyloNetwork::RandomFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n           -numhybrids => integer [optional]\n           -norepeat => boolean [optional]\n\nReturns a Bio::PhyloNetwork::RandomFactory object. Such an object will create\nrandom binary tree-child phylogenetic networks each time next_network\nis called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\nIf the parameter -numhybrids=E<gt>$numhybrids is given, then the generated\nnetworks will have exactly $numhybrids hybrid nodes. Note that, necessarily,\n$numhybrids E<lt> $numleaves. Otherwise, the number of hybrid nodes will be chosen\nat random for each call of next_network.\n\nIf the parameter -norepeat=E<gt>1 is given, then successive calls of next_network\nwill give non-isomorphic networks.","parameters":[{"label":"$pkg"},{"label":"@args"}],"label":"new($pkg,@args)"},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$pkg","line":101},{"line":101,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":103,"name":"$self","localvar":"my","kind":13,"containerName":"new"},{"line":103,"name":"$pkg","containerName":"new","kind":13},{"name":"@args","containerName":"new","kind":13,"line":103},{"name":"$leavesR","containerName":"new","localvar":"my","kind":13,"line":105,"definition":"my"},{"name":"$numleaves","containerName":"new","kind":13,"line":105},{"line":105,"containerName":"new","kind":13,"name":"$numhybrids"},{"containerName":"new","kind":13,"name":"$norepeat","line":105},{"line":106,"kind":13,"containerName":"new","name":"$self"},{"line":106,"containerName":"new","kind":12,"name":"_rearrange"},{"kind":13,"containerName":"new","name":"@args","line":109},{"localvar":"my","containerName":"new","kind":13,"name":"@leaves","line":110,"definition":"my"},{"line":111,"kind":13,"containerName":"new","name":"$leavesR"},{"name":"$numleaves","containerName":"new","kind":13,"line":111},{"kind":13,"containerName":"new","name":"@leaves","line":112},{"name":"$numleaves","containerName":"new","kind":13,"line":112},{"line":113,"name":"$leavesR","containerName":"new","kind":13},{"name":"@leaves","kind":13,"containerName":"new","line":113},{"name":"$leavesR","containerName":"new","kind":13,"line":115},{"containerName":"new","kind":13,"name":"$self","line":116},{"line":116,"containerName":"new","kind":12,"name":"throw"},{"line":118,"name":"$norepeat","containerName":"new","kind":13},{"line":120,"containerName":"new","kind":13,"name":"$self"},{"line":120,"kind":13,"containerName":"new","name":"@leaves"},{"line":121,"name":"$self","containerName":"new","kind":13},{"line":121,"name":"$numleaves","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":122},{"line":122,"name":"$numhybrids","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$numhybrids","line":122},{"line":123,"name":"$self","containerName":"new","kind":13},{"name":"$norepeat","containerName":"new","kind":13,"line":123},{"kind":13,"containerName":"new","name":"$self","line":124},{"line":125,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"new","line":125},{"line":125,"name":"@leaves","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":126},{"name":"$pkg","kind":13,"containerName":"new","line":126}],"containerName":"main::","name":"new","definition":"sub","detail":"($pkg,@args)"},{"name":"RandomFactory","kind":2,"containerName":"Bio::PhyloNetwork::Math::Random::Bio::Tree","line":101},{"line":103,"name":"SUPER","containerName":"new","kind":12},{"name":"leaves","kind":12,"line":120},{"kind":12,"name":"numleaves","line":121},{"line":122,"name":"numhybrids","kind":12},{"kind":12,"name":"norepeat","line":123},{"line":124,"kind":12,"name":"found"},{"kind":12,"name":"tree_factory","line":125},{"line":125,"containerName":"Tree::RandomFactory","kind":12,"name":"Bio"},{"children":[{"line":140,"name":"$self","kind":13,"localvar":"my","containerName":"next_network","definition":"my"},{"definition":"my","name":"$numleaves","containerName":"next_network","localvar":"my","kind":13,"line":142},{"line":142,"name":"$self","kind":13,"containerName":"next_network"},{"definition":"my","line":143,"localvar":"my","kind":13,"containerName":"next_network","name":"@found"},{"line":143,"kind":13,"containerName":"next_network","name":"$self"}],"containerName":"main::","name":"next_network","definition":"sub","detail":"($self)","line":139,"range":{"start":{"line":139,"character":0},"end":{"character":9999,"line":143}},"kind":12,"signature":{"documentation":"1;\n# $Id: RandomFactory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::RandomFactory - Module to generate random\nPhylogenetic Networks\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::RandomFactory;\n\n # Will generate at random all the 66 binary tree-child phylogenetic\n # networks with 3 leaves\n\n my $factory=Bio::PhyloNetwork::RandomFactory->new(-numleaves=>3,-norepeat=>1);\n\n my @nets;\n\n for (my $i=0; $i<66; $i++) {\n   my $net=$factory->next_network();\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nBuilds a random (binary tree-child) phylogenetic network each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::RandomFactory;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\nuse Math::Random;\nuse Bio::Tree::RandomFactory;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::RandomFactory();\n Function: Creates a new Bio::PhyloNetwork::RandomFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n           -numhybrids => integer [optional]\n           -norepeat => boolean [optional]\n\nReturns a Bio::PhyloNetwork::RandomFactory object. Such an object will create\nrandom binary tree-child phylogenetic networks each time next_network\nis called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\nIf the parameter -numhybrids=E<gt>$numhybrids is given, then the generated\nnetworks will have exactly $numhybrids hybrid nodes. Note that, necessarily,\n$numhybrids E<lt> $numleaves. Otherwise, the number of hybrid nodes will be chosen\nat random for each call of next_network.\n\nIf the parameter -norepeat=E<gt>1 is given, then successive calls of next_network\nwill give non-isomorphic networks.\n\n\nsub new {\n  my ($pkg,@args)=@_;\n\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($leavesR,$numleaves,$numhybrids,$norepeat)=\n    $self->_rearrange([qw(LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  NUMHYBRIDS\n\t\t\t  NOREPEAT)],@args);\n  my @leaves;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  if (! defined $leavesR) {\n    $self->throw(\"No leaves set neither numleaves given\");\n  }\n  $norepeat ||= 0;\n\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{numhybrids}=$numhybrids if defined $numhybrids;\n  $self->{norepeat}=$norepeat;\n  $self->{found}=[];\n  $self->{tree_factory}=Bio::Tree::RandomFactory->new(-taxa => \\@leaves);\n  bless($self,$pkg);\n}\n\n=head2 next_network\n\n Title   : next_network\n Usage   : my $net=$factory->next_network()\n Function: returns a random network\n Returns : Bio::PhyloNetwork\n Args    : none","parameters":[{"label":"$self"}],"label":"next_network($self)"}},{"name":"numleaves","kind":12,"line":142},{"line":143,"name":"found","kind":12},{"definition":"my","line":144,"kind":13,"localvar":"my","containerName":null,"name":"$numhybrids"},{"line":145,"kind":12,"name":"START"},{"line":146,"name":"%self","kind":13,"containerName":null},{"line":146,"name":"numhybrids","kind":12},{"name":"$numhybrids","kind":13,"containerName":null,"line":147},{"line":147,"name":"%numleaves","containerName":null,"kind":13},{"line":150,"name":"$numhybrids","kind":13,"containerName":null},{"line":150,"kind":13,"containerName":null,"name":"%self"},{"line":150,"kind":12,"name":"numhybrids"},{"definition":"my","line":152,"kind":13,"localvar":"my","containerName":null,"name":"$tf"},{"kind":13,"containerName":null,"name":"%self","line":152},{"line":152,"name":"tree_factory","kind":12},{"name":"$tree","localvar":"my","containerName":null,"kind":13,"line":153,"definition":"my"},{"line":153,"name":"$tf","containerName":null,"kind":13},{"line":153,"containerName":"main::","kind":12,"name":"next_tree"},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$net","line":154},{"containerName":"PhyloNetwork","kind":12,"name":"Bio","line":154},{"containerName":"main::","kind":12,"name":"new","line":154},{"name":"$tree","containerName":null,"kind":13,"line":154},{"localvar":"my","kind":13,"containerName":null,"name":"$i","line":155,"definition":"my"},{"line":155,"kind":13,"containerName":null,"name":"$i"},{"name":"$numhybrids","kind":13,"containerName":null,"line":155},{"line":155,"containerName":null,"kind":13,"name":"%i"},{"kind":13,"containerName":null,"name":"$net","line":156},{"line":156,"kind":12,"name":"random_attack"},{"name":"$net","containerName":null,"kind":13,"line":156},{"kind":13,"containerName":null,"name":"$i","line":156},{"line":158,"kind":13,"containerName":null,"name":"%self"},{"line":158,"kind":12,"name":"norepeat"},{"definition":"my","line":159,"name":"$ant","kind":13,"localvar":"my","containerName":null},{"kind":13,"containerName":null,"name":"@found","line":159},{"kind":12,"name":"START","line":160},{"kind":13,"containerName":null,"name":"$net","line":160},{"line":160,"name":"is_mu_isomorphic","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$ant","line":160},{"containerName":null,"kind":13,"name":"@found","line":162},{"name":"$net","containerName":null,"kind":13,"line":162},{"line":163,"containerName":null,"kind":13,"name":"%self"},{"line":163,"kind":12,"name":"found"},{"line":163,"name":"@found","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$net","line":165},{"detail":"($net,$lbl)","definition":"sub","name":"random_attack","containerName":"main::","children":[{"definition":"my","line":169,"name":"$net","kind":13,"localvar":"my","containerName":"random_attack"},{"line":169,"name":"$lbl","kind":13,"containerName":"random_attack"},{"line":171,"name":"$graph","localvar":"my","kind":13,"containerName":"random_attack","definition":"my"},{"containerName":"random_attack","kind":13,"name":"$net","line":171},{"definition":"my","localvar":"my","containerName":"random_attack","kind":13,"name":"$u1","line":172},{"name":"$v1","kind":13,"containerName":"random_attack","line":172},{"name":"$u2","containerName":"random_attack","kind":13,"line":172},{"line":172,"kind":13,"containerName":"random_attack","name":"$v2"},{"name":"$e1","kind":13,"localvar":"my","containerName":"random_attack","line":174,"definition":"my"},{"containerName":"random_attack","kind":13,"name":"$graph","line":174},{"name":"random_edge","kind":12,"containerName":"random_attack","line":174},{"line":175,"name":"$e2","kind":13,"localvar":"my","containerName":"random_attack","definition":"my"},{"line":175,"name":"$graph","containerName":"random_attack","kind":13},{"line":175,"name":"random_edge","kind":12,"containerName":"random_attack"},{"kind":13,"containerName":"random_attack","name":"$u1","line":176},{"line":176,"name":"$e1","kind":13,"containerName":"random_attack"},{"line":177,"kind":13,"containerName":"random_attack","name":"$v1"},{"line":177,"kind":13,"containerName":"random_attack","name":"$e1"},{"line":178,"name":"$u2","containerName":"random_attack","kind":13},{"kind":13,"containerName":"random_attack","name":"$e2","line":178},{"name":"$v2","kind":13,"containerName":"random_attack","line":179},{"line":179,"name":"$e2","kind":13,"containerName":"random_attack"},{"kind":13,"containerName":"random_attack","name":"$net","line":180},{"name":"is_attackable","kind":12,"containerName":"random_attack","line":180},{"containerName":"random_attack","kind":13,"name":"$u1","line":180},{"name":"$v1","containerName":"random_attack","kind":13,"line":180},{"kind":13,"containerName":"random_attack","name":"$u2","line":180},{"name":"$v2","containerName":"random_attack","kind":13,"line":180},{"containerName":"random_attack","kind":13,"name":"$lbl","line":180},{"line":181,"containerName":"random_attack","kind":13,"name":"$net"},{"kind":12,"containerName":"random_attack","name":"do_attack","line":181},{"name":"$u1","containerName":"random_attack","kind":13,"line":181},{"line":181,"kind":13,"containerName":"random_attack","name":"$v1"},{"name":"$u2","containerName":"random_attack","kind":13,"line":181},{"name":"$v2","containerName":"random_attack","kind":13,"line":181},{"name":"$lbl","containerName":"random_attack","kind":13,"line":181},{"name":"$net","kind":13,"containerName":"random_attack","line":182}],"signature":{"parameters":[{"label":"$net"},{"label":"$lbl"}],"documentation":"","label":"random_attack($net,$lbl)"},"range":{"start":{"character":0,"line":168},"end":{"character":9999,"line":183}},"kind":12,"line":168},{"kind":12,"name":"graph","line":171}]}