{"vars":[{"name":"base","containerName":"","kind":2,"line":65},{"signature":{"label":"new($pkg,@args)","parameters":[{"label":"$pkg"},{"label":"@args"}],"documentation":"1;\n# $Id: FactoryX.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::FactoryX\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::FactoryX - Module to sequentially generate\nPhylogenetic Networks\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::Factory;\n\n # Will generate sequentially all the 4059 binary tree-child phylogenetic\n # networks with 4 leaves\n\n my $factory=Bio::PhyloNetwork::Factory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary tree-child) phylogenetic network each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::FactoryX;\n\nuse strict;\nuse warnings;\n\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\nuse Bio::PhyloNetwork::TreeFactoryX;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::Factory();\n Function: Creates a new Bio::PhyloNetwork::Factory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n           -numhybrids => integer [default = numleaves -1]\n           -recurse => boolean [optional]\n\nReturns a Bio::PhyloNetwork::Factory object. Such an object will\nsequentially create binary tree-child phylogenetic networks\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\nIf the parameter -numhybrids=E<gt>$numhybrids is given, then the generated\nnetworks will have at most $numhybrids hybrid nodes. Note that, necessarily,\n$numhybrids E<lt> $numleaves.\n\nIf the parameter -recurse=E<gt>1 is given, then all networks with number of hybrid\nnodes less or equal to $numhybrids will be given; otherwise only those with\nexactly $numhybrids hybrid nodes."},"range":{"start":{"line":100,"character":0},"end":{"line":139,"character":9999}},"kind":12,"line":100,"detail":"($pkg,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"definition":"my","line":101,"kind":13,"localvar":"my","containerName":"new","name":"$pkg"},{"name":"@args","kind":13,"containerName":"new","line":101},{"containerName":"new","localvar":"my","kind":13,"name":"$self","line":102,"definition":"my"},{"line":102,"name":"$pkg","kind":13,"containerName":"new"},{"line":102,"kind":13,"containerName":"new","name":"@args"},{"line":104,"containerName":"new","localvar":"my","kind":13,"name":"$leavesR","definition":"my"},{"line":104,"name":"$numleaves","kind":13,"containerName":"new"},{"line":104,"kind":13,"containerName":"new","name":"$numhybrids"},{"line":105,"containerName":"new","kind":13,"name":"$self"},{"line":105,"kind":12,"containerName":"new","name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":107},{"line":108,"localvar":"my","kind":13,"containerName":"new","name":"@leaves","definition":"my"},{"line":109,"kind":13,"containerName":"new","name":"$leavesR"},{"line":109,"name":"$numleaves","containerName":"new","kind":13},{"line":110,"kind":13,"containerName":"new","name":"@leaves"},{"line":110,"containerName":"new","kind":13,"name":"$numleaves"},{"line":111,"name":"$leavesR","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"@leaves","line":111},{"name":"$leavesR","containerName":"new","kind":13,"line":113},{"name":"$self","kind":13,"containerName":"new","line":114},{"line":114,"name":"throw","kind":12,"containerName":"new"},{"containerName":"new","kind":13,"name":"@leaves","line":116},{"name":"$leavesR","containerName":"new","kind":13,"line":116},{"line":117,"name":"$self","containerName":"new","kind":13},{"name":"$leavesR","containerName":"new","kind":13,"line":117},{"line":118,"name":"$numleaves","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"@leaves","line":118},{"kind":13,"containerName":"new","name":"$self","line":119},{"kind":13,"containerName":"new","name":"$numleaves","line":119},{"line":121,"kind":13,"containerName":"new","name":"$numhybrids"},{"kind":13,"containerName":"new","name":"$numhybrids","line":122},{"line":122,"kind":13,"containerName":"new","name":"$numleaves"},{"line":124,"containerName":"new","kind":13,"name":"$self"},{"line":124,"kind":13,"containerName":"new","name":"$numhybrids"},{"name":"$numhybrids","kind":13,"containerName":"new","line":125},{"line":126,"kind":12,"containerName":"new","name":"new"},{"name":"@leaves","containerName":"new","kind":13,"line":126},{"name":"$parent","localvar":"my","kind":13,"containerName":"new","line":128,"definition":"my"},{"kind":13,"containerName":"new","name":"$numhybrids","line":129},{"line":130,"containerName":"new","kind":13,"name":"$parent"},{"containerName":"new","kind":13,"name":"$pkg","line":130},{"line":130,"name":"@leaves","kind":13,"containerName":"new"},{"name":"$numhybrids","kind":13,"containerName":"new","line":131},{"localvar":"my","kind":13,"containerName":"new","name":"@subfactories","line":133,"definition":"my"},{"name":"$parent","kind":13,"containerName":"new","line":133},{"line":134,"containerName":"new","kind":13,"name":"@subfactories"},{"line":134,"containerName":"new","kind":13,"name":"$parent"},{"kind":13,"containerName":"new","name":"$self","line":137},{"line":137,"name":"@subfactories","containerName":"new","kind":13}]},{"name":"TreeFactoryX","containerName":"Bio::PhyloNetwork::Bio::PhyloNetwork","kind":2,"line":101},{"name":"SUPER","kind":12,"containerName":"new","line":102},{"kind":12,"name":"leaves","line":117},{"line":119,"kind":12,"name":"numleaves"},{"line":124,"kind":12,"name":"numhybrids"},{"line":126,"name":"Bio","kind":12,"containerName":"PhyloNetwork::TreeFactoryX"},{"line":133,"name":"subfactories","kind":12},{"name":"subfactories","kind":12,"line":137},{"kind":13,"containerName":null,"name":"$parent","line":141},{"line":141,"kind":12,"containerName":"PhyloNetwork::TreeFactoryX","name":"Bio"},{"name":"new","kind":12,"containerName":"main::","line":141},{"containerName":null,"kind":13,"name":"@leaves","line":141},{"line":142,"containerName":null,"kind":13,"name":"%self"},{"name":"subfactories","kind":12,"line":142},{"name":"$parent","containerName":null,"kind":13,"line":142},{"line":144,"containerName":null,"kind":13,"name":"%self"},{"line":144,"kind":12,"name":"parent"},{"name":"$parent","kind":13,"containerName":null,"line":144},{"line":145,"kind":13,"containerName":null,"name":"$self"},{"name":"update","containerName":"main::","kind":12,"line":145},{"name":"%self","containerName":null,"kind":13,"line":146},{"name":"found","kind":12,"line":146},{"line":147,"name":"%self","kind":13,"containerName":null},{"kind":12,"name":"thrown","line":147},{"kind":13,"containerName":null,"name":"%self","line":148},{"name":"hybnow","kind":12,"line":148},{"name":"$self","kind":13,"containerName":null,"line":149},{"name":"$pkg","kind":13,"containerName":null,"line":149},{"children":[{"line":153,"kind":13,"localvar":"my","containerName":"update","name":"$self","definition":"my"},{"line":155,"containerName":"update","kind":13,"name":"$self"},{"line":156,"name":"@candidates","localvar":"my","kind":13,"containerName":"update","definition":"my"},{"kind":13,"containerName":"update","name":"$self","line":156},{"containerName":"update","kind":12,"name":"edges","line":156},{"line":157,"name":"$self","containerName":"update","kind":13},{"name":"@candidates","containerName":"update","kind":13,"line":157},{"containerName":"update","kind":13,"name":"$self","line":158},{"line":158,"kind":13,"containerName":"update","name":"@candidates"},{"name":"$self","kind":13,"containerName":"update","line":159},{"containerName":"update","kind":13,"name":"$self","line":160},{"line":162,"containerName":"update","kind":13,"name":"$self"},{"containerName":"update","kind":13,"name":"$self","line":163},{"line":164,"containerName":"update","kind":13,"name":"$self"},{"line":165,"containerName":"update","kind":13,"name":"$self"}],"containerName":"main::","name":"update","definition":"sub","detail":"($self)","line":152,"kind":12,"range":{"start":{"line":152,"character":0},"end":{"character":9999,"line":167}},"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"update($self)"}},{"name":"oldnet","kind":12,"line":155},{"line":156,"name":"oldnet","kind":12},{"name":"candidates","kind":12,"line":157},{"kind":12,"name":"numcandidates","line":158},{"line":159,"name":"index1","kind":12},{"line":160,"kind":12,"name":"index2"},{"name":"candidates","kind":12,"line":162},{"name":"numcandidates","kind":12,"line":163},{"kind":12,"name":"index1","line":164},{"line":165,"kind":12,"name":"index2"},{"containerName":"main::","name":"next_network_repeated","children":[{"line":170,"name":"$self","kind":13,"localvar":"my","containerName":"next_network_repeated","definition":"my"},{"line":172,"name":"$self","kind":13,"containerName":"next_network_repeated"},{"line":172,"kind":13,"containerName":"next_network_repeated","name":"$self"}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":172},"start":{"line":169,"character":0}},"line":169,"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"next_network_repeated($self)"}},{"name":"thrown","kind":12,"line":172},{"name":"found","kind":12,"line":172},{"name":"%self","kind":13,"containerName":null,"line":173},{"line":173,"name":"thrown","kind":12},{"containerName":null,"kind":13,"name":"%self","line":173},{"line":173,"name":"thrown","kind":12},{"name":"%self","kind":13,"containerName":null,"line":174},{"kind":12,"name":"found","line":174},{"line":174,"kind":13,"containerName":null,"name":"%self"},{"line":174,"name":"thrown","kind":12},{"containerName":"main::","name":"next_network_new","children":[{"line":178,"containerName":"next_network_new","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":181,"name":"$self","containerName":"next_network_new","kind":13},{"name":"$self","containerName":"next_network_new","kind":13,"line":181},{"name":"$self","containerName":"next_network_new","kind":13,"line":182},{"name":"$self","containerName":"next_network_new","kind":13,"line":183},{"line":186,"name":"$self","containerName":"next_network_new","kind":13},{"name":"$self","kind":13,"containerName":"next_network_new","line":186},{"definition":"my","line":187,"localvar":"my","kind":13,"containerName":"next_network_new","name":"$oldnet"},{"line":187,"kind":13,"containerName":"next_network_new","name":"$self"},{"line":187,"name":"next_network_repeated","kind":12,"containerName":"next_network_new"},{"line":188,"name":"$oldnet","kind":13,"containerName":"next_network_new"},{"line":192,"containerName":"next_network_new","kind":13,"name":"$self"},{"name":"$oldnet","kind":13,"containerName":"next_network_new","line":192},{"containerName":"next_network_new","kind":13,"name":"$self","line":193},{"kind":12,"containerName":"next_network_new","name":"update","line":193},{"line":195,"name":"$u1","localvar":"my","containerName":"next_network_new","kind":13,"definition":"my"},{"line":195,"name":"$self","kind":13,"containerName":"next_network_new"},{"line":195,"name":"$self","kind":13,"containerName":"next_network_new"},{"definition":"my","name":"$v1","containerName":"next_network_new","localvar":"my","kind":13,"line":196},{"name":"$self","kind":13,"containerName":"next_network_new","line":196},{"line":196,"name":"$self","kind":13,"containerName":"next_network_new"},{"containerName":"next_network_new","localvar":"my","kind":13,"name":"$u2","line":197,"definition":"my"},{"line":197,"name":"$self","containerName":"next_network_new","kind":13},{"line":197,"kind":13,"containerName":"next_network_new","name":"$self"},{"line":198,"localvar":"my","containerName":"next_network_new","kind":13,"name":"$v2","definition":"my"},{"name":"$self","kind":13,"containerName":"next_network_new","line":198},{"kind":13,"containerName":"next_network_new","name":"$self","line":198},{"definition":"my","name":"$lbl","containerName":"next_network_new","localvar":"my","kind":13,"line":199},{"line":199,"kind":13,"containerName":"next_network_new","name":"$self"},{"containerName":"next_network_new","kind":13,"name":"$self","line":200},{"line":200,"name":"is_attackable","kind":12,"containerName":"next_network_new"},{"line":200,"containerName":"next_network_new","kind":13,"name":"$u1"},{"name":"$v1","kind":13,"containerName":"next_network_new","line":200},{"name":"$u2","kind":13,"containerName":"next_network_new","line":200},{"containerName":"next_network_new","kind":13,"name":"$v2","line":200},{"line":201,"containerName":"next_network_new","localvar":"my","kind":13,"name":"$net","definition":"my"},{"line":201,"kind":12,"containerName":"next_network_new","name":"new"},{"line":201,"containerName":"next_network_new","kind":13,"name":"$self"},{"line":201,"kind":12,"containerName":"next_network_new","name":"graph"},{"kind":13,"containerName":"next_network_new","name":"$net","line":202},{"kind":12,"containerName":"next_network_new","name":"do_attack","line":202},{"line":202,"kind":13,"containerName":"next_network_new","name":"$u1"},{"kind":13,"containerName":"next_network_new","name":"$v1","line":202},{"name":"$u2","containerName":"next_network_new","kind":13,"line":202},{"line":202,"name":"$v2","kind":13,"containerName":"next_network_new"},{"line":202,"containerName":"next_network_new","kind":13,"name":"$lbl"},{"containerName":"next_network_new","kind":13,"name":"$self","line":203},{"containerName":"next_network_new","localvar":"my","kind":13,"name":"@found","line":204,"definition":"my"},{"containerName":"next_network_new","kind":13,"name":"$self","line":204},{"definition":"my","line":205,"localvar":"my","kind":13,"containerName":"next_network_new","name":"$netant"},{"line":205,"name":"@found","containerName":"next_network_new","kind":13},{"line":206,"kind":13,"containerName":"next_network_new","name":"$net"},{"kind":12,"containerName":"next_network_new","name":"is_mu_isomorphic","line":206},{"containerName":"next_network_new","kind":13,"name":"$netant","line":206},{"containerName":"next_network_new","kind":13,"name":"@found","line":210},{"line":210,"containerName":"next_network_new","kind":13,"name":"$net"},{"line":211,"name":"$self","containerName":"next_network_new","kind":13},{"line":211,"name":"@found","containerName":"next_network_new","kind":13},{"line":212,"name":"$net","containerName":"next_network_new","kind":13}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"line":177,"character":0},"end":{"line":213,"character":9999}},"line":177,"signature":{"label":"next_network_new($self)","parameters":[{"label":"$self"}],"documentation":""}},{"line":179,"kind":12,"name":"START"},{"line":181,"name":"index1","kind":12},{"name":"numcandidates","kind":12,"line":181},{"kind":12,"name":"index2","line":182},{"line":183,"kind":12,"name":"index1"},{"kind":12,"name":"index2","line":186},{"line":186,"kind":12,"name":"numcandidates"},{"line":187,"name":"parent","kind":12},{"name":"oldnet","kind":12,"line":192},{"name":"candidates","kind":12,"line":195},{"kind":12,"name":"index1","line":195},{"line":196,"kind":12,"name":"candidates"},{"line":196,"name":"index1","kind":12},{"name":"candidates","kind":12,"line":197},{"name":"index2","kind":12,"line":197},{"name":"candidates","kind":12,"line":198},{"kind":12,"name":"index2","line":198},{"line":199,"name":"numhybrids","kind":12},{"name":"oldnet","kind":12,"line":200},{"kind":12,"containerName":"PhyloNetwork","name":"Bio","line":201},{"line":201,"name":"oldnet","kind":12},{"name":"index1","kind":12,"line":203},{"line":204,"kind":12,"name":"found"},{"kind":12,"name":"START","line":207},{"name":"found","kind":12,"line":211},{"name":"%self","containerName":null,"kind":13,"line":215},{"line":215,"name":"index1","kind":12},{"name":"START","kind":12,"line":216},{"line":230,"range":{"start":{"character":0,"line":230},"end":{"line":254,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: FactoryX.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::FactoryX\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::FactoryX - Module to sequentially generate\nPhylogenetic Networks\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::Factory;\n\n # Will generate sequentially all the 4059 binary tree-child phylogenetic\n # networks with 4 leaves\n\n my $factory=Bio::PhyloNetwork::Factory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary tree-child) phylogenetic network each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::FactoryX;\n\nuse strict;\nuse warnings;\n\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\nuse Bio::PhyloNetwork::TreeFactoryX;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::Factory();\n Function: Creates a new Bio::PhyloNetwork::Factory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n           -numhybrids => integer [default = numleaves -1]\n           -recurse => boolean [optional]\n\nReturns a Bio::PhyloNetwork::Factory object. Such an object will\nsequentially create binary tree-child phylogenetic networks\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\nIf the parameter -numhybrids=E<gt>$numhybrids is given, then the generated\nnetworks will have at most $numhybrids hybrid nodes. Note that, necessarily,\n$numhybrids E<lt> $numleaves.\n\nIf the parameter -recurse=E<gt>1 is given, then all networks with number of hybrid\nnodes less or equal to $numhybrids will be given; otherwise only those with\nexactly $numhybrids hybrid nodes.\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($leavesR,$numleaves,$numhybrids)=\n    $self->_rearrange([qw(LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  NUMHYBRIDS)],@args);\n  my @leaves;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  if (! defined $leavesR) {\n    $self->throw(\"No leaves set neither numleaves given\");\n  }\n  @leaves=@$leavesR;\n  $self->{leaves}=$leavesR;\n  $numleaves=@leaves;\n  $self->{numleaves}=$numleaves;\n\n  if (! defined $numhybrids) {\n    $numhybrids=$numleaves-1;\n  }\n  $self->{numhybrids}=$numhybrids;\n  if ($numhybrids ==0) {\n    return Bio::PhyloNetwork::TreeFactoryX->new(-leaves=>\\@leaves);\n  }\n  my $parent;\n  if ($numhybrids > 1) {\n    $parent=new($pkg,'-leaves'=>\\@leaves,\n\t\t'-numhybrids'=>($numhybrids-1)\n\t       );\n    my @subfactories=@{$parent->{subfactories}};\n    push @subfactories,$parent;\n#    print \"$numhybrids : \".(scalar @subfactories);\n#    print \"\\n\";\n    $self->{subfactories}=\\@subfactories;\n#    print \"$numhybrids: \".(scalar @subfactories).\"\\n\";\n  }\n  else {\n    $parent=Bio::PhyloNetwork::TreeFactoryX->new(-leaves=>\\@leaves);\n    $self->{subfactories}=[$parent];\n  }\n  $self->{parent}=$parent;\n  $self->update();\n  $self->{found}=[];\n  $self->{thrown}=0;\n  $self->{hybnow}=0;\n  bless($self,$pkg);\n}\n\nsub update {\n  my ($self)=@_;\n\n  if (defined $self->{oldnet}) {\n    my @candidates=$self->{oldnet}->edges();\n    $self->{candidates}=\\@candidates;\n    $self->{numcandidates}=(scalar @candidates);\n    $self->{index1}=0;\n    $self->{index2}=0;\n  } else {\n    $self->{candidates}=[];\n    $self->{numcandidates}=0;\n    $self->{index1}=0;\n    $self->{index2}=0;\n  }\n}\n\nsub next_network_repeated {\n  my ($self)=@_;\n\n  return 0 if ($self->{thrown} >= (scalar @{$self->{found}}));\n  $self->{thrown}=$self->{thrown}+1;\n  return $self->{found}->[$self->{thrown}-1];\n}\n\nsub next_network_new {\n  my ($self)=@_;\n START:\n#  print $self->{index1}.\",\".$self->{index2}.\":\".$self->{numcandidates}.\"\\n\";\n  if ($self->{index1} >= $self->{numcandidates}) {\n    $self->{index2}++;\n    $self->{index1}=0;\n  }\n#  print $self->{index1}.\",\".$self->{index2}.\":\".$self->{numcandidates}.\"\\n\";\n  if ($self->{index2} >= $self->{numcandidates}) {\n    my $oldnet=$self->{parent}->next_network_repeated();\n    if (! $oldnet) {\n#      print \"notoldnet\\n\";\n      return 0;\n    }\n    $self->{oldnet}=$oldnet;\n    $self->update();\n  }\n  my $u1=$self->{candidates}->[$self->{index1}]->[0];\n  my $v1=$self->{candidates}->[$self->{index1}]->[1];\n  my $u2=$self->{candidates}->[$self->{index2}]->[0];\n  my $v2=$self->{candidates}->[$self->{index2}]->[1];\n  my $lbl=$self->{numhybrids};\n  if ($self->{oldnet}->is_attackable($u1,$v1,$u2,$v2)) {\n    my $net=Bio::PhyloNetwork->new(-graph=>$self->{oldnet}->graph);\n    $net->do_attack($u1,$v1,$u2,$v2,$lbl);\n    $self->{index1}++;\n    my @found=@{$self->{found}};\n    foreach my $netant (@found) {\n      if ($net->is_mu_isomorphic($netant) ) {\n\tgoto START;\n      }\n    }\n    push @found,$net;\n    $self->{found}=\\@found;\n    return $net;\n  }\n  else {\n    $self->{index1}++;\n    goto START;\n  }\n}\n\n=head2 next_network\n\n Title   : next_network\n Usage   : my $net=$factory->next_network()\n Function: returns a network\n Returns : Bio::PhyloNetwork\n Args    : none","parameters":[{"label":"$self"}],"label":"next_network($self)"},"children":[{"line":231,"containerName":"next_network","localvar":"my","kind":13,"name":"$self","definition":"my"},{"definition":"my","line":232,"name":"$hybnow","containerName":"next_network","localvar":"my","kind":13},{"line":234,"containerName":"next_network","kind":13,"name":"$hybnow"},{"containerName":"next_network","kind":13,"name":"$self","line":234},{"line":240,"kind":13,"localvar":"my","containerName":"next_network","name":"$net","definition":"my"},{"name":"$hybnow","containerName":"next_network","kind":13,"line":241},{"name":"$self","kind":13,"containerName":"next_network","line":241},{"name":"$net","kind":13,"containerName":"next_network","line":242},{"line":242,"name":"$self","kind":13,"containerName":"next_network"},{"line":242,"containerName":"next_network","kind":13,"name":"$hybnow"},{"name":"next_network_new","kind":12,"containerName":"next_network","line":242},{"line":244,"name":"$net","containerName":"next_network","kind":13},{"line":244,"kind":13,"containerName":"next_network","name":"$self"},{"name":"next_network_new","containerName":"next_network","kind":12,"line":244},{"containerName":"next_network","kind":13,"name":"$net","line":246},{"line":247,"kind":13,"containerName":"next_network","name":"$hybnow"},{"line":247,"kind":13,"containerName":"next_network","name":"$self"},{"line":248,"containerName":"next_network","kind":13,"name":"$self"},{"line":248,"name":"$self","kind":13,"containerName":"next_network"},{"kind":13,"containerName":"next_network","name":"$net","line":253}],"containerName":"main::","name":"next_network","definition":"sub","detail":"($self)"},{"kind":12,"name":"WTF","line":233},{"line":234,"name":"hybnow","kind":12},{"line":241,"name":"numhybrids","kind":12},{"line":242,"kind":12,"name":"subfactories"},{"line":247,"name":"numhybrids","kind":12},{"line":248,"name":"hybnow","kind":12},{"line":248,"kind":12,"name":"hybnow"},{"name":"WTF","kind":12,"line":249}],"version":5}