{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":257},{"children":[{"line":329,"name":"$pkg","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"line":329,"name":"@args","containerName":"new","kind":13},{"line":330,"localvar":"my","kind":13,"containerName":"new","name":"$self","definition":"my"},{"line":330,"kind":13,"containerName":"new","name":"$pkg"},{"line":330,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$eNewick","line":331},{"name":"$edgesR","containerName":"new","kind":13,"line":331},{"name":"$leavesR","kind":13,"containerName":"new","line":331},{"line":331,"name":"$numleaves","containerName":"new","kind":13},{"line":331,"name":"$graph","containerName":"new","kind":13},{"line":331,"name":"$tree","containerName":"new","kind":13},{"line":331,"kind":13,"containerName":"new","name":"$mudataR"},{"kind":13,"containerName":"new","name":"$self","line":332},{"containerName":"new","kind":12,"name":"_rearrange","line":332},{"name":"@args","containerName":"new","kind":13,"line":338},{"line":339,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":13,"name":"$pkg","line":339},{"line":341,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"build_from_eNewick","line":341},{"line":341,"kind":13,"containerName":"new","name":"$eNewick"},{"line":341,"kind":13,"containerName":"new","name":"$eNewick"},{"name":"$self","kind":13,"containerName":"new","line":342},{"kind":12,"containerName":"new","name":"build_from_edges","line":342},{"line":342,"name":"$edgesR","kind":13,"containerName":"new"},{"line":342,"containerName":"new","kind":13,"name":"$edgesR"},{"line":343,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"build_from_graph","line":343},{"name":"$graph","kind":13,"containerName":"new","line":343},{"name":"$graph","containerName":"new","kind":13,"line":343},{"name":"$self","containerName":"new","kind":13,"line":344},{"line":344,"kind":12,"containerName":"new","name":"build_from_tree"},{"line":344,"name":"$tree","containerName":"new","kind":13},{"name":"$tree","containerName":"new","kind":13,"line":344},{"containerName":"new","kind":13,"name":"$leavesR","line":345},{"line":345,"name":"$numleaves","containerName":"new","kind":13},{"line":346,"name":"@leaves","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"line":346,"kind":13,"containerName":"new","name":"$numleaves"},{"line":347,"name":"$leavesR","containerName":"new","kind":13},{"line":347,"name":"@leaves","containerName":"new","kind":13},{"line":349,"containerName":"new","kind":13,"name":"$self"},{"line":349,"name":"build_from_mudata","kind":12,"containerName":"new"},{"name":"$mudataR","containerName":"new","kind":13,"line":349},{"containerName":"new","kind":13,"name":"$leavesR","line":349},{"line":350,"containerName":"new","kind":13,"name":"$mudataR"},{"containerName":"new","kind":13,"name":"$leavesR","line":350},{"line":351,"name":"$self","containerName":"new","kind":13}],"containerName":"main::","name":"new","definition":"sub","detail":"($pkg,@args)","line":328,"kind":12,"range":{"start":{"character":0,"line":328},"end":{"line":352,"character":9999}},"signature":{"parameters":[{"label":"$pkg"},{"label":"@args"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").","label":"new($pkg,@args)"}},{"line":329,"kind":2,"containerName":"Bio::PhyloNetwork::muVector::Graph::Directed::Bio::TreeIO::Bio::Tree::Node::IO::String::Array::Compare::Algorithm","name":"Munkres"},{"line":330,"containerName":"new","kind":12,"name":"SUPER"},{"signature":{"label":"build_from_edges($self,@edges)","documentation":" Builders","parameters":[{"label":"$self"},{"label":"@edges"}]},"kind":12,"range":{"start":{"line":356,"character":0},"end":{"line":367,"character":9999}},"line":356,"detail":"($self,@edges)","definition":"sub","name":"build_from_edges","containerName":"main::","children":[{"definition":"my","line":357,"localvar":"my","containerName":"build_from_edges","kind":13,"name":"$self"},{"containerName":"build_from_edges","kind":13,"name":"@edges","line":357},{"definition":"my","line":358,"name":"$graph","kind":13,"localvar":"my","containerName":"build_from_edges"},{"name":"new","containerName":"build_from_edges","kind":12,"line":358},{"line":359,"name":"$graph","containerName":"build_from_edges","kind":13},{"line":359,"kind":12,"containerName":"build_from_edges","name":"add_edges"},{"line":359,"name":"@edges","containerName":"build_from_edges","kind":13},{"line":360,"name":"$self","kind":13,"containerName":"build_from_edges"},{"containerName":"build_from_edges","kind":13,"name":"$graph","line":360},{"line":361,"kind":13,"containerName":"build_from_edges","name":"$self"},{"containerName":"build_from_edges","kind":12,"name":"recompute","line":361},{"definition":"my","line":362,"localvar":"my","kind":13,"containerName":"build_from_edges","name":"$labels"},{"definition":"my","localvar":"my","kind":13,"containerName":"build_from_edges","name":"$node","line":363},{"name":"$self","kind":13,"containerName":"build_from_edges","line":363},{"containerName":"build_from_edges","kind":12,"name":"nodes","line":363},{"line":364,"name":"$labels","containerName":"build_from_edges","kind":13},{"line":364,"containerName":"build_from_edges","kind":13,"name":"$node"},{"kind":13,"containerName":"build_from_edges","name":"$node","line":364},{"line":366,"kind":13,"containerName":"build_from_edges","name":"$self"},{"line":366,"name":"$labels","containerName":"build_from_edges","kind":13}]},{"line":358,"containerName":"Directed","kind":12,"name":"Graph"},{"line":360,"kind":12,"name":"graph"},{"kind":12,"name":"labels","line":366},{"kind":12,"range":{"start":{"character":0,"line":369},"end":{"character":9999,"line":379}},"line":369,"signature":{"label":"build_from_graph($self,$graph)","parameters":[{"label":"$self"},{"label":"$graph"}],"documentation":""},"containerName":"main::","name":"build_from_graph","children":[{"definition":"my","name":"$self","containerName":"build_from_graph","localvar":"my","kind":13,"line":370},{"line":370,"name":"$graph","kind":13,"containerName":"build_from_graph"},{"line":371,"localvar":"my","kind":13,"containerName":"build_from_graph","name":"$graphcp","definition":"my"},{"line":371,"kind":13,"containerName":"build_from_graph","name":"$graph"},{"line":371,"name":"copy","containerName":"build_from_graph","kind":12},{"line":372,"name":"$self","containerName":"build_from_graph","kind":13},{"line":372,"name":"$graphcp","containerName":"build_from_graph","kind":13},{"containerName":"build_from_graph","kind":13,"name":"$self","line":373},{"kind":12,"containerName":"build_from_graph","name":"recompute","line":373},{"localvar":"my","kind":13,"containerName":"build_from_graph","name":"$labels","line":374,"definition":"my"},{"definition":"my","localvar":"my","containerName":"build_from_graph","kind":13,"name":"$node","line":375},{"name":"$self","containerName":"build_from_graph","kind":13,"line":375},{"line":375,"containerName":"build_from_graph","kind":12,"name":"nodes"},{"line":376,"name":"$labels","kind":13,"containerName":"build_from_graph"},{"line":376,"name":"$node","kind":13,"containerName":"build_from_graph"},{"line":376,"name":"$node","kind":13,"containerName":"build_from_graph"},{"kind":13,"containerName":"build_from_graph","name":"$self","line":378},{"line":378,"name":"$labels","containerName":"build_from_graph","kind":13}],"detail":"($self,$graph)","definition":"sub"},{"line":372,"name":"graph","kind":12},{"name":"labels","kind":12,"line":378},{"line":381,"localvar":"my","kind":13,"containerName":null,"name":"$_eN_index","definition":"my"},{"children":[{"definition":"my","line":384,"name":"$self","containerName":"build_from_eNewick","localvar":"my","kind":13},{"kind":13,"containerName":"build_from_eNewick","name":"$string","line":384},{"line":385,"kind":13,"containerName":"build_from_eNewick","name":"$_eN_index"},{"line":386,"containerName":"build_from_eNewick","localvar":"my","kind":13,"name":"$graph","definition":"my"},{"line":386,"containerName":"build_from_eNewick","kind":12,"name":"new"},{"line":387,"localvar":"my","kind":13,"containerName":"build_from_eNewick","name":"$labels","definition":"my"},{"definition":"my","line":388,"name":"@blocks","containerName":"build_from_eNewick","localvar":"my","kind":13},{"line":388,"name":"$string","containerName":"build_from_eNewick","kind":13},{"name":"$block","localvar":"my","kind":13,"containerName":"build_from_eNewick","line":389,"definition":"my"},{"line":389,"name":"@blocks","kind":13,"containerName":"build_from_eNewick"},{"containerName":"build_from_eNewick","localvar":"my","kind":13,"name":"$rt","line":390,"definition":"my"},{"line":390,"kind":13,"containerName":"build_from_eNewick","name":"$str"},{"name":"$block","containerName":"build_from_eNewick","kind":13,"line":390},{"definition":"my","name":"$rtlbl","localvar":"my","kind":13,"containerName":"build_from_eNewick","line":391},{"line":391,"name":"$rttype","kind":13,"containerName":"build_from_eNewick"},{"line":391,"name":"$rtid","containerName":"build_from_eNewick","kind":13},{"line":391,"name":"$rtlng","kind":13,"containerName":"build_from_eNewick"},{"name":"$rt","kind":13,"containerName":"build_from_eNewick","line":391},{"containerName":"build_from_eNewick","kind":13,"name":"$graph","line":392},{"kind":13,"containerName":"build_from_eNewick","name":"$labels","line":392},{"name":"$block","kind":13,"containerName":"build_from_eNewick","line":392},{"name":"$rtid","kind":13,"containerName":"build_from_eNewick","line":392},{"kind":13,"containerName":"build_from_eNewick","name":"$labels","line":393},{"line":393,"containerName":"build_from_eNewick","kind":13,"name":"$rtid"},{"line":393,"containerName":"build_from_eNewick","kind":13,"name":"$rtlbl"},{"containerName":"build_from_eNewick","kind":13,"name":"$self","line":395},{"line":395,"name":"$graph","containerName":"build_from_eNewick","kind":13},{"line":396,"kind":13,"containerName":"build_from_eNewick","name":"$self"},{"line":396,"kind":13,"containerName":"build_from_eNewick","name":"$labels"},{"line":397,"kind":13,"containerName":"build_from_eNewick","name":"$self"},{"line":397,"name":"recompute","containerName":"build_from_eNewick","kind":12}],"name":"build_from_eNewick","containerName":"main::","definition":"sub","detail":"($self,$string)","line":383,"range":{"start":{"line":383,"character":0},"end":{"character":9999,"line":398}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$string"}],"documentation":"","label":"build_from_eNewick($self,$string)"}},{"line":386,"kind":12,"containerName":"Directed","name":"Graph"},{"name":"get_root_and_subtree","kind":12,"line":390},{"name":"get_label_type_id_length","kind":12,"line":391},{"kind":12,"name":"process_block","line":392},{"line":395,"kind":12,"name":"graph"},{"line":396,"name":"labels","kind":12},{"line":400,"kind":12,"range":{"end":{"line":430,"character":9999},"start":{"line":400,"character":0}},"signature":{"label":"process_block($graph,$labels,$block,$rtid)","parameters":[{"label":"$graph"},{"label":"$labels"},{"label":"$block"},{"label":"$rtid"}],"documentation":""},"children":[{"line":401,"name":"$graph","kind":13,"localvar":"my","containerName":"process_block","definition":"my"},{"kind":13,"containerName":"process_block","name":"$labels","line":401},{"line":401,"name":"$block","containerName":"process_block","kind":13},{"containerName":"process_block","kind":13,"name":"$rtid","line":401},{"name":"$rt","localvar":"my","kind":13,"containerName":"process_block","line":402,"definition":"my"},{"kind":13,"containerName":"process_block","name":"$str","line":402},{"containerName":"process_block","kind":13,"name":"$block","line":402},{"definition":"my","line":403,"name":"@substrs","localvar":"my","containerName":"process_block","kind":13},{"line":403,"name":"$str","containerName":"process_block","kind":13},{"line":404,"localvar":"my","containerName":"process_block","kind":13,"name":"$substr","definition":"my"},{"line":404,"name":"@substrs","kind":13,"containerName":"process_block"},{"line":405,"name":"$subrt","containerName":"process_block","localvar":"my","kind":13,"definition":"my"},{"containerName":"process_block","kind":13,"name":"$subblock","line":405},{"line":405,"kind":13,"containerName":"process_block","name":"$substr"},{"definition":"my","line":406,"name":"$subrtlbl","localvar":"my","kind":13,"containerName":"process_block"},{"line":406,"name":"$subrttype","containerName":"process_block","kind":13},{"line":406,"kind":13,"containerName":"process_block","name":"$subrtid"},{"name":"$subrtlng","containerName":"process_block","kind":13,"line":406},{"name":"$subrt","kind":13,"containerName":"process_block","line":407},{"line":408,"name":"$subrtlng","kind":13,"containerName":"process_block"},{"containerName":"process_block","kind":13,"name":"$graph","line":409},{"kind":12,"containerName":"process_block","name":"add_weighted_edges","line":409},{"containerName":"process_block","kind":13,"name":"$rtid","line":409},{"name":"$subrtid","containerName":"process_block","kind":13,"line":409},{"name":"$subrtlng","kind":13,"containerName":"process_block","line":409},{"line":412,"containerName":"process_block","kind":13,"name":"$graph"},{"kind":12,"containerName":"process_block","name":"add_edges","line":412},{"line":412,"name":"$rtid","kind":13,"containerName":"process_block"},{"line":412,"containerName":"process_block","kind":13,"name":"$subrtid"},{"line":414,"kind":13,"containerName":"process_block","name":"$subrttype"},{"kind":13,"containerName":"process_block","name":"$graph","line":415},{"containerName":"process_block","kind":12,"name":"set_edge_attribute","line":415},{"kind":13,"containerName":"process_block","name":"$rtid","line":415},{"line":415,"containerName":"process_block","kind":13,"name":"$subrtid"},{"kind":13,"containerName":"process_block","name":"$subrttype","line":415},{"kind":13,"containerName":"process_block","name":"$subrtlbl","line":417},{"line":419,"name":"$labels","kind":13,"containerName":"process_block"},{"kind":13,"containerName":"process_block","name":"$subrtid","line":419},{"kind":13,"containerName":"process_block","name":"$labels","line":419},{"name":"$subrtid","kind":13,"containerName":"process_block","line":419},{"kind":13,"containerName":"process_block","name":"$labels","line":420},{"containerName":"process_block","kind":13,"name":"$subrtid","line":420},{"line":420,"kind":13,"containerName":"process_block","name":"$subrtlbl"},{"containerName":"process_block","kind":13,"name":"$labels","line":421},{"line":421,"name":"$subrtid","containerName":"process_block","kind":13},{"line":421,"name":"$subrtlbl","containerName":"process_block","kind":13},{"name":"$subrtlbl","kind":13,"containerName":"process_block","line":421},{"name":"$labels","containerName":"process_block","kind":13,"line":423},{"name":"$subrtid","containerName":"process_block","kind":13,"line":423},{"kind":13,"containerName":"process_block","name":"$subblock","line":426},{"line":427,"name":"$graph","containerName":"process_block","kind":13},{"kind":13,"containerName":"process_block","name":"$labels","line":427},{"line":427,"name":"$subblock","kind":13,"containerName":"process_block"},{"line":427,"name":"$subrtid","kind":13,"containerName":"process_block"}],"name":"process_block","containerName":"main::","definition":"sub","detail":"($graph,$labels,$block,$rtid)"},{"line":402,"name":"get_root_and_subtree","kind":12},{"line":403,"kind":12,"name":"my_split"},{"line":405,"name":"get_root_and_subtree","kind":12},{"line":407,"kind":12,"name":"get_label_type_id_length"},{"detail":"($block)","definition":"sub","containerName":"main::","name":"get_root_and_subtree","children":[{"definition":"my","name":"$block","containerName":"get_root_and_subtree","localvar":"my","kind":13,"line":433},{"containerName":"get_root_and_subtree","localvar":"my","kind":13,"name":"$rt","line":434,"definition":"my"},{"containerName":"get_root_and_subtree","kind":13,"name":"$str","line":434},{"name":"$rt","kind":13,"containerName":"get_root_and_subtree","line":436},{"line":436,"name":"$str","containerName":"get_root_and_subtree","kind":13},{"line":436,"containerName":"get_root_and_subtree","kind":13,"name":"$block"},{"line":437,"containerName":"get_root_and_subtree","kind":13,"name":"$rt"},{"line":437,"name":"$block","containerName":"get_root_and_subtree","kind":13},{"definition":"my","localvar":"my","containerName":"get_root_and_subtree","kind":13,"name":"$pos","line":439},{"line":439,"kind":13,"containerName":"get_root_and_subtree","name":"$rt"},{"line":440,"containerName":"get_root_and_subtree","kind":13,"name":"$rt"},{"line":440,"name":"$pos","kind":13,"containerName":"get_root_and_subtree"},{"line":440,"name":"$pos","containerName":"get_root_and_subtree","kind":13},{"name":"$pos","kind":13,"containerName":"get_root_and_subtree","line":441},{"name":"$rt","kind":13,"containerName":"get_root_and_subtree","line":443},{"containerName":"get_root_and_subtree","kind":13,"name":"$block","line":443},{"line":443,"containerName":"get_root_and_subtree","kind":13,"name":"$pos"},{"kind":13,"containerName":"get_root_and_subtree","name":"$block","line":443},{"line":443,"containerName":"get_root_and_subtree","kind":13,"name":"$pos"},{"name":"$str","kind":13,"containerName":"get_root_and_subtree","line":444},{"line":444,"kind":13,"containerName":"get_root_and_subtree","name":"$block"},{"line":444,"name":"$pos","containerName":"get_root_and_subtree","kind":13},{"line":446,"kind":13,"containerName":"get_root_and_subtree","name":"$rt"},{"name":"$rt","containerName":"get_root_and_subtree","kind":13,"line":446},{"line":447,"containerName":"get_root_and_subtree","kind":13,"name":"$str"},{"line":447,"kind":13,"containerName":"get_root_and_subtree","name":"$str"},{"line":448,"kind":13,"containerName":"get_root_and_subtree","name":"$rt"},{"line":448,"name":"$str","containerName":"get_root_and_subtree","kind":13}],"signature":{"parameters":[{"label":"$block"}],"documentation":"","label":"get_root_and_subtree($block)"},"kind":12,"range":{"start":{"line":432,"character":0},"end":{"character":9999,"line":449}},"line":432},{"line":446,"name":"trim","kind":12},{"kind":12,"name":"trim","line":447},{"line":451,"kind":12,"range":{"end":{"line":479,"character":9999},"start":{"character":0,"line":451}},"signature":{"label":"get_label_type_id_length($string)","documentation":"","parameters":[{"label":"$string"}]},"children":[{"definition":"my","line":452,"containerName":"get_label_type_id_length","localvar":"my","kind":13,"name":"$string"},{"name":"$string","kind":13,"containerName":"get_label_type_id_length","line":453},{"line":455,"name":"$string","containerName":"get_label_type_id_length","kind":13},{"definition":"my","line":457,"localvar":"my","containerName":"get_label_type_id_length","kind":13,"name":"$label"},{"name":"$length","kind":13,"containerName":"get_label_type_id_length","line":457},{"kind":13,"containerName":"get_label_type_id_length","name":"$string","line":457},{"line":458,"name":"$label","containerName":"get_label_type_id_length","kind":13},{"localvar":"my","containerName":"get_label_type_id_length","kind":13,"name":"$id","line":459,"definition":"my"},{"name":"$label","containerName":"get_label_type_id_length","kind":13,"line":460},{"line":460,"name":"$label","kind":13,"containerName":"get_label_type_id_length"},{"name":"$_eN_index","containerName":"get_label_type_id_length","kind":13,"line":462},{"containerName":"get_label_type_id_length","kind":13,"name":"$id","line":463},{"line":465,"kind":13,"containerName":"get_label_type_id_length","name":"$id"},{"name":"$label","kind":13,"containerName":"get_label_type_id_length","line":465},{"line":467,"name":"$label","kind":13,"containerName":"get_label_type_id_length"},{"containerName":"get_label_type_id_length","kind":13,"name":"$id","line":467},{"name":"$length","containerName":"get_label_type_id_length","kind":13,"line":467},{"definition":"my","name":"$label","kind":13,"localvar":"my","containerName":"get_label_type_id_length","line":471},{"line":471,"kind":13,"containerName":"get_label_type_id_length","name":"$string2"},{"line":471,"name":"$string","containerName":"get_label_type_id_length","kind":13},{"name":"$typeid","localvar":"my","containerName":"get_label_type_id_length","kind":13,"line":472,"definition":"my"},{"name":"$length","containerName":"get_label_type_id_length","kind":13,"line":472},{"line":472,"name":"$string2","containerName":"get_label_type_id_length","kind":13},{"definition":"my","line":473,"name":"$type","containerName":"get_label_type_id_length","localvar":"my","kind":13},{"line":473,"containerName":"get_label_type_id_length","kind":13,"name":"$typeid"},{"line":474,"name":"$type","containerName":"get_label_type_id_length","kind":13},{"containerName":"get_label_type_id_length","localvar":"my","kind":13,"name":"$id","line":475,"definition":"my"},{"line":475,"name":"$typeid","kind":13,"containerName":"get_label_type_id_length"},{"line":476,"containerName":"get_label_type_id_length","kind":13,"name":"$id"},{"name":"$label","kind":13,"containerName":"get_label_type_id_length","line":477},{"line":477,"name":"$type","kind":13,"containerName":"get_label_type_id_length"},{"line":477,"name":"$id","containerName":"get_label_type_id_length","kind":13},{"containerName":"get_label_type_id_length","kind":13,"name":"$length","line":477}],"containerName":"main::","name":"get_label_type_id_length","definition":"sub","detail":"($string)"},{"line":481,"range":{"end":{"line":487,"character":9999},"start":{"character":0,"line":481}},"kind":12,"signature":{"label":"trim($string)","parameters":[{"label":"$string"}],"documentation":""},"children":[{"definition":"my","name":"$string","containerName":"trim","localvar":"my","kind":13,"line":483},{"line":484,"name":"$string","kind":13,"containerName":"trim"},{"line":485,"name":"$string","kind":13,"containerName":"trim"},{"name":"$string","kind":13,"containerName":"trim","line":486}],"name":"trim","containerName":"main::","definition":"sub","detail":"($string)"},{"children":[{"name":"$string","kind":13,"localvar":"my","containerName":"my_split","line":490,"definition":"my"},{"localvar":"my","kind":13,"containerName":"my_split","name":"$temp","line":491,"definition":"my"},{"name":"@substrings","localvar":"my","containerName":"my_split","kind":13,"line":492,"definition":"my"},{"line":493,"name":"$level","kind":13,"localvar":"my","containerName":"my_split","definition":"my"},{"name":"$i","kind":13,"localvar":"my","containerName":"my_split","line":494,"definition":"my"},{"containerName":"my_split","kind":13,"name":"$string","line":494},{"line":495,"name":"$char","localvar":"my","containerName":"my_split","kind":13,"definition":"my"},{"line":495,"name":"$string","kind":13,"containerName":"my_split"},{"line":495,"kind":13,"containerName":"my_split","name":"$i"},{"containerName":"my_split","kind":13,"name":"$char","line":496},{"name":"$level","containerName":"my_split","kind":13,"line":497},{"line":499,"containerName":"my_split","kind":13,"name":"$char"},{"line":500,"containerName":"my_split","kind":13,"name":"$level"},{"line":501,"kind":13,"containerName":"my_split","name":"@substrings"},{"line":501,"name":"$temp","kind":13,"containerName":"my_split"},{"name":"$temp","containerName":"my_split","kind":13,"line":502},{"line":504,"name":"$level","containerName":"my_split","kind":13},{"line":506,"containerName":"my_split","kind":13,"name":"$char"},{"line":506,"kind":13,"containerName":"my_split","name":"$level"},{"name":"@substrings","containerName":"my_split","kind":13,"line":507},{"containerName":"my_split","kind":13,"name":"$temp","line":507},{"line":508,"name":"$temp","containerName":"my_split","kind":13},{"name":"$char","containerName":"my_split","kind":13,"line":509},{"containerName":"my_split","kind":13,"name":"$temp","line":511},{"line":511,"kind":13,"containerName":"my_split","name":"$temp"},{"line":511,"kind":13,"containerName":"my_split","name":"$char"},{"line":513,"name":"@substrings","containerName":"my_split","kind":13}],"name":"my_split","containerName":"main::","definition":"sub","detail":"($string)","line":489,"range":{"end":{"character":9999,"line":514},"start":{"line":489,"character":0}},"kind":12,"signature":{"label":"my_split($string)","documentation":"","parameters":[{"label":"$string"}]}},{"signature":{"label":"build_from_mudata($self,$mus,$leavesR)","documentation":"","parameters":[{"label":"$self"},{"label":"$mus"},{"label":"$leavesR"}]},"range":{"start":{"line":516,"character":0},"end":{"line":519,"character":9999}},"kind":12,"line":516,"detail":"($self,$mus,$leavesR)","definition":"sub","containerName":"main::","name":"build_from_mudata","children":[{"definition":"my","name":"$self","containerName":"build_from_mudata","localvar":"my","kind":13,"line":517},{"name":"$mus","containerName":"build_from_mudata","kind":13,"line":517},{"line":517,"name":"$leavesR","containerName":"build_from_mudata","kind":13},{"line":518,"name":"$graph","kind":13,"localvar":"my","containerName":"build_from_mudata","definition":"my"},{"containerName":"build_from_mudata","kind":12,"name":"new","line":518},{"line":519,"localvar":"my","kind":13,"containerName":"build_from_mudata","name":"@nodes","definition":"my"},{"kind":13,"containerName":"build_from_mudata","name":"$mus","line":519}]},{"kind":12,"containerName":"Directed","name":"Graph","line":518},{"localvar":"my","kind":13,"containerName":null,"name":"@leaves","line":520,"definition":"my"},{"containerName":null,"kind":13,"name":"$leavesR","line":520},{"localvar":"my","containerName":null,"kind":13,"name":"%seen","line":522,"definition":"my"},{"line":523,"kind":13,"localvar":"my","containerName":null,"name":"@internal","definition":"my"},{"line":525,"name":"@seen","kind":13,"containerName":null},{"line":525,"name":"@leaves","containerName":null,"kind":13},{"definition":"my","name":"$node","localvar":"my","kind":13,"containerName":null,"line":527},{"line":527,"name":"@nodes","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@internal","line":528},{"line":528,"name":"$node","kind":13,"containerName":null},{"line":528,"kind":13,"containerName":null,"name":"%seen"},{"name":"$node","kind":13,"containerName":null,"line":528},{"line":531,"name":"@internal","kind":13,"containerName":null},{"name":"%mus","containerName":null,"kind":13,"line":531},{"containerName":null,"kind":13,"name":"$b","line":531},{"name":"%mus","kind":13,"containerName":null,"line":531},{"containerName":null,"kind":13,"name":"$a","line":531},{"name":"@internal","containerName":null,"kind":13,"line":531},{"name":"@nodes","kind":13,"containerName":null,"line":532},{"containerName":null,"kind":13,"name":"@internal","line":532},{"line":532,"kind":13,"containerName":null,"name":"@leaves"},{"definition":"my","line":533,"name":"$numnodes","containerName":null,"localvar":"my","kind":13},{"name":"@nodes","containerName":null,"kind":13,"line":533},{"definition":"my","name":"$i","kind":13,"localvar":"my","containerName":null,"line":534},{"line":534,"containerName":null,"kind":13,"name":"$i"},{"line":534,"name":"$numnodes","containerName":null,"kind":13},{"line":534,"kind":13,"containerName":null,"name":"%i"},{"definition":"my","line":535,"name":"$mu","localvar":"my","kind":13,"containerName":null},{"name":"%mus","containerName":null,"kind":13,"line":535},{"line":535,"name":"@nodes","containerName":null,"kind":13},{"name":"$i","kind":13,"containerName":null,"line":535},{"definition":"my","line":536,"name":"$j","containerName":null,"localvar":"my","kind":13},{"name":"$i","kind":13,"containerName":null,"line":536},{"kind":13,"containerName":null,"name":"$mu","line":537},{"kind":12,"containerName":"main::","name":"is_positive","line":537},{"line":537,"name":"$j","kind":13,"containerName":null},{"line":537,"kind":13,"containerName":null,"name":"%numnodes"},{"kind":13,"containerName":null,"name":"$mu","line":538},{"name":"geq_poset","kind":12,"containerName":"main::","line":538},{"line":538,"kind":13,"containerName":null,"name":"%mus"},{"line":538,"kind":13,"containerName":null,"name":"@nodes"},{"line":538,"containerName":null,"kind":13,"name":"%j"},{"name":"$graph","kind":13,"containerName":null,"line":539},{"name":"add_edges","kind":12,"containerName":"main::","line":539},{"name":"@nodes","containerName":null,"kind":13,"line":539},{"line":539,"containerName":null,"kind":13,"name":"$i"},{"name":"@nodes","kind":13,"containerName":null,"line":539},{"line":539,"kind":13,"containerName":null,"name":"$j"},{"kind":13,"containerName":null,"name":"$mu","line":540},{"kind":13,"containerName":null,"name":"$mu","line":540},{"name":"%mus","kind":13,"containerName":null,"line":540},{"line":540,"kind":13,"containerName":null,"name":"@nodes"},{"name":"$j","containerName":null,"kind":13,"line":540},{"name":"$j","kind":13,"containerName":null,"line":542},{"line":545,"name":"$self","containerName":null,"kind":13},{"line":545,"name":"build_from_graph","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$graph","line":545},{"definition":"sub","detail":"($self,$tree)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"build_from_tree","kind":13,"line":581},{"kind":13,"containerName":"build_from_tree","name":"$tree","line":581},{"line":587,"containerName":"build_from_tree","localvar":"my","kind":13,"name":"$str","definition":"my"},{"definition":"my","line":588,"containerName":"build_from_tree","localvar":"my","kind":13,"name":"$io"},{"line":588,"name":"new","kind":12,"containerName":"build_from_tree"},{"kind":13,"containerName":"build_from_tree","name":"$str","line":588},{"definition":"my","line":589,"localvar":"my","containerName":"build_from_tree","kind":13,"name":"$treeio"},{"line":589,"name":"new","containerName":"build_from_tree","kind":12},{"name":"$io","containerName":"build_from_tree","kind":13,"line":589},{"name":"$treeio","kind":13,"containerName":"build_from_tree","line":590},{"line":590,"containerName":"build_from_tree","kind":12,"name":"write_tree"},{"line":590,"name":"$tree","kind":13,"containerName":"build_from_tree"},{"line":592,"name":"$self","containerName":"build_from_tree","kind":13},{"name":"build_from_eNewick","kind":12,"containerName":"build_from_tree","line":592},{"name":"$str","containerName":"build_from_tree","kind":13,"line":592}],"containerName":"main::","name":"build_from_tree","signature":{"label":"build_from_tree($self,$tree)","documentation":" sub relabel_tree {\n   my ($tree)=@_;\n   my $i=1;\n   my $j=1;\n   my $root=$tree->get_root_node();\n   foreach my $node ($tree->get_nodes()) {\n     if ($node == $root) {\n       $node->{'_id'}=\"r\";\n     }\n     elsif (! $node->is_Leaf) {\n       $node->{'_id'}=\"t$i\";\n       $i++;\n     }\n     else {\n       if ($node->{'_id'} eq \"\") {\n \t$node->{'_id'}=\"l$j\";\n \t$j++;\n       }\n     }\n   }\n   return $tree;\n }\n sub build_subtree {\n   my ($graph,$root)=@_;\n   foreach my $child ($root->each_Descendent) {\n     $graph->add_edge($root->id,$child->id);\n     $graph=build_subtree($graph,$child);\n   }\n   return $graph;\n }","parameters":[{"label":"$self"},{"label":"$tree"}]},"line":580,"kind":12,"range":{"start":{"line":580,"character":0},"end":{"line":593,"character":9999}}},{"line":588,"kind":12,"containerName":"String","name":"IO"},{"line":589,"name":"Bio","kind":12,"containerName":"TreeIO"},{"signature":{"label":"recompute($self)","parameters":[{"label":"$self"}],"documentation":""},"range":{"end":{"character":9999,"line":624},"start":{"character":0,"line":595}},"kind":12,"line":595,"detail":"($self)","definition":"sub","name":"recompute","containerName":"main::","children":[{"localvar":"my","containerName":"recompute","kind":13,"name":"$self","line":596,"definition":"my"},{"line":597,"name":"$self","containerName":"recompute","kind":13},{"name":"throw","kind":12,"containerName":"recompute","line":597},{"name":"$self","kind":13,"containerName":"recompute","line":597},{"line":598,"name":"$self","kind":13,"containerName":"recompute"},{"containerName":"recompute","kind":12,"name":"is_dag","line":598},{"kind":13,"localvar":"my","containerName":"recompute","name":"@leaves","line":599,"definition":"my"},{"name":"$self","containerName":"recompute","kind":13,"line":599},{"name":"successorless_vertices","containerName":"recompute","kind":12,"line":599},{"kind":13,"containerName":"recompute","name":"@leaves","line":600},{"name":"@leaves","containerName":"recompute","kind":13,"line":600},{"line":601,"containerName":"recompute","localvar":"my","kind":13,"name":"$numleaves","definition":"my"},{"line":601,"kind":13,"containerName":"recompute","name":"@leaves"},{"line":602,"name":"@roots","localvar":"my","kind":13,"containerName":"recompute","definition":"my"},{"name":"$self","containerName":"recompute","kind":13,"line":602},{"line":602,"kind":12,"containerName":"recompute","name":"predecessorless_vertices"},{"definition":"my","kind":13,"localvar":"my","containerName":"recompute","name":"$numroots","line":603},{"line":603,"name":"@roots","containerName":"recompute","kind":13},{"line":605,"localvar":"my","kind":13,"containerName":"recompute","name":"@nodes","definition":"my"},{"line":605,"kind":13,"containerName":"recompute","name":"$self"},{"kind":12,"containerName":"recompute","name":"vertices","line":605},{"line":606,"name":"@nodes","containerName":"recompute","kind":13},{"name":"@nodes","containerName":"recompute","kind":13,"line":606},{"line":607,"localvar":"my","containerName":"recompute","kind":13,"name":"$numnodes","definition":"my"},{"line":607,"containerName":"recompute","kind":13,"name":"@nodes"},{"localvar":"my","kind":13,"containerName":"recompute","name":"$node","line":608,"definition":"my"},{"line":608,"name":"@nodes","containerName":"recompute","kind":13},{"containerName":"recompute","kind":13,"name":"$self","line":609},{"name":"$node","containerName":"recompute","kind":13,"line":609},{"name":"$self","kind":13,"containerName":"recompute","line":610},{"name":"$node","containerName":"recompute","kind":13,"line":610},{"line":613,"containerName":"recompute","kind":13,"name":"$self"},{"name":"@leaves","kind":13,"containerName":"recompute","line":613},{"kind":13,"containerName":"recompute","name":"$self","line":614},{"kind":13,"containerName":"recompute","name":"$numleaves","line":614},{"line":615,"kind":13,"containerName":"recompute","name":"$self"},{"line":615,"name":"@roots","containerName":"recompute","kind":13},{"line":616,"kind":13,"containerName":"recompute","name":"$self"},{"containerName":"recompute","kind":13,"name":"$numroots","line":616},{"name":"$self","kind":13,"containerName":"recompute","line":617},{"name":"@nodes","kind":13,"containerName":"recompute","line":617},{"name":"$self","containerName":"recompute","kind":13,"line":618},{"kind":13,"containerName":"recompute","name":"$numnodes","line":618},{"line":619,"name":"$self","kind":13,"containerName":"recompute"},{"name":"$self","containerName":"recompute","kind":13,"line":620},{"kind":13,"containerName":"recompute","name":"$self","line":621},{"name":"compute_height","kind":12,"containerName":"recompute","line":621},{"name":"$self","containerName":"recompute","kind":13,"line":622},{"line":622,"name":"compute_mu","kind":12,"containerName":"recompute"},{"name":"$self","kind":13,"containerName":"recompute","line":623}]},{"line":597,"kind":12,"name":"graph"},{"line":598,"name":"graph","kind":12},{"name":"graph","kind":12,"line":599},{"line":602,"name":"graph","kind":12},{"name":"graph","kind":12,"line":605},{"line":609,"name":"labels","kind":12},{"line":610,"name":"labels","kind":12},{"line":613,"kind":12,"name":"leaves"},{"name":"numleaves","kind":12,"line":614},{"line":615,"name":"roots","kind":12},{"name":"numroots","kind":12,"line":616},{"line":617,"name":"nodes","kind":12},{"kind":12,"name":"numnodes","line":618},{"name":"mudata","kind":12,"line":619},{"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"is_attackable","name":"$self","line":629},{"line":629,"kind":13,"containerName":"is_attackable","name":"$u1"},{"name":"$v1","containerName":"is_attackable","kind":13,"line":629},{"line":629,"containerName":"is_attackable","kind":13,"name":"$u2"},{"name":"$v2","containerName":"is_attackable","kind":13,"line":629},{"containerName":"is_attackable","kind":13,"name":"$self","line":630},{"kind":12,"containerName":"is_attackable","name":"is_hybrid_node","line":630},{"name":"$v1","kind":13,"containerName":"is_attackable","line":630},{"line":631,"name":"$self","containerName":"is_attackable","kind":13},{"line":631,"containerName":"is_attackable","kind":12,"name":"is_hybrid_node"},{"line":631,"kind":13,"containerName":"is_attackable","name":"$v2"},{"name":"$self","containerName":"is_attackable","kind":13,"line":632},{"line":632,"name":"graph","containerName":"is_attackable","kind":12},{"line":632,"kind":12,"containerName":"is_attackable","name":"is_reachable"},{"line":632,"kind":13,"containerName":"is_attackable","name":"$v2"},{"kind":13,"containerName":"is_attackable","name":"$u1","line":632},{"line":633,"containerName":"is_attackable","kind":13,"name":"$u1"},{"name":"$u2","containerName":"is_attackable","kind":13,"line":633},{"kind":13,"containerName":"is_attackable","name":"$v1","line":633},{"kind":13,"containerName":"is_attackable","name":"$v2","line":633},{"line":634,"kind":13,"containerName":"is_attackable","name":"$v2"},{"line":634,"containerName":"is_attackable","kind":13,"name":"$self"},{"name":"is_tree_node","kind":12,"containerName":"is_attackable","line":634},{"containerName":"is_attackable","kind":13,"name":"$self","line":635},{"kind":12,"containerName":"is_attackable","name":"graph","line":635},{"name":"successors","kind":12,"containerName":"is_attackable","line":635},{"containerName":"is_attackable","kind":13,"name":"$u2","line":635}],"containerName":"main::","name":"is_attackable","definition":"sub","detail":"($self,$u1,$v1,$u2,$v2)","line":628,"range":{"end":{"character":9999,"line":640},"start":{"character":0,"line":628}},"kind":12,"signature":{"documentation":" Hybridizing","parameters":[{"label":"$self"},{"label":"$u1"},{"label":"$v1"},{"label":"$u2"},{"label":"$v2"}],"label":"is_attackable($self,$u1,$v1,$u2,$v2)"}},{"detail":"($self,$u1,$v1,$u2,$v2,$lbl)","definition":"sub","name":"do_attack","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"do_attack","kind":13,"line":643,"definition":"my"},{"name":"$u1","kind":13,"containerName":"do_attack","line":643},{"line":643,"containerName":"do_attack","kind":13,"name":"$v1"},{"containerName":"do_attack","kind":13,"name":"$u2","line":643},{"containerName":"do_attack","kind":13,"name":"$v2","line":643},{"name":"$lbl","kind":13,"containerName":"do_attack","line":643},{"name":"$graph","localvar":"my","kind":13,"containerName":"do_attack","line":644,"definition":"my"},{"name":"$self","kind":13,"containerName":"do_attack","line":644},{"name":"$graph","containerName":"do_attack","kind":13,"line":645},{"kind":12,"containerName":"do_attack","name":"delete_edge","line":645},{"line":645,"containerName":"do_attack","kind":13,"name":"$u1"},{"line":645,"containerName":"do_attack","kind":13,"name":"$v1"},{"line":646,"kind":13,"containerName":"do_attack","name":"$graph"},{"line":646,"name":"delete_edge","containerName":"do_attack","kind":12},{"line":646,"name":"$u2","kind":13,"containerName":"do_attack"},{"kind":13,"containerName":"do_attack","name":"$v2","line":646},{"line":647,"containerName":"do_attack","kind":13,"name":"$graph"},{"line":647,"kind":12,"containerName":"do_attack","name":"add_edge"},{"name":"$u1","containerName":"do_attack","kind":13,"line":647},{"name":"$graph","containerName":"do_attack","kind":13,"line":648},{"name":"add_edge","containerName":"do_attack","kind":12,"line":648},{"line":648,"containerName":"do_attack","kind":13,"name":"$v1"},{"line":649,"name":"$graph","containerName":"do_attack","kind":13},{"kind":12,"containerName":"do_attack","name":"add_edge","line":649},{"line":649,"name":"$u2","kind":13,"containerName":"do_attack"},{"containerName":"do_attack","kind":13,"name":"$graph","line":650},{"kind":12,"containerName":"do_attack","name":"add_edge","line":650},{"line":650,"name":"$v2","kind":13,"containerName":"do_attack"},{"line":651,"kind":13,"containerName":"do_attack","name":"$graph"},{"line":651,"kind":12,"containerName":"do_attack","name":"add_edge"},{"line":652,"name":"$self","containerName":"do_attack","kind":13},{"line":652,"kind":12,"containerName":"do_attack","name":"build_from_graph"},{"line":652,"containerName":"do_attack","kind":13,"name":"$graph"}],"signature":{"parameters":[{"label":"$self"},{"label":"$u1"},{"label":"$v1"},{"label":"$u2"},{"label":"$v2"},{"label":"$lbl"}],"documentation":"","label":"do_attack($self,$u1,$v1,$u2,$v2,$lbl)"},"kind":12,"range":{"start":{"character":0,"line":642},"end":{"character":9999,"line":653}},"line":642},{"line":644,"name":"graph","kind":12},{"line":658,"kind":12,"range":{"start":{"character":0,"line":658},"end":{"line":662,"character":9999}},"signature":{"label":"compute_mu($self)","parameters":[{"label":"$self"}],"documentation":" Computation of mu-data"},"children":[{"localvar":"my","containerName":"compute_mu","kind":13,"name":"$self","line":659,"definition":"my"},{"definition":"my","line":660,"containerName":"compute_mu","localvar":"my","kind":13,"name":"$graph"},{"kind":13,"containerName":"compute_mu","name":"$self","line":660},{"name":"$mudata","containerName":"compute_mu","localvar":"my","kind":13,"line":661,"definition":"my"},{"line":661,"name":"$self","kind":13,"containerName":"compute_mu"},{"line":662,"name":"@leaves","localvar":"my","kind":13,"containerName":"compute_mu","definition":"my"},{"line":662,"containerName":"compute_mu","kind":13,"name":"$self"}],"name":"compute_mu","containerName":"main::","definition":"sub","detail":"($self)"},{"kind":12,"name":"graph","line":660},{"line":661,"kind":12,"name":"mudata"},{"line":662,"kind":12,"name":"leaves"},{"localvar":"my","containerName":null,"kind":13,"name":"$numleaves","line":663,"definition":"my"},{"name":"%self","containerName":null,"kind":13,"line":663},{"line":663,"kind":12,"name":"numleaves"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$i","line":664},{"kind":13,"containerName":null,"name":"$i","line":664},{"line":664,"name":"$numleaves","kind":13,"containerName":null},{"line":664,"kind":13,"containerName":null,"name":"%i"},{"definition":"my","name":"$vec","kind":13,"localvar":"my","containerName":null,"line":665},{"line":665,"kind":12,"containerName":"PhyloNetwork::muVector","name":"Bio"},{"line":665,"containerName":"main::","kind":12,"name":"new"},{"line":665,"name":"$numleaves","containerName":null,"kind":13},{"line":666,"kind":13,"containerName":null,"name":"@vec"},{"line":666,"name":"$i","containerName":null,"kind":13},{"line":667,"kind":13,"containerName":null,"name":"%mudata"},{"line":667,"containerName":null,"kind":13,"name":"@leaves"},{"containerName":null,"kind":13,"name":"$i","line":667},{"name":"$vec","kind":13,"containerName":null,"line":667},{"definition":"my","line":669,"name":"$h","localvar":"my","containerName":null,"kind":13},{"line":670,"localvar":"my","containerName":null,"kind":13,"name":"@nodes","definition":"my"},{"line":670,"name":"%self","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$h","line":670},{"name":"%self","kind":13,"containerName":null,"line":670},{"kind":12,"name":"nodes","line":670},{"localvar":"my","kind":13,"containerName":null,"name":"$u","line":672,"definition":"my"},{"line":672,"containerName":null,"kind":13,"name":"@nodes"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$vec","line":673},{"name":"Bio","containerName":"PhyloNetwork::muVector","kind":12,"line":673},{"line":673,"kind":12,"containerName":"main::","name":"new"},{"name":"$numleaves","kind":13,"containerName":null,"line":673},{"localvar":"my","containerName":null,"kind":13,"name":"$son","line":674,"definition":"my"},{"line":674,"containerName":null,"kind":13,"name":"$graph"},{"line":674,"name":"successors","kind":12,"containerName":"main::"},{"name":"%u","containerName":null,"kind":13,"line":674},{"line":675,"name":"$vec","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%mudata","line":675},{"line":675,"name":"$son","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%mudata","line":677},{"name":"$u","kind":13,"containerName":null,"line":677},{"line":677,"kind":13,"containerName":null,"name":"$vec"},{"line":679,"name":"$h","kind":13,"containerName":null},{"kind":12,"range":{"end":{"character":9999,"line":686},"start":{"line":683,"character":0}},"line":683,"signature":{"label":"compute_height($self)","parameters":[{"label":"$self"}],"documentation":""},"containerName":"main::","name":"compute_height","children":[{"definition":"my","line":684,"name":"$self","containerName":"compute_height","localvar":"my","kind":13},{"line":685,"localvar":"my","containerName":"compute_height","kind":13,"name":"$graph","definition":"my"},{"name":"$self","kind":13,"containerName":"compute_height","line":685},{"definition":"my","localvar":"my","kind":13,"containerName":"compute_height","name":"@leaves","line":686},{"line":686,"name":"$self","kind":13,"containerName":"compute_height"}],"detail":"($self)","definition":"sub"},{"line":685,"kind":12,"name":"graph"},{"name":"leaves","kind":12,"line":686},{"definition":"my","name":"$leaf","kind":13,"localvar":"my","containerName":null,"line":687},{"line":687,"name":"@leaves","containerName":null,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":688},{"name":"$leaf","containerName":null,"kind":13,"line":688},{"line":690,"name":"$h","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"definition":"my","line":691,"name":"@nodes","localvar":"my","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":691},{"line":691,"name":"%self","kind":13,"containerName":null},{"name":"$h","kind":13,"containerName":null,"line":691},{"kind":13,"containerName":null,"name":"%self","line":692},{"line":692,"name":"nodes","kind":12},{"definition":"my","line":694,"name":"$node","kind":13,"localvar":"my","containerName":null},{"name":"@nodes","containerName":null,"kind":13,"line":694},{"line":695,"name":"$parent","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"$graph","containerName":null,"kind":13,"line":695},{"line":695,"kind":12,"containerName":"main::","name":"predecessors"},{"name":"%node","containerName":null,"kind":13,"line":695},{"containerName":null,"kind":13,"name":"%self","line":696},{"line":696,"kind":13,"containerName":null,"name":"$parent"},{"name":"$h","kind":13,"containerName":null,"line":696},{"line":699,"name":"$h","kind":13,"containerName":null},{"line":715,"range":{"start":{"character":0,"line":715},"end":{"character":9999,"line":719}},"kind":12,"signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar","parameters":[{"label":"$self"},{"label":"$node"}],"label":"is_leaf($self,$node)"},"children":[{"definition":"my","line":716,"name":"$self","localvar":"my","containerName":"is_leaf","kind":13},{"kind":13,"containerName":"is_leaf","name":"$node","line":716},{"line":717,"name":"$self","containerName":"is_leaf","kind":13},{"name":"out_degree","kind":12,"containerName":"is_leaf","line":717},{"line":717,"kind":13,"containerName":"is_leaf","name":"$node"}],"name":"is_leaf","containerName":"main::","definition":"sub","detail":"($self,$node)"},{"line":717,"name":"graph","kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"$node"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar","label":"is_root($self,$node)"},"kind":12,"range":{"start":{"character":0,"line":731},"end":{"character":9999,"line":735}},"line":731,"detail":"($self,$node)","definition":"sub","containerName":"main::","name":"is_root","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"is_root","line":732},{"line":732,"kind":13,"containerName":"is_root","name":"$node"},{"name":"$self","kind":13,"containerName":"is_root","line":733},{"line":733,"name":"in_degree","kind":12,"containerName":"is_root"},{"containerName":"is_root","kind":13,"name":"$node","line":733}]},{"line":733,"name":"graph","kind":12},{"children":[{"localvar":"my","kind":13,"containerName":"is_tree_node","name":"$self","line":748,"definition":"my"},{"line":748,"name":"$node","kind":13,"containerName":"is_tree_node"},{"line":749,"containerName":"is_tree_node","kind":13,"name":"$self"},{"name":"in_degree","containerName":"is_tree_node","kind":12,"line":749},{"name":"$node","kind":13,"containerName":"is_tree_node","line":749}],"containerName":"main::","name":"is_tree_node","definition":"sub","detail":"($self,$node)","line":747,"kind":12,"range":{"start":{"character":0,"line":747},"end":{"character":9999,"line":751}},"signature":{"parameters":[{"label":"$self"},{"label":"$node"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar","label":"is_tree_node($self,$node)"}},{"line":749,"kind":12,"name":"graph"},{"detail":"($self,$node)","definition":"sub","containerName":"main::","name":"is_hybrid_node","children":[{"line":764,"name":"$self","kind":13,"localvar":"my","containerName":"is_hybrid_node","definition":"my"},{"line":764,"kind":13,"containerName":"is_hybrid_node","name":"$node"},{"name":"$self","kind":13,"containerName":"is_hybrid_node","line":765},{"name":"in_degree","containerName":"is_hybrid_node","kind":12,"line":765},{"line":765,"name":"$node","containerName":"is_hybrid_node","kind":13}],"signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar","parameters":[{"label":"$self"},{"label":"$node"}],"label":"is_hybrid_node($self,$node)"},"kind":12,"range":{"end":{"line":767,"character":9999},"start":{"line":763,"character":0}},"line":763},{"line":765,"kind":12,"name":"graph"},{"kind":12,"range":{"end":{"line":781,"character":9999},"start":{"line":769,"character":0}},"line":769,"containerName":"main::","name":"has_tree_child","children":[{"line":772,"name":"$g","kind":13,"localvar":"my","containerName":"has_tree_child","definition":"my"},{"definition":"my","line":773,"name":"$node","localvar":"my","kind":13,"containerName":"has_tree_child"},{"name":"@Sons","containerName":"has_tree_child","localvar":"my","kind":13,"line":774,"definition":"my"},{"line":774,"containerName":"has_tree_child","kind":13,"name":"$g"},{"line":774,"name":"successors","kind":12,"containerName":"has_tree_child"},{"line":774,"kind":13,"containerName":"has_tree_child","name":"$node"},{"definition":"my","name":"$son","kind":13,"localvar":"my","containerName":"has_tree_child","line":775},{"line":775,"containerName":"has_tree_child","kind":13,"name":"@Sons"},{"kind":13,"containerName":"has_tree_child","name":"$g","line":776},{"line":776,"kind":12,"containerName":"has_tree_child","name":"in_degree"},{"name":"$son","containerName":"has_tree_child","kind":13,"line":776}],"definition":"sub"},{"line":793,"range":{"start":{"line":793,"character":0},"end":{"character":9999,"line":800}},"kind":12,"signature":{"label":"is_tree_child($self)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork","parameters":[{"label":"$self"}]},"children":[{"line":794,"localvar":"my","containerName":"is_tree_child","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"is_tree_child","line":795},{"line":796,"containerName":"is_tree_child","kind":13,"name":"$self"},{"kind":13,"containerName":"is_tree_child","name":"$self","line":798},{"definition":"my","localvar":"my","kind":13,"containerName":"is_tree_child","name":"$graph","line":799},{"line":799,"name":"$self","kind":13,"containerName":"is_tree_child"},{"name":"$node","containerName":"is_tree_child","localvar":"my","kind":13,"line":800,"definition":"my"},{"line":800,"name":"$self","containerName":"is_tree_child","kind":13}],"containerName":"main::","name":"is_tree_child","definition":"sub","detail":"($self)"},{"name":"is_tree_child","kind":12,"line":795},{"line":796,"kind":12,"name":"is_tree_child"},{"name":"is_tree_child","kind":12,"line":798},{"line":799,"name":"graph","kind":12},{"line":800,"name":"nodes","kind":12},{"line":801,"name":"$graph","containerName":null,"kind":13},{"line":801,"name":"out_degree","containerName":"main::","kind":12},{"line":801,"kind":13,"containerName":null,"name":"$node"},{"line":802,"containerName":null,"kind":13,"name":"$graph"},{"name":"$node","kind":13,"containerName":null,"line":802},{"line":804,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"name":"is_tree_child","line":804},{"definition":"sub","detail":"($self)","children":[{"name":"$self","localvar":"my","containerName":"nodes","kind":13,"line":821,"definition":"my"},{"name":"$self","kind":13,"containerName":"nodes","line":822}],"containerName":"main::","name":"nodes","signature":{"label":"nodes($self)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none","parameters":[{"label":"$self"}]},"line":820,"kind":12,"range":{"end":{"line":822,"character":9999},"start":{"line":820,"character":0}}},{"name":"nodes","kind":12,"line":822},{"line":835,"kind":12,"range":{"end":{"character":9999,"line":837},"start":{"line":835,"character":0}},"signature":{"label":"leaves($self)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none","parameters":[{"label":"$self"}]},"children":[{"line":836,"localvar":"my","kind":13,"containerName":"leaves","name":"$self","definition":"my"},{"line":837,"name":"$self","kind":13,"containerName":"leaves"}],"containerName":"main::","name":"leaves","definition":"sub","detail":"($self)"},{"name":"leaves","kind":12,"line":837},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none","label":"roots($self)"},"range":{"end":{"character":9999,"line":852},"start":{"character":0,"line":850}},"kind":12,"line":850,"detail":"($self)","definition":"sub","name":"roots","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"roots","name":"$self","line":851,"definition":"my"},{"containerName":"roots","kind":13,"name":"$self","line":852}]},{"line":852,"kind":12,"name":"roots"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":866,"name":"$self","containerName":"internal_nodes","localvar":"my","kind":13},{"kind":13,"containerName":"internal_nodes","name":"$self","line":867},{"name":"is_leaf","containerName":"internal_nodes","kind":12,"line":867},{"line":867,"kind":13,"containerName":"internal_nodes","name":"$self"},{"line":867,"kind":12,"containerName":"internal_nodes","name":"nodes"}],"containerName":"main::","name":"internal_nodes","signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none","parameters":[{"label":"$self"}],"label":"internal_nodes($self)"},"line":865,"range":{"start":{"line":865,"character":0},"end":{"character":9999,"line":868}},"kind":12},{"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","containerName":"tree_nodes","localvar":"my","kind":13,"line":881},{"name":"$self","kind":13,"containerName":"tree_nodes","line":882},{"line":882,"name":"is_tree_node","kind":12,"containerName":"tree_nodes"},{"line":882,"containerName":"tree_nodes","kind":13,"name":"$self"},{"name":"nodes","containerName":"tree_nodes","kind":12,"line":882}],"name":"tree_nodes","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none","label":"tree_nodes($self)"},"line":880,"kind":12,"range":{"end":{"character":9999,"line":883},"start":{"character":0,"line":880}}},{"detail":"($self)","definition":"sub","name":"hybrid_nodes","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"hybrid_nodes","localvar":"my","kind":13,"line":896},{"line":897,"kind":13,"containerName":"hybrid_nodes","name":"$self"},{"containerName":"hybrid_nodes","kind":12,"name":"is_hybrid_node","line":897},{"line":897,"name":"$self","kind":13,"containerName":"hybrid_nodes"},{"line":897,"name":"nodes","kind":12,"containerName":"hybrid_nodes"}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none","label":"hybrid_nodes($self)"},"kind":12,"range":{"start":{"character":0,"line":895},"end":{"character":9999,"line":898}},"line":895},{"range":{"start":{"character":0,"line":910},"end":{"character":9999,"line":913}},"kind":12,"line":910,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none","label":"graph($self)"},"name":"graph","containerName":"main::","children":[{"definition":"my","line":911,"containerName":"graph","localvar":"my","kind":13,"name":"$self"},{"kind":13,"containerName":"graph","name":"$self","line":912}],"detail":"($self)","definition":"sub"},{"name":"graph","kind":12,"line":912},{"line":928,"range":{"end":{"line":931,"character":9999},"start":{"line":928,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.","label":"edges($self)"},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"edges","name":"$self","line":929},{"line":930,"name":"$self","containerName":"edges","kind":13},{"containerName":"edges","kind":12,"name":"edges","line":930}],"containerName":"main::","name":"edges","definition":"sub","detail":"($self)"},{"kind":12,"name":"graph","line":930},{"children":[{"localvar":"my","containerName":"tree_edges","kind":13,"name":"$self","line":945,"definition":"my"},{"line":946,"containerName":"tree_edges","kind":13,"name":"$self"},{"line":946,"name":"is_tree_node","containerName":"tree_edges","kind":12},{"line":946,"name":"$self","containerName":"tree_edges","kind":13},{"name":"edges","containerName":"tree_edges","kind":12,"line":946}],"containerName":"main::","name":"tree_edges","definition":"sub","detail":"($self)","line":944,"range":{"end":{"line":947,"character":9999},"start":{"character":0,"line":944}},"kind":12,"signature":{"label":"tree_edges($self)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none","parameters":[{"label":"$self"}]}},{"name":"hybrid_edges","containerName":"main::","children":[{"definition":"my","containerName":"hybrid_edges","localvar":"my","kind":13,"name":"$self","line":961},{"kind":13,"containerName":"hybrid_edges","name":"$self","line":962},{"name":"is_hybrid_node","containerName":"hybrid_edges","kind":12,"line":962},{"line":962,"kind":13,"containerName":"hybrid_edges","name":"$self"},{"kind":12,"containerName":"hybrid_edges","name":"edges","line":962}],"detail":"($self)","definition":"sub","range":{"start":{"line":960,"character":0},"end":{"line":963,"character":9999}},"kind":12,"line":960,"signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none","parameters":[{"label":"$self"}],"label":"hybrid_edges($self)"}},{"kind":12,"range":{"end":{"line":981,"character":9999},"start":{"line":976,"character":0}},"line":976,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none","label":"explode($self)"},"name":"explode","containerName":"main::","children":[{"line":977,"name":"$self","localvar":"my","containerName":"explode","kind":13,"definition":"my"},{"line":978,"localvar":"my","containerName":"explode","kind":13,"name":"@trees","definition":"my"},{"name":"$self","containerName":"explode","kind":13,"line":979},{"line":979,"name":"explode_rec","containerName":"explode","kind":12},{"line":979,"name":"@trees","kind":13,"containerName":"explode"},{"name":"@trees","kind":13,"containerName":"explode","line":980}],"detail":"($self)","definition":"sub"},{"children":[{"line":984,"localvar":"my","containerName":"explode_rec","kind":13,"name":"$self","definition":"my"},{"line":984,"name":"$trees","kind":13,"containerName":"explode_rec"},{"definition":"my","line":985,"name":"@h","localvar":"my","containerName":"explode_rec","kind":13},{"line":985,"name":"$self","containerName":"explode_rec","kind":13},{"line":985,"containerName":"explode_rec","kind":12,"name":"hybrid_nodes"},{"line":986,"kind":13,"containerName":"explode_rec","name":"@h"},{"kind":13,"localvar":"my","containerName":"explode_rec","name":"$v","line":987,"definition":"my"},{"containerName":"explode_rec","kind":13,"name":"@h","line":987},{"localvar":"my","kind":13,"containerName":"explode_rec","name":"$u","line":988,"definition":"my"},{"line":988,"name":"$self","containerName":"explode_rec","kind":13},{"line":988,"name":"predecessors","kind":12,"containerName":"explode_rec"},{"line":988,"kind":13,"containerName":"explode_rec","name":"$v"},{"name":"$self","kind":13,"containerName":"explode_rec","line":989},{"line":989,"containerName":"explode_rec","kind":12,"name":"delete_edge"},{"kind":13,"containerName":"explode_rec","name":"$u","line":989},{"line":989,"kind":13,"containerName":"explode_rec","name":"$v"},{"containerName":"explode_rec","kind":13,"name":"$self","line":990},{"line":990,"name":"explode_rec","kind":12,"containerName":"explode_rec"},{"line":990,"kind":13,"containerName":"explode_rec","name":"$trees"},{"line":991,"kind":13,"containerName":"explode_rec","name":"$self"},{"line":991,"containerName":"explode_rec","kind":12,"name":"add_edge"},{"line":991,"kind":13,"containerName":"explode_rec","name":"$u"},{"line":991,"name":"$v","containerName":"explode_rec","kind":13},{"name":"$io","localvar":"my","containerName":"explode_rec","kind":13,"line":994,"definition":"my"},{"line":994,"name":"new","kind":12,"containerName":"explode_rec"},{"kind":13,"containerName":"explode_rec","name":"$self","line":994},{"containerName":"explode_rec","kind":12,"name":"eNewick","line":994},{"kind":13,"localvar":"my","containerName":"explode_rec","name":"$treeio","line":995,"definition":"my"},{"name":"new","containerName":"explode_rec","kind":12,"line":995},{"containerName":"explode_rec","kind":13,"name":"$io","line":995},{"line":996,"name":"$tree","localvar":"my","containerName":"explode_rec","kind":13,"definition":"my"},{"line":996,"name":"$treeio","kind":13,"containerName":"explode_rec"},{"line":996,"kind":12,"containerName":"explode_rec","name":"next_tree"},{"line":997,"name":"$tree","kind":13,"containerName":"explode_rec"},{"line":997,"kind":12,"containerName":"explode_rec","name":"contract_linear_paths"},{"line":998,"kind":13,"containerName":"explode_rec","name":"$trees"},{"name":"$tree","containerName":"explode_rec","kind":13,"line":998}],"containerName":"main::","name":"explode_rec","definition":"sub","detail":"($self,$trees)","line":983,"kind":12,"range":{"start":{"line":983,"character":0},"end":{"character":9999,"line":999}},"signature":{"label":"explode_rec($self,$trees)","parameters":[{"label":"$self"},{"label":"$trees"}],"documentation":""}},{"line":988,"name":"graph","kind":12},{"kind":12,"name":"graph","line":989},{"line":991,"kind":12,"name":"graph"},{"name":"IO","containerName":"String","kind":12,"line":994},{"kind":12,"containerName":"TreeIO","name":"Bio","line":995},{"signature":{"label":"mudata($self)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.","parameters":[{"label":"$self"}]},"line":1015,"range":{"end":{"line":1017,"character":9999},"start":{"character":0,"line":1015}},"kind":12,"definition":"sub","detail":"($self)","children":[{"line":1016,"localvar":"my","containerName":"mudata","kind":13,"name":"$self","definition":"my"},{"containerName":"mudata","kind":13,"name":"$self","line":1017}],"name":"mudata","containerName":"main::"},{"line":1017,"name":"mudata","kind":12},{"line":1020,"range":{"end":{"character":9999,"line":1023},"start":{"line":1020,"character":0}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$u"}],"label":"mudata_node($self,$u)"},"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"mudata_node","line":1021,"definition":"my"},{"name":"$u","kind":13,"containerName":"mudata_node","line":1021},{"line":1022,"name":"$self","kind":13,"containerName":"mudata_node"},{"containerName":"mudata_node","kind":13,"name":"$u","line":1022}],"containerName":"main::","name":"mudata_node","definition":"sub","detail":"($self,$u)"},{"name":"mudata","kind":12,"line":1022},{"definition":"sub","detail":"($self)","children":[{"localvar":"my","containerName":"heights","kind":13,"name":"$self","line":1039,"definition":"my"},{"containerName":"heights","kind":13,"name":"$self","line":1040}],"name":"heights","containerName":"main::","signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.","parameters":[{"label":"$self"}],"label":"heights($self)"},"line":1038,"range":{"start":{"line":1038,"character":0},"end":{"line":1040,"character":9999}},"kind":12},{"signature":{"label":"height_node($self,$u)","documentation":"","parameters":[{"label":"$self"},{"label":"$u"}]},"line":1043,"range":{"start":{"character":0,"line":1043},"end":{"character":9999,"line":1046}},"kind":12,"definition":"sub","detail":"($self,$u)","children":[{"containerName":"height_node","localvar":"my","kind":13,"name":"$self","line":1044,"definition":"my"},{"kind":13,"containerName":"height_node","name":"$u","line":1044},{"line":1045,"containerName":"height_node","kind":13,"name":"$self"},{"line":1045,"name":"$u","kind":13,"containerName":"height_node"}],"name":"height_node","containerName":"main::"},{"detail":"($net1,$net2)","definition":"sub","name":"mu_distance","containerName":"main::","children":[{"containerName":"mu_distance","localvar":"my","kind":13,"name":"$net1","line":1060,"definition":"my"},{"line":1060,"kind":13,"containerName":"mu_distance","name":"$net2"},{"definition":"my","line":1061,"kind":13,"localvar":"my","containerName":"mu_distance","name":"@nodes1"},{"line":1061,"containerName":"mu_distance","kind":13,"name":"$net1"},{"kind":12,"containerName":"mu_distance","name":"nodes","line":1061},{"line":1062,"localvar":"my","kind":13,"containerName":"mu_distance","name":"@nodes2","definition":"my"},{"line":1062,"name":"$net2","containerName":"mu_distance","kind":13},{"line":1062,"containerName":"mu_distance","kind":12,"name":"nodes"},{"definition":"my","containerName":"mu_distance","localvar":"my","kind":13,"name":"$comp","line":1063},{"line":1063,"containerName":"mu_distance","kind":12,"name":"new"},{"kind":13,"containerName":"mu_distance","name":"$net1","line":1064},{"name":"throw","kind":12,"containerName":"mu_distance","line":1064},{"name":"$comp","kind":13,"containerName":"mu_distance","line":1065},{"containerName":"mu_distance","kind":12,"name":"compare","line":1065},{"line":1065,"kind":13,"containerName":"mu_distance","name":"$net1"},{"line":1065,"containerName":"mu_distance","kind":13,"name":"$net2"},{"name":"$net1","containerName":"mu_distance","kind":13,"line":1066},{"containerName":"mu_distance","kind":12,"name":"warn","line":1066},{"line":1067,"containerName":"mu_distance","kind":13,"name":"$net1"},{"containerName":"mu_distance","kind":12,"name":"is_tree_child","line":1067},{"kind":13,"containerName":"mu_distance","name":"$net2","line":1068},{"line":1068,"name":"warn","containerName":"mu_distance","kind":12},{"containerName":"mu_distance","kind":13,"name":"$net2","line":1069},{"line":1069,"name":"is_tree_child","containerName":"mu_distance","kind":12},{"definition":"my","line":1070,"name":"@leaves","localvar":"my","kind":13,"containerName":"mu_distance"},{"containerName":"mu_distance","kind":13,"name":"$net1","line":1070}],"signature":{"parameters":[{"label":"$net1"},{"label":"$net2"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork","label":"mu_distance($net1,$net2)"},"kind":12,"range":{"end":{"line":1070,"character":9999},"start":{"line":1059,"character":0}},"line":1059},{"line":1063,"containerName":"Compare","kind":12,"name":"Array"},{"line":1065,"name":"leaves","kind":12},{"kind":12,"name":"leaves","line":1065},{"line":1070,"kind":12,"name":"leaves"},{"line":1071,"name":"%matched1","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":1072,"name":"%matched2","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"kind":12,"name":"OUTER","line":1073},{"name":"$node1","localvar":"my","containerName":null,"kind":13,"line":1073,"definition":"my"},{"kind":13,"containerName":null,"name":"@nodes1","line":1073},{"definition":"my","line":1074,"name":"$node2","kind":13,"localvar":"my","containerName":null},{"name":"@nodes2","containerName":null,"kind":13,"line":1074},{"containerName":null,"kind":13,"name":"%matched1","line":1076},{"containerName":null,"kind":13,"name":"$node1","line":1076},{"kind":13,"containerName":null,"name":"%matched2","line":1076},{"line":1076,"containerName":null,"kind":13,"name":"$node2"},{"name":"%net1","kind":13,"containerName":null,"line":1077},{"line":1077,"kind":12,"name":"mudata"},{"kind":13,"containerName":null,"name":"$node1","line":1077},{"line":1077,"name":"%net2","kind":13,"containerName":null},{"name":"mudata","kind":12,"line":1077},{"kind":13,"containerName":null,"name":"%node2","line":1077},{"line":1079,"containerName":null,"kind":13,"name":"%matched1"},{"line":1079,"name":"$node1","containerName":null,"kind":13},{"line":1079,"name":"$node2","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%matched2","line":1080},{"kind":13,"containerName":null,"name":"$node2","line":1080},{"kind":13,"containerName":null,"name":"$node1","line":1080},{"name":"OUTER","kind":12,"line":1081},{"line":1085,"kind":13,"containerName":null,"name":"@nodes1"},{"kind":13,"containerName":null,"name":"@nodes2","line":1085},{"line":1085,"containerName":null,"kind":13,"name":"%matched1"},{"detail":"($net1,$net2)","definition":"sub","containerName":"main::","name":"mu_distance_generalized","children":[{"line":1100,"name":"$net1","localvar":"my","kind":13,"containerName":"mu_distance_generalized","definition":"my"},{"kind":13,"containerName":"mu_distance_generalized","name":"$net2","line":1100},{"line":1101,"name":"$netr1","localvar":"my","kind":13,"containerName":"mu_distance_generalized","definition":"my"},{"name":"$netr2","kind":13,"containerName":"mu_distance_generalized","line":1101},{"kind":13,"containerName":"mu_distance_generalized","name":"$net1","line":1101},{"name":"topological_restriction","containerName":"mu_distance_generalized","kind":12,"line":1101},{"containerName":"mu_distance_generalized","kind":13,"name":"$net2","line":1101},{"line":1102,"name":"$netr1","containerName":"mu_distance_generalized","kind":13},{"name":"mu_distance","containerName":"mu_distance_generalized","kind":12,"line":1102},{"name":"$netr2","kind":13,"containerName":"mu_distance_generalized","line":1102}],"signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork","parameters":[{"label":"$net1"},{"label":"$net2"}],"label":"mu_distance_generalized($net1,$net2)"},"kind":12,"range":{"end":{"character":9999,"line":1103},"start":{"line":1099,"character":0}},"line":1099},{"line":1107,"kind":12,"range":{"start":{"line":1107,"character":0},"end":{"character":9999,"line":1110}},"signature":{"label":"mudata_string_node($self,$u)","parameters":[{"label":"$self"},{"label":"$u"}],"documentation":" mudata_string (code mu_data in a string; useful for isomorphism testing)"},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"mudata_string_node","name":"$self","line":1108},{"line":1108,"name":"$u","kind":13,"containerName":"mudata_string_node"},{"containerName":"mudata_string_node","kind":13,"name":"$self","line":1109},{"containerName":"mudata_string_node","kind":13,"name":"$u","line":1109},{"line":1109,"containerName":"mudata_string_node","kind":12,"name":"display"}],"containerName":"main::","name":"mudata_string_node","definition":"sub","detail":"($self,$u)"},{"line":1109,"kind":12,"name":"mudata"},{"children":[{"definition":"my","localvar":"my","containerName":"mudata_string","kind":13,"name":"$self","line":1113},{"line":1114,"containerName":"mudata_string","kind":13,"name":"$self"},{"name":"$self","containerName":"mudata_string","kind":13,"line":1114},{"definition":"my","name":"@internal","containerName":"mudata_string","localvar":"my","kind":13,"line":1115},{"line":1115,"name":"$self","kind":13,"containerName":"mudata_string"},{"name":"internal_nodes","containerName":"mudata_string","kind":12,"line":1115},{"localvar":"my","containerName":"mudata_string","kind":13,"name":"$mus","line":1116,"definition":"my"},{"kind":13,"containerName":"mudata_string","name":"$self","line":1116},{"containerName":"mudata_string","kind":13,"name":"@internal","line":1117},{"line":1117,"name":"$mus","containerName":"mudata_string","kind":13},{"name":"$b","kind":13,"containerName":"mudata_string","line":1117},{"containerName":"mudata_string","kind":13,"name":"$mus","line":1117},{"line":1117,"name":"$a","containerName":"mudata_string","kind":13},{"name":"@internal","containerName":"mudata_string","kind":13,"line":1117},{"definition":"my","line":1118,"containerName":"mudata_string","localvar":"my","kind":13,"name":"$str"},{"line":1119,"containerName":"mudata_string","localvar":"my","kind":13,"name":"$node","definition":"my"},{"line":1119,"containerName":"mudata_string","kind":13,"name":"@internal"},{"line":1120,"name":"$str","kind":13,"containerName":"mudata_string"},{"line":1120,"name":"$str","kind":13,"containerName":"mudata_string"},{"name":"$self","containerName":"mudata_string","kind":13,"line":1120},{"name":"mudata_string_node","kind":12,"containerName":"mudata_string","line":1120},{"line":1120,"containerName":"mudata_string","kind":13,"name":"$node"},{"line":1122,"kind":13,"containerName":"mudata_string","name":"$self"},{"containerName":"mudata_string","kind":13,"name":"$str","line":1122},{"name":"$str","kind":13,"containerName":"mudata_string","line":1123}],"name":"mudata_string","containerName":"main::","definition":"sub","detail":"($self)","line":1112,"kind":12,"range":{"end":{"character":9999,"line":1124},"start":{"line":1112,"character":0}},"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"mudata_string($self)"}},{"line":1114,"kind":12,"name":"mudata_string"},{"kind":12,"name":"mudata_string","line":1114},{"name":"mudata","kind":12,"line":1116},{"name":"mudata_string","kind":12,"line":1122},{"range":{"end":{"character":9999,"line":1129},"start":{"character":0,"line":1126}},"kind":12,"line":1126,"signature":{"documentation":"","parameters":[{"label":"$net1"},{"label":"$net2"}],"label":"is_mu_isomorphic($net1,$net2)"},"containerName":"main::","name":"is_mu_isomorphic","children":[{"definition":"my","name":"$net1","localvar":"my","containerName":"is_mu_isomorphic","kind":13,"line":1127},{"line":1127,"containerName":"is_mu_isomorphic","kind":13,"name":"$net2"},{"line":1128,"name":"$net1","containerName":"is_mu_isomorphic","kind":13},{"line":1128,"name":"mudata_string","kind":12,"containerName":"is_mu_isomorphic"},{"line":1128,"containerName":"is_mu_isomorphic","kind":13,"name":"$net2"},{"line":1128,"name":"mudata_string","containerName":"is_mu_isomorphic","kind":12}],"detail":"($net1,$net2)","definition":"sub"},{"name":"compute_tripartition_node","containerName":"main::","children":[{"definition":"my","line":1134,"kind":13,"localvar":"my","containerName":"compute_tripartition_node","name":"$self"},{"name":"$u","containerName":"compute_tripartition_node","kind":13,"line":1134},{"name":"$self","containerName":"compute_tripartition_node","kind":13,"line":1135},{"line":1135,"containerName":"compute_tripartition_node","kind":12,"name":"warn"},{"kind":13,"containerName":"compute_tripartition_node","name":"$self","line":1136},{"definition":"my","line":1137,"name":"$root","localvar":"my","kind":13,"containerName":"compute_tripartition_node"},{"kind":13,"containerName":"compute_tripartition_node","name":"$self","line":1137},{"definition":"my","line":1138,"containerName":"compute_tripartition_node","localvar":"my","kind":13,"name":"$graph"},{"line":1138,"name":"$self","kind":13,"containerName":"compute_tripartition_node"},{"definition":"my","line":1139,"name":"$graphPruned","localvar":"my","containerName":"compute_tripartition_node","kind":13},{"kind":13,"containerName":"compute_tripartition_node","name":"$graph","line":1139},{"name":"copy","kind":12,"containerName":"compute_tripartition_node","line":1139},{"name":"$graphPruned","containerName":"compute_tripartition_node","kind":13,"line":1140},{"containerName":"compute_tripartition_node","kind":12,"name":"delete_vertex","line":1140},{"name":"$u","containerName":"compute_tripartition_node","kind":13,"line":1140},{"line":1141,"localvar":"my","kind":13,"containerName":"compute_tripartition_node","name":"$tripartition","definition":"my"},{"line":1142,"containerName":"compute_tripartition_node","localvar":"my","kind":13,"name":"$leaf","definition":"my"},{"line":1142,"kind":13,"containerName":"compute_tripartition_node","name":"$self"}],"detail":"($self,$u)","definition":"sub","kind":12,"range":{"start":{"line":1133,"character":0},"end":{"character":9999,"line":1142}},"line":1133,"signature":{"label":"compute_tripartition_node($self,$u)","documentation":" tripartitions","parameters":[{"label":"$self"},{"label":"$u"}]}},{"name":"numroots","kind":12,"line":1136},{"kind":12,"name":"roots","line":1137},{"line":1138,"kind":12,"name":"graph"},{"line":1142,"name":"leaves","kind":12},{"name":"$type","localvar":"my","kind":13,"containerName":null,"line":1143,"definition":"my"},{"containerName":null,"kind":13,"name":"$graph","line":1144},{"line":1144,"name":"is_reachable","kind":12,"containerName":"main::"},{"line":1144,"kind":13,"containerName":null,"name":"$u"},{"line":1144,"kind":13,"containerName":null,"name":"%leaf"},{"kind":13,"containerName":null,"name":"$graphPruned","line":1145},{"containerName":"main::","kind":12,"name":"is_reachable","line":1145},{"line":1145,"containerName":null,"kind":13,"name":"$root"},{"line":1145,"name":"%leaf","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%type","line":1145},{"containerName":null,"kind":13,"name":"%type","line":1146},{"line":1148,"name":"$type","kind":13,"containerName":null},{"name":"$tripartition","containerName":null,"kind":13,"line":1149},{"line":1149,"name":"$type","kind":13,"containerName":null},{"name":"%self","containerName":null,"kind":13,"line":1151},{"kind":12,"name":"tripartitions","line":1151},{"line":1151,"containerName":null,"kind":13,"name":"$u"},{"kind":13,"containerName":null,"name":"$tripartition","line":1151},{"detail":"($self)","definition":"sub","name":"compute_tripartitions","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"compute_tripartitions","name":"$self","line":1155},{"line":1156,"name":"$node","containerName":"compute_tripartitions","localvar":"my","kind":13,"definition":"my"},{"line":1156,"name":"$self","containerName":"compute_tripartitions","kind":13}],"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"compute_tripartitions($self)"},"kind":12,"range":{"end":{"line":1156,"character":9999},"start":{"character":0,"line":1154}},"line":1154},{"line":1156,"kind":12,"name":"nodes"},{"kind":13,"containerName":null,"name":"$self","line":1157},{"containerName":"main::","kind":12,"name":"compute_tripartition_node","line":1157},{"line":1157,"kind":13,"containerName":null,"name":"$node"},{"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"tripartitions","line":1177},{"line":1178,"name":"$self","containerName":"tripartitions","kind":13},{"line":1178,"name":"compute_tripartitions","containerName":"tripartitions","kind":12},{"line":1178,"kind":13,"containerName":"tripartitions","name":"$self"},{"line":1179,"containerName":"tripartitions","kind":13,"name":"$self"}],"containerName":"main::","name":"tripartitions","definition":"sub","detail":"($self)","line":1176,"kind":12,"range":{"start":{"line":1176,"character":0},"end":{"character":9999,"line":1179}},"signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.","parameters":[{"label":"$self"}],"label":"tripartitions($self)"}},{"line":1178,"name":"tripartitions","kind":12},{"kind":12,"name":"tripartitions","line":1179},{"children":[{"line":1185,"localvar":"my","kind":13,"containerName":"tripartition_error","name":"$net1","definition":"my"},{"line":1185,"kind":13,"containerName":"tripartition_error","name":"$net2"},{"definition":"my","line":1186,"name":"$comp","localvar":"my","kind":13,"containerName":"tripartition_error"},{"line":1186,"name":"new","kind":12,"containerName":"tripartition_error"},{"line":1187,"containerName":"tripartition_error","kind":13,"name":"$net1"},{"name":"throw","kind":12,"containerName":"tripartition_error","line":1187},{"line":1188,"containerName":"tripartition_error","kind":13,"name":"$comp"},{"kind":12,"containerName":"tripartition_error","name":"compare","line":1188},{"kind":13,"containerName":"tripartition_error","name":"$net1","line":1188},{"kind":13,"containerName":"tripartition_error","name":"$net2","line":1188},{"containerName":"tripartition_error","kind":13,"name":"$net1","line":1189},{"line":1189,"kind":12,"containerName":"tripartition_error","name":"warn"},{"line":1190,"kind":13,"containerName":"tripartition_error","name":"$net1"},{"line":1190,"name":"is_tree_child","containerName":"tripartition_error","kind":12},{"line":1191,"kind":13,"containerName":"tripartition_error","name":"$net2"},{"line":1191,"kind":12,"containerName":"tripartition_error","name":"warn"},{"containerName":"tripartition_error","kind":13,"name":"$net2","line":1192},{"name":"is_tree_child","containerName":"tripartition_error","kind":12,"line":1192},{"line":1193,"kind":13,"containerName":"tripartition_error","name":"$net1"},{"line":1193,"containerName":"tripartition_error","kind":12,"name":"warn"},{"name":"$net1","kind":13,"containerName":"tripartition_error","line":1194},{"line":1194,"containerName":"tripartition_error","kind":12,"name":"is_time_consistent"},{"name":"$net2","kind":13,"containerName":"tripartition_error","line":1195},{"line":1195,"containerName":"tripartition_error","kind":12,"name":"warn"},{"name":"$net2","kind":13,"containerName":"tripartition_error","line":1196},{"name":"is_time_consistent","containerName":"tripartition_error","kind":12,"line":1196},{"line":1197,"name":"$net1","kind":13,"containerName":"tripartition_error"},{"line":1197,"name":"compute_tripartitions","kind":12,"containerName":"tripartition_error"},{"line":1197,"kind":13,"containerName":"tripartition_error","name":"$net1"},{"containerName":"tripartition_error","kind":13,"name":"$net2","line":1198},{"name":"compute_tripartitions","containerName":"tripartition_error","kind":12,"line":1198},{"kind":13,"containerName":"tripartition_error","name":"$net2","line":1198},{"definition":"my","line":1199,"name":"@edges1","localvar":"my","kind":13,"containerName":"tripartition_error"},{"line":1199,"name":"$net1","kind":13,"containerName":"tripartition_error"},{"name":"edges","containerName":"tripartition_error","kind":12,"line":1199},{"name":"@edges2","kind":13,"localvar":"my","containerName":"tripartition_error","line":1200,"definition":"my"},{"line":1200,"name":"$net2","kind":13,"containerName":"tripartition_error"},{"kind":12,"containerName":"tripartition_error","name":"edges","line":1200},{"definition":"my","name":"$FN","kind":13,"localvar":"my","containerName":"tripartition_error","line":1201},{"containerName":"tripartition_error","kind":13,"name":"$FP","line":1201},{"definition":"my","containerName":"tripartition_error","localvar":"my","kind":13,"name":"$edge1","line":1202},{"line":1202,"containerName":"tripartition_error","kind":13,"name":"@edges1"},{"line":1203,"name":"$matched","containerName":"tripartition_error","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":1204,"name":"$edge2","kind":13,"localvar":"my","containerName":"tripartition_error"},{"line":1204,"name":"@edges2","containerName":"tripartition_error","kind":13},{"name":"$net1","containerName":"tripartition_error","kind":13,"line":1205},{"line":1205,"containerName":"tripartition_error","kind":13,"name":"$edge1"},{"line":1206,"kind":13,"containerName":"tripartition_error","name":"$net2"},{"line":1206,"containerName":"tripartition_error","kind":13,"name":"$edge2"},{"line":1207,"name":"$matched","containerName":"tripartition_error","kind":13},{"line":1211,"kind":13,"containerName":"tripartition_error","name":"$matched"},{"containerName":"tripartition_error","kind":13,"name":"$FN","line":1211},{"line":1213,"localvar":"my","containerName":"tripartition_error","kind":13,"name":"$edge2","definition":"my"},{"line":1213,"name":"@edges2","containerName":"tripartition_error","kind":13},{"definition":"my","name":"$matched","containerName":"tripartition_error","localvar":"my","kind":13,"line":1214},{"line":1215,"containerName":"tripartition_error","localvar":"my","kind":13,"name":"$edge1","definition":"my"},{"line":1215,"containerName":"tripartition_error","kind":13,"name":"@edges1"},{"line":1216,"name":"$net1","containerName":"tripartition_error","kind":13},{"name":"$edge1","kind":13,"containerName":"tripartition_error","line":1216},{"containerName":"tripartition_error","kind":13,"name":"$net2","line":1217},{"line":1217,"kind":13,"containerName":"tripartition_error","name":"$edge2"},{"line":1218,"containerName":"tripartition_error","kind":13,"name":"$matched"},{"line":1222,"kind":13,"containerName":"tripartition_error","name":"$matched"},{"name":"$FP","kind":13,"containerName":"tripartition_error","line":1222},{"line":1224,"name":"$FN","kind":13,"containerName":"tripartition_error"},{"line":1224,"containerName":"tripartition_error","kind":13,"name":"@edges1"},{"name":"$FP","kind":13,"containerName":"tripartition_error","line":1224},{"kind":13,"containerName":"tripartition_error","name":"@edges2","line":1224}],"containerName":"main::","name":"tripartition_error","definition":"sub","detail":"($net1,$net2)","line":1184,"range":{"start":{"character":0,"line":1184},"end":{"character":9999,"line":1225}},"kind":12,"signature":{"parameters":[{"label":"$net1"},{"label":"$net2"}],"documentation":" to do: change to tri_distance and test for TC and time-cons","label":"tripartition_error($net1,$net2)"}},{"name":"Array","containerName":"Compare","kind":12,"line":1186},{"name":"leaves","kind":12,"line":1188},{"name":"leaves","kind":12,"line":1188},{"name":"tripartitions","kind":12,"line":1197},{"kind":12,"name":"tripartitions","line":1198},{"line":1199,"kind":12,"name":"graph"},{"line":1200,"kind":12,"name":"graph"},{"kind":12,"name":"tripartitions","line":1205},{"name":"tripartitions","kind":12,"line":1206},{"line":1216,"kind":12,"name":"tripartitions"},{"name":"tripartitions","kind":12,"line":1217},{"name":"is_time_consistent","containerName":"main::","children":[{"definition":"my","line":1242,"name":"$self","localvar":"my","kind":13,"containerName":"is_time_consistent"},{"containerName":"is_time_consistent","kind":13,"name":"$self","line":1243},{"line":1243,"name":"compute_temporal_representation","kind":12,"containerName":"is_time_consistent"},{"line":1244,"name":"$self","containerName":"is_time_consistent","kind":13},{"line":1245,"kind":13,"containerName":"is_time_consistent","name":"$self"}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":1246},"start":{"character":0,"line":1241}},"line":1241,"signature":{"label":"is_time_consistent($self)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none","parameters":[{"label":"$self"}]}},{"name":"has_temporal_representation","kind":12,"line":1244},{"line":1245,"name":"has_temporal_representation","kind":12},{"definition":"sub","detail":"($self)","children":[{"line":1260,"kind":13,"localvar":"my","containerName":"temporal_representation","name":"$self","definition":"my"},{"line":1261,"name":"$self","containerName":"temporal_representation","kind":13},{"kind":12,"containerName":"temporal_representation","name":"is_time_consistent","line":1261},{"name":"$self","containerName":"temporal_representation","kind":13,"line":1262}],"containerName":"main::","name":"temporal_representation","signature":{"label":"temporal_representation($self)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none","parameters":[{"label":"$self"}]},"line":1259,"range":{"start":{"line":1259,"character":0},"end":{"line":1263,"character":9999}},"kind":12},{"line":1262,"name":"temporal_representation","kind":12},{"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"compute_temporal_representation($self)"},"line":1267,"range":{"end":{"character":9999,"line":1289},"start":{"line":1267,"character":0}},"kind":12,"definition":"sub","detail":"($self)","children":[{"kind":13,"localvar":"my","containerName":"compute_temporal_representation","name":"$self","line":1268,"definition":"my"},{"definition":"my","line":1269,"localvar":"my","kind":13,"containerName":"compute_temporal_representation","name":"$quotient"},{"line":1269,"name":"new","kind":12,"containerName":"compute_temporal_representation"},{"definition":"my","line":1270,"kind":13,"localvar":"my","containerName":"compute_temporal_representation","name":"$classes"},{"line":1270,"kind":13,"containerName":"compute_temporal_representation","name":"$self"},{"definition":"my","line":1271,"name":"%repr","localvar":"my","kind":13,"containerName":"compute_temporal_representation"},{"line":1272,"kind":13,"containerName":"compute_temporal_representation","name":"$repr"},{"line":1272,"name":"$classes","kind":13,"containerName":"compute_temporal_representation"},{"line":1272,"name":"$self","kind":13,"containerName":"compute_temporal_representation"},{"name":"nodes","containerName":"compute_temporal_representation","kind":12,"line":1272},{"definition":"my","kind":13,"localvar":"my","containerName":"compute_temporal_representation","name":"$e","line":1273},{"name":"$self","containerName":"compute_temporal_representation","kind":13,"line":1273},{"containerName":"compute_temporal_representation","kind":12,"name":"tree_edges","line":1273},{"line":1274,"kind":13,"containerName":"compute_temporal_representation","name":"$quotient"},{"name":"add_edge","kind":12,"containerName":"compute_temporal_representation","line":1274},{"line":1274,"kind":13,"containerName":"compute_temporal_representation","name":"$repr"},{"kind":13,"containerName":"compute_temporal_representation","name":"$e","line":1274},{"containerName":"compute_temporal_representation","kind":13,"name":"$repr","line":1274},{"kind":13,"containerName":"compute_temporal_representation","name":"$e","line":1274},{"definition":"my","localvar":"my","containerName":"compute_temporal_representation","kind":13,"name":"%temp","line":1276},{"definition":"my","kind":13,"localvar":"my","containerName":"compute_temporal_representation","name":"$depth","line":1277},{"line":1278,"containerName":"compute_temporal_representation","kind":13,"name":"$quotient"},{"line":1278,"containerName":"compute_temporal_representation","kind":12,"name":"vertices"},{"line":1279,"name":"@svs","containerName":"compute_temporal_representation","localvar":"my","kind":13,"definition":"my"},{"line":1279,"containerName":"compute_temporal_representation","kind":13,"name":"$quotient"},{"line":1279,"name":"predecessorless_vertices","kind":12,"containerName":"compute_temporal_representation"},{"definition":"my","line":1280,"name":"$sv","containerName":"compute_temporal_representation","localvar":"my","kind":13},{"line":1280,"containerName":"compute_temporal_representation","kind":13,"name":"@svs"},{"name":"$temp","kind":13,"containerName":"compute_temporal_representation","line":1281},{"line":1281,"name":"$sv","containerName":"compute_temporal_representation","kind":13},{"containerName":"compute_temporal_representation","kind":13,"name":"$depth","line":1281},{"line":1283,"name":"$quotient","containerName":"compute_temporal_representation","kind":13},{"containerName":"compute_temporal_representation","kind":12,"name":"delete_vertices","line":1283},{"line":1283,"name":"@svs","containerName":"compute_temporal_representation","kind":13},{"name":"$depth","containerName":"compute_temporal_representation","kind":13,"line":1287},{"line":1289,"kind":13,"localvar":"my","containerName":"compute_temporal_representation","name":"$node","definition":"my"},{"kind":13,"containerName":"compute_temporal_representation","name":"$self","line":1289}],"name":"compute_temporal_representation","containerName":"main::"},{"line":1269,"containerName":"Directed","kind":12,"name":"Graph"},{"line":1270,"name":"find_classes","kind":12},{"line":1289,"name":"nodes","kind":12},{"line":1290,"containerName":null,"kind":13,"name":"%temp"},{"line":1290,"containerName":null,"kind":13,"name":"$node"},{"kind":13,"containerName":null,"name":"%temp","line":1290},{"line":1290,"name":"%repr","kind":13,"containerName":null},{"line":1290,"kind":13,"containerName":null,"name":"$node"},{"name":"%self","kind":13,"containerName":null,"line":1292},{"name":"temporal_representation","kind":12,"line":1292},{"line":1292,"containerName":null,"kind":13,"name":"%temp"},{"line":1293,"kind":13,"containerName":null,"name":"%self"},{"line":1293,"name":"has_temporal_representation","kind":12},{"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"find_classes($self)"},"kind":12,"range":{"end":{"character":9999,"line":1304},"start":{"character":0,"line":1296}},"line":1296,"detail":"($self)","definition":"sub","name":"find_classes","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"find_classes","line":1297,"definition":"my"},{"line":1298,"localvar":"my","containerName":"find_classes","kind":13,"name":"$classes","definition":"my"},{"name":"$classes","kind":13,"containerName":"find_classes","line":1299},{"name":"$self","containerName":"find_classes","kind":13,"line":1299},{"line":1299,"containerName":"find_classes","kind":12,"name":"nodes"},{"definition":"my","line":1300,"kind":13,"localvar":"my","containerName":"find_classes","name":"$e"},{"line":1300,"kind":13,"containerName":"find_classes","name":"$self"},{"line":1300,"kind":12,"containerName":"find_classes","name":"hybrid_edges"},{"kind":13,"containerName":"find_classes","name":"$classes","line":1301},{"line":1301,"name":"$classes","containerName":"find_classes","kind":13},{"kind":13,"containerName":"find_classes","name":"$e","line":1301},{"kind":13,"containerName":"find_classes","name":"$e","line":1301},{"name":"$classes","kind":13,"containerName":"find_classes","line":1303}]},{"line":1301,"kind":12,"name":"join_classes"},{"containerName":"main::","name":"join_classes","children":[{"line":1307,"name":"$classes","localvar":"my","kind":13,"containerName":"join_classes","definition":"my"},{"line":1307,"containerName":"join_classes","kind":13,"name":"$u"},{"kind":13,"containerName":"join_classes","name":"$v","line":1307},{"definition":"my","localvar":"my","kind":13,"containerName":"join_classes","name":"@clu","line":1308},{"name":"$classes","containerName":"join_classes","kind":13,"line":1308},{"name":"$u","kind":13,"containerName":"join_classes","line":1308}],"detail":"($classes,$u,$v)","definition":"sub","range":{"end":{"character":9999,"line":1308},"start":{"character":0,"line":1306}},"kind":12,"line":1306,"signature":{"label":"join_classes($classes,$u,$v)","parameters":[{"label":"$classes"},{"label":"$u"},{"label":"$v"}],"documentation":""}},{"kind":13,"localvar":"my","containerName":null,"name":"@clv","line":1309,"definition":"my"},{"name":"%classes","kind":13,"containerName":null,"line":1309},{"line":1309,"kind":13,"containerName":null,"name":"$v"},{"localvar":"my","containerName":null,"kind":13,"name":"@cljoin","line":1310,"definition":"my"},{"kind":13,"containerName":null,"name":"@clu","line":1310},{"containerName":null,"kind":13,"name":"@clv","line":1310},{"name":"%classes","containerName":null,"kind":13,"line":1311},{"containerName":null,"kind":13,"name":"@cljoin","line":1311},{"line":1311,"containerName":null,"kind":13,"name":"@cljoin"},{"line":1312,"containerName":null,"kind":13,"name":"$classes"},{"line":1331,"range":{"start":{"character":0,"line":1331},"end":{"character":9999,"line":1355}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none","label":"contract_elementary($self)"},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"contract_elementary","name":"$self","line":1332},{"definition":"my","name":"$contracted","containerName":"contract_elementary","localvar":"my","kind":13,"line":1334},{"line":1334,"name":"$self","containerName":"contract_elementary","kind":13},{"kind":12,"containerName":"contract_elementary","name":"graph","line":1334},{"line":1334,"name":"copy","kind":12,"containerName":"contract_elementary"},{"definition":"my","localvar":"my","kind":13,"containerName":"contract_elementary","name":"@nodes","line":1335},{"containerName":"contract_elementary","kind":13,"name":"$self","line":1335},{"kind":12,"containerName":"contract_elementary","name":"nodes","line":1335},{"line":1336,"localvar":"my","kind":13,"containerName":"contract_elementary","name":"$mus","definition":"my"},{"kind":13,"containerName":"contract_elementary","name":"$self","line":1336},{"definition":"my","line":1337,"containerName":"contract_elementary","localvar":"my","kind":13,"name":"$hs"},{"containerName":"contract_elementary","kind":13,"name":"$self","line":1337},{"localvar":"my","containerName":"contract_elementary","kind":13,"name":"%blocks","line":1338,"definition":"my"},{"line":1339,"name":"$u","containerName":"contract_elementary","localvar":"my","kind":13,"definition":"my"},{"name":"@nodes","kind":13,"containerName":"contract_elementary","line":1339},{"line":1340,"name":"$blocks","kind":13,"containerName":"contract_elementary"},{"line":1340,"kind":13,"containerName":"contract_elementary","name":"$u"},{"line":1340,"containerName":"contract_elementary","kind":13,"name":"$u"},{"definition":"my","localvar":"my","kind":13,"containerName":"contract_elementary","name":"@elementary","line":1342},{"line":1342,"kind":13,"containerName":"contract_elementary","name":"$contracted"},{"line":1342,"containerName":"contract_elementary","kind":12,"name":"out_degree"},{"line":1342,"name":"$self","containerName":"contract_elementary","kind":13},{"containerName":"contract_elementary","kind":12,"name":"tree_nodes","line":1342},{"line":1343,"name":"@elementary","containerName":"contract_elementary","kind":13},{"name":"$mus","containerName":"contract_elementary","kind":13,"line":1343},{"line":1343,"name":"$b","containerName":"contract_elementary","kind":13},{"containerName":"contract_elementary","kind":13,"name":"$mus","line":1343},{"name":"$a","containerName":"contract_elementary","kind":13,"line":1343},{"line":1344,"containerName":"contract_elementary","kind":13,"name":"$hs"},{"line":1344,"kind":13,"containerName":"contract_elementary","name":"$b"},{"line":1344,"name":"$hs","containerName":"contract_elementary","kind":13},{"line":1344,"kind":13,"containerName":"contract_elementary","name":"$a"},{"containerName":"contract_elementary","kind":13,"name":"@elementary","line":1344},{"localvar":"my","containerName":"contract_elementary","kind":13,"name":"$elem","line":1345,"definition":"my"},{"line":1345,"name":"@elementary","containerName":"contract_elementary","kind":13},{"line":1346,"name":"@children","localvar":"my","containerName":"contract_elementary","kind":13,"definition":"my"},{"line":1346,"kind":13,"containerName":"contract_elementary","name":"$contracted"},{"line":1346,"kind":12,"containerName":"contract_elementary","name":"successors"},{"containerName":"contract_elementary","kind":13,"name":"$elem","line":1346},{"definition":"my","name":"$child","kind":13,"localvar":"my","containerName":"contract_elementary","line":1347},{"name":"$children","kind":13,"containerName":"contract_elementary","line":1347},{"line":1348,"containerName":"contract_elementary","kind":13,"name":"$contracted"},{"line":1348,"name":"in_degree","kind":12,"containerName":"contract_elementary"},{"line":1348,"name":"$elem","kind":13,"containerName":"contract_elementary"},{"line":1349,"kind":13,"localvar":"my","containerName":"contract_elementary","name":"@parents","definition":"my"},{"kind":13,"containerName":"contract_elementary","name":"$contracted","line":1349},{"line":1349,"name":"predecessors","kind":12,"containerName":"contract_elementary"},{"line":1349,"name":"$elem","kind":13,"containerName":"contract_elementary"},{"line":1350,"name":"$parent","containerName":"contract_elementary","localvar":"my","kind":13,"definition":"my"},{"line":1350,"kind":13,"containerName":"contract_elementary","name":"$parents"},{"line":1351,"kind":13,"containerName":"contract_elementary","name":"$contracted"},{"line":1351,"name":"add_edge","kind":12,"containerName":"contract_elementary"},{"line":1351,"containerName":"contract_elementary","kind":13,"name":"$parent"},{"name":"$child","containerName":"contract_elementary","kind":13,"line":1351},{"line":1353,"name":"$contracted","kind":13,"containerName":"contract_elementary"},{"name":"delete_vertex","containerName":"contract_elementary","kind":12,"line":1353},{"name":"$elem","kind":13,"containerName":"contract_elementary","line":1353},{"definition":"my","kind":13,"localvar":"my","containerName":"contract_elementary","name":"@blch","line":1354},{"line":1354,"containerName":"contract_elementary","kind":13,"name":"$blocks"},{"name":"$child","containerName":"contract_elementary","kind":13,"line":1354},{"definition":"my","kind":13,"localvar":"my","containerName":"contract_elementary","name":"@blem","line":1355},{"line":1355,"containerName":"contract_elementary","kind":13,"name":"$blocks"},{"name":"$elem","kind":13,"containerName":"contract_elementary","line":1355}],"containerName":"main::","name":"contract_elementary","definition":"sub","detail":"($self)"},{"kind":12,"name":"mudata","line":1336},{"name":"%blocks","containerName":null,"kind":13,"line":1356},{"kind":13,"containerName":null,"name":"@child","line":1356},{"line":1356,"containerName":null,"kind":13,"name":"@blem"},{"containerName":null,"kind":13,"name":"@blch","line":1356},{"line":1357,"name":"%blocks","containerName":null,"kind":13},{"name":"$elem","containerName":null,"kind":13,"line":1357},{"line":1359,"name":"$contr","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"kind":12,"containerName":"PhyloNetwork","name":"Bio","line":1359},{"line":1359,"name":"new","kind":12,"containerName":"main::"},{"line":1359,"name":"$contracted","containerName":null,"kind":13},{"line":1360,"name":"$contr","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%blocks","line":1360},{"signature":{"parameters":[{"label":"$net1"},{"label":"$net2"},{"label":"%params"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none\n\n\nsub contract_elementary {\n  my ($self)=@_;\n\n  my $contracted=$self->graph->copy();\n  my @nodes=$self->nodes();\n  my $mus=$self->{mudata};\n  my $hs=$self->{h};\n  my %blocks;\n  foreach my $u (@nodes) {\n    $blocks{$u}=[$u];\n  }\n  my @elementary=grep { $contracted->out_degree($_) == 1} $self->tree_nodes();\n  @elementary=sort {$mus->{$b} <=> $mus->{$a} ||\n\t\t\t $hs->{$b} <=> $hs->{$a}} @elementary;\n  foreach my $elem (@elementary) {\n    my @children=$contracted->successors($elem);\n    my $child=$children[0];\n    if ($contracted->in_degree($elem) == 1) {\n      my @parents=$contracted->predecessors($elem);\n      my $parent=$parents[0];\n      $contracted->add_edge($parent,$child);\n    }\n    $contracted->delete_vertex($elem);\n    my @blch=@{$blocks{$child}};\n    my @blem=@{$blocks{$elem}};\n    $blocks{$child}=[@blem,@blch];\n    delete $blocks{$elem};\n  }\n  my $contr=Bio::PhyloNetwork->new(-graph => $contracted);\n  return $contr,\\%blocks;\n}\n\n=head2 optimal_alignment\n\n Title   : optimal_alignment\n Usage   : my ($weight,$alignment,$wgts)=$net->optimal_alignment($net2)\n Function: returns the total weight of an optimal alignment,\n           the alignment itself, and partial weights\n           between the networks $net1 and $net2 on the same set of leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,reference to hash,reference to hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.","label":"optimal_alignment($net1,$net2,%params)"},"kind":12,"range":{"start":{"character":0,"line":1380},"end":{"line":1393,"character":9999}},"line":1380,"detail":"($net1,$net2,%params)","definition":"sub","containerName":"main::","name":"optimal_alignment","children":[{"definition":"my","line":1381,"name":"$net1","localvar":"my","containerName":"optimal_alignment","kind":13},{"name":"$net2","containerName":"optimal_alignment","kind":13,"line":1381},{"name":"%params","containerName":"optimal_alignment","kind":13,"line":1381},{"definition":"my","name":"$net1cont","localvar":"my","kind":13,"containerName":"optimal_alignment","line":1383},{"line":1383,"kind":13,"containerName":"optimal_alignment","name":"$blocks1"},{"line":1383,"containerName":"optimal_alignment","kind":13,"name":"$net1"},{"definition":"my","localvar":"my","containerName":"optimal_alignment","kind":13,"name":"$net2cont","line":1384},{"containerName":"optimal_alignment","kind":13,"name":"$blocks2","line":1384},{"containerName":"optimal_alignment","kind":13,"name":"$net2","line":1384},{"line":1385,"name":"$wc","containerName":"optimal_alignment","localvar":"my","kind":13,"definition":"my"},{"line":1385,"name":"$alignc","kind":13,"containerName":"optimal_alignment"},{"name":"$weightc","containerName":"optimal_alignment","kind":13,"line":1385},{"line":1386,"kind":13,"containerName":"optimal_alignment","name":"$net1cont"},{"line":1386,"name":"$net2cont","kind":13,"containerName":"optimal_alignment"},{"line":1386,"name":"%params","kind":13,"containerName":"optimal_alignment"},{"definition":"my","containerName":"optimal_alignment","localvar":"my","kind":13,"name":"%alignment","line":1387},{"line":1388,"kind":13,"localvar":"my","containerName":"optimal_alignment","name":"$totalweigth","definition":"my"},{"line":1389,"name":"%weigths","kind":13,"localvar":"my","containerName":"optimal_alignment","definition":"my"},{"name":"$u1","kind":13,"localvar":"my","containerName":"optimal_alignment","line":1390,"definition":"my"},{"line":1390,"containerName":"optimal_alignment","kind":13,"name":"$alignc"},{"definition":"my","line":1391,"name":"$u2","kind":13,"localvar":"my","containerName":"optimal_alignment"},{"kind":13,"containerName":"optimal_alignment","name":"$alignc","line":1391},{"line":1391,"kind":13,"containerName":"optimal_alignment","name":"$u1"},{"definition":"my","name":"@block1","localvar":"my","kind":13,"containerName":"optimal_alignment","line":1392},{"line":1392,"containerName":"optimal_alignment","kind":13,"name":"$blocks1"},{"line":1392,"name":"$u1","kind":13,"containerName":"optimal_alignment"},{"line":1393,"name":"@block2","localvar":"my","containerName":"optimal_alignment","kind":13,"definition":"my"},{"name":"$blocks2","containerName":"optimal_alignment","kind":13,"line":1393},{"name":"$u2","kind":13,"containerName":"optimal_alignment","line":1393}]},{"line":1386,"kind":12,"name":"optimal_alignment_noelementary"},{"line":1394,"name":"@block1","containerName":null,"kind":13},{"line":1394,"containerName":null,"kind":13,"name":"@block2"},{"definition":"my","name":"$u1dc","localvar":"my","kind":13,"containerName":null,"line":1395},{"kind":13,"containerName":null,"name":"@block1","line":1395},{"definition":"my","name":"$u2dc","kind":13,"localvar":"my","containerName":null,"line":1396},{"containerName":null,"kind":13,"name":"@block2","line":1396},{"line":1397,"kind":13,"containerName":null,"name":"%alignment"},{"line":1397,"name":"$u1dc","kind":13,"containerName":null},{"line":1397,"name":"$u2dc","containerName":null,"kind":13},{"name":"%weigths","containerName":null,"kind":13,"line":1398},{"line":1398,"name":"$u1dc","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%weightc","line":1398},{"line":1398,"containerName":null,"kind":13,"name":"$u1"},{"line":1399,"kind":13,"containerName":null,"name":"$totalweigth"},{"name":"%weigths","containerName":null,"kind":13,"line":1399},{"line":1399,"kind":13,"containerName":null,"name":"$u1dc"},{"containerName":null,"kind":13,"name":"$totalweigth","line":1402},{"line":1402,"kind":13,"containerName":null,"name":"%alignment"},{"name":"%weigths","kind":13,"containerName":null,"line":1402},{"detail":"($net1,$net2,%params)","definition":"sub","name":"optimal_alignment_noelementary","containerName":"main::","children":[{"localvar":"my","containerName":"optimal_alignment_noelementary","kind":13,"name":"$net1","line":1406,"definition":"my"},{"line":1406,"name":"$net2","kind":13,"containerName":"optimal_alignment_noelementary"},{"containerName":"optimal_alignment_noelementary","kind":13,"name":"%params","line":1406},{"definition":"my","localvar":"my","containerName":"optimal_alignment_noelementary","kind":13,"name":"$comp","line":1408},{"name":"new","containerName":"optimal_alignment_noelementary","kind":12,"line":1408},{"line":1409,"name":"$net1","containerName":"optimal_alignment_noelementary","kind":13},{"line":1409,"name":"throw","containerName":"optimal_alignment_noelementary","kind":12},{"name":"$comp","kind":13,"containerName":"optimal_alignment_noelementary","line":1410},{"name":"compare","kind":12,"containerName":"optimal_alignment_noelementary","line":1410},{"line":1410,"name":"$net1","containerName":"optimal_alignment_noelementary","kind":13},{"kind":13,"containerName":"optimal_alignment_noelementary","name":"$net2","line":1410},{"line":1411,"name":"$distance","kind":13,"localvar":"my","containerName":"optimal_alignment_noelementary","definition":"my"},{"line":1412,"containerName":"optimal_alignment_noelementary","kind":13,"name":"$params"},{"kind":13,"containerName":"optimal_alignment_noelementary","name":"$params","line":1412},{"name":"$distance","kind":13,"containerName":"optimal_alignment_noelementary","line":1413},{"line":1415,"kind":13,"containerName":"optimal_alignment_noelementary","name":"$distance"},{"name":"$numleaves","kind":13,"localvar":"my","containerName":"optimal_alignment_noelementary","line":1417,"definition":"my"},{"line":1417,"kind":13,"containerName":"optimal_alignment_noelementary","name":"$net1"},{"localvar":"my","kind":13,"containerName":"optimal_alignment_noelementary","name":"@nodes1","line":1418,"definition":"my"},{"line":1418,"kind":13,"containerName":"optimal_alignment_noelementary","name":"$net1"},{"line":1418,"name":"internal_nodes","kind":12,"containerName":"optimal_alignment_noelementary"},{"definition":"my","line":1419,"name":"@nodes2","kind":13,"localvar":"my","containerName":"optimal_alignment_noelementary"},{"line":1419,"kind":13,"containerName":"optimal_alignment_noelementary","name":"$net2"},{"line":1419,"name":"internal_nodes","containerName":"optimal_alignment_noelementary","kind":12},{"definition":"my","containerName":"optimal_alignment_noelementary","localvar":"my","kind":13,"name":"$numnodes1","line":1420},{"containerName":"optimal_alignment_noelementary","kind":13,"name":"@nodes1","line":1420},{"line":1421,"localvar":"my","kind":13,"containerName":"optimal_alignment_noelementary","name":"$numnodes2","definition":"my"},{"name":"@nodes2","containerName":"optimal_alignment_noelementary","kind":13,"line":1421},{"definition":"my","localvar":"my","kind":13,"containerName":"optimal_alignment_noelementary","name":"@matrix","line":1422},{"localvar":"my","kind":13,"containerName":"optimal_alignment_noelementary","name":"$i","line":1423,"definition":"my"},{"line":1423,"kind":13,"containerName":"optimal_alignment_noelementary","name":"$i"},{"line":1423,"containerName":"optimal_alignment_noelementary","kind":13,"name":"$numnodes1"},{"containerName":"optimal_alignment_noelementary","kind":13,"name":"$i","line":1423},{"definition":"my","line":1424,"name":"@row","localvar":"my","containerName":"optimal_alignment_noelementary","kind":13},{"definition":"my","containerName":"optimal_alignment_noelementary","localvar":"my","kind":13,"name":"$j","line":1425},{"kind":13,"containerName":"optimal_alignment_noelementary","name":"$j","line":1425},{"line":1425,"name":"$numnodes2","kind":13,"containerName":"optimal_alignment_noelementary"},{"name":"$j","containerName":"optimal_alignment_noelementary","kind":13,"line":1425},{"line":1426,"kind":13,"containerName":"optimal_alignment_noelementary","name":"@row"},{"name":"$net1","containerName":"optimal_alignment_noelementary","kind":13,"line":1426},{"line":1426,"name":"$nodes1","containerName":"optimal_alignment_noelementary","kind":13},{"containerName":"optimal_alignment_noelementary","kind":13,"name":"$i","line":1426},{"line":1426,"name":"$net2","containerName":"optimal_alignment_noelementary","kind":13},{"containerName":"optimal_alignment_noelementary","kind":13,"name":"$nodes2","line":1426},{"line":1426,"name":"$j","containerName":"optimal_alignment_noelementary","kind":13},{"line":1426,"name":"$distance","kind":13,"containerName":"optimal_alignment_noelementary"},{"containerName":"optimal_alignment_noelementary","kind":13,"name":"@matrix","line":1428},{"line":1428,"name":"@row","kind":13,"containerName":"optimal_alignment_noelementary"},{"line":1430,"containerName":"optimal_alignment_noelementary","localvar":"my","kind":13,"name":"@alignment","definition":"my"},{"name":"@matrix","kind":13,"containerName":"optimal_alignment_noelementary","line":1431},{"containerName":"optimal_alignment_noelementary","kind":13,"name":"@alignment","line":1431},{"localvar":"my","containerName":"optimal_alignment_noelementary","kind":13,"name":"%alignmenthash","line":1432,"definition":"my"},{"localvar":"my","kind":13,"containerName":"optimal_alignment_noelementary","name":"%weighthash","line":1433,"definition":"my"},{"definition":"my","line":1434,"localvar":"my","containerName":"optimal_alignment_noelementary","kind":13,"name":"$totalw"},{"definition":"my","line":1435,"localvar":"my","containerName":"optimal_alignment_noelementary","kind":13,"name":"$leaf"},{"containerName":"optimal_alignment_noelementary","kind":13,"name":"$net1","line":1435}],"signature":{"documentation":"","parameters":[{"label":"$net1"},{"label":"$net2"},{"label":"%params"}],"label":"optimal_alignment_noelementary($net1,$net2,%params)"},"kind":12,"range":{"end":{"line":1435,"character":9999},"start":{"line":1405,"character":0}},"line":1405},{"line":1408,"name":"Array","containerName":"Compare","kind":12},{"name":"leaves","kind":12,"line":1410},{"name":"leaves","kind":12,"line":1410},{"name":"numleaves","kind":12,"line":1417},{"kind":12,"name":"weight","line":1426},{"kind":12,"name":"assign","line":1431},{"line":1435,"name":"leaves","kind":12},{"name":"%alignmenthash","kind":13,"containerName":null,"line":1436},{"line":1436,"kind":13,"containerName":null,"name":"$leaf"},{"containerName":null,"kind":13,"name":"$leaf","line":1436},{"line":1437,"kind":13,"containerName":null,"name":"%weighthash"},{"line":1437,"kind":13,"containerName":null,"name":"$leaf"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$i","line":1439},{"line":1439,"kind":13,"containerName":null,"name":"$i"},{"line":1439,"kind":13,"containerName":null,"name":"$numnodes1"},{"kind":13,"containerName":null,"name":"%i","line":1439},{"kind":13,"containerName":null,"name":"@nodes2","line":1440},{"line":1440,"kind":13,"containerName":null,"name":"@alignment"},{"line":1440,"kind":13,"containerName":null,"name":"%i"},{"line":1441,"name":"%alignmenthash","kind":13,"containerName":null},{"line":1441,"containerName":null,"kind":13,"name":"@nodes1"},{"name":"$i","kind":13,"containerName":null,"line":1441},{"name":"@nodes2","kind":13,"containerName":null,"line":1441},{"name":"@alignment","kind":13,"containerName":null,"line":1441},{"name":"$i","kind":13,"containerName":null,"line":1441},{"line":1442,"name":"%weighthash","kind":13,"containerName":null},{"line":1442,"containerName":null,"kind":13,"name":"@nodes1"},{"line":1442,"containerName":null,"kind":13,"name":"$i"},{"line":1442,"kind":13,"containerName":null,"name":"@matrix"},{"line":1442,"name":"@i","containerName":null,"kind":13},{"line":1442,"kind":13,"containerName":null,"name":"@alignment"},{"line":1442,"containerName":null,"kind":13,"name":"$i"},{"line":1443,"name":"$totalw","containerName":null,"kind":13},{"line":1443,"kind":13,"containerName":null,"name":"@matrix"},{"name":"@i","containerName":null,"kind":13,"line":1443},{"line":1443,"name":"@alignment","kind":13,"containerName":null},{"line":1443,"containerName":null,"kind":13,"name":"$i"},{"name":"$totalw","kind":13,"containerName":null,"line":1446},{"line":1446,"containerName":null,"kind":13,"name":"%alignmenthash"},{"containerName":null,"kind":13,"name":"%weighthash","line":1446},{"definition":"sub","detail":"($net1,$net2,%params)","children":[{"name":"$net1","containerName":"optimal_alignment_generalized","localvar":"my","kind":13,"line":1467,"definition":"my"},{"line":1467,"name":"$net2","kind":13,"containerName":"optimal_alignment_generalized"},{"line":1467,"kind":13,"containerName":"optimal_alignment_generalized","name":"%params"},{"line":1468,"name":"$netr1","localvar":"my","containerName":"optimal_alignment_generalized","kind":13,"definition":"my"},{"containerName":"optimal_alignment_generalized","kind":13,"name":"$netr2","line":1468},{"name":"$net1","containerName":"optimal_alignment_generalized","kind":13,"line":1468},{"line":1468,"kind":12,"containerName":"optimal_alignment_generalized","name":"topological_restriction"},{"containerName":"optimal_alignment_generalized","kind":13,"name":"$net2","line":1468},{"line":1469,"kind":13,"containerName":"optimal_alignment_generalized","name":"$netr1"},{"name":"optimal_alignment","containerName":"optimal_alignment_generalized","kind":12,"line":1469},{"kind":13,"containerName":"optimal_alignment_generalized","name":"$netr2","line":1469},{"line":1469,"kind":13,"containerName":"optimal_alignment_generalized","name":"%params"}],"containerName":"main::","name":"optimal_alignment_generalized","signature":{"parameters":[{"label":"$net1"},{"label":"$net2"},{"label":"%params"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none\n\n\nsub contract_elementary {\n  my ($self)=@_;\n\n  my $contracted=$self->graph->copy();\n  my @nodes=$self->nodes();\n  my $mus=$self->{mudata};\n  my $hs=$self->{h};\n  my %blocks;\n  foreach my $u (@nodes) {\n    $blocks{$u}=[$u];\n  }\n  my @elementary=grep { $contracted->out_degree($_) == 1} $self->tree_nodes();\n  @elementary=sort {$mus->{$b} <=> $mus->{$a} ||\n\t\t\t $hs->{$b} <=> $hs->{$a}} @elementary;\n  foreach my $elem (@elementary) {\n    my @children=$contracted->successors($elem);\n    my $child=$children[0];\n    if ($contracted->in_degree($elem) == 1) {\n      my @parents=$contracted->predecessors($elem);\n      my $parent=$parents[0];\n      $contracted->add_edge($parent,$child);\n    }\n    $contracted->delete_vertex($elem);\n    my @blch=@{$blocks{$child}};\n    my @blem=@{$blocks{$elem}};\n    $blocks{$child}=[@blem,@blch];\n    delete $blocks{$elem};\n  }\n  my $contr=Bio::PhyloNetwork->new(-graph => $contracted);\n  return $contr,\\%blocks;\n}\n\n=head2 optimal_alignment\n\n Title   : optimal_alignment\n Usage   : my ($weight,$alignment,$wgts)=$net->optimal_alignment($net2)\n Function: returns the total weight of an optimal alignment,\n           the alignment itself, and partial weights\n           between the networks $net1 and $net2 on the same set of leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,reference to hash,reference to hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment {\n  my ($net1,$net2,%params)=@_;\n\n  my ($net1cont,$blocks1)=contract_elementary($net1);\n  my ($net2cont,$blocks2)=contract_elementary($net2);\n  my ($wc,$alignc,$weightc)=\n    optimal_alignment_noelementary($net1cont,$net2cont,%params);\n  my %alignment=();\n  my $totalweigth=0;\n  my %weigths=();\n  foreach my $u1 (keys %$alignc) {\n    my $u2=$alignc->{$u1};\n    my @block1=@{$blocks1->{$u1}};\n    my @block2=@{$blocks2->{$u2}};\n    while (@block1 && @block2) {\n      my $u1dc=pop @block1;\n      my $u2dc=pop @block2;\n      $alignment{$u1dc}=$u2dc;\n      $weigths{$u1dc}=$weightc->{$u1};\n      $totalweigth+=$weigths{$u1dc};\n    }\n  }\n  return $totalweigth,\\%alignment,\\%weigths;\n}\n\nsub optimal_alignment_noelementary {\n  my ($net1,$net2,%params)=@_;\n\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot align phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  my $distance;\n  if ((defined $params{-metric})and ($params{-metric} eq 'Hamming')) {\n    $distance='Hamming';\n  } else {\n    $distance='Manhattan';\n  }\n  my $numleaves=$net1->{numleaves};\n  my @nodes1=$net1->internal_nodes();\n  my @nodes2=$net2->internal_nodes();\n  my $numnodes1=@nodes1;\n  my $numnodes2=@nodes2;\n  my @matrix=();\n  for (my $i=0;$i<$numnodes1;$i++) {\n    my @row=();\n    for (my $j=0;$j<$numnodes2;$j++) {\n      push @row,weight($net1,$nodes1[$i],$net2,$nodes2[$j],$distance);\n    }\n    push @matrix,\\@row;\n  }\n  my @alignment=();\n  assign(\\@matrix,\\@alignment);\n  my %alignmenthash;\n  my %weighthash;\n  my $totalw=0;\n  foreach my $leaf (@{$net1->{leaves}}) {\n    $alignmenthash{$leaf}=$leaf;\n    $weighthash{$leaf}=0;\n  }\n  for (my $i=0;$i<$numnodes1;$i++) {\n    if (defined $nodes2[$alignment[$i]]) {\n      $alignmenthash{$nodes1[$i]}=$nodes2[$alignment[$i]];\n      $weighthash{$nodes1[$i]}=$matrix[$i][$alignment[$i]];\n      $totalw += $matrix[$i][$alignment[$i]];\n    }\n  }\n  return $totalw,\\%alignmenthash,\\%weighthash;\n }\n\n=head2 optimal_alignment_generalized\n\n Title   : optimal_alignment_generalized\n Usage   : my ($weight,%alignment)=$net->optimal_alignment_generalized($net2)\n Function: returns the wieght of an optimal alignment, and the alignment itself,\n           between the topological restriction of the networks $net1 and $net2\n           on the set of common leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.","label":"optimal_alignment_generalized($net1,$net2,%params)"},"line":1466,"kind":12,"range":{"start":{"line":1466,"character":0},"end":{"line":1470,"character":9999}}},{"name":"weight","containerName":"main::","children":[{"definition":"my","line":1473,"containerName":"weight","localvar":"my","kind":13,"name":"$net1"},{"line":1473,"containerName":"weight","kind":13,"name":"$v1"},{"containerName":"weight","kind":13,"name":"$net2","line":1473},{"line":1473,"name":"$v2","containerName":"weight","kind":13},{"line":1473,"containerName":"weight","kind":13,"name":"$distance"},{"line":1474,"name":"$w","containerName":"weight","localvar":"my","kind":13,"definition":"my"},{"line":1475,"name":"$distance","kind":13,"containerName":"weight"},{"line":1476,"kind":13,"containerName":"weight","name":"$distance"},{"name":"$distance","kind":13,"containerName":"weight","line":1478},{"name":"$w","containerName":"weight","kind":13,"line":1479},{"line":1479,"name":"$net1","containerName":"weight","kind":13},{"kind":13,"containerName":"weight","name":"$v1","line":1479},{"line":1479,"containerName":"weight","kind":12,"name":"hamming"},{"line":1479,"containerName":"weight","kind":13,"name":"$net2"},{"name":"$v2","containerName":"weight","kind":13,"line":1479},{"line":1481,"containerName":"weight","kind":13,"name":"$w"},{"line":1481,"kind":13,"containerName":"weight","name":"$net1"},{"line":1481,"name":"$v1","kind":13,"containerName":"weight"},{"name":"manhattan","kind":12,"containerName":"weight","line":1481},{"line":1481,"kind":13,"containerName":"weight","name":"$net2"},{"containerName":"weight","kind":13,"name":"$v2","line":1481},{"name":"$net1","kind":13,"containerName":"weight","line":1483},{"line":1483,"kind":12,"containerName":"weight","name":"is_tree_node"},{"line":1483,"kind":13,"containerName":"weight","name":"$v1"},{"containerName":"weight","kind":13,"name":"$net2","line":1483},{"line":1483,"containerName":"weight","kind":12,"name":"is_hybrid_node"},{"name":"$v2","kind":13,"containerName":"weight","line":1483},{"line":1484,"containerName":"weight","kind":13,"name":"$net2"},{"line":1484,"containerName":"weight","kind":12,"name":"is_tree_node"},{"line":1484,"kind":13,"containerName":"weight","name":"$v2"},{"containerName":"weight","kind":13,"name":"$net1","line":1484},{"line":1484,"kind":12,"containerName":"weight","name":"is_hybrid_node"},{"name":"$v1","kind":13,"containerName":"weight","line":1484},{"name":"$w","kind":13,"containerName":"weight","line":1487},{"line":1487,"name":"$net1","kind":13,"containerName":"weight"},{"line":1489,"name":"$w","kind":13,"containerName":"weight"}],"detail":"($net1,$v1,$net2,$v2,$distance)","definition":"sub","range":{"start":{"line":1472,"character":0},"end":{"line":1490,"character":9999}},"kind":12,"line":1472,"signature":{"label":"weight($net1,$v1,$net2,$v2,$distance)","documentation":"","parameters":[{"label":"$net1"},{"label":"$v1"},{"label":"$net2"},{"label":"$v2"},{"label":"$distance"}]}},{"line":1479,"kind":12,"name":"mudata"},{"line":1479,"kind":12,"name":"mudata"},{"line":1481,"name":"mudata","kind":12},{"name":"mudata","kind":12,"line":1481},{"line":1487,"kind":12,"name":"numleaves"},{"containerName":"main::","name":"topological_restriction","children":[{"definition":"my","name":"$net1","localvar":"my","containerName":"topological_restriction","kind":13,"line":1505},{"name":"$net2","kind":13,"containerName":"topological_restriction","line":1505},{"definition":"my","localvar":"my","kind":13,"containerName":"topological_restriction","name":"@leaves1","line":1507},{"line":1507,"name":"$net1","kind":13,"containerName":"topological_restriction"},{"name":"leaves","containerName":"topological_restriction","kind":12,"line":1507},{"definition":"my","localvar":"my","kind":13,"containerName":"topological_restriction","name":"@leaves2","line":1508},{"line":1508,"containerName":"topological_restriction","kind":13,"name":"$net2"},{"kind":12,"containerName":"topological_restriction","name":"leaves","line":1508},{"name":"$numleaves1","kind":13,"localvar":"my","containerName":"topological_restriction","line":1509,"definition":"my"},{"line":1509,"kind":13,"containerName":"topological_restriction","name":"@leaves1"},{"definition":"my","localvar":"my","containerName":"topological_restriction","kind":13,"name":"$numleaves2","line":1510},{"line":1510,"kind":13,"containerName":"topological_restriction","name":"@leaves2"},{"definition":"my","containerName":"topological_restriction","localvar":"my","kind":13,"name":"%position1","line":1511},{"line":1512,"name":"$i","localvar":"my","containerName":"topological_restriction","kind":13,"definition":"my"},{"name":"$i","containerName":"topological_restriction","kind":13,"line":1512},{"kind":13,"containerName":"topological_restriction","name":"$numleaves1","line":1512},{"kind":13,"containerName":"topological_restriction","name":"$i","line":1512},{"line":1513,"name":"$position1","kind":13,"containerName":"topological_restriction"},{"line":1513,"kind":13,"containerName":"topological_restriction","name":"$leaves1"},{"name":"$i","containerName":"topological_restriction","kind":13,"line":1513},{"line":1513,"name":"$i","kind":13,"containerName":"topological_restriction"},{"definition":"my","name":"%position2","kind":13,"localvar":"my","containerName":"topological_restriction","line":1515},{"definition":"my","localvar":"my","kind":13,"containerName":"topological_restriction","name":"@commonleaves","line":1516},{"definition":"my","line":1517,"kind":13,"localvar":"my","containerName":"topological_restriction","name":"$j"},{"name":"$j","kind":13,"containerName":"topological_restriction","line":1517},{"containerName":"topological_restriction","kind":13,"name":"$numleaves2","line":1517},{"kind":13,"containerName":"topological_restriction","name":"$j","line":1517},{"name":"$position1","kind":13,"containerName":"topological_restriction","line":1518},{"line":1518,"name":"$leaves2","kind":13,"containerName":"topological_restriction"},{"line":1518,"name":"$j","containerName":"topological_restriction","kind":13},{"kind":13,"containerName":"topological_restriction","name":"@commonleaves","line":1519},{"name":"$leaves2","containerName":"topological_restriction","kind":13,"line":1519},{"name":"$j","kind":13,"containerName":"topological_restriction","line":1519},{"name":"$position2","kind":13,"containerName":"topological_restriction","line":1520},{"containerName":"topological_restriction","kind":13,"name":"$leaves2","line":1520},{"containerName":"topological_restriction","kind":13,"name":"$j","line":1520},{"line":1520,"containerName":"topological_restriction","kind":13,"name":"$j"},{"name":"$graphred1","localvar":"my","kind":13,"containerName":"topological_restriction","line":1523,"definition":"my"},{"line":1523,"kind":13,"containerName":"topological_restriction","name":"$net1"},{"kind":12,"containerName":"topological_restriction","name":"copy","line":1523},{"line":1524,"name":"$graphred2","containerName":"topological_restriction","localvar":"my","kind":13,"definition":"my"},{"line":1524,"kind":13,"containerName":"topological_restriction","name":"$net2"},{"containerName":"topological_restriction","kind":12,"name":"copy","line":1524},{"definition":"my","name":"$u","localvar":"my","kind":13,"containerName":"topological_restriction","line":1526},{"line":1526,"containerName":"topological_restriction","kind":13,"name":"$graphred1"},{"line":1526,"name":"vertices","kind":12,"containerName":"topological_restriction"},{"definition":"my","line":1527,"name":"$mu","localvar":"my","kind":13,"containerName":"topological_restriction"},{"line":1527,"name":"$net1","kind":13,"containerName":"topological_restriction"},{"name":"mudata_node","kind":12,"containerName":"topological_restriction","line":1527},{"line":1527,"kind":13,"containerName":"topological_restriction","name":"$u"},{"line":1528,"name":"$leaf","containerName":"topological_restriction","localvar":"my","kind":13,"definition":"my"},{"name":"@commonleaves","kind":13,"containerName":"topological_restriction","line":1528},{"line":1529,"kind":13,"containerName":"topological_restriction","name":"$mu"},{"name":"$position1","containerName":"topological_restriction","kind":13,"line":1529},{"name":"$leaf","kind":13,"containerName":"topological_restriction","line":1529},{"line":1533,"name":"$graphred1","containerName":"topological_restriction","kind":13},{"line":1533,"kind":12,"containerName":"topological_restriction","name":"delete_vertex"},{"line":1533,"name":"$u","containerName":"topological_restriction","kind":13},{"line":1536,"name":"$u","containerName":"topological_restriction","localvar":"my","kind":13,"definition":"my"},{"name":"$graphred2","kind":13,"containerName":"topological_restriction","line":1536},{"name":"vertices","kind":12,"containerName":"topological_restriction","line":1536},{"line":1537,"name":"$mu","localvar":"my","kind":13,"containerName":"topological_restriction","definition":"my"},{"containerName":"topological_restriction","kind":13,"name":"$net2","line":1537},{"line":1537,"kind":12,"containerName":"topological_restriction","name":"mudata_node"},{"name":"$u","containerName":"topological_restriction","kind":13,"line":1537},{"line":1538,"localvar":"my","kind":13,"containerName":"topological_restriction","name":"$leaf","definition":"my"},{"line":1538,"containerName":"topological_restriction","kind":13,"name":"@commonleaves"},{"line":1539,"containerName":"topological_restriction","kind":13,"name":"$mu"},{"name":"$position2","kind":13,"containerName":"topological_restriction","line":1539},{"kind":13,"containerName":"topological_restriction","name":"$leaf","line":1539},{"kind":13,"containerName":"topological_restriction","name":"$graphred2","line":1543},{"name":"delete_vertex","kind":12,"containerName":"topological_restriction","line":1543},{"line":1543,"containerName":"topological_restriction","kind":13,"name":"$u"},{"definition":"my","kind":13,"localvar":"my","containerName":"topological_restriction","name":"$netr1","line":1545},{"line":1545,"kind":12,"containerName":"topological_restriction","name":"new"},{"line":1545,"name":"$graphred1","containerName":"topological_restriction","kind":13},{"line":1546,"name":"$netr2","kind":13,"localvar":"my","containerName":"topological_restriction","definition":"my"},{"containerName":"topological_restriction","kind":12,"name":"new","line":1546},{"line":1546,"name":"$graphred2","kind":13,"containerName":"topological_restriction"},{"name":"$netr1","kind":13,"containerName":"topological_restriction","line":1547},{"line":1547,"kind":13,"containerName":"topological_restriction","name":"$netr2"}],"detail":"($net1,$net2)","definition":"sub","range":{"start":{"character":0,"line":1504},"end":{"character":9999,"line":1548}},"kind":12,"line":1504,"signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none\n\n\nsub contract_elementary {\n  my ($self)=@_;\n\n  my $contracted=$self->graph->copy();\n  my @nodes=$self->nodes();\n  my $mus=$self->{mudata};\n  my $hs=$self->{h};\n  my %blocks;\n  foreach my $u (@nodes) {\n    $blocks{$u}=[$u];\n  }\n  my @elementary=grep { $contracted->out_degree($_) == 1} $self->tree_nodes();\n  @elementary=sort {$mus->{$b} <=> $mus->{$a} ||\n\t\t\t $hs->{$b} <=> $hs->{$a}} @elementary;\n  foreach my $elem (@elementary) {\n    my @children=$contracted->successors($elem);\n    my $child=$children[0];\n    if ($contracted->in_degree($elem) == 1) {\n      my @parents=$contracted->predecessors($elem);\n      my $parent=$parents[0];\n      $contracted->add_edge($parent,$child);\n    }\n    $contracted->delete_vertex($elem);\n    my @blch=@{$blocks{$child}};\n    my @blem=@{$blocks{$elem}};\n    $blocks{$child}=[@blem,@blch];\n    delete $blocks{$elem};\n  }\n  my $contr=Bio::PhyloNetwork->new(-graph => $contracted);\n  return $contr,\\%blocks;\n}\n\n=head2 optimal_alignment\n\n Title   : optimal_alignment\n Usage   : my ($weight,$alignment,$wgts)=$net->optimal_alignment($net2)\n Function: returns the total weight of an optimal alignment,\n           the alignment itself, and partial weights\n           between the networks $net1 and $net2 on the same set of leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,reference to hash,reference to hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment {\n  my ($net1,$net2,%params)=@_;\n\n  my ($net1cont,$blocks1)=contract_elementary($net1);\n  my ($net2cont,$blocks2)=contract_elementary($net2);\n  my ($wc,$alignc,$weightc)=\n    optimal_alignment_noelementary($net1cont,$net2cont,%params);\n  my %alignment=();\n  my $totalweigth=0;\n  my %weigths=();\n  foreach my $u1 (keys %$alignc) {\n    my $u2=$alignc->{$u1};\n    my @block1=@{$blocks1->{$u1}};\n    my @block2=@{$blocks2->{$u2}};\n    while (@block1 && @block2) {\n      my $u1dc=pop @block1;\n      my $u2dc=pop @block2;\n      $alignment{$u1dc}=$u2dc;\n      $weigths{$u1dc}=$weightc->{$u1};\n      $totalweigth+=$weigths{$u1dc};\n    }\n  }\n  return $totalweigth,\\%alignment,\\%weigths;\n}\n\nsub optimal_alignment_noelementary {\n  my ($net1,$net2,%params)=@_;\n\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot align phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  my $distance;\n  if ((defined $params{-metric})and ($params{-metric} eq 'Hamming')) {\n    $distance='Hamming';\n  } else {\n    $distance='Manhattan';\n  }\n  my $numleaves=$net1->{numleaves};\n  my @nodes1=$net1->internal_nodes();\n  my @nodes2=$net2->internal_nodes();\n  my $numnodes1=@nodes1;\n  my $numnodes2=@nodes2;\n  my @matrix=();\n  for (my $i=0;$i<$numnodes1;$i++) {\n    my @row=();\n    for (my $j=0;$j<$numnodes2;$j++) {\n      push @row,weight($net1,$nodes1[$i],$net2,$nodes2[$j],$distance);\n    }\n    push @matrix,\\@row;\n  }\n  my @alignment=();\n  assign(\\@matrix,\\@alignment);\n  my %alignmenthash;\n  my %weighthash;\n  my $totalw=0;\n  foreach my $leaf (@{$net1->{leaves}}) {\n    $alignmenthash{$leaf}=$leaf;\n    $weighthash{$leaf}=0;\n  }\n  for (my $i=0;$i<$numnodes1;$i++) {\n    if (defined $nodes2[$alignment[$i]]) {\n      $alignmenthash{$nodes1[$i]}=$nodes2[$alignment[$i]];\n      $weighthash{$nodes1[$i]}=$matrix[$i][$alignment[$i]];\n      $totalw += $matrix[$i][$alignment[$i]];\n    }\n  }\n  return $totalw,\\%alignmenthash,\\%weighthash;\n }\n\n=head2 optimal_alignment_generalized\n\n Title   : optimal_alignment_generalized\n Usage   : my ($weight,%alignment)=$net->optimal_alignment_generalized($net2)\n Function: returns the wieght of an optimal alignment, and the alignment itself,\n           between the topological restriction of the networks $net1 and $net2\n           on the set of common leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment_generalized {\n  my ($net1,$net2,%params)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->optimal_alignment($netr2,%params);\n}\n\nsub weight {\n  my ($net1,$v1,$net2,$v2,$distance)=@_;\n  my $w;\n  if (! defined $distance) {\n    $distance='Manhattan';\n  }\n  if ($distance eq 'Hamming') {\n    $w=$net1->{mudata}->{$v1}->hamming($net2->{mudata}->{$v2});\n  } else {\n    $w=$net1->{mudata}->{$v1}->manhattan($net2->{mudata}->{$v2});\n  }\n  if (($net1->is_tree_node($v1) && $net2->is_hybrid_node($v2)) ||\n      ($net2->is_tree_node($v2) && $net1->is_hybrid_node($v1))\n     )\n    {\n      $w +=1/(2*$net1->{numleaves});\n    }\n  return $w;\n}\n\n\n=head2 topological_restriction\n\n Title   : topological_restriction\n Usage   : my ($netr1,$netr2)=$net1->topological_restriction($net2)\n Function: returns the topological restriction of $net1 and $net2 on its\n           common set of leaves\n Returns : Bio::PhyloNetwork, Bio::PhyloNetwork\n Args    : Bio::PhyloNetwork","parameters":[{"label":"$net1"},{"label":"$net2"}],"label":"topological_restriction($net1,$net2)"}},{"name":"graph","kind":12,"line":1523},{"name":"graph","kind":12,"line":1524},{"name":"OUTER1","kind":12,"line":1525},{"name":"OUTER1","kind":12,"line":1530},{"kind":12,"name":"OUTER2","line":1535},{"name":"OUTER2","kind":12,"line":1540},{"kind":12,"containerName":"PhyloNetwork","name":"Bio","line":1545},{"name":"Bio","kind":12,"containerName":"PhyloNetwork","line":1546},{"detail":"($self)","definition":"sub","containerName":"main::","name":"eNewick","children":[{"definition":"my","containerName":"eNewick","localvar":"my","kind":13,"name":"$self","line":1564},{"definition":"my","name":"$str","localvar":"my","kind":13,"containerName":"eNewick","line":1565},{"definition":"my","kind":13,"localvar":"my","containerName":"eNewick","name":"$seen","line":1566},{"line":1567,"containerName":"eNewick","localvar":"my","kind":13,"name":"$root","definition":"my"},{"line":1567,"name":"$self","kind":13,"containerName":"eNewick"},{"line":1567,"name":"roots","containerName":"eNewick","kind":12},{"name":"$str","kind":13,"containerName":"eNewick","line":1568},{"containerName":"eNewick","kind":13,"name":"$str","line":1568},{"line":1568,"name":"$self","containerName":"eNewick","kind":13},{"kind":12,"containerName":"eNewick","name":"eNewick_aux","line":1568},{"line":1568,"name":"$root","kind":13,"containerName":"eNewick"},{"line":1568,"name":"$seen","containerName":"eNewick","kind":13},{"line":1570,"kind":13,"containerName":"eNewick","name":"$str"}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none\n\n\nsub contract_elementary {\n  my ($self)=@_;\n\n  my $contracted=$self->graph->copy();\n  my @nodes=$self->nodes();\n  my $mus=$self->{mudata};\n  my $hs=$self->{h};\n  my %blocks;\n  foreach my $u (@nodes) {\n    $blocks{$u}=[$u];\n  }\n  my @elementary=grep { $contracted->out_degree($_) == 1} $self->tree_nodes();\n  @elementary=sort {$mus->{$b} <=> $mus->{$a} ||\n\t\t\t $hs->{$b} <=> $hs->{$a}} @elementary;\n  foreach my $elem (@elementary) {\n    my @children=$contracted->successors($elem);\n    my $child=$children[0];\n    if ($contracted->in_degree($elem) == 1) {\n      my @parents=$contracted->predecessors($elem);\n      my $parent=$parents[0];\n      $contracted->add_edge($parent,$child);\n    }\n    $contracted->delete_vertex($elem);\n    my @blch=@{$blocks{$child}};\n    my @blem=@{$blocks{$elem}};\n    $blocks{$child}=[@blem,@blch];\n    delete $blocks{$elem};\n  }\n  my $contr=Bio::PhyloNetwork->new(-graph => $contracted);\n  return $contr,\\%blocks;\n}\n\n=head2 optimal_alignment\n\n Title   : optimal_alignment\n Usage   : my ($weight,$alignment,$wgts)=$net->optimal_alignment($net2)\n Function: returns the total weight of an optimal alignment,\n           the alignment itself, and partial weights\n           between the networks $net1 and $net2 on the same set of leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,reference to hash,reference to hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment {\n  my ($net1,$net2,%params)=@_;\n\n  my ($net1cont,$blocks1)=contract_elementary($net1);\n  my ($net2cont,$blocks2)=contract_elementary($net2);\n  my ($wc,$alignc,$weightc)=\n    optimal_alignment_noelementary($net1cont,$net2cont,%params);\n  my %alignment=();\n  my $totalweigth=0;\n  my %weigths=();\n  foreach my $u1 (keys %$alignc) {\n    my $u2=$alignc->{$u1};\n    my @block1=@{$blocks1->{$u1}};\n    my @block2=@{$blocks2->{$u2}};\n    while (@block1 && @block2) {\n      my $u1dc=pop @block1;\n      my $u2dc=pop @block2;\n      $alignment{$u1dc}=$u2dc;\n      $weigths{$u1dc}=$weightc->{$u1};\n      $totalweigth+=$weigths{$u1dc};\n    }\n  }\n  return $totalweigth,\\%alignment,\\%weigths;\n}\n\nsub optimal_alignment_noelementary {\n  my ($net1,$net2,%params)=@_;\n\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot align phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  my $distance;\n  if ((defined $params{-metric})and ($params{-metric} eq 'Hamming')) {\n    $distance='Hamming';\n  } else {\n    $distance='Manhattan';\n  }\n  my $numleaves=$net1->{numleaves};\n  my @nodes1=$net1->internal_nodes();\n  my @nodes2=$net2->internal_nodes();\n  my $numnodes1=@nodes1;\n  my $numnodes2=@nodes2;\n  my @matrix=();\n  for (my $i=0;$i<$numnodes1;$i++) {\n    my @row=();\n    for (my $j=0;$j<$numnodes2;$j++) {\n      push @row,weight($net1,$nodes1[$i],$net2,$nodes2[$j],$distance);\n    }\n    push @matrix,\\@row;\n  }\n  my @alignment=();\n  assign(\\@matrix,\\@alignment);\n  my %alignmenthash;\n  my %weighthash;\n  my $totalw=0;\n  foreach my $leaf (@{$net1->{leaves}}) {\n    $alignmenthash{$leaf}=$leaf;\n    $weighthash{$leaf}=0;\n  }\n  for (my $i=0;$i<$numnodes1;$i++) {\n    if (defined $nodes2[$alignment[$i]]) {\n      $alignmenthash{$nodes1[$i]}=$nodes2[$alignment[$i]];\n      $weighthash{$nodes1[$i]}=$matrix[$i][$alignment[$i]];\n      $totalw += $matrix[$i][$alignment[$i]];\n    }\n  }\n  return $totalw,\\%alignmenthash,\\%weighthash;\n }\n\n=head2 optimal_alignment_generalized\n\n Title   : optimal_alignment_generalized\n Usage   : my ($weight,%alignment)=$net->optimal_alignment_generalized($net2)\n Function: returns the wieght of an optimal alignment, and the alignment itself,\n           between the topological restriction of the networks $net1 and $net2\n           on the set of common leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment_generalized {\n  my ($net1,$net2,%params)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->optimal_alignment($netr2,%params);\n}\n\nsub weight {\n  my ($net1,$v1,$net2,$v2,$distance)=@_;\n  my $w;\n  if (! defined $distance) {\n    $distance='Manhattan';\n  }\n  if ($distance eq 'Hamming') {\n    $w=$net1->{mudata}->{$v1}->hamming($net2->{mudata}->{$v2});\n  } else {\n    $w=$net1->{mudata}->{$v1}->manhattan($net2->{mudata}->{$v2});\n  }\n  if (($net1->is_tree_node($v1) && $net2->is_hybrid_node($v2)) ||\n      ($net2->is_tree_node($v2) && $net1->is_hybrid_node($v1))\n     )\n    {\n      $w +=1/(2*$net1->{numleaves});\n    }\n  return $w;\n}\n\n\n=head2 topological_restriction\n\n Title   : topological_restriction\n Usage   : my ($netr1,$netr2)=$net1->topological_restriction($net2)\n Function: returns the topological restriction of $net1 and $net2 on its\n           common set of leaves\n Returns : Bio::PhyloNetwork, Bio::PhyloNetwork\n Args    : Bio::PhyloNetwork\n\n\nsub topological_restriction {\n  my ($net1,$net2)=@_;\n\n  my @leaves1=$net1->leaves();\n  my @leaves2=$net2->leaves();\n  my $numleaves1=scalar @leaves1;\n  my $numleaves2=scalar @leaves2;\n  my %position1;\n  for (my $i=0; $i<$numleaves1; $i++) {\n    $position1{$leaves1[$i]}=$i;\n  }\n  my %position2;\n  my @commonleaves=();\n  for (my $j=0; $j<$numleaves2; $j++) {\n    if (defined $position1{$leaves2[$j]}) {\n      push @commonleaves,$leaves2[$j];\n      $position2{$leaves2[$j]}=$j;\n    }\n  }\n  my $graphred1=$net1->{graph}->copy();\n  my $graphred2=$net2->{graph}->copy();\n OUTER1:\n  foreach my $u ($graphred1->vertices()) {\n    my $mu=$net1->mudata_node($u);\n    foreach my $leaf (@commonleaves) {\n      if ($mu->[$position1{$leaf}]>0) {\n\tnext OUTER1;\n      }\n    }\n    $graphred1->delete_vertex($u);\n  }\n OUTER2:\n  foreach my $u ($graphred2->vertices()) {\n    my $mu=$net2->mudata_node($u);\n    foreach my $leaf (@commonleaves) {\n      if ($mu->[$position2{$leaf}]>0) {\n\tnext OUTER2;\n      }\n    }\n    $graphred2->delete_vertex($u);\n  }\n  my $netr1=Bio::PhyloNetwork->new(-graph => $graphred1);\n  my $netr2=Bio::PhyloNetwork->new(-graph => $graphred2);\n  return ($netr1,$netr2);\n}\n\n# Functions for eNewick representation\n\n=head2 eNewick\n\n Title   : eNewick\n Usage   : my $str=$net->eNewick()\n Function: returns the eNewick representation of $net without labeling\n           internal tree nodes\n Returns : string\n Args    : none","label":"eNewick($self)"},"kind":12,"range":{"end":{"character":9999,"line":1571},"start":{"line":1563,"character":0}},"line":1563},{"detail":"($self,$node,$seen,$parent)","definition":"sub","containerName":"main::","name":"eNewick_aux","children":[{"definition":"my","line":1574,"containerName":"eNewick_aux","localvar":"my","kind":13,"name":"$self"},{"name":"$node","kind":13,"containerName":"eNewick_aux","line":1574},{"name":"$seen","kind":13,"containerName":"eNewick_aux","line":1574},{"line":1574,"containerName":"eNewick_aux","kind":13,"name":"$parent"},{"definition":"my","name":"$str","localvar":"my","kind":13,"containerName":"eNewick_aux","line":1575},{"line":1576,"name":"$self","containerName":"eNewick_aux","kind":13},{"line":1576,"name":"is_leaf","containerName":"eNewick_aux","kind":12},{"line":1576,"name":"$node","kind":13,"containerName":"eNewick_aux"},{"line":1577,"kind":13,"containerName":"eNewick_aux","name":"$seen"},{"name":"$node","kind":13,"containerName":"eNewick_aux","line":1577},{"line":1579,"containerName":"eNewick_aux","kind":13,"name":"$str"},{"name":"$self","kind":13,"containerName":"eNewick_aux","line":1579},{"name":"$parent","containerName":"eNewick_aux","kind":13,"line":1579},{"line":1579,"kind":13,"containerName":"eNewick_aux","name":"$node"},{"name":"$seen","containerName":"eNewick_aux","kind":13,"line":1582},{"line":1582,"name":"$node","containerName":"eNewick_aux","kind":13},{"definition":"my","line":1583,"containerName":"eNewick_aux","localvar":"my","kind":13,"name":"@sons"},{"kind":13,"containerName":"eNewick_aux","name":"$self","line":1583},{"containerName":"eNewick_aux","kind":12,"name":"successors","line":1583},{"line":1583,"kind":13,"containerName":"eNewick_aux","name":"$node"},{"containerName":"eNewick_aux","kind":13,"name":"$str","line":1584},{"definition":"my","line":1585,"kind":13,"localvar":"my","containerName":"eNewick_aux","name":"$son"},{"kind":13,"containerName":"eNewick_aux","name":"@sons","line":1585},{"line":1586,"kind":13,"containerName":"eNewick_aux","name":"$str"},{"line":1586,"kind":13,"containerName":"eNewick_aux","name":"$str"},{"line":1586,"containerName":"eNewick_aux","kind":13,"name":"$self"},{"name":"eNewick_aux","containerName":"eNewick_aux","kind":12,"line":1586},{"line":1586,"name":"$son","kind":13,"containerName":"eNewick_aux"},{"line":1586,"name":"$seen","kind":13,"containerName":"eNewick_aux"},{"name":"$node","containerName":"eNewick_aux","kind":13,"line":1586},{"line":1588,"kind":13,"containerName":"eNewick_aux","name":"$str"},{"kind":13,"containerName":"eNewick_aux","name":"$str","line":1589},{"name":"$self","kind":13,"containerName":"eNewick_aux","line":1589},{"name":"$parent","containerName":"eNewick_aux","kind":13,"line":1589},{"name":"$node","kind":13,"containerName":"eNewick_aux","line":1589},{"line":1591,"name":"$str","kind":13,"containerName":"eNewick_aux"}],"signature":{"parameters":[{"label":"$self"},{"label":"$node"},{"label":"$seen"},{"label":"$parent"}],"documentation":"","label":"eNewick_aux($self,$node,$seen,$parent)"},"kind":12,"range":{"end":{"character":9999,"line":1592},"start":{"character":0,"line":1573}},"line":1573},{"kind":12,"name":"make_label","line":1579},{"name":"graph","kind":12,"line":1583},{"line":1589,"kind":12,"name":"make_label"},{"range":{"start":{"line":1594,"character":0},"end":{"character":9999,"line":1617}},"kind":12,"line":1594,"signature":{"parameters":[{"label":"$self"},{"label":"$parent"},{"label":"$node"}],"documentation":"","label":"make_label($self,$parent,$node)"},"containerName":"main::","name":"make_label","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"make_label","kind":13,"line":1595},{"name":"$parent","kind":13,"containerName":"make_label","line":1595},{"kind":13,"containerName":"make_label","name":"$node","line":1595},{"definition":"my","line":1596,"name":"$str","containerName":"make_label","localvar":"my","kind":13},{"name":"$self","containerName":"make_label","kind":13,"line":1597},{"containerName":"make_label","kind":12,"name":"is_hybrid_node","line":1597},{"line":1597,"name":"$node","kind":13,"containerName":"make_label"},{"name":"$lbl","localvar":"my","kind":13,"containerName":"make_label","line":1598,"definition":"my"},{"name":"$self","kind":13,"containerName":"make_label","line":1598},{"name":"$node","kind":13,"containerName":"make_label","line":1598},{"name":"$lbl","kind":13,"containerName":"make_label","line":1599},{"line":1600,"kind":13,"containerName":"make_label","name":"$lbl"},{"line":1602,"name":"$str","kind":13,"containerName":"make_label"},{"name":"$lbl","kind":13,"containerName":"make_label","line":1602},{"line":1603,"name":"$str","containerName":"make_label","kind":13},{"line":1604,"containerName":"make_label","kind":13,"name":"$parent"},{"line":1605,"containerName":"make_label","kind":13,"name":"$self"},{"line":1605,"kind":12,"containerName":"make_label","name":"graph"},{"name":"has_edge_attribute","kind":12,"containerName":"make_label","line":1605},{"containerName":"make_label","kind":13,"name":"$parent","line":1605},{"line":1605,"name":"$node","kind":13,"containerName":"make_label"},{"containerName":"make_label","kind":13,"name":"$str","line":1606},{"line":1606,"containerName":"make_label","kind":13,"name":"$self"},{"containerName":"make_label","kind":12,"name":"graph","line":1606},{"line":1606,"name":"get_edge_attribute","kind":12,"containerName":"make_label"},{"name":"$parent","kind":13,"containerName":"make_label","line":1606},{"name":"$node","kind":13,"containerName":"make_label","line":1606},{"name":"$str","containerName":"make_label","kind":13,"line":1608},{"name":"$node","kind":13,"containerName":"make_label","line":1608},{"line":1610,"name":"$str","containerName":"make_label","kind":13},{"name":"$self","kind":13,"containerName":"make_label","line":1610},{"line":1610,"name":"$node","kind":13,"containerName":"make_label"},{"line":1612,"name":"$parent","containerName":"make_label","kind":13},{"line":1613,"name":"$self","kind":13,"containerName":"make_label"},{"line":1613,"name":"graph","kind":12,"containerName":"make_label"},{"name":"has_edge_weight","containerName":"make_label","kind":12,"line":1613},{"name":"$parent","containerName":"make_label","kind":13,"line":1613},{"kind":13,"containerName":"make_label","name":"$node","line":1613},{"name":"$str","containerName":"make_label","kind":13,"line":1614},{"kind":13,"containerName":"make_label","name":"$self","line":1614},{"line":1614,"name":"graph","kind":12,"containerName":"make_label"},{"kind":12,"containerName":"make_label","name":"get_edge_weight","line":1614},{"line":1614,"containerName":"make_label","kind":13,"name":"$parent"},{"name":"$node","kind":13,"containerName":"make_label","line":1614},{"name":"$str","kind":13,"containerName":"make_label","line":1616}],"detail":"($self,$parent,$node)","definition":"sub"},{"line":1598,"name":"labels","kind":12},{"kind":12,"name":"labels","line":1610},{"children":[{"line":1631,"name":"$self","containerName":"eNewick_full","localvar":"my","kind":13,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"eNewick_full","name":"$str","line":1632},{"line":1633,"name":"$seen","localvar":"my","kind":13,"containerName":"eNewick_full","definition":"my"},{"kind":13,"localvar":"my","containerName":"eNewick_full","name":"$root","line":1634,"definition":"my"},{"name":"$self","containerName":"eNewick_full","kind":13,"line":1634},{"line":1634,"name":"roots","containerName":"eNewick_full","kind":12},{"name":"$str","containerName":"eNewick_full","kind":13,"line":1635},{"line":1635,"name":"$str","containerName":"eNewick_full","kind":13},{"line":1635,"name":"$self","kind":13,"containerName":"eNewick_full"},{"name":"eNewick_full_aux","containerName":"eNewick_full","kind":12,"line":1635},{"name":"$root","containerName":"eNewick_full","kind":13,"line":1635},{"line":1635,"kind":13,"containerName":"eNewick_full","name":"$seen"},{"name":"$str","containerName":"eNewick_full","kind":13,"line":1637}],"containerName":"main::","name":"eNewick_full","definition":"sub","detail":"($self)","line":1630,"range":{"end":{"line":1638,"character":9999},"start":{"line":1630,"character":0}},"kind":12,"signature":{"label":"eNewick_full($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none\n\n\nsub contract_elementary {\n  my ($self)=@_;\n\n  my $contracted=$self->graph->copy();\n  my @nodes=$self->nodes();\n  my $mus=$self->{mudata};\n  my $hs=$self->{h};\n  my %blocks;\n  foreach my $u (@nodes) {\n    $blocks{$u}=[$u];\n  }\n  my @elementary=grep { $contracted->out_degree($_) == 1} $self->tree_nodes();\n  @elementary=sort {$mus->{$b} <=> $mus->{$a} ||\n\t\t\t $hs->{$b} <=> $hs->{$a}} @elementary;\n  foreach my $elem (@elementary) {\n    my @children=$contracted->successors($elem);\n    my $child=$children[0];\n    if ($contracted->in_degree($elem) == 1) {\n      my @parents=$contracted->predecessors($elem);\n      my $parent=$parents[0];\n      $contracted->add_edge($parent,$child);\n    }\n    $contracted->delete_vertex($elem);\n    my @blch=@{$blocks{$child}};\n    my @blem=@{$blocks{$elem}};\n    $blocks{$child}=[@blem,@blch];\n    delete $blocks{$elem};\n  }\n  my $contr=Bio::PhyloNetwork->new(-graph => $contracted);\n  return $contr,\\%blocks;\n}\n\n=head2 optimal_alignment\n\n Title   : optimal_alignment\n Usage   : my ($weight,$alignment,$wgts)=$net->optimal_alignment($net2)\n Function: returns the total weight of an optimal alignment,\n           the alignment itself, and partial weights\n           between the networks $net1 and $net2 on the same set of leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,reference to hash,reference to hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment {\n  my ($net1,$net2,%params)=@_;\n\n  my ($net1cont,$blocks1)=contract_elementary($net1);\n  my ($net2cont,$blocks2)=contract_elementary($net2);\n  my ($wc,$alignc,$weightc)=\n    optimal_alignment_noelementary($net1cont,$net2cont,%params);\n  my %alignment=();\n  my $totalweigth=0;\n  my %weigths=();\n  foreach my $u1 (keys %$alignc) {\n    my $u2=$alignc->{$u1};\n    my @block1=@{$blocks1->{$u1}};\n    my @block2=@{$blocks2->{$u2}};\n    while (@block1 && @block2) {\n      my $u1dc=pop @block1;\n      my $u2dc=pop @block2;\n      $alignment{$u1dc}=$u2dc;\n      $weigths{$u1dc}=$weightc->{$u1};\n      $totalweigth+=$weigths{$u1dc};\n    }\n  }\n  return $totalweigth,\\%alignment,\\%weigths;\n}\n\nsub optimal_alignment_noelementary {\n  my ($net1,$net2,%params)=@_;\n\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot align phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  my $distance;\n  if ((defined $params{-metric})and ($params{-metric} eq 'Hamming')) {\n    $distance='Hamming';\n  } else {\n    $distance='Manhattan';\n  }\n  my $numleaves=$net1->{numleaves};\n  my @nodes1=$net1->internal_nodes();\n  my @nodes2=$net2->internal_nodes();\n  my $numnodes1=@nodes1;\n  my $numnodes2=@nodes2;\n  my @matrix=();\n  for (my $i=0;$i<$numnodes1;$i++) {\n    my @row=();\n    for (my $j=0;$j<$numnodes2;$j++) {\n      push @row,weight($net1,$nodes1[$i],$net2,$nodes2[$j],$distance);\n    }\n    push @matrix,\\@row;\n  }\n  my @alignment=();\n  assign(\\@matrix,\\@alignment);\n  my %alignmenthash;\n  my %weighthash;\n  my $totalw=0;\n  foreach my $leaf (@{$net1->{leaves}}) {\n    $alignmenthash{$leaf}=$leaf;\n    $weighthash{$leaf}=0;\n  }\n  for (my $i=0;$i<$numnodes1;$i++) {\n    if (defined $nodes2[$alignment[$i]]) {\n      $alignmenthash{$nodes1[$i]}=$nodes2[$alignment[$i]];\n      $weighthash{$nodes1[$i]}=$matrix[$i][$alignment[$i]];\n      $totalw += $matrix[$i][$alignment[$i]];\n    }\n  }\n  return $totalw,\\%alignmenthash,\\%weighthash;\n }\n\n=head2 optimal_alignment_generalized\n\n Title   : optimal_alignment_generalized\n Usage   : my ($weight,%alignment)=$net->optimal_alignment_generalized($net2)\n Function: returns the wieght of an optimal alignment, and the alignment itself,\n           between the topological restriction of the networks $net1 and $net2\n           on the set of common leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment_generalized {\n  my ($net1,$net2,%params)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->optimal_alignment($netr2,%params);\n}\n\nsub weight {\n  my ($net1,$v1,$net2,$v2,$distance)=@_;\n  my $w;\n  if (! defined $distance) {\n    $distance='Manhattan';\n  }\n  if ($distance eq 'Hamming') {\n    $w=$net1->{mudata}->{$v1}->hamming($net2->{mudata}->{$v2});\n  } else {\n    $w=$net1->{mudata}->{$v1}->manhattan($net2->{mudata}->{$v2});\n  }\n  if (($net1->is_tree_node($v1) && $net2->is_hybrid_node($v2)) ||\n      ($net2->is_tree_node($v2) && $net1->is_hybrid_node($v1))\n     )\n    {\n      $w +=1/(2*$net1->{numleaves});\n    }\n  return $w;\n}\n\n\n=head2 topological_restriction\n\n Title   : topological_restriction\n Usage   : my ($netr1,$netr2)=$net1->topological_restriction($net2)\n Function: returns the topological restriction of $net1 and $net2 on its\n           common set of leaves\n Returns : Bio::PhyloNetwork, Bio::PhyloNetwork\n Args    : Bio::PhyloNetwork\n\n\nsub topological_restriction {\n  my ($net1,$net2)=@_;\n\n  my @leaves1=$net1->leaves();\n  my @leaves2=$net2->leaves();\n  my $numleaves1=scalar @leaves1;\n  my $numleaves2=scalar @leaves2;\n  my %position1;\n  for (my $i=0; $i<$numleaves1; $i++) {\n    $position1{$leaves1[$i]}=$i;\n  }\n  my %position2;\n  my @commonleaves=();\n  for (my $j=0; $j<$numleaves2; $j++) {\n    if (defined $position1{$leaves2[$j]}) {\n      push @commonleaves,$leaves2[$j];\n      $position2{$leaves2[$j]}=$j;\n    }\n  }\n  my $graphred1=$net1->{graph}->copy();\n  my $graphred2=$net2->{graph}->copy();\n OUTER1:\n  foreach my $u ($graphred1->vertices()) {\n    my $mu=$net1->mudata_node($u);\n    foreach my $leaf (@commonleaves) {\n      if ($mu->[$position1{$leaf}]>0) {\n\tnext OUTER1;\n      }\n    }\n    $graphred1->delete_vertex($u);\n  }\n OUTER2:\n  foreach my $u ($graphred2->vertices()) {\n    my $mu=$net2->mudata_node($u);\n    foreach my $leaf (@commonleaves) {\n      if ($mu->[$position2{$leaf}]>0) {\n\tnext OUTER2;\n      }\n    }\n    $graphred2->delete_vertex($u);\n  }\n  my $netr1=Bio::PhyloNetwork->new(-graph => $graphred1);\n  my $netr2=Bio::PhyloNetwork->new(-graph => $graphred2);\n  return ($netr1,$netr2);\n}\n\n# Functions for eNewick representation\n\n=head2 eNewick\n\n Title   : eNewick\n Usage   : my $str=$net->eNewick()\n Function: returns the eNewick representation of $net without labeling\n           internal tree nodes\n Returns : string\n Args    : none\n\n\nsub eNewick {\n  my ($self)=@_;\n  my $str=\"\";\n  my $seen={};\n  foreach my $root ($self->roots()) {\n    $str=$str.$self->eNewick_aux($root,$seen,undef).\"; \";\n  }\n  return $str;\n}\n\nsub eNewick_aux {\n  my ($self,$node,$seen,$parent)=@_;\n  my $str='';\n  if ($self->is_leaf($node) ||\n      (defined $seen->{$node}) )\n    {\n      $str=make_label($self,$parent,$node);\n    }\n  else {\n    $seen->{$node}=1;\n    my @sons=$self->{graph}->successors($node);\n    $str=\"(\";\n    foreach my $son (@sons) {\n      $str=$str.$self->eNewick_aux($son,$seen,$node).\",\";\n    }\n    chop($str);\n    $str.=\")\".make_label($self,$parent,$node);\n  }\n  return $str;\n}\n\nsub make_label {\n  my ($self,$parent,$node)=@_;\n  my $str='';\n  if ($self->is_hybrid_node($node)) {\n    my $lbl=$self->{labels}->{$node};\n    if ($lbl =~ /#/) {\n      $lbl='';\n    }\n    $str.=$lbl; #$self->{labels}->{$node};\n    $str.='#';\n    if ((defined $parent) &&\n\t($self->graph->has_edge_attribute($parent,$node,'type'))) {\n      $str.=$self->graph->get_edge_attribute($parent,$node,'type');\n    }\n    $str.=substr $node,1;\n  } else {\n    $str.=$self->{labels}->{$node};\n  }\n  if ((defined $parent) &&\n      ($self->graph->has_edge_weight($parent,$node))) {\n    $str.=\":\".$self->graph->get_edge_weight($parent,$node);\n  }\n  return $str;\n}\n\n=head2 eNewick_full\n\n Title   : eNewick_full\n Usage   : my $str=$net->eNewick_full()\n Function: returns the eNewick representation of $net labeling\n           internal tree nodes\n Returns : string\n Args    : none"}},{"range":{"end":{"character":9999,"line":1659},"start":{"character":0,"line":1640}},"kind":12,"line":1640,"signature":{"parameters":[{"label":"$self"},{"label":"$node"},{"label":"$seen"},{"label":"$parent"}],"documentation":"","label":"eNewick_full_aux($self,$node,$seen,$parent)"},"name":"eNewick_full_aux","containerName":"main::","children":[{"line":1641,"name":"$self","localvar":"my","kind":13,"containerName":"eNewick_full_aux","definition":"my"},{"line":1641,"name":"$node","kind":13,"containerName":"eNewick_full_aux"},{"name":"$seen","kind":13,"containerName":"eNewick_full_aux","line":1641},{"name":"$parent","kind":13,"containerName":"eNewick_full_aux","line":1641},{"line":1642,"containerName":"eNewick_full_aux","localvar":"my","kind":13,"name":"$str","definition":"my"},{"containerName":"eNewick_full_aux","kind":13,"name":"$self","line":1643},{"line":1643,"kind":12,"containerName":"eNewick_full_aux","name":"is_leaf"},{"line":1643,"name":"$node","containerName":"eNewick_full_aux","kind":13},{"line":1644,"kind":13,"containerName":"eNewick_full_aux","name":"$seen"},{"kind":13,"containerName":"eNewick_full_aux","name":"$node","line":1644},{"containerName":"eNewick_full_aux","kind":13,"name":"$str","line":1646},{"containerName":"eNewick_full_aux","kind":13,"name":"$self","line":1646},{"containerName":"eNewick_full_aux","kind":13,"name":"$parent","line":1646},{"name":"$node","containerName":"eNewick_full_aux","kind":13,"line":1646},{"line":1649,"name":"$seen","kind":13,"containerName":"eNewick_full_aux"},{"line":1649,"kind":13,"containerName":"eNewick_full_aux","name":"$node"},{"definition":"my","line":1650,"containerName":"eNewick_full_aux","localvar":"my","kind":13,"name":"@sons"},{"line":1650,"name":"$self","kind":13,"containerName":"eNewick_full_aux"},{"line":1650,"name":"successors","kind":12,"containerName":"eNewick_full_aux"},{"containerName":"eNewick_full_aux","kind":13,"name":"$node","line":1650},{"line":1651,"name":"$str","containerName":"eNewick_full_aux","kind":13},{"definition":"my","line":1652,"name":"$son","kind":13,"localvar":"my","containerName":"eNewick_full_aux"},{"line":1652,"kind":13,"containerName":"eNewick_full_aux","name":"@sons"},{"containerName":"eNewick_full_aux","kind":13,"name":"$str","line":1653},{"line":1653,"name":"$str","containerName":"eNewick_full_aux","kind":13},{"name":"$self","containerName":"eNewick_full_aux","kind":13,"line":1653},{"line":1653,"name":"eNewick_full_aux","containerName":"eNewick_full_aux","kind":12},{"name":"$son","containerName":"eNewick_full_aux","kind":13,"line":1653},{"line":1653,"name":"$seen","containerName":"eNewick_full_aux","kind":13},{"line":1653,"name":"$node","containerName":"eNewick_full_aux","kind":13},{"line":1655,"containerName":"eNewick_full_aux","kind":13,"name":"$str"},{"kind":13,"containerName":"eNewick_full_aux","name":"$str","line":1656},{"name":"$self","kind":13,"containerName":"eNewick_full_aux","line":1656},{"name":"$parent","containerName":"eNewick_full_aux","kind":13,"line":1656},{"line":1656,"name":"$node","kind":13,"containerName":"eNewick_full_aux"},{"containerName":"eNewick_full_aux","kind":13,"name":"$str","line":1658}],"detail":"($self,$node,$seen,$parent)","definition":"sub"},{"name":"make_label_full","kind":12,"line":1646},{"name":"graph","kind":12,"line":1650},{"line":1656,"kind":12,"name":"make_label_full"},{"signature":{"label":"make_label_full($self,$parent,$node)","parameters":[{"label":"$self"},{"label":"$parent"},{"label":"$node"}],"documentation":""},"kind":12,"range":{"end":{"line":1689,"character":9999},"start":{"line":1661,"character":0}},"line":1661,"detail":"($self,$parent,$node)","definition":"sub","containerName":"main::","name":"make_label_full","children":[{"line":1662,"localvar":"my","kind":13,"containerName":"make_label_full","name":"$self","definition":"my"},{"line":1662,"name":"$parent","containerName":"make_label_full","kind":13},{"kind":13,"containerName":"make_label_full","name":"$node","line":1662},{"line":1663,"localvar":"my","containerName":"make_label_full","kind":13,"name":"$str","definition":"my"},{"containerName":"make_label_full","kind":13,"name":"$self","line":1664},{"line":1664,"containerName":"make_label_full","kind":12,"name":"is_hybrid_node"},{"line":1664,"kind":13,"containerName":"make_label_full","name":"$node"},{"kind":13,"localvar":"my","containerName":"make_label_full","name":"$lbl","line":1665,"definition":"my"},{"line":1665,"name":"$self","containerName":"make_label_full","kind":13},{"line":1665,"name":"$node","kind":13,"containerName":"make_label_full"},{"line":1666,"name":"$lbl","kind":13,"containerName":"make_label_full"},{"line":1667,"name":"$lbl","kind":13,"containerName":"make_label_full"},{"line":1669,"kind":13,"containerName":"make_label_full","name":"$str"},{"line":1669,"kind":13,"containerName":"make_label_full","name":"$lbl"},{"kind":13,"containerName":"make_label_full","name":"$str","line":1670},{"name":"$parent","containerName":"make_label_full","kind":13,"line":1671},{"line":1672,"kind":13,"containerName":"make_label_full","name":"$self"},{"name":"graph","containerName":"make_label_full","kind":12,"line":1672},{"name":"has_edge_attribute","kind":12,"containerName":"make_label_full","line":1672},{"name":"$parent","containerName":"make_label_full","kind":13,"line":1672},{"containerName":"make_label_full","kind":13,"name":"$node","line":1672},{"kind":13,"containerName":"make_label_full","name":"$str","line":1673},{"line":1673,"containerName":"make_label_full","kind":13,"name":"$self"},{"name":"graph","kind":12,"containerName":"make_label_full","line":1673},{"name":"get_edge_attribute","containerName":"make_label_full","kind":12,"line":1673},{"kind":13,"containerName":"make_label_full","name":"$parent","line":1673},{"kind":13,"containerName":"make_label_full","name":"$node","line":1673},{"line":1675,"name":"$str","containerName":"make_label_full","kind":13},{"line":1675,"containerName":"make_label_full","kind":13,"name":"$node"},{"line":1677,"name":"$self","kind":13,"containerName":"make_label_full"},{"containerName":"make_label_full","kind":13,"name":"$node","line":1677},{"line":1677,"kind":13,"containerName":"make_label_full","name":"$self"},{"line":1677,"name":"$node","kind":13,"containerName":"make_label_full"},{"line":1678,"containerName":"make_label_full","kind":13,"name":"$str"},{"line":1678,"containerName":"make_label_full","kind":13,"name":"$self"},{"kind":13,"containerName":"make_label_full","name":"$node","line":1678},{"line":1681,"name":"$str","containerName":"make_label_full","kind":13},{"line":1681,"kind":13,"containerName":"make_label_full","name":"$node"},{"line":1684,"containerName":"make_label_full","kind":13,"name":"$parent"},{"line":1685,"kind":13,"containerName":"make_label_full","name":"$self"},{"line":1685,"containerName":"make_label_full","kind":12,"name":"graph"},{"line":1685,"kind":12,"containerName":"make_label_full","name":"has_edge_weight"},{"kind":13,"containerName":"make_label_full","name":"$parent","line":1685},{"line":1685,"name":"$node","kind":13,"containerName":"make_label_full"},{"name":"$str","containerName":"make_label_full","kind":13,"line":1686},{"line":1686,"kind":13,"containerName":"make_label_full","name":"$self"},{"name":"graph","kind":12,"containerName":"make_label_full","line":1686},{"line":1686,"name":"get_edge_weight","containerName":"make_label_full","kind":12},{"line":1686,"kind":13,"containerName":"make_label_full","name":"$parent"},{"line":1686,"name":"$node","containerName":"make_label_full","kind":13},{"name":"$str","containerName":"make_label_full","kind":13,"line":1688}]},{"line":1665,"name":"labels","kind":12},{"line":1677,"kind":12,"name":"labels"},{"name":"labels","kind":12,"line":1677},{"name":"labels","kind":12,"line":1678},{"line":1749,"kind":2,"containerName":"","name":"overload"},{"line":1749,"kind":12,"name":"display"},{"containerName":"main::","name":"display","children":[{"definition":"my","line":1762,"name":"$self","localvar":"my","kind":13,"containerName":"display"},{"definition":"my","line":1763,"name":"$str","kind":13,"localvar":"my","containerName":"display"},{"line":1764,"name":"$graph","kind":13,"localvar":"my","containerName":"display","definition":"my"},{"line":1764,"name":"$self","containerName":"display","kind":13},{"definition":"my","line":1765,"localvar":"my","containerName":"display","kind":13,"name":"@leaves"},{"line":1765,"name":"$self","containerName":"display","kind":13},{"line":1765,"name":"leaves","containerName":"display","kind":12},{"line":1766,"name":"@nodes","kind":13,"localvar":"my","containerName":"display","definition":"my"},{"line":1766,"kind":13,"containerName":"display","name":"$self"}],"detail":"($self)","definition":"sub","range":{"end":{"character":9999,"line":1766},"start":{"line":1761,"character":0}},"kind":12,"line":1761,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none\n\n\nsub contract_elementary {\n  my ($self)=@_;\n\n  my $contracted=$self->graph->copy();\n  my @nodes=$self->nodes();\n  my $mus=$self->{mudata};\n  my $hs=$self->{h};\n  my %blocks;\n  foreach my $u (@nodes) {\n    $blocks{$u}=[$u];\n  }\n  my @elementary=grep { $contracted->out_degree($_) == 1} $self->tree_nodes();\n  @elementary=sort {$mus->{$b} <=> $mus->{$a} ||\n\t\t\t $hs->{$b} <=> $hs->{$a}} @elementary;\n  foreach my $elem (@elementary) {\n    my @children=$contracted->successors($elem);\n    my $child=$children[0];\n    if ($contracted->in_degree($elem) == 1) {\n      my @parents=$contracted->predecessors($elem);\n      my $parent=$parents[0];\n      $contracted->add_edge($parent,$child);\n    }\n    $contracted->delete_vertex($elem);\n    my @blch=@{$blocks{$child}};\n    my @blem=@{$blocks{$elem}};\n    $blocks{$child}=[@blem,@blch];\n    delete $blocks{$elem};\n  }\n  my $contr=Bio::PhyloNetwork->new(-graph => $contracted);\n  return $contr,\\%blocks;\n}\n\n=head2 optimal_alignment\n\n Title   : optimal_alignment\n Usage   : my ($weight,$alignment,$wgts)=$net->optimal_alignment($net2)\n Function: returns the total weight of an optimal alignment,\n           the alignment itself, and partial weights\n           between the networks $net1 and $net2 on the same set of leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,reference to hash,reference to hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment {\n  my ($net1,$net2,%params)=@_;\n\n  my ($net1cont,$blocks1)=contract_elementary($net1);\n  my ($net2cont,$blocks2)=contract_elementary($net2);\n  my ($wc,$alignc,$weightc)=\n    optimal_alignment_noelementary($net1cont,$net2cont,%params);\n  my %alignment=();\n  my $totalweigth=0;\n  my %weigths=();\n  foreach my $u1 (keys %$alignc) {\n    my $u2=$alignc->{$u1};\n    my @block1=@{$blocks1->{$u1}};\n    my @block2=@{$blocks2->{$u2}};\n    while (@block1 && @block2) {\n      my $u1dc=pop @block1;\n      my $u2dc=pop @block2;\n      $alignment{$u1dc}=$u2dc;\n      $weigths{$u1dc}=$weightc->{$u1};\n      $totalweigth+=$weigths{$u1dc};\n    }\n  }\n  return $totalweigth,\\%alignment,\\%weigths;\n}\n\nsub optimal_alignment_noelementary {\n  my ($net1,$net2,%params)=@_;\n\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot align phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  my $distance;\n  if ((defined $params{-metric})and ($params{-metric} eq 'Hamming')) {\n    $distance='Hamming';\n  } else {\n    $distance='Manhattan';\n  }\n  my $numleaves=$net1->{numleaves};\n  my @nodes1=$net1->internal_nodes();\n  my @nodes2=$net2->internal_nodes();\n  my $numnodes1=@nodes1;\n  my $numnodes2=@nodes2;\n  my @matrix=();\n  for (my $i=0;$i<$numnodes1;$i++) {\n    my @row=();\n    for (my $j=0;$j<$numnodes2;$j++) {\n      push @row,weight($net1,$nodes1[$i],$net2,$nodes2[$j],$distance);\n    }\n    push @matrix,\\@row;\n  }\n  my @alignment=();\n  assign(\\@matrix,\\@alignment);\n  my %alignmenthash;\n  my %weighthash;\n  my $totalw=0;\n  foreach my $leaf (@{$net1->{leaves}}) {\n    $alignmenthash{$leaf}=$leaf;\n    $weighthash{$leaf}=0;\n  }\n  for (my $i=0;$i<$numnodes1;$i++) {\n    if (defined $nodes2[$alignment[$i]]) {\n      $alignmenthash{$nodes1[$i]}=$nodes2[$alignment[$i]];\n      $weighthash{$nodes1[$i]}=$matrix[$i][$alignment[$i]];\n      $totalw += $matrix[$i][$alignment[$i]];\n    }\n  }\n  return $totalw,\\%alignmenthash,\\%weighthash;\n }\n\n=head2 optimal_alignment_generalized\n\n Title   : optimal_alignment_generalized\n Usage   : my ($weight,%alignment)=$net->optimal_alignment_generalized($net2)\n Function: returns the wieght of an optimal alignment, and the alignment itself,\n           between the topological restriction of the networks $net1 and $net2\n           on the set of common leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment_generalized {\n  my ($net1,$net2,%params)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->optimal_alignment($netr2,%params);\n}\n\nsub weight {\n  my ($net1,$v1,$net2,$v2,$distance)=@_;\n  my $w;\n  if (! defined $distance) {\n    $distance='Manhattan';\n  }\n  if ($distance eq 'Hamming') {\n    $w=$net1->{mudata}->{$v1}->hamming($net2->{mudata}->{$v2});\n  } else {\n    $w=$net1->{mudata}->{$v1}->manhattan($net2->{mudata}->{$v2});\n  }\n  if (($net1->is_tree_node($v1) && $net2->is_hybrid_node($v2)) ||\n      ($net2->is_tree_node($v2) && $net1->is_hybrid_node($v1))\n     )\n    {\n      $w +=1/(2*$net1->{numleaves});\n    }\n  return $w;\n}\n\n\n=head2 topological_restriction\n\n Title   : topological_restriction\n Usage   : my ($netr1,$netr2)=$net1->topological_restriction($net2)\n Function: returns the topological restriction of $net1 and $net2 on its\n           common set of leaves\n Returns : Bio::PhyloNetwork, Bio::PhyloNetwork\n Args    : Bio::PhyloNetwork\n\n\nsub topological_restriction {\n  my ($net1,$net2)=@_;\n\n  my @leaves1=$net1->leaves();\n  my @leaves2=$net2->leaves();\n  my $numleaves1=scalar @leaves1;\n  my $numleaves2=scalar @leaves2;\n  my %position1;\n  for (my $i=0; $i<$numleaves1; $i++) {\n    $position1{$leaves1[$i]}=$i;\n  }\n  my %position2;\n  my @commonleaves=();\n  for (my $j=0; $j<$numleaves2; $j++) {\n    if (defined $position1{$leaves2[$j]}) {\n      push @commonleaves,$leaves2[$j];\n      $position2{$leaves2[$j]}=$j;\n    }\n  }\n  my $graphred1=$net1->{graph}->copy();\n  my $graphred2=$net2->{graph}->copy();\n OUTER1:\n  foreach my $u ($graphred1->vertices()) {\n    my $mu=$net1->mudata_node($u);\n    foreach my $leaf (@commonleaves) {\n      if ($mu->[$position1{$leaf}]>0) {\n\tnext OUTER1;\n      }\n    }\n    $graphred1->delete_vertex($u);\n  }\n OUTER2:\n  foreach my $u ($graphred2->vertices()) {\n    my $mu=$net2->mudata_node($u);\n    foreach my $leaf (@commonleaves) {\n      if ($mu->[$position2{$leaf}]>0) {\n\tnext OUTER2;\n      }\n    }\n    $graphred2->delete_vertex($u);\n  }\n  my $netr1=Bio::PhyloNetwork->new(-graph => $graphred1);\n  my $netr2=Bio::PhyloNetwork->new(-graph => $graphred2);\n  return ($netr1,$netr2);\n}\n\n# Functions for eNewick representation\n\n=head2 eNewick\n\n Title   : eNewick\n Usage   : my $str=$net->eNewick()\n Function: returns the eNewick representation of $net without labeling\n           internal tree nodes\n Returns : string\n Args    : none\n\n\nsub eNewick {\n  my ($self)=@_;\n  my $str=\"\";\n  my $seen={};\n  foreach my $root ($self->roots()) {\n    $str=$str.$self->eNewick_aux($root,$seen,undef).\"; \";\n  }\n  return $str;\n}\n\nsub eNewick_aux {\n  my ($self,$node,$seen,$parent)=@_;\n  my $str='';\n  if ($self->is_leaf($node) ||\n      (defined $seen->{$node}) )\n    {\n      $str=make_label($self,$parent,$node);\n    }\n  else {\n    $seen->{$node}=1;\n    my @sons=$self->{graph}->successors($node);\n    $str=\"(\";\n    foreach my $son (@sons) {\n      $str=$str.$self->eNewick_aux($son,$seen,$node).\",\";\n    }\n    chop($str);\n    $str.=\")\".make_label($self,$parent,$node);\n  }\n  return $str;\n}\n\nsub make_label {\n  my ($self,$parent,$node)=@_;\n  my $str='';\n  if ($self->is_hybrid_node($node)) {\n    my $lbl=$self->{labels}->{$node};\n    if ($lbl =~ /#/) {\n      $lbl='';\n    }\n    $str.=$lbl; #$self->{labels}->{$node};\n    $str.='#';\n    if ((defined $parent) &&\n\t($self->graph->has_edge_attribute($parent,$node,'type'))) {\n      $str.=$self->graph->get_edge_attribute($parent,$node,'type');\n    }\n    $str.=substr $node,1;\n  } else {\n    $str.=$self->{labels}->{$node};\n  }\n  if ((defined $parent) &&\n      ($self->graph->has_edge_weight($parent,$node))) {\n    $str.=\":\".$self->graph->get_edge_weight($parent,$node);\n  }\n  return $str;\n}\n\n=head2 eNewick_full\n\n Title   : eNewick_full\n Usage   : my $str=$net->eNewick_full()\n Function: returns the eNewick representation of $net labeling\n           internal tree nodes\n Returns : string\n Args    : none\n\n\nsub eNewick_full {\n  my ($self)=@_;\n  my $str=\"\";\n  my $seen={};\n  foreach my $root ($self->roots()) {\n    $str=$str.$self->eNewick_full_aux($root,$seen,undef).\"; \";\n  }\n  return $str;\n}\n\nsub eNewick_full_aux {\n  my ($self,$node,$seen,$parent)=@_;\n  my $str='';\n  if ($self->is_leaf($node) ||\n      (defined $seen->{$node}) )\n    {\n      $str=make_label_full($self,$parent,$node);\n    }\n  else {\n    $seen->{$node}=1;\n    my @sons=$self->{graph}->successors($node);\n    $str=\"(\";\n    foreach my $son (@sons) {\n      $str=$str.$self->eNewick_full_aux($son,$seen,$node).\",\";\n    }\n    chop($str);\n    $str.=\")\".make_label_full($self,$parent,$node);\n  }\n  return $str;\n}\n\nsub make_label_full {\n  my ($self,$parent,$node)=@_;\n  my $str='';\n  if ($self->is_hybrid_node($node)) {\n    my $lbl=$self->{labels}->{$node};\n    if ($lbl =~ /#/) {\n      $lbl='';\n    }\n    $str.=$lbl; #$self->{labels}->{$node};\n    $str.='#';\n    if ((defined $parent) &&\n\t($self->graph->has_edge_attribute($parent,$node,'type'))) {\n      $str.=$self->graph->get_edge_attribute($parent,$node,'type');\n    }\n    $str.=substr $node,1;\n  } else {\n    if ((defined $self->{labels}->{$node})&&($self->{labels}->{$node} ne '')) {\n      $str.=$self->{labels}->{$node};\n    }\n    else {\n      $str.=$node;\n    }\n  }\n  if ((defined $parent) &&\n      ($self->graph->has_edge_weight($parent,$node))) {\n    $str.=\":\".$self->graph->get_edge_weight($parent,$node);\n  }\n  return $str;\n}\n\n# sub eNewick_full {\n#   my ($self)=@_;\n#   my $str=\"\";\n#   my $seen={};\n#   foreach my $root ($self->roots()) {\n#     $str=$str.$self->eNewick_full_aux($root,$seen,undef).\"; \";\n#   }\n#   return $str;\n# }\n\n# sub eNewick_full_aux {\n#   my ($self,$node,$seen,$parent)=@_;\n#   my $str;\n#   if ($self->is_leaf($node) ||\n#       (defined $seen->{$node}) )\n#     {\n#       if ($self->is_hybrid_node($node)) {\n# \tmy $tag=substr $node,1;\n# \tif ((defined $parent) &&\n# \t    ($self->graph->has_edge_attribute($parent,$node,'type'))) {\n# \t  $str='#'.$self->graph->get_edge_attribute($parent,$node,'type').$tag;\n# \t} else {\n# \t  $str=$node;\n# \t}\n#       } else {\n# \t$str=$node;\n#       }\n#     }\n#   else {\n#     $seen->{$node}=1;\n#     my @sons=$self->{graph}->successors($node);\n#     $str=\"(\";\n#     foreach my $son (@sons) {\n#       $str=$str.$self->eNewick_full_aux($son,$seen,$node).\",\";\n#     }\n#     chop($str);\n#     if ($self->is_hybrid_node($node)) {\n#       my $tag=substr $node,1;\n#       if ((defined $parent) &&\n# \t  ($self->graph->has_edge_attribute($parent,$node,'type'))) {\n# \t$str.=')#'.$self->graph->get_edge_attribute($parent,$node,'type').$tag;\n#       } else {\n# \t$str.=\")$node\";\n#       }\n#     } else {\n#       $str.=\")$node\";\n#     }\n#   }\n#   if ((defined $parent) &&\n#       ($self->graph->has_edge_weight($parent,$node))) {\n#     $str.=\":\".$self->graph->get_edge_weight($parent,$node);\n#   }\n#   return $str;\n# }\n\n\n# displaying data\n\nuse overload '\"\"' => \\&display;\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$net->display()\n Function: returns a string containing all the available information on $net\n Returns : string\n Args    : none","label":"display($self)"}},{"line":1764,"kind":12,"name":"graph"},{"line":1766,"name":"nodes","kind":12},{"name":"$str","containerName":null,"kind":13,"line":1767},{"line":1768,"kind":13,"containerName":null,"name":"$str"},{"line":1769,"kind":13,"containerName":null,"name":"$str"},{"name":"$str","kind":13,"containerName":null,"line":1770},{"line":1770,"name":"$self","kind":13,"containerName":null},{"name":"eNewick","kind":12,"containerName":"main::","line":1770},{"kind":13,"containerName":null,"name":"$str","line":1771},{"line":1771,"name":"$self","containerName":null,"kind":13},{"name":"eNewick_full","kind":12,"containerName":"main::","line":1771},{"containerName":null,"kind":13,"name":"$str","line":1772},{"name":"$node","localvar":"my","kind":13,"containerName":null,"line":1773,"definition":"my"},{"containerName":null,"kind":13,"name":"@nodes","line":1773},{"name":"$str","kind":13,"containerName":null,"line":1774},{"line":1775,"containerName":null,"kind":13,"name":"%self"},{"name":"labels","kind":12,"line":1775},{"name":"%node","kind":13,"containerName":null,"line":1775},{"line":1776,"name":"$str","kind":13,"containerName":null},{"line":1776,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"name":"labels","line":1776},{"line":1776,"name":"%node","kind":13,"containerName":null},{"line":1778,"name":"$str","containerName":null,"kind":13},{"name":"$str","containerName":null,"kind":13,"line":1780},{"line":1780,"name":"%self","kind":13,"containerName":null},{"line":1780,"name":"$node","containerName":null,"kind":13},{"line":1780,"name":"%self","kind":13,"containerName":null},{"name":"mudata","kind":12,"line":1780},{"name":"$node","kind":13,"containerName":null,"line":1780},{"name":"%self","containerName":null,"kind":13,"line":1782},{"line":1782,"name":"has_temporal_representation","kind":12},{"name":"$str","kind":13,"containerName":null,"line":1783},{"name":"%self","kind":13,"containerName":null,"line":1784},{"name":"has_temporal_representation","kind":12,"line":1784},{"definition":"my","name":"$node","localvar":"my","kind":13,"containerName":null,"line":1785},{"name":"@nodes","kind":13,"containerName":null,"line":1785},{"name":"$str","kind":13,"containerName":null,"line":1786},{"line":1787,"kind":13,"containerName":null,"name":"$str"},{"line":1787,"name":"%self","kind":13,"containerName":null},{"line":1787,"kind":12,"name":"temporal_representation"},{"line":1787,"name":"%node","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$str","line":1790},{"line":1793,"name":"%self","containerName":null,"kind":13},{"name":"tripartitions","kind":12,"line":1793},{"line":1794,"name":"$str","kind":13,"containerName":null},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$node","line":1795},{"kind":13,"containerName":null,"name":"@nodes","line":1795},{"line":1796,"containerName":null,"kind":13,"name":"$str"},{"containerName":null,"kind":13,"name":"$str","line":1797},{"name":"%self","containerName":null,"kind":13,"line":1797},{"kind":12,"name":"tripartitions","line":1797},{"line":1797,"containerName":null,"kind":13,"name":"$node"},{"name":"$str","containerName":null,"kind":13,"line":1800}]}